#ifndef __SPM_COREFIDEBUGVISITOR_H__
#define __SPM_COREFIDEBUGVISITOR_H__

class MY_DECL spm_corefi_tclPrintVisitor : public spm_corefi_tclVisitorBase {

private:
   /* default constructor */ spm_corefi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   spm_corefi_tclPrintVisitor(spm_fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(spm_fi_tclU8& oU8);
   virtual tVoid vVisitS8(spm_fi_tclS8& oS8);
   virtual tVoid vVisitU16(spm_fi_tclU16& oU16);
   virtual tVoid vVisitS16(spm_fi_tclS16& oS16);
   virtual tVoid vVisitU24(spm_fi_tclU24& oU24);
   virtual tVoid vVisitS24(spm_fi_tclS24& oS24);
   virtual tVoid vVisitU32(spm_fi_tclU32& oU32);
   virtual tVoid vVisitS32(spm_fi_tclS32& oS32);
   virtual tVoid vVisitU64(spm_fi_tclU64& oU64);
   virtual tVoid vVisitS64(spm_fi_tclS64& oS64);
   virtual tVoid vVisitBool(spm_fi_tclBool& oBool);
   virtual tVoid vVisitString(spm_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(spm_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(spm_fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(spm_corefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpandTimeDate(spm_corefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpandSwVersionInfo(spm_corefi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b32_SubState0(spm_fi_tcl_b32_SubState0& o_b32_SubState0);
   virtual tVoid vVisit_b32_SubState1(spm_fi_tcl_b32_SubState1& o_b32_SubState1);
   virtual tVoid vVisit_b32_SubState2(spm_fi_tcl_b32_SubState2& o_b32_SubState2);
   virtual tVoid vVisit_b32_SubState3(spm_fi_tcl_b32_SubState3& o_b32_SubState3);
   virtual tVoid vVisit_SPM_e32_SubStateType(spm_fi_tcl_SPM_e32_SubStateType& o_SPM_e32_SubStateType);
   virtual tVoid vVisit_SPM_e32_OnOffReason(spm_fi_tcl_SPM_e32_OnOffReason& o_SPM_e32_OnOffReason);
   virtual tVoid vVisit_SPM_e32_SYSTEM_STATES(spm_fi_tcl_SPM_e32_SYSTEM_STATES& o_SPM_e32_SYSTEM_STATES);
   virtual tVoid vVisit_SPM_e32_SYSPWR_BEHAVIOUR(spm_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR& o_SPM_e32_SYSPWR_BEHAVIOUR);
   virtual tVoid vVisit_SPM_e32_HMI_STATE(spm_fi_tcl_SPM_e32_HMI_STATE& o_SPM_e32_HMI_STATE);
   virtual tVoid vVisit_SPM_e32_DIM_STATE(spm_fi_tcl_SPM_e32_DIM_STATE& o_SPM_e32_DIM_STATE);
   virtual tVoid vVisit_SPM_b32_DIM_STATE(spm_fi_tcl_SPM_b32_DIM_STATE& o_SPM_b32_DIM_STATE);
   virtual tVoid vVisit_SPM_e32_BT_STATE(spm_fi_tcl_SPM_e32_BT_STATE& o_SPM_e32_BT_STATE);
   virtual tVoid vVisit_SPM_e32_WIFI_STATE(spm_fi_tcl_SPM_e32_WIFI_STATE& o_SPM_e32_WIFI_STATE);
   virtual tVoid vVisit_SPM_e32_AUDIO_STATE(spm_fi_tcl_SPM_e32_AUDIO_STATE& o_SPM_e32_AUDIO_STATE);
   virtual tVoid vVisit_SPM_e32_SPI_STATE(spm_fi_tcl_SPM_e32_SPI_STATE& o_SPM_e32_SPI_STATE);
   virtual tVoid vVisit_SPM_e32_TUNER_STATE(spm_fi_tcl_SPM_e32_TUNER_STATE& o_SPM_e32_TUNER_STATE);
   virtual tVoid vVisit_SPM_e32_AUDIO_SOURCE(spm_fi_tcl_SPM_e32_AUDIO_SOURCE& o_SPM_e32_AUDIO_SOURCE);
   virtual tVoid vVisit_SPM_e32_CD_INSERT_STATE(spm_fi_tcl_SPM_e32_CD_INSERT_STATE& o_SPM_e32_CD_INSERT_STATE);
   virtual tVoid vVisit_SPM_e32_SYS_STATE(spm_fi_tcl_SPM_e32_SYS_STATE& o_SPM_e32_SYS_STATE);
   virtual tVoid vVisit_SPM_e32_MOST_EVENT(spm_fi_tcl_SPM_e32_MOST_EVENT& o_SPM_e32_MOST_EVENT);
   virtual tVoid vVisit_SPM_e32_MOST_CONFIG_STATE(spm_fi_tcl_SPM_e32_MOST_CONFIG_STATE& o_SPM_e32_MOST_CONFIG_STATE);
   virtual tVoid vVisit_SPM_e32_TLA_STATE(spm_fi_tcl_SPM_e32_TLA_STATE& o_SPM_e32_TLA_STATE);
   virtual tVoid vVisit_SPM_e32_PROCESSOR_STATE(spm_fi_tcl_SPM_e32_PROCESSOR_STATE& o_SPM_e32_PROCESSOR_STATE);
   virtual tVoid vVisit_SPM_e32_STARTUP_STATE(spm_fi_tcl_SPM_e32_STARTUP_STATE& o_SPM_e32_STARTUP_STATE);
   virtual tBool bDoExpand_SPM_HistoryTrigger(spm_corefi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_SPM_e32_RESTART_TYPE(spm_fi_tcl_SPM_e32_RESTART_TYPE& o_SPM_e32_RESTART_TYPE);
   virtual tVoid vVisit_SPM_e32_CODE_REQUEST(spm_fi_tcl_SPM_e32_CODE_REQUEST& o_SPM_e32_CODE_REQUEST);
   virtual tVoid vVisit_SPM_e32_WAKEUP_REASON(spm_fi_tcl_SPM_e32_WAKEUP_REASON& o_SPM_e32_WAKEUP_REASON);
   virtual tVoid vVisit_SPM_e32_MEDIA_EJECT_STATE(spm_fi_tcl_SPM_e32_MEDIA_EJECT_STATE& o_SPM_e32_MEDIA_EJECT_STATE);
   virtual tVoid vVisit_SPM_e32_KEY_STATE(spm_fi_tcl_SPM_e32_KEY_STATE& o_SPM_e32_KEY_STATE);
   virtual tVoid vVisit_SPM_e32_SECURITY_STATE(spm_fi_tcl_SPM_e32_SECURITY_STATE& o_SPM_e32_SECURITY_STATE);
   virtual tVoid vVisit_SPM_e32_STARTUP_REASON(spm_fi_tcl_SPM_e32_STARTUP_REASON& o_SPM_e32_STARTUP_REASON);
   virtual tVoid vVisit_SPM_e32_PHONE_MUTE_STATE(spm_fi_tcl_SPM_e32_PHONE_MUTE_STATE& o_SPM_e32_PHONE_MUTE_STATE);
   virtual tVoid vVisit_e8_LcmResetReason(spm_fi_tcl_e8_LcmResetReason& o_e8_LcmResetReason);
   virtual tVoid vVisit_SPM_e32_CVM_EVENT(spm_fi_tcl_SPM_e32_CVM_EVENT& o_SPM_e32_CVM_EVENT);
   virtual tVoid vVisit_SPM_e32_SYSPWRMODE(spm_fi_tcl_SPM_e32_SYSPWRMODE& o_SPM_e32_SYSPWRMODE);
   virtual tVoid vVisit_SPM_e8_WAKEUP_LIST_REASON(spm_fi_tcl_SPM_e8_WAKEUP_LIST_REASON& o_SPM_e8_WAKEUP_LIST_REASON);
   virtual tBool bDoExpand_SPM_TransPortMode(spm_corefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SPM_TransPortModeList(spm_corefi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_StateModes(spm_fi_tcl_e8_StateModes& o_e8_StateModes);
   virtual tVoid vVisit_e8_StateEntryType(spm_fi_tcl_e8_StateEntryType& o_e8_StateEntryType);
   virtual tBool bDoExpand_SubStateEntry(spm_corefi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DownloadLockStates(spm_fi_tcl_e8_DownloadLockStates& o_e8_DownloadLockStates);
   virtual tVoid vVisit_e8_ProcessState(spm_fi_tcl_e8_ProcessState& o_e8_ProcessState);
   virtual tBool bDoExpand_ProcessElement(spm_corefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SPM_ProcessInfo(spm_corefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SPM_Vin(spm_corefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SPM_VinHistory(spm_corefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ResetElement(spm_corefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_WakeupElement(spm_corefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StateChangeElement(spm_corefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SwitchOnElement(spm_corefi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_SPM_e32_START_PROC_TYPE(spm_fi_tcl_SPM_e32_START_PROC_TYPE& o_SPM_e32_START_PROC_TYPE);
   virtual tVoid vVisit_SPM_e32_MRESULT(spm_fi_tcl_SPM_e32_MRESULT& o_SPM_e32_MRESULT);
   virtual tVoid vVisit_SPM_e32_RUNLEVEL(spm_fi_tcl_SPM_e32_RUNLEVEL& o_SPM_e32_RUNLEVEL);
   virtual tVoid vVisit_SPM_b32_SYSPWRSAVEMODE(spm_fi_tcl_SPM_b32_SYSPWRSAVEMODE& o_SPM_b32_SYSPWRSAVEMODE);
   virtual tBool bDoExpand_SPM_PartnumberItem(spm_corefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SPM_PartnumberList(spm_corefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SPM_AlphacodeItem(spm_corefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SPM_AlphacodeList(spm_corefi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_SPM_e32_REDUCTION_LEVEL(spm_fi_tcl_SPM_e32_REDUCTION_LEVEL& o_SPM_e32_REDUCTION_LEVEL);
   virtual tVoid vVisit_SPM_e32_CLEAR_LIST(spm_fi_tcl_SPM_e32_CLEAR_LIST& o_SPM_e32_CLEAR_LIST);
   virtual tBool bDoExpand_SPM_AppIdList(spm_corefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SPM_RestrictedDlLock(spm_corefi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_UpdateLockCommand(spm_fi_tcl_e8_UpdateLockCommand& o_e8_UpdateLockCommand);
   virtual tVoid vVisit_e8_UpdateLockState(spm_fi_tcl_e8_UpdateLockState& o_e8_UpdateLockState);
   virtual tBool bDoExpand_SPM_UpdateLockState(spm_corefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SPM_VoltageEventCounter(spm_corefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SPM_VoltageRange(spm_corefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SPM_SystemStatisticsData(spm_corefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SPM_ResetInfoStatisticData(spm_corefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SPM_SWVersionStatisticData(spm_corefi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DefSetMode(spm_fi_tcl_e8_DefSetMode& o_e8_DefSetMode);
   virtual tVoid vVisit_e8_DiaglogDefsetType(spm_fi_tcl_e8_DiaglogDefsetType& o_e8_DiaglogDefsetType);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   spm_fi_tclOutput* poOutput;
};


class MY_DECL spm_corefi_tclRandomInitVisitor : public spm_corefi_tclVisitorBase {
public:

   spm_corefi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(spm_fi_tclU8& oU8);
   virtual tVoid vVisitS8(spm_fi_tclS8& oS8);
   virtual tVoid vVisitU16(spm_fi_tclU16& oU16);
   virtual tVoid vVisitS16(spm_fi_tclS16& oS16);
   virtual tVoid vVisitU24(spm_fi_tclU24& oU24);
   virtual tVoid vVisitS24(spm_fi_tclS24& oS24);
   virtual tVoid vVisitU32(spm_fi_tclU32& oU32);
   virtual tVoid vVisitS32(spm_fi_tclS32& oS32);
   virtual tVoid vVisitU64(spm_fi_tclU64& oU64);
   virtual tVoid vVisitS64(spm_fi_tclS64& oS64);
   virtual tVoid vVisitBool(spm_fi_tclBool& oBool);
   virtual tVoid vVisitString(spm_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(spm_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(spm_fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_b32_SubState0(spm_fi_tcl_b32_SubState0& o_b32_SubState0);
   virtual tVoid vVisit_b32_SubState1(spm_fi_tcl_b32_SubState1& o_b32_SubState1);
   virtual tVoid vVisit_b32_SubState2(spm_fi_tcl_b32_SubState2& o_b32_SubState2);
   virtual tVoid vVisit_b32_SubState3(spm_fi_tcl_b32_SubState3& o_b32_SubState3);
   virtual tVoid vVisit_SPM_e32_SubStateType(spm_fi_tcl_SPM_e32_SubStateType& o_SPM_e32_SubStateType);
   virtual tVoid vVisit_SPM_e32_OnOffReason(spm_fi_tcl_SPM_e32_OnOffReason& o_SPM_e32_OnOffReason);
   virtual tVoid vVisit_SPM_e32_SYSTEM_STATES(spm_fi_tcl_SPM_e32_SYSTEM_STATES& o_SPM_e32_SYSTEM_STATES);
   virtual tVoid vVisit_SPM_e32_SYSPWR_BEHAVIOUR(spm_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR& o_SPM_e32_SYSPWR_BEHAVIOUR);
   virtual tVoid vVisit_SPM_e32_HMI_STATE(spm_fi_tcl_SPM_e32_HMI_STATE& o_SPM_e32_HMI_STATE);
   virtual tVoid vVisit_SPM_e32_DIM_STATE(spm_fi_tcl_SPM_e32_DIM_STATE& o_SPM_e32_DIM_STATE);
   virtual tVoid vVisit_SPM_b32_DIM_STATE(spm_fi_tcl_SPM_b32_DIM_STATE& o_SPM_b32_DIM_STATE);
   virtual tVoid vVisit_SPM_e32_BT_STATE(spm_fi_tcl_SPM_e32_BT_STATE& o_SPM_e32_BT_STATE);
   virtual tVoid vVisit_SPM_e32_WIFI_STATE(spm_fi_tcl_SPM_e32_WIFI_STATE& o_SPM_e32_WIFI_STATE);
   virtual tVoid vVisit_SPM_e32_AUDIO_STATE(spm_fi_tcl_SPM_e32_AUDIO_STATE& o_SPM_e32_AUDIO_STATE);
   virtual tVoid vVisit_SPM_e32_SPI_STATE(spm_fi_tcl_SPM_e32_SPI_STATE& o_SPM_e32_SPI_STATE);
   virtual tVoid vVisit_SPM_e32_TUNER_STATE(spm_fi_tcl_SPM_e32_TUNER_STATE& o_SPM_e32_TUNER_STATE);
   virtual tVoid vVisit_SPM_e32_AUDIO_SOURCE(spm_fi_tcl_SPM_e32_AUDIO_SOURCE& o_SPM_e32_AUDIO_SOURCE);
   virtual tVoid vVisit_SPM_e32_CD_INSERT_STATE(spm_fi_tcl_SPM_e32_CD_INSERT_STATE& o_SPM_e32_CD_INSERT_STATE);
   virtual tVoid vVisit_SPM_e32_SYS_STATE(spm_fi_tcl_SPM_e32_SYS_STATE& o_SPM_e32_SYS_STATE);
   virtual tVoid vVisit_SPM_e32_MOST_EVENT(spm_fi_tcl_SPM_e32_MOST_EVENT& o_SPM_e32_MOST_EVENT);
   virtual tVoid vVisit_SPM_e32_MOST_CONFIG_STATE(spm_fi_tcl_SPM_e32_MOST_CONFIG_STATE& o_SPM_e32_MOST_CONFIG_STATE);
   virtual tVoid vVisit_SPM_e32_TLA_STATE(spm_fi_tcl_SPM_e32_TLA_STATE& o_SPM_e32_TLA_STATE);
   virtual tVoid vVisit_SPM_e32_PROCESSOR_STATE(spm_fi_tcl_SPM_e32_PROCESSOR_STATE& o_SPM_e32_PROCESSOR_STATE);
   virtual tVoid vVisit_SPM_e32_STARTUP_STATE(spm_fi_tcl_SPM_e32_STARTUP_STATE& o_SPM_e32_STARTUP_STATE);
   virtual tVoid vVisit_SPM_e32_RESTART_TYPE(spm_fi_tcl_SPM_e32_RESTART_TYPE& o_SPM_e32_RESTART_TYPE);
   virtual tVoid vVisit_SPM_e32_CODE_REQUEST(spm_fi_tcl_SPM_e32_CODE_REQUEST& o_SPM_e32_CODE_REQUEST);
   virtual tVoid vVisit_SPM_e32_WAKEUP_REASON(spm_fi_tcl_SPM_e32_WAKEUP_REASON& o_SPM_e32_WAKEUP_REASON);
   virtual tVoid vVisit_SPM_e32_MEDIA_EJECT_STATE(spm_fi_tcl_SPM_e32_MEDIA_EJECT_STATE& o_SPM_e32_MEDIA_EJECT_STATE);
   virtual tVoid vVisit_SPM_e32_KEY_STATE(spm_fi_tcl_SPM_e32_KEY_STATE& o_SPM_e32_KEY_STATE);
   virtual tVoid vVisit_SPM_e32_SECURITY_STATE(spm_fi_tcl_SPM_e32_SECURITY_STATE& o_SPM_e32_SECURITY_STATE);
   virtual tVoid vVisit_SPM_e32_STARTUP_REASON(spm_fi_tcl_SPM_e32_STARTUP_REASON& o_SPM_e32_STARTUP_REASON);
   virtual tVoid vVisit_SPM_e32_PHONE_MUTE_STATE(spm_fi_tcl_SPM_e32_PHONE_MUTE_STATE& o_SPM_e32_PHONE_MUTE_STATE);
   virtual tVoid vVisit_e8_LcmResetReason(spm_fi_tcl_e8_LcmResetReason& o_e8_LcmResetReason);
   virtual tVoid vVisit_SPM_e32_CVM_EVENT(spm_fi_tcl_SPM_e32_CVM_EVENT& o_SPM_e32_CVM_EVENT);
   virtual tVoid vVisit_SPM_e32_SYSPWRMODE(spm_fi_tcl_SPM_e32_SYSPWRMODE& o_SPM_e32_SYSPWRMODE);
   virtual tVoid vVisit_SPM_e8_WAKEUP_LIST_REASON(spm_fi_tcl_SPM_e8_WAKEUP_LIST_REASON& o_SPM_e8_WAKEUP_LIST_REASON);
   virtual tVoid vVisit_e8_StateModes(spm_fi_tcl_e8_StateModes& o_e8_StateModes);
   virtual tVoid vVisit_e8_StateEntryType(spm_fi_tcl_e8_StateEntryType& o_e8_StateEntryType);
   virtual tVoid vVisit_e8_DownloadLockStates(spm_fi_tcl_e8_DownloadLockStates& o_e8_DownloadLockStates);
   virtual tVoid vVisit_e8_ProcessState(spm_fi_tcl_e8_ProcessState& o_e8_ProcessState);
   virtual tVoid vVisit_SPM_e32_START_PROC_TYPE(spm_fi_tcl_SPM_e32_START_PROC_TYPE& o_SPM_e32_START_PROC_TYPE);
   virtual tVoid vVisit_SPM_e32_MRESULT(spm_fi_tcl_SPM_e32_MRESULT& o_SPM_e32_MRESULT);
   virtual tVoid vVisit_SPM_e32_RUNLEVEL(spm_fi_tcl_SPM_e32_RUNLEVEL& o_SPM_e32_RUNLEVEL);
   virtual tVoid vVisit_SPM_b32_SYSPWRSAVEMODE(spm_fi_tcl_SPM_b32_SYSPWRSAVEMODE& o_SPM_b32_SYSPWRSAVEMODE);
   virtual tVoid vVisit_SPM_e32_REDUCTION_LEVEL(spm_fi_tcl_SPM_e32_REDUCTION_LEVEL& o_SPM_e32_REDUCTION_LEVEL);
   virtual tVoid vVisit_SPM_e32_CLEAR_LIST(spm_fi_tcl_SPM_e32_CLEAR_LIST& o_SPM_e32_CLEAR_LIST);
   virtual tVoid vVisit_e8_UpdateLockCommand(spm_fi_tcl_e8_UpdateLockCommand& o_e8_UpdateLockCommand);
   virtual tVoid vVisit_e8_UpdateLockState(spm_fi_tcl_e8_UpdateLockState& o_e8_UpdateLockState);
   virtual tVoid vVisit_e8_DefSetMode(spm_fi_tcl_e8_DefSetMode& o_e8_DefSetMode);
   virtual tVoid vVisit_e8_DiaglogDefsetType(spm_fi_tcl_e8_DiaglogDefsetType& o_e8_DiaglogDefsetType);
	tU32 u32ListSize;
};

#endif
