#ifndef SPEAUD_FIVISITOR_HEADER
#define SPEAUD_FIVISITOR_HEADER

// --Basisklasse fuer eine FI-Besucher-Klasse

class speaud_fi_tclOutput {
public:
   speaud_fi_tclOutput();
   virtual ~speaud_fi_tclOutput(){};

   virtual tVoid vPrintLine(tCString coszLine) = 0;
};

class speaud_fi_tclFileOutput : public speaud_fi_tclOutput 
{
public:
   speaud_fi_tclFileOutput(OSAL_tIODescriptor rIOD):fd(rIOD) {}
   virtual tVoid vPrintLine(tCString coszLine);
protected:
   OSAL_tIODescriptor fd;
private:
   speaud_fi_tclFileOutput(); //lint !e1704
   speaud_fi_tclFileOutput& operator=(const speaud_fi_tclFileOutput& coRef);
   speaud_fi_tclFileOutput(const speaud_fi_tclFileOutput& coRef); //lint !e1704
};

class speaud_fi_tclMemOutput : public speaud_fi_tclOutput
{
public:
   speaud_fi_tclMemOutput(tU32 u32MemSize);
   virtual ~speaud_fi_tclMemOutput();
   virtual tVoid vPrintLine(tCString coszLine);
   tString szGetBuffer();
protected:
   tChar* szBuf;
   tChar* szEndBuf;
   tChar* s8BufPos;
private:
   speaud_fi_tclMemOutput(); //lint !e1704
   speaud_fi_tclMemOutput(const speaud_fi_tclMemOutput& coRef); //lint !e1704
   speaud_fi_tclMemOutput& operator=(const speaud_fi_tclMemOutput& coRef); //lint !e1704
};

class MY_DECL speaud_fi_tclVisitorBase {
public:

   // --Konstruktor
   speaud_fi_tclVisitorBase():bBreakNow(FALSE),bIsVisitorValid(FALSE) {}
   virtual ~speaud_fi_tclVisitorBase() {}

   tBool bIsValid() const { return bIsVisitorValid; }
   tVoid vInvalidate() { bIsVisitorValid=FALSE; }
   tVoid vValidate() { bIsVisitorValid=TRUE; }
   tBool bBreak() const { return bBreakNow; }
   tVoid vReleaseBreak() { bBreakNow = FALSE; }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(speaud_fi_tclU8& oU8);
   virtual tVoid vVisitS8(speaud_fi_tclS8& oS8);
   virtual tVoid vVisitU16(speaud_fi_tclU16& oU16);
   virtual tVoid vVisitS16(speaud_fi_tclS16& oS16);
   virtual tVoid vVisitU24(speaud_fi_tclU24& oU24);
   virtual tVoid vVisitS24(speaud_fi_tclS24& oS24);
   virtual tVoid vVisitU32(speaud_fi_tclU32& oU32);
   virtual tVoid vVisitS32(speaud_fi_tclS32& oS32);
   virtual tVoid vVisitU64(speaud_fi_tclU64& oU64);
   virtual tVoid vVisitS64(speaud_fi_tclS64& oS64);
   virtual tVoid vVisitF32(speaud_fi_tclF32& oF32);
   virtual tVoid vVisitF64(speaud_fi_tclF64& oF64);
   virtual tVoid vVisitBool(speaud_fi_tclBool& oBool);
   virtual tVoid vVisitString(speaud_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(speaud_fi_tclMultiLanguageString& oString);

   virtual tVoid vVisitList(speaud_fi_tclList& oList);
   virtual tVoid vVisit_BinContainer(speaud_fi_tcl_BinContainer& oBinContainer);

   virtual tVoid vVisit_Reserved(speaud_fi_tcl_Reserved& oReserved);

   virtual tVoid vVisit_u8_Percent(speaud_fi_tcl_u8_Percent& ou8_Percent);

   virtual tVoid vVisit_s16_PerThousand(speaud_fi_tcl_s16_PerThousand& os16_PerThousand);

   virtual tVoid vVisit_u16_IndexInReferenceList(speaud_fi_tcl_u16_IndexInReferenceList& ou16_IndexInReferenceList);

   virtual tVoid vVisit_u16_ErrorCode(speaud_fi_tcl_u16_ErrorCode& ou16_ErrorCode);

   virtual tVoid vVisit_u16_RPM(speaud_fi_tcl_u16_RPM& ou16_RPM);

   virtual tVoid vVisit_s32_Kilogram(speaud_fi_tcl_s32_Kilogram& os32_Kilogram);

   virtual tVoid vVisit_s32_Pound(speaud_fi_tcl_s32_Pound& os32_Pound);

   virtual tVoid vVisit_s16_Meter(speaud_fi_tcl_s16_Meter& os16_Meter);

   virtual tVoid vVisit_s32_Meter(speaud_fi_tcl_s32_Meter& os32_Meter);

   virtual tVoid vVisit_s32_Yards(speaud_fi_tcl_s32_Yards& os32_Yards);

   virtual tVoid vVisit_s32_Foot(speaud_fi_tcl_s32_Foot& os32_Foot);

   virtual tVoid vVisit_s32_Centimeter(speaud_fi_tcl_s32_Centimeter& os32_Centimeter);

   virtual tVoid vVisit_s32_Inch(speaud_fi_tcl_s32_Inch& os32_Inch);

   virtual tVoid vVisit_s32_Millimeter(speaud_fi_tcl_s32_Millimeter& os32_Millimeter);

   virtual tVoid vVisit_s32_Microliter(speaud_fi_tcl_s32_Microliter& os32_Microliter);

   virtual tVoid vVisit_s32_Second(speaud_fi_tcl_s32_Second& os32_Second);

   virtual tVoid vVisit_u16_MilliSecond(speaud_fi_tcl_u16_MilliSecond& ou16_MilliSecond);

   virtual tVoid vVisit_s32_MilliSecond(speaud_fi_tcl_s32_MilliSecond& os32_MilliSecond);

   virtual tVoid vVisit_POSIXTime(speaud_fi_tcl_POSIXTime& oPOSIXTime);

   virtual tVoid vVisit_e8_DST_State(speaud_fi_tcl_e8_DST_State& oe8_DST_State);

   virtual tVoid vVisit_TimeZoneElement(speaud_fi_tcl_TimeZoneElement& oTimeZoneElement);

   virtual tVoid vVisit_s16_KmPerHour(speaud_fi_tcl_s16_KmPerHour& os16_KmPerHour);

   virtual tVoid vVisit_s16_MilesPerHour(speaud_fi_tcl_s16_MilesPerHour& os16_MilesPerHour);

   virtual tVoid vVisit_s16_Knot(speaud_fi_tcl_s16_Knot& os16_Knot);

   virtual tVoid vVisit_s16_CentimeterSecond(speaud_fi_tcl_s16_CentimeterSecond& os16_CentimeterSecond);

   virtual tVoid vVisit_s16_Kelvin(speaud_fi_tcl_s16_Kelvin& os16_Kelvin);

   virtual tVoid vVisit_s16_Fahrenheit(speaud_fi_tcl_s16_Fahrenheit& os16_Fahrenheit);

   virtual tVoid vVisit_s32_Pascal(speaud_fi_tcl_s32_Pascal& os32_Pascal);

   virtual tVoid vVisit_s32_Watt(speaud_fi_tcl_s32_Watt& os32_Watt);

   virtual tVoid vVisit_FIVersion(speaud_fi_tcl_FIVersion& oFIVersion);

   virtual tVoid vVisit_s32_Longitude(speaud_fi_tcl_s32_Longitude& os32_Longitude);

   virtual tVoid vVisit_s32_Latitude(speaud_fi_tcl_s32_Latitude& os32_Latitude);

   virtual tVoid vVisit_PositionWGS84(speaud_fi_tcl_PositionWGS84& oPositionWGS84);

   virtual tVoid vVisit_RectangleWGS84(speaud_fi_tcl_RectangleWGS84& oRectangleWGS84);

   virtual tVoid vVisit_e16_ISOCountryCode(speaud_fi_tcl_e16_ISOCountryCode& oe16_ISOCountryCode);

   virtual tVoid vVisit_e16_ISOLanguageCode(speaud_fi_tcl_e16_ISOLanguageCode& oe16_ISOLanguageCode);

   virtual tVoid vVisit_LanguageID(speaud_fi_tcl_LanguageID& oLanguageID);

   virtual tVoid vVisit_u8_DirectionAbsolute(speaud_fi_tcl_u8_DirectionAbsolute& ou8_DirectionAbsolute);

   virtual tVoid vVisit_u8_DirectionRelative(speaud_fi_tcl_u8_DirectionRelative& ou8_DirectionRelative);

   virtual tVoid vVisit_s16_CentiDegree(speaud_fi_tcl_s16_CentiDegree& os16_CentiDegree);

   virtual tVoid vVisit_s16_Degree(speaud_fi_tcl_s16_Degree& os16_Degree);

   virtual tVoid vVisit_u16_DirectionAbsolute_CentiDegree(speaud_fi_tcl_u16_DirectionAbsolute_CentiDegree& ou16_DirectionAbsolute_CentiDegree);

   virtual tVoid vVisit_s16_DirectionRelative_CentiDegree(speaud_fi_tcl_s16_DirectionRelative_CentiDegree& os16_DirectionRelative_CentiDegree);

   virtual tVoid vVisit_e8_FuelType(speaud_fi_tcl_e8_FuelType& oe8_FuelType);

   virtual tVoid vVisit_DistTimeFuel(speaud_fi_tcl_DistTimeFuel& oDistTimeFuel);

   virtual tVoid vVisit_e8_SPEAUD_TEST(speaud_fi_tcl_e8_SPEAUD_TEST& oe8_SPEAUD_TEST);


 	fi_tclTraversePath<fi_tclKnot>::tclIterator oIterator;		
	
protected:
	tBool bBreakNow;
	tBool bIsVisitorValid;
private:

};

#endif
