#ifndef SPEAUD_MAINFILANGUAGE_HEADER
#define SPEAUD_MAINFILANGUAGE_HEADER

class speaud_mainfi_tclInContext;
class speaud_mainfi_tclOutContext;
class speaud_mainfi_tclVisitorBase;

class MY_DECL speaud_mainfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  speaud_mainfi_tclDescription(fi_tclInContext* poIn, speaud_mainfi_tclVisitorBase* poVisit);
  speaud_mainfi_tclDescription(fi_tclOutContext* poOut, speaud_mainfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(speaud_mainfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(speaud_fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ speaud_mainfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  speaud_mainfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<speaud_mainfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<speaud_mainfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline speaud_mainfi_tclDescription::speaud_mainfi_tclDescription(fi_tclInContext* poIn, speaud_mainfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline speaud_mainfi_tclDescription::speaud_mainfi_tclDescription(fi_tclOutContext* poOut, speaud_mainfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

