#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define SPEAUD_FI_S_IMPORT_INTERFACE_SPEAUD_MAINFI_STDVISITORS
#include "speaud_fi_if.h"

tBool speaud_mainfi_tclDescription::bInitMessage(speaud_mainfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case speaud_mainfi_tclToken::EN_LAST_TOKEN:
   case speaud_mainfi_tclToken::EN_LIST:
   case speaud_mainfi_tclToken::EN_END_OF_STRUCT:
   case speaud_mainfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case speaud_mainfi_tclToken::EN_MSG_INTERNMSGSTATUS:
   {
      bResult = oPath.bGoDown(speaud_mainfi_tclKnot(speaud_mainfi_tclToken::EN_E8_SPEAUD_TEST,speaud_mainfi_tclSemanticDomain::EN_MSG_ETEST)) && bResult;
   } break;
   case speaud_mainfi_tclToken::EN_MSG_INTERNMSGUPREG:
   case speaud_mainfi_tclToken::EN_MSG_INTERNMSGRELUPREG:
   case speaud_mainfi_tclToken::EN_BINCONTAINER:
   case speaud_mainfi_tclToken::EN_E8_SPEAUD_TEST:
   case speaud_mainfi_tclToken::EN_U8:   
   case speaud_mainfi_tclToken::EN_S8:   
   case speaud_mainfi_tclToken::EN_U16:   
   case speaud_mainfi_tclToken::EN_S16:   
   case speaud_mainfi_tclToken::EN_U24:   
   case speaud_mainfi_tclToken::EN_S24:   
   case speaud_mainfi_tclToken::EN_U32:   
   case speaud_mainfi_tclToken::EN_S32:   
   case speaud_mainfi_tclToken::EN_U64:   
   case speaud_mainfi_tclToken::EN_S64:   
   case speaud_mainfi_tclToken::EN_F32:   
   case speaud_mainfi_tclToken::EN_F64:   
   case speaud_mainfi_tclToken::EN_BOOL:   
   case speaud_mainfi_tclToken::EN_STRING:   
   case speaud_mainfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(speaud_mainfi_tclKnot(enMsgToken,speaud_mainfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool speaud_mainfi_tclDescription::bDoIt(speaud_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool speaud_mainfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      speaud_mainfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      speaud_mainfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      speaud_mainfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == speaud_mainfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(speaud_mainfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(speaud_mainfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(speaud_mainfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case speaud_mainfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == speaud_mainfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case speaud_mainfi_tclToken::EN_LIST: 
      {
         speaud_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            speaud_mainfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(speaud_mainfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            speaud_mainfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(speaud_mainfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case speaud_mainfi_tclToken::EN_U8: 
      {
         speaud_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case speaud_mainfi_tclToken::EN_U16: 
      {
         speaud_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case speaud_mainfi_tclToken::EN_U24: 
      {
         speaud_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case speaud_mainfi_tclToken::EN_U32: 
      {
         speaud_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case speaud_mainfi_tclToken::EN_U64: 
      {
         speaud_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case speaud_mainfi_tclToken::EN_S8: 
      {
         speaud_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case speaud_mainfi_tclToken::EN_S16: 
      {
         speaud_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case speaud_mainfi_tclToken::EN_S24: 
      {
         speaud_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case speaud_mainfi_tclToken::EN_S32: 
      {
         speaud_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case speaud_mainfi_tclToken::EN_S64: 
      {
         speaud_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case speaud_mainfi_tclToken::EN_F32: 
      {
         speaud_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case speaud_mainfi_tclToken::EN_F64: 
      {
         speaud_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case speaud_mainfi_tclToken::EN_BOOL: 
      {
         speaud_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case speaud_mainfi_tclToken::EN_STRING: 
      {
         speaud_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case speaud_mainfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         speaud_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case speaud_mainfi_tclToken::EN_MSG_INTERNMSGUPREG:
      case speaud_mainfi_tclToken::EN_MSG_INTERNMSGRELUPREG:
      case speaud_mainfi_tclToken::EN_MSG_INTERNMSGSTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case speaud_mainfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(speaud_mainfi_tclKnot(speaud_mainfi_tclToken::EN_END_OF_STRUCT,speaud_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(speaud_mainfi_tclKnot(speaud_mainfi_tclToken::EN_U8,speaud_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(speaud_mainfi_tclKnot(speaud_mainfi_tclToken::EN_LIST,speaud_mainfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         speaud_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case speaud_mainfi_tclToken::EN_E8_SPEAUD_TEST:
      {
         speaud_fi_tcl_e8_SPEAUD_TEST o_e8_SPEAUD_TEST;
         if (!bDoIt(o_e8_SPEAUD_TEST))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case speaud_mainfi_tclToken::EN_UNKNOWN:
      case speaud_mainfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

