/************************************************************************
 
 *FILE:           alltypes.cpp
 
 *SW-COMPONENT:   FI Functional Interface
 
 *DESCRIPTION:    Interface fuer alle Typdefinitionen
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#if !defined(FI_S_NO_STRING_ACCESS_METHODS) || !defined(FI_S_UTFMODE_TRANSPARENT)
   #define UTFUTIL_S_IMPORT_INTERFACE_GENERIC
   #include "utf_if.h"
#endif

#define SENSOR_FI_S_IMPORT_INTERFACE_FI_TYPES
#include "sensor_fi_if.h"
// -----------------------------------------------------------------------------

fi_tclOutContext& sensor_fi_tclU8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u8Value);
  return oOut;
}

fi_tclInContext& sensor_fi_tclU8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u8Value);
  return oIn;
}

tU32 sensor_fi_tclU8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sensor_fi_tclS8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s8Value);
  return oOut;
}

fi_tclInContext& sensor_fi_tclS8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s8Value);
  return oIn;
}

tU32 sensor_fi_tclS8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sensor_fi_tclU16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u16Value);
  return oOut;
}

fi_tclInContext& sensor_fi_tclU16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u16Value);
  return oIn;
}

tU32 sensor_fi_tclU16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sensor_fi_tclS16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s16Value);
  return oOut;
}

fi_tclInContext& sensor_fi_tclS16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s16Value);
  return oIn;
}

tU32 sensor_fi_tclS16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sensor_fi_tclU24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u24Value);
  return oOut;
}

fi_tclInContext& sensor_fi_tclU24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u24Value);
  return oIn;
}

tU32 sensor_fi_tclU24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sensor_fi_tclS24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s24Value);
  return oOut;
}

fi_tclInContext& sensor_fi_tclS24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s24Value);
  return oIn;
}

tU32 sensor_fi_tclS24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sensor_fi_tclU32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u32Value);
  return oOut;
}

fi_tclInContext& sensor_fi_tclU32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u32Value);
  return oIn;
}

tU32 sensor_fi_tclU32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sensor_fi_tclU64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u64Value);
  return oOut;
}

fi_tclInContext& sensor_fi_tclU64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u64Value);
  return oIn;
}

tU32 sensor_fi_tclU64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sensor_fi_tclS32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s32Value);
  return oOut;
}

fi_tclInContext& sensor_fi_tclS32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s32Value);
  return oIn;
}

tU32 sensor_fi_tclS32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sensor_fi_tclS64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s64Value);
  return oOut;
}

fi_tclInContext& sensor_fi_tclS64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s64Value);
  return oIn;
}

tU32 sensor_fi_tclS64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sensor_fi_tclF32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f32Value);
  return oOut;
}

fi_tclInContext& sensor_fi_tclF32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f32Value);
  return oIn;
}

tU32 sensor_fi_tclF32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sensor_fi_tclF64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f64Value);
  return oOut;
}

fi_tclInContext& sensor_fi_tclF64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f64Value);
  return oIn;
}

tU32 sensor_fi_tclF64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sensor_fi_tclBool::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(bValue);
  return oOut;
}

fi_tclInContext& sensor_fi_tclBool::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(bValue);
  return oIn;
}

tU32 sensor_fi_tclBool::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sensor_fi_tclString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid sensor_fi_tclString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_fi_tclString::~sensor_fi_tclString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

sensor_fi_tclString& sensor_fi_tclString::operator=(const sensor_fi_tclString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

sensor_fi_tclString::sensor_fi_tclString(const sensor_fi_tclString& coRef):sensor_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& sensor_fi_tclString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool sensor_fi_tclString::operator==(const sensor_fi_tclString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 sensor_fi_tclString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
sensor_fi_tclString& sensor_fi_tclString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclString::fi_tclString(const tString& coszString) // ADDED (changed from const tString to const tString&)
sensor_fi_tclString::sensor_fi_tclString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool sensor_fi_tclString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

sensor_fi_tclString::operator tString&() // ADDED
{
   return szValue;
}

sensor_fi_tclString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool sensor_fi_tclString::operator!=(intptr_t iNULL) const // ADDED
{
   return szValue != (char*)iNULL;
}

static tChar sensor_FI_C_U8_NULLCHAR = '\0';

tChar* sensor_fi_tclString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* sensor_fi_tclString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* sensor_fi_tclString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& sensor_fi_tclString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return sensor_FI_C_U8_NULLCHAR;
}

tChar& sensor_fi_tclString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return sensor_FI_C_U8_NULLCHAR;
}

tChar& sensor_fi_tclString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return sensor_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool sensor_fi_tclString::bSet(const sensor_fi_tclString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool sensor_fi_tclString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
case FI_EN_ISO8859_1M :
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = util_u32ConvertISO8859_1Mod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            util_u32ConvertISO8859_1Mod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
   return bSuccess;
}

tString sensor_fi_tclString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

// -----------------------------------------------------------------------------

fi_tclOutContext& sensor_fi_tclList::oWrite(fi_tclOutContext& oOut) const 
{
   // --Schreibe die Listenlaenge in den Kontext
   (tVoid) oOut.oWrite(u32ListSize);
   return oOut;
}

fi_tclInContext& sensor_fi_tclList::oRead(fi_tclInContext& oIn) 
{
  // --Lese die Listenlaenge aus dem Kontext
  (tVoid) oIn.oRead(u32ListSize);
  return oIn;
}

tBool sensor_fi_tclList::operator==(const sensor_fi_tclList& roRef) const
{
   return roRef.u32ListSize == u32ListSize;
}

tU32 sensor_fi_tclList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sensor_fi_tclMultiLanguageString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid sensor_fi_tclMultiLanguageString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_fi_tclMultiLanguageString::~sensor_fi_tclMultiLanguageString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

sensor_fi_tclMultiLanguageString& sensor_fi_tclMultiLanguageString::operator=(const sensor_fi_tclMultiLanguageString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

sensor_fi_tclMultiLanguageString::sensor_fi_tclMultiLanguageString(const sensor_fi_tclMultiLanguageString& coRef):sensor_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& sensor_fi_tclMultiLanguageString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool sensor_fi_tclMultiLanguageString::operator==(const sensor_fi_tclMultiLanguageString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 sensor_fi_tclMultiLanguageString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
sensor_fi_tclMultiLanguageString& sensor_fi_tclMultiLanguageString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclMultiLanguageString::fi_tclMultiLanguageString(const tString& coszString) // ADDED (changed from const tString to const tString&)
sensor_fi_tclMultiLanguageString::sensor_fi_tclMultiLanguageString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool sensor_fi_tclMultiLanguageString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

sensor_fi_tclMultiLanguageString::operator tString&() // ADDED
{
   return szValue;
}

sensor_fi_tclMultiLanguageString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool sensor_fi_tclMultiLanguageString::operator!=(intptr_t iNULL) const// ADDED
{
   return szValue != (char*)iNULL;
}

tChar* sensor_fi_tclMultiLanguageString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* sensor_fi_tclMultiLanguageString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* sensor_fi_tclMultiLanguageString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& sensor_fi_tclMultiLanguageString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return sensor_FI_C_U8_NULLCHAR;
}

tChar& sensor_fi_tclMultiLanguageString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return sensor_FI_C_U8_NULLCHAR;
}

tChar& sensor_fi_tclMultiLanguageString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return sensor_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool sensor_fi_tclMultiLanguageString::bSet(const sensor_fi_tclMultiLanguageString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclMultiLanguageString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool sensor_fi_tclMultiLanguageString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }

   return bSuccess;
}

tString sensor_fi_tclMultiLanguageString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_fi_tcl_BinContainer::sensor_fi_tcl_BinContainer(const sensor_fi_tcl_BinContainer& coRef)
   : sensor_fi_tclVisitableTypeBase(coRef)
{
   ContainerDataList = coRef.ContainerDataList;
}
sensor_fi_tcl_BinContainer& sensor_fi_tcl_BinContainer::operator=(const sensor_fi_tcl_BinContainer& coRef)
{
   if (this == &coRef) return *this;
   ContainerDataList = coRef.ContainerDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sensor_fi_tcl_BinContainer::vDestroy()
{
   {
   ContainerDataList.clear();
   }
}

sensor_fi_tcl_BinContainer::sensor_fi_tcl_BinContainer()

 {}

tS32 sensor_fi_tcl_BinContainer::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_BINCONTAINER;
}


sensor_fi_tcl_BinContainer::~sensor_fi_tcl_BinContainer()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sensor_fi_tcl_BinContainer::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ContainerDataList.size()*1;
}

fi_tclInContext& sensor_fi_tcl_BinContainer::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ContainerDataList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ContainerDataList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_BinContainer::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ContainerDataList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ContainerDataList.size(); ++u32Idx)
         (tVoid) (oOut << ContainerDataList[u32Idx]);
   }
   return oOut;
}

tBool sensor_fi_tcl_BinContainer::operator==(const sensor_fi_tcl_BinContainer& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ContainerDataList.size() == roRef.ContainerDataList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ContainerDataList.size()); ++u32Idx)
            bResult = bResult && (ContainerDataList[u32Idx] == roRef.ContainerDataList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sensor_fi_tcl_Reserved::sensor_fi_tcl_Reserved()
 {}

tS32 sensor_fi_tcl_Reserved::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_RESERVED;
}


sensor_fi_tcl_Reserved::~sensor_fi_tcl_Reserved()
{}

tU32 sensor_fi_tcl_Reserved::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

fi_tclInContext& sensor_fi_tcl_Reserved::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_Reserved::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_u8_Percent::sensor_fi_tcl_u8_Percent(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 sensor_fi_tcl_u8_Percent::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_U8_PERCENT;
}


sensor_fi_tcl_u8_Percent::~sensor_fi_tcl_u8_Percent()
{}

tU32 sensor_fi_tcl_u8_Percent::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_fi_tcl_u8_Percent::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& sensor_fi_tcl_u8_Percent::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_s16_PerThousand::sensor_fi_tcl_s16_PerThousand(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sensor_fi_tcl_s16_PerThousand::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_S16_PERTHOUSAND;
}


sensor_fi_tcl_s16_PerThousand::~sensor_fi_tcl_s16_PerThousand()
{}

tU32 sensor_fi_tcl_s16_PerThousand::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sensor_fi_tcl_s16_PerThousand::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sensor_fi_tcl_s16_PerThousand::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_u16_IndexInReferenceList::sensor_fi_tcl_u16_IndexInReferenceList(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 sensor_fi_tcl_u16_IndexInReferenceList::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_U16_INDEXINREFERENCELIST;
}


sensor_fi_tcl_u16_IndexInReferenceList::~sensor_fi_tcl_u16_IndexInReferenceList()
{}

tU32 sensor_fi_tcl_u16_IndexInReferenceList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sensor_fi_tcl_u16_IndexInReferenceList::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& sensor_fi_tcl_u16_IndexInReferenceList::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_u16_ErrorCode::sensor_fi_tcl_u16_ErrorCode(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 sensor_fi_tcl_u16_ErrorCode::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_U16_ERRORCODE;
}


sensor_fi_tcl_u16_ErrorCode::~sensor_fi_tcl_u16_ErrorCode()
{}

tU32 sensor_fi_tcl_u16_ErrorCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sensor_fi_tcl_u16_ErrorCode::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& sensor_fi_tcl_u16_ErrorCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_u16_RPM::sensor_fi_tcl_u16_RPM(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 sensor_fi_tcl_u16_RPM::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_U16_RPM;
}


sensor_fi_tcl_u16_RPM::~sensor_fi_tcl_u16_RPM()
{}

tU32 sensor_fi_tcl_u16_RPM::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sensor_fi_tcl_u16_RPM::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& sensor_fi_tcl_u16_RPM::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_s32_Kilogram::sensor_fi_tcl_s32_Kilogram(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sensor_fi_tcl_s32_Kilogram::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_S32_KILOGRAM;
}


sensor_fi_tcl_s32_Kilogram::~sensor_fi_tcl_s32_Kilogram()
{}

tU32 sensor_fi_tcl_s32_Kilogram::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sensor_fi_tcl_s32_Kilogram::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sensor_fi_tcl_s32_Kilogram::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_s32_Pound::sensor_fi_tcl_s32_Pound(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sensor_fi_tcl_s32_Pound::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_S32_POUND;
}


sensor_fi_tcl_s32_Pound::~sensor_fi_tcl_s32_Pound()
{}

tU32 sensor_fi_tcl_s32_Pound::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sensor_fi_tcl_s32_Pound::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sensor_fi_tcl_s32_Pound::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_s16_Meter::sensor_fi_tcl_s16_Meter(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sensor_fi_tcl_s16_Meter::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_S16_METER;
}


sensor_fi_tcl_s16_Meter::~sensor_fi_tcl_s16_Meter()
{}

tU32 sensor_fi_tcl_s16_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sensor_fi_tcl_s16_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sensor_fi_tcl_s16_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_s32_Meter::sensor_fi_tcl_s32_Meter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sensor_fi_tcl_s32_Meter::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_S32_METER;
}


sensor_fi_tcl_s32_Meter::~sensor_fi_tcl_s32_Meter()
{}

tU32 sensor_fi_tcl_s32_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sensor_fi_tcl_s32_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sensor_fi_tcl_s32_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_s32_Yards::sensor_fi_tcl_s32_Yards(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sensor_fi_tcl_s32_Yards::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_S32_YARDS;
}


sensor_fi_tcl_s32_Yards::~sensor_fi_tcl_s32_Yards()
{}

tU32 sensor_fi_tcl_s32_Yards::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sensor_fi_tcl_s32_Yards::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sensor_fi_tcl_s32_Yards::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_s32_Foot::sensor_fi_tcl_s32_Foot(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sensor_fi_tcl_s32_Foot::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_S32_FOOT;
}


sensor_fi_tcl_s32_Foot::~sensor_fi_tcl_s32_Foot()
{}

tU32 sensor_fi_tcl_s32_Foot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sensor_fi_tcl_s32_Foot::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sensor_fi_tcl_s32_Foot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_s32_Centimeter::sensor_fi_tcl_s32_Centimeter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sensor_fi_tcl_s32_Centimeter::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_S32_CENTIMETER;
}


sensor_fi_tcl_s32_Centimeter::~sensor_fi_tcl_s32_Centimeter()
{}

tU32 sensor_fi_tcl_s32_Centimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sensor_fi_tcl_s32_Centimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sensor_fi_tcl_s32_Centimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_s32_Inch::sensor_fi_tcl_s32_Inch(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sensor_fi_tcl_s32_Inch::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_S32_INCH;
}


sensor_fi_tcl_s32_Inch::~sensor_fi_tcl_s32_Inch()
{}

tU32 sensor_fi_tcl_s32_Inch::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sensor_fi_tcl_s32_Inch::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sensor_fi_tcl_s32_Inch::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_s32_Millimeter::sensor_fi_tcl_s32_Millimeter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sensor_fi_tcl_s32_Millimeter::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_S32_MILLIMETER;
}


sensor_fi_tcl_s32_Millimeter::~sensor_fi_tcl_s32_Millimeter()
{}

tU32 sensor_fi_tcl_s32_Millimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sensor_fi_tcl_s32_Millimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sensor_fi_tcl_s32_Millimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_s32_Microliter::sensor_fi_tcl_s32_Microliter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sensor_fi_tcl_s32_Microliter::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_S32_MICROLITER;
}


sensor_fi_tcl_s32_Microliter::~sensor_fi_tcl_s32_Microliter()
{}

tU32 sensor_fi_tcl_s32_Microliter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sensor_fi_tcl_s32_Microliter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sensor_fi_tcl_s32_Microliter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_s32_Second::sensor_fi_tcl_s32_Second(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sensor_fi_tcl_s32_Second::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_S32_SECOND;
}


sensor_fi_tcl_s32_Second::~sensor_fi_tcl_s32_Second()
{}

tU32 sensor_fi_tcl_s32_Second::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sensor_fi_tcl_s32_Second::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sensor_fi_tcl_s32_Second::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_u16_MilliSecond::sensor_fi_tcl_u16_MilliSecond(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 sensor_fi_tcl_u16_MilliSecond::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_U16_MILLISECOND;
}


sensor_fi_tcl_u16_MilliSecond::~sensor_fi_tcl_u16_MilliSecond()
{}

tU32 sensor_fi_tcl_u16_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sensor_fi_tcl_u16_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& sensor_fi_tcl_u16_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_s32_MilliSecond::sensor_fi_tcl_s32_MilliSecond(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sensor_fi_tcl_s32_MilliSecond::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_S32_MILLISECOND;
}


sensor_fi_tcl_s32_MilliSecond::~sensor_fi_tcl_s32_MilliSecond()
{}

tU32 sensor_fi_tcl_s32_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sensor_fi_tcl_s32_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sensor_fi_tcl_s32_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_fi_tcl_POSIXTime::sensor_fi_tcl_POSIXTime(const sensor_fi_tcl_POSIXTime& coRef)
   : sensor_fi_tclVisitableTypeBase(coRef)
{
   Time = coRef.Time;
}
sensor_fi_tcl_POSIXTime& sensor_fi_tcl_POSIXTime::operator=(const sensor_fi_tcl_POSIXTime& coRef)
{
   if (this == &coRef) return *this;
   Time = coRef.Time;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_POSIXTime::sensor_fi_tcl_POSIXTime()
:Time(0)
 {}

tS32 sensor_fi_tcl_POSIXTime::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_POSIXTIME;
}


sensor_fi_tcl_POSIXTime::~sensor_fi_tcl_POSIXTime()
{}

tU32 sensor_fi_tcl_POSIXTime::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sensor_fi_tcl_POSIXTime::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Time);
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_POSIXTime::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Time);
   return oOut;
}

tBool sensor_fi_tcl_POSIXTime::operator==(const sensor_fi_tcl_POSIXTime& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Time == roRef.Time);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_e8_DST_State::sensor_fi_tcl_e8_DST_State():enType(FI_EN_T_STANDARDTIME) {}

tS32 sensor_fi_tcl_e8_DST_State::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_E8_DST_STATE;
}


sensor_fi_tcl_e8_DST_State::~sensor_fi_tcl_e8_DST_State()
{}

tU32 sensor_fi_tcl_e8_DST_State::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_fi_tcl_e8_DST_State::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_e8_DST_State::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_fi_tcl_TimeZoneElement::sensor_fi_tcl_TimeZoneElement(const sensor_fi_tcl_TimeZoneElement& coRef)
   : sensor_fi_tclVisitableTypeBase(coRef)
{
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
}
sensor_fi_tcl_TimeZoneElement& sensor_fi_tcl_TimeZoneElement::operator=(const sensor_fi_tcl_TimeZoneElement& coRef)
{
   if (this == &coRef) return *this;
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sensor_fi_tcl_TimeZoneElement::vDestroy()
{
   Abbreviation_StandardTime.vDestroy();
   Abbreviation_DST_in_effect.vDestroy();
   {
   DST_TimeDomain.clear();
   }
}

sensor_fi_tcl_TimeZoneElement::sensor_fi_tcl_TimeZoneElement()
:Abbreviation_StandardTime(0)
,Abbreviation_DST_in_effect(0)
,TimeZoneDifference()
,DST_State()
,DSTDifference()

 {}

tS32 sensor_fi_tcl_TimeZoneElement::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_TIMEZONEELEMENT;
}


sensor_fi_tcl_TimeZoneElement::~sensor_fi_tcl_TimeZoneElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sensor_fi_tcl_TimeZoneElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 13+Abbreviation_StandardTime.u32GetSize(u16MajorVersion)+Abbreviation_DST_in_effect.u32GetSize(u16MajorVersion)+DST_TimeDomain.size()*1;
}

fi_tclInContext& sensor_fi_tcl_TimeZoneElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Abbreviation_StandardTime);
   (tVoid) (oIn >> Abbreviation_DST_in_effect);
   (tVoid) (oIn >> TimeZoneDifference);
   (tVoid) (oIn >> DST_State);
   (tVoid) (oIn >> DSTDifference);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      DST_TimeDomain.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DST_TimeDomain[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_TimeZoneElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Abbreviation_StandardTime);
   (tVoid) (oOut << Abbreviation_DST_in_effect);
   (tVoid) (oOut << TimeZoneDifference);
   (tVoid) (oOut << DST_State);
   (tVoid) (oOut << DSTDifference);
   (tVoid) (oOut << (tU32)DST_TimeDomain.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DST_TimeDomain.size(); ++u32Idx)
         (tVoid) (oOut << DST_TimeDomain[u32Idx]);
   }
   return oOut;
}

tBool sensor_fi_tcl_TimeZoneElement::operator==(const sensor_fi_tcl_TimeZoneElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Abbreviation_StandardTime == roRef.Abbreviation_StandardTime);
   bResult = bResult && (Abbreviation_DST_in_effect == roRef.Abbreviation_DST_in_effect);
   bResult = bResult && (TimeZoneDifference == roRef.TimeZoneDifference);
   bResult = bResult && (DST_State == roRef.DST_State);
   bResult = bResult && (DSTDifference == roRef.DSTDifference);
      bResult = bResult && (DST_TimeDomain.size() == roRef.DST_TimeDomain.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DST_TimeDomain.size()); ++u32Idx)
            bResult = bResult && (DST_TimeDomain[u32Idx] == roRef.DST_TimeDomain[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_s16_KmPerHour::sensor_fi_tcl_s16_KmPerHour(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sensor_fi_tcl_s16_KmPerHour::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_S16_KMPERHOUR;
}


sensor_fi_tcl_s16_KmPerHour::~sensor_fi_tcl_s16_KmPerHour()
{}

tU32 sensor_fi_tcl_s16_KmPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sensor_fi_tcl_s16_KmPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sensor_fi_tcl_s16_KmPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_s16_MilesPerHour::sensor_fi_tcl_s16_MilesPerHour(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sensor_fi_tcl_s16_MilesPerHour::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_S16_MILESPERHOUR;
}


sensor_fi_tcl_s16_MilesPerHour::~sensor_fi_tcl_s16_MilesPerHour()
{}

tU32 sensor_fi_tcl_s16_MilesPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sensor_fi_tcl_s16_MilesPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sensor_fi_tcl_s16_MilesPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_s16_Knot::sensor_fi_tcl_s16_Knot(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sensor_fi_tcl_s16_Knot::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_S16_KNOT;
}


sensor_fi_tcl_s16_Knot::~sensor_fi_tcl_s16_Knot()
{}

tU32 sensor_fi_tcl_s16_Knot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sensor_fi_tcl_s16_Knot::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sensor_fi_tcl_s16_Knot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_s16_CentimeterSecond::sensor_fi_tcl_s16_CentimeterSecond(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sensor_fi_tcl_s16_CentimeterSecond::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_S16_CENTIMETERSECOND;
}


sensor_fi_tcl_s16_CentimeterSecond::~sensor_fi_tcl_s16_CentimeterSecond()
{}

tU32 sensor_fi_tcl_s16_CentimeterSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sensor_fi_tcl_s16_CentimeterSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sensor_fi_tcl_s16_CentimeterSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_s16_Kelvin::sensor_fi_tcl_s16_Kelvin(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sensor_fi_tcl_s16_Kelvin::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_S16_KELVIN;
}


sensor_fi_tcl_s16_Kelvin::~sensor_fi_tcl_s16_Kelvin()
{}

tU32 sensor_fi_tcl_s16_Kelvin::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sensor_fi_tcl_s16_Kelvin::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sensor_fi_tcl_s16_Kelvin::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_s16_Fahrenheit::sensor_fi_tcl_s16_Fahrenheit(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sensor_fi_tcl_s16_Fahrenheit::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_S16_FAHRENHEIT;
}


sensor_fi_tcl_s16_Fahrenheit::~sensor_fi_tcl_s16_Fahrenheit()
{}

tU32 sensor_fi_tcl_s16_Fahrenheit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sensor_fi_tcl_s16_Fahrenheit::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sensor_fi_tcl_s16_Fahrenheit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_s32_Pascal::sensor_fi_tcl_s32_Pascal(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sensor_fi_tcl_s32_Pascal::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_S32_PASCAL;
}


sensor_fi_tcl_s32_Pascal::~sensor_fi_tcl_s32_Pascal()
{}

tU32 sensor_fi_tcl_s32_Pascal::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sensor_fi_tcl_s32_Pascal::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sensor_fi_tcl_s32_Pascal::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_s32_Watt::sensor_fi_tcl_s32_Watt(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sensor_fi_tcl_s32_Watt::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_S32_WATT;
}


sensor_fi_tcl_s32_Watt::~sensor_fi_tcl_s32_Watt()
{}

tU32 sensor_fi_tcl_s32_Watt::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sensor_fi_tcl_s32_Watt::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sensor_fi_tcl_s32_Watt::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_fi_tcl_FIVersion::sensor_fi_tcl_FIVersion(const sensor_fi_tcl_FIVersion& coRef)
   : sensor_fi_tclVisitableTypeBase(coRef)
{
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
}
sensor_fi_tcl_FIVersion& sensor_fi_tcl_FIVersion::operator=(const sensor_fi_tcl_FIVersion& coRef)
{
   if (this == &coRef) return *this;
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_FIVersion::sensor_fi_tcl_FIVersion()
:MajorVersion(0)
,MinorVersion(0)
,PatchVersion(0)
 {}

tS32 sensor_fi_tcl_FIVersion::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_FIVERSION;
}


sensor_fi_tcl_FIVersion::~sensor_fi_tcl_FIVersion()
{}

tU32 sensor_fi_tcl_FIVersion::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& sensor_fi_tcl_FIVersion::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MajorVersion);
   (tVoid) (oIn >> MinorVersion);
   (tVoid) (oIn >> PatchVersion);
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_FIVersion::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MajorVersion);
   (tVoid) (oOut << MinorVersion);
   (tVoid) (oOut << PatchVersion);
   return oOut;
}

tBool sensor_fi_tcl_FIVersion::operator==(const sensor_fi_tcl_FIVersion& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MajorVersion == roRef.MajorVersion);
   bResult = bResult && (MinorVersion == roRef.MinorVersion);
   bResult = bResult && (PatchVersion == roRef.PatchVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_s32_Longitude::sensor_fi_tcl_s32_Longitude(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sensor_fi_tcl_s32_Longitude::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_S32_LONGITUDE;
}


sensor_fi_tcl_s32_Longitude::~sensor_fi_tcl_s32_Longitude()
{}

tU32 sensor_fi_tcl_s32_Longitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sensor_fi_tcl_s32_Longitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sensor_fi_tcl_s32_Longitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_s32_Latitude::sensor_fi_tcl_s32_Latitude(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sensor_fi_tcl_s32_Latitude::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_S32_LATITUDE;
}


sensor_fi_tcl_s32_Latitude::~sensor_fi_tcl_s32_Latitude()
{}

tU32 sensor_fi_tcl_s32_Latitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sensor_fi_tcl_s32_Latitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sensor_fi_tcl_s32_Latitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_fi_tcl_PositionWGS84::sensor_fi_tcl_PositionWGS84(const sensor_fi_tcl_PositionWGS84& coRef)
   : sensor_fi_tclVisitableTypeBase(coRef)
{
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
}
sensor_fi_tcl_PositionWGS84& sensor_fi_tcl_PositionWGS84::operator=(const sensor_fi_tcl_PositionWGS84& coRef)
{
   if (this == &coRef) return *this;
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_PositionWGS84::sensor_fi_tcl_PositionWGS84()
:Longitude()
,Latitude()
 {}

tS32 sensor_fi_tcl_PositionWGS84::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_POSITIONWGS84;
}


sensor_fi_tcl_PositionWGS84::~sensor_fi_tcl_PositionWGS84()
{}

tU32 sensor_fi_tcl_PositionWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& sensor_fi_tcl_PositionWGS84::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Longitude);
   (tVoid) (oIn >> Latitude);
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_PositionWGS84::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Longitude);
   (tVoid) (oOut << Latitude);
   return oOut;
}

tBool sensor_fi_tcl_PositionWGS84::operator==(const sensor_fi_tcl_PositionWGS84& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Longitude == roRef.Longitude);
   bResult = bResult && (Latitude == roRef.Latitude);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_fi_tcl_RectangleWGS84::sensor_fi_tcl_RectangleWGS84(const sensor_fi_tcl_RectangleWGS84& coRef)
   : sensor_fi_tclVisitableTypeBase(coRef)
{
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
}
sensor_fi_tcl_RectangleWGS84& sensor_fi_tcl_RectangleWGS84::operator=(const sensor_fi_tcl_RectangleWGS84& coRef)
{
   if (this == &coRef) return *this;
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_RectangleWGS84::sensor_fi_tcl_RectangleWGS84()
:LongitudeMin()
,LatitudeMin()
,LongitudeMax()
,LatitudeMax()
 {}

tS32 sensor_fi_tcl_RectangleWGS84::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_RECTANGLEWGS84;
}


sensor_fi_tcl_RectangleWGS84::~sensor_fi_tcl_RectangleWGS84()
{}

tU32 sensor_fi_tcl_RectangleWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

fi_tclInContext& sensor_fi_tcl_RectangleWGS84::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LongitudeMin);
   (tVoid) (oIn >> LatitudeMin);
   (tVoid) (oIn >> LongitudeMax);
   (tVoid) (oIn >> LatitudeMax);
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_RectangleWGS84::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LongitudeMin);
   (tVoid) (oOut << LatitudeMin);
   (tVoid) (oOut << LongitudeMax);
   (tVoid) (oOut << LatitudeMax);
   return oOut;
}

tBool sensor_fi_tcl_RectangleWGS84::operator==(const sensor_fi_tcl_RectangleWGS84& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LongitudeMin == roRef.LongitudeMin);
   bResult = bResult && (LatitudeMin == roRef.LatitudeMin);
   bResult = bResult && (LongitudeMax == roRef.LongitudeMax);
   bResult = bResult && (LatitudeMax == roRef.LatitudeMax);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_e16_ISOCountryCode::sensor_fi_tcl_e16_ISOCountryCode():enType(FI_EN_ISO_ALPHA_3_UNDEFINED) {}

tS32 sensor_fi_tcl_e16_ISOCountryCode::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_E16_ISOCOUNTRYCODE;
}


sensor_fi_tcl_e16_ISOCountryCode::~sensor_fi_tcl_e16_ISOCountryCode()
{}

tU32 sensor_fi_tcl_e16_ISOCountryCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sensor_fi_tcl_e16_ISOCountryCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_e16_ISOCountryCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_e16_ISOLanguageCode::sensor_fi_tcl_e16_ISOLanguageCode():enType(FI_EN_ISO_639_1_UNDEFINED) {}

tS32 sensor_fi_tcl_e16_ISOLanguageCode::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_E16_ISOLANGUAGECODE;
}


sensor_fi_tcl_e16_ISOLanguageCode::~sensor_fi_tcl_e16_ISOLanguageCode()
{}

tU32 sensor_fi_tcl_e16_ISOLanguageCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sensor_fi_tcl_e16_ISOLanguageCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_e16_ISOLanguageCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_fi_tcl_LanguageID::sensor_fi_tcl_LanguageID(const sensor_fi_tcl_LanguageID& coRef)
   : sensor_fi_tclVisitableTypeBase(coRef)
{
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
}
sensor_fi_tcl_LanguageID& sensor_fi_tcl_LanguageID::operator=(const sensor_fi_tcl_LanguageID& coRef)
{
   if (this == &coRef) return *this;
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_LanguageID::sensor_fi_tcl_LanguageID()
:ISO639_LanguageCode()
,ISO3166_CountryCode()
 {}

tS32 sensor_fi_tcl_LanguageID::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_LANGUAGEID;
}


sensor_fi_tcl_LanguageID::~sensor_fi_tcl_LanguageID()
{}

tU32 sensor_fi_tcl_LanguageID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sensor_fi_tcl_LanguageID::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ISO639_LanguageCode);
   (tVoid) (oIn >> ISO3166_CountryCode);
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_LanguageID::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ISO639_LanguageCode);
   (tVoid) (oOut << ISO3166_CountryCode);
   return oOut;
}

tBool sensor_fi_tcl_LanguageID::operator==(const sensor_fi_tcl_LanguageID& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ISO639_LanguageCode == roRef.ISO639_LanguageCode);
   bResult = bResult && (ISO3166_CountryCode == roRef.ISO3166_CountryCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_u8_DirectionAbsolute::sensor_fi_tcl_u8_DirectionAbsolute(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 sensor_fi_tcl_u8_DirectionAbsolute::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_U8_DIRECTIONABSOLUTE;
}


sensor_fi_tcl_u8_DirectionAbsolute::~sensor_fi_tcl_u8_DirectionAbsolute()
{}

tU32 sensor_fi_tcl_u8_DirectionAbsolute::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_fi_tcl_u8_DirectionAbsolute::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& sensor_fi_tcl_u8_DirectionAbsolute::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_u8_DirectionRelative::sensor_fi_tcl_u8_DirectionRelative(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 sensor_fi_tcl_u8_DirectionRelative::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_U8_DIRECTIONRELATIVE;
}


sensor_fi_tcl_u8_DirectionRelative::~sensor_fi_tcl_u8_DirectionRelative()
{}

tU32 sensor_fi_tcl_u8_DirectionRelative::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_fi_tcl_u8_DirectionRelative::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& sensor_fi_tcl_u8_DirectionRelative::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_s16_CentiDegree::sensor_fi_tcl_s16_CentiDegree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sensor_fi_tcl_s16_CentiDegree::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_S16_CENTIDEGREE;
}


sensor_fi_tcl_s16_CentiDegree::~sensor_fi_tcl_s16_CentiDegree()
{}

tU32 sensor_fi_tcl_s16_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sensor_fi_tcl_s16_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sensor_fi_tcl_s16_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_s16_Degree::sensor_fi_tcl_s16_Degree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sensor_fi_tcl_s16_Degree::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_S16_DEGREE;
}


sensor_fi_tcl_s16_Degree::~sensor_fi_tcl_s16_Degree()
{}

tU32 sensor_fi_tcl_s16_Degree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sensor_fi_tcl_s16_Degree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sensor_fi_tcl_s16_Degree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_u16_DirectionAbsolute_CentiDegree::sensor_fi_tcl_u16_DirectionAbsolute_CentiDegree(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 sensor_fi_tcl_u16_DirectionAbsolute_CentiDegree::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_U16_DIRECTIONABSOLUTE_CENTIDEGREE;
}


sensor_fi_tcl_u16_DirectionAbsolute_CentiDegree::~sensor_fi_tcl_u16_DirectionAbsolute_CentiDegree()
{}

tU32 sensor_fi_tcl_u16_DirectionAbsolute_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sensor_fi_tcl_u16_DirectionAbsolute_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& sensor_fi_tcl_u16_DirectionAbsolute_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_s16_DirectionRelative_CentiDegree::sensor_fi_tcl_s16_DirectionRelative_CentiDegree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sensor_fi_tcl_s16_DirectionRelative_CentiDegree::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_S16_DIRECTIONRELATIVE_CENTIDEGREE;
}


sensor_fi_tcl_s16_DirectionRelative_CentiDegree::~sensor_fi_tcl_s16_DirectionRelative_CentiDegree()
{}

tU32 sensor_fi_tcl_s16_DirectionRelative_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sensor_fi_tcl_s16_DirectionRelative_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sensor_fi_tcl_s16_DirectionRelative_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_e8_FuelType::sensor_fi_tcl_e8_FuelType():enType(FI_EN_RESERVED) {}

tS32 sensor_fi_tcl_e8_FuelType::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_E8_FUELTYPE;
}


sensor_fi_tcl_e8_FuelType::~sensor_fi_tcl_e8_FuelType()
{}

tU32 sensor_fi_tcl_e8_FuelType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_fi_tcl_e8_FuelType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_e8_FuelType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_fi_tcl_DistTimeFuel::sensor_fi_tcl_DistTimeFuel(const sensor_fi_tcl_DistTimeFuel& coRef)
   : sensor_fi_tclVisitableTypeBase(coRef)
{
   Distance = coRef.Distance;
   Time = coRef.Time;
   Fuel = coRef.Fuel;
}
sensor_fi_tcl_DistTimeFuel& sensor_fi_tcl_DistTimeFuel::operator=(const sensor_fi_tcl_DistTimeFuel& coRef)
{
   if (this == &coRef) return *this;
   Distance = coRef.Distance;
   Time = coRef.Time;
   Fuel = coRef.Fuel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_DistTimeFuel::sensor_fi_tcl_DistTimeFuel()
:Distance()
,Time()
,Fuel()
 {}

tS32 sensor_fi_tcl_DistTimeFuel::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_DISTTIMEFUEL;
}


sensor_fi_tcl_DistTimeFuel::~sensor_fi_tcl_DistTimeFuel()
{}

tU32 sensor_fi_tcl_DistTimeFuel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& sensor_fi_tcl_DistTimeFuel::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Distance);
   (tVoid) (oIn >> Time);
   (tVoid) (oIn >> Fuel);
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_DistTimeFuel::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Distance);
   (tVoid) (oOut << Time);
   (tVoid) (oOut << Fuel);
   return oOut;
}

tBool sensor_fi_tcl_DistTimeFuel::operator==(const sensor_fi_tcl_DistTimeFuel& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Distance == roRef.Distance);
   bResult = bResult && (Time == roRef.Time);
   bResult = bResult && (Fuel == roRef.Fuel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_fi_tcl_VdsVersionInfo::sensor_fi_tcl_VdsVersionInfo(const sensor_fi_tcl_VdsVersionInfo& coRef)
   : sensor_fi_tclVisitableTypeBase(coRef)
{
   vdsVersion = coRef.vdsVersion;
   boardVersion = coRef.boardVersion;
}
sensor_fi_tcl_VdsVersionInfo& sensor_fi_tcl_VdsVersionInfo::operator=(const sensor_fi_tcl_VdsVersionInfo& coRef)
{
   if (this == &coRef) return *this;
   vdsVersion = coRef.vdsVersion;
   boardVersion = coRef.boardVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sensor_fi_tcl_VdsVersionInfo::vDestroy()
{
   vdsVersion.vDestroy();
   boardVersion.vDestroy();
}

sensor_fi_tcl_VdsVersionInfo::sensor_fi_tcl_VdsVersionInfo()
:vdsVersion()
,boardVersion()
 {}

tS32 sensor_fi_tcl_VdsVersionInfo::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_VDSVERSIONINFO;
}


sensor_fi_tcl_VdsVersionInfo::~sensor_fi_tcl_VdsVersionInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sensor_fi_tcl_VdsVersionInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+vdsVersion.u32GetSize(u16MajorVersion)+boardVersion.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sensor_fi_tcl_VdsVersionInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> vdsVersion);
   (tVoid) (oIn >> boardVersion);
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_VdsVersionInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << vdsVersion);
   (tVoid) (oOut << boardVersion);
   return oOut;
}

tBool sensor_fi_tcl_VdsVersionInfo::operator==(const sensor_fi_tcl_VdsVersionInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (vdsVersion == roRef.vdsVersion);
   bResult = bResult && (boardVersion == roRef.boardVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_e8_OdometerStatus::sensor_fi_tcl_e8_OdometerStatus():enType(FI_EN_ODOMSTATE_UNKNOWN) {}

tS32 sensor_fi_tcl_e8_OdometerStatus::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_E8_ODOMETERSTATUS;
}


sensor_fi_tcl_e8_OdometerStatus::~sensor_fi_tcl_e8_OdometerStatus()
{}

tU32 sensor_fi_tcl_e8_OdometerStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_fi_tcl_e8_OdometerStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_e8_OdometerStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_e8_OdometerDirection::sensor_fi_tcl_e8_OdometerDirection():enType(FI_EN_ODOMDIR_UNKNOWN) {}

tS32 sensor_fi_tcl_e8_OdometerDirection::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_E8_ODOMETERDIRECTION;
}


sensor_fi_tcl_e8_OdometerDirection::~sensor_fi_tcl_e8_OdometerDirection()
{}

tU32 sensor_fi_tcl_e8_OdometerDirection::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_fi_tcl_e8_OdometerDirection::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_e8_OdometerDirection::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_fi_tcl_OdometerData::sensor_fi_tcl_OdometerData(const sensor_fi_tcl_OdometerData& coRef)
   : sensor_fi_tclVisitableTypeBase(coRef)
{
   Timestamp = coRef.Timestamp;
   OdometerCount = coRef.OdometerCount;
   OdometerStatus = coRef.OdometerStatus;
   OdometerCount_Direction = coRef.OdometerCount_Direction;
}
sensor_fi_tcl_OdometerData& sensor_fi_tcl_OdometerData::operator=(const sensor_fi_tcl_OdometerData& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   OdometerCount = coRef.OdometerCount;
   OdometerStatus = coRef.OdometerStatus;
   OdometerCount_Direction = coRef.OdometerCount_Direction;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_OdometerData::sensor_fi_tcl_OdometerData()
:Timestamp(0)
,OdometerCount(0)
,OdometerStatus()
,OdometerCount_Direction()
 {}

tS32 sensor_fi_tcl_OdometerData::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_ODOMETERDATA;
}


sensor_fi_tcl_OdometerData::~sensor_fi_tcl_OdometerData()
{}

tU32 sensor_fi_tcl_OdometerData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& sensor_fi_tcl_OdometerData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> OdometerCount);
   (tVoid) (oIn >> OdometerStatus);
   (tVoid) (oIn >> OdometerCount_Direction);
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_OdometerData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << OdometerCount);
   (tVoid) (oOut << OdometerStatus);
   (tVoid) (oOut << OdometerCount_Direction);
   return oOut;
}

tBool sensor_fi_tcl_OdometerData::operator==(const sensor_fi_tcl_OdometerData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (OdometerCount == roRef.OdometerCount);
   bResult = bResult && (OdometerStatus == roRef.OdometerStatus);
   bResult = bResult && (OdometerCount_Direction == roRef.OdometerCount_Direction);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_e8_AbsStatus::sensor_fi_tcl_e8_AbsStatus():enType(FI_EN_ABS_STATUS_UNKNOWN) {}

tS32 sensor_fi_tcl_e8_AbsStatus::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_E8_ABSSTATUS;
}


sensor_fi_tcl_e8_AbsStatus::~sensor_fi_tcl_e8_AbsStatus()
{}

tU32 sensor_fi_tcl_e8_AbsStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_fi_tcl_e8_AbsStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_e8_AbsStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_e8_AbsDirection::sensor_fi_tcl_e8_AbsDirection():enType(FI_EN_ABS_DIRECTION_UNKNOWN) {}

tS32 sensor_fi_tcl_e8_AbsDirection::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_E8_ABSDIRECTION;
}


sensor_fi_tcl_e8_AbsDirection::~sensor_fi_tcl_e8_AbsDirection()
{}

tU32 sensor_fi_tcl_e8_AbsDirection::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_fi_tcl_e8_AbsDirection::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_e8_AbsDirection::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_fi_tcl_AbsData::sensor_fi_tcl_AbsData(const sensor_fi_tcl_AbsData& coRef)
   : sensor_fi_tclVisitableTypeBase(coRef)
{
   AbsTimeStamp = coRef.AbsTimeStamp;
   WheelCounterFrontLeft = coRef.WheelCounterFrontLeft;
   WheelCounterFrontRight = coRef.WheelCounterFrontRight;
   WheelCounterRearLeft = coRef.WheelCounterRearLeft;
   WheelCounterRearRight = coRef.WheelCounterRearRight;
   StatusFrontLeft = coRef.StatusFrontLeft;
   StatusFrontRight = coRef.StatusFrontRight;
   StatusRearLeft = coRef.StatusRearLeft;
   StatusRearRight = coRef.StatusRearRight;
   DirectionFrontLeft = coRef.DirectionFrontLeft;
   DirectionFrontRight = coRef.DirectionFrontRight;
   DirectionRearLeft = coRef.DirectionRearLeft;
   DirectionRearRight = coRef.DirectionRearRight;
}
sensor_fi_tcl_AbsData& sensor_fi_tcl_AbsData::operator=(const sensor_fi_tcl_AbsData& coRef)
{
   if (this == &coRef) return *this;
   AbsTimeStamp = coRef.AbsTimeStamp;
   WheelCounterFrontLeft = coRef.WheelCounterFrontLeft;
   WheelCounterFrontRight = coRef.WheelCounterFrontRight;
   WheelCounterRearLeft = coRef.WheelCounterRearLeft;
   WheelCounterRearRight = coRef.WheelCounterRearRight;
   StatusFrontLeft = coRef.StatusFrontLeft;
   StatusFrontRight = coRef.StatusFrontRight;
   StatusRearLeft = coRef.StatusRearLeft;
   StatusRearRight = coRef.StatusRearRight;
   DirectionFrontLeft = coRef.DirectionFrontLeft;
   DirectionFrontRight = coRef.DirectionFrontRight;
   DirectionRearLeft = coRef.DirectionRearLeft;
   DirectionRearRight = coRef.DirectionRearRight;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_AbsData::sensor_fi_tcl_AbsData()
:AbsTimeStamp(0)
,WheelCounterFrontLeft(0)
,WheelCounterFrontRight(0)
,WheelCounterRearLeft(0)
,WheelCounterRearRight(0)
,StatusFrontLeft()
,StatusFrontRight()
,StatusRearLeft()
,StatusRearRight()
,DirectionFrontLeft()
,DirectionFrontRight()
,DirectionRearLeft()
,DirectionRearRight()
 {}

tS32 sensor_fi_tcl_AbsData::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_ABSDATA;
}


sensor_fi_tcl_AbsData::~sensor_fi_tcl_AbsData()
{}

tU32 sensor_fi_tcl_AbsData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 20;
}

fi_tclInContext& sensor_fi_tcl_AbsData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AbsTimeStamp);
   (tVoid) (oIn >> WheelCounterFrontLeft);
   (tVoid) (oIn >> WheelCounterFrontRight);
   (tVoid) (oIn >> WheelCounterRearLeft);
   (tVoid) (oIn >> WheelCounterRearRight);
   (tVoid) (oIn >> StatusFrontLeft);
   (tVoid) (oIn >> StatusFrontRight);
   (tVoid) (oIn >> StatusRearLeft);
   (tVoid) (oIn >> StatusRearRight);
   (tVoid) (oIn >> DirectionFrontLeft);
   (tVoid) (oIn >> DirectionFrontRight);
   (tVoid) (oIn >> DirectionRearLeft);
   (tVoid) (oIn >> DirectionRearRight);
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_AbsData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AbsTimeStamp);
   (tVoid) (oOut << WheelCounterFrontLeft);
   (tVoid) (oOut << WheelCounterFrontRight);
   (tVoid) (oOut << WheelCounterRearLeft);
   (tVoid) (oOut << WheelCounterRearRight);
   (tVoid) (oOut << StatusFrontLeft);
   (tVoid) (oOut << StatusFrontRight);
   (tVoid) (oOut << StatusRearLeft);
   (tVoid) (oOut << StatusRearRight);
   (tVoid) (oOut << DirectionFrontLeft);
   (tVoid) (oOut << DirectionFrontRight);
   (tVoid) (oOut << DirectionRearLeft);
   (tVoid) (oOut << DirectionRearRight);
   return oOut;
}

tBool sensor_fi_tcl_AbsData::operator==(const sensor_fi_tcl_AbsData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AbsTimeStamp == roRef.AbsTimeStamp);
   bResult = bResult && (WheelCounterFrontLeft == roRef.WheelCounterFrontLeft);
   bResult = bResult && (WheelCounterFrontRight == roRef.WheelCounterFrontRight);
   bResult = bResult && (WheelCounterRearLeft == roRef.WheelCounterRearLeft);
   bResult = bResult && (WheelCounterRearRight == roRef.WheelCounterRearRight);
   bResult = bResult && (StatusFrontLeft == roRef.StatusFrontLeft);
   bResult = bResult && (StatusFrontRight == roRef.StatusFrontRight);
   bResult = bResult && (StatusRearLeft == roRef.StatusRearLeft);
   bResult = bResult && (StatusRearRight == roRef.StatusRearRight);
   bResult = bResult && (DirectionFrontLeft == roRef.DirectionFrontLeft);
   bResult = bResult && (DirectionFrontRight == roRef.DirectionFrontRight);
   bResult = bResult && (DirectionRearLeft == roRef.DirectionRearLeft);
   bResult = bResult && (DirectionRearRight == roRef.DirectionRearRight);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_fi_tcl_SensorHwInfo::sensor_fi_tcl_SensorHwInfo(const sensor_fi_tcl_SensorHwInfo& coRef)
   : sensor_fi_tclVisitableTypeBase(coRef)
{
   AdcRangeMin = coRef.AdcRangeMin;
   AdcRangeMax = coRef.AdcRangeMax;
   SampleMin = coRef.SampleMin;
   SampleMax = coRef.SampleMax;
   MinNoiseValue = coRef.MinNoiseValue;
   EstimOffset = coRef.EstimOffset;
   MinOffset = coRef.MinOffset;
   MaxOffset = coRef.MaxOffset;
   DriftOffset = coRef.DriftOffset;
   MaxUnsteadOffset = coRef.MaxUnsteadOffset;
   BestCalibOffset = coRef.BestCalibOffset;
   EstimScaleFactor = coRef.EstimScaleFactor;
   MinScaleFactor = coRef.MinScaleFactor;
   MaxScaleFactor = coRef.MaxScaleFactor;
   DriftScaleFactor = coRef.DriftScaleFactor;
   MaxUnsteadScaleFactor = coRef.MaxUnsteadScaleFactor;
   BestCalibScaleFactor = coRef.BestCalibScaleFactor;
   DriftOffsetTime = coRef.DriftOffsetTime;
   DriftScaleFactorTime = coRef.DriftScaleFactorTime;
}
sensor_fi_tcl_SensorHwInfo& sensor_fi_tcl_SensorHwInfo::operator=(const sensor_fi_tcl_SensorHwInfo& coRef)
{
   if (this == &coRef) return *this;
   AdcRangeMin = coRef.AdcRangeMin;
   AdcRangeMax = coRef.AdcRangeMax;
   SampleMin = coRef.SampleMin;
   SampleMax = coRef.SampleMax;
   MinNoiseValue = coRef.MinNoiseValue;
   EstimOffset = coRef.EstimOffset;
   MinOffset = coRef.MinOffset;
   MaxOffset = coRef.MaxOffset;
   DriftOffset = coRef.DriftOffset;
   MaxUnsteadOffset = coRef.MaxUnsteadOffset;
   BestCalibOffset = coRef.BestCalibOffset;
   EstimScaleFactor = coRef.EstimScaleFactor;
   MinScaleFactor = coRef.MinScaleFactor;
   MaxScaleFactor = coRef.MaxScaleFactor;
   DriftScaleFactor = coRef.DriftScaleFactor;
   MaxUnsteadScaleFactor = coRef.MaxUnsteadScaleFactor;
   BestCalibScaleFactor = coRef.BestCalibScaleFactor;
   DriftOffsetTime = coRef.DriftOffsetTime;
   DriftScaleFactorTime = coRef.DriftScaleFactorTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_SensorHwInfo::sensor_fi_tcl_SensorHwInfo()
:AdcRangeMin(0)
,AdcRangeMax(0)
,SampleMin(0)
,SampleMax(0)
,MinNoiseValue(0)
,EstimOffset(0)
,MinOffset(0)
,MaxOffset(0)
,DriftOffset(0)
,MaxUnsteadOffset(0)
,BestCalibOffset(0)
,EstimScaleFactor(0)
,MinScaleFactor(0)
,MaxScaleFactor(0)
,DriftScaleFactor(0)
,MaxUnsteadScaleFactor(0)
,BestCalibScaleFactor(0)
,DriftOffsetTime(0)
,DriftScaleFactorTime(0)
 {}

tS32 sensor_fi_tcl_SensorHwInfo::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_SENSORHWINFO;
}


sensor_fi_tcl_SensorHwInfo::~sensor_fi_tcl_SensorHwInfo()
{}

tU32 sensor_fi_tcl_SensorHwInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 76;
}

fi_tclInContext& sensor_fi_tcl_SensorHwInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AdcRangeMin);
   (tVoid) (oIn >> AdcRangeMax);
   (tVoid) (oIn >> SampleMin);
   (tVoid) (oIn >> SampleMax);
   (tVoid) (oIn >> MinNoiseValue);
   (tVoid) (oIn >> EstimOffset);
   (tVoid) (oIn >> MinOffset);
   (tVoid) (oIn >> MaxOffset);
   (tVoid) (oIn >> DriftOffset);
   (tVoid) (oIn >> MaxUnsteadOffset);
   (tVoid) (oIn >> BestCalibOffset);
   (tVoid) (oIn >> EstimScaleFactor);
   (tVoid) (oIn >> MinScaleFactor);
   (tVoid) (oIn >> MaxScaleFactor);
   (tVoid) (oIn >> DriftScaleFactor);
   (tVoid) (oIn >> MaxUnsteadScaleFactor);
   (tVoid) (oIn >> BestCalibScaleFactor);
   (tVoid) (oIn >> DriftOffsetTime);
   (tVoid) (oIn >> DriftScaleFactorTime);
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_SensorHwInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AdcRangeMin);
   (tVoid) (oOut << AdcRangeMax);
   (tVoid) (oOut << SampleMin);
   (tVoid) (oOut << SampleMax);
   (tVoid) (oOut << MinNoiseValue);
   (tVoid) (oOut << EstimOffset);
   (tVoid) (oOut << MinOffset);
   (tVoid) (oOut << MaxOffset);
   (tVoid) (oOut << DriftOffset);
   (tVoid) (oOut << MaxUnsteadOffset);
   (tVoid) (oOut << BestCalibOffset);
   (tVoid) (oOut << EstimScaleFactor);
   (tVoid) (oOut << MinScaleFactor);
   (tVoid) (oOut << MaxScaleFactor);
   (tVoid) (oOut << DriftScaleFactor);
   (tVoid) (oOut << MaxUnsteadScaleFactor);
   (tVoid) (oOut << BestCalibScaleFactor);
   (tVoid) (oOut << DriftOffsetTime);
   (tVoid) (oOut << DriftScaleFactorTime);
   return oOut;
}

tBool sensor_fi_tcl_SensorHwInfo::operator==(const sensor_fi_tcl_SensorHwInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AdcRangeMin == roRef.AdcRangeMin);
   bResult = bResult && (AdcRangeMax == roRef.AdcRangeMax);
   bResult = bResult && (SampleMin == roRef.SampleMin);
   bResult = bResult && (SampleMax == roRef.SampleMax);
   bResult = bResult && (MinNoiseValue == roRef.MinNoiseValue);
   bResult = bResult && (EstimOffset == roRef.EstimOffset);
   bResult = bResult && (MinOffset == roRef.MinOffset);
   bResult = bResult && (MaxOffset == roRef.MaxOffset);
   bResult = bResult && (DriftOffset == roRef.DriftOffset);
   bResult = bResult && (MaxUnsteadOffset == roRef.MaxUnsteadOffset);
   bResult = bResult && (BestCalibOffset == roRef.BestCalibOffset);
   bResult = bResult && (EstimScaleFactor == roRef.EstimScaleFactor);
   bResult = bResult && (MinScaleFactor == roRef.MinScaleFactor);
   bResult = bResult && (MaxScaleFactor == roRef.MaxScaleFactor);
   bResult = bResult && (DriftScaleFactor == roRef.DriftScaleFactor);
   bResult = bResult && (MaxUnsteadScaleFactor == roRef.MaxUnsteadScaleFactor);
   bResult = bResult && (BestCalibScaleFactor == roRef.BestCalibScaleFactor);
   bResult = bResult && (DriftOffsetTime == roRef.DriftOffsetTime);
   bResult = bResult && (DriftScaleFactorTime == roRef.DriftScaleFactorTime);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_fi_tcl_3dMountAngles::sensor_fi_tcl_3dMountAngles(const sensor_fi_tcl_3dMountAngles& coRef)
   : sensor_fi_tclVisitableTypeBase(coRef)
{
   AngRX = coRef.AngRX;
   AngRY = coRef.AngRY;
   AngRZ = coRef.AngRZ;
   AngSX = coRef.AngSX;
   AngSY = coRef.AngSY;
   AngSZ = coRef.AngSZ;
   AngTX = coRef.AngTX;
   AngTY = coRef.AngTY;
   AngTZ = coRef.AngTZ;
}
sensor_fi_tcl_3dMountAngles& sensor_fi_tcl_3dMountAngles::operator=(const sensor_fi_tcl_3dMountAngles& coRef)
{
   if (this == &coRef) return *this;
   AngRX = coRef.AngRX;
   AngRY = coRef.AngRY;
   AngRZ = coRef.AngRZ;
   AngSX = coRef.AngSX;
   AngSY = coRef.AngSY;
   AngSZ = coRef.AngSZ;
   AngTX = coRef.AngTX;
   AngTY = coRef.AngTY;
   AngTZ = coRef.AngTZ;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_3dMountAngles::sensor_fi_tcl_3dMountAngles()
:AngRX(0)
,AngRY(0)
,AngRZ(0)
,AngSX(0)
,AngSY(0)
,AngSZ(0)
,AngTX(0)
,AngTY(0)
,AngTZ(0)
 {}

tS32 sensor_fi_tcl_3dMountAngles::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_3DMOUNTANGLES;
}


sensor_fi_tcl_3dMountAngles::~sensor_fi_tcl_3dMountAngles()
{}

tU32 sensor_fi_tcl_3dMountAngles::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& sensor_fi_tcl_3dMountAngles::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AngRX);
   (tVoid) (oIn >> AngRY);
   (tVoid) (oIn >> AngRZ);
   (tVoid) (oIn >> AngSX);
   (tVoid) (oIn >> AngSY);
   (tVoid) (oIn >> AngSZ);
   (tVoid) (oIn >> AngTX);
   (tVoid) (oIn >> AngTY);
   (tVoid) (oIn >> AngTZ);
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_3dMountAngles::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AngRX);
   (tVoid) (oOut << AngRY);
   (tVoid) (oOut << AngRZ);
   (tVoid) (oOut << AngSX);
   (tVoid) (oOut << AngSY);
   (tVoid) (oOut << AngSZ);
   (tVoid) (oOut << AngTX);
   (tVoid) (oOut << AngTY);
   (tVoid) (oOut << AngTZ);
   return oOut;
}

tBool sensor_fi_tcl_3dMountAngles::operator==(const sensor_fi_tcl_3dMountAngles& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AngRX == roRef.AngRX);
   bResult = bResult && (AngRY == roRef.AngRY);
   bResult = bResult && (AngRZ == roRef.AngRZ);
   bResult = bResult && (AngSX == roRef.AngSX);
   bResult = bResult && (AngSY == roRef.AngSY);
   bResult = bResult && (AngSZ == roRef.AngSZ);
   bResult = bResult && (AngTX == roRef.AngTX);
   bResult = bResult && (AngTY == roRef.AngTY);
   bResult = bResult && (AngTZ == roRef.AngTZ);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_e16_GyroStatus::sensor_fi_tcl_e16_GyroStatus():enType(FI_EN_GYROSTATE_CONNECTED_NORMAL) {}

tS32 sensor_fi_tcl_e16_GyroStatus::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_E16_GYROSTATUS;
}


sensor_fi_tcl_e16_GyroStatus::~sensor_fi_tcl_e16_GyroStatus()
{}

tU32 sensor_fi_tcl_e16_GyroStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sensor_fi_tcl_e16_GyroStatus::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_e16_GyroStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_e16_AccStatus::sensor_fi_tcl_e16_AccStatus():enType(FI_EN_ACCSTATE_CONNECTED_NORMAL) {}

tS32 sensor_fi_tcl_e16_AccStatus::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_E16_ACCSTATUS;
}


sensor_fi_tcl_e16_AccStatus::~sensor_fi_tcl_e16_AccStatus()
{}

tU32 sensor_fi_tcl_e16_AccStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sensor_fi_tcl_e16_AccStatus::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_e16_AccStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_fi_tcl_3dGyroHwInfo::sensor_fi_tcl_3dGyroHwInfo(const sensor_fi_tcl_3dGyroHwInfo& coRef)
   : sensor_fi_tclVisitableTypeBase(coRef)
{
   SampleRate = coRef.SampleRate;
   MountAngles = coRef.MountAngles;
   RAxes = coRef.RAxes;
   SAxes = coRef.SAxes;
   TAxes = coRef.TAxes;
}
sensor_fi_tcl_3dGyroHwInfo& sensor_fi_tcl_3dGyroHwInfo::operator=(const sensor_fi_tcl_3dGyroHwInfo& coRef)
{
   if (this == &coRef) return *this;
   SampleRate = coRef.SampleRate;
   MountAngles = coRef.MountAngles;
   RAxes = coRef.RAxes;
   SAxes = coRef.SAxes;
   TAxes = coRef.TAxes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_3dGyroHwInfo::sensor_fi_tcl_3dGyroHwInfo()
:SampleRate(0)
,MountAngles()
,RAxes()
,SAxes()
,TAxes()
 {}

tS32 sensor_fi_tcl_3dGyroHwInfo::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_3DGYROHWINFO;
}


sensor_fi_tcl_3dGyroHwInfo::~sensor_fi_tcl_3dGyroHwInfo()
{}

tU32 sensor_fi_tcl_3dGyroHwInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 241;
}

fi_tclInContext& sensor_fi_tcl_3dGyroHwInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SampleRate);
   (tVoid) (oIn >> MountAngles);
   (tVoid) (oIn >> RAxes);
   (tVoid) (oIn >> SAxes);
   (tVoid) (oIn >> TAxes);
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_3dGyroHwInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SampleRate);
   (tVoid) (oOut << MountAngles);
   (tVoid) (oOut << RAxes);
   (tVoid) (oOut << SAxes);
   (tVoid) (oOut << TAxes);
   return oOut;
}

tBool sensor_fi_tcl_3dGyroHwInfo::operator==(const sensor_fi_tcl_3dGyroHwInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SampleRate == roRef.SampleRate);
   bResult = bResult && (MountAngles == roRef.MountAngles);
   bResult = bResult && (RAxes == roRef.RAxes);
   bResult = bResult && (SAxes == roRef.SAxes);
   bResult = bResult && (TAxes == roRef.TAxes);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_fi_tcl_3dAccHwInfo::sensor_fi_tcl_3dAccHwInfo(const sensor_fi_tcl_3dAccHwInfo& coRef)
   : sensor_fi_tclVisitableTypeBase(coRef)
{
   SampleRate = coRef.SampleRate;
   MountAngles = coRef.MountAngles;
   RAxes = coRef.RAxes;
   SAxes = coRef.SAxes;
   TAxes = coRef.TAxes;
}
sensor_fi_tcl_3dAccHwInfo& sensor_fi_tcl_3dAccHwInfo::operator=(const sensor_fi_tcl_3dAccHwInfo& coRef)
{
   if (this == &coRef) return *this;
   SampleRate = coRef.SampleRate;
   MountAngles = coRef.MountAngles;
   RAxes = coRef.RAxes;
   SAxes = coRef.SAxes;
   TAxes = coRef.TAxes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_3dAccHwInfo::sensor_fi_tcl_3dAccHwInfo()
:SampleRate(0)
,MountAngles()
,RAxes()
,SAxes()
,TAxes()
 {}

tS32 sensor_fi_tcl_3dAccHwInfo::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_3DACCHWINFO;
}


sensor_fi_tcl_3dAccHwInfo::~sensor_fi_tcl_3dAccHwInfo()
{}

tU32 sensor_fi_tcl_3dAccHwInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 241;
}

fi_tclInContext& sensor_fi_tcl_3dAccHwInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SampleRate);
   (tVoid) (oIn >> MountAngles);
   (tVoid) (oIn >> RAxes);
   (tVoid) (oIn >> SAxes);
   (tVoid) (oIn >> TAxes);
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_3dAccHwInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SampleRate);
   (tVoid) (oOut << MountAngles);
   (tVoid) (oOut << RAxes);
   (tVoid) (oOut << SAxes);
   (tVoid) (oOut << TAxes);
   return oOut;
}

tBool sensor_fi_tcl_3dAccHwInfo::operator==(const sensor_fi_tcl_3dAccHwInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SampleRate == roRef.SampleRate);
   bResult = bResult && (MountAngles == roRef.MountAngles);
   bResult = bResult && (RAxes == roRef.RAxes);
   bResult = bResult && (SAxes == roRef.SAxes);
   bResult = bResult && (TAxes == roRef.TAxes);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_fi_tcl_3dGyroData::sensor_fi_tcl_3dGyroData(const sensor_fi_tcl_3dGyroData& coRef)
   : sensor_fi_tclVisitableTypeBase(coRef)
{
   TimeStamp3dGyro = coRef.TimeStamp3dGyro;
   RVal = coRef.RVal;
   SVal = coRef.SVal;
   TVal = coRef.TVal;
   RStatus = coRef.RStatus;
   SStatus = coRef.SStatus;
   TStatus = coRef.TStatus;
}
sensor_fi_tcl_3dGyroData& sensor_fi_tcl_3dGyroData::operator=(const sensor_fi_tcl_3dGyroData& coRef)
{
   if (this == &coRef) return *this;
   TimeStamp3dGyro = coRef.TimeStamp3dGyro;
   RVal = coRef.RVal;
   SVal = coRef.SVal;
   TVal = coRef.TVal;
   RStatus = coRef.RStatus;
   SStatus = coRef.SStatus;
   TStatus = coRef.TStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_3dGyroData::sensor_fi_tcl_3dGyroData()
:TimeStamp3dGyro(0)
,RVal(0)
,SVal(0)
,TVal(0)
,RStatus()
,SStatus()
,TStatus()
 {}

tS32 sensor_fi_tcl_3dGyroData::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_3DGYRODATA;
}


sensor_fi_tcl_3dGyroData::~sensor_fi_tcl_3dGyroData()
{}

tU32 sensor_fi_tcl_3dGyroData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 22;
}

fi_tclInContext& sensor_fi_tcl_3dGyroData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TimeStamp3dGyro);
   (tVoid) (oIn >> RVal);
   (tVoid) (oIn >> SVal);
   (tVoid) (oIn >> TVal);
   (tVoid) (oIn >> RStatus);
   (tVoid) (oIn >> SStatus);
   (tVoid) (oIn >> TStatus);
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_3dGyroData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TimeStamp3dGyro);
   (tVoid) (oOut << RVal);
   (tVoid) (oOut << SVal);
   (tVoid) (oOut << TVal);
   (tVoid) (oOut << RStatus);
   (tVoid) (oOut << SStatus);
   (tVoid) (oOut << TStatus);
   return oOut;
}

tBool sensor_fi_tcl_3dGyroData::operator==(const sensor_fi_tcl_3dGyroData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TimeStamp3dGyro == roRef.TimeStamp3dGyro);
   bResult = bResult && (RVal == roRef.RVal);
   bResult = bResult && (SVal == roRef.SVal);
   bResult = bResult && (TVal == roRef.TVal);
   bResult = bResult && (RStatus == roRef.RStatus);
   bResult = bResult && (SStatus == roRef.SStatus);
   bResult = bResult && (TStatus == roRef.TStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_fi_tcl_3dAccData::sensor_fi_tcl_3dAccData(const sensor_fi_tcl_3dAccData& coRef)
   : sensor_fi_tclVisitableTypeBase(coRef)
{
   TimeStamp3dAcc = coRef.TimeStamp3dAcc;
   RVal = coRef.RVal;
   SVal = coRef.SVal;
   TVal = coRef.TVal;
   RStatus = coRef.RStatus;
   SStatus = coRef.SStatus;
   TStatus = coRef.TStatus;
}
sensor_fi_tcl_3dAccData& sensor_fi_tcl_3dAccData::operator=(const sensor_fi_tcl_3dAccData& coRef)
{
   if (this == &coRef) return *this;
   TimeStamp3dAcc = coRef.TimeStamp3dAcc;
   RVal = coRef.RVal;
   SVal = coRef.SVal;
   TVal = coRef.TVal;
   RStatus = coRef.RStatus;
   SStatus = coRef.SStatus;
   TStatus = coRef.TStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_3dAccData::sensor_fi_tcl_3dAccData()
:TimeStamp3dAcc(0)
,RVal(0)
,SVal(0)
,TVal(0)
,RStatus()
,SStatus()
,TStatus()
 {}

tS32 sensor_fi_tcl_3dAccData::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_3DACCDATA;
}


sensor_fi_tcl_3dAccData::~sensor_fi_tcl_3dAccData()
{}

tU32 sensor_fi_tcl_3dAccData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 22;
}

fi_tclInContext& sensor_fi_tcl_3dAccData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TimeStamp3dAcc);
   (tVoid) (oIn >> RVal);
   (tVoid) (oIn >> SVal);
   (tVoid) (oIn >> TVal);
   (tVoid) (oIn >> RStatus);
   (tVoid) (oIn >> SStatus);
   (tVoid) (oIn >> TStatus);
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_3dAccData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TimeStamp3dAcc);
   (tVoid) (oOut << RVal);
   (tVoid) (oOut << SVal);
   (tVoid) (oOut << TVal);
   (tVoid) (oOut << RStatus);
   (tVoid) (oOut << SStatus);
   (tVoid) (oOut << TStatus);
   return oOut;
}

tBool sensor_fi_tcl_3dAccData::operator==(const sensor_fi_tcl_3dAccData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TimeStamp3dAcc == roRef.TimeStamp3dAcc);
   bResult = bResult && (RVal == roRef.RVal);
   bResult = bResult && (SVal == roRef.SVal);
   bResult = bResult && (TVal == roRef.TVal);
   bResult = bResult && (RStatus == roRef.RStatus);
   bResult = bResult && (SStatus == roRef.SStatus);
   bResult = bResult && (TStatus == roRef.TStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_e8_GnssHw::sensor_fi_tcl_e8_GnssHw():enType(FI_EN_GNSS_HW_UNKNOWN) {}

tS32 sensor_fi_tcl_e8_GnssHw::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_E8_GNSSHW;
}


sensor_fi_tcl_e8_GnssHw::~sensor_fi_tcl_e8_GnssHw()
{}

tU32 sensor_fi_tcl_e8_GnssHw::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_fi_tcl_e8_GnssHw::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_e8_GnssHw::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_b8_GnssSatSys::sensor_fi_tcl_b8_GnssSatSys():u8Value(0)
{}

tS32 sensor_fi_tcl_b8_GnssSatSys::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_B8_GNSSSATSYS;
}


sensor_fi_tcl_b8_GnssSatSys::~sensor_fi_tcl_b8_GnssSatSys()
{}

tU32 sensor_fi_tcl_b8_GnssSatSys::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_fi_tcl_b8_GnssSatSys::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& sensor_fi_tcl_b8_GnssSatSys::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_b8_GnssSatStatus::sensor_fi_tcl_b8_GnssSatStatus():u8Value(0)
{}

tS32 sensor_fi_tcl_b8_GnssSatStatus::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_B8_GNSSSATSTATUS;
}


sensor_fi_tcl_b8_GnssSatStatus::~sensor_fi_tcl_b8_GnssSatStatus()
{}

tU32 sensor_fi_tcl_b8_GnssSatStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_fi_tcl_b8_GnssSatStatus::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& sensor_fi_tcl_b8_GnssSatStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_fi_tcl_GnssConfigData::sensor_fi_tcl_GnssConfigData(const sensor_fi_tcl_GnssConfigData& coRef)
   : sensor_fi_tclVisitableTypeBase(coRef)
{
   GnssHardwareType = coRef.GnssHardwareType;
   GnssReceiverFirmwareVersion = coRef.GnssReceiverFirmwareVersion;
   GnssReceiverFirmwareCrc = coRef.GnssReceiverFirmwareCrc;
   NumberOfChannels = coRef.NumberOfChannels;
   UsedSatStatusBits = coRef.UsedSatStatusBits;
   UpdateFrequency = coRef.UpdateFrequency;
}
sensor_fi_tcl_GnssConfigData& sensor_fi_tcl_GnssConfigData::operator=(const sensor_fi_tcl_GnssConfigData& coRef)
{
   if (this == &coRef) return *this;
   GnssHardwareType = coRef.GnssHardwareType;
   GnssReceiverFirmwareVersion = coRef.GnssReceiverFirmwareVersion;
   GnssReceiverFirmwareCrc = coRef.GnssReceiverFirmwareCrc;
   NumberOfChannels = coRef.NumberOfChannels;
   UsedSatStatusBits = coRef.UsedSatStatusBits;
   UpdateFrequency = coRef.UpdateFrequency;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_GnssConfigData::sensor_fi_tcl_GnssConfigData()
:GnssHardwareType()
,GnssReceiverFirmwareVersion(0)
,GnssReceiverFirmwareCrc(0)
,NumberOfChannels(0)
,UsedSatStatusBits()
,UpdateFrequency(0)
 {}

tS32 sensor_fi_tcl_GnssConfigData::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_GNSSCONFIGDATA;
}


sensor_fi_tcl_GnssConfigData::~sensor_fi_tcl_GnssConfigData()
{}

tU32 sensor_fi_tcl_GnssConfigData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& sensor_fi_tcl_GnssConfigData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GnssHardwareType);
   (tVoid) (oIn >> GnssReceiverFirmwareVersion);
   (tVoid) (oIn >> GnssReceiverFirmwareCrc);
   (tVoid) (oIn >> NumberOfChannels);
   (tVoid) (oIn >> UsedSatStatusBits);
   (tVoid) (oIn >> UpdateFrequency);
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_GnssConfigData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GnssHardwareType);
   (tVoid) (oOut << GnssReceiverFirmwareVersion);
   (tVoid) (oOut << GnssReceiverFirmwareCrc);
   (tVoid) (oOut << NumberOfChannels);
   (tVoid) (oOut << UsedSatStatusBits);
   (tVoid) (oOut << UpdateFrequency);
   return oOut;
}

tBool sensor_fi_tcl_GnssConfigData::operator==(const sensor_fi_tcl_GnssConfigData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GnssHardwareType == roRef.GnssHardwareType);
   bResult = bResult && (GnssReceiverFirmwareVersion == roRef.GnssReceiverFirmwareVersion);
   bResult = bResult && (GnssReceiverFirmwareCrc == roRef.GnssReceiverFirmwareCrc);
   bResult = bResult && (NumberOfChannels == roRef.NumberOfChannels);
   bResult = bResult && (UsedSatStatusBits == roRef.UsedSatStatusBits);
   bResult = bResult && (UpdateFrequency == roRef.UpdateFrequency);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_e8_GnssQuality::sensor_fi_tcl_e8_GnssQuality():enType(FI_EN_GNSSQUALITY_UNKNOWN) {}

tS32 sensor_fi_tcl_e8_GnssQuality::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_E8_GNSSQUALITY;
}


sensor_fi_tcl_e8_GnssQuality::~sensor_fi_tcl_e8_GnssQuality()
{}

tU32 sensor_fi_tcl_e8_GnssQuality::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_fi_tcl_e8_GnssQuality::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_e8_GnssQuality::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_e8_GnssMode::sensor_fi_tcl_e8_GnssMode():enType(FI_EN_GNSSMODE_UNKNOWN) {}

tS32 sensor_fi_tcl_e8_GnssMode::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_E8_GNSSMODE;
}


sensor_fi_tcl_e8_GnssMode::~sensor_fi_tcl_e8_GnssMode()
{}

tU32 sensor_fi_tcl_e8_GnssMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_fi_tcl_e8_GnssMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_e8_GnssMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_fi_tcl_GnssStatus::sensor_fi_tcl_GnssStatus(const sensor_fi_tcl_GnssStatus& coRef)
   : sensor_fi_tclVisitableTypeBase(coRef)
{
   GnssQuality = coRef.GnssQuality;
   GnssMode = coRef.GnssMode;
}
sensor_fi_tcl_GnssStatus& sensor_fi_tcl_GnssStatus::operator=(const sensor_fi_tcl_GnssStatus& coRef)
{
   if (this == &coRef) return *this;
   GnssQuality = coRef.GnssQuality;
   GnssMode = coRef.GnssMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_GnssStatus::sensor_fi_tcl_GnssStatus()
:GnssQuality()
,GnssMode()
 {}

tS32 sensor_fi_tcl_GnssStatus::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_GNSSSTATUS;
}


sensor_fi_tcl_GnssStatus::~sensor_fi_tcl_GnssStatus()
{}

tU32 sensor_fi_tcl_GnssStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sensor_fi_tcl_GnssStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GnssQuality);
   (tVoid) (oIn >> GnssMode);
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_GnssStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GnssQuality);
   (tVoid) (oOut << GnssMode);
   return oOut;
}

tBool sensor_fi_tcl_GnssStatus::operator==(const sensor_fi_tcl_GnssStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GnssQuality == roRef.GnssQuality);
   bResult = bResult && (GnssMode == roRef.GnssMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_fi_tcl_CovarianceMatrixUpperTriangle::sensor_fi_tcl_CovarianceMatrixUpperTriangle(const sensor_fi_tcl_CovarianceMatrixUpperTriangle& coRef)
   : sensor_fi_tclVisitableTypeBase(coRef)
{
   Elem0 = coRef.Elem0;
   Elem4 = coRef.Elem4;
   Elem5 = coRef.Elem5;
   Elem8 = coRef.Elem8;
   Elem9 = coRef.Elem9;
   Elem10 = coRef.Elem10;
}
sensor_fi_tcl_CovarianceMatrixUpperTriangle& sensor_fi_tcl_CovarianceMatrixUpperTriangle::operator=(const sensor_fi_tcl_CovarianceMatrixUpperTriangle& coRef)
{
   if (this == &coRef) return *this;
   Elem0 = coRef.Elem0;
   Elem4 = coRef.Elem4;
   Elem5 = coRef.Elem5;
   Elem8 = coRef.Elem8;
   Elem9 = coRef.Elem9;
   Elem10 = coRef.Elem10;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_CovarianceMatrixUpperTriangle::sensor_fi_tcl_CovarianceMatrixUpperTriangle()
:Elem0(0)
,Elem4(0)
,Elem5(0)
,Elem8(0)
,Elem9(0)
,Elem10(0)
 {}

tS32 sensor_fi_tcl_CovarianceMatrixUpperTriangle::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_COVARIANCEMATRIXUPPERTRIANGLE;
}


sensor_fi_tcl_CovarianceMatrixUpperTriangle::~sensor_fi_tcl_CovarianceMatrixUpperTriangle()
{}

tU32 sensor_fi_tcl_CovarianceMatrixUpperTriangle::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 24;
}

fi_tclInContext& sensor_fi_tcl_CovarianceMatrixUpperTriangle::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Elem0);
   (tVoid) (oIn >> Elem4);
   (tVoid) (oIn >> Elem5);
   (tVoid) (oIn >> Elem8);
   (tVoid) (oIn >> Elem9);
   (tVoid) (oIn >> Elem10);
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_CovarianceMatrixUpperTriangle::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Elem0);
   (tVoid) (oOut << Elem4);
   (tVoid) (oOut << Elem5);
   (tVoid) (oOut << Elem8);
   (tVoid) (oOut << Elem9);
   (tVoid) (oOut << Elem10);
   return oOut;
}

tBool sensor_fi_tcl_CovarianceMatrixUpperTriangle::operator==(const sensor_fi_tcl_CovarianceMatrixUpperTriangle& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Elem0 == roRef.Elem0);
   bResult = bResult && (Elem4 == roRef.Elem4);
   bResult = bResult && (Elem5 == roRef.Elem5);
   bResult = bResult && (Elem8 == roRef.Elem8);
   bResult = bResult && (Elem9 == roRef.Elem9);
   bResult = bResult && (Elem10 == roRef.Elem10);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_fi_tcl_TimeDate::sensor_fi_tcl_TimeDate(const sensor_fi_tcl_TimeDate& coRef)
   : sensor_fi_tclVisitableTypeBase(coRef)
{
   td_year = coRef.td_year;
   td_month = coRef.td_month;
   td_day = coRef.td_day;
   td_hour = coRef.td_hour;
   td_minute = coRef.td_minute;
   td_second = coRef.td_second;
   td_milliSeconds = coRef.td_milliSeconds;
}
sensor_fi_tcl_TimeDate& sensor_fi_tcl_TimeDate::operator=(const sensor_fi_tcl_TimeDate& coRef)
{
   if (this == &coRef) return *this;
   td_year = coRef.td_year;
   td_month = coRef.td_month;
   td_day = coRef.td_day;
   td_hour = coRef.td_hour;
   td_minute = coRef.td_minute;
   td_second = coRef.td_second;
   td_milliSeconds = coRef.td_milliSeconds;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_TimeDate::sensor_fi_tcl_TimeDate()
:td_year(0)
,td_month(0)
,td_day(0)
,td_hour(0)
,td_minute(0)
,td_second(0)
,td_milliSeconds(0)
 {}

tS32 sensor_fi_tcl_TimeDate::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_TIMEDATE;
}


sensor_fi_tcl_TimeDate::~sensor_fi_tcl_TimeDate()
{}

tU32 sensor_fi_tcl_TimeDate::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& sensor_fi_tcl_TimeDate::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> td_year);
   (tVoid) (oIn >> td_month);
   (tVoid) (oIn >> td_day);
   (tVoid) (oIn >> td_hour);
   (tVoid) (oIn >> td_minute);
   (tVoid) (oIn >> td_second);
   (tVoid) (oIn >> td_milliSeconds);
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_TimeDate::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << td_year);
   (tVoid) (oOut << td_month);
   (tVoid) (oOut << td_day);
   (tVoid) (oOut << td_hour);
   (tVoid) (oOut << td_minute);
   (tVoid) (oOut << td_second);
   (tVoid) (oOut << td_milliSeconds);
   return oOut;
}

tBool sensor_fi_tcl_TimeDate::operator==(const sensor_fi_tcl_TimeDate& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (td_year == roRef.td_year);
   bResult = bResult && (td_month == roRef.td_month);
   bResult = bResult && (td_day == roRef.td_day);
   bResult = bResult && (td_hour == roRef.td_hour);
   bResult = bResult && (td_minute == roRef.td_minute);
   bResult = bResult && (td_second == roRef.td_second);
   bResult = bResult && (td_milliSeconds == roRef.td_milliSeconds);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_fi_tcl_GnssChanData::sensor_fi_tcl_GnssChanData(const sensor_fi_tcl_GnssChanData& coRef)
   : sensor_fi_tclVisitableTypeBase(coRef)
{
   SvId = coRef.SvId;
   SatStatus = coRef.SatStatus;
   Azimuth = coRef.Azimuth;
   Elevation = coRef.Elevation;
   CarrierToNoiseRatio = coRef.CarrierToNoiseRatio;
}
sensor_fi_tcl_GnssChanData& sensor_fi_tcl_GnssChanData::operator=(const sensor_fi_tcl_GnssChanData& coRef)
{
   if (this == &coRef) return *this;
   SvId = coRef.SvId;
   SatStatus = coRef.SatStatus;
   Azimuth = coRef.Azimuth;
   Elevation = coRef.Elevation;
   CarrierToNoiseRatio = coRef.CarrierToNoiseRatio;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_GnssChanData::sensor_fi_tcl_GnssChanData()
:SvId(0)
,SatStatus()
,Azimuth(0)
,Elevation(0)
,CarrierToNoiseRatio(0)
 {}

tS32 sensor_fi_tcl_GnssChanData::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_GNSSCHANDATA;
}


sensor_fi_tcl_GnssChanData::~sensor_fi_tcl_GnssChanData()
{}

tU32 sensor_fi_tcl_GnssChanData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& sensor_fi_tcl_GnssChanData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SvId);
   (tVoid) (oIn >> SatStatus);
   (tVoid) (oIn >> Azimuth);
   (tVoid) (oIn >> Elevation);
   (tVoid) (oIn >> CarrierToNoiseRatio);
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_GnssChanData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SvId);
   (tVoid) (oOut << SatStatus);
   (tVoid) (oOut << Azimuth);
   (tVoid) (oOut << Elevation);
   (tVoid) (oOut << CarrierToNoiseRatio);
   return oOut;
}

tBool sensor_fi_tcl_GnssChanData::operator==(const sensor_fi_tcl_GnssChanData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SvId == roRef.SvId);
   bResult = bResult && (SatStatus == roRef.SatStatus);
   bResult = bResult && (Azimuth == roRef.Azimuth);
   bResult = bResult && (Elevation == roRef.Elevation);
   bResult = bResult && (CarrierToNoiseRatio == roRef.CarrierToNoiseRatio);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_fi_tcl_GnssPvtData::sensor_fi_tcl_GnssPvtData(const sensor_fi_tcl_GnssPvtData& coRef)
   : sensor_fi_tclVisitableTypeBase(coRef)
{
   UtcTimeDate = coRef.UtcTimeDate;
   Latitude = coRef.Latitude;
   Longitude = coRef.Longitude;
   AltitudeWGS84 = coRef.AltitudeWGS84;
   GeoidalSeparation = coRef.GeoidalSeparation;
   VelocityNorth = coRef.VelocityNorth;
   VelocityEast = coRef.VelocityEast;
   VelocityUp = coRef.VelocityUp;
   PositionCovarianceMatrix = coRef.PositionCovarianceMatrix;
   VelocityCovarianceMatrix = coRef.VelocityCovarianceMatrix;
   GnssStatus = coRef.GnssStatus;
   GDOP = coRef.GDOP;
   PDOP = coRef.PDOP;
   HDOP = coRef.HDOP;
   TDOP = coRef.TDOP;
   VDOP = coRef.VDOP;
   SatSysUsed = coRef.SatSysUsed;
   SatellitesVisible = coRef.SatellitesVisible;
   SatellitesReceived = coRef.SatellitesReceived;
   SatellitesUsed = coRef.SatellitesUsed;
}
sensor_fi_tcl_GnssPvtData& sensor_fi_tcl_GnssPvtData::operator=(const sensor_fi_tcl_GnssPvtData& coRef)
{
   if (this == &coRef) return *this;
   UtcTimeDate = coRef.UtcTimeDate;
   Latitude = coRef.Latitude;
   Longitude = coRef.Longitude;
   AltitudeWGS84 = coRef.AltitudeWGS84;
   GeoidalSeparation = coRef.GeoidalSeparation;
   VelocityNorth = coRef.VelocityNorth;
   VelocityEast = coRef.VelocityEast;
   VelocityUp = coRef.VelocityUp;
   PositionCovarianceMatrix = coRef.PositionCovarianceMatrix;
   VelocityCovarianceMatrix = coRef.VelocityCovarianceMatrix;
   GnssStatus = coRef.GnssStatus;
   GDOP = coRef.GDOP;
   PDOP = coRef.PDOP;
   HDOP = coRef.HDOP;
   TDOP = coRef.TDOP;
   VDOP = coRef.VDOP;
   SatSysUsed = coRef.SatSysUsed;
   SatellitesVisible = coRef.SatellitesVisible;
   SatellitesReceived = coRef.SatellitesReceived;
   SatellitesUsed = coRef.SatellitesUsed;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_GnssPvtData::sensor_fi_tcl_GnssPvtData()
:UtcTimeDate()
,Latitude(0)
,Longitude(0)
,AltitudeWGS84(0)
,GeoidalSeparation(0)
,VelocityNorth(0)
,VelocityEast(0)
,VelocityUp(0)
,PositionCovarianceMatrix()
,VelocityCovarianceMatrix()
,GnssStatus()
,GDOP(0)
,PDOP(0)
,HDOP(0)
,TDOP(0)
,VDOP(0)
,SatSysUsed()
,SatellitesVisible(0)
,SatellitesReceived(0)
,SatellitesUsed(0)
 {}

tS32 sensor_fi_tcl_GnssPvtData::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_GNSSPVTDATA;
}


sensor_fi_tcl_GnssPvtData::~sensor_fi_tcl_GnssPvtData()
{}

tU32 sensor_fi_tcl_GnssPvtData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 122;
}

fi_tclInContext& sensor_fi_tcl_GnssPvtData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> UtcTimeDate);
   (tVoid) (oIn >> Latitude);
   (tVoid) (oIn >> Longitude);
   (tVoid) (oIn >> AltitudeWGS84);
   (tVoid) (oIn >> GeoidalSeparation);
   (tVoid) (oIn >> VelocityNorth);
   (tVoid) (oIn >> VelocityEast);
   (tVoid) (oIn >> VelocityUp);
   (tVoid) (oIn >> PositionCovarianceMatrix);
   (tVoid) (oIn >> VelocityCovarianceMatrix);
   (tVoid) (oIn >> GnssStatus);
   (tVoid) (oIn >> GDOP);
   (tVoid) (oIn >> PDOP);
   (tVoid) (oIn >> HDOP);
   (tVoid) (oIn >> TDOP);
   (tVoid) (oIn >> VDOP);
   (tVoid) (oIn >> SatSysUsed);
   (tVoid) (oIn >> SatellitesVisible);
   (tVoid) (oIn >> SatellitesReceived);
   (tVoid) (oIn >> SatellitesUsed);
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_GnssPvtData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << UtcTimeDate);
   (tVoid) (oOut << Latitude);
   (tVoid) (oOut << Longitude);
   (tVoid) (oOut << AltitudeWGS84);
   (tVoid) (oOut << GeoidalSeparation);
   (tVoid) (oOut << VelocityNorth);
   (tVoid) (oOut << VelocityEast);
   (tVoid) (oOut << VelocityUp);
   (tVoid) (oOut << PositionCovarianceMatrix);
   (tVoid) (oOut << VelocityCovarianceMatrix);
   (tVoid) (oOut << GnssStatus);
   (tVoid) (oOut << GDOP);
   (tVoid) (oOut << PDOP);
   (tVoid) (oOut << HDOP);
   (tVoid) (oOut << TDOP);
   (tVoid) (oOut << VDOP);
   (tVoid) (oOut << SatSysUsed);
   (tVoid) (oOut << SatellitesVisible);
   (tVoid) (oOut << SatellitesReceived);
   (tVoid) (oOut << SatellitesUsed);
   return oOut;
}

tBool sensor_fi_tcl_GnssPvtData::operator==(const sensor_fi_tcl_GnssPvtData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UtcTimeDate == roRef.UtcTimeDate);
   bResult = bResult && (Latitude == roRef.Latitude);
   bResult = bResult && (Longitude == roRef.Longitude);
   bResult = bResult && (AltitudeWGS84 == roRef.AltitudeWGS84);
   bResult = bResult && (GeoidalSeparation == roRef.GeoidalSeparation);
   bResult = bResult && (VelocityNorth == roRef.VelocityNorth);
   bResult = bResult && (VelocityEast == roRef.VelocityEast);
   bResult = bResult && (VelocityUp == roRef.VelocityUp);
   bResult = bResult && (PositionCovarianceMatrix == roRef.PositionCovarianceMatrix);
   bResult = bResult && (VelocityCovarianceMatrix == roRef.VelocityCovarianceMatrix);
   bResult = bResult && (GnssStatus == roRef.GnssStatus);
   bResult = bResult && (GDOP == roRef.GDOP);
   bResult = bResult && (PDOP == roRef.PDOP);
   bResult = bResult && (HDOP == roRef.HDOP);
   bResult = bResult && (TDOP == roRef.TDOP);
   bResult = bResult && (VDOP == roRef.VDOP);
   bResult = bResult && (SatSysUsed == roRef.SatSysUsed);
   bResult = bResult && (SatellitesVisible == roRef.SatellitesVisible);
   bResult = bResult && (SatellitesReceived == roRef.SatellitesReceived);
   bResult = bResult && (SatellitesUsed == roRef.SatellitesUsed);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_fi_tcl_GnssData::sensor_fi_tcl_GnssData(const sensor_fi_tcl_GnssData& coRef)
   : sensor_fi_tclVisitableTypeBase(coRef)
{
   Timestamp = coRef.Timestamp;
   GnssPvtData = coRef.GnssPvtData;
   GnssChanDataList = coRef.GnssChanDataList;
}
sensor_fi_tcl_GnssData& sensor_fi_tcl_GnssData::operator=(const sensor_fi_tcl_GnssData& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   GnssPvtData = coRef.GnssPvtData;
   GnssChanDataList = coRef.GnssChanDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sensor_fi_tcl_GnssData::vDestroy()
{
   GnssPvtData.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < GnssChanDataList.size(); ++u32Idx)
         GnssChanDataList[u32Idx].vDestroy();
   GnssChanDataList.clear();
   }
}

sensor_fi_tcl_GnssData::sensor_fi_tcl_GnssData()
:Timestamp(0)
,GnssPvtData()

 {}

tS32 sensor_fi_tcl_GnssData::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_GNSSDATA;
}


sensor_fi_tcl_GnssData::~sensor_fi_tcl_GnssData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sensor_fi_tcl_GnssData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 130+GnssChanDataList.size()*12;
}

fi_tclInContext& sensor_fi_tcl_GnssData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> GnssPvtData);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < GnssChanDataList.size(); ++u32Idx)
      {
         GnssChanDataList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      GnssChanDataList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> GnssChanDataList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_GnssData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << GnssPvtData);
   (tVoid) (oOut << (tU32)GnssChanDataList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < GnssChanDataList.size(); ++u32Idx)
         (tVoid) (oOut << GnssChanDataList[u32Idx]);
   }
   return oOut;
}

tBool sensor_fi_tcl_GnssData::operator==(const sensor_fi_tcl_GnssData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (GnssPvtData == roRef.GnssPvtData);
      bResult = bResult && (GnssChanDataList.size() == roRef.GnssChanDataList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < GnssChanDataList.size()); ++u32Idx)
            bResult = bResult && (GnssChanDataList[u32Idx] == roRef.GnssChanDataList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_e8_timeMode::sensor_fi_tcl_e8_timeMode():enType(FI_EN_TIMEMODE_DEFAULT) {}

tS32 sensor_fi_tcl_e8_timeMode::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_E8_TIMEMODE;
}


sensor_fi_tcl_e8_timeMode::~sensor_fi_tcl_e8_timeMode()
{}

tU32 sensor_fi_tcl_e8_timeMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_fi_tcl_e8_timeMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_e8_timeMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_e8_DefSetGroups::sensor_fi_tcl_e8_DefSetGroups():enType(FI_EN_DEFSET_GROUP_MAINTENANCE) {}

tS32 sensor_fi_tcl_e8_DefSetGroups::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_E8_DEFSETGROUPS;
}


sensor_fi_tcl_e8_DefSetGroups::~sensor_fi_tcl_e8_DefSetGroups()
{}

tU32 sensor_fi_tcl_e8_DefSetGroups::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_fi_tcl_e8_DefSetGroups::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_e8_DefSetGroups::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_e8_DefSetMode::sensor_fi_tcl_e8_DefSetMode():enType(FI_EN_DEFSET_SRC_CODING) {}

tS32 sensor_fi_tcl_e8_DefSetMode::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_E8_DEFSETMODE;
}


sensor_fi_tcl_e8_DefSetMode::~sensor_fi_tcl_e8_DefSetMode()
{}

tU32 sensor_fi_tcl_e8_DefSetMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_fi_tcl_e8_DefSetMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_e8_DefSetMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_fi_tcl_AllSensorData::sensor_fi_tcl_AllSensorData(const sensor_fi_tcl_AllSensorData& coRef)
   : sensor_fi_tclVisitableTypeBase(coRef)
{
   GnssUpdate = coRef.GnssUpdate;
   OdometerUpdate = coRef.OdometerUpdate;
   AbsUpdate = coRef.AbsUpdate;
   GyroUpdate = coRef.GyroUpdate;
   GyroTemperature = coRef.GyroTemperature;
   AccUpdate = coRef.AccUpdate;
   AccTemperature = coRef.AccTemperature;
}
sensor_fi_tcl_AllSensorData& sensor_fi_tcl_AllSensorData::operator=(const sensor_fi_tcl_AllSensorData& coRef)
{
   if (this == &coRef) return *this;
   GnssUpdate = coRef.GnssUpdate;
   OdometerUpdate = coRef.OdometerUpdate;
   AbsUpdate = coRef.AbsUpdate;
   GyroUpdate = coRef.GyroUpdate;
   GyroTemperature = coRef.GyroTemperature;
   AccUpdate = coRef.AccUpdate;
   AccTemperature = coRef.AccTemperature;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sensor_fi_tcl_AllSensorData::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < GnssUpdate.size(); ++u32Idx)
         GnssUpdate[u32Idx].vDestroy();
   GnssUpdate.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < OdometerUpdate.size(); ++u32Idx)
         OdometerUpdate[u32Idx].vDestroy();
   OdometerUpdate.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < AbsUpdate.size(); ++u32Idx)
         AbsUpdate[u32Idx].vDestroy();
   AbsUpdate.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < GyroUpdate.size(); ++u32Idx)
         GyroUpdate[u32Idx].vDestroy();
   GyroUpdate.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < AccUpdate.size(); ++u32Idx)
         AccUpdate[u32Idx].vDestroy();
   AccUpdate.clear();
   }
}

sensor_fi_tcl_AllSensorData::sensor_fi_tcl_AllSensorData()




:GyroTemperature(0)

,AccTemperature(0)
 {}

tS32 sensor_fi_tcl_AllSensorData::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_ALLSENSORDATA;
}


sensor_fi_tcl_AllSensorData::~sensor_fi_tcl_AllSensorData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sensor_fi_tcl_AllSensorData::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < GnssUpdate.size(); ++u32ListIdx)
      u32DynamicSize += GnssUpdate[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+28+OdometerUpdate.size()*8+AbsUpdate.size()*20+GyroUpdate.size()*22+AccUpdate.size()*22;
}

fi_tclInContext& sensor_fi_tcl_AllSensorData::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < GnssUpdate.size(); ++u32Idx)
      {
         GnssUpdate[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      GnssUpdate.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> GnssUpdate[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < OdometerUpdate.size(); ++u32Idx)
      {
         OdometerUpdate[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      OdometerUpdate.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> OdometerUpdate[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AbsUpdate.size(); ++u32Idx)
      {
         AbsUpdate[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AbsUpdate.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AbsUpdate[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < GyroUpdate.size(); ++u32Idx)
      {
         GyroUpdate[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      GyroUpdate.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> GyroUpdate[u32Idx]);
      }
   }
   (tVoid) (oIn >> GyroTemperature);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AccUpdate.size(); ++u32Idx)
      {
         AccUpdate[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AccUpdate.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AccUpdate[u32Idx]);
      }
   }
   (tVoid) (oIn >> AccTemperature);
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_AllSensorData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)GnssUpdate.size());
   {
      for (tU32 u32Idx = 0; u32Idx < GnssUpdate.size(); ++u32Idx)
         (tVoid) (oOut << GnssUpdate[u32Idx]);
   }
   (tVoid) (oOut << (tU32)OdometerUpdate.size());
   {
      for (tU32 u32Idx = 0; u32Idx < OdometerUpdate.size(); ++u32Idx)
         (tVoid) (oOut << OdometerUpdate[u32Idx]);
   }
   (tVoid) (oOut << (tU32)AbsUpdate.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AbsUpdate.size(); ++u32Idx)
         (tVoid) (oOut << AbsUpdate[u32Idx]);
   }
   (tVoid) (oOut << (tU32)GyroUpdate.size());
   {
      for (tU32 u32Idx = 0; u32Idx < GyroUpdate.size(); ++u32Idx)
         (tVoid) (oOut << GyroUpdate[u32Idx]);
   }
   (tVoid) (oOut << GyroTemperature);
   (tVoid) (oOut << (tU32)AccUpdate.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AccUpdate.size(); ++u32Idx)
         (tVoid) (oOut << AccUpdate[u32Idx]);
   }
   (tVoid) (oOut << AccTemperature);
   return oOut;
}

tBool sensor_fi_tcl_AllSensorData::operator==(const sensor_fi_tcl_AllSensorData& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (GnssUpdate.size() == roRef.GnssUpdate.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < GnssUpdate.size()); ++u32Idx)
            bResult = bResult && (GnssUpdate[u32Idx] == roRef.GnssUpdate[u32Idx]);
      }
      bResult = bResult && (OdometerUpdate.size() == roRef.OdometerUpdate.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OdometerUpdate.size()); ++u32Idx)
            bResult = bResult && (OdometerUpdate[u32Idx] == roRef.OdometerUpdate[u32Idx]);
      }
      bResult = bResult && (AbsUpdate.size() == roRef.AbsUpdate.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AbsUpdate.size()); ++u32Idx)
            bResult = bResult && (AbsUpdate[u32Idx] == roRef.AbsUpdate[u32Idx]);
      }
      bResult = bResult && (GyroUpdate.size() == roRef.GyroUpdate.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < GyroUpdate.size()); ++u32Idx)
            bResult = bResult && (GyroUpdate[u32Idx] == roRef.GyroUpdate[u32Idx]);
      }
   bResult = bResult && (GyroTemperature == roRef.GyroTemperature);
      bResult = bResult && (AccUpdate.size() == roRef.AccUpdate.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AccUpdate.size()); ++u32Idx)
            bResult = bResult && (AccUpdate[u32Idx] == roRef.AccUpdate[u32Idx]);
      }
   bResult = bResult && (AccTemperature == roRef.AccTemperature);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_e8_velocity_source::sensor_fi_tcl_e8_velocity_source():enType(FI_EN_SRC_V_INVALID) {}

tS32 sensor_fi_tcl_e8_velocity_source::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_E8_VELOCITY_SOURCE;
}


sensor_fi_tcl_e8_velocity_source::~sensor_fi_tcl_e8_velocity_source()
{}

tU32 sensor_fi_tcl_e8_velocity_source::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_fi_tcl_e8_velocity_source::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_e8_velocity_source::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_e8_position_source::sensor_fi_tcl_e8_position_source():enType(FI_EN_SRC_POS_INVALID) {}

tS32 sensor_fi_tcl_e8_position_source::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_E8_POSITION_SOURCE;
}


sensor_fi_tcl_e8_position_source::~sensor_fi_tcl_e8_position_source()
{}

tU32 sensor_fi_tcl_e8_position_source::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_fi_tcl_e8_position_source::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_e8_position_source::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_e8_countrycode_source::sensor_fi_tcl_e8_countrycode_source():enType(FI_EN_SRC_CC_INVALID) {}

tS32 sensor_fi_tcl_e8_countrycode_source::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_E8_COUNTRYCODE_SOURCE;
}


sensor_fi_tcl_e8_countrycode_source::~sensor_fi_tcl_e8_countrycode_source()
{}

tU32 sensor_fi_tcl_e8_countrycode_source::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_fi_tcl_e8_countrycode_source::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_e8_countrycode_source::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_e8_timezone_source::sensor_fi_tcl_e8_timezone_source():enType(FI_EN_SRC_TZ_INVALID) {}

tS32 sensor_fi_tcl_e8_timezone_source::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_E8_TIMEZONE_SOURCE;
}


sensor_fi_tcl_e8_timezone_source::~sensor_fi_tcl_e8_timezone_source()
{}

tU32 sensor_fi_tcl_e8_timezone_source::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_fi_tcl_e8_timezone_source::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_e8_timezone_source::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_e8_deadreckoning_info_source::sensor_fi_tcl_e8_deadreckoning_info_source():enType(FI_EN_SRC_DRPOS_INVALID) {}

tS32 sensor_fi_tcl_e8_deadreckoning_info_source::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_E8_DEADRECKONING_INFO_SOURCE;
}


sensor_fi_tcl_e8_deadreckoning_info_source::~sensor_fi_tcl_e8_deadreckoning_info_source()
{}

tU32 sensor_fi_tcl_e8_deadreckoning_info_source::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_fi_tcl_e8_deadreckoning_info_source::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_e8_deadreckoning_info_source::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_b16_deadreckoning_info_validity::sensor_fi_tcl_b16_deadreckoning_info_validity():u16Value(0)
{}

tS32 sensor_fi_tcl_b16_deadreckoning_info_validity::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_B16_DEADRECKONING_INFO_VALIDITY;
}


sensor_fi_tcl_b16_deadreckoning_info_validity::~sensor_fi_tcl_b16_deadreckoning_info_validity()
{}

tU32 sensor_fi_tcl_b16_deadreckoning_info_validity::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sensor_fi_tcl_b16_deadreckoning_info_validity::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& sensor_fi_tcl_b16_deadreckoning_info_validity::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_s32_pv_Second::sensor_fi_tcl_s32_pv_Second(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sensor_fi_tcl_s32_pv_Second::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_S32_PV_SECOND;
}


sensor_fi_tcl_s32_pv_Second::~sensor_fi_tcl_s32_pv_Second()
{}

tU32 sensor_fi_tcl_s32_pv_Second::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sensor_fi_tcl_s32_pv_Second::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sensor_fi_tcl_s32_pv_Second::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_e8_pv_DST_State::sensor_fi_tcl_e8_pv_DST_State():enType(FI_EN_PV_STANDARD_TIME) {}

tS32 sensor_fi_tcl_e8_pv_DST_State::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_E8_PV_DST_STATE;
}


sensor_fi_tcl_e8_pv_DST_State::~sensor_fi_tcl_e8_pv_DST_State()
{}

tU32 sensor_fi_tcl_e8_pv_DST_State::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_fi_tcl_e8_pv_DST_State::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_e8_pv_DST_State::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_fi_tcl_pv_TimeZone::sensor_fi_tcl_pv_TimeZone(const sensor_fi_tcl_pv_TimeZone& coRef)
   : sensor_fi_tclVisitableTypeBase(coRef)
{
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
}
sensor_fi_tcl_pv_TimeZone& sensor_fi_tcl_pv_TimeZone::operator=(const sensor_fi_tcl_pv_TimeZone& coRef)
{
   if (this == &coRef) return *this;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_pv_TimeZone::sensor_fi_tcl_pv_TimeZone()
:TimeZoneDifference()
,DST_State()
,DSTDifference()
 {}

tS32 sensor_fi_tcl_pv_TimeZone::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_PV_TIMEZONE;
}


sensor_fi_tcl_pv_TimeZone::~sensor_fi_tcl_pv_TimeZone()
{}

tU32 sensor_fi_tcl_pv_TimeZone::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& sensor_fi_tcl_pv_TimeZone::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TimeZoneDifference);
   (tVoid) (oIn >> DST_State);
   (tVoid) (oIn >> DSTDifference);
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_pv_TimeZone::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TimeZoneDifference);
   (tVoid) (oOut << DST_State);
   (tVoid) (oOut << DSTDifference);
   return oOut;
}

tBool sensor_fi_tcl_pv_TimeZone::operator==(const sensor_fi_tcl_pv_TimeZone& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TimeZoneDifference == roRef.TimeZoneDifference);
   bResult = bResult && (DST_State == roRef.DST_State);
   bResult = bResult && (DSTDifference == roRef.DSTDifference);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_e16_pv_ISOCountryCode::sensor_fi_tcl_e16_pv_ISOCountryCode():enType(FI_EN_ISO_ALPHA_3_UNDEFINED) {}

tS32 sensor_fi_tcl_e16_pv_ISOCountryCode::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_E16_PV_ISOCOUNTRYCODE;
}


sensor_fi_tcl_e16_pv_ISOCountryCode::~sensor_fi_tcl_e16_pv_ISOCountryCode()
{}

tU32 sensor_fi_tcl_e16_pv_ISOCountryCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sensor_fi_tcl_e16_pv_ISOCountryCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_e16_pv_ISOCountryCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_fi_tcl_mount_angles::sensor_fi_tcl_mount_angles(const sensor_fi_tcl_mount_angles& coRef)
   : sensor_fi_tclVisitableTypeBase(coRef)
{
   AngRX = coRef.AngRX;
   AngRY = coRef.AngRY;
   AngRZ = coRef.AngRZ;
   AngSX = coRef.AngSX;
   AngSY = coRef.AngSY;
   AngSZ = coRef.AngSZ;
   AngTX = coRef.AngTX;
   AngTY = coRef.AngTY;
   AngTZ = coRef.AngTZ;
}
sensor_fi_tcl_mount_angles& sensor_fi_tcl_mount_angles::operator=(const sensor_fi_tcl_mount_angles& coRef)
{
   if (this == &coRef) return *this;
   AngRX = coRef.AngRX;
   AngRY = coRef.AngRY;
   AngRZ = coRef.AngRZ;
   AngSX = coRef.AngSX;
   AngSY = coRef.AngSY;
   AngSZ = coRef.AngSZ;
   AngTX = coRef.AngTX;
   AngTY = coRef.AngTY;
   AngTZ = coRef.AngTZ;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_mount_angles::sensor_fi_tcl_mount_angles()
:AngRX(0)
,AngRY(0)
,AngRZ(0)
,AngSX(0)
,AngSY(0)
,AngSZ(0)
,AngTX(0)
,AngTY(0)
,AngTZ(0)
 {}

tS32 sensor_fi_tcl_mount_angles::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_MOUNT_ANGLES;
}


sensor_fi_tcl_mount_angles::~sensor_fi_tcl_mount_angles()
{}

tU32 sensor_fi_tcl_mount_angles::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& sensor_fi_tcl_mount_angles::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AngRX);
   (tVoid) (oIn >> AngRY);
   (tVoid) (oIn >> AngRZ);
   (tVoid) (oIn >> AngSX);
   (tVoid) (oIn >> AngSY);
   (tVoid) (oIn >> AngSZ);
   (tVoid) (oIn >> AngTX);
   (tVoid) (oIn >> AngTY);
   (tVoid) (oIn >> AngTZ);
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_mount_angles::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AngRX);
   (tVoid) (oOut << AngRY);
   (tVoid) (oOut << AngRZ);
   (tVoid) (oOut << AngSX);
   (tVoid) (oOut << AngSY);
   (tVoid) (oOut << AngSZ);
   (tVoid) (oOut << AngTX);
   (tVoid) (oOut << AngTY);
   (tVoid) (oOut << AngTZ);
   return oOut;
}

tBool sensor_fi_tcl_mount_angles::operator==(const sensor_fi_tcl_mount_angles& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AngRX == roRef.AngRX);
   bResult = bResult && (AngRY == roRef.AngRY);
   bResult = bResult && (AngRZ == roRef.AngRZ);
   bResult = bResult && (AngSX == roRef.AngSX);
   bResult = bResult && (AngSY == roRef.AngSY);
   bResult = bResult && (AngSZ == roRef.AngSZ);
   bResult = bResult && (AngTX == roRef.AngTX);
   bResult = bResult && (AngTY == roRef.AngTY);
   bResult = bResult && (AngTZ == roRef.AngTZ);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_fi_tcl_e8_mounting_source::sensor_fi_tcl_e8_mounting_source():enType(FI_EN_SRC_MOUNTING_INVALID) {}

tS32 sensor_fi_tcl_e8_mounting_source::s32GetTypeId() const
{
   return (tS32) sensor_typesfi_tclToken::EN_E8_MOUNTING_SOURCE;
}


sensor_fi_tcl_e8_mounting_source::~sensor_fi_tcl_e8_mounting_source()
{}

tU32 sensor_fi_tcl_e8_mounting_source::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_fi_tcl_e8_mounting_source::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sensor_fi_tcl_e8_mounting_source::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

