#ifndef SENSOR_FIVISITOR_HEADER
#define SENSOR_FIVISITOR_HEADER

// --Basisklasse fuer eine FI-Besucher-Klasse

class sensor_fi_tclOutput {
public:
   sensor_fi_tclOutput();
   virtual ~sensor_fi_tclOutput(){};

   virtual tVoid vPrintLine(tCString coszLine) = 0;
};

class sensor_fi_tclFileOutput : public sensor_fi_tclOutput 
{
public:
   sensor_fi_tclFileOutput(OSAL_tIODescriptor rIOD):fd(rIOD) {}
   virtual tVoid vPrintLine(tCString coszLine);
protected:
   OSAL_tIODescriptor fd;
private:
   sensor_fi_tclFileOutput(); //lint !e1704
   sensor_fi_tclFileOutput& operator=(const sensor_fi_tclFileOutput& coRef);
   sensor_fi_tclFileOutput(const sensor_fi_tclFileOutput& coRef); //lint !e1704
};

class sensor_fi_tclMemOutput : public sensor_fi_tclOutput
{
public:
   sensor_fi_tclMemOutput(tU32 u32MemSize);
   virtual ~sensor_fi_tclMemOutput();
   virtual tVoid vPrintLine(tCString coszLine);
   tString szGetBuffer();
protected:
   tChar* szBuf;
   tChar* szEndBuf;
   tChar* s8BufPos;
private:
   sensor_fi_tclMemOutput(); //lint !e1704
   sensor_fi_tclMemOutput(const sensor_fi_tclMemOutput& coRef); //lint !e1704
   sensor_fi_tclMemOutput& operator=(const sensor_fi_tclMemOutput& coRef); //lint !e1704
};

class MY_DECL sensor_fi_tclVisitorBase {
public:

   // --Konstruktor
   sensor_fi_tclVisitorBase():bBreakNow(FALSE),bIsVisitorValid(FALSE) {}
   virtual ~sensor_fi_tclVisitorBase() {}

   tBool bIsValid() const { return bIsVisitorValid; }
   tVoid vInvalidate() { bIsVisitorValid=FALSE; }
   tVoid vValidate() { bIsVisitorValid=TRUE; }
   tBool bBreak() const { return bBreakNow; }
   tVoid vReleaseBreak() { bBreakNow = FALSE; }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(sensor_fi_tclU8& oU8);
   virtual tVoid vVisitS8(sensor_fi_tclS8& oS8);
   virtual tVoid vVisitU16(sensor_fi_tclU16& oU16);
   virtual tVoid vVisitS16(sensor_fi_tclS16& oS16);
   virtual tVoid vVisitU24(sensor_fi_tclU24& oU24);
   virtual tVoid vVisitS24(sensor_fi_tclS24& oS24);
   virtual tVoid vVisitU32(sensor_fi_tclU32& oU32);
   virtual tVoid vVisitS32(sensor_fi_tclS32& oS32);
   virtual tVoid vVisitU64(sensor_fi_tclU64& oU64);
   virtual tVoid vVisitS64(sensor_fi_tclS64& oS64);
   virtual tVoid vVisitF32(sensor_fi_tclF32& oF32);
   virtual tVoid vVisitF64(sensor_fi_tclF64& oF64);
   virtual tVoid vVisitBool(sensor_fi_tclBool& oBool);
   virtual tVoid vVisitString(sensor_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(sensor_fi_tclMultiLanguageString& oString);

   virtual tVoid vVisitList(sensor_fi_tclList& oList);
   virtual tVoid vVisit_BinContainer(sensor_fi_tcl_BinContainer& oBinContainer);

   virtual tVoid vVisit_Reserved(sensor_fi_tcl_Reserved& oReserved);

   virtual tVoid vVisit_u8_Percent(sensor_fi_tcl_u8_Percent& ou8_Percent);

   virtual tVoid vVisit_s16_PerThousand(sensor_fi_tcl_s16_PerThousand& os16_PerThousand);

   virtual tVoid vVisit_u16_IndexInReferenceList(sensor_fi_tcl_u16_IndexInReferenceList& ou16_IndexInReferenceList);

   virtual tVoid vVisit_u16_ErrorCode(sensor_fi_tcl_u16_ErrorCode& ou16_ErrorCode);

   virtual tVoid vVisit_u16_RPM(sensor_fi_tcl_u16_RPM& ou16_RPM);

   virtual tVoid vVisit_s32_Kilogram(sensor_fi_tcl_s32_Kilogram& os32_Kilogram);

   virtual tVoid vVisit_s32_Pound(sensor_fi_tcl_s32_Pound& os32_Pound);

   virtual tVoid vVisit_s16_Meter(sensor_fi_tcl_s16_Meter& os16_Meter);

   virtual tVoid vVisit_s32_Meter(sensor_fi_tcl_s32_Meter& os32_Meter);

   virtual tVoid vVisit_s32_Yards(sensor_fi_tcl_s32_Yards& os32_Yards);

   virtual tVoid vVisit_s32_Foot(sensor_fi_tcl_s32_Foot& os32_Foot);

   virtual tVoid vVisit_s32_Centimeter(sensor_fi_tcl_s32_Centimeter& os32_Centimeter);

   virtual tVoid vVisit_s32_Inch(sensor_fi_tcl_s32_Inch& os32_Inch);

   virtual tVoid vVisit_s32_Millimeter(sensor_fi_tcl_s32_Millimeter& os32_Millimeter);

   virtual tVoid vVisit_s32_Microliter(sensor_fi_tcl_s32_Microliter& os32_Microliter);

   virtual tVoid vVisit_s32_Second(sensor_fi_tcl_s32_Second& os32_Second);

   virtual tVoid vVisit_u16_MilliSecond(sensor_fi_tcl_u16_MilliSecond& ou16_MilliSecond);

   virtual tVoid vVisit_s32_MilliSecond(sensor_fi_tcl_s32_MilliSecond& os32_MilliSecond);

   virtual tVoid vVisit_POSIXTime(sensor_fi_tcl_POSIXTime& oPOSIXTime);

   virtual tVoid vVisit_e8_DST_State(sensor_fi_tcl_e8_DST_State& oe8_DST_State);

   virtual tVoid vVisit_TimeZoneElement(sensor_fi_tcl_TimeZoneElement& oTimeZoneElement);

   virtual tVoid vVisit_s16_KmPerHour(sensor_fi_tcl_s16_KmPerHour& os16_KmPerHour);

   virtual tVoid vVisit_s16_MilesPerHour(sensor_fi_tcl_s16_MilesPerHour& os16_MilesPerHour);

   virtual tVoid vVisit_s16_Knot(sensor_fi_tcl_s16_Knot& os16_Knot);

   virtual tVoid vVisit_s16_CentimeterSecond(sensor_fi_tcl_s16_CentimeterSecond& os16_CentimeterSecond);

   virtual tVoid vVisit_s16_Kelvin(sensor_fi_tcl_s16_Kelvin& os16_Kelvin);

   virtual tVoid vVisit_s16_Fahrenheit(sensor_fi_tcl_s16_Fahrenheit& os16_Fahrenheit);

   virtual tVoid vVisit_s32_Pascal(sensor_fi_tcl_s32_Pascal& os32_Pascal);

   virtual tVoid vVisit_s32_Watt(sensor_fi_tcl_s32_Watt& os32_Watt);

   virtual tVoid vVisit_FIVersion(sensor_fi_tcl_FIVersion& oFIVersion);

   virtual tVoid vVisit_s32_Longitude(sensor_fi_tcl_s32_Longitude& os32_Longitude);

   virtual tVoid vVisit_s32_Latitude(sensor_fi_tcl_s32_Latitude& os32_Latitude);

   virtual tVoid vVisit_PositionWGS84(sensor_fi_tcl_PositionWGS84& oPositionWGS84);

   virtual tVoid vVisit_RectangleWGS84(sensor_fi_tcl_RectangleWGS84& oRectangleWGS84);

   virtual tVoid vVisit_e16_ISOCountryCode(sensor_fi_tcl_e16_ISOCountryCode& oe16_ISOCountryCode);

   virtual tVoid vVisit_e16_ISOLanguageCode(sensor_fi_tcl_e16_ISOLanguageCode& oe16_ISOLanguageCode);

   virtual tVoid vVisit_LanguageID(sensor_fi_tcl_LanguageID& oLanguageID);

   virtual tVoid vVisit_u8_DirectionAbsolute(sensor_fi_tcl_u8_DirectionAbsolute& ou8_DirectionAbsolute);

   virtual tVoid vVisit_u8_DirectionRelative(sensor_fi_tcl_u8_DirectionRelative& ou8_DirectionRelative);

   virtual tVoid vVisit_s16_CentiDegree(sensor_fi_tcl_s16_CentiDegree& os16_CentiDegree);

   virtual tVoid vVisit_s16_Degree(sensor_fi_tcl_s16_Degree& os16_Degree);

   virtual tVoid vVisit_u16_DirectionAbsolute_CentiDegree(sensor_fi_tcl_u16_DirectionAbsolute_CentiDegree& ou16_DirectionAbsolute_CentiDegree);

   virtual tVoid vVisit_s16_DirectionRelative_CentiDegree(sensor_fi_tcl_s16_DirectionRelative_CentiDegree& os16_DirectionRelative_CentiDegree);

   virtual tVoid vVisit_e8_FuelType(sensor_fi_tcl_e8_FuelType& oe8_FuelType);

   virtual tVoid vVisit_DistTimeFuel(sensor_fi_tcl_DistTimeFuel& oDistTimeFuel);

   virtual tVoid vVisit_VdsVersionInfo(sensor_fi_tcl_VdsVersionInfo& oVdsVersionInfo);

   virtual tVoid vVisit_e8_OdometerStatus(sensor_fi_tcl_e8_OdometerStatus& oe8_OdometerStatus);

   virtual tVoid vVisit_e8_OdometerDirection(sensor_fi_tcl_e8_OdometerDirection& oe8_OdometerDirection);

   virtual tVoid vVisit_OdometerData(sensor_fi_tcl_OdometerData& oOdometerData);

   virtual tVoid vVisit_e8_AbsStatus(sensor_fi_tcl_e8_AbsStatus& oe8_AbsStatus);

   virtual tVoid vVisit_e8_AbsDirection(sensor_fi_tcl_e8_AbsDirection& oe8_AbsDirection);

   virtual tVoid vVisit_AbsData(sensor_fi_tcl_AbsData& oAbsData);

   virtual tVoid vVisit_SensorHwInfo(sensor_fi_tcl_SensorHwInfo& oSensorHwInfo);

   virtual tVoid vVisit_3dMountAngles(sensor_fi_tcl_3dMountAngles& o3dMountAngles);

   virtual tVoid vVisit_e16_GyroStatus(sensor_fi_tcl_e16_GyroStatus& oe16_GyroStatus);

   virtual tVoid vVisit_e16_AccStatus(sensor_fi_tcl_e16_AccStatus& oe16_AccStatus);

   virtual tVoid vVisit_3dGyroHwInfo(sensor_fi_tcl_3dGyroHwInfo& o3dGyroHwInfo);

   virtual tVoid vVisit_3dAccHwInfo(sensor_fi_tcl_3dAccHwInfo& o3dAccHwInfo);

   virtual tVoid vVisit_3dGyroData(sensor_fi_tcl_3dGyroData& o3dGyroData);

   virtual tVoid vVisit_3dAccData(sensor_fi_tcl_3dAccData& o3dAccData);

   virtual tVoid vVisit_e8_GnssHw(sensor_fi_tcl_e8_GnssHw& oe8_GnssHw);

   virtual tVoid vVisit_b8_GnssSatSys(sensor_fi_tcl_b8_GnssSatSys& ob8_GnssSatSys);

   virtual tVoid vVisit_b8_GnssSatStatus(sensor_fi_tcl_b8_GnssSatStatus& ob8_GnssSatStatus);

   virtual tVoid vVisit_GnssConfigData(sensor_fi_tcl_GnssConfigData& oGnssConfigData);

   virtual tVoid vVisit_e8_GnssQuality(sensor_fi_tcl_e8_GnssQuality& oe8_GnssQuality);

   virtual tVoid vVisit_e8_GnssMode(sensor_fi_tcl_e8_GnssMode& oe8_GnssMode);

   virtual tVoid vVisit_GnssStatus(sensor_fi_tcl_GnssStatus& oGnssStatus);

   virtual tVoid vVisit_CovarianceMatrixUpperTriangle(sensor_fi_tcl_CovarianceMatrixUpperTriangle& oCovarianceMatrixUpperTriangle);

   virtual tVoid vVisit_TimeDate(sensor_fi_tcl_TimeDate& oTimeDate);

   virtual tVoid vVisit_GnssChanData(sensor_fi_tcl_GnssChanData& oGnssChanData);

   virtual tVoid vVisit_GnssPvtData(sensor_fi_tcl_GnssPvtData& oGnssPvtData);

   virtual tVoid vVisit_GnssData(sensor_fi_tcl_GnssData& oGnssData);

   virtual tVoid vVisit_e8_timeMode(sensor_fi_tcl_e8_timeMode& oe8_timeMode);

   virtual tVoid vVisit_e8_DefSetGroups(sensor_fi_tcl_e8_DefSetGroups& oe8_DefSetGroups);

   virtual tVoid vVisit_e8_DefSetMode(sensor_fi_tcl_e8_DefSetMode& oe8_DefSetMode);

   virtual tVoid vVisit_AllSensorData(sensor_fi_tcl_AllSensorData& oAllSensorData);

   virtual tVoid vVisit_e8_velocity_source(sensor_fi_tcl_e8_velocity_source& oe8_velocity_source);

   virtual tVoid vVisit_e8_position_source(sensor_fi_tcl_e8_position_source& oe8_position_source);

   virtual tVoid vVisit_e8_countrycode_source(sensor_fi_tcl_e8_countrycode_source& oe8_countrycode_source);

   virtual tVoid vVisit_e8_timezone_source(sensor_fi_tcl_e8_timezone_source& oe8_timezone_source);

   virtual tVoid vVisit_e8_deadreckoning_info_source(sensor_fi_tcl_e8_deadreckoning_info_source& oe8_deadreckoning_info_source);

   virtual tVoid vVisit_b16_deadreckoning_info_validity(sensor_fi_tcl_b16_deadreckoning_info_validity& ob16_deadreckoning_info_validity);

   virtual tVoid vVisit_s32_pv_Second(sensor_fi_tcl_s32_pv_Second& os32_pv_Second);

   virtual tVoid vVisit_e8_pv_DST_State(sensor_fi_tcl_e8_pv_DST_State& oe8_pv_DST_State);

   virtual tVoid vVisit_pv_TimeZone(sensor_fi_tcl_pv_TimeZone& opv_TimeZone);

   virtual tVoid vVisit_e16_pv_ISOCountryCode(sensor_fi_tcl_e16_pv_ISOCountryCode& oe16_pv_ISOCountryCode);

   virtual tVoid vVisit_mount_angles(sensor_fi_tcl_mount_angles& omount_angles);

   virtual tVoid vVisit_e8_mounting_source(sensor_fi_tcl_e8_mounting_source& oe8_mounting_source);


 	fi_tclTraversePath<fi_tclKnot>::tclIterator oIterator;		
	
protected:
	tBool bBreakNow;
	tBool bIsVisitorValid;
private:

};

#endif
