/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef SENSOR_PVFITYPES_HEADER
#define SENSOR_PVFITYPES_HEADER


class sensor_pvfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for sensor_pv_fi message types

fi_tclMessageBase* sensor_pvfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class sensor_pvfi_tclMsgBaseMessage : public sensor_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   sensor_pvfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class sensor_pvfi_tclMsgpositionGet : public sensor_pvfi_tclMsgBaseMessage
{
public:

   sensor_pvfi_tclMsgpositionGet();

   virtual ~sensor_pvfi_tclMsgpositionGet();

   inline tBool operator==(const sensor_pvfi_tclMsgpositionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_pvfi_tclMsgpositionUpReg : public sensor_pvfi_tclMsgBaseMessage
{
public:

   sensor_pvfi_tclMsgpositionUpReg();

   virtual ~sensor_pvfi_tclMsgpositionUpReg();

   inline tBool operator==(const sensor_pvfi_tclMsgpositionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_pvfi_tclMsgpositionRelUpReg : public sensor_pvfi_tclMsgBaseMessage
{
public:

   sensor_pvfi_tclMsgpositionRelUpReg();

   virtual ~sensor_pvfi_tclMsgpositionRelUpReg();

   inline tBool operator==(const sensor_pvfi_tclMsgpositionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_pvfi_tclMsgpositionStatus : public sensor_pvfi_tclMsgBaseMessage
{
public:

   sensor_pvfi_tclMsgpositionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sensor_pvfi_tclMsgpositionStatus& operator=(const sensor_pvfi_tclMsgpositionStatus& coRef);
   sensor_pvfi_tclMsgpositionStatus(const sensor_pvfi_tclMsgpositionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tF64 posLatitude;
   tF64 posLongitude;
   sensor_fi_tcl_e8_position_source posSource;
   sensor_fi_tcl_e16_pv_ISOCountryCode countryCode;
   sensor_fi_tcl_e8_countrycode_source countryCodeSource;
   sensor_fi_tcl_pv_TimeZone timeZone;
   sensor_fi_tcl_e8_timezone_source timeZoneSource;
   virtual ~sensor_pvfi_tclMsgpositionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sensor_pvfi_tclMsgpositionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sensor_pvfi_tclMsgvelocityGet : public sensor_pvfi_tclMsgBaseMessage
{
public:

   sensor_pvfi_tclMsgvelocityGet();

   virtual ~sensor_pvfi_tclMsgvelocityGet();

   inline tBool operator==(const sensor_pvfi_tclMsgvelocityGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_pvfi_tclMsgvelocityUpReg : public sensor_pvfi_tclMsgBaseMessage
{
public:

   sensor_pvfi_tclMsgvelocityUpReg();

   virtual ~sensor_pvfi_tclMsgvelocityUpReg();

   inline tBool operator==(const sensor_pvfi_tclMsgvelocityUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_pvfi_tclMsgvelocityRelUpReg : public sensor_pvfi_tclMsgBaseMessage
{
public:

   sensor_pvfi_tclMsgvelocityRelUpReg();

   virtual ~sensor_pvfi_tclMsgvelocityRelUpReg();

   inline tBool operator==(const sensor_pvfi_tclMsgvelocityRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_pvfi_tclMsgvelocityStatus : public sensor_pvfi_tclMsgBaseMessage
{
public:

   sensor_pvfi_tclMsgvelocityStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sensor_pvfi_tclMsgvelocityStatus& operator=(const sensor_pvfi_tclMsgvelocityStatus& coRef);
   sensor_pvfi_tclMsgvelocityStatus(const sensor_pvfi_tclMsgvelocityStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 velocityValue;
   sensor_fi_tcl_e8_velocity_source velocitiySource;
   virtual ~sensor_pvfi_tclMsgvelocityStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sensor_pvfi_tclMsgvelocityStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sensor_pvfi_tclMsgdeadreckoning_infoGet : public sensor_pvfi_tclMsgBaseMessage
{
public:

   sensor_pvfi_tclMsgdeadreckoning_infoGet();

   virtual ~sensor_pvfi_tclMsgdeadreckoning_infoGet();

   inline tBool operator==(const sensor_pvfi_tclMsgdeadreckoning_infoGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_pvfi_tclMsgdeadreckoning_infoUpReg : public sensor_pvfi_tclMsgBaseMessage
{
public:

   sensor_pvfi_tclMsgdeadreckoning_infoUpReg();

   virtual ~sensor_pvfi_tclMsgdeadreckoning_infoUpReg();

   inline tBool operator==(const sensor_pvfi_tclMsgdeadreckoning_infoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_pvfi_tclMsgdeadreckoning_infoRelUpReg : public sensor_pvfi_tclMsgBaseMessage
{
public:

   sensor_pvfi_tclMsgdeadreckoning_infoRelUpReg();

   virtual ~sensor_pvfi_tclMsgdeadreckoning_infoRelUpReg();

   inline tBool operator==(const sensor_pvfi_tclMsgdeadreckoning_infoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_pvfi_tclMsgdeadreckoning_infoStatus : public sensor_pvfi_tclMsgBaseMessage
{
public:

   sensor_pvfi_tclMsgdeadreckoning_infoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sensor_pvfi_tclMsgdeadreckoning_infoStatus& operator=(const sensor_pvfi_tclMsgdeadreckoning_infoStatus& coRef);
   sensor_pvfi_tclMsgdeadreckoning_infoStatus(const sensor_pvfi_tclMsgdeadreckoning_infoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU64 drTimestamp;
   tU32 drSystemTime;
   tF64 drLatitude;
   tF64 drLongitude;
   tF32 drHeading;
   tF32 drSpeed;
   tF32 drAltitude;
   tF32 drTurnrateX;
   tF32 drTurnrateY;
   tF32 drTurnrateZ;
   tF32 drAccelerationX;
   tF32 drAccelerationY;
   tF32 drAccelerationZ;
   sensor_fi_tcl_e8_deadreckoning_info_source drInfoSource;
   sensor_fi_tcl_b16_deadreckoning_info_validity drInfoValidity;
   virtual ~sensor_pvfi_tclMsgdeadreckoning_infoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sensor_pvfi_tclMsgdeadreckoning_infoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sensor_pvfi_tclMsgmountingGet : public sensor_pvfi_tclMsgBaseMessage
{
public:

   sensor_pvfi_tclMsgmountingGet();

   virtual ~sensor_pvfi_tclMsgmountingGet();

   inline tBool operator==(const sensor_pvfi_tclMsgmountingGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_pvfi_tclMsgmountingUpReg : public sensor_pvfi_tclMsgBaseMessage
{
public:

   sensor_pvfi_tclMsgmountingUpReg();

   virtual ~sensor_pvfi_tclMsgmountingUpReg();

   inline tBool operator==(const sensor_pvfi_tclMsgmountingUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_pvfi_tclMsgmountingRelUpReg : public sensor_pvfi_tclMsgBaseMessage
{
public:

   sensor_pvfi_tclMsgmountingRelUpReg();

   virtual ~sensor_pvfi_tclMsgmountingRelUpReg();

   inline tBool operator==(const sensor_pvfi_tclMsgmountingRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_pvfi_tclMsgmountingStatus : public sensor_pvfi_tclMsgBaseMessage
{
public:

   sensor_pvfi_tclMsgmountingStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sensor_pvfi_tclMsgmountingStatus& operator=(const sensor_pvfi_tclMsgmountingStatus& coRef);
   sensor_pvfi_tclMsgmountingStatus(const sensor_pvfi_tclMsgmountingStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sensor_fi_tcl_mount_angles angles;
   sensor_fi_tcl_e8_mounting_source source;
   virtual ~sensor_pvfi_tclMsgmountingStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sensor_pvfi_tclMsgmountingStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
