/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_PVFI_TYPES
#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_PVFI_FUNCTIONIDS
#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_PVFI_SERVICEINFO
#include "sensor_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for sensor_pv_fi message types

fi_tclMessageBase* sensor_pvfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case sensor_pvfi_tclToken::EN_MSG_POSITIONGET:
         return OSAL_NEW sensor_pvfi_tclMsgpositionGet;

      case sensor_pvfi_tclToken::EN_MSG_POSITIONUPREG:
         return OSAL_NEW sensor_pvfi_tclMsgpositionUpReg;

      case sensor_pvfi_tclToken::EN_MSG_POSITIONRELUPREG:
         return OSAL_NEW sensor_pvfi_tclMsgpositionRelUpReg;

      case sensor_pvfi_tclToken::EN_MSG_POSITIONSTATUS:
         return OSAL_NEW sensor_pvfi_tclMsgpositionStatus;

      case sensor_pvfi_tclToken::EN_MSG_VELOCITYGET:
         return OSAL_NEW sensor_pvfi_tclMsgvelocityGet;

      case sensor_pvfi_tclToken::EN_MSG_VELOCITYUPREG:
         return OSAL_NEW sensor_pvfi_tclMsgvelocityUpReg;

      case sensor_pvfi_tclToken::EN_MSG_VELOCITYRELUPREG:
         return OSAL_NEW sensor_pvfi_tclMsgvelocityRelUpReg;

      case sensor_pvfi_tclToken::EN_MSG_VELOCITYSTATUS:
         return OSAL_NEW sensor_pvfi_tclMsgvelocityStatus;

      case sensor_pvfi_tclToken::EN_MSG_DEADRECKONING_INFOGET:
         return OSAL_NEW sensor_pvfi_tclMsgdeadreckoning_infoGet;

      case sensor_pvfi_tclToken::EN_MSG_DEADRECKONING_INFOUPREG:
         return OSAL_NEW sensor_pvfi_tclMsgdeadreckoning_infoUpReg;

      case sensor_pvfi_tclToken::EN_MSG_DEADRECKONING_INFORELUPREG:
         return OSAL_NEW sensor_pvfi_tclMsgdeadreckoning_infoRelUpReg;

      case sensor_pvfi_tclToken::EN_MSG_DEADRECKONING_INFOSTATUS:
         return OSAL_NEW sensor_pvfi_tclMsgdeadreckoning_infoStatus;

      case sensor_pvfi_tclToken::EN_MSG_MOUNTINGGET:
         return OSAL_NEW sensor_pvfi_tclMsgmountingGet;

      case sensor_pvfi_tclToken::EN_MSG_MOUNTINGUPREG:
         return OSAL_NEW sensor_pvfi_tclMsgmountingUpReg;

      case sensor_pvfi_tclToken::EN_MSG_MOUNTINGRELUPREG:
         return OSAL_NEW sensor_pvfi_tclMsgmountingRelUpReg;

      case sensor_pvfi_tclToken::EN_MSG_MOUNTINGSTATUS:
         return OSAL_NEW sensor_pvfi_tclMsgmountingStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all sensor_pvfifi messages

// common functions

tU16 sensor_pvfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return SENSOR_PVFI_C_U16_SERVICE_ID;
}

tU16 sensor_pvfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 sensor_pvfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& sensor_pvfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& sensor_pvfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 sensor_pvfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& sensor_pvfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& sensor_pvfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

sensor_pvfi_tclMsgpositionGet::sensor_pvfi_tclMsgpositionGet()
 {}

tS32 sensor_pvfi_tclMsgpositionGet::s32GetTypeId() const
{
   return (tS32) sensor_pvfi_tclToken::EN_MSG_POSITIONGET;
}


sensor_pvfi_tclMsgpositionGet::~sensor_pvfi_tclMsgpositionGet()
{}

//=============================================================================

sensor_pvfi_tclMsgpositionUpReg::sensor_pvfi_tclMsgpositionUpReg()
 {}

tS32 sensor_pvfi_tclMsgpositionUpReg::s32GetTypeId() const
{
   return (tS32) sensor_pvfi_tclToken::EN_MSG_POSITIONUPREG;
}


sensor_pvfi_tclMsgpositionUpReg::~sensor_pvfi_tclMsgpositionUpReg()
{}

//=============================================================================

sensor_pvfi_tclMsgpositionRelUpReg::sensor_pvfi_tclMsgpositionRelUpReg()
 {}

tS32 sensor_pvfi_tclMsgpositionRelUpReg::s32GetTypeId() const
{
   return (tS32) sensor_pvfi_tclToken::EN_MSG_POSITIONRELUPREG;
}


sensor_pvfi_tclMsgpositionRelUpReg::~sensor_pvfi_tclMsgpositionRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_pvfi_tclMsgpositionStatus::sensor_pvfi_tclMsgpositionStatus(const sensor_pvfi_tclMsgpositionStatus& coRef)
   : sensor_pvfi_tclMsgBaseMessage(coRef)
{
   posLatitude = coRef.posLatitude;
   posLongitude = coRef.posLongitude;
   posSource = coRef.posSource;
   countryCode = coRef.countryCode;
   countryCodeSource = coRef.countryCodeSource;
   timeZone = coRef.timeZone;
   timeZoneSource = coRef.timeZoneSource;
}
sensor_pvfi_tclMsgpositionStatus& sensor_pvfi_tclMsgpositionStatus::operator=(const sensor_pvfi_tclMsgpositionStatus& coRef)
{
   if (this == &coRef) return *this;
   posLatitude = coRef.posLatitude;
   posLongitude = coRef.posLongitude;
   posSource = coRef.posSource;
   countryCode = coRef.countryCode;
   countryCodeSource = coRef.countryCodeSource;
   timeZone = coRef.timeZone;
   timeZoneSource = coRef.timeZoneSource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_pvfi_tclMsgpositionStatus::sensor_pvfi_tclMsgpositionStatus()
:posLatitude(0)
,posLongitude(0)
,posSource()
,countryCode()
,countryCodeSource()
,timeZone()
,timeZoneSource()
 {}

tS32 sensor_pvfi_tclMsgpositionStatus::s32GetTypeId() const
{
   return (tS32) sensor_pvfi_tclToken::EN_MSG_POSITIONSTATUS;
}


sensor_pvfi_tclMsgpositionStatus::~sensor_pvfi_tclMsgpositionStatus()
{}

tU32 sensor_pvfi_tclMsgpositionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 30;
}

fi_tclInContext& sensor_pvfi_tclMsgpositionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> posLatitude);
   (tVoid) (oIn >> posLongitude);
   (tVoid) (oIn >> posSource);
   (tVoid) (oIn >> countryCode);
   (tVoid) (oIn >> countryCodeSource);
   (tVoid) (oIn >> timeZone);
   (tVoid) (oIn >> timeZoneSource);
   return oIn;
}

fi_tclOutContext& sensor_pvfi_tclMsgpositionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << posLatitude);
   (tVoid) (oOut << posLongitude);
   (tVoid) (oOut << posSource);
   (tVoid) (oOut << countryCode);
   (tVoid) (oOut << countryCodeSource);
   (tVoid) (oOut << timeZone);
   (tVoid) (oOut << timeZoneSource);
   return oOut;
}

tBool sensor_pvfi_tclMsgpositionStatus::operator==(const sensor_pvfi_tclMsgpositionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (posLatitude == roRef.posLatitude);
   bResult = bResult && (posLongitude == roRef.posLongitude);
   bResult = bResult && (posSource == roRef.posSource);
   bResult = bResult && (countryCode == roRef.countryCode);
   bResult = bResult && (countryCodeSource == roRef.countryCodeSource);
   bResult = bResult && (timeZone == roRef.timeZone);
   bResult = bResult && (timeZoneSource == roRef.timeZoneSource);
   return bResult;
}

//=============================================================================

sensor_pvfi_tclMsgvelocityGet::sensor_pvfi_tclMsgvelocityGet()
 {}

tS32 sensor_pvfi_tclMsgvelocityGet::s32GetTypeId() const
{
   return (tS32) sensor_pvfi_tclToken::EN_MSG_VELOCITYGET;
}


sensor_pvfi_tclMsgvelocityGet::~sensor_pvfi_tclMsgvelocityGet()
{}

//=============================================================================

sensor_pvfi_tclMsgvelocityUpReg::sensor_pvfi_tclMsgvelocityUpReg()
 {}

tS32 sensor_pvfi_tclMsgvelocityUpReg::s32GetTypeId() const
{
   return (tS32) sensor_pvfi_tclToken::EN_MSG_VELOCITYUPREG;
}


sensor_pvfi_tclMsgvelocityUpReg::~sensor_pvfi_tclMsgvelocityUpReg()
{}

//=============================================================================

sensor_pvfi_tclMsgvelocityRelUpReg::sensor_pvfi_tclMsgvelocityRelUpReg()
 {}

tS32 sensor_pvfi_tclMsgvelocityRelUpReg::s32GetTypeId() const
{
   return (tS32) sensor_pvfi_tclToken::EN_MSG_VELOCITYRELUPREG;
}


sensor_pvfi_tclMsgvelocityRelUpReg::~sensor_pvfi_tclMsgvelocityRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_pvfi_tclMsgvelocityStatus::sensor_pvfi_tclMsgvelocityStatus(const sensor_pvfi_tclMsgvelocityStatus& coRef)
   : sensor_pvfi_tclMsgBaseMessage(coRef)
{
   velocityValue = coRef.velocityValue;
   velocitiySource = coRef.velocitiySource;
}
sensor_pvfi_tclMsgvelocityStatus& sensor_pvfi_tclMsgvelocityStatus::operator=(const sensor_pvfi_tclMsgvelocityStatus& coRef)
{
   if (this == &coRef) return *this;
   velocityValue = coRef.velocityValue;
   velocitiySource = coRef.velocitiySource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_pvfi_tclMsgvelocityStatus::sensor_pvfi_tclMsgvelocityStatus()
:velocityValue(0)
,velocitiySource()
 {}

tS32 sensor_pvfi_tclMsgvelocityStatus::s32GetTypeId() const
{
   return (tS32) sensor_pvfi_tclToken::EN_MSG_VELOCITYSTATUS;
}


sensor_pvfi_tclMsgvelocityStatus::~sensor_pvfi_tclMsgvelocityStatus()
{}

tU32 sensor_pvfi_tclMsgvelocityStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& sensor_pvfi_tclMsgvelocityStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> velocityValue);
   (tVoid) (oIn >> velocitiySource);
   return oIn;
}

fi_tclOutContext& sensor_pvfi_tclMsgvelocityStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << velocityValue);
   (tVoid) (oOut << velocitiySource);
   return oOut;
}

tBool sensor_pvfi_tclMsgvelocityStatus::operator==(const sensor_pvfi_tclMsgvelocityStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (velocityValue == roRef.velocityValue);
   bResult = bResult && (velocitiySource == roRef.velocitiySource);
   return bResult;
}

//=============================================================================

sensor_pvfi_tclMsgdeadreckoning_infoGet::sensor_pvfi_tclMsgdeadreckoning_infoGet()
 {}

tS32 sensor_pvfi_tclMsgdeadreckoning_infoGet::s32GetTypeId() const
{
   return (tS32) sensor_pvfi_tclToken::EN_MSG_DEADRECKONING_INFOGET;
}


sensor_pvfi_tclMsgdeadreckoning_infoGet::~sensor_pvfi_tclMsgdeadreckoning_infoGet()
{}

//=============================================================================

sensor_pvfi_tclMsgdeadreckoning_infoUpReg::sensor_pvfi_tclMsgdeadreckoning_infoUpReg()
 {}

tS32 sensor_pvfi_tclMsgdeadreckoning_infoUpReg::s32GetTypeId() const
{
   return (tS32) sensor_pvfi_tclToken::EN_MSG_DEADRECKONING_INFOUPREG;
}


sensor_pvfi_tclMsgdeadreckoning_infoUpReg::~sensor_pvfi_tclMsgdeadreckoning_infoUpReg()
{}

//=============================================================================

sensor_pvfi_tclMsgdeadreckoning_infoRelUpReg::sensor_pvfi_tclMsgdeadreckoning_infoRelUpReg()
 {}

tS32 sensor_pvfi_tclMsgdeadreckoning_infoRelUpReg::s32GetTypeId() const
{
   return (tS32) sensor_pvfi_tclToken::EN_MSG_DEADRECKONING_INFORELUPREG;
}


sensor_pvfi_tclMsgdeadreckoning_infoRelUpReg::~sensor_pvfi_tclMsgdeadreckoning_infoRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_pvfi_tclMsgdeadreckoning_infoStatus::sensor_pvfi_tclMsgdeadreckoning_infoStatus(const sensor_pvfi_tclMsgdeadreckoning_infoStatus& coRef)
   : sensor_pvfi_tclMsgBaseMessage(coRef)
{
   drTimestamp = coRef.drTimestamp;
   drSystemTime = coRef.drSystemTime;
   drLatitude = coRef.drLatitude;
   drLongitude = coRef.drLongitude;
   drHeading = coRef.drHeading;
   drSpeed = coRef.drSpeed;
   drAltitude = coRef.drAltitude;
   drTurnrateX = coRef.drTurnrateX;
   drTurnrateY = coRef.drTurnrateY;
   drTurnrateZ = coRef.drTurnrateZ;
   drAccelerationX = coRef.drAccelerationX;
   drAccelerationY = coRef.drAccelerationY;
   drAccelerationZ = coRef.drAccelerationZ;
   drInfoSource = coRef.drInfoSource;
   drInfoValidity = coRef.drInfoValidity;
}
sensor_pvfi_tclMsgdeadreckoning_infoStatus& sensor_pvfi_tclMsgdeadreckoning_infoStatus::operator=(const sensor_pvfi_tclMsgdeadreckoning_infoStatus& coRef)
{
   if (this == &coRef) return *this;
   drTimestamp = coRef.drTimestamp;
   drSystemTime = coRef.drSystemTime;
   drLatitude = coRef.drLatitude;
   drLongitude = coRef.drLongitude;
   drHeading = coRef.drHeading;
   drSpeed = coRef.drSpeed;
   drAltitude = coRef.drAltitude;
   drTurnrateX = coRef.drTurnrateX;
   drTurnrateY = coRef.drTurnrateY;
   drTurnrateZ = coRef.drTurnrateZ;
   drAccelerationX = coRef.drAccelerationX;
   drAccelerationY = coRef.drAccelerationY;
   drAccelerationZ = coRef.drAccelerationZ;
   drInfoSource = coRef.drInfoSource;
   drInfoValidity = coRef.drInfoValidity;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_pvfi_tclMsgdeadreckoning_infoStatus::sensor_pvfi_tclMsgdeadreckoning_infoStatus()
:drTimestamp(0)
,drSystemTime(0)
,drLatitude(0)
,drLongitude(0)
,drHeading(0)
,drSpeed(0)
,drAltitude(0)
,drTurnrateX(0)
,drTurnrateY(0)
,drTurnrateZ(0)
,drAccelerationX(0)
,drAccelerationY(0)
,drAccelerationZ(0)
,drInfoSource()
,drInfoValidity()
 {}

tS32 sensor_pvfi_tclMsgdeadreckoning_infoStatus::s32GetTypeId() const
{
   return (tS32) sensor_pvfi_tclToken::EN_MSG_DEADRECKONING_INFOSTATUS;
}


sensor_pvfi_tclMsgdeadreckoning_infoStatus::~sensor_pvfi_tclMsgdeadreckoning_infoStatus()
{}

tU32 sensor_pvfi_tclMsgdeadreckoning_infoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 67;
}

fi_tclInContext& sensor_pvfi_tclMsgdeadreckoning_infoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> drTimestamp);
   (tVoid) (oIn >> drSystemTime);
   (tVoid) (oIn >> drLatitude);
   (tVoid) (oIn >> drLongitude);
   (tVoid) (oIn >> drHeading);
   (tVoid) (oIn >> drSpeed);
   (tVoid) (oIn >> drAltitude);
   (tVoid) (oIn >> drTurnrateX);
   (tVoid) (oIn >> drTurnrateY);
   (tVoid) (oIn >> drTurnrateZ);
   (tVoid) (oIn >> drAccelerationX);
   (tVoid) (oIn >> drAccelerationY);
   (tVoid) (oIn >> drAccelerationZ);
   (tVoid) (oIn >> drInfoSource);
   (tVoid) (oIn >> drInfoValidity);
   return oIn;
}

fi_tclOutContext& sensor_pvfi_tclMsgdeadreckoning_infoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << drTimestamp);
   (tVoid) (oOut << drSystemTime);
   (tVoid) (oOut << drLatitude);
   (tVoid) (oOut << drLongitude);
   (tVoid) (oOut << drHeading);
   (tVoid) (oOut << drSpeed);
   (tVoid) (oOut << drAltitude);
   (tVoid) (oOut << drTurnrateX);
   (tVoid) (oOut << drTurnrateY);
   (tVoid) (oOut << drTurnrateZ);
   (tVoid) (oOut << drAccelerationX);
   (tVoid) (oOut << drAccelerationY);
   (tVoid) (oOut << drAccelerationZ);
   (tVoid) (oOut << drInfoSource);
   (tVoid) (oOut << drInfoValidity);
   return oOut;
}

tBool sensor_pvfi_tclMsgdeadreckoning_infoStatus::operator==(const sensor_pvfi_tclMsgdeadreckoning_infoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (drTimestamp == roRef.drTimestamp);
   bResult = bResult && (drSystemTime == roRef.drSystemTime);
   bResult = bResult && (drLatitude == roRef.drLatitude);
   bResult = bResult && (drLongitude == roRef.drLongitude);
   bResult = bResult && (drHeading == roRef.drHeading);
   bResult = bResult && (drSpeed == roRef.drSpeed);
   bResult = bResult && (drAltitude == roRef.drAltitude);
   bResult = bResult && (drTurnrateX == roRef.drTurnrateX);
   bResult = bResult && (drTurnrateY == roRef.drTurnrateY);
   bResult = bResult && (drTurnrateZ == roRef.drTurnrateZ);
   bResult = bResult && (drAccelerationX == roRef.drAccelerationX);
   bResult = bResult && (drAccelerationY == roRef.drAccelerationY);
   bResult = bResult && (drAccelerationZ == roRef.drAccelerationZ);
   bResult = bResult && (drInfoSource == roRef.drInfoSource);
   bResult = bResult && (drInfoValidity == roRef.drInfoValidity);
   return bResult;
}

//=============================================================================

sensor_pvfi_tclMsgmountingGet::sensor_pvfi_tclMsgmountingGet()
 {}

tS32 sensor_pvfi_tclMsgmountingGet::s32GetTypeId() const
{
   return (tS32) sensor_pvfi_tclToken::EN_MSG_MOUNTINGGET;
}


sensor_pvfi_tclMsgmountingGet::~sensor_pvfi_tclMsgmountingGet()
{}

//=============================================================================

sensor_pvfi_tclMsgmountingUpReg::sensor_pvfi_tclMsgmountingUpReg()
 {}

tS32 sensor_pvfi_tclMsgmountingUpReg::s32GetTypeId() const
{
   return (tS32) sensor_pvfi_tclToken::EN_MSG_MOUNTINGUPREG;
}


sensor_pvfi_tclMsgmountingUpReg::~sensor_pvfi_tclMsgmountingUpReg()
{}

//=============================================================================

sensor_pvfi_tclMsgmountingRelUpReg::sensor_pvfi_tclMsgmountingRelUpReg()
 {}

tS32 sensor_pvfi_tclMsgmountingRelUpReg::s32GetTypeId() const
{
   return (tS32) sensor_pvfi_tclToken::EN_MSG_MOUNTINGRELUPREG;
}


sensor_pvfi_tclMsgmountingRelUpReg::~sensor_pvfi_tclMsgmountingRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_pvfi_tclMsgmountingStatus::sensor_pvfi_tclMsgmountingStatus(const sensor_pvfi_tclMsgmountingStatus& coRef)
   : sensor_pvfi_tclMsgBaseMessage(coRef)
{
   angles = coRef.angles;
   source = coRef.source;
}
sensor_pvfi_tclMsgmountingStatus& sensor_pvfi_tclMsgmountingStatus::operator=(const sensor_pvfi_tclMsgmountingStatus& coRef)
{
   if (this == &coRef) return *this;
   angles = coRef.angles;
   source = coRef.source;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_pvfi_tclMsgmountingStatus::sensor_pvfi_tclMsgmountingStatus()
:angles()
,source()
 {}

tS32 sensor_pvfi_tclMsgmountingStatus::s32GetTypeId() const
{
   return (tS32) sensor_pvfi_tclToken::EN_MSG_MOUNTINGSTATUS;
}


sensor_pvfi_tclMsgmountingStatus::~sensor_pvfi_tclMsgmountingStatus()
{}

tU32 sensor_pvfi_tclMsgmountingStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& sensor_pvfi_tclMsgmountingStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> angles);
   (tVoid) (oIn >> source);
   return oIn;
}

fi_tclOutContext& sensor_pvfi_tclMsgmountingStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << angles);
   (tVoid) (oOut << source);
   return oOut;
}

tBool sensor_pvfi_tclMsgmountingStatus::operator==(const sensor_pvfi_tclMsgmountingStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (angles == roRef.angles);
   bResult = bResult && (source == roRef.source);
   return bResult;
}

