#ifndef __SENSOR_PVFIDEBUGVISITOR_H__
#define __SENSOR_PVFIDEBUGVISITOR_H__

class MY_DECL sensor_pvfi_tclPrintVisitor : public sensor_pvfi_tclVisitorBase {

private:
   /* default constructor */ sensor_pvfi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   sensor_pvfi_tclPrintVisitor(sensor_fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(sensor_fi_tclU8& oU8);
   virtual tVoid vVisitS8(sensor_fi_tclS8& oS8);
   virtual tVoid vVisitU16(sensor_fi_tclU16& oU16);
   virtual tVoid vVisitS16(sensor_fi_tclS16& oS16);
   virtual tVoid vVisitU24(sensor_fi_tclU24& oU24);
   virtual tVoid vVisitS24(sensor_fi_tclS24& oS24);
   virtual tVoid vVisitU32(sensor_fi_tclU32& oU32);
   virtual tVoid vVisitS32(sensor_fi_tclS32& oS32);
   virtual tVoid vVisitU64(sensor_fi_tclU64& oU64);
   virtual tVoid vVisitS64(sensor_fi_tclS64& oS64);
   virtual tVoid vVisitBool(sensor_fi_tclBool& oBool);
   virtual tVoid vVisitString(sensor_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(sensor_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(sensor_fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(sensor_pvfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_velocity_source(sensor_fi_tcl_e8_velocity_source& o_e8_velocity_source);
   virtual tVoid vVisit_e8_position_source(sensor_fi_tcl_e8_position_source& o_e8_position_source);
   virtual tVoid vVisit_e8_countrycode_source(sensor_fi_tcl_e8_countrycode_source& o_e8_countrycode_source);
   virtual tVoid vVisit_e8_timezone_source(sensor_fi_tcl_e8_timezone_source& o_e8_timezone_source);
   virtual tVoid vVisit_e8_deadreckoning_info_source(sensor_fi_tcl_e8_deadreckoning_info_source& o_e8_deadreckoning_info_source);
   virtual tVoid vVisit_b16_deadreckoning_info_validity(sensor_fi_tcl_b16_deadreckoning_info_validity& o_b16_deadreckoning_info_validity);
   virtual tVoid vVisit_s32_pv_Second(sensor_fi_tcl_s32_pv_Second& o_s32_pv_Second);
   virtual tVoid vVisit_e8_pv_DST_State(sensor_fi_tcl_e8_pv_DST_State& o_e8_pv_DST_State);
   virtual tBool bDoExpand_pv_TimeZone(sensor_pvfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e16_pv_ISOCountryCode(sensor_fi_tcl_e16_pv_ISOCountryCode& o_e16_pv_ISOCountryCode);
   virtual tBool bDoExpand_mount_angles(sensor_pvfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_mounting_source(sensor_fi_tcl_e8_mounting_source& o_e8_mounting_source);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   sensor_fi_tclOutput* poOutput;
};


class MY_DECL sensor_pvfi_tclRandomInitVisitor : public sensor_pvfi_tclVisitorBase {
public:

   sensor_pvfi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(sensor_fi_tclU8& oU8);
   virtual tVoid vVisitS8(sensor_fi_tclS8& oS8);
   virtual tVoid vVisitU16(sensor_fi_tclU16& oU16);
   virtual tVoid vVisitS16(sensor_fi_tclS16& oS16);
   virtual tVoid vVisitU24(sensor_fi_tclU24& oU24);
   virtual tVoid vVisitS24(sensor_fi_tclS24& oS24);
   virtual tVoid vVisitU32(sensor_fi_tclU32& oU32);
   virtual tVoid vVisitS32(sensor_fi_tclS32& oS32);
   virtual tVoid vVisitU64(sensor_fi_tclU64& oU64);
   virtual tVoid vVisitS64(sensor_fi_tclS64& oS64);
   virtual tVoid vVisitBool(sensor_fi_tclBool& oBool);
   virtual tVoid vVisitString(sensor_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(sensor_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(sensor_fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_e8_velocity_source(sensor_fi_tcl_e8_velocity_source& o_e8_velocity_source);
   virtual tVoid vVisit_e8_position_source(sensor_fi_tcl_e8_position_source& o_e8_position_source);
   virtual tVoid vVisit_e8_countrycode_source(sensor_fi_tcl_e8_countrycode_source& o_e8_countrycode_source);
   virtual tVoid vVisit_e8_timezone_source(sensor_fi_tcl_e8_timezone_source& o_e8_timezone_source);
   virtual tVoid vVisit_e8_deadreckoning_info_source(sensor_fi_tcl_e8_deadreckoning_info_source& o_e8_deadreckoning_info_source);
   virtual tVoid vVisit_b16_deadreckoning_info_validity(sensor_fi_tcl_b16_deadreckoning_info_validity& o_b16_deadreckoning_info_validity);
   virtual tVoid vVisit_s32_pv_Second(sensor_fi_tcl_s32_pv_Second& o_s32_pv_Second);
   virtual tVoid vVisit_e8_pv_DST_State(sensor_fi_tcl_e8_pv_DST_State& o_e8_pv_DST_State);
   virtual tVoid vVisit_e16_pv_ISOCountryCode(sensor_fi_tcl_e16_pv_ISOCountryCode& o_e16_pv_ISOCountryCode);
   virtual tVoid vVisit_e8_mounting_source(sensor_fi_tcl_e8_mounting_source& o_e8_mounting_source);
	tU32 u32ListSize;
};

#endif
