/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_LOCATIONFI_TYPES
#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_LOCATIONFI_FUNCTIONIDS
#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_LOCATIONFI_SERVICEINFO
#include "sensor_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for sensor_location_fi message types

fi_tclMessageBase* sensor_locationfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case sensor_locationfi_tclToken::EN_MSG_SAVEPERSISTENTMETHODSTART:
         return OSAL_NEW sensor_locationfi_tclMsgSavePersistentMethodStart;

      case sensor_locationfi_tclToken::EN_MSG_SAVEPERSISTENTMETHODRESULT:
         return OSAL_NEW sensor_locationfi_tclMsgSavePersistentMethodResult;

      case sensor_locationfi_tclToken::EN_MSG_UPDATEDIAGLOGMETHODSTART:
         return OSAL_NEW sensor_locationfi_tclMsgUpdateDiagLogMethodStart;

      case sensor_locationfi_tclToken::EN_MSG_UPDATEDIAGLOGMETHODRESULT:
         return OSAL_NEW sensor_locationfi_tclMsgUpdateDiagLogMethodResult;

      case sensor_locationfi_tclToken::EN_MSG_FACTORYSETTINGSMETHODSTART:
         return OSAL_NEW sensor_locationfi_tclMsgFactorySettingsMethodStart;

      case sensor_locationfi_tclToken::EN_MSG_FACTORYSETTINGSMETHODRESULT:
         return OSAL_NEW sensor_locationfi_tclMsgFactorySettingsMethodResult;

      case sensor_locationfi_tclToken::EN_MSG_UPDATEFACTORYSETTINGSMETHODSTART:
         return OSAL_NEW sensor_locationfi_tclMsgUpdateFactorySettingsMethodStart;

      case sensor_locationfi_tclToken::EN_MSG_UPDATEFACTORYSETTINGSMETHODRESULT:
         return OSAL_NEW sensor_locationfi_tclMsgUpdateFactorySettingsMethodResult;

      case sensor_locationfi_tclToken::EN_MSG_GYRO3DGETHWINFOMETHODSTART:
         return OSAL_NEW sensor_locationfi_tclMsgGyro3dGetHwInfoMethodStart;

      case sensor_locationfi_tclToken::EN_MSG_GYRO3DGETHWINFOMETHODRESULT:
         return OSAL_NEW sensor_locationfi_tclMsgGyro3dGetHwInfoMethodResult;

      case sensor_locationfi_tclToken::EN_MSG_ACC3DGETHWINFOMETHODSTART:
         return OSAL_NEW sensor_locationfi_tclMsgAcc3dGetHwInfoMethodStart;

      case sensor_locationfi_tclToken::EN_MSG_ACC3DGETHWINFOMETHODRESULT:
         return OSAL_NEW sensor_locationfi_tclMsgAcc3dGetHwInfoMethodResult;

      case sensor_locationfi_tclToken::EN_MSG_GYROSELFTESTMETHODSTART:
         return OSAL_NEW sensor_locationfi_tclMsgGyroSelfTestMethodStart;

      case sensor_locationfi_tclToken::EN_MSG_GYROSELFTESTMETHODRESULT:
         return OSAL_NEW sensor_locationfi_tclMsgGyroSelfTestMethodResult;

      case sensor_locationfi_tclToken::EN_MSG_ACCSELFTESTMETHODSTART:
         return OSAL_NEW sensor_locationfi_tclMsgAccSelfTestMethodStart;

      case sensor_locationfi_tclToken::EN_MSG_ACCSELFTESTMETHODRESULT:
         return OSAL_NEW sensor_locationfi_tclMsgAccSelfTestMethodResult;

      case sensor_locationfi_tclToken::EN_MSG_ODOMETERDATA_UPDATEGET:
         return OSAL_NEW sensor_locationfi_tclMsgOdometerData_UpdateGet;

      case sensor_locationfi_tclToken::EN_MSG_ODOMETERDATA_UPDATEUPREG:
         return OSAL_NEW sensor_locationfi_tclMsgOdometerData_UpdateUpReg;

      case sensor_locationfi_tclToken::EN_MSG_ODOMETERDATA_UPDATERELUPREG:
         return OSAL_NEW sensor_locationfi_tclMsgOdometerData_UpdateRelUpReg;

      case sensor_locationfi_tclToken::EN_MSG_ODOMETERDATA_UPDATESTATUS:
         return OSAL_NEW sensor_locationfi_tclMsgOdometerData_UpdateStatus;

      case sensor_locationfi_tclToken::EN_MSG_ABSDATAGET:
         return OSAL_NEW sensor_locationfi_tclMsgAbsDataGet;

      case sensor_locationfi_tclToken::EN_MSG_ABSDATAUPREG:
         return OSAL_NEW sensor_locationfi_tclMsgAbsDataUpReg;

      case sensor_locationfi_tclToken::EN_MSG_ABSDATARELUPREG:
         return OSAL_NEW sensor_locationfi_tclMsgAbsDataRelUpReg;

      case sensor_locationfi_tclToken::EN_MSG_ABSDATASTATUS:
         return OSAL_NEW sensor_locationfi_tclMsgAbsDataStatus;

      case sensor_locationfi_tclToken::EN_MSG_GYRO3DDATA_UPDATEGET:
         return OSAL_NEW sensor_locationfi_tclMsgGyro3dData_UpdateGet;

      case sensor_locationfi_tclToken::EN_MSG_GYRO3DDATA_UPDATEUPREG:
         return OSAL_NEW sensor_locationfi_tclMsgGyro3dData_UpdateUpReg;

      case sensor_locationfi_tclToken::EN_MSG_GYRO3DDATA_UPDATERELUPREG:
         return OSAL_NEW sensor_locationfi_tclMsgGyro3dData_UpdateRelUpReg;

      case sensor_locationfi_tclToken::EN_MSG_GYRO3DDATA_UPDATESTATUS:
         return OSAL_NEW sensor_locationfi_tclMsgGyro3dData_UpdateStatus;

      case sensor_locationfi_tclToken::EN_MSG_ACC3DDATA_UPDATEGET:
         return OSAL_NEW sensor_locationfi_tclMsgAcc3dData_UpdateGet;

      case sensor_locationfi_tclToken::EN_MSG_ACC3DDATA_UPDATEUPREG:
         return OSAL_NEW sensor_locationfi_tclMsgAcc3dData_UpdateUpReg;

      case sensor_locationfi_tclToken::EN_MSG_ACC3DDATA_UPDATERELUPREG:
         return OSAL_NEW sensor_locationfi_tclMsgAcc3dData_UpdateRelUpReg;

      case sensor_locationfi_tclToken::EN_MSG_ACC3DDATA_UPDATESTATUS:
         return OSAL_NEW sensor_locationfi_tclMsgAcc3dData_UpdateStatus;

      case sensor_locationfi_tclToken::EN_MSG_GYROTEMPERATUREGET:
         return OSAL_NEW sensor_locationfi_tclMsgGyroTemperatureGet;

      case sensor_locationfi_tclToken::EN_MSG_GYROTEMPERATUREUPREG:
         return OSAL_NEW sensor_locationfi_tclMsgGyroTemperatureUpReg;

      case sensor_locationfi_tclToken::EN_MSG_GYROTEMPERATURERELUPREG:
         return OSAL_NEW sensor_locationfi_tclMsgGyroTemperatureRelUpReg;

      case sensor_locationfi_tclToken::EN_MSG_GYROTEMPERATURESTATUS:
         return OSAL_NEW sensor_locationfi_tclMsgGyroTemperatureStatus;

      case sensor_locationfi_tclToken::EN_MSG_GNSSSATSYSTEMGET:
         return OSAL_NEW sensor_locationfi_tclMsgGnssSatSystemGet;

      case sensor_locationfi_tclToken::EN_MSG_GNSSSATSYSTEMSET:
         return OSAL_NEW sensor_locationfi_tclMsgGnssSatSystemSet;

      case sensor_locationfi_tclToken::EN_MSG_GNSSSATSYSTEMSTATUS:
         return OSAL_NEW sensor_locationfi_tclMsgGnssSatSystemStatus;

      case sensor_locationfi_tclToken::EN_MSG_GNSSWNEPOCHGET:
         return OSAL_NEW sensor_locationfi_tclMsgGnssWnEpochGet;

      case sensor_locationfi_tclToken::EN_MSG_GNSSWNEPOCHSET:
         return OSAL_NEW sensor_locationfi_tclMsgGnssWnEpochSet;

      case sensor_locationfi_tclToken::EN_MSG_GNSSWNEPOCHSTATUS:
         return OSAL_NEW sensor_locationfi_tclMsgGnssWnEpochStatus;

      case sensor_locationfi_tclToken::EN_MSG_GNSSCONFIGDATAGET:
         return OSAL_NEW sensor_locationfi_tclMsgGnssConfigDataGet;

      case sensor_locationfi_tclToken::EN_MSG_GNSSCONFIGDATAUPREG:
         return OSAL_NEW sensor_locationfi_tclMsgGnssConfigDataUpReg;

      case sensor_locationfi_tclToken::EN_MSG_GNSSCONFIGDATARELUPREG:
         return OSAL_NEW sensor_locationfi_tclMsgGnssConfigDataRelUpReg;

      case sensor_locationfi_tclToken::EN_MSG_GNSSCONFIGDATASTATUS:
         return OSAL_NEW sensor_locationfi_tclMsgGnssConfigDataStatus;

      case sensor_locationfi_tclToken::EN_MSG_GNSSDATAGET:
         return OSAL_NEW sensor_locationfi_tclMsgGnssDataGet;

      case sensor_locationfi_tclToken::EN_MSG_GNSSDATAUPREG:
         return OSAL_NEW sensor_locationfi_tclMsgGnssDataUpReg;

      case sensor_locationfi_tclToken::EN_MSG_GNSSDATARELUPREG:
         return OSAL_NEW sensor_locationfi_tclMsgGnssDataRelUpReg;

      case sensor_locationfi_tclToken::EN_MSG_GNSSDATASTATUS:
         return OSAL_NEW sensor_locationfi_tclMsgGnssDataStatus;

      case sensor_locationfi_tclToken::EN_MSG_ALLSENSORDATAUPREG:
         return OSAL_NEW sensor_locationfi_tclMsgAllSensorDataUpReg;

      case sensor_locationfi_tclToken::EN_MSG_ALLSENSORDATARELUPREG:
         return OSAL_NEW sensor_locationfi_tclMsgAllSensorDataRelUpReg;

      case sensor_locationfi_tclToken::EN_MSG_ALLSENSORDATASTATUS:
         return OSAL_NEW sensor_locationfi_tclMsgAllSensorDataStatus;

      case sensor_locationfi_tclToken::EN_MSG_VDSVERSIONINFOGET:
         return OSAL_NEW sensor_locationfi_tclMsgVdsVersionInfoGet;

      case sensor_locationfi_tclToken::EN_MSG_VDSVERSIONINFOSTATUS:
         return OSAL_NEW sensor_locationfi_tclMsgVdsVersionInfoStatus;

      case sensor_locationfi_tclToken::EN_MSG_ACCTEMPERATUREGET:
         return OSAL_NEW sensor_locationfi_tclMsgAccTemperatureGet;

      case sensor_locationfi_tclToken::EN_MSG_ACCTEMPERATUREUPREG:
         return OSAL_NEW sensor_locationfi_tclMsgAccTemperatureUpReg;

      case sensor_locationfi_tclToken::EN_MSG_ACCTEMPERATURERELUPREG:
         return OSAL_NEW sensor_locationfi_tclMsgAccTemperatureRelUpReg;

      case sensor_locationfi_tclToken::EN_MSG_ACCTEMPERATURESTATUS:
         return OSAL_NEW sensor_locationfi_tclMsgAccTemperatureStatus;

      case sensor_locationfi_tclToken::EN_MSG_DIAGGNSSSATSYSTEMGET:
         return OSAL_NEW sensor_locationfi_tclMsgDiagGnssSatSystemGet;

      case sensor_locationfi_tclToken::EN_MSG_DIAGGNSSSATSYSTEMSET:
         return OSAL_NEW sensor_locationfi_tclMsgDiagGnssSatSystemSet;

      case sensor_locationfi_tclToken::EN_MSG_DIAGGNSSSATSYSTEMSTATUS:
         return OSAL_NEW sensor_locationfi_tclMsgDiagGnssSatSystemStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all sensor_locationfifi messages

// common functions

tU16 sensor_locationfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return SENSOR_LOCATIONFI_C_U16_SERVICE_ID;
}

tU16 sensor_locationfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 sensor_locationfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& sensor_locationfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& sensor_locationfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 sensor_locationfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& sensor_locationfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& sensor_locationfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

sensor_locationfi_tclMsgSavePersistentMethodStart::sensor_locationfi_tclMsgSavePersistentMethodStart()
 {}

tS32 sensor_locationfi_tclMsgSavePersistentMethodStart::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_SAVEPERSISTENTMETHODSTART;
}


sensor_locationfi_tclMsgSavePersistentMethodStart::~sensor_locationfi_tclMsgSavePersistentMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_locationfi_tclMsgSavePersistentMethodResult::sensor_locationfi_tclMsgSavePersistentMethodResult(const sensor_locationfi_tclMsgSavePersistentMethodResult& coRef)
   : sensor_locationfi_tclMsgBaseMessage(coRef)
{
   bSuccess = coRef.bSuccess;
}
sensor_locationfi_tclMsgSavePersistentMethodResult& sensor_locationfi_tclMsgSavePersistentMethodResult::operator=(const sensor_locationfi_tclMsgSavePersistentMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bSuccess = coRef.bSuccess;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_locationfi_tclMsgSavePersistentMethodResult::sensor_locationfi_tclMsgSavePersistentMethodResult()
:bSuccess(0)
 {}

tS32 sensor_locationfi_tclMsgSavePersistentMethodResult::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_SAVEPERSISTENTMETHODRESULT;
}


sensor_locationfi_tclMsgSavePersistentMethodResult::~sensor_locationfi_tclMsgSavePersistentMethodResult()
{}

tU32 sensor_locationfi_tclMsgSavePersistentMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_locationfi_tclMsgSavePersistentMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bSuccess);
   return oIn;
}

fi_tclOutContext& sensor_locationfi_tclMsgSavePersistentMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bSuccess);
   return oOut;
}

tBool sensor_locationfi_tclMsgSavePersistentMethodResult::operator==(const sensor_locationfi_tclMsgSavePersistentMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bSuccess == roRef.bSuccess);
   return bResult;
}

//=============================================================================

sensor_locationfi_tclMsgUpdateDiagLogMethodStart::sensor_locationfi_tclMsgUpdateDiagLogMethodStart()
 {}

tS32 sensor_locationfi_tclMsgUpdateDiagLogMethodStart::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_UPDATEDIAGLOGMETHODSTART;
}


sensor_locationfi_tclMsgUpdateDiagLogMethodStart::~sensor_locationfi_tclMsgUpdateDiagLogMethodStart()
{}

//=============================================================================

sensor_locationfi_tclMsgUpdateDiagLogMethodResult::sensor_locationfi_tclMsgUpdateDiagLogMethodResult()
 {}

tS32 sensor_locationfi_tclMsgUpdateDiagLogMethodResult::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_UPDATEDIAGLOGMETHODRESULT;
}


sensor_locationfi_tclMsgUpdateDiagLogMethodResult::~sensor_locationfi_tclMsgUpdateDiagLogMethodResult()
{}

//=============================================================================

sensor_locationfi_tclMsgFactorySettingsMethodStart::sensor_locationfi_tclMsgFactorySettingsMethodStart()
 {}

tS32 sensor_locationfi_tclMsgFactorySettingsMethodStart::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_FACTORYSETTINGSMETHODSTART;
}


sensor_locationfi_tclMsgFactorySettingsMethodStart::~sensor_locationfi_tclMsgFactorySettingsMethodStart()
{}

//=============================================================================

sensor_locationfi_tclMsgFactorySettingsMethodResult::sensor_locationfi_tclMsgFactorySettingsMethodResult()
 {}

tS32 sensor_locationfi_tclMsgFactorySettingsMethodResult::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_FACTORYSETTINGSMETHODRESULT;
}


sensor_locationfi_tclMsgFactorySettingsMethodResult::~sensor_locationfi_tclMsgFactorySettingsMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_locationfi_tclMsgUpdateFactorySettingsMethodStart::sensor_locationfi_tclMsgUpdateFactorySettingsMethodStart(const sensor_locationfi_tclMsgUpdateFactorySettingsMethodStart& coRef)
   : sensor_locationfi_tclMsgBaseMessage(coRef)
{
   DefSetGroup = coRef.DefSetGroup;
   DefSetMode = coRef.DefSetMode;
}
sensor_locationfi_tclMsgUpdateFactorySettingsMethodStart& sensor_locationfi_tclMsgUpdateFactorySettingsMethodStart::operator=(const sensor_locationfi_tclMsgUpdateFactorySettingsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DefSetGroup = coRef.DefSetGroup;
   DefSetMode = coRef.DefSetMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_locationfi_tclMsgUpdateFactorySettingsMethodStart::sensor_locationfi_tclMsgUpdateFactorySettingsMethodStart()
:DefSetGroup()
,DefSetMode()
 {}

tS32 sensor_locationfi_tclMsgUpdateFactorySettingsMethodStart::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_UPDATEFACTORYSETTINGSMETHODSTART;
}


sensor_locationfi_tclMsgUpdateFactorySettingsMethodStart::~sensor_locationfi_tclMsgUpdateFactorySettingsMethodStart()
{}

tU32 sensor_locationfi_tclMsgUpdateFactorySettingsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sensor_locationfi_tclMsgUpdateFactorySettingsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetGroup);
   (tVoid) (oIn >> DefSetMode);
   return oIn;
}

fi_tclOutContext& sensor_locationfi_tclMsgUpdateFactorySettingsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetGroup);
   (tVoid) (oOut << DefSetMode);
   return oOut;
}

tBool sensor_locationfi_tclMsgUpdateFactorySettingsMethodStart::operator==(const sensor_locationfi_tclMsgUpdateFactorySettingsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetGroup == roRef.DefSetGroup);
   bResult = bResult && (DefSetMode == roRef.DefSetMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_locationfi_tclMsgUpdateFactorySettingsMethodResult::sensor_locationfi_tclMsgUpdateFactorySettingsMethodResult(const sensor_locationfi_tclMsgUpdateFactorySettingsMethodResult& coRef)
   : sensor_locationfi_tclMsgBaseMessage(coRef)
{
   DefSetGroup = coRef.DefSetGroup;
   DefSetMode = coRef.DefSetMode;
   DefSetStateSuccessful = coRef.DefSetStateSuccessful;
}
sensor_locationfi_tclMsgUpdateFactorySettingsMethodResult& sensor_locationfi_tclMsgUpdateFactorySettingsMethodResult::operator=(const sensor_locationfi_tclMsgUpdateFactorySettingsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DefSetGroup = coRef.DefSetGroup;
   DefSetMode = coRef.DefSetMode;
   DefSetStateSuccessful = coRef.DefSetStateSuccessful;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_locationfi_tclMsgUpdateFactorySettingsMethodResult::sensor_locationfi_tclMsgUpdateFactorySettingsMethodResult()
:DefSetGroup()
,DefSetMode()
,DefSetStateSuccessful(0)
 {}

tS32 sensor_locationfi_tclMsgUpdateFactorySettingsMethodResult::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_UPDATEFACTORYSETTINGSMETHODRESULT;
}


sensor_locationfi_tclMsgUpdateFactorySettingsMethodResult::~sensor_locationfi_tclMsgUpdateFactorySettingsMethodResult()
{}

tU32 sensor_locationfi_tclMsgUpdateFactorySettingsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& sensor_locationfi_tclMsgUpdateFactorySettingsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetGroup);
   (tVoid) (oIn >> DefSetMode);
   (tVoid) (oIn >> DefSetStateSuccessful);
   return oIn;
}

fi_tclOutContext& sensor_locationfi_tclMsgUpdateFactorySettingsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetGroup);
   (tVoid) (oOut << DefSetMode);
   (tVoid) (oOut << DefSetStateSuccessful);
   return oOut;
}

tBool sensor_locationfi_tclMsgUpdateFactorySettingsMethodResult::operator==(const sensor_locationfi_tclMsgUpdateFactorySettingsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetGroup == roRef.DefSetGroup);
   bResult = bResult && (DefSetMode == roRef.DefSetMode);
   bResult = bResult && (DefSetStateSuccessful == roRef.DefSetStateSuccessful);
   return bResult;
}

//=============================================================================

sensor_locationfi_tclMsgGyro3dGetHwInfoMethodStart::sensor_locationfi_tclMsgGyro3dGetHwInfoMethodStart()
 {}

tS32 sensor_locationfi_tclMsgGyro3dGetHwInfoMethodStart::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_GYRO3DGETHWINFOMETHODSTART;
}


sensor_locationfi_tclMsgGyro3dGetHwInfoMethodStart::~sensor_locationfi_tclMsgGyro3dGetHwInfoMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_locationfi_tclMsgGyro3dGetHwInfoMethodResult::sensor_locationfi_tclMsgGyro3dGetHwInfoMethodResult(const sensor_locationfi_tclMsgGyro3dGetHwInfoMethodResult& coRef)
   : sensor_locationfi_tclMsgBaseMessage(coRef)
{
   Gyro3dHwInfo = coRef.Gyro3dHwInfo;
}
sensor_locationfi_tclMsgGyro3dGetHwInfoMethodResult& sensor_locationfi_tclMsgGyro3dGetHwInfoMethodResult::operator=(const sensor_locationfi_tclMsgGyro3dGetHwInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Gyro3dHwInfo = coRef.Gyro3dHwInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_locationfi_tclMsgGyro3dGetHwInfoMethodResult::sensor_locationfi_tclMsgGyro3dGetHwInfoMethodResult()
:Gyro3dHwInfo()
 {}

tS32 sensor_locationfi_tclMsgGyro3dGetHwInfoMethodResult::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_GYRO3DGETHWINFOMETHODRESULT;
}


sensor_locationfi_tclMsgGyro3dGetHwInfoMethodResult::~sensor_locationfi_tclMsgGyro3dGetHwInfoMethodResult()
{}

tU32 sensor_locationfi_tclMsgGyro3dGetHwInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 241;
}

fi_tclInContext& sensor_locationfi_tclMsgGyro3dGetHwInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Gyro3dHwInfo);
   return oIn;
}

fi_tclOutContext& sensor_locationfi_tclMsgGyro3dGetHwInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Gyro3dHwInfo);
   return oOut;
}

tBool sensor_locationfi_tclMsgGyro3dGetHwInfoMethodResult::operator==(const sensor_locationfi_tclMsgGyro3dGetHwInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Gyro3dHwInfo == roRef.Gyro3dHwInfo);
   return bResult;
}

//=============================================================================

sensor_locationfi_tclMsgAcc3dGetHwInfoMethodStart::sensor_locationfi_tclMsgAcc3dGetHwInfoMethodStart()
 {}

tS32 sensor_locationfi_tclMsgAcc3dGetHwInfoMethodStart::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_ACC3DGETHWINFOMETHODSTART;
}


sensor_locationfi_tclMsgAcc3dGetHwInfoMethodStart::~sensor_locationfi_tclMsgAcc3dGetHwInfoMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_locationfi_tclMsgAcc3dGetHwInfoMethodResult::sensor_locationfi_tclMsgAcc3dGetHwInfoMethodResult(const sensor_locationfi_tclMsgAcc3dGetHwInfoMethodResult& coRef)
   : sensor_locationfi_tclMsgBaseMessage(coRef)
{
   Acc3dHwInfo = coRef.Acc3dHwInfo;
}
sensor_locationfi_tclMsgAcc3dGetHwInfoMethodResult& sensor_locationfi_tclMsgAcc3dGetHwInfoMethodResult::operator=(const sensor_locationfi_tclMsgAcc3dGetHwInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Acc3dHwInfo = coRef.Acc3dHwInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_locationfi_tclMsgAcc3dGetHwInfoMethodResult::sensor_locationfi_tclMsgAcc3dGetHwInfoMethodResult()
:Acc3dHwInfo()
 {}

tS32 sensor_locationfi_tclMsgAcc3dGetHwInfoMethodResult::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_ACC3DGETHWINFOMETHODRESULT;
}


sensor_locationfi_tclMsgAcc3dGetHwInfoMethodResult::~sensor_locationfi_tclMsgAcc3dGetHwInfoMethodResult()
{}

tU32 sensor_locationfi_tclMsgAcc3dGetHwInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 241;
}

fi_tclInContext& sensor_locationfi_tclMsgAcc3dGetHwInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Acc3dHwInfo);
   return oIn;
}

fi_tclOutContext& sensor_locationfi_tclMsgAcc3dGetHwInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Acc3dHwInfo);
   return oOut;
}

tBool sensor_locationfi_tclMsgAcc3dGetHwInfoMethodResult::operator==(const sensor_locationfi_tclMsgAcc3dGetHwInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Acc3dHwInfo == roRef.Acc3dHwInfo);
   return bResult;
}

//=============================================================================

sensor_locationfi_tclMsgGyroSelfTestMethodStart::sensor_locationfi_tclMsgGyroSelfTestMethodStart()
 {}

tS32 sensor_locationfi_tclMsgGyroSelfTestMethodStart::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_GYROSELFTESTMETHODSTART;
}


sensor_locationfi_tclMsgGyroSelfTestMethodStart::~sensor_locationfi_tclMsgGyroSelfTestMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_locationfi_tclMsgGyroSelfTestMethodResult::sensor_locationfi_tclMsgGyroSelfTestMethodResult(const sensor_locationfi_tclMsgGyroSelfTestMethodResult& coRef)
   : sensor_locationfi_tclMsgBaseMessage(coRef)
{
   bSuccess = coRef.bSuccess;
}
sensor_locationfi_tclMsgGyroSelfTestMethodResult& sensor_locationfi_tclMsgGyroSelfTestMethodResult::operator=(const sensor_locationfi_tclMsgGyroSelfTestMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bSuccess = coRef.bSuccess;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_locationfi_tclMsgGyroSelfTestMethodResult::sensor_locationfi_tclMsgGyroSelfTestMethodResult()
:bSuccess(0)
 {}

tS32 sensor_locationfi_tclMsgGyroSelfTestMethodResult::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_GYROSELFTESTMETHODRESULT;
}


sensor_locationfi_tclMsgGyroSelfTestMethodResult::~sensor_locationfi_tclMsgGyroSelfTestMethodResult()
{}

tU32 sensor_locationfi_tclMsgGyroSelfTestMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_locationfi_tclMsgGyroSelfTestMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bSuccess);
   return oIn;
}

fi_tclOutContext& sensor_locationfi_tclMsgGyroSelfTestMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bSuccess);
   return oOut;
}

tBool sensor_locationfi_tclMsgGyroSelfTestMethodResult::operator==(const sensor_locationfi_tclMsgGyroSelfTestMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bSuccess == roRef.bSuccess);
   return bResult;
}

//=============================================================================

sensor_locationfi_tclMsgAccSelfTestMethodStart::sensor_locationfi_tclMsgAccSelfTestMethodStart()
 {}

tS32 sensor_locationfi_tclMsgAccSelfTestMethodStart::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_ACCSELFTESTMETHODSTART;
}


sensor_locationfi_tclMsgAccSelfTestMethodStart::~sensor_locationfi_tclMsgAccSelfTestMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_locationfi_tclMsgAccSelfTestMethodResult::sensor_locationfi_tclMsgAccSelfTestMethodResult(const sensor_locationfi_tclMsgAccSelfTestMethodResult& coRef)
   : sensor_locationfi_tclMsgBaseMessage(coRef)
{
   bSuccess = coRef.bSuccess;
}
sensor_locationfi_tclMsgAccSelfTestMethodResult& sensor_locationfi_tclMsgAccSelfTestMethodResult::operator=(const sensor_locationfi_tclMsgAccSelfTestMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bSuccess = coRef.bSuccess;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_locationfi_tclMsgAccSelfTestMethodResult::sensor_locationfi_tclMsgAccSelfTestMethodResult()
:bSuccess(0)
 {}

tS32 sensor_locationfi_tclMsgAccSelfTestMethodResult::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_ACCSELFTESTMETHODRESULT;
}


sensor_locationfi_tclMsgAccSelfTestMethodResult::~sensor_locationfi_tclMsgAccSelfTestMethodResult()
{}

tU32 sensor_locationfi_tclMsgAccSelfTestMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_locationfi_tclMsgAccSelfTestMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bSuccess);
   return oIn;
}

fi_tclOutContext& sensor_locationfi_tclMsgAccSelfTestMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bSuccess);
   return oOut;
}

tBool sensor_locationfi_tclMsgAccSelfTestMethodResult::operator==(const sensor_locationfi_tclMsgAccSelfTestMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bSuccess == roRef.bSuccess);
   return bResult;
}

//=============================================================================

sensor_locationfi_tclMsgOdometerData_UpdateGet::sensor_locationfi_tclMsgOdometerData_UpdateGet()
 {}

tS32 sensor_locationfi_tclMsgOdometerData_UpdateGet::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_ODOMETERDATA_UPDATEGET;
}


sensor_locationfi_tclMsgOdometerData_UpdateGet::~sensor_locationfi_tclMsgOdometerData_UpdateGet()
{}

//=============================================================================

sensor_locationfi_tclMsgOdometerData_UpdateUpReg::sensor_locationfi_tclMsgOdometerData_UpdateUpReg()
 {}

tS32 sensor_locationfi_tclMsgOdometerData_UpdateUpReg::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_ODOMETERDATA_UPDATEUPREG;
}


sensor_locationfi_tclMsgOdometerData_UpdateUpReg::~sensor_locationfi_tclMsgOdometerData_UpdateUpReg()
{}

//=============================================================================

sensor_locationfi_tclMsgOdometerData_UpdateRelUpReg::sensor_locationfi_tclMsgOdometerData_UpdateRelUpReg()
 {}

tS32 sensor_locationfi_tclMsgOdometerData_UpdateRelUpReg::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_ODOMETERDATA_UPDATERELUPREG;
}


sensor_locationfi_tclMsgOdometerData_UpdateRelUpReg::~sensor_locationfi_tclMsgOdometerData_UpdateRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_locationfi_tclMsgOdometerData_UpdateStatus::sensor_locationfi_tclMsgOdometerData_UpdateStatus(const sensor_locationfi_tclMsgOdometerData_UpdateStatus& coRef)
   : sensor_locationfi_tclMsgBaseMessage(coRef)
{
   OdometerData = coRef.OdometerData;
   FirstOdomValueIsInitial = coRef.FirstOdomValueIsInitial;
}
sensor_locationfi_tclMsgOdometerData_UpdateStatus& sensor_locationfi_tclMsgOdometerData_UpdateStatus::operator=(const sensor_locationfi_tclMsgOdometerData_UpdateStatus& coRef)
{
   if (this == &coRef) return *this;
   OdometerData = coRef.OdometerData;
   FirstOdomValueIsInitial = coRef.FirstOdomValueIsInitial;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sensor_locationfi_tclMsgOdometerData_UpdateStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < OdometerData.size(); ++u32Idx)
         OdometerData[u32Idx].vDestroy();
   OdometerData.clear();
   }
}

sensor_locationfi_tclMsgOdometerData_UpdateStatus::sensor_locationfi_tclMsgOdometerData_UpdateStatus()

:FirstOdomValueIsInitial(0)
 {}

tS32 sensor_locationfi_tclMsgOdometerData_UpdateStatus::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_ODOMETERDATA_UPDATESTATUS;
}


sensor_locationfi_tclMsgOdometerData_UpdateStatus::~sensor_locationfi_tclMsgOdometerData_UpdateStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sensor_locationfi_tclMsgOdometerData_UpdateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+OdometerData.size()*8;
}

fi_tclInContext& sensor_locationfi_tclMsgOdometerData_UpdateStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < OdometerData.size(); ++u32Idx)
      {
         OdometerData[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      OdometerData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> OdometerData[u32Idx]);
      }
   }
   (tVoid) (oIn >> FirstOdomValueIsInitial);
   return oIn;
}

fi_tclOutContext& sensor_locationfi_tclMsgOdometerData_UpdateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)OdometerData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < OdometerData.size(); ++u32Idx)
         (tVoid) (oOut << OdometerData[u32Idx]);
   }
   (tVoid) (oOut << FirstOdomValueIsInitial);
   return oOut;
}

tBool sensor_locationfi_tclMsgOdometerData_UpdateStatus::operator==(const sensor_locationfi_tclMsgOdometerData_UpdateStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (OdometerData.size() == roRef.OdometerData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OdometerData.size()); ++u32Idx)
            bResult = bResult && (OdometerData[u32Idx] == roRef.OdometerData[u32Idx]);
      }
   bResult = bResult && (FirstOdomValueIsInitial == roRef.FirstOdomValueIsInitial);
   return bResult;
}

//=============================================================================

sensor_locationfi_tclMsgAbsDataGet::sensor_locationfi_tclMsgAbsDataGet()
 {}

tS32 sensor_locationfi_tclMsgAbsDataGet::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_ABSDATAGET;
}


sensor_locationfi_tclMsgAbsDataGet::~sensor_locationfi_tclMsgAbsDataGet()
{}

//=============================================================================

sensor_locationfi_tclMsgAbsDataUpReg::sensor_locationfi_tclMsgAbsDataUpReg()
 {}

tS32 sensor_locationfi_tclMsgAbsDataUpReg::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_ABSDATAUPREG;
}


sensor_locationfi_tclMsgAbsDataUpReg::~sensor_locationfi_tclMsgAbsDataUpReg()
{}

//=============================================================================

sensor_locationfi_tclMsgAbsDataRelUpReg::sensor_locationfi_tclMsgAbsDataRelUpReg()
 {}

tS32 sensor_locationfi_tclMsgAbsDataRelUpReg::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_ABSDATARELUPREG;
}


sensor_locationfi_tclMsgAbsDataRelUpReg::~sensor_locationfi_tclMsgAbsDataRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_locationfi_tclMsgAbsDataStatus::sensor_locationfi_tclMsgAbsDataStatus(const sensor_locationfi_tclMsgAbsDataStatus& coRef)
   : sensor_locationfi_tclMsgBaseMessage(coRef)
{
   AbsData = coRef.AbsData;
}
sensor_locationfi_tclMsgAbsDataStatus& sensor_locationfi_tclMsgAbsDataStatus::operator=(const sensor_locationfi_tclMsgAbsDataStatus& coRef)
{
   if (this == &coRef) return *this;
   AbsData = coRef.AbsData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sensor_locationfi_tclMsgAbsDataStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AbsData.size(); ++u32Idx)
         AbsData[u32Idx].vDestroy();
   AbsData.clear();
   }
}

sensor_locationfi_tclMsgAbsDataStatus::sensor_locationfi_tclMsgAbsDataStatus()

 {}

tS32 sensor_locationfi_tclMsgAbsDataStatus::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_ABSDATASTATUS;
}


sensor_locationfi_tclMsgAbsDataStatus::~sensor_locationfi_tclMsgAbsDataStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sensor_locationfi_tclMsgAbsDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+AbsData.size()*20;
}

fi_tclInContext& sensor_locationfi_tclMsgAbsDataStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AbsData.size(); ++u32Idx)
      {
         AbsData[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AbsData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AbsData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sensor_locationfi_tclMsgAbsDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)AbsData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AbsData.size(); ++u32Idx)
         (tVoid) (oOut << AbsData[u32Idx]);
   }
   return oOut;
}

tBool sensor_locationfi_tclMsgAbsDataStatus::operator==(const sensor_locationfi_tclMsgAbsDataStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (AbsData.size() == roRef.AbsData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AbsData.size()); ++u32Idx)
            bResult = bResult && (AbsData[u32Idx] == roRef.AbsData[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sensor_locationfi_tclMsgGyro3dData_UpdateGet::sensor_locationfi_tclMsgGyro3dData_UpdateGet()
 {}

tS32 sensor_locationfi_tclMsgGyro3dData_UpdateGet::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_GYRO3DDATA_UPDATEGET;
}


sensor_locationfi_tclMsgGyro3dData_UpdateGet::~sensor_locationfi_tclMsgGyro3dData_UpdateGet()
{}

//=============================================================================

sensor_locationfi_tclMsgGyro3dData_UpdateUpReg::sensor_locationfi_tclMsgGyro3dData_UpdateUpReg()
 {}

tS32 sensor_locationfi_tclMsgGyro3dData_UpdateUpReg::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_GYRO3DDATA_UPDATEUPREG;
}


sensor_locationfi_tclMsgGyro3dData_UpdateUpReg::~sensor_locationfi_tclMsgGyro3dData_UpdateUpReg()
{}

//=============================================================================

sensor_locationfi_tclMsgGyro3dData_UpdateRelUpReg::sensor_locationfi_tclMsgGyro3dData_UpdateRelUpReg()
 {}

tS32 sensor_locationfi_tclMsgGyro3dData_UpdateRelUpReg::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_GYRO3DDATA_UPDATERELUPREG;
}


sensor_locationfi_tclMsgGyro3dData_UpdateRelUpReg::~sensor_locationfi_tclMsgGyro3dData_UpdateRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_locationfi_tclMsgGyro3dData_UpdateStatus::sensor_locationfi_tclMsgGyro3dData_UpdateStatus(const sensor_locationfi_tclMsgGyro3dData_UpdateStatus& coRef)
   : sensor_locationfi_tclMsgBaseMessage(coRef)
{
   Gyro3dData = coRef.Gyro3dData;
}
sensor_locationfi_tclMsgGyro3dData_UpdateStatus& sensor_locationfi_tclMsgGyro3dData_UpdateStatus::operator=(const sensor_locationfi_tclMsgGyro3dData_UpdateStatus& coRef)
{
   if (this == &coRef) return *this;
   Gyro3dData = coRef.Gyro3dData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sensor_locationfi_tclMsgGyro3dData_UpdateStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Gyro3dData.size(); ++u32Idx)
         Gyro3dData[u32Idx].vDestroy();
   Gyro3dData.clear();
   }
}

sensor_locationfi_tclMsgGyro3dData_UpdateStatus::sensor_locationfi_tclMsgGyro3dData_UpdateStatus()

 {}

tS32 sensor_locationfi_tclMsgGyro3dData_UpdateStatus::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_GYRO3DDATA_UPDATESTATUS;
}


sensor_locationfi_tclMsgGyro3dData_UpdateStatus::~sensor_locationfi_tclMsgGyro3dData_UpdateStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sensor_locationfi_tclMsgGyro3dData_UpdateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+Gyro3dData.size()*22;
}

fi_tclInContext& sensor_locationfi_tclMsgGyro3dData_UpdateStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Gyro3dData.size(); ++u32Idx)
      {
         Gyro3dData[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Gyro3dData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Gyro3dData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sensor_locationfi_tclMsgGyro3dData_UpdateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Gyro3dData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Gyro3dData.size(); ++u32Idx)
         (tVoid) (oOut << Gyro3dData[u32Idx]);
   }
   return oOut;
}

tBool sensor_locationfi_tclMsgGyro3dData_UpdateStatus::operator==(const sensor_locationfi_tclMsgGyro3dData_UpdateStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Gyro3dData.size() == roRef.Gyro3dData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Gyro3dData.size()); ++u32Idx)
            bResult = bResult && (Gyro3dData[u32Idx] == roRef.Gyro3dData[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sensor_locationfi_tclMsgAcc3dData_UpdateGet::sensor_locationfi_tclMsgAcc3dData_UpdateGet()
 {}

tS32 sensor_locationfi_tclMsgAcc3dData_UpdateGet::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_ACC3DDATA_UPDATEGET;
}


sensor_locationfi_tclMsgAcc3dData_UpdateGet::~sensor_locationfi_tclMsgAcc3dData_UpdateGet()
{}

//=============================================================================

sensor_locationfi_tclMsgAcc3dData_UpdateUpReg::sensor_locationfi_tclMsgAcc3dData_UpdateUpReg()
 {}

tS32 sensor_locationfi_tclMsgAcc3dData_UpdateUpReg::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_ACC3DDATA_UPDATEUPREG;
}


sensor_locationfi_tclMsgAcc3dData_UpdateUpReg::~sensor_locationfi_tclMsgAcc3dData_UpdateUpReg()
{}

//=============================================================================

sensor_locationfi_tclMsgAcc3dData_UpdateRelUpReg::sensor_locationfi_tclMsgAcc3dData_UpdateRelUpReg()
 {}

tS32 sensor_locationfi_tclMsgAcc3dData_UpdateRelUpReg::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_ACC3DDATA_UPDATERELUPREG;
}


sensor_locationfi_tclMsgAcc3dData_UpdateRelUpReg::~sensor_locationfi_tclMsgAcc3dData_UpdateRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_locationfi_tclMsgAcc3dData_UpdateStatus::sensor_locationfi_tclMsgAcc3dData_UpdateStatus(const sensor_locationfi_tclMsgAcc3dData_UpdateStatus& coRef)
   : sensor_locationfi_tclMsgBaseMessage(coRef)
{
   Acc3dData = coRef.Acc3dData;
}
sensor_locationfi_tclMsgAcc3dData_UpdateStatus& sensor_locationfi_tclMsgAcc3dData_UpdateStatus::operator=(const sensor_locationfi_tclMsgAcc3dData_UpdateStatus& coRef)
{
   if (this == &coRef) return *this;
   Acc3dData = coRef.Acc3dData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sensor_locationfi_tclMsgAcc3dData_UpdateStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Acc3dData.size(); ++u32Idx)
         Acc3dData[u32Idx].vDestroy();
   Acc3dData.clear();
   }
}

sensor_locationfi_tclMsgAcc3dData_UpdateStatus::sensor_locationfi_tclMsgAcc3dData_UpdateStatus()

 {}

tS32 sensor_locationfi_tclMsgAcc3dData_UpdateStatus::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_ACC3DDATA_UPDATESTATUS;
}


sensor_locationfi_tclMsgAcc3dData_UpdateStatus::~sensor_locationfi_tclMsgAcc3dData_UpdateStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sensor_locationfi_tclMsgAcc3dData_UpdateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+Acc3dData.size()*22;
}

fi_tclInContext& sensor_locationfi_tclMsgAcc3dData_UpdateStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Acc3dData.size(); ++u32Idx)
      {
         Acc3dData[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Acc3dData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Acc3dData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sensor_locationfi_tclMsgAcc3dData_UpdateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Acc3dData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Acc3dData.size(); ++u32Idx)
         (tVoid) (oOut << Acc3dData[u32Idx]);
   }
   return oOut;
}

tBool sensor_locationfi_tclMsgAcc3dData_UpdateStatus::operator==(const sensor_locationfi_tclMsgAcc3dData_UpdateStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Acc3dData.size() == roRef.Acc3dData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Acc3dData.size()); ++u32Idx)
            bResult = bResult && (Acc3dData[u32Idx] == roRef.Acc3dData[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sensor_locationfi_tclMsgGyroTemperatureGet::sensor_locationfi_tclMsgGyroTemperatureGet()
 {}

tS32 sensor_locationfi_tclMsgGyroTemperatureGet::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_GYROTEMPERATUREGET;
}


sensor_locationfi_tclMsgGyroTemperatureGet::~sensor_locationfi_tclMsgGyroTemperatureGet()
{}

//=============================================================================

sensor_locationfi_tclMsgGyroTemperatureUpReg::sensor_locationfi_tclMsgGyroTemperatureUpReg()
 {}

tS32 sensor_locationfi_tclMsgGyroTemperatureUpReg::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_GYROTEMPERATUREUPREG;
}


sensor_locationfi_tclMsgGyroTemperatureUpReg::~sensor_locationfi_tclMsgGyroTemperatureUpReg()
{}

//=============================================================================

sensor_locationfi_tclMsgGyroTemperatureRelUpReg::sensor_locationfi_tclMsgGyroTemperatureRelUpReg()
 {}

tS32 sensor_locationfi_tclMsgGyroTemperatureRelUpReg::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_GYROTEMPERATURERELUPREG;
}


sensor_locationfi_tclMsgGyroTemperatureRelUpReg::~sensor_locationfi_tclMsgGyroTemperatureRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_locationfi_tclMsgGyroTemperatureStatus::sensor_locationfi_tclMsgGyroTemperatureStatus(const sensor_locationfi_tclMsgGyroTemperatureStatus& coRef)
   : sensor_locationfi_tclMsgBaseMessage(coRef)
{
   GyroTemperature = coRef.GyroTemperature;
}
sensor_locationfi_tclMsgGyroTemperatureStatus& sensor_locationfi_tclMsgGyroTemperatureStatus::operator=(const sensor_locationfi_tclMsgGyroTemperatureStatus& coRef)
{
   if (this == &coRef) return *this;
   GyroTemperature = coRef.GyroTemperature;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_locationfi_tclMsgGyroTemperatureStatus::sensor_locationfi_tclMsgGyroTemperatureStatus()
:GyroTemperature(0)
 {}

tS32 sensor_locationfi_tclMsgGyroTemperatureStatus::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_GYROTEMPERATURESTATUS;
}


sensor_locationfi_tclMsgGyroTemperatureStatus::~sensor_locationfi_tclMsgGyroTemperatureStatus()
{}

tU32 sensor_locationfi_tclMsgGyroTemperatureStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sensor_locationfi_tclMsgGyroTemperatureStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GyroTemperature);
   return oIn;
}

fi_tclOutContext& sensor_locationfi_tclMsgGyroTemperatureStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GyroTemperature);
   return oOut;
}

tBool sensor_locationfi_tclMsgGyroTemperatureStatus::operator==(const sensor_locationfi_tclMsgGyroTemperatureStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GyroTemperature == roRef.GyroTemperature);
   return bResult;
}

//=============================================================================

sensor_locationfi_tclMsgGnssSatSystemGet::sensor_locationfi_tclMsgGnssSatSystemGet()
 {}

tS32 sensor_locationfi_tclMsgGnssSatSystemGet::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_GNSSSATSYSTEMGET;
}


sensor_locationfi_tclMsgGnssSatSystemGet::~sensor_locationfi_tclMsgGnssSatSystemGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_locationfi_tclMsgGnssSatSystemSet::sensor_locationfi_tclMsgGnssSatSystemSet(const sensor_locationfi_tclMsgGnssSatSystemSet& coRef)
   : sensor_locationfi_tclMsgBaseMessage(coRef)
{
   TargetGnssSatSys = coRef.TargetGnssSatSys;
}
sensor_locationfi_tclMsgGnssSatSystemSet& sensor_locationfi_tclMsgGnssSatSystemSet::operator=(const sensor_locationfi_tclMsgGnssSatSystemSet& coRef)
{
   if (this == &coRef) return *this;
   TargetGnssSatSys = coRef.TargetGnssSatSys;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_locationfi_tclMsgGnssSatSystemSet::sensor_locationfi_tclMsgGnssSatSystemSet()
:TargetGnssSatSys()
 {}

tS32 sensor_locationfi_tclMsgGnssSatSystemSet::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_GNSSSATSYSTEMSET;
}


sensor_locationfi_tclMsgGnssSatSystemSet::~sensor_locationfi_tclMsgGnssSatSystemSet()
{}

tU32 sensor_locationfi_tclMsgGnssSatSystemSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_locationfi_tclMsgGnssSatSystemSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TargetGnssSatSys);
   return oIn;
}

fi_tclOutContext& sensor_locationfi_tclMsgGnssSatSystemSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TargetGnssSatSys);
   return oOut;
}

tBool sensor_locationfi_tclMsgGnssSatSystemSet::operator==(const sensor_locationfi_tclMsgGnssSatSystemSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TargetGnssSatSys == roRef.TargetGnssSatSys);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_locationfi_tclMsgGnssSatSystemStatus::sensor_locationfi_tclMsgGnssSatSystemStatus(const sensor_locationfi_tclMsgGnssSatSystemStatus& coRef)
   : sensor_locationfi_tclMsgBaseMessage(coRef)
{
   ActualGnssSatSys = coRef.ActualGnssSatSys;
}
sensor_locationfi_tclMsgGnssSatSystemStatus& sensor_locationfi_tclMsgGnssSatSystemStatus::operator=(const sensor_locationfi_tclMsgGnssSatSystemStatus& coRef)
{
   if (this == &coRef) return *this;
   ActualGnssSatSys = coRef.ActualGnssSatSys;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_locationfi_tclMsgGnssSatSystemStatus::sensor_locationfi_tclMsgGnssSatSystemStatus()
:ActualGnssSatSys()
 {}

tS32 sensor_locationfi_tclMsgGnssSatSystemStatus::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_GNSSSATSYSTEMSTATUS;
}


sensor_locationfi_tclMsgGnssSatSystemStatus::~sensor_locationfi_tclMsgGnssSatSystemStatus()
{}

tU32 sensor_locationfi_tclMsgGnssSatSystemStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_locationfi_tclMsgGnssSatSystemStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ActualGnssSatSys);
   return oIn;
}

fi_tclOutContext& sensor_locationfi_tclMsgGnssSatSystemStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ActualGnssSatSys);
   return oOut;
}

tBool sensor_locationfi_tclMsgGnssSatSystemStatus::operator==(const sensor_locationfi_tclMsgGnssSatSystemStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ActualGnssSatSys == roRef.ActualGnssSatSys);
   return bResult;
}

//=============================================================================

sensor_locationfi_tclMsgGnssWnEpochGet::sensor_locationfi_tclMsgGnssWnEpochGet()
 {}

tS32 sensor_locationfi_tclMsgGnssWnEpochGet::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_GNSSWNEPOCHGET;
}


sensor_locationfi_tclMsgGnssWnEpochGet::~sensor_locationfi_tclMsgGnssWnEpochGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_locationfi_tclMsgGnssWnEpochSet::sensor_locationfi_tclMsgGnssWnEpochSet(const sensor_locationfi_tclMsgGnssWnEpochSet& coRef)
   : sensor_locationfi_tclMsgBaseMessage(coRef)
{
   TargetWnDate = coRef.TargetWnDate;
}
sensor_locationfi_tclMsgGnssWnEpochSet& sensor_locationfi_tclMsgGnssWnEpochSet::operator=(const sensor_locationfi_tclMsgGnssWnEpochSet& coRef)
{
   if (this == &coRef) return *this;
   TargetWnDate = coRef.TargetWnDate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_locationfi_tclMsgGnssWnEpochSet::sensor_locationfi_tclMsgGnssWnEpochSet()
:TargetWnDate()
 {}

tS32 sensor_locationfi_tclMsgGnssWnEpochSet::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_GNSSWNEPOCHSET;
}


sensor_locationfi_tclMsgGnssWnEpochSet::~sensor_locationfi_tclMsgGnssWnEpochSet()
{}

tU32 sensor_locationfi_tclMsgGnssWnEpochSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& sensor_locationfi_tclMsgGnssWnEpochSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TargetWnDate);
   return oIn;
}

fi_tclOutContext& sensor_locationfi_tclMsgGnssWnEpochSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TargetWnDate);
   return oOut;
}

tBool sensor_locationfi_tclMsgGnssWnEpochSet::operator==(const sensor_locationfi_tclMsgGnssWnEpochSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TargetWnDate == roRef.TargetWnDate);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_locationfi_tclMsgGnssWnEpochStatus::sensor_locationfi_tclMsgGnssWnEpochStatus(const sensor_locationfi_tclMsgGnssWnEpochStatus& coRef)
   : sensor_locationfi_tclMsgBaseMessage(coRef)
{
   ActualWnDate = coRef.ActualWnDate;
}
sensor_locationfi_tclMsgGnssWnEpochStatus& sensor_locationfi_tclMsgGnssWnEpochStatus::operator=(const sensor_locationfi_tclMsgGnssWnEpochStatus& coRef)
{
   if (this == &coRef) return *this;
   ActualWnDate = coRef.ActualWnDate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_locationfi_tclMsgGnssWnEpochStatus::sensor_locationfi_tclMsgGnssWnEpochStatus()
:ActualWnDate()
 {}

tS32 sensor_locationfi_tclMsgGnssWnEpochStatus::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_GNSSWNEPOCHSTATUS;
}


sensor_locationfi_tclMsgGnssWnEpochStatus::~sensor_locationfi_tclMsgGnssWnEpochStatus()
{}

tU32 sensor_locationfi_tclMsgGnssWnEpochStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& sensor_locationfi_tclMsgGnssWnEpochStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ActualWnDate);
   return oIn;
}

fi_tclOutContext& sensor_locationfi_tclMsgGnssWnEpochStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ActualWnDate);
   return oOut;
}

tBool sensor_locationfi_tclMsgGnssWnEpochStatus::operator==(const sensor_locationfi_tclMsgGnssWnEpochStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ActualWnDate == roRef.ActualWnDate);
   return bResult;
}

//=============================================================================

sensor_locationfi_tclMsgGnssConfigDataGet::sensor_locationfi_tclMsgGnssConfigDataGet()
 {}

tS32 sensor_locationfi_tclMsgGnssConfigDataGet::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_GNSSCONFIGDATAGET;
}


sensor_locationfi_tclMsgGnssConfigDataGet::~sensor_locationfi_tclMsgGnssConfigDataGet()
{}

//=============================================================================

sensor_locationfi_tclMsgGnssConfigDataUpReg::sensor_locationfi_tclMsgGnssConfigDataUpReg()
 {}

tS32 sensor_locationfi_tclMsgGnssConfigDataUpReg::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_GNSSCONFIGDATAUPREG;
}


sensor_locationfi_tclMsgGnssConfigDataUpReg::~sensor_locationfi_tclMsgGnssConfigDataUpReg()
{}

//=============================================================================

sensor_locationfi_tclMsgGnssConfigDataRelUpReg::sensor_locationfi_tclMsgGnssConfigDataRelUpReg()
 {}

tS32 sensor_locationfi_tclMsgGnssConfigDataRelUpReg::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_GNSSCONFIGDATARELUPREG;
}


sensor_locationfi_tclMsgGnssConfigDataRelUpReg::~sensor_locationfi_tclMsgGnssConfigDataRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_locationfi_tclMsgGnssConfigDataStatus::sensor_locationfi_tclMsgGnssConfigDataStatus(const sensor_locationfi_tclMsgGnssConfigDataStatus& coRef)
   : sensor_locationfi_tclMsgBaseMessage(coRef)
{
   GnssConfigData = coRef.GnssConfigData;
}
sensor_locationfi_tclMsgGnssConfigDataStatus& sensor_locationfi_tclMsgGnssConfigDataStatus::operator=(const sensor_locationfi_tclMsgGnssConfigDataStatus& coRef)
{
   if (this == &coRef) return *this;
   GnssConfigData = coRef.GnssConfigData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_locationfi_tclMsgGnssConfigDataStatus::sensor_locationfi_tclMsgGnssConfigDataStatus()
:GnssConfigData()
 {}

tS32 sensor_locationfi_tclMsgGnssConfigDataStatus::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_GNSSCONFIGDATASTATUS;
}


sensor_locationfi_tclMsgGnssConfigDataStatus::~sensor_locationfi_tclMsgGnssConfigDataStatus()
{}

tU32 sensor_locationfi_tclMsgGnssConfigDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& sensor_locationfi_tclMsgGnssConfigDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GnssConfigData);
   return oIn;
}

fi_tclOutContext& sensor_locationfi_tclMsgGnssConfigDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GnssConfigData);
   return oOut;
}

tBool sensor_locationfi_tclMsgGnssConfigDataStatus::operator==(const sensor_locationfi_tclMsgGnssConfigDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GnssConfigData == roRef.GnssConfigData);
   return bResult;
}

//=============================================================================

sensor_locationfi_tclMsgGnssDataGet::sensor_locationfi_tclMsgGnssDataGet()
 {}

tS32 sensor_locationfi_tclMsgGnssDataGet::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_GNSSDATAGET;
}


sensor_locationfi_tclMsgGnssDataGet::~sensor_locationfi_tclMsgGnssDataGet()
{}

//=============================================================================

sensor_locationfi_tclMsgGnssDataUpReg::sensor_locationfi_tclMsgGnssDataUpReg()
 {}

tS32 sensor_locationfi_tclMsgGnssDataUpReg::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_GNSSDATAUPREG;
}


sensor_locationfi_tclMsgGnssDataUpReg::~sensor_locationfi_tclMsgGnssDataUpReg()
{}

//=============================================================================

sensor_locationfi_tclMsgGnssDataRelUpReg::sensor_locationfi_tclMsgGnssDataRelUpReg()
 {}

tS32 sensor_locationfi_tclMsgGnssDataRelUpReg::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_GNSSDATARELUPREG;
}


sensor_locationfi_tclMsgGnssDataRelUpReg::~sensor_locationfi_tclMsgGnssDataRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_locationfi_tclMsgGnssDataStatus::sensor_locationfi_tclMsgGnssDataStatus(const sensor_locationfi_tclMsgGnssDataStatus& coRef)
   : sensor_locationfi_tclMsgBaseMessage(coRef)
{
   GnssData = coRef.GnssData;
}
sensor_locationfi_tclMsgGnssDataStatus& sensor_locationfi_tclMsgGnssDataStatus::operator=(const sensor_locationfi_tclMsgGnssDataStatus& coRef)
{
   if (this == &coRef) return *this;
   GnssData = coRef.GnssData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sensor_locationfi_tclMsgGnssDataStatus::vDestroy()
{
   GnssData.vDestroy(); 
}

sensor_locationfi_tclMsgGnssDataStatus::sensor_locationfi_tclMsgGnssDataStatus()
:GnssData()
 {}

tS32 sensor_locationfi_tclMsgGnssDataStatus::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_GNSSDATASTATUS;
}


sensor_locationfi_tclMsgGnssDataStatus::~sensor_locationfi_tclMsgGnssDataStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sensor_locationfi_tclMsgGnssDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+GnssData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sensor_locationfi_tclMsgGnssDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GnssData);
   return oIn;
}

fi_tclOutContext& sensor_locationfi_tclMsgGnssDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GnssData);
   return oOut;
}

tBool sensor_locationfi_tclMsgGnssDataStatus::operator==(const sensor_locationfi_tclMsgGnssDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GnssData == roRef.GnssData);
   return bResult;
}

//=============================================================================

sensor_locationfi_tclMsgAllSensorDataUpReg::sensor_locationfi_tclMsgAllSensorDataUpReg()
 {}

tS32 sensor_locationfi_tclMsgAllSensorDataUpReg::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_ALLSENSORDATAUPREG;
}


sensor_locationfi_tclMsgAllSensorDataUpReg::~sensor_locationfi_tclMsgAllSensorDataUpReg()
{}

//=============================================================================

sensor_locationfi_tclMsgAllSensorDataRelUpReg::sensor_locationfi_tclMsgAllSensorDataRelUpReg()
 {}

tS32 sensor_locationfi_tclMsgAllSensorDataRelUpReg::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_ALLSENSORDATARELUPREG;
}


sensor_locationfi_tclMsgAllSensorDataRelUpReg::~sensor_locationfi_tclMsgAllSensorDataRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_locationfi_tclMsgAllSensorDataStatus::sensor_locationfi_tclMsgAllSensorDataStatus(const sensor_locationfi_tclMsgAllSensorDataStatus& coRef)
   : sensor_locationfi_tclMsgBaseMessage(coRef)
{
   SensorDataBlock = coRef.SensorDataBlock;
}
sensor_locationfi_tclMsgAllSensorDataStatus& sensor_locationfi_tclMsgAllSensorDataStatus::operator=(const sensor_locationfi_tclMsgAllSensorDataStatus& coRef)
{
   if (this == &coRef) return *this;
   SensorDataBlock = coRef.SensorDataBlock;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sensor_locationfi_tclMsgAllSensorDataStatus::vDestroy()
{
   SensorDataBlock.vDestroy(); 
}

sensor_locationfi_tclMsgAllSensorDataStatus::sensor_locationfi_tclMsgAllSensorDataStatus()
:SensorDataBlock()
 {}

tS32 sensor_locationfi_tclMsgAllSensorDataStatus::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_ALLSENSORDATASTATUS;
}


sensor_locationfi_tclMsgAllSensorDataStatus::~sensor_locationfi_tclMsgAllSensorDataStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sensor_locationfi_tclMsgAllSensorDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+SensorDataBlock.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sensor_locationfi_tclMsgAllSensorDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SensorDataBlock);
   return oIn;
}

fi_tclOutContext& sensor_locationfi_tclMsgAllSensorDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SensorDataBlock);
   return oOut;
}

tBool sensor_locationfi_tclMsgAllSensorDataStatus::operator==(const sensor_locationfi_tclMsgAllSensorDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SensorDataBlock == roRef.SensorDataBlock);
   return bResult;
}

//=============================================================================

sensor_locationfi_tclMsgVdsVersionInfoGet::sensor_locationfi_tclMsgVdsVersionInfoGet()
 {}

tS32 sensor_locationfi_tclMsgVdsVersionInfoGet::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_VDSVERSIONINFOGET;
}


sensor_locationfi_tclMsgVdsVersionInfoGet::~sensor_locationfi_tclMsgVdsVersionInfoGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_locationfi_tclMsgVdsVersionInfoStatus::sensor_locationfi_tclMsgVdsVersionInfoStatus(const sensor_locationfi_tclMsgVdsVersionInfoStatus& coRef)
   : sensor_locationfi_tclMsgBaseMessage(coRef)
{
   VdsVersion = coRef.VdsVersion;
}
sensor_locationfi_tclMsgVdsVersionInfoStatus& sensor_locationfi_tclMsgVdsVersionInfoStatus::operator=(const sensor_locationfi_tclMsgVdsVersionInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   VdsVersion = coRef.VdsVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sensor_locationfi_tclMsgVdsVersionInfoStatus::vDestroy()
{
   VdsVersion.vDestroy(); 
}

sensor_locationfi_tclMsgVdsVersionInfoStatus::sensor_locationfi_tclMsgVdsVersionInfoStatus()
:VdsVersion()
 {}

tS32 sensor_locationfi_tclMsgVdsVersionInfoStatus::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_VDSVERSIONINFOSTATUS;
}


sensor_locationfi_tclMsgVdsVersionInfoStatus::~sensor_locationfi_tclMsgVdsVersionInfoStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sensor_locationfi_tclMsgVdsVersionInfoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+VdsVersion.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sensor_locationfi_tclMsgVdsVersionInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VdsVersion);
   return oIn;
}

fi_tclOutContext& sensor_locationfi_tclMsgVdsVersionInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VdsVersion);
   return oOut;
}

tBool sensor_locationfi_tclMsgVdsVersionInfoStatus::operator==(const sensor_locationfi_tclMsgVdsVersionInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VdsVersion == roRef.VdsVersion);
   return bResult;
}

//=============================================================================

sensor_locationfi_tclMsgAccTemperatureGet::sensor_locationfi_tclMsgAccTemperatureGet()
 {}

tS32 sensor_locationfi_tclMsgAccTemperatureGet::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_ACCTEMPERATUREGET;
}


sensor_locationfi_tclMsgAccTemperatureGet::~sensor_locationfi_tclMsgAccTemperatureGet()
{}

//=============================================================================

sensor_locationfi_tclMsgAccTemperatureUpReg::sensor_locationfi_tclMsgAccTemperatureUpReg()
 {}

tS32 sensor_locationfi_tclMsgAccTemperatureUpReg::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_ACCTEMPERATUREUPREG;
}


sensor_locationfi_tclMsgAccTemperatureUpReg::~sensor_locationfi_tclMsgAccTemperatureUpReg()
{}

//=============================================================================

sensor_locationfi_tclMsgAccTemperatureRelUpReg::sensor_locationfi_tclMsgAccTemperatureRelUpReg()
 {}

tS32 sensor_locationfi_tclMsgAccTemperatureRelUpReg::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_ACCTEMPERATURERELUPREG;
}


sensor_locationfi_tclMsgAccTemperatureRelUpReg::~sensor_locationfi_tclMsgAccTemperatureRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_locationfi_tclMsgAccTemperatureStatus::sensor_locationfi_tclMsgAccTemperatureStatus(const sensor_locationfi_tclMsgAccTemperatureStatus& coRef)
   : sensor_locationfi_tclMsgBaseMessage(coRef)
{
   AccTemperature = coRef.AccTemperature;
}
sensor_locationfi_tclMsgAccTemperatureStatus& sensor_locationfi_tclMsgAccTemperatureStatus::operator=(const sensor_locationfi_tclMsgAccTemperatureStatus& coRef)
{
   if (this == &coRef) return *this;
   AccTemperature = coRef.AccTemperature;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_locationfi_tclMsgAccTemperatureStatus::sensor_locationfi_tclMsgAccTemperatureStatus()
:AccTemperature(0)
 {}

tS32 sensor_locationfi_tclMsgAccTemperatureStatus::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_ACCTEMPERATURESTATUS;
}


sensor_locationfi_tclMsgAccTemperatureStatus::~sensor_locationfi_tclMsgAccTemperatureStatus()
{}

tU32 sensor_locationfi_tclMsgAccTemperatureStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sensor_locationfi_tclMsgAccTemperatureStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AccTemperature);
   return oIn;
}

fi_tclOutContext& sensor_locationfi_tclMsgAccTemperatureStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AccTemperature);
   return oOut;
}

tBool sensor_locationfi_tclMsgAccTemperatureStatus::operator==(const sensor_locationfi_tclMsgAccTemperatureStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AccTemperature == roRef.AccTemperature);
   return bResult;
}

//=============================================================================

sensor_locationfi_tclMsgDiagGnssSatSystemGet::sensor_locationfi_tclMsgDiagGnssSatSystemGet()
 {}

tS32 sensor_locationfi_tclMsgDiagGnssSatSystemGet::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_DIAGGNSSSATSYSTEMGET;
}


sensor_locationfi_tclMsgDiagGnssSatSystemGet::~sensor_locationfi_tclMsgDiagGnssSatSystemGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_locationfi_tclMsgDiagGnssSatSystemSet::sensor_locationfi_tclMsgDiagGnssSatSystemSet(const sensor_locationfi_tclMsgDiagGnssSatSystemSet& coRef)
   : sensor_locationfi_tclMsgBaseMessage(coRef)
{
   TargetGnssSatSys = coRef.TargetGnssSatSys;
}
sensor_locationfi_tclMsgDiagGnssSatSystemSet& sensor_locationfi_tclMsgDiagGnssSatSystemSet::operator=(const sensor_locationfi_tclMsgDiagGnssSatSystemSet& coRef)
{
   if (this == &coRef) return *this;
   TargetGnssSatSys = coRef.TargetGnssSatSys;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_locationfi_tclMsgDiagGnssSatSystemSet::sensor_locationfi_tclMsgDiagGnssSatSystemSet()
:TargetGnssSatSys()
 {}

tS32 sensor_locationfi_tclMsgDiagGnssSatSystemSet::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_DIAGGNSSSATSYSTEMSET;
}


sensor_locationfi_tclMsgDiagGnssSatSystemSet::~sensor_locationfi_tclMsgDiagGnssSatSystemSet()
{}

tU32 sensor_locationfi_tclMsgDiagGnssSatSystemSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_locationfi_tclMsgDiagGnssSatSystemSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TargetGnssSatSys);
   return oIn;
}

fi_tclOutContext& sensor_locationfi_tclMsgDiagGnssSatSystemSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TargetGnssSatSys);
   return oOut;
}

tBool sensor_locationfi_tclMsgDiagGnssSatSystemSet::operator==(const sensor_locationfi_tclMsgDiagGnssSatSystemSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TargetGnssSatSys == roRef.TargetGnssSatSys);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sensor_locationfi_tclMsgDiagGnssSatSystemStatus::sensor_locationfi_tclMsgDiagGnssSatSystemStatus(const sensor_locationfi_tclMsgDiagGnssSatSystemStatus& coRef)
   : sensor_locationfi_tclMsgBaseMessage(coRef)
{
   ActualGnssSatSys = coRef.ActualGnssSatSys;
}
sensor_locationfi_tclMsgDiagGnssSatSystemStatus& sensor_locationfi_tclMsgDiagGnssSatSystemStatus::operator=(const sensor_locationfi_tclMsgDiagGnssSatSystemStatus& coRef)
{
   if (this == &coRef) return *this;
   ActualGnssSatSys = coRef.ActualGnssSatSys;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sensor_locationfi_tclMsgDiagGnssSatSystemStatus::sensor_locationfi_tclMsgDiagGnssSatSystemStatus()
:ActualGnssSatSys()
 {}

tS32 sensor_locationfi_tclMsgDiagGnssSatSystemStatus::s32GetTypeId() const
{
   return (tS32) sensor_locationfi_tclToken::EN_MSG_DIAGGNSSSATSYSTEMSTATUS;
}


sensor_locationfi_tclMsgDiagGnssSatSystemStatus::~sensor_locationfi_tclMsgDiagGnssSatSystemStatus()
{}

tU32 sensor_locationfi_tclMsgDiagGnssSatSystemStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sensor_locationfi_tclMsgDiagGnssSatSystemStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ActualGnssSatSys);
   return oIn;
}

fi_tclOutContext& sensor_locationfi_tclMsgDiagGnssSatSystemStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ActualGnssSatSys);
   return oOut;
}

tBool sensor_locationfi_tclMsgDiagGnssSatSystemStatus::operator==(const sensor_locationfi_tclMsgDiagGnssSatSystemStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ActualGnssSatSys == roRef.ActualGnssSatSys);
   return bResult;
}

