#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_LOCATIONFI_STDVISITORS
#include "sensor_fi_if.h"

tBool sensor_locationfi_tclDescription::bInitMessage(sensor_locationfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case sensor_locationfi_tclToken::EN_LAST_TOKEN:
   case sensor_locationfi_tclToken::EN_LIST:
   case sensor_locationfi_tclToken::EN_END_OF_STRUCT:
   case sensor_locationfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case sensor_locationfi_tclToken::EN_MSG_SAVEPERSISTENTMETHODRESULT:
   {
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_BOOL,sensor_locationfi_tclSemanticDomain::EN_MSG_BSUCCESS)) && bResult;
   } break;
   case sensor_locationfi_tclToken::EN_MSG_UPDATEFACTORYSETTINGSMETHODSTART:
   {
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_E8_DEFSETMODE,sensor_locationfi_tclSemanticDomain::EN_MSG_DEFSETMODE)) && bResult;
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_E8_DEFSETGROUPS,sensor_locationfi_tclSemanticDomain::EN_MSG_DEFSETGROUP)) && bResult;
   } break;
   case sensor_locationfi_tclToken::EN_MSG_UPDATEFACTORYSETTINGSMETHODRESULT:
   {
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_BOOL,sensor_locationfi_tclSemanticDomain::EN_MSG_DEFSETSTATESUCCESSFUL)) && bResult;
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_E8_DEFSETMODE,sensor_locationfi_tclSemanticDomain::EN_MSG_DEFSETMODE)) && bResult;
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_E8_DEFSETGROUPS,sensor_locationfi_tclSemanticDomain::EN_MSG_DEFSETGROUP)) && bResult;
   } break;
   case sensor_locationfi_tclToken::EN_MSG_GYRO3DGETHWINFOMETHODRESULT:
   {
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_3DGYROHWINFO,sensor_locationfi_tclSemanticDomain::EN_MSG_GYRO3DHWINFO)) && bResult;
   } break;
   case sensor_locationfi_tclToken::EN_MSG_ACC3DGETHWINFOMETHODRESULT:
   {
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_3DACCHWINFO,sensor_locationfi_tclSemanticDomain::EN_MSG_ACC3DHWINFO)) && bResult;
   } break;
   case sensor_locationfi_tclToken::EN_MSG_GYROSELFTESTMETHODRESULT:
   {
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_BOOL,sensor_locationfi_tclSemanticDomain::EN_MSG_BSUCCESS)) && bResult;
   } break;
   case sensor_locationfi_tclToken::EN_MSG_ACCSELFTESTMETHODRESULT:
   {
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_BOOL,sensor_locationfi_tclSemanticDomain::EN_MSG_BSUCCESS)) && bResult;
   } break;
   case sensor_locationfi_tclToken::EN_MSG_ODOMETERDATA_UPDATESTATUS:
   {
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_BOOL,sensor_locationfi_tclSemanticDomain::EN_MSG_FIRSTODOMVALUEISINITIAL)) && bResult;
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_ODOMETERDATA,sensor_locationfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_LIST,sensor_locationfi_tclSemanticDomain::EN_MSG_ODOMETERDATA)) && bResult;
   } break;
   case sensor_locationfi_tclToken::EN_MSG_ABSDATASTATUS:
   {
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_ABSDATA,sensor_locationfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_LIST,sensor_locationfi_tclSemanticDomain::EN_MSG_ABSDATA)) && bResult;
   } break;
   case sensor_locationfi_tclToken::EN_MSG_GYRO3DDATA_UPDATESTATUS:
   {
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_3DGYRODATA,sensor_locationfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_LIST,sensor_locationfi_tclSemanticDomain::EN_MSG_GYRO3DDATA)) && bResult;
   } break;
   case sensor_locationfi_tclToken::EN_MSG_ACC3DDATA_UPDATESTATUS:
   {
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_3DACCDATA,sensor_locationfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_LIST,sensor_locationfi_tclSemanticDomain::EN_MSG_ACC3DDATA)) && bResult;
   } break;
   case sensor_locationfi_tclToken::EN_MSG_GYROTEMPERATURESTATUS:
   {
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_MSG_GYROTEMPERATURE)) && bResult;
   } break;
   case sensor_locationfi_tclToken::EN_MSG_GNSSSATSYSTEMSET:
   {
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_B8_GNSSSATSYS,sensor_locationfi_tclSemanticDomain::EN_MSG_TARGETGNSSSATSYS)) && bResult;
   } break;
   case sensor_locationfi_tclToken::EN_MSG_GNSSSATSYSTEMSTATUS:
   {
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_B8_GNSSSATSYS,sensor_locationfi_tclSemanticDomain::EN_MSG_ACTUALGNSSSATSYS)) && bResult;
   } break;
   case sensor_locationfi_tclToken::EN_MSG_GNSSWNEPOCHSET:
   {
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_TIMEDATE,sensor_locationfi_tclSemanticDomain::EN_MSG_TARGETWNDATE)) && bResult;
   } break;
   case sensor_locationfi_tclToken::EN_MSG_GNSSWNEPOCHSTATUS:
   {
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_TIMEDATE,sensor_locationfi_tclSemanticDomain::EN_MSG_ACTUALWNDATE)) && bResult;
   } break;
   case sensor_locationfi_tclToken::EN_MSG_GNSSCONFIGDATASTATUS:
   {
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_GNSSCONFIGDATA,sensor_locationfi_tclSemanticDomain::EN_MSG_GNSSCONFIGDATA)) && bResult;
   } break;
   case sensor_locationfi_tclToken::EN_MSG_GNSSDATASTATUS:
   {
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_GNSSDATA,sensor_locationfi_tclSemanticDomain::EN_MSG_GNSSDATA)) && bResult;
   } break;
   case sensor_locationfi_tclToken::EN_MSG_ALLSENSORDATASTATUS:
   {
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_ALLSENSORDATA,sensor_locationfi_tclSemanticDomain::EN_MSG_SENSORDATABLOCK)) && bResult;
   } break;
   case sensor_locationfi_tclToken::EN_MSG_VDSVERSIONINFOSTATUS:
   {
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_VDSVERSIONINFO,sensor_locationfi_tclSemanticDomain::EN_MSG_VDSVERSION)) && bResult;
   } break;
   case sensor_locationfi_tclToken::EN_MSG_ACCTEMPERATURESTATUS:
   {
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_MSG_ACCTEMPERATURE)) && bResult;
   } break;
   case sensor_locationfi_tclToken::EN_MSG_DIAGGNSSSATSYSTEMSET:
   {
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_B8_GNSSSATSYS,sensor_locationfi_tclSemanticDomain::EN_MSG_TARGETGNSSSATSYS)) && bResult;
   } break;
   case sensor_locationfi_tclToken::EN_MSG_DIAGGNSSSATSYSTEMSTATUS:
   {
      bResult = oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_B8_GNSSSATSYS,sensor_locationfi_tclSemanticDomain::EN_MSG_ACTUALGNSSSATSYS)) && bResult;
   } break;
   case sensor_locationfi_tclToken::EN_MSG_SAVEPERSISTENTMETHODSTART:
   case sensor_locationfi_tclToken::EN_MSG_UPDATEDIAGLOGMETHODSTART:
   case sensor_locationfi_tclToken::EN_MSG_UPDATEDIAGLOGMETHODRESULT:
   case sensor_locationfi_tclToken::EN_MSG_FACTORYSETTINGSMETHODSTART:
   case sensor_locationfi_tclToken::EN_MSG_FACTORYSETTINGSMETHODRESULT:
   case sensor_locationfi_tclToken::EN_MSG_GYRO3DGETHWINFOMETHODSTART:
   case sensor_locationfi_tclToken::EN_MSG_ACC3DGETHWINFOMETHODSTART:
   case sensor_locationfi_tclToken::EN_MSG_GYROSELFTESTMETHODSTART:
   case sensor_locationfi_tclToken::EN_MSG_ACCSELFTESTMETHODSTART:
   case sensor_locationfi_tclToken::EN_MSG_ODOMETERDATA_UPDATEGET:
   case sensor_locationfi_tclToken::EN_MSG_ODOMETERDATA_UPDATEUPREG:
   case sensor_locationfi_tclToken::EN_MSG_ODOMETERDATA_UPDATERELUPREG:
   case sensor_locationfi_tclToken::EN_MSG_ABSDATAGET:
   case sensor_locationfi_tclToken::EN_MSG_ABSDATAUPREG:
   case sensor_locationfi_tclToken::EN_MSG_ABSDATARELUPREG:
   case sensor_locationfi_tclToken::EN_MSG_GYRO3DDATA_UPDATEGET:
   case sensor_locationfi_tclToken::EN_MSG_GYRO3DDATA_UPDATEUPREG:
   case sensor_locationfi_tclToken::EN_MSG_GYRO3DDATA_UPDATERELUPREG:
   case sensor_locationfi_tclToken::EN_MSG_ACC3DDATA_UPDATEGET:
   case sensor_locationfi_tclToken::EN_MSG_ACC3DDATA_UPDATEUPREG:
   case sensor_locationfi_tclToken::EN_MSG_ACC3DDATA_UPDATERELUPREG:
   case sensor_locationfi_tclToken::EN_MSG_GYROTEMPERATUREGET:
   case sensor_locationfi_tclToken::EN_MSG_GYROTEMPERATUREUPREG:
   case sensor_locationfi_tclToken::EN_MSG_GYROTEMPERATURERELUPREG:
   case sensor_locationfi_tclToken::EN_MSG_GNSSSATSYSTEMGET:
   case sensor_locationfi_tclToken::EN_MSG_GNSSWNEPOCHGET:
   case sensor_locationfi_tclToken::EN_MSG_GNSSCONFIGDATAGET:
   case sensor_locationfi_tclToken::EN_MSG_GNSSCONFIGDATAUPREG:
   case sensor_locationfi_tclToken::EN_MSG_GNSSCONFIGDATARELUPREG:
   case sensor_locationfi_tclToken::EN_MSG_GNSSDATAGET:
   case sensor_locationfi_tclToken::EN_MSG_GNSSDATAUPREG:
   case sensor_locationfi_tclToken::EN_MSG_GNSSDATARELUPREG:
   case sensor_locationfi_tclToken::EN_MSG_ALLSENSORDATAUPREG:
   case sensor_locationfi_tclToken::EN_MSG_ALLSENSORDATARELUPREG:
   case sensor_locationfi_tclToken::EN_MSG_VDSVERSIONINFOGET:
   case sensor_locationfi_tclToken::EN_MSG_ACCTEMPERATUREGET:
   case sensor_locationfi_tclToken::EN_MSG_ACCTEMPERATUREUPREG:
   case sensor_locationfi_tclToken::EN_MSG_ACCTEMPERATURERELUPREG:
   case sensor_locationfi_tclToken::EN_MSG_DIAGGNSSSATSYSTEMGET:
   case sensor_locationfi_tclToken::EN_BINCONTAINER:
   case sensor_locationfi_tclToken::EN_VDSVERSIONINFO:
   case sensor_locationfi_tclToken::EN_E8_ODOMETERSTATUS:
   case sensor_locationfi_tclToken::EN_E8_ODOMETERDIRECTION:
   case sensor_locationfi_tclToken::EN_ODOMETERDATA:
   case sensor_locationfi_tclToken::EN_E8_ABSSTATUS:
   case sensor_locationfi_tclToken::EN_E8_ABSDIRECTION:
   case sensor_locationfi_tclToken::EN_ABSDATA:
   case sensor_locationfi_tclToken::EN_SENSORHWINFO:
   case sensor_locationfi_tclToken::EN_3DMOUNTANGLES:
   case sensor_locationfi_tclToken::EN_E16_GYROSTATUS:
   case sensor_locationfi_tclToken::EN_E16_ACCSTATUS:
   case sensor_locationfi_tclToken::EN_3DGYROHWINFO:
   case sensor_locationfi_tclToken::EN_3DACCHWINFO:
   case sensor_locationfi_tclToken::EN_3DGYRODATA:
   case sensor_locationfi_tclToken::EN_3DACCDATA:
   case sensor_locationfi_tclToken::EN_E8_GNSSHW:
   case sensor_locationfi_tclToken::EN_B8_GNSSSATSYS:
   case sensor_locationfi_tclToken::EN_B8_GNSSSATSTATUS:
   case sensor_locationfi_tclToken::EN_GNSSCONFIGDATA:
   case sensor_locationfi_tclToken::EN_E8_GNSSQUALITY:
   case sensor_locationfi_tclToken::EN_E8_GNSSMODE:
   case sensor_locationfi_tclToken::EN_GNSSSTATUS:
   case sensor_locationfi_tclToken::EN_COVARIANCEMATRIXUPPERTRIANGLE:
   case sensor_locationfi_tclToken::EN_TIMEDATE:
   case sensor_locationfi_tclToken::EN_GNSSCHANDATA:
   case sensor_locationfi_tclToken::EN_GNSSPVTDATA:
   case sensor_locationfi_tclToken::EN_GNSSDATA:
   case sensor_locationfi_tclToken::EN_E8_DEFSETGROUPS:
   case sensor_locationfi_tclToken::EN_E8_DEFSETMODE:
   case sensor_locationfi_tclToken::EN_ALLSENSORDATA:
   case sensor_locationfi_tclToken::EN_U8:   
   case sensor_locationfi_tclToken::EN_S8:   
   case sensor_locationfi_tclToken::EN_U16:   
   case sensor_locationfi_tclToken::EN_S16:   
   case sensor_locationfi_tclToken::EN_U24:   
   case sensor_locationfi_tclToken::EN_S24:   
   case sensor_locationfi_tclToken::EN_U32:   
   case sensor_locationfi_tclToken::EN_S32:   
   case sensor_locationfi_tclToken::EN_U64:   
   case sensor_locationfi_tclToken::EN_S64:   
   case sensor_locationfi_tclToken::EN_F32:   
   case sensor_locationfi_tclToken::EN_F64:   
   case sensor_locationfi_tclToken::EN_BOOL:   
   case sensor_locationfi_tclToken::EN_STRING:   
   case sensor_locationfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(enMsgToken,sensor_locationfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool sensor_locationfi_tclDescription::bDoIt(sensor_fi_tclVisitableTypeBase& oTypeBase)
{
   // --Lesen oder Schreiben?
   if (enType==EN_PARSING)
   {
     // --Erst einlesen, dann Besucher bergeben.
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --Erst Besucher bergeben, dann ausgeben
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool sensor_locationfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      sensor_locationfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      sensor_locationfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      sensor_locationfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == sensor_locationfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(sensor_locationfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case sensor_locationfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == sensor_locationfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case sensor_locationfi_tclToken::EN_LIST: 
      {
         sensor_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            sensor_locationfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            sensor_locationfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case sensor_locationfi_tclToken::EN_U8: 
      {
         sensor_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case sensor_locationfi_tclToken::EN_U16: 
      {
         sensor_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_locationfi_tclToken::EN_U24: 
      {
         sensor_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_locationfi_tclToken::EN_U32: 
      {
         sensor_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_locationfi_tclToken::EN_U64: 
      {
         sensor_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_locationfi_tclToken::EN_S8: 
      {
         sensor_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_locationfi_tclToken::EN_S16: 
      {
         sensor_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_locationfi_tclToken::EN_S24: 
      {
         sensor_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_locationfi_tclToken::EN_S32: 
      {
         sensor_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_locationfi_tclToken::EN_S64: 
      {
         sensor_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_locationfi_tclToken::EN_F32: 
      {
         sensor_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_locationfi_tclToken::EN_F64: 
      {
         sensor_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_locationfi_tclToken::EN_BOOL: 
      {
         sensor_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_locationfi_tclToken::EN_STRING: 
      {
         sensor_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_locationfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         sensor_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case sensor_locationfi_tclToken::EN_MSG_SAVEPERSISTENTMETHODSTART:
      case sensor_locationfi_tclToken::EN_MSG_SAVEPERSISTENTMETHODRESULT:
      case sensor_locationfi_tclToken::EN_MSG_UPDATEDIAGLOGMETHODSTART:
      case sensor_locationfi_tclToken::EN_MSG_UPDATEDIAGLOGMETHODRESULT:
      case sensor_locationfi_tclToken::EN_MSG_FACTORYSETTINGSMETHODSTART:
      case sensor_locationfi_tclToken::EN_MSG_FACTORYSETTINGSMETHODRESULT:
      case sensor_locationfi_tclToken::EN_MSG_UPDATEFACTORYSETTINGSMETHODSTART:
      case sensor_locationfi_tclToken::EN_MSG_UPDATEFACTORYSETTINGSMETHODRESULT:
      case sensor_locationfi_tclToken::EN_MSG_GYRO3DGETHWINFOMETHODSTART:
      case sensor_locationfi_tclToken::EN_MSG_GYRO3DGETHWINFOMETHODRESULT:
      case sensor_locationfi_tclToken::EN_MSG_ACC3DGETHWINFOMETHODSTART:
      case sensor_locationfi_tclToken::EN_MSG_ACC3DGETHWINFOMETHODRESULT:
      case sensor_locationfi_tclToken::EN_MSG_GYROSELFTESTMETHODSTART:
      case sensor_locationfi_tclToken::EN_MSG_GYROSELFTESTMETHODRESULT:
      case sensor_locationfi_tclToken::EN_MSG_ACCSELFTESTMETHODSTART:
      case sensor_locationfi_tclToken::EN_MSG_ACCSELFTESTMETHODRESULT:
      case sensor_locationfi_tclToken::EN_MSG_ODOMETERDATA_UPDATEGET:
      case sensor_locationfi_tclToken::EN_MSG_ODOMETERDATA_UPDATEUPREG:
      case sensor_locationfi_tclToken::EN_MSG_ODOMETERDATA_UPDATERELUPREG:
      case sensor_locationfi_tclToken::EN_MSG_ODOMETERDATA_UPDATESTATUS:
      case sensor_locationfi_tclToken::EN_MSG_ABSDATAGET:
      case sensor_locationfi_tclToken::EN_MSG_ABSDATAUPREG:
      case sensor_locationfi_tclToken::EN_MSG_ABSDATARELUPREG:
      case sensor_locationfi_tclToken::EN_MSG_ABSDATASTATUS:
      case sensor_locationfi_tclToken::EN_MSG_GYRO3DDATA_UPDATEGET:
      case sensor_locationfi_tclToken::EN_MSG_GYRO3DDATA_UPDATEUPREG:
      case sensor_locationfi_tclToken::EN_MSG_GYRO3DDATA_UPDATERELUPREG:
      case sensor_locationfi_tclToken::EN_MSG_GYRO3DDATA_UPDATESTATUS:
      case sensor_locationfi_tclToken::EN_MSG_ACC3DDATA_UPDATEGET:
      case sensor_locationfi_tclToken::EN_MSG_ACC3DDATA_UPDATEUPREG:
      case sensor_locationfi_tclToken::EN_MSG_ACC3DDATA_UPDATERELUPREG:
      case sensor_locationfi_tclToken::EN_MSG_ACC3DDATA_UPDATESTATUS:
      case sensor_locationfi_tclToken::EN_MSG_GYROTEMPERATUREGET:
      case sensor_locationfi_tclToken::EN_MSG_GYROTEMPERATUREUPREG:
      case sensor_locationfi_tclToken::EN_MSG_GYROTEMPERATURERELUPREG:
      case sensor_locationfi_tclToken::EN_MSG_GYROTEMPERATURESTATUS:
      case sensor_locationfi_tclToken::EN_MSG_GNSSSATSYSTEMGET:
      case sensor_locationfi_tclToken::EN_MSG_GNSSSATSYSTEMSET:
      case sensor_locationfi_tclToken::EN_MSG_GNSSSATSYSTEMSTATUS:
      case sensor_locationfi_tclToken::EN_MSG_GNSSWNEPOCHGET:
      case sensor_locationfi_tclToken::EN_MSG_GNSSWNEPOCHSET:
      case sensor_locationfi_tclToken::EN_MSG_GNSSWNEPOCHSTATUS:
      case sensor_locationfi_tclToken::EN_MSG_GNSSCONFIGDATAGET:
      case sensor_locationfi_tclToken::EN_MSG_GNSSCONFIGDATAUPREG:
      case sensor_locationfi_tclToken::EN_MSG_GNSSCONFIGDATARELUPREG:
      case sensor_locationfi_tclToken::EN_MSG_GNSSCONFIGDATASTATUS:
      case sensor_locationfi_tclToken::EN_MSG_GNSSDATAGET:
      case sensor_locationfi_tclToken::EN_MSG_GNSSDATAUPREG:
      case sensor_locationfi_tclToken::EN_MSG_GNSSDATARELUPREG:
      case sensor_locationfi_tclToken::EN_MSG_GNSSDATASTATUS:
      case sensor_locationfi_tclToken::EN_MSG_ALLSENSORDATAUPREG:
      case sensor_locationfi_tclToken::EN_MSG_ALLSENSORDATARELUPREG:
      case sensor_locationfi_tclToken::EN_MSG_ALLSENSORDATASTATUS:
      case sensor_locationfi_tclToken::EN_MSG_VDSVERSIONINFOGET:
      case sensor_locationfi_tclToken::EN_MSG_VDSVERSIONINFOSTATUS:
      case sensor_locationfi_tclToken::EN_MSG_ACCTEMPERATUREGET:
      case sensor_locationfi_tclToken::EN_MSG_ACCTEMPERATUREUPREG:
      case sensor_locationfi_tclToken::EN_MSG_ACCTEMPERATURERELUPREG:
      case sensor_locationfi_tclToken::EN_MSG_ACCTEMPERATURESTATUS:
      case sensor_locationfi_tclToken::EN_MSG_DIAGGNSSSATSYSTEMGET:
      case sensor_locationfi_tclToken::EN_MSG_DIAGGNSSSATSYSTEMSET:
      case sensor_locationfi_tclToken::EN_MSG_DIAGGNSSSATSYSTEMSTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case sensor_locationfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_END_OF_STRUCT,sensor_locationfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U8,sensor_locationfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_LIST,sensor_locationfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         sensor_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sensor_locationfi_tclToken::EN_VDSVERSIONINFO:
      {
      if (poVisitor->bDoExpand_VdsVersionInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_END_OF_STRUCT,sensor_locationfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_STRING,sensor_locationfi_tclSemanticDomain::EN_BOARDVERSION));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_STRING,sensor_locationfi_tclSemanticDomain::EN_VDSVERSION));
      }
      else
      {
         sensor_fi_tcl_VdsVersionInfo o_VdsVersionInfo;
         if (!bDoIt(o_VdsVersionInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VdsVersionInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VdsVersionInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sensor_locationfi_tclToken::EN_E8_ODOMETERSTATUS:
      {
         sensor_fi_tcl_e8_OdometerStatus o_e8_OdometerStatus;
         if (!bDoIt(o_e8_OdometerStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_locationfi_tclToken::EN_E8_ODOMETERDIRECTION:
      {
         sensor_fi_tcl_e8_OdometerDirection o_e8_OdometerDirection;
         if (!bDoIt(o_e8_OdometerDirection))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_locationfi_tclToken::EN_ODOMETERDATA:
      {
      if (poVisitor->bDoExpand_OdometerData(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_END_OF_STRUCT,sensor_locationfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_E8_ODOMETERDIRECTION,sensor_locationfi_tclSemanticDomain::EN_ODOMETERCOUNT_DIRECTION));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_E8_ODOMETERSTATUS,sensor_locationfi_tclSemanticDomain::EN_ODOMETERSTATUS));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U16,sensor_locationfi_tclSemanticDomain::EN_ODOMETERCOUNT));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U32,sensor_locationfi_tclSemanticDomain::EN_TIMESTAMP));
      }
      else
      {
         sensor_fi_tcl_OdometerData o_OdometerData;
         if (!bDoIt(o_OdometerData))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_OdometerData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_OdometerData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sensor_locationfi_tclToken::EN_E8_ABSSTATUS:
      {
         sensor_fi_tcl_e8_AbsStatus o_e8_AbsStatus;
         if (!bDoIt(o_e8_AbsStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_locationfi_tclToken::EN_E8_ABSDIRECTION:
      {
         sensor_fi_tcl_e8_AbsDirection o_e8_AbsDirection;
         if (!bDoIt(o_e8_AbsDirection))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_locationfi_tclToken::EN_ABSDATA:
      {
      if (poVisitor->bDoExpand_AbsData(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_END_OF_STRUCT,sensor_locationfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_E8_ABSDIRECTION,sensor_locationfi_tclSemanticDomain::EN_DIRECTIONREARRIGHT));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_E8_ABSDIRECTION,sensor_locationfi_tclSemanticDomain::EN_DIRECTIONREARLEFT));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_E8_ABSDIRECTION,sensor_locationfi_tclSemanticDomain::EN_DIRECTIONFRONTRIGHT));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_E8_ABSDIRECTION,sensor_locationfi_tclSemanticDomain::EN_DIRECTIONFRONTLEFT));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_E8_ABSSTATUS,sensor_locationfi_tclSemanticDomain::EN_STATUSREARRIGHT));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_E8_ABSSTATUS,sensor_locationfi_tclSemanticDomain::EN_STATUSREARLEFT));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_E8_ABSSTATUS,sensor_locationfi_tclSemanticDomain::EN_STATUSFRONTRIGHT));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_E8_ABSSTATUS,sensor_locationfi_tclSemanticDomain::EN_STATUSFRONTLEFT));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U16,sensor_locationfi_tclSemanticDomain::EN_WHEELCOUNTERREARRIGHT));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U16,sensor_locationfi_tclSemanticDomain::EN_WHEELCOUNTERREARLEFT));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U16,sensor_locationfi_tclSemanticDomain::EN_WHEELCOUNTERFRONTRIGHT));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U16,sensor_locationfi_tclSemanticDomain::EN_WHEELCOUNTERFRONTLEFT));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U32,sensor_locationfi_tclSemanticDomain::EN_ABSTIMESTAMP));
      }
      else
      {
         sensor_fi_tcl_AbsData o_AbsData;
         if (!bDoIt(o_AbsData))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AbsData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AbsData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sensor_locationfi_tclToken::EN_SENSORHWINFO:
      {
      if (poVisitor->bDoExpand_SensorHwInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_END_OF_STRUCT,sensor_locationfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_DRIFTSCALEFACTORTIME));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_DRIFTOFFSETTIME));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_BESTCALIBSCALEFACTOR));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_MAXUNSTEADSCALEFACTOR));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_DRIFTSCALEFACTOR));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_MAXSCALEFACTOR));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_MINSCALEFACTOR));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_ESTIMSCALEFACTOR));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_BESTCALIBOFFSET));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_MAXUNSTEADOFFSET));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_DRIFTOFFSET));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_MAXOFFSET));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_MINOFFSET));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_ESTIMOFFSET));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_MINNOISEVALUE));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U32,sensor_locationfi_tclSemanticDomain::EN_SAMPLEMAX));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U32,sensor_locationfi_tclSemanticDomain::EN_SAMPLEMIN));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U32,sensor_locationfi_tclSemanticDomain::EN_ADCRANGEMAX));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U32,sensor_locationfi_tclSemanticDomain::EN_ADCRANGEMIN));
      }
      else
      {
         sensor_fi_tcl_SensorHwInfo o_SensorHwInfo;
         if (!bDoIt(o_SensorHwInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SensorHwInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SensorHwInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sensor_locationfi_tclToken::EN_3DMOUNTANGLES:
      {
      if (poVisitor->bDoExpand_3dMountAngles(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_END_OF_STRUCT,sensor_locationfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U8,sensor_locationfi_tclSemanticDomain::EN_ANGTZ));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U8,sensor_locationfi_tclSemanticDomain::EN_ANGTY));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U8,sensor_locationfi_tclSemanticDomain::EN_ANGTX));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U8,sensor_locationfi_tclSemanticDomain::EN_ANGSZ));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U8,sensor_locationfi_tclSemanticDomain::EN_ANGSY));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U8,sensor_locationfi_tclSemanticDomain::EN_ANGSX));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U8,sensor_locationfi_tclSemanticDomain::EN_ANGRZ));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U8,sensor_locationfi_tclSemanticDomain::EN_ANGRY));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U8,sensor_locationfi_tclSemanticDomain::EN_ANGRX));
      }
      else
      {
         sensor_fi_tcl_3dMountAngles o_3dMountAngles;
         if (!bDoIt(o_3dMountAngles))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_3dMountAngles.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_3dMountAngles.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sensor_locationfi_tclToken::EN_E16_GYROSTATUS:
      {
         sensor_fi_tcl_e16_GyroStatus o_e16_GyroStatus;
         if (!bDoIt(o_e16_GyroStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_locationfi_tclToken::EN_E16_ACCSTATUS:
      {
         sensor_fi_tcl_e16_AccStatus o_e16_AccStatus;
         if (!bDoIt(o_e16_AccStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_locationfi_tclToken::EN_3DGYROHWINFO:
      {
      if (poVisitor->bDoExpand_3dGyroHwInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_END_OF_STRUCT,sensor_locationfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_SENSORHWINFO,sensor_locationfi_tclSemanticDomain::EN_TAXES));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_SENSORHWINFO,sensor_locationfi_tclSemanticDomain::EN_SAXES));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_SENSORHWINFO,sensor_locationfi_tclSemanticDomain::EN_RAXES));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_3DMOUNTANGLES,sensor_locationfi_tclSemanticDomain::EN_MOUNTANGLES));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U32,sensor_locationfi_tclSemanticDomain::EN_SAMPLERATE));
      }
      else
      {
         sensor_fi_tcl_3dGyroHwInfo o_3dGyroHwInfo;
         if (!bDoIt(o_3dGyroHwInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_3dGyroHwInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_3dGyroHwInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sensor_locationfi_tclToken::EN_3DACCHWINFO:
      {
      if (poVisitor->bDoExpand_3dAccHwInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_END_OF_STRUCT,sensor_locationfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_SENSORHWINFO,sensor_locationfi_tclSemanticDomain::EN_TAXES));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_SENSORHWINFO,sensor_locationfi_tclSemanticDomain::EN_SAXES));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_SENSORHWINFO,sensor_locationfi_tclSemanticDomain::EN_RAXES));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_3DMOUNTANGLES,sensor_locationfi_tclSemanticDomain::EN_MOUNTANGLES));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U32,sensor_locationfi_tclSemanticDomain::EN_SAMPLERATE));
      }
      else
      {
         sensor_fi_tcl_3dAccHwInfo o_3dAccHwInfo;
         if (!bDoIt(o_3dAccHwInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_3dAccHwInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_3dAccHwInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sensor_locationfi_tclToken::EN_3DGYRODATA:
      {
      if (poVisitor->bDoExpand_3dGyroData(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_END_OF_STRUCT,sensor_locationfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_E16_GYROSTATUS,sensor_locationfi_tclSemanticDomain::EN_TSTATUS));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_E16_GYROSTATUS,sensor_locationfi_tclSemanticDomain::EN_SSTATUS));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_E16_GYROSTATUS,sensor_locationfi_tclSemanticDomain::EN_RSTATUS));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U32,sensor_locationfi_tclSemanticDomain::EN_TVAL));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U32,sensor_locationfi_tclSemanticDomain::EN_SVAL));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U32,sensor_locationfi_tclSemanticDomain::EN_RVAL));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U32,sensor_locationfi_tclSemanticDomain::EN_TIMESTAMP3DGYRO));
      }
      else
      {
         sensor_fi_tcl_3dGyroData o_3dGyroData;
         if (!bDoIt(o_3dGyroData))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_3dGyroData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_3dGyroData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sensor_locationfi_tclToken::EN_3DACCDATA:
      {
      if (poVisitor->bDoExpand_3dAccData(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_END_OF_STRUCT,sensor_locationfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_E16_ACCSTATUS,sensor_locationfi_tclSemanticDomain::EN_TSTATUS));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_E16_ACCSTATUS,sensor_locationfi_tclSemanticDomain::EN_SSTATUS));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_E16_ACCSTATUS,sensor_locationfi_tclSemanticDomain::EN_RSTATUS));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U32,sensor_locationfi_tclSemanticDomain::EN_TVAL));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U32,sensor_locationfi_tclSemanticDomain::EN_SVAL));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U32,sensor_locationfi_tclSemanticDomain::EN_RVAL));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U32,sensor_locationfi_tclSemanticDomain::EN_TIMESTAMP3DACC));
      }
      else
      {
         sensor_fi_tcl_3dAccData o_3dAccData;
         if (!bDoIt(o_3dAccData))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_3dAccData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_3dAccData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sensor_locationfi_tclToken::EN_E8_GNSSHW:
      {
         sensor_fi_tcl_e8_GnssHw o_e8_GnssHw;
         if (!bDoIt(o_e8_GnssHw))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_locationfi_tclToken::EN_B8_GNSSSATSYS:
      {
         sensor_fi_tcl_b8_GnssSatSys o_b8_GnssSatSys;
         if (!bDoIt(o_b8_GnssSatSys))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_locationfi_tclToken::EN_B8_GNSSSATSTATUS:
      {
         sensor_fi_tcl_b8_GnssSatStatus o_b8_GnssSatStatus;
         if (!bDoIt(o_b8_GnssSatStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_locationfi_tclToken::EN_GNSSCONFIGDATA:
      {
      if (poVisitor->bDoExpand_GnssConfigData(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_END_OF_STRUCT,sensor_locationfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U8,sensor_locationfi_tclSemanticDomain::EN_UPDATEFREQUENCY));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_B8_GNSSSATSTATUS,sensor_locationfi_tclSemanticDomain::EN_USEDSATSTATUSBITS));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U16,sensor_locationfi_tclSemanticDomain::EN_NUMBEROFCHANNELS));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U32,sensor_locationfi_tclSemanticDomain::EN_GNSSRECEIVERFIRMWARECRC));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U32,sensor_locationfi_tclSemanticDomain::EN_GNSSRECEIVERFIRMWAREVERSION));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_E8_GNSSHW,sensor_locationfi_tclSemanticDomain::EN_GNSSHARDWARETYPE));
      }
      else
      {
         sensor_fi_tcl_GnssConfigData o_GnssConfigData;
         if (!bDoIt(o_GnssConfigData))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GnssConfigData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GnssConfigData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sensor_locationfi_tclToken::EN_E8_GNSSQUALITY:
      {
         sensor_fi_tcl_e8_GnssQuality o_e8_GnssQuality;
         if (!bDoIt(o_e8_GnssQuality))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_locationfi_tclToken::EN_E8_GNSSMODE:
      {
         sensor_fi_tcl_e8_GnssMode o_e8_GnssMode;
         if (!bDoIt(o_e8_GnssMode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_locationfi_tclToken::EN_GNSSSTATUS:
      {
      if (poVisitor->bDoExpand_GnssStatus(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_END_OF_STRUCT,sensor_locationfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_E8_GNSSMODE,sensor_locationfi_tclSemanticDomain::EN_GNSSMODE));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_E8_GNSSQUALITY,sensor_locationfi_tclSemanticDomain::EN_GNSSQUALITY));
      }
      else
      {
         sensor_fi_tcl_GnssStatus o_GnssStatus;
         if (!bDoIt(o_GnssStatus))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GnssStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GnssStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sensor_locationfi_tclToken::EN_COVARIANCEMATRIXUPPERTRIANGLE:
      {
      if (poVisitor->bDoExpand_CovarianceMatrixUpperTriangle(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_END_OF_STRUCT,sensor_locationfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_ELEM10));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_ELEM9));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_ELEM8));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_ELEM5));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_ELEM4));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_ELEM0));
      }
      else
      {
         sensor_fi_tcl_CovarianceMatrixUpperTriangle o_CovarianceMatrixUpperTriangle;
         if (!bDoIt(o_CovarianceMatrixUpperTriangle))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CovarianceMatrixUpperTriangle.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CovarianceMatrixUpperTriangle.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sensor_locationfi_tclToken::EN_TIMEDATE:
      {
      if (poVisitor->bDoExpand_TimeDate(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_END_OF_STRUCT,sensor_locationfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U16,sensor_locationfi_tclSemanticDomain::EN_TD_MILLISECONDS));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U8,sensor_locationfi_tclSemanticDomain::EN_TD_SECOND));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U8,sensor_locationfi_tclSemanticDomain::EN_TD_MINUTE));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U8,sensor_locationfi_tclSemanticDomain::EN_TD_HOUR));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U8,sensor_locationfi_tclSemanticDomain::EN_TD_DAY));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U8,sensor_locationfi_tclSemanticDomain::EN_TD_MONTH));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U16,sensor_locationfi_tclSemanticDomain::EN_TD_YEAR));
      }
      else
      {
         sensor_fi_tcl_TimeDate o_TimeDate;
         if (!bDoIt(o_TimeDate))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TimeDate.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TimeDate.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sensor_locationfi_tclToken::EN_GNSSCHANDATA:
      {
      if (poVisitor->bDoExpand_GnssChanData(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_END_OF_STRUCT,sensor_locationfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U8,sensor_locationfi_tclSemanticDomain::EN_CARRIERTONOISERATIO));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_ELEVATION));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_AZIMUTH));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_B8_GNSSSATSTATUS,sensor_locationfi_tclSemanticDomain::EN_SATSTATUS));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U16,sensor_locationfi_tclSemanticDomain::EN_SVID));
      }
      else
      {
         sensor_fi_tcl_GnssChanData o_GnssChanData;
         if (!bDoIt(o_GnssChanData))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GnssChanData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GnssChanData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sensor_locationfi_tclToken::EN_GNSSPVTDATA:
      {
      if (poVisitor->bDoExpand_GnssPvtData(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_END_OF_STRUCT,sensor_locationfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U16,sensor_locationfi_tclSemanticDomain::EN_SATELLITESUSED));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U16,sensor_locationfi_tclSemanticDomain::EN_SATELLITESRECEIVED));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U16,sensor_locationfi_tclSemanticDomain::EN_SATELLITESVISIBLE));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_B8_GNSSSATSYS,sensor_locationfi_tclSemanticDomain::EN_SATSYSUSED));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_VDOP));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_TDOP));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_HDOP));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_PDOP));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_GDOP));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_GNSSSTATUS,sensor_locationfi_tclSemanticDomain::EN_GNSSSTATUS));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_COVARIANCEMATRIXUPPERTRIANGLE,sensor_locationfi_tclSemanticDomain::EN_VELOCITYCOVARIANCEMATRIX));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_COVARIANCEMATRIXUPPERTRIANGLE,sensor_locationfi_tclSemanticDomain::EN_POSITIONCOVARIANCEMATRIX));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_VELOCITYUP));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_VELOCITYEAST));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_VELOCITYNORTH));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_GEOIDALSEPARATION));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_ALTITUDEWGS84));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F64,sensor_locationfi_tclSemanticDomain::EN_LONGITUDE));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F64,sensor_locationfi_tclSemanticDomain::EN_LATITUDE));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_TIMEDATE,sensor_locationfi_tclSemanticDomain::EN_UTCTIMEDATE));
      }
      else
      {
         sensor_fi_tcl_GnssPvtData o_GnssPvtData;
         if (!bDoIt(o_GnssPvtData))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GnssPvtData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GnssPvtData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sensor_locationfi_tclToken::EN_GNSSDATA:
      {
      if (poVisitor->bDoExpand_GnssData(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_END_OF_STRUCT,sensor_locationfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_GNSSCHANDATA,sensor_locationfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_LIST,sensor_locationfi_tclSemanticDomain::EN_GNSSCHANDATALIST));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_GNSSPVTDATA,sensor_locationfi_tclSemanticDomain::EN_GNSSPVTDATA));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_U32,sensor_locationfi_tclSemanticDomain::EN_TIMESTAMP));
      }
      else
      {
         sensor_fi_tcl_GnssData o_GnssData;
         if (!bDoIt(o_GnssData))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GnssData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GnssData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sensor_locationfi_tclToken::EN_E8_DEFSETGROUPS:
      {
         sensor_fi_tcl_e8_DefSetGroups o_e8_DefSetGroups;
         if (!bDoIt(o_e8_DefSetGroups))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_locationfi_tclToken::EN_E8_DEFSETMODE:
      {
         sensor_fi_tcl_e8_DefSetMode o_e8_DefSetMode;
         if (!bDoIt(o_e8_DefSetMode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_locationfi_tclToken::EN_ALLSENSORDATA:
      {
      if (poVisitor->bDoExpand_AllSensorData(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_END_OF_STRUCT,sensor_locationfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_ACCTEMPERATURE));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_3DACCDATA,sensor_locationfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_LIST,sensor_locationfi_tclSemanticDomain::EN_ACCUPDATE));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_F32,sensor_locationfi_tclSemanticDomain::EN_GYROTEMPERATURE));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_3DGYRODATA,sensor_locationfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_LIST,sensor_locationfi_tclSemanticDomain::EN_GYROUPDATE));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_ABSDATA,sensor_locationfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_LIST,sensor_locationfi_tclSemanticDomain::EN_ABSUPDATE));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_ODOMETERDATA,sensor_locationfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_LIST,sensor_locationfi_tclSemanticDomain::EN_ODOMETERUPDATE));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_GNSSDATA,sensor_locationfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(sensor_locationfi_tclKnot(sensor_locationfi_tclToken::EN_LIST,sensor_locationfi_tclSemanticDomain::EN_GNSSUPDATE));
      }
      else
      {
         sensor_fi_tcl_AllSensorData o_AllSensorData;
         if (!bDoIt(o_AllSensorData))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AllSensorData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AllSensorData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sensor_locationfi_tclToken::EN_UNKNOWN:
      case sensor_locationfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

