/************************************************************************
 
 *FILE:           alltypes.cpp
 
 *SW-COMPONENT:   FI Functional Interface
 
 *DESCRIPTION:    Interface fuer alle Typdefinitionen
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
// -----------------------------------------------------------------------------

fi_tclOutContext& sds_fi_tclU8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u8Value);
  return oOut;
}

fi_tclInContext& sds_fi_tclU8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u8Value);
  return oIn;
}

tU32 sds_fi_tclU8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sds_fi_tclS8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s8Value);
  return oOut;
}

fi_tclInContext& sds_fi_tclS8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s8Value);
  return oIn;
}

tU32 sds_fi_tclS8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sds_fi_tclU16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u16Value);
  return oOut;
}

fi_tclInContext& sds_fi_tclU16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u16Value);
  return oIn;
}

tU32 sds_fi_tclU16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sds_fi_tclS16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s16Value);
  return oOut;
}

fi_tclInContext& sds_fi_tclS16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s16Value);
  return oIn;
}

tU32 sds_fi_tclS16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sds_fi_tclU24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u24Value);
  return oOut;
}

fi_tclInContext& sds_fi_tclU24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u24Value);
  return oIn;
}

tU32 sds_fi_tclU24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sds_fi_tclS24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s24Value);
  return oOut;
}

fi_tclInContext& sds_fi_tclS24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s24Value);
  return oIn;
}

tU32 sds_fi_tclS24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sds_fi_tclU32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u32Value);
  return oOut;
}

fi_tclInContext& sds_fi_tclU32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u32Value);
  return oIn;
}

tU32 sds_fi_tclU32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sds_fi_tclU64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u64Value);
  return oOut;
}

fi_tclInContext& sds_fi_tclU64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u64Value);
  return oIn;
}

tU32 sds_fi_tclU64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sds_fi_tclS32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s32Value);
  return oOut;
}

fi_tclInContext& sds_fi_tclS32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s32Value);
  return oIn;
}

tU32 sds_fi_tclS32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sds_fi_tclS64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s64Value);
  return oOut;
}

fi_tclInContext& sds_fi_tclS64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s64Value);
  return oIn;
}

tU32 sds_fi_tclS64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sds_fi_tclF32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f32Value);
  return oOut;
}

fi_tclInContext& sds_fi_tclF32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f32Value);
  return oIn;
}

tU32 sds_fi_tclF32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sds_fi_tclF64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f64Value);
  return oOut;
}

fi_tclInContext& sds_fi_tclF64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f64Value);
  return oIn;
}

tU32 sds_fi_tclF64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sds_fi_tclBool::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(bValue);
  return oOut;
}

fi_tclInContext& sds_fi_tclBool::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(bValue);
  return oIn;
}

tU32 sds_fi_tclBool::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sds_fi_tclString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid sds_fi_tclString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tclString::~sds_fi_tclString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

sds_fi_tclString& sds_fi_tclString::operator=(const sds_fi_tclString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

sds_fi_tclString::sds_fi_tclString(const sds_fi_tclString& coRef):sds_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& sds_fi_tclString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool sds_fi_tclString::operator==(const sds_fi_tclString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 sds_fi_tclString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
sds_fi_tclString& sds_fi_tclString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclString::fi_tclString(const tString& coszString) // ADDED (changed from const tString to const tString&)
sds_fi_tclString::sds_fi_tclString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool sds_fi_tclString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

sds_fi_tclString::operator tString&() // ADDED
{
   return szValue;
}

sds_fi_tclString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool sds_fi_tclString::operator!=(intptr_t iNULL) const // ADDED
{
   return szValue != (char*)iNULL;
}

static tChar sds_FI_C_U8_NULLCHAR = '\0';

tChar* sds_fi_tclString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* sds_fi_tclString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* sds_fi_tclString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& sds_fi_tclString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return sds_FI_C_U8_NULLCHAR;
}

tChar& sds_fi_tclString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return sds_FI_C_U8_NULLCHAR;
}

tChar& sds_fi_tclString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return sds_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool sds_fi_tclString::bSet(const sds_fi_tclString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool sds_fi_tclString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
case FI_EN_ISO8859_1M :
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = util_u32ConvertISO8859_1Mod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            util_u32ConvertISO8859_1Mod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
   return bSuccess;
}

tString sds_fi_tclString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

// -----------------------------------------------------------------------------

fi_tclOutContext& sds_fi_tclList::oWrite(fi_tclOutContext& oOut) const 
{
   // --Schreibe die Listenlaenge in den Kontext
   (tVoid) oOut.oWrite(u32ListSize);
   return oOut;
}

fi_tclInContext& sds_fi_tclList::oRead(fi_tclInContext& oIn) 
{
  // --Lese die Listenlaenge aus dem Kontext
  (tVoid) oIn.oRead(u32ListSize);
  return oIn;
}

tBool sds_fi_tclList::operator==(const sds_fi_tclList& roRef) const
{
   return roRef.u32ListSize == u32ListSize;
}

tU32 sds_fi_tclList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sds_fi_tclMultiLanguageString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid sds_fi_tclMultiLanguageString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tclMultiLanguageString::~sds_fi_tclMultiLanguageString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

sds_fi_tclMultiLanguageString& sds_fi_tclMultiLanguageString::operator=(const sds_fi_tclMultiLanguageString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

sds_fi_tclMultiLanguageString::sds_fi_tclMultiLanguageString(const sds_fi_tclMultiLanguageString& coRef):sds_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& sds_fi_tclMultiLanguageString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool sds_fi_tclMultiLanguageString::operator==(const sds_fi_tclMultiLanguageString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 sds_fi_tclMultiLanguageString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
sds_fi_tclMultiLanguageString& sds_fi_tclMultiLanguageString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclMultiLanguageString::fi_tclMultiLanguageString(const tString& coszString) // ADDED (changed from const tString to const tString&)
sds_fi_tclMultiLanguageString::sds_fi_tclMultiLanguageString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool sds_fi_tclMultiLanguageString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

sds_fi_tclMultiLanguageString::operator tString&() // ADDED
{
   return szValue;
}

sds_fi_tclMultiLanguageString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool sds_fi_tclMultiLanguageString::operator!=(intptr_t iNULL) const// ADDED
{
   return szValue != (char*)iNULL;
}

tChar* sds_fi_tclMultiLanguageString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* sds_fi_tclMultiLanguageString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* sds_fi_tclMultiLanguageString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& sds_fi_tclMultiLanguageString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return sds_FI_C_U8_NULLCHAR;
}

tChar& sds_fi_tclMultiLanguageString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return sds_FI_C_U8_NULLCHAR;
}

tChar& sds_fi_tclMultiLanguageString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return sds_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool sds_fi_tclMultiLanguageString::bSet(const sds_fi_tclMultiLanguageString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclMultiLanguageString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool sds_fi_tclMultiLanguageString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }

   return bSuccess;
}

tString sds_fi_tclMultiLanguageString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_BinContainerTypes::sds_fi_tcl_e8_BinContainerTypes():enType(FI_EN_T_RESERVED) {}

tS32 sds_fi_tcl_e8_BinContainerTypes::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_BINCONTAINERTYPES;
}


sds_fi_tcl_e8_BinContainerTypes::~sds_fi_tcl_e8_BinContainerTypes()
{}

tU32 sds_fi_tcl_e8_BinContainerTypes::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_BinContainerTypes::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_BinContainerTypes::oWrite(fi_tclOutContext& oOut) const
{
   sds_fi_tcl_e8_BinContainerTypes::tenType enData = enType;
   if ((enData == FI_EN_T_GRAPHICALWEATHERSHAPEBINCONTAINER) && !(29 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   if ((enData == FI_EN_T_MAPROUTEBINCONTAINER) && !(15 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   return oOut.oWrite((tU8)enData);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_BinContainer::sds_fi_tcl_BinContainer(const sds_fi_tcl_BinContainer& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   ContainerDataList = coRef.ContainerDataList;
}
sds_fi_tcl_BinContainer& sds_fi_tcl_BinContainer::operator=(const sds_fi_tcl_BinContainer& coRef)
{
   if (this == &coRef) return *this;
   ContainerDataList = coRef.ContainerDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_BinContainer::vDestroy()
{
   {
   ContainerDataList.clear();
   }
}

sds_fi_tcl_BinContainer::sds_fi_tcl_BinContainer()

 {}

tS32 sds_fi_tcl_BinContainer::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_BINCONTAINER;
}


sds_fi_tcl_BinContainer::~sds_fi_tcl_BinContainer()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_BinContainer::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ContainerDataList.size()*1;
}

fi_tclInContext& sds_fi_tcl_BinContainer::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ContainerDataList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ContainerDataList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_BinContainer::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ContainerDataList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ContainerDataList.size(); ++u32Idx)
         (tVoid) (oOut << ContainerDataList[u32Idx]);
   }
   return oOut;
}

tBool sds_fi_tcl_BinContainer::operator==(const sds_fi_tcl_BinContainer& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ContainerDataList.size() == roRef.ContainerDataList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ContainerDataList.size()); ++u32Idx)
            bResult = bResult && (ContainerDataList[u32Idx] == roRef.ContainerDataList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e16_ISO639_3_SDSLanguageCode::sds_fi_tcl_e16_ISO639_3_SDSLanguageCode():enType(FI_EN_ISO_639_3_INVALID) {}

tS32 sds_fi_tcl_e16_ISO639_3_SDSLanguageCode::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E16_ISO639_3_SDSLANGUAGECODE;
}


sds_fi_tcl_e16_ISO639_3_SDSLanguageCode::~sds_fi_tcl_e16_ISO639_3_SDSLanguageCode()
{}

tU32 sds_fi_tcl_e16_ISO639_3_SDSLanguageCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_fi_tcl_e16_ISO639_3_SDSLanguageCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e16_ISO639_3_SDSLanguageCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_Slot::sds_fi_tcl_e8_Slot():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_Slot::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_SLOT;
}


sds_fi_tcl_e8_Slot::~sds_fi_tcl_e8_Slot()
{}

tU32 sds_fi_tcl_e8_Slot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_Slot::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_Slot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_Domain::sds_fi_tcl_e8_Domain():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_Domain::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_DOMAIN;
}


sds_fi_tcl_e8_Domain::~sds_fi_tcl_e8_Domain()
{}

tU32 sds_fi_tcl_e8_Domain::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_Domain::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_Domain::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_ConnectedDeviceUpdateStatus::sds_fi_tcl_e8_ConnectedDeviceUpdateStatus():enType(FI_EN_DEVICEUNAVAILABLE) {}

tS32 sds_fi_tcl_e8_ConnectedDeviceUpdateStatus::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_CONNECTEDDEVICEUPDATESTATUS;
}


sds_fi_tcl_e8_ConnectedDeviceUpdateStatus::~sds_fi_tcl_e8_ConnectedDeviceUpdateStatus()
{}

tU32 sds_fi_tcl_e8_ConnectedDeviceUpdateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_ConnectedDeviceUpdateStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_ConnectedDeviceUpdateStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_PromptSetting::sds_fi_tcl_e8_PromptSetting():enType(FI_EN_SHORT) {}

tS32 sds_fi_tcl_e8_PromptSetting::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_PROMPTSETTING;
}


sds_fi_tcl_e8_PromptSetting::~sds_fi_tcl_e8_PromptSetting()
{}

tU32 sds_fi_tcl_e8_PromptSetting::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_PromptSetting::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_PromptSetting::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_WordType::sds_fi_tcl_e8_WordType():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_WordType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_WORDTYPE;
}


sds_fi_tcl_e8_WordType::~sds_fi_tcl_e8_WordType()
{}

tU32 sds_fi_tcl_e8_WordType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_WordType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_WordType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_NDSFeatureType::sds_fi_tcl_e8_NDSFeatureType():enType(FI_EN_NAMEOBJECT) {}

tS32 sds_fi_tcl_e8_NDSFeatureType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_NDSFEATURETYPE;
}


sds_fi_tcl_e8_NDSFeatureType::~sds_fi_tcl_e8_NDSFeatureType()
{}

tU32 sds_fi_tcl_e8_NDSFeatureType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_NDSFeatureType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_NDSFeatureType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e32_SSE_ASR_Mode::sds_fi_tcl_e32_SSE_ASR_Mode():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e32_SSE_ASR_Mode::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E32_SSE_ASR_MODE;
}


sds_fi_tcl_e32_SSE_ASR_Mode::~sds_fi_tcl_e32_SSE_ASR_Mode()
{}

tU32 sds_fi_tcl_e32_SSE_ASR_Mode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_fi_tcl_e32_SSE_ASR_Mode::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e32_SSE_ASR_Mode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_SDSDestinationType::sds_fi_tcl_e8_SDSDestinationType():enType(FI_EN_RESERVED) {}

tS32 sds_fi_tcl_e8_SDSDestinationType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_SDSDESTINATIONTYPE;
}


sds_fi_tcl_e8_SDSDestinationType::~sds_fi_tcl_e8_SDSDestinationType()
{}

tU32 sds_fi_tcl_e8_SDSDestinationType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_SDSDestinationType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_SDSDestinationType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e16_ISOCountryCode::sds_fi_tcl_e16_ISOCountryCode():enType(FI_EN_ISO_ALPHA_3_UNDEFINED) {}

tS32 sds_fi_tcl_e16_ISOCountryCode::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E16_ISOCOUNTRYCODE;
}


sds_fi_tcl_e16_ISOCountryCode::~sds_fi_tcl_e16_ISOCountryCode()
{}

tU32 sds_fi_tcl_e16_ISOCountryCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_fi_tcl_e16_ISOCountryCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e16_ISOCountryCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_ConnectedDeviceStatus::sds_fi_tcl_ConnectedDeviceStatus(const sds_fi_tcl_ConnectedDeviceStatus& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   u32DeviceId = coRef.u32DeviceId;
   tenDomain = coRef.tenDomain;
   UpdateStatus = coRef.UpdateStatus;
}
sds_fi_tcl_ConnectedDeviceStatus& sds_fi_tcl_ConnectedDeviceStatus::operator=(const sds_fi_tcl_ConnectedDeviceStatus& coRef)
{
   if (this == &coRef) return *this;
   u32DeviceId = coRef.u32DeviceId;
   tenDomain = coRef.tenDomain;
   UpdateStatus = coRef.UpdateStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_ConnectedDeviceStatus::sds_fi_tcl_ConnectedDeviceStatus()
:u32DeviceId(0)
,tenDomain()
,UpdateStatus()
 {}

tS32 sds_fi_tcl_ConnectedDeviceStatus::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_CONNECTEDDEVICESTATUS;
}


sds_fi_tcl_ConnectedDeviceStatus::~sds_fi_tcl_ConnectedDeviceStatus()
{}

tU32 sds_fi_tcl_ConnectedDeviceStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& sds_fi_tcl_ConnectedDeviceStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32DeviceId);
   (tVoid) (oIn >> tenDomain);
   (tVoid) (oIn >> UpdateStatus);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_ConnectedDeviceStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32DeviceId);
   (tVoid) (oOut << tenDomain);
   (tVoid) (oOut << UpdateStatus);
   return oOut;
}

tBool sds_fi_tcl_ConnectedDeviceStatus::operator==(const sds_fi_tcl_ConnectedDeviceStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32DeviceId == roRef.u32DeviceId);
   bResult = bResult && (tenDomain == roRef.tenDomain);
   bResult = bResult && (UpdateStatus == roRef.UpdateStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_NDSLanguageID::sds_fi_tcl_NDSLanguageID(const sds_fi_tcl_NDSLanguageID& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   LanguageCode = coRef.LanguageCode;
   ISO_CountryCode = coRef.ISO_CountryCode;
   ISO_LanguageCode = coRef.ISO_LanguageCode;
   ScriptCode = coRef.ScriptCode;
}
sds_fi_tcl_NDSLanguageID& sds_fi_tcl_NDSLanguageID::operator=(const sds_fi_tcl_NDSLanguageID& coRef)
{
   if (this == &coRef) return *this;
   LanguageCode = coRef.LanguageCode;
   ISO_CountryCode = coRef.ISO_CountryCode;
   ISO_LanguageCode = coRef.ISO_LanguageCode;
   ScriptCode = coRef.ScriptCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_NDSLanguageID::vDestroy()
{
   ISO_CountryCode.vDestroy();
   ISO_LanguageCode.vDestroy();
   ScriptCode.vDestroy();
}

sds_fi_tcl_NDSLanguageID::sds_fi_tcl_NDSLanguageID()
:LanguageCode(0)
,ISO_CountryCode()
,ISO_LanguageCode()
,ScriptCode()
 {}

tS32 sds_fi_tcl_NDSLanguageID::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_NDSLANGUAGEID;
}


sds_fi_tcl_NDSLanguageID::~sds_fi_tcl_NDSLanguageID()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_NDSLanguageID::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+ISO_CountryCode.u32GetSize(u16MajorVersion)+ISO_LanguageCode.u32GetSize(u16MajorVersion)+ScriptCode.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_NDSLanguageID::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageCode);
   (tVoid) (oIn >> ISO_CountryCode);
   (tVoid) (oIn >> ISO_LanguageCode);
   (tVoid) (oIn >> ScriptCode);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_NDSLanguageID::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageCode);
   (tVoid) (oOut << ISO_CountryCode);
   (tVoid) (oOut << ISO_LanguageCode);
   (tVoid) (oOut << ScriptCode);
   return oOut;
}

tBool sds_fi_tcl_NDSLanguageID::operator==(const sds_fi_tcl_NDSLanguageID& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageCode == roRef.LanguageCode);
   bResult = bResult && (ISO_CountryCode == roRef.ISO_CountryCode);
   bResult = bResult && (ISO_LanguageCode == roRef.ISO_LanguageCode);
   bResult = bResult && (ScriptCode == roRef.ScriptCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_NDSID::sds_fi_tcl_NDSID(const sds_fi_tcl_NDSID& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   u16UpdateRegionId = coRef.u16UpdateRegionId;
   u32ProductId = coRef.u32ProductId;
   u8SupplierId = coRef.u8SupplierId;
   u32NDSId = coRef.u32NDSId;
   eNDSFeatureType = coRef.eNDSFeatureType;
   POIRootRegionID = coRef.POIRootRegionID;
   GlobalXRefId = coRef.GlobalXRefId;
}
sds_fi_tcl_NDSID& sds_fi_tcl_NDSID::operator=(const sds_fi_tcl_NDSID& coRef)
{
   if (this == &coRef) return *this;
   u16UpdateRegionId = coRef.u16UpdateRegionId;
   u32ProductId = coRef.u32ProductId;
   u8SupplierId = coRef.u8SupplierId;
   u32NDSId = coRef.u32NDSId;
   eNDSFeatureType = coRef.eNDSFeatureType;
   POIRootRegionID = coRef.POIRootRegionID;
   GlobalXRefId = coRef.GlobalXRefId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_NDSID::sds_fi_tcl_NDSID()
:u16UpdateRegionId(0)
,u32ProductId(0)
,u8SupplierId(0)
,u32NDSId(0)
,eNDSFeatureType()
,POIRootRegionID(0)
,GlobalXRefId(0)
 {}

tS32 sds_fi_tcl_NDSID::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_NDSID;
}


sds_fi_tcl_NDSID::~sds_fi_tcl_NDSID()
{}

tU32 sds_fi_tcl_NDSID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 24;
}

fi_tclInContext& sds_fi_tcl_NDSID::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16UpdateRegionId);
   (tVoid) (oIn >> u32ProductId);
   (tVoid) (oIn >> u8SupplierId);
   (tVoid) (oIn >> u32NDSId);
   (tVoid) (oIn >> eNDSFeatureType);
   (tVoid) (oIn >> POIRootRegionID);
   (tVoid) (oIn >> GlobalXRefId);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_NDSID::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16UpdateRegionId);
   (tVoid) (oOut << u32ProductId);
   (tVoid) (oOut << u8SupplierId);
   (tVoid) (oOut << u32NDSId);
   (tVoid) (oOut << eNDSFeatureType);
   (tVoid) (oOut << POIRootRegionID);
   (tVoid) (oOut << GlobalXRefId);
   return oOut;
}

tBool sds_fi_tcl_NDSID::operator==(const sds_fi_tcl_NDSID& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16UpdateRegionId == roRef.u16UpdateRegionId);
   bResult = bResult && (u32ProductId == roRef.u32ProductId);
   bResult = bResult && (u8SupplierId == roRef.u8SupplierId);
   bResult = bResult && (u32NDSId == roRef.u32NDSId);
   bResult = bResult && (eNDSFeatureType == roRef.eNDSFeatureType);
   bResult = bResult && (POIRootRegionID == roRef.POIRootRegionID);
   bResult = bResult && (GlobalXRefId == roRef.GlobalXRefId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_StreetAvailability::sds_fi_tcl_StreetAvailability(const sds_fi_tcl_StreetAvailability& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   City_Id = coRef.City_Id;
   Availability = coRef.Availability;
}
sds_fi_tcl_StreetAvailability& sds_fi_tcl_StreetAvailability::operator=(const sds_fi_tcl_StreetAvailability& coRef)
{
   if (this == &coRef) return *this;
   City_Id = coRef.City_Id;
   Availability = coRef.Availability;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_StreetAvailability::sds_fi_tcl_StreetAvailability()
:City_Id()
,Availability(0)
 {}

tS32 sds_fi_tcl_StreetAvailability::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_STREETAVAILABILITY;
}


sds_fi_tcl_StreetAvailability::~sds_fi_tcl_StreetAvailability()
{}

tU32 sds_fi_tcl_StreetAvailability::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 25;
}

fi_tclInContext& sds_fi_tcl_StreetAvailability::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> City_Id);
   (tVoid) (oIn >> Availability);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_StreetAvailability::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << City_Id);
   (tVoid) (oOut << Availability);
   return oOut;
}

tBool sds_fi_tcl_StreetAvailability::operator==(const sds_fi_tcl_StreetAvailability& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (City_Id == roRef.City_Id);
   bResult = bResult && (Availability == roRef.Availability);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_PhonemeForLanguage::sds_fi_tcl_PhonemeForLanguage(const sds_fi_tcl_PhonemeForLanguage& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   Language = coRef.Language;
   Phoneme = coRef.Phoneme;
}
sds_fi_tcl_PhonemeForLanguage& sds_fi_tcl_PhonemeForLanguage::operator=(const sds_fi_tcl_PhonemeForLanguage& coRef)
{
   if (this == &coRef) return *this;
   Language = coRef.Language;
   Phoneme = coRef.Phoneme;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_PhonemeForLanguage::vDestroy()
{
   Language.vDestroy(); 
   Phoneme.vDestroy();
}

sds_fi_tcl_PhonemeForLanguage::sds_fi_tcl_PhonemeForLanguage()
:Language()
,Phoneme()
 {}

tS32 sds_fi_tcl_PhonemeForLanguage::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_PHONEMEFORLANGUAGE;
}


sds_fi_tcl_PhonemeForLanguage::~sds_fi_tcl_PhonemeForLanguage()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_PhonemeForLanguage::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Language.u32GetSize(u16MajorVersion)+Phoneme.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_PhonemeForLanguage::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Language);
   (tVoid) (oIn >> Phoneme);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_PhonemeForLanguage::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Language);
   (tVoid) (oOut << Phoneme);
   return oOut;
}

tBool sds_fi_tcl_PhonemeForLanguage::operator==(const sds_fi_tcl_PhonemeForLanguage& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Language == roRef.Language);
   bResult = bResult && (Phoneme == roRef.Phoneme);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_StringAndPhoneme::sds_fi_tcl_StringAndPhoneme(const sds_fi_tcl_StringAndPhoneme& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   NDSId = coRef.NDSId;
   OrthographyList = coRef.OrthographyList;
   PhonemeAndLanguageList = coRef.PhonemeAndLanguageList;
   DestItemtype = coRef.DestItemtype;
}
sds_fi_tcl_StringAndPhoneme& sds_fi_tcl_StringAndPhoneme::operator=(const sds_fi_tcl_StringAndPhoneme& coRef)
{
   if (this == &coRef) return *this;
   NDSId = coRef.NDSId;
   OrthographyList = coRef.OrthographyList;
   PhonemeAndLanguageList = coRef.PhonemeAndLanguageList;
   DestItemtype = coRef.DestItemtype;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_StringAndPhoneme::vDestroy()
{
   NDSId.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < OrthographyList.size(); ++u32Idx)
         OrthographyList[u32Idx].vDestroy();
   OrthographyList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < PhonemeAndLanguageList.size(); ++u32Idx)
         PhonemeAndLanguageList[u32Idx].vDestroy();
   PhonemeAndLanguageList.clear();
   }
}

sds_fi_tcl_StringAndPhoneme::sds_fi_tcl_StringAndPhoneme()
:NDSId()


,DestItemtype()
 {}

tS32 sds_fi_tcl_StringAndPhoneme::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_STRINGANDPHONEME;
}


sds_fi_tcl_StringAndPhoneme::~sds_fi_tcl_StringAndPhoneme()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_StringAndPhoneme::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < OrthographyList.size(); ++u32ListIdx)
      u32DynamicSize += OrthographyList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < PhonemeAndLanguageList.size(); ++u32ListIdx)
      u32DynamicSize += PhonemeAndLanguageList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+33;
}

fi_tclInContext& sds_fi_tcl_StringAndPhoneme::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> NDSId);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < OrthographyList.size(); ++u32Idx)
      {
         OrthographyList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      OrthographyList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> OrthographyList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PhonemeAndLanguageList.size(); ++u32Idx)
      {
         PhonemeAndLanguageList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      PhonemeAndLanguageList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PhonemeAndLanguageList[u32Idx]);
      }
   }
   (tVoid) (oIn >> DestItemtype);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_StringAndPhoneme::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NDSId);
   (tVoid) (oOut << (tU32)OrthographyList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < OrthographyList.size(); ++u32Idx)
         (tVoid) (oOut << OrthographyList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)PhonemeAndLanguageList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PhonemeAndLanguageList.size(); ++u32Idx)
         (tVoid) (oOut << PhonemeAndLanguageList[u32Idx]);
   }
   (tVoid) (oOut << DestItemtype);
   return oOut;
}

tBool sds_fi_tcl_StringAndPhoneme::operator==(const sds_fi_tcl_StringAndPhoneme& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NDSId == roRef.NDSId);
      bResult = bResult && (OrthographyList.size() == roRef.OrthographyList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OrthographyList.size()); ++u32Idx)
            bResult = bResult && (OrthographyList[u32Idx] == roRef.OrthographyList[u32Idx]);
      }
      bResult = bResult && (PhonemeAndLanguageList.size() == roRef.PhonemeAndLanguageList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PhonemeAndLanguageList.size()); ++u32Idx)
            bResult = bResult && (PhonemeAndLanguageList[u32Idx] == roRef.PhonemeAndLanguageList[u32Idx]);
      }
   bResult = bResult && (DestItemtype == roRef.DestItemtype);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_StatePhoneme::sds_fi_tcl_StatePhoneme(const sds_fi_tcl_StatePhoneme& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   StateId = coRef.StateId;
   PhonemeList = coRef.PhonemeList;
   OrthographyList = coRef.OrthographyList;
}
sds_fi_tcl_StatePhoneme& sds_fi_tcl_StatePhoneme::operator=(const sds_fi_tcl_StatePhoneme& coRef)
{
   if (this == &coRef) return *this;
   StateId = coRef.StateId;
   PhonemeList = coRef.PhonemeList;
   OrthographyList = coRef.OrthographyList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_StatePhoneme::vDestroy()
{
   StateId.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < PhonemeList.size(); ++u32Idx)
         PhonemeList[u32Idx].vDestroy();
   PhonemeList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < OrthographyList.size(); ++u32Idx)
         OrthographyList[u32Idx].vDestroy();
   OrthographyList.clear();
   }
}

sds_fi_tcl_StatePhoneme::sds_fi_tcl_StatePhoneme()
:StateId()


 {}

tS32 sds_fi_tcl_StatePhoneme::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_STATEPHONEME;
}


sds_fi_tcl_StatePhoneme::~sds_fi_tcl_StatePhoneme()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_StatePhoneme::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < PhonemeList.size(); ++u32ListIdx)
      u32DynamicSize += PhonemeList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < OrthographyList.size(); ++u32ListIdx)
      u32DynamicSize += OrthographyList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+32;
}

fi_tclInContext& sds_fi_tcl_StatePhoneme::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StateId);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PhonemeList.size(); ++u32Idx)
      {
         PhonemeList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      PhonemeList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PhonemeList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < OrthographyList.size(); ++u32Idx)
      {
         OrthographyList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      OrthographyList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> OrthographyList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_StatePhoneme::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StateId);
   (tVoid) (oOut << (tU32)PhonemeList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PhonemeList.size(); ++u32Idx)
         (tVoid) (oOut << PhonemeList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)OrthographyList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < OrthographyList.size(); ++u32Idx)
         (tVoid) (oOut << OrthographyList[u32Idx]);
   }
   return oOut;
}

tBool sds_fi_tcl_StatePhoneme::operator==(const sds_fi_tcl_StatePhoneme& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StateId == roRef.StateId);
      bResult = bResult && (PhonemeList.size() == roRef.PhonemeList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PhonemeList.size()); ++u32Idx)
            bResult = bResult && (PhonemeList[u32Idx] == roRef.PhonemeList[u32Idx]);
      }
      bResult = bResult && (OrthographyList.size() == roRef.OrthographyList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OrthographyList.size()); ++u32Idx)
            bResult = bResult && (OrthographyList[u32Idx] == roRef.OrthographyList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_CountryPhoneme::sds_fi_tcl_CountryPhoneme(const sds_fi_tcl_CountryPhoneme& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   CountryId = coRef.CountryId;
   PhonemeList = coRef.PhonemeList;
   OrthographyList = coRef.OrthographyList;
   StateList = coRef.StateList;
   CountryCode = coRef.CountryCode;
}
sds_fi_tcl_CountryPhoneme& sds_fi_tcl_CountryPhoneme::operator=(const sds_fi_tcl_CountryPhoneme& coRef)
{
   if (this == &coRef) return *this;
   CountryId = coRef.CountryId;
   PhonemeList = coRef.PhonemeList;
   OrthographyList = coRef.OrthographyList;
   StateList = coRef.StateList;
   CountryCode = coRef.CountryCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_CountryPhoneme::vDestroy()
{
   CountryId.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < PhonemeList.size(); ++u32Idx)
         PhonemeList[u32Idx].vDestroy();
   PhonemeList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < OrthographyList.size(); ++u32Idx)
         OrthographyList[u32Idx].vDestroy();
   OrthographyList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < StateList.size(); ++u32Idx)
         StateList[u32Idx].vDestroy();
   StateList.clear();
   }
}

sds_fi_tcl_CountryPhoneme::sds_fi_tcl_CountryPhoneme()
:CountryId()



,CountryCode()
 {}

tS32 sds_fi_tcl_CountryPhoneme::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_COUNTRYPHONEME;
}


sds_fi_tcl_CountryPhoneme::~sds_fi_tcl_CountryPhoneme()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_CountryPhoneme::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < PhonemeList.size(); ++u32ListIdx)
      u32DynamicSize += PhonemeList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < OrthographyList.size(); ++u32ListIdx)
      u32DynamicSize += OrthographyList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < StateList.size(); ++u32ListIdx)
      u32DynamicSize += StateList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+38;
}

fi_tclInContext& sds_fi_tcl_CountryPhoneme::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CountryId);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PhonemeList.size(); ++u32Idx)
      {
         PhonemeList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      PhonemeList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PhonemeList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < OrthographyList.size(); ++u32Idx)
      {
         OrthographyList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      OrthographyList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> OrthographyList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StateList.size(); ++u32Idx)
      {
         StateList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      StateList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> StateList[u32Idx]);
      }
   }
   (tVoid) (oIn >> CountryCode);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_CountryPhoneme::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CountryId);
   (tVoid) (oOut << (tU32)PhonemeList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PhonemeList.size(); ++u32Idx)
         (tVoid) (oOut << PhonemeList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)OrthographyList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < OrthographyList.size(); ++u32Idx)
         (tVoid) (oOut << OrthographyList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)StateList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < StateList.size(); ++u32Idx)
         (tVoid) (oOut << StateList[u32Idx]);
   }
   (tVoid) (oOut << CountryCode);
   return oOut;
}

tBool sds_fi_tcl_CountryPhoneme::operator==(const sds_fi_tcl_CountryPhoneme& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CountryId == roRef.CountryId);
      bResult = bResult && (PhonemeList.size() == roRef.PhonemeList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PhonemeList.size()); ++u32Idx)
            bResult = bResult && (PhonemeList[u32Idx] == roRef.PhonemeList[u32Idx]);
      }
      bResult = bResult && (OrthographyList.size() == roRef.OrthographyList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OrthographyList.size()); ++u32Idx)
            bResult = bResult && (OrthographyList[u32Idx] == roRef.OrthographyList[u32Idx]);
      }
      bResult = bResult && (StateList.size() == roRef.StateList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StateList.size()); ++u32Idx)
            bResult = bResult && (StateList[u32Idx] == roRef.StateList[u32Idx]);
      }
   bResult = bResult && (CountryCode == roRef.CountryCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_CityId::sds_fi_tcl_CityId(const sds_fi_tcl_CityId& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   City_ID_ = coRef.City_ID_;
}
sds_fi_tcl_CityId& sds_fi_tcl_CityId::operator=(const sds_fi_tcl_CityId& coRef)
{
   if (this == &coRef) return *this;
   City_ID_ = coRef.City_ID_;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_CityId::sds_fi_tcl_CityId()
:City_ID_()
 {}

tS32 sds_fi_tcl_CityId::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_CITYID;
}


sds_fi_tcl_CityId::~sds_fi_tcl_CityId()
{}

tU32 sds_fi_tcl_CityId::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 24;
}

fi_tclInContext& sds_fi_tcl_CityId::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> City_ID_);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_CityId::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << City_ID_);
   return oOut;
}

tBool sds_fi_tcl_CityId::operator==(const sds_fi_tcl_CityId& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (City_ID_ == roRef.City_ID_);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_ECNR_ASR_Mode_Status::sds_fi_tcl_ECNR_ASR_Mode_Status(const sds_fi_tcl_ECNR_ASR_Mode_Status& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   Mode_Enable = coRef.Mode_Enable;
   Mode_Status = coRef.Mode_Status;
}
sds_fi_tcl_ECNR_ASR_Mode_Status& sds_fi_tcl_ECNR_ASR_Mode_Status::operator=(const sds_fi_tcl_ECNR_ASR_Mode_Status& coRef)
{
   if (this == &coRef) return *this;
   Mode_Enable = coRef.Mode_Enable;
   Mode_Status = coRef.Mode_Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_ECNR_ASR_Mode_Status::sds_fi_tcl_ECNR_ASR_Mode_Status()
:Mode_Enable(0)
,Mode_Status()
 {}

tS32 sds_fi_tcl_ECNR_ASR_Mode_Status::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_ECNR_ASR_MODE_STATUS;
}


sds_fi_tcl_ECNR_ASR_Mode_Status::~sds_fi_tcl_ECNR_ASR_Mode_Status()
{}

tU32 sds_fi_tcl_ECNR_ASR_Mode_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds_fi_tcl_ECNR_ASR_Mode_Status::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Mode_Enable);
   (tVoid) (oIn >> Mode_Status);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_ECNR_ASR_Mode_Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Mode_Enable);
   (tVoid) (oOut << Mode_Status);
   return oOut;
}

tBool sds_fi_tcl_ECNR_ASR_Mode_Status::operator==(const sds_fi_tcl_ECNR_ASR_Mode_Status& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Mode_Enable == roRef.Mode_Enable);
   bResult = bResult && (Mode_Status == roRef.Mode_Status);
   return bResult;
}

//=============================================================================

sds_fi_tcl_Reserved::sds_fi_tcl_Reserved()
 {}

tS32 sds_fi_tcl_Reserved::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_RESERVED;
}


sds_fi_tcl_Reserved::~sds_fi_tcl_Reserved()
{}

tU32 sds_fi_tcl_Reserved::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

fi_tclInContext& sds_fi_tcl_Reserved::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_Reserved::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_u8_Percent::sds_fi_tcl_u8_Percent(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 sds_fi_tcl_u8_Percent::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_U8_PERCENT;
}


sds_fi_tcl_u8_Percent::~sds_fi_tcl_u8_Percent()
{}

tU32 sds_fi_tcl_u8_Percent::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_u8_Percent::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& sds_fi_tcl_u8_Percent::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_s16_PerThousand::sds_fi_tcl_s16_PerThousand(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sds_fi_tcl_s16_PerThousand::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_S16_PERTHOUSAND;
}


sds_fi_tcl_s16_PerThousand::~sds_fi_tcl_s16_PerThousand()
{}

tU32 sds_fi_tcl_s16_PerThousand::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_fi_tcl_s16_PerThousand::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sds_fi_tcl_s16_PerThousand::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_u16_IndexInReferenceList::sds_fi_tcl_u16_IndexInReferenceList(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 sds_fi_tcl_u16_IndexInReferenceList::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_U16_INDEXINREFERENCELIST;
}


sds_fi_tcl_u16_IndexInReferenceList::~sds_fi_tcl_u16_IndexInReferenceList()
{}

tU32 sds_fi_tcl_u16_IndexInReferenceList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_fi_tcl_u16_IndexInReferenceList::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& sds_fi_tcl_u16_IndexInReferenceList::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_u16_ErrorCode::sds_fi_tcl_u16_ErrorCode(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 sds_fi_tcl_u16_ErrorCode::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_U16_ERRORCODE;
}


sds_fi_tcl_u16_ErrorCode::~sds_fi_tcl_u16_ErrorCode()
{}

tU32 sds_fi_tcl_u16_ErrorCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_fi_tcl_u16_ErrorCode::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& sds_fi_tcl_u16_ErrorCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_u16_RPM::sds_fi_tcl_u16_RPM(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 sds_fi_tcl_u16_RPM::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_U16_RPM;
}


sds_fi_tcl_u16_RPM::~sds_fi_tcl_u16_RPM()
{}

tU32 sds_fi_tcl_u16_RPM::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_fi_tcl_u16_RPM::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& sds_fi_tcl_u16_RPM::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_s32_Kilogram::sds_fi_tcl_s32_Kilogram(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds_fi_tcl_s32_Kilogram::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_S32_KILOGRAM;
}


sds_fi_tcl_s32_Kilogram::~sds_fi_tcl_s32_Kilogram()
{}

tU32 sds_fi_tcl_s32_Kilogram::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_fi_tcl_s32_Kilogram::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds_fi_tcl_s32_Kilogram::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_s32_Pound::sds_fi_tcl_s32_Pound(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds_fi_tcl_s32_Pound::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_S32_POUND;
}


sds_fi_tcl_s32_Pound::~sds_fi_tcl_s32_Pound()
{}

tU32 sds_fi_tcl_s32_Pound::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_fi_tcl_s32_Pound::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds_fi_tcl_s32_Pound::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_s16_Meter::sds_fi_tcl_s16_Meter(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sds_fi_tcl_s16_Meter::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_S16_METER;
}


sds_fi_tcl_s16_Meter::~sds_fi_tcl_s16_Meter()
{}

tU32 sds_fi_tcl_s16_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_fi_tcl_s16_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sds_fi_tcl_s16_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_s32_Meter::sds_fi_tcl_s32_Meter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds_fi_tcl_s32_Meter::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_S32_METER;
}


sds_fi_tcl_s32_Meter::~sds_fi_tcl_s32_Meter()
{}

tU32 sds_fi_tcl_s32_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_fi_tcl_s32_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds_fi_tcl_s32_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_s32_Yards::sds_fi_tcl_s32_Yards(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds_fi_tcl_s32_Yards::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_S32_YARDS;
}


sds_fi_tcl_s32_Yards::~sds_fi_tcl_s32_Yards()
{}

tU32 sds_fi_tcl_s32_Yards::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_fi_tcl_s32_Yards::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds_fi_tcl_s32_Yards::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_s32_Foot::sds_fi_tcl_s32_Foot(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds_fi_tcl_s32_Foot::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_S32_FOOT;
}


sds_fi_tcl_s32_Foot::~sds_fi_tcl_s32_Foot()
{}

tU32 sds_fi_tcl_s32_Foot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_fi_tcl_s32_Foot::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds_fi_tcl_s32_Foot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_s32_Centimeter::sds_fi_tcl_s32_Centimeter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds_fi_tcl_s32_Centimeter::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_S32_CENTIMETER;
}


sds_fi_tcl_s32_Centimeter::~sds_fi_tcl_s32_Centimeter()
{}

tU32 sds_fi_tcl_s32_Centimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_fi_tcl_s32_Centimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds_fi_tcl_s32_Centimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_s32_Inch::sds_fi_tcl_s32_Inch(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds_fi_tcl_s32_Inch::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_S32_INCH;
}


sds_fi_tcl_s32_Inch::~sds_fi_tcl_s32_Inch()
{}

tU32 sds_fi_tcl_s32_Inch::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_fi_tcl_s32_Inch::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds_fi_tcl_s32_Inch::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_s32_Millimeter::sds_fi_tcl_s32_Millimeter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds_fi_tcl_s32_Millimeter::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_S32_MILLIMETER;
}


sds_fi_tcl_s32_Millimeter::~sds_fi_tcl_s32_Millimeter()
{}

tU32 sds_fi_tcl_s32_Millimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_fi_tcl_s32_Millimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds_fi_tcl_s32_Millimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_s32_Microliter::sds_fi_tcl_s32_Microliter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds_fi_tcl_s32_Microliter::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_S32_MICROLITER;
}


sds_fi_tcl_s32_Microliter::~sds_fi_tcl_s32_Microliter()
{}

tU32 sds_fi_tcl_s32_Microliter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_fi_tcl_s32_Microliter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds_fi_tcl_s32_Microliter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_s32_Second::sds_fi_tcl_s32_Second(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds_fi_tcl_s32_Second::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_S32_SECOND;
}


sds_fi_tcl_s32_Second::~sds_fi_tcl_s32_Second()
{}

tU32 sds_fi_tcl_s32_Second::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_fi_tcl_s32_Second::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds_fi_tcl_s32_Second::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_u16_MilliSecond::sds_fi_tcl_u16_MilliSecond(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 sds_fi_tcl_u16_MilliSecond::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_U16_MILLISECOND;
}


sds_fi_tcl_u16_MilliSecond::~sds_fi_tcl_u16_MilliSecond()
{}

tU32 sds_fi_tcl_u16_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_fi_tcl_u16_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& sds_fi_tcl_u16_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_s32_MilliSecond::sds_fi_tcl_s32_MilliSecond(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds_fi_tcl_s32_MilliSecond::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_S32_MILLISECOND;
}


sds_fi_tcl_s32_MilliSecond::~sds_fi_tcl_s32_MilliSecond()
{}

tU32 sds_fi_tcl_s32_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_fi_tcl_s32_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds_fi_tcl_s32_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_POSIXTime::sds_fi_tcl_POSIXTime(const sds_fi_tcl_POSIXTime& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   Time = coRef.Time;
}
sds_fi_tcl_POSIXTime& sds_fi_tcl_POSIXTime::operator=(const sds_fi_tcl_POSIXTime& coRef)
{
   if (this == &coRef) return *this;
   Time = coRef.Time;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_POSIXTime::sds_fi_tcl_POSIXTime()
:Time(0)
 {}

tS32 sds_fi_tcl_POSIXTime::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_POSIXTIME;
}


sds_fi_tcl_POSIXTime::~sds_fi_tcl_POSIXTime()
{}

tU32 sds_fi_tcl_POSIXTime::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_fi_tcl_POSIXTime::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Time);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_POSIXTime::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Time);
   return oOut;
}

tBool sds_fi_tcl_POSIXTime::operator==(const sds_fi_tcl_POSIXTime& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Time == roRef.Time);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_DST_State::sds_fi_tcl_e8_DST_State():enType(FI_EN_T_STANDARDTIME) {}

tS32 sds_fi_tcl_e8_DST_State::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_DST_STATE;
}


sds_fi_tcl_e8_DST_State::~sds_fi_tcl_e8_DST_State()
{}

tU32 sds_fi_tcl_e8_DST_State::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_DST_State::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_DST_State::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_TimeZoneElement::sds_fi_tcl_TimeZoneElement(const sds_fi_tcl_TimeZoneElement& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
}
sds_fi_tcl_TimeZoneElement& sds_fi_tcl_TimeZoneElement::operator=(const sds_fi_tcl_TimeZoneElement& coRef)
{
   if (this == &coRef) return *this;
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_TimeZoneElement::vDestroy()
{
   Abbreviation_StandardTime.vDestroy();
   Abbreviation_DST_in_effect.vDestroy();
   {
   DST_TimeDomain.clear();
   }
}

sds_fi_tcl_TimeZoneElement::sds_fi_tcl_TimeZoneElement()
:Abbreviation_StandardTime(0)
,Abbreviation_DST_in_effect(0)
,TimeZoneDifference()
,DST_State()
,DSTDifference()

 {}

tS32 sds_fi_tcl_TimeZoneElement::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_TIMEZONEELEMENT;
}


sds_fi_tcl_TimeZoneElement::~sds_fi_tcl_TimeZoneElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_TimeZoneElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 13+Abbreviation_StandardTime.u32GetSize(u16MajorVersion)+Abbreviation_DST_in_effect.u32GetSize(u16MajorVersion)+DST_TimeDomain.size()*1;
}

fi_tclInContext& sds_fi_tcl_TimeZoneElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Abbreviation_StandardTime);
   (tVoid) (oIn >> Abbreviation_DST_in_effect);
   (tVoid) (oIn >> TimeZoneDifference);
   (tVoid) (oIn >> DST_State);
   (tVoid) (oIn >> DSTDifference);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      DST_TimeDomain.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DST_TimeDomain[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_TimeZoneElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Abbreviation_StandardTime);
   (tVoid) (oOut << Abbreviation_DST_in_effect);
   (tVoid) (oOut << TimeZoneDifference);
   (tVoid) (oOut << DST_State);
   (tVoid) (oOut << DSTDifference);
   (tVoid) (oOut << (tU32)DST_TimeDomain.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DST_TimeDomain.size(); ++u32Idx)
         (tVoid) (oOut << DST_TimeDomain[u32Idx]);
   }
   return oOut;
}

tBool sds_fi_tcl_TimeZoneElement::operator==(const sds_fi_tcl_TimeZoneElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Abbreviation_StandardTime == roRef.Abbreviation_StandardTime);
   bResult = bResult && (Abbreviation_DST_in_effect == roRef.Abbreviation_DST_in_effect);
   bResult = bResult && (TimeZoneDifference == roRef.TimeZoneDifference);
   bResult = bResult && (DST_State == roRef.DST_State);
   bResult = bResult && (DSTDifference == roRef.DSTDifference);
      bResult = bResult && (DST_TimeDomain.size() == roRef.DST_TimeDomain.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DST_TimeDomain.size()); ++u32Idx)
            bResult = bResult && (DST_TimeDomain[u32Idx] == roRef.DST_TimeDomain[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_s16_KmPerHour::sds_fi_tcl_s16_KmPerHour(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sds_fi_tcl_s16_KmPerHour::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_S16_KMPERHOUR;
}


sds_fi_tcl_s16_KmPerHour::~sds_fi_tcl_s16_KmPerHour()
{}

tU32 sds_fi_tcl_s16_KmPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_fi_tcl_s16_KmPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sds_fi_tcl_s16_KmPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_s16_MilesPerHour::sds_fi_tcl_s16_MilesPerHour(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sds_fi_tcl_s16_MilesPerHour::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_S16_MILESPERHOUR;
}


sds_fi_tcl_s16_MilesPerHour::~sds_fi_tcl_s16_MilesPerHour()
{}

tU32 sds_fi_tcl_s16_MilesPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_fi_tcl_s16_MilesPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sds_fi_tcl_s16_MilesPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_s16_Knot::sds_fi_tcl_s16_Knot(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sds_fi_tcl_s16_Knot::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_S16_KNOT;
}


sds_fi_tcl_s16_Knot::~sds_fi_tcl_s16_Knot()
{}

tU32 sds_fi_tcl_s16_Knot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_fi_tcl_s16_Knot::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sds_fi_tcl_s16_Knot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_s16_CentimeterSecond::sds_fi_tcl_s16_CentimeterSecond(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sds_fi_tcl_s16_CentimeterSecond::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_S16_CENTIMETERSECOND;
}


sds_fi_tcl_s16_CentimeterSecond::~sds_fi_tcl_s16_CentimeterSecond()
{}

tU32 sds_fi_tcl_s16_CentimeterSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_fi_tcl_s16_CentimeterSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sds_fi_tcl_s16_CentimeterSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_s16_Kelvin::sds_fi_tcl_s16_Kelvin(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sds_fi_tcl_s16_Kelvin::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_S16_KELVIN;
}


sds_fi_tcl_s16_Kelvin::~sds_fi_tcl_s16_Kelvin()
{}

tU32 sds_fi_tcl_s16_Kelvin::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_fi_tcl_s16_Kelvin::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sds_fi_tcl_s16_Kelvin::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_s16_Fahrenheit::sds_fi_tcl_s16_Fahrenheit(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sds_fi_tcl_s16_Fahrenheit::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_S16_FAHRENHEIT;
}


sds_fi_tcl_s16_Fahrenheit::~sds_fi_tcl_s16_Fahrenheit()
{}

tU32 sds_fi_tcl_s16_Fahrenheit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_fi_tcl_s16_Fahrenheit::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sds_fi_tcl_s16_Fahrenheit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_s32_Pascal::sds_fi_tcl_s32_Pascal(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds_fi_tcl_s32_Pascal::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_S32_PASCAL;
}


sds_fi_tcl_s32_Pascal::~sds_fi_tcl_s32_Pascal()
{}

tU32 sds_fi_tcl_s32_Pascal::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_fi_tcl_s32_Pascal::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds_fi_tcl_s32_Pascal::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_s32_Watt::sds_fi_tcl_s32_Watt(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds_fi_tcl_s32_Watt::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_S32_WATT;
}


sds_fi_tcl_s32_Watt::~sds_fi_tcl_s32_Watt()
{}

tU32 sds_fi_tcl_s32_Watt::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_fi_tcl_s32_Watt::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds_fi_tcl_s32_Watt::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_FIVersion::sds_fi_tcl_FIVersion(const sds_fi_tcl_FIVersion& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
}
sds_fi_tcl_FIVersion& sds_fi_tcl_FIVersion::operator=(const sds_fi_tcl_FIVersion& coRef)
{
   if (this == &coRef) return *this;
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_FIVersion::sds_fi_tcl_FIVersion()
:MajorVersion(0)
,MinorVersion(0)
,PatchVersion(0)
 {}

tS32 sds_fi_tcl_FIVersion::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_FIVERSION;
}


sds_fi_tcl_FIVersion::~sds_fi_tcl_FIVersion()
{}

tU32 sds_fi_tcl_FIVersion::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& sds_fi_tcl_FIVersion::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MajorVersion);
   (tVoid) (oIn >> MinorVersion);
   (tVoid) (oIn >> PatchVersion);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_FIVersion::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MajorVersion);
   (tVoid) (oOut << MinorVersion);
   (tVoid) (oOut << PatchVersion);
   return oOut;
}

tBool sds_fi_tcl_FIVersion::operator==(const sds_fi_tcl_FIVersion& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MajorVersion == roRef.MajorVersion);
   bResult = bResult && (MinorVersion == roRef.MinorVersion);
   bResult = bResult && (PatchVersion == roRef.PatchVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_s32_Longitude::sds_fi_tcl_s32_Longitude(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds_fi_tcl_s32_Longitude::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_S32_LONGITUDE;
}


sds_fi_tcl_s32_Longitude::~sds_fi_tcl_s32_Longitude()
{}

tU32 sds_fi_tcl_s32_Longitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_fi_tcl_s32_Longitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds_fi_tcl_s32_Longitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_s32_Latitude::sds_fi_tcl_s32_Latitude(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds_fi_tcl_s32_Latitude::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_S32_LATITUDE;
}


sds_fi_tcl_s32_Latitude::~sds_fi_tcl_s32_Latitude()
{}

tU32 sds_fi_tcl_s32_Latitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_fi_tcl_s32_Latitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds_fi_tcl_s32_Latitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_PositionWGS84::sds_fi_tcl_PositionWGS84(const sds_fi_tcl_PositionWGS84& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
}
sds_fi_tcl_PositionWGS84& sds_fi_tcl_PositionWGS84::operator=(const sds_fi_tcl_PositionWGS84& coRef)
{
   if (this == &coRef) return *this;
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_PositionWGS84::sds_fi_tcl_PositionWGS84()
:Longitude()
,Latitude()
 {}

tS32 sds_fi_tcl_PositionWGS84::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_POSITIONWGS84;
}


sds_fi_tcl_PositionWGS84::~sds_fi_tcl_PositionWGS84()
{}

tU32 sds_fi_tcl_PositionWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& sds_fi_tcl_PositionWGS84::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Longitude);
   (tVoid) (oIn >> Latitude);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_PositionWGS84::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Longitude);
   (tVoid) (oOut << Latitude);
   return oOut;
}

tBool sds_fi_tcl_PositionWGS84::operator==(const sds_fi_tcl_PositionWGS84& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Longitude == roRef.Longitude);
   bResult = bResult && (Latitude == roRef.Latitude);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_RectangleWGS84::sds_fi_tcl_RectangleWGS84(const sds_fi_tcl_RectangleWGS84& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
}
sds_fi_tcl_RectangleWGS84& sds_fi_tcl_RectangleWGS84::operator=(const sds_fi_tcl_RectangleWGS84& coRef)
{
   if (this == &coRef) return *this;
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_RectangleWGS84::sds_fi_tcl_RectangleWGS84()
:LongitudeMin()
,LatitudeMin()
,LongitudeMax()
,LatitudeMax()
 {}

tS32 sds_fi_tcl_RectangleWGS84::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_RECTANGLEWGS84;
}


sds_fi_tcl_RectangleWGS84::~sds_fi_tcl_RectangleWGS84()
{}

tU32 sds_fi_tcl_RectangleWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

fi_tclInContext& sds_fi_tcl_RectangleWGS84::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LongitudeMin);
   (tVoid) (oIn >> LatitudeMin);
   (tVoid) (oIn >> LongitudeMax);
   (tVoid) (oIn >> LatitudeMax);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_RectangleWGS84::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LongitudeMin);
   (tVoid) (oOut << LatitudeMin);
   (tVoid) (oOut << LongitudeMax);
   (tVoid) (oOut << LatitudeMax);
   return oOut;
}

tBool sds_fi_tcl_RectangleWGS84::operator==(const sds_fi_tcl_RectangleWGS84& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LongitudeMin == roRef.LongitudeMin);
   bResult = bResult && (LatitudeMin == roRef.LatitudeMin);
   bResult = bResult && (LongitudeMax == roRef.LongitudeMax);
   bResult = bResult && (LatitudeMax == roRef.LatitudeMax);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_SDSLanguageID::sds_fi_tcl_SDSLanguageID(const sds_fi_tcl_SDSLanguageID& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   ISO639_3_SDSLanguageCode = coRef.ISO639_3_SDSLanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
}
sds_fi_tcl_SDSLanguageID& sds_fi_tcl_SDSLanguageID::operator=(const sds_fi_tcl_SDSLanguageID& coRef)
{
   if (this == &coRef) return *this;
   ISO639_3_SDSLanguageCode = coRef.ISO639_3_SDSLanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_SDSLanguageID::sds_fi_tcl_SDSLanguageID()
:ISO639_3_SDSLanguageCode()
,ISO3166_CountryCode()
 {}

tS32 sds_fi_tcl_SDSLanguageID::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_SDSLANGUAGEID;
}


sds_fi_tcl_SDSLanguageID::~sds_fi_tcl_SDSLanguageID()
{}

tU32 sds_fi_tcl_SDSLanguageID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_fi_tcl_SDSLanguageID::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ISO639_3_SDSLanguageCode);
   (tVoid) (oIn >> ISO3166_CountryCode);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_SDSLanguageID::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ISO639_3_SDSLanguageCode);
   (tVoid) (oOut << ISO3166_CountryCode);
   return oOut;
}

tBool sds_fi_tcl_SDSLanguageID::operator==(const sds_fi_tcl_SDSLanguageID& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ISO639_3_SDSLanguageCode == roRef.ISO639_3_SDSLanguageCode);
   bResult = bResult && (ISO3166_CountryCode == roRef.ISO3166_CountryCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e16_ISOLanguageCode::sds_fi_tcl_e16_ISOLanguageCode():enType(FI_EN_ISO_639_1_UNDEFINED) {}

tS32 sds_fi_tcl_e16_ISOLanguageCode::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E16_ISOLANGUAGECODE;
}


sds_fi_tcl_e16_ISOLanguageCode::~sds_fi_tcl_e16_ISOLanguageCode()
{}

tU32 sds_fi_tcl_e16_ISOLanguageCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_fi_tcl_e16_ISOLanguageCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e16_ISOLanguageCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_LanguageID::sds_fi_tcl_LanguageID(const sds_fi_tcl_LanguageID& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
}
sds_fi_tcl_LanguageID& sds_fi_tcl_LanguageID::operator=(const sds_fi_tcl_LanguageID& coRef)
{
   if (this == &coRef) return *this;
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_LanguageID::sds_fi_tcl_LanguageID()
:ISO639_LanguageCode()
,ISO3166_CountryCode()
 {}

tS32 sds_fi_tcl_LanguageID::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_LANGUAGEID;
}


sds_fi_tcl_LanguageID::~sds_fi_tcl_LanguageID()
{}

tU32 sds_fi_tcl_LanguageID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_fi_tcl_LanguageID::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ISO639_LanguageCode);
   (tVoid) (oIn >> ISO3166_CountryCode);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_LanguageID::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ISO639_LanguageCode);
   (tVoid) (oOut << ISO3166_CountryCode);
   return oOut;
}

tBool sds_fi_tcl_LanguageID::operator==(const sds_fi_tcl_LanguageID& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ISO639_LanguageCode == roRef.ISO639_LanguageCode);
   bResult = bResult && (ISO3166_CountryCode == roRef.ISO3166_CountryCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_u8_DirectionAbsolute::sds_fi_tcl_u8_DirectionAbsolute(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 sds_fi_tcl_u8_DirectionAbsolute::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_U8_DIRECTIONABSOLUTE;
}


sds_fi_tcl_u8_DirectionAbsolute::~sds_fi_tcl_u8_DirectionAbsolute()
{}

tU32 sds_fi_tcl_u8_DirectionAbsolute::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_u8_DirectionAbsolute::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& sds_fi_tcl_u8_DirectionAbsolute::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_u8_DirectionRelative::sds_fi_tcl_u8_DirectionRelative(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 sds_fi_tcl_u8_DirectionRelative::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_U8_DIRECTIONRELATIVE;
}


sds_fi_tcl_u8_DirectionRelative::~sds_fi_tcl_u8_DirectionRelative()
{}

tU32 sds_fi_tcl_u8_DirectionRelative::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_u8_DirectionRelative::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& sds_fi_tcl_u8_DirectionRelative::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_s16_CentiDegree::sds_fi_tcl_s16_CentiDegree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sds_fi_tcl_s16_CentiDegree::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_S16_CENTIDEGREE;
}


sds_fi_tcl_s16_CentiDegree::~sds_fi_tcl_s16_CentiDegree()
{}

tU32 sds_fi_tcl_s16_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_fi_tcl_s16_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sds_fi_tcl_s16_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_s16_Degree::sds_fi_tcl_s16_Degree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sds_fi_tcl_s16_Degree::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_S16_DEGREE;
}


sds_fi_tcl_s16_Degree::~sds_fi_tcl_s16_Degree()
{}

tU32 sds_fi_tcl_s16_Degree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_fi_tcl_s16_Degree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sds_fi_tcl_s16_Degree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_u16_DirectionAbsolute_CentiDegree::sds_fi_tcl_u16_DirectionAbsolute_CentiDegree(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 sds_fi_tcl_u16_DirectionAbsolute_CentiDegree::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_U16_DIRECTIONABSOLUTE_CENTIDEGREE;
}


sds_fi_tcl_u16_DirectionAbsolute_CentiDegree::~sds_fi_tcl_u16_DirectionAbsolute_CentiDegree()
{}

tU32 sds_fi_tcl_u16_DirectionAbsolute_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_fi_tcl_u16_DirectionAbsolute_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& sds_fi_tcl_u16_DirectionAbsolute_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_s16_DirectionRelative_CentiDegree::sds_fi_tcl_s16_DirectionRelative_CentiDegree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sds_fi_tcl_s16_DirectionRelative_CentiDegree::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_S16_DIRECTIONRELATIVE_CENTIDEGREE;
}


sds_fi_tcl_s16_DirectionRelative_CentiDegree::~sds_fi_tcl_s16_DirectionRelative_CentiDegree()
{}

tU32 sds_fi_tcl_s16_DirectionRelative_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_fi_tcl_s16_DirectionRelative_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sds_fi_tcl_s16_DirectionRelative_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_FuelType::sds_fi_tcl_e8_FuelType():enType(FI_EN_RESERVED) {}

tS32 sds_fi_tcl_e8_FuelType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_FUELTYPE;
}


sds_fi_tcl_e8_FuelType::~sds_fi_tcl_e8_FuelType()
{}

tU32 sds_fi_tcl_e8_FuelType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_FuelType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_FuelType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_DistTimeFuel::sds_fi_tcl_DistTimeFuel(const sds_fi_tcl_DistTimeFuel& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   Distance = coRef.Distance;
   Time = coRef.Time;
   Fuel = coRef.Fuel;
}
sds_fi_tcl_DistTimeFuel& sds_fi_tcl_DistTimeFuel::operator=(const sds_fi_tcl_DistTimeFuel& coRef)
{
   if (this == &coRef) return *this;
   Distance = coRef.Distance;
   Time = coRef.Time;
   Fuel = coRef.Fuel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_DistTimeFuel::sds_fi_tcl_DistTimeFuel()
:Distance()
,Time()
,Fuel()
 {}

tS32 sds_fi_tcl_DistTimeFuel::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_DISTTIMEFUEL;
}


sds_fi_tcl_DistTimeFuel::~sds_fi_tcl_DistTimeFuel()
{}

tU32 sds_fi_tcl_DistTimeFuel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& sds_fi_tcl_DistTimeFuel::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Distance);
   (tVoid) (oIn >> Time);
   (tVoid) (oIn >> Fuel);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_DistTimeFuel::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Distance);
   (tVoid) (oOut << Time);
   (tVoid) (oOut << Fuel);
   return oOut;
}

tBool sds_fi_tcl_DistTimeFuel::operator==(const sds_fi_tcl_DistTimeFuel& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Distance == roRef.Distance);
   bResult = bResult && (Time == roRef.Time);
   bResult = bResult && (Fuel == roRef.Fuel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e16_SelectionCriterionType::sds_fi_tcl_e16_SelectionCriterionType():enType(FI_EN_RESERVED) {}

tS32 sds_fi_tcl_e16_SelectionCriterionType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E16_SELECTIONCRITERIONTYPE;
}


sds_fi_tcl_e16_SelectionCriterionType::~sds_fi_tcl_e16_SelectionCriterionType()
{}

tU32 sds_fi_tcl_e16_SelectionCriterionType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_fi_tcl_e16_SelectionCriterionType::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e16_SelectionCriterionType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_LocationDescriptionDataType::sds_fi_tcl_e8_LocationDescriptionDataType():enType(FI_EN_T_RESERVED) {}

tS32 sds_fi_tcl_e8_LocationDescriptionDataType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_LOCATIONDESCRIPTIONDATATYPE;
}


sds_fi_tcl_e8_LocationDescriptionDataType::~sds_fi_tcl_e8_LocationDescriptionDataType()
{}

tU32 sds_fi_tcl_e8_LocationDescriptionDataType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_LocationDescriptionDataType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_LocationDescriptionDataType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_b8_LocationDescriptorStatus::sds_fi_tcl_b8_LocationDescriptorStatus():u8Value(0)
{}

tS32 sds_fi_tcl_b8_LocationDescriptorStatus::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_B8_LOCATIONDESCRIPTORSTATUS;
}


sds_fi_tcl_b8_LocationDescriptorStatus::~sds_fi_tcl_b8_LocationDescriptorStatus()
{}

tU32 sds_fi_tcl_b8_LocationDescriptorStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_b8_LocationDescriptorStatus::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& sds_fi_tcl_b8_LocationDescriptorStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_LocationDescriptor::sds_fi_tcl_LocationDescriptor(const sds_fi_tcl_LocationDescriptor& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   SelectionCriterion = coRef.SelectionCriterion;
   DataType = coRef.DataType;
   if  (coRef.poDataData)
   {
      switch(DataType.enType)
      {
      case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_RESERVED:
         poDataData = OSAL_NEW sds_fi_tcl_Reserved((const sds_fi_tcl_Reserved&)*coRef.poDataData);
         break;
      case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_TSTRING:
         poDataData = OSAL_NEW sds_fi_tclString((const sds_fi_tclString&)*coRef.poDataData);
         break;
      case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGID:
         poDataData = OSAL_NEW sds_fi_tcl_StringID((const sds_fi_tcl_StringID&)*coRef.poDataData);
         break;
      case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONHEADINGSPEED:
         poDataData = OSAL_NEW sds_fi_tcl_PositionHeadingSpeed((const sds_fi_tcl_PositionHeadingSpeed&)*coRef.poDataData);
         break;
      case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONWGS84:
         poDataData = OSAL_NEW sds_fi_tcl_PositionWGS84((const sds_fi_tcl_PositionWGS84&)*coRef.poDataData);
         break;
      case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_NAVLOCATIONBINCONTAINER:
         if (coRef.poDataData->s32GetTypeId() == (tS32)sds_typesfi_tclToken::EN_NAVLOCATIONBINCONTAINER)
         {
            poDataData = OSAL_NEW sds_fi_tcl_NavLocationBinContainer((const sds_fi_tcl_NavLocationBinContainer&)*coRef.poDataData);
         }
         else
         {
            poDataData = OSAL_NEW sds_fi_tcl_BinContainer((const sds_fi_tcl_BinContainer&)*coRef.poDataData);
         }
         break;
      case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGPOSITION:
         poDataData = OSAL_NEW sds_fi_tcl_StringPosition((const sds_fi_tcl_StringPosition&)*coRef.poDataData);
         break;
      case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_FLISTRING:
         poDataData = OSAL_NEW sds_fi_tcl_FLIString((const sds_fi_tcl_FLIString&)*coRef.poDataData);
         break;
      case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_LISTOFPOSITIONS:
         poDataData = OSAL_NEW sds_fi_tcl_ListOfPositions((const sds_fi_tcl_ListOfPositions&)*coRef.poDataData);
         break;
      default:
         poDataData = OSAL_NULL;
      }
   }
   else
   {
      poDataData = OSAL_NULL;
   }
   Status = coRef.Status;
}
sds_fi_tcl_LocationDescriptor& sds_fi_tcl_LocationDescriptor::operator=(const sds_fi_tcl_LocationDescriptor& coRef)
{
   if (this == &coRef) return *this;
   SelectionCriterion = coRef.SelectionCriterion;
   OSAL_DELETE poDataData;
   DataType = coRef.DataType;
   if  (coRef.poDataData)
   {
      switch(DataType.enType)
      {
      case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_RESERVED:
         poDataData = OSAL_NEW sds_fi_tcl_Reserved((const sds_fi_tcl_Reserved&)*coRef.poDataData);
         break;
      case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_TSTRING:
         poDataData = OSAL_NEW sds_fi_tclString((const sds_fi_tclString&)*coRef.poDataData);
         break;
      case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGID:
         poDataData = OSAL_NEW sds_fi_tcl_StringID((const sds_fi_tcl_StringID&)*coRef.poDataData);
         break;
      case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONHEADINGSPEED:
         poDataData = OSAL_NEW sds_fi_tcl_PositionHeadingSpeed((const sds_fi_tcl_PositionHeadingSpeed&)*coRef.poDataData);
         break;
      case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONWGS84:
         poDataData = OSAL_NEW sds_fi_tcl_PositionWGS84((const sds_fi_tcl_PositionWGS84&)*coRef.poDataData);
         break;
      case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_NAVLOCATIONBINCONTAINER:
         if (coRef.poDataData->s32GetTypeId() == (tS32)sds_typesfi_tclToken::EN_NAVLOCATIONBINCONTAINER)
         {
            poDataData = OSAL_NEW sds_fi_tcl_NavLocationBinContainer((const sds_fi_tcl_NavLocationBinContainer&)*coRef.poDataData);
         }
         else
         {
            poDataData = OSAL_NEW sds_fi_tcl_BinContainer((const sds_fi_tcl_BinContainer&)*coRef.poDataData);
         }
         break;
      case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGPOSITION:
         poDataData = OSAL_NEW sds_fi_tcl_StringPosition((const sds_fi_tcl_StringPosition&)*coRef.poDataData);
         break;
      case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_FLISTRING:
         poDataData = OSAL_NEW sds_fi_tcl_FLIString((const sds_fi_tcl_FLIString&)*coRef.poDataData);
         break;
      case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_LISTOFPOSITIONS:
         poDataData = OSAL_NEW sds_fi_tcl_ListOfPositions((const sds_fi_tcl_ListOfPositions&)*coRef.poDataData);
         break;
      default:
         poDataData = OSAL_NULL;
      }
   }
   else
   {
      poDataData = OSAL_NULL;
   }
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_LocationDescriptor::vDestroy()
{
   if (poDataData)
   {
      poDataData->vDestroy();
      OSAL_DELETE poDataData;
      poDataData = OSAL_NULL;
   }
}

sds_fi_tcl_LocationDescriptor::sds_fi_tcl_LocationDescriptor()
:SelectionCriterion()
,poDataData(0)
,Status()
 {}

tS32 sds_fi_tcl_LocationDescriptor::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_LOCATIONDESCRIPTOR;
}


sds_fi_tcl_LocationDescriptor::~sds_fi_tcl_LocationDescriptor()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_LocationDescriptor::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+(poDataData?poDataData->u32GetSize(u16MajorVersion):0);
}

fi_tclInContext& sds_fi_tcl_LocationDescriptor::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SelectionCriterion);
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poDataData;
#else
   if (poDataData)
   {
      poDataData->vDestroy();
      OSAL_DELETE poDataData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   (tVoid) (oIn >> DataType);
   switch(DataType.enType)
   {
   case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_RESERVED:
      poDataData = OSAL_NEW sds_fi_tcl_Reserved;
      break;
   case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_TSTRING:
      poDataData = OSAL_NEW sds_fi_tclString;
      break;
   case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGID:
      poDataData = OSAL_NEW sds_fi_tcl_StringID;
      break;
   case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONHEADINGSPEED:
      poDataData = OSAL_NEW sds_fi_tcl_PositionHeadingSpeed;
      break;
   case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONWGS84:
      poDataData = OSAL_NEW sds_fi_tcl_PositionWGS84;
      break;
   case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_NAVLOCATIONBINCONTAINER:
      poDataData = OSAL_NEW sds_fi_tcl_BinContainer;
      break;
   case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGPOSITION:
      poDataData = OSAL_NEW sds_fi_tcl_StringPosition;
      break;
   case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_FLISTRING:
      poDataData = OSAL_NEW sds_fi_tcl_FLIString;
      break;
   case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_LISTOFPOSITIONS:
      poDataData = OSAL_NEW sds_fi_tcl_ListOfPositions;
      break;
   default:
      oIn.Invalidate();
      poDataData = OSAL_NULL;
   }
   if (poDataData && oIn.bIsValid())
      poDataData->oRead(oIn);
   else
      oIn.Invalidate();
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_LocationDescriptor::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SelectionCriterion);
   (tVoid) (oOut << DataType);
   if (poDataData)
   {
      (tVoid) poDataData->oWrite(oOut);
   }
   else
   {
      oOut.Invalidate();
   }
   (tVoid) (oOut << Status);
   return oOut;
}

tBool sds_fi_tcl_LocationDescriptor::operator==(const sds_fi_tcl_LocationDescriptor& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SelectionCriterion == roRef.SelectionCriterion);
   bResult = bResult && (DataType == roRef.DataType);
   if (bResult && poDataData && roRef.poDataData) 
   {
      switch (DataType.enType)
      {
      case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_RESERVED:
         bResult = bResult && (*(const sds_fi_tcl_Reserved*)poDataData == *(const sds_fi_tcl_Reserved*)roRef.poDataData); //lint !e826
      break;
      case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_TSTRING:
         bResult = bResult && (*(const sds_fi_tclString*)poDataData == *(const sds_fi_tclString*)roRef.poDataData); //lint !e826
      break;
      case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGID:
         bResult = bResult && (*(const sds_fi_tcl_StringID*)poDataData == *(const sds_fi_tcl_StringID*)roRef.poDataData); //lint !e826
      break;
      case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONHEADINGSPEED:
         bResult = bResult && (*(const sds_fi_tcl_PositionHeadingSpeed*)poDataData == *(const sds_fi_tcl_PositionHeadingSpeed*)roRef.poDataData); //lint !e826
      break;
      case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONWGS84:
         bResult = bResult && (*(const sds_fi_tcl_PositionWGS84*)poDataData == *(const sds_fi_tcl_PositionWGS84*)roRef.poDataData); //lint !e826
      break;
      case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_NAVLOCATIONBINCONTAINER:
         bResult = bResult && (*(const sds_fi_tcl_BinContainer*)poDataData == *(const sds_fi_tcl_BinContainer*)roRef.poDataData); //lint !e826
      break;
      case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGPOSITION:
         bResult = bResult && (*(const sds_fi_tcl_StringPosition*)poDataData == *(const sds_fi_tcl_StringPosition*)roRef.poDataData); //lint !e826
      break;
      case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_FLISTRING:
         bResult = bResult && (*(const sds_fi_tcl_FLIString*)poDataData == *(const sds_fi_tcl_FLIString*)roRef.poDataData); //lint !e826
      break;
      case sds_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_LISTOFPOSITIONS:
         bResult = bResult && (*(const sds_fi_tcl_ListOfPositions*)poDataData == *(const sds_fi_tcl_ListOfPositions*)roRef.poDataData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poDataData == roRef.poDataData);
   }
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_LocationDescription::sds_fi_tcl_LocationDescription(const sds_fi_tcl_LocationDescription& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   Descriptors = coRef.Descriptors;
}
sds_fi_tcl_LocationDescription& sds_fi_tcl_LocationDescription::operator=(const sds_fi_tcl_LocationDescription& coRef)
{
   if (this == &coRef) return *this;
   Descriptors = coRef.Descriptors;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_LocationDescription::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Descriptors.size(); ++u32Idx)
         Descriptors[u32Idx].vDestroy();
   Descriptors.clear();
   }
}

sds_fi_tcl_LocationDescription::sds_fi_tcl_LocationDescription()

 {}

tS32 sds_fi_tcl_LocationDescription::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_LOCATIONDESCRIPTION;
}


sds_fi_tcl_LocationDescription::~sds_fi_tcl_LocationDescription()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_LocationDescription::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Descriptors.size(); ++u32ListIdx)
      u32DynamicSize += Descriptors[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_fi_tcl_LocationDescription::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Descriptors.size(); ++u32Idx)
      {
         Descriptors[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Descriptors.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Descriptors[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_LocationDescription::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Descriptors.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Descriptors.size(); ++u32Idx)
         (tVoid) (oOut << Descriptors[u32Idx]);
   }
   return oOut;
}

tBool sds_fi_tcl_LocationDescription::operator==(const sds_fi_tcl_LocationDescription& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Descriptors.size() == roRef.Descriptors.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Descriptors.size()); ++u32Idx)
            bResult = bResult && (Descriptors[u32Idx] == roRef.Descriptors[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_StringPosition::sds_fi_tcl_StringPosition(const sds_fi_tcl_StringPosition& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   String = coRef.String;
   Position = coRef.Position;
}
sds_fi_tcl_StringPosition& sds_fi_tcl_StringPosition::operator=(const sds_fi_tcl_StringPosition& coRef)
{
   if (this == &coRef) return *this;
   String = coRef.String;
   Position = coRef.Position;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_StringPosition::vDestroy()
{
   String.vDestroy();
   Position.vDestroy(); 
}

sds_fi_tcl_StringPosition::sds_fi_tcl_StringPosition()
:String()
,Position()
 {}

tS32 sds_fi_tcl_StringPosition::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_STRINGPOSITION;
}


sds_fi_tcl_StringPosition::~sds_fi_tcl_StringPosition()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_StringPosition::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+String.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_StringPosition::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> String);
   (tVoid) (oIn >> Position);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_StringPosition::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << String);
   (tVoid) (oOut << Position);
   return oOut;
}

tBool sds_fi_tcl_StringPosition::operator==(const sds_fi_tcl_StringPosition& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (String == roRef.String);
   bResult = bResult && (Position == roRef.Position);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_StringID::sds_fi_tcl_StringID(const sds_fi_tcl_StringID& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   String = coRef.String;
   ID = coRef.ID;
}
sds_fi_tcl_StringID& sds_fi_tcl_StringID::operator=(const sds_fi_tcl_StringID& coRef)
{
   if (this == &coRef) return *this;
   String = coRef.String;
   ID = coRef.ID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_StringID::vDestroy()
{
   String.vDestroy();
}

sds_fi_tcl_StringID::sds_fi_tcl_StringID()
:String()
,ID(0)
 {}

tS32 sds_fi_tcl_StringID::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_STRINGID;
}


sds_fi_tcl_StringID::~sds_fi_tcl_StringID()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_StringID::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+String.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_StringID::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> String);
   (tVoid) (oIn >> ID);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_StringID::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << String);
   (tVoid) (oOut << ID);
   return oOut;
}

tBool sds_fi_tcl_StringID::operator==(const sds_fi_tcl_StringID& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (String == roRef.String);
   bResult = bResult && (ID == roRef.ID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_FLIString::sds_fi_tcl_FLIString(const sds_fi_tcl_FLIString& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   String = coRef.String;
}
sds_fi_tcl_FLIString& sds_fi_tcl_FLIString::operator=(const sds_fi_tcl_FLIString& coRef)
{
   if (this == &coRef) return *this;
   String = coRef.String;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_FLIString::vDestroy()
{
   String.vDestroy();
}

sds_fi_tcl_FLIString::sds_fi_tcl_FLIString()
:String()
 {}

tS32 sds_fi_tcl_FLIString::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_FLISTRING;
}


sds_fi_tcl_FLIString::~sds_fi_tcl_FLIString()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_FLIString::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+String.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_FLIString::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> String);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_FLIString::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << String);
   return oOut;
}

tBool sds_fi_tcl_FLIString::operator==(const sds_fi_tcl_FLIString& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (String == roRef.String);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_b8_PositionStatus::sds_fi_tcl_b8_PositionStatus():u8Value(0)
{}

tS32 sds_fi_tcl_b8_PositionStatus::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_B8_POSITIONSTATUS;
}


sds_fi_tcl_b8_PositionStatus::~sds_fi_tcl_b8_PositionStatus()
{}

tU32 sds_fi_tcl_b8_PositionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_b8_PositionStatus::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& sds_fi_tcl_b8_PositionStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_ListOfPositions::sds_fi_tcl_ListOfPositions(const sds_fi_tcl_ListOfPositions& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   Positions = coRef.Positions;
   PositionStati = coRef.PositionStati;
   ID = coRef.ID;
   CurrentPosition = coRef.CurrentPosition;
}
sds_fi_tcl_ListOfPositions& sds_fi_tcl_ListOfPositions::operator=(const sds_fi_tcl_ListOfPositions& coRef)
{
   if (this == &coRef) return *this;
   Positions = coRef.Positions;
   PositionStati = coRef.PositionStati;
   ID = coRef.ID;
   CurrentPosition = coRef.CurrentPosition;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_ListOfPositions::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Positions.size(); ++u32Idx)
         Positions[u32Idx].vDestroy();
   Positions.clear();
   }
   {
   PositionStati.clear();
   }
   CurrentPosition.vDestroy(); 
}

sds_fi_tcl_ListOfPositions::sds_fi_tcl_ListOfPositions()


:ID(0)
,CurrentPosition()
 {}

tS32 sds_fi_tcl_ListOfPositions::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_LISTOFPOSITIONS;
}


sds_fi_tcl_ListOfPositions::~sds_fi_tcl_ListOfPositions()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_ListOfPositions::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 20+Positions.size()*8+PositionStati.size()*1;
}

fi_tclInContext& sds_fi_tcl_ListOfPositions::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Positions.size(); ++u32Idx)
      {
         Positions[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Positions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Positions[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      PositionStati.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PositionStati[u32Idx]);
      }
   }
   (tVoid) (oIn >> ID);
   (tVoid) (oIn >> CurrentPosition);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_ListOfPositions::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Positions.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Positions.size(); ++u32Idx)
         (tVoid) (oOut << Positions[u32Idx]);
   }
   (tVoid) (oOut << (tU32)PositionStati.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PositionStati.size(); ++u32Idx)
         (tVoid) (oOut << PositionStati[u32Idx]);
   }
   (tVoid) (oOut << ID);
   (tVoid) (oOut << CurrentPosition);
   return oOut;
}

tBool sds_fi_tcl_ListOfPositions::operator==(const sds_fi_tcl_ListOfPositions& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Positions.size() == roRef.Positions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Positions.size()); ++u32Idx)
            bResult = bResult && (Positions[u32Idx] == roRef.Positions[u32Idx]);
      }
      bResult = bResult && (PositionStati.size() == roRef.PositionStati.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PositionStati.size()); ++u32Idx)
            bResult = bResult && (PositionStati[u32Idx] == roRef.PositionStati[u32Idx]);
      }
   bResult = bResult && (ID == roRef.ID);
   bResult = bResult && (CurrentPosition == roRef.CurrentPosition);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_b16_PositionReliability::sds_fi_tcl_b16_PositionReliability():u16Value(0)
{}

tS32 sds_fi_tcl_b16_PositionReliability::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_B16_POSITIONRELIABILITY;
}


sds_fi_tcl_b16_PositionReliability::~sds_fi_tcl_b16_PositionReliability()
{}

tU32 sds_fi_tcl_b16_PositionReliability::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_fi_tcl_b16_PositionReliability::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& sds_fi_tcl_b16_PositionReliability::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_PositionHeadingSpeed::sds_fi_tcl_PositionHeadingSpeed(const sds_fi_tcl_PositionHeadingSpeed& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   PositionWGS84 = coRef.PositionWGS84;
   PositionReliability = coRef.PositionReliability;
   Speed = coRef.Speed;
   Heading = coRef.Heading;
}
sds_fi_tcl_PositionHeadingSpeed& sds_fi_tcl_PositionHeadingSpeed::operator=(const sds_fi_tcl_PositionHeadingSpeed& coRef)
{
   if (this == &coRef) return *this;
   PositionWGS84 = coRef.PositionWGS84;
   PositionReliability = coRef.PositionReliability;
   Speed = coRef.Speed;
   Heading = coRef.Heading;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_PositionHeadingSpeed::sds_fi_tcl_PositionHeadingSpeed()
:PositionWGS84()
,PositionReliability()
,Speed()
,Heading()
 {}

tS32 sds_fi_tcl_PositionHeadingSpeed::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_POSITIONHEADINGSPEED;
}


sds_fi_tcl_PositionHeadingSpeed::~sds_fi_tcl_PositionHeadingSpeed()
{}

tU32 sds_fi_tcl_PositionHeadingSpeed::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& sds_fi_tcl_PositionHeadingSpeed::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PositionWGS84);
   (tVoid) (oIn >> PositionReliability);
   (tVoid) (oIn >> Speed);
   (tVoid) (oIn >> Heading);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_PositionHeadingSpeed::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PositionWGS84);
   (tVoid) (oOut << PositionReliability);
   (tVoid) (oOut << Speed);
   (tVoid) (oOut << Heading);
   return oOut;
}

tBool sds_fi_tcl_PositionHeadingSpeed::operator==(const sds_fi_tcl_PositionHeadingSpeed& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PositionWGS84 == roRef.PositionWGS84);
   bResult = bResult && (PositionReliability == roRef.PositionReliability);
   bResult = bResult && (Speed == roRef.Speed);
   bResult = bResult && (Heading == roRef.Heading);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_u32_DataSetId::sds_fi_tcl_u32_DataSetId(tU32 _u32Value)
: u32Value(_u32Value
) {} 

tS32 sds_fi_tcl_u32_DataSetId::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_U32_DATASETID;
}


sds_fi_tcl_u32_DataSetId::~sds_fi_tcl_u32_DataSetId()
{}

tU32 sds_fi_tcl_u32_DataSetId::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_fi_tcl_u32_DataSetId::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& sds_fi_tcl_u32_DataSetId::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_u32_MediaId::sds_fi_tcl_u32_MediaId(tU32 _u32Value)
: u32Value(_u32Value
) {} 

tS32 sds_fi_tcl_u32_MediaId::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_U32_MEDIAID;
}


sds_fi_tcl_u32_MediaId::~sds_fi_tcl_u32_MediaId()
{}

tU32 sds_fi_tcl_u32_MediaId::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_fi_tcl_u32_MediaId::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& sds_fi_tcl_u32_MediaId::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_NavClusterDesc::sds_fi_tcl_NavClusterDesc(const sds_fi_tcl_NavClusterDesc& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   Level = coRef.Level;
   FileId = coRef.FileId;
   FileOffset = coRef.FileOffset;
   Length = coRef.Length;
}
sds_fi_tcl_NavClusterDesc& sds_fi_tcl_NavClusterDesc::operator=(const sds_fi_tcl_NavClusterDesc& coRef)
{
   if (this == &coRef) return *this;
   Level = coRef.Level;
   FileId = coRef.FileId;
   FileOffset = coRef.FileOffset;
   Length = coRef.Length;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_NavClusterDesc::sds_fi_tcl_NavClusterDesc()
:Level(0)
,FileId(0)
,FileOffset(0)
,Length(0)
 {}

tS32 sds_fi_tcl_NavClusterDesc::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_NAVCLUSTERDESC;
}


sds_fi_tcl_NavClusterDesc::~sds_fi_tcl_NavClusterDesc()
{}

tU32 sds_fi_tcl_NavClusterDesc::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& sds_fi_tcl_NavClusterDesc::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Level);
   (tVoid) (oIn >> FileId);
   (tVoid) (oIn >> FileOffset);
   (tVoid) (oIn >> Length);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_NavClusterDesc::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Level);
   (tVoid) (oOut << FileId);
   (tVoid) (oOut << FileOffset);
   (tVoid) (oOut << Length);
   return oOut;
}

tBool sds_fi_tcl_NavClusterDesc::operator==(const sds_fi_tcl_NavClusterDesc& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Level == roRef.Level);
   bResult = bResult && (FileId == roRef.FileId);
   bResult = bResult && (FileOffset == roRef.FileOffset);
   bResult = bResult && (Length == roRef.Length);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_NavDataLevel::sds_fi_tcl_e8_NavDataLevel():enType(FI_EN_DATA_LEVEL_0) {}

tS32 sds_fi_tcl_e8_NavDataLevel::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_NAVDATALEVEL;
}


sds_fi_tcl_e8_NavDataLevel::~sds_fi_tcl_e8_NavDataLevel()
{}

tU32 sds_fi_tcl_e8_NavDataLevel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_NavDataLevel::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_NavDataLevel::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_NavOneCellDirection::sds_fi_tcl_e8_NavOneCellDirection():enType(FI_EN_NO) {}

tS32 sds_fi_tcl_e8_NavOneCellDirection::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_NAVONECELLDIRECTION;
}


sds_fi_tcl_e8_NavOneCellDirection::~sds_fi_tcl_e8_NavOneCellDirection()
{}

tU32 sds_fi_tcl_e8_NavOneCellDirection::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_NavOneCellDirection::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_NavOneCellDirection::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_NavOneCellDesc::sds_fi_tcl_NavOneCellDesc(const sds_fi_tcl_NavOneCellDesc& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   OneCellId = coRef.OneCellId;
   UseDirection = coRef.UseDirection;
   IndexInClusterRefList = coRef.IndexInClusterRefList;
}
sds_fi_tcl_NavOneCellDesc& sds_fi_tcl_NavOneCellDesc::operator=(const sds_fi_tcl_NavOneCellDesc& coRef)
{
   if (this == &coRef) return *this;
   OneCellId = coRef.OneCellId;
   UseDirection = coRef.UseDirection;
   IndexInClusterRefList = coRef.IndexInClusterRefList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_NavOneCellDesc::sds_fi_tcl_NavOneCellDesc()
:OneCellId(0)
,UseDirection()
,IndexInClusterRefList()
 {}

tS32 sds_fi_tcl_NavOneCellDesc::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_NAVONECELLDESC;
}


sds_fi_tcl_NavOneCellDesc::~sds_fi_tcl_NavOneCellDesc()
{}

tU32 sds_fi_tcl_NavOneCellDesc::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds_fi_tcl_NavOneCellDesc::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> OneCellId);
   (tVoid) (oIn >> UseDirection);
   (tVoid) (oIn >> IndexInClusterRefList);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_NavOneCellDesc::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << OneCellId);
   (tVoid) (oOut << UseDirection);
   (tVoid) (oOut << IndexInClusterRefList);
   return oOut;
}

tBool sds_fi_tcl_NavOneCellDesc::operator==(const sds_fi_tcl_NavOneCellDesc& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (OneCellId == roRef.OneCellId);
   bResult = bResult && (UseDirection == roRef.UseDirection);
   bResult = bResult && (IndexInClusterRefList == roRef.IndexInClusterRefList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_SideInfo::sds_fi_tcl_e8_SideInfo():enType(FI_EN_RESERVED) {}

tS32 sds_fi_tcl_e8_SideInfo::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_SIDEINFO;
}


sds_fi_tcl_e8_SideInfo::~sds_fi_tcl_e8_SideInfo()
{}

tU32 sds_fi_tcl_e8_SideInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_SideInfo::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_SideInfo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_s32_EMU::sds_fi_tcl_s32_EMU(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds_fi_tcl_s32_EMU::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_S32_EMU;
}


sds_fi_tcl_s32_EMU::~sds_fi_tcl_s32_EMU()
{}

tU32 sds_fi_tcl_s32_EMU::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_fi_tcl_s32_EMU::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds_fi_tcl_s32_EMU::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_NavZeroCellDesc::sds_fi_tcl_NavZeroCellDesc(const sds_fi_tcl_NavZeroCellDesc& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   ZeroCellId = coRef.ZeroCellId;
   IndexInClusterRefList = coRef.IndexInClusterRefList;
}
sds_fi_tcl_NavZeroCellDesc& sds_fi_tcl_NavZeroCellDesc::operator=(const sds_fi_tcl_NavZeroCellDesc& coRef)
{
   if (this == &coRef) return *this;
   ZeroCellId = coRef.ZeroCellId;
   IndexInClusterRefList = coRef.IndexInClusterRefList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_NavZeroCellDesc::sds_fi_tcl_NavZeroCellDesc()
:ZeroCellId(0)
,IndexInClusterRefList()
 {}

tS32 sds_fi_tcl_NavZeroCellDesc::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_NAVZEROCELLDESC;
}


sds_fi_tcl_NavZeroCellDesc::~sds_fi_tcl_NavZeroCellDesc()
{}

tU32 sds_fi_tcl_NavZeroCellDesc::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_fi_tcl_NavZeroCellDesc::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ZeroCellId);
   (tVoid) (oIn >> IndexInClusterRefList);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_NavZeroCellDesc::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ZeroCellId);
   (tVoid) (oOut << IndexInClusterRefList);
   return oOut;
}

tBool sds_fi_tcl_NavZeroCellDesc::operator==(const sds_fi_tcl_NavZeroCellDesc& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ZeroCellId == roRef.ZeroCellId);
   bResult = bResult && (IndexInClusterRefList == roRef.IndexInClusterRefList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_NavOneCell::sds_fi_tcl_NavOneCell(const sds_fi_tcl_NavOneCell& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   OneCellId = coRef.OneCellId;
   UseDirection = coRef.UseDirection;
   ClusterFileId = coRef.ClusterFileId;
   ClusterFileOffset = coRef.ClusterFileOffset;
   ClusterLength = coRef.ClusterLength;
}
sds_fi_tcl_NavOneCell& sds_fi_tcl_NavOneCell::operator=(const sds_fi_tcl_NavOneCell& coRef)
{
   if (this == &coRef) return *this;
   OneCellId = coRef.OneCellId;
   UseDirection = coRef.UseDirection;
   ClusterFileId = coRef.ClusterFileId;
   ClusterFileOffset = coRef.ClusterFileOffset;
   ClusterLength = coRef.ClusterLength;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_NavOneCell::sds_fi_tcl_NavOneCell()
:OneCellId(0)
,UseDirection()
,ClusterFileId(0)
,ClusterFileOffset(0)
,ClusterLength(0)
 {}

tS32 sds_fi_tcl_NavOneCell::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_NAVONECELL;
}


sds_fi_tcl_NavOneCell::~sds_fi_tcl_NavOneCell()
{}

tU32 sds_fi_tcl_NavOneCell::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& sds_fi_tcl_NavOneCell::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> OneCellId);
   (tVoid) (oIn >> UseDirection);
   (tVoid) (oIn >> ClusterFileId);
   (tVoid) (oIn >> ClusterFileOffset);
   (tVoid) (oIn >> ClusterLength);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_NavOneCell::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << OneCellId);
   (tVoid) (oOut << UseDirection);
   (tVoid) (oOut << ClusterFileId);
   (tVoid) (oOut << ClusterFileOffset);
   (tVoid) (oOut << ClusterLength);
   return oOut;
}

tBool sds_fi_tcl_NavOneCell::operator==(const sds_fi_tcl_NavOneCell& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (OneCellId == roRef.OneCellId);
   bResult = bResult && (UseDirection == roRef.UseDirection);
   bResult = bResult && (ClusterFileId == roRef.ClusterFileId);
   bResult = bResult && (ClusterFileOffset == roRef.ClusterFileOffset);
   bResult = bResult && (ClusterLength == roRef.ClusterLength);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_NavOneCellCategory::sds_fi_tcl_e8_NavOneCellCategory():enType(FI_EN_T_RESERVED) {}

tS32 sds_fi_tcl_e8_NavOneCellCategory::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_NAVONECELLCATEGORY;
}


sds_fi_tcl_e8_NavOneCellCategory::~sds_fi_tcl_e8_NavOneCellCategory()
{}

tU32 sds_fi_tcl_e8_NavOneCellCategory::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_NavOneCellCategory::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_NavOneCellCategory::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_NavLocationDescType::sds_fi_tcl_e8_NavLocationDescType():enType(FI_EN_T_RESERVED) {}

tS32 sds_fi_tcl_e8_NavLocationDescType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_NAVLOCATIONDESCTYPE;
}


sds_fi_tcl_e8_NavLocationDescType::~sds_fi_tcl_e8_NavLocationDescType()
{}

tU32 sds_fi_tcl_e8_NavLocationDescType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_NavLocationDescType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_NavLocationDescType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_NavLocationDesc::sds_fi_tcl_NavLocationDesc(const sds_fi_tcl_NavLocationDesc& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   NavLocationDescTypeType = coRef.NavLocationDescTypeType;
   if  (coRef.poNavLocationDescTypeData)
   {
      switch(NavLocationDescTypeType.enType)
      {
      case sds_fi_tcl_e8_NavLocationDescType::FI_EN_T_RESERVED:
         poNavLocationDescTypeData = OSAL_NEW sds_fi_tcl_Reserved((const sds_fi_tcl_Reserved&)*coRef.poNavLocationDescTypeData);
         break;
      case sds_fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVLOCATIONDATADESC:
         poNavLocationDescTypeData = OSAL_NEW sds_fi_tcl_NavLocationDataDesc((const sds_fi_tcl_NavLocationDataDesc&)*coRef.poNavLocationDescTypeData);
         break;
      case sds_fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONCIRCLE:
         poNavLocationDescTypeData = OSAL_NEW sds_fi_tcl_NavAreaDescriptionCircle((const sds_fi_tcl_NavAreaDescriptionCircle&)*coRef.poNavLocationDescTypeData);
         break;
      case sds_fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONPOLYGON:
         poNavLocationDescTypeData = OSAL_NEW sds_fi_tcl_NavAreaDescriptionPolygon((const sds_fi_tcl_NavAreaDescriptionPolygon&)*coRef.poNavLocationDescTypeData);
         break;
      default:
         poNavLocationDescTypeData = OSAL_NULL;
      }
   }
   else
   {
      poNavLocationDescTypeData = OSAL_NULL;
   }
}
sds_fi_tcl_NavLocationDesc& sds_fi_tcl_NavLocationDesc::operator=(const sds_fi_tcl_NavLocationDesc& coRef)
{
   if (this == &coRef) return *this;
   OSAL_DELETE poNavLocationDescTypeData;
   NavLocationDescTypeType = coRef.NavLocationDescTypeType;
   if  (coRef.poNavLocationDescTypeData)
   {
      switch(NavLocationDescTypeType.enType)
      {
      case sds_fi_tcl_e8_NavLocationDescType::FI_EN_T_RESERVED:
         poNavLocationDescTypeData = OSAL_NEW sds_fi_tcl_Reserved((const sds_fi_tcl_Reserved&)*coRef.poNavLocationDescTypeData);
         break;
      case sds_fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVLOCATIONDATADESC:
         poNavLocationDescTypeData = OSAL_NEW sds_fi_tcl_NavLocationDataDesc((const sds_fi_tcl_NavLocationDataDesc&)*coRef.poNavLocationDescTypeData);
         break;
      case sds_fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONCIRCLE:
         poNavLocationDescTypeData = OSAL_NEW sds_fi_tcl_NavAreaDescriptionCircle((const sds_fi_tcl_NavAreaDescriptionCircle&)*coRef.poNavLocationDescTypeData);
         break;
      case sds_fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONPOLYGON:
         poNavLocationDescTypeData = OSAL_NEW sds_fi_tcl_NavAreaDescriptionPolygon((const sds_fi_tcl_NavAreaDescriptionPolygon&)*coRef.poNavLocationDescTypeData);
         break;
      default:
         poNavLocationDescTypeData = OSAL_NULL;
      }
   }
   else
   {
      poNavLocationDescTypeData = OSAL_NULL;
   }
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_NavLocationDesc::vDestroy()
{
   if (poNavLocationDescTypeData)
   {
      poNavLocationDescTypeData->vDestroy();
      OSAL_DELETE poNavLocationDescTypeData;
      poNavLocationDescTypeData = OSAL_NULL;
   }
}

sds_fi_tcl_NavLocationDesc::sds_fi_tcl_NavLocationDesc()
:poNavLocationDescTypeData(0)
 {}

tS32 sds_fi_tcl_NavLocationDesc::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_NAVLOCATIONDESC;
}


sds_fi_tcl_NavLocationDesc::~sds_fi_tcl_NavLocationDesc()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_NavLocationDesc::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+(poNavLocationDescTypeData?poNavLocationDescTypeData->u32GetSize(u16MajorVersion):0);
}

fi_tclInContext& sds_fi_tcl_NavLocationDesc::oRead(fi_tclInContext& oIn)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poNavLocationDescTypeData;
#else
   if (poNavLocationDescTypeData)
   {
      poNavLocationDescTypeData->vDestroy();
      OSAL_DELETE poNavLocationDescTypeData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   (tVoid) (oIn >> NavLocationDescTypeType);
   switch(NavLocationDescTypeType.enType)
   {
   case sds_fi_tcl_e8_NavLocationDescType::FI_EN_T_RESERVED:
      poNavLocationDescTypeData = OSAL_NEW sds_fi_tcl_Reserved;
      break;
   case sds_fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVLOCATIONDATADESC:
      poNavLocationDescTypeData = OSAL_NEW sds_fi_tcl_NavLocationDataDesc;
      break;
   case sds_fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONCIRCLE:
      poNavLocationDescTypeData = OSAL_NEW sds_fi_tcl_NavAreaDescriptionCircle;
      break;
   case sds_fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONPOLYGON:
      poNavLocationDescTypeData = OSAL_NEW sds_fi_tcl_NavAreaDescriptionPolygon;
      break;
   default:
      oIn.Invalidate();
      poNavLocationDescTypeData = OSAL_NULL;
   }
   if (poNavLocationDescTypeData && oIn.bIsValid())
      poNavLocationDescTypeData->oRead(oIn);
   else
      oIn.Invalidate();
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_NavLocationDesc::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NavLocationDescTypeType);
   if (poNavLocationDescTypeData)
   {
      (tVoid) poNavLocationDescTypeData->oWrite(oOut);
   }
   else
   {
      oOut.Invalidate();
   }
   return oOut;
}

tBool sds_fi_tcl_NavLocationDesc::operator==(const sds_fi_tcl_NavLocationDesc& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NavLocationDescTypeType == roRef.NavLocationDescTypeType);
   if (bResult && poNavLocationDescTypeData && roRef.poNavLocationDescTypeData) 
   {
      switch (NavLocationDescTypeType.enType)
      {
      case sds_fi_tcl_e8_NavLocationDescType::FI_EN_T_RESERVED:
         bResult = bResult && (*(const sds_fi_tcl_Reserved*)poNavLocationDescTypeData == *(const sds_fi_tcl_Reserved*)roRef.poNavLocationDescTypeData); //lint !e826
      break;
      case sds_fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVLOCATIONDATADESC:
         bResult = bResult && (*(const sds_fi_tcl_NavLocationDataDesc*)poNavLocationDescTypeData == *(const sds_fi_tcl_NavLocationDataDesc*)roRef.poNavLocationDescTypeData); //lint !e826
      break;
      case sds_fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONCIRCLE:
         bResult = bResult && (*(const sds_fi_tcl_NavAreaDescriptionCircle*)poNavLocationDescTypeData == *(const sds_fi_tcl_NavAreaDescriptionCircle*)roRef.poNavLocationDescTypeData); //lint !e826
      break;
      case sds_fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONPOLYGON:
         bResult = bResult && (*(const sds_fi_tcl_NavAreaDescriptionPolygon*)poNavLocationDescTypeData == *(const sds_fi_tcl_NavAreaDescriptionPolygon*)roRef.poNavLocationDescTypeData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poNavLocationDescTypeData == roRef.poNavLocationDescTypeData);
   }
   return bResult;
}

//=============================================================================

#ifndef FI_S_EXTERNAL_FI
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_NavLocationBinContainer::sds_fi_tcl_NavLocationBinContainer(const sds_fi_tcl_NavLocationBinContainer& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   ContainerLength = coRef.ContainerLength;
   ServiceID = coRef.ServiceID;
   ContainerFIVersion = coRef.ContainerFIVersion;
   ContainerType = coRef.ContainerType;
   ContainerData = coRef.ContainerData;
}
sds_fi_tcl_NavLocationBinContainer& sds_fi_tcl_NavLocationBinContainer::operator=(const sds_fi_tcl_NavLocationBinContainer& coRef)
{
   if (this == &coRef) return *this;
   ContainerLength = coRef.ContainerLength;
   ServiceID = coRef.ServiceID;
   ContainerFIVersion = coRef.ContainerFIVersion;
   ContainerType = coRef.ContainerType;
   ContainerData = coRef.ContainerData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_NavLocationBinContainer::vDestroy()
{
   ContainerFIVersion.vDestroy(); 
   ContainerData.vDestroy(); 
}

sds_fi_tcl_NavLocationBinContainer::sds_fi_tcl_NavLocationBinContainer()
:ContainerLength(0)
,ServiceID(0)
,ContainerFIVersion()
,ContainerType()
,ContainerData()
 {}

tS32 sds_fi_tcl_NavLocationBinContainer::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_NAVLOCATIONBINCONTAINER;
}


sds_fi_tcl_NavLocationBinContainer::~sds_fi_tcl_NavLocationBinContainer()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_NavLocationBinContainer::u32GetSize(tU16 u16MajorVersion) const
{
   u16MajorVersion = ContainerFIVersion.MajorVersion;
   return 10+ContainerData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_NavLocationBinContainer::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ContainerLength);
   (tVoid) (oIn >> ServiceID);
   (tVoid) (oIn >> ContainerFIVersion);
   (tVoid) (oIn >> ContainerType);
   if (!oIn.bIsValid() ||
       (ContainerLength <= 6) ||
       (ContainerType.enType != sds_fi_tcl_e8_BinContainerTypes::FI_EN_T_NAVLOCATIONBINCONTAINER) ||
       (ContainerFIVersion.MajorVersion < sds_fi_tcl_NavLocationBinContainer::C_U16_MAJORVERSION_MIN) ||
       (ContainerFIVersion.MajorVersion > sds_fi_tcl_NavLocationBinContainer::C_U16_MAJORVERSION_MAX))
   {
      if (oIn.bIsValid() && (ContainerLength >= 6))
      {
         // read rest of container but discard it
         for (tU32 u32Dummy = 0; u32Dummy < (ContainerLength - 6); ++u32Dummy)
         {
            tU8 u8Dummy;
            oIn.oRead(u8Dummy);
         }
      }
      else
      {
         oIn.Invalidate();
      }
      return oIn;
   }
   tU16 u16MajorVersion = oIn.u16SetMajorVersion(ContainerFIVersion.MajorVersion);
   (tVoid) (oIn >> ContainerData);
   oIn.u16SetMajorVersion(u16MajorVersion);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_NavLocationBinContainer::oWrite(fi_tclOutContext& oOut) const
{
   tU16 u16MajorVersion = oOut.u16SetMajorVersion(ContainerFIVersion.MajorVersion);
   (tVoid) (oOut << ContainerLength);
   (tVoid) (oOut << ServiceID);
   (tVoid) (oOut << ContainerFIVersion);
   (tVoid) (oOut << ContainerType);
   (tVoid) (oOut << ContainerData);
   oOut.u16SetMajorVersion(u16MajorVersion);
   return oOut;
}

tBool sds_fi_tcl_NavLocationBinContainer::operator==(const sds_fi_tcl_NavLocationBinContainer& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ContainerLength == roRef.ContainerLength);
   bResult = bResult && (ServiceID == roRef.ServiceID);
   bResult = bResult && (ContainerFIVersion == roRef.ContainerFIVersion);
   bResult = bResult && (ContainerType == roRef.ContainerType);
   bResult = bResult && (ContainerData == roRef.ContainerData);
   return bResult;
}

tU16 sds_fi_tcl_NavLocationBinContainer::u16Transform(const sds_fi_tcl_BinContainer& oContainer)
{
   tU16 u16RetVal = 0;
   if (&oContainer != OSAL_NULL) //lint !e774 (&oContainer CAN be NULL!!)
   {
      this->vDestroy();
      tU32 u32MinSize = this->u32GetSize(sds_fi_tcl_NavLocationBinContainer::C_U16_MAJORVERSION_MAX);
      tU32 u32Size = oContainer.u32GetSize(0);
      if (u32Size >= u32MinSize)
      {
         tU8* pu8Buf = OSAL_NEW tU8[u32Size];
         if (pu8Buf != OSAL_NULL)
         {
            if (oContainer.ContainerDataList[8] == (tU8)sds_fi_tcl_e8_BinContainerTypes::FI_EN_T_NAVLOCATIONBINCONTAINER)
            {
               tU16 u16MajorVersion = oContainer.ContainerDataList[2] + (oContainer.ContainerDataList[3] << 8);
               if ((u16MajorVersion >= sds_fi_tcl_NavLocationBinContainer::C_U16_MAJORVERSION_MIN) &&
                   (u16MajorVersion <= sds_fi_tcl_NavLocationBinContainer::C_U16_MAJORVERSION_MAX))
               {
                  fi_tclOutContext oOut(pu8Buf,pu8Buf+u32Size,u16MajorVersion);
                  fi_tclInContext  oIn (pu8Buf,pu8Buf+u32Size,u16MajorVersion);
                  (tVoid) (oOut << oContainer);
                  (tVoid) (oIn >> *this);
                  if (!oIn.bIsValid())
                  {
                     u16RetVal = SDS_FI_C_U16_ERROR_INTERNALFAILURE;
                  }
               }
               else
               {
                  u16RetVal = SDS_FI_C_U16_ERROR_INVALIDBINCONTAINERWRONGVERSION;
               }
            }
            else
            {
               u16RetVal = SDS_FI_C_U16_ERROR_INVALIDBINCONTAINERUNEXPECTEDDATA;
            }
         }
         else
         {
            this->ContainerType.enType = sds_fi_tcl_e8_BinContainerTypes::FI_EN_T_RESERVED;
            u16RetVal = SDS_FI_C_U16_ERROR_INTERNALFAILURE;
         }
         OSAL_DELETE[] pu8Buf;
      }
      else
      {
         u16RetVal = SDS_FI_C_U16_ERROR_INVALIDBINCONTAINERUNEXPECTEDDATA;
      }
   }
   else
   {
      u16RetVal = SDS_FI_C_U16_ERROR_INVALIDBINCONTAINERUNEXPECTEDDATA;
   }
   return u16RetVal;
}

const tU16 sds_fi_tcl_NavLocationBinContainer::C_U16_MAJORVERSION_MAX = 33;
const tU16 sds_fi_tcl_NavLocationBinContainer::C_U16_MAJORVERSION_MIN = 6;

#endif // FI_S_EXTERNAL_FI
//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_NavIndexZFDestinationType::sds_fi_tcl_e8_NavIndexZFDestinationType():enType(FI_EN_CENTRE) {}

tS32 sds_fi_tcl_e8_NavIndexZFDestinationType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_NAVINDEXZFDESTINATIONTYPE;
}


sds_fi_tcl_e8_NavIndexZFDestinationType::~sds_fi_tcl_e8_NavIndexZFDestinationType()
{}

tU32 sds_fi_tcl_e8_NavIndexZFDestinationType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_NavIndexZFDestinationType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_NavIndexZFDestinationType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_NavLocationNavDataType::sds_fi_tcl_e8_NavLocationNavDataType():enType(FI_EN_T_RESERVED) {}

tS32 sds_fi_tcl_e8_NavLocationNavDataType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_NAVLOCATIONNAVDATATYPE;
}


sds_fi_tcl_e8_NavLocationNavDataType::~sds_fi_tcl_e8_NavLocationNavDataType()
{}

tU32 sds_fi_tcl_e8_NavLocationNavDataType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_NavLocationNavDataType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_NavLocationNavDataType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_NavLocationDataDesc::sds_fi_tcl_NavLocationDataDesc(const sds_fi_tcl_NavLocationDataDesc& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   NavDataSetID = coRef.NavDataSetID;
   IndexZFDestType = coRef.IndexZFDestType;
   ObjectPointRefList = coRef.ObjectPointRefList;
   AccessPointRefList = coRef.AccessPointRefList;
   NavDataTypeType = coRef.NavDataTypeType;
   if  (coRef.poNavDataTypeData)
   {
      switch(NavDataTypeType.enType)
      {
      case sds_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_RESERVED:
         poNavDataTypeData = OSAL_NEW sds_fi_tcl_Reserved((const sds_fi_tcl_Reserved&)*coRef.poNavDataTypeData);
         break;
      case sds_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
         poNavDataTypeData = OSAL_NEW sds_fi_tcl_NavIntersectionDestinationZeroCellListSet((const sds_fi_tcl_NavIntersectionDestinationZeroCellListSet&)*coRef.poNavDataTypeData);
         break;
      case sds_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSTREETDESTINATIONONECELLLISTSET:
         poNavDataTypeData = OSAL_NEW sds_fi_tcl_NavStreetDestinationOneCellListSet((const sds_fi_tcl_NavStreetDestinationOneCellListSet&)*coRef.poNavDataTypeData);
         break;
      case sds_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSPOTDESTINATIONONECELLLISTSET:
         poNavDataTypeData = OSAL_NEW sds_fi_tcl_NavSpotDestinationOneCellListSet((const sds_fi_tcl_NavSpotDestinationOneCellListSet&)*coRef.poNavDataTypeData);
         break;
      default:
         poNavDataTypeData = OSAL_NULL;
      }
   }
   else
   {
      poNavDataTypeData = OSAL_NULL;
   }
}
sds_fi_tcl_NavLocationDataDesc& sds_fi_tcl_NavLocationDataDesc::operator=(const sds_fi_tcl_NavLocationDataDesc& coRef)
{
   if (this == &coRef) return *this;
   NavDataSetID = coRef.NavDataSetID;
   IndexZFDestType = coRef.IndexZFDestType;
   ObjectPointRefList = coRef.ObjectPointRefList;
   AccessPointRefList = coRef.AccessPointRefList;
   OSAL_DELETE poNavDataTypeData;
   NavDataTypeType = coRef.NavDataTypeType;
   if  (coRef.poNavDataTypeData)
   {
      switch(NavDataTypeType.enType)
      {
      case sds_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_RESERVED:
         poNavDataTypeData = OSAL_NEW sds_fi_tcl_Reserved((const sds_fi_tcl_Reserved&)*coRef.poNavDataTypeData);
         break;
      case sds_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
         poNavDataTypeData = OSAL_NEW sds_fi_tcl_NavIntersectionDestinationZeroCellListSet((const sds_fi_tcl_NavIntersectionDestinationZeroCellListSet&)*coRef.poNavDataTypeData);
         break;
      case sds_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSTREETDESTINATIONONECELLLISTSET:
         poNavDataTypeData = OSAL_NEW sds_fi_tcl_NavStreetDestinationOneCellListSet((const sds_fi_tcl_NavStreetDestinationOneCellListSet&)*coRef.poNavDataTypeData);
         break;
      case sds_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSPOTDESTINATIONONECELLLISTSET:
         poNavDataTypeData = OSAL_NEW sds_fi_tcl_NavSpotDestinationOneCellListSet((const sds_fi_tcl_NavSpotDestinationOneCellListSet&)*coRef.poNavDataTypeData);
         break;
      default:
         poNavDataTypeData = OSAL_NULL;
      }
   }
   else
   {
      poNavDataTypeData = OSAL_NULL;
   }
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_NavLocationDataDesc::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ObjectPointRefList.size(); ++u32Idx)
         ObjectPointRefList[u32Idx].vDestroy();
   ObjectPointRefList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < AccessPointRefList.size(); ++u32Idx)
         AccessPointRefList[u32Idx].vDestroy();
   AccessPointRefList.clear();
   }
   if (poNavDataTypeData)
   {
      poNavDataTypeData->vDestroy();
      OSAL_DELETE poNavDataTypeData;
      poNavDataTypeData = OSAL_NULL;
   }
}

sds_fi_tcl_NavLocationDataDesc::sds_fi_tcl_NavLocationDataDesc()
:NavDataSetID()
,IndexZFDestType()


,poNavDataTypeData(0)
 {}

tS32 sds_fi_tcl_NavLocationDataDesc::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_NAVLOCATIONDATADESC;
}


sds_fi_tcl_NavLocationDataDesc::~sds_fi_tcl_NavLocationDataDesc()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_NavLocationDataDesc::u32GetSize(tU16 u16MajorVersion) const
{
   return 14+ObjectPointRefList.size()*8+AccessPointRefList.size()*8+(poNavDataTypeData?poNavDataTypeData->u32GetSize(u16MajorVersion):0);
}

fi_tclInContext& sds_fi_tcl_NavLocationDataDesc::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> NavDataSetID);
   (tVoid) (oIn >> IndexZFDestType);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ObjectPointRefList.size(); ++u32Idx)
      {
         ObjectPointRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ObjectPointRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ObjectPointRefList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AccessPointRefList.size(); ++u32Idx)
      {
         AccessPointRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AccessPointRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AccessPointRefList[u32Idx]);
      }
   }
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poNavDataTypeData;
#else
   if (poNavDataTypeData)
   {
      poNavDataTypeData->vDestroy();
      OSAL_DELETE poNavDataTypeData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   (tVoid) (oIn >> NavDataTypeType);
   switch(NavDataTypeType.enType)
   {
   case sds_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_RESERVED:
      poNavDataTypeData = OSAL_NEW sds_fi_tcl_Reserved;
      break;
   case sds_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
      poNavDataTypeData = OSAL_NEW sds_fi_tcl_NavIntersectionDestinationZeroCellListSet;
      break;
   case sds_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSTREETDESTINATIONONECELLLISTSET:
      poNavDataTypeData = OSAL_NEW sds_fi_tcl_NavStreetDestinationOneCellListSet;
      break;
   case sds_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSPOTDESTINATIONONECELLLISTSET:
      poNavDataTypeData = OSAL_NEW sds_fi_tcl_NavSpotDestinationOneCellListSet;
      break;
   default:
      oIn.Invalidate();
      poNavDataTypeData = OSAL_NULL;
   }
   if (poNavDataTypeData && oIn.bIsValid())
      poNavDataTypeData->oRead(oIn);
   else
      oIn.Invalidate();
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_NavLocationDataDesc::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NavDataSetID);
   (tVoid) (oOut << IndexZFDestType);
   (tVoid) (oOut << (tU32)ObjectPointRefList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ObjectPointRefList.size(); ++u32Idx)
         (tVoid) (oOut << ObjectPointRefList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)AccessPointRefList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AccessPointRefList.size(); ++u32Idx)
         (tVoid) (oOut << AccessPointRefList[u32Idx]);
   }
   (tVoid) (oOut << NavDataTypeType);
   if (poNavDataTypeData)
   {
      (tVoid) poNavDataTypeData->oWrite(oOut);
   }
   else
   {
      oOut.Invalidate();
   }
   return oOut;
}

tBool sds_fi_tcl_NavLocationDataDesc::operator==(const sds_fi_tcl_NavLocationDataDesc& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NavDataSetID == roRef.NavDataSetID);
   bResult = bResult && (IndexZFDestType == roRef.IndexZFDestType);
      bResult = bResult && (ObjectPointRefList.size() == roRef.ObjectPointRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ObjectPointRefList.size()); ++u32Idx)
            bResult = bResult && (ObjectPointRefList[u32Idx] == roRef.ObjectPointRefList[u32Idx]);
      }
      bResult = bResult && (AccessPointRefList.size() == roRef.AccessPointRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AccessPointRefList.size()); ++u32Idx)
            bResult = bResult && (AccessPointRefList[u32Idx] == roRef.AccessPointRefList[u32Idx]);
      }
   bResult = bResult && (NavDataTypeType == roRef.NavDataTypeType);
   if (bResult && poNavDataTypeData && roRef.poNavDataTypeData) 
   {
      switch (NavDataTypeType.enType)
      {
      case sds_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_RESERVED:
         bResult = bResult && (*(const sds_fi_tcl_Reserved*)poNavDataTypeData == *(const sds_fi_tcl_Reserved*)roRef.poNavDataTypeData); //lint !e826
      break;
      case sds_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
         bResult = bResult && (*(const sds_fi_tcl_NavIntersectionDestinationZeroCellListSet*)poNavDataTypeData == *(const sds_fi_tcl_NavIntersectionDestinationZeroCellListSet*)roRef.poNavDataTypeData); //lint !e826
      break;
      case sds_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSTREETDESTINATIONONECELLLISTSET:
         bResult = bResult && (*(const sds_fi_tcl_NavStreetDestinationOneCellListSet*)poNavDataTypeData == *(const sds_fi_tcl_NavStreetDestinationOneCellListSet*)roRef.poNavDataTypeData); //lint !e826
      break;
      case sds_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSPOTDESTINATIONONECELLLISTSET:
         bResult = bResult && (*(const sds_fi_tcl_NavSpotDestinationOneCellListSet*)poNavDataTypeData == *(const sds_fi_tcl_NavSpotDestinationOneCellListSet*)roRef.poNavDataTypeData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poNavDataTypeData == roRef.poNavDataTypeData);
   }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_NavSpotDestinationOneCellProperty::sds_fi_tcl_NavSpotDestinationOneCellProperty(const sds_fi_tcl_NavSpotDestinationOneCellProperty& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   SideInfo = coRef.SideInfo;
   FromZeroCellToSpotLength = coRef.FromZeroCellToSpotLength;
   OneCellLength = coRef.OneCellLength;
   DestDistance = coRef.DestDistance;
   DecisionPoint = coRef.DecisionPoint;
   IndexInObjectPointRefList = coRef.IndexInObjectPointRefList;
   IndexInAccessPointRefList = coRef.IndexInAccessPointRefList;
}
sds_fi_tcl_NavSpotDestinationOneCellProperty& sds_fi_tcl_NavSpotDestinationOneCellProperty::operator=(const sds_fi_tcl_NavSpotDestinationOneCellProperty& coRef)
{
   if (this == &coRef) return *this;
   SideInfo = coRef.SideInfo;
   FromZeroCellToSpotLength = coRef.FromZeroCellToSpotLength;
   OneCellLength = coRef.OneCellLength;
   DestDistance = coRef.DestDistance;
   DecisionPoint = coRef.DecisionPoint;
   IndexInObjectPointRefList = coRef.IndexInObjectPointRefList;
   IndexInAccessPointRefList = coRef.IndexInAccessPointRefList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_NavSpotDestinationOneCellProperty::sds_fi_tcl_NavSpotDestinationOneCellProperty()
:SideInfo()
,FromZeroCellToSpotLength()
,OneCellLength()
,DestDistance()
,DecisionPoint()
,IndexInObjectPointRefList()
,IndexInAccessPointRefList()
 {}

tS32 sds_fi_tcl_NavSpotDestinationOneCellProperty::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_NAVSPOTDESTINATIONONECELLPROPERTY;
}


sds_fi_tcl_NavSpotDestinationOneCellProperty::~sds_fi_tcl_NavSpotDestinationOneCellProperty()
{}

tU32 sds_fi_tcl_NavSpotDestinationOneCellProperty::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 25;
}

fi_tclInContext& sds_fi_tcl_NavSpotDestinationOneCellProperty::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SideInfo);
   (tVoid) (oIn >> FromZeroCellToSpotLength);
   (tVoid) (oIn >> OneCellLength);
   (tVoid) (oIn >> DestDistance);
   (tVoid) (oIn >> DecisionPoint);
   (tVoid) (oIn >> IndexInObjectPointRefList);
   (tVoid) (oIn >> IndexInAccessPointRefList);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_NavSpotDestinationOneCellProperty::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SideInfo);
   (tVoid) (oOut << FromZeroCellToSpotLength);
   (tVoid) (oOut << OneCellLength);
   (tVoid) (oOut << DestDistance);
   (tVoid) (oOut << DecisionPoint);
   (tVoid) (oOut << IndexInObjectPointRefList);
   (tVoid) (oOut << IndexInAccessPointRefList);
   return oOut;
}

tBool sds_fi_tcl_NavSpotDestinationOneCellProperty::operator==(const sds_fi_tcl_NavSpotDestinationOneCellProperty& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SideInfo == roRef.SideInfo);
   bResult = bResult && (FromZeroCellToSpotLength == roRef.FromZeroCellToSpotLength);
   bResult = bResult && (OneCellLength == roRef.OneCellLength);
   bResult = bResult && (DestDistance == roRef.DestDistance);
   bResult = bResult && (DecisionPoint == roRef.DecisionPoint);
   bResult = bResult && (IndexInObjectPointRefList == roRef.IndexInObjectPointRefList);
   bResult = bResult && (IndexInAccessPointRefList == roRef.IndexInAccessPointRefList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_NavSpotDestinationOneCellDesc::sds_fi_tcl_NavSpotDestinationOneCellDesc(const sds_fi_tcl_NavSpotDestinationOneCellDesc& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   OneCellDesc = coRef.OneCellDesc;
   OneCellProperty = coRef.OneCellProperty;
}
sds_fi_tcl_NavSpotDestinationOneCellDesc& sds_fi_tcl_NavSpotDestinationOneCellDesc::operator=(const sds_fi_tcl_NavSpotDestinationOneCellDesc& coRef)
{
   if (this == &coRef) return *this;
   OneCellDesc = coRef.OneCellDesc;
   OneCellProperty = coRef.OneCellProperty;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_NavSpotDestinationOneCellDesc::sds_fi_tcl_NavSpotDestinationOneCellDesc()
:OneCellDesc()
,OneCellProperty()
 {}

tS32 sds_fi_tcl_NavSpotDestinationOneCellDesc::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_NAVSPOTDESTINATIONONECELLDESC;
}


sds_fi_tcl_NavSpotDestinationOneCellDesc::~sds_fi_tcl_NavSpotDestinationOneCellDesc()
{}

tU32 sds_fi_tcl_NavSpotDestinationOneCellDesc::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 30;
}

fi_tclInContext& sds_fi_tcl_NavSpotDestinationOneCellDesc::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> OneCellDesc);
   (tVoid) (oIn >> OneCellProperty);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_NavSpotDestinationOneCellDesc::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << OneCellDesc);
   (tVoid) (oOut << OneCellProperty);
   return oOut;
}

tBool sds_fi_tcl_NavSpotDestinationOneCellDesc::operator==(const sds_fi_tcl_NavSpotDestinationOneCellDesc& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (OneCellDesc == roRef.OneCellDesc);
   bResult = bResult && (OneCellProperty == roRef.OneCellProperty);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_NavSpotDestinationOneCellListSet::sds_fi_tcl_NavSpotDestinationOneCellListSet(const sds_fi_tcl_NavSpotDestinationOneCellListSet& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   ClusterRefList = coRef.ClusterRefList;
   SpotDestinationOneCellRefList = coRef.SpotDestinationOneCellRefList;
}
sds_fi_tcl_NavSpotDestinationOneCellListSet& sds_fi_tcl_NavSpotDestinationOneCellListSet::operator=(const sds_fi_tcl_NavSpotDestinationOneCellListSet& coRef)
{
   if (this == &coRef) return *this;
   ClusterRefList = coRef.ClusterRefList;
   SpotDestinationOneCellRefList = coRef.SpotDestinationOneCellRefList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_NavSpotDestinationOneCellListSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
         ClusterRefList[u32Idx].vDestroy();
   ClusterRefList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < SpotDestinationOneCellRefList.size(); ++u32Idx)
         SpotDestinationOneCellRefList[u32Idx].vDestroy();
   SpotDestinationOneCellRefList.clear();
   }
}

sds_fi_tcl_NavSpotDestinationOneCellListSet::sds_fi_tcl_NavSpotDestinationOneCellListSet()


 {}

tS32 sds_fi_tcl_NavSpotDestinationOneCellListSet::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_NAVSPOTDESTINATIONONECELLLISTSET;
}


sds_fi_tcl_NavSpotDestinationOneCellListSet::~sds_fi_tcl_NavSpotDestinationOneCellListSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_NavSpotDestinationOneCellListSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ClusterRefList.size()*9+SpotDestinationOneCellRefList.size()*30;
}

fi_tclInContext& sds_fi_tcl_NavSpotDestinationOneCellListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
      {
         ClusterRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ClusterRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ClusterRefList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SpotDestinationOneCellRefList.size(); ++u32Idx)
      {
         SpotDestinationOneCellRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SpotDestinationOneCellRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SpotDestinationOneCellRefList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_NavSpotDestinationOneCellListSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ClusterRefList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
         (tVoid) (oOut << ClusterRefList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)SpotDestinationOneCellRefList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SpotDestinationOneCellRefList.size(); ++u32Idx)
         (tVoid) (oOut << SpotDestinationOneCellRefList[u32Idx]);
   }
   return oOut;
}

tBool sds_fi_tcl_NavSpotDestinationOneCellListSet::operator==(const sds_fi_tcl_NavSpotDestinationOneCellListSet& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ClusterRefList.size() == roRef.ClusterRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ClusterRefList.size()); ++u32Idx)
            bResult = bResult && (ClusterRefList[u32Idx] == roRef.ClusterRefList[u32Idx]);
      }
      bResult = bResult && (SpotDestinationOneCellRefList.size() == roRef.SpotDestinationOneCellRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SpotDestinationOneCellRefList.size()); ++u32Idx)
            bResult = bResult && (SpotDestinationOneCellRefList[u32Idx] == roRef.SpotDestinationOneCellRefList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_NavStreetDestinationOneCellProperty::sds_fi_tcl_NavStreetDestinationOneCellProperty(const sds_fi_tcl_NavStreetDestinationOneCellProperty& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   SideInfo = coRef.SideInfo;
   IndexInObjectPointRefList = coRef.IndexInObjectPointRefList;
   IndexInAccessPointRefList = coRef.IndexInAccessPointRefList;
}
sds_fi_tcl_NavStreetDestinationOneCellProperty& sds_fi_tcl_NavStreetDestinationOneCellProperty::operator=(const sds_fi_tcl_NavStreetDestinationOneCellProperty& coRef)
{
   if (this == &coRef) return *this;
   SideInfo = coRef.SideInfo;
   IndexInObjectPointRefList = coRef.IndexInObjectPointRefList;
   IndexInAccessPointRefList = coRef.IndexInAccessPointRefList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_NavStreetDestinationOneCellProperty::sds_fi_tcl_NavStreetDestinationOneCellProperty()
:SideInfo()
,IndexInObjectPointRefList()
,IndexInAccessPointRefList()
 {}

tS32 sds_fi_tcl_NavStreetDestinationOneCellProperty::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_NAVSTREETDESTINATIONONECELLPROPERTY;
}


sds_fi_tcl_NavStreetDestinationOneCellProperty::~sds_fi_tcl_NavStreetDestinationOneCellProperty()
{}

tU32 sds_fi_tcl_NavStreetDestinationOneCellProperty::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds_fi_tcl_NavStreetDestinationOneCellProperty::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SideInfo);
   (tVoid) (oIn >> IndexInObjectPointRefList);
   (tVoid) (oIn >> IndexInAccessPointRefList);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_NavStreetDestinationOneCellProperty::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SideInfo);
   (tVoid) (oOut << IndexInObjectPointRefList);
   (tVoid) (oOut << IndexInAccessPointRefList);
   return oOut;
}

tBool sds_fi_tcl_NavStreetDestinationOneCellProperty::operator==(const sds_fi_tcl_NavStreetDestinationOneCellProperty& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SideInfo == roRef.SideInfo);
   bResult = bResult && (IndexInObjectPointRefList == roRef.IndexInObjectPointRefList);
   bResult = bResult && (IndexInAccessPointRefList == roRef.IndexInAccessPointRefList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_NavStreetDestinationOneCellDesc::sds_fi_tcl_NavStreetDestinationOneCellDesc(const sds_fi_tcl_NavStreetDestinationOneCellDesc& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   OneCellDesc = coRef.OneCellDesc;
   OneCellProperty = coRef.OneCellProperty;
}
sds_fi_tcl_NavStreetDestinationOneCellDesc& sds_fi_tcl_NavStreetDestinationOneCellDesc::operator=(const sds_fi_tcl_NavStreetDestinationOneCellDesc& coRef)
{
   if (this == &coRef) return *this;
   OneCellDesc = coRef.OneCellDesc;
   OneCellProperty = coRef.OneCellProperty;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_NavStreetDestinationOneCellDesc::sds_fi_tcl_NavStreetDestinationOneCellDesc()
:OneCellDesc()
,OneCellProperty()
 {}

tS32 sds_fi_tcl_NavStreetDestinationOneCellDesc::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_NAVSTREETDESTINATIONONECELLDESC;
}


sds_fi_tcl_NavStreetDestinationOneCellDesc::~sds_fi_tcl_NavStreetDestinationOneCellDesc()
{}

tU32 sds_fi_tcl_NavStreetDestinationOneCellDesc::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& sds_fi_tcl_NavStreetDestinationOneCellDesc::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> OneCellDesc);
   (tVoid) (oIn >> OneCellProperty);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_NavStreetDestinationOneCellDesc::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << OneCellDesc);
   (tVoid) (oOut << OneCellProperty);
   return oOut;
}

tBool sds_fi_tcl_NavStreetDestinationOneCellDesc::operator==(const sds_fi_tcl_NavStreetDestinationOneCellDesc& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (OneCellDesc == roRef.OneCellDesc);
   bResult = bResult && (OneCellProperty == roRef.OneCellProperty);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_NavStreetDestinationOneCellListSet::sds_fi_tcl_NavStreetDestinationOneCellListSet(const sds_fi_tcl_NavStreetDestinationOneCellListSet& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   ClusterRefList = coRef.ClusterRefList;
   StreetDestinationOneCellRefList = coRef.StreetDestinationOneCellRefList;
}
sds_fi_tcl_NavStreetDestinationOneCellListSet& sds_fi_tcl_NavStreetDestinationOneCellListSet::operator=(const sds_fi_tcl_NavStreetDestinationOneCellListSet& coRef)
{
   if (this == &coRef) return *this;
   ClusterRefList = coRef.ClusterRefList;
   StreetDestinationOneCellRefList = coRef.StreetDestinationOneCellRefList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_NavStreetDestinationOneCellListSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
         ClusterRefList[u32Idx].vDestroy();
   ClusterRefList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < StreetDestinationOneCellRefList.size(); ++u32Idx)
         StreetDestinationOneCellRefList[u32Idx].vDestroy();
   StreetDestinationOneCellRefList.clear();
   }
}

sds_fi_tcl_NavStreetDestinationOneCellListSet::sds_fi_tcl_NavStreetDestinationOneCellListSet()


 {}

tS32 sds_fi_tcl_NavStreetDestinationOneCellListSet::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_NAVSTREETDESTINATIONONECELLLISTSET;
}


sds_fi_tcl_NavStreetDestinationOneCellListSet::~sds_fi_tcl_NavStreetDestinationOneCellListSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_NavStreetDestinationOneCellListSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ClusterRefList.size()*9+StreetDestinationOneCellRefList.size()*10;
}

fi_tclInContext& sds_fi_tcl_NavStreetDestinationOneCellListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
      {
         ClusterRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ClusterRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ClusterRefList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StreetDestinationOneCellRefList.size(); ++u32Idx)
      {
         StreetDestinationOneCellRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      StreetDestinationOneCellRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> StreetDestinationOneCellRefList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_NavStreetDestinationOneCellListSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ClusterRefList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
         (tVoid) (oOut << ClusterRefList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)StreetDestinationOneCellRefList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < StreetDestinationOneCellRefList.size(); ++u32Idx)
         (tVoid) (oOut << StreetDestinationOneCellRefList[u32Idx]);
   }
   return oOut;
}

tBool sds_fi_tcl_NavStreetDestinationOneCellListSet::operator==(const sds_fi_tcl_NavStreetDestinationOneCellListSet& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ClusterRefList.size() == roRef.ClusterRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ClusterRefList.size()); ++u32Idx)
            bResult = bResult && (ClusterRefList[u32Idx] == roRef.ClusterRefList[u32Idx]);
      }
      bResult = bResult && (StreetDestinationOneCellRefList.size() == roRef.StreetDestinationOneCellRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StreetDestinationOneCellRefList.size()); ++u32Idx)
            bResult = bResult && (StreetDestinationOneCellRefList[u32Idx] == roRef.StreetDestinationOneCellRefList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_NavIntersectionType::sds_fi_tcl_e8_NavIntersectionType():enType(FI_EN_OBJECTINTERSECTION) {}

tS32 sds_fi_tcl_e8_NavIntersectionType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_NAVINTERSECTIONTYPE;
}


sds_fi_tcl_e8_NavIntersectionType::~sds_fi_tcl_e8_NavIntersectionType()
{}

tU32 sds_fi_tcl_e8_NavIntersectionType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_NavIntersectionType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_NavIntersectionType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_NavIntersectionDestinationZeroCellProperty::sds_fi_tcl_NavIntersectionDestinationZeroCellProperty(const sds_fi_tcl_NavIntersectionDestinationZeroCellProperty& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   IntersectionType = coRef.IntersectionType;
   IndexInObjectPointRefList = coRef.IndexInObjectPointRefList;
   IndexInAccessPointRefList = coRef.IndexInAccessPointRefList;
}
sds_fi_tcl_NavIntersectionDestinationZeroCellProperty& sds_fi_tcl_NavIntersectionDestinationZeroCellProperty::operator=(const sds_fi_tcl_NavIntersectionDestinationZeroCellProperty& coRef)
{
   if (this == &coRef) return *this;
   IntersectionType = coRef.IntersectionType;
   IndexInObjectPointRefList = coRef.IndexInObjectPointRefList;
   IndexInAccessPointRefList = coRef.IndexInAccessPointRefList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_NavIntersectionDestinationZeroCellProperty::sds_fi_tcl_NavIntersectionDestinationZeroCellProperty()
:IntersectionType()
,IndexInObjectPointRefList()
,IndexInAccessPointRefList()
 {}

tS32 sds_fi_tcl_NavIntersectionDestinationZeroCellProperty::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLPROPERTY;
}


sds_fi_tcl_NavIntersectionDestinationZeroCellProperty::~sds_fi_tcl_NavIntersectionDestinationZeroCellProperty()
{}

tU32 sds_fi_tcl_NavIntersectionDestinationZeroCellProperty::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds_fi_tcl_NavIntersectionDestinationZeroCellProperty::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> IntersectionType);
   (tVoid) (oIn >> IndexInObjectPointRefList);
   (tVoid) (oIn >> IndexInAccessPointRefList);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_NavIntersectionDestinationZeroCellProperty::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << IntersectionType);
   (tVoid) (oOut << IndexInObjectPointRefList);
   (tVoid) (oOut << IndexInAccessPointRefList);
   return oOut;
}

tBool sds_fi_tcl_NavIntersectionDestinationZeroCellProperty::operator==(const sds_fi_tcl_NavIntersectionDestinationZeroCellProperty& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (IntersectionType == roRef.IntersectionType);
   bResult = bResult && (IndexInObjectPointRefList == roRef.IndexInObjectPointRefList);
   bResult = bResult && (IndexInAccessPointRefList == roRef.IndexInAccessPointRefList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_NavIntersectionDestinationZeroCellDesc::sds_fi_tcl_NavIntersectionDestinationZeroCellDesc(const sds_fi_tcl_NavIntersectionDestinationZeroCellDesc& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   ZeroCellDesc = coRef.ZeroCellDesc;
   ZeroCellProperty = coRef.ZeroCellProperty;
}
sds_fi_tcl_NavIntersectionDestinationZeroCellDesc& sds_fi_tcl_NavIntersectionDestinationZeroCellDesc::operator=(const sds_fi_tcl_NavIntersectionDestinationZeroCellDesc& coRef)
{
   if (this == &coRef) return *this;
   ZeroCellDesc = coRef.ZeroCellDesc;
   ZeroCellProperty = coRef.ZeroCellProperty;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_NavIntersectionDestinationZeroCellDesc::sds_fi_tcl_NavIntersectionDestinationZeroCellDesc()
:ZeroCellDesc()
,ZeroCellProperty()
 {}

tS32 sds_fi_tcl_NavIntersectionDestinationZeroCellDesc::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLDESC;
}


sds_fi_tcl_NavIntersectionDestinationZeroCellDesc::~sds_fi_tcl_NavIntersectionDestinationZeroCellDesc()
{}

tU32 sds_fi_tcl_NavIntersectionDestinationZeroCellDesc::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& sds_fi_tcl_NavIntersectionDestinationZeroCellDesc::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ZeroCellDesc);
   (tVoid) (oIn >> ZeroCellProperty);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_NavIntersectionDestinationZeroCellDesc::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ZeroCellDesc);
   (tVoid) (oOut << ZeroCellProperty);
   return oOut;
}

tBool sds_fi_tcl_NavIntersectionDestinationZeroCellDesc::operator==(const sds_fi_tcl_NavIntersectionDestinationZeroCellDesc& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ZeroCellDesc == roRef.ZeroCellDesc);
   bResult = bResult && (ZeroCellProperty == roRef.ZeroCellProperty);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_NavIntersectionDestinationZeroCellListSet::sds_fi_tcl_NavIntersectionDestinationZeroCellListSet(const sds_fi_tcl_NavIntersectionDestinationZeroCellListSet& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   ClusterRefList = coRef.ClusterRefList;
   IntersectionDestinationZeroCellRefList = coRef.IntersectionDestinationZeroCellRefList;
}
sds_fi_tcl_NavIntersectionDestinationZeroCellListSet& sds_fi_tcl_NavIntersectionDestinationZeroCellListSet::operator=(const sds_fi_tcl_NavIntersectionDestinationZeroCellListSet& coRef)
{
   if (this == &coRef) return *this;
   ClusterRefList = coRef.ClusterRefList;
   IntersectionDestinationZeroCellRefList = coRef.IntersectionDestinationZeroCellRefList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_NavIntersectionDestinationZeroCellListSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
         ClusterRefList[u32Idx].vDestroy();
   ClusterRefList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < IntersectionDestinationZeroCellRefList.size(); ++u32Idx)
         IntersectionDestinationZeroCellRefList[u32Idx].vDestroy();
   IntersectionDestinationZeroCellRefList.clear();
   }
}

sds_fi_tcl_NavIntersectionDestinationZeroCellListSet::sds_fi_tcl_NavIntersectionDestinationZeroCellListSet()


 {}

tS32 sds_fi_tcl_NavIntersectionDestinationZeroCellListSet::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET;
}


sds_fi_tcl_NavIntersectionDestinationZeroCellListSet::~sds_fi_tcl_NavIntersectionDestinationZeroCellListSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_NavIntersectionDestinationZeroCellListSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ClusterRefList.size()*9+IntersectionDestinationZeroCellRefList.size()*9;
}

fi_tclInContext& sds_fi_tcl_NavIntersectionDestinationZeroCellListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
      {
         ClusterRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ClusterRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ClusterRefList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < IntersectionDestinationZeroCellRefList.size(); ++u32Idx)
      {
         IntersectionDestinationZeroCellRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      IntersectionDestinationZeroCellRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> IntersectionDestinationZeroCellRefList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_NavIntersectionDestinationZeroCellListSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ClusterRefList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
         (tVoid) (oOut << ClusterRefList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)IntersectionDestinationZeroCellRefList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < IntersectionDestinationZeroCellRefList.size(); ++u32Idx)
         (tVoid) (oOut << IntersectionDestinationZeroCellRefList[u32Idx]);
   }
   return oOut;
}

tBool sds_fi_tcl_NavIntersectionDestinationZeroCellListSet::operator==(const sds_fi_tcl_NavIntersectionDestinationZeroCellListSet& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ClusterRefList.size() == roRef.ClusterRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ClusterRefList.size()); ++u32Idx)
            bResult = bResult && (ClusterRefList[u32Idx] == roRef.ClusterRefList[u32Idx]);
      }
      bResult = bResult && (IntersectionDestinationZeroCellRefList.size() == roRef.IntersectionDestinationZeroCellRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < IntersectionDestinationZeroCellRefList.size()); ++u32Idx)
            bResult = bResult && (IntersectionDestinationZeroCellRefList[u32Idx] == roRef.IntersectionDestinationZeroCellRefList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_NavAreaDescriptionCircle::sds_fi_tcl_NavAreaDescriptionCircle(const sds_fi_tcl_NavAreaDescriptionCircle& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   Radius = coRef.Radius;
   Coordinate = coRef.Coordinate;
}
sds_fi_tcl_NavAreaDescriptionCircle& sds_fi_tcl_NavAreaDescriptionCircle::operator=(const sds_fi_tcl_NavAreaDescriptionCircle& coRef)
{
   if (this == &coRef) return *this;
   Radius = coRef.Radius;
   Coordinate = coRef.Coordinate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_NavAreaDescriptionCircle::sds_fi_tcl_NavAreaDescriptionCircle()
:Radius()
,Coordinate()
 {}

tS32 sds_fi_tcl_NavAreaDescriptionCircle::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_NAVAREADESCRIPTIONCIRCLE;
}


sds_fi_tcl_NavAreaDescriptionCircle::~sds_fi_tcl_NavAreaDescriptionCircle()
{}

tU32 sds_fi_tcl_NavAreaDescriptionCircle::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& sds_fi_tcl_NavAreaDescriptionCircle::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Radius);
   (tVoid) (oIn >> Coordinate);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_NavAreaDescriptionCircle::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Radius);
   (tVoid) (oOut << Coordinate);
   return oOut;
}

tBool sds_fi_tcl_NavAreaDescriptionCircle::operator==(const sds_fi_tcl_NavAreaDescriptionCircle& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Radius == roRef.Radius);
   bResult = bResult && (Coordinate == roRef.Coordinate);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_NavAreaDescriptionPolygon::sds_fi_tcl_NavAreaDescriptionPolygon(const sds_fi_tcl_NavAreaDescriptionPolygon& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   CoordinateList = coRef.CoordinateList;
}
sds_fi_tcl_NavAreaDescriptionPolygon& sds_fi_tcl_NavAreaDescriptionPolygon::operator=(const sds_fi_tcl_NavAreaDescriptionPolygon& coRef)
{
   if (this == &coRef) return *this;
   CoordinateList = coRef.CoordinateList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_NavAreaDescriptionPolygon::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < CoordinateList.size(); ++u32Idx)
         CoordinateList[u32Idx].vDestroy();
   CoordinateList.clear();
   }
}

sds_fi_tcl_NavAreaDescriptionPolygon::sds_fi_tcl_NavAreaDescriptionPolygon()

 {}

tS32 sds_fi_tcl_NavAreaDescriptionPolygon::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_NAVAREADESCRIPTIONPOLYGON;
}


sds_fi_tcl_NavAreaDescriptionPolygon::~sds_fi_tcl_NavAreaDescriptionPolygon()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_NavAreaDescriptionPolygon::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+CoordinateList.size()*8;
}

fi_tclInContext& sds_fi_tcl_NavAreaDescriptionPolygon::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CoordinateList.size(); ++u32Idx)
      {
         CoordinateList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      CoordinateList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> CoordinateList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_NavAreaDescriptionPolygon::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)CoordinateList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < CoordinateList.size(); ++u32Idx)
         (tVoid) (oOut << CoordinateList[u32Idx]);
   }
   return oOut;
}

tBool sds_fi_tcl_NavAreaDescriptionPolygon::operator==(const sds_fi_tcl_NavAreaDescriptionPolygon& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (CoordinateList.size() == roRef.CoordinateList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CoordinateList.size()); ++u32Idx)
            bResult = bResult && (CoordinateList[u32Idx] == roRef.CoordinateList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_u64_tPVoid::sds_fi_tcl_u64_tPVoid(tU64 _u64Value)
: u64Value(_u64Value
) {} 

tS32 sds_fi_tcl_u64_tPVoid::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_U64_TPVOID;
}


sds_fi_tcl_u64_tPVoid::~sds_fi_tcl_u64_tPVoid()
{}

tU32 sds_fi_tcl_u64_tPVoid::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& sds_fi_tcl_u64_tPVoid::oRead(fi_tclInContext& oIn)
{
   return oIn >> u64Value;
}

fi_tclOutContext& sds_fi_tcl_u64_tPVoid::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u64Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_VDLCategoryName::sds_fi_tcl_e8_VDLCategoryName():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_VDLCategoryName::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_VDLCATEGORYNAME;
}


sds_fi_tcl_e8_VDLCategoryName::~sds_fi_tcl_e8_VDLCategoryName()
{}

tU32 sds_fi_tcl_e8_VDLCategoryName::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_VDLCategoryName::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_VDLCategoryName::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_SDSLocationType::sds_fi_tcl_e8_SDSLocationType():enType(FI_EN_DEFAULT) {}

tS32 sds_fi_tcl_e8_SDSLocationType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_SDSLOCATIONTYPE;
}


sds_fi_tcl_e8_SDSLocationType::~sds_fi_tcl_e8_SDSLocationType()
{}

tU32 sds_fi_tcl_e8_SDSLocationType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_SDSLocationType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_SDSLocationType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_ListType::sds_fi_tcl_e8_ListType():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_ListType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_LISTTYPE;
}


sds_fi_tcl_e8_ListType::~sds_fi_tcl_e8_ListType()
{}

tU32 sds_fi_tcl_e8_ListType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_ListType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_ListType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_CurrentCountry::sds_fi_tcl_CurrentCountry(const sds_fi_tcl_CurrentCountry& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   CountryCode = coRef.CountryCode;
   CountryName = coRef.CountryName;
   nNDSId = coRef.nNDSId;
}
sds_fi_tcl_CurrentCountry& sds_fi_tcl_CurrentCountry::operator=(const sds_fi_tcl_CurrentCountry& coRef)
{
   if (this == &coRef) return *this;
   CountryCode = coRef.CountryCode;
   CountryName = coRef.CountryName;
   nNDSId = coRef.nNDSId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_CurrentCountry::vDestroy()
{
   CountryName.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < nNDSId.size(); ++u32Idx)
         nNDSId[u32Idx].vDestroy();
   nNDSId.clear();
   }
}

sds_fi_tcl_CurrentCountry::sds_fi_tcl_CurrentCountry()
:CountryCode()
,CountryName()

 {}

tS32 sds_fi_tcl_CurrentCountry::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_CURRENTCOUNTRY;
}


sds_fi_tcl_CurrentCountry::~sds_fi_tcl_CurrentCountry()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_CurrentCountry::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+CountryName.u32GetSize(u16MajorVersion)+nNDSId.size()*24;
}

fi_tclInContext& sds_fi_tcl_CurrentCountry::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CountryCode);
   (tVoid) (oIn >> CountryName);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < nNDSId.size(); ++u32Idx)
      {
         nNDSId[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      nNDSId.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> nNDSId[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_CurrentCountry::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CountryCode);
   (tVoid) (oOut << CountryName);
   (tVoid) (oOut << (tU32)nNDSId.size());
   {
      for (tU32 u32Idx = 0; u32Idx < nNDSId.size(); ++u32Idx)
         (tVoid) (oOut << nNDSId[u32Idx]);
   }
   return oOut;
}

tBool sds_fi_tcl_CurrentCountry::operator==(const sds_fi_tcl_CurrentCountry& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CountryCode == roRef.CountryCode);
   bResult = bResult && (CountryName == roRef.CountryName);
      bResult = bResult && (nNDSId.size() == roRef.nNDSId.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < nNDSId.size()); ++u32Idx)
            bResult = bResult && (nNDSId[u32Idx] == roRef.nNDSId[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_CurrentState::sds_fi_tcl_CurrentState(const sds_fi_tcl_CurrentState& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   StateShort = coRef.StateShort;
   StateName = coRef.StateName;
   nNDSId = coRef.nNDSId;
}
sds_fi_tcl_CurrentState& sds_fi_tcl_CurrentState::operator=(const sds_fi_tcl_CurrentState& coRef)
{
   if (this == &coRef) return *this;
   StateShort = coRef.StateShort;
   StateName = coRef.StateName;
   nNDSId = coRef.nNDSId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_CurrentState::vDestroy()
{
   StateShort.vDestroy();
   StateName.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < nNDSId.size(); ++u32Idx)
         nNDSId[u32Idx].vDestroy();
   nNDSId.clear();
   }
}

sds_fi_tcl_CurrentState::sds_fi_tcl_CurrentState()
:StateShort()
,StateName()

 {}

tS32 sds_fi_tcl_CurrentState::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_CURRENTSTATE;
}


sds_fi_tcl_CurrentState::~sds_fi_tcl_CurrentState()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_CurrentState::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+StateShort.u32GetSize(u16MajorVersion)+StateName.u32GetSize(u16MajorVersion)+nNDSId.size()*24;
}

fi_tclInContext& sds_fi_tcl_CurrentState::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StateShort);
   (tVoid) (oIn >> StateName);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < nNDSId.size(); ++u32Idx)
      {
         nNDSId[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      nNDSId.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> nNDSId[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_CurrentState::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StateShort);
   (tVoid) (oOut << StateName);
   (tVoid) (oOut << (tU32)nNDSId.size());
   {
      for (tU32 u32Idx = 0; u32Idx < nNDSId.size(); ++u32Idx)
         (tVoid) (oOut << nNDSId[u32Idx]);
   }
   return oOut;
}

tBool sds_fi_tcl_CurrentState::operator==(const sds_fi_tcl_CurrentState& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StateShort == roRef.StateShort);
   bResult = bResult && (StateName == roRef.StateName);
      bResult = bResult && (nNDSId.size() == roRef.nNDSId.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < nNDSId.size()); ++u32Idx)
            bResult = bResult && (nNDSId[u32Idx] == roRef.nNDSId[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_CurrentCity::sds_fi_tcl_CurrentCity(const sds_fi_tcl_CurrentCity& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   CityName = coRef.CityName;
   tNDSId = coRef.tNDSId;
}
sds_fi_tcl_CurrentCity& sds_fi_tcl_CurrentCity::operator=(const sds_fi_tcl_CurrentCity& coRef)
{
   if (this == &coRef) return *this;
   CityName = coRef.CityName;
   tNDSId = coRef.tNDSId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_CurrentCity::vDestroy()
{
   CityName.vDestroy();
   tNDSId.vDestroy(); 
}

sds_fi_tcl_CurrentCity::sds_fi_tcl_CurrentCity()
:CityName()
,tNDSId()
 {}

tS32 sds_fi_tcl_CurrentCity::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_CURRENTCITY;
}


sds_fi_tcl_CurrentCity::~sds_fi_tcl_CurrentCity()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_CurrentCity::u32GetSize(tU16 u16MajorVersion) const
{
   return 24+CityName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_CurrentCity::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CityName);
   (tVoid) (oIn >> tNDSId);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_CurrentCity::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CityName);
   (tVoid) (oOut << tNDSId);
   return oOut;
}

tBool sds_fi_tcl_CurrentCity::operator==(const sds_fi_tcl_CurrentCity& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CityName == roRef.CityName);
   bResult = bResult && (tNDSId == roRef.tNDSId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_NameID::sds_fi_tcl_NameID(const sds_fi_tcl_NameID& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   Name = coRef.Name;
   ID = coRef.ID;
   URId = coRef.URId;
   eNDSFeatureType = coRef.eNDSFeatureType;
}
sds_fi_tcl_NameID& sds_fi_tcl_NameID::operator=(const sds_fi_tcl_NameID& coRef)
{
   if (this == &coRef) return *this;
   Name = coRef.Name;
   ID = coRef.ID;
   URId = coRef.URId;
   eNDSFeatureType = coRef.eNDSFeatureType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_NameID::vDestroy()
{
   Name.vDestroy();
}

sds_fi_tcl_NameID::sds_fi_tcl_NameID()
:Name()
,ID(0)
,URId(0)
,eNDSFeatureType()
 {}

tS32 sds_fi_tcl_NameID::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_NAMEID;
}


sds_fi_tcl_NameID::~sds_fi_tcl_NameID()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_NameID::u32GetSize(tU16 u16MajorVersion) const
{
   return 7+Name.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_NameID::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Name);
   (tVoid) (oIn >> ID);
   (tVoid) (oIn >> URId);
   (tVoid) (oIn >> eNDSFeatureType);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_NameID::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Name);
   (tVoid) (oOut << ID);
   (tVoid) (oOut << URId);
   (tVoid) (oOut << eNDSFeatureType);
   return oOut;
}

tBool sds_fi_tcl_NameID::operator==(const sds_fi_tcl_NameID& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Name == roRef.Name);
   bResult = bResult && (ID == roRef.ID);
   bResult = bResult && (URId == roRef.URId);
   bResult = bResult && (eNDSFeatureType == roRef.eNDSFeatureType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_SDSDestinationEntry::sds_fi_tcl_SDSDestinationEntry(const sds_fi_tcl_SDSDestinationEntry& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   e8Type = coRef.e8Type;
   NameID = coRef.NameID;
   u32WordConf = coRef.u32WordConf;
   e8LocationType = coRef.e8LocationType;
}
sds_fi_tcl_SDSDestinationEntry& sds_fi_tcl_SDSDestinationEntry::operator=(const sds_fi_tcl_SDSDestinationEntry& coRef)
{
   if (this == &coRef) return *this;
   e8Type = coRef.e8Type;
   NameID = coRef.NameID;
   u32WordConf = coRef.u32WordConf;
   e8LocationType = coRef.e8LocationType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_SDSDestinationEntry::vDestroy()
{
   NameID.vDestroy(); 
}

sds_fi_tcl_SDSDestinationEntry::sds_fi_tcl_SDSDestinationEntry()
:e8Type()
,NameID()
,u32WordConf(0)
,e8LocationType()
 {}

tS32 sds_fi_tcl_SDSDestinationEntry::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_SDSDESTINATIONENTRY;
}


sds_fi_tcl_SDSDestinationEntry::~sds_fi_tcl_SDSDestinationEntry()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_SDSDestinationEntry::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+NameID.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_SDSDestinationEntry::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Type);
   (tVoid) (oIn >> NameID);
   (tVoid) (oIn >> u32WordConf);
   (tVoid) (oIn >> e8LocationType);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_SDSDestinationEntry::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Type);
   (tVoid) (oOut << NameID);
   (tVoid) (oOut << u32WordConf);
   (tVoid) (oOut << e8LocationType);
   return oOut;
}

tBool sds_fi_tcl_SDSDestinationEntry::operator==(const sds_fi_tcl_SDSDestinationEntry& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Type == roRef.e8Type);
   bResult = bResult && (NameID == roRef.NameID);
   bResult = bResult && (u32WordConf == roRef.u32WordConf);
   bResult = bResult && (e8LocationType == roRef.e8LocationType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_SDSIDTranscriptionsEntry::sds_fi_tcl_SDSIDTranscriptionsEntry(const sds_fi_tcl_SDSIDTranscriptionsEntry& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   u32WordUserID = coRef.u32WordUserID;
   ArrTranscriptions = coRef.ArrTranscriptions;
}
sds_fi_tcl_SDSIDTranscriptionsEntry& sds_fi_tcl_SDSIDTranscriptionsEntry::operator=(const sds_fi_tcl_SDSIDTranscriptionsEntry& coRef)
{
   if (this == &coRef) return *this;
   u32WordUserID = coRef.u32WordUserID;
   ArrTranscriptions = coRef.ArrTranscriptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_SDSIDTranscriptionsEntry::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ArrTranscriptions.size(); ++u32Idx)
         ArrTranscriptions[u32Idx].vDestroy();
   ArrTranscriptions.clear();
   }
}

sds_fi_tcl_SDSIDTranscriptionsEntry::sds_fi_tcl_SDSIDTranscriptionsEntry()
:u32WordUserID(0)

 {}

tS32 sds_fi_tcl_SDSIDTranscriptionsEntry::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_SDSIDTRANSCRIPTIONSENTRY;
}


sds_fi_tcl_SDSIDTranscriptionsEntry::~sds_fi_tcl_SDSIDTranscriptionsEntry()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_SDSIDTranscriptionsEntry::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ArrTranscriptions.size(); ++u32ListIdx)
      u32DynamicSize += ArrTranscriptions[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

fi_tclInContext& sds_fi_tcl_SDSIDTranscriptionsEntry::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32WordUserID);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ArrTranscriptions.size(); ++u32Idx)
      {
         ArrTranscriptions[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ArrTranscriptions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ArrTranscriptions[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_SDSIDTranscriptionsEntry::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32WordUserID);
   (tVoid) (oOut << (tU32)ArrTranscriptions.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ArrTranscriptions.size(); ++u32Idx)
         (tVoid) (oOut << ArrTranscriptions[u32Idx]);
   }
   return oOut;
}

tBool sds_fi_tcl_SDSIDTranscriptionsEntry::operator==(const sds_fi_tcl_SDSIDTranscriptionsEntry& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32WordUserID == roRef.u32WordUserID);
      bResult = bResult && (ArrTranscriptions.size() == roRef.ArrTranscriptions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ArrTranscriptions.size()); ++u32Idx)
            bResult = bResult && (ArrTranscriptions[u32Idx] == roRef.ArrTranscriptions[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_AudioSourceID::sds_fi_tcl_e8_AudioSourceID():enType(FI_EN_DEBUG_RETRIGGER) {}

tS32 sds_fi_tcl_e8_AudioSourceID::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_AUDIOSOURCEID;
}


sds_fi_tcl_e8_AudioSourceID::~sds_fi_tcl_e8_AudioSourceID()
{}

tU32 sds_fi_tcl_e8_AudioSourceID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_AudioSourceID::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_AudioSourceID::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8SequenceCategory::sds_fi_tcl_e8SequenceCategory():enType(FI_EN_IMMEDIATE) {}

tS32 sds_fi_tcl_e8SequenceCategory::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8SEQUENCECATEGORY;
}


sds_fi_tcl_e8SequenceCategory::~sds_fi_tcl_e8SequenceCategory()
{}

tU32 sds_fi_tcl_e8SequenceCategory::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8SequenceCategory::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8SequenceCategory::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_TextStyleOption::sds_fi_tcl_e8_TextStyleOption():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_TextStyleOption::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_TEXTSTYLEOPTION;
}


sds_fi_tcl_e8_TextStyleOption::~sds_fi_tcl_e8_TextStyleOption()
{}

tU32 sds_fi_tcl_e8_TextStyleOption::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_TextStyleOption::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_TextStyleOption::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_StatusInfoOption::sds_fi_tcl_e8_StatusInfoOption():enType(FI_EN_NOINFO) {}

tS32 sds_fi_tcl_e8_StatusInfoOption::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_STATUSINFOOPTION;
}


sds_fi_tcl_e8_StatusInfoOption::~sds_fi_tcl_e8_StatusInfoOption()
{}

tU32 sds_fi_tcl_e8_StatusInfoOption::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_StatusInfoOption::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_StatusInfoOption::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_BufferingOption::sds_fi_tcl_e8_BufferingOption():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_BufferingOption::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_BUFFERINGOPTION;
}


sds_fi_tcl_e8_BufferingOption::~sds_fi_tcl_e8_BufferingOption()
{}

tU32 sds_fi_tcl_e8_BufferingOption::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_BufferingOption::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_BufferingOption::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_PromptAbortOption::sds_fi_tcl_e8_PromptAbortOption():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_PromptAbortOption::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_PROMPTABORTOPTION;
}


sds_fi_tcl_e8_PromptAbortOption::~sds_fi_tcl_e8_PromptAbortOption()
{}

tU32 sds_fi_tcl_e8_PromptAbortOption::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_PromptAbortOption::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_PromptAbortOption::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_TTSStatus::sds_fi_tcl_e8_TTSStatus():enType(FI_EN_INITIALIZATION) {}

tS32 sds_fi_tcl_e8_TTSStatus::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_TTSSTATUS;
}


sds_fi_tcl_e8_TTSStatus::~sds_fi_tcl_e8_TTSStatus()
{}

tU32 sds_fi_tcl_e8_TTSStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_TTSStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_TTSStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_JobStatus::sds_fi_tcl_e8_JobStatus():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_JobStatus::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_JOBSTATUS;
}


sds_fi_tcl_e8_JobStatus::~sds_fi_tcl_e8_JobStatus()
{}

tU32 sds_fi_tcl_e8_JobStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_JobStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_JobStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_ReleaseTypeTTS::sds_fi_tcl_e8_ReleaseTypeTTS():enType(FI_EN_VOICECHANGE) {}

tS32 sds_fi_tcl_e8_ReleaseTypeTTS::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_RELEASETYPETTS;
}


sds_fi_tcl_e8_ReleaseTypeTTS::~sds_fi_tcl_e8_ReleaseTypeTTS()
{}

tU32 sds_fi_tcl_e8_ReleaseTypeTTS::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_ReleaseTypeTTS::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_ReleaseTypeTTS::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_TTSTunType::sds_fi_tcl_e8_TTSTunType():enType(FI_EN_TUNEDPROMPTSDATABASE) {}

tS32 sds_fi_tcl_e8_TTSTunType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_TTSTUNTYPE;
}


sds_fi_tcl_e8_TTSTunType::~sds_fi_tcl_e8_TTSTunType()
{}

tU32 sds_fi_tcl_e8_TTSTunType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_TTSTunType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_TTSTunType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_TunSrc::sds_fi_tcl_e8_TunSrc():enType(FI_EN_SYSTEM) {}

tS32 sds_fi_tcl_e8_TunSrc::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_TUNSRC;
}


sds_fi_tcl_e8_TunSrc::~sds_fi_tcl_e8_TunSrc()
{}

tU32 sds_fi_tcl_e8_TunSrc::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_TunSrc::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_TunSrc::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_TTSDomain::sds_fi_tcl_e8_TTSDomain():enType(FI_EN_UNUSED) {}

tS32 sds_fi_tcl_e8_TTSDomain::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_TTSDOMAIN;
}


sds_fi_tcl_e8_TTSDomain::~sds_fi_tcl_e8_TTSDomain()
{}

tU32 sds_fi_tcl_e8_TTSDomain::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_TTSDomain::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_TTSDomain::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_Phoneme::sds_fi_tcl_Phoneme(const sds_fi_tcl_Phoneme& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   Word = coRef.Word;
   Phonemes = coRef.Phonemes;
}
sds_fi_tcl_Phoneme& sds_fi_tcl_Phoneme::operator=(const sds_fi_tcl_Phoneme& coRef)
{
   if (this == &coRef) return *this;
   Word = coRef.Word;
   Phonemes = coRef.Phonemes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_Phoneme::vDestroy()
{
   Word.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < Phonemes.size(); ++u32Idx)
         Phonemes[u32Idx].vDestroy();
   Phonemes.clear();
   }
}

sds_fi_tcl_Phoneme::sds_fi_tcl_Phoneme()
:Word()

 {}

tS32 sds_fi_tcl_Phoneme::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_PHONEME;
}


sds_fi_tcl_Phoneme::~sds_fi_tcl_Phoneme()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_Phoneme::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Phonemes.size(); ++u32ListIdx)
      u32DynamicSize += Phonemes[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4+Word.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_Phoneme::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Word);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Phonemes.size(); ++u32Idx)
      {
         Phonemes[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Phonemes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Phonemes[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_Phoneme::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Word);
   (tVoid) (oOut << (tU32)Phonemes.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Phonemes.size(); ++u32Idx)
         (tVoid) (oOut << Phonemes[u32Idx]);
   }
   return oOut;
}

tBool sds_fi_tcl_Phoneme::operator==(const sds_fi_tcl_Phoneme& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Word == roRef.Word);
      bResult = bResult && (Phonemes.size() == roRef.Phonemes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Phonemes.size()); ++u32Idx)
            bResult = bResult && (Phonemes[u32Idx] == roRef.Phonemes[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_SpeakProgress::sds_fi_tcl_SpeakProgress(const sds_fi_tcl_SpeakProgress& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   Marker = coRef.Marker;
   LastMarkerSrcPos = coRef.LastMarkerSrcPos;
   TextUnit = coRef.TextUnit;
   LastTextUnitSrcPos = coRef.LastTextUnitSrcPos;
   LastBookmarkID = coRef.LastBookmarkID;
   JobStatus = coRef.JobStatus;
}
sds_fi_tcl_SpeakProgress& sds_fi_tcl_SpeakProgress::operator=(const sds_fi_tcl_SpeakProgress& coRef)
{
   if (this == &coRef) return *this;
   Marker = coRef.Marker;
   LastMarkerSrcPos = coRef.LastMarkerSrcPos;
   TextUnit = coRef.TextUnit;
   LastTextUnitSrcPos = coRef.LastTextUnitSrcPos;
   LastBookmarkID = coRef.LastBookmarkID;
   JobStatus = coRef.JobStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_SpeakProgress::sds_fi_tcl_SpeakProgress()
:Marker(0)
,LastMarkerSrcPos(0)
,TextUnit(0)
,LastTextUnitSrcPos(0)
,LastBookmarkID(0)
,JobStatus()
 {}

tS32 sds_fi_tcl_SpeakProgress::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_SPEAKPROGRESS;
}


sds_fi_tcl_SpeakProgress::~sds_fi_tcl_SpeakProgress()
{}

tU32 sds_fi_tcl_SpeakProgress::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 17;
}

fi_tclInContext& sds_fi_tcl_SpeakProgress::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Marker);
   (tVoid) (oIn >> LastMarkerSrcPos);
   (tVoid) (oIn >> TextUnit);
   (tVoid) (oIn >> LastTextUnitSrcPos);
   (tVoid) (oIn >> LastBookmarkID);
   (tVoid) (oIn >> JobStatus);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_SpeakProgress::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Marker);
   (tVoid) (oOut << LastMarkerSrcPos);
   (tVoid) (oOut << TextUnit);
   (tVoid) (oOut << LastTextUnitSrcPos);
   (tVoid) (oOut << LastBookmarkID);
   (tVoid) (oOut << JobStatus);
   return oOut;
}

tBool sds_fi_tcl_SpeakProgress::operator==(const sds_fi_tcl_SpeakProgress& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Marker == roRef.Marker);
   bResult = bResult && (LastMarkerSrcPos == roRef.LastMarkerSrcPos);
   bResult = bResult && (TextUnit == roRef.TextUnit);
   bResult = bResult && (LastTextUnitSrcPos == roRef.LastTextUnitSrcPos);
   bResult = bResult && (LastBookmarkID == roRef.LastBookmarkID);
   bResult = bResult && (JobStatus == roRef.JobStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_FileLocation::sds_fi_tcl_FileLocation(const sds_fi_tcl_FileLocation& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   SavedBlock = coRef.SavedBlock;
   PartOfBlock = coRef.PartOfBlock;
   BlockID = coRef.BlockID;
   FileLocation = coRef.FileLocation;
   FileSize = coRef.FileSize;
}
sds_fi_tcl_FileLocation& sds_fi_tcl_FileLocation::operator=(const sds_fi_tcl_FileLocation& coRef)
{
   if (this == &coRef) return *this;
   SavedBlock = coRef.SavedBlock;
   PartOfBlock = coRef.PartOfBlock;
   BlockID = coRef.BlockID;
   FileLocation = coRef.FileLocation;
   FileSize = coRef.FileSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_FileLocation::vDestroy()
{
   FileLocation.vDestroy();
}

sds_fi_tcl_FileLocation::sds_fi_tcl_FileLocation()
:SavedBlock(0)
,PartOfBlock(0)
,BlockID(0)
,FileLocation()
,FileSize(0)
 {}

tS32 sds_fi_tcl_FileLocation::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_FILELOCATION;
}


sds_fi_tcl_FileLocation::~sds_fi_tcl_FileLocation()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_FileLocation::u32GetSize(tU16 u16MajorVersion) const
{
   return 10+FileLocation.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_FileLocation::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SavedBlock);
   (tVoid) (oIn >> PartOfBlock);
   (tVoid) (oIn >> BlockID);
   (tVoid) (oIn >> FileLocation);
   (tVoid) (oIn >> FileSize);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_FileLocation::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SavedBlock);
   (tVoid) (oOut << PartOfBlock);
   (tVoid) (oOut << BlockID);
   (tVoid) (oOut << FileLocation);
   (tVoid) (oOut << FileSize);
   return oOut;
}

tBool sds_fi_tcl_FileLocation::operator==(const sds_fi_tcl_FileLocation& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SavedBlock == roRef.SavedBlock);
   bResult = bResult && (PartOfBlock == roRef.PartOfBlock);
   bResult = bResult && (BlockID == roRef.BlockID);
   bResult = bResult && (FileLocation == roRef.FileLocation);
   bResult = bResult && (FileSize == roRef.FileSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_BufferingProgress::sds_fi_tcl_BufferingProgress(const sds_fi_tcl_BufferingProgress& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   FileLocation = coRef.FileLocation;
   JobStatus = coRef.JobStatus;
}
sds_fi_tcl_BufferingProgress& sds_fi_tcl_BufferingProgress::operator=(const sds_fi_tcl_BufferingProgress& coRef)
{
   if (this == &coRef) return *this;
   FileLocation = coRef.FileLocation;
   JobStatus = coRef.JobStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_BufferingProgress::vDestroy()
{
   FileLocation.vDestroy(); 
}

sds_fi_tcl_BufferingProgress::sds_fi_tcl_BufferingProgress()
:FileLocation()
,JobStatus()
 {}

tS32 sds_fi_tcl_BufferingProgress::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_BUFFERINGPROGRESS;
}


sds_fi_tcl_BufferingProgress::~sds_fi_tcl_BufferingProgress()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_BufferingProgress::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+FileLocation.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_BufferingProgress::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FileLocation);
   (tVoid) (oIn >> JobStatus);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_BufferingProgress::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FileLocation);
   (tVoid) (oOut << JobStatus);
   return oOut;
}

tBool sds_fi_tcl_BufferingProgress::operator==(const sds_fi_tcl_BufferingProgress& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FileLocation == roRef.FileLocation);
   bResult = bResult && (JobStatus == roRef.JobStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_VoiceGender::sds_fi_tcl_e8_VoiceGender():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_VoiceGender::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_VOICEGENDER;
}


sds_fi_tcl_e8_VoiceGender::~sds_fi_tcl_e8_VoiceGender()
{}

tU32 sds_fi_tcl_e8_VoiceGender::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_VoiceGender::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_VoiceGender::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_TTSVersionInfo::sds_fi_tcl_TTSVersionInfo(const sds_fi_tcl_TTSVersionInfo& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   TTSEngineManufacturer = coRef.TTSEngineManufacturer;
   TTSEngineProductionDate = coRef.TTSEngineProductionDate;
   TTSEngineProductVersion = coRef.TTSEngineProductVersion;
   TTSModuleProductionDate = coRef.TTSModuleProductionDate;
   TTSModuleVersion = coRef.TTSModuleVersion;
}
sds_fi_tcl_TTSVersionInfo& sds_fi_tcl_TTSVersionInfo::operator=(const sds_fi_tcl_TTSVersionInfo& coRef)
{
   if (this == &coRef) return *this;
   TTSEngineManufacturer = coRef.TTSEngineManufacturer;
   TTSEngineProductionDate = coRef.TTSEngineProductionDate;
   TTSEngineProductVersion = coRef.TTSEngineProductVersion;
   TTSModuleProductionDate = coRef.TTSModuleProductionDate;
   TTSModuleVersion = coRef.TTSModuleVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_TTSVersionInfo::vDestroy()
{
   TTSEngineManufacturer.vDestroy();
   TTSEngineProductionDate.vDestroy();
   TTSEngineProductVersion.vDestroy();
   TTSModuleProductionDate.vDestroy();
   TTSModuleVersion.vDestroy();
}

sds_fi_tcl_TTSVersionInfo::sds_fi_tcl_TTSVersionInfo()
:TTSEngineManufacturer()
,TTSEngineProductionDate()
,TTSEngineProductVersion()
,TTSModuleProductionDate()
,TTSModuleVersion()
 {}

tS32 sds_fi_tcl_TTSVersionInfo::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_TTSVERSIONINFO;
}


sds_fi_tcl_TTSVersionInfo::~sds_fi_tcl_TTSVersionInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_TTSVersionInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TTSEngineManufacturer.u32GetSize(u16MajorVersion)+TTSEngineProductionDate.u32GetSize(u16MajorVersion)+TTSEngineProductVersion.u32GetSize(u16MajorVersion)+TTSModuleProductionDate.u32GetSize(u16MajorVersion)+TTSModuleVersion.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_TTSVersionInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TTSEngineManufacturer);
   (tVoid) (oIn >> TTSEngineProductionDate);
   (tVoid) (oIn >> TTSEngineProductVersion);
   (tVoid) (oIn >> TTSModuleProductionDate);
   (tVoid) (oIn >> TTSModuleVersion);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_TTSVersionInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TTSEngineManufacturer);
   (tVoid) (oOut << TTSEngineProductionDate);
   (tVoid) (oOut << TTSEngineProductVersion);
   (tVoid) (oOut << TTSModuleProductionDate);
   (tVoid) (oOut << TTSModuleVersion);
   return oOut;
}

tBool sds_fi_tcl_TTSVersionInfo::operator==(const sds_fi_tcl_TTSVersionInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TTSEngineManufacturer == roRef.TTSEngineManufacturer);
   bResult = bResult && (TTSEngineProductionDate == roRef.TTSEngineProductionDate);
   bResult = bResult && (TTSEngineProductVersion == roRef.TTSEngineProductVersion);
   bResult = bResult && (TTSModuleProductionDate == roRef.TTSModuleProductionDate);
   bResult = bResult && (TTSModuleVersion == roRef.TTSModuleVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_TTSPhonemeResult::sds_fi_tcl_TTSPhonemeResult(const sds_fi_tcl_TTSPhonemeResult& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   ID = coRef.ID;
   Phoneme = coRef.Phoneme;
   CommError = coRef.CommError;
   PhonemeAvailability = coRef.PhonemeAvailability;
}
sds_fi_tcl_TTSPhonemeResult& sds_fi_tcl_TTSPhonemeResult::operator=(const sds_fi_tcl_TTSPhonemeResult& coRef)
{
   if (this == &coRef) return *this;
   ID = coRef.ID;
   Phoneme = coRef.Phoneme;
   CommError = coRef.CommError;
   PhonemeAvailability = coRef.PhonemeAvailability;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_TTSPhonemeResult::vDestroy()
{
   Phoneme.vDestroy();
}

sds_fi_tcl_TTSPhonemeResult::sds_fi_tcl_TTSPhonemeResult()
:ID(0)
,Phoneme()
,CommError(0)
,PhonemeAvailability(0)
 {}

tS32 sds_fi_tcl_TTSPhonemeResult::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_TTSPHONEMERESULT;
}


sds_fi_tcl_TTSPhonemeResult::~sds_fi_tcl_TTSPhonemeResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_TTSPhonemeResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+Phoneme.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_TTSPhonemeResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ID);
   (tVoid) (oIn >> Phoneme);
   (tVoid) (oIn >> CommError);
   (tVoid) (oIn >> PhonemeAvailability);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_TTSPhonemeResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ID);
   (tVoid) (oOut << Phoneme);
   (tVoid) (oOut << CommError);
   (tVoid) (oOut << PhonemeAvailability);
   return oOut;
}

tBool sds_fi_tcl_TTSPhonemeResult::operator==(const sds_fi_tcl_TTSPhonemeResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ID == roRef.ID);
   bResult = bResult && (Phoneme == roRef.Phoneme);
   bResult = bResult && (CommError == roRef.CommError);
   bResult = bResult && (PhonemeAvailability == roRef.PhonemeAvailability);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_TTSTuningFile::sds_fi_tcl_TTSTuningFile(const sds_fi_tcl_TTSTuningFile& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   Type = coRef.Type;
   SrcType = coRef.SrcType;
   Filename = coRef.Filename;
}
sds_fi_tcl_TTSTuningFile& sds_fi_tcl_TTSTuningFile::operator=(const sds_fi_tcl_TTSTuningFile& coRef)
{
   if (this == &coRef) return *this;
   Type = coRef.Type;
   SrcType = coRef.SrcType;
   Filename = coRef.Filename;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_TTSTuningFile::vDestroy()
{
   Filename.vDestroy();
}

sds_fi_tcl_TTSTuningFile::sds_fi_tcl_TTSTuningFile()
:Type()
,SrcType()
,Filename()
 {}

tS32 sds_fi_tcl_TTSTuningFile::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_TTSTUNINGFILE;
}


sds_fi_tcl_TTSTuningFile::~sds_fi_tcl_TTSTuningFile()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_TTSTuningFile::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+Filename.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_TTSTuningFile::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Type);
   (tVoid) (oIn >> SrcType);
   (tVoid) (oIn >> Filename);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_TTSTuningFile::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Type);
   (tVoid) (oOut << SrcType);
   (tVoid) (oOut << Filename);
   return oOut;
}

tBool sds_fi_tcl_TTSTuningFile::operator==(const sds_fi_tcl_TTSTuningFile& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Type == roRef.Type);
   bResult = bResult && (SrcType == roRef.SrcType);
   bResult = bResult && (Filename == roRef.Filename);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_TTSVoiceInfo::sds_fi_tcl_TTSVoiceInfo(const sds_fi_tcl_TTSVoiceInfo& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   LanguageID = coRef.LanguageID;
   VoiceName = coRef.VoiceName;
   VoiceGender = coRef.VoiceGender;
   Version = coRef.Version;
}
sds_fi_tcl_TTSVoiceInfo& sds_fi_tcl_TTSVoiceInfo::operator=(const sds_fi_tcl_TTSVoiceInfo& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   VoiceName = coRef.VoiceName;
   VoiceGender = coRef.VoiceGender;
   Version = coRef.Version;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_TTSVoiceInfo::vDestroy()
{
   LanguageID.vDestroy(); 
   VoiceName.vDestroy();
   Version.vDestroy();
}

sds_fi_tcl_TTSVoiceInfo::sds_fi_tcl_TTSVoiceInfo()
:LanguageID()
,VoiceName()
,VoiceGender()
,Version()
 {}

tS32 sds_fi_tcl_TTSVoiceInfo::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_TTSVOICEINFO;
}


sds_fi_tcl_TTSVoiceInfo::~sds_fi_tcl_TTSVoiceInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_TTSVoiceInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+VoiceName.u32GetSize(u16MajorVersion)+Version.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_TTSVoiceInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> VoiceName);
   (tVoid) (oIn >> VoiceGender);
   (tVoid) (oIn >> Version);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_TTSVoiceInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << VoiceName);
   (tVoid) (oOut << VoiceGender);
   (tVoid) (oOut << Version);
   return oOut;
}

tBool sds_fi_tcl_TTSVoiceInfo::operator==(const sds_fi_tcl_TTSVoiceInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (VoiceName == roRef.VoiceName);
   bResult = bResult && (VoiceGender == roRef.VoiceGender);
   bResult = bResult && (Version == roRef.Version);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_PathType::sds_fi_tcl_e8_PathType():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_PathType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_PATHTYPE;
}


sds_fi_tcl_e8_PathType::~sds_fi_tcl_e8_PathType()
{}

tU32 sds_fi_tcl_e8_PathType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_PathType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_PathType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_VoiceType::sds_fi_tcl_VoiceType(const sds_fi_tcl_VoiceType& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   LanguageID = coRef.LanguageID;
   VoiceName = coRef.VoiceName;
   VoiceGender = coRef.VoiceGender;
}
sds_fi_tcl_VoiceType& sds_fi_tcl_VoiceType::operator=(const sds_fi_tcl_VoiceType& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   VoiceName = coRef.VoiceName;
   VoiceGender = coRef.VoiceGender;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_VoiceType::vDestroy()
{
   LanguageID.vDestroy(); 
   VoiceName.vDestroy();
}

sds_fi_tcl_VoiceType::sds_fi_tcl_VoiceType()
:LanguageID()
,VoiceName()
,VoiceGender()
 {}

tS32 sds_fi_tcl_VoiceType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_VOICETYPE;
}


sds_fi_tcl_VoiceType::~sds_fi_tcl_VoiceType()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_VoiceType::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+VoiceName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_VoiceType::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> VoiceName);
   (tVoid) (oIn >> VoiceGender);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_VoiceType::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << VoiceName);
   (tVoid) (oOut << VoiceGender);
   return oOut;
}

tBool sds_fi_tcl_VoiceType::operator==(const sds_fi_tcl_VoiceType& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (VoiceName == roRef.VoiceName);
   bResult = bResult && (VoiceGender == roRef.VoiceGender);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_DataCarrier::sds_fi_tcl_e8_DataCarrier():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_DataCarrier::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_DATACARRIER;
}


sds_fi_tcl_e8_DataCarrier::~sds_fi_tcl_e8_DataCarrier()
{}

tU32 sds_fi_tcl_e8_DataCarrier::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_DataCarrier::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_DataCarrier::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_UserWordUsage::sds_fi_tcl_e8_UserWordUsage():enType(FI_EN_DELETE) {}

tS32 sds_fi_tcl_e8_UserWordUsage::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_USERWORDUSAGE;
}


sds_fi_tcl_e8_UserWordUsage::~sds_fi_tcl_e8_UserWordUsage()
{}

tU32 sds_fi_tcl_e8_UserWordUsage::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_UserWordUsage::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_UserWordUsage::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_CountryType::sds_fi_tcl_e8_CountryType():enType(FI_EN_HOMECOUNTRY) {}

tS32 sds_fi_tcl_e8_CountryType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_COUNTRYTYPE;
}


sds_fi_tcl_e8_CountryType::~sds_fi_tcl_e8_CountryType()
{}

tU32 sds_fi_tcl_e8_CountryType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_CountryType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_CountryType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_StorageDevice::sds_fi_tcl_e8_StorageDevice():enType(FI_EN_PERMANENTSTORAGEDEVICE) {}

tS32 sds_fi_tcl_e8_StorageDevice::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_STORAGEDEVICE;
}


sds_fi_tcl_e8_StorageDevice::~sds_fi_tcl_e8_StorageDevice()
{}

tU32 sds_fi_tcl_e8_StorageDevice::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_StorageDevice::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_StorageDevice::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_FileAvailability::sds_fi_tcl_e8_FileAvailability():enType(FI_EN_AVAILABLESIZEOK) {}

tS32 sds_fi_tcl_e8_FileAvailability::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_FILEAVAILABILITY;
}


sds_fi_tcl_e8_FileAvailability::~sds_fi_tcl_e8_FileAvailability()
{}

tU32 sds_fi_tcl_e8_FileAvailability::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_FileAvailability::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_FileAvailability::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_FileType::sds_fi_tcl_e8_FileType():enType(FI_EN_GRAMMAR) {}

tS32 sds_fi_tcl_e8_FileType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_FILETYPE;
}


sds_fi_tcl_e8_FileType::~sds_fi_tcl_e8_FileType()
{}

tU32 sds_fi_tcl_e8_FileType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_FileType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_FileType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_FileAccessMode::sds_fi_tcl_e8_FileAccessMode():enType(FI_EN_CREATE) {}

tS32 sds_fi_tcl_e8_FileAccessMode::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_FILEACCESSMODE;
}


sds_fi_tcl_e8_FileAccessMode::~sds_fi_tcl_e8_FileAccessMode()
{}

tU32 sds_fi_tcl_e8_FileAccessMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_FileAccessMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_FileAccessMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_FileAccessResult::sds_fi_tcl_e8_FileAccessResult():enType(FI_EN_COMMIT) {}

tS32 sds_fi_tcl_e8_FileAccessResult::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_FILEACCESSRESULT;
}


sds_fi_tcl_e8_FileAccessResult::~sds_fi_tcl_e8_FileAccessResult()
{}

tU32 sds_fi_tcl_e8_FileAccessResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_FileAccessResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_FileAccessResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_ContextType::sds_fi_tcl_e8_ContextType():enType(FI_EN_COMPLETECITIES) {}

tS32 sds_fi_tcl_e8_ContextType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_CONTEXTTYPE;
}


sds_fi_tcl_e8_ContextType::~sds_fi_tcl_e8_ContextType()
{}

tU32 sds_fi_tcl_e8_ContextType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_ContextType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_ContextType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_DestinationCategory::sds_fi_tcl_e8_DestinationCategory():enType(FI_EN_COUNTRY) {}

tS32 sds_fi_tcl_e8_DestinationCategory::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_DESTINATIONCATEGORY;
}


sds_fi_tcl_e8_DestinationCategory::~sds_fi_tcl_e8_DestinationCategory()
{}

tU32 sds_fi_tcl_e8_DestinationCategory::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_DestinationCategory::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_DestinationCategory::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_ReleaseTypeSDP::sds_fi_tcl_e8_ReleaseTypeSDP():enType(FI_EN_USERCHANGE) {}

tS32 sds_fi_tcl_e8_ReleaseTypeSDP::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_RELEASETYPESDP;
}


sds_fi_tcl_e8_ReleaseTypeSDP::~sds_fi_tcl_e8_ReleaseTypeSDP()
{}

tU32 sds_fi_tcl_e8_ReleaseTypeSDP::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_ReleaseTypeSDP::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_ReleaseTypeSDP::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_UwCategories::sds_fi_tcl_e8_UwCategories():enType(FI_EN_ALLCATEGORIES) {}

tS32 sds_fi_tcl_e8_UwCategories::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_UWCATEGORIES;
}


sds_fi_tcl_e8_UwCategories::~sds_fi_tcl_e8_UwCategories()
{}

tU32 sds_fi_tcl_e8_UwCategories::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_UwCategories::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_UwCategories::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_TTSFileType::sds_fi_tcl_e8_TTSFileType():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_TTSFileType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_TTSFILETYPE;
}


sds_fi_tcl_e8_TTSFileType::~sds_fi_tcl_e8_TTSFileType()
{}

tU32 sds_fi_tcl_e8_TTSFileType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_TTSFileType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_TTSFileType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_ContextFileType::sds_fi_tcl_e8_ContextFileType():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_ContextFileType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_CONTEXTFILETYPE;
}


sds_fi_tcl_e8_ContextFileType::~sds_fi_tcl_e8_ContextFileType()
{}

tU32 sds_fi_tcl_e8_ContextFileType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_ContextFileType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_ContextFileType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_SemBufferFileType::sds_fi_tcl_e8_SemBufferFileType():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_SemBufferFileType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_SEMBUFFERFILETYPE;
}


sds_fi_tcl_e8_SemBufferFileType::~sds_fi_tcl_e8_SemBufferFileType()
{}

tU32 sds_fi_tcl_e8_SemBufferFileType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_SemBufferFileType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_SemBufferFileType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_TranscriptionFileType::sds_fi_tcl_e8_TranscriptionFileType():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_TranscriptionFileType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_TRANSCRIPTIONFILETYPE;
}


sds_fi_tcl_e8_TranscriptionFileType::~sds_fi_tcl_e8_TranscriptionFileType()
{}

tU32 sds_fi_tcl_e8_TranscriptionFileType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_TranscriptionFileType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_TranscriptionFileType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_CountrySupportType::sds_fi_tcl_e8_CountrySupportType():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_CountrySupportType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_COUNTRYSUPPORTTYPE;
}


sds_fi_tcl_e8_CountrySupportType::~sds_fi_tcl_e8_CountrySupportType()
{}

tU32 sds_fi_tcl_e8_CountrySupportType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_CountrySupportType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_CountrySupportType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_TTSEngineType::sds_fi_tcl_e8_TTSEngineType():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_TTSEngineType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_TTSENGINETYPE;
}


sds_fi_tcl_e8_TTSEngineType::~sds_fi_tcl_e8_TTSEngineType()
{}

tU32 sds_fi_tcl_e8_TTSEngineType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_TTSEngineType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_TTSEngineType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_AvailableLanguage::sds_fi_tcl_AvailableLanguage(const sds_fi_tcl_AvailableLanguage& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   LanguageID = coRef.LanguageID;
   StorageDevice = coRef.StorageDevice;
}
sds_fi_tcl_AvailableLanguage& sds_fi_tcl_AvailableLanguage::operator=(const sds_fi_tcl_AvailableLanguage& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   StorageDevice = coRef.StorageDevice;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_AvailableLanguage::sds_fi_tcl_AvailableLanguage()
:LanguageID()
,StorageDevice()
 {}

tS32 sds_fi_tcl_AvailableLanguage::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_AVAILABLELANGUAGE;
}


sds_fi_tcl_AvailableLanguage::~sds_fi_tcl_AvailableLanguage()
{}

tU32 sds_fi_tcl_AvailableLanguage::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds_fi_tcl_AvailableLanguage::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> StorageDevice);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_AvailableLanguage::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << StorageDevice);
   return oOut;
}

tBool sds_fi_tcl_AvailableLanguage::operator==(const sds_fi_tcl_AvailableLanguage& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (StorageDevice == roRef.StorageDevice);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_AvailableTTSVoices::sds_fi_tcl_AvailableTTSVoices(const sds_fi_tcl_AvailableTTSVoices& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   TTSVoice = coRef.TTSVoice;
}
sds_fi_tcl_AvailableTTSVoices& sds_fi_tcl_AvailableTTSVoices::operator=(const sds_fi_tcl_AvailableTTSVoices& coRef)
{
   if (this == &coRef) return *this;
   TTSVoice = coRef.TTSVoice;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_AvailableTTSVoices::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TTSVoice.size(); ++u32Idx)
         TTSVoice[u32Idx].vDestroy();
   TTSVoice.clear();
   }
}

sds_fi_tcl_AvailableTTSVoices::sds_fi_tcl_AvailableTTSVoices()

 {}

tS32 sds_fi_tcl_AvailableTTSVoices::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_AVAILABLETTSVOICES;
}


sds_fi_tcl_AvailableTTSVoices::~sds_fi_tcl_AvailableTTSVoices()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_AvailableTTSVoices::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TTSVoice.size(); ++u32ListIdx)
      u32DynamicSize += TTSVoice[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_fi_tcl_AvailableTTSVoices::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TTSVoice.size(); ++u32Idx)
      {
         TTSVoice[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TTSVoice.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TTSVoice[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_AvailableTTSVoices::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TTSVoice.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TTSVoice.size(); ++u32Idx)
         (tVoid) (oOut << TTSVoice[u32Idx]);
   }
   return oOut;
}

tBool sds_fi_tcl_AvailableTTSVoices::operator==(const sds_fi_tcl_AvailableTTSVoices& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TTSVoice.size() == roRef.TTSVoice.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TTSVoice.size()); ++u32Idx)
            bResult = bResult && (TTSVoice[u32Idx] == roRef.TTSVoice[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_VoiceDescription::sds_fi_tcl_VoiceDescription(const sds_fi_tcl_VoiceDescription& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   VoiceType = coRef.VoiceType;
   StorageDevice = coRef.StorageDevice;
}
sds_fi_tcl_VoiceDescription& sds_fi_tcl_VoiceDescription::operator=(const sds_fi_tcl_VoiceDescription& coRef)
{
   if (this == &coRef) return *this;
   VoiceType = coRef.VoiceType;
   StorageDevice = coRef.StorageDevice;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_VoiceDescription::vDestroy()
{
   VoiceType.vDestroy(); 
}

sds_fi_tcl_VoiceDescription::sds_fi_tcl_VoiceDescription()
:VoiceType()
,StorageDevice()
 {}

tS32 sds_fi_tcl_VoiceDescription::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_VOICEDESCRIPTION;
}


sds_fi_tcl_VoiceDescription::~sds_fi_tcl_VoiceDescription()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_VoiceDescription::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+VoiceType.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_VoiceDescription::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VoiceType);
   (tVoid) (oIn >> StorageDevice);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_VoiceDescription::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VoiceType);
   (tVoid) (oOut << StorageDevice);
   return oOut;
}

tBool sds_fi_tcl_VoiceDescription::operator==(const sds_fi_tcl_VoiceDescription& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VoiceType == roRef.VoiceType);
   bResult = bResult && (StorageDevice == roRef.StorageDevice);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_DictionaryGroup::sds_fi_tcl_DictionaryGroup(const sds_fi_tcl_DictionaryGroup& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   DictFileName = coRef.DictFileName;
   NumNames = coRef.NumNames;
   Name = coRef.Name;
}
sds_fi_tcl_DictionaryGroup& sds_fi_tcl_DictionaryGroup::operator=(const sds_fi_tcl_DictionaryGroup& coRef)
{
   if (this == &coRef) return *this;
   DictFileName = coRef.DictFileName;
   NumNames = coRef.NumNames;
   Name = coRef.Name;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_DictionaryGroup::vDestroy()
{
   DictFileName.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < Name.size(); ++u32Idx)
         Name[u32Idx].vDestroy();
   Name.clear();
   }
}

sds_fi_tcl_DictionaryGroup::sds_fi_tcl_DictionaryGroup()
:DictFileName()
,NumNames(0)

 {}

tS32 sds_fi_tcl_DictionaryGroup::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_DICTIONARYGROUP;
}


sds_fi_tcl_DictionaryGroup::~sds_fi_tcl_DictionaryGroup()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_DictionaryGroup::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Name.size(); ++u32ListIdx)
      u32DynamicSize += Name[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+6+DictFileName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_DictionaryGroup::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DictFileName);
   (tVoid) (oIn >> NumNames);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Name.size(); ++u32Idx)
      {
         Name[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Name.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Name[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_DictionaryGroup::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DictFileName);
   (tVoid) (oOut << NumNames);
   (tVoid) (oOut << (tU32)Name.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Name.size(); ++u32Idx)
         (tVoid) (oOut << Name[u32Idx]);
   }
   return oOut;
}

tBool sds_fi_tcl_DictionaryGroup::operator==(const sds_fi_tcl_DictionaryGroup& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DictFileName == roRef.DictFileName);
   bResult = bResult && (NumNames == roRef.NumNames);
      bResult = bResult && (Name.size() == roRef.Name.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Name.size()); ++u32Idx)
            bResult = bResult && (Name[u32Idx] == roRef.Name[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_AvailableCountry::sds_fi_tcl_AvailableCountry(const sds_fi_tcl_AvailableCountry& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   LanguageID = coRef.LanguageID;
   CountryCode = coRef.CountryCode;
   State = coRef.State;
   MajorVersion_SBS_NAV = coRef.MajorVersion_SBS_NAV;
   MinorVersion_SBS_NAV = coRef.MinorVersion_SBS_NAV;
   BoschCreateDate = coRef.BoschCreateDate;
}
sds_fi_tcl_AvailableCountry& sds_fi_tcl_AvailableCountry::operator=(const sds_fi_tcl_AvailableCountry& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   CountryCode = coRef.CountryCode;
   State = coRef.State;
   MajorVersion_SBS_NAV = coRef.MajorVersion_SBS_NAV;
   MinorVersion_SBS_NAV = coRef.MinorVersion_SBS_NAV;
   BoschCreateDate = coRef.BoschCreateDate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_AvailableCountry::vDestroy()
{
   LanguageID.vDestroy(); 
   State.vDestroy();
   BoschCreateDate.vDestroy();
}

sds_fi_tcl_AvailableCountry::sds_fi_tcl_AvailableCountry()
:LanguageID()
,CountryCode()
,State()
,MajorVersion_SBS_NAV(0)
,MinorVersion_SBS_NAV(0)
,BoschCreateDate()
 {}

tS32 sds_fi_tcl_AvailableCountry::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_AVAILABLECOUNTRY;
}


sds_fi_tcl_AvailableCountry::~sds_fi_tcl_AvailableCountry()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_AvailableCountry::u32GetSize(tU16 u16MajorVersion) const
{
   return 10+State.u32GetSize(u16MajorVersion)+BoschCreateDate.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_AvailableCountry::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> CountryCode);
   (tVoid) (oIn >> State);
   (tVoid) (oIn >> MajorVersion_SBS_NAV);
   (tVoid) (oIn >> MinorVersion_SBS_NAV);
   (tVoid) (oIn >> BoschCreateDate);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_AvailableCountry::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << CountryCode);
   (tVoid) (oOut << State);
   (tVoid) (oOut << MajorVersion_SBS_NAV);
   (tVoid) (oOut << MinorVersion_SBS_NAV);
   (tVoid) (oOut << BoschCreateDate);
   return oOut;
}

tBool sds_fi_tcl_AvailableCountry::operator==(const sds_fi_tcl_AvailableCountry& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (CountryCode == roRef.CountryCode);
   bResult = bResult && (State == roRef.State);
   bResult = bResult && (MajorVersion_SBS_NAV == roRef.MajorVersion_SBS_NAV);
   bResult = bResult && (MinorVersion_SBS_NAV == roRef.MinorVersion_SBS_NAV);
   bResult = bResult && (BoschCreateDate == roRef.BoschCreateDate);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_TTSTunningFile::sds_fi_tcl_TTSTunningFile(const sds_fi_tcl_TTSTunningFile& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   Type = coRef.Type;
   Filename = coRef.Filename;
}
sds_fi_tcl_TTSTunningFile& sds_fi_tcl_TTSTunningFile::operator=(const sds_fi_tcl_TTSTunningFile& coRef)
{
   if (this == &coRef) return *this;
   Type = coRef.Type;
   Filename = coRef.Filename;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_TTSTunningFile::vDestroy()
{
   Filename.vDestroy();
}

sds_fi_tcl_TTSTunningFile::sds_fi_tcl_TTSTunningFile()
:Type()
,Filename()
 {}

tS32 sds_fi_tcl_TTSTunningFile::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_TTSTUNNINGFILE;
}


sds_fi_tcl_TTSTunningFile::~sds_fi_tcl_TTSTunningFile()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_TTSTunningFile::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+Filename.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_TTSTunningFile::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Type);
   (tVoid) (oIn >> Filename);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_TTSTunningFile::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Type);
   (tVoid) (oOut << Filename);
   return oOut;
}

tBool sds_fi_tcl_TTSTunningFile::operator==(const sds_fi_tcl_TTSTunningFile& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Type == roRef.Type);
   bResult = bResult && (Filename == roRef.Filename);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_TTSVoiceFile::sds_fi_tcl_TTSVoiceFile(const sds_fi_tcl_TTSVoiceFile& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   Filename = coRef.Filename;
   LogicalName = coRef.LogicalName;
}
sds_fi_tcl_TTSVoiceFile& sds_fi_tcl_TTSVoiceFile::operator=(const sds_fi_tcl_TTSVoiceFile& coRef)
{
   if (this == &coRef) return *this;
   Filename = coRef.Filename;
   LogicalName = coRef.LogicalName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_TTSVoiceFile::vDestroy()
{
   Filename.vDestroy();
   LogicalName.vDestroy();
}

sds_fi_tcl_TTSVoiceFile::sds_fi_tcl_TTSVoiceFile()
:Filename()
,LogicalName()
 {}

tS32 sds_fi_tcl_TTSVoiceFile::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_TTSVOICEFILE;
}


sds_fi_tcl_TTSVoiceFile::~sds_fi_tcl_TTSVoiceFile()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_TTSVoiceFile::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Filename.u32GetSize(u16MajorVersion)+LogicalName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_TTSVoiceFile::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Filename);
   (tVoid) (oIn >> LogicalName);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_TTSVoiceFile::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Filename);
   (tVoid) (oOut << LogicalName);
   return oOut;
}

tBool sds_fi_tcl_TTSVoiceFile::operator==(const sds_fi_tcl_TTSVoiceFile& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Filename == roRef.Filename);
   bResult = bResult && (LogicalName == roRef.LogicalName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_ContextFile::sds_fi_tcl_ContextFile(const sds_fi_tcl_ContextFile& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   Type = coRef.Type;
   Filename = coRef.Filename;
}
sds_fi_tcl_ContextFile& sds_fi_tcl_ContextFile::operator=(const sds_fi_tcl_ContextFile& coRef)
{
   if (this == &coRef) return *this;
   Type = coRef.Type;
   Filename = coRef.Filename;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_ContextFile::vDestroy()
{
   Filename.vDestroy();
}

sds_fi_tcl_ContextFile::sds_fi_tcl_ContextFile()
:Type()
,Filename()
 {}

tS32 sds_fi_tcl_ContextFile::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_CONTEXTFILE;
}


sds_fi_tcl_ContextFile::~sds_fi_tcl_ContextFile()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_ContextFile::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+Filename.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_ContextFile::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Type);
   (tVoid) (oIn >> Filename);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_ContextFile::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Type);
   (tVoid) (oOut << Filename);
   return oOut;
}

tBool sds_fi_tcl_ContextFile::operator==(const sds_fi_tcl_ContextFile& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Type == roRef.Type);
   bResult = bResult && (Filename == roRef.Filename);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_SemBufferFile::sds_fi_tcl_SemBufferFile(const sds_fi_tcl_SemBufferFile& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   Type = coRef.Type;
   Filename = coRef.Filename;
}
sds_fi_tcl_SemBufferFile& sds_fi_tcl_SemBufferFile::operator=(const sds_fi_tcl_SemBufferFile& coRef)
{
   if (this == &coRef) return *this;
   Type = coRef.Type;
   Filename = coRef.Filename;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_SemBufferFile::vDestroy()
{
   Filename.vDestroy();
}

sds_fi_tcl_SemBufferFile::sds_fi_tcl_SemBufferFile()
:Type()
,Filename()
 {}

tS32 sds_fi_tcl_SemBufferFile::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_SEMBUFFERFILE;
}


sds_fi_tcl_SemBufferFile::~sds_fi_tcl_SemBufferFile()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_SemBufferFile::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+Filename.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_SemBufferFile::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Type);
   (tVoid) (oIn >> Filename);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_SemBufferFile::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Type);
   (tVoid) (oOut << Filename);
   return oOut;
}

tBool sds_fi_tcl_SemBufferFile::operator==(const sds_fi_tcl_SemBufferFile& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Type == roRef.Type);
   bResult = bResult && (Filename == roRef.Filename);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_ConnectDevice::sds_fi_tcl_ConnectDevice(const sds_fi_tcl_ConnectDevice& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   DeviceID = coRef.DeviceID;
   Timestamp = coRef.Timestamp;
   GnDbTimestamp = coRef.GnDbTimestamp;
}
sds_fi_tcl_ConnectDevice& sds_fi_tcl_ConnectDevice::operator=(const sds_fi_tcl_ConnectDevice& coRef)
{
   if (this == &coRef) return *this;
   DeviceID = coRef.DeviceID;
   Timestamp = coRef.Timestamp;
   GnDbTimestamp = coRef.GnDbTimestamp;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_ConnectDevice::sds_fi_tcl_ConnectDevice()
:DeviceID(0)
,Timestamp(0)
,GnDbTimestamp(0)
 {}

tS32 sds_fi_tcl_ConnectDevice::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_CONNECTDEVICE;
}


sds_fi_tcl_ConnectDevice::~sds_fi_tcl_ConnectDevice()
{}

tU32 sds_fi_tcl_ConnectDevice::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& sds_fi_tcl_ConnectDevice::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceID);
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> GnDbTimestamp);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_ConnectDevice::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceID);
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << GnDbTimestamp);
   return oOut;
}

tBool sds_fi_tcl_ConnectDevice::operator==(const sds_fi_tcl_ConnectDevice& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceID == roRef.DeviceID);
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (GnDbTimestamp == roRef.GnDbTimestamp);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_DynamicContextFile::sds_fi_tcl_DynamicContextFile(const sds_fi_tcl_DynamicContextFile& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   LogicalName = coRef.LogicalName;
   Filename = coRef.Filename;
}
sds_fi_tcl_DynamicContextFile& sds_fi_tcl_DynamicContextFile::operator=(const sds_fi_tcl_DynamicContextFile& coRef)
{
   if (this == &coRef) return *this;
   LogicalName = coRef.LogicalName;
   Filename = coRef.Filename;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_DynamicContextFile::vDestroy()
{
   LogicalName.vDestroy();
   Filename.vDestroy();
}

sds_fi_tcl_DynamicContextFile::sds_fi_tcl_DynamicContextFile()
:LogicalName()
,Filename()
 {}

tS32 sds_fi_tcl_DynamicContextFile::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_DYNAMICCONTEXTFILE;
}


sds_fi_tcl_DynamicContextFile::~sds_fi_tcl_DynamicContextFile()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_DynamicContextFile::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+LogicalName.u32GetSize(u16MajorVersion)+Filename.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_DynamicContextFile::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LogicalName);
   (tVoid) (oIn >> Filename);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_DynamicContextFile::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LogicalName);
   (tVoid) (oOut << Filename);
   return oOut;
}

tBool sds_fi_tcl_DynamicContextFile::operator==(const sds_fi_tcl_DynamicContextFile& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LogicalName == roRef.LogicalName);
   bResult = bResult && (Filename == roRef.Filename);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_TranscriptionFile::sds_fi_tcl_TranscriptionFile(const sds_fi_tcl_TranscriptionFile& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   Type = coRef.Type;
   Filename = coRef.Filename;
}
sds_fi_tcl_TranscriptionFile& sds_fi_tcl_TranscriptionFile::operator=(const sds_fi_tcl_TranscriptionFile& coRef)
{
   if (this == &coRef) return *this;
   Type = coRef.Type;
   Filename = coRef.Filename;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_TranscriptionFile::vDestroy()
{
   Filename.vDestroy();
}

sds_fi_tcl_TranscriptionFile::sds_fi_tcl_TranscriptionFile()
:Type()
,Filename()
 {}

tS32 sds_fi_tcl_TranscriptionFile::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_TRANSCRIPTIONFILE;
}


sds_fi_tcl_TranscriptionFile::~sds_fi_tcl_TranscriptionFile()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_TranscriptionFile::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+Filename.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_TranscriptionFile::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Type);
   (tVoid) (oIn >> Filename);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_TranscriptionFile::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Type);
   (tVoid) (oOut << Filename);
   return oOut;
}

tBool sds_fi_tcl_TranscriptionFile::operator==(const sds_fi_tcl_TranscriptionFile& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Type == roRef.Type);
   bResult = bResult && (Filename == roRef.Filename);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_UserAudioFile::sds_fi_tcl_UserAudioFile(const sds_fi_tcl_UserAudioFile& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   UserwordID = coRef.UserwordID;
   Filename = coRef.Filename;
}
sds_fi_tcl_UserAudioFile& sds_fi_tcl_UserAudioFile::operator=(const sds_fi_tcl_UserAudioFile& coRef)
{
   if (this == &coRef) return *this;
   UserwordID = coRef.UserwordID;
   Filename = coRef.Filename;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_UserAudioFile::vDestroy()
{
   Filename.vDestroy();
}

sds_fi_tcl_UserAudioFile::sds_fi_tcl_UserAudioFile()
:UserwordID(0)
,Filename()
 {}

tS32 sds_fi_tcl_UserAudioFile::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_USERAUDIOFILE;
}


sds_fi_tcl_UserAudioFile::~sds_fi_tcl_UserAudioFile()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_UserAudioFile::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+Filename.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_UserAudioFile::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> UserwordID);
   (tVoid) (oIn >> Filename);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_UserAudioFile::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << UserwordID);
   (tVoid) (oOut << Filename);
   return oOut;
}

tBool sds_fi_tcl_UserAudioFile::operator==(const sds_fi_tcl_UserAudioFile& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UserwordID == roRef.UserwordID);
   bResult = bResult && (Filename == roRef.Filename);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_SpeechSupportInfoType::sds_fi_tcl_e8_SpeechSupportInfoType():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_SpeechSupportInfoType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_SPEECHSUPPORTINFOTYPE;
}


sds_fi_tcl_e8_SpeechSupportInfoType::~sds_fi_tcl_e8_SpeechSupportInfoType()
{}

tU32 sds_fi_tcl_e8_SpeechSupportInfoType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_SpeechSupportInfoType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_SpeechSupportInfoType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_SpeakerInfoType::sds_fi_tcl_SpeakerInfoType(const sds_fi_tcl_SpeakerInfoType& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   LanguageID = coRef.LanguageID;
   Speaker = coRef.Speaker;
   Gender = coRef.Gender;
   SupportInfo = coRef.SupportInfo;
}
sds_fi_tcl_SpeakerInfoType& sds_fi_tcl_SpeakerInfoType::operator=(const sds_fi_tcl_SpeakerInfoType& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   Speaker = coRef.Speaker;
   Gender = coRef.Gender;
   SupportInfo = coRef.SupportInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_SpeakerInfoType::vDestroy()
{
   LanguageID.vDestroy(); 
   Speaker.vDestroy();
}

sds_fi_tcl_SpeakerInfoType::sds_fi_tcl_SpeakerInfoType()
:LanguageID()
,Speaker()
,Gender()
,SupportInfo()
 {}

tS32 sds_fi_tcl_SpeakerInfoType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_SPEAKERINFOTYPE;
}


sds_fi_tcl_SpeakerInfoType::~sds_fi_tcl_SpeakerInfoType()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_SpeakerInfoType::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+Speaker.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_SpeakerInfoType::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> Speaker);
   (tVoid) (oIn >> Gender);
   (tVoid) (oIn >> SupportInfo);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_SpeakerInfoType::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << Speaker);
   (tVoid) (oOut << Gender);
   (tVoid) (oOut << SupportInfo);
   return oOut;
}

tBool sds_fi_tcl_SpeakerInfoType::operator==(const sds_fi_tcl_SpeakerInfoType& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (Speaker == roRef.Speaker);
   bResult = bResult && (Gender == roRef.Gender);
   bResult = bResult && (SupportInfo == roRef.SupportInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_I2SNameIDs::sds_fi_tcl_I2SNameIDs(const sds_fi_tcl_I2SNameIDs& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   I2SNameIDs = coRef.I2SNameIDs;
}
sds_fi_tcl_I2SNameIDs& sds_fi_tcl_I2SNameIDs::operator=(const sds_fi_tcl_I2SNameIDs& coRef)
{
   if (this == &coRef) return *this;
   I2SNameIDs = coRef.I2SNameIDs;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_I2SNameIDs::vDestroy()
{
   {
   I2SNameIDs.clear();
   }
}

sds_fi_tcl_I2SNameIDs::sds_fi_tcl_I2SNameIDs()

 {}

tS32 sds_fi_tcl_I2SNameIDs::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_I2SNAMEIDS;
}


sds_fi_tcl_I2SNameIDs::~sds_fi_tcl_I2SNameIDs()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_I2SNameIDs::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+I2SNameIDs.size()*4;
}

fi_tclInContext& sds_fi_tcl_I2SNameIDs::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      I2SNameIDs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> I2SNameIDs[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_I2SNameIDs::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)I2SNameIDs.size());
   {
      for (tU32 u32Idx = 0; u32Idx < I2SNameIDs.size(); ++u32Idx)
         (tVoid) (oOut << I2SNameIDs[u32Idx]);
   }
   return oOut;
}

tBool sds_fi_tcl_I2SNameIDs::operator==(const sds_fi_tcl_I2SNameIDs& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (I2SNameIDs.size() == roRef.I2SNameIDs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < I2SNameIDs.size()); ++u32Idx)
            bResult = bResult && (I2SNameIDs[u32Idx] == roRef.I2SNameIDs[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_DynamicCtxStatus::sds_fi_tcl_DynamicCtxStatus(const sds_fi_tcl_DynamicCtxStatus& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   DomainID = coRef.DomainID;
   DeviceID = coRef.DeviceID;
}
sds_fi_tcl_DynamicCtxStatus& sds_fi_tcl_DynamicCtxStatus::operator=(const sds_fi_tcl_DynamicCtxStatus& coRef)
{
   if (this == &coRef) return *this;
   DomainID = coRef.DomainID;
   DeviceID = coRef.DeviceID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_DynamicCtxStatus::sds_fi_tcl_DynamicCtxStatus()
:DomainID()
,DeviceID(0)
 {}

tS32 sds_fi_tcl_DynamicCtxStatus::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_DYNAMICCTXSTATUS;
}


sds_fi_tcl_DynamicCtxStatus::~sds_fi_tcl_DynamicCtxStatus()
{}

tU32 sds_fi_tcl_DynamicCtxStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds_fi_tcl_DynamicCtxStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DomainID);
   (tVoid) (oIn >> DeviceID);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_DynamicCtxStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DomainID);
   (tVoid) (oOut << DeviceID);
   return oOut;
}

tBool sds_fi_tcl_DynamicCtxStatus::operator==(const sds_fi_tcl_DynamicCtxStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DomainID == roRef.DomainID);
   bResult = bResult && (DeviceID == roRef.DeviceID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_DynamicDataContextMetaFile::sds_fi_tcl_DynamicDataContextMetaFile(const sds_fi_tcl_DynamicDataContextMetaFile& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   DomainDeviceID = coRef.DomainDeviceID;
   DeviceMetaFile = coRef.DeviceMetaFile;
}
sds_fi_tcl_DynamicDataContextMetaFile& sds_fi_tcl_DynamicDataContextMetaFile::operator=(const sds_fi_tcl_DynamicDataContextMetaFile& coRef)
{
   if (this == &coRef) return *this;
   DomainDeviceID = coRef.DomainDeviceID;
   DeviceMetaFile = coRef.DeviceMetaFile;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_DynamicDataContextMetaFile::vDestroy()
{
   DomainDeviceID.vDestroy(); 
   DeviceMetaFile.vDestroy();
}

sds_fi_tcl_DynamicDataContextMetaFile::sds_fi_tcl_DynamicDataContextMetaFile()
:DomainDeviceID()
,DeviceMetaFile()
 {}

tS32 sds_fi_tcl_DynamicDataContextMetaFile::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_DYNAMICDATACONTEXTMETAFILE;
}


sds_fi_tcl_DynamicDataContextMetaFile::~sds_fi_tcl_DynamicDataContextMetaFile()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_DynamicDataContextMetaFile::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+DeviceMetaFile.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_DynamicDataContextMetaFile::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DomainDeviceID);
   (tVoid) (oIn >> DeviceMetaFile);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_DynamicDataContextMetaFile::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DomainDeviceID);
   (tVoid) (oOut << DeviceMetaFile);
   return oOut;
}

tBool sds_fi_tcl_DynamicDataContextMetaFile::operator==(const sds_fi_tcl_DynamicDataContextMetaFile& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DomainDeviceID == roRef.DomainDeviceID);
   bResult = bResult && (DeviceMetaFile == roRef.DeviceMetaFile);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_CityWithStreets::sds_fi_tcl_CityWithStreets(const sds_fi_tcl_CityWithStreets& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   CityID = coRef.CityID;
   StreetAvailability = coRef.StreetAvailability;
}
sds_fi_tcl_CityWithStreets& sds_fi_tcl_CityWithStreets::operator=(const sds_fi_tcl_CityWithStreets& coRef)
{
   if (this == &coRef) return *this;
   CityID = coRef.CityID;
   StreetAvailability = coRef.StreetAvailability;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_CityWithStreets::sds_fi_tcl_CityWithStreets()
:CityID(0)
,StreetAvailability(0)
 {}

tS32 sds_fi_tcl_CityWithStreets::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_CITYWITHSTREETS;
}


sds_fi_tcl_CityWithStreets::~sds_fi_tcl_CityWithStreets()
{}

tU32 sds_fi_tcl_CityWithStreets::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds_fi_tcl_CityWithStreets::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CityID);
   (tVoid) (oIn >> StreetAvailability);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_CityWithStreets::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CityID);
   (tVoid) (oOut << StreetAvailability);
   return oOut;
}

tBool sds_fi_tcl_CityWithStreets::operator==(const sds_fi_tcl_CityWithStreets& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CityID == roRef.CityID);
   bResult = bResult && (StreetAvailability == roRef.StreetAvailability);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_WordWithPhoneme::sds_fi_tcl_WordWithPhoneme(const sds_fi_tcl_WordWithPhoneme& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   Word = coRef.Word;
   PhonemeFound = coRef.PhonemeFound;
}
sds_fi_tcl_WordWithPhoneme& sds_fi_tcl_WordWithPhoneme::operator=(const sds_fi_tcl_WordWithPhoneme& coRef)
{
   if (this == &coRef) return *this;
   Word = coRef.Word;
   PhonemeFound = coRef.PhonemeFound;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_WordWithPhoneme::vDestroy()
{
   Word.vDestroy();
   PhonemeFound.vDestroy();
}

sds_fi_tcl_WordWithPhoneme::sds_fi_tcl_WordWithPhoneme()
:Word()
,PhonemeFound()
 {}

tS32 sds_fi_tcl_WordWithPhoneme::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_WORDWITHPHONEME;
}


sds_fi_tcl_WordWithPhoneme::~sds_fi_tcl_WordWithPhoneme()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_WordWithPhoneme::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Word.u32GetSize(u16MajorVersion)+PhonemeFound.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_WordWithPhoneme::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Word);
   (tVoid) (oIn >> PhonemeFound);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_WordWithPhoneme::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Word);
   (tVoid) (oOut << PhonemeFound);
   return oOut;
}

tBool sds_fi_tcl_WordWithPhoneme::operator==(const sds_fi_tcl_WordWithPhoneme& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Word == roRef.Word);
   bResult = bResult && (PhonemeFound == roRef.PhonemeFound);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_VcData::sds_fi_tcl_VcData(const sds_fi_tcl_VcData& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   Section = coRef.Section;
   FilePath = coRef.FilePath;
}
sds_fi_tcl_VcData& sds_fi_tcl_VcData::operator=(const sds_fi_tcl_VcData& coRef)
{
   if (this == &coRef) return *this;
   Section = coRef.Section;
   FilePath = coRef.FilePath;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_VcData::vDestroy()
{
   Section.vDestroy();
   FilePath.vDestroy();
}

sds_fi_tcl_VcData::sds_fi_tcl_VcData()
:Section()
,FilePath()
 {}

tS32 sds_fi_tcl_VcData::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_VCDATA;
}


sds_fi_tcl_VcData::~sds_fi_tcl_VcData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_VcData::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Section.u32GetSize(u16MajorVersion)+FilePath.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_VcData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Section);
   (tVoid) (oIn >> FilePath);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_VcData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Section);
   (tVoid) (oOut << FilePath);
   return oOut;
}

tBool sds_fi_tcl_VcData::operator==(const sds_fi_tcl_VcData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Section == roRef.Section);
   bResult = bResult && (FilePath == roRef.FilePath);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_BlobData::sds_fi_tcl_BlobData(const sds_fi_tcl_BlobData& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   URId = coRef.URId;
   FileLocation = coRef.FileLocation;
   FileSize = coRef.FileSize;
}
sds_fi_tcl_BlobData& sds_fi_tcl_BlobData::operator=(const sds_fi_tcl_BlobData& coRef)
{
   if (this == &coRef) return *this;
   URId = coRef.URId;
   FileLocation = coRef.FileLocation;
   FileSize = coRef.FileSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_BlobData::vDestroy()
{
   FileLocation.vDestroy();
}

sds_fi_tcl_BlobData::sds_fi_tcl_BlobData()
:URId(0)
,FileLocation()
,FileSize(0)
 {}

tS32 sds_fi_tcl_BlobData::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_BLOBDATA;
}


sds_fi_tcl_BlobData::~sds_fi_tcl_BlobData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_BlobData::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+FileLocation.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_BlobData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> URId);
   (tVoid) (oIn >> FileLocation);
   (tVoid) (oIn >> FileSize);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_BlobData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << URId);
   (tVoid) (oOut << FileLocation);
   (tVoid) (oOut << FileSize);
   return oOut;
}

tBool sds_fi_tcl_BlobData::operator==(const sds_fi_tcl_BlobData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (URId == roRef.URId);
   bResult = bResult && (FileLocation == roRef.FileLocation);
   bResult = bResult && (FileSize == roRef.FileSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_SDNLocation::sds_fi_tcl_e8_SDNLocation():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_SDNLocation::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_SDNLOCATION;
}


sds_fi_tcl_e8_SDNLocation::~sds_fi_tcl_e8_SDNLocation()
{}

tU32 sds_fi_tcl_e8_SDNLocation::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_SDNLocation::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_SDNLocation::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_AddressType::sds_fi_tcl_e8_AddressType():enType(FI_EN_COUNTRY) {}

tS32 sds_fi_tcl_e8_AddressType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_ADDRESSTYPE;
}


sds_fi_tcl_e8_AddressType::~sds_fi_tcl_e8_AddressType()
{}

tU32 sds_fi_tcl_e8_AddressType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_AddressType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_AddressType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_SettingsType::sds_fi_tcl_e8_SettingsType():enType(FI_EN_VOICEBARGEIN) {}

tS32 sds_fi_tcl_e8_SettingsType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_SETTINGSTYPE;
}


sds_fi_tcl_e8_SettingsType::~sds_fi_tcl_e8_SettingsType()
{}

tU32 sds_fi_tcl_e8_SettingsType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_SettingsType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_SettingsType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_RecogStatus::sds_fi_tcl_e8_RecogStatus():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_RecogStatus::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_RECOGSTATUS;
}


sds_fi_tcl_e8_RecogStatus::~sds_fi_tcl_e8_RecogStatus()
{}

tU32 sds_fi_tcl_e8_RecogStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_RecogStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_RecogStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_DataCategory::sds_fi_tcl_e8_DataCategory():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_DataCategory::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_DATACATEGORY;
}


sds_fi_tcl_e8_DataCategory::~sds_fi_tcl_e8_DataCategory()
{}

tU32 sds_fi_tcl_e8_DataCategory::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_DataCategory::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_DataCategory::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_RecogFromFile::sds_fi_tcl_RecogFromFile(const sds_fi_tcl_RecogFromFile& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   bRecogFromFile = coRef.bRecogFromFile;
   bRecogFromFileInc = coRef.bRecogFromFileInc;
   bNotEnoughTSData = coRef.bNotEnoughTSData;
   u32FileID = coRef.u32FileID;
   szRecogFromFilePath = coRef.szRecogFromFilePath;
   bSlowDownDataStream = coRef.bSlowDownDataStream;
}
sds_fi_tcl_RecogFromFile& sds_fi_tcl_RecogFromFile::operator=(const sds_fi_tcl_RecogFromFile& coRef)
{
   if (this == &coRef) return *this;
   bRecogFromFile = coRef.bRecogFromFile;
   bRecogFromFileInc = coRef.bRecogFromFileInc;
   bNotEnoughTSData = coRef.bNotEnoughTSData;
   u32FileID = coRef.u32FileID;
   szRecogFromFilePath = coRef.szRecogFromFilePath;
   bSlowDownDataStream = coRef.bSlowDownDataStream;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_RecogFromFile::vDestroy()
{
   szRecogFromFilePath.vDestroy();
}

sds_fi_tcl_RecogFromFile::sds_fi_tcl_RecogFromFile()
:bRecogFromFile(0)
,bRecogFromFileInc(0)
,bNotEnoughTSData(0)
,u32FileID(0)
,szRecogFromFilePath()
,bSlowDownDataStream(0)
 {}

tS32 sds_fi_tcl_RecogFromFile::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_RECOGFROMFILE;
}


sds_fi_tcl_RecogFromFile::~sds_fi_tcl_RecogFromFile()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_RecogFromFile::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+szRecogFromFilePath.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_RecogFromFile::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bRecogFromFile);
   (tVoid) (oIn >> bRecogFromFileInc);
   (tVoid) (oIn >> bNotEnoughTSData);
   (tVoid) (oIn >> u32FileID);
   (tVoid) (oIn >> szRecogFromFilePath);
   (tVoid) (oIn >> bSlowDownDataStream);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_RecogFromFile::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bRecogFromFile);
   (tVoid) (oOut << bRecogFromFileInc);
   (tVoid) (oOut << bNotEnoughTSData);
   (tVoid) (oOut << u32FileID);
   (tVoid) (oOut << szRecogFromFilePath);
   (tVoid) (oOut << bSlowDownDataStream);
   return oOut;
}

tBool sds_fi_tcl_RecogFromFile::operator==(const sds_fi_tcl_RecogFromFile& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bRecogFromFile == roRef.bRecogFromFile);
   bResult = bResult && (bRecogFromFileInc == roRef.bRecogFromFileInc);
   bResult = bResult && (bNotEnoughTSData == roRef.bNotEnoughTSData);
   bResult = bResult && (u32FileID == roRef.u32FileID);
   bResult = bResult && (szRecogFromFilePath == roRef.szRecogFromFilePath);
   bResult = bResult && (bSlowDownDataStream == roRef.bSlowDownDataStream);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_RecogToFile::sds_fi_tcl_RecogToFile(const sds_fi_tcl_RecogToFile& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   bRecogToFile = coRef.bRecogToFile;
   bRecogToFileInc = coRef.bRecogToFileInc;
   u32FileID = coRef.u32FileID;
   szRecogToFilePath = coRef.szRecogToFilePath;
}
sds_fi_tcl_RecogToFile& sds_fi_tcl_RecogToFile::operator=(const sds_fi_tcl_RecogToFile& coRef)
{
   if (this == &coRef) return *this;
   bRecogToFile = coRef.bRecogToFile;
   bRecogToFileInc = coRef.bRecogToFileInc;
   u32FileID = coRef.u32FileID;
   szRecogToFilePath = coRef.szRecogToFilePath;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_RecogToFile::vDestroy()
{
   szRecogToFilePath.vDestroy();
}

sds_fi_tcl_RecogToFile::sds_fi_tcl_RecogToFile()
:bRecogToFile(0)
,bRecogToFileInc(0)
,u32FileID(0)
,szRecogToFilePath()
 {}

tS32 sds_fi_tcl_RecogToFile::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_RECOGTOFILE;
}


sds_fi_tcl_RecogToFile::~sds_fi_tcl_RecogToFile()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_RecogToFile::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+szRecogToFilePath.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_RecogToFile::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bRecogToFile);
   (tVoid) (oIn >> bRecogToFileInc);
   (tVoid) (oIn >> u32FileID);
   (tVoid) (oIn >> szRecogToFilePath);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_RecogToFile::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bRecogToFile);
   (tVoid) (oOut << bRecogToFileInc);
   (tVoid) (oOut << u32FileID);
   (tVoid) (oOut << szRecogToFilePath);
   return oOut;
}

tBool sds_fi_tcl_RecogToFile::operator==(const sds_fi_tcl_RecogToFile& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bRecogToFile == roRef.bRecogToFile);
   bResult = bResult && (bRecogToFileInc == roRef.bRecogToFileInc);
   bResult = bResult && (u32FileID == roRef.u32FileID);
   bResult = bResult && (szRecogToFilePath == roRef.szRecogToFilePath);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_REC_Settings::sds_fi_tcl_REC_Settings(const sds_fi_tcl_REC_Settings& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   enRecogType = coRef.enRecogType;
   bValue = coRef.bValue;
}
sds_fi_tcl_REC_Settings& sds_fi_tcl_REC_Settings::operator=(const sds_fi_tcl_REC_Settings& coRef)
{
   if (this == &coRef) return *this;
   enRecogType = coRef.enRecogType;
   bValue = coRef.bValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_REC_Settings::sds_fi_tcl_REC_Settings()
:enRecogType()
,bValue(0)
 {}

tS32 sds_fi_tcl_REC_Settings::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_REC_SETTINGS;
}


sds_fi_tcl_REC_Settings::~sds_fi_tcl_REC_Settings()
{}

tU32 sds_fi_tcl_REC_Settings::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_fi_tcl_REC_Settings::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enRecogType);
   (tVoid) (oIn >> bValue);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_REC_Settings::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enRecogType);
   (tVoid) (oOut << bValue);
   return oOut;
}

tBool sds_fi_tcl_REC_Settings::operator==(const sds_fi_tcl_REC_Settings& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enRecogType == roRef.enRecogType);
   bResult = bResult && (bValue == roRef.bValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_WUWStatus::sds_fi_tcl_e8_WUWStatus():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_WUWStatus::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_WUWSTATUS;
}


sds_fi_tcl_e8_WUWStatus::~sds_fi_tcl_e8_WUWStatus()
{}

tU32 sds_fi_tcl_e8_WUWStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_WUWStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_WUWStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_u32_FrontEndParam::sds_fi_tcl_u32_FrontEndParam():enType(FI_EN_LH_FX_PARAM_START_ENABLE) {}

tS32 sds_fi_tcl_u32_FrontEndParam::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_U32_FRONTENDPARAM;
}


sds_fi_tcl_u32_FrontEndParam::~sds_fi_tcl_u32_FrontEndParam()
{}

tU32 sds_fi_tcl_u32_FrontEndParam::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_fi_tcl_u32_FrontEndParam::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_u32_FrontEndParam::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_u32_RecParam::sds_fi_tcl_u32_RecParam():enType(FI_EN_LH_REC_PARAM_AUTOMATIC_RESTART) {}

tS32 sds_fi_tcl_u32_RecParam::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_U32_RECPARAM;
}


sds_fi_tcl_u32_RecParam::~sds_fi_tcl_u32_RecParam()
{}

tU32 sds_fi_tcl_u32_RecParam::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_fi_tcl_u32_RecParam::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_u32_RecParam::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_u32_ContextParam::sds_fi_tcl_u32_ContextParam():enType(FI_EN_LH_CTX_PARAM_ACCURACY) {}

tS32 sds_fi_tcl_u32_ContextParam::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_U32_CONTEXTPARAM;
}


sds_fi_tcl_u32_ContextParam::~sds_fi_tcl_u32_ContextParam()
{}

tU32 sds_fi_tcl_u32_ContextParam::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_fi_tcl_u32_ContextParam::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_u32_ContextParam::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8RecogAbnormalEvents::sds_fi_tcl_e8RecogAbnormalEvents():enType(FI_EN_LH_FX_ABNORMNULL) {}

tS32 sds_fi_tcl_e8RecogAbnormalEvents::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8RECOGABNORMALEVENTS;
}


sds_fi_tcl_e8RecogAbnormalEvents::~sds_fi_tcl_e8RecogAbnormalEvents()
{}

tU32 sds_fi_tcl_e8RecogAbnormalEvents::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8RecogAbnormalEvents::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8RecogAbnormalEvents::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_RecogResultType::sds_fi_tcl_e8_RecogResultType():enType(FI_EN_UNKNOWNFAILUE) {}

tS32 sds_fi_tcl_e8_RecogResultType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_RECOGRESULTTYPE;
}


sds_fi_tcl_e8_RecogResultType::~sds_fi_tcl_e8_RecogResultType()
{}

tU32 sds_fi_tcl_e8_RecogResultType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_RecogResultType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_RecogResultType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_RecResultInterfaceType::sds_fi_tcl_e8_RecResultInterfaceType():enType(FI_EN_REC_UNKNOWNRESULT_INTERFACE) {}

tS32 sds_fi_tcl_e8_RecResultInterfaceType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_RECRESULTINTERFACETYPE;
}


sds_fi_tcl_e8_RecResultInterfaceType::~sds_fi_tcl_e8_RecResultInterfaceType()
{}

tU32 sds_fi_tcl_e8_RecResultInterfaceType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_RecResultInterfaceType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_RecResultInterfaceType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_USWTrainingType::sds_fi_tcl_e8_USWTrainingType():enType(FI_EN_UW_UNKNOWN_TRAINING) {}

tS32 sds_fi_tcl_e8_USWTrainingType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_USWTRAININGTYPE;
}


sds_fi_tcl_e8_USWTrainingType::~sds_fi_tcl_e8_USWTrainingType()
{}

tU32 sds_fi_tcl_e8_USWTrainingType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_USWTrainingType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_USWTrainingType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_RecogNBestResultWordInfo::sds_fi_tcl_RecogNBestResultWordInfo(const sds_fi_tcl_RecogNBestResultWordInfo& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   u32UserId = coRef.u32UserId;
   szWord = coRef.szWord;
   u32WordConf = coRef.u32WordConf;
   bIsWordASlot = coRef.bIsWordASlot;
}
sds_fi_tcl_RecogNBestResultWordInfo& sds_fi_tcl_RecogNBestResultWordInfo::operator=(const sds_fi_tcl_RecogNBestResultWordInfo& coRef)
{
   if (this == &coRef) return *this;
   u32UserId = coRef.u32UserId;
   szWord = coRef.szWord;
   u32WordConf = coRef.u32WordConf;
   bIsWordASlot = coRef.bIsWordASlot;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_RecogNBestResultWordInfo::vDestroy()
{
   szWord.vDestroy();
}

sds_fi_tcl_RecogNBestResultWordInfo::sds_fi_tcl_RecogNBestResultWordInfo()
:u32UserId(0)
,szWord()
,u32WordConf(0)
,bIsWordASlot(0)
 {}

tS32 sds_fi_tcl_RecogNBestResultWordInfo::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_RECOGNBESTRESULTWORDINFO;
}


sds_fi_tcl_RecogNBestResultWordInfo::~sds_fi_tcl_RecogNBestResultWordInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_RecogNBestResultWordInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 9+szWord.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_RecogNBestResultWordInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32UserId);
   (tVoid) (oIn >> szWord);
   (tVoid) (oIn >> u32WordConf);
   (tVoid) (oIn >> bIsWordASlot);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_RecogNBestResultWordInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32UserId);
   (tVoid) (oOut << szWord);
   (tVoid) (oOut << u32WordConf);
   (tVoid) (oOut << bIsWordASlot);
   return oOut;
}

tBool sds_fi_tcl_RecogNBestResultWordInfo::operator==(const sds_fi_tcl_RecogNBestResultWordInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32UserId == roRef.u32UserId);
   bResult = bResult && (szWord == roRef.szWord);
   bResult = bResult && (u32WordConf == roRef.u32WordConf);
   bResult = bResult && (bIsWordASlot == roRef.bIsWordASlot);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_SemConfig::sds_fi_tcl_SemConfig(const sds_fi_tcl_SemConfig& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   LogicalNameSemBuffer = coRef.LogicalNameSemBuffer;
   TopicNames = coRef.TopicNames;
}
sds_fi_tcl_SemConfig& sds_fi_tcl_SemConfig::operator=(const sds_fi_tcl_SemConfig& coRef)
{
   if (this == &coRef) return *this;
   LogicalNameSemBuffer = coRef.LogicalNameSemBuffer;
   TopicNames = coRef.TopicNames;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_SemConfig::vDestroy()
{
   LogicalNameSemBuffer.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < TopicNames.size(); ++u32Idx)
         TopicNames[u32Idx].vDestroy();
   TopicNames.clear();
   }
}

sds_fi_tcl_SemConfig::sds_fi_tcl_SemConfig()
:LogicalNameSemBuffer()

 {}

tS32 sds_fi_tcl_SemConfig::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_SEMCONFIG;
}


sds_fi_tcl_SemConfig::~sds_fi_tcl_SemConfig()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_SemConfig::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TopicNames.size(); ++u32ListIdx)
      u32DynamicSize += TopicNames[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4+LogicalNameSemBuffer.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_SemConfig::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LogicalNameSemBuffer);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TopicNames.size(); ++u32Idx)
      {
         TopicNames[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TopicNames.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TopicNames[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_SemConfig::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LogicalNameSemBuffer);
   (tVoid) (oOut << (tU32)TopicNames.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TopicNames.size(); ++u32Idx)
         (tVoid) (oOut << TopicNames[u32Idx]);
   }
   return oOut;
}

tBool sds_fi_tcl_SemConfig::operator==(const sds_fi_tcl_SemConfig& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LogicalNameSemBuffer == roRef.LogicalNameSemBuffer);
      bResult = bResult && (TopicNames.size() == roRef.TopicNames.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TopicNames.size()); ++u32Idx)
            bResult = bResult && (TopicNames[u32Idx] == roRef.TopicNames[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_SemResultSlotInfo::sds_fi_tcl_SemResultSlotInfo(const sds_fi_tcl_SemResultSlotInfo& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   szSlotName = coRef.szSlotName;
   szSlotValue = coRef.szSlotValue;
   u32SlotScore = coRef.u32SlotScore;
}
sds_fi_tcl_SemResultSlotInfo& sds_fi_tcl_SemResultSlotInfo::operator=(const sds_fi_tcl_SemResultSlotInfo& coRef)
{
   if (this == &coRef) return *this;
   szSlotName = coRef.szSlotName;
   szSlotValue = coRef.szSlotValue;
   u32SlotScore = coRef.u32SlotScore;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_SemResultSlotInfo::vDestroy()
{
   szSlotName.vDestroy();
   szSlotValue.vDestroy();
}

sds_fi_tcl_SemResultSlotInfo::sds_fi_tcl_SemResultSlotInfo()
:szSlotName()
,szSlotValue()
,u32SlotScore(0)
 {}

tS32 sds_fi_tcl_SemResultSlotInfo::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_SEMRESULTSLOTINFO;
}


sds_fi_tcl_SemResultSlotInfo::~sds_fi_tcl_SemResultSlotInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_SemResultSlotInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+szSlotName.u32GetSize(u16MajorVersion)+szSlotValue.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_SemResultSlotInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szSlotName);
   (tVoid) (oIn >> szSlotValue);
   (tVoid) (oIn >> u32SlotScore);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_SemResultSlotInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szSlotName);
   (tVoid) (oOut << szSlotValue);
   (tVoid) (oOut << u32SlotScore);
   return oOut;
}

tBool sds_fi_tcl_SemResultSlotInfo::operator==(const sds_fi_tcl_SemResultSlotInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szSlotName == roRef.szSlotName);
   bResult = bResult && (szSlotValue == roRef.szSlotValue);
   bResult = bResult && (u32SlotScore == roRef.u32SlotScore);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_SemResultInterpretations::sds_fi_tcl_SemResultInterpretations(const sds_fi_tcl_SemResultInterpretations& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   u32InterpretScore = coRef.u32InterpretScore;
   arSemSlots = coRef.arSemSlots;
}
sds_fi_tcl_SemResultInterpretations& sds_fi_tcl_SemResultInterpretations::operator=(const sds_fi_tcl_SemResultInterpretations& coRef)
{
   if (this == &coRef) return *this;
   u32InterpretScore = coRef.u32InterpretScore;
   arSemSlots = coRef.arSemSlots;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_SemResultInterpretations::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < arSemSlots.size(); ++u32Idx)
         arSemSlots[u32Idx].vDestroy();
   arSemSlots.clear();
   }
}

sds_fi_tcl_SemResultInterpretations::sds_fi_tcl_SemResultInterpretations()
:u32InterpretScore(0)

 {}

tS32 sds_fi_tcl_SemResultInterpretations::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_SEMRESULTINTERPRETATIONS;
}


sds_fi_tcl_SemResultInterpretations::~sds_fi_tcl_SemResultInterpretations()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_SemResultInterpretations::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < arSemSlots.size(); ++u32ListIdx)
      u32DynamicSize += arSemSlots[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

fi_tclInContext& sds_fi_tcl_SemResultInterpretations::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32InterpretScore);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < arSemSlots.size(); ++u32Idx)
      {
         arSemSlots[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      arSemSlots.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> arSemSlots[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_SemResultInterpretations::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32InterpretScore);
   (tVoid) (oOut << (tU32)arSemSlots.size());
   {
      for (tU32 u32Idx = 0; u32Idx < arSemSlots.size(); ++u32Idx)
         (tVoid) (oOut << arSemSlots[u32Idx]);
   }
   return oOut;
}

tBool sds_fi_tcl_SemResultInterpretations::operator==(const sds_fi_tcl_SemResultInterpretations& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32InterpretScore == roRef.u32InterpretScore);
      bResult = bResult && (arSemSlots.size() == roRef.arSemSlots.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < arSemSlots.size()); ++u32Idx)
            bResult = bResult && (arSemSlots[u32Idx] == roRef.arSemSlots[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_RecogNBestResult::sds_fi_tcl_RecogNBestResult(const sds_fi_tcl_RecogNBestResult& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   szResultSentence = coRef.szResultSentence;
   u32ConfidenceValue = coRef.u32ConfidenceValue;
   szLogicalName = coRef.szLogicalName;
   szStartRule = coRef.szStartRule;
   arrWordInfos = coRef.arrWordInfos;
}
sds_fi_tcl_RecogNBestResult& sds_fi_tcl_RecogNBestResult::operator=(const sds_fi_tcl_RecogNBestResult& coRef)
{
   if (this == &coRef) return *this;
   szResultSentence = coRef.szResultSentence;
   u32ConfidenceValue = coRef.u32ConfidenceValue;
   szLogicalName = coRef.szLogicalName;
   szStartRule = coRef.szStartRule;
   arrWordInfos = coRef.arrWordInfos;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_RecogNBestResult::vDestroy()
{
   szResultSentence.vDestroy();
   szLogicalName.vDestroy();
   szStartRule.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < arrWordInfos.size(); ++u32Idx)
         arrWordInfos[u32Idx].vDestroy();
   arrWordInfos.clear();
   }
}

sds_fi_tcl_RecogNBestResult::sds_fi_tcl_RecogNBestResult()
:szResultSentence()
,u32ConfidenceValue(0)
,szLogicalName()
,szStartRule()

 {}

tS32 sds_fi_tcl_RecogNBestResult::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_RECOGNBESTRESULT;
}


sds_fi_tcl_RecogNBestResult::~sds_fi_tcl_RecogNBestResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_RecogNBestResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < arrWordInfos.size(); ++u32ListIdx)
      u32DynamicSize += arrWordInfos[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8+szResultSentence.u32GetSize(u16MajorVersion)+szLogicalName.u32GetSize(u16MajorVersion)+szStartRule.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_RecogNBestResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szResultSentence);
   (tVoid) (oIn >> u32ConfidenceValue);
   (tVoid) (oIn >> szLogicalName);
   (tVoid) (oIn >> szStartRule);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < arrWordInfos.size(); ++u32Idx)
      {
         arrWordInfos[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      arrWordInfos.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> arrWordInfos[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_RecogNBestResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szResultSentence);
   (tVoid) (oOut << u32ConfidenceValue);
   (tVoid) (oOut << szLogicalName);
   (tVoid) (oOut << szStartRule);
   (tVoid) (oOut << (tU32)arrWordInfos.size());
   {
      for (tU32 u32Idx = 0; u32Idx < arrWordInfos.size(); ++u32Idx)
         (tVoid) (oOut << arrWordInfos[u32Idx]);
   }
   return oOut;
}

tBool sds_fi_tcl_RecogNBestResult::operator==(const sds_fi_tcl_RecogNBestResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szResultSentence == roRef.szResultSentence);
   bResult = bResult && (u32ConfidenceValue == roRef.u32ConfidenceValue);
   bResult = bResult && (szLogicalName == roRef.szLogicalName);
   bResult = bResult && (szStartRule == roRef.szStartRule);
      bResult = bResult && (arrWordInfos.size() == roRef.arrWordInfos.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < arrWordInfos.size()); ++u32Idx)
            bResult = bResult && (arrWordInfos[u32Idx] == roRef.arrWordInfos[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_RecogSemResult::sds_fi_tcl_RecogSemResult(const sds_fi_tcl_RecogSemResult& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   szTopicName = coRef.szTopicName;
   u32TopicScore = coRef.u32TopicScore;
   SemBuffer = coRef.SemBuffer;
   arInterpretations = coRef.arInterpretations;
}
sds_fi_tcl_RecogSemResult& sds_fi_tcl_RecogSemResult::operator=(const sds_fi_tcl_RecogSemResult& coRef)
{
   if (this == &coRef) return *this;
   szTopicName = coRef.szTopicName;
   u32TopicScore = coRef.u32TopicScore;
   SemBuffer = coRef.SemBuffer;
   arInterpretations = coRef.arInterpretations;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_RecogSemResult::vDestroy()
{
   szTopicName.vDestroy();
   SemBuffer.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < arInterpretations.size(); ++u32Idx)
         arInterpretations[u32Idx].vDestroy();
   arInterpretations.clear();
   }
}

sds_fi_tcl_RecogSemResult::sds_fi_tcl_RecogSemResult()
:szTopicName()
,u32TopicScore(0)
,SemBuffer()

 {}

tS32 sds_fi_tcl_RecogSemResult::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_RECOGSEMRESULT;
}


sds_fi_tcl_RecogSemResult::~sds_fi_tcl_RecogSemResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_RecogSemResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < arInterpretations.size(); ++u32ListIdx)
      u32DynamicSize += arInterpretations[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8+szTopicName.u32GetSize(u16MajorVersion)+SemBuffer.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_RecogSemResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szTopicName);
   (tVoid) (oIn >> u32TopicScore);
   (tVoid) (oIn >> SemBuffer);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < arInterpretations.size(); ++u32Idx)
      {
         arInterpretations[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      arInterpretations.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> arInterpretations[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_RecogSemResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szTopicName);
   (tVoid) (oOut << u32TopicScore);
   (tVoid) (oOut << SemBuffer);
   (tVoid) (oOut << (tU32)arInterpretations.size());
   {
      for (tU32 u32Idx = 0; u32Idx < arInterpretations.size(); ++u32Idx)
         (tVoid) (oOut << arInterpretations[u32Idx]);
   }
   return oOut;
}

tBool sds_fi_tcl_RecogSemResult::operator==(const sds_fi_tcl_RecogSemResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szTopicName == roRef.szTopicName);
   bResult = bResult && (u32TopicScore == roRef.u32TopicScore);
   bResult = bResult && (SemBuffer == roRef.SemBuffer);
      bResult = bResult && (arInterpretations.size() == roRef.arInterpretations.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < arInterpretations.size()); ++u32Idx)
            bResult = bResult && (arInterpretations[u32Idx] == roRef.arInterpretations[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_RecogNaviNBestResult::sds_fi_tcl_RecogNaviNBestResult(const sds_fi_tcl_RecogNaviNBestResult& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   u32ConfidenceValue = coRef.u32ConfidenceValue;
   szLogicalName = coRef.szLogicalName;
   DestinationList = coRef.DestinationList;
}
sds_fi_tcl_RecogNaviNBestResult& sds_fi_tcl_RecogNaviNBestResult::operator=(const sds_fi_tcl_RecogNaviNBestResult& coRef)
{
   if (this == &coRef) return *this;
   u32ConfidenceValue = coRef.u32ConfidenceValue;
   szLogicalName = coRef.szLogicalName;
   DestinationList = coRef.DestinationList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_RecogNaviNBestResult::vDestroy()
{
   szLogicalName.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < DestinationList.size(); ++u32Idx)
         DestinationList[u32Idx].vDestroy();
   DestinationList.clear();
   }
}

sds_fi_tcl_RecogNaviNBestResult::sds_fi_tcl_RecogNaviNBestResult()
:u32ConfidenceValue(0)
,szLogicalName()

 {}

tS32 sds_fi_tcl_RecogNaviNBestResult::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_RECOGNAVINBESTRESULT;
}


sds_fi_tcl_RecogNaviNBestResult::~sds_fi_tcl_RecogNaviNBestResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_RecogNaviNBestResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DestinationList.size(); ++u32ListIdx)
      u32DynamicSize += DestinationList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8+szLogicalName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_RecogNaviNBestResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ConfidenceValue);
   (tVoid) (oIn >> szLogicalName);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DestinationList.size(); ++u32Idx)
      {
         DestinationList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DestinationList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DestinationList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_RecogNaviNBestResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ConfidenceValue);
   (tVoid) (oOut << szLogicalName);
   (tVoid) (oOut << (tU32)DestinationList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DestinationList.size(); ++u32Idx)
         (tVoid) (oOut << DestinationList[u32Idx]);
   }
   return oOut;
}

tBool sds_fi_tcl_RecogNaviNBestResult::operator==(const sds_fi_tcl_RecogNaviNBestResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ConfidenceValue == roRef.u32ConfidenceValue);
   bResult = bResult && (szLogicalName == roRef.szLogicalName);
      bResult = bResult && (DestinationList.size() == roRef.DestinationList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DestinationList.size()); ++u32Idx)
            bResult = bResult && (DestinationList[u32Idx] == roRef.DestinationList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_FrontEndParameter::sds_fi_tcl_FrontEndParameter(const sds_fi_tcl_FrontEndParameter& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   s32ParamValue = coRef.s32ParamValue;
   FrontEndParam = coRef.FrontEndParam;
}
sds_fi_tcl_FrontEndParameter& sds_fi_tcl_FrontEndParameter::operator=(const sds_fi_tcl_FrontEndParameter& coRef)
{
   if (this == &coRef) return *this;
   s32ParamValue = coRef.s32ParamValue;
   FrontEndParam = coRef.FrontEndParam;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_FrontEndParameter::sds_fi_tcl_FrontEndParameter()
:s32ParamValue(0)
,FrontEndParam()
 {}

tS32 sds_fi_tcl_FrontEndParameter::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_FRONTENDPARAMETER;
}


sds_fi_tcl_FrontEndParameter::~sds_fi_tcl_FrontEndParameter()
{}

tU32 sds_fi_tcl_FrontEndParameter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& sds_fi_tcl_FrontEndParameter::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s32ParamValue);
   (tVoid) (oIn >> FrontEndParam);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_FrontEndParameter::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s32ParamValue);
   (tVoid) (oOut << FrontEndParam);
   return oOut;
}

tBool sds_fi_tcl_FrontEndParameter::operator==(const sds_fi_tcl_FrontEndParameter& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s32ParamValue == roRef.s32ParamValue);
   bResult = bResult && (FrontEndParam == roRef.FrontEndParam);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_RecParameter::sds_fi_tcl_RecParameter(const sds_fi_tcl_RecParameter& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   s32ParamValue = coRef.s32ParamValue;
   RecogParam = coRef.RecogParam;
}
sds_fi_tcl_RecParameter& sds_fi_tcl_RecParameter::operator=(const sds_fi_tcl_RecParameter& coRef)
{
   if (this == &coRef) return *this;
   s32ParamValue = coRef.s32ParamValue;
   RecogParam = coRef.RecogParam;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_RecParameter::sds_fi_tcl_RecParameter()
:s32ParamValue(0)
,RecogParam()
 {}

tS32 sds_fi_tcl_RecParameter::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_RECPARAMETER;
}


sds_fi_tcl_RecParameter::~sds_fi_tcl_RecParameter()
{}

tU32 sds_fi_tcl_RecParameter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& sds_fi_tcl_RecParameter::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s32ParamValue);
   (tVoid) (oIn >> RecogParam);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_RecParameter::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s32ParamValue);
   (tVoid) (oOut << RecogParam);
   return oOut;
}

tBool sds_fi_tcl_RecParameter::operator==(const sds_fi_tcl_RecParameter& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s32ParamValue == roRef.s32ParamValue);
   bResult = bResult && (RecogParam == roRef.RecogParam);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_ContextParameter::sds_fi_tcl_ContextParameter(const sds_fi_tcl_ContextParameter& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   s32ParamValue = coRef.s32ParamValue;
   ContextParam = coRef.ContextParam;
}
sds_fi_tcl_ContextParameter& sds_fi_tcl_ContextParameter::operator=(const sds_fi_tcl_ContextParameter& coRef)
{
   if (this == &coRef) return *this;
   s32ParamValue = coRef.s32ParamValue;
   ContextParam = coRef.ContextParam;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_ContextParameter::sds_fi_tcl_ContextParameter()
:s32ParamValue(0)
,ContextParam()
 {}

tS32 sds_fi_tcl_ContextParameter::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_CONTEXTPARAMETER;
}


sds_fi_tcl_ContextParameter::~sds_fi_tcl_ContextParameter()
{}

tU32 sds_fi_tcl_ContextParameter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& sds_fi_tcl_ContextParameter::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s32ParamValue);
   (tVoid) (oIn >> ContextParam);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_ContextParameter::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s32ParamValue);
   (tVoid) (oOut << ContextParam);
   return oOut;
}

tBool sds_fi_tcl_ContextParameter::operator==(const sds_fi_tcl_ContextParameter& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s32ParamValue == roRef.s32ParamValue);
   bResult = bResult && (ContextParam == roRef.ContextParam);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_VoconComponent::sds_fi_tcl_e8_VoconComponent():enType(FI_EN_VOCONBASE) {}

tS32 sds_fi_tcl_e8_VoconComponent::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_VOCONCOMPONENT;
}


sds_fi_tcl_e8_VoconComponent::~sds_fi_tcl_e8_VoconComponent()
{}

tU32 sds_fi_tcl_e8_VoconComponent::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_VoconComponent::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_VoconComponent::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_VoconComponentStatus::sds_fi_tcl_e8_VoconComponentStatus():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_VoconComponentStatus::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_VOCONCOMPONENTSTATUS;
}


sds_fi_tcl_e8_VoconComponentStatus::~sds_fi_tcl_e8_VoconComponentStatus()
{}

tU32 sds_fi_tcl_e8_VoconComponentStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_VoconComponentStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_VoconComponentStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_PrompterStatus::sds_fi_tcl_e8_PrompterStatus():enType(FI_EN_PREPAREVOICEOUTPUT) {}

tS32 sds_fi_tcl_e8_PrompterStatus::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_PROMPTERSTATUS;
}


sds_fi_tcl_e8_PrompterStatus::~sds_fi_tcl_e8_PrompterStatus()
{}

tU32 sds_fi_tcl_e8_PrompterStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_PrompterStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_PrompterStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_ReleaseTypePP::sds_fi_tcl_e8_ReleaseTypePP():enType(FI_EN_SPEAKERCHANGE) {}

tS32 sds_fi_tcl_e8_ReleaseTypePP::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_RELEASETYPEPP;
}


sds_fi_tcl_e8_ReleaseTypePP::~sds_fi_tcl_e8_ReleaseTypePP()
{}

tU32 sds_fi_tcl_e8_ReleaseTypePP::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_ReleaseTypePP::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_ReleaseTypePP::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_VarType::sds_fi_tcl_e8_VarType():enType(FI_EN_PHONE) {}

tS32 sds_fi_tcl_e8_VarType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_VARTYPE;
}


sds_fi_tcl_e8_VarType::~sds_fi_tcl_e8_VarType()
{}

tU32 sds_fi_tcl_e8_VarType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_VarType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_VarType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e16_OrderingType::sds_fi_tcl_e16_OrderingType():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e16_OrderingType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E16_ORDERINGTYPE;
}


sds_fi_tcl_e16_OrderingType::~sds_fi_tcl_e16_OrderingType()
{}

tU32 sds_fi_tcl_e16_OrderingType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e16_OrderingType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e16_OrderingType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e16_SpeechAppDictType::sds_fi_tcl_e16_SpeechAppDictType():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e16_SpeechAppDictType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E16_SPEECHAPPDICTTYPE;
}


sds_fi_tcl_e16_SpeechAppDictType::~sds_fi_tcl_e16_SpeechAppDictType()
{}

tU32 sds_fi_tcl_e16_SpeechAppDictType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e16_SpeechAppDictType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e16_SpeechAppDictType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_PPJobStatus::sds_fi_tcl_e8_PPJobStatus():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_PPJobStatus::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_PPJOBSTATUS;
}


sds_fi_tcl_e8_PPJobStatus::~sds_fi_tcl_e8_PPJobStatus()
{}

tU32 sds_fi_tcl_e8_PPJobStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_PPJobStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_PPJobStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_DlgAppID::sds_fi_tcl_e8_DlgAppID():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_DlgAppID::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_DLGAPPID;
}


sds_fi_tcl_e8_DlgAppID::~sds_fi_tcl_e8_DlgAppID()
{}

tU32 sds_fi_tcl_e8_DlgAppID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_DlgAppID::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_DlgAppID::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_PromptLength::sds_fi_tcl_e8_PromptLength():enType(FI_EN_LONG) {}

tS32 sds_fi_tcl_e8_PromptLength::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_PROMPTLENGTH;
}


sds_fi_tcl_e8_PromptLength::~sds_fi_tcl_e8_PromptLength()
{}

tU32 sds_fi_tcl_e8_PromptLength::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_PromptLength::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_PromptLength::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_PromptListStatus::sds_fi_tcl_PromptListStatus(const sds_fi_tcl_PromptListStatus& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   FlagName = coRef.FlagName;
   FlagValue = coRef.FlagValue;
}
sds_fi_tcl_PromptListStatus& sds_fi_tcl_PromptListStatus::operator=(const sds_fi_tcl_PromptListStatus& coRef)
{
   if (this == &coRef) return *this;
   FlagName = coRef.FlagName;
   FlagValue = coRef.FlagValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_PromptListStatus::vDestroy()
{
   FlagName.vDestroy();
}

sds_fi_tcl_PromptListStatus::sds_fi_tcl_PromptListStatus()
:FlagName()
,FlagValue(0)
 {}

tS32 sds_fi_tcl_PromptListStatus::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_PROMPTLISTSTATUS;
}


sds_fi_tcl_PromptListStatus::~sds_fi_tcl_PromptListStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_PromptListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+FlagName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_PromptListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FlagName);
   (tVoid) (oIn >> FlagValue);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_PromptListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FlagName);
   (tVoid) (oOut << FlagValue);
   return oOut;
}

tBool sds_fi_tcl_PromptListStatus::operator==(const sds_fi_tcl_PromptListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FlagName == roRef.FlagName);
   bResult = bResult && (FlagValue == roRef.FlagValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_PhraseVariable::sds_fi_tcl_PhraseVariable(const sds_fi_tcl_PhraseVariable& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   VarText = coRef.VarText;
   VarType = coRef.VarType;
   TTSDictionaryType = coRef.TTSDictionaryType;
   DictCountryID = coRef.DictCountryID;
   DictCountryName = coRef.DictCountryName;
   VarAdditionalInfo  = coRef.VarAdditionalInfo ;
   TTSLanguageID = coRef.TTSLanguageID;
}
sds_fi_tcl_PhraseVariable& sds_fi_tcl_PhraseVariable::operator=(const sds_fi_tcl_PhraseVariable& coRef)
{
   if (this == &coRef) return *this;
   VarText = coRef.VarText;
   VarType = coRef.VarType;
   TTSDictionaryType = coRef.TTSDictionaryType;
   DictCountryID = coRef.DictCountryID;
   DictCountryName = coRef.DictCountryName;
   VarAdditionalInfo  = coRef.VarAdditionalInfo ;
   TTSLanguageID = coRef.TTSLanguageID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_PhraseVariable::vDestroy()
{
   VarText.vDestroy();
   DictCountryName.vDestroy();
   VarAdditionalInfo .vDestroy();
   TTSLanguageID.vDestroy(); 
}

sds_fi_tcl_PhraseVariable::sds_fi_tcl_PhraseVariable()
:VarText()
,VarType()
,TTSDictionaryType(0)
,DictCountryID()
,DictCountryName()
,VarAdditionalInfo ()
,TTSLanguageID()
 {}

tS32 sds_fi_tcl_PhraseVariable::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_PHRASEVARIABLE;
}


sds_fi_tcl_PhraseVariable::~sds_fi_tcl_PhraseVariable()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_PhraseVariable::u32GetSize(tU16 u16MajorVersion) const
{
   return 9+VarText.u32GetSize(u16MajorVersion)+DictCountryName.u32GetSize(u16MajorVersion)+VarAdditionalInfo .u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_PhraseVariable::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VarText);
   (tVoid) (oIn >> VarType);
   (tVoid) (oIn >> TTSDictionaryType);
   (tVoid) (oIn >> DictCountryID);
   (tVoid) (oIn >> DictCountryName);
   (tVoid) (oIn >> VarAdditionalInfo );
   (tVoid) (oIn >> TTSLanguageID);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_PhraseVariable::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VarText);
   (tVoid) (oOut << VarType);
   (tVoid) (oOut << TTSDictionaryType);
   (tVoid) (oOut << DictCountryID);
   (tVoid) (oOut << DictCountryName);
   (tVoid) (oOut << VarAdditionalInfo );
   (tVoid) (oOut << TTSLanguageID);
   return oOut;
}

tBool sds_fi_tcl_PhraseVariable::operator==(const sds_fi_tcl_PhraseVariable& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VarText == roRef.VarText);
   bResult = bResult && (VarType == roRef.VarType);
   bResult = bResult && (TTSDictionaryType == roRef.TTSDictionaryType);
   bResult = bResult && (DictCountryID == roRef.DictCountryID);
   bResult = bResult && (DictCountryName == roRef.DictCountryName);
   bResult = bResult && (VarAdditionalInfo  == roRef.VarAdditionalInfo );
   bResult = bResult && (TTSLanguageID == roRef.TTSLanguageID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_PlayProgress::sds_fi_tcl_PlayProgress(const sds_fi_tcl_PlayProgress& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   MarkerValue = coRef.MarkerValue;
   PPJobStatus = coRef.PPJobStatus;
}
sds_fi_tcl_PlayProgress& sds_fi_tcl_PlayProgress::operator=(const sds_fi_tcl_PlayProgress& coRef)
{
   if (this == &coRef) return *this;
   MarkerValue = coRef.MarkerValue;
   PPJobStatus = coRef.PPJobStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_PlayProgress::vDestroy()
{
   MarkerValue.vDestroy();
}

sds_fi_tcl_PlayProgress::sds_fi_tcl_PlayProgress()
:MarkerValue()
,PPJobStatus()
 {}

tS32 sds_fi_tcl_PlayProgress::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_PLAYPROGRESS;
}


sds_fi_tcl_PlayProgress::~sds_fi_tcl_PlayProgress()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_PlayProgress::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+MarkerValue.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_PlayProgress::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MarkerValue);
   (tVoid) (oIn >> PPJobStatus);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_PlayProgress::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MarkerValue);
   (tVoid) (oOut << PPJobStatus);
   return oOut;
}

tBool sds_fi_tcl_PlayProgress::operator==(const sds_fi_tcl_PlayProgress& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MarkerValue == roRef.MarkerValue);
   bResult = bResult && (PPJobStatus == roRef.PPJobStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_SD_Format::sds_fi_tcl_e8_SD_Format():enType(FI_EN_TYPE_OKI_ADPCM) {}

tS32 sds_fi_tcl_e8_SD_Format::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_SD_FORMAT;
}


sds_fi_tcl_e8_SD_Format::~sds_fi_tcl_e8_SD_Format()
{}

tU32 sds_fi_tcl_e8_SD_Format::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_SD_Format::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_SD_Format::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_u16_SD_SampleFrequency::sds_fi_tcl_u16_SD_SampleFrequency(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 sds_fi_tcl_u16_SD_SampleFrequency::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_U16_SD_SAMPLEFREQUENCY;
}


sds_fi_tcl_u16_SD_SampleFrequency::~sds_fi_tcl_u16_SD_SampleFrequency()
{}

tU32 sds_fi_tcl_u16_SD_SampleFrequency::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_fi_tcl_u16_SD_SampleFrequency::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& sds_fi_tcl_u16_SD_SampleFrequency::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_SD_Settings::sds_fi_tcl_SD_Settings(const sds_fi_tcl_SD_Settings& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   SpeechDataFormat = coRef.SpeechDataFormat;
   SampleFrequency = coRef.SampleFrequency;
   Resolution = coRef.Resolution;
   Mono = coRef.Mono;
}
sds_fi_tcl_SD_Settings& sds_fi_tcl_SD_Settings::operator=(const sds_fi_tcl_SD_Settings& coRef)
{
   if (this == &coRef) return *this;
   SpeechDataFormat = coRef.SpeechDataFormat;
   SampleFrequency = coRef.SampleFrequency;
   Resolution = coRef.Resolution;
   Mono = coRef.Mono;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_SD_Settings::sds_fi_tcl_SD_Settings()
:SpeechDataFormat()
,SampleFrequency()
,Resolution(0)
,Mono(0)
 {}

tS32 sds_fi_tcl_SD_Settings::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_SD_SETTINGS;
}


sds_fi_tcl_SD_Settings::~sds_fi_tcl_SD_Settings()
{}

tU32 sds_fi_tcl_SD_Settings::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds_fi_tcl_SD_Settings::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SpeechDataFormat);
   (tVoid) (oIn >> SampleFrequency);
   (tVoid) (oIn >> Resolution);
   (tVoid) (oIn >> Mono);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_SD_Settings::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SpeechDataFormat);
   (tVoid) (oOut << SampleFrequency);
   (tVoid) (oOut << Resolution);
   (tVoid) (oOut << Mono);
   return oOut;
}

tBool sds_fi_tcl_SD_Settings::operator==(const sds_fi_tcl_SD_Settings& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SpeechDataFormat == roRef.SpeechDataFormat);
   bResult = bResult && (SampleFrequency == roRef.SampleFrequency);
   bResult = bResult && (Resolution == roRef.Resolution);
   bResult = bResult && (Mono == roRef.Mono);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_AudioMode::sds_fi_tcl_e8_AudioMode():enType(FI_EN_STARTOUTPUT) {}

tS32 sds_fi_tcl_e8_AudioMode::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_AUDIOMODE;
}


sds_fi_tcl_e8_AudioMode::~sds_fi_tcl_e8_AudioMode()
{}

tU32 sds_fi_tcl_e8_AudioMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_AudioMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_AudioMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_SDSTestCase::sds_fi_tcl_e8_SDSTestCase():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_SDSTestCase::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_SDSTESTCASE;
}


sds_fi_tcl_e8_SDSTestCase::~sds_fi_tcl_e8_SDSTestCase()
{}

tU32 sds_fi_tcl_e8_SDSTestCase::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_SDSTestCase::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_SDSTestCase::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_PushButtonOption::sds_fi_tcl_e8_PushButtonOption():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_PushButtonOption::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_PUSHBUTTONOPTION;
}


sds_fi_tcl_e8_PushButtonOption::~sds_fi_tcl_e8_PushButtonOption()
{}

tU32 sds_fi_tcl_e8_PushButtonOption::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_PushButtonOption::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_PushButtonOption::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_Application::sds_fi_tcl_e8_Application():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_Application::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_APPLICATION;
}


sds_fi_tcl_e8_Application::~sds_fi_tcl_e8_Application()
{}

tU32 sds_fi_tcl_e8_Application::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_Application::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_Application::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_ListeningStatus::sds_fi_tcl_e8_ListeningStatus():enType(FI_EN_NONE) {}

tS32 sds_fi_tcl_e8_ListeningStatus::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_LISTENINGSTATUS;
}


sds_fi_tcl_e8_ListeningStatus::~sds_fi_tcl_e8_ListeningStatus()
{}

tU32 sds_fi_tcl_e8_ListeningStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_ListeningStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_ListeningStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_PopUp_UpdateType::sds_fi_tcl_e8_PopUp_UpdateType():enType(FI_EN_UPDATE_ALL) {}

tS32 sds_fi_tcl_e8_PopUp_UpdateType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_POPUP_UPDATETYPE;
}


sds_fi_tcl_e8_PopUp_UpdateType::~sds_fi_tcl_e8_PopUp_UpdateType()
{}

tU32 sds_fi_tcl_e8_PopUp_UpdateType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_PopUp_UpdateType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_PopUp_UpdateType::oWrite(fi_tclOutContext& oOut) const
{
   sds_fi_tcl_e8_PopUp_UpdateType::tenType enData = enType;
   if ((enData == FI_EN_UPDATE_LIST_NEXT) && !(1 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_UPDATE_ALL;
   }
   if ((enData == FI_EN_UPDATE_LIST_PREV) && !(1 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_UPDATE_ALL;
   }
   return oOut.oWrite((tU8)enData);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_GEN_SelectionType::sds_fi_tcl_e8_GEN_SelectionType():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_GEN_SelectionType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_GEN_SELECTIONTYPE;
}


sds_fi_tcl_e8_GEN_SelectionType::~sds_fi_tcl_e8_GEN_SelectionType()
{}

tU32 sds_fi_tcl_e8_GEN_SelectionType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_GEN_SelectionType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_GEN_SelectionType::oWrite(fi_tclOutContext& oOut) const
{
   sds_fi_tcl_e8_GEN_SelectionType::tenType enData = enType;
   if ((enData == FI_EN_BYTRACK) && !(1 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_UNKNOWN;
   }
   return oOut.oWrite((tU8)enData);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_TUN_Status::sds_fi_tcl_e8_TUN_Status():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_TUN_Status::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_TUN_STATUS;
}


sds_fi_tcl_e8_TUN_Status::~sds_fi_tcl_e8_TUN_Status()
{}

tU32 sds_fi_tcl_e8_TUN_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_TUN_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_TUN_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_TUN_Band::sds_fi_tcl_e8_TUN_Band():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_TUN_Band::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_TUN_BAND;
}


sds_fi_tcl_e8_TUN_Band::~sds_fi_tcl_e8_TUN_Band()
{}

tU32 sds_fi_tcl_e8_TUN_Band::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_TUN_Band::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_TUN_Band::oWrite(fi_tclOutContext& oOut) const
{
   sds_fi_tcl_e8_TUN_Band::tenType enData = enType;
   if ((enData == FI_EN_XM) && !(1 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_FM;
   }
   if ((enData == FI_EN_DAB) && !(1 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_FM;
   }
   return oOut.oWrite((tU8)enData);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_TUN_MemBank::sds_fi_tcl_e8_TUN_MemBank():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_TUN_MemBank::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_TUN_MEMBANK;
}


sds_fi_tcl_e8_TUN_MemBank::~sds_fi_tcl_e8_TUN_MemBank()
{}

tU32 sds_fi_tcl_e8_TUN_MemBank::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_TUN_MemBank::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_TUN_MemBank::oWrite(fi_tclOutContext& oOut) const
{
   sds_fi_tcl_e8_TUN_MemBank::tenType enData = enType;
   if ((enData == FI_EN_BANK_10) && !(1 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_UNKNOWN;
   }
   if ((enData == FI_EN_BANK_9) && !(1 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_UNKNOWN;
   }
   if ((enData == FI_EN_BANK_8) && !(1 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_UNKNOWN;
   }
   if ((enData == FI_EN_BANK_7) && !(1 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_UNKNOWN;
   }
   return oOut.oWrite((tU8)enData);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_TUN_Setting::sds_fi_tcl_e8_TUN_Setting():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_TUN_Setting::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_TUN_SETTING;
}


sds_fi_tcl_e8_TUN_Setting::~sds_fi_tcl_e8_TUN_Setting()
{}

tU32 sds_fi_tcl_e8_TUN_Setting::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_TUN_Setting::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_TUN_Setting::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_PHN_Status::sds_fi_tcl_e8_PHN_Status():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_PHN_Status::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_PHN_STATUS;
}


sds_fi_tcl_e8_PHN_Status::~sds_fi_tcl_e8_PHN_Status()
{}

tU32 sds_fi_tcl_e8_PHN_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_PHN_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_PHN_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_PHN_HWType::sds_fi_tcl_e8_PHN_HWType():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_PHN_HWType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_PHN_HWTYPE;
}


sds_fi_tcl_e8_PHN_HWType::~sds_fi_tcl_e8_PHN_HWType()
{}

tU32 sds_fi_tcl_e8_PHN_HWType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_PHN_HWType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_PHN_HWType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_PHN_MenuType::sds_fi_tcl_e8_PHN_MenuType():enType(FI_EN_OTHER) {}

tS32 sds_fi_tcl_e8_PHN_MenuType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_PHN_MENUTYPE;
}


sds_fi_tcl_e8_PHN_MenuType::~sds_fi_tcl_e8_PHN_MenuType()
{}

tU32 sds_fi_tcl_e8_PHN_MenuType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_PHN_MenuType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_PHN_MenuType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_PHN_Setting::sds_fi_tcl_e8_PHN_Setting():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_PHN_Setting::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_PHN_SETTING;
}


sds_fi_tcl_e8_PHN_Setting::~sds_fi_tcl_e8_PHN_Setting()
{}

tU32 sds_fi_tcl_e8_PHN_Setting::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_PHN_Setting::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_PHN_Setting::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_PHN_ListType::sds_fi_tcl_e8_PHN_ListType():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_PHN_ListType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_PHN_LISTTYPE;
}


sds_fi_tcl_e8_PHN_ListType::~sds_fi_tcl_e8_PHN_ListType()
{}

tU32 sds_fi_tcl_e8_PHN_ListType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_PHN_ListType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_PHN_ListType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_PHN_NumberType::sds_fi_tcl_e8_PHN_NumberType():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_PHN_NumberType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_PHN_NUMBERTYPE;
}


sds_fi_tcl_e8_PHN_NumberType::~sds_fi_tcl_e8_PHN_NumberType()
{}

tU32 sds_fi_tcl_e8_PHN_NumberType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_PHN_NumberType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_PHN_NumberType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_NAV_Status::sds_fi_tcl_e8_NAV_Status():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_NAV_Status::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_NAV_STATUS;
}


sds_fi_tcl_e8_NAV_Status::~sds_fi_tcl_e8_NAV_Status()
{}

tU32 sds_fi_tcl_e8_NAV_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_NAV_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_NAV_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_NAV_MenuType::sds_fi_tcl_e8_NAV_MenuType():enType(FI_EN_OTHER) {}

tS32 sds_fi_tcl_e8_NAV_MenuType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_NAV_MENUTYPE;
}


sds_fi_tcl_e8_NAV_MenuType::~sds_fi_tcl_e8_NAV_MenuType()
{}

tU32 sds_fi_tcl_e8_NAV_MenuType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_NAV_MenuType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_NAV_MenuType::oWrite(fi_tclOutContext& oOut) const
{
   sds_fi_tcl_e8_NAV_MenuType::tenType enData = enType;
   if ((enData == FI_EN_ENTER_USERWORD) && !(1 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_NAV_MAIN;
   }
   return oOut.oWrite((tU8)enData);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_NAV_NavUnit::sds_fi_tcl_e8_NAV_NavUnit():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_NAV_NavUnit::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_NAV_NAVUNIT;
}


sds_fi_tcl_e8_NAV_NavUnit::~sds_fi_tcl_e8_NAV_NavUnit()
{}

tU32 sds_fi_tcl_e8_NAV_NavUnit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_NAV_NavUnit::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_NAV_NavUnit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_NAV_ZoomLevel::sds_fi_tcl_e8_NAV_ZoomLevel():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_NAV_ZoomLevel::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_NAV_ZOOMLEVEL;
}


sds_fi_tcl_e8_NAV_ZoomLevel::~sds_fi_tcl_e8_NAV_ZoomLevel()
{}

tU32 sds_fi_tcl_e8_NAV_ZoomLevel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_NAV_ZoomLevel::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_NAV_ZoomLevel::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_NAV_RouteCriteria::sds_fi_tcl_e8_NAV_RouteCriteria():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_NAV_RouteCriteria::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_NAV_ROUTECRITERIA;
}


sds_fi_tcl_e8_NAV_RouteCriteria::~sds_fi_tcl_e8_NAV_RouteCriteria()
{}

tU32 sds_fi_tcl_e8_NAV_RouteCriteria::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_NAV_RouteCriteria::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_NAV_RouteCriteria::oWrite(fi_tclOutContext& oOut) const
{
   sds_fi_tcl_e8_NAV_RouteCriteria::tenType enData = enType;
   if ((enData == FI_EN_AVOID_TRUCKUNSAFEROADS) && !(1 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_AVOID_HIGHWAYS;
   }
   if ((enData == FI_EN_USE_TRUCKUNSAFEROADS) && !(1 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_USE_HIGHWAYS;
   }
   if ((enData == FI_EN_AVOID_AUTOTRAIN) && !(1 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_AVOID_FERRY;
   }
   if ((enData == FI_EN_USE_AUTOTRAIN) && !(1 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_USE_FERRY;
   }
   if ((enData == FI_EN_USE_ECONOMIC_ROUTE) && !(1 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_USE_FAST_ROUTE;
   }
   if ((enData == FI_EN_USE_ECOLOGIC_ROUTE) && !(1 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_USE_FAST_ROUTE;
   }
   return oOut.oWrite((tU8)enData);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_NAV_Setting::sds_fi_tcl_e8_NAV_Setting():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_NAV_Setting::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_NAV_SETTING;
}


sds_fi_tcl_e8_NAV_Setting::~sds_fi_tcl_e8_NAV_Setting()
{}

tU32 sds_fi_tcl_e8_NAV_Setting::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_NAV_Setting::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_NAV_Setting::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_NAV_MapMode::sds_fi_tcl_e8_NAV_MapMode():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_NAV_MapMode::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_NAV_MAPMODE;
}


sds_fi_tcl_e8_NAV_MapMode::~sds_fi_tcl_e8_NAV_MapMode()
{}

tU32 sds_fi_tcl_e8_NAV_MapMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_NAV_MapMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_NAV_MapMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_NAV_ListType::sds_fi_tcl_e8_NAV_ListType():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_NAV_ListType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_NAV_LISTTYPE;
}


sds_fi_tcl_e8_NAV_ListType::~sds_fi_tcl_e8_NAV_ListType()
{}

tU32 sds_fi_tcl_e8_NAV_ListType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_NAV_ListType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_NAV_ListType::oWrite(fi_tclOutContext& oOut) const
{
   sds_fi_tcl_e8_NAV_ListType::tenType enData = enType;
   if ((enData == FI_EN_HOME_DEST) && !(1 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_PERSISTANT_DEST;
   }
   return oOut.oWrite((tU8)enData);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_CDA_Slot::sds_fi_tcl_e8_CDA_Slot():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_CDA_Slot::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_CDA_SLOT;
}


sds_fi_tcl_e8_CDA_Slot::~sds_fi_tcl_e8_CDA_Slot()
{}

tU32 sds_fi_tcl_e8_CDA_Slot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_CDA_Slot::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_CDA_Slot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_ProgressInfo::sds_fi_tcl_e8_ProgressInfo():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_ProgressInfo::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_PROGRESSINFO;
}


sds_fi_tcl_e8_ProgressInfo::~sds_fi_tcl_e8_ProgressInfo()
{}

tU32 sds_fi_tcl_e8_ProgressInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_ProgressInfo::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_ProgressInfo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_VoiceControlStatus::sds_fi_tcl_e8_VoiceControlStatus():enType(FI_EN_VOICECONTROLDOWNLOADACTIVE) {}

tS32 sds_fi_tcl_e8_VoiceControlStatus::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_VOICECONTROLSTATUS;
}


sds_fi_tcl_e8_VoiceControlStatus::~sds_fi_tcl_e8_VoiceControlStatus()
{}

tU32 sds_fi_tcl_e8_VoiceControlStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_VoiceControlStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_VoiceControlStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_Sentence::sds_fi_tcl_e8_Sentence():enType(FI_EN_RESERVED) {}

tS32 sds_fi_tcl_e8_Sentence::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_SENTENCE;
}


sds_fi_tcl_e8_Sentence::~sds_fi_tcl_e8_Sentence()
{}

tU32 sds_fi_tcl_e8_Sentence::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_Sentence::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_Sentence::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_Userword::sds_fi_tcl_Userword(const sds_fi_tcl_Userword& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   UWProfile = coRef.UWProfile;
   LanguageID = coRef.LanguageID;
   PhoneUWs = coRef.PhoneUWs;
   TunerUWs = coRef.TunerUWs;
   NaviUWs = coRef.NaviUWs;
}
sds_fi_tcl_Userword& sds_fi_tcl_Userword::operator=(const sds_fi_tcl_Userword& coRef)
{
   if (this == &coRef) return *this;
   UWProfile = coRef.UWProfile;
   LanguageID = coRef.LanguageID;
   PhoneUWs = coRef.PhoneUWs;
   TunerUWs = coRef.TunerUWs;
   NaviUWs = coRef.NaviUWs;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_Userword::vDestroy()
{
   LanguageID.vDestroy(); 
   {
   PhoneUWs.clear();
   }
   {
   TunerUWs.clear();
   }
   {
   NaviUWs.clear();
   }
}

sds_fi_tcl_Userword::sds_fi_tcl_Userword()
:UWProfile(0)
,LanguageID()



 {}

tS32 sds_fi_tcl_Userword::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_USERWORD;
}


sds_fi_tcl_Userword::~sds_fi_tcl_Userword()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_Userword::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 20+PhoneUWs.size()*4+TunerUWs.size()*4+NaviUWs.size()*4;
}

fi_tclInContext& sds_fi_tcl_Userword::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> UWProfile);
   (tVoid) (oIn >> LanguageID);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      PhoneUWs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PhoneUWs[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      TunerUWs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TunerUWs[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      NaviUWs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> NaviUWs[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_Userword::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << UWProfile);
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << (tU32)PhoneUWs.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PhoneUWs.size(); ++u32Idx)
         (tVoid) (oOut << PhoneUWs[u32Idx]);
   }
   (tVoid) (oOut << (tU32)TunerUWs.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TunerUWs.size(); ++u32Idx)
         (tVoid) (oOut << TunerUWs[u32Idx]);
   }
   (tVoid) (oOut << (tU32)NaviUWs.size());
   {
      for (tU32 u32Idx = 0; u32Idx < NaviUWs.size(); ++u32Idx)
         (tVoid) (oOut << NaviUWs[u32Idx]);
   }
   return oOut;
}

tBool sds_fi_tcl_Userword::operator==(const sds_fi_tcl_Userword& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UWProfile == roRef.UWProfile);
   bResult = bResult && (LanguageID == roRef.LanguageID);
      bResult = bResult && (PhoneUWs.size() == roRef.PhoneUWs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PhoneUWs.size()); ++u32Idx)
            bResult = bResult && (PhoneUWs[u32Idx] == roRef.PhoneUWs[u32Idx]);
      }
      bResult = bResult && (TunerUWs.size() == roRef.TunerUWs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TunerUWs.size()); ++u32Idx)
            bResult = bResult && (TunerUWs[u32Idx] == roRef.TunerUWs[u32Idx]);
      }
      bResult = bResult && (NaviUWs.size() == roRef.NaviUWs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < NaviUWs.size()); ++u32Idx)
            bResult = bResult && (NaviUWs[u32Idx] == roRef.NaviUWs[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_Progress::sds_fi_tcl_Progress(const sds_fi_tcl_Progress& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   ProgressInfo = coRef.ProgressInfo;
   u16ProgressRate = coRef.u16ProgressRate;
}
sds_fi_tcl_Progress& sds_fi_tcl_Progress::operator=(const sds_fi_tcl_Progress& coRef)
{
   if (this == &coRef) return *this;
   ProgressInfo = coRef.ProgressInfo;
   u16ProgressRate = coRef.u16ProgressRate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_Progress::sds_fi_tcl_Progress()
:ProgressInfo()
,u16ProgressRate(0)
 {}

tS32 sds_fi_tcl_Progress::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_PROGRESS;
}


sds_fi_tcl_Progress::~sds_fi_tcl_Progress()
{}

tU32 sds_fi_tcl_Progress::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& sds_fi_tcl_Progress::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ProgressInfo);
   (tVoid) (oIn >> u16ProgressRate);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_Progress::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ProgressInfo);
   (tVoid) (oOut << u16ProgressRate);
   return oOut;
}

tBool sds_fi_tcl_Progress::operator==(const sds_fi_tcl_Progress& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ProgressInfo == roRef.ProgressInfo);
   bResult = bResult && (u16ProgressRate == roRef.u16ProgressRate);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_VR_Speaker::sds_fi_tcl_VR_Speaker(const sds_fi_tcl_VR_Speaker& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   VoiceName = coRef.VoiceName;
   VoiceGender = coRef.VoiceGender;
   StorageDevice = coRef.StorageDevice;
}
sds_fi_tcl_VR_Speaker& sds_fi_tcl_VR_Speaker::operator=(const sds_fi_tcl_VR_Speaker& coRef)
{
   if (this == &coRef) return *this;
   VoiceName = coRef.VoiceName;
   VoiceGender = coRef.VoiceGender;
   StorageDevice = coRef.StorageDevice;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_VR_Speaker::vDestroy()
{
   VoiceName.vDestroy();
}

sds_fi_tcl_VR_Speaker::sds_fi_tcl_VR_Speaker()
:VoiceName()
,VoiceGender()
,StorageDevice()
 {}

tS32 sds_fi_tcl_VR_Speaker::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_VR_SPEAKER;
}


sds_fi_tcl_VR_Speaker::~sds_fi_tcl_VR_Speaker()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_VR_Speaker::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+VoiceName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_VR_Speaker::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VoiceName);
   (tVoid) (oIn >> VoiceGender);
   (tVoid) (oIn >> StorageDevice);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_VR_Speaker::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VoiceName);
   (tVoid) (oOut << VoiceGender);
   (tVoid) (oOut << StorageDevice);
   return oOut;
}

tBool sds_fi_tcl_VR_Speaker::operator==(const sds_fi_tcl_VR_Speaker& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VoiceName == roRef.VoiceName);
   bResult = bResult && (VoiceGender == roRef.VoiceGender);
   bResult = bResult && (StorageDevice == roRef.StorageDevice);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_LanguageAndSpeaker::sds_fi_tcl_LanguageAndSpeaker(const sds_fi_tcl_LanguageAndSpeaker& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   TTSVoices = coRef.TTSVoices;
   PromptSpeakers = coRef.PromptSpeakers;
   LanguageID = coRef.LanguageID;
   SpeakerID = coRef.SpeakerID;
}
sds_fi_tcl_LanguageAndSpeaker& sds_fi_tcl_LanguageAndSpeaker::operator=(const sds_fi_tcl_LanguageAndSpeaker& coRef)
{
   if (this == &coRef) return *this;
   TTSVoices = coRef.TTSVoices;
   PromptSpeakers = coRef.PromptSpeakers;
   LanguageID = coRef.LanguageID;
   SpeakerID = coRef.SpeakerID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_LanguageAndSpeaker::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TTSVoices.size(); ++u32Idx)
         TTSVoices[u32Idx].vDestroy();
   TTSVoices.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < PromptSpeakers.size(); ++u32Idx)
         PromptSpeakers[u32Idx].vDestroy();
   PromptSpeakers.clear();
   }
   LanguageID.vDestroy(); 
}

sds_fi_tcl_LanguageAndSpeaker::sds_fi_tcl_LanguageAndSpeaker()


:LanguageID()
,SpeakerID(0)
 {}

tS32 sds_fi_tcl_LanguageAndSpeaker::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_LANGUAGEANDSPEAKER;
}


sds_fi_tcl_LanguageAndSpeaker::~sds_fi_tcl_LanguageAndSpeaker()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_LanguageAndSpeaker::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TTSVoices.size(); ++u32ListIdx)
      u32DynamicSize += TTSVoices[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < PromptSpeakers.size(); ++u32ListIdx)
      u32DynamicSize += PromptSpeakers[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+14;
}

fi_tclInContext& sds_fi_tcl_LanguageAndSpeaker::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TTSVoices.size(); ++u32Idx)
      {
         TTSVoices[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TTSVoices.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TTSVoices[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PromptSpeakers.size(); ++u32Idx)
      {
         PromptSpeakers[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      PromptSpeakers.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PromptSpeakers[u32Idx]);
      }
   }
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> SpeakerID);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_LanguageAndSpeaker::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TTSVoices.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TTSVoices.size(); ++u32Idx)
         (tVoid) (oOut << TTSVoices[u32Idx]);
   }
   (tVoid) (oOut << (tU32)PromptSpeakers.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PromptSpeakers.size(); ++u32Idx)
         (tVoid) (oOut << PromptSpeakers[u32Idx]);
   }
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << SpeakerID);
   return oOut;
}

tBool sds_fi_tcl_LanguageAndSpeaker::operator==(const sds_fi_tcl_LanguageAndSpeaker& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TTSVoices.size() == roRef.TTSVoices.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TTSVoices.size()); ++u32Idx)
            bResult = bResult && (TTSVoices[u32Idx] == roRef.TTSVoices[u32Idx]);
      }
      bResult = bResult && (PromptSpeakers.size() == roRef.PromptSpeakers.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PromptSpeakers.size()); ++u32Idx)
            bResult = bResult && (PromptSpeakers[u32Idx] == roRef.PromptSpeakers[u32Idx]);
      }
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (SpeakerID == roRef.SpeakerID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_CountryType::sds_fi_tcl_CountryType(const sds_fi_tcl_CountryType& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   LanguageID = coRef.LanguageID;
   CountryType = coRef.CountryType;
   CountryCode = coRef.CountryCode;
   State = coRef.State;
}
sds_fi_tcl_CountryType& sds_fi_tcl_CountryType::operator=(const sds_fi_tcl_CountryType& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   CountryType = coRef.CountryType;
   CountryCode = coRef.CountryCode;
   State = coRef.State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_CountryType::vDestroy()
{
   LanguageID.vDestroy(); 
   State.vDestroy();
}

sds_fi_tcl_CountryType::sds_fi_tcl_CountryType()
:LanguageID()
,CountryType()
,CountryCode()
,State()
 {}

tS32 sds_fi_tcl_CountryType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_COUNTRYTYPE;
}


sds_fi_tcl_CountryType::~sds_fi_tcl_CountryType()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_CountryType::u32GetSize(tU16 u16MajorVersion) const
{
   return 7+State.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_CountryType::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> CountryType);
   (tVoid) (oIn >> CountryCode);
   (tVoid) (oIn >> State);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_CountryType::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << CountryType);
   (tVoid) (oOut << CountryCode);
   (tVoid) (oOut << State);
   return oOut;
}

tBool sds_fi_tcl_CountryType::operator==(const sds_fi_tcl_CountryType& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (CountryType == roRef.CountryType);
   bResult = bResult && (CountryCode == roRef.CountryCode);
   bResult = bResult && (State == roRef.State);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_HomeDestCountry::sds_fi_tcl_HomeDestCountry(const sds_fi_tcl_HomeDestCountry& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   HomeCountry = coRef.HomeCountry;
   DestCountry = coRef.DestCountry;
}
sds_fi_tcl_HomeDestCountry& sds_fi_tcl_HomeDestCountry::operator=(const sds_fi_tcl_HomeDestCountry& coRef)
{
   if (this == &coRef) return *this;
   HomeCountry = coRef.HomeCountry;
   DestCountry = coRef.DestCountry;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_HomeDestCountry::vDestroy()
{
   HomeCountry.vDestroy(); 
   DestCountry.vDestroy(); 
}

sds_fi_tcl_HomeDestCountry::sds_fi_tcl_HomeDestCountry()
:HomeCountry()
,DestCountry()
 {}

tS32 sds_fi_tcl_HomeDestCountry::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_HOMEDESTCOUNTRY;
}


sds_fi_tcl_HomeDestCountry::~sds_fi_tcl_HomeDestCountry()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_HomeDestCountry::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+HomeCountry.u32GetSize(u16MajorVersion)+DestCountry.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_HomeDestCountry::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> HomeCountry);
   (tVoid) (oIn >> DestCountry);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_HomeDestCountry::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << HomeCountry);
   (tVoid) (oOut << DestCountry);
   return oOut;
}

tBool sds_fi_tcl_HomeDestCountry::operator==(const sds_fi_tcl_HomeDestCountry& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (HomeCountry == roRef.HomeCountry);
   bResult = bResult && (DestCountry == roRef.DestCountry);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_DestEntry::sds_fi_tcl_DestEntry(const sds_fi_tcl_DestEntry& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   CountryName = coRef.CountryName;
   CityName = coRef.CityName;
   StreetName = coRef.StreetName;
   POIName = coRef.POIName;
   HouseNr = coRef.HouseNr;
   nUswID = coRef.nUswID;
   nDestListID = coRef.nDestListID;
}
sds_fi_tcl_DestEntry& sds_fi_tcl_DestEntry::operator=(const sds_fi_tcl_DestEntry& coRef)
{
   if (this == &coRef) return *this;
   CountryName = coRef.CountryName;
   CityName = coRef.CityName;
   StreetName = coRef.StreetName;
   POIName = coRef.POIName;
   HouseNr = coRef.HouseNr;
   nUswID = coRef.nUswID;
   nDestListID = coRef.nDestListID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_DestEntry::vDestroy()
{
   CountryName.vDestroy();
   CityName.vDestroy();
   StreetName.vDestroy();
   POIName.vDestroy();
   HouseNr.vDestroy();
}

sds_fi_tcl_DestEntry::sds_fi_tcl_DestEntry()
:CountryName()
,CityName()
,StreetName()
,POIName()
,HouseNr()
,nUswID(0)
,nDestListID(0)
 {}

tS32 sds_fi_tcl_DestEntry::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_DESTENTRY;
}


sds_fi_tcl_DestEntry::~sds_fi_tcl_DestEntry()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_DestEntry::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+CountryName.u32GetSize(u16MajorVersion)+CityName.u32GetSize(u16MajorVersion)+StreetName.u32GetSize(u16MajorVersion)+POIName.u32GetSize(u16MajorVersion)+HouseNr.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_DestEntry::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CountryName);
   (tVoid) (oIn >> CityName);
   (tVoid) (oIn >> StreetName);
   (tVoid) (oIn >> POIName);
   (tVoid) (oIn >> HouseNr);
   (tVoid) (oIn >> nUswID);
   (tVoid) (oIn >> nDestListID);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_DestEntry::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CountryName);
   (tVoid) (oOut << CityName);
   (tVoid) (oOut << StreetName);
   (tVoid) (oOut << POIName);
   (tVoid) (oOut << HouseNr);
   (tVoid) (oOut << nUswID);
   (tVoid) (oOut << nDestListID);
   return oOut;
}

tBool sds_fi_tcl_DestEntry::operator==(const sds_fi_tcl_DestEntry& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CountryName == roRef.CountryName);
   bResult = bResult && (CityName == roRef.CityName);
   bResult = bResult && (StreetName == roRef.StreetName);
   bResult = bResult && (POIName == roRef.POIName);
   bResult = bResult && (HouseNr == roRef.HouseNr);
   bResult = bResult && (nUswID == roRef.nUswID);
   bResult = bResult && (nDestListID == roRef.nDestListID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_PhoneEntry::sds_fi_tcl_PhoneEntry(const sds_fi_tcl_PhoneEntry& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   LastName = coRef.LastName;
   FirstName = coRef.FirstName;
   PhoneNumber = coRef.PhoneNumber;
   PhoneNumberType = coRef.PhoneNumberType;
   nUswID = coRef.nUswID;
   nUswListID = coRef.nUswListID;
   nPhnBookListID = coRef.nPhnBookListID;
}
sds_fi_tcl_PhoneEntry& sds_fi_tcl_PhoneEntry::operator=(const sds_fi_tcl_PhoneEntry& coRef)
{
   if (this == &coRef) return *this;
   LastName = coRef.LastName;
   FirstName = coRef.FirstName;
   PhoneNumber = coRef.PhoneNumber;
   PhoneNumberType = coRef.PhoneNumberType;
   nUswID = coRef.nUswID;
   nUswListID = coRef.nUswListID;
   nPhnBookListID = coRef.nPhnBookListID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_PhoneEntry::vDestroy()
{
   LastName.vDestroy();
   FirstName.vDestroy();
   PhoneNumber.vDestroy();
   PhoneNumberType.vDestroy();
}

sds_fi_tcl_PhoneEntry::sds_fi_tcl_PhoneEntry()
:LastName()
,FirstName()
,PhoneNumber()
,PhoneNumberType()
,nUswID(0)
,nUswListID(0)
,nPhnBookListID(0)
 {}

tS32 sds_fi_tcl_PhoneEntry::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_PHONEENTRY;
}


sds_fi_tcl_PhoneEntry::~sds_fi_tcl_PhoneEntry()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_PhoneEntry::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+LastName.u32GetSize(u16MajorVersion)+FirstName.u32GetSize(u16MajorVersion)+PhoneNumber.u32GetSize(u16MajorVersion)+PhoneNumberType.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_PhoneEntry::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LastName);
   (tVoid) (oIn >> FirstName);
   (tVoid) (oIn >> PhoneNumber);
   (tVoid) (oIn >> PhoneNumberType);
   (tVoid) (oIn >> nUswID);
   (tVoid) (oIn >> nUswListID);
   (tVoid) (oIn >> nPhnBookListID);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_PhoneEntry::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LastName);
   (tVoid) (oOut << FirstName);
   (tVoid) (oOut << PhoneNumber);
   (tVoid) (oOut << PhoneNumberType);
   (tVoid) (oOut << nUswID);
   (tVoid) (oOut << nUswListID);
   (tVoid) (oOut << nPhnBookListID);
   return oOut;
}

tBool sds_fi_tcl_PhoneEntry::operator==(const sds_fi_tcl_PhoneEntry& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LastName == roRef.LastName);
   bResult = bResult && (FirstName == roRef.FirstName);
   bResult = bResult && (PhoneNumber == roRef.PhoneNumber);
   bResult = bResult && (PhoneNumberType == roRef.PhoneNumberType);
   bResult = bResult && (nUswID == roRef.nUswID);
   bResult = bResult && (nUswListID == roRef.nUswListID);
   bResult = bResult && (nPhnBookListID == roRef.nPhnBookListID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_AudioChannelAdvice::sds_fi_tcl_e8_AudioChannelAdvice():enType(FI_EN_START) {}

tS32 sds_fi_tcl_e8_AudioChannelAdvice::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_AUDIOCHANNELADVICE;
}


sds_fi_tcl_e8_AudioChannelAdvice::~sds_fi_tcl_e8_AudioChannelAdvice()
{}

tU32 sds_fi_tcl_e8_AudioChannelAdvice::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_AudioChannelAdvice::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_AudioChannelAdvice::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_VoiceCategory::sds_fi_tcl_e8_VoiceCategory():enType(FI_EN_DRIVINGRECOMMENDATION) {}

tS32 sds_fi_tcl_e8_VoiceCategory::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_VOICECATEGORY;
}


sds_fi_tcl_e8_VoiceCategory::~sds_fi_tcl_e8_VoiceCategory()
{}

tU32 sds_fi_tcl_e8_VoiceCategory::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_VoiceCategory::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_VoiceCategory::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_CatStatus::sds_fi_tcl_e8_CatStatus():enType(FI_EN_SILENT) {}

tS32 sds_fi_tcl_e8_CatStatus::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_CATSTATUS;
}


sds_fi_tcl_e8_CatStatus::~sds_fi_tcl_e8_CatStatus()
{}

tU32 sds_fi_tcl_e8_CatStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_CatStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_CatStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_AudioChannelAdvice::sds_fi_tcl_AudioChannelAdvice(const sds_fi_tcl_AudioChannelAdvice& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   ChannelAdvice = coRef.ChannelAdvice;
   Index = coRef.Index;
   Device = coRef.Device;
}
sds_fi_tcl_AudioChannelAdvice& sds_fi_tcl_AudioChannelAdvice::operator=(const sds_fi_tcl_AudioChannelAdvice& coRef)
{
   if (this == &coRef) return *this;
   ChannelAdvice = coRef.ChannelAdvice;
   Index = coRef.Index;
   Device = coRef.Device;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_AudioChannelAdvice::vDestroy()
{
   Device.vDestroy();
}

sds_fi_tcl_AudioChannelAdvice::sds_fi_tcl_AudioChannelAdvice()
:ChannelAdvice()
,Index(0)
,Device()
 {}

tS32 sds_fi_tcl_AudioChannelAdvice::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_AUDIOCHANNELADVICE;
}


sds_fi_tcl_AudioChannelAdvice::~sds_fi_tcl_AudioChannelAdvice()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_AudioChannelAdvice::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+Device.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_AudioChannelAdvice::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ChannelAdvice);
   (tVoid) (oIn >> Index);
   (tVoid) (oIn >> Device);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_AudioChannelAdvice::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ChannelAdvice);
   (tVoid) (oOut << Index);
   (tVoid) (oOut << Device);
   return oOut;
}

tBool sds_fi_tcl_AudioChannelAdvice::operator==(const sds_fi_tcl_AudioChannelAdvice& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ChannelAdvice == roRef.ChannelAdvice);
   bResult = bResult && (Index == roRef.Index);
   bResult = bResult && (Device == roRef.Device);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_b8_AudioOutputLocation::sds_fi_tcl_b8_AudioOutputLocation():u8Value(0)
{}

tS32 sds_fi_tcl_b8_AudioOutputLocation::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_B8_AUDIOOUTPUTLOCATION;
}


sds_fi_tcl_b8_AudioOutputLocation::~sds_fi_tcl_b8_AudioOutputLocation()
{}

tU32 sds_fi_tcl_b8_AudioOutputLocation::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_b8_AudioOutputLocation::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& sds_fi_tcl_b8_AudioOutputLocation::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_b8_AudioFormat::sds_fi_tcl_b8_AudioFormat():u8Value(0)
{}

tS32 sds_fi_tcl_b8_AudioFormat::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_B8_AUDIOFORMAT;
}


sds_fi_tcl_b8_AudioFormat::~sds_fi_tcl_b8_AudioFormat()
{}

tU32 sds_fi_tcl_b8_AudioFormat::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_b8_AudioFormat::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& sds_fi_tcl_b8_AudioFormat::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_InstancesPerCategory::sds_fi_tcl_InstancesPerCategory(const sds_fi_tcl_InstancesPerCategory& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   VoiceCategory = coRef.VoiceCategory;
   NumberOfInstances = coRef.NumberOfInstances;
}
sds_fi_tcl_InstancesPerCategory& sds_fi_tcl_InstancesPerCategory::operator=(const sds_fi_tcl_InstancesPerCategory& coRef)
{
   if (this == &coRef) return *this;
   VoiceCategory = coRef.VoiceCategory;
   NumberOfInstances = coRef.NumberOfInstances;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_InstancesPerCategory::sds_fi_tcl_InstancesPerCategory()
:VoiceCategory()
,NumberOfInstances(0)
 {}

tS32 sds_fi_tcl_InstancesPerCategory::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_INSTANCESPERCATEGORY;
}


sds_fi_tcl_InstancesPerCategory::~sds_fi_tcl_InstancesPerCategory()
{}

tU32 sds_fi_tcl_InstancesPerCategory::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_fi_tcl_InstancesPerCategory::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VoiceCategory);
   (tVoid) (oIn >> NumberOfInstances);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_InstancesPerCategory::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VoiceCategory);
   (tVoid) (oOut << NumberOfInstances);
   return oOut;
}

tBool sds_fi_tcl_InstancesPerCategory::operator==(const sds_fi_tcl_InstancesPerCategory& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VoiceCategory == roRef.VoiceCategory);
   bResult = bResult && (NumberOfInstances == roRef.NumberOfInstances);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_InstancesPerCategoryList::sds_fi_tcl_InstancesPerCategoryList(const sds_fi_tcl_InstancesPerCategoryList& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   InstancesPerCategory = coRef.InstancesPerCategory;
   MaxAmountInstances = coRef.MaxAmountInstances;
}
sds_fi_tcl_InstancesPerCategoryList& sds_fi_tcl_InstancesPerCategoryList::operator=(const sds_fi_tcl_InstancesPerCategoryList& coRef)
{
   if (this == &coRef) return *this;
   InstancesPerCategory = coRef.InstancesPerCategory;
   MaxAmountInstances = coRef.MaxAmountInstances;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_InstancesPerCategoryList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < InstancesPerCategory.size(); ++u32Idx)
         InstancesPerCategory[u32Idx].vDestroy();
   InstancesPerCategory.clear();
   }
}

sds_fi_tcl_InstancesPerCategoryList::sds_fi_tcl_InstancesPerCategoryList()

:MaxAmountInstances(0)
 {}

tS32 sds_fi_tcl_InstancesPerCategoryList::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_INSTANCESPERCATEGORYLIST;
}


sds_fi_tcl_InstancesPerCategoryList::~sds_fi_tcl_InstancesPerCategoryList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_InstancesPerCategoryList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+InstancesPerCategory.size()*2;
}

fi_tclInContext& sds_fi_tcl_InstancesPerCategoryList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < InstancesPerCategory.size(); ++u32Idx)
      {
         InstancesPerCategory[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      InstancesPerCategory.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> InstancesPerCategory[u32Idx]);
      }
   }
   (tVoid) (oIn >> MaxAmountInstances);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_InstancesPerCategoryList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)InstancesPerCategory.size());
   {
      for (tU32 u32Idx = 0; u32Idx < InstancesPerCategory.size(); ++u32Idx)
         (tVoid) (oOut << InstancesPerCategory[u32Idx]);
   }
   (tVoid) (oOut << MaxAmountInstances);
   return oOut;
}

tBool sds_fi_tcl_InstancesPerCategoryList::operator==(const sds_fi_tcl_InstancesPerCategoryList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (InstancesPerCategory.size() == roRef.InstancesPerCategory.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < InstancesPerCategory.size()); ++u32Idx)
            bResult = bResult && (InstancesPerCategory[u32Idx] == roRef.InstancesPerCategory[u32Idx]);
      }
   bResult = bResult && (MaxAmountInstances == roRef.MaxAmountInstances);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_b16_RequestAddInfo::sds_fi_tcl_b16_RequestAddInfo():u16Value(0)
{}

tS32 sds_fi_tcl_b16_RequestAddInfo::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_B16_REQUESTADDINFO;
}


sds_fi_tcl_b16_RequestAddInfo::~sds_fi_tcl_b16_RequestAddInfo()
{}

tU32 sds_fi_tcl_b16_RequestAddInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_fi_tcl_b16_RequestAddInfo::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& sds_fi_tcl_b16_RequestAddInfo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_ChannelRequestStatus::sds_fi_tcl_ChannelRequestStatus(const sds_fi_tcl_ChannelRequestStatus& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   Category = coRef.Category;
   Index = coRef.Index;
   Status = coRef.Status;
   AudioFormat = coRef.AudioFormat;
   AudioOutputLocation = coRef.AudioOutputLocation;
   RequestAddInfo = coRef.RequestAddInfo;
}
sds_fi_tcl_ChannelRequestStatus& sds_fi_tcl_ChannelRequestStatus::operator=(const sds_fi_tcl_ChannelRequestStatus& coRef)
{
   if (this == &coRef) return *this;
   Category = coRef.Category;
   Index = coRef.Index;
   Status = coRef.Status;
   AudioFormat = coRef.AudioFormat;
   AudioOutputLocation = coRef.AudioOutputLocation;
   RequestAddInfo = coRef.RequestAddInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_ChannelRequestStatus::sds_fi_tcl_ChannelRequestStatus()
:Category()
,Index(0)
,Status()
,AudioFormat()
,AudioOutputLocation()
,RequestAddInfo()
 {}

tS32 sds_fi_tcl_ChannelRequestStatus::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_CHANNELREQUESTSTATUS;
}


sds_fi_tcl_ChannelRequestStatus::~sds_fi_tcl_ChannelRequestStatus()
{}

tU32 sds_fi_tcl_ChannelRequestStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   return u32DynamicSize+5;
}

fi_tclInContext& sds_fi_tcl_ChannelRequestStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Category);
   (tVoid) (oIn >> Index);
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> AudioFormat);
   (tVoid) (oIn >> AudioOutputLocation);
   if (2 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> RequestAddInfo);
   }
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_ChannelRequestStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Category);
   (tVoid) (oOut << Index);
   (tVoid) (oOut << Status);
   (tVoid) (oOut << AudioFormat);
   (tVoid) (oOut << AudioOutputLocation);
   if (2 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << RequestAddInfo);
   }
   return oOut;
}

tBool sds_fi_tcl_ChannelRequestStatus::operator==(const sds_fi_tcl_ChannelRequestStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Category == roRef.Category);
   bResult = bResult && (Index == roRef.Index);
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (AudioFormat == roRef.AudioFormat);
   bResult = bResult && (AudioOutputLocation == roRef.AudioOutputLocation);
   bResult = bResult && (RequestAddInfo == roRef.RequestAddInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_ChannelRequestStatusList::sds_fi_tcl_ChannelRequestStatusList(const sds_fi_tcl_ChannelRequestStatusList& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   ChannelRequestStatusList = coRef.ChannelRequestStatusList;
}
sds_fi_tcl_ChannelRequestStatusList& sds_fi_tcl_ChannelRequestStatusList::operator=(const sds_fi_tcl_ChannelRequestStatusList& coRef)
{
   if (this == &coRef) return *this;
   ChannelRequestStatusList = coRef.ChannelRequestStatusList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_ChannelRequestStatusList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ChannelRequestStatusList.size(); ++u32Idx)
         ChannelRequestStatusList[u32Idx].vDestroy();
   ChannelRequestStatusList.clear();
   }
}

sds_fi_tcl_ChannelRequestStatusList::sds_fi_tcl_ChannelRequestStatusList()

 {}

tS32 sds_fi_tcl_ChannelRequestStatusList::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_CHANNELREQUESTSTATUSLIST;
}


sds_fi_tcl_ChannelRequestStatusList::~sds_fi_tcl_ChannelRequestStatusList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_ChannelRequestStatusList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ChannelRequestStatusList.size(); ++u32ListIdx)
      u32DynamicSize += ChannelRequestStatusList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_fi_tcl_ChannelRequestStatusList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ChannelRequestStatusList.size(); ++u32Idx)
      {
         ChannelRequestStatusList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ChannelRequestStatusList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ChannelRequestStatusList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_ChannelRequestStatusList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ChannelRequestStatusList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ChannelRequestStatusList.size(); ++u32Idx)
         (tVoid) (oOut << ChannelRequestStatusList[u32Idx]);
   }
   return oOut;
}

tBool sds_fi_tcl_ChannelRequestStatusList::operator==(const sds_fi_tcl_ChannelRequestStatusList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ChannelRequestStatusList.size() == roRef.ChannelRequestStatusList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ChannelRequestStatusList.size()); ++u32Idx)
            bResult = bResult && (ChannelRequestStatusList[u32Idx] == roRef.ChannelRequestStatusList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_TSStatus::sds_fi_tcl_e8_TSStatus():enType(FI_EN_TSINIT) {}

tS32 sds_fi_tcl_e8_TSStatus::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_TSSTATUS;
}


sds_fi_tcl_e8_TSStatus::~sds_fi_tcl_e8_TSStatus()
{}

tU32 sds_fi_tcl_e8_TSStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_TSStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_TSStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_DeviceContextStatus::sds_fi_tcl_e8_DeviceContextStatus():enType(FI_EN_AVAILABLE) {}

tS32 sds_fi_tcl_e8_DeviceContextStatus::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_DEVICECONTEXTSTATUS;
}


sds_fi_tcl_e8_DeviceContextStatus::~sds_fi_tcl_e8_DeviceContextStatus()
{}

tU32 sds_fi_tcl_e8_DeviceContextStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_DeviceContextStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_DeviceContextStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_DynamicDataStatus::sds_fi_tcl_e8_DynamicDataStatus():enType(FI_EN_DYNAMICDATAAVAILABLE) {}

tS32 sds_fi_tcl_e8_DynamicDataStatus::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_DYNAMICDATASTATUS;
}


sds_fi_tcl_e8_DynamicDataStatus::~sds_fi_tcl_e8_DynamicDataStatus()
{}

tU32 sds_fi_tcl_e8_DynamicDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_DynamicDataStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_DynamicDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_Category::sds_fi_tcl_e8_Category():enType(FI_EN_NORMAL) {}

tS32 sds_fi_tcl_e8_Category::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_CATEGORY;
}


sds_fi_tcl_e8_Category::~sds_fi_tcl_e8_Category()
{}

tU32 sds_fi_tcl_e8_Category::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_Category::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_Category::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_ContextUpdateStatus::sds_fi_tcl_e8_ContextUpdateStatus():enType(FI_EN_CONTEXTAVAILABLE) {}

tS32 sds_fi_tcl_e8_ContextUpdateStatus::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_CONTEXTUPDATESTATUS;
}


sds_fi_tcl_e8_ContextUpdateStatus::~sds_fi_tcl_e8_ContextUpdateStatus()
{}

tU32 sds_fi_tcl_e8_ContextUpdateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_ContextUpdateStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_ContextUpdateStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_WordTransMap::sds_fi_tcl_WordTransMap(const sds_fi_tcl_WordTransMap& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   Word = coRef.Word;
   Transcriptions = coRef.Transcriptions;
}
sds_fi_tcl_WordTransMap& sds_fi_tcl_WordTransMap::operator=(const sds_fi_tcl_WordTransMap& coRef)
{
   if (this == &coRef) return *this;
   Word = coRef.Word;
   Transcriptions = coRef.Transcriptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_WordTransMap::vDestroy()
{
   Word.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < Transcriptions.size(); ++u32Idx)
         Transcriptions[u32Idx].vDestroy();
   Transcriptions.clear();
   }
}

sds_fi_tcl_WordTransMap::sds_fi_tcl_WordTransMap()
:Word()

 {}

tS32 sds_fi_tcl_WordTransMap::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_WORDTRANSMAP;
}


sds_fi_tcl_WordTransMap::~sds_fi_tcl_WordTransMap()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_WordTransMap::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Transcriptions.size(); ++u32ListIdx)
      u32DynamicSize += Transcriptions[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4+Word.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_WordTransMap::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Word);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Transcriptions.size(); ++u32Idx)
      {
         Transcriptions[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Transcriptions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Transcriptions[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_WordTransMap::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Word);
   (tVoid) (oOut << (tU32)Transcriptions.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Transcriptions.size(); ++u32Idx)
         (tVoid) (oOut << Transcriptions[u32Idx]);
   }
   return oOut;
}

tBool sds_fi_tcl_WordTransMap::operator==(const sds_fi_tcl_WordTransMap& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Word == roRef.Word);
      bResult = bResult && (Transcriptions.size() == roRef.Transcriptions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Transcriptions.size()); ++u32Idx)
            bResult = bResult && (Transcriptions[u32Idx] == roRef.Transcriptions[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_DynamicDataStatus::sds_fi_tcl_DynamicDataStatus(const sds_fi_tcl_DynamicDataStatus& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   u32DeviceId = coRef.u32DeviceId;
   PageNumbers = coRef.PageNumbers;
   tenDomain = coRef.tenDomain;
   DynamicDataStatus = coRef.DynamicDataStatus;
}
sds_fi_tcl_DynamicDataStatus& sds_fi_tcl_DynamicDataStatus::operator=(const sds_fi_tcl_DynamicDataStatus& coRef)
{
   if (this == &coRef) return *this;
   u32DeviceId = coRef.u32DeviceId;
   PageNumbers = coRef.PageNumbers;
   tenDomain = coRef.tenDomain;
   DynamicDataStatus = coRef.DynamicDataStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_DynamicDataStatus::vDestroy()
{
   {
   PageNumbers.clear();
   }
}

sds_fi_tcl_DynamicDataStatus::sds_fi_tcl_DynamicDataStatus()
:u32DeviceId(0)

,tenDomain()
,DynamicDataStatus()
 {}

tS32 sds_fi_tcl_DynamicDataStatus::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_DYNAMICDATASTATUS;
}


sds_fi_tcl_DynamicDataStatus::~sds_fi_tcl_DynamicDataStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_DynamicDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10+PageNumbers.size()*4;
}

fi_tclInContext& sds_fi_tcl_DynamicDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32DeviceId);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      PageNumbers.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PageNumbers[u32Idx]);
      }
   }
   (tVoid) (oIn >> tenDomain);
   (tVoid) (oIn >> DynamicDataStatus);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_DynamicDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32DeviceId);
   (tVoid) (oOut << (tU32)PageNumbers.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PageNumbers.size(); ++u32Idx)
         (tVoid) (oOut << PageNumbers[u32Idx]);
   }
   (tVoid) (oOut << tenDomain);
   (tVoid) (oOut << DynamicDataStatus);
   return oOut;
}

tBool sds_fi_tcl_DynamicDataStatus::operator==(const sds_fi_tcl_DynamicDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32DeviceId == roRef.u32DeviceId);
      bResult = bResult && (PageNumbers.size() == roRef.PageNumbers.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PageNumbers.size()); ++u32Idx)
            bResult = bResult && (PageNumbers[u32Idx] == roRef.PageNumbers[u32Idx]);
      }
   bResult = bResult && (tenDomain == roRef.tenDomain);
   bResult = bResult && (DynamicDataStatus == roRef.DynamicDataStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_IdTransMap::sds_fi_tcl_IdTransMap(const sds_fi_tcl_IdTransMap& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   u32Index = coRef.u32Index;
   Transcriptions = coRef.Transcriptions;
}
sds_fi_tcl_IdTransMap& sds_fi_tcl_IdTransMap::operator=(const sds_fi_tcl_IdTransMap& coRef)
{
   if (this == &coRef) return *this;
   u32Index = coRef.u32Index;
   Transcriptions = coRef.Transcriptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_IdTransMap::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Transcriptions.size(); ++u32Idx)
         Transcriptions[u32Idx].vDestroy();
   Transcriptions.clear();
   }
}

sds_fi_tcl_IdTransMap::sds_fi_tcl_IdTransMap()
:u32Index(0)

 {}

tS32 sds_fi_tcl_IdTransMap::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_IDTRANSMAP;
}


sds_fi_tcl_IdTransMap::~sds_fi_tcl_IdTransMap()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_IdTransMap::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Transcriptions.size(); ++u32ListIdx)
      u32DynamicSize += Transcriptions[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

fi_tclInContext& sds_fi_tcl_IdTransMap::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Index);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Transcriptions.size(); ++u32Idx)
      {
         Transcriptions[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Transcriptions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Transcriptions[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_IdTransMap::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Index);
   (tVoid) (oOut << (tU32)Transcriptions.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Transcriptions.size(); ++u32Idx)
         (tVoid) (oOut << Transcriptions[u32Idx]);
   }
   return oOut;
}

tBool sds_fi_tcl_IdTransMap::operator==(const sds_fi_tcl_IdTransMap& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Index == roRef.u32Index);
      bResult = bResult && (Transcriptions.size() == roRef.Transcriptions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Transcriptions.size()); ++u32Idx)
            bResult = bResult && (Transcriptions[u32Idx] == roRef.Transcriptions[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_e8_DeviceContextAvailability::sds_fi_tcl_e8_DeviceContextAvailability(const sds_fi_tcl_e8_DeviceContextAvailability& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   DynamicDataStatus = coRef.DynamicDataStatus;
   DeviceContextStaus = coRef.DeviceContextStaus;
}
sds_fi_tcl_e8_DeviceContextAvailability& sds_fi_tcl_e8_DeviceContextAvailability::operator=(const sds_fi_tcl_e8_DeviceContextAvailability& coRef)
{
   if (this == &coRef) return *this;
   DynamicDataStatus = coRef.DynamicDataStatus;
   DeviceContextStaus = coRef.DeviceContextStaus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_e8_DeviceContextAvailability::vDestroy()
{
   DynamicDataStatus.vDestroy(); 
}

sds_fi_tcl_e8_DeviceContextAvailability::sds_fi_tcl_e8_DeviceContextAvailability()
:DynamicDataStatus()
,DeviceContextStaus()
 {}

tS32 sds_fi_tcl_e8_DeviceContextAvailability::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_DEVICECONTEXTAVAILABILITY;
}


sds_fi_tcl_e8_DeviceContextAvailability::~sds_fi_tcl_e8_DeviceContextAvailability()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_e8_DeviceContextAvailability::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+DynamicDataStatus.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_e8_DeviceContextAvailability::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DynamicDataStatus);
   (tVoid) (oIn >> DeviceContextStaus);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_DeviceContextAvailability::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DynamicDataStatus);
   (tVoid) (oOut << DeviceContextStaus);
   return oOut;
}

tBool sds_fi_tcl_e8_DeviceContextAvailability::operator==(const sds_fi_tcl_e8_DeviceContextAvailability& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DynamicDataStatus == roRef.DynamicDataStatus);
   bResult = bResult && (DeviceContextStaus == roRef.DeviceContextStaus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_ContextOverFlowStatus::sds_fi_tcl_ContextOverFlowStatus(const sds_fi_tcl_ContextOverFlowStatus& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   u32DeviceId = coRef.u32DeviceId;
   ContextOverFlow = coRef.ContextOverFlow;
}
sds_fi_tcl_ContextOverFlowStatus& sds_fi_tcl_ContextOverFlowStatus::operator=(const sds_fi_tcl_ContextOverFlowStatus& coRef)
{
   if (this == &coRef) return *this;
   u32DeviceId = coRef.u32DeviceId;
   ContextOverFlow = coRef.ContextOverFlow;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_ContextOverFlowStatus::sds_fi_tcl_ContextOverFlowStatus()
:u32DeviceId(0)
,ContextOverFlow(0)
 {}

tS32 sds_fi_tcl_ContextOverFlowStatus::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_CONTEXTOVERFLOWSTATUS;
}


sds_fi_tcl_ContextOverFlowStatus::~sds_fi_tcl_ContextOverFlowStatus()
{}

tU32 sds_fi_tcl_ContextOverFlowStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds_fi_tcl_ContextOverFlowStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32DeviceId);
   (tVoid) (oIn >> ContextOverFlow);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_ContextOverFlowStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32DeviceId);
   (tVoid) (oOut << ContextOverFlow);
   return oOut;
}

tBool sds_fi_tcl_ContextOverFlowStatus::operator==(const sds_fi_tcl_ContextOverFlowStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32DeviceId == roRef.u32DeviceId);
   bResult = bResult && (ContextOverFlow == roRef.ContextOverFlow);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_SlotAvailabilty::sds_fi_tcl_SlotAvailabilty(const sds_fi_tcl_SlotAvailabilty& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   e8Slot = coRef.e8Slot;
   bAvailable = coRef.bAvailable;
}
sds_fi_tcl_SlotAvailabilty& sds_fi_tcl_SlotAvailabilty::operator=(const sds_fi_tcl_SlotAvailabilty& coRef)
{
   if (this == &coRef) return *this;
   e8Slot = coRef.e8Slot;
   bAvailable = coRef.bAvailable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_SlotAvailabilty::sds_fi_tcl_SlotAvailabilty()
:e8Slot()
,bAvailable(0)
 {}

tS32 sds_fi_tcl_SlotAvailabilty::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_SLOTAVAILABILTY;
}


sds_fi_tcl_SlotAvailabilty::~sds_fi_tcl_SlotAvailabilty()
{}

tU32 sds_fi_tcl_SlotAvailabilty::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_fi_tcl_SlotAvailabilty::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Slot);
   (tVoid) (oIn >> bAvailable);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_SlotAvailabilty::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Slot);
   (tVoid) (oOut << bAvailable);
   return oOut;
}

tBool sds_fi_tcl_SlotAvailabilty::operator==(const sds_fi_tcl_SlotAvailabilty& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Slot == roRef.e8Slot);
   bResult = bResult && (bAvailable == roRef.bAvailable);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_WordSlot::sds_fi_tcl_WordSlot(const sds_fi_tcl_WordSlot& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   szWord = coRef.szWord;
   e8Slot = coRef.e8Slot;
}
sds_fi_tcl_WordSlot& sds_fi_tcl_WordSlot::operator=(const sds_fi_tcl_WordSlot& coRef)
{
   if (this == &coRef) return *this;
   szWord = coRef.szWord;
   e8Slot = coRef.e8Slot;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_WordSlot::vDestroy()
{
   szWord.vDestroy();
}

sds_fi_tcl_WordSlot::sds_fi_tcl_WordSlot()
:szWord()
,e8Slot()
 {}

tS32 sds_fi_tcl_WordSlot::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_WORDSLOT;
}


sds_fi_tcl_WordSlot::~sds_fi_tcl_WordSlot()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_WordSlot::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+szWord.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_WordSlot::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szWord);
   (tVoid) (oIn >> e8Slot);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_WordSlot::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szWord);
   (tVoid) (oOut << e8Slot);
   return oOut;
}

tBool sds_fi_tcl_WordSlot::operator==(const sds_fi_tcl_WordSlot& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szWord == roRef.szWord);
   bResult = bResult && (e8Slot == roRef.e8Slot);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_WordTransSlot::sds_fi_tcl_WordTransSlot(const sds_fi_tcl_WordTransSlot& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   stWordTrans = coRef.stWordTrans;
   e8Slot = coRef.e8Slot;
}
sds_fi_tcl_WordTransSlot& sds_fi_tcl_WordTransSlot::operator=(const sds_fi_tcl_WordTransSlot& coRef)
{
   if (this == &coRef) return *this;
   stWordTrans = coRef.stWordTrans;
   e8Slot = coRef.e8Slot;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_WordTransSlot::vDestroy()
{
   stWordTrans.vDestroy(); 
}

sds_fi_tcl_WordTransSlot::sds_fi_tcl_WordTransSlot()
:stWordTrans()
,e8Slot()
 {}

tS32 sds_fi_tcl_WordTransSlot::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_WORDTRANSSLOT;
}


sds_fi_tcl_WordTransSlot::~sds_fi_tcl_WordTransSlot()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_WordTransSlot::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+stWordTrans.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_WordTransSlot::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> stWordTrans);
   (tVoid) (oIn >> e8Slot);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_WordTransSlot::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << stWordTrans);
   (tVoid) (oOut << e8Slot);
   return oOut;
}

tBool sds_fi_tcl_WordTransSlot::operator==(const sds_fi_tcl_WordTransSlot& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (stWordTrans == roRef.stWordTrans);
   bResult = bResult && (e8Slot == roRef.e8Slot);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_WordInfo::sds_fi_tcl_WordInfo(const sds_fi_tcl_WordInfo& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   e8WordType = coRef.e8WordType;
   NDSId = coRef.NDSId;
   szWord = coRef.szWord;
   szPhoneme = coRef.szPhoneme;
}
sds_fi_tcl_WordInfo& sds_fi_tcl_WordInfo::operator=(const sds_fi_tcl_WordInfo& coRef)
{
   if (this == &coRef) return *this;
   e8WordType = coRef.e8WordType;
   NDSId = coRef.NDSId;
   szWord = coRef.szWord;
   szPhoneme = coRef.szPhoneme;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_WordInfo::vDestroy()
{
   NDSId.vDestroy(); 
   szWord.vDestroy();
   szPhoneme.vDestroy();
}

sds_fi_tcl_WordInfo::sds_fi_tcl_WordInfo()
:e8WordType()
,NDSId()
,szWord()
,szPhoneme()
 {}

tS32 sds_fi_tcl_WordInfo::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_WORDINFO;
}


sds_fi_tcl_WordInfo::~sds_fi_tcl_WordInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_WordInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 25+szWord.u32GetSize(u16MajorVersion)+szPhoneme.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_WordInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8WordType);
   (tVoid) (oIn >> NDSId);
   (tVoid) (oIn >> szWord);
   (tVoid) (oIn >> szPhoneme);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_WordInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8WordType);
   (tVoid) (oOut << NDSId);
   (tVoid) (oOut << szWord);
   (tVoid) (oOut << szPhoneme);
   return oOut;
}

tBool sds_fi_tcl_WordInfo::operator==(const sds_fi_tcl_WordInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8WordType == roRef.e8WordType);
   bResult = bResult && (NDSId == roRef.NDSId);
   bResult = bResult && (szWord == roRef.szWord);
   bResult = bResult && (szPhoneme == roRef.szPhoneme);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_ListElements::sds_fi_tcl_ListElements(const sds_fi_tcl_ListElements& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   u32Index = coRef.u32Index;
   WordInfo = coRef.WordInfo;
}
sds_fi_tcl_ListElements& sds_fi_tcl_ListElements::operator=(const sds_fi_tcl_ListElements& coRef)
{
   if (this == &coRef) return *this;
   u32Index = coRef.u32Index;
   WordInfo = coRef.WordInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_ListElements::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < WordInfo.size(); ++u32Idx)
         WordInfo[u32Idx].vDestroy();
   WordInfo.clear();
   }
}

sds_fi_tcl_ListElements::sds_fi_tcl_ListElements()
:u32Index(0)

 {}

tS32 sds_fi_tcl_ListElements::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_LISTELEMENTS;
}


sds_fi_tcl_ListElements::~sds_fi_tcl_ListElements()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_ListElements::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < WordInfo.size(); ++u32ListIdx)
      u32DynamicSize += WordInfo[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

fi_tclInContext& sds_fi_tcl_ListElements::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Index);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < WordInfo.size(); ++u32Idx)
      {
         WordInfo[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      WordInfo.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> WordInfo[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_ListElements::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Index);
   (tVoid) (oOut << (tU32)WordInfo.size());
   {
      for (tU32 u32Idx = 0; u32Idx < WordInfo.size(); ++u32Idx)
         (tVoid) (oOut << WordInfo[u32Idx]);
   }
   return oOut;
}

tBool sds_fi_tcl_ListElements::operator==(const sds_fi_tcl_ListElements& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Index == roRef.u32Index);
      bResult = bResult && (WordInfo.size() == roRef.WordInfo.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < WordInfo.size()); ++u32Idx)
            bResult = bResult && (WordInfo[u32Idx] == roRef.WordInfo[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_ListEntries::sds_fi_tcl_ListEntries(const sds_fi_tcl_ListEntries& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   u32ListElementId = coRef.u32ListElementId;
   WordInfo = coRef.WordInfo;
}
sds_fi_tcl_ListEntries& sds_fi_tcl_ListEntries::operator=(const sds_fi_tcl_ListEntries& coRef)
{
   if (this == &coRef) return *this;
   u32ListElementId = coRef.u32ListElementId;
   WordInfo = coRef.WordInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_ListEntries::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < WordInfo.size(); ++u32Idx)
         WordInfo[u32Idx].vDestroy();
   WordInfo.clear();
   }
}

sds_fi_tcl_ListEntries::sds_fi_tcl_ListEntries()
:u32ListElementId(0)

 {}

tS32 sds_fi_tcl_ListEntries::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_LISTENTRIES;
}


sds_fi_tcl_ListEntries::~sds_fi_tcl_ListEntries()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_ListEntries::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < WordInfo.size(); ++u32ListIdx)
      u32DynamicSize += WordInfo[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

fi_tclInContext& sds_fi_tcl_ListEntries::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListElementId);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < WordInfo.size(); ++u32Idx)
      {
         WordInfo[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      WordInfo.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> WordInfo[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_ListEntries::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListElementId);
   (tVoid) (oOut << (tU32)WordInfo.size());
   {
      for (tU32 u32Idx = 0; u32Idx < WordInfo.size(); ++u32Idx)
         (tVoid) (oOut << WordInfo[u32Idx]);
   }
   return oOut;
}

tBool sds_fi_tcl_ListEntries::operator==(const sds_fi_tcl_ListEntries& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListElementId == roRef.u32ListElementId);
      bResult = bResult && (WordInfo.size() == roRef.WordInfo.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < WordInfo.size()); ++u32Idx)
            bResult = bResult && (WordInfo[u32Idx] == roRef.WordInfo[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_ListContextStatus::sds_fi_tcl_ListContextStatus(const sds_fi_tcl_ListContextStatus& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   e8Domain = coRef.e8Domain;
   e8WordType = coRef.e8WordType;
   e8Status = coRef.e8Status;
}
sds_fi_tcl_ListContextStatus& sds_fi_tcl_ListContextStatus::operator=(const sds_fi_tcl_ListContextStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Domain = coRef.e8Domain;
   e8WordType = coRef.e8WordType;
   e8Status = coRef.e8Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_ListContextStatus::sds_fi_tcl_ListContextStatus()
:e8Domain()
,e8WordType()
,e8Status()
 {}

tS32 sds_fi_tcl_ListContextStatus::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_LISTCONTEXTSTATUS;
}


sds_fi_tcl_ListContextStatus::~sds_fi_tcl_ListContextStatus()
{}

tU32 sds_fi_tcl_ListContextStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& sds_fi_tcl_ListContextStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Domain);
   (tVoid) (oIn >> e8WordType);
   (tVoid) (oIn >> e8Status);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_ListContextStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Domain);
   (tVoid) (oOut << e8WordType);
   (tVoid) (oOut << e8Status);
   return oOut;
}

tBool sds_fi_tcl_ListContextStatus::operator==(const sds_fi_tcl_ListContextStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Domain == roRef.e8Domain);
   bResult = bResult && (e8WordType == roRef.e8WordType);
   bResult = bResult && (e8Status == roRef.e8Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_WordPhonemeMap::sds_fi_tcl_WordPhonemeMap(const sds_fi_tcl_WordPhonemeMap& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   u32WordID = coRef.u32WordID;
   tWordID = coRef.tWordID;
   stWordTransMap = coRef.stWordTransMap;
}
sds_fi_tcl_WordPhonemeMap& sds_fi_tcl_WordPhonemeMap::operator=(const sds_fi_tcl_WordPhonemeMap& coRef)
{
   if (this == &coRef) return *this;
   u32WordID = coRef.u32WordID;
   tWordID = coRef.tWordID;
   stWordTransMap = coRef.stWordTransMap;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_WordPhonemeMap::vDestroy()
{
   tWordID.vDestroy(); 
   stWordTransMap.vDestroy(); 
}

sds_fi_tcl_WordPhonemeMap::sds_fi_tcl_WordPhonemeMap()
:u32WordID(0)
,tWordID()
,stWordTransMap()
 {}

tS32 sds_fi_tcl_WordPhonemeMap::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_WORDPHONEMEMAP;
}


sds_fi_tcl_WordPhonemeMap::~sds_fi_tcl_WordPhonemeMap()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_WordPhonemeMap::u32GetSize(tU16 u16MajorVersion) const
{
   return 28+stWordTransMap.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_WordPhonemeMap::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32WordID);
   (tVoid) (oIn >> tWordID);
   (tVoid) (oIn >> stWordTransMap);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_WordPhonemeMap::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32WordID);
   (tVoid) (oOut << tWordID);
   (tVoid) (oOut << stWordTransMap);
   return oOut;
}

tBool sds_fi_tcl_WordPhonemeMap::operator==(const sds_fi_tcl_WordPhonemeMap& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32WordID == roRef.u32WordID);
   bResult = bResult && (tWordID == roRef.tWordID);
   bResult = bResult && (stWordTransMap == roRef.stWordTransMap);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_MPL_Status::sds_fi_tcl_e8_MPL_Status():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_MPL_Status::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_MPL_STATUS;
}


sds_fi_tcl_e8_MPL_Status::~sds_fi_tcl_e8_MPL_Status()
{}

tU32 sds_fi_tcl_e8_MPL_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_MPL_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_MPL_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_MPL_SourceType::sds_fi_tcl_e8_MPL_SourceType():enType(FI_EN_SOURCE_TYPE_UNKNOWN) {}

tS32 sds_fi_tcl_e8_MPL_SourceType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_MPL_SOURCETYPE;
}


sds_fi_tcl_e8_MPL_SourceType::~sds_fi_tcl_e8_MPL_SourceType()
{}

tU32 sds_fi_tcl_e8_MPL_SourceType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_MPL_SourceType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_MPL_SourceType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_MPL_MenuType::sds_fi_tcl_e8_MPL_MenuType():enType(FI_EN_MENU_TYPE_UNKNOWN) {}

tS32 sds_fi_tcl_e8_MPL_MenuType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_MPL_MENUTYPE;
}


sds_fi_tcl_e8_MPL_MenuType::~sds_fi_tcl_e8_MPL_MenuType()
{}

tU32 sds_fi_tcl_e8_MPL_MenuType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_MPL_MenuType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_MPL_MenuType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_DeviceStatus::sds_fi_tcl_e8_DeviceStatus():enType(FI_EN_DEVICE_UNKNOWN) {}

tS32 sds_fi_tcl_e8_DeviceStatus::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_DEVICESTATUS;
}


sds_fi_tcl_e8_DeviceStatus::~sds_fi_tcl_e8_DeviceStatus()
{}

tU32 sds_fi_tcl_e8_DeviceStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_DeviceStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_DeviceStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_SDS2HMI_PHN_Status::sds_fi_tcl_e8_SDS2HMI_PHN_Status():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_SDS2HMI_PHN_Status::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_SDS2HMI_PHN_STATUS;
}


sds_fi_tcl_e8_SDS2HMI_PHN_Status::~sds_fi_tcl_e8_SDS2HMI_PHN_Status()
{}

tU32 sds_fi_tcl_e8_SDS2HMI_PHN_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_SDS2HMI_PHN_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_SDS2HMI_PHN_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_SDS2HMI_PHN_MenuType::sds_fi_tcl_e8_SDS2HMI_PHN_MenuType():enType(FI_EN_OTHER) {}

tS32 sds_fi_tcl_e8_SDS2HMI_PHN_MenuType::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_SDS2HMI_PHN_MENUTYPE;
}


sds_fi_tcl_e8_SDS2HMI_PHN_MenuType::~sds_fi_tcl_e8_SDS2HMI_PHN_MenuType()
{}

tU32 sds_fi_tcl_e8_SDS2HMI_PHN_MenuType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_SDS2HMI_PHN_MenuType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_SDS2HMI_PHN_MenuType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_SDS2HMI_TUN_Status::sds_fi_tcl_e8_SDS2HMI_TUN_Status():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_SDS2HMI_TUN_Status::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_SDS2HMI_TUN_STATUS;
}


sds_fi_tcl_e8_SDS2HMI_TUN_Status::~sds_fi_tcl_e8_SDS2HMI_TUN_Status()
{}

tU32 sds_fi_tcl_e8_SDS2HMI_TUN_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_SDS2HMI_TUN_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_SDS2HMI_TUN_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_SDS2HMI_TUN_Band::sds_fi_tcl_e8_SDS2HMI_TUN_Band():enType(FI_EN_UNKNOWN) {}

tS32 sds_fi_tcl_e8_SDS2HMI_TUN_Band::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_SDS2HMI_TUN_BAND;
}


sds_fi_tcl_e8_SDS2HMI_TUN_Band::~sds_fi_tcl_e8_SDS2HMI_TUN_Band()
{}

tU32 sds_fi_tcl_e8_SDS2HMI_TUN_Band::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_SDS2HMI_TUN_Band::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_SDS2HMI_TUN_Band::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_fi_tcl_e8_NDS_SDN_Status::sds_fi_tcl_e8_NDS_SDN_Status():enType(FI_EN_DATA_NOT_AVAILABLE) {}

tS32 sds_fi_tcl_e8_NDS_SDN_Status::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_E8_NDS_SDN_STATUS;
}


sds_fi_tcl_e8_NDS_SDN_Status::~sds_fi_tcl_e8_NDS_SDN_Status()
{}

tU32 sds_fi_tcl_e8_NDS_SDN_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_fi_tcl_e8_NDS_SDN_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_e8_NDS_SDN_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_fi_tcl_DeviceStatus::sds_fi_tcl_DeviceStatus(const sds_fi_tcl_DeviceStatus& coRef)
   : sds_fi_tclVisitableTypeBase(coRef)
{
   DeviceID = coRef.DeviceID;
   DeviceName = coRef.DeviceName;
   Status = coRef.Status;
   Type = coRef.Type;
}
sds_fi_tcl_DeviceStatus& sds_fi_tcl_DeviceStatus::operator=(const sds_fi_tcl_DeviceStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceID = coRef.DeviceID;
   DeviceName = coRef.DeviceName;
   Status = coRef.Status;
   Type = coRef.Type;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_fi_tcl_DeviceStatus::vDestroy()
{
   DeviceName.vDestroy();
}

sds_fi_tcl_DeviceStatus::sds_fi_tcl_DeviceStatus()
:DeviceID(0)
,DeviceName()
,Status()
,Type()
 {}

tS32 sds_fi_tcl_DeviceStatus::s32GetTypeId() const
{
   return (tS32) sds_typesfi_tclToken::EN_DEVICESTATUS;
}


sds_fi_tcl_DeviceStatus::~sds_fi_tcl_DeviceStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_fi_tcl_DeviceStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+DeviceName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_fi_tcl_DeviceStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceID);
   (tVoid) (oIn >> DeviceName);
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> Type);
   return oIn;
}

fi_tclOutContext& sds_fi_tcl_DeviceStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceID);
   (tVoid) (oOut << DeviceName);
   (tVoid) (oOut << Status);
   (tVoid) (oOut << Type);
   return oOut;
}

tBool sds_fi_tcl_DeviceStatus::operator==(const sds_fi_tcl_DeviceStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceID == roRef.DeviceID);
   bResult = bResult && (DeviceName == roRef.DeviceName);
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (Type == roRef.Type);
   return bResult;
}

