/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef SDS_VOICECONTROLFITYPES_HEADER
#define SDS_VOICECONTROLFITYPES_HEADER


class sds_voicecontrolfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for SDS_VOICECONTROL_FI message types

fi_tclMessageBase* sds_voicecontrolfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class sds_voicecontrolfi_tclMsgBaseMessage : public sds_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   sds_voicecontrolfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class sds_voicecontrolfi_tclMsgPTTEventMethodStart : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgPTTEventMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_voicecontrolfi_tclMsgPTTEventMethodStart& operator=(const sds_voicecontrolfi_tclMsgPTTEventMethodStart& coRef);
   sds_voicecontrolfi_tclMsgPTTEventMethodStart(const sds_voicecontrolfi_tclMsgPTTEventMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_PushButtonOption PushButtonOption;
   virtual ~sds_voicecontrolfi_tclMsgPTTEventMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_voicecontrolfi_tclMsgPTTEventMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgPTTEventMethodResult : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgPTTEventMethodResult();

   virtual ~sds_voicecontrolfi_tclMsgPTTEventMethodResult();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgPTTEventMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgAbortDialogMethodStart : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgAbortDialogMethodStart();

   virtual ~sds_voicecontrolfi_tclMsgAbortDialogMethodStart();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgAbortDialogMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgAbortDialogMethodResult : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgAbortDialogMethodResult();

   virtual ~sds_voicecontrolfi_tclMsgAbortDialogMethodResult();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgAbortDialogMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgResetDialogMethodStart : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgResetDialogMethodStart();

   virtual ~sds_voicecontrolfi_tclMsgResetDialogMethodStart();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgResetDialogMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgResetDialogMethodResult : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgResetDialogMethodResult();

   virtual ~sds_voicecontrolfi_tclMsgResetDialogMethodResult();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgResetDialogMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodStart : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodStart& operator=(const sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodStart& coRef);
   sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodStart(const sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_LanguageAndSpeaker LanguageAndSpeaker;
   virtual ~sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultFirst : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultFirst();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultFirst& operator=(const sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultFirst& coRef);
   sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultFirst(const sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultFirst& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_Progress Progress;
   virtual ~sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultFirst();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultFirst& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultMiddle : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultMiddle();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultMiddle& operator=(const sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultMiddle& coRef);
   sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultMiddle(const sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultMiddle& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_Progress Progress;
   virtual ~sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultMiddle();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultMiddle& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultLast : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultLast();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultLast& operator=(const sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultLast& coRef);
   sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultLast(const sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultLast& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_Progress Progress;
   virtual ~sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultLast();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultLast& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodStart : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodStart& operator=(const sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodStart& coRef);
   sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodStart(const sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_HomeDestCountry HomeDestCountry;
   virtual ~sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultFirst : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultFirst();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultFirst& operator=(const sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultFirst& coRef);
   sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultFirst(const sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultFirst& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_Progress Progress;
   virtual ~sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultFirst();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultFirst& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultMiddle : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultMiddle();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultMiddle& operator=(const sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultMiddle& coRef);
   sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultMiddle(const sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultMiddle& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_Progress Progress;
   virtual ~sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultMiddle();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultMiddle& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultLast : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultLast();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultLast& operator=(const sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultLast& coRef);
   sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultLast(const sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultLast& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_Progress Progress;
   virtual ~sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultLast();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultLast& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgDoUpRegToPropertiesMethodStart : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgDoUpRegToPropertiesMethodStart();

   virtual ~sds_voicecontrolfi_tclMsgDoUpRegToPropertiesMethodStart();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgDoUpRegToPropertiesMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgDoUpRegToPropertiesMethodResult : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgDoUpRegToPropertiesMethodResult();

   virtual ~sds_voicecontrolfi_tclMsgDoUpRegToPropertiesMethodResult();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgDoUpRegToPropertiesMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodStart : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodStart& operator=(const sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodStart& coRef);
   sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodStart(const sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_VoiceControlStatus VoiceControlStatus;
   virtual ~sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodResult : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodResult();

   virtual ~sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodResult();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgUpdateAllUserWordsMethodStart : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgUpdateAllUserWordsMethodStart();

   virtual ~sds_voicecontrolfi_tclMsgUpdateAllUserWordsMethodStart();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgUpdateAllUserWordsMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgUpdateAllUserWordsMethodResult : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgUpdateAllUserWordsMethodResult();

   virtual ~sds_voicecontrolfi_tclMsgUpdateAllUserWordsMethodResult();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgUpdateAllUserWordsMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodStart : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodStart();

   virtual ~sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodStart();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodResult : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodResult& operator=(const sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodResult& coRef);
   sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodResult(const sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_LanguageAndSpeaker, std::allocator<sds_fi_tcl_LanguageAndSpeaker> > LanguagesAndSpeaker;
   virtual ~sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgLoadDialogFileMethodStart : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgLoadDialogFileMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_voicecontrolfi_tclMsgLoadDialogFileMethodStart& operator=(const sds_voicecontrolfi_tclMsgLoadDialogFileMethodStart& coRef);
   sds_voicecontrolfi_tclMsgLoadDialogFileMethodStart(const sds_voicecontrolfi_tclMsgLoadDialogFileMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString DialogPath;
   virtual ~sds_voicecontrolfi_tclMsgLoadDialogFileMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_voicecontrolfi_tclMsgLoadDialogFileMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgLoadDialogFileMethodResult : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgLoadDialogFileMethodResult();

   virtual ~sds_voicecontrolfi_tclMsgLoadDialogFileMethodResult();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgLoadDialogFileMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodStart : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodStart& operator=(const sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodStart& coRef);
   sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodStart(const sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_RecogStatus RecognizerStatus;
   virtual ~sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodResult : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodResult();

   virtual ~sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodResult();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgStartUpGoodCasesMethodStart : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgStartUpGoodCasesMethodStart();

   virtual ~sds_voicecontrolfi_tclMsgStartUpGoodCasesMethodStart();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgStartUpGoodCasesMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgStartUpGoodCasesMethodResult : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgStartUpGoodCasesMethodResult();

   virtual ~sds_voicecontrolfi_tclMsgStartUpGoodCasesMethodResult();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgStartUpGoodCasesMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgStartUpBadCasesMethodStart : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgStartUpBadCasesMethodStart();

   virtual ~sds_voicecontrolfi_tclMsgStartUpBadCasesMethodStart();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgStartUpBadCasesMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgStartUpBadCasesMethodResult : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgStartUpBadCasesMethodResult();

   virtual ~sds_voicecontrolfi_tclMsgStartUpBadCasesMethodResult();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgStartUpBadCasesMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodStart : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodStart& operator=(const sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodStart& coRef);
   sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodStart(const sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool ServicesAvailable;
   virtual ~sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodResult : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodResult();

   virtual ~sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodResult();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgSpeakSentenceMethodStart : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgSpeakSentenceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_voicecontrolfi_tclMsgSpeakSentenceMethodStart& operator=(const sds_voicecontrolfi_tclMsgSpeakSentenceMethodStart& coRef);
   sds_voicecontrolfi_tclMsgSpeakSentenceMethodStart(const sds_voicecontrolfi_tclMsgSpeakSentenceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_Sentence e8SentenceId;
   virtual ~sds_voicecontrolfi_tclMsgSpeakSentenceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_voicecontrolfi_tclMsgSpeakSentenceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgSpeakSentenceMethodResult : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgSpeakSentenceMethodResult();

   virtual ~sds_voicecontrolfi_tclMsgSpeakSentenceMethodResult();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgSpeakSentenceMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodStart : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodStart& operator=(const sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodStart& coRef);
   sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodStart(const sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_SDSTestCase e8Testcase;
   virtual ~sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodAbort : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodAbort();

   virtual ~sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodAbort();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodAbort& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodResult : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodResult();

   virtual ~sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodResult();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgSDSDiagnosisTestAbortResult : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgSDSDiagnosisTestAbortResult();

   virtual ~sds_voicecontrolfi_tclMsgSDSDiagnosisTestAbortResult();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgSDSDiagnosisTestAbortResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgTIMEREXPIREDMethodStart : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgTIMEREXPIREDMethodStart();

   virtual ~sds_voicecontrolfi_tclMsgTIMEREXPIREDMethodStart();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgTIMEREXPIREDMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgTIMEREXPIREDMethodResult : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgTIMEREXPIREDMethodResult();

   virtual ~sds_voicecontrolfi_tclMsgTIMEREXPIREDMethodResult();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgTIMEREXPIREDMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgInitiateCntryDwnlAfterStartUpMethodStart : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgInitiateCntryDwnlAfterStartUpMethodStart();

   virtual ~sds_voicecontrolfi_tclMsgInitiateCntryDwnlAfterStartUpMethodStart();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgInitiateCntryDwnlAfterStartUpMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgInitiateCntryDwnlAfterStartUpMethodResult : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgInitiateCntryDwnlAfterStartUpMethodResult();

   virtual ~sds_voicecontrolfi_tclMsgInitiateCntryDwnlAfterStartUpMethodResult();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgInitiateCntryDwnlAfterStartUpMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgUserEventMethodStart : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgUserEventMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_voicecontrolfi_tclMsgUserEventMethodStart& operator=(const sds_voicecontrolfi_tclMsgUserEventMethodStart& coRef);
   sds_voicecontrolfi_tclMsgUserEventMethodStart(const sds_voicecontrolfi_tclMsgUserEventMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8UserEventID;
   sds_fi_tclString sUserEventString;
   virtual ~sds_voicecontrolfi_tclMsgUserEventMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_voicecontrolfi_tclMsgUserEventMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgUserEventMethodResult : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgUserEventMethodResult();

   virtual ~sds_voicecontrolfi_tclMsgUserEventMethodResult();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgUserEventMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgResumeSettingsRequestUpdateMethodStart : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgResumeSettingsRequestUpdateMethodStart();

   virtual ~sds_voicecontrolfi_tclMsgResumeSettingsRequestUpdateMethodStart();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgResumeSettingsRequestUpdateMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgResumeSettingsRequestUpdateMethodResult : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgResumeSettingsRequestUpdateMethodResult();

   virtual ~sds_voicecontrolfi_tclMsgResumeSettingsRequestUpdateMethodResult();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgResumeSettingsRequestUpdateMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgTriggerPTTMethodStart : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgTriggerPTTMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_voicecontrolfi_tclMsgTriggerPTTMethodStart& operator=(const sds_voicecontrolfi_tclMsgTriggerPTTMethodStart& coRef);
   sds_voicecontrolfi_tclMsgTriggerPTTMethodStart(const sds_voicecontrolfi_tclMsgTriggerPTTMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Value;
   virtual ~sds_voicecontrolfi_tclMsgTriggerPTTMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_voicecontrolfi_tclMsgTriggerPTTMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgTriggerPTTMethodResult : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgTriggerPTTMethodResult();

   virtual ~sds_voicecontrolfi_tclMsgTriggerPTTMethodResult();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgTriggerPTTMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgVoicecontrolStatusGet : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgVoicecontrolStatusGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_voicecontrolfi_tclMsgVoicecontrolStatusGet& operator=(const sds_voicecontrolfi_tclMsgVoicecontrolStatusGet& coRef);
   sds_voicecontrolfi_tclMsgVoicecontrolStatusGet(const sds_voicecontrolfi_tclMsgVoicecontrolStatusGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_VoiceControlStatus VoiceControlStatus;
   virtual ~sds_voicecontrolfi_tclMsgVoicecontrolStatusGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_voicecontrolfi_tclMsgVoicecontrolStatusGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgVoicecontrolStatusUpReg : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgVoicecontrolStatusUpReg();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_voicecontrolfi_tclMsgVoicecontrolStatusUpReg& operator=(const sds_voicecontrolfi_tclMsgVoicecontrolStatusUpReg& coRef);
   sds_voicecontrolfi_tclMsgVoicecontrolStatusUpReg(const sds_voicecontrolfi_tclMsgVoicecontrolStatusUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_VoiceControlStatus VoiceControlStatus;
   virtual ~sds_voicecontrolfi_tclMsgVoicecontrolStatusUpReg();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_voicecontrolfi_tclMsgVoicecontrolStatusUpReg& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgVoicecontrolStatusRelUpReg : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgVoicecontrolStatusRelUpReg();

   virtual ~sds_voicecontrolfi_tclMsgVoicecontrolStatusRelUpReg();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgVoicecontrolStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgVoicecontrolStatusStatus : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgVoicecontrolStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_voicecontrolfi_tclMsgVoicecontrolStatusStatus& operator=(const sds_voicecontrolfi_tclMsgVoicecontrolStatusStatus& coRef);
   sds_voicecontrolfi_tclMsgVoicecontrolStatusStatus(const sds_voicecontrolfi_tclMsgVoicecontrolStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_VoiceControlStatus VoiceControlStatus;
   virtual ~sds_voicecontrolfi_tclMsgVoicecontrolStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_voicecontrolfi_tclMsgVoicecontrolStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgLanguageandSpeakerGet : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgLanguageandSpeakerGet();

   virtual ~sds_voicecontrolfi_tclMsgLanguageandSpeakerGet();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgLanguageandSpeakerGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgLanguageandSpeakerUpReg : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgLanguageandSpeakerUpReg();

   virtual ~sds_voicecontrolfi_tclMsgLanguageandSpeakerUpReg();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgLanguageandSpeakerUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgLanguageandSpeakerRelUpReg : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgLanguageandSpeakerRelUpReg();

   virtual ~sds_voicecontrolfi_tclMsgLanguageandSpeakerRelUpReg();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgLanguageandSpeakerRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgLanguageandSpeakerStatus : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgLanguageandSpeakerStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_voicecontrolfi_tclMsgLanguageandSpeakerStatus& operator=(const sds_voicecontrolfi_tclMsgLanguageandSpeakerStatus& coRef);
   sds_voicecontrolfi_tclMsgLanguageandSpeakerStatus(const sds_voicecontrolfi_tclMsgLanguageandSpeakerStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_LanguageAndSpeaker LanguageAndSpeaker;
   virtual ~sds_voicecontrolfi_tclMsgLanguageandSpeakerStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_voicecontrolfi_tclMsgLanguageandSpeakerStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersGet : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersGet();

   virtual ~sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersGet();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersUpReg : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersUpReg();

   virtual ~sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersUpReg();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersRelUpReg : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersRelUpReg();

   virtual ~sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersRelUpReg();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersStatus : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersStatus& operator=(const sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersStatus& coRef);
   sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersStatus(const sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_LanguageAndSpeaker, std::allocator<sds_fi_tcl_LanguageAndSpeaker> > LanguagesAndSpeaker;
   virtual ~sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgAvailableUserwordsGet : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgAvailableUserwordsGet();

   virtual ~sds_voicecontrolfi_tclMsgAvailableUserwordsGet();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgAvailableUserwordsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgAvailableUserwordsUpReg : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgAvailableUserwordsUpReg();

   virtual ~sds_voicecontrolfi_tclMsgAvailableUserwordsUpReg();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgAvailableUserwordsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgAvailableUserwordsRelUpReg : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgAvailableUserwordsRelUpReg();

   virtual ~sds_voicecontrolfi_tclMsgAvailableUserwordsRelUpReg();

   inline tBool operator==(const sds_voicecontrolfi_tclMsgAvailableUserwordsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_voicecontrolfi_tclMsgAvailableUserwordsStatus : public sds_voicecontrolfi_tclMsgBaseMessage
{
public:

   sds_voicecontrolfi_tclMsgAvailableUserwordsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_voicecontrolfi_tclMsgAvailableUserwordsStatus& operator=(const sds_voicecontrolfi_tclMsgAvailableUserwordsStatus& coRef);
   sds_voicecontrolfi_tclMsgAvailableUserwordsStatus(const sds_voicecontrolfi_tclMsgAvailableUserwordsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_Userword, std::allocator<sds_fi_tcl_Userword> > AvailableUserWords;
   virtual ~sds_voicecontrolfi_tclMsgAvailableUserwordsStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_voicecontrolfi_tclMsgAvailableUserwordsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
