/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
// =============================================================================
//
//                Factory for SDS_VOICECONTROL_FI message types

fi_tclMessageBase* sds_voicecontrolfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case sds_voicecontrolfi_tclToken::EN_MSG_PTTEVENTMETHODSTART:
         return OSAL_NEW sds_voicecontrolfi_tclMsgPTTEventMethodStart;

      case sds_voicecontrolfi_tclToken::EN_MSG_PTTEVENTMETHODRESULT:
         return OSAL_NEW sds_voicecontrolfi_tclMsgPTTEventMethodResult;

      case sds_voicecontrolfi_tclToken::EN_MSG_ABORTDIALOGMETHODSTART:
         return OSAL_NEW sds_voicecontrolfi_tclMsgAbortDialogMethodStart;

      case sds_voicecontrolfi_tclToken::EN_MSG_ABORTDIALOGMETHODRESULT:
         return OSAL_NEW sds_voicecontrolfi_tclMsgAbortDialogMethodResult;

      case sds_voicecontrolfi_tclToken::EN_MSG_RESETDIALOGMETHODSTART:
         return OSAL_NEW sds_voicecontrolfi_tclMsgResetDialogMethodStart;

      case sds_voicecontrolfi_tclToken::EN_MSG_RESETDIALOGMETHODRESULT:
         return OSAL_NEW sds_voicecontrolfi_tclMsgResetDialogMethodResult;

      case sds_voicecontrolfi_tclToken::EN_MSG_SETLANGUAGEANDSPEAKERMETHODSTART:
         return OSAL_NEW sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodStart;

      case sds_voicecontrolfi_tclToken::EN_MSG_SETLANGUAGEANDSPEAKERMETHODRESULTFIRST:
         return OSAL_NEW sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultFirst;

      case sds_voicecontrolfi_tclToken::EN_MSG_SETLANGUAGEANDSPEAKERMETHODRESULTMIDDLE:
         return OSAL_NEW sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultMiddle;

      case sds_voicecontrolfi_tclToken::EN_MSG_SETLANGUAGEANDSPEAKERMETHODRESULTLAST:
         return OSAL_NEW sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultLast;

      case sds_voicecontrolfi_tclToken::EN_MSG_SETHOMEDESTCOUNTRYMETHODSTART:
         return OSAL_NEW sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodStart;

      case sds_voicecontrolfi_tclToken::EN_MSG_SETHOMEDESTCOUNTRYMETHODRESULTFIRST:
         return OSAL_NEW sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultFirst;

      case sds_voicecontrolfi_tclToken::EN_MSG_SETHOMEDESTCOUNTRYMETHODRESULTMIDDLE:
         return OSAL_NEW sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultMiddle;

      case sds_voicecontrolfi_tclToken::EN_MSG_SETHOMEDESTCOUNTRYMETHODRESULTLAST:
         return OSAL_NEW sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultLast;

      case sds_voicecontrolfi_tclToken::EN_MSG_DOUPREGTOPROPERTIESMETHODSTART:
         return OSAL_NEW sds_voicecontrolfi_tclMsgDoUpRegToPropertiesMethodStart;

      case sds_voicecontrolfi_tclToken::EN_MSG_DOUPREGTOPROPERTIESMETHODRESULT:
         return OSAL_NEW sds_voicecontrolfi_tclMsgDoUpRegToPropertiesMethodResult;

      case sds_voicecontrolfi_tclToken::EN_MSG_SETVOICECONTROLSTATUSMETHODSTART:
         return OSAL_NEW sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodStart;

      case sds_voicecontrolfi_tclToken::EN_MSG_SETVOICECONTROLSTATUSMETHODRESULT:
         return OSAL_NEW sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodResult;

      case sds_voicecontrolfi_tclToken::EN_MSG_UPDATEALLUSERWORDSMETHODSTART:
         return OSAL_NEW sds_voicecontrolfi_tclMsgUpdateAllUserWordsMethodStart;

      case sds_voicecontrolfi_tclToken::EN_MSG_UPDATEALLUSERWORDSMETHODRESULT:
         return OSAL_NEW sds_voicecontrolfi_tclMsgUpdateAllUserWordsMethodResult;

      case sds_voicecontrolfi_tclToken::EN_MSG_UPDATEAVAILABLELANGUAGEANDSPEAKERMETHODSTART:
         return OSAL_NEW sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodStart;

      case sds_voicecontrolfi_tclToken::EN_MSG_UPDATEAVAILABLELANGUAGEANDSPEAKERMETHODRESULT:
         return OSAL_NEW sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodResult;

      case sds_voicecontrolfi_tclToken::EN_MSG_LOADDIALOGFILEMETHODSTART:
         return OSAL_NEW sds_voicecontrolfi_tclMsgLoadDialogFileMethodStart;

      case sds_voicecontrolfi_tclToken::EN_MSG_LOADDIALOGFILEMETHODRESULT:
         return OSAL_NEW sds_voicecontrolfi_tclMsgLoadDialogFileMethodResult;

      case sds_voicecontrolfi_tclToken::EN_MSG_UPDATERECOGNITIONSTAUSMETHODSTART:
         return OSAL_NEW sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodStart;

      case sds_voicecontrolfi_tclToken::EN_MSG_UPDATERECOGNITIONSTAUSMETHODRESULT:
         return OSAL_NEW sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodResult;

      case sds_voicecontrolfi_tclToken::EN_MSG_STARTUPGOODCASESMETHODSTART:
         return OSAL_NEW sds_voicecontrolfi_tclMsgStartUpGoodCasesMethodStart;

      case sds_voicecontrolfi_tclToken::EN_MSG_STARTUPGOODCASESMETHODRESULT:
         return OSAL_NEW sds_voicecontrolfi_tclMsgStartUpGoodCasesMethodResult;

      case sds_voicecontrolfi_tclToken::EN_MSG_STARTUPBADCASESMETHODSTART:
         return OSAL_NEW sds_voicecontrolfi_tclMsgStartUpBadCasesMethodStart;

      case sds_voicecontrolfi_tclToken::EN_MSG_STARTUPBADCASESMETHODRESULT:
         return OSAL_NEW sds_voicecontrolfi_tclMsgStartUpBadCasesMethodResult;

      case sds_voicecontrolfi_tclToken::EN_MSG_SERVICEAVAILABILTYOFSERVERSMETHODSTART:
         return OSAL_NEW sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodStart;

      case sds_voicecontrolfi_tclToken::EN_MSG_SERVICEAVAILABILTYOFSERVERSMETHODRESULT:
         return OSAL_NEW sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodResult;

      case sds_voicecontrolfi_tclToken::EN_MSG_SPEAKSENTENCEMETHODSTART:
         return OSAL_NEW sds_voicecontrolfi_tclMsgSpeakSentenceMethodStart;

      case sds_voicecontrolfi_tclToken::EN_MSG_SPEAKSENTENCEMETHODRESULT:
         return OSAL_NEW sds_voicecontrolfi_tclMsgSpeakSentenceMethodResult;

      case sds_voicecontrolfi_tclToken::EN_MSG_SDSDIAGNOSISTESTMETHODSTART:
         return OSAL_NEW sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodStart;

      case sds_voicecontrolfi_tclToken::EN_MSG_SDSDIAGNOSISTESTMETHODABORT:
         return OSAL_NEW sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodAbort;

      case sds_voicecontrolfi_tclToken::EN_MSG_SDSDIAGNOSISTESTMETHODRESULT:
         return OSAL_NEW sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodResult;

      case sds_voicecontrolfi_tclToken::EN_MSG_SDSDIAGNOSISTESTABORTRESULT:
         return OSAL_NEW sds_voicecontrolfi_tclMsgSDSDiagnosisTestAbortResult;

      case sds_voicecontrolfi_tclToken::EN_MSG_TIMEREXPIREDMETHODSTART:
         return OSAL_NEW sds_voicecontrolfi_tclMsgTIMEREXPIREDMethodStart;

      case sds_voicecontrolfi_tclToken::EN_MSG_TIMEREXPIREDMETHODRESULT:
         return OSAL_NEW sds_voicecontrolfi_tclMsgTIMEREXPIREDMethodResult;

      case sds_voicecontrolfi_tclToken::EN_MSG_INITIATECNTRYDWNLAFTERSTARTUPMETHODSTART:
         return OSAL_NEW sds_voicecontrolfi_tclMsgInitiateCntryDwnlAfterStartUpMethodStart;

      case sds_voicecontrolfi_tclToken::EN_MSG_INITIATECNTRYDWNLAFTERSTARTUPMETHODRESULT:
         return OSAL_NEW sds_voicecontrolfi_tclMsgInitiateCntryDwnlAfterStartUpMethodResult;

      case sds_voicecontrolfi_tclToken::EN_MSG_USEREVENTMETHODSTART:
         return OSAL_NEW sds_voicecontrolfi_tclMsgUserEventMethodStart;

      case sds_voicecontrolfi_tclToken::EN_MSG_USEREVENTMETHODRESULT:
         return OSAL_NEW sds_voicecontrolfi_tclMsgUserEventMethodResult;

      case sds_voicecontrolfi_tclToken::EN_MSG_RESUMESETTINGSREQUESTUPDATEMETHODSTART:
         return OSAL_NEW sds_voicecontrolfi_tclMsgResumeSettingsRequestUpdateMethodStart;

      case sds_voicecontrolfi_tclToken::EN_MSG_RESUMESETTINGSREQUESTUPDATEMETHODRESULT:
         return OSAL_NEW sds_voicecontrolfi_tclMsgResumeSettingsRequestUpdateMethodResult;

      case sds_voicecontrolfi_tclToken::EN_MSG_TRIGGERPTTMETHODSTART:
         return OSAL_NEW sds_voicecontrolfi_tclMsgTriggerPTTMethodStart;

      case sds_voicecontrolfi_tclToken::EN_MSG_TRIGGERPTTMETHODRESULT:
         return OSAL_NEW sds_voicecontrolfi_tclMsgTriggerPTTMethodResult;

      case sds_voicecontrolfi_tclToken::EN_MSG_VOICECONTROLSTATUSGET:
         return OSAL_NEW sds_voicecontrolfi_tclMsgVoicecontrolStatusGet;

      case sds_voicecontrolfi_tclToken::EN_MSG_VOICECONTROLSTATUSUPREG:
         return OSAL_NEW sds_voicecontrolfi_tclMsgVoicecontrolStatusUpReg;

      case sds_voicecontrolfi_tclToken::EN_MSG_VOICECONTROLSTATUSRELUPREG:
         return OSAL_NEW sds_voicecontrolfi_tclMsgVoicecontrolStatusRelUpReg;

      case sds_voicecontrolfi_tclToken::EN_MSG_VOICECONTROLSTATUSSTATUS:
         return OSAL_NEW sds_voicecontrolfi_tclMsgVoicecontrolStatusStatus;

      case sds_voicecontrolfi_tclToken::EN_MSG_LANGUAGEANDSPEAKERGET:
         return OSAL_NEW sds_voicecontrolfi_tclMsgLanguageandSpeakerGet;

      case sds_voicecontrolfi_tclToken::EN_MSG_LANGUAGEANDSPEAKERUPREG:
         return OSAL_NEW sds_voicecontrolfi_tclMsgLanguageandSpeakerUpReg;

      case sds_voicecontrolfi_tclToken::EN_MSG_LANGUAGEANDSPEAKERRELUPREG:
         return OSAL_NEW sds_voicecontrolfi_tclMsgLanguageandSpeakerRelUpReg;

      case sds_voicecontrolfi_tclToken::EN_MSG_LANGUAGEANDSPEAKERSTATUS:
         return OSAL_NEW sds_voicecontrolfi_tclMsgLanguageandSpeakerStatus;

      case sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLELANGUAGESANDSPEAKERSGET:
         return OSAL_NEW sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersGet;

      case sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLELANGUAGESANDSPEAKERSUPREG:
         return OSAL_NEW sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersUpReg;

      case sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLELANGUAGESANDSPEAKERSRELUPREG:
         return OSAL_NEW sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersRelUpReg;

      case sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLELANGUAGESANDSPEAKERSSTATUS:
         return OSAL_NEW sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersStatus;

      case sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLEUSERWORDSGET:
         return OSAL_NEW sds_voicecontrolfi_tclMsgAvailableUserwordsGet;

      case sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLEUSERWORDSUPREG:
         return OSAL_NEW sds_voicecontrolfi_tclMsgAvailableUserwordsUpReg;

      case sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLEUSERWORDSRELUPREG:
         return OSAL_NEW sds_voicecontrolfi_tclMsgAvailableUserwordsRelUpReg;

      case sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLEUSERWORDSSTATUS:
         return OSAL_NEW sds_voicecontrolfi_tclMsgAvailableUserwordsStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all sds_voicecontrolfifi messages

// common functions

tU16 sds_voicecontrolfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return SDS_VOICECONTROLFI_C_U16_SERVICE_ID;
}

tU16 sds_voicecontrolfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 sds_voicecontrolfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& sds_voicecontrolfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& sds_voicecontrolfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 sds_voicecontrolfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& sds_voicecontrolfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& sds_voicecontrolfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_voicecontrolfi_tclMsgPTTEventMethodStart::sds_voicecontrolfi_tclMsgPTTEventMethodStart(const sds_voicecontrolfi_tclMsgPTTEventMethodStart& coRef)
   : sds_voicecontrolfi_tclMsgBaseMessage(coRef)
{
   PushButtonOption = coRef.PushButtonOption;
}
sds_voicecontrolfi_tclMsgPTTEventMethodStart& sds_voicecontrolfi_tclMsgPTTEventMethodStart::operator=(const sds_voicecontrolfi_tclMsgPTTEventMethodStart& coRef)
{
   if (this == &coRef) return *this;
   PushButtonOption = coRef.PushButtonOption;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_voicecontrolfi_tclMsgPTTEventMethodStart::sds_voicecontrolfi_tclMsgPTTEventMethodStart()
:PushButtonOption()
 {}

tS32 sds_voicecontrolfi_tclMsgPTTEventMethodStart::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_PTTEVENTMETHODSTART;
}


sds_voicecontrolfi_tclMsgPTTEventMethodStart::~sds_voicecontrolfi_tclMsgPTTEventMethodStart()
{}

tU32 sds_voicecontrolfi_tclMsgPTTEventMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_voicecontrolfi_tclMsgPTTEventMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PushButtonOption);
   return oIn;
}

fi_tclOutContext& sds_voicecontrolfi_tclMsgPTTEventMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PushButtonOption);
   return oOut;
}

tBool sds_voicecontrolfi_tclMsgPTTEventMethodStart::operator==(const sds_voicecontrolfi_tclMsgPTTEventMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PushButtonOption == roRef.PushButtonOption);
   return bResult;
}

//=============================================================================

sds_voicecontrolfi_tclMsgPTTEventMethodResult::sds_voicecontrolfi_tclMsgPTTEventMethodResult()
 {}

tS32 sds_voicecontrolfi_tclMsgPTTEventMethodResult::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_PTTEVENTMETHODRESULT;
}


sds_voicecontrolfi_tclMsgPTTEventMethodResult::~sds_voicecontrolfi_tclMsgPTTEventMethodResult()
{}

//=============================================================================

sds_voicecontrolfi_tclMsgAbortDialogMethodStart::sds_voicecontrolfi_tclMsgAbortDialogMethodStart()
 {}

tS32 sds_voicecontrolfi_tclMsgAbortDialogMethodStart::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_ABORTDIALOGMETHODSTART;
}


sds_voicecontrolfi_tclMsgAbortDialogMethodStart::~sds_voicecontrolfi_tclMsgAbortDialogMethodStart()
{}

//=============================================================================

sds_voicecontrolfi_tclMsgAbortDialogMethodResult::sds_voicecontrolfi_tclMsgAbortDialogMethodResult()
 {}

tS32 sds_voicecontrolfi_tclMsgAbortDialogMethodResult::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_ABORTDIALOGMETHODRESULT;
}


sds_voicecontrolfi_tclMsgAbortDialogMethodResult::~sds_voicecontrolfi_tclMsgAbortDialogMethodResult()
{}

//=============================================================================

sds_voicecontrolfi_tclMsgResetDialogMethodStart::sds_voicecontrolfi_tclMsgResetDialogMethodStart()
 {}

tS32 sds_voicecontrolfi_tclMsgResetDialogMethodStart::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_RESETDIALOGMETHODSTART;
}


sds_voicecontrolfi_tclMsgResetDialogMethodStart::~sds_voicecontrolfi_tclMsgResetDialogMethodStart()
{}

//=============================================================================

sds_voicecontrolfi_tclMsgResetDialogMethodResult::sds_voicecontrolfi_tclMsgResetDialogMethodResult()
 {}

tS32 sds_voicecontrolfi_tclMsgResetDialogMethodResult::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_RESETDIALOGMETHODRESULT;
}


sds_voicecontrolfi_tclMsgResetDialogMethodResult::~sds_voicecontrolfi_tclMsgResetDialogMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodStart::sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodStart(const sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodStart& coRef)
   : sds_voicecontrolfi_tclMsgBaseMessage(coRef)
{
   LanguageAndSpeaker = coRef.LanguageAndSpeaker;
}
sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodStart& sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodStart::operator=(const sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageAndSpeaker = coRef.LanguageAndSpeaker;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodStart::vDestroy()
{
   LanguageAndSpeaker.vDestroy(); 
}

sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodStart::sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodStart()
:LanguageAndSpeaker()
 {}

tS32 sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodStart::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_SETLANGUAGEANDSPEAKERMETHODSTART;
}


sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodStart::~sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+LanguageAndSpeaker.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageAndSpeaker);
   return oIn;
}

fi_tclOutContext& sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageAndSpeaker);
   return oOut;
}

tBool sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodStart::operator==(const sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageAndSpeaker == roRef.LanguageAndSpeaker);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultFirst::sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultFirst(const sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultFirst& coRef)
   : sds_voicecontrolfi_tclMsgBaseMessage(coRef)
{
   Progress = coRef.Progress;
}
sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultFirst& sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultFirst::operator=(const sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultFirst& coRef)
{
   if (this == &coRef) return *this;
   Progress = coRef.Progress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultFirst::sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultFirst()
:Progress()
 {}

tS32 sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultFirst::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_SETLANGUAGEANDSPEAKERMETHODRESULTFIRST;
}


sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultFirst::~sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultFirst()
{}

tU32 sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultFirst::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultFirst::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Progress);
   return oIn;
}

fi_tclOutContext& sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultFirst::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Progress);
   return oOut;
}

tBool sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultFirst::operator==(const sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultFirst& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Progress == roRef.Progress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultMiddle::sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultMiddle(const sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultMiddle& coRef)
   : sds_voicecontrolfi_tclMsgBaseMessage(coRef)
{
   Progress = coRef.Progress;
}
sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultMiddle& sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultMiddle::operator=(const sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultMiddle& coRef)
{
   if (this == &coRef) return *this;
   Progress = coRef.Progress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultMiddle::sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultMiddle()
:Progress()
 {}

tS32 sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultMiddle::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_SETLANGUAGEANDSPEAKERMETHODRESULTMIDDLE;
}


sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultMiddle::~sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultMiddle()
{}

tU32 sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultMiddle::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultMiddle::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Progress);
   return oIn;
}

fi_tclOutContext& sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultMiddle::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Progress);
   return oOut;
}

tBool sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultMiddle::operator==(const sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultMiddle& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Progress == roRef.Progress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultLast::sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultLast(const sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultLast& coRef)
   : sds_voicecontrolfi_tclMsgBaseMessage(coRef)
{
   Progress = coRef.Progress;
}
sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultLast& sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultLast::operator=(const sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultLast& coRef)
{
   if (this == &coRef) return *this;
   Progress = coRef.Progress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultLast::sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultLast()
:Progress()
 {}

tS32 sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultLast::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_SETLANGUAGEANDSPEAKERMETHODRESULTLAST;
}


sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultLast::~sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultLast()
{}

tU32 sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultLast::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultLast::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Progress);
   return oIn;
}

fi_tclOutContext& sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultLast::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Progress);
   return oOut;
}

tBool sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultLast::operator==(const sds_voicecontrolfi_tclMsgSetLanguageAndSpeakerMethodResultLast& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Progress == roRef.Progress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodStart::sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodStart(const sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodStart& coRef)
   : sds_voicecontrolfi_tclMsgBaseMessage(coRef)
{
   HomeDestCountry = coRef.HomeDestCountry;
}
sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodStart& sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodStart::operator=(const sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodStart& coRef)
{
   if (this == &coRef) return *this;
   HomeDestCountry = coRef.HomeDestCountry;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodStart::vDestroy()
{
   HomeDestCountry.vDestroy(); 
}

sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodStart::sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodStart()
:HomeDestCountry()
 {}

tS32 sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodStart::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_SETHOMEDESTCOUNTRYMETHODSTART;
}


sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodStart::~sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+HomeDestCountry.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> HomeDestCountry);
   return oIn;
}

fi_tclOutContext& sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << HomeDestCountry);
   return oOut;
}

tBool sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodStart::operator==(const sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (HomeDestCountry == roRef.HomeDestCountry);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultFirst::sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultFirst(const sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultFirst& coRef)
   : sds_voicecontrolfi_tclMsgBaseMessage(coRef)
{
   Progress = coRef.Progress;
}
sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultFirst& sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultFirst::operator=(const sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultFirst& coRef)
{
   if (this == &coRef) return *this;
   Progress = coRef.Progress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultFirst::sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultFirst()
:Progress()
 {}

tS32 sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultFirst::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_SETHOMEDESTCOUNTRYMETHODRESULTFIRST;
}


sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultFirst::~sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultFirst()
{}

tU32 sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultFirst::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultFirst::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Progress);
   return oIn;
}

fi_tclOutContext& sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultFirst::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Progress);
   return oOut;
}

tBool sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultFirst::operator==(const sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultFirst& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Progress == roRef.Progress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultMiddle::sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultMiddle(const sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultMiddle& coRef)
   : sds_voicecontrolfi_tclMsgBaseMessage(coRef)
{
   Progress = coRef.Progress;
}
sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultMiddle& sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultMiddle::operator=(const sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultMiddle& coRef)
{
   if (this == &coRef) return *this;
   Progress = coRef.Progress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultMiddle::sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultMiddle()
:Progress()
 {}

tS32 sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultMiddle::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_SETHOMEDESTCOUNTRYMETHODRESULTMIDDLE;
}


sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultMiddle::~sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultMiddle()
{}

tU32 sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultMiddle::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultMiddle::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Progress);
   return oIn;
}

fi_tclOutContext& sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultMiddle::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Progress);
   return oOut;
}

tBool sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultMiddle::operator==(const sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultMiddle& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Progress == roRef.Progress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultLast::sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultLast(const sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultLast& coRef)
   : sds_voicecontrolfi_tclMsgBaseMessage(coRef)
{
   Progress = coRef.Progress;
}
sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultLast& sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultLast::operator=(const sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultLast& coRef)
{
   if (this == &coRef) return *this;
   Progress = coRef.Progress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultLast::sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultLast()
:Progress()
 {}

tS32 sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultLast::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_SETHOMEDESTCOUNTRYMETHODRESULTLAST;
}


sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultLast::~sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultLast()
{}

tU32 sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultLast::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultLast::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Progress);
   return oIn;
}

fi_tclOutContext& sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultLast::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Progress);
   return oOut;
}

tBool sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultLast::operator==(const sds_voicecontrolfi_tclMsgSetHomeDestCountryMethodResultLast& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Progress == roRef.Progress);
   return bResult;
}

//=============================================================================

sds_voicecontrolfi_tclMsgDoUpRegToPropertiesMethodStart::sds_voicecontrolfi_tclMsgDoUpRegToPropertiesMethodStart()
 {}

tS32 sds_voicecontrolfi_tclMsgDoUpRegToPropertiesMethodStart::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_DOUPREGTOPROPERTIESMETHODSTART;
}


sds_voicecontrolfi_tclMsgDoUpRegToPropertiesMethodStart::~sds_voicecontrolfi_tclMsgDoUpRegToPropertiesMethodStart()
{}

//=============================================================================

sds_voicecontrolfi_tclMsgDoUpRegToPropertiesMethodResult::sds_voicecontrolfi_tclMsgDoUpRegToPropertiesMethodResult()
 {}

tS32 sds_voicecontrolfi_tclMsgDoUpRegToPropertiesMethodResult::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_DOUPREGTOPROPERTIESMETHODRESULT;
}


sds_voicecontrolfi_tclMsgDoUpRegToPropertiesMethodResult::~sds_voicecontrolfi_tclMsgDoUpRegToPropertiesMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodStart::sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodStart(const sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodStart& coRef)
   : sds_voicecontrolfi_tclMsgBaseMessage(coRef)
{
   VoiceControlStatus = coRef.VoiceControlStatus;
}
sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodStart& sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodStart::operator=(const sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   VoiceControlStatus = coRef.VoiceControlStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodStart::sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodStart()
:VoiceControlStatus()
 {}

tS32 sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodStart::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_SETVOICECONTROLSTATUSMETHODSTART;
}


sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodStart::~sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodStart()
{}

tU32 sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VoiceControlStatus);
   return oIn;
}

fi_tclOutContext& sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VoiceControlStatus);
   return oOut;
}

tBool sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodStart::operator==(const sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VoiceControlStatus == roRef.VoiceControlStatus);
   return bResult;
}

//=============================================================================

sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodResult::sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodResult()
 {}

tS32 sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodResult::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_SETVOICECONTROLSTATUSMETHODRESULT;
}


sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodResult::~sds_voicecontrolfi_tclMsgSetVoiceControlStatusMethodResult()
{}

//=============================================================================

sds_voicecontrolfi_tclMsgUpdateAllUserWordsMethodStart::sds_voicecontrolfi_tclMsgUpdateAllUserWordsMethodStart()
 {}

tS32 sds_voicecontrolfi_tclMsgUpdateAllUserWordsMethodStart::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_UPDATEALLUSERWORDSMETHODSTART;
}


sds_voicecontrolfi_tclMsgUpdateAllUserWordsMethodStart::~sds_voicecontrolfi_tclMsgUpdateAllUserWordsMethodStart()
{}

//=============================================================================

sds_voicecontrolfi_tclMsgUpdateAllUserWordsMethodResult::sds_voicecontrolfi_tclMsgUpdateAllUserWordsMethodResult()
 {}

tS32 sds_voicecontrolfi_tclMsgUpdateAllUserWordsMethodResult::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_UPDATEALLUSERWORDSMETHODRESULT;
}


sds_voicecontrolfi_tclMsgUpdateAllUserWordsMethodResult::~sds_voicecontrolfi_tclMsgUpdateAllUserWordsMethodResult()
{}

//=============================================================================

sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodStart::sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodStart()
 {}

tS32 sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodStart::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_UPDATEAVAILABLELANGUAGEANDSPEAKERMETHODSTART;
}


sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodStart::~sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodResult::sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodResult(const sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodResult& coRef)
   : sds_voicecontrolfi_tclMsgBaseMessage(coRef)
{
   LanguagesAndSpeaker = coRef.LanguagesAndSpeaker;
}
sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodResult& sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodResult::operator=(const sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodResult& coRef)
{
   if (this == &coRef) return *this;
   LanguagesAndSpeaker = coRef.LanguagesAndSpeaker;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < LanguagesAndSpeaker.size(); ++u32Idx)
         LanguagesAndSpeaker[u32Idx].vDestroy();
   LanguagesAndSpeaker.clear();
   }
}

sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodResult::sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodResult()

 {}

tS32 sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodResult::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_UPDATEAVAILABLELANGUAGEANDSPEAKERMETHODRESULT;
}


sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodResult::~sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < LanguagesAndSpeaker.size(); ++u32ListIdx)
      u32DynamicSize += LanguagesAndSpeaker[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < LanguagesAndSpeaker.size(); ++u32Idx)
      {
         LanguagesAndSpeaker[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      LanguagesAndSpeaker.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> LanguagesAndSpeaker[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)LanguagesAndSpeaker.size());
   {
      for (tU32 u32Idx = 0; u32Idx < LanguagesAndSpeaker.size(); ++u32Idx)
         (tVoid) (oOut << LanguagesAndSpeaker[u32Idx]);
   }
   return oOut;
}

tBool sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodResult::operator==(const sds_voicecontrolfi_tclMsgUpdateAvailableLanguageAndSpeakerMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (LanguagesAndSpeaker.size() == roRef.LanguagesAndSpeaker.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < LanguagesAndSpeaker.size()); ++u32Idx)
            bResult = bResult && (LanguagesAndSpeaker[u32Idx] == roRef.LanguagesAndSpeaker[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_voicecontrolfi_tclMsgLoadDialogFileMethodStart::sds_voicecontrolfi_tclMsgLoadDialogFileMethodStart(const sds_voicecontrolfi_tclMsgLoadDialogFileMethodStart& coRef)
   : sds_voicecontrolfi_tclMsgBaseMessage(coRef)
{
   DialogPath = coRef.DialogPath;
}
sds_voicecontrolfi_tclMsgLoadDialogFileMethodStart& sds_voicecontrolfi_tclMsgLoadDialogFileMethodStart::operator=(const sds_voicecontrolfi_tclMsgLoadDialogFileMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DialogPath = coRef.DialogPath;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_voicecontrolfi_tclMsgLoadDialogFileMethodStart::vDestroy()
{
   DialogPath.vDestroy();
}

sds_voicecontrolfi_tclMsgLoadDialogFileMethodStart::sds_voicecontrolfi_tclMsgLoadDialogFileMethodStart()
:DialogPath()
 {}

tS32 sds_voicecontrolfi_tclMsgLoadDialogFileMethodStart::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_LOADDIALOGFILEMETHODSTART;
}


sds_voicecontrolfi_tclMsgLoadDialogFileMethodStart::~sds_voicecontrolfi_tclMsgLoadDialogFileMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_voicecontrolfi_tclMsgLoadDialogFileMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+DialogPath.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_voicecontrolfi_tclMsgLoadDialogFileMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DialogPath);
   return oIn;
}

fi_tclOutContext& sds_voicecontrolfi_tclMsgLoadDialogFileMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DialogPath);
   return oOut;
}

tBool sds_voicecontrolfi_tclMsgLoadDialogFileMethodStart::operator==(const sds_voicecontrolfi_tclMsgLoadDialogFileMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DialogPath == roRef.DialogPath);
   return bResult;
}

//=============================================================================

sds_voicecontrolfi_tclMsgLoadDialogFileMethodResult::sds_voicecontrolfi_tclMsgLoadDialogFileMethodResult()
 {}

tS32 sds_voicecontrolfi_tclMsgLoadDialogFileMethodResult::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_LOADDIALOGFILEMETHODRESULT;
}


sds_voicecontrolfi_tclMsgLoadDialogFileMethodResult::~sds_voicecontrolfi_tclMsgLoadDialogFileMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodStart::sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodStart(const sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodStart& coRef)
   : sds_voicecontrolfi_tclMsgBaseMessage(coRef)
{
   RecognizerStatus = coRef.RecognizerStatus;
}
sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodStart& sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodStart::operator=(const sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RecognizerStatus = coRef.RecognizerStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodStart::sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodStart()
:RecognizerStatus()
 {}

tS32 sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodStart::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_UPDATERECOGNITIONSTAUSMETHODSTART;
}


sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodStart::~sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodStart()
{}

tU32 sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RecognizerStatus);
   return oIn;
}

fi_tclOutContext& sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RecognizerStatus);
   return oOut;
}

tBool sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodStart::operator==(const sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RecognizerStatus == roRef.RecognizerStatus);
   return bResult;
}

//=============================================================================

sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodResult::sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodResult()
 {}

tS32 sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodResult::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_UPDATERECOGNITIONSTAUSMETHODRESULT;
}


sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodResult::~sds_voicecontrolfi_tclMsgUpdateRecognitionStausMethodResult()
{}

//=============================================================================

sds_voicecontrolfi_tclMsgStartUpGoodCasesMethodStart::sds_voicecontrolfi_tclMsgStartUpGoodCasesMethodStart()
 {}

tS32 sds_voicecontrolfi_tclMsgStartUpGoodCasesMethodStart::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_STARTUPGOODCASESMETHODSTART;
}


sds_voicecontrolfi_tclMsgStartUpGoodCasesMethodStart::~sds_voicecontrolfi_tclMsgStartUpGoodCasesMethodStart()
{}

//=============================================================================

sds_voicecontrolfi_tclMsgStartUpGoodCasesMethodResult::sds_voicecontrolfi_tclMsgStartUpGoodCasesMethodResult()
 {}

tS32 sds_voicecontrolfi_tclMsgStartUpGoodCasesMethodResult::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_STARTUPGOODCASESMETHODRESULT;
}


sds_voicecontrolfi_tclMsgStartUpGoodCasesMethodResult::~sds_voicecontrolfi_tclMsgStartUpGoodCasesMethodResult()
{}

//=============================================================================

sds_voicecontrolfi_tclMsgStartUpBadCasesMethodStart::sds_voicecontrolfi_tclMsgStartUpBadCasesMethodStart()
 {}

tS32 sds_voicecontrolfi_tclMsgStartUpBadCasesMethodStart::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_STARTUPBADCASESMETHODSTART;
}


sds_voicecontrolfi_tclMsgStartUpBadCasesMethodStart::~sds_voicecontrolfi_tclMsgStartUpBadCasesMethodStart()
{}

//=============================================================================

sds_voicecontrolfi_tclMsgStartUpBadCasesMethodResult::sds_voicecontrolfi_tclMsgStartUpBadCasesMethodResult()
 {}

tS32 sds_voicecontrolfi_tclMsgStartUpBadCasesMethodResult::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_STARTUPBADCASESMETHODRESULT;
}


sds_voicecontrolfi_tclMsgStartUpBadCasesMethodResult::~sds_voicecontrolfi_tclMsgStartUpBadCasesMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodStart::sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodStart(const sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodStart& coRef)
   : sds_voicecontrolfi_tclMsgBaseMessage(coRef)
{
   ServicesAvailable = coRef.ServicesAvailable;
}
sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodStart& sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodStart::operator=(const sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ServicesAvailable = coRef.ServicesAvailable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodStart::sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodStart()
:ServicesAvailable(0)
 {}

tS32 sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodStart::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_SERVICEAVAILABILTYOFSERVERSMETHODSTART;
}


sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodStart::~sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodStart()
{}

tU32 sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServicesAvailable);
   return oIn;
}

fi_tclOutContext& sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServicesAvailable);
   return oOut;
}

tBool sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodStart::operator==(const sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServicesAvailable == roRef.ServicesAvailable);
   return bResult;
}

//=============================================================================

sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodResult::sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodResult()
 {}

tS32 sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodResult::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_SERVICEAVAILABILTYOFSERVERSMETHODRESULT;
}


sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodResult::~sds_voicecontrolfi_tclMsgServiceAvailabiltyOfServersMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_voicecontrolfi_tclMsgSpeakSentenceMethodStart::sds_voicecontrolfi_tclMsgSpeakSentenceMethodStart(const sds_voicecontrolfi_tclMsgSpeakSentenceMethodStart& coRef)
   : sds_voicecontrolfi_tclMsgBaseMessage(coRef)
{
   e8SentenceId = coRef.e8SentenceId;
}
sds_voicecontrolfi_tclMsgSpeakSentenceMethodStart& sds_voicecontrolfi_tclMsgSpeakSentenceMethodStart::operator=(const sds_voicecontrolfi_tclMsgSpeakSentenceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8SentenceId = coRef.e8SentenceId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_voicecontrolfi_tclMsgSpeakSentenceMethodStart::sds_voicecontrolfi_tclMsgSpeakSentenceMethodStart()
:e8SentenceId()
 {}

tS32 sds_voicecontrolfi_tclMsgSpeakSentenceMethodStart::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_SPEAKSENTENCEMETHODSTART;
}


sds_voicecontrolfi_tclMsgSpeakSentenceMethodStart::~sds_voicecontrolfi_tclMsgSpeakSentenceMethodStart()
{}

tU32 sds_voicecontrolfi_tclMsgSpeakSentenceMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_voicecontrolfi_tclMsgSpeakSentenceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8SentenceId);
   return oIn;
}

fi_tclOutContext& sds_voicecontrolfi_tclMsgSpeakSentenceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8SentenceId);
   return oOut;
}

tBool sds_voicecontrolfi_tclMsgSpeakSentenceMethodStart::operator==(const sds_voicecontrolfi_tclMsgSpeakSentenceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8SentenceId == roRef.e8SentenceId);
   return bResult;
}

//=============================================================================

sds_voicecontrolfi_tclMsgSpeakSentenceMethodResult::sds_voicecontrolfi_tclMsgSpeakSentenceMethodResult()
 {}

tS32 sds_voicecontrolfi_tclMsgSpeakSentenceMethodResult::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_SPEAKSENTENCEMETHODRESULT;
}


sds_voicecontrolfi_tclMsgSpeakSentenceMethodResult::~sds_voicecontrolfi_tclMsgSpeakSentenceMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodStart::sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodStart(const sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodStart& coRef)
   : sds_voicecontrolfi_tclMsgBaseMessage(coRef)
{
   e8Testcase = coRef.e8Testcase;
}
sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodStart& sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodStart::operator=(const sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8Testcase = coRef.e8Testcase;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodStart::sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodStart()
:e8Testcase()
 {}

tS32 sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodStart::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_SDSDIAGNOSISTESTMETHODSTART;
}


sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodStart::~sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodStart()
{}

tU32 sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Testcase);
   return oIn;
}

fi_tclOutContext& sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Testcase);
   return oOut;
}

tBool sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodStart::operator==(const sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Testcase == roRef.e8Testcase);
   return bResult;
}

//=============================================================================

sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodAbort::sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodAbort()
 {}

tS32 sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodAbort::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_SDSDIAGNOSISTESTMETHODABORT;
}


sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodAbort::~sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodAbort()
{}

//=============================================================================

sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodResult::sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodResult()
 {}

tS32 sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodResult::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_SDSDIAGNOSISTESTMETHODRESULT;
}


sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodResult::~sds_voicecontrolfi_tclMsgSDSDiagnosisTestMethodResult()
{}

//=============================================================================

sds_voicecontrolfi_tclMsgSDSDiagnosisTestAbortResult::sds_voicecontrolfi_tclMsgSDSDiagnosisTestAbortResult()
 {}

tS32 sds_voicecontrolfi_tclMsgSDSDiagnosisTestAbortResult::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_SDSDIAGNOSISTESTABORTRESULT;
}


sds_voicecontrolfi_tclMsgSDSDiagnosisTestAbortResult::~sds_voicecontrolfi_tclMsgSDSDiagnosisTestAbortResult()
{}

//=============================================================================

sds_voicecontrolfi_tclMsgTIMEREXPIREDMethodStart::sds_voicecontrolfi_tclMsgTIMEREXPIREDMethodStart()
 {}

tS32 sds_voicecontrolfi_tclMsgTIMEREXPIREDMethodStart::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_TIMEREXPIREDMETHODSTART;
}


sds_voicecontrolfi_tclMsgTIMEREXPIREDMethodStart::~sds_voicecontrolfi_tclMsgTIMEREXPIREDMethodStart()
{}

//=============================================================================

sds_voicecontrolfi_tclMsgTIMEREXPIREDMethodResult::sds_voicecontrolfi_tclMsgTIMEREXPIREDMethodResult()
 {}

tS32 sds_voicecontrolfi_tclMsgTIMEREXPIREDMethodResult::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_TIMEREXPIREDMETHODRESULT;
}


sds_voicecontrolfi_tclMsgTIMEREXPIREDMethodResult::~sds_voicecontrolfi_tclMsgTIMEREXPIREDMethodResult()
{}

//=============================================================================

sds_voicecontrolfi_tclMsgInitiateCntryDwnlAfterStartUpMethodStart::sds_voicecontrolfi_tclMsgInitiateCntryDwnlAfterStartUpMethodStart()
 {}

tS32 sds_voicecontrolfi_tclMsgInitiateCntryDwnlAfterStartUpMethodStart::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_INITIATECNTRYDWNLAFTERSTARTUPMETHODSTART;
}


sds_voicecontrolfi_tclMsgInitiateCntryDwnlAfterStartUpMethodStart::~sds_voicecontrolfi_tclMsgInitiateCntryDwnlAfterStartUpMethodStart()
{}

//=============================================================================

sds_voicecontrolfi_tclMsgInitiateCntryDwnlAfterStartUpMethodResult::sds_voicecontrolfi_tclMsgInitiateCntryDwnlAfterStartUpMethodResult()
 {}

tS32 sds_voicecontrolfi_tclMsgInitiateCntryDwnlAfterStartUpMethodResult::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_INITIATECNTRYDWNLAFTERSTARTUPMETHODRESULT;
}


sds_voicecontrolfi_tclMsgInitiateCntryDwnlAfterStartUpMethodResult::~sds_voicecontrolfi_tclMsgInitiateCntryDwnlAfterStartUpMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_voicecontrolfi_tclMsgUserEventMethodStart::sds_voicecontrolfi_tclMsgUserEventMethodStart(const sds_voicecontrolfi_tclMsgUserEventMethodStart& coRef)
   : sds_voicecontrolfi_tclMsgBaseMessage(coRef)
{
   u8UserEventID = coRef.u8UserEventID;
   sUserEventString = coRef.sUserEventString;
}
sds_voicecontrolfi_tclMsgUserEventMethodStart& sds_voicecontrolfi_tclMsgUserEventMethodStart::operator=(const sds_voicecontrolfi_tclMsgUserEventMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8UserEventID = coRef.u8UserEventID;
   sUserEventString = coRef.sUserEventString;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_voicecontrolfi_tclMsgUserEventMethodStart::vDestroy()
{
   sUserEventString.vDestroy();
}

sds_voicecontrolfi_tclMsgUserEventMethodStart::sds_voicecontrolfi_tclMsgUserEventMethodStart()
:u8UserEventID(0)
,sUserEventString()
 {}

tS32 sds_voicecontrolfi_tclMsgUserEventMethodStart::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_USEREVENTMETHODSTART;
}


sds_voicecontrolfi_tclMsgUserEventMethodStart::~sds_voicecontrolfi_tclMsgUserEventMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_voicecontrolfi_tclMsgUserEventMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sUserEventString.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_voicecontrolfi_tclMsgUserEventMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8UserEventID);
   (tVoid) (oIn >> sUserEventString);
   return oIn;
}

fi_tclOutContext& sds_voicecontrolfi_tclMsgUserEventMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8UserEventID);
   (tVoid) (oOut << sUserEventString);
   return oOut;
}

tBool sds_voicecontrolfi_tclMsgUserEventMethodStart::operator==(const sds_voicecontrolfi_tclMsgUserEventMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8UserEventID == roRef.u8UserEventID);
   bResult = bResult && (sUserEventString == roRef.sUserEventString);
   return bResult;
}

//=============================================================================

sds_voicecontrolfi_tclMsgUserEventMethodResult::sds_voicecontrolfi_tclMsgUserEventMethodResult()
 {}

tS32 sds_voicecontrolfi_tclMsgUserEventMethodResult::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_USEREVENTMETHODRESULT;
}


sds_voicecontrolfi_tclMsgUserEventMethodResult::~sds_voicecontrolfi_tclMsgUserEventMethodResult()
{}

//=============================================================================

sds_voicecontrolfi_tclMsgResumeSettingsRequestUpdateMethodStart::sds_voicecontrolfi_tclMsgResumeSettingsRequestUpdateMethodStart()
 {}

tS32 sds_voicecontrolfi_tclMsgResumeSettingsRequestUpdateMethodStart::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_RESUMESETTINGSREQUESTUPDATEMETHODSTART;
}


sds_voicecontrolfi_tclMsgResumeSettingsRequestUpdateMethodStart::~sds_voicecontrolfi_tclMsgResumeSettingsRequestUpdateMethodStart()
{}

//=============================================================================

sds_voicecontrolfi_tclMsgResumeSettingsRequestUpdateMethodResult::sds_voicecontrolfi_tclMsgResumeSettingsRequestUpdateMethodResult()
 {}

tS32 sds_voicecontrolfi_tclMsgResumeSettingsRequestUpdateMethodResult::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_RESUMESETTINGSREQUESTUPDATEMETHODRESULT;
}


sds_voicecontrolfi_tclMsgResumeSettingsRequestUpdateMethodResult::~sds_voicecontrolfi_tclMsgResumeSettingsRequestUpdateMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_voicecontrolfi_tclMsgTriggerPTTMethodStart::sds_voicecontrolfi_tclMsgTriggerPTTMethodStart(const sds_voicecontrolfi_tclMsgTriggerPTTMethodStart& coRef)
   : sds_voicecontrolfi_tclMsgBaseMessage(coRef)
{
   Value = coRef.Value;
}
sds_voicecontrolfi_tclMsgTriggerPTTMethodStart& sds_voicecontrolfi_tclMsgTriggerPTTMethodStart::operator=(const sds_voicecontrolfi_tclMsgTriggerPTTMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Value = coRef.Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_voicecontrolfi_tclMsgTriggerPTTMethodStart::sds_voicecontrolfi_tclMsgTriggerPTTMethodStart()
:Value(0)
 {}

tS32 sds_voicecontrolfi_tclMsgTriggerPTTMethodStart::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_TRIGGERPTTMETHODSTART;
}


sds_voicecontrolfi_tclMsgTriggerPTTMethodStart::~sds_voicecontrolfi_tclMsgTriggerPTTMethodStart()
{}

tU32 sds_voicecontrolfi_tclMsgTriggerPTTMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_voicecontrolfi_tclMsgTriggerPTTMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Value);
   return oIn;
}

fi_tclOutContext& sds_voicecontrolfi_tclMsgTriggerPTTMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Value);
   return oOut;
}

tBool sds_voicecontrolfi_tclMsgTriggerPTTMethodStart::operator==(const sds_voicecontrolfi_tclMsgTriggerPTTMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Value == roRef.Value);
   return bResult;
}

//=============================================================================

sds_voicecontrolfi_tclMsgTriggerPTTMethodResult::sds_voicecontrolfi_tclMsgTriggerPTTMethodResult()
 {}

tS32 sds_voicecontrolfi_tclMsgTriggerPTTMethodResult::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_TRIGGERPTTMETHODRESULT;
}


sds_voicecontrolfi_tclMsgTriggerPTTMethodResult::~sds_voicecontrolfi_tclMsgTriggerPTTMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_voicecontrolfi_tclMsgVoicecontrolStatusGet::sds_voicecontrolfi_tclMsgVoicecontrolStatusGet(const sds_voicecontrolfi_tclMsgVoicecontrolStatusGet& coRef)
   : sds_voicecontrolfi_tclMsgBaseMessage(coRef)
{
   VoiceControlStatus = coRef.VoiceControlStatus;
}
sds_voicecontrolfi_tclMsgVoicecontrolStatusGet& sds_voicecontrolfi_tclMsgVoicecontrolStatusGet::operator=(const sds_voicecontrolfi_tclMsgVoicecontrolStatusGet& coRef)
{
   if (this == &coRef) return *this;
   VoiceControlStatus = coRef.VoiceControlStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_voicecontrolfi_tclMsgVoicecontrolStatusGet::sds_voicecontrolfi_tclMsgVoicecontrolStatusGet()
:VoiceControlStatus()
 {}

tS32 sds_voicecontrolfi_tclMsgVoicecontrolStatusGet::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_VOICECONTROLSTATUSGET;
}


sds_voicecontrolfi_tclMsgVoicecontrolStatusGet::~sds_voicecontrolfi_tclMsgVoicecontrolStatusGet()
{}

tU32 sds_voicecontrolfi_tclMsgVoicecontrolStatusGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_voicecontrolfi_tclMsgVoicecontrolStatusGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VoiceControlStatus);
   return oIn;
}

fi_tclOutContext& sds_voicecontrolfi_tclMsgVoicecontrolStatusGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VoiceControlStatus);
   return oOut;
}

tBool sds_voicecontrolfi_tclMsgVoicecontrolStatusGet::operator==(const sds_voicecontrolfi_tclMsgVoicecontrolStatusGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VoiceControlStatus == roRef.VoiceControlStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_voicecontrolfi_tclMsgVoicecontrolStatusUpReg::sds_voicecontrolfi_tclMsgVoicecontrolStatusUpReg(const sds_voicecontrolfi_tclMsgVoicecontrolStatusUpReg& coRef)
   : sds_voicecontrolfi_tclMsgBaseMessage(coRef)
{
   VoiceControlStatus = coRef.VoiceControlStatus;
}
sds_voicecontrolfi_tclMsgVoicecontrolStatusUpReg& sds_voicecontrolfi_tclMsgVoicecontrolStatusUpReg::operator=(const sds_voicecontrolfi_tclMsgVoicecontrolStatusUpReg& coRef)
{
   if (this == &coRef) return *this;
   VoiceControlStatus = coRef.VoiceControlStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_voicecontrolfi_tclMsgVoicecontrolStatusUpReg::sds_voicecontrolfi_tclMsgVoicecontrolStatusUpReg()
:VoiceControlStatus()
 {}

tS32 sds_voicecontrolfi_tclMsgVoicecontrolStatusUpReg::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_VOICECONTROLSTATUSUPREG;
}


sds_voicecontrolfi_tclMsgVoicecontrolStatusUpReg::~sds_voicecontrolfi_tclMsgVoicecontrolStatusUpReg()
{}

tU32 sds_voicecontrolfi_tclMsgVoicecontrolStatusUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_voicecontrolfi_tclMsgVoicecontrolStatusUpReg::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VoiceControlStatus);
   return oIn;
}

fi_tclOutContext& sds_voicecontrolfi_tclMsgVoicecontrolStatusUpReg::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VoiceControlStatus);
   return oOut;
}

tBool sds_voicecontrolfi_tclMsgVoicecontrolStatusUpReg::operator==(const sds_voicecontrolfi_tclMsgVoicecontrolStatusUpReg& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VoiceControlStatus == roRef.VoiceControlStatus);
   return bResult;
}

//=============================================================================

sds_voicecontrolfi_tclMsgVoicecontrolStatusRelUpReg::sds_voicecontrolfi_tclMsgVoicecontrolStatusRelUpReg()
 {}

tS32 sds_voicecontrolfi_tclMsgVoicecontrolStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_VOICECONTROLSTATUSRELUPREG;
}


sds_voicecontrolfi_tclMsgVoicecontrolStatusRelUpReg::~sds_voicecontrolfi_tclMsgVoicecontrolStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_voicecontrolfi_tclMsgVoicecontrolStatusStatus::sds_voicecontrolfi_tclMsgVoicecontrolStatusStatus(const sds_voicecontrolfi_tclMsgVoicecontrolStatusStatus& coRef)
   : sds_voicecontrolfi_tclMsgBaseMessage(coRef)
{
   VoiceControlStatus = coRef.VoiceControlStatus;
}
sds_voicecontrolfi_tclMsgVoicecontrolStatusStatus& sds_voicecontrolfi_tclMsgVoicecontrolStatusStatus::operator=(const sds_voicecontrolfi_tclMsgVoicecontrolStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   VoiceControlStatus = coRef.VoiceControlStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_voicecontrolfi_tclMsgVoicecontrolStatusStatus::sds_voicecontrolfi_tclMsgVoicecontrolStatusStatus()
:VoiceControlStatus()
 {}

tS32 sds_voicecontrolfi_tclMsgVoicecontrolStatusStatus::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_VOICECONTROLSTATUSSTATUS;
}


sds_voicecontrolfi_tclMsgVoicecontrolStatusStatus::~sds_voicecontrolfi_tclMsgVoicecontrolStatusStatus()
{}

tU32 sds_voicecontrolfi_tclMsgVoicecontrolStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_voicecontrolfi_tclMsgVoicecontrolStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VoiceControlStatus);
   return oIn;
}

fi_tclOutContext& sds_voicecontrolfi_tclMsgVoicecontrolStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VoiceControlStatus);
   return oOut;
}

tBool sds_voicecontrolfi_tclMsgVoicecontrolStatusStatus::operator==(const sds_voicecontrolfi_tclMsgVoicecontrolStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VoiceControlStatus == roRef.VoiceControlStatus);
   return bResult;
}

//=============================================================================

sds_voicecontrolfi_tclMsgLanguageandSpeakerGet::sds_voicecontrolfi_tclMsgLanguageandSpeakerGet()
 {}

tS32 sds_voicecontrolfi_tclMsgLanguageandSpeakerGet::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_LANGUAGEANDSPEAKERGET;
}


sds_voicecontrolfi_tclMsgLanguageandSpeakerGet::~sds_voicecontrolfi_tclMsgLanguageandSpeakerGet()
{}

//=============================================================================

sds_voicecontrolfi_tclMsgLanguageandSpeakerUpReg::sds_voicecontrolfi_tclMsgLanguageandSpeakerUpReg()
 {}

tS32 sds_voicecontrolfi_tclMsgLanguageandSpeakerUpReg::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_LANGUAGEANDSPEAKERUPREG;
}


sds_voicecontrolfi_tclMsgLanguageandSpeakerUpReg::~sds_voicecontrolfi_tclMsgLanguageandSpeakerUpReg()
{}

//=============================================================================

sds_voicecontrolfi_tclMsgLanguageandSpeakerRelUpReg::sds_voicecontrolfi_tclMsgLanguageandSpeakerRelUpReg()
 {}

tS32 sds_voicecontrolfi_tclMsgLanguageandSpeakerRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_LANGUAGEANDSPEAKERRELUPREG;
}


sds_voicecontrolfi_tclMsgLanguageandSpeakerRelUpReg::~sds_voicecontrolfi_tclMsgLanguageandSpeakerRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_voicecontrolfi_tclMsgLanguageandSpeakerStatus::sds_voicecontrolfi_tclMsgLanguageandSpeakerStatus(const sds_voicecontrolfi_tclMsgLanguageandSpeakerStatus& coRef)
   : sds_voicecontrolfi_tclMsgBaseMessage(coRef)
{
   LanguageAndSpeaker = coRef.LanguageAndSpeaker;
}
sds_voicecontrolfi_tclMsgLanguageandSpeakerStatus& sds_voicecontrolfi_tclMsgLanguageandSpeakerStatus::operator=(const sds_voicecontrolfi_tclMsgLanguageandSpeakerStatus& coRef)
{
   if (this == &coRef) return *this;
   LanguageAndSpeaker = coRef.LanguageAndSpeaker;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_voicecontrolfi_tclMsgLanguageandSpeakerStatus::vDestroy()
{
   LanguageAndSpeaker.vDestroy(); 
}

sds_voicecontrolfi_tclMsgLanguageandSpeakerStatus::sds_voicecontrolfi_tclMsgLanguageandSpeakerStatus()
:LanguageAndSpeaker()
 {}

tS32 sds_voicecontrolfi_tclMsgLanguageandSpeakerStatus::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_LANGUAGEANDSPEAKERSTATUS;
}


sds_voicecontrolfi_tclMsgLanguageandSpeakerStatus::~sds_voicecontrolfi_tclMsgLanguageandSpeakerStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_voicecontrolfi_tclMsgLanguageandSpeakerStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+LanguageAndSpeaker.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_voicecontrolfi_tclMsgLanguageandSpeakerStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageAndSpeaker);
   return oIn;
}

fi_tclOutContext& sds_voicecontrolfi_tclMsgLanguageandSpeakerStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageAndSpeaker);
   return oOut;
}

tBool sds_voicecontrolfi_tclMsgLanguageandSpeakerStatus::operator==(const sds_voicecontrolfi_tclMsgLanguageandSpeakerStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageAndSpeaker == roRef.LanguageAndSpeaker);
   return bResult;
}

//=============================================================================

sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersGet::sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersGet()
 {}

tS32 sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersGet::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLELANGUAGESANDSPEAKERSGET;
}


sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersGet::~sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersGet()
{}

//=============================================================================

sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersUpReg::sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersUpReg()
 {}

tS32 sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersUpReg::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLELANGUAGESANDSPEAKERSUPREG;
}


sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersUpReg::~sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersUpReg()
{}

//=============================================================================

sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersRelUpReg::sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersRelUpReg()
 {}

tS32 sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLELANGUAGESANDSPEAKERSRELUPREG;
}


sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersRelUpReg::~sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersStatus::sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersStatus(const sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersStatus& coRef)
   : sds_voicecontrolfi_tclMsgBaseMessage(coRef)
{
   LanguagesAndSpeaker = coRef.LanguagesAndSpeaker;
}
sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersStatus& sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersStatus::operator=(const sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersStatus& coRef)
{
   if (this == &coRef) return *this;
   LanguagesAndSpeaker = coRef.LanguagesAndSpeaker;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < LanguagesAndSpeaker.size(); ++u32Idx)
         LanguagesAndSpeaker[u32Idx].vDestroy();
   LanguagesAndSpeaker.clear();
   }
}

sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersStatus::sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersStatus()

 {}

tS32 sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersStatus::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLELANGUAGESANDSPEAKERSSTATUS;
}


sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersStatus::~sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < LanguagesAndSpeaker.size(); ++u32ListIdx)
      u32DynamicSize += LanguagesAndSpeaker[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < LanguagesAndSpeaker.size(); ++u32Idx)
      {
         LanguagesAndSpeaker[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      LanguagesAndSpeaker.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> LanguagesAndSpeaker[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)LanguagesAndSpeaker.size());
   {
      for (tU32 u32Idx = 0; u32Idx < LanguagesAndSpeaker.size(); ++u32Idx)
         (tVoid) (oOut << LanguagesAndSpeaker[u32Idx]);
   }
   return oOut;
}

tBool sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersStatus::operator==(const sds_voicecontrolfi_tclMsgAvailableLanguagesAndSpeakersStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (LanguagesAndSpeaker.size() == roRef.LanguagesAndSpeaker.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < LanguagesAndSpeaker.size()); ++u32Idx)
            bResult = bResult && (LanguagesAndSpeaker[u32Idx] == roRef.LanguagesAndSpeaker[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_voicecontrolfi_tclMsgAvailableUserwordsGet::sds_voicecontrolfi_tclMsgAvailableUserwordsGet()
 {}

tS32 sds_voicecontrolfi_tclMsgAvailableUserwordsGet::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLEUSERWORDSGET;
}


sds_voicecontrolfi_tclMsgAvailableUserwordsGet::~sds_voicecontrolfi_tclMsgAvailableUserwordsGet()
{}

//=============================================================================

sds_voicecontrolfi_tclMsgAvailableUserwordsUpReg::sds_voicecontrolfi_tclMsgAvailableUserwordsUpReg()
 {}

tS32 sds_voicecontrolfi_tclMsgAvailableUserwordsUpReg::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLEUSERWORDSUPREG;
}


sds_voicecontrolfi_tclMsgAvailableUserwordsUpReg::~sds_voicecontrolfi_tclMsgAvailableUserwordsUpReg()
{}

//=============================================================================

sds_voicecontrolfi_tclMsgAvailableUserwordsRelUpReg::sds_voicecontrolfi_tclMsgAvailableUserwordsRelUpReg()
 {}

tS32 sds_voicecontrolfi_tclMsgAvailableUserwordsRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLEUSERWORDSRELUPREG;
}


sds_voicecontrolfi_tclMsgAvailableUserwordsRelUpReg::~sds_voicecontrolfi_tclMsgAvailableUserwordsRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_voicecontrolfi_tclMsgAvailableUserwordsStatus::sds_voicecontrolfi_tclMsgAvailableUserwordsStatus(const sds_voicecontrolfi_tclMsgAvailableUserwordsStatus& coRef)
   : sds_voicecontrolfi_tclMsgBaseMessage(coRef)
{
   AvailableUserWords = coRef.AvailableUserWords;
}
sds_voicecontrolfi_tclMsgAvailableUserwordsStatus& sds_voicecontrolfi_tclMsgAvailableUserwordsStatus::operator=(const sds_voicecontrolfi_tclMsgAvailableUserwordsStatus& coRef)
{
   if (this == &coRef) return *this;
   AvailableUserWords = coRef.AvailableUserWords;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_voicecontrolfi_tclMsgAvailableUserwordsStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AvailableUserWords.size(); ++u32Idx)
         AvailableUserWords[u32Idx].vDestroy();
   AvailableUserWords.clear();
   }
}

sds_voicecontrolfi_tclMsgAvailableUserwordsStatus::sds_voicecontrolfi_tclMsgAvailableUserwordsStatus()

 {}

tS32 sds_voicecontrolfi_tclMsgAvailableUserwordsStatus::s32GetTypeId() const
{
   return (tS32) sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLEUSERWORDSSTATUS;
}


sds_voicecontrolfi_tclMsgAvailableUserwordsStatus::~sds_voicecontrolfi_tclMsgAvailableUserwordsStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_voicecontrolfi_tclMsgAvailableUserwordsStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < AvailableUserWords.size(); ++u32ListIdx)
      u32DynamicSize += AvailableUserWords[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_voicecontrolfi_tclMsgAvailableUserwordsStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AvailableUserWords.size(); ++u32Idx)
      {
         AvailableUserWords[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AvailableUserWords.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AvailableUserWords[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_voicecontrolfi_tclMsgAvailableUserwordsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)AvailableUserWords.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AvailableUserWords.size(); ++u32Idx)
         (tVoid) (oOut << AvailableUserWords[u32Idx]);
   }
   return oOut;
}

tBool sds_voicecontrolfi_tclMsgAvailableUserwordsStatus::operator==(const sds_voicecontrolfi_tclMsgAvailableUserwordsStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (AvailableUserWords.size() == roRef.AvailableUserWords.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AvailableUserWords.size()); ++u32Idx)
            bResult = bResult && (AvailableUserWords[u32Idx] == roRef.AvailableUserWords[u32Idx]);
      }
   return bResult;
}

