#ifndef SDS_VOICECONTROLFILANGUAGE_HEADER
#define SDS_VOICECONTROLFILANGUAGE_HEADER

class sds_voicecontrolfi_tclInContext;
class sds_voicecontrolfi_tclOutContext;
class sds_voicecontrolfi_tclVisitorBase;

class MY_DECL sds_voicecontrolfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  sds_voicecontrolfi_tclDescription(fi_tclInContext* poIn, sds_voicecontrolfi_tclVisitorBase* poVisit);
  sds_voicecontrolfi_tclDescription(fi_tclOutContext* poOut, sds_voicecontrolfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(sds_voicecontrolfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(sds_fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ sds_voicecontrolfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  sds_voicecontrolfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<sds_voicecontrolfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<sds_voicecontrolfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline sds_voicecontrolfi_tclDescription::sds_voicecontrolfi_tclDescription(fi_tclInContext* poIn, sds_voicecontrolfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline sds_voicecontrolfi_tclDescription::sds_voicecontrolfi_tclDescription(fi_tclOutContext* poOut, sds_voicecontrolfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

