#include "precompiled.hh"

tBool sds_voicecontrolfi_tclDescription::bInitMessage(sds_voicecontrolfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case sds_voicecontrolfi_tclToken::EN_LAST_TOKEN:
   case sds_voicecontrolfi_tclToken::EN_LIST:
   case sds_voicecontrolfi_tclToken::EN_END_OF_STRUCT:
   case sds_voicecontrolfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case sds_voicecontrolfi_tclToken::EN_MSG_PTTEVENTMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_E8_PUSHBUTTONOPTION,sds_voicecontrolfi_tclSemanticDomain::EN_MSG_PUSHBUTTONOPTION)) && bResult;
   } break;
   case sds_voicecontrolfi_tclToken::EN_MSG_SETLANGUAGEANDSPEAKERMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_LANGUAGEANDSPEAKER,sds_voicecontrolfi_tclSemanticDomain::EN_MSG_LANGUAGEANDSPEAKER)) && bResult;
   } break;
   case sds_voicecontrolfi_tclToken::EN_MSG_SETLANGUAGEANDSPEAKERMETHODRESULTFIRST:
   {
      bResult = oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_PROGRESS,sds_voicecontrolfi_tclSemanticDomain::EN_MSG_PROGRESS)) && bResult;
   } break;
   case sds_voicecontrolfi_tclToken::EN_MSG_SETLANGUAGEANDSPEAKERMETHODRESULTMIDDLE:
   {
      bResult = oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_PROGRESS,sds_voicecontrolfi_tclSemanticDomain::EN_MSG_PROGRESS)) && bResult;
   } break;
   case sds_voicecontrolfi_tclToken::EN_MSG_SETLANGUAGEANDSPEAKERMETHODRESULTLAST:
   {
      bResult = oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_PROGRESS,sds_voicecontrolfi_tclSemanticDomain::EN_MSG_PROGRESS)) && bResult;
   } break;
   case sds_voicecontrolfi_tclToken::EN_MSG_SETHOMEDESTCOUNTRYMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_HOMEDESTCOUNTRY,sds_voicecontrolfi_tclSemanticDomain::EN_MSG_HOMEDESTCOUNTRY)) && bResult;
   } break;
   case sds_voicecontrolfi_tclToken::EN_MSG_SETHOMEDESTCOUNTRYMETHODRESULTFIRST:
   {
      bResult = oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_PROGRESS,sds_voicecontrolfi_tclSemanticDomain::EN_MSG_PROGRESS)) && bResult;
   } break;
   case sds_voicecontrolfi_tclToken::EN_MSG_SETHOMEDESTCOUNTRYMETHODRESULTMIDDLE:
   {
      bResult = oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_PROGRESS,sds_voicecontrolfi_tclSemanticDomain::EN_MSG_PROGRESS)) && bResult;
   } break;
   case sds_voicecontrolfi_tclToken::EN_MSG_SETHOMEDESTCOUNTRYMETHODRESULTLAST:
   {
      bResult = oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_PROGRESS,sds_voicecontrolfi_tclSemanticDomain::EN_MSG_PROGRESS)) && bResult;
   } break;
   case sds_voicecontrolfi_tclToken::EN_MSG_SETVOICECONTROLSTATUSMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_E8_VOICECONTROLSTATUS,sds_voicecontrolfi_tclSemanticDomain::EN_MSG_VOICECONTROLSTATUS)) && bResult;
   } break;
   case sds_voicecontrolfi_tclToken::EN_MSG_UPDATEAVAILABLELANGUAGEANDSPEAKERMETHODRESULT:
   {
      bResult = oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_LANGUAGEANDSPEAKER,sds_voicecontrolfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_LIST,sds_voicecontrolfi_tclSemanticDomain::EN_MSG_LANGUAGESANDSPEAKER)) && bResult;
   } break;
   case sds_voicecontrolfi_tclToken::EN_MSG_LOADDIALOGFILEMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_STRING,sds_voicecontrolfi_tclSemanticDomain::EN_MSG_DIALOGPATH)) && bResult;
   } break;
   case sds_voicecontrolfi_tclToken::EN_MSG_UPDATERECOGNITIONSTAUSMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_E8_RECOGSTATUS,sds_voicecontrolfi_tclSemanticDomain::EN_MSG_RECOGNIZERSTATUS)) && bResult;
   } break;
   case sds_voicecontrolfi_tclToken::EN_MSG_SERVICEAVAILABILTYOFSERVERSMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_BOOL,sds_voicecontrolfi_tclSemanticDomain::EN_MSG_SERVICESAVAILABLE)) && bResult;
   } break;
   case sds_voicecontrolfi_tclToken::EN_MSG_SPEAKSENTENCEMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_E8_SENTENCE,sds_voicecontrolfi_tclSemanticDomain::EN_MSG_E8SENTENCEID)) && bResult;
   } break;
   case sds_voicecontrolfi_tclToken::EN_MSG_SDSDIAGNOSISTESTMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_E8_SDSTESTCASE,sds_voicecontrolfi_tclSemanticDomain::EN_MSG_E8TESTCASE)) && bResult;
   } break;
   case sds_voicecontrolfi_tclToken::EN_MSG_USEREVENTMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_STRING,sds_voicecontrolfi_tclSemanticDomain::EN_MSG_SUSEREVENTSTRING)) && bResult;
      bResult = oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_U8,sds_voicecontrolfi_tclSemanticDomain::EN_MSG_U8USEREVENTID)) && bResult;
   } break;
   case sds_voicecontrolfi_tclToken::EN_MSG_TRIGGERPTTMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_U32,sds_voicecontrolfi_tclSemanticDomain::EN_MSG_VALUE)) && bResult;
   } break;
   case sds_voicecontrolfi_tclToken::EN_MSG_VOICECONTROLSTATUSGET:
   {
      bResult = oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_E8_VOICECONTROLSTATUS,sds_voicecontrolfi_tclSemanticDomain::EN_MSG_VOICECONTROLSTATUS)) && bResult;
   } break;
   case sds_voicecontrolfi_tclToken::EN_MSG_VOICECONTROLSTATUSUPREG:
   {
      bResult = oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_E8_VOICECONTROLSTATUS,sds_voicecontrolfi_tclSemanticDomain::EN_MSG_VOICECONTROLSTATUS)) && bResult;
   } break;
   case sds_voicecontrolfi_tclToken::EN_MSG_VOICECONTROLSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_E8_VOICECONTROLSTATUS,sds_voicecontrolfi_tclSemanticDomain::EN_MSG_VOICECONTROLSTATUS)) && bResult;
   } break;
   case sds_voicecontrolfi_tclToken::EN_MSG_LANGUAGEANDSPEAKERSTATUS:
   {
      bResult = oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_LANGUAGEANDSPEAKER,sds_voicecontrolfi_tclSemanticDomain::EN_MSG_LANGUAGEANDSPEAKER)) && bResult;
   } break;
   case sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLELANGUAGESANDSPEAKERSSTATUS:
   {
      bResult = oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_LANGUAGEANDSPEAKER,sds_voicecontrolfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_LIST,sds_voicecontrolfi_tclSemanticDomain::EN_MSG_LANGUAGESANDSPEAKER)) && bResult;
   } break;
   case sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLEUSERWORDSSTATUS:
   {
      bResult = oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_USERWORD,sds_voicecontrolfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_LIST,sds_voicecontrolfi_tclSemanticDomain::EN_MSG_AVAILABLEUSERWORDS)) && bResult;
   } break;
   case sds_voicecontrolfi_tclToken::EN_MSG_PTTEVENTMETHODRESULT:
   case sds_voicecontrolfi_tclToken::EN_MSG_ABORTDIALOGMETHODSTART:
   case sds_voicecontrolfi_tclToken::EN_MSG_ABORTDIALOGMETHODRESULT:
   case sds_voicecontrolfi_tclToken::EN_MSG_RESETDIALOGMETHODSTART:
   case sds_voicecontrolfi_tclToken::EN_MSG_RESETDIALOGMETHODRESULT:
   case sds_voicecontrolfi_tclToken::EN_MSG_DOUPREGTOPROPERTIESMETHODSTART:
   case sds_voicecontrolfi_tclToken::EN_MSG_DOUPREGTOPROPERTIESMETHODRESULT:
   case sds_voicecontrolfi_tclToken::EN_MSG_SETVOICECONTROLSTATUSMETHODRESULT:
   case sds_voicecontrolfi_tclToken::EN_MSG_UPDATEALLUSERWORDSMETHODSTART:
   case sds_voicecontrolfi_tclToken::EN_MSG_UPDATEALLUSERWORDSMETHODRESULT:
   case sds_voicecontrolfi_tclToken::EN_MSG_UPDATEAVAILABLELANGUAGEANDSPEAKERMETHODSTART:
   case sds_voicecontrolfi_tclToken::EN_MSG_LOADDIALOGFILEMETHODRESULT:
   case sds_voicecontrolfi_tclToken::EN_MSG_UPDATERECOGNITIONSTAUSMETHODRESULT:
   case sds_voicecontrolfi_tclToken::EN_MSG_STARTUPGOODCASESMETHODSTART:
   case sds_voicecontrolfi_tclToken::EN_MSG_STARTUPGOODCASESMETHODRESULT:
   case sds_voicecontrolfi_tclToken::EN_MSG_STARTUPBADCASESMETHODSTART:
   case sds_voicecontrolfi_tclToken::EN_MSG_STARTUPBADCASESMETHODRESULT:
   case sds_voicecontrolfi_tclToken::EN_MSG_SERVICEAVAILABILTYOFSERVERSMETHODRESULT:
   case sds_voicecontrolfi_tclToken::EN_MSG_SPEAKSENTENCEMETHODRESULT:
   case sds_voicecontrolfi_tclToken::EN_MSG_SDSDIAGNOSISTESTMETHODABORT:
   case sds_voicecontrolfi_tclToken::EN_MSG_SDSDIAGNOSISTESTMETHODRESULT:
   case sds_voicecontrolfi_tclToken::EN_MSG_SDSDIAGNOSISTESTABORTRESULT:
   case sds_voicecontrolfi_tclToken::EN_MSG_TIMEREXPIREDMETHODSTART:
   case sds_voicecontrolfi_tclToken::EN_MSG_TIMEREXPIREDMETHODRESULT:
   case sds_voicecontrolfi_tclToken::EN_MSG_INITIATECNTRYDWNLAFTERSTARTUPMETHODSTART:
   case sds_voicecontrolfi_tclToken::EN_MSG_INITIATECNTRYDWNLAFTERSTARTUPMETHODRESULT:
   case sds_voicecontrolfi_tclToken::EN_MSG_USEREVENTMETHODRESULT:
   case sds_voicecontrolfi_tclToken::EN_MSG_RESUMESETTINGSREQUESTUPDATEMETHODSTART:
   case sds_voicecontrolfi_tclToken::EN_MSG_RESUMESETTINGSREQUESTUPDATEMETHODRESULT:
   case sds_voicecontrolfi_tclToken::EN_MSG_TRIGGERPTTMETHODRESULT:
   case sds_voicecontrolfi_tclToken::EN_MSG_VOICECONTROLSTATUSRELUPREG:
   case sds_voicecontrolfi_tclToken::EN_MSG_LANGUAGEANDSPEAKERGET:
   case sds_voicecontrolfi_tclToken::EN_MSG_LANGUAGEANDSPEAKERUPREG:
   case sds_voicecontrolfi_tclToken::EN_MSG_LANGUAGEANDSPEAKERRELUPREG:
   case sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLELANGUAGESANDSPEAKERSGET:
   case sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLELANGUAGESANDSPEAKERSUPREG:
   case sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLELANGUAGESANDSPEAKERSRELUPREG:
   case sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLEUSERWORDSGET:
   case sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLEUSERWORDSUPREG:
   case sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLEUSERWORDSRELUPREG:
   case sds_voicecontrolfi_tclToken::EN_BINCONTAINER:
   case sds_voicecontrolfi_tclToken::EN_E16_ISOCOUNTRYCODE:
   case sds_voicecontrolfi_tclToken::EN_E16_ISO639_3_SDSLANGUAGECODE:
   case sds_voicecontrolfi_tclToken::EN_SDSLANGUAGEID:
   case sds_voicecontrolfi_tclToken::EN_E8_SDSTESTCASE:
   case sds_voicecontrolfi_tclToken::EN_E8_PUSHBUTTONOPTION:
   case sds_voicecontrolfi_tclToken::EN_E8_PROGRESSINFO:
   case sds_voicecontrolfi_tclToken::EN_E8_VOICECONTROLSTATUS:
   case sds_voicecontrolfi_tclToken::EN_E8_SENTENCE:
   case sds_voicecontrolfi_tclToken::EN_USERWORD:
   case sds_voicecontrolfi_tclToken::EN_PROGRESS:
   case sds_voicecontrolfi_tclToken::EN_E8_VOICEGENDER:
   case sds_voicecontrolfi_tclToken::EN_E8_STORAGEDEVICE:
   case sds_voicecontrolfi_tclToken::EN_E8_COUNTRYTYPE:
   case sds_voicecontrolfi_tclToken::EN_COUNTRYTYPE:
   case sds_voicecontrolfi_tclToken::EN_VR_SPEAKER:
   case sds_voicecontrolfi_tclToken::EN_HOMEDESTCOUNTRY:
   case sds_voicecontrolfi_tclToken::EN_LANGUAGEANDSPEAKER:
   case sds_voicecontrolfi_tclToken::EN_E8_RECOGSTATUS:
   case sds_voicecontrolfi_tclToken::EN_U8:   
   case sds_voicecontrolfi_tclToken::EN_S8:   
   case sds_voicecontrolfi_tclToken::EN_U16:   
   case sds_voicecontrolfi_tclToken::EN_S16:   
   case sds_voicecontrolfi_tclToken::EN_U24:   
   case sds_voicecontrolfi_tclToken::EN_S24:   
   case sds_voicecontrolfi_tclToken::EN_U32:   
   case sds_voicecontrolfi_tclToken::EN_S32:   
   case sds_voicecontrolfi_tclToken::EN_U64:   
   case sds_voicecontrolfi_tclToken::EN_S64:   
   case sds_voicecontrolfi_tclToken::EN_F32:   
   case sds_voicecontrolfi_tclToken::EN_F64:   
   case sds_voicecontrolfi_tclToken::EN_BOOL:   
   case sds_voicecontrolfi_tclToken::EN_STRING:   
   case sds_voicecontrolfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(enMsgToken,sds_voicecontrolfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool sds_voicecontrolfi_tclDescription::bDoIt(sds_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool sds_voicecontrolfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      sds_voicecontrolfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      sds_voicecontrolfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      sds_voicecontrolfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == sds_voicecontrolfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(sds_voicecontrolfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case sds_voicecontrolfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == sds_voicecontrolfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case sds_voicecontrolfi_tclToken::EN_LIST: 
      {
         sds_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            sds_voicecontrolfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            sds_voicecontrolfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case sds_voicecontrolfi_tclToken::EN_U8: 
      {
         sds_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case sds_voicecontrolfi_tclToken::EN_U16: 
      {
         sds_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_voicecontrolfi_tclToken::EN_U24: 
      {
         sds_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_voicecontrolfi_tclToken::EN_U32: 
      {
         sds_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_voicecontrolfi_tclToken::EN_U64: 
      {
         sds_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_voicecontrolfi_tclToken::EN_S8: 
      {
         sds_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_voicecontrolfi_tclToken::EN_S16: 
      {
         sds_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_voicecontrolfi_tclToken::EN_S24: 
      {
         sds_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_voicecontrolfi_tclToken::EN_S32: 
      {
         sds_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_voicecontrolfi_tclToken::EN_S64: 
      {
         sds_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_voicecontrolfi_tclToken::EN_F32: 
      {
         sds_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_voicecontrolfi_tclToken::EN_F64: 
      {
         sds_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_voicecontrolfi_tclToken::EN_BOOL: 
      {
         sds_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_voicecontrolfi_tclToken::EN_STRING: 
      {
         sds_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_voicecontrolfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         sds_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case sds_voicecontrolfi_tclToken::EN_MSG_PTTEVENTMETHODSTART:
      case sds_voicecontrolfi_tclToken::EN_MSG_PTTEVENTMETHODRESULT:
      case sds_voicecontrolfi_tclToken::EN_MSG_ABORTDIALOGMETHODSTART:
      case sds_voicecontrolfi_tclToken::EN_MSG_ABORTDIALOGMETHODRESULT:
      case sds_voicecontrolfi_tclToken::EN_MSG_RESETDIALOGMETHODSTART:
      case sds_voicecontrolfi_tclToken::EN_MSG_RESETDIALOGMETHODRESULT:
      case sds_voicecontrolfi_tclToken::EN_MSG_SETLANGUAGEANDSPEAKERMETHODSTART:
      case sds_voicecontrolfi_tclToken::EN_MSG_SETLANGUAGEANDSPEAKERMETHODRESULTFIRST:
      case sds_voicecontrolfi_tclToken::EN_MSG_SETLANGUAGEANDSPEAKERMETHODRESULTMIDDLE:
      case sds_voicecontrolfi_tclToken::EN_MSG_SETLANGUAGEANDSPEAKERMETHODRESULTLAST:
      case sds_voicecontrolfi_tclToken::EN_MSG_SETHOMEDESTCOUNTRYMETHODSTART:
      case sds_voicecontrolfi_tclToken::EN_MSG_SETHOMEDESTCOUNTRYMETHODRESULTFIRST:
      case sds_voicecontrolfi_tclToken::EN_MSG_SETHOMEDESTCOUNTRYMETHODRESULTMIDDLE:
      case sds_voicecontrolfi_tclToken::EN_MSG_SETHOMEDESTCOUNTRYMETHODRESULTLAST:
      case sds_voicecontrolfi_tclToken::EN_MSG_DOUPREGTOPROPERTIESMETHODSTART:
      case sds_voicecontrolfi_tclToken::EN_MSG_DOUPREGTOPROPERTIESMETHODRESULT:
      case sds_voicecontrolfi_tclToken::EN_MSG_SETVOICECONTROLSTATUSMETHODSTART:
      case sds_voicecontrolfi_tclToken::EN_MSG_SETVOICECONTROLSTATUSMETHODRESULT:
      case sds_voicecontrolfi_tclToken::EN_MSG_UPDATEALLUSERWORDSMETHODSTART:
      case sds_voicecontrolfi_tclToken::EN_MSG_UPDATEALLUSERWORDSMETHODRESULT:
      case sds_voicecontrolfi_tclToken::EN_MSG_UPDATEAVAILABLELANGUAGEANDSPEAKERMETHODSTART:
      case sds_voicecontrolfi_tclToken::EN_MSG_UPDATEAVAILABLELANGUAGEANDSPEAKERMETHODRESULT:
      case sds_voicecontrolfi_tclToken::EN_MSG_LOADDIALOGFILEMETHODSTART:
      case sds_voicecontrolfi_tclToken::EN_MSG_LOADDIALOGFILEMETHODRESULT:
      case sds_voicecontrolfi_tclToken::EN_MSG_UPDATERECOGNITIONSTAUSMETHODSTART:
      case sds_voicecontrolfi_tclToken::EN_MSG_UPDATERECOGNITIONSTAUSMETHODRESULT:
      case sds_voicecontrolfi_tclToken::EN_MSG_STARTUPGOODCASESMETHODSTART:
      case sds_voicecontrolfi_tclToken::EN_MSG_STARTUPGOODCASESMETHODRESULT:
      case sds_voicecontrolfi_tclToken::EN_MSG_STARTUPBADCASESMETHODSTART:
      case sds_voicecontrolfi_tclToken::EN_MSG_STARTUPBADCASESMETHODRESULT:
      case sds_voicecontrolfi_tclToken::EN_MSG_SERVICEAVAILABILTYOFSERVERSMETHODSTART:
      case sds_voicecontrolfi_tclToken::EN_MSG_SERVICEAVAILABILTYOFSERVERSMETHODRESULT:
      case sds_voicecontrolfi_tclToken::EN_MSG_SPEAKSENTENCEMETHODSTART:
      case sds_voicecontrolfi_tclToken::EN_MSG_SPEAKSENTENCEMETHODRESULT:
      case sds_voicecontrolfi_tclToken::EN_MSG_SDSDIAGNOSISTESTMETHODSTART:
      case sds_voicecontrolfi_tclToken::EN_MSG_SDSDIAGNOSISTESTMETHODABORT:
      case sds_voicecontrolfi_tclToken::EN_MSG_SDSDIAGNOSISTESTMETHODRESULT:
      case sds_voicecontrolfi_tclToken::EN_MSG_SDSDIAGNOSISTESTABORTRESULT:
      case sds_voicecontrolfi_tclToken::EN_MSG_TIMEREXPIREDMETHODSTART:
      case sds_voicecontrolfi_tclToken::EN_MSG_TIMEREXPIREDMETHODRESULT:
      case sds_voicecontrolfi_tclToken::EN_MSG_INITIATECNTRYDWNLAFTERSTARTUPMETHODSTART:
      case sds_voicecontrolfi_tclToken::EN_MSG_INITIATECNTRYDWNLAFTERSTARTUPMETHODRESULT:
      case sds_voicecontrolfi_tclToken::EN_MSG_USEREVENTMETHODSTART:
      case sds_voicecontrolfi_tclToken::EN_MSG_USEREVENTMETHODRESULT:
      case sds_voicecontrolfi_tclToken::EN_MSG_RESUMESETTINGSREQUESTUPDATEMETHODSTART:
      case sds_voicecontrolfi_tclToken::EN_MSG_RESUMESETTINGSREQUESTUPDATEMETHODRESULT:
      case sds_voicecontrolfi_tclToken::EN_MSG_TRIGGERPTTMETHODSTART:
      case sds_voicecontrolfi_tclToken::EN_MSG_TRIGGERPTTMETHODRESULT:
      case sds_voicecontrolfi_tclToken::EN_MSG_VOICECONTROLSTATUSGET:
      case sds_voicecontrolfi_tclToken::EN_MSG_VOICECONTROLSTATUSUPREG:
      case sds_voicecontrolfi_tclToken::EN_MSG_VOICECONTROLSTATUSRELUPREG:
      case sds_voicecontrolfi_tclToken::EN_MSG_VOICECONTROLSTATUSSTATUS:
      case sds_voicecontrolfi_tclToken::EN_MSG_LANGUAGEANDSPEAKERGET:
      case sds_voicecontrolfi_tclToken::EN_MSG_LANGUAGEANDSPEAKERUPREG:
      case sds_voicecontrolfi_tclToken::EN_MSG_LANGUAGEANDSPEAKERRELUPREG:
      case sds_voicecontrolfi_tclToken::EN_MSG_LANGUAGEANDSPEAKERSTATUS:
      case sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLELANGUAGESANDSPEAKERSGET:
      case sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLELANGUAGESANDSPEAKERSUPREG:
      case sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLELANGUAGESANDSPEAKERSRELUPREG:
      case sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLELANGUAGESANDSPEAKERSSTATUS:
      case sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLEUSERWORDSGET:
      case sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLEUSERWORDSUPREG:
      case sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLEUSERWORDSRELUPREG:
      case sds_voicecontrolfi_tclToken::EN_MSG_AVAILABLEUSERWORDSSTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case sds_voicecontrolfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_END_OF_STRUCT,sds_voicecontrolfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_U8,sds_voicecontrolfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_LIST,sds_voicecontrolfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         sds_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_voicecontrolfi_tclToken::EN_E16_ISOCOUNTRYCODE:
      {
         sds_fi_tcl_e16_ISOCountryCode o_e16_ISOCountryCode;
         if (!bDoIt(o_e16_ISOCountryCode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_voicecontrolfi_tclToken::EN_E16_ISO639_3_SDSLANGUAGECODE:
      {
         sds_fi_tcl_e16_ISO639_3_SDSLanguageCode o_e16_ISO639_3_SDSLanguageCode;
         if (!bDoIt(o_e16_ISO639_3_SDSLanguageCode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_voicecontrolfi_tclToken::EN_SDSLANGUAGEID:
      {
      if (poVisitor->bDoExpand_SDSLanguageID(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_END_OF_STRUCT,sds_voicecontrolfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_E16_ISOCOUNTRYCODE,sds_voicecontrolfi_tclSemanticDomain::EN_ISO3166_COUNTRYCODE));
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_E16_ISO639_3_SDSLANGUAGECODE,sds_voicecontrolfi_tclSemanticDomain::EN_ISO639_3_SDSLANGUAGECODE));
      }
      else
      {
         sds_fi_tcl_SDSLanguageID o_SDSLanguageID;
         if (!bDoIt(o_SDSLanguageID))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SDSLanguageID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SDSLanguageID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_voicecontrolfi_tclToken::EN_E8_SDSTESTCASE:
      {
         sds_fi_tcl_e8_SDSTestCase o_e8_SDSTestCase;
         if (!bDoIt(o_e8_SDSTestCase))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_voicecontrolfi_tclToken::EN_E8_PUSHBUTTONOPTION:
      {
         sds_fi_tcl_e8_PushButtonOption o_e8_PushButtonOption;
         if (!bDoIt(o_e8_PushButtonOption))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_voicecontrolfi_tclToken::EN_E8_PROGRESSINFO:
      {
         sds_fi_tcl_e8_ProgressInfo o_e8_ProgressInfo;
         if (!bDoIt(o_e8_ProgressInfo))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_voicecontrolfi_tclToken::EN_E8_VOICECONTROLSTATUS:
      {
         sds_fi_tcl_e8_VoiceControlStatus o_e8_VoiceControlStatus;
         if (!bDoIt(o_e8_VoiceControlStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_voicecontrolfi_tclToken::EN_E8_SENTENCE:
      {
         sds_fi_tcl_e8_Sentence o_e8_Sentence;
         if (!bDoIt(o_e8_Sentence))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_voicecontrolfi_tclToken::EN_USERWORD:
      {
      if (poVisitor->bDoExpand_Userword(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_END_OF_STRUCT,sds_voicecontrolfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_U32,sds_voicecontrolfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_LIST,sds_voicecontrolfi_tclSemanticDomain::EN_NAVIUWS));
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_U32,sds_voicecontrolfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_LIST,sds_voicecontrolfi_tclSemanticDomain::EN_TUNERUWS));
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_U32,sds_voicecontrolfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_LIST,sds_voicecontrolfi_tclSemanticDomain::EN_PHONEUWS));
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_SDSLANGUAGEID,sds_voicecontrolfi_tclSemanticDomain::EN_LANGUAGEID));
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_U32,sds_voicecontrolfi_tclSemanticDomain::EN_UWPROFILE));
      }
      else
      {
         sds_fi_tcl_Userword o_Userword;
         if (!bDoIt(o_Userword))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Userword.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Userword.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_voicecontrolfi_tclToken::EN_PROGRESS:
      {
      if (poVisitor->bDoExpand_Progress(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_END_OF_STRUCT,sds_voicecontrolfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_U16,sds_voicecontrolfi_tclSemanticDomain::EN_U16PROGRESSRATE));
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_E8_PROGRESSINFO,sds_voicecontrolfi_tclSemanticDomain::EN_PROGRESSINFO));
      }
      else
      {
         sds_fi_tcl_Progress o_Progress;
         if (!bDoIt(o_Progress))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Progress.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Progress.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_voicecontrolfi_tclToken::EN_E8_VOICEGENDER:
      {
         sds_fi_tcl_e8_VoiceGender o_e8_VoiceGender;
         if (!bDoIt(o_e8_VoiceGender))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_voicecontrolfi_tclToken::EN_E8_STORAGEDEVICE:
      {
         sds_fi_tcl_e8_StorageDevice o_e8_StorageDevice;
         if (!bDoIt(o_e8_StorageDevice))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_voicecontrolfi_tclToken::EN_E8_COUNTRYTYPE:
      {
         sds_fi_tcl_e8_CountryType o_e8_CountryType;
         if (!bDoIt(o_e8_CountryType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_voicecontrolfi_tclToken::EN_COUNTRYTYPE:
      {
      if (poVisitor->bDoExpand_CountryType(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_END_OF_STRUCT,sds_voicecontrolfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_STRING,sds_voicecontrolfi_tclSemanticDomain::EN_STATE));
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_E16_ISOCOUNTRYCODE,sds_voicecontrolfi_tclSemanticDomain::EN_COUNTRYCODE));
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_E8_COUNTRYTYPE,sds_voicecontrolfi_tclSemanticDomain::EN_COUNTRYTYPE));
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_SDSLANGUAGEID,sds_voicecontrolfi_tclSemanticDomain::EN_LANGUAGEID));
      }
      else
      {
         sds_fi_tcl_CountryType o_CountryType;
         if (!bDoIt(o_CountryType))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountryType.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountryType.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_voicecontrolfi_tclToken::EN_VR_SPEAKER:
      {
      if (poVisitor->bDoExpand_VR_Speaker(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_END_OF_STRUCT,sds_voicecontrolfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_E8_STORAGEDEVICE,sds_voicecontrolfi_tclSemanticDomain::EN_STORAGEDEVICE));
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_E8_VOICEGENDER,sds_voicecontrolfi_tclSemanticDomain::EN_VOICEGENDER));
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_STRING,sds_voicecontrolfi_tclSemanticDomain::EN_VOICENAME));
      }
      else
      {
         sds_fi_tcl_VR_Speaker o_VR_Speaker;
         if (!bDoIt(o_VR_Speaker))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VR_Speaker.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VR_Speaker.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_voicecontrolfi_tclToken::EN_HOMEDESTCOUNTRY:
      {
      if (poVisitor->bDoExpand_HomeDestCountry(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_END_OF_STRUCT,sds_voicecontrolfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_COUNTRYTYPE,sds_voicecontrolfi_tclSemanticDomain::EN_DESTCOUNTRY));
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_COUNTRYTYPE,sds_voicecontrolfi_tclSemanticDomain::EN_HOMECOUNTRY));
      }
      else
      {
         sds_fi_tcl_HomeDestCountry o_HomeDestCountry;
         if (!bDoIt(o_HomeDestCountry))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_HomeDestCountry.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_HomeDestCountry.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_voicecontrolfi_tclToken::EN_LANGUAGEANDSPEAKER:
      {
      if (poVisitor->bDoExpand_LanguageAndSpeaker(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_END_OF_STRUCT,sds_voicecontrolfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_U16,sds_voicecontrolfi_tclSemanticDomain::EN_SPEAKERID));
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_SDSLANGUAGEID,sds_voicecontrolfi_tclSemanticDomain::EN_LANGUAGEID));
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_VR_SPEAKER,sds_voicecontrolfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_LIST,sds_voicecontrolfi_tclSemanticDomain::EN_PROMPTSPEAKERS));
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_VR_SPEAKER,sds_voicecontrolfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(sds_voicecontrolfi_tclKnot(sds_voicecontrolfi_tclToken::EN_LIST,sds_voicecontrolfi_tclSemanticDomain::EN_TTSVOICES));
      }
      else
      {
         sds_fi_tcl_LanguageAndSpeaker o_LanguageAndSpeaker;
         if (!bDoIt(o_LanguageAndSpeaker))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LanguageAndSpeaker.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LanguageAndSpeaker.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_voicecontrolfi_tclToken::EN_E8_RECOGSTATUS:
      {
         sds_fi_tcl_e8_RecogStatus o_e8_RecogStatus;
         if (!bDoIt(o_e8_RecogStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_voicecontrolfi_tclToken::EN_UNKNOWN:
      case sds_voicecontrolfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

