#ifndef __SDS_VOICECONTROLFIDEBUGVISITOR_H__
#define __SDS_VOICECONTROLFIDEBUGVISITOR_H__

class MY_DECL sds_voicecontrolfi_tclPrintVisitor : public sds_voicecontrolfi_tclVisitorBase {

private:
   /* default constructor */ sds_voicecontrolfi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   sds_voicecontrolfi_tclPrintVisitor(sds_fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(sds_fi_tclU8& oU8);
   virtual tVoid vVisitS8(sds_fi_tclS8& oS8);
   virtual tVoid vVisitU16(sds_fi_tclU16& oU16);
   virtual tVoid vVisitS16(sds_fi_tclS16& oS16);
   virtual tVoid vVisitU24(sds_fi_tclU24& oU24);
   virtual tVoid vVisitS24(sds_fi_tclS24& oS24);
   virtual tVoid vVisitU32(sds_fi_tclU32& oU32);
   virtual tVoid vVisitS32(sds_fi_tclS32& oS32);
   virtual tVoid vVisitU64(sds_fi_tclU64& oU64);
   virtual tVoid vVisitS64(sds_fi_tclS64& oS64);
   virtual tVoid vVisitBool(sds_fi_tclBool& oBool);
   virtual tVoid vVisitString(sds_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(sds_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(sds_fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(sds_voicecontrolfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e16_ISOCountryCode(sds_fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_e16_ISO639_3_SDSLanguageCode(sds_fi_tcl_e16_ISO639_3_SDSLanguageCode& o_e16_ISO639_3_SDSLanguageCode);
   virtual tBool bDoExpand_SDSLanguageID(sds_voicecontrolfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_SDSTestCase(sds_fi_tcl_e8_SDSTestCase& o_e8_SDSTestCase);
   virtual tVoid vVisit_e8_PushButtonOption(sds_fi_tcl_e8_PushButtonOption& o_e8_PushButtonOption);
   virtual tVoid vVisit_e8_ProgressInfo(sds_fi_tcl_e8_ProgressInfo& o_e8_ProgressInfo);
   virtual tVoid vVisit_e8_VoiceControlStatus(sds_fi_tcl_e8_VoiceControlStatus& o_e8_VoiceControlStatus);
   virtual tVoid vVisit_e8_Sentence(sds_fi_tcl_e8_Sentence& o_e8_Sentence);
   virtual tBool bDoExpand_Userword(sds_voicecontrolfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Progress(sds_voicecontrolfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_VoiceGender(sds_fi_tcl_e8_VoiceGender& o_e8_VoiceGender);
   virtual tVoid vVisit_e8_StorageDevice(sds_fi_tcl_e8_StorageDevice& o_e8_StorageDevice);
   virtual tVoid vVisit_e8_CountryType(sds_fi_tcl_e8_CountryType& o_e8_CountryType);
   virtual tBool bDoExpand_CountryType(sds_voicecontrolfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_VR_Speaker(sds_voicecontrolfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_HomeDestCountry(sds_voicecontrolfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LanguageAndSpeaker(sds_voicecontrolfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_RecogStatus(sds_fi_tcl_e8_RecogStatus& o_e8_RecogStatus);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   sds_fi_tclOutput* poOutput;
};


class MY_DECL sds_voicecontrolfi_tclRandomInitVisitor : public sds_voicecontrolfi_tclVisitorBase {
public:

   sds_voicecontrolfi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(sds_fi_tclU8& oU8);
   virtual tVoid vVisitS8(sds_fi_tclS8& oS8);
   virtual tVoid vVisitU16(sds_fi_tclU16& oU16);
   virtual tVoid vVisitS16(sds_fi_tclS16& oS16);
   virtual tVoid vVisitU24(sds_fi_tclU24& oU24);
   virtual tVoid vVisitS24(sds_fi_tclS24& oS24);
   virtual tVoid vVisitU32(sds_fi_tclU32& oU32);
   virtual tVoid vVisitS32(sds_fi_tclS32& oS32);
   virtual tVoid vVisitU64(sds_fi_tclU64& oU64);
   virtual tVoid vVisitS64(sds_fi_tclS64& oS64);
   virtual tVoid vVisitBool(sds_fi_tclBool& oBool);
   virtual tVoid vVisitString(sds_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(sds_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(sds_fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_e16_ISOCountryCode(sds_fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_e16_ISO639_3_SDSLanguageCode(sds_fi_tcl_e16_ISO639_3_SDSLanguageCode& o_e16_ISO639_3_SDSLanguageCode);
   virtual tVoid vVisit_e8_SDSTestCase(sds_fi_tcl_e8_SDSTestCase& o_e8_SDSTestCase);
   virtual tVoid vVisit_e8_PushButtonOption(sds_fi_tcl_e8_PushButtonOption& o_e8_PushButtonOption);
   virtual tVoid vVisit_e8_ProgressInfo(sds_fi_tcl_e8_ProgressInfo& o_e8_ProgressInfo);
   virtual tVoid vVisit_e8_VoiceControlStatus(sds_fi_tcl_e8_VoiceControlStatus& o_e8_VoiceControlStatus);
   virtual tVoid vVisit_e8_Sentence(sds_fi_tcl_e8_Sentence& o_e8_Sentence);
   virtual tVoid vVisit_e8_VoiceGender(sds_fi_tcl_e8_VoiceGender& o_e8_VoiceGender);
   virtual tVoid vVisit_e8_StorageDevice(sds_fi_tcl_e8_StorageDevice& o_e8_StorageDevice);
   virtual tVoid vVisit_e8_CountryType(sds_fi_tcl_e8_CountryType& o_e8_CountryType);
   virtual tVoid vVisit_e8_RecogStatus(sds_fi_tcl_e8_RecogStatus& o_e8_RecogStatus);
	tU32 u32ListSize;
};

#endif
