/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef SDS_TTSFITYPES_HEADER
#define SDS_TTSFITYPES_HEADER


class sds_ttsfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for SDS_TTS_FI message types

fi_tclMessageBase* sds_ttsfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class sds_ttsfi_tclMsgBaseMessage : public sds_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   sds_ttsfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class sds_ttsfi_tclMsgSynthesizeSpeakMethodStart : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgSynthesizeSpeakMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgSynthesizeSpeakMethodStart& operator=(const sds_ttsfi_tclMsgSynthesizeSpeakMethodStart& coRef);
   sds_ttsfi_tclMsgSynthesizeSpeakMethodStart(const sds_ttsfi_tclMsgSynthesizeSpeakMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString TextAndTags;
   sds_fi_tcl_e8_TextStyleOption TextStyle;
   sds_fi_tcl_b8_AudioOutputLocation AudioOutputLocation;
   sds_fi_tcl_e8_StatusInfoOption StatusInfo;
   tU32 ExpDate;
   tBool LastPackage;
   virtual ~sds_ttsfi_tclMsgSynthesizeSpeakMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgSynthesizeSpeakMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgSynthesizeSpeakMethodResultFirst : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgSynthesizeSpeakMethodResultFirst();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgSynthesizeSpeakMethodResultFirst& operator=(const sds_ttsfi_tclMsgSynthesizeSpeakMethodResultFirst& coRef);
   sds_ttsfi_tclMsgSynthesizeSpeakMethodResultFirst(const sds_ttsfi_tclMsgSynthesizeSpeakMethodResultFirst& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SpeakProgress JobProgress;
   virtual ~sds_ttsfi_tclMsgSynthesizeSpeakMethodResultFirst();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgSynthesizeSpeakMethodResultFirst& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgSynthesizeSpeakMethodResultMiddle : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgSynthesizeSpeakMethodResultMiddle();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgSynthesizeSpeakMethodResultMiddle& operator=(const sds_ttsfi_tclMsgSynthesizeSpeakMethodResultMiddle& coRef);
   sds_ttsfi_tclMsgSynthesizeSpeakMethodResultMiddle(const sds_ttsfi_tclMsgSynthesizeSpeakMethodResultMiddle& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SpeakProgress JobProgress;
   virtual ~sds_ttsfi_tclMsgSynthesizeSpeakMethodResultMiddle();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgSynthesizeSpeakMethodResultMiddle& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgSynthesizeSpeakMethodResultLast : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgSynthesizeSpeakMethodResultLast();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgSynthesizeSpeakMethodResultLast& operator=(const sds_ttsfi_tclMsgSynthesizeSpeakMethodResultLast& coRef);
   sds_ttsfi_tclMsgSynthesizeSpeakMethodResultLast(const sds_ttsfi_tclMsgSynthesizeSpeakMethodResultLast& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SpeakProgress JobProgress;
   virtual ~sds_ttsfi_tclMsgSynthesizeSpeakMethodResultLast();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgSynthesizeSpeakMethodResultLast& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgSynthesizeWriteMethodStart : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgSynthesizeWriteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgSynthesizeWriteMethodStart& operator=(const sds_ttsfi_tclMsgSynthesizeWriteMethodStart& coRef);
   sds_ttsfi_tclMsgSynthesizeWriteMethodStart(const sds_ttsfi_tclMsgSynthesizeWriteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString TextAndTags;
   sds_fi_tcl_e8_TextStyleOption TextStyle;
   sds_fi_tcl_e8_BufferingOption Buffering;
   tU32 ExpDate;
   tBool LastPackage;
   sds_fi_tcl_b8_AudioFormat Compression;
   virtual ~sds_ttsfi_tclMsgSynthesizeWriteMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgSynthesizeWriteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgSynthesizeWriteMethodResultFirst : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgSynthesizeWriteMethodResultFirst();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgSynthesizeWriteMethodResultFirst& operator=(const sds_ttsfi_tclMsgSynthesizeWriteMethodResultFirst& coRef);
   sds_ttsfi_tclMsgSynthesizeWriteMethodResultFirst(const sds_ttsfi_tclMsgSynthesizeWriteMethodResultFirst& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_BufferingProgress, std::allocator<sds_fi_tcl_BufferingProgress> > BufferingProgress;
   virtual ~sds_ttsfi_tclMsgSynthesizeWriteMethodResultFirst();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgSynthesizeWriteMethodResultFirst& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgSynthesizeWriteMethodResultMiddle : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgSynthesizeWriteMethodResultMiddle();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgSynthesizeWriteMethodResultMiddle& operator=(const sds_ttsfi_tclMsgSynthesizeWriteMethodResultMiddle& coRef);
   sds_ttsfi_tclMsgSynthesizeWriteMethodResultMiddle(const sds_ttsfi_tclMsgSynthesizeWriteMethodResultMiddle& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_BufferingProgress, std::allocator<sds_fi_tcl_BufferingProgress> > BufferingProgress;
   virtual ~sds_ttsfi_tclMsgSynthesizeWriteMethodResultMiddle();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgSynthesizeWriteMethodResultMiddle& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgSynthesizeWriteMethodResultLast : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgSynthesizeWriteMethodResultLast();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgSynthesizeWriteMethodResultLast& operator=(const sds_ttsfi_tclMsgSynthesizeWriteMethodResultLast& coRef);
   sds_ttsfi_tclMsgSynthesizeWriteMethodResultLast(const sds_ttsfi_tclMsgSynthesizeWriteMethodResultLast& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_BufferingProgress, std::allocator<sds_fi_tcl_BufferingProgress> > BufferingProgress;
   virtual ~sds_ttsfi_tclMsgSynthesizeWriteMethodResultLast();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgSynthesizeWriteMethodResultLast& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodStart : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodStart& operator=(const sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodStart& coRef);
   sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodStart(const sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString TextAndTags;
   sds_fi_tcl_e8_AudioSourceID TextStyle;
   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tcl_b8_AudioOutputLocation AudioOutputLocation;
   sds_fi_tcl_e8_StatusInfoOption StatusInfo;
   tU32 ExpDate;
   tBool LastPackage;
   tU8 Index;
   sds_fi_tcl_e8SequenceCategory SpeechSequence;
   virtual ~sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultFirst : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultFirst();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultFirst& operator=(const sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultFirst& coRef);
   sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultFirst(const sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultFirst& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SpeakProgress JobProgress;
   virtual ~sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultFirst();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultFirst& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultMiddle : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultMiddle();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultMiddle& operator=(const sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultMiddle& coRef);
   sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultMiddle(const sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultMiddle& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SpeakProgress JobProgress;
   virtual ~sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultMiddle();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultMiddle& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultLast : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultLast();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultLast& operator=(const sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultLast& coRef);
   sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultLast(const sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultLast& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SpeakProgress JobProgress;
   virtual ~sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultLast();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultLast& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgPrepareVoiceOutputMethodStart : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgPrepareVoiceOutputMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgPrepareVoiceOutputMethodStart& operator=(const sds_ttsfi_tclMsgPrepareVoiceOutputMethodStart& coRef);
   sds_ttsfi_tclMsgPrepareVoiceOutputMethodStart(const sds_ttsfi_tclMsgPrepareVoiceOutputMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString Device;
   virtual ~sds_ttsfi_tclMsgPrepareVoiceOutputMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgPrepareVoiceOutputMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgPrepareVoiceOutputMethodResult : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgPrepareVoiceOutputMethodResult();

   virtual ~sds_ttsfi_tclMsgPrepareVoiceOutputMethodResult();

   inline tBool operator==(const sds_ttsfi_tclMsgPrepareVoiceOutputMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgReleaseDataMethodStart : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgReleaseDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgReleaseDataMethodStart& operator=(const sds_ttsfi_tclMsgReleaseDataMethodStart& coRef);
   sds_ttsfi_tclMsgReleaseDataMethodStart(const sds_ttsfi_tclMsgReleaseDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_ReleaseTypeTTS ReleaseType;
   virtual ~sds_ttsfi_tclMsgReleaseDataMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgReleaseDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgReleaseDataMethodResult : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgReleaseDataMethodResult();

   virtual ~sds_ttsfi_tclMsgReleaseDataMethodResult();

   inline tBool operator==(const sds_ttsfi_tclMsgReleaseDataMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgSetVoiceMethodStart : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgSetVoiceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgSetVoiceMethodStart& operator=(const sds_ttsfi_tclMsgSetVoiceMethodStart& coRef);
   sds_ttsfi_tclMsgSetVoiceMethodStart(const sds_ttsfi_tclMsgSetVoiceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_VoiceType TTSVoice;
   virtual ~sds_ttsfi_tclMsgSetVoiceMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgSetVoiceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgSetVoiceMethodResult : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgSetVoiceMethodResult();

   virtual ~sds_ttsfi_tclMsgSetVoiceMethodResult();

   inline tBool operator==(const sds_ttsfi_tclMsgSetVoiceMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgAbortPromptMethodStart : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgAbortPromptMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgAbortPromptMethodStart& operator=(const sds_ttsfi_tclMsgAbortPromptMethodStart& coRef);
   sds_ttsfi_tclMsgAbortPromptMethodStart(const sds_ttsfi_tclMsgAbortPromptMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_PromptAbortOption AbortPromptOption;
   virtual ~sds_ttsfi_tclMsgAbortPromptMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgAbortPromptMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgAbortPromptMethodResult : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgAbortPromptMethodResult();

   virtual ~sds_ttsfi_tclMsgAbortPromptMethodResult();

   inline tBool operator==(const sds_ttsfi_tclMsgAbortPromptMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgPausePromptMethodStart : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgPausePromptMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgPausePromptMethodStart& operator=(const sds_ttsfi_tclMsgPausePromptMethodStart& coRef);
   sds_ttsfi_tclMsgPausePromptMethodStart(const sds_ttsfi_tclMsgPausePromptMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_PromptAbortOption PausePromptOption;
   virtual ~sds_ttsfi_tclMsgPausePromptMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgPausePromptMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgPausePromptMethodResult : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgPausePromptMethodResult();

   virtual ~sds_ttsfi_tclMsgPausePromptMethodResult();

   inline tBool operator==(const sds_ttsfi_tclMsgPausePromptMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgContinuePromptMethodStart : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgContinuePromptMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgContinuePromptMethodStart& operator=(const sds_ttsfi_tclMsgContinuePromptMethodStart& coRef);
   sds_ttsfi_tclMsgContinuePromptMethodStart(const sds_ttsfi_tclMsgContinuePromptMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Dummy;
   virtual ~sds_ttsfi_tclMsgContinuePromptMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgContinuePromptMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgContinuePromptMethodResult : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgContinuePromptMethodResult();

   virtual ~sds_ttsfi_tclMsgContinuePromptMethodResult();

   inline tBool operator==(const sds_ttsfi_tclMsgContinuePromptMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgAbortPromptWithExtensionMethodStart : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgAbortPromptWithExtensionMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgAbortPromptWithExtensionMethodStart& operator=(const sds_ttsfi_tclMsgAbortPromptWithExtensionMethodStart& coRef);
   sds_ttsfi_tclMsgAbortPromptWithExtensionMethodStart(const sds_ttsfi_tclMsgAbortPromptWithExtensionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_PromptAbortOption AbortPromptOption;
   virtual ~sds_ttsfi_tclMsgAbortPromptWithExtensionMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgAbortPromptWithExtensionMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgAbortPromptWithExtensionMethodResult : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgAbortPromptWithExtensionMethodResult();

   virtual ~sds_ttsfi_tclMsgAbortPromptWithExtensionMethodResult();

   inline tBool operator==(const sds_ttsfi_tclMsgAbortPromptWithExtensionMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgPausePromptWithExtensionMethodStart : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgPausePromptWithExtensionMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgPausePromptWithExtensionMethodStart& operator=(const sds_ttsfi_tclMsgPausePromptWithExtensionMethodStart& coRef);
   sds_ttsfi_tclMsgPausePromptWithExtensionMethodStart(const sds_ttsfi_tclMsgPausePromptWithExtensionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_PromptAbortOption PausePromptOption;
   virtual ~sds_ttsfi_tclMsgPausePromptWithExtensionMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgPausePromptWithExtensionMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgPausePromptWithExtensionMethodResult : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgPausePromptWithExtensionMethodResult();

   virtual ~sds_ttsfi_tclMsgPausePromptWithExtensionMethodResult();

   inline tBool operator==(const sds_ttsfi_tclMsgPausePromptWithExtensionMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgContinuePromptWithExtensionMethodStart : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgContinuePromptWithExtensionMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgContinuePromptWithExtensionMethodStart& operator=(const sds_ttsfi_tclMsgContinuePromptWithExtensionMethodStart& coRef);
   sds_ttsfi_tclMsgContinuePromptWithExtensionMethodStart(const sds_ttsfi_tclMsgContinuePromptWithExtensionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Dummy;
   virtual ~sds_ttsfi_tclMsgContinuePromptWithExtensionMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgContinuePromptWithExtensionMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgContinuePromptWithExtensionMethodResult : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgContinuePromptWithExtensionMethodResult();

   virtual ~sds_ttsfi_tclMsgContinuePromptWithExtensionMethodResult();

   inline tBool operator==(const sds_ttsfi_tclMsgContinuePromptWithExtensionMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgRequestPhonemeMethodStart : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgRequestPhonemeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgRequestPhonemeMethodStart& operator=(const sds_ttsfi_tclMsgRequestPhonemeMethodStart& coRef);
   sds_ttsfi_tclMsgRequestPhonemeMethodStart(const sds_ttsfi_tclMsgRequestPhonemeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString TextAndTags;
   sds_fi_tcl_e8_TextStyleOption TextStyle;
   virtual ~sds_ttsfi_tclMsgRequestPhonemeMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgRequestPhonemeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgRequestPhonemeMethodResult : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgRequestPhonemeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgRequestPhonemeMethodResult& operator=(const sds_ttsfi_tclMsgRequestPhonemeMethodResult& coRef);
   sds_ttsfi_tclMsgRequestPhonemeMethodResult(const sds_ttsfi_tclMsgRequestPhonemeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_TTSPhonemeResult, std::allocator<sds_fi_tcl_TTSPhonemeResult> > PhonemeList;
   virtual ~sds_ttsfi_tclMsgRequestPhonemeMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgRequestPhonemeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgLoadTuningFilesMethodStart : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgLoadTuningFilesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgLoadTuningFilesMethodStart& operator=(const sds_ttsfi_tclMsgLoadTuningFilesMethodStart& coRef);
   sds_ttsfi_tclMsgLoadTuningFilesMethodStart(const sds_ttsfi_tclMsgLoadTuningFilesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_TTSTuningFile, std::allocator<sds_fi_tcl_TTSTuningFile> > TTSTunFiles;
   sds_fi_tcl_e8_TTSDomain TTSDomain;
   sds_fi_tclString TTSVersion;
   virtual ~sds_ttsfi_tclMsgLoadTuningFilesMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgLoadTuningFilesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgLoadTuningFilesMethodResult : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgLoadTuningFilesMethodResult();

   virtual ~sds_ttsfi_tclMsgLoadTuningFilesMethodResult();

   inline tBool operator==(const sds_ttsfi_tclMsgLoadTuningFilesMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgSetDefaultSpeechRateMethodStart : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgSetDefaultSpeechRateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgSetDefaultSpeechRateMethodStart& operator=(const sds_ttsfi_tclMsgSetDefaultSpeechRateMethodStart& coRef);
   sds_ttsfi_tclMsgSetDefaultSpeechRateMethodStart(const sds_ttsfi_tclMsgSetDefaultSpeechRateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 Rate;
   virtual ~sds_ttsfi_tclMsgSetDefaultSpeechRateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgSetDefaultSpeechRateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgSetDefaultSpeechRateMethodResult : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgSetDefaultSpeechRateMethodResult();

   virtual ~sds_ttsfi_tclMsgSetDefaultSpeechRateMethodResult();

   inline tBool operator==(const sds_ttsfi_tclMsgSetDefaultSpeechRateMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDoSynthesisForSpeakMethodStart : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDoSynthesisForSpeakMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgDoSynthesisForSpeakMethodStart& operator=(const sds_ttsfi_tclMsgDoSynthesisForSpeakMethodStart& coRef);
   sds_ttsfi_tclMsgDoSynthesisForSpeakMethodStart(const sds_ttsfi_tclMsgDoSynthesisForSpeakMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString TextAndTags;
   sds_fi_tcl_e8_TextStyleOption TextStyle;
   sds_fi_tcl_e8_StatusInfoOption StatusInfo;
   tBool LastPackage;
   virtual ~sds_ttsfi_tclMsgDoSynthesisForSpeakMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgDoSynthesisForSpeakMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDoSynthesisForSpeakMethodResult : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDoSynthesisForSpeakMethodResult();

   virtual ~sds_ttsfi_tclMsgDoSynthesisForSpeakMethodResult();

   inline tBool operator==(const sds_ttsfi_tclMsgDoSynthesisForSpeakMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDoPrepareAudioOutputMethodStart : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDoPrepareAudioOutputMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgDoPrepareAudioOutputMethodStart& operator=(const sds_ttsfi_tclMsgDoPrepareAudioOutputMethodStart& coRef);
   sds_ttsfi_tclMsgDoPrepareAudioOutputMethodStart(const sds_ttsfi_tclMsgDoPrepareAudioOutputMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString DeviceName;
   virtual ~sds_ttsfi_tclMsgDoPrepareAudioOutputMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgDoPrepareAudioOutputMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDoPrepareAudioOutputMethodResult : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDoPrepareAudioOutputMethodResult();

   virtual ~sds_ttsfi_tclMsgDoPrepareAudioOutputMethodResult();

   inline tBool operator==(const sds_ttsfi_tclMsgDoPrepareAudioOutputMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDoAudioOutputSpeakMethodStart : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDoAudioOutputSpeakMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgDoAudioOutputSpeakMethodStart& operator=(const sds_ttsfi_tclMsgDoAudioOutputSpeakMethodStart& coRef);
   sds_ttsfi_tclMsgDoAudioOutputSpeakMethodStart(const sds_ttsfi_tclMsgDoAudioOutputSpeakMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_StatusInfoOption StatusInfo;
   sds_fi_tcl_b8_AudioOutputLocation AudioOutputLocation;
   virtual ~sds_ttsfi_tclMsgDoAudioOutputSpeakMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgDoAudioOutputSpeakMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultFirst : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultFirst();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultFirst& operator=(const sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultFirst& coRef);
   sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultFirst(const sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultFirst& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SpeakProgress JobProgress;
   virtual ~sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultFirst();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultFirst& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultMiddle : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultMiddle();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultMiddle& operator=(const sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultMiddle& coRef);
   sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultMiddle(const sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultMiddle& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SpeakProgress JobProgress;
   virtual ~sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultMiddle();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultMiddle& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultLast : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultLast();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultLast& operator=(const sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultLast& coRef);
   sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultLast(const sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultLast& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SpeakProgress JobProgress;
   virtual ~sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultLast();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultLast& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDoUpRegToPropertiesMethodStart : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDoUpRegToPropertiesMethodStart();

   virtual ~sds_ttsfi_tclMsgDoUpRegToPropertiesMethodStart();

   inline tBool operator==(const sds_ttsfi_tclMsgDoUpRegToPropertiesMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDoUpRegToPropertiesMethodResult : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDoUpRegToPropertiesMethodResult();

   virtual ~sds_ttsfi_tclMsgDoUpRegToPropertiesMethodResult();

   inline tBool operator==(const sds_ttsfi_tclMsgDoUpRegToPropertiesMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDoSynthesisForWriteMethodStart : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDoSynthesisForWriteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgDoSynthesisForWriteMethodStart& operator=(const sds_ttsfi_tclMsgDoSynthesisForWriteMethodStart& coRef);
   sds_ttsfi_tclMsgDoSynthesisForWriteMethodStart(const sds_ttsfi_tclMsgDoSynthesisForWriteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString TextAndTags;
   sds_fi_tcl_e8_TextStyleOption TextStyle;
   tBool LastPackage;
   virtual ~sds_ttsfi_tclMsgDoSynthesisForWriteMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgDoSynthesisForWriteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDoSynthesisForWriteMethodResult : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDoSynthesisForWriteMethodResult();

   virtual ~sds_ttsfi_tclMsgDoSynthesisForWriteMethodResult();

   inline tBool operator==(const sds_ttsfi_tclMsgDoSynthesisForWriteMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDoAudioOutputWriteMethodStart : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDoAudioOutputWriteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgDoAudioOutputWriteMethodStart& operator=(const sds_ttsfi_tclMsgDoAudioOutputWriteMethodStart& coRef);
   sds_ttsfi_tclMsgDoAudioOutputWriteMethodStart(const sds_ttsfi_tclMsgDoAudioOutputWriteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_BufferingOption Buffering;
   sds_fi_tcl_b8_AudioFormat Compression;
   virtual ~sds_ttsfi_tclMsgDoAudioOutputWriteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgDoAudioOutputWriteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultFirst : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultFirst();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultFirst& operator=(const sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultFirst& coRef);
   sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultFirst(const sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultFirst& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_BufferingProgress, std::allocator<sds_fi_tcl_BufferingProgress> > BufferingProgress;
   virtual ~sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultFirst();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultFirst& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultMiddle : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultMiddle();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultMiddle& operator=(const sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultMiddle& coRef);
   sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultMiddle(const sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultMiddle& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_BufferingProgress, std::allocator<sds_fi_tcl_BufferingProgress> > BufferingProgress;
   virtual ~sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultMiddle();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultMiddle& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultLast : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultLast();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultLast& operator=(const sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultLast& coRef);
   sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultLast(const sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultLast& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_BufferingProgress, std::allocator<sds_fi_tcl_BufferingProgress> > BufferingProgress;
   virtual ~sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultLast();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultLast& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodStart : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodStart& operator=(const sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodStart& coRef);
   sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodStart(const sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString TextAndTags;
   sds_fi_tcl_e8_AudioSourceID TextStyle;
   sds_fi_tcl_e8_StatusInfoOption StatusInfo;
   tBool LastPackage;
   virtual ~sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodResult : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodResult();

   virtual ~sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodResult();

   inline tBool operator==(const sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDoReleaseDataMethodStart : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDoReleaseDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgDoReleaseDataMethodStart& operator=(const sds_ttsfi_tclMsgDoReleaseDataMethodStart& coRef);
   sds_ttsfi_tclMsgDoReleaseDataMethodStart(const sds_ttsfi_tclMsgDoReleaseDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_ReleaseTypeTTS ReleaseType;
   virtual ~sds_ttsfi_tclMsgDoReleaseDataMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgDoReleaseDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDoReleaseDataMethodResult : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDoReleaseDataMethodResult();

   virtual ~sds_ttsfi_tclMsgDoReleaseDataMethodResult();

   inline tBool operator==(const sds_ttsfi_tclMsgDoReleaseDataMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDoReleaseAudioDeviceMethodStart : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDoReleaseAudioDeviceMethodStart();

   virtual ~sds_ttsfi_tclMsgDoReleaseAudioDeviceMethodStart();

   inline tBool operator==(const sds_ttsfi_tclMsgDoReleaseAudioDeviceMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDoReleaseAudioDeviceMethodResult : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDoReleaseAudioDeviceMethodResult();

   virtual ~sds_ttsfi_tclMsgDoReleaseAudioDeviceMethodResult();

   inline tBool operator==(const sds_ttsfi_tclMsgDoReleaseAudioDeviceMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDoRequestPhonemeMethodStart : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDoRequestPhonemeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgDoRequestPhonemeMethodStart& operator=(const sds_ttsfi_tclMsgDoRequestPhonemeMethodStart& coRef);
   sds_ttsfi_tclMsgDoRequestPhonemeMethodStart(const sds_ttsfi_tclMsgDoRequestPhonemeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString TextAndTags;
   sds_fi_tcl_e8_TextStyleOption TextStyle;
   virtual ~sds_ttsfi_tclMsgDoRequestPhonemeMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgDoRequestPhonemeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDoRequestPhonemeMethodResult : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDoRequestPhonemeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgDoRequestPhonemeMethodResult& operator=(const sds_ttsfi_tclMsgDoRequestPhonemeMethodResult& coRef);
   sds_ttsfi_tclMsgDoRequestPhonemeMethodResult(const sds_ttsfi_tclMsgDoRequestPhonemeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_TTSPhonemeResult, std::allocator<sds_fi_tcl_TTSPhonemeResult> > PhonemeList;
   virtual ~sds_ttsfi_tclMsgDoRequestPhonemeMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgDoRequestPhonemeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodStart : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodStart& operator=(const sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodStart& coRef);
   sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodStart(const sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_StatusInfoOption StatusInfo;
   sds_fi_tcl_b8_AudioOutputLocation AudioOutputLocation;
   virtual ~sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultFirst : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultFirst();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultFirst& operator=(const sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultFirst& coRef);
   sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultFirst(const sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultFirst& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SpeakProgress JobProgress;
   virtual ~sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultFirst();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultFirst& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultMiddle : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultMiddle();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultMiddle& operator=(const sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultMiddle& coRef);
   sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultMiddle(const sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultMiddle& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SpeakProgress JobProgress;
   virtual ~sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultMiddle();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultMiddle& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultLast : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultLast();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultLast& operator=(const sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultLast& coRef);
   sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultLast(const sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultLast& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SpeakProgress JobProgress;
   virtual ~sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultLast();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultLast& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgVoiceGet : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgVoiceGet();

   virtual ~sds_ttsfi_tclMsgVoiceGet();

   inline tBool operator==(const sds_ttsfi_tclMsgVoiceGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgVoiceStatus : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgVoiceStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgVoiceStatus& operator=(const sds_ttsfi_tclMsgVoiceStatus& coRef);
   sds_ttsfi_tclMsgVoiceStatus(const sds_ttsfi_tclMsgVoiceStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_TTSVoiceInfo TTSVoice;
   virtual ~sds_ttsfi_tclMsgVoiceStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgVoiceStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgVoiceUpReg : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgVoiceUpReg();

   virtual ~sds_ttsfi_tclMsgVoiceUpReg();

   inline tBool operator==(const sds_ttsfi_tclMsgVoiceUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgVoiceRelUpReg : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgVoiceRelUpReg();

   virtual ~sds_ttsfi_tclMsgVoiceRelUpReg();

   inline tBool operator==(const sds_ttsfi_tclMsgVoiceRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgAvailableVoicesGet : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgAvailableVoicesGet();

   virtual ~sds_ttsfi_tclMsgAvailableVoicesGet();

   inline tBool operator==(const sds_ttsfi_tclMsgAvailableVoicesGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgAvailableVoicesStatus : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgAvailableVoicesStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgAvailableVoicesStatus& operator=(const sds_ttsfi_tclMsgAvailableVoicesStatus& coRef);
   sds_ttsfi_tclMsgAvailableVoicesStatus(const sds_ttsfi_tclMsgAvailableVoicesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_AvailableTTSVoices AvailableTTSVoices;
   virtual ~sds_ttsfi_tclMsgAvailableVoicesStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgAvailableVoicesStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgAvailableVoicesUpReg : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgAvailableVoicesUpReg();

   virtual ~sds_ttsfi_tclMsgAvailableVoicesUpReg();

   inline tBool operator==(const sds_ttsfi_tclMsgAvailableVoicesUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgAvailableVoicesRelUpReg : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgAvailableVoicesRelUpReg();

   virtual ~sds_ttsfi_tclMsgAvailableVoicesRelUpReg();

   inline tBool operator==(const sds_ttsfi_tclMsgAvailableVoicesRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgTTSVersionInfoGet : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgTTSVersionInfoGet();

   virtual ~sds_ttsfi_tclMsgTTSVersionInfoGet();

   inline tBool operator==(const sds_ttsfi_tclMsgTTSVersionInfoGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgTTSVersionInfoStatus : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgTTSVersionInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgTTSVersionInfoStatus& operator=(const sds_ttsfi_tclMsgTTSVersionInfoStatus& coRef);
   sds_ttsfi_tclMsgTTSVersionInfoStatus(const sds_ttsfi_tclMsgTTSVersionInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_TTSVersionInfo TTSVersionInfo;
   virtual ~sds_ttsfi_tclMsgTTSVersionInfoStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgTTSVersionInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgTTSVersionInfoUpReg : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgTTSVersionInfoUpReg();

   virtual ~sds_ttsfi_tclMsgTTSVersionInfoUpReg();

   inline tBool operator==(const sds_ttsfi_tclMsgTTSVersionInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgTTSVersionInfoRelUpReg : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgTTSVersionInfoRelUpReg();

   virtual ~sds_ttsfi_tclMsgTTSVersionInfoRelUpReg();

   inline tBool operator==(const sds_ttsfi_tclMsgTTSVersionInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgTTSStatusGet : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgTTSStatusGet();

   virtual ~sds_ttsfi_tclMsgTTSStatusGet();

   inline tBool operator==(const sds_ttsfi_tclMsgTTSStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgTTSStatusStatus : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgTTSStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgTTSStatusStatus& operator=(const sds_ttsfi_tclMsgTTSStatusStatus& coRef);
   sds_ttsfi_tclMsgTTSStatusStatus(const sds_ttsfi_tclMsgTTSStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_TTSStatus TTSStatus;
   virtual ~sds_ttsfi_tclMsgTTSStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgTTSStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgTTSStatusUpReg : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgTTSStatusUpReg();

   virtual ~sds_ttsfi_tclMsgTTSStatusUpReg();

   inline tBool operator==(const sds_ttsfi_tclMsgTTSStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgTTSStatusRelUpReg : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgTTSStatusRelUpReg();

   virtual ~sds_ttsfi_tclMsgTTSStatusRelUpReg();

   inline tBool operator==(const sds_ttsfi_tclMsgTTSStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDownloadCompleteGet : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDownloadCompleteGet();

   virtual ~sds_ttsfi_tclMsgDownloadCompleteGet();

   inline tBool operator==(const sds_ttsfi_tclMsgDownloadCompleteGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDownloadCompleteUpReg : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDownloadCompleteUpReg();

   virtual ~sds_ttsfi_tclMsgDownloadCompleteUpReg();

   inline tBool operator==(const sds_ttsfi_tclMsgDownloadCompleteUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDownloadCompleteRelUpReg : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDownloadCompleteRelUpReg();

   virtual ~sds_ttsfi_tclMsgDownloadCompleteRelUpReg();

   inline tBool operator==(const sds_ttsfi_tclMsgDownloadCompleteRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgDownloadCompleteStatus : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgDownloadCompleteStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgDownloadCompleteStatus& operator=(const sds_ttsfi_tclMsgDownloadCompleteStatus& coRef);
   sds_ttsfi_tclMsgDownloadCompleteStatus(const sds_ttsfi_tclMsgDownloadCompleteStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Complete;
   virtual ~sds_ttsfi_tclMsgDownloadCompleteStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgDownloadCompleteStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgTTSPlaybackSpacingSet : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgTTSPlaybackSpacingSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgTTSPlaybackSpacingSet& operator=(const sds_ttsfi_tclMsgTTSPlaybackSpacingSet& coRef);
   sds_ttsfi_tclMsgTTSPlaybackSpacingSet(const sds_ttsfi_tclMsgTTSPlaybackSpacingSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 PlaybackSpacing;
   virtual ~sds_ttsfi_tclMsgTTSPlaybackSpacingSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgTTSPlaybackSpacingSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgTTSPlaybackSpacingStatus : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgTTSPlaybackSpacingStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_ttsfi_tclMsgTTSPlaybackSpacingStatus& operator=(const sds_ttsfi_tclMsgTTSPlaybackSpacingStatus& coRef);
   sds_ttsfi_tclMsgTTSPlaybackSpacingStatus(const sds_ttsfi_tclMsgTTSPlaybackSpacingStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 PlaybackSpacing;
   virtual ~sds_ttsfi_tclMsgTTSPlaybackSpacingStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_ttsfi_tclMsgTTSPlaybackSpacingStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgTTSPlaybackSpacingUpReg : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgTTSPlaybackSpacingUpReg();

   virtual ~sds_ttsfi_tclMsgTTSPlaybackSpacingUpReg();

   inline tBool operator==(const sds_ttsfi_tclMsgTTSPlaybackSpacingUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_ttsfi_tclMsgTTSPlaybackSpacingRelUpReg : public sds_ttsfi_tclMsgBaseMessage
{
public:

   sds_ttsfi_tclMsgTTSPlaybackSpacingRelUpReg();

   virtual ~sds_ttsfi_tclMsgTTSPlaybackSpacingRelUpReg();

   inline tBool operator==(const sds_ttsfi_tclMsgTTSPlaybackSpacingRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};


#endif
