/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
// =============================================================================
//
//                Factory for SDS_TTS_FI message types

fi_tclMessageBase* sds_ttsfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODSTART:
         return OSAL_NEW sds_ttsfi_tclMsgSynthesizeSpeakMethodStart;

      case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODRESULTFIRST:
         return OSAL_NEW sds_ttsfi_tclMsgSynthesizeSpeakMethodResultFirst;

      case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODRESULTMIDDLE:
         return OSAL_NEW sds_ttsfi_tclMsgSynthesizeSpeakMethodResultMiddle;

      case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODRESULTLAST:
         return OSAL_NEW sds_ttsfi_tclMsgSynthesizeSpeakMethodResultLast;

      case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZEWRITEMETHODSTART:
         return OSAL_NEW sds_ttsfi_tclMsgSynthesizeWriteMethodStart;

      case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZEWRITEMETHODRESULTFIRST:
         return OSAL_NEW sds_ttsfi_tclMsgSynthesizeWriteMethodResultFirst;

      case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZEWRITEMETHODRESULTMIDDLE:
         return OSAL_NEW sds_ttsfi_tclMsgSynthesizeWriteMethodResultMiddle;

      case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZEWRITEMETHODRESULTLAST:
         return OSAL_NEW sds_ttsfi_tclMsgSynthesizeWriteMethodResultLast;

      case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKWITHEXTENSIONMETHODSTART:
         return OSAL_NEW sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodStart;

      case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKWITHEXTENSIONMETHODRESULTFIRST:
         return OSAL_NEW sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultFirst;

      case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKWITHEXTENSIONMETHODRESULTMIDDLE:
         return OSAL_NEW sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultMiddle;

      case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKWITHEXTENSIONMETHODRESULTLAST:
         return OSAL_NEW sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultLast;

      case sds_ttsfi_tclToken::EN_MSG_PREPAREVOICEOUTPUTMETHODSTART:
         return OSAL_NEW sds_ttsfi_tclMsgPrepareVoiceOutputMethodStart;

      case sds_ttsfi_tclToken::EN_MSG_PREPAREVOICEOUTPUTMETHODRESULT:
         return OSAL_NEW sds_ttsfi_tclMsgPrepareVoiceOutputMethodResult;

      case sds_ttsfi_tclToken::EN_MSG_RELEASEDATAMETHODSTART:
         return OSAL_NEW sds_ttsfi_tclMsgReleaseDataMethodStart;

      case sds_ttsfi_tclToken::EN_MSG_RELEASEDATAMETHODRESULT:
         return OSAL_NEW sds_ttsfi_tclMsgReleaseDataMethodResult;

      case sds_ttsfi_tclToken::EN_MSG_SETVOICEMETHODSTART:
         return OSAL_NEW sds_ttsfi_tclMsgSetVoiceMethodStart;

      case sds_ttsfi_tclToken::EN_MSG_SETVOICEMETHODRESULT:
         return OSAL_NEW sds_ttsfi_tclMsgSetVoiceMethodResult;

      case sds_ttsfi_tclToken::EN_MSG_ABORTPROMPTMETHODSTART:
         return OSAL_NEW sds_ttsfi_tclMsgAbortPromptMethodStart;

      case sds_ttsfi_tclToken::EN_MSG_ABORTPROMPTMETHODRESULT:
         return OSAL_NEW sds_ttsfi_tclMsgAbortPromptMethodResult;

      case sds_ttsfi_tclToken::EN_MSG_PAUSEPROMPTMETHODSTART:
         return OSAL_NEW sds_ttsfi_tclMsgPausePromptMethodStart;

      case sds_ttsfi_tclToken::EN_MSG_PAUSEPROMPTMETHODRESULT:
         return OSAL_NEW sds_ttsfi_tclMsgPausePromptMethodResult;

      case sds_ttsfi_tclToken::EN_MSG_CONTINUEPROMPTMETHODSTART:
         return OSAL_NEW sds_ttsfi_tclMsgContinuePromptMethodStart;

      case sds_ttsfi_tclToken::EN_MSG_CONTINUEPROMPTMETHODRESULT:
         return OSAL_NEW sds_ttsfi_tclMsgContinuePromptMethodResult;

      case sds_ttsfi_tclToken::EN_MSG_ABORTPROMPTWITHEXTENSIONMETHODSTART:
         return OSAL_NEW sds_ttsfi_tclMsgAbortPromptWithExtensionMethodStart;

      case sds_ttsfi_tclToken::EN_MSG_ABORTPROMPTWITHEXTENSIONMETHODRESULT:
         return OSAL_NEW sds_ttsfi_tclMsgAbortPromptWithExtensionMethodResult;

      case sds_ttsfi_tclToken::EN_MSG_PAUSEPROMPTWITHEXTENSIONMETHODSTART:
         return OSAL_NEW sds_ttsfi_tclMsgPausePromptWithExtensionMethodStart;

      case sds_ttsfi_tclToken::EN_MSG_PAUSEPROMPTWITHEXTENSIONMETHODRESULT:
         return OSAL_NEW sds_ttsfi_tclMsgPausePromptWithExtensionMethodResult;

      case sds_ttsfi_tclToken::EN_MSG_CONTINUEPROMPTWITHEXTENSIONMETHODSTART:
         return OSAL_NEW sds_ttsfi_tclMsgContinuePromptWithExtensionMethodStart;

      case sds_ttsfi_tclToken::EN_MSG_CONTINUEPROMPTWITHEXTENSIONMETHODRESULT:
         return OSAL_NEW sds_ttsfi_tclMsgContinuePromptWithExtensionMethodResult;

      case sds_ttsfi_tclToken::EN_MSG_REQUESTPHONEMEMETHODSTART:
         return OSAL_NEW sds_ttsfi_tclMsgRequestPhonemeMethodStart;

      case sds_ttsfi_tclToken::EN_MSG_REQUESTPHONEMEMETHODRESULT:
         return OSAL_NEW sds_ttsfi_tclMsgRequestPhonemeMethodResult;

      case sds_ttsfi_tclToken::EN_MSG_LOADTUNINGFILESMETHODSTART:
         return OSAL_NEW sds_ttsfi_tclMsgLoadTuningFilesMethodStart;

      case sds_ttsfi_tclToken::EN_MSG_LOADTUNINGFILESMETHODRESULT:
         return OSAL_NEW sds_ttsfi_tclMsgLoadTuningFilesMethodResult;

      case sds_ttsfi_tclToken::EN_MSG_SETDEFAULTSPEECHRATEMETHODSTART:
         return OSAL_NEW sds_ttsfi_tclMsgSetDefaultSpeechRateMethodStart;

      case sds_ttsfi_tclToken::EN_MSG_SETDEFAULTSPEECHRATEMETHODRESULT:
         return OSAL_NEW sds_ttsfi_tclMsgSetDefaultSpeechRateMethodResult;

      case sds_ttsfi_tclToken::EN_MSG_DOSYNTHESISFORSPEAKMETHODSTART:
         return OSAL_NEW sds_ttsfi_tclMsgDoSynthesisForSpeakMethodStart;

      case sds_ttsfi_tclToken::EN_MSG_DOSYNTHESISFORSPEAKMETHODRESULT:
         return OSAL_NEW sds_ttsfi_tclMsgDoSynthesisForSpeakMethodResult;

      case sds_ttsfi_tclToken::EN_MSG_DOPREPAREAUDIOOUTPUTMETHODSTART:
         return OSAL_NEW sds_ttsfi_tclMsgDoPrepareAudioOutputMethodStart;

      case sds_ttsfi_tclToken::EN_MSG_DOPREPAREAUDIOOUTPUTMETHODRESULT:
         return OSAL_NEW sds_ttsfi_tclMsgDoPrepareAudioOutputMethodResult;

      case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKMETHODSTART:
         return OSAL_NEW sds_ttsfi_tclMsgDoAudioOutputSpeakMethodStart;

      case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKMETHODRESULTFIRST:
         return OSAL_NEW sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultFirst;

      case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKMETHODRESULTMIDDLE:
         return OSAL_NEW sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultMiddle;

      case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKMETHODRESULTLAST:
         return OSAL_NEW sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultLast;

      case sds_ttsfi_tclToken::EN_MSG_DOUPREGTOPROPERTIESMETHODSTART:
         return OSAL_NEW sds_ttsfi_tclMsgDoUpRegToPropertiesMethodStart;

      case sds_ttsfi_tclToken::EN_MSG_DOUPREGTOPROPERTIESMETHODRESULT:
         return OSAL_NEW sds_ttsfi_tclMsgDoUpRegToPropertiesMethodResult;

      case sds_ttsfi_tclToken::EN_MSG_DOSYNTHESISFORWRITEMETHODSTART:
         return OSAL_NEW sds_ttsfi_tclMsgDoSynthesisForWriteMethodStart;

      case sds_ttsfi_tclToken::EN_MSG_DOSYNTHESISFORWRITEMETHODRESULT:
         return OSAL_NEW sds_ttsfi_tclMsgDoSynthesisForWriteMethodResult;

      case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTWRITEMETHODSTART:
         return OSAL_NEW sds_ttsfi_tclMsgDoAudioOutputWriteMethodStart;

      case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTWRITEMETHODRESULTFIRST:
         return OSAL_NEW sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultFirst;

      case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTWRITEMETHODRESULTMIDDLE:
         return OSAL_NEW sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultMiddle;

      case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTWRITEMETHODRESULTLAST:
         return OSAL_NEW sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultLast;

      case sds_ttsfi_tclToken::EN_MSG_DOSYNTHESISFORSPEAKWITHEXTENTIONMETHODSTART:
         return OSAL_NEW sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodStart;

      case sds_ttsfi_tclToken::EN_MSG_DOSYNTHESISFORSPEAKWITHEXTENTIONMETHODRESULT:
         return OSAL_NEW sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodResult;

      case sds_ttsfi_tclToken::EN_MSG_DORELEASEDATAMETHODSTART:
         return OSAL_NEW sds_ttsfi_tclMsgDoReleaseDataMethodStart;

      case sds_ttsfi_tclToken::EN_MSG_DORELEASEDATAMETHODRESULT:
         return OSAL_NEW sds_ttsfi_tclMsgDoReleaseDataMethodResult;

      case sds_ttsfi_tclToken::EN_MSG_DORELEASEAUDIODEVICEMETHODSTART:
         return OSAL_NEW sds_ttsfi_tclMsgDoReleaseAudioDeviceMethodStart;

      case sds_ttsfi_tclToken::EN_MSG_DORELEASEAUDIODEVICEMETHODRESULT:
         return OSAL_NEW sds_ttsfi_tclMsgDoReleaseAudioDeviceMethodResult;

      case sds_ttsfi_tclToken::EN_MSG_DOREQUESTPHONEMEMETHODSTART:
         return OSAL_NEW sds_ttsfi_tclMsgDoRequestPhonemeMethodStart;

      case sds_ttsfi_tclToken::EN_MSG_DOREQUESTPHONEMEMETHODRESULT:
         return OSAL_NEW sds_ttsfi_tclMsgDoRequestPhonemeMethodResult;

      case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKWITHEXTENSIONMETHODSTART:
         return OSAL_NEW sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodStart;

      case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKWITHEXTENSIONMETHODRESULTFIRST:
         return OSAL_NEW sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultFirst;

      case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKWITHEXTENSIONMETHODRESULTMIDDLE:
         return OSAL_NEW sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultMiddle;

      case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKWITHEXTENSIONMETHODRESULTLAST:
         return OSAL_NEW sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultLast;

      case sds_ttsfi_tclToken::EN_MSG_VOICEGET:
         return OSAL_NEW sds_ttsfi_tclMsgVoiceGet;

      case sds_ttsfi_tclToken::EN_MSG_VOICESTATUS:
         return OSAL_NEW sds_ttsfi_tclMsgVoiceStatus;

      case sds_ttsfi_tclToken::EN_MSG_VOICEUPREG:
         return OSAL_NEW sds_ttsfi_tclMsgVoiceUpReg;

      case sds_ttsfi_tclToken::EN_MSG_VOICERELUPREG:
         return OSAL_NEW sds_ttsfi_tclMsgVoiceRelUpReg;

      case sds_ttsfi_tclToken::EN_MSG_AVAILABLEVOICESGET:
         return OSAL_NEW sds_ttsfi_tclMsgAvailableVoicesGet;

      case sds_ttsfi_tclToken::EN_MSG_AVAILABLEVOICESSTATUS:
         return OSAL_NEW sds_ttsfi_tclMsgAvailableVoicesStatus;

      case sds_ttsfi_tclToken::EN_MSG_AVAILABLEVOICESUPREG:
         return OSAL_NEW sds_ttsfi_tclMsgAvailableVoicesUpReg;

      case sds_ttsfi_tclToken::EN_MSG_AVAILABLEVOICESRELUPREG:
         return OSAL_NEW sds_ttsfi_tclMsgAvailableVoicesRelUpReg;

      case sds_ttsfi_tclToken::EN_MSG_TTSVERSIONINFOGET:
         return OSAL_NEW sds_ttsfi_tclMsgTTSVersionInfoGet;

      case sds_ttsfi_tclToken::EN_MSG_TTSVERSIONINFOSTATUS:
         return OSAL_NEW sds_ttsfi_tclMsgTTSVersionInfoStatus;

      case sds_ttsfi_tclToken::EN_MSG_TTSVERSIONINFOUPREG:
         return OSAL_NEW sds_ttsfi_tclMsgTTSVersionInfoUpReg;

      case sds_ttsfi_tclToken::EN_MSG_TTSVERSIONINFORELUPREG:
         return OSAL_NEW sds_ttsfi_tclMsgTTSVersionInfoRelUpReg;

      case sds_ttsfi_tclToken::EN_MSG_TTSSTATUSGET:
         return OSAL_NEW sds_ttsfi_tclMsgTTSStatusGet;

      case sds_ttsfi_tclToken::EN_MSG_TTSSTATUSSTATUS:
         return OSAL_NEW sds_ttsfi_tclMsgTTSStatusStatus;

      case sds_ttsfi_tclToken::EN_MSG_TTSSTATUSUPREG:
         return OSAL_NEW sds_ttsfi_tclMsgTTSStatusUpReg;

      case sds_ttsfi_tclToken::EN_MSG_TTSSTATUSRELUPREG:
         return OSAL_NEW sds_ttsfi_tclMsgTTSStatusRelUpReg;

      case sds_ttsfi_tclToken::EN_MSG_DOWNLOADCOMPLETEGET:
         return OSAL_NEW sds_ttsfi_tclMsgDownloadCompleteGet;

      case sds_ttsfi_tclToken::EN_MSG_DOWNLOADCOMPLETEUPREG:
         return OSAL_NEW sds_ttsfi_tclMsgDownloadCompleteUpReg;

      case sds_ttsfi_tclToken::EN_MSG_DOWNLOADCOMPLETERELUPREG:
         return OSAL_NEW sds_ttsfi_tclMsgDownloadCompleteRelUpReg;

      case sds_ttsfi_tclToken::EN_MSG_DOWNLOADCOMPLETESTATUS:
         return OSAL_NEW sds_ttsfi_tclMsgDownloadCompleteStatus;

      case sds_ttsfi_tclToken::EN_MSG_TTSPLAYBACKSPACINGSET:
         return OSAL_NEW sds_ttsfi_tclMsgTTSPlaybackSpacingSet;

      case sds_ttsfi_tclToken::EN_MSG_TTSPLAYBACKSPACINGSTATUS:
         return OSAL_NEW sds_ttsfi_tclMsgTTSPlaybackSpacingStatus;

      case sds_ttsfi_tclToken::EN_MSG_TTSPLAYBACKSPACINGUPREG:
         return OSAL_NEW sds_ttsfi_tclMsgTTSPlaybackSpacingUpReg;

      case sds_ttsfi_tclToken::EN_MSG_TTSPLAYBACKSPACINGRELUPREG:
         return OSAL_NEW sds_ttsfi_tclMsgTTSPlaybackSpacingRelUpReg;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all sds_ttsfifi messages

// common functions

tU16 sds_ttsfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return SDS_TTSFI_C_U16_SERVICE_ID;
}

tU16 sds_ttsfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 sds_ttsfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& sds_ttsfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& sds_ttsfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 sds_ttsfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& sds_ttsfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& sds_ttsfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgSynthesizeSpeakMethodStart::sds_ttsfi_tclMsgSynthesizeSpeakMethodStart(const sds_ttsfi_tclMsgSynthesizeSpeakMethodStart& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   TextAndTags = coRef.TextAndTags;
   TextStyle = coRef.TextStyle;
   AudioOutputLocation = coRef.AudioOutputLocation;
   StatusInfo = coRef.StatusInfo;
   ExpDate = coRef.ExpDate;
   LastPackage = coRef.LastPackage;
}
sds_ttsfi_tclMsgSynthesizeSpeakMethodStart& sds_ttsfi_tclMsgSynthesizeSpeakMethodStart::operator=(const sds_ttsfi_tclMsgSynthesizeSpeakMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TextAndTags = coRef.TextAndTags;
   TextStyle = coRef.TextStyle;
   AudioOutputLocation = coRef.AudioOutputLocation;
   StatusInfo = coRef.StatusInfo;
   ExpDate = coRef.ExpDate;
   LastPackage = coRef.LastPackage;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_ttsfi_tclMsgSynthesizeSpeakMethodStart::vDestroy()
{
   TextAndTags.vDestroy();
}

sds_ttsfi_tclMsgSynthesizeSpeakMethodStart::sds_ttsfi_tclMsgSynthesizeSpeakMethodStart()
:TextAndTags()
,TextStyle()
,AudioOutputLocation()
,StatusInfo()
,ExpDate(0)
,LastPackage(0)
 {}

tS32 sds_ttsfi_tclMsgSynthesizeSpeakMethodStart::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODSTART;
}


sds_ttsfi_tclMsgSynthesizeSpeakMethodStart::~sds_ttsfi_tclMsgSynthesizeSpeakMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_ttsfi_tclMsgSynthesizeSpeakMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+TextAndTags.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_ttsfi_tclMsgSynthesizeSpeakMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TextAndTags);
   (tVoid) (oIn >> TextStyle);
   (tVoid) (oIn >> AudioOutputLocation);
   (tVoid) (oIn >> StatusInfo);
   (tVoid) (oIn >> ExpDate);
   (tVoid) (oIn >> LastPackage);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgSynthesizeSpeakMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TextAndTags);
   (tVoid) (oOut << TextStyle);
   (tVoid) (oOut << AudioOutputLocation);
   (tVoid) (oOut << StatusInfo);
   (tVoid) (oOut << ExpDate);
   (tVoid) (oOut << LastPackage);
   return oOut;
}

tBool sds_ttsfi_tclMsgSynthesizeSpeakMethodStart::operator==(const sds_ttsfi_tclMsgSynthesizeSpeakMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TextAndTags == roRef.TextAndTags);
   bResult = bResult && (TextStyle == roRef.TextStyle);
   bResult = bResult && (AudioOutputLocation == roRef.AudioOutputLocation);
   bResult = bResult && (StatusInfo == roRef.StatusInfo);
   bResult = bResult && (ExpDate == roRef.ExpDate);
   bResult = bResult && (LastPackage == roRef.LastPackage);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgSynthesizeSpeakMethodResultFirst::sds_ttsfi_tclMsgSynthesizeSpeakMethodResultFirst(const sds_ttsfi_tclMsgSynthesizeSpeakMethodResultFirst& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   JobProgress = coRef.JobProgress;
}
sds_ttsfi_tclMsgSynthesizeSpeakMethodResultFirst& sds_ttsfi_tclMsgSynthesizeSpeakMethodResultFirst::operator=(const sds_ttsfi_tclMsgSynthesizeSpeakMethodResultFirst& coRef)
{
   if (this == &coRef) return *this;
   JobProgress = coRef.JobProgress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_ttsfi_tclMsgSynthesizeSpeakMethodResultFirst::sds_ttsfi_tclMsgSynthesizeSpeakMethodResultFirst()
:JobProgress()
 {}

tS32 sds_ttsfi_tclMsgSynthesizeSpeakMethodResultFirst::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODRESULTFIRST;
}


sds_ttsfi_tclMsgSynthesizeSpeakMethodResultFirst::~sds_ttsfi_tclMsgSynthesizeSpeakMethodResultFirst()
{}

tU32 sds_ttsfi_tclMsgSynthesizeSpeakMethodResultFirst::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 17;
}

fi_tclInContext& sds_ttsfi_tclMsgSynthesizeSpeakMethodResultFirst::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> JobProgress);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgSynthesizeSpeakMethodResultFirst::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << JobProgress);
   return oOut;
}

tBool sds_ttsfi_tclMsgSynthesizeSpeakMethodResultFirst::operator==(const sds_ttsfi_tclMsgSynthesizeSpeakMethodResultFirst& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (JobProgress == roRef.JobProgress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgSynthesizeSpeakMethodResultMiddle::sds_ttsfi_tclMsgSynthesizeSpeakMethodResultMiddle(const sds_ttsfi_tclMsgSynthesizeSpeakMethodResultMiddle& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   JobProgress = coRef.JobProgress;
}
sds_ttsfi_tclMsgSynthesizeSpeakMethodResultMiddle& sds_ttsfi_tclMsgSynthesizeSpeakMethodResultMiddle::operator=(const sds_ttsfi_tclMsgSynthesizeSpeakMethodResultMiddle& coRef)
{
   if (this == &coRef) return *this;
   JobProgress = coRef.JobProgress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_ttsfi_tclMsgSynthesizeSpeakMethodResultMiddle::sds_ttsfi_tclMsgSynthesizeSpeakMethodResultMiddle()
:JobProgress()
 {}

tS32 sds_ttsfi_tclMsgSynthesizeSpeakMethodResultMiddle::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODRESULTMIDDLE;
}


sds_ttsfi_tclMsgSynthesizeSpeakMethodResultMiddle::~sds_ttsfi_tclMsgSynthesizeSpeakMethodResultMiddle()
{}

tU32 sds_ttsfi_tclMsgSynthesizeSpeakMethodResultMiddle::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 17;
}

fi_tclInContext& sds_ttsfi_tclMsgSynthesizeSpeakMethodResultMiddle::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> JobProgress);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgSynthesizeSpeakMethodResultMiddle::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << JobProgress);
   return oOut;
}

tBool sds_ttsfi_tclMsgSynthesizeSpeakMethodResultMiddle::operator==(const sds_ttsfi_tclMsgSynthesizeSpeakMethodResultMiddle& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (JobProgress == roRef.JobProgress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgSynthesizeSpeakMethodResultLast::sds_ttsfi_tclMsgSynthesizeSpeakMethodResultLast(const sds_ttsfi_tclMsgSynthesizeSpeakMethodResultLast& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   JobProgress = coRef.JobProgress;
}
sds_ttsfi_tclMsgSynthesizeSpeakMethodResultLast& sds_ttsfi_tclMsgSynthesizeSpeakMethodResultLast::operator=(const sds_ttsfi_tclMsgSynthesizeSpeakMethodResultLast& coRef)
{
   if (this == &coRef) return *this;
   JobProgress = coRef.JobProgress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_ttsfi_tclMsgSynthesizeSpeakMethodResultLast::sds_ttsfi_tclMsgSynthesizeSpeakMethodResultLast()
:JobProgress()
 {}

tS32 sds_ttsfi_tclMsgSynthesizeSpeakMethodResultLast::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODRESULTLAST;
}


sds_ttsfi_tclMsgSynthesizeSpeakMethodResultLast::~sds_ttsfi_tclMsgSynthesizeSpeakMethodResultLast()
{}

tU32 sds_ttsfi_tclMsgSynthesizeSpeakMethodResultLast::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 17;
}

fi_tclInContext& sds_ttsfi_tclMsgSynthesizeSpeakMethodResultLast::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> JobProgress);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgSynthesizeSpeakMethodResultLast::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << JobProgress);
   return oOut;
}

tBool sds_ttsfi_tclMsgSynthesizeSpeakMethodResultLast::operator==(const sds_ttsfi_tclMsgSynthesizeSpeakMethodResultLast& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (JobProgress == roRef.JobProgress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgSynthesizeWriteMethodStart::sds_ttsfi_tclMsgSynthesizeWriteMethodStart(const sds_ttsfi_tclMsgSynthesizeWriteMethodStart& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   TextAndTags = coRef.TextAndTags;
   TextStyle = coRef.TextStyle;
   Buffering = coRef.Buffering;
   ExpDate = coRef.ExpDate;
   LastPackage = coRef.LastPackage;
   Compression = coRef.Compression;
}
sds_ttsfi_tclMsgSynthesizeWriteMethodStart& sds_ttsfi_tclMsgSynthesizeWriteMethodStart::operator=(const sds_ttsfi_tclMsgSynthesizeWriteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TextAndTags = coRef.TextAndTags;
   TextStyle = coRef.TextStyle;
   Buffering = coRef.Buffering;
   ExpDate = coRef.ExpDate;
   LastPackage = coRef.LastPackage;
   Compression = coRef.Compression;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_ttsfi_tclMsgSynthesizeWriteMethodStart::vDestroy()
{
   TextAndTags.vDestroy();
}

sds_ttsfi_tclMsgSynthesizeWriteMethodStart::sds_ttsfi_tclMsgSynthesizeWriteMethodStart()
:TextAndTags()
,TextStyle()
,Buffering()
,ExpDate(0)
,LastPackage(0)
,Compression()
 {}

tS32 sds_ttsfi_tclMsgSynthesizeWriteMethodStart::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_SYNTHESIZEWRITEMETHODSTART;
}


sds_ttsfi_tclMsgSynthesizeWriteMethodStart::~sds_ttsfi_tclMsgSynthesizeWriteMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_ttsfi_tclMsgSynthesizeWriteMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+TextAndTags.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_ttsfi_tclMsgSynthesizeWriteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TextAndTags);
   (tVoid) (oIn >> TextStyle);
   (tVoid) (oIn >> Buffering);
   (tVoid) (oIn >> ExpDate);
   (tVoid) (oIn >> LastPackage);
   (tVoid) (oIn >> Compression);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgSynthesizeWriteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TextAndTags);
   (tVoid) (oOut << TextStyle);
   (tVoid) (oOut << Buffering);
   (tVoid) (oOut << ExpDate);
   (tVoid) (oOut << LastPackage);
   (tVoid) (oOut << Compression);
   return oOut;
}

tBool sds_ttsfi_tclMsgSynthesizeWriteMethodStart::operator==(const sds_ttsfi_tclMsgSynthesizeWriteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TextAndTags == roRef.TextAndTags);
   bResult = bResult && (TextStyle == roRef.TextStyle);
   bResult = bResult && (Buffering == roRef.Buffering);
   bResult = bResult && (ExpDate == roRef.ExpDate);
   bResult = bResult && (LastPackage == roRef.LastPackage);
   bResult = bResult && (Compression == roRef.Compression);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgSynthesizeWriteMethodResultFirst::sds_ttsfi_tclMsgSynthesizeWriteMethodResultFirst(const sds_ttsfi_tclMsgSynthesizeWriteMethodResultFirst& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   BufferingProgress = coRef.BufferingProgress;
}
sds_ttsfi_tclMsgSynthesizeWriteMethodResultFirst& sds_ttsfi_tclMsgSynthesizeWriteMethodResultFirst::operator=(const sds_ttsfi_tclMsgSynthesizeWriteMethodResultFirst& coRef)
{
   if (this == &coRef) return *this;
   BufferingProgress = coRef.BufferingProgress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_ttsfi_tclMsgSynthesizeWriteMethodResultFirst::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < BufferingProgress.size(); ++u32Idx)
         BufferingProgress[u32Idx].vDestroy();
   BufferingProgress.clear();
   }
}

sds_ttsfi_tclMsgSynthesizeWriteMethodResultFirst::sds_ttsfi_tclMsgSynthesizeWriteMethodResultFirst()

 {}

tS32 sds_ttsfi_tclMsgSynthesizeWriteMethodResultFirst::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_SYNTHESIZEWRITEMETHODRESULTFIRST;
}


sds_ttsfi_tclMsgSynthesizeWriteMethodResultFirst::~sds_ttsfi_tclMsgSynthesizeWriteMethodResultFirst()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_ttsfi_tclMsgSynthesizeWriteMethodResultFirst::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < BufferingProgress.size(); ++u32ListIdx)
      u32DynamicSize += BufferingProgress[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_ttsfi_tclMsgSynthesizeWriteMethodResultFirst::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < BufferingProgress.size(); ++u32Idx)
      {
         BufferingProgress[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      BufferingProgress.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> BufferingProgress[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgSynthesizeWriteMethodResultFirst::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)BufferingProgress.size());
   {
      for (tU32 u32Idx = 0; u32Idx < BufferingProgress.size(); ++u32Idx)
         (tVoid) (oOut << BufferingProgress[u32Idx]);
   }
   return oOut;
}

tBool sds_ttsfi_tclMsgSynthesizeWriteMethodResultFirst::operator==(const sds_ttsfi_tclMsgSynthesizeWriteMethodResultFirst& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (BufferingProgress.size() == roRef.BufferingProgress.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < BufferingProgress.size()); ++u32Idx)
            bResult = bResult && (BufferingProgress[u32Idx] == roRef.BufferingProgress[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgSynthesizeWriteMethodResultMiddle::sds_ttsfi_tclMsgSynthesizeWriteMethodResultMiddle(const sds_ttsfi_tclMsgSynthesizeWriteMethodResultMiddle& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   BufferingProgress = coRef.BufferingProgress;
}
sds_ttsfi_tclMsgSynthesizeWriteMethodResultMiddle& sds_ttsfi_tclMsgSynthesizeWriteMethodResultMiddle::operator=(const sds_ttsfi_tclMsgSynthesizeWriteMethodResultMiddle& coRef)
{
   if (this == &coRef) return *this;
   BufferingProgress = coRef.BufferingProgress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_ttsfi_tclMsgSynthesizeWriteMethodResultMiddle::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < BufferingProgress.size(); ++u32Idx)
         BufferingProgress[u32Idx].vDestroy();
   BufferingProgress.clear();
   }
}

sds_ttsfi_tclMsgSynthesizeWriteMethodResultMiddle::sds_ttsfi_tclMsgSynthesizeWriteMethodResultMiddle()

 {}

tS32 sds_ttsfi_tclMsgSynthesizeWriteMethodResultMiddle::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_SYNTHESIZEWRITEMETHODRESULTMIDDLE;
}


sds_ttsfi_tclMsgSynthesizeWriteMethodResultMiddle::~sds_ttsfi_tclMsgSynthesizeWriteMethodResultMiddle()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_ttsfi_tclMsgSynthesizeWriteMethodResultMiddle::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < BufferingProgress.size(); ++u32ListIdx)
      u32DynamicSize += BufferingProgress[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_ttsfi_tclMsgSynthesizeWriteMethodResultMiddle::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < BufferingProgress.size(); ++u32Idx)
      {
         BufferingProgress[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      BufferingProgress.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> BufferingProgress[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgSynthesizeWriteMethodResultMiddle::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)BufferingProgress.size());
   {
      for (tU32 u32Idx = 0; u32Idx < BufferingProgress.size(); ++u32Idx)
         (tVoid) (oOut << BufferingProgress[u32Idx]);
   }
   return oOut;
}

tBool sds_ttsfi_tclMsgSynthesizeWriteMethodResultMiddle::operator==(const sds_ttsfi_tclMsgSynthesizeWriteMethodResultMiddle& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (BufferingProgress.size() == roRef.BufferingProgress.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < BufferingProgress.size()); ++u32Idx)
            bResult = bResult && (BufferingProgress[u32Idx] == roRef.BufferingProgress[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgSynthesizeWriteMethodResultLast::sds_ttsfi_tclMsgSynthesizeWriteMethodResultLast(const sds_ttsfi_tclMsgSynthesizeWriteMethodResultLast& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   BufferingProgress = coRef.BufferingProgress;
}
sds_ttsfi_tclMsgSynthesizeWriteMethodResultLast& sds_ttsfi_tclMsgSynthesizeWriteMethodResultLast::operator=(const sds_ttsfi_tclMsgSynthesizeWriteMethodResultLast& coRef)
{
   if (this == &coRef) return *this;
   BufferingProgress = coRef.BufferingProgress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_ttsfi_tclMsgSynthesizeWriteMethodResultLast::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < BufferingProgress.size(); ++u32Idx)
         BufferingProgress[u32Idx].vDestroy();
   BufferingProgress.clear();
   }
}

sds_ttsfi_tclMsgSynthesizeWriteMethodResultLast::sds_ttsfi_tclMsgSynthesizeWriteMethodResultLast()

 {}

tS32 sds_ttsfi_tclMsgSynthesizeWriteMethodResultLast::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_SYNTHESIZEWRITEMETHODRESULTLAST;
}


sds_ttsfi_tclMsgSynthesizeWriteMethodResultLast::~sds_ttsfi_tclMsgSynthesizeWriteMethodResultLast()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_ttsfi_tclMsgSynthesizeWriteMethodResultLast::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < BufferingProgress.size(); ++u32ListIdx)
      u32DynamicSize += BufferingProgress[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_ttsfi_tclMsgSynthesizeWriteMethodResultLast::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < BufferingProgress.size(); ++u32Idx)
      {
         BufferingProgress[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      BufferingProgress.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> BufferingProgress[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgSynthesizeWriteMethodResultLast::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)BufferingProgress.size());
   {
      for (tU32 u32Idx = 0; u32Idx < BufferingProgress.size(); ++u32Idx)
         (tVoid) (oOut << BufferingProgress[u32Idx]);
   }
   return oOut;
}

tBool sds_ttsfi_tclMsgSynthesizeWriteMethodResultLast::operator==(const sds_ttsfi_tclMsgSynthesizeWriteMethodResultLast& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (BufferingProgress.size() == roRef.BufferingProgress.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < BufferingProgress.size()); ++u32Idx)
            bResult = bResult && (BufferingProgress[u32Idx] == roRef.BufferingProgress[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodStart::sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodStart(const sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodStart& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   TextAndTags = coRef.TextAndTags;
   TextStyle = coRef.TextStyle;
   LanguageID = coRef.LanguageID;
   AudioOutputLocation = coRef.AudioOutputLocation;
   StatusInfo = coRef.StatusInfo;
   ExpDate = coRef.ExpDate;
   LastPackage = coRef.LastPackage;
   Index = coRef.Index;
   SpeechSequence = coRef.SpeechSequence;
}
sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodStart& sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodStart::operator=(const sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TextAndTags = coRef.TextAndTags;
   TextStyle = coRef.TextStyle;
   LanguageID = coRef.LanguageID;
   AudioOutputLocation = coRef.AudioOutputLocation;
   StatusInfo = coRef.StatusInfo;
   ExpDate = coRef.ExpDate;
   LastPackage = coRef.LastPackage;
   Index = coRef.Index;
   SpeechSequence = coRef.SpeechSequence;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodStart::vDestroy()
{
   TextAndTags.vDestroy();
   LanguageID.vDestroy(); 
}

sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodStart::sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodStart()
:TextAndTags()
,TextStyle()
,LanguageID()
,AudioOutputLocation()
,StatusInfo()
,ExpDate(0)
,LastPackage(0)
,Index(0)
,SpeechSequence()
 {}

tS32 sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodStart::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKWITHEXTENSIONMETHODSTART;
}


sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodStart::~sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 14+TextAndTags.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TextAndTags);
   (tVoid) (oIn >> TextStyle);
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> AudioOutputLocation);
   (tVoid) (oIn >> StatusInfo);
   (tVoid) (oIn >> ExpDate);
   (tVoid) (oIn >> LastPackage);
   (tVoid) (oIn >> Index);
   (tVoid) (oIn >> SpeechSequence);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TextAndTags);
   (tVoid) (oOut << TextStyle);
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << AudioOutputLocation);
   (tVoid) (oOut << StatusInfo);
   (tVoid) (oOut << ExpDate);
   (tVoid) (oOut << LastPackage);
   (tVoid) (oOut << Index);
   (tVoid) (oOut << SpeechSequence);
   return oOut;
}

tBool sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodStart::operator==(const sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TextAndTags == roRef.TextAndTags);
   bResult = bResult && (TextStyle == roRef.TextStyle);
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (AudioOutputLocation == roRef.AudioOutputLocation);
   bResult = bResult && (StatusInfo == roRef.StatusInfo);
   bResult = bResult && (ExpDate == roRef.ExpDate);
   bResult = bResult && (LastPackage == roRef.LastPackage);
   bResult = bResult && (Index == roRef.Index);
   bResult = bResult && (SpeechSequence == roRef.SpeechSequence);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultFirst::sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultFirst(const sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultFirst& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   JobProgress = coRef.JobProgress;
}
sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultFirst& sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultFirst::operator=(const sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultFirst& coRef)
{
   if (this == &coRef) return *this;
   JobProgress = coRef.JobProgress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultFirst::sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultFirst()
:JobProgress()
 {}

tS32 sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultFirst::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKWITHEXTENSIONMETHODRESULTFIRST;
}


sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultFirst::~sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultFirst()
{}

tU32 sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultFirst::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 17;
}

fi_tclInContext& sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultFirst::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> JobProgress);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultFirst::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << JobProgress);
   return oOut;
}

tBool sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultFirst::operator==(const sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultFirst& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (JobProgress == roRef.JobProgress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultMiddle::sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultMiddle(const sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultMiddle& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   JobProgress = coRef.JobProgress;
}
sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultMiddle& sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultMiddle::operator=(const sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultMiddle& coRef)
{
   if (this == &coRef) return *this;
   JobProgress = coRef.JobProgress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultMiddle::sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultMiddle()
:JobProgress()
 {}

tS32 sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultMiddle::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKWITHEXTENSIONMETHODRESULTMIDDLE;
}


sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultMiddle::~sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultMiddle()
{}

tU32 sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultMiddle::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 17;
}

fi_tclInContext& sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultMiddle::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> JobProgress);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultMiddle::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << JobProgress);
   return oOut;
}

tBool sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultMiddle::operator==(const sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultMiddle& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (JobProgress == roRef.JobProgress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultLast::sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultLast(const sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultLast& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   JobProgress = coRef.JobProgress;
}
sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultLast& sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultLast::operator=(const sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultLast& coRef)
{
   if (this == &coRef) return *this;
   JobProgress = coRef.JobProgress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultLast::sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultLast()
:JobProgress()
 {}

tS32 sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultLast::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKWITHEXTENSIONMETHODRESULTLAST;
}


sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultLast::~sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultLast()
{}

tU32 sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultLast::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 17;
}

fi_tclInContext& sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultLast::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> JobProgress);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultLast::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << JobProgress);
   return oOut;
}

tBool sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultLast::operator==(const sds_ttsfi_tclMsgSynthesizeSpeakWithExtensionMethodResultLast& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (JobProgress == roRef.JobProgress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgPrepareVoiceOutputMethodStart::sds_ttsfi_tclMsgPrepareVoiceOutputMethodStart(const sds_ttsfi_tclMsgPrepareVoiceOutputMethodStart& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   Device = coRef.Device;
}
sds_ttsfi_tclMsgPrepareVoiceOutputMethodStart& sds_ttsfi_tclMsgPrepareVoiceOutputMethodStart::operator=(const sds_ttsfi_tclMsgPrepareVoiceOutputMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Device = coRef.Device;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_ttsfi_tclMsgPrepareVoiceOutputMethodStart::vDestroy()
{
   Device.vDestroy();
}

sds_ttsfi_tclMsgPrepareVoiceOutputMethodStart::sds_ttsfi_tclMsgPrepareVoiceOutputMethodStart()
:Device()
 {}

tS32 sds_ttsfi_tclMsgPrepareVoiceOutputMethodStart::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_PREPAREVOICEOUTPUTMETHODSTART;
}


sds_ttsfi_tclMsgPrepareVoiceOutputMethodStart::~sds_ttsfi_tclMsgPrepareVoiceOutputMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_ttsfi_tclMsgPrepareVoiceOutputMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Device.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_ttsfi_tclMsgPrepareVoiceOutputMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Device);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgPrepareVoiceOutputMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Device);
   return oOut;
}

tBool sds_ttsfi_tclMsgPrepareVoiceOutputMethodStart::operator==(const sds_ttsfi_tclMsgPrepareVoiceOutputMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Device == roRef.Device);
   return bResult;
}

//=============================================================================

sds_ttsfi_tclMsgPrepareVoiceOutputMethodResult::sds_ttsfi_tclMsgPrepareVoiceOutputMethodResult()
 {}

tS32 sds_ttsfi_tclMsgPrepareVoiceOutputMethodResult::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_PREPAREVOICEOUTPUTMETHODRESULT;
}


sds_ttsfi_tclMsgPrepareVoiceOutputMethodResult::~sds_ttsfi_tclMsgPrepareVoiceOutputMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgReleaseDataMethodStart::sds_ttsfi_tclMsgReleaseDataMethodStart(const sds_ttsfi_tclMsgReleaseDataMethodStart& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   ReleaseType = coRef.ReleaseType;
}
sds_ttsfi_tclMsgReleaseDataMethodStart& sds_ttsfi_tclMsgReleaseDataMethodStart::operator=(const sds_ttsfi_tclMsgReleaseDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ReleaseType = coRef.ReleaseType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_ttsfi_tclMsgReleaseDataMethodStart::sds_ttsfi_tclMsgReleaseDataMethodStart()
:ReleaseType()
 {}

tS32 sds_ttsfi_tclMsgReleaseDataMethodStart::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_RELEASEDATAMETHODSTART;
}


sds_ttsfi_tclMsgReleaseDataMethodStart::~sds_ttsfi_tclMsgReleaseDataMethodStart()
{}

tU32 sds_ttsfi_tclMsgReleaseDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_ttsfi_tclMsgReleaseDataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ReleaseType);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgReleaseDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ReleaseType);
   return oOut;
}

tBool sds_ttsfi_tclMsgReleaseDataMethodStart::operator==(const sds_ttsfi_tclMsgReleaseDataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ReleaseType == roRef.ReleaseType);
   return bResult;
}

//=============================================================================

sds_ttsfi_tclMsgReleaseDataMethodResult::sds_ttsfi_tclMsgReleaseDataMethodResult()
 {}

tS32 sds_ttsfi_tclMsgReleaseDataMethodResult::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_RELEASEDATAMETHODRESULT;
}


sds_ttsfi_tclMsgReleaseDataMethodResult::~sds_ttsfi_tclMsgReleaseDataMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgSetVoiceMethodStart::sds_ttsfi_tclMsgSetVoiceMethodStart(const sds_ttsfi_tclMsgSetVoiceMethodStart& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   TTSVoice = coRef.TTSVoice;
}
sds_ttsfi_tclMsgSetVoiceMethodStart& sds_ttsfi_tclMsgSetVoiceMethodStart::operator=(const sds_ttsfi_tclMsgSetVoiceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TTSVoice = coRef.TTSVoice;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_ttsfi_tclMsgSetVoiceMethodStart::vDestroy()
{
   TTSVoice.vDestroy(); 
}

sds_ttsfi_tclMsgSetVoiceMethodStart::sds_ttsfi_tclMsgSetVoiceMethodStart()
:TTSVoice()
 {}

tS32 sds_ttsfi_tclMsgSetVoiceMethodStart::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_SETVOICEMETHODSTART;
}


sds_ttsfi_tclMsgSetVoiceMethodStart::~sds_ttsfi_tclMsgSetVoiceMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_ttsfi_tclMsgSetVoiceMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TTSVoice.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_ttsfi_tclMsgSetVoiceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TTSVoice);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgSetVoiceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TTSVoice);
   return oOut;
}

tBool sds_ttsfi_tclMsgSetVoiceMethodStart::operator==(const sds_ttsfi_tclMsgSetVoiceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TTSVoice == roRef.TTSVoice);
   return bResult;
}

//=============================================================================

sds_ttsfi_tclMsgSetVoiceMethodResult::sds_ttsfi_tclMsgSetVoiceMethodResult()
 {}

tS32 sds_ttsfi_tclMsgSetVoiceMethodResult::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_SETVOICEMETHODRESULT;
}


sds_ttsfi_tclMsgSetVoiceMethodResult::~sds_ttsfi_tclMsgSetVoiceMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgAbortPromptMethodStart::sds_ttsfi_tclMsgAbortPromptMethodStart(const sds_ttsfi_tclMsgAbortPromptMethodStart& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   AbortPromptOption = coRef.AbortPromptOption;
}
sds_ttsfi_tclMsgAbortPromptMethodStart& sds_ttsfi_tclMsgAbortPromptMethodStart::operator=(const sds_ttsfi_tclMsgAbortPromptMethodStart& coRef)
{
   if (this == &coRef) return *this;
   AbortPromptOption = coRef.AbortPromptOption;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_ttsfi_tclMsgAbortPromptMethodStart::sds_ttsfi_tclMsgAbortPromptMethodStart()
:AbortPromptOption()
 {}

tS32 sds_ttsfi_tclMsgAbortPromptMethodStart::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_ABORTPROMPTMETHODSTART;
}


sds_ttsfi_tclMsgAbortPromptMethodStart::~sds_ttsfi_tclMsgAbortPromptMethodStart()
{}

tU32 sds_ttsfi_tclMsgAbortPromptMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_ttsfi_tclMsgAbortPromptMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AbortPromptOption);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgAbortPromptMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AbortPromptOption);
   return oOut;
}

tBool sds_ttsfi_tclMsgAbortPromptMethodStart::operator==(const sds_ttsfi_tclMsgAbortPromptMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AbortPromptOption == roRef.AbortPromptOption);
   return bResult;
}

//=============================================================================

sds_ttsfi_tclMsgAbortPromptMethodResult::sds_ttsfi_tclMsgAbortPromptMethodResult()
 {}

tS32 sds_ttsfi_tclMsgAbortPromptMethodResult::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_ABORTPROMPTMETHODRESULT;
}


sds_ttsfi_tclMsgAbortPromptMethodResult::~sds_ttsfi_tclMsgAbortPromptMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgPausePromptMethodStart::sds_ttsfi_tclMsgPausePromptMethodStart(const sds_ttsfi_tclMsgPausePromptMethodStart& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   PausePromptOption = coRef.PausePromptOption;
}
sds_ttsfi_tclMsgPausePromptMethodStart& sds_ttsfi_tclMsgPausePromptMethodStart::operator=(const sds_ttsfi_tclMsgPausePromptMethodStart& coRef)
{
   if (this == &coRef) return *this;
   PausePromptOption = coRef.PausePromptOption;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_ttsfi_tclMsgPausePromptMethodStart::sds_ttsfi_tclMsgPausePromptMethodStart()
:PausePromptOption()
 {}

tS32 sds_ttsfi_tclMsgPausePromptMethodStart::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_PAUSEPROMPTMETHODSTART;
}


sds_ttsfi_tclMsgPausePromptMethodStart::~sds_ttsfi_tclMsgPausePromptMethodStart()
{}

tU32 sds_ttsfi_tclMsgPausePromptMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_ttsfi_tclMsgPausePromptMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PausePromptOption);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgPausePromptMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PausePromptOption);
   return oOut;
}

tBool sds_ttsfi_tclMsgPausePromptMethodStart::operator==(const sds_ttsfi_tclMsgPausePromptMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PausePromptOption == roRef.PausePromptOption);
   return bResult;
}

//=============================================================================

sds_ttsfi_tclMsgPausePromptMethodResult::sds_ttsfi_tclMsgPausePromptMethodResult()
 {}

tS32 sds_ttsfi_tclMsgPausePromptMethodResult::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_PAUSEPROMPTMETHODRESULT;
}


sds_ttsfi_tclMsgPausePromptMethodResult::~sds_ttsfi_tclMsgPausePromptMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgContinuePromptMethodStart::sds_ttsfi_tclMsgContinuePromptMethodStart(const sds_ttsfi_tclMsgContinuePromptMethodStart& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   Dummy = coRef.Dummy;
}
sds_ttsfi_tclMsgContinuePromptMethodStart& sds_ttsfi_tclMsgContinuePromptMethodStart::operator=(const sds_ttsfi_tclMsgContinuePromptMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Dummy = coRef.Dummy;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_ttsfi_tclMsgContinuePromptMethodStart::sds_ttsfi_tclMsgContinuePromptMethodStart()
:Dummy(0)
 {}

tS32 sds_ttsfi_tclMsgContinuePromptMethodStart::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_CONTINUEPROMPTMETHODSTART;
}


sds_ttsfi_tclMsgContinuePromptMethodStart::~sds_ttsfi_tclMsgContinuePromptMethodStart()
{}

tU32 sds_ttsfi_tclMsgContinuePromptMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_ttsfi_tclMsgContinuePromptMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Dummy);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgContinuePromptMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Dummy);
   return oOut;
}

tBool sds_ttsfi_tclMsgContinuePromptMethodStart::operator==(const sds_ttsfi_tclMsgContinuePromptMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Dummy == roRef.Dummy);
   return bResult;
}

//=============================================================================

sds_ttsfi_tclMsgContinuePromptMethodResult::sds_ttsfi_tclMsgContinuePromptMethodResult()
 {}

tS32 sds_ttsfi_tclMsgContinuePromptMethodResult::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_CONTINUEPROMPTMETHODRESULT;
}


sds_ttsfi_tclMsgContinuePromptMethodResult::~sds_ttsfi_tclMsgContinuePromptMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgAbortPromptWithExtensionMethodStart::sds_ttsfi_tclMsgAbortPromptWithExtensionMethodStart(const sds_ttsfi_tclMsgAbortPromptWithExtensionMethodStart& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   AbortPromptOption = coRef.AbortPromptOption;
}
sds_ttsfi_tclMsgAbortPromptWithExtensionMethodStart& sds_ttsfi_tclMsgAbortPromptWithExtensionMethodStart::operator=(const sds_ttsfi_tclMsgAbortPromptWithExtensionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   AbortPromptOption = coRef.AbortPromptOption;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_ttsfi_tclMsgAbortPromptWithExtensionMethodStart::sds_ttsfi_tclMsgAbortPromptWithExtensionMethodStart()
:AbortPromptOption()
 {}

tS32 sds_ttsfi_tclMsgAbortPromptWithExtensionMethodStart::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_ABORTPROMPTWITHEXTENSIONMETHODSTART;
}


sds_ttsfi_tclMsgAbortPromptWithExtensionMethodStart::~sds_ttsfi_tclMsgAbortPromptWithExtensionMethodStart()
{}

tU32 sds_ttsfi_tclMsgAbortPromptWithExtensionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_ttsfi_tclMsgAbortPromptWithExtensionMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AbortPromptOption);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgAbortPromptWithExtensionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AbortPromptOption);
   return oOut;
}

tBool sds_ttsfi_tclMsgAbortPromptWithExtensionMethodStart::operator==(const sds_ttsfi_tclMsgAbortPromptWithExtensionMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AbortPromptOption == roRef.AbortPromptOption);
   return bResult;
}

//=============================================================================

sds_ttsfi_tclMsgAbortPromptWithExtensionMethodResult::sds_ttsfi_tclMsgAbortPromptWithExtensionMethodResult()
 {}

tS32 sds_ttsfi_tclMsgAbortPromptWithExtensionMethodResult::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_ABORTPROMPTWITHEXTENSIONMETHODRESULT;
}


sds_ttsfi_tclMsgAbortPromptWithExtensionMethodResult::~sds_ttsfi_tclMsgAbortPromptWithExtensionMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgPausePromptWithExtensionMethodStart::sds_ttsfi_tclMsgPausePromptWithExtensionMethodStart(const sds_ttsfi_tclMsgPausePromptWithExtensionMethodStart& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   PausePromptOption = coRef.PausePromptOption;
}
sds_ttsfi_tclMsgPausePromptWithExtensionMethodStart& sds_ttsfi_tclMsgPausePromptWithExtensionMethodStart::operator=(const sds_ttsfi_tclMsgPausePromptWithExtensionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   PausePromptOption = coRef.PausePromptOption;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_ttsfi_tclMsgPausePromptWithExtensionMethodStart::sds_ttsfi_tclMsgPausePromptWithExtensionMethodStart()
:PausePromptOption()
 {}

tS32 sds_ttsfi_tclMsgPausePromptWithExtensionMethodStart::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_PAUSEPROMPTWITHEXTENSIONMETHODSTART;
}


sds_ttsfi_tclMsgPausePromptWithExtensionMethodStart::~sds_ttsfi_tclMsgPausePromptWithExtensionMethodStart()
{}

tU32 sds_ttsfi_tclMsgPausePromptWithExtensionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_ttsfi_tclMsgPausePromptWithExtensionMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PausePromptOption);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgPausePromptWithExtensionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PausePromptOption);
   return oOut;
}

tBool sds_ttsfi_tclMsgPausePromptWithExtensionMethodStart::operator==(const sds_ttsfi_tclMsgPausePromptWithExtensionMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PausePromptOption == roRef.PausePromptOption);
   return bResult;
}

//=============================================================================

sds_ttsfi_tclMsgPausePromptWithExtensionMethodResult::sds_ttsfi_tclMsgPausePromptWithExtensionMethodResult()
 {}

tS32 sds_ttsfi_tclMsgPausePromptWithExtensionMethodResult::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_PAUSEPROMPTWITHEXTENSIONMETHODRESULT;
}


sds_ttsfi_tclMsgPausePromptWithExtensionMethodResult::~sds_ttsfi_tclMsgPausePromptWithExtensionMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgContinuePromptWithExtensionMethodStart::sds_ttsfi_tclMsgContinuePromptWithExtensionMethodStart(const sds_ttsfi_tclMsgContinuePromptWithExtensionMethodStart& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   Dummy = coRef.Dummy;
}
sds_ttsfi_tclMsgContinuePromptWithExtensionMethodStart& sds_ttsfi_tclMsgContinuePromptWithExtensionMethodStart::operator=(const sds_ttsfi_tclMsgContinuePromptWithExtensionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Dummy = coRef.Dummy;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_ttsfi_tclMsgContinuePromptWithExtensionMethodStart::sds_ttsfi_tclMsgContinuePromptWithExtensionMethodStart()
:Dummy(0)
 {}

tS32 sds_ttsfi_tclMsgContinuePromptWithExtensionMethodStart::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_CONTINUEPROMPTWITHEXTENSIONMETHODSTART;
}


sds_ttsfi_tclMsgContinuePromptWithExtensionMethodStart::~sds_ttsfi_tclMsgContinuePromptWithExtensionMethodStart()
{}

tU32 sds_ttsfi_tclMsgContinuePromptWithExtensionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_ttsfi_tclMsgContinuePromptWithExtensionMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Dummy);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgContinuePromptWithExtensionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Dummy);
   return oOut;
}

tBool sds_ttsfi_tclMsgContinuePromptWithExtensionMethodStart::operator==(const sds_ttsfi_tclMsgContinuePromptWithExtensionMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Dummy == roRef.Dummy);
   return bResult;
}

//=============================================================================

sds_ttsfi_tclMsgContinuePromptWithExtensionMethodResult::sds_ttsfi_tclMsgContinuePromptWithExtensionMethodResult()
 {}

tS32 sds_ttsfi_tclMsgContinuePromptWithExtensionMethodResult::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_CONTINUEPROMPTWITHEXTENSIONMETHODRESULT;
}


sds_ttsfi_tclMsgContinuePromptWithExtensionMethodResult::~sds_ttsfi_tclMsgContinuePromptWithExtensionMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgRequestPhonemeMethodStart::sds_ttsfi_tclMsgRequestPhonemeMethodStart(const sds_ttsfi_tclMsgRequestPhonemeMethodStart& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   TextAndTags = coRef.TextAndTags;
   TextStyle = coRef.TextStyle;
}
sds_ttsfi_tclMsgRequestPhonemeMethodStart& sds_ttsfi_tclMsgRequestPhonemeMethodStart::operator=(const sds_ttsfi_tclMsgRequestPhonemeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TextAndTags = coRef.TextAndTags;
   TextStyle = coRef.TextStyle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_ttsfi_tclMsgRequestPhonemeMethodStart::vDestroy()
{
   TextAndTags.vDestroy();
}

sds_ttsfi_tclMsgRequestPhonemeMethodStart::sds_ttsfi_tclMsgRequestPhonemeMethodStart()
:TextAndTags()
,TextStyle()
 {}

tS32 sds_ttsfi_tclMsgRequestPhonemeMethodStart::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_REQUESTPHONEMEMETHODSTART;
}


sds_ttsfi_tclMsgRequestPhonemeMethodStart::~sds_ttsfi_tclMsgRequestPhonemeMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_ttsfi_tclMsgRequestPhonemeMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+TextAndTags.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_ttsfi_tclMsgRequestPhonemeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TextAndTags);
   (tVoid) (oIn >> TextStyle);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgRequestPhonemeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TextAndTags);
   (tVoid) (oOut << TextStyle);
   return oOut;
}

tBool sds_ttsfi_tclMsgRequestPhonemeMethodStart::operator==(const sds_ttsfi_tclMsgRequestPhonemeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TextAndTags == roRef.TextAndTags);
   bResult = bResult && (TextStyle == roRef.TextStyle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgRequestPhonemeMethodResult::sds_ttsfi_tclMsgRequestPhonemeMethodResult(const sds_ttsfi_tclMsgRequestPhonemeMethodResult& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   PhonemeList = coRef.PhonemeList;
}
sds_ttsfi_tclMsgRequestPhonemeMethodResult& sds_ttsfi_tclMsgRequestPhonemeMethodResult::operator=(const sds_ttsfi_tclMsgRequestPhonemeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   PhonemeList = coRef.PhonemeList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_ttsfi_tclMsgRequestPhonemeMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < PhonemeList.size(); ++u32Idx)
         PhonemeList[u32Idx].vDestroy();
   PhonemeList.clear();
   }
}

sds_ttsfi_tclMsgRequestPhonemeMethodResult::sds_ttsfi_tclMsgRequestPhonemeMethodResult()

 {}

tS32 sds_ttsfi_tclMsgRequestPhonemeMethodResult::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_REQUESTPHONEMEMETHODRESULT;
}


sds_ttsfi_tclMsgRequestPhonemeMethodResult::~sds_ttsfi_tclMsgRequestPhonemeMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_ttsfi_tclMsgRequestPhonemeMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < PhonemeList.size(); ++u32ListIdx)
      u32DynamicSize += PhonemeList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_ttsfi_tclMsgRequestPhonemeMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PhonemeList.size(); ++u32Idx)
      {
         PhonemeList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      PhonemeList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PhonemeList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgRequestPhonemeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)PhonemeList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PhonemeList.size(); ++u32Idx)
         (tVoid) (oOut << PhonemeList[u32Idx]);
   }
   return oOut;
}

tBool sds_ttsfi_tclMsgRequestPhonemeMethodResult::operator==(const sds_ttsfi_tclMsgRequestPhonemeMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (PhonemeList.size() == roRef.PhonemeList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PhonemeList.size()); ++u32Idx)
            bResult = bResult && (PhonemeList[u32Idx] == roRef.PhonemeList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgLoadTuningFilesMethodStart::sds_ttsfi_tclMsgLoadTuningFilesMethodStart(const sds_ttsfi_tclMsgLoadTuningFilesMethodStart& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   TTSTunFiles = coRef.TTSTunFiles;
   TTSDomain = coRef.TTSDomain;
   TTSVersion = coRef.TTSVersion;
}
sds_ttsfi_tclMsgLoadTuningFilesMethodStart& sds_ttsfi_tclMsgLoadTuningFilesMethodStart::operator=(const sds_ttsfi_tclMsgLoadTuningFilesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TTSTunFiles = coRef.TTSTunFiles;
   TTSDomain = coRef.TTSDomain;
   TTSVersion = coRef.TTSVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_ttsfi_tclMsgLoadTuningFilesMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TTSTunFiles.size(); ++u32Idx)
         TTSTunFiles[u32Idx].vDestroy();
   TTSTunFiles.clear();
   }
   TTSVersion.vDestroy();
}

sds_ttsfi_tclMsgLoadTuningFilesMethodStart::sds_ttsfi_tclMsgLoadTuningFilesMethodStart()

:TTSDomain()
,TTSVersion()
 {}

tS32 sds_ttsfi_tclMsgLoadTuningFilesMethodStart::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_LOADTUNINGFILESMETHODSTART;
}


sds_ttsfi_tclMsgLoadTuningFilesMethodStart::~sds_ttsfi_tclMsgLoadTuningFilesMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_ttsfi_tclMsgLoadTuningFilesMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TTSTunFiles.size(); ++u32ListIdx)
      u32DynamicSize += TTSTunFiles[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+5+TTSVersion.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_ttsfi_tclMsgLoadTuningFilesMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TTSTunFiles.size(); ++u32Idx)
      {
         TTSTunFiles[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TTSTunFiles.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TTSTunFiles[u32Idx]);
      }
   }
   (tVoid) (oIn >> TTSDomain);
   (tVoid) (oIn >> TTSVersion);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgLoadTuningFilesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TTSTunFiles.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TTSTunFiles.size(); ++u32Idx)
         (tVoid) (oOut << TTSTunFiles[u32Idx]);
   }
   (tVoid) (oOut << TTSDomain);
   (tVoid) (oOut << TTSVersion);
   return oOut;
}

tBool sds_ttsfi_tclMsgLoadTuningFilesMethodStart::operator==(const sds_ttsfi_tclMsgLoadTuningFilesMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TTSTunFiles.size() == roRef.TTSTunFiles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TTSTunFiles.size()); ++u32Idx)
            bResult = bResult && (TTSTunFiles[u32Idx] == roRef.TTSTunFiles[u32Idx]);
      }
   bResult = bResult && (TTSDomain == roRef.TTSDomain);
   bResult = bResult && (TTSVersion == roRef.TTSVersion);
   return bResult;
}

//=============================================================================

sds_ttsfi_tclMsgLoadTuningFilesMethodResult::sds_ttsfi_tclMsgLoadTuningFilesMethodResult()
 {}

tS32 sds_ttsfi_tclMsgLoadTuningFilesMethodResult::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_LOADTUNINGFILESMETHODRESULT;
}


sds_ttsfi_tclMsgLoadTuningFilesMethodResult::~sds_ttsfi_tclMsgLoadTuningFilesMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgSetDefaultSpeechRateMethodStart::sds_ttsfi_tclMsgSetDefaultSpeechRateMethodStart(const sds_ttsfi_tclMsgSetDefaultSpeechRateMethodStart& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   Rate = coRef.Rate;
}
sds_ttsfi_tclMsgSetDefaultSpeechRateMethodStart& sds_ttsfi_tclMsgSetDefaultSpeechRateMethodStart::operator=(const sds_ttsfi_tclMsgSetDefaultSpeechRateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Rate = coRef.Rate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_ttsfi_tclMsgSetDefaultSpeechRateMethodStart::sds_ttsfi_tclMsgSetDefaultSpeechRateMethodStart()
:Rate(0)
 {}

tS32 sds_ttsfi_tclMsgSetDefaultSpeechRateMethodStart::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_SETDEFAULTSPEECHRATEMETHODSTART;
}


sds_ttsfi_tclMsgSetDefaultSpeechRateMethodStart::~sds_ttsfi_tclMsgSetDefaultSpeechRateMethodStart()
{}

tU32 sds_ttsfi_tclMsgSetDefaultSpeechRateMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_ttsfi_tclMsgSetDefaultSpeechRateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Rate);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgSetDefaultSpeechRateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Rate);
   return oOut;
}

tBool sds_ttsfi_tclMsgSetDefaultSpeechRateMethodStart::operator==(const sds_ttsfi_tclMsgSetDefaultSpeechRateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Rate == roRef.Rate);
   return bResult;
}

//=============================================================================

sds_ttsfi_tclMsgSetDefaultSpeechRateMethodResult::sds_ttsfi_tclMsgSetDefaultSpeechRateMethodResult()
 {}

tS32 sds_ttsfi_tclMsgSetDefaultSpeechRateMethodResult::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_SETDEFAULTSPEECHRATEMETHODRESULT;
}


sds_ttsfi_tclMsgSetDefaultSpeechRateMethodResult::~sds_ttsfi_tclMsgSetDefaultSpeechRateMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgDoSynthesisForSpeakMethodStart::sds_ttsfi_tclMsgDoSynthesisForSpeakMethodStart(const sds_ttsfi_tclMsgDoSynthesisForSpeakMethodStart& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   TextAndTags = coRef.TextAndTags;
   TextStyle = coRef.TextStyle;
   StatusInfo = coRef.StatusInfo;
   LastPackage = coRef.LastPackage;
}
sds_ttsfi_tclMsgDoSynthesisForSpeakMethodStart& sds_ttsfi_tclMsgDoSynthesisForSpeakMethodStart::operator=(const sds_ttsfi_tclMsgDoSynthesisForSpeakMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TextAndTags = coRef.TextAndTags;
   TextStyle = coRef.TextStyle;
   StatusInfo = coRef.StatusInfo;
   LastPackage = coRef.LastPackage;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_ttsfi_tclMsgDoSynthesisForSpeakMethodStart::vDestroy()
{
   TextAndTags.vDestroy();
}

sds_ttsfi_tclMsgDoSynthesisForSpeakMethodStart::sds_ttsfi_tclMsgDoSynthesisForSpeakMethodStart()
:TextAndTags()
,TextStyle()
,StatusInfo()
,LastPackage(0)
 {}

tS32 sds_ttsfi_tclMsgDoSynthesisForSpeakMethodStart::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DOSYNTHESISFORSPEAKMETHODSTART;
}


sds_ttsfi_tclMsgDoSynthesisForSpeakMethodStart::~sds_ttsfi_tclMsgDoSynthesisForSpeakMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_ttsfi_tclMsgDoSynthesisForSpeakMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+TextAndTags.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_ttsfi_tclMsgDoSynthesisForSpeakMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TextAndTags);
   (tVoid) (oIn >> TextStyle);
   (tVoid) (oIn >> StatusInfo);
   (tVoid) (oIn >> LastPackage);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgDoSynthesisForSpeakMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TextAndTags);
   (tVoid) (oOut << TextStyle);
   (tVoid) (oOut << StatusInfo);
   (tVoid) (oOut << LastPackage);
   return oOut;
}

tBool sds_ttsfi_tclMsgDoSynthesisForSpeakMethodStart::operator==(const sds_ttsfi_tclMsgDoSynthesisForSpeakMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TextAndTags == roRef.TextAndTags);
   bResult = bResult && (TextStyle == roRef.TextStyle);
   bResult = bResult && (StatusInfo == roRef.StatusInfo);
   bResult = bResult && (LastPackage == roRef.LastPackage);
   return bResult;
}

//=============================================================================

sds_ttsfi_tclMsgDoSynthesisForSpeakMethodResult::sds_ttsfi_tclMsgDoSynthesisForSpeakMethodResult()
 {}

tS32 sds_ttsfi_tclMsgDoSynthesisForSpeakMethodResult::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DOSYNTHESISFORSPEAKMETHODRESULT;
}


sds_ttsfi_tclMsgDoSynthesisForSpeakMethodResult::~sds_ttsfi_tclMsgDoSynthesisForSpeakMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgDoPrepareAudioOutputMethodStart::sds_ttsfi_tclMsgDoPrepareAudioOutputMethodStart(const sds_ttsfi_tclMsgDoPrepareAudioOutputMethodStart& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   DeviceName = coRef.DeviceName;
}
sds_ttsfi_tclMsgDoPrepareAudioOutputMethodStart& sds_ttsfi_tclMsgDoPrepareAudioOutputMethodStart::operator=(const sds_ttsfi_tclMsgDoPrepareAudioOutputMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceName = coRef.DeviceName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_ttsfi_tclMsgDoPrepareAudioOutputMethodStart::vDestroy()
{
   DeviceName.vDestroy();
}

sds_ttsfi_tclMsgDoPrepareAudioOutputMethodStart::sds_ttsfi_tclMsgDoPrepareAudioOutputMethodStart()
:DeviceName()
 {}

tS32 sds_ttsfi_tclMsgDoPrepareAudioOutputMethodStart::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DOPREPAREAUDIOOUTPUTMETHODSTART;
}


sds_ttsfi_tclMsgDoPrepareAudioOutputMethodStart::~sds_ttsfi_tclMsgDoPrepareAudioOutputMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_ttsfi_tclMsgDoPrepareAudioOutputMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+DeviceName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_ttsfi_tclMsgDoPrepareAudioOutputMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceName);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgDoPrepareAudioOutputMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceName);
   return oOut;
}

tBool sds_ttsfi_tclMsgDoPrepareAudioOutputMethodStart::operator==(const sds_ttsfi_tclMsgDoPrepareAudioOutputMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceName == roRef.DeviceName);
   return bResult;
}

//=============================================================================

sds_ttsfi_tclMsgDoPrepareAudioOutputMethodResult::sds_ttsfi_tclMsgDoPrepareAudioOutputMethodResult()
 {}

tS32 sds_ttsfi_tclMsgDoPrepareAudioOutputMethodResult::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DOPREPAREAUDIOOUTPUTMETHODRESULT;
}


sds_ttsfi_tclMsgDoPrepareAudioOutputMethodResult::~sds_ttsfi_tclMsgDoPrepareAudioOutputMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgDoAudioOutputSpeakMethodStart::sds_ttsfi_tclMsgDoAudioOutputSpeakMethodStart(const sds_ttsfi_tclMsgDoAudioOutputSpeakMethodStart& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   StatusInfo = coRef.StatusInfo;
   AudioOutputLocation = coRef.AudioOutputLocation;
}
sds_ttsfi_tclMsgDoAudioOutputSpeakMethodStart& sds_ttsfi_tclMsgDoAudioOutputSpeakMethodStart::operator=(const sds_ttsfi_tclMsgDoAudioOutputSpeakMethodStart& coRef)
{
   if (this == &coRef) return *this;
   StatusInfo = coRef.StatusInfo;
   AudioOutputLocation = coRef.AudioOutputLocation;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_ttsfi_tclMsgDoAudioOutputSpeakMethodStart::sds_ttsfi_tclMsgDoAudioOutputSpeakMethodStart()
:StatusInfo()
,AudioOutputLocation()
 {}

tS32 sds_ttsfi_tclMsgDoAudioOutputSpeakMethodStart::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKMETHODSTART;
}


sds_ttsfi_tclMsgDoAudioOutputSpeakMethodStart::~sds_ttsfi_tclMsgDoAudioOutputSpeakMethodStart()
{}

tU32 sds_ttsfi_tclMsgDoAudioOutputSpeakMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_ttsfi_tclMsgDoAudioOutputSpeakMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StatusInfo);
   (tVoid) (oIn >> AudioOutputLocation);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgDoAudioOutputSpeakMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StatusInfo);
   (tVoid) (oOut << AudioOutputLocation);
   return oOut;
}

tBool sds_ttsfi_tclMsgDoAudioOutputSpeakMethodStart::operator==(const sds_ttsfi_tclMsgDoAudioOutputSpeakMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StatusInfo == roRef.StatusInfo);
   bResult = bResult && (AudioOutputLocation == roRef.AudioOutputLocation);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultFirst::sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultFirst(const sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultFirst& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   JobProgress = coRef.JobProgress;
}
sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultFirst& sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultFirst::operator=(const sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultFirst& coRef)
{
   if (this == &coRef) return *this;
   JobProgress = coRef.JobProgress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultFirst::sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultFirst()
:JobProgress()
 {}

tS32 sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultFirst::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKMETHODRESULTFIRST;
}


sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultFirst::~sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultFirst()
{}

tU32 sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultFirst::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 17;
}

fi_tclInContext& sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultFirst::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> JobProgress);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultFirst::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << JobProgress);
   return oOut;
}

tBool sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultFirst::operator==(const sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultFirst& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (JobProgress == roRef.JobProgress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultMiddle::sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultMiddle(const sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultMiddle& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   JobProgress = coRef.JobProgress;
}
sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultMiddle& sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultMiddle::operator=(const sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultMiddle& coRef)
{
   if (this == &coRef) return *this;
   JobProgress = coRef.JobProgress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultMiddle::sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultMiddle()
:JobProgress()
 {}

tS32 sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultMiddle::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKMETHODRESULTMIDDLE;
}


sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultMiddle::~sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultMiddle()
{}

tU32 sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultMiddle::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 17;
}

fi_tclInContext& sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultMiddle::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> JobProgress);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultMiddle::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << JobProgress);
   return oOut;
}

tBool sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultMiddle::operator==(const sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultMiddle& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (JobProgress == roRef.JobProgress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultLast::sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultLast(const sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultLast& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   JobProgress = coRef.JobProgress;
}
sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultLast& sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultLast::operator=(const sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultLast& coRef)
{
   if (this == &coRef) return *this;
   JobProgress = coRef.JobProgress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultLast::sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultLast()
:JobProgress()
 {}

tS32 sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultLast::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKMETHODRESULTLAST;
}


sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultLast::~sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultLast()
{}

tU32 sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultLast::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 17;
}

fi_tclInContext& sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultLast::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> JobProgress);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultLast::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << JobProgress);
   return oOut;
}

tBool sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultLast::operator==(const sds_ttsfi_tclMsgDoAudioOutputSpeakMethodResultLast& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (JobProgress == roRef.JobProgress);
   return bResult;
}

//=============================================================================

sds_ttsfi_tclMsgDoUpRegToPropertiesMethodStart::sds_ttsfi_tclMsgDoUpRegToPropertiesMethodStart()
 {}

tS32 sds_ttsfi_tclMsgDoUpRegToPropertiesMethodStart::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DOUPREGTOPROPERTIESMETHODSTART;
}


sds_ttsfi_tclMsgDoUpRegToPropertiesMethodStart::~sds_ttsfi_tclMsgDoUpRegToPropertiesMethodStart()
{}

//=============================================================================

sds_ttsfi_tclMsgDoUpRegToPropertiesMethodResult::sds_ttsfi_tclMsgDoUpRegToPropertiesMethodResult()
 {}

tS32 sds_ttsfi_tclMsgDoUpRegToPropertiesMethodResult::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DOUPREGTOPROPERTIESMETHODRESULT;
}


sds_ttsfi_tclMsgDoUpRegToPropertiesMethodResult::~sds_ttsfi_tclMsgDoUpRegToPropertiesMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgDoSynthesisForWriteMethodStart::sds_ttsfi_tclMsgDoSynthesisForWriteMethodStart(const sds_ttsfi_tclMsgDoSynthesisForWriteMethodStart& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   TextAndTags = coRef.TextAndTags;
   TextStyle = coRef.TextStyle;
   LastPackage = coRef.LastPackage;
}
sds_ttsfi_tclMsgDoSynthesisForWriteMethodStart& sds_ttsfi_tclMsgDoSynthesisForWriteMethodStart::operator=(const sds_ttsfi_tclMsgDoSynthesisForWriteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TextAndTags = coRef.TextAndTags;
   TextStyle = coRef.TextStyle;
   LastPackage = coRef.LastPackage;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_ttsfi_tclMsgDoSynthesisForWriteMethodStart::vDestroy()
{
   TextAndTags.vDestroy();
}

sds_ttsfi_tclMsgDoSynthesisForWriteMethodStart::sds_ttsfi_tclMsgDoSynthesisForWriteMethodStart()
:TextAndTags()
,TextStyle()
,LastPackage(0)
 {}

tS32 sds_ttsfi_tclMsgDoSynthesisForWriteMethodStart::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DOSYNTHESISFORWRITEMETHODSTART;
}


sds_ttsfi_tclMsgDoSynthesisForWriteMethodStart::~sds_ttsfi_tclMsgDoSynthesisForWriteMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_ttsfi_tclMsgDoSynthesisForWriteMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+TextAndTags.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_ttsfi_tclMsgDoSynthesisForWriteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TextAndTags);
   (tVoid) (oIn >> TextStyle);
   (tVoid) (oIn >> LastPackage);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgDoSynthesisForWriteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TextAndTags);
   (tVoid) (oOut << TextStyle);
   (tVoid) (oOut << LastPackage);
   return oOut;
}

tBool sds_ttsfi_tclMsgDoSynthesisForWriteMethodStart::operator==(const sds_ttsfi_tclMsgDoSynthesisForWriteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TextAndTags == roRef.TextAndTags);
   bResult = bResult && (TextStyle == roRef.TextStyle);
   bResult = bResult && (LastPackage == roRef.LastPackage);
   return bResult;
}

//=============================================================================

sds_ttsfi_tclMsgDoSynthesisForWriteMethodResult::sds_ttsfi_tclMsgDoSynthesisForWriteMethodResult()
 {}

tS32 sds_ttsfi_tclMsgDoSynthesisForWriteMethodResult::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DOSYNTHESISFORWRITEMETHODRESULT;
}


sds_ttsfi_tclMsgDoSynthesisForWriteMethodResult::~sds_ttsfi_tclMsgDoSynthesisForWriteMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgDoAudioOutputWriteMethodStart::sds_ttsfi_tclMsgDoAudioOutputWriteMethodStart(const sds_ttsfi_tclMsgDoAudioOutputWriteMethodStart& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   Buffering = coRef.Buffering;
   Compression = coRef.Compression;
}
sds_ttsfi_tclMsgDoAudioOutputWriteMethodStart& sds_ttsfi_tclMsgDoAudioOutputWriteMethodStart::operator=(const sds_ttsfi_tclMsgDoAudioOutputWriteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Buffering = coRef.Buffering;
   Compression = coRef.Compression;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_ttsfi_tclMsgDoAudioOutputWriteMethodStart::sds_ttsfi_tclMsgDoAudioOutputWriteMethodStart()
:Buffering()
,Compression()
 {}

tS32 sds_ttsfi_tclMsgDoAudioOutputWriteMethodStart::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTWRITEMETHODSTART;
}


sds_ttsfi_tclMsgDoAudioOutputWriteMethodStart::~sds_ttsfi_tclMsgDoAudioOutputWriteMethodStart()
{}

tU32 sds_ttsfi_tclMsgDoAudioOutputWriteMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_ttsfi_tclMsgDoAudioOutputWriteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Buffering);
   (tVoid) (oIn >> Compression);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgDoAudioOutputWriteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Buffering);
   (tVoid) (oOut << Compression);
   return oOut;
}

tBool sds_ttsfi_tclMsgDoAudioOutputWriteMethodStart::operator==(const sds_ttsfi_tclMsgDoAudioOutputWriteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Buffering == roRef.Buffering);
   bResult = bResult && (Compression == roRef.Compression);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultFirst::sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultFirst(const sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultFirst& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   BufferingProgress = coRef.BufferingProgress;
}
sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultFirst& sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultFirst::operator=(const sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultFirst& coRef)
{
   if (this == &coRef) return *this;
   BufferingProgress = coRef.BufferingProgress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultFirst::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < BufferingProgress.size(); ++u32Idx)
         BufferingProgress[u32Idx].vDestroy();
   BufferingProgress.clear();
   }
}

sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultFirst::sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultFirst()

 {}

tS32 sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultFirst::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTWRITEMETHODRESULTFIRST;
}


sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultFirst::~sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultFirst()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultFirst::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < BufferingProgress.size(); ++u32ListIdx)
      u32DynamicSize += BufferingProgress[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultFirst::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < BufferingProgress.size(); ++u32Idx)
      {
         BufferingProgress[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      BufferingProgress.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> BufferingProgress[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultFirst::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)BufferingProgress.size());
   {
      for (tU32 u32Idx = 0; u32Idx < BufferingProgress.size(); ++u32Idx)
         (tVoid) (oOut << BufferingProgress[u32Idx]);
   }
   return oOut;
}

tBool sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultFirst::operator==(const sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultFirst& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (BufferingProgress.size() == roRef.BufferingProgress.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < BufferingProgress.size()); ++u32Idx)
            bResult = bResult && (BufferingProgress[u32Idx] == roRef.BufferingProgress[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultMiddle::sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultMiddle(const sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultMiddle& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   BufferingProgress = coRef.BufferingProgress;
}
sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultMiddle& sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultMiddle::operator=(const sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultMiddle& coRef)
{
   if (this == &coRef) return *this;
   BufferingProgress = coRef.BufferingProgress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultMiddle::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < BufferingProgress.size(); ++u32Idx)
         BufferingProgress[u32Idx].vDestroy();
   BufferingProgress.clear();
   }
}

sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultMiddle::sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultMiddle()

 {}

tS32 sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultMiddle::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTWRITEMETHODRESULTMIDDLE;
}


sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultMiddle::~sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultMiddle()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultMiddle::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < BufferingProgress.size(); ++u32ListIdx)
      u32DynamicSize += BufferingProgress[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultMiddle::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < BufferingProgress.size(); ++u32Idx)
      {
         BufferingProgress[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      BufferingProgress.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> BufferingProgress[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultMiddle::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)BufferingProgress.size());
   {
      for (tU32 u32Idx = 0; u32Idx < BufferingProgress.size(); ++u32Idx)
         (tVoid) (oOut << BufferingProgress[u32Idx]);
   }
   return oOut;
}

tBool sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultMiddle::operator==(const sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultMiddle& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (BufferingProgress.size() == roRef.BufferingProgress.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < BufferingProgress.size()); ++u32Idx)
            bResult = bResult && (BufferingProgress[u32Idx] == roRef.BufferingProgress[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultLast::sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultLast(const sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultLast& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   BufferingProgress = coRef.BufferingProgress;
}
sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultLast& sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultLast::operator=(const sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultLast& coRef)
{
   if (this == &coRef) return *this;
   BufferingProgress = coRef.BufferingProgress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultLast::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < BufferingProgress.size(); ++u32Idx)
         BufferingProgress[u32Idx].vDestroy();
   BufferingProgress.clear();
   }
}

sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultLast::sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultLast()

 {}

tS32 sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultLast::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTWRITEMETHODRESULTLAST;
}


sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultLast::~sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultLast()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultLast::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < BufferingProgress.size(); ++u32ListIdx)
      u32DynamicSize += BufferingProgress[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultLast::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < BufferingProgress.size(); ++u32Idx)
      {
         BufferingProgress[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      BufferingProgress.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> BufferingProgress[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultLast::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)BufferingProgress.size());
   {
      for (tU32 u32Idx = 0; u32Idx < BufferingProgress.size(); ++u32Idx)
         (tVoid) (oOut << BufferingProgress[u32Idx]);
   }
   return oOut;
}

tBool sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultLast::operator==(const sds_ttsfi_tclMsgDoAudioOutputWriteMethodResultLast& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (BufferingProgress.size() == roRef.BufferingProgress.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < BufferingProgress.size()); ++u32Idx)
            bResult = bResult && (BufferingProgress[u32Idx] == roRef.BufferingProgress[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodStart::sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodStart(const sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodStart& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   TextAndTags = coRef.TextAndTags;
   TextStyle = coRef.TextStyle;
   StatusInfo = coRef.StatusInfo;
   LastPackage = coRef.LastPackage;
}
sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodStart& sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodStart::operator=(const sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TextAndTags = coRef.TextAndTags;
   TextStyle = coRef.TextStyle;
   StatusInfo = coRef.StatusInfo;
   LastPackage = coRef.LastPackage;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodStart::vDestroy()
{
   TextAndTags.vDestroy();
}

sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodStart::sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodStart()
:TextAndTags()
,TextStyle()
,StatusInfo()
,LastPackage(0)
 {}

tS32 sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodStart::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DOSYNTHESISFORSPEAKWITHEXTENTIONMETHODSTART;
}


sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodStart::~sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+TextAndTags.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TextAndTags);
   (tVoid) (oIn >> TextStyle);
   (tVoid) (oIn >> StatusInfo);
   (tVoid) (oIn >> LastPackage);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TextAndTags);
   (tVoid) (oOut << TextStyle);
   (tVoid) (oOut << StatusInfo);
   (tVoid) (oOut << LastPackage);
   return oOut;
}

tBool sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodStart::operator==(const sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TextAndTags == roRef.TextAndTags);
   bResult = bResult && (TextStyle == roRef.TextStyle);
   bResult = bResult && (StatusInfo == roRef.StatusInfo);
   bResult = bResult && (LastPackage == roRef.LastPackage);
   return bResult;
}

//=============================================================================

sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodResult::sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodResult()
 {}

tS32 sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodResult::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DOSYNTHESISFORSPEAKWITHEXTENTIONMETHODRESULT;
}


sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodResult::~sds_ttsfi_tclMsgDoSynthesisForSpeakWithExtentionMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgDoReleaseDataMethodStart::sds_ttsfi_tclMsgDoReleaseDataMethodStart(const sds_ttsfi_tclMsgDoReleaseDataMethodStart& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   ReleaseType = coRef.ReleaseType;
}
sds_ttsfi_tclMsgDoReleaseDataMethodStart& sds_ttsfi_tclMsgDoReleaseDataMethodStart::operator=(const sds_ttsfi_tclMsgDoReleaseDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ReleaseType = coRef.ReleaseType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_ttsfi_tclMsgDoReleaseDataMethodStart::sds_ttsfi_tclMsgDoReleaseDataMethodStart()
:ReleaseType()
 {}

tS32 sds_ttsfi_tclMsgDoReleaseDataMethodStart::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DORELEASEDATAMETHODSTART;
}


sds_ttsfi_tclMsgDoReleaseDataMethodStart::~sds_ttsfi_tclMsgDoReleaseDataMethodStart()
{}

tU32 sds_ttsfi_tclMsgDoReleaseDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_ttsfi_tclMsgDoReleaseDataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ReleaseType);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgDoReleaseDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ReleaseType);
   return oOut;
}

tBool sds_ttsfi_tclMsgDoReleaseDataMethodStart::operator==(const sds_ttsfi_tclMsgDoReleaseDataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ReleaseType == roRef.ReleaseType);
   return bResult;
}

//=============================================================================

sds_ttsfi_tclMsgDoReleaseDataMethodResult::sds_ttsfi_tclMsgDoReleaseDataMethodResult()
 {}

tS32 sds_ttsfi_tclMsgDoReleaseDataMethodResult::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DORELEASEDATAMETHODRESULT;
}


sds_ttsfi_tclMsgDoReleaseDataMethodResult::~sds_ttsfi_tclMsgDoReleaseDataMethodResult()
{}

//=============================================================================

sds_ttsfi_tclMsgDoReleaseAudioDeviceMethodStart::sds_ttsfi_tclMsgDoReleaseAudioDeviceMethodStart()
 {}

tS32 sds_ttsfi_tclMsgDoReleaseAudioDeviceMethodStart::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DORELEASEAUDIODEVICEMETHODSTART;
}


sds_ttsfi_tclMsgDoReleaseAudioDeviceMethodStart::~sds_ttsfi_tclMsgDoReleaseAudioDeviceMethodStart()
{}

//=============================================================================

sds_ttsfi_tclMsgDoReleaseAudioDeviceMethodResult::sds_ttsfi_tclMsgDoReleaseAudioDeviceMethodResult()
 {}

tS32 sds_ttsfi_tclMsgDoReleaseAudioDeviceMethodResult::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DORELEASEAUDIODEVICEMETHODRESULT;
}


sds_ttsfi_tclMsgDoReleaseAudioDeviceMethodResult::~sds_ttsfi_tclMsgDoReleaseAudioDeviceMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgDoRequestPhonemeMethodStart::sds_ttsfi_tclMsgDoRequestPhonemeMethodStart(const sds_ttsfi_tclMsgDoRequestPhonemeMethodStart& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   TextAndTags = coRef.TextAndTags;
   TextStyle = coRef.TextStyle;
}
sds_ttsfi_tclMsgDoRequestPhonemeMethodStart& sds_ttsfi_tclMsgDoRequestPhonemeMethodStart::operator=(const sds_ttsfi_tclMsgDoRequestPhonemeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TextAndTags = coRef.TextAndTags;
   TextStyle = coRef.TextStyle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_ttsfi_tclMsgDoRequestPhonemeMethodStart::vDestroy()
{
   TextAndTags.vDestroy();
}

sds_ttsfi_tclMsgDoRequestPhonemeMethodStart::sds_ttsfi_tclMsgDoRequestPhonemeMethodStart()
:TextAndTags()
,TextStyle()
 {}

tS32 sds_ttsfi_tclMsgDoRequestPhonemeMethodStart::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DOREQUESTPHONEMEMETHODSTART;
}


sds_ttsfi_tclMsgDoRequestPhonemeMethodStart::~sds_ttsfi_tclMsgDoRequestPhonemeMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_ttsfi_tclMsgDoRequestPhonemeMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+TextAndTags.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_ttsfi_tclMsgDoRequestPhonemeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TextAndTags);
   (tVoid) (oIn >> TextStyle);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgDoRequestPhonemeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TextAndTags);
   (tVoid) (oOut << TextStyle);
   return oOut;
}

tBool sds_ttsfi_tclMsgDoRequestPhonemeMethodStart::operator==(const sds_ttsfi_tclMsgDoRequestPhonemeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TextAndTags == roRef.TextAndTags);
   bResult = bResult && (TextStyle == roRef.TextStyle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgDoRequestPhonemeMethodResult::sds_ttsfi_tclMsgDoRequestPhonemeMethodResult(const sds_ttsfi_tclMsgDoRequestPhonemeMethodResult& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   PhonemeList = coRef.PhonemeList;
}
sds_ttsfi_tclMsgDoRequestPhonemeMethodResult& sds_ttsfi_tclMsgDoRequestPhonemeMethodResult::operator=(const sds_ttsfi_tclMsgDoRequestPhonemeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   PhonemeList = coRef.PhonemeList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_ttsfi_tclMsgDoRequestPhonemeMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < PhonemeList.size(); ++u32Idx)
         PhonemeList[u32Idx].vDestroy();
   PhonemeList.clear();
   }
}

sds_ttsfi_tclMsgDoRequestPhonemeMethodResult::sds_ttsfi_tclMsgDoRequestPhonemeMethodResult()

 {}

tS32 sds_ttsfi_tclMsgDoRequestPhonemeMethodResult::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DOREQUESTPHONEMEMETHODRESULT;
}


sds_ttsfi_tclMsgDoRequestPhonemeMethodResult::~sds_ttsfi_tclMsgDoRequestPhonemeMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_ttsfi_tclMsgDoRequestPhonemeMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < PhonemeList.size(); ++u32ListIdx)
      u32DynamicSize += PhonemeList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_ttsfi_tclMsgDoRequestPhonemeMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PhonemeList.size(); ++u32Idx)
      {
         PhonemeList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      PhonemeList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PhonemeList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgDoRequestPhonemeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)PhonemeList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PhonemeList.size(); ++u32Idx)
         (tVoid) (oOut << PhonemeList[u32Idx]);
   }
   return oOut;
}

tBool sds_ttsfi_tclMsgDoRequestPhonemeMethodResult::operator==(const sds_ttsfi_tclMsgDoRequestPhonemeMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (PhonemeList.size() == roRef.PhonemeList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PhonemeList.size()); ++u32Idx)
            bResult = bResult && (PhonemeList[u32Idx] == roRef.PhonemeList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodStart::sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodStart(const sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodStart& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   StatusInfo = coRef.StatusInfo;
   AudioOutputLocation = coRef.AudioOutputLocation;
}
sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodStart& sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodStart::operator=(const sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   StatusInfo = coRef.StatusInfo;
   AudioOutputLocation = coRef.AudioOutputLocation;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodStart::sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodStart()
:StatusInfo()
,AudioOutputLocation()
 {}

tS32 sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodStart::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKWITHEXTENSIONMETHODSTART;
}


sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodStart::~sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodStart()
{}

tU32 sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StatusInfo);
   (tVoid) (oIn >> AudioOutputLocation);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StatusInfo);
   (tVoid) (oOut << AudioOutputLocation);
   return oOut;
}

tBool sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodStart::operator==(const sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StatusInfo == roRef.StatusInfo);
   bResult = bResult && (AudioOutputLocation == roRef.AudioOutputLocation);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultFirst::sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultFirst(const sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultFirst& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   JobProgress = coRef.JobProgress;
}
sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultFirst& sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultFirst::operator=(const sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultFirst& coRef)
{
   if (this == &coRef) return *this;
   JobProgress = coRef.JobProgress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultFirst::sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultFirst()
:JobProgress()
 {}

tS32 sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultFirst::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKWITHEXTENSIONMETHODRESULTFIRST;
}


sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultFirst::~sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultFirst()
{}

tU32 sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultFirst::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 17;
}

fi_tclInContext& sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultFirst::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> JobProgress);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultFirst::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << JobProgress);
   return oOut;
}

tBool sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultFirst::operator==(const sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultFirst& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (JobProgress == roRef.JobProgress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultMiddle::sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultMiddle(const sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultMiddle& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   JobProgress = coRef.JobProgress;
}
sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultMiddle& sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultMiddle::operator=(const sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultMiddle& coRef)
{
   if (this == &coRef) return *this;
   JobProgress = coRef.JobProgress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultMiddle::sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultMiddle()
:JobProgress()
 {}

tS32 sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultMiddle::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKWITHEXTENSIONMETHODRESULTMIDDLE;
}


sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultMiddle::~sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultMiddle()
{}

tU32 sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultMiddle::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 17;
}

fi_tclInContext& sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultMiddle::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> JobProgress);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultMiddle::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << JobProgress);
   return oOut;
}

tBool sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultMiddle::operator==(const sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultMiddle& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (JobProgress == roRef.JobProgress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultLast::sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultLast(const sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultLast& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   JobProgress = coRef.JobProgress;
}
sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultLast& sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultLast::operator=(const sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultLast& coRef)
{
   if (this == &coRef) return *this;
   JobProgress = coRef.JobProgress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultLast::sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultLast()
:JobProgress()
 {}

tS32 sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultLast::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKWITHEXTENSIONMETHODRESULTLAST;
}


sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultLast::~sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultLast()
{}

tU32 sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultLast::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 17;
}

fi_tclInContext& sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultLast::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> JobProgress);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultLast::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << JobProgress);
   return oOut;
}

tBool sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultLast::operator==(const sds_ttsfi_tclMsgDoAudioOutputSpeakWithExtensionMethodResultLast& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (JobProgress == roRef.JobProgress);
   return bResult;
}

//=============================================================================

sds_ttsfi_tclMsgVoiceGet::sds_ttsfi_tclMsgVoiceGet()
 {}

tS32 sds_ttsfi_tclMsgVoiceGet::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_VOICEGET;
}


sds_ttsfi_tclMsgVoiceGet::~sds_ttsfi_tclMsgVoiceGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgVoiceStatus::sds_ttsfi_tclMsgVoiceStatus(const sds_ttsfi_tclMsgVoiceStatus& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   TTSVoice = coRef.TTSVoice;
}
sds_ttsfi_tclMsgVoiceStatus& sds_ttsfi_tclMsgVoiceStatus::operator=(const sds_ttsfi_tclMsgVoiceStatus& coRef)
{
   if (this == &coRef) return *this;
   TTSVoice = coRef.TTSVoice;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_ttsfi_tclMsgVoiceStatus::vDestroy()
{
   TTSVoice.vDestroy(); 
}

sds_ttsfi_tclMsgVoiceStatus::sds_ttsfi_tclMsgVoiceStatus()
:TTSVoice()
 {}

tS32 sds_ttsfi_tclMsgVoiceStatus::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_VOICESTATUS;
}


sds_ttsfi_tclMsgVoiceStatus::~sds_ttsfi_tclMsgVoiceStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_ttsfi_tclMsgVoiceStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TTSVoice.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_ttsfi_tclMsgVoiceStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TTSVoice);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgVoiceStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TTSVoice);
   return oOut;
}

tBool sds_ttsfi_tclMsgVoiceStatus::operator==(const sds_ttsfi_tclMsgVoiceStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TTSVoice == roRef.TTSVoice);
   return bResult;
}

//=============================================================================

sds_ttsfi_tclMsgVoiceUpReg::sds_ttsfi_tclMsgVoiceUpReg()
 {}

tS32 sds_ttsfi_tclMsgVoiceUpReg::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_VOICEUPREG;
}


sds_ttsfi_tclMsgVoiceUpReg::~sds_ttsfi_tclMsgVoiceUpReg()
{}

//=============================================================================

sds_ttsfi_tclMsgVoiceRelUpReg::sds_ttsfi_tclMsgVoiceRelUpReg()
 {}

tS32 sds_ttsfi_tclMsgVoiceRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_VOICERELUPREG;
}


sds_ttsfi_tclMsgVoiceRelUpReg::~sds_ttsfi_tclMsgVoiceRelUpReg()
{}

//=============================================================================

sds_ttsfi_tclMsgAvailableVoicesGet::sds_ttsfi_tclMsgAvailableVoicesGet()
 {}

tS32 sds_ttsfi_tclMsgAvailableVoicesGet::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_AVAILABLEVOICESGET;
}


sds_ttsfi_tclMsgAvailableVoicesGet::~sds_ttsfi_tclMsgAvailableVoicesGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgAvailableVoicesStatus::sds_ttsfi_tclMsgAvailableVoicesStatus(const sds_ttsfi_tclMsgAvailableVoicesStatus& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   AvailableTTSVoices = coRef.AvailableTTSVoices;
}
sds_ttsfi_tclMsgAvailableVoicesStatus& sds_ttsfi_tclMsgAvailableVoicesStatus::operator=(const sds_ttsfi_tclMsgAvailableVoicesStatus& coRef)
{
   if (this == &coRef) return *this;
   AvailableTTSVoices = coRef.AvailableTTSVoices;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_ttsfi_tclMsgAvailableVoicesStatus::vDestroy()
{
   AvailableTTSVoices.vDestroy(); 
}

sds_ttsfi_tclMsgAvailableVoicesStatus::sds_ttsfi_tclMsgAvailableVoicesStatus()
:AvailableTTSVoices()
 {}

tS32 sds_ttsfi_tclMsgAvailableVoicesStatus::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_AVAILABLEVOICESSTATUS;
}


sds_ttsfi_tclMsgAvailableVoicesStatus::~sds_ttsfi_tclMsgAvailableVoicesStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_ttsfi_tclMsgAvailableVoicesStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+AvailableTTSVoices.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_ttsfi_tclMsgAvailableVoicesStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AvailableTTSVoices);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgAvailableVoicesStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AvailableTTSVoices);
   return oOut;
}

tBool sds_ttsfi_tclMsgAvailableVoicesStatus::operator==(const sds_ttsfi_tclMsgAvailableVoicesStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AvailableTTSVoices == roRef.AvailableTTSVoices);
   return bResult;
}

//=============================================================================

sds_ttsfi_tclMsgAvailableVoicesUpReg::sds_ttsfi_tclMsgAvailableVoicesUpReg()
 {}

tS32 sds_ttsfi_tclMsgAvailableVoicesUpReg::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_AVAILABLEVOICESUPREG;
}


sds_ttsfi_tclMsgAvailableVoicesUpReg::~sds_ttsfi_tclMsgAvailableVoicesUpReg()
{}

//=============================================================================

sds_ttsfi_tclMsgAvailableVoicesRelUpReg::sds_ttsfi_tclMsgAvailableVoicesRelUpReg()
 {}

tS32 sds_ttsfi_tclMsgAvailableVoicesRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_AVAILABLEVOICESRELUPREG;
}


sds_ttsfi_tclMsgAvailableVoicesRelUpReg::~sds_ttsfi_tclMsgAvailableVoicesRelUpReg()
{}

//=============================================================================

sds_ttsfi_tclMsgTTSVersionInfoGet::sds_ttsfi_tclMsgTTSVersionInfoGet()
 {}

tS32 sds_ttsfi_tclMsgTTSVersionInfoGet::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_TTSVERSIONINFOGET;
}


sds_ttsfi_tclMsgTTSVersionInfoGet::~sds_ttsfi_tclMsgTTSVersionInfoGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgTTSVersionInfoStatus::sds_ttsfi_tclMsgTTSVersionInfoStatus(const sds_ttsfi_tclMsgTTSVersionInfoStatus& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   TTSVersionInfo = coRef.TTSVersionInfo;
}
sds_ttsfi_tclMsgTTSVersionInfoStatus& sds_ttsfi_tclMsgTTSVersionInfoStatus::operator=(const sds_ttsfi_tclMsgTTSVersionInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   TTSVersionInfo = coRef.TTSVersionInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_ttsfi_tclMsgTTSVersionInfoStatus::vDestroy()
{
   TTSVersionInfo.vDestroy(); 
}

sds_ttsfi_tclMsgTTSVersionInfoStatus::sds_ttsfi_tclMsgTTSVersionInfoStatus()
:TTSVersionInfo()
 {}

tS32 sds_ttsfi_tclMsgTTSVersionInfoStatus::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_TTSVERSIONINFOSTATUS;
}


sds_ttsfi_tclMsgTTSVersionInfoStatus::~sds_ttsfi_tclMsgTTSVersionInfoStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_ttsfi_tclMsgTTSVersionInfoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TTSVersionInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_ttsfi_tclMsgTTSVersionInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TTSVersionInfo);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgTTSVersionInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TTSVersionInfo);
   return oOut;
}

tBool sds_ttsfi_tclMsgTTSVersionInfoStatus::operator==(const sds_ttsfi_tclMsgTTSVersionInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TTSVersionInfo == roRef.TTSVersionInfo);
   return bResult;
}

//=============================================================================

sds_ttsfi_tclMsgTTSVersionInfoUpReg::sds_ttsfi_tclMsgTTSVersionInfoUpReg()
 {}

tS32 sds_ttsfi_tclMsgTTSVersionInfoUpReg::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_TTSVERSIONINFOUPREG;
}


sds_ttsfi_tclMsgTTSVersionInfoUpReg::~sds_ttsfi_tclMsgTTSVersionInfoUpReg()
{}

//=============================================================================

sds_ttsfi_tclMsgTTSVersionInfoRelUpReg::sds_ttsfi_tclMsgTTSVersionInfoRelUpReg()
 {}

tS32 sds_ttsfi_tclMsgTTSVersionInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_TTSVERSIONINFORELUPREG;
}


sds_ttsfi_tclMsgTTSVersionInfoRelUpReg::~sds_ttsfi_tclMsgTTSVersionInfoRelUpReg()
{}

//=============================================================================

sds_ttsfi_tclMsgTTSStatusGet::sds_ttsfi_tclMsgTTSStatusGet()
 {}

tS32 sds_ttsfi_tclMsgTTSStatusGet::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_TTSSTATUSGET;
}


sds_ttsfi_tclMsgTTSStatusGet::~sds_ttsfi_tclMsgTTSStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgTTSStatusStatus::sds_ttsfi_tclMsgTTSStatusStatus(const sds_ttsfi_tclMsgTTSStatusStatus& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   TTSStatus = coRef.TTSStatus;
}
sds_ttsfi_tclMsgTTSStatusStatus& sds_ttsfi_tclMsgTTSStatusStatus::operator=(const sds_ttsfi_tclMsgTTSStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   TTSStatus = coRef.TTSStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_ttsfi_tclMsgTTSStatusStatus::sds_ttsfi_tclMsgTTSStatusStatus()
:TTSStatus()
 {}

tS32 sds_ttsfi_tclMsgTTSStatusStatus::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_TTSSTATUSSTATUS;
}


sds_ttsfi_tclMsgTTSStatusStatus::~sds_ttsfi_tclMsgTTSStatusStatus()
{}

tU32 sds_ttsfi_tclMsgTTSStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_ttsfi_tclMsgTTSStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TTSStatus);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgTTSStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TTSStatus);
   return oOut;
}

tBool sds_ttsfi_tclMsgTTSStatusStatus::operator==(const sds_ttsfi_tclMsgTTSStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TTSStatus == roRef.TTSStatus);
   return bResult;
}

//=============================================================================

sds_ttsfi_tclMsgTTSStatusUpReg::sds_ttsfi_tclMsgTTSStatusUpReg()
 {}

tS32 sds_ttsfi_tclMsgTTSStatusUpReg::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_TTSSTATUSUPREG;
}


sds_ttsfi_tclMsgTTSStatusUpReg::~sds_ttsfi_tclMsgTTSStatusUpReg()
{}

//=============================================================================

sds_ttsfi_tclMsgTTSStatusRelUpReg::sds_ttsfi_tclMsgTTSStatusRelUpReg()
 {}

tS32 sds_ttsfi_tclMsgTTSStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_TTSSTATUSRELUPREG;
}


sds_ttsfi_tclMsgTTSStatusRelUpReg::~sds_ttsfi_tclMsgTTSStatusRelUpReg()
{}

//=============================================================================

sds_ttsfi_tclMsgDownloadCompleteGet::sds_ttsfi_tclMsgDownloadCompleteGet()
 {}

tS32 sds_ttsfi_tclMsgDownloadCompleteGet::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DOWNLOADCOMPLETEGET;
}


sds_ttsfi_tclMsgDownloadCompleteGet::~sds_ttsfi_tclMsgDownloadCompleteGet()
{}

//=============================================================================

sds_ttsfi_tclMsgDownloadCompleteUpReg::sds_ttsfi_tclMsgDownloadCompleteUpReg()
 {}

tS32 sds_ttsfi_tclMsgDownloadCompleteUpReg::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DOWNLOADCOMPLETEUPREG;
}


sds_ttsfi_tclMsgDownloadCompleteUpReg::~sds_ttsfi_tclMsgDownloadCompleteUpReg()
{}

//=============================================================================

sds_ttsfi_tclMsgDownloadCompleteRelUpReg::sds_ttsfi_tclMsgDownloadCompleteRelUpReg()
 {}

tS32 sds_ttsfi_tclMsgDownloadCompleteRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DOWNLOADCOMPLETERELUPREG;
}


sds_ttsfi_tclMsgDownloadCompleteRelUpReg::~sds_ttsfi_tclMsgDownloadCompleteRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgDownloadCompleteStatus::sds_ttsfi_tclMsgDownloadCompleteStatus(const sds_ttsfi_tclMsgDownloadCompleteStatus& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   Complete = coRef.Complete;
}
sds_ttsfi_tclMsgDownloadCompleteStatus& sds_ttsfi_tclMsgDownloadCompleteStatus::operator=(const sds_ttsfi_tclMsgDownloadCompleteStatus& coRef)
{
   if (this == &coRef) return *this;
   Complete = coRef.Complete;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_ttsfi_tclMsgDownloadCompleteStatus::sds_ttsfi_tclMsgDownloadCompleteStatus()
:Complete(0)
 {}

tS32 sds_ttsfi_tclMsgDownloadCompleteStatus::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_DOWNLOADCOMPLETESTATUS;
}


sds_ttsfi_tclMsgDownloadCompleteStatus::~sds_ttsfi_tclMsgDownloadCompleteStatus()
{}

tU32 sds_ttsfi_tclMsgDownloadCompleteStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_ttsfi_tclMsgDownloadCompleteStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Complete);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgDownloadCompleteStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Complete);
   return oOut;
}

tBool sds_ttsfi_tclMsgDownloadCompleteStatus::operator==(const sds_ttsfi_tclMsgDownloadCompleteStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Complete == roRef.Complete);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgTTSPlaybackSpacingSet::sds_ttsfi_tclMsgTTSPlaybackSpacingSet(const sds_ttsfi_tclMsgTTSPlaybackSpacingSet& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   PlaybackSpacing = coRef.PlaybackSpacing;
}
sds_ttsfi_tclMsgTTSPlaybackSpacingSet& sds_ttsfi_tclMsgTTSPlaybackSpacingSet::operator=(const sds_ttsfi_tclMsgTTSPlaybackSpacingSet& coRef)
{
   if (this == &coRef) return *this;
   PlaybackSpacing = coRef.PlaybackSpacing;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_ttsfi_tclMsgTTSPlaybackSpacingSet::sds_ttsfi_tclMsgTTSPlaybackSpacingSet()
:PlaybackSpacing(0)
 {}

tS32 sds_ttsfi_tclMsgTTSPlaybackSpacingSet::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_TTSPLAYBACKSPACINGSET;
}


sds_ttsfi_tclMsgTTSPlaybackSpacingSet::~sds_ttsfi_tclMsgTTSPlaybackSpacingSet()
{}

tU32 sds_ttsfi_tclMsgTTSPlaybackSpacingSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_ttsfi_tclMsgTTSPlaybackSpacingSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PlaybackSpacing);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgTTSPlaybackSpacingSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PlaybackSpacing);
   return oOut;
}

tBool sds_ttsfi_tclMsgTTSPlaybackSpacingSet::operator==(const sds_ttsfi_tclMsgTTSPlaybackSpacingSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PlaybackSpacing == roRef.PlaybackSpacing);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_ttsfi_tclMsgTTSPlaybackSpacingStatus::sds_ttsfi_tclMsgTTSPlaybackSpacingStatus(const sds_ttsfi_tclMsgTTSPlaybackSpacingStatus& coRef)
   : sds_ttsfi_tclMsgBaseMessage(coRef)
{
   PlaybackSpacing = coRef.PlaybackSpacing;
}
sds_ttsfi_tclMsgTTSPlaybackSpacingStatus& sds_ttsfi_tclMsgTTSPlaybackSpacingStatus::operator=(const sds_ttsfi_tclMsgTTSPlaybackSpacingStatus& coRef)
{
   if (this == &coRef) return *this;
   PlaybackSpacing = coRef.PlaybackSpacing;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_ttsfi_tclMsgTTSPlaybackSpacingStatus::sds_ttsfi_tclMsgTTSPlaybackSpacingStatus()
:PlaybackSpacing(0)
 {}

tS32 sds_ttsfi_tclMsgTTSPlaybackSpacingStatus::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_TTSPLAYBACKSPACINGSTATUS;
}


sds_ttsfi_tclMsgTTSPlaybackSpacingStatus::~sds_ttsfi_tclMsgTTSPlaybackSpacingStatus()
{}

tU32 sds_ttsfi_tclMsgTTSPlaybackSpacingStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_ttsfi_tclMsgTTSPlaybackSpacingStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PlaybackSpacing);
   return oIn;
}

fi_tclOutContext& sds_ttsfi_tclMsgTTSPlaybackSpacingStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PlaybackSpacing);
   return oOut;
}

tBool sds_ttsfi_tclMsgTTSPlaybackSpacingStatus::operator==(const sds_ttsfi_tclMsgTTSPlaybackSpacingStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PlaybackSpacing == roRef.PlaybackSpacing);
   return bResult;
}

//=============================================================================

sds_ttsfi_tclMsgTTSPlaybackSpacingUpReg::sds_ttsfi_tclMsgTTSPlaybackSpacingUpReg()
 {}

tS32 sds_ttsfi_tclMsgTTSPlaybackSpacingUpReg::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_TTSPLAYBACKSPACINGUPREG;
}


sds_ttsfi_tclMsgTTSPlaybackSpacingUpReg::~sds_ttsfi_tclMsgTTSPlaybackSpacingUpReg()
{}

//=============================================================================

sds_ttsfi_tclMsgTTSPlaybackSpacingRelUpReg::sds_ttsfi_tclMsgTTSPlaybackSpacingRelUpReg()
 {}

tS32 sds_ttsfi_tclMsgTTSPlaybackSpacingRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_ttsfi_tclToken::EN_MSG_TTSPLAYBACKSPACINGRELUPREG;
}


sds_ttsfi_tclMsgTTSPlaybackSpacingRelUpReg::~sds_ttsfi_tclMsgTTSPlaybackSpacingRelUpReg()
{}

