#include "precompiled.hh"

tBool sds_ttsfi_tclDescription::bInitMessage(sds_ttsfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case sds_ttsfi_tclToken::EN_LAST_TOKEN:
   case sds_ttsfi_tclToken::EN_LIST:
   case sds_ttsfi_tclToken::EN_END_OF_STRUCT:
   case sds_ttsfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_BOOL,sds_ttsfi_tclSemanticDomain::EN_MSG_LASTPACKAGE)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_U32,sds_ttsfi_tclSemanticDomain::EN_MSG_EXPDATE)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_STATUSINFOOPTION,sds_ttsfi_tclSemanticDomain::EN_MSG_STATUSINFO)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_B8_AUDIOOUTPUTLOCATION,sds_ttsfi_tclSemanticDomain::EN_MSG_AUDIOOUTPUTLOCATION)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_TEXTSTYLEOPTION,sds_ttsfi_tclSemanticDomain::EN_MSG_TEXTSTYLE)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_STRING,sds_ttsfi_tclSemanticDomain::EN_MSG_TEXTANDTAGS)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODRESULTFIRST:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_SPEAKPROGRESS,sds_ttsfi_tclSemanticDomain::EN_MSG_JOBPROGRESS)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODRESULTMIDDLE:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_SPEAKPROGRESS,sds_ttsfi_tclSemanticDomain::EN_MSG_JOBPROGRESS)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODRESULTLAST:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_SPEAKPROGRESS,sds_ttsfi_tclSemanticDomain::EN_MSG_JOBPROGRESS)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZEWRITEMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_B8_AUDIOFORMAT,sds_ttsfi_tclSemanticDomain::EN_MSG_COMPRESSION)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_BOOL,sds_ttsfi_tclSemanticDomain::EN_MSG_LASTPACKAGE)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_U32,sds_ttsfi_tclSemanticDomain::EN_MSG_EXPDATE)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_BUFFERINGOPTION,sds_ttsfi_tclSemanticDomain::EN_MSG_BUFFERING)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_TEXTSTYLEOPTION,sds_ttsfi_tclSemanticDomain::EN_MSG_TEXTSTYLE)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_STRING,sds_ttsfi_tclSemanticDomain::EN_MSG_TEXTANDTAGS)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZEWRITEMETHODRESULTFIRST:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_BUFFERINGPROGRESS,sds_ttsfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_LIST,sds_ttsfi_tclSemanticDomain::EN_MSG_BUFFERINGPROGRESS)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZEWRITEMETHODRESULTMIDDLE:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_BUFFERINGPROGRESS,sds_ttsfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_LIST,sds_ttsfi_tclSemanticDomain::EN_MSG_BUFFERINGPROGRESS)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZEWRITEMETHODRESULTLAST:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_BUFFERINGPROGRESS,sds_ttsfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_LIST,sds_ttsfi_tclSemanticDomain::EN_MSG_BUFFERINGPROGRESS)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKWITHEXTENSIONMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8SEQUENCECATEGORY,sds_ttsfi_tclSemanticDomain::EN_MSG_SPEECHSEQUENCE)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_U8,sds_ttsfi_tclSemanticDomain::EN_MSG_INDEX)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_BOOL,sds_ttsfi_tclSemanticDomain::EN_MSG_LASTPACKAGE)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_U32,sds_ttsfi_tclSemanticDomain::EN_MSG_EXPDATE)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_STATUSINFOOPTION,sds_ttsfi_tclSemanticDomain::EN_MSG_STATUSINFO)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_B8_AUDIOOUTPUTLOCATION,sds_ttsfi_tclSemanticDomain::EN_MSG_AUDIOOUTPUTLOCATION)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_SDSLANGUAGEID,sds_ttsfi_tclSemanticDomain::EN_MSG_LANGUAGEID)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_AUDIOSOURCEID,sds_ttsfi_tclSemanticDomain::EN_MSG_TEXTSTYLE)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_STRING,sds_ttsfi_tclSemanticDomain::EN_MSG_TEXTANDTAGS)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKWITHEXTENSIONMETHODRESULTFIRST:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_SPEAKPROGRESS,sds_ttsfi_tclSemanticDomain::EN_MSG_JOBPROGRESS)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKWITHEXTENSIONMETHODRESULTMIDDLE:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_SPEAKPROGRESS,sds_ttsfi_tclSemanticDomain::EN_MSG_JOBPROGRESS)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKWITHEXTENSIONMETHODRESULTLAST:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_SPEAKPROGRESS,sds_ttsfi_tclSemanticDomain::EN_MSG_JOBPROGRESS)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_PREPAREVOICEOUTPUTMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_STRING,sds_ttsfi_tclSemanticDomain::EN_MSG_DEVICE)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_RELEASEDATAMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_RELEASETYPETTS,sds_ttsfi_tclSemanticDomain::EN_MSG_RELEASETYPE)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_SETVOICEMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_VOICETYPE,sds_ttsfi_tclSemanticDomain::EN_MSG_TTSVOICE)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_ABORTPROMPTMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_PROMPTABORTOPTION,sds_ttsfi_tclSemanticDomain::EN_MSG_ABORTPROMPTOPTION)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_PAUSEPROMPTMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_PROMPTABORTOPTION,sds_ttsfi_tclSemanticDomain::EN_MSG_PAUSEPROMPTOPTION)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_CONTINUEPROMPTMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_U8,sds_ttsfi_tclSemanticDomain::EN_MSG_DUMMY)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_ABORTPROMPTWITHEXTENSIONMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_PROMPTABORTOPTION,sds_ttsfi_tclSemanticDomain::EN_MSG_ABORTPROMPTOPTION)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_PAUSEPROMPTWITHEXTENSIONMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_PROMPTABORTOPTION,sds_ttsfi_tclSemanticDomain::EN_MSG_PAUSEPROMPTOPTION)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_CONTINUEPROMPTWITHEXTENSIONMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_U8,sds_ttsfi_tclSemanticDomain::EN_MSG_DUMMY)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_REQUESTPHONEMEMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_TEXTSTYLEOPTION,sds_ttsfi_tclSemanticDomain::EN_MSG_TEXTSTYLE)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_STRING,sds_ttsfi_tclSemanticDomain::EN_MSG_TEXTANDTAGS)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_REQUESTPHONEMEMETHODRESULT:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_TTSPHONEMERESULT,sds_ttsfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_LIST,sds_ttsfi_tclSemanticDomain::EN_MSG_PHONEMELIST)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_LOADTUNINGFILESMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_STRING,sds_ttsfi_tclSemanticDomain::EN_MSG_TTSVERSION)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_TTSDOMAIN,sds_ttsfi_tclSemanticDomain::EN_MSG_TTSDOMAIN)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_TTSTUNINGFILE,sds_ttsfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_LIST,sds_ttsfi_tclSemanticDomain::EN_MSG_TTSTUNFILES)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_SETDEFAULTSPEECHRATEMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_U16,sds_ttsfi_tclSemanticDomain::EN_MSG_RATE)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_DOSYNTHESISFORSPEAKMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_BOOL,sds_ttsfi_tclSemanticDomain::EN_MSG_LASTPACKAGE)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_STATUSINFOOPTION,sds_ttsfi_tclSemanticDomain::EN_MSG_STATUSINFO)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_TEXTSTYLEOPTION,sds_ttsfi_tclSemanticDomain::EN_MSG_TEXTSTYLE)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_STRING,sds_ttsfi_tclSemanticDomain::EN_MSG_TEXTANDTAGS)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_DOPREPAREAUDIOOUTPUTMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_STRING,sds_ttsfi_tclSemanticDomain::EN_MSG_DEVICENAME)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_B8_AUDIOOUTPUTLOCATION,sds_ttsfi_tclSemanticDomain::EN_MSG_AUDIOOUTPUTLOCATION)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_STATUSINFOOPTION,sds_ttsfi_tclSemanticDomain::EN_MSG_STATUSINFO)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKMETHODRESULTFIRST:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_SPEAKPROGRESS,sds_ttsfi_tclSemanticDomain::EN_MSG_JOBPROGRESS)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKMETHODRESULTMIDDLE:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_SPEAKPROGRESS,sds_ttsfi_tclSemanticDomain::EN_MSG_JOBPROGRESS)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKMETHODRESULTLAST:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_SPEAKPROGRESS,sds_ttsfi_tclSemanticDomain::EN_MSG_JOBPROGRESS)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_DOSYNTHESISFORWRITEMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_BOOL,sds_ttsfi_tclSemanticDomain::EN_MSG_LASTPACKAGE)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_TEXTSTYLEOPTION,sds_ttsfi_tclSemanticDomain::EN_MSG_TEXTSTYLE)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_STRING,sds_ttsfi_tclSemanticDomain::EN_MSG_TEXTANDTAGS)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTWRITEMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_B8_AUDIOFORMAT,sds_ttsfi_tclSemanticDomain::EN_MSG_COMPRESSION)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_BUFFERINGOPTION,sds_ttsfi_tclSemanticDomain::EN_MSG_BUFFERING)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTWRITEMETHODRESULTFIRST:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_BUFFERINGPROGRESS,sds_ttsfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_LIST,sds_ttsfi_tclSemanticDomain::EN_MSG_BUFFERINGPROGRESS)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTWRITEMETHODRESULTMIDDLE:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_BUFFERINGPROGRESS,sds_ttsfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_LIST,sds_ttsfi_tclSemanticDomain::EN_MSG_BUFFERINGPROGRESS)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTWRITEMETHODRESULTLAST:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_BUFFERINGPROGRESS,sds_ttsfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_LIST,sds_ttsfi_tclSemanticDomain::EN_MSG_BUFFERINGPROGRESS)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_DOSYNTHESISFORSPEAKWITHEXTENTIONMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_BOOL,sds_ttsfi_tclSemanticDomain::EN_MSG_LASTPACKAGE)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_STATUSINFOOPTION,sds_ttsfi_tclSemanticDomain::EN_MSG_STATUSINFO)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_AUDIOSOURCEID,sds_ttsfi_tclSemanticDomain::EN_MSG_TEXTSTYLE)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_STRING,sds_ttsfi_tclSemanticDomain::EN_MSG_TEXTANDTAGS)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_DORELEASEDATAMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_RELEASETYPETTS,sds_ttsfi_tclSemanticDomain::EN_MSG_RELEASETYPE)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_DOREQUESTPHONEMEMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_TEXTSTYLEOPTION,sds_ttsfi_tclSemanticDomain::EN_MSG_TEXTSTYLE)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_STRING,sds_ttsfi_tclSemanticDomain::EN_MSG_TEXTANDTAGS)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_DOREQUESTPHONEMEMETHODRESULT:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_TTSPHONEMERESULT,sds_ttsfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_LIST,sds_ttsfi_tclSemanticDomain::EN_MSG_PHONEMELIST)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKWITHEXTENSIONMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_B8_AUDIOOUTPUTLOCATION,sds_ttsfi_tclSemanticDomain::EN_MSG_AUDIOOUTPUTLOCATION)) && bResult;
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_STATUSINFOOPTION,sds_ttsfi_tclSemanticDomain::EN_MSG_STATUSINFO)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKWITHEXTENSIONMETHODRESULTFIRST:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_SPEAKPROGRESS,sds_ttsfi_tclSemanticDomain::EN_MSG_JOBPROGRESS)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKWITHEXTENSIONMETHODRESULTMIDDLE:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_SPEAKPROGRESS,sds_ttsfi_tclSemanticDomain::EN_MSG_JOBPROGRESS)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKWITHEXTENSIONMETHODRESULTLAST:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_SPEAKPROGRESS,sds_ttsfi_tclSemanticDomain::EN_MSG_JOBPROGRESS)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_VOICESTATUS:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_TTSVOICEINFO,sds_ttsfi_tclSemanticDomain::EN_MSG_TTSVOICE)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_AVAILABLEVOICESSTATUS:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_AVAILABLETTSVOICES,sds_ttsfi_tclSemanticDomain::EN_MSG_AVAILABLETTSVOICES)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_TTSVERSIONINFOSTATUS:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_TTSVERSIONINFO,sds_ttsfi_tclSemanticDomain::EN_MSG_TTSVERSIONINFO)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_TTSSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_TTSSTATUS,sds_ttsfi_tclSemanticDomain::EN_MSG_TTSSTATUS)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_DOWNLOADCOMPLETESTATUS:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_BOOL,sds_ttsfi_tclSemanticDomain::EN_MSG_COMPLETE)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_TTSPLAYBACKSPACINGSET:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_U8,sds_ttsfi_tclSemanticDomain::EN_MSG_PLAYBACKSPACING)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_TTSPLAYBACKSPACINGSTATUS:
   {
      bResult = oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_U8,sds_ttsfi_tclSemanticDomain::EN_MSG_PLAYBACKSPACING)) && bResult;
   } break;
   case sds_ttsfi_tclToken::EN_MSG_PREPAREVOICEOUTPUTMETHODRESULT:
   case sds_ttsfi_tclToken::EN_MSG_RELEASEDATAMETHODRESULT:
   case sds_ttsfi_tclToken::EN_MSG_SETVOICEMETHODRESULT:
   case sds_ttsfi_tclToken::EN_MSG_ABORTPROMPTMETHODRESULT:
   case sds_ttsfi_tclToken::EN_MSG_PAUSEPROMPTMETHODRESULT:
   case sds_ttsfi_tclToken::EN_MSG_CONTINUEPROMPTMETHODRESULT:
   case sds_ttsfi_tclToken::EN_MSG_ABORTPROMPTWITHEXTENSIONMETHODRESULT:
   case sds_ttsfi_tclToken::EN_MSG_PAUSEPROMPTWITHEXTENSIONMETHODRESULT:
   case sds_ttsfi_tclToken::EN_MSG_CONTINUEPROMPTWITHEXTENSIONMETHODRESULT:
   case sds_ttsfi_tclToken::EN_MSG_LOADTUNINGFILESMETHODRESULT:
   case sds_ttsfi_tclToken::EN_MSG_SETDEFAULTSPEECHRATEMETHODRESULT:
   case sds_ttsfi_tclToken::EN_MSG_DOSYNTHESISFORSPEAKMETHODRESULT:
   case sds_ttsfi_tclToken::EN_MSG_DOPREPAREAUDIOOUTPUTMETHODRESULT:
   case sds_ttsfi_tclToken::EN_MSG_DOUPREGTOPROPERTIESMETHODSTART:
   case sds_ttsfi_tclToken::EN_MSG_DOUPREGTOPROPERTIESMETHODRESULT:
   case sds_ttsfi_tclToken::EN_MSG_DOSYNTHESISFORWRITEMETHODRESULT:
   case sds_ttsfi_tclToken::EN_MSG_DOSYNTHESISFORSPEAKWITHEXTENTIONMETHODRESULT:
   case sds_ttsfi_tclToken::EN_MSG_DORELEASEDATAMETHODRESULT:
   case sds_ttsfi_tclToken::EN_MSG_DORELEASEAUDIODEVICEMETHODSTART:
   case sds_ttsfi_tclToken::EN_MSG_DORELEASEAUDIODEVICEMETHODRESULT:
   case sds_ttsfi_tclToken::EN_MSG_VOICEGET:
   case sds_ttsfi_tclToken::EN_MSG_VOICEUPREG:
   case sds_ttsfi_tclToken::EN_MSG_VOICERELUPREG:
   case sds_ttsfi_tclToken::EN_MSG_AVAILABLEVOICESGET:
   case sds_ttsfi_tclToken::EN_MSG_AVAILABLEVOICESUPREG:
   case sds_ttsfi_tclToken::EN_MSG_AVAILABLEVOICESRELUPREG:
   case sds_ttsfi_tclToken::EN_MSG_TTSVERSIONINFOGET:
   case sds_ttsfi_tclToken::EN_MSG_TTSVERSIONINFOUPREG:
   case sds_ttsfi_tclToken::EN_MSG_TTSVERSIONINFORELUPREG:
   case sds_ttsfi_tclToken::EN_MSG_TTSSTATUSGET:
   case sds_ttsfi_tclToken::EN_MSG_TTSSTATUSUPREG:
   case sds_ttsfi_tclToken::EN_MSG_TTSSTATUSRELUPREG:
   case sds_ttsfi_tclToken::EN_MSG_DOWNLOADCOMPLETEGET:
   case sds_ttsfi_tclToken::EN_MSG_DOWNLOADCOMPLETEUPREG:
   case sds_ttsfi_tclToken::EN_MSG_DOWNLOADCOMPLETERELUPREG:
   case sds_ttsfi_tclToken::EN_MSG_TTSPLAYBACKSPACINGUPREG:
   case sds_ttsfi_tclToken::EN_MSG_TTSPLAYBACKSPACINGRELUPREG:
   case sds_ttsfi_tclToken::EN_E16_ISOCOUNTRYCODE:
   case sds_ttsfi_tclToken::EN_BINCONTAINER:
   case sds_ttsfi_tclToken::EN_E16_ISO639_3_SDSLANGUAGECODE:
   case sds_ttsfi_tclToken::EN_SDSLANGUAGEID:
   case sds_ttsfi_tclToken::EN_E8_VOICEGENDER:
   case sds_ttsfi_tclToken::EN_VOICETYPE:
   case sds_ttsfi_tclToken::EN_E8_AUDIOSOURCEID:
   case sds_ttsfi_tclToken::EN_E8SEQUENCECATEGORY:
   case sds_ttsfi_tclToken::EN_E8_TEXTSTYLEOPTION:
   case sds_ttsfi_tclToken::EN_E8_STATUSINFOOPTION:
   case sds_ttsfi_tclToken::EN_E8_BUFFERINGOPTION:
   case sds_ttsfi_tclToken::EN_E8_PROMPTABORTOPTION:
   case sds_ttsfi_tclToken::EN_E8_TTSSTATUS:
   case sds_ttsfi_tclToken::EN_E8_JOBSTATUS:
   case sds_ttsfi_tclToken::EN_E8_RELEASETYPETTS:
   case sds_ttsfi_tclToken::EN_E8_TTSTUNTYPE:
   case sds_ttsfi_tclToken::EN_E8_TUNSRC:
   case sds_ttsfi_tclToken::EN_E8_TTSDOMAIN:
   case sds_ttsfi_tclToken::EN_SPEAKPROGRESS:
   case sds_ttsfi_tclToken::EN_FILELOCATION:
   case sds_ttsfi_tclToken::EN_BUFFERINGPROGRESS:
   case sds_ttsfi_tclToken::EN_AVAILABLETTSVOICES:
   case sds_ttsfi_tclToken::EN_TTSVERSIONINFO:
   case sds_ttsfi_tclToken::EN_TTSPHONEMERESULT:
   case sds_ttsfi_tclToken::EN_TTSTUNINGFILE:
   case sds_ttsfi_tclToken::EN_TTSVOICEINFO:
   case sds_ttsfi_tclToken::EN_B8_AUDIOOUTPUTLOCATION:
   case sds_ttsfi_tclToken::EN_B8_AUDIOFORMAT:
   case sds_ttsfi_tclToken::EN_U8:   
   case sds_ttsfi_tclToken::EN_S8:   
   case sds_ttsfi_tclToken::EN_U16:   
   case sds_ttsfi_tclToken::EN_S16:   
   case sds_ttsfi_tclToken::EN_U24:   
   case sds_ttsfi_tclToken::EN_S24:   
   case sds_ttsfi_tclToken::EN_U32:   
   case sds_ttsfi_tclToken::EN_S32:   
   case sds_ttsfi_tclToken::EN_U64:   
   case sds_ttsfi_tclToken::EN_S64:   
   case sds_ttsfi_tclToken::EN_F32:   
   case sds_ttsfi_tclToken::EN_F64:   
   case sds_ttsfi_tclToken::EN_BOOL:   
   case sds_ttsfi_tclToken::EN_STRING:   
   case sds_ttsfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(enMsgToken,sds_ttsfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool sds_ttsfi_tclDescription::bDoIt(sds_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool sds_ttsfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      sds_ttsfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      sds_ttsfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      sds_ttsfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == sds_ttsfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(sds_ttsfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case sds_ttsfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == sds_ttsfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_LIST: 
      {
         sds_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            sds_ttsfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            sds_ttsfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case sds_ttsfi_tclToken::EN_U8: 
      {
         sds_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case sds_ttsfi_tclToken::EN_U16: 
      {
         sds_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_U24: 
      {
         sds_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_U32: 
      {
         sds_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_U64: 
      {
         sds_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_S8: 
      {
         sds_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_S16: 
      {
         sds_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_S24: 
      {
         sds_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_S32: 
      {
         sds_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_S64: 
      {
         sds_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_F32: 
      {
         sds_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_F64: 
      {
         sds_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_BOOL: 
      {
         sds_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_STRING: 
      {
         sds_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         sds_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODSTART:
      case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODRESULTFIRST:
      case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODRESULTMIDDLE:
      case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODRESULTLAST:
      case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZEWRITEMETHODSTART:
      case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZEWRITEMETHODRESULTFIRST:
      case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZEWRITEMETHODRESULTMIDDLE:
      case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZEWRITEMETHODRESULTLAST:
      case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKWITHEXTENSIONMETHODSTART:
      case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKWITHEXTENSIONMETHODRESULTFIRST:
      case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKWITHEXTENSIONMETHODRESULTMIDDLE:
      case sds_ttsfi_tclToken::EN_MSG_SYNTHESIZESPEAKWITHEXTENSIONMETHODRESULTLAST:
      case sds_ttsfi_tclToken::EN_MSG_PREPAREVOICEOUTPUTMETHODSTART:
      case sds_ttsfi_tclToken::EN_MSG_PREPAREVOICEOUTPUTMETHODRESULT:
      case sds_ttsfi_tclToken::EN_MSG_RELEASEDATAMETHODSTART:
      case sds_ttsfi_tclToken::EN_MSG_RELEASEDATAMETHODRESULT:
      case sds_ttsfi_tclToken::EN_MSG_SETVOICEMETHODSTART:
      case sds_ttsfi_tclToken::EN_MSG_SETVOICEMETHODRESULT:
      case sds_ttsfi_tclToken::EN_MSG_ABORTPROMPTMETHODSTART:
      case sds_ttsfi_tclToken::EN_MSG_ABORTPROMPTMETHODRESULT:
      case sds_ttsfi_tclToken::EN_MSG_PAUSEPROMPTMETHODSTART:
      case sds_ttsfi_tclToken::EN_MSG_PAUSEPROMPTMETHODRESULT:
      case sds_ttsfi_tclToken::EN_MSG_CONTINUEPROMPTMETHODSTART:
      case sds_ttsfi_tclToken::EN_MSG_CONTINUEPROMPTMETHODRESULT:
      case sds_ttsfi_tclToken::EN_MSG_ABORTPROMPTWITHEXTENSIONMETHODSTART:
      case sds_ttsfi_tclToken::EN_MSG_ABORTPROMPTWITHEXTENSIONMETHODRESULT:
      case sds_ttsfi_tclToken::EN_MSG_PAUSEPROMPTWITHEXTENSIONMETHODSTART:
      case sds_ttsfi_tclToken::EN_MSG_PAUSEPROMPTWITHEXTENSIONMETHODRESULT:
      case sds_ttsfi_tclToken::EN_MSG_CONTINUEPROMPTWITHEXTENSIONMETHODSTART:
      case sds_ttsfi_tclToken::EN_MSG_CONTINUEPROMPTWITHEXTENSIONMETHODRESULT:
      case sds_ttsfi_tclToken::EN_MSG_REQUESTPHONEMEMETHODSTART:
      case sds_ttsfi_tclToken::EN_MSG_REQUESTPHONEMEMETHODRESULT:
      case sds_ttsfi_tclToken::EN_MSG_LOADTUNINGFILESMETHODSTART:
      case sds_ttsfi_tclToken::EN_MSG_LOADTUNINGFILESMETHODRESULT:
      case sds_ttsfi_tclToken::EN_MSG_SETDEFAULTSPEECHRATEMETHODSTART:
      case sds_ttsfi_tclToken::EN_MSG_SETDEFAULTSPEECHRATEMETHODRESULT:
      case sds_ttsfi_tclToken::EN_MSG_DOSYNTHESISFORSPEAKMETHODSTART:
      case sds_ttsfi_tclToken::EN_MSG_DOSYNTHESISFORSPEAKMETHODRESULT:
      case sds_ttsfi_tclToken::EN_MSG_DOPREPAREAUDIOOUTPUTMETHODSTART:
      case sds_ttsfi_tclToken::EN_MSG_DOPREPAREAUDIOOUTPUTMETHODRESULT:
      case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKMETHODSTART:
      case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKMETHODRESULTFIRST:
      case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKMETHODRESULTMIDDLE:
      case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKMETHODRESULTLAST:
      case sds_ttsfi_tclToken::EN_MSG_DOUPREGTOPROPERTIESMETHODSTART:
      case sds_ttsfi_tclToken::EN_MSG_DOUPREGTOPROPERTIESMETHODRESULT:
      case sds_ttsfi_tclToken::EN_MSG_DOSYNTHESISFORWRITEMETHODSTART:
      case sds_ttsfi_tclToken::EN_MSG_DOSYNTHESISFORWRITEMETHODRESULT:
      case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTWRITEMETHODSTART:
      case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTWRITEMETHODRESULTFIRST:
      case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTWRITEMETHODRESULTMIDDLE:
      case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTWRITEMETHODRESULTLAST:
      case sds_ttsfi_tclToken::EN_MSG_DOSYNTHESISFORSPEAKWITHEXTENTIONMETHODSTART:
      case sds_ttsfi_tclToken::EN_MSG_DOSYNTHESISFORSPEAKWITHEXTENTIONMETHODRESULT:
      case sds_ttsfi_tclToken::EN_MSG_DORELEASEDATAMETHODSTART:
      case sds_ttsfi_tclToken::EN_MSG_DORELEASEDATAMETHODRESULT:
      case sds_ttsfi_tclToken::EN_MSG_DORELEASEAUDIODEVICEMETHODSTART:
      case sds_ttsfi_tclToken::EN_MSG_DORELEASEAUDIODEVICEMETHODRESULT:
      case sds_ttsfi_tclToken::EN_MSG_DOREQUESTPHONEMEMETHODSTART:
      case sds_ttsfi_tclToken::EN_MSG_DOREQUESTPHONEMEMETHODRESULT:
      case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKWITHEXTENSIONMETHODSTART:
      case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKWITHEXTENSIONMETHODRESULTFIRST:
      case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKWITHEXTENSIONMETHODRESULTMIDDLE:
      case sds_ttsfi_tclToken::EN_MSG_DOAUDIOOUTPUTSPEAKWITHEXTENSIONMETHODRESULTLAST:
      case sds_ttsfi_tclToken::EN_MSG_VOICEGET:
      case sds_ttsfi_tclToken::EN_MSG_VOICESTATUS:
      case sds_ttsfi_tclToken::EN_MSG_VOICEUPREG:
      case sds_ttsfi_tclToken::EN_MSG_VOICERELUPREG:
      case sds_ttsfi_tclToken::EN_MSG_AVAILABLEVOICESGET:
      case sds_ttsfi_tclToken::EN_MSG_AVAILABLEVOICESSTATUS:
      case sds_ttsfi_tclToken::EN_MSG_AVAILABLEVOICESUPREG:
      case sds_ttsfi_tclToken::EN_MSG_AVAILABLEVOICESRELUPREG:
      case sds_ttsfi_tclToken::EN_MSG_TTSVERSIONINFOGET:
      case sds_ttsfi_tclToken::EN_MSG_TTSVERSIONINFOSTATUS:
      case sds_ttsfi_tclToken::EN_MSG_TTSVERSIONINFOUPREG:
      case sds_ttsfi_tclToken::EN_MSG_TTSVERSIONINFORELUPREG:
      case sds_ttsfi_tclToken::EN_MSG_TTSSTATUSGET:
      case sds_ttsfi_tclToken::EN_MSG_TTSSTATUSSTATUS:
      case sds_ttsfi_tclToken::EN_MSG_TTSSTATUSUPREG:
      case sds_ttsfi_tclToken::EN_MSG_TTSSTATUSRELUPREG:
      case sds_ttsfi_tclToken::EN_MSG_DOWNLOADCOMPLETEGET:
      case sds_ttsfi_tclToken::EN_MSG_DOWNLOADCOMPLETEUPREG:
      case sds_ttsfi_tclToken::EN_MSG_DOWNLOADCOMPLETERELUPREG:
      case sds_ttsfi_tclToken::EN_MSG_DOWNLOADCOMPLETESTATUS:
      case sds_ttsfi_tclToken::EN_MSG_TTSPLAYBACKSPACINGSET:
      case sds_ttsfi_tclToken::EN_MSG_TTSPLAYBACKSPACINGSTATUS:
      case sds_ttsfi_tclToken::EN_MSG_TTSPLAYBACKSPACINGUPREG:
      case sds_ttsfi_tclToken::EN_MSG_TTSPLAYBACKSPACINGRELUPREG:
         (tVoid) bInitMessage(enToken);
         break;
      case sds_ttsfi_tclToken::EN_E16_ISOCOUNTRYCODE:
      {
         sds_fi_tcl_e16_ISOCountryCode o_e16_ISOCountryCode;
         if (!bDoIt(o_e16_ISOCountryCode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_END_OF_STRUCT,sds_ttsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_U8,sds_ttsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_LIST,sds_ttsfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         sds_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_ttsfi_tclToken::EN_E16_ISO639_3_SDSLANGUAGECODE:
      {
         sds_fi_tcl_e16_ISO639_3_SDSLanguageCode o_e16_ISO639_3_SDSLanguageCode;
         if (!bDoIt(o_e16_ISO639_3_SDSLanguageCode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_SDSLANGUAGEID:
      {
      if (poVisitor->bDoExpand_SDSLanguageID(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_END_OF_STRUCT,sds_ttsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E16_ISOCOUNTRYCODE,sds_ttsfi_tclSemanticDomain::EN_ISO3166_COUNTRYCODE));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E16_ISO639_3_SDSLANGUAGECODE,sds_ttsfi_tclSemanticDomain::EN_ISO639_3_SDSLANGUAGECODE));
      }
      else
      {
         sds_fi_tcl_SDSLanguageID o_SDSLanguageID;
         if (!bDoIt(o_SDSLanguageID))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SDSLanguageID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SDSLanguageID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_ttsfi_tclToken::EN_E8_VOICEGENDER:
      {
         sds_fi_tcl_e8_VoiceGender o_e8_VoiceGender;
         if (!bDoIt(o_e8_VoiceGender))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_VOICETYPE:
      {
      if (poVisitor->bDoExpand_VoiceType(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_END_OF_STRUCT,sds_ttsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_VOICEGENDER,sds_ttsfi_tclSemanticDomain::EN_VOICEGENDER));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_STRING,sds_ttsfi_tclSemanticDomain::EN_VOICENAME));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_SDSLANGUAGEID,sds_ttsfi_tclSemanticDomain::EN_LANGUAGEID));
      }
      else
      {
         sds_fi_tcl_VoiceType o_VoiceType;
         if (!bDoIt(o_VoiceType))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VoiceType.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VoiceType.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_ttsfi_tclToken::EN_E8_AUDIOSOURCEID:
      {
         sds_fi_tcl_e8_AudioSourceID o_e8_AudioSourceID;
         if (!bDoIt(o_e8_AudioSourceID))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_E8SEQUENCECATEGORY:
      {
         sds_fi_tcl_e8SequenceCategory o_e8SequenceCategory;
         if (!bDoIt(o_e8SequenceCategory))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_E8_TEXTSTYLEOPTION:
      {
         sds_fi_tcl_e8_TextStyleOption o_e8_TextStyleOption;
         if (!bDoIt(o_e8_TextStyleOption))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_E8_STATUSINFOOPTION:
      {
         sds_fi_tcl_e8_StatusInfoOption o_e8_StatusInfoOption;
         if (!bDoIt(o_e8_StatusInfoOption))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_E8_BUFFERINGOPTION:
      {
         sds_fi_tcl_e8_BufferingOption o_e8_BufferingOption;
         if (!bDoIt(o_e8_BufferingOption))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_E8_PROMPTABORTOPTION:
      {
         sds_fi_tcl_e8_PromptAbortOption o_e8_PromptAbortOption;
         if (!bDoIt(o_e8_PromptAbortOption))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_E8_TTSSTATUS:
      {
         sds_fi_tcl_e8_TTSStatus o_e8_TTSStatus;
         if (!bDoIt(o_e8_TTSStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_E8_JOBSTATUS:
      {
         sds_fi_tcl_e8_JobStatus o_e8_JobStatus;
         if (!bDoIt(o_e8_JobStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_E8_RELEASETYPETTS:
      {
         sds_fi_tcl_e8_ReleaseTypeTTS o_e8_ReleaseTypeTTS;
         if (!bDoIt(o_e8_ReleaseTypeTTS))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_E8_TTSTUNTYPE:
      {
         sds_fi_tcl_e8_TTSTunType o_e8_TTSTunType;
         if (!bDoIt(o_e8_TTSTunType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_E8_TUNSRC:
      {
         sds_fi_tcl_e8_TunSrc o_e8_TunSrc;
         if (!bDoIt(o_e8_TunSrc))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_E8_TTSDOMAIN:
      {
         sds_fi_tcl_e8_TTSDomain o_e8_TTSDomain;
         if (!bDoIt(o_e8_TTSDomain))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_SPEAKPROGRESS:
      {
      if (poVisitor->bDoExpand_SpeakProgress(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_END_OF_STRUCT,sds_ttsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_JOBSTATUS,sds_ttsfi_tclSemanticDomain::EN_JOBSTATUS));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_U32,sds_ttsfi_tclSemanticDomain::EN_LASTBOOKMARKID));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_U32,sds_ttsfi_tclSemanticDomain::EN_LASTTEXTUNITSRCPOS));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_U16,sds_ttsfi_tclSemanticDomain::EN_TEXTUNIT));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_U32,sds_ttsfi_tclSemanticDomain::EN_LASTMARKERSRCPOS));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_U16,sds_ttsfi_tclSemanticDomain::EN_MARKER));
      }
      else
      {
         sds_fi_tcl_SpeakProgress o_SpeakProgress;
         if (!bDoIt(o_SpeakProgress))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SpeakProgress.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SpeakProgress.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_ttsfi_tclToken::EN_FILELOCATION:
      {
      if (poVisitor->bDoExpand_FileLocation(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_END_OF_STRUCT,sds_ttsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_U32,sds_ttsfi_tclSemanticDomain::EN_FILESIZE));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_STRING,sds_ttsfi_tclSemanticDomain::EN_FILELOCATION));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_U32,sds_ttsfi_tclSemanticDomain::EN_BLOCKID));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_U8,sds_ttsfi_tclSemanticDomain::EN_PARTOFBLOCK));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_U8,sds_ttsfi_tclSemanticDomain::EN_SAVEDBLOCK));
      }
      else
      {
         sds_fi_tcl_FileLocation o_FileLocation;
         if (!bDoIt(o_FileLocation))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FileLocation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FileLocation.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_ttsfi_tclToken::EN_BUFFERINGPROGRESS:
      {
      if (poVisitor->bDoExpand_BufferingProgress(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_END_OF_STRUCT,sds_ttsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_JOBSTATUS,sds_ttsfi_tclSemanticDomain::EN_JOBSTATUS));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_FILELOCATION,sds_ttsfi_tclSemanticDomain::EN_FILELOCATION));
      }
      else
      {
         sds_fi_tcl_BufferingProgress o_BufferingProgress;
         if (!bDoIt(o_BufferingProgress))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BufferingProgress.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BufferingProgress.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_ttsfi_tclToken::EN_AVAILABLETTSVOICES:
      {
      if (poVisitor->bDoExpand_AvailableTTSVoices(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_END_OF_STRUCT,sds_ttsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_VOICETYPE,sds_ttsfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_LIST,sds_ttsfi_tclSemanticDomain::EN_TTSVOICE));
      }
      else
      {
         sds_fi_tcl_AvailableTTSVoices o_AvailableTTSVoices;
         if (!bDoIt(o_AvailableTTSVoices))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AvailableTTSVoices.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AvailableTTSVoices.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_ttsfi_tclToken::EN_TTSVERSIONINFO:
      {
      if (poVisitor->bDoExpand_TTSVersionInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_END_OF_STRUCT,sds_ttsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_STRING,sds_ttsfi_tclSemanticDomain::EN_TTSMODULEVERSION));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_STRING,sds_ttsfi_tclSemanticDomain::EN_TTSMODULEPRODUCTIONDATE));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_STRING,sds_ttsfi_tclSemanticDomain::EN_TTSENGINEPRODUCTVERSION));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_STRING,sds_ttsfi_tclSemanticDomain::EN_TTSENGINEPRODUCTIONDATE));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_STRING,sds_ttsfi_tclSemanticDomain::EN_TTSENGINEMANUFACTURER));
      }
      else
      {
         sds_fi_tcl_TTSVersionInfo o_TTSVersionInfo;
         if (!bDoIt(o_TTSVersionInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TTSVersionInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TTSVersionInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_ttsfi_tclToken::EN_TTSPHONEMERESULT:
      {
      if (poVisitor->bDoExpand_TTSPhonemeResult(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_END_OF_STRUCT,sds_ttsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_BOOL,sds_ttsfi_tclSemanticDomain::EN_PHONEMEAVAILABILITY));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_BOOL,sds_ttsfi_tclSemanticDomain::EN_COMMERROR));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_STRING,sds_ttsfi_tclSemanticDomain::EN_PHONEME));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_U16,sds_ttsfi_tclSemanticDomain::EN_ID));
      }
      else
      {
         sds_fi_tcl_TTSPhonemeResult o_TTSPhonemeResult;
         if (!bDoIt(o_TTSPhonemeResult))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TTSPhonemeResult.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TTSPhonemeResult.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_ttsfi_tclToken::EN_TTSTUNINGFILE:
      {
      if (poVisitor->bDoExpand_TTSTuningFile(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_END_OF_STRUCT,sds_ttsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_STRING,sds_ttsfi_tclSemanticDomain::EN_FILENAME));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_TUNSRC,sds_ttsfi_tclSemanticDomain::EN_SRCTYPE));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_TTSTUNTYPE,sds_ttsfi_tclSemanticDomain::EN_TYPE));
      }
      else
      {
         sds_fi_tcl_TTSTuningFile o_TTSTuningFile;
         if (!bDoIt(o_TTSTuningFile))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TTSTuningFile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TTSTuningFile.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_ttsfi_tclToken::EN_TTSVOICEINFO:
      {
      if (poVisitor->bDoExpand_TTSVoiceInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_END_OF_STRUCT,sds_ttsfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_STRING,sds_ttsfi_tclSemanticDomain::EN_VERSION));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_E8_VOICEGENDER,sds_ttsfi_tclSemanticDomain::EN_VOICEGENDER));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_STRING,sds_ttsfi_tclSemanticDomain::EN_VOICENAME));
         (tVoid) oPath.bGoDown(sds_ttsfi_tclKnot(sds_ttsfi_tclToken::EN_SDSLANGUAGEID,sds_ttsfi_tclSemanticDomain::EN_LANGUAGEID));
      }
      else
      {
         sds_fi_tcl_TTSVoiceInfo o_TTSVoiceInfo;
         if (!bDoIt(o_TTSVoiceInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TTSVoiceInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TTSVoiceInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_ttsfi_tclToken::EN_B8_AUDIOOUTPUTLOCATION:
      {
         sds_fi_tcl_b8_AudioOutputLocation o_b8_AudioOutputLocation;
         if (!bDoIt(o_b8_AudioOutputLocation))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_B8_AUDIOFORMAT:
      {
         sds_fi_tcl_b8_AudioFormat o_b8_AudioFormat;
         if (!bDoIt(o_b8_AudioFormat))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_ttsfi_tclToken::EN_UNKNOWN:
      case sds_ttsfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

