#ifndef __SDS_TTSFIDEBUGVISITOR_H__
#define __SDS_TTSFIDEBUGVISITOR_H__

class MY_DECL sds_ttsfi_tclPrintVisitor : public sds_ttsfi_tclVisitorBase {

private:
   /* default constructor */ sds_ttsfi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   sds_ttsfi_tclPrintVisitor(sds_fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(sds_fi_tclU8& oU8);
   virtual tVoid vVisitS8(sds_fi_tclS8& oS8);
   virtual tVoid vVisitU16(sds_fi_tclU16& oU16);
   virtual tVoid vVisitS16(sds_fi_tclS16& oS16);
   virtual tVoid vVisitU24(sds_fi_tclU24& oU24);
   virtual tVoid vVisitS24(sds_fi_tclS24& oS24);
   virtual tVoid vVisitU32(sds_fi_tclU32& oU32);
   virtual tVoid vVisitS32(sds_fi_tclS32& oS32);
   virtual tVoid vVisitU64(sds_fi_tclU64& oU64);
   virtual tVoid vVisitS64(sds_fi_tclS64& oS64);
   virtual tVoid vVisitBool(sds_fi_tclBool& oBool);
   virtual tVoid vVisitString(sds_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(sds_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(sds_fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tVoid vVisit_e16_ISOCountryCode(sds_fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tBool bDoExpand_BinContainer(sds_ttsfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e16_ISO639_3_SDSLanguageCode(sds_fi_tcl_e16_ISO639_3_SDSLanguageCode& o_e16_ISO639_3_SDSLanguageCode);
   virtual tBool bDoExpand_SDSLanguageID(sds_ttsfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_VoiceGender(sds_fi_tcl_e8_VoiceGender& o_e8_VoiceGender);
   virtual tBool bDoExpand_VoiceType(sds_ttsfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_AudioSourceID(sds_fi_tcl_e8_AudioSourceID& o_e8_AudioSourceID);
   virtual tVoid vVisit_e8SequenceCategory(sds_fi_tcl_e8SequenceCategory& o_e8SequenceCategory);
   virtual tVoid vVisit_e8_TextStyleOption(sds_fi_tcl_e8_TextStyleOption& o_e8_TextStyleOption);
   virtual tVoid vVisit_e8_StatusInfoOption(sds_fi_tcl_e8_StatusInfoOption& o_e8_StatusInfoOption);
   virtual tVoid vVisit_e8_BufferingOption(sds_fi_tcl_e8_BufferingOption& o_e8_BufferingOption);
   virtual tVoid vVisit_e8_PromptAbortOption(sds_fi_tcl_e8_PromptAbortOption& o_e8_PromptAbortOption);
   virtual tVoid vVisit_e8_TTSStatus(sds_fi_tcl_e8_TTSStatus& o_e8_TTSStatus);
   virtual tVoid vVisit_e8_JobStatus(sds_fi_tcl_e8_JobStatus& o_e8_JobStatus);
   virtual tVoid vVisit_e8_ReleaseTypeTTS(sds_fi_tcl_e8_ReleaseTypeTTS& o_e8_ReleaseTypeTTS);
   virtual tVoid vVisit_e8_TTSTunType(sds_fi_tcl_e8_TTSTunType& o_e8_TTSTunType);
   virtual tVoid vVisit_e8_TunSrc(sds_fi_tcl_e8_TunSrc& o_e8_TunSrc);
   virtual tVoid vVisit_e8_TTSDomain(sds_fi_tcl_e8_TTSDomain& o_e8_TTSDomain);
   virtual tBool bDoExpand_SpeakProgress(sds_ttsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_FileLocation(sds_ttsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_BufferingProgress(sds_ttsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_AvailableTTSVoices(sds_ttsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TTSVersionInfo(sds_ttsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TTSPhonemeResult(sds_ttsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TTSTuningFile(sds_ttsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TTSVoiceInfo(sds_ttsfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_AudioOutputLocation(sds_fi_tcl_b8_AudioOutputLocation& o_b8_AudioOutputLocation);
   virtual tVoid vVisit_b8_AudioFormat(sds_fi_tcl_b8_AudioFormat& o_b8_AudioFormat);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   sds_fi_tclOutput* poOutput;
};


class MY_DECL sds_ttsfi_tclRandomInitVisitor : public sds_ttsfi_tclVisitorBase {
public:

   sds_ttsfi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(sds_fi_tclU8& oU8);
   virtual tVoid vVisitS8(sds_fi_tclS8& oS8);
   virtual tVoid vVisitU16(sds_fi_tclU16& oU16);
   virtual tVoid vVisitS16(sds_fi_tclS16& oS16);
   virtual tVoid vVisitU24(sds_fi_tclU24& oU24);
   virtual tVoid vVisitS24(sds_fi_tclS24& oS24);
   virtual tVoid vVisitU32(sds_fi_tclU32& oU32);
   virtual tVoid vVisitS32(sds_fi_tclS32& oS32);
   virtual tVoid vVisitU64(sds_fi_tclU64& oU64);
   virtual tVoid vVisitS64(sds_fi_tclS64& oS64);
   virtual tVoid vVisitBool(sds_fi_tclBool& oBool);
   virtual tVoid vVisitString(sds_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(sds_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(sds_fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_e16_ISOCountryCode(sds_fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_e16_ISO639_3_SDSLanguageCode(sds_fi_tcl_e16_ISO639_3_SDSLanguageCode& o_e16_ISO639_3_SDSLanguageCode);
   virtual tVoid vVisit_e8_VoiceGender(sds_fi_tcl_e8_VoiceGender& o_e8_VoiceGender);
   virtual tVoid vVisit_e8_AudioSourceID(sds_fi_tcl_e8_AudioSourceID& o_e8_AudioSourceID);
   virtual tVoid vVisit_e8SequenceCategory(sds_fi_tcl_e8SequenceCategory& o_e8SequenceCategory);
   virtual tVoid vVisit_e8_TextStyleOption(sds_fi_tcl_e8_TextStyleOption& o_e8_TextStyleOption);
   virtual tVoid vVisit_e8_StatusInfoOption(sds_fi_tcl_e8_StatusInfoOption& o_e8_StatusInfoOption);
   virtual tVoid vVisit_e8_BufferingOption(sds_fi_tcl_e8_BufferingOption& o_e8_BufferingOption);
   virtual tVoid vVisit_e8_PromptAbortOption(sds_fi_tcl_e8_PromptAbortOption& o_e8_PromptAbortOption);
   virtual tVoid vVisit_e8_TTSStatus(sds_fi_tcl_e8_TTSStatus& o_e8_TTSStatus);
   virtual tVoid vVisit_e8_JobStatus(sds_fi_tcl_e8_JobStatus& o_e8_JobStatus);
   virtual tVoid vVisit_e8_ReleaseTypeTTS(sds_fi_tcl_e8_ReleaseTypeTTS& o_e8_ReleaseTypeTTS);
   virtual tVoid vVisit_e8_TTSTunType(sds_fi_tcl_e8_TTSTunType& o_e8_TTSTunType);
   virtual tVoid vVisit_e8_TunSrc(sds_fi_tcl_e8_TunSrc& o_e8_TunSrc);
   virtual tVoid vVisit_e8_TTSDomain(sds_fi_tcl_e8_TTSDomain& o_e8_TTSDomain);
   virtual tVoid vVisit_b8_AudioOutputLocation(sds_fi_tcl_b8_AudioOutputLocation& o_b8_AudioOutputLocation);
   virtual tVoid vVisit_b8_AudioFormat(sds_fi_tcl_b8_AudioFormat& o_b8_AudioFormat);
	tU32 u32ListSize;
};

#endif
