/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef SDS_TRANSCRIPTIONSERVICEFITYPES_HEADER
#define SDS_TRANSCRIPTIONSERVICEFITYPES_HEADER


class sds_transcriptionservicefi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for SDS_TRANSCRIPTIONSERVICE_FI message types

fi_tclMessageBase* sds_transcriptionservicefi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class sds_transcriptionservicefi_tclMsgBaseMessage : public sds_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   sds_transcriptionservicefi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodStart : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodStart& operator=(const sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodStart& coRef);
   sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodStart(const sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tclString, std::allocator<sds_fi_tclString> > stWords;
   sds_fi_tcl_e8_Slot e8Slot;
   tU8 u8NumofTrans;
   virtual ~sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodResult : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodResult& operator=(const sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodResult& coRef);
   sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodResult(const sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_WordTransMap, std::allocator<sds_fi_tcl_WordTransMap> > WordTranscriptionsMap;
   virtual ~sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgDoUpRegToPropertiesMethodStart : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgDoUpRegToPropertiesMethodStart();

   virtual ~sds_transcriptionservicefi_tclMsgDoUpRegToPropertiesMethodStart();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgDoUpRegToPropertiesMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgDoUpRegToPropertiesMethodResult : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgDoUpRegToPropertiesMethodResult();

   virtual ~sds_transcriptionservicefi_tclMsgDoUpRegToPropertiesMethodResult();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgDoUpRegToPropertiesMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgConfigurePronounceMethodStart : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgConfigurePronounceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgConfigurePronounceMethodStart& operator=(const sds_transcriptionservicefi_tclMsgConfigurePronounceMethodStart& coRef);
   sds_transcriptionservicefi_tclMsgConfigurePronounceMethodStart(const sds_transcriptionservicefi_tclMsgConfigurePronounceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_Domain e8Domain;
   sds_fi_tclString szSlot;
   virtual ~sds_transcriptionservicefi_tclMsgConfigurePronounceMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgConfigurePronounceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgConfigurePronounceMethodResult : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgConfigurePronounceMethodResult();

   virtual ~sds_transcriptionservicefi_tclMsgConfigurePronounceMethodResult();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgConfigurePronounceMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodStart : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodStart& operator=(const sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodStart& coRef);
   sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodStart(const sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_VoconComponent e8VoconComponent;
   sds_fi_tcl_u64_tPVoid poComponent;
   virtual ~sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodResult : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodResult();

   virtual ~sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodResult();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodStart : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodStart& operator=(const sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodStart& coRef);
   sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodStart(const sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_VoconComponent e8VoconComponent;
   virtual ~sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodResult : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodResult();

   virtual ~sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodResult();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgReInitializeVoconComponentMethodStart : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgReInitializeVoconComponentMethodStart();

   virtual ~sds_transcriptionservicefi_tclMsgReInitializeVoconComponentMethodStart();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgReInitializeVoconComponentMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgReInitializeVoconComponentMethodResult : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgReInitializeVoconComponentMethodResult();

   virtual ~sds_transcriptionservicefi_tclMsgReInitializeVoconComponentMethodResult();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgReInitializeVoconComponentMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodStart : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodStart& operator=(const sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodStart& coRef);
   sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodStart(const sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32DeviceId;
   sds_fi_tcl_e8_Domain e8Domain;
   sds_fi_tclString strSlotType;
   tU32 u32ChunkStatus;
   tU32 u32TotalItems;
   virtual ~sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodResult : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodResult();

   virtual ~sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodResult();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgInformPausestateMethodStart : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgInformPausestateMethodStart();

   virtual ~sds_transcriptionservicefi_tclMsgInformPausestateMethodStart();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgInformPausestateMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgInformPausestateMethodResult : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgInformPausestateMethodResult();

   virtual ~sds_transcriptionservicefi_tclMsgInformPausestateMethodResult();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgInformPausestateMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgSetLanguageMethodStart : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgSetLanguageMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgSetLanguageMethodStart& operator=(const sds_transcriptionservicefi_tclMsgSetLanguageMethodStart& coRef);
   sds_transcriptionservicefi_tclMsgSetLanguageMethodStart(const sds_transcriptionservicefi_tclMsgSetLanguageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID Language;
   virtual ~sds_transcriptionservicefi_tclMsgSetLanguageMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgSetLanguageMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgSetLanguageMethodResult : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgSetLanguageMethodResult();

   virtual ~sds_transcriptionservicefi_tclMsgSetLanguageMethodResult();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgSetLanguageMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgInformLanguageMethodStart : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgInformLanguageMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgInformLanguageMethodStart& operator=(const sds_transcriptionservicefi_tclMsgInformLanguageMethodStart& coRef);
   sds_transcriptionservicefi_tclMsgInformLanguageMethodStart(const sds_transcriptionservicefi_tclMsgInformLanguageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID Language;
   virtual ~sds_transcriptionservicefi_tclMsgInformLanguageMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgInformLanguageMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgInformLanguageMethodResult : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgInformLanguageMethodResult();

   virtual ~sds_transcriptionservicefi_tclMsgInformLanguageMethodResult();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgInformLanguageMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodStart : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodStart& operator=(const sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodStart& coRef);
   sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodStart(const sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID Language;
   virtual ~sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodResult : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodResult();

   virtual ~sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodResult();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodStart : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodStart& operator=(const sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodStart& coRef);
   sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodStart(const sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bOnError;
   virtual ~sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodResult : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodResult();

   virtual ~sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodResult();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodStart : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodStart& operator=(const sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodStart& coRef);
   sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodStart(const sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_WordSlot, std::allocator<sds_fi_tcl_WordSlot> > stWordSlots;
   tU8 u8NumofTrans;
   virtual ~sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodResult : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodResult& operator=(const sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodResult& coRef);
   sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodResult(const sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_WordTransSlot, std::allocator<sds_fi_tcl_WordTransSlot> > stWordTransSlot;
   virtual ~sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgReleaseDataMethodStart : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgReleaseDataMethodStart();

   virtual ~sds_transcriptionservicefi_tclMsgReleaseDataMethodStart();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgReleaseDataMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgReleaseDataMethodResult : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgReleaseDataMethodResult();

   virtual ~sds_transcriptionservicefi_tclMsgReleaseDataMethodResult();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgReleaseDataMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodStart : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodStart& operator=(const sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodStart& coRef);
   sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodStart(const sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32DeviceId;
   sds_fi_tcl_e8_Domain e8Domain;
   virtual ~sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodResult : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodResult();

   virtual ~sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodResult();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodStart : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodStart& operator=(const sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodStart& coRef);
   sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodStart(const sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_VoconComponent e8VoconComponent;
   virtual ~sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodResult : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodResult();

   virtual ~sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodResult();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsglanguagechangesuccessMethodStart : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsglanguagechangesuccessMethodStart();

   virtual ~sds_transcriptionservicefi_tclMsglanguagechangesuccessMethodStart();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsglanguagechangesuccessMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsglanguagechangesuccessMethodResult : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsglanguagechangesuccessMethodResult();

   virtual ~sds_transcriptionservicefi_tclMsglanguagechangesuccessMethodResult();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsglanguagechangesuccessMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodStart : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodStart& operator=(const sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodStart& coRef);
   sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodStart(const sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tcl_e16_ISOCountryCode CountryCode;
   sds_fi_tcl_e8_ListType e8ListType;
   tU32 u32PageNumber;
   std::vector<sds_fi_tcl_ListEntries, std::allocator<sds_fi_tcl_ListEntries> > ListEntries;
   virtual ~sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodResult : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodResult& operator=(const sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodResult& coRef);
   sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodResult(const sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_SDSIDTranscriptionsEntry, std::allocator<sds_fi_tcl_SDSIDTranscriptionsEntry> > IDTranscriptionsMap;
   tU32 u32PageNumber;
   virtual ~sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodStart : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodStart& operator=(const sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodStart& coRef);
   sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodStart(const sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString szTraceCmd;
   virtual ~sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodResult : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodResult();

   virtual ~sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodResult();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodStart : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodStart& operator=(const sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodStart& coRef);
   sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodStart(const sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString szTraceCmd;
   virtual ~sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodResult : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodResult();

   virtual ~sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodResult();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodStart : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodStart& operator=(const sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodStart& coRef);
   sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodStart(const sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString szTraceCmd;
   virtual ~sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodResult : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodResult();

   virtual ~sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodResult();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodStart : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodStart& operator=(const sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodStart& coRef);
   sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodStart(const sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString szDBPath;
   virtual ~sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodResult : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodResult();

   virtual ~sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodResult();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodStart : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodStart& operator=(const sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodStart& coRef);
   sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodStart(const sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString szDBPath;
   virtual ~sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodResult : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodResult();

   virtual ~sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodResult();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodStart : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodStart& operator=(const sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodStart& coRef);
   sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodStart(const sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32DeviceId;
   sds_fi_tclString szDBPath;
   virtual ~sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodResult : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodResult();

   virtual ~sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodResult();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgFreeExcessHeapMemoryMethodStart : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgFreeExcessHeapMemoryMethodStart();

   virtual ~sds_transcriptionservicefi_tclMsgFreeExcessHeapMemoryMethodStart();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgFreeExcessHeapMemoryMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgFreeExcessHeapMemoryMethodResult : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgFreeExcessHeapMemoryMethodResult();

   virtual ~sds_transcriptionservicefi_tclMsgFreeExcessHeapMemoryMethodResult();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgFreeExcessHeapMemoryMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgLogHeapStatusMethodStart : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgLogHeapStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgLogHeapStatusMethodStart& operator=(const sds_transcriptionservicefi_tclMsgLogHeapStatusMethodStart& coRef);
   sds_transcriptionservicefi_tclMsgLogHeapStatusMethodStart(const sds_transcriptionservicefi_tclMsgLogHeapStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bTraceHeap;
   virtual ~sds_transcriptionservicefi_tclMsgLogHeapStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgLogHeapStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgLogHeapStatusMethodResult : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgLogHeapStatusMethodResult();

   virtual ~sds_transcriptionservicefi_tclMsgLogHeapStatusMethodResult();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgLogHeapStatusMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodStart : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodStart& operator=(const sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodStart& coRef);
   sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodStart(const sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_CountryPhoneme, std::allocator<sds_fi_tcl_CountryPhoneme> > CountryStateList;
   virtual ~sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodResult : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodResult();

   virtual ~sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodResult();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgCreateListContextMethodStart : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgCreateListContextMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgCreateListContextMethodStart& operator=(const sds_transcriptionservicefi_tclMsgCreateListContextMethodStart& coRef);
   sds_transcriptionservicefi_tclMsgCreateListContextMethodStart(const sds_transcriptionservicefi_tclMsgCreateListContextMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_Domain e8Domain;
   sds_fi_tcl_e8_WordType e8WordType;
   tBool IsPhonemeAvailable;
   std::vector<sds_fi_tcl_WordPhonemeMap, std::allocator<sds_fi_tcl_WordPhonemeMap> > stWordPhonemeMap;
   virtual ~sds_transcriptionservicefi_tclMsgCreateListContextMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgCreateListContextMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgCreateListContextMethodResult : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgCreateListContextMethodResult();

   virtual ~sds_transcriptionservicefi_tclMsgCreateListContextMethodResult();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgCreateListContextMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodStart : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodStart& operator=(const sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodStart& coRef);
   sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodStart(const sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_ListContextStatus, std::allocator<sds_fi_tcl_ListContextStatus> > ListContextStatus;
   virtual ~sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodResult : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodResult();

   virtual ~sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodResult();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgTSStatusGet : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgTSStatusGet();

   virtual ~sds_transcriptionservicefi_tclMsgTSStatusGet();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgTSStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgTSStatusUpReg : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgTSStatusUpReg();

   virtual ~sds_transcriptionservicefi_tclMsgTSStatusUpReg();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgTSStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgTSStatusRelUpReg : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgTSStatusRelUpReg();

   virtual ~sds_transcriptionservicefi_tclMsgTSStatusRelUpReg();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgTSStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgTSStatusStatus : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgTSStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgTSStatusStatus& operator=(const sds_transcriptionservicefi_tclMsgTSStatusStatus& coRef);
   sds_transcriptionservicefi_tclMsgTSStatusStatus(const sds_transcriptionservicefi_tclMsgTSStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_TSStatus TSStatus;
   virtual ~sds_transcriptionservicefi_tclMsgTSStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgTSStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgConnectedDeviceStatusGet : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgConnectedDeviceStatusGet();

   virtual ~sds_transcriptionservicefi_tclMsgConnectedDeviceStatusGet();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgConnectedDeviceStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgConnectedDeviceStatusUpReg : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgConnectedDeviceStatusUpReg();

   virtual ~sds_transcriptionservicefi_tclMsgConnectedDeviceStatusUpReg();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgConnectedDeviceStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgConnectedDeviceStatusRelUpReg : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgConnectedDeviceStatusRelUpReg();

   virtual ~sds_transcriptionservicefi_tclMsgConnectedDeviceStatusRelUpReg();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgConnectedDeviceStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgConnectedDeviceStatusStatus : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgConnectedDeviceStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgConnectedDeviceStatusStatus& operator=(const sds_transcriptionservicefi_tclMsgConnectedDeviceStatusStatus& coRef);
   sds_transcriptionservicefi_tclMsgConnectedDeviceStatusStatus(const sds_transcriptionservicefi_tclMsgConnectedDeviceStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_ConnectedDeviceStatus, std::allocator<sds_fi_tcl_ConnectedDeviceStatus> > ConnectedDeviceStatus;
   tU8 MediaState;
   std::vector<sds_fi_tcl_e8_Slot, std::allocator<sds_fi_tcl_e8_Slot> > e8Slot;
   virtual ~sds_transcriptionservicefi_tclMsgConnectedDeviceStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgConnectedDeviceStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgDynamicDataStatusGet : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgDynamicDataStatusGet();

   virtual ~sds_transcriptionservicefi_tclMsgDynamicDataStatusGet();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgDynamicDataStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgDynamicDataStatusUpReg : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgDynamicDataStatusUpReg();

   virtual ~sds_transcriptionservicefi_tclMsgDynamicDataStatusUpReg();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgDynamicDataStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgDynamicDataStatusRelUpReg : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgDynamicDataStatusRelUpReg();

   virtual ~sds_transcriptionservicefi_tclMsgDynamicDataStatusRelUpReg();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgDynamicDataStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgDynamicDataStatusStatus : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgDynamicDataStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgDynamicDataStatusStatus& operator=(const sds_transcriptionservicefi_tclMsgDynamicDataStatusStatus& coRef);
   sds_transcriptionservicefi_tclMsgDynamicDataStatusStatus(const sds_transcriptionservicefi_tclMsgDynamicDataStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_DynamicDataStatus, std::allocator<sds_fi_tcl_DynamicDataStatus> > DynamicDataStatus;
   std::vector<sds_fi_tcl_e8_Slot, std::allocator<sds_fi_tcl_e8_Slot> > e8FSGSlots;
   std::vector<sds_fi_tcl_e8_Slot, std::allocator<sds_fi_tcl_e8_Slot> > e8SLMSlots;
   virtual ~sds_transcriptionservicefi_tclMsgDynamicDataStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgDynamicDataStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgContextOverflowGet : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgContextOverflowGet();

   virtual ~sds_transcriptionservicefi_tclMsgContextOverflowGet();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgContextOverflowGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgContextOverflowUpReg : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgContextOverflowUpReg();

   virtual ~sds_transcriptionservicefi_tclMsgContextOverflowUpReg();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgContextOverflowUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgContextOverflowRelUpReg : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgContextOverflowRelUpReg();

   virtual ~sds_transcriptionservicefi_tclMsgContextOverflowRelUpReg();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgContextOverflowRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgContextOverflowStatus : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgContextOverflowStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgContextOverflowStatus& operator=(const sds_transcriptionservicefi_tclMsgContextOverflowStatus& coRef);
   sds_transcriptionservicefi_tclMsgContextOverflowStatus(const sds_transcriptionservicefi_tclMsgContextOverflowStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_ContextOverFlowStatus ContextOverflow;
   virtual ~sds_transcriptionservicefi_tclMsgContextOverflowStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgContextOverflowStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusGet : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusGet();

   virtual ~sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusGet();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusUpReg : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusUpReg();

   virtual ~sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusUpReg();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusRelUpReg : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusRelUpReg();

   virtual ~sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusRelUpReg();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusStatus : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusStatus& operator=(const sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusStatus& coRef);
   sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusStatus(const sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_VoconComponentStatus VoconAsrStatus;
   sds_fi_tcl_e8_VoconComponentStatus VoconPronStatus;
   virtual ~sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgLanguageGet : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgLanguageGet();

   virtual ~sds_transcriptionservicefi_tclMsgLanguageGet();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgLanguageGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgLanguageStatus : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgLanguageStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgLanguageStatus& operator=(const sds_transcriptionservicefi_tclMsgLanguageStatus& coRef);
   sds_transcriptionservicefi_tclMsgLanguageStatus(const sds_transcriptionservicefi_tclMsgLanguageStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID Language;
   virtual ~sds_transcriptionservicefi_tclMsgLanguageStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgLanguageStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgListContextStatusGet : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgListContextStatusGet();

   virtual ~sds_transcriptionservicefi_tclMsgListContextStatusGet();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgListContextStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgListContextStatusUpReg : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgListContextStatusUpReg();

   virtual ~sds_transcriptionservicefi_tclMsgListContextStatusUpReg();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgListContextStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgListContextStatusRelUpReg : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgListContextStatusRelUpReg();

   virtual ~sds_transcriptionservicefi_tclMsgListContextStatusRelUpReg();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgListContextStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgListContextStatusStatus : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgListContextStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgListContextStatusStatus& operator=(const sds_transcriptionservicefi_tclMsgListContextStatusStatus& coRef);
   sds_transcriptionservicefi_tclMsgListContextStatusStatus(const sds_transcriptionservicefi_tclMsgListContextStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_ListContextStatus, std::allocator<sds_fi_tcl_ListContextStatus> > ListContextStatus;
   virtual ~sds_transcriptionservicefi_tclMsgListContextStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgListContextStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusGet : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusGet();

   virtual ~sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusGet();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusUpReg : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusUpReg();

   virtual ~sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusUpReg();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusRelUpReg : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusRelUpReg();

   virtual ~sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusRelUpReg();

   inline tBool operator==(const sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusSet : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusSet& operator=(const sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusSet& coRef);
   sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusSet(const sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_e8_DeviceContextAvailability, std::allocator<sds_fi_tcl_e8_DeviceContextAvailability> > DeviceContextStatus;
   virtual ~sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusStatus : public sds_transcriptionservicefi_tclMsgBaseMessage
{
public:

   sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusStatus& operator=(const sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusStatus& coRef);
   sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusStatus(const sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_e8_DeviceContextAvailability, std::allocator<sds_fi_tcl_e8_DeviceContextAvailability> > DeviceContextStatus;
   virtual ~sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
