#include "precompiled.hh"

tBool sds_transcriptionservicefi_tclDescription::bInitMessage(sds_transcriptionservicefi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case sds_transcriptionservicefi_tclToken::EN_LAST_TOKEN:
   case sds_transcriptionservicefi_tclToken::EN_LIST:
   case sds_transcriptionservicefi_tclToken::EN_END_OF_STRUCT:
   case sds_transcriptionservicefi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case sds_transcriptionservicefi_tclToken::EN_MSG_GETTRANSCRIPTIONSMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_U8,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_U8NUMOFTRANS)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_SLOT,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_E8SLOT)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_STRING,sds_transcriptionservicefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LIST,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_STWORDS)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_GETTRANSCRIPTIONSMETHODRESULT:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_WORDTRANSMAP,sds_transcriptionservicefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LIST,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_WORDTRANSCRIPTIONSMAP)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_CONFIGUREPRONOUNCEMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_STRING,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_SZSLOT)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_DOMAIN,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_E8DOMAIN)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_VOCONCOMPONENTINITIALIZEDMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_U64_TPVOID,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_POCOMPONENT)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_VOCONCOMPONENT,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_E8VOCONCOMPONENT)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_VOCONCOMPONENTUNINITIALIZEDMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_VOCONCOMPONENT,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_E8VOCONCOMPONENT)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_RESUMECONTEXTUPDATEMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_U32,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_U32TOTALITEMS)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_U32,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_U32CHUNKSTATUS)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_STRING,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_STRSLOTTYPE)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_DOMAIN,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_E8DOMAIN)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_U32,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_U32DEVICEID)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_SETLANGUAGEMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_SDSLANGUAGEID,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_LANGUAGE)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_INFORMLANGUAGEMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_SDSLANGUAGEID,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_LANGUAGE)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_CREATETSRESOURCESMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_SDSLANGUAGEID,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_LANGUAGE)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_CLOSETSRESOURCESMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_BOOL,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_BONERROR)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_GETTRANSCRIPTIONSTTSMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_U8,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_U8NUMOFTRANS)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_WORDSLOT,sds_transcriptionservicefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LIST,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_STWORDSLOTS)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_GETTRANSCRIPTIONSTTSMETHODRESULT:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_WORDTRANSSLOT,sds_transcriptionservicefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LIST,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_STWORDTRANSSLOT)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_HANDLENEWDEVICEMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_DOMAIN,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_E8DOMAIN)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_U32,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_U32DEVICEID)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_CONFIRMVOCONACTIVITYSTOPMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_VOCONCOMPONENT,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_E8VOCONCOMPONENT)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_GETTRANSCRIPTIONSFORLISTMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LISTENTRIES,sds_transcriptionservicefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LIST,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_LISTENTRIES)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_U32,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_U32PAGENUMBER)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_LISTTYPE,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_E8LISTTYPE)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E16_ISOCOUNTRYCODE,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_COUNTRYCODE)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_SDSLANGUAGEID,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_LANGUAGEID)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_GETTRANSCRIPTIONSFORLISTMETHODRESULT:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_U32,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_U32PAGENUMBER)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_SDSIDTRANSCRIPTIONSENTRY,sds_transcriptionservicefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LIST,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_IDTRANSCRIPTIONSMAP)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_TRACECMDPHONEUPDATEMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_STRING,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_SZTRACECMD)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_TRACECMDMEDIAUPDATEMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_STRING,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_SZTRACECMD)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_TRACECMDTUNERUPDATEMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_STRING,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_SZTRACECMD)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_SETPHONEDBPATHMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_STRING,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_SZDBPATH)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_SETMEDIADBPATHMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_STRING,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_SZDBPATH)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_SETTUNERDBPATHMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_STRING,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_SZDBPATH)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_U32,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_U32DEVICEID)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_LOGHEAPSTATUSMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_BOOL,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_BTRACEHEAP)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_CREATECOUNTRYSTATELISTMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_COUNTRYPHONEME,sds_transcriptionservicefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LIST,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_COUNTRYSTATELIST)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_CREATELISTCONTEXTMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_WORDPHONEMEMAP,sds_transcriptionservicefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LIST,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_STWORDPHONEMEMAP)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_BOOL,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_ISPHONEMEAVAILABLE)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_WORDTYPE,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_E8WORDTYPE)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_DOMAIN,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_E8DOMAIN)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_UPDATELISTCONTEXTPROPERTYMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LISTCONTEXTSTATUS,sds_transcriptionservicefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LIST,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_LISTCONTEXTSTATUS)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_TSSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_TSSTATUS,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_TSSTATUS)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_CONNECTEDDEVICESTATUSSTATUS:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_SLOT,sds_transcriptionservicefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LIST,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_E8SLOT)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_U8,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_MEDIASTATE)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_CONNECTEDDEVICESTATUS,sds_transcriptionservicefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LIST,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_CONNECTEDDEVICESTATUS)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_DYNAMICDATASTATUSSTATUS:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_SLOT,sds_transcriptionservicefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LIST,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_E8SLMSLOTS)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_SLOT,sds_transcriptionservicefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LIST,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_E8FSGSLOTS)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_DYNAMICDATASTATUS,sds_transcriptionservicefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LIST,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_DYNAMICDATASTATUS)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_CONTEXTOVERFLOWSTATUS:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_CONTEXTOVERFLOWSTATUS,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_CONTEXTOVERFLOW)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_TSVOCONCOMPONENTSSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_VOCONCOMPONENTSTATUS,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_VOCONPRONSTATUS)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_VOCONCOMPONENTSTATUS,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_VOCONASRSTATUS)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_LANGUAGESTATUS:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_SDSLANGUAGEID,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_LANGUAGE)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_LISTCONTEXTSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LISTCONTEXTSTATUS,sds_transcriptionservicefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LIST,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_LISTCONTEXTSTATUS)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_RECCTXLOADEDSTATUSSET:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_DEVICECONTEXTAVAILABILITY,sds_transcriptionservicefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LIST,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_DEVICECONTEXTSTATUS)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_RECCTXLOADEDSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_DEVICECONTEXTAVAILABILITY,sds_transcriptionservicefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LIST,sds_transcriptionservicefi_tclSemanticDomain::EN_MSG_DEVICECONTEXTSTATUS)) && bResult;
   } break;
   case sds_transcriptionservicefi_tclToken::EN_MSG_DOUPREGTOPROPERTIESMETHODSTART:
   case sds_transcriptionservicefi_tclToken::EN_MSG_DOUPREGTOPROPERTIESMETHODRESULT:
   case sds_transcriptionservicefi_tclToken::EN_MSG_CONFIGUREPRONOUNCEMETHODRESULT:
   case sds_transcriptionservicefi_tclToken::EN_MSG_VOCONCOMPONENTINITIALIZEDMETHODRESULT:
   case sds_transcriptionservicefi_tclToken::EN_MSG_VOCONCOMPONENTUNINITIALIZEDMETHODRESULT:
   case sds_transcriptionservicefi_tclToken::EN_MSG_REINITIALIZEVOCONCOMPONENTMETHODSTART:
   case sds_transcriptionservicefi_tclToken::EN_MSG_REINITIALIZEVOCONCOMPONENTMETHODRESULT:
   case sds_transcriptionservicefi_tclToken::EN_MSG_RESUMECONTEXTUPDATEMETHODRESULT:
   case sds_transcriptionservicefi_tclToken::EN_MSG_INFORMPAUSESTATEMETHODSTART:
   case sds_transcriptionservicefi_tclToken::EN_MSG_INFORMPAUSESTATEMETHODRESULT:
   case sds_transcriptionservicefi_tclToken::EN_MSG_SETLANGUAGEMETHODRESULT:
   case sds_transcriptionservicefi_tclToken::EN_MSG_INFORMLANGUAGEMETHODRESULT:
   case sds_transcriptionservicefi_tclToken::EN_MSG_CREATETSRESOURCESMETHODRESULT:
   case sds_transcriptionservicefi_tclToken::EN_MSG_CLOSETSRESOURCESMETHODRESULT:
   case sds_transcriptionservicefi_tclToken::EN_MSG_RELEASEDATAMETHODSTART:
   case sds_transcriptionservicefi_tclToken::EN_MSG_RELEASEDATAMETHODRESULT:
   case sds_transcriptionservicefi_tclToken::EN_MSG_HANDLENEWDEVICEMETHODRESULT:
   case sds_transcriptionservicefi_tclToken::EN_MSG_CONFIRMVOCONACTIVITYSTOPMETHODRESULT:
   case sds_transcriptionservicefi_tclToken::EN_MSG_LANGUAGECHANGESUCCESSMETHODSTART:
   case sds_transcriptionservicefi_tclToken::EN_MSG_LANGUAGECHANGESUCCESSMETHODRESULT:
   case sds_transcriptionservicefi_tclToken::EN_MSG_TRACECMDPHONEUPDATEMETHODRESULT:
   case sds_transcriptionservicefi_tclToken::EN_MSG_TRACECMDMEDIAUPDATEMETHODRESULT:
   case sds_transcriptionservicefi_tclToken::EN_MSG_TRACECMDTUNERUPDATEMETHODRESULT:
   case sds_transcriptionservicefi_tclToken::EN_MSG_SETPHONEDBPATHMETHODRESULT:
   case sds_transcriptionservicefi_tclToken::EN_MSG_SETMEDIADBPATHMETHODRESULT:
   case sds_transcriptionservicefi_tclToken::EN_MSG_SETTUNERDBPATHMETHODRESULT:
   case sds_transcriptionservicefi_tclToken::EN_MSG_FREEEXCESSHEAPMEMORYMETHODSTART:
   case sds_transcriptionservicefi_tclToken::EN_MSG_FREEEXCESSHEAPMEMORYMETHODRESULT:
   case sds_transcriptionservicefi_tclToken::EN_MSG_LOGHEAPSTATUSMETHODRESULT:
   case sds_transcriptionservicefi_tclToken::EN_MSG_CREATECOUNTRYSTATELISTMETHODRESULT:
   case sds_transcriptionservicefi_tclToken::EN_MSG_CREATELISTCONTEXTMETHODRESULT:
   case sds_transcriptionservicefi_tclToken::EN_MSG_UPDATELISTCONTEXTPROPERTYMETHODRESULT:
   case sds_transcriptionservicefi_tclToken::EN_MSG_TSSTATUSGET:
   case sds_transcriptionservicefi_tclToken::EN_MSG_TSSTATUSUPREG:
   case sds_transcriptionservicefi_tclToken::EN_MSG_TSSTATUSRELUPREG:
   case sds_transcriptionservicefi_tclToken::EN_MSG_CONNECTEDDEVICESTATUSGET:
   case sds_transcriptionservicefi_tclToken::EN_MSG_CONNECTEDDEVICESTATUSUPREG:
   case sds_transcriptionservicefi_tclToken::EN_MSG_CONNECTEDDEVICESTATUSRELUPREG:
   case sds_transcriptionservicefi_tclToken::EN_MSG_DYNAMICDATASTATUSGET:
   case sds_transcriptionservicefi_tclToken::EN_MSG_DYNAMICDATASTATUSUPREG:
   case sds_transcriptionservicefi_tclToken::EN_MSG_DYNAMICDATASTATUSRELUPREG:
   case sds_transcriptionservicefi_tclToken::EN_MSG_CONTEXTOVERFLOWGET:
   case sds_transcriptionservicefi_tclToken::EN_MSG_CONTEXTOVERFLOWUPREG:
   case sds_transcriptionservicefi_tclToken::EN_MSG_CONTEXTOVERFLOWRELUPREG:
   case sds_transcriptionservicefi_tclToken::EN_MSG_TSVOCONCOMPONENTSSTATUSGET:
   case sds_transcriptionservicefi_tclToken::EN_MSG_TSVOCONCOMPONENTSSTATUSUPREG:
   case sds_transcriptionservicefi_tclToken::EN_MSG_TSVOCONCOMPONENTSSTATUSRELUPREG:
   case sds_transcriptionservicefi_tclToken::EN_MSG_LANGUAGEGET:
   case sds_transcriptionservicefi_tclToken::EN_MSG_LISTCONTEXTSTATUSGET:
   case sds_transcriptionservicefi_tclToken::EN_MSG_LISTCONTEXTSTATUSUPREG:
   case sds_transcriptionservicefi_tclToken::EN_MSG_LISTCONTEXTSTATUSRELUPREG:
   case sds_transcriptionservicefi_tclToken::EN_MSG_RECCTXLOADEDSTATUSGET:
   case sds_transcriptionservicefi_tclToken::EN_MSG_RECCTXLOADEDSTATUSUPREG:
   case sds_transcriptionservicefi_tclToken::EN_MSG_RECCTXLOADEDSTATUSRELUPREG:
   case sds_transcriptionservicefi_tclToken::EN_E8_VOCONCOMPONENTSTATUS:
   case sds_transcriptionservicefi_tclToken::EN_E16_ISOCOUNTRYCODE:
   case sds_transcriptionservicefi_tclToken::EN_E8_VOCONCOMPONENT:
   case sds_transcriptionservicefi_tclToken::EN_BINCONTAINER:
   case sds_transcriptionservicefi_tclToken::EN_E16_ISO639_3_SDSLANGUAGECODE:
   case sds_transcriptionservicefi_tclToken::EN_E8_SLOT:
   case sds_transcriptionservicefi_tclToken::EN_E8_DOMAIN:
   case sds_transcriptionservicefi_tclToken::EN_E8_CONNECTEDDEVICEUPDATESTATUS:
   case sds_transcriptionservicefi_tclToken::EN_E8_WORDTYPE:
   case sds_transcriptionservicefi_tclToken::EN_E8_NDSFEATURETYPE:
   case sds_transcriptionservicefi_tclToken::EN_SDSLANGUAGEID:
   case sds_transcriptionservicefi_tclToken::EN_CONNECTEDDEVICESTATUS:
   case sds_transcriptionservicefi_tclToken::EN_NDSID:
   case sds_transcriptionservicefi_tclToken::EN_STATEPHONEME:
   case sds_transcriptionservicefi_tclToken::EN_COUNTRYPHONEME:
   case sds_transcriptionservicefi_tclToken::EN_U64_TPVOID:
   case sds_transcriptionservicefi_tclToken::EN_E8_LISTTYPE:
   case sds_transcriptionservicefi_tclToken::EN_SDSIDTRANSCRIPTIONSENTRY:
   case sds_transcriptionservicefi_tclToken::EN_E8_TSSTATUS:
   case sds_transcriptionservicefi_tclToken::EN_E8_DEVICECONTEXTSTATUS:
   case sds_transcriptionservicefi_tclToken::EN_E8_DYNAMICDATASTATUS:
   case sds_transcriptionservicefi_tclToken::EN_E8_CONTEXTUPDATESTATUS:
   case sds_transcriptionservicefi_tclToken::EN_WORDTRANSMAP:
   case sds_transcriptionservicefi_tclToken::EN_DYNAMICDATASTATUS:
   case sds_transcriptionservicefi_tclToken::EN_E8_DEVICECONTEXTAVAILABILITY:
   case sds_transcriptionservicefi_tclToken::EN_CONTEXTOVERFLOWSTATUS:
   case sds_transcriptionservicefi_tclToken::EN_WORDSLOT:
   case sds_transcriptionservicefi_tclToken::EN_WORDTRANSSLOT:
   case sds_transcriptionservicefi_tclToken::EN_WORDINFO:
   case sds_transcriptionservicefi_tclToken::EN_LISTENTRIES:
   case sds_transcriptionservicefi_tclToken::EN_LISTCONTEXTSTATUS:
   case sds_transcriptionservicefi_tclToken::EN_WORDPHONEMEMAP:
   case sds_transcriptionservicefi_tclToken::EN_U8:   
   case sds_transcriptionservicefi_tclToken::EN_S8:   
   case sds_transcriptionservicefi_tclToken::EN_U16:   
   case sds_transcriptionservicefi_tclToken::EN_S16:   
   case sds_transcriptionservicefi_tclToken::EN_U24:   
   case sds_transcriptionservicefi_tclToken::EN_S24:   
   case sds_transcriptionservicefi_tclToken::EN_U32:   
   case sds_transcriptionservicefi_tclToken::EN_S32:   
   case sds_transcriptionservicefi_tclToken::EN_U64:   
   case sds_transcriptionservicefi_tclToken::EN_S64:   
   case sds_transcriptionservicefi_tclToken::EN_F32:   
   case sds_transcriptionservicefi_tclToken::EN_F64:   
   case sds_transcriptionservicefi_tclToken::EN_BOOL:   
   case sds_transcriptionservicefi_tclToken::EN_STRING:   
   case sds_transcriptionservicefi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(enMsgToken,sds_transcriptionservicefi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool sds_transcriptionservicefi_tclDescription::bDoIt(sds_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool sds_transcriptionservicefi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      sds_transcriptionservicefi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      sds_transcriptionservicefi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      sds_transcriptionservicefi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == sds_transcriptionservicefi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(sds_transcriptionservicefi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case sds_transcriptionservicefi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == sds_transcriptionservicefi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case sds_transcriptionservicefi_tclToken::EN_LIST: 
      {
         sds_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            sds_transcriptionservicefi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            sds_transcriptionservicefi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case sds_transcriptionservicefi_tclToken::EN_U8: 
      {
         sds_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case sds_transcriptionservicefi_tclToken::EN_U16: 
      {
         sds_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_transcriptionservicefi_tclToken::EN_U24: 
      {
         sds_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_transcriptionservicefi_tclToken::EN_U32: 
      {
         sds_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_transcriptionservicefi_tclToken::EN_U64: 
      {
         sds_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_transcriptionservicefi_tclToken::EN_S8: 
      {
         sds_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_transcriptionservicefi_tclToken::EN_S16: 
      {
         sds_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_transcriptionservicefi_tclToken::EN_S24: 
      {
         sds_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_transcriptionservicefi_tclToken::EN_S32: 
      {
         sds_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_transcriptionservicefi_tclToken::EN_S64: 
      {
         sds_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_transcriptionservicefi_tclToken::EN_F32: 
      {
         sds_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_transcriptionservicefi_tclToken::EN_F64: 
      {
         sds_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_transcriptionservicefi_tclToken::EN_BOOL: 
      {
         sds_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_transcriptionservicefi_tclToken::EN_STRING: 
      {
         sds_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_transcriptionservicefi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         sds_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case sds_transcriptionservicefi_tclToken::EN_MSG_GETTRANSCRIPTIONSMETHODSTART:
      case sds_transcriptionservicefi_tclToken::EN_MSG_GETTRANSCRIPTIONSMETHODRESULT:
      case sds_transcriptionservicefi_tclToken::EN_MSG_DOUPREGTOPROPERTIESMETHODSTART:
      case sds_transcriptionservicefi_tclToken::EN_MSG_DOUPREGTOPROPERTIESMETHODRESULT:
      case sds_transcriptionservicefi_tclToken::EN_MSG_CONFIGUREPRONOUNCEMETHODSTART:
      case sds_transcriptionservicefi_tclToken::EN_MSG_CONFIGUREPRONOUNCEMETHODRESULT:
      case sds_transcriptionservicefi_tclToken::EN_MSG_VOCONCOMPONENTINITIALIZEDMETHODSTART:
      case sds_transcriptionservicefi_tclToken::EN_MSG_VOCONCOMPONENTINITIALIZEDMETHODRESULT:
      case sds_transcriptionservicefi_tclToken::EN_MSG_VOCONCOMPONENTUNINITIALIZEDMETHODSTART:
      case sds_transcriptionservicefi_tclToken::EN_MSG_VOCONCOMPONENTUNINITIALIZEDMETHODRESULT:
      case sds_transcriptionservicefi_tclToken::EN_MSG_REINITIALIZEVOCONCOMPONENTMETHODSTART:
      case sds_transcriptionservicefi_tclToken::EN_MSG_REINITIALIZEVOCONCOMPONENTMETHODRESULT:
      case sds_transcriptionservicefi_tclToken::EN_MSG_RESUMECONTEXTUPDATEMETHODSTART:
      case sds_transcriptionservicefi_tclToken::EN_MSG_RESUMECONTEXTUPDATEMETHODRESULT:
      case sds_transcriptionservicefi_tclToken::EN_MSG_INFORMPAUSESTATEMETHODSTART:
      case sds_transcriptionservicefi_tclToken::EN_MSG_INFORMPAUSESTATEMETHODRESULT:
      case sds_transcriptionservicefi_tclToken::EN_MSG_SETLANGUAGEMETHODSTART:
      case sds_transcriptionservicefi_tclToken::EN_MSG_SETLANGUAGEMETHODRESULT:
      case sds_transcriptionservicefi_tclToken::EN_MSG_INFORMLANGUAGEMETHODSTART:
      case sds_transcriptionservicefi_tclToken::EN_MSG_INFORMLANGUAGEMETHODRESULT:
      case sds_transcriptionservicefi_tclToken::EN_MSG_CREATETSRESOURCESMETHODSTART:
      case sds_transcriptionservicefi_tclToken::EN_MSG_CREATETSRESOURCESMETHODRESULT:
      case sds_transcriptionservicefi_tclToken::EN_MSG_CLOSETSRESOURCESMETHODSTART:
      case sds_transcriptionservicefi_tclToken::EN_MSG_CLOSETSRESOURCESMETHODRESULT:
      case sds_transcriptionservicefi_tclToken::EN_MSG_GETTRANSCRIPTIONSTTSMETHODSTART:
      case sds_transcriptionservicefi_tclToken::EN_MSG_GETTRANSCRIPTIONSTTSMETHODRESULT:
      case sds_transcriptionservicefi_tclToken::EN_MSG_RELEASEDATAMETHODSTART:
      case sds_transcriptionservicefi_tclToken::EN_MSG_RELEASEDATAMETHODRESULT:
      case sds_transcriptionservicefi_tclToken::EN_MSG_HANDLENEWDEVICEMETHODSTART:
      case sds_transcriptionservicefi_tclToken::EN_MSG_HANDLENEWDEVICEMETHODRESULT:
      case sds_transcriptionservicefi_tclToken::EN_MSG_CONFIRMVOCONACTIVITYSTOPMETHODSTART:
      case sds_transcriptionservicefi_tclToken::EN_MSG_CONFIRMVOCONACTIVITYSTOPMETHODRESULT:
      case sds_transcriptionservicefi_tclToken::EN_MSG_LANGUAGECHANGESUCCESSMETHODSTART:
      case sds_transcriptionservicefi_tclToken::EN_MSG_LANGUAGECHANGESUCCESSMETHODRESULT:
      case sds_transcriptionservicefi_tclToken::EN_MSG_GETTRANSCRIPTIONSFORLISTMETHODSTART:
      case sds_transcriptionservicefi_tclToken::EN_MSG_GETTRANSCRIPTIONSFORLISTMETHODRESULT:
      case sds_transcriptionservicefi_tclToken::EN_MSG_TRACECMDPHONEUPDATEMETHODSTART:
      case sds_transcriptionservicefi_tclToken::EN_MSG_TRACECMDPHONEUPDATEMETHODRESULT:
      case sds_transcriptionservicefi_tclToken::EN_MSG_TRACECMDMEDIAUPDATEMETHODSTART:
      case sds_transcriptionservicefi_tclToken::EN_MSG_TRACECMDMEDIAUPDATEMETHODRESULT:
      case sds_transcriptionservicefi_tclToken::EN_MSG_TRACECMDTUNERUPDATEMETHODSTART:
      case sds_transcriptionservicefi_tclToken::EN_MSG_TRACECMDTUNERUPDATEMETHODRESULT:
      case sds_transcriptionservicefi_tclToken::EN_MSG_SETPHONEDBPATHMETHODSTART:
      case sds_transcriptionservicefi_tclToken::EN_MSG_SETPHONEDBPATHMETHODRESULT:
      case sds_transcriptionservicefi_tclToken::EN_MSG_SETMEDIADBPATHMETHODSTART:
      case sds_transcriptionservicefi_tclToken::EN_MSG_SETMEDIADBPATHMETHODRESULT:
      case sds_transcriptionservicefi_tclToken::EN_MSG_SETTUNERDBPATHMETHODSTART:
      case sds_transcriptionservicefi_tclToken::EN_MSG_SETTUNERDBPATHMETHODRESULT:
      case sds_transcriptionservicefi_tclToken::EN_MSG_FREEEXCESSHEAPMEMORYMETHODSTART:
      case sds_transcriptionservicefi_tclToken::EN_MSG_FREEEXCESSHEAPMEMORYMETHODRESULT:
      case sds_transcriptionservicefi_tclToken::EN_MSG_LOGHEAPSTATUSMETHODSTART:
      case sds_transcriptionservicefi_tclToken::EN_MSG_LOGHEAPSTATUSMETHODRESULT:
      case sds_transcriptionservicefi_tclToken::EN_MSG_CREATECOUNTRYSTATELISTMETHODSTART:
      case sds_transcriptionservicefi_tclToken::EN_MSG_CREATECOUNTRYSTATELISTMETHODRESULT:
      case sds_transcriptionservicefi_tclToken::EN_MSG_CREATELISTCONTEXTMETHODSTART:
      case sds_transcriptionservicefi_tclToken::EN_MSG_CREATELISTCONTEXTMETHODRESULT:
      case sds_transcriptionservicefi_tclToken::EN_MSG_UPDATELISTCONTEXTPROPERTYMETHODSTART:
      case sds_transcriptionservicefi_tclToken::EN_MSG_UPDATELISTCONTEXTPROPERTYMETHODRESULT:
      case sds_transcriptionservicefi_tclToken::EN_MSG_TSSTATUSGET:
      case sds_transcriptionservicefi_tclToken::EN_MSG_TSSTATUSUPREG:
      case sds_transcriptionservicefi_tclToken::EN_MSG_TSSTATUSRELUPREG:
      case sds_transcriptionservicefi_tclToken::EN_MSG_TSSTATUSSTATUS:
      case sds_transcriptionservicefi_tclToken::EN_MSG_CONNECTEDDEVICESTATUSGET:
      case sds_transcriptionservicefi_tclToken::EN_MSG_CONNECTEDDEVICESTATUSUPREG:
      case sds_transcriptionservicefi_tclToken::EN_MSG_CONNECTEDDEVICESTATUSRELUPREG:
      case sds_transcriptionservicefi_tclToken::EN_MSG_CONNECTEDDEVICESTATUSSTATUS:
      case sds_transcriptionservicefi_tclToken::EN_MSG_DYNAMICDATASTATUSGET:
      case sds_transcriptionservicefi_tclToken::EN_MSG_DYNAMICDATASTATUSUPREG:
      case sds_transcriptionservicefi_tclToken::EN_MSG_DYNAMICDATASTATUSRELUPREG:
      case sds_transcriptionservicefi_tclToken::EN_MSG_DYNAMICDATASTATUSSTATUS:
      case sds_transcriptionservicefi_tclToken::EN_MSG_CONTEXTOVERFLOWGET:
      case sds_transcriptionservicefi_tclToken::EN_MSG_CONTEXTOVERFLOWUPREG:
      case sds_transcriptionservicefi_tclToken::EN_MSG_CONTEXTOVERFLOWRELUPREG:
      case sds_transcriptionservicefi_tclToken::EN_MSG_CONTEXTOVERFLOWSTATUS:
      case sds_transcriptionservicefi_tclToken::EN_MSG_TSVOCONCOMPONENTSSTATUSGET:
      case sds_transcriptionservicefi_tclToken::EN_MSG_TSVOCONCOMPONENTSSTATUSUPREG:
      case sds_transcriptionservicefi_tclToken::EN_MSG_TSVOCONCOMPONENTSSTATUSRELUPREG:
      case sds_transcriptionservicefi_tclToken::EN_MSG_TSVOCONCOMPONENTSSTATUSSTATUS:
      case sds_transcriptionservicefi_tclToken::EN_MSG_LANGUAGEGET:
      case sds_transcriptionservicefi_tclToken::EN_MSG_LANGUAGESTATUS:
      case sds_transcriptionservicefi_tclToken::EN_MSG_LISTCONTEXTSTATUSGET:
      case sds_transcriptionservicefi_tclToken::EN_MSG_LISTCONTEXTSTATUSUPREG:
      case sds_transcriptionservicefi_tclToken::EN_MSG_LISTCONTEXTSTATUSRELUPREG:
      case sds_transcriptionservicefi_tclToken::EN_MSG_LISTCONTEXTSTATUSSTATUS:
      case sds_transcriptionservicefi_tclToken::EN_MSG_RECCTXLOADEDSTATUSGET:
      case sds_transcriptionservicefi_tclToken::EN_MSG_RECCTXLOADEDSTATUSUPREG:
      case sds_transcriptionservicefi_tclToken::EN_MSG_RECCTXLOADEDSTATUSRELUPREG:
      case sds_transcriptionservicefi_tclToken::EN_MSG_RECCTXLOADEDSTATUSSET:
      case sds_transcriptionservicefi_tclToken::EN_MSG_RECCTXLOADEDSTATUSSTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case sds_transcriptionservicefi_tclToken::EN_E8_VOCONCOMPONENTSTATUS:
      {
         sds_fi_tcl_e8_VoconComponentStatus o_e8_VoconComponentStatus;
         if (!bDoIt(o_e8_VoconComponentStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_transcriptionservicefi_tclToken::EN_E16_ISOCOUNTRYCODE:
      {
         sds_fi_tcl_e16_ISOCountryCode o_e16_ISOCountryCode;
         if (!bDoIt(o_e16_ISOCountryCode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_transcriptionservicefi_tclToken::EN_E8_VOCONCOMPONENT:
      {
         sds_fi_tcl_e8_VoconComponent o_e8_VoconComponent;
         if (!bDoIt(o_e8_VoconComponent))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_transcriptionservicefi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_END_OF_STRUCT,sds_transcriptionservicefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_U8,sds_transcriptionservicefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LIST,sds_transcriptionservicefi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         sds_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_transcriptionservicefi_tclToken::EN_E16_ISO639_3_SDSLANGUAGECODE:
      {
         sds_fi_tcl_e16_ISO639_3_SDSLanguageCode o_e16_ISO639_3_SDSLanguageCode;
         if (!bDoIt(o_e16_ISO639_3_SDSLanguageCode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_transcriptionservicefi_tclToken::EN_E8_SLOT:
      {
         sds_fi_tcl_e8_Slot o_e8_Slot;
         if (!bDoIt(o_e8_Slot))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_transcriptionservicefi_tclToken::EN_E8_DOMAIN:
      {
         sds_fi_tcl_e8_Domain o_e8_Domain;
         if (!bDoIt(o_e8_Domain))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_transcriptionservicefi_tclToken::EN_E8_CONNECTEDDEVICEUPDATESTATUS:
      {
         sds_fi_tcl_e8_ConnectedDeviceUpdateStatus o_e8_ConnectedDeviceUpdateStatus;
         if (!bDoIt(o_e8_ConnectedDeviceUpdateStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_transcriptionservicefi_tclToken::EN_E8_WORDTYPE:
      {
         sds_fi_tcl_e8_WordType o_e8_WordType;
         if (!bDoIt(o_e8_WordType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_transcriptionservicefi_tclToken::EN_E8_NDSFEATURETYPE:
      {
         sds_fi_tcl_e8_NDSFeatureType o_e8_NDSFeatureType;
         if (!bDoIt(o_e8_NDSFeatureType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_transcriptionservicefi_tclToken::EN_SDSLANGUAGEID:
      {
      if (poVisitor->bDoExpand_SDSLanguageID(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_END_OF_STRUCT,sds_transcriptionservicefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E16_ISOCOUNTRYCODE,sds_transcriptionservicefi_tclSemanticDomain::EN_ISO3166_COUNTRYCODE));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E16_ISO639_3_SDSLANGUAGECODE,sds_transcriptionservicefi_tclSemanticDomain::EN_ISO639_3_SDSLANGUAGECODE));
      }
      else
      {
         sds_fi_tcl_SDSLanguageID o_SDSLanguageID;
         if (!bDoIt(o_SDSLanguageID))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SDSLanguageID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SDSLanguageID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_transcriptionservicefi_tclToken::EN_CONNECTEDDEVICESTATUS:
      {
      if (poVisitor->bDoExpand_ConnectedDeviceStatus(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_END_OF_STRUCT,sds_transcriptionservicefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_CONNECTEDDEVICEUPDATESTATUS,sds_transcriptionservicefi_tclSemanticDomain::EN_UPDATESTATUS));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_DOMAIN,sds_transcriptionservicefi_tclSemanticDomain::EN_TENDOMAIN));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_U32,sds_transcriptionservicefi_tclSemanticDomain::EN_U32DEVICEID));
      }
      else
      {
         sds_fi_tcl_ConnectedDeviceStatus o_ConnectedDeviceStatus;
         if (!bDoIt(o_ConnectedDeviceStatus))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ConnectedDeviceStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ConnectedDeviceStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_transcriptionservicefi_tclToken::EN_NDSID:
      {
      if (poVisitor->bDoExpand_NDSID(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_END_OF_STRUCT,sds_transcriptionservicefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_U32,sds_transcriptionservicefi_tclSemanticDomain::EN_GLOBALXREFID));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_U64,sds_transcriptionservicefi_tclSemanticDomain::EN_POIROOTREGIONID));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_NDSFEATURETYPE,sds_transcriptionservicefi_tclSemanticDomain::EN_ENDSFEATURETYPE));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_U32,sds_transcriptionservicefi_tclSemanticDomain::EN_U32NDSID));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_U8,sds_transcriptionservicefi_tclSemanticDomain::EN_U8SUPPLIERID));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_U32,sds_transcriptionservicefi_tclSemanticDomain::EN_U32PRODUCTID));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_U16,sds_transcriptionservicefi_tclSemanticDomain::EN_U16UPDATEREGIONID));
      }
      else
      {
         sds_fi_tcl_NDSID o_NDSID;
         if (!bDoIt(o_NDSID))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NDSID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NDSID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_transcriptionservicefi_tclToken::EN_STATEPHONEME:
      {
      if (poVisitor->bDoExpand_StatePhoneme(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_END_OF_STRUCT,sds_transcriptionservicefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_STRING,sds_transcriptionservicefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LIST,sds_transcriptionservicefi_tclSemanticDomain::EN_ORTHOGRAPHYLIST));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_STRING,sds_transcriptionservicefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LIST,sds_transcriptionservicefi_tclSemanticDomain::EN_PHONEMELIST));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_NDSID,sds_transcriptionservicefi_tclSemanticDomain::EN_STATEID));
      }
      else
      {
         sds_fi_tcl_StatePhoneme o_StatePhoneme;
         if (!bDoIt(o_StatePhoneme))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StatePhoneme.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StatePhoneme.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_transcriptionservicefi_tclToken::EN_COUNTRYPHONEME:
      {
      if (poVisitor->bDoExpand_CountryPhoneme(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_END_OF_STRUCT,sds_transcriptionservicefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E16_ISOCOUNTRYCODE,sds_transcriptionservicefi_tclSemanticDomain::EN_COUNTRYCODE));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_STATEPHONEME,sds_transcriptionservicefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LIST,sds_transcriptionservicefi_tclSemanticDomain::EN_STATELIST));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_STRING,sds_transcriptionservicefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LIST,sds_transcriptionservicefi_tclSemanticDomain::EN_ORTHOGRAPHYLIST));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_STRING,sds_transcriptionservicefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LIST,sds_transcriptionservicefi_tclSemanticDomain::EN_PHONEMELIST));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_NDSID,sds_transcriptionservicefi_tclSemanticDomain::EN_COUNTRYID));
      }
      else
      {
         sds_fi_tcl_CountryPhoneme o_CountryPhoneme;
         if (!bDoIt(o_CountryPhoneme))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountryPhoneme.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_CountryPhoneme.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_transcriptionservicefi_tclToken::EN_U64_TPVOID:
      {
         sds_fi_tcl_u64_tPVoid o_u64_tPVoid;
         if (!bDoIt(o_u64_tPVoid))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_transcriptionservicefi_tclToken::EN_E8_LISTTYPE:
      {
         sds_fi_tcl_e8_ListType o_e8_ListType;
         if (!bDoIt(o_e8_ListType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_transcriptionservicefi_tclToken::EN_SDSIDTRANSCRIPTIONSENTRY:
      {
      if (poVisitor->bDoExpand_SDSIDTranscriptionsEntry(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_END_OF_STRUCT,sds_transcriptionservicefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_STRING,sds_transcriptionservicefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LIST,sds_transcriptionservicefi_tclSemanticDomain::EN_ARRTRANSCRIPTIONS));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_U32,sds_transcriptionservicefi_tclSemanticDomain::EN_U32WORDUSERID));
      }
      else
      {
         sds_fi_tcl_SDSIDTranscriptionsEntry o_SDSIDTranscriptionsEntry;
         if (!bDoIt(o_SDSIDTranscriptionsEntry))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SDSIDTranscriptionsEntry.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SDSIDTranscriptionsEntry.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_transcriptionservicefi_tclToken::EN_E8_TSSTATUS:
      {
         sds_fi_tcl_e8_TSStatus o_e8_TSStatus;
         if (!bDoIt(o_e8_TSStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_transcriptionservicefi_tclToken::EN_E8_DEVICECONTEXTSTATUS:
      {
         sds_fi_tcl_e8_DeviceContextStatus o_e8_DeviceContextStatus;
         if (!bDoIt(o_e8_DeviceContextStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_transcriptionservicefi_tclToken::EN_E8_DYNAMICDATASTATUS:
      {
         sds_fi_tcl_e8_DynamicDataStatus o_e8_DynamicDataStatus;
         if (!bDoIt(o_e8_DynamicDataStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_transcriptionservicefi_tclToken::EN_E8_CONTEXTUPDATESTATUS:
      {
         sds_fi_tcl_e8_ContextUpdateStatus o_e8_ContextUpdateStatus;
         if (!bDoIt(o_e8_ContextUpdateStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_transcriptionservicefi_tclToken::EN_WORDTRANSMAP:
      {
      if (poVisitor->bDoExpand_WordTransMap(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_END_OF_STRUCT,sds_transcriptionservicefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_STRING,sds_transcriptionservicefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LIST,sds_transcriptionservicefi_tclSemanticDomain::EN_TRANSCRIPTIONS));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_STRING,sds_transcriptionservicefi_tclSemanticDomain::EN_WORD));
      }
      else
      {
         sds_fi_tcl_WordTransMap o_WordTransMap;
         if (!bDoIt(o_WordTransMap))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WordTransMap.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WordTransMap.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_transcriptionservicefi_tclToken::EN_DYNAMICDATASTATUS:
      {
      if (poVisitor->bDoExpand_DynamicDataStatus(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_END_OF_STRUCT,sds_transcriptionservicefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_DYNAMICDATASTATUS,sds_transcriptionservicefi_tclSemanticDomain::EN_DYNAMICDATASTATUS));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_DOMAIN,sds_transcriptionservicefi_tclSemanticDomain::EN_TENDOMAIN));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_U32,sds_transcriptionservicefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LIST,sds_transcriptionservicefi_tclSemanticDomain::EN_PAGENUMBERS));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_U32,sds_transcriptionservicefi_tclSemanticDomain::EN_U32DEVICEID));
      }
      else
      {
         sds_fi_tcl_DynamicDataStatus o_DynamicDataStatus;
         if (!bDoIt(o_DynamicDataStatus))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DynamicDataStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DynamicDataStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_transcriptionservicefi_tclToken::EN_E8_DEVICECONTEXTAVAILABILITY:
      {
      if (poVisitor->bDoExpand_e8_DeviceContextAvailability(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_END_OF_STRUCT,sds_transcriptionservicefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_DEVICECONTEXTSTATUS,sds_transcriptionservicefi_tclSemanticDomain::EN_DEVICECONTEXTSTAUS));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_DYNAMICDATASTATUS,sds_transcriptionservicefi_tclSemanticDomain::EN_DYNAMICDATASTATUS));
      }
      else
      {
         sds_fi_tcl_e8_DeviceContextAvailability o_e8_DeviceContextAvailability;
         if (!bDoIt(o_e8_DeviceContextAvailability))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_e8_DeviceContextAvailability.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_e8_DeviceContextAvailability.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_transcriptionservicefi_tclToken::EN_CONTEXTOVERFLOWSTATUS:
      {
      if (poVisitor->bDoExpand_ContextOverFlowStatus(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_END_OF_STRUCT,sds_transcriptionservicefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_BOOL,sds_transcriptionservicefi_tclSemanticDomain::EN_CONTEXTOVERFLOW));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_U32,sds_transcriptionservicefi_tclSemanticDomain::EN_U32DEVICEID));
      }
      else
      {
         sds_fi_tcl_ContextOverFlowStatus o_ContextOverFlowStatus;
         if (!bDoIt(o_ContextOverFlowStatus))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ContextOverFlowStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ContextOverFlowStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_transcriptionservicefi_tclToken::EN_WORDSLOT:
      {
      if (poVisitor->bDoExpand_WordSlot(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_END_OF_STRUCT,sds_transcriptionservicefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_SLOT,sds_transcriptionservicefi_tclSemanticDomain::EN_E8SLOT));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_STRING,sds_transcriptionservicefi_tclSemanticDomain::EN_SZWORD));
      }
      else
      {
         sds_fi_tcl_WordSlot o_WordSlot;
         if (!bDoIt(o_WordSlot))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WordSlot.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WordSlot.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_transcriptionservicefi_tclToken::EN_WORDTRANSSLOT:
      {
      if (poVisitor->bDoExpand_WordTransSlot(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_END_OF_STRUCT,sds_transcriptionservicefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_SLOT,sds_transcriptionservicefi_tclSemanticDomain::EN_E8SLOT));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_WORDTRANSMAP,sds_transcriptionservicefi_tclSemanticDomain::EN_STWORDTRANS));
      }
      else
      {
         sds_fi_tcl_WordTransSlot o_WordTransSlot;
         if (!bDoIt(o_WordTransSlot))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WordTransSlot.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WordTransSlot.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_transcriptionservicefi_tclToken::EN_WORDINFO:
      {
      if (poVisitor->bDoExpand_WordInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_END_OF_STRUCT,sds_transcriptionservicefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_STRING,sds_transcriptionservicefi_tclSemanticDomain::EN_SZPHONEME));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_STRING,sds_transcriptionservicefi_tclSemanticDomain::EN_SZWORD));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_NDSID,sds_transcriptionservicefi_tclSemanticDomain::EN_NDSID));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_WORDTYPE,sds_transcriptionservicefi_tclSemanticDomain::EN_E8WORDTYPE));
      }
      else
      {
         sds_fi_tcl_WordInfo o_WordInfo;
         if (!bDoIt(o_WordInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WordInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WordInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_transcriptionservicefi_tclToken::EN_LISTENTRIES:
      {
      if (poVisitor->bDoExpand_ListEntries(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_END_OF_STRUCT,sds_transcriptionservicefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_WORDINFO,sds_transcriptionservicefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_LIST,sds_transcriptionservicefi_tclSemanticDomain::EN_WORDINFO));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_U32,sds_transcriptionservicefi_tclSemanticDomain::EN_U32LISTELEMENTID));
      }
      else
      {
         sds_fi_tcl_ListEntries o_ListEntries;
         if (!bDoIt(o_ListEntries))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ListEntries.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ListEntries.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_transcriptionservicefi_tclToken::EN_LISTCONTEXTSTATUS:
      {
      if (poVisitor->bDoExpand_ListContextStatus(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_END_OF_STRUCT,sds_transcriptionservicefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_CONTEXTUPDATESTATUS,sds_transcriptionservicefi_tclSemanticDomain::EN_E8STATUS));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_WORDTYPE,sds_transcriptionservicefi_tclSemanticDomain::EN_E8WORDTYPE));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_E8_DOMAIN,sds_transcriptionservicefi_tclSemanticDomain::EN_E8DOMAIN));
      }
      else
      {
         sds_fi_tcl_ListContextStatus o_ListContextStatus;
         if (!bDoIt(o_ListContextStatus))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ListContextStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ListContextStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_transcriptionservicefi_tclToken::EN_WORDPHONEMEMAP:
      {
      if (poVisitor->bDoExpand_WordPhonemeMap(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_END_OF_STRUCT,sds_transcriptionservicefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_WORDTRANSMAP,sds_transcriptionservicefi_tclSemanticDomain::EN_STWORDTRANSMAP));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_NDSID,sds_transcriptionservicefi_tclSemanticDomain::EN_TWORDID));
         (tVoid) oPath.bGoDown(sds_transcriptionservicefi_tclKnot(sds_transcriptionservicefi_tclToken::EN_U32,sds_transcriptionservicefi_tclSemanticDomain::EN_U32WORDID));
      }
      else
      {
         sds_fi_tcl_WordPhonemeMap o_WordPhonemeMap;
         if (!bDoIt(o_WordPhonemeMap))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WordPhonemeMap.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WordPhonemeMap.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_transcriptionservicefi_tclToken::EN_UNKNOWN:
      case sds_transcriptionservicefi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

