#ifndef __SDS_TRANSCRIPTIONSERVICEFIDEBUGVISITOR_H__
#define __SDS_TRANSCRIPTIONSERVICEFIDEBUGVISITOR_H__

class MY_DECL sds_transcriptionservicefi_tclPrintVisitor : public sds_transcriptionservicefi_tclVisitorBase {

private:
   /* default constructor */ sds_transcriptionservicefi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   sds_transcriptionservicefi_tclPrintVisitor(sds_fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(sds_fi_tclU8& oU8);
   virtual tVoid vVisitS8(sds_fi_tclS8& oS8);
   virtual tVoid vVisitU16(sds_fi_tclU16& oU16);
   virtual tVoid vVisitS16(sds_fi_tclS16& oS16);
   virtual tVoid vVisitU24(sds_fi_tclU24& oU24);
   virtual tVoid vVisitS24(sds_fi_tclS24& oS24);
   virtual tVoid vVisitU32(sds_fi_tclU32& oU32);
   virtual tVoid vVisitS32(sds_fi_tclS32& oS32);
   virtual tVoid vVisitU64(sds_fi_tclU64& oU64);
   virtual tVoid vVisitS64(sds_fi_tclS64& oS64);
   virtual tVoid vVisitBool(sds_fi_tclBool& oBool);
   virtual tVoid vVisitString(sds_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(sds_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(sds_fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tVoid vVisit_e8_VoconComponentStatus(sds_fi_tcl_e8_VoconComponentStatus& o_e8_VoconComponentStatus);
   virtual tVoid vVisit_e16_ISOCountryCode(sds_fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_e8_VoconComponent(sds_fi_tcl_e8_VoconComponent& o_e8_VoconComponent);
   virtual tBool bDoExpand_BinContainer(sds_transcriptionservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e16_ISO639_3_SDSLanguageCode(sds_fi_tcl_e16_ISO639_3_SDSLanguageCode& o_e16_ISO639_3_SDSLanguageCode);
   virtual tVoid vVisit_e8_Slot(sds_fi_tcl_e8_Slot& o_e8_Slot);
   virtual tVoid vVisit_e8_Domain(sds_fi_tcl_e8_Domain& o_e8_Domain);
   virtual tVoid vVisit_e8_ConnectedDeviceUpdateStatus(sds_fi_tcl_e8_ConnectedDeviceUpdateStatus& o_e8_ConnectedDeviceUpdateStatus);
   virtual tVoid vVisit_e8_WordType(sds_fi_tcl_e8_WordType& o_e8_WordType);
   virtual tVoid vVisit_e8_NDSFeatureType(sds_fi_tcl_e8_NDSFeatureType& o_e8_NDSFeatureType);
   virtual tBool bDoExpand_SDSLanguageID(sds_transcriptionservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ConnectedDeviceStatus(sds_transcriptionservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NDSID(sds_transcriptionservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StatePhoneme(sds_transcriptionservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CountryPhoneme(sds_transcriptionservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u64_tPVoid(sds_fi_tcl_u64_tPVoid& o_u64_tPVoid);
   virtual tVoid vVisit_e8_ListType(sds_fi_tcl_e8_ListType& o_e8_ListType);
   virtual tBool bDoExpand_SDSIDTranscriptionsEntry(sds_transcriptionservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_TSStatus(sds_fi_tcl_e8_TSStatus& o_e8_TSStatus);
   virtual tVoid vVisit_e8_DeviceContextStatus(sds_fi_tcl_e8_DeviceContextStatus& o_e8_DeviceContextStatus);
   virtual tVoid vVisit_e8_DynamicDataStatus(sds_fi_tcl_e8_DynamicDataStatus& o_e8_DynamicDataStatus);
   virtual tVoid vVisit_e8_ContextUpdateStatus(sds_fi_tcl_e8_ContextUpdateStatus& o_e8_ContextUpdateStatus);
   virtual tBool bDoExpand_WordTransMap(sds_transcriptionservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DynamicDataStatus(sds_transcriptionservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_e8_DeviceContextAvailability(sds_transcriptionservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ContextOverFlowStatus(sds_transcriptionservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_WordSlot(sds_transcriptionservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_WordTransSlot(sds_transcriptionservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_WordInfo(sds_transcriptionservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ListEntries(sds_transcriptionservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ListContextStatus(sds_transcriptionservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_WordPhonemeMap(sds_transcriptionservicefi_tclSemanticDomain::tenType enSemantic);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   sds_fi_tclOutput* poOutput;
};


class MY_DECL sds_transcriptionservicefi_tclRandomInitVisitor : public sds_transcriptionservicefi_tclVisitorBase {
public:

   sds_transcriptionservicefi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(sds_fi_tclU8& oU8);
   virtual tVoid vVisitS8(sds_fi_tclS8& oS8);
   virtual tVoid vVisitU16(sds_fi_tclU16& oU16);
   virtual tVoid vVisitS16(sds_fi_tclS16& oS16);
   virtual tVoid vVisitU24(sds_fi_tclU24& oU24);
   virtual tVoid vVisitS24(sds_fi_tclS24& oS24);
   virtual tVoid vVisitU32(sds_fi_tclU32& oU32);
   virtual tVoid vVisitS32(sds_fi_tclS32& oS32);
   virtual tVoid vVisitU64(sds_fi_tclU64& oU64);
   virtual tVoid vVisitS64(sds_fi_tclS64& oS64);
   virtual tVoid vVisitBool(sds_fi_tclBool& oBool);
   virtual tVoid vVisitString(sds_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(sds_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(sds_fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_e8_VoconComponentStatus(sds_fi_tcl_e8_VoconComponentStatus& o_e8_VoconComponentStatus);
   virtual tVoid vVisit_e16_ISOCountryCode(sds_fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_e8_VoconComponent(sds_fi_tcl_e8_VoconComponent& o_e8_VoconComponent);
   virtual tVoid vVisit_e16_ISO639_3_SDSLanguageCode(sds_fi_tcl_e16_ISO639_3_SDSLanguageCode& o_e16_ISO639_3_SDSLanguageCode);
   virtual tVoid vVisit_e8_Slot(sds_fi_tcl_e8_Slot& o_e8_Slot);
   virtual tVoid vVisit_e8_Domain(sds_fi_tcl_e8_Domain& o_e8_Domain);
   virtual tVoid vVisit_e8_ConnectedDeviceUpdateStatus(sds_fi_tcl_e8_ConnectedDeviceUpdateStatus& o_e8_ConnectedDeviceUpdateStatus);
   virtual tVoid vVisit_e8_WordType(sds_fi_tcl_e8_WordType& o_e8_WordType);
   virtual tVoid vVisit_e8_NDSFeatureType(sds_fi_tcl_e8_NDSFeatureType& o_e8_NDSFeatureType);
   virtual tVoid vVisit_u64_tPVoid(sds_fi_tcl_u64_tPVoid& o_u64_tPVoid);
   virtual tVoid vVisit_e8_ListType(sds_fi_tcl_e8_ListType& o_e8_ListType);
   virtual tVoid vVisit_e8_TSStatus(sds_fi_tcl_e8_TSStatus& o_e8_TSStatus);
   virtual tVoid vVisit_e8_DeviceContextStatus(sds_fi_tcl_e8_DeviceContextStatus& o_e8_DeviceContextStatus);
   virtual tVoid vVisit_e8_DynamicDataStatus(sds_fi_tcl_e8_DynamicDataStatus& o_e8_DynamicDataStatus);
   virtual tVoid vVisit_e8_ContextUpdateStatus(sds_fi_tcl_e8_ContextUpdateStatus& o_e8_ContextUpdateStatus);
	tU32 u32ListSize;
};

#endif
