/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef SDS_SPEECHDPFITYPES_HEADER
#define SDS_SPEECHDPFITYPES_HEADER


class sds_speechdpfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for SDS_SPEECHDP_FI message types

fi_tclMessageBase* sds_speechdpfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class sds_speechdpfi_tclMsgBaseMessage : public sds_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   sds_speechdpfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class sds_speechdpfi_tclMsgGetDataCarrierInfoMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetDataCarrierInfoMethodStart();

   virtual ~sds_speechdpfi_tclMsgGetDataCarrierInfoMethodStart();

   inline tBool operator==(const sds_speechdpfi_tclMsgGetDataCarrierInfoMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetDataCarrierInfoMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetDataCarrierInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetDataCarrierInfoMethodResult& operator=(const sds_speechdpfi_tclMsgGetDataCarrierInfoMethodResult& coRef);
   sds_speechdpfi_tclMsgGetDataCarrierInfoMethodResult(const sds_speechdpfi_tclMsgGetDataCarrierInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_DataCarrier DataCarrierType;
   tU16 MajorVersion_SBS_NAV;
   tU16 MinorVersion_SBS_NAV;
   sds_fi_tclString BoschCreateDate_SBS_NAV;
   tU16 MajorVersion_SBS_ASR;
   tU16 MinorVersion_SBS_ASR;
   sds_fi_tclString BoschCreateDate_SBS_ASR;
   tU16 MajorVersion_SBS_TTS;
   tU16 MinorVersion_SBS_TTS;
   sds_fi_tclString BoschCreateDate_SBS_TTS;
   tU16 MajorVersion_SBS_BAS;
   tU16 MinorVersion_SBS_BAS;
   sds_fi_tclString BoschCreateDate_SBS_BAS;
   tU16 MajorVersion_SpeechData;
   tU16 MinorVersion_SpeechData;
   sds_fi_tclString BoschCreateDate_SpeechData;
   tU16 MajorVersion_NaviData;
   tU16 MinorVersion_NaviData;
   sds_fi_tclString BoschCreateDate_NaviData;
   virtual ~sds_speechdpfi_tclMsgGetDataCarrierInfoMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetDataCarrierInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgSetUserMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgSetUserMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgSetUserMethodStart& operator=(const sds_speechdpfi_tclMsgSetUserMethodStart& coRef);
   sds_speechdpfi_tclMsgSetUserMethodStart(const sds_speechdpfi_tclMsgSetUserMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 UserID;
   virtual ~sds_speechdpfi_tclMsgSetUserMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgSetUserMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgSetUserMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgSetUserMethodResult();

   virtual ~sds_speechdpfi_tclMsgSetUserMethodResult();

   inline tBool operator==(const sds_speechdpfi_tclMsgSetUserMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgReleaseDataMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgReleaseDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgReleaseDataMethodStart& operator=(const sds_speechdpfi_tclMsgReleaseDataMethodStart& coRef);
   sds_speechdpfi_tclMsgReleaseDataMethodStart(const sds_speechdpfi_tclMsgReleaseDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_ReleaseTypeSDP ReleaseType;
   virtual ~sds_speechdpfi_tclMsgReleaseDataMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgReleaseDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgReleaseDataMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgReleaseDataMethodResult();

   virtual ~sds_speechdpfi_tclMsgReleaseDataMethodResult();

   inline tBool operator==(const sds_speechdpfi_tclMsgReleaseDataMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDownloadSDSLanguageMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDownloadSDSLanguageMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgDownloadSDSLanguageMethodStart& operator=(const sds_speechdpfi_tclMsgDownloadSDSLanguageMethodStart& coRef);
   sds_speechdpfi_tclMsgDownloadSDSLanguageMethodStart(const sds_speechdpfi_tclMsgDownloadSDSLanguageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool DownloadASR;
   tBool DownloadTTS;
   tBool DownloadPromptCC;
   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tcl_VoiceType TTSVoice;
   sds_fi_tcl_VoiceType PromptVoice;
   sds_fi_tcl_e8_UserWordUsage UserWordUsage;
   virtual ~sds_speechdpfi_tclMsgDownloadSDSLanguageMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgDownloadSDSLanguageMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultFirst : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultFirst();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultFirst& operator=(const sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultFirst& coRef);
   sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultFirst(const sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultFirst& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 Progress;
   virtual ~sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultFirst();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultFirst& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultMiddle : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultMiddle();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultMiddle& operator=(const sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultMiddle& coRef);
   sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultMiddle(const sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultMiddle& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 Progress;
   virtual ~sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultMiddle();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultMiddle& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultLast : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultLast();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultLast& operator=(const sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultLast& coRef);
   sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultLast(const sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultLast& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 Progress;
   virtual ~sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultLast();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultLast& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetSDSLanguageMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetSDSLanguageMethodStart();

   virtual ~sds_speechdpfi_tclMsgGetSDSLanguageMethodStart();

   inline tBool operator==(const sds_speechdpfi_tclMsgGetSDSLanguageMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetSDSLanguageMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetSDSLanguageMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetSDSLanguageMethodResult& operator=(const sds_speechdpfi_tclMsgGetSDSLanguageMethodResult& coRef);
   sds_speechdpfi_tclMsgGetSDSLanguageMethodResult(const sds_speechdpfi_tclMsgGetSDSLanguageMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tcl_VoiceDescription TTSVoice;
   sds_fi_tcl_VoiceDescription PromptVoice;
   tU16 MajorVersion_SBS_ASR;
   tU16 MinorVersion_SBS_ASR;
   sds_fi_tclString BoschCreateDate_SBS_ASR;
   tU16 MajorVersion_SBS_TTS;
   tU16 MinorVersion_SBS_TTS;
   sds_fi_tclString BoschCreateDate_SBS_TTS;
   tU16 MajorVersion_SBS_BAS;
   tU16 MinorVersion_SBS_BAS;
   sds_fi_tclString BoschCreateDate_SBS_BAS;
   virtual ~sds_speechdpfi_tclMsgGetSDSLanguageMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetSDSLanguageMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDownloadSDSCountryMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDownloadSDSCountryMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgDownloadSDSCountryMethodStart& operator=(const sds_speechdpfi_tclMsgDownloadSDSCountryMethodStart& coRef);
   sds_speechdpfi_tclMsgDownloadSDSCountryMethodStart(const sds_speechdpfi_tclMsgDownloadSDSCountryMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tcl_e8_CountryType CountryType;
   sds_fi_tcl_e16_ISOCountryCode Country;
   sds_fi_tclString State;
   virtual ~sds_speechdpfi_tclMsgDownloadSDSCountryMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgDownloadSDSCountryMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultFirst : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultFirst();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultFirst& operator=(const sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultFirst& coRef);
   sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultFirst(const sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultFirst& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 Progress;
   virtual ~sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultFirst();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultFirst& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultMiddle : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultMiddle();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultMiddle& operator=(const sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultMiddle& coRef);
   sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultMiddle(const sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultMiddle& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 Progress;
   virtual ~sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultMiddle();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultMiddle& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultLast : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultLast();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultLast& operator=(const sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultLast& coRef);
   sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultLast(const sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultLast& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 Progress;
   virtual ~sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultLast();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultLast& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetSDSCountryMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetSDSCountryMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetSDSCountryMethodStart& operator=(const sds_speechdpfi_tclMsgGetSDSCountryMethodStart& coRef);
   sds_speechdpfi_tclMsgGetSDSCountryMethodStart(const sds_speechdpfi_tclMsgGetSDSCountryMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_CountryType CountryType;
   virtual ~sds_speechdpfi_tclMsgGetSDSCountryMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetSDSCountryMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetSDSCountryMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetSDSCountryMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetSDSCountryMethodResult& operator=(const sds_speechdpfi_tclMsgGetSDSCountryMethodResult& coRef);
   sds_speechdpfi_tclMsgGetSDSCountryMethodResult(const sds_speechdpfi_tclMsgGetSDSCountryMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tcl_e16_ISOCountryCode CountryCode;
   sds_fi_tclString State;
   tU16 MajorVersion_SBS_NAV;
   tU16 MinorVersion_SBS_NAV;
   sds_fi_tclString BoschCreateDate;
   virtual ~sds_speechdpfi_tclMsgGetSDSCountryMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetSDSCountryMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodStart& operator=(const sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodStart& coRef);
   sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodStart(const sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_StorageDevice StorageDevice;
   virtual ~sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodResult& operator=(const sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodResult& coRef);
   sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodResult(const sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_AvailableCountry, std::allocator<sds_fi_tcl_AvailableCountry> > AvailableCountries;
   virtual ~sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodStart();

   virtual ~sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodStart();

   inline tBool operator==(const sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodResult& operator=(const sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodResult& coRef);
   sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodResult(const sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_AvailableLanguage, std::allocator<sds_fi_tcl_AvailableLanguage> > AvailableASRLanguages;
   virtual ~sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetASRLanguageModelMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetASRLanguageModelMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetASRLanguageModelMethodStart& operator=(const sds_speechdpfi_tclMsgGetASRLanguageModelMethodStart& coRef);
   sds_speechdpfi_tclMsgGetASRLanguageModelMethodStart(const sds_speechdpfi_tclMsgGetASRLanguageModelMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   virtual ~sds_speechdpfi_tclMsgGetASRLanguageModelMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetASRLanguageModelMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetASRLanguageModelMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetASRLanguageModelMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetASRLanguageModelMethodResult& operator=(const sds_speechdpfi_tclMsgGetASRLanguageModelMethodResult& coRef);
   sds_speechdpfi_tclMsgGetASRLanguageModelMethodResult(const sds_speechdpfi_tclMsgGetASRLanguageModelMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString FrontendFile;
   sds_fi_tclString BackendFile;
   std::vector<sds_fi_tclString, std::allocator<sds_fi_tclString> > DDG2PFileName;
   virtual ~sds_speechdpfi_tclMsgGetASRLanguageModelMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetASRLanguageModelMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetCmdCtrlDataMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetCmdCtrlDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetCmdCtrlDataMethodStart& operator=(const sds_speechdpfi_tclMsgGetCmdCtrlDataMethodStart& coRef);
   sds_speechdpfi_tclMsgGetCmdCtrlDataMethodStart(const sds_speechdpfi_tclMsgGetCmdCtrlDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_FileAccessMode FileAccessMode;
   sds_fi_tcl_e8_FileType FileType;
   sds_fi_tcl_SDSLanguageID LanguageID;
   tU16 UserID;
   sds_fi_tclString LogicalName;
   virtual ~sds_speechdpfi_tclMsgGetCmdCtrlDataMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetCmdCtrlDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetCmdCtrlDataMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetCmdCtrlDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetCmdCtrlDataMethodResult& operator=(const sds_speechdpfi_tclMsgGetCmdCtrlDataMethodResult& coRef);
   sds_speechdpfi_tclMsgGetCmdCtrlDataMethodResult(const sds_speechdpfi_tclMsgGetCmdCtrlDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 Cookie;
   sds_fi_tclString FileName;
   virtual ~sds_speechdpfi_tclMsgGetCmdCtrlDataMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetCmdCtrlDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgNewUserWordMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgNewUserWordMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgNewUserWordMethodStart& operator=(const sds_speechdpfi_tclMsgNewUserWordMethodStart& coRef);
   sds_speechdpfi_tclMsgNewUserWordMethodStart(const sds_speechdpfi_tclMsgNewUserWordMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_FileAccessMode FileAccessMode;
   sds_fi_tcl_SDSLanguageID LanguageID;
   tU16 UserID;
   sds_fi_tcl_e8_UwCategories UserWordCategory;
   virtual ~sds_speechdpfi_tclMsgNewUserWordMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgNewUserWordMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgNewUserWordMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgNewUserWordMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgNewUserWordMethodResult& operator=(const sds_speechdpfi_tclMsgNewUserWordMethodResult& coRef);
   sds_speechdpfi_tclMsgNewUserWordMethodResult(const sds_speechdpfi_tclMsgNewUserWordMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 Cookie;
   sds_fi_tclString Grammar;
   sds_fi_tclString Dictionary;
   sds_fi_tclString LabelFile;
   sds_fi_tclString UserWordAudioFile;
   tU16 UserWordIndex;
   virtual ~sds_speechdpfi_tclMsgNewUserWordMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgNewUserWordMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgChangeUserWordMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgChangeUserWordMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgChangeUserWordMethodStart& operator=(const sds_speechdpfi_tclMsgChangeUserWordMethodStart& coRef);
   sds_speechdpfi_tclMsgChangeUserWordMethodStart(const sds_speechdpfi_tclMsgChangeUserWordMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_FileAccessMode FileAccessMode;
   sds_fi_tcl_SDSLanguageID LanguageID;
   tU16 UserID;
   sds_fi_tcl_e8_UwCategories UserWordCategory;
   tU16 UserWordIndex;
   virtual ~sds_speechdpfi_tclMsgChangeUserWordMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgChangeUserWordMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgChangeUserWordMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgChangeUserWordMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgChangeUserWordMethodResult& operator=(const sds_speechdpfi_tclMsgChangeUserWordMethodResult& coRef);
   sds_speechdpfi_tclMsgChangeUserWordMethodResult(const sds_speechdpfi_tclMsgChangeUserWordMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 Cookie;
   sds_fi_tclString Grammar;
   sds_fi_tclString Dictionary;
   sds_fi_tclString LabelFile;
   sds_fi_tclString UserWordAudioFile;
   virtual ~sds_speechdpfi_tclMsgChangeUserWordMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgChangeUserWordMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetUserWordDataMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetUserWordDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetUserWordDataMethodStart& operator=(const sds_speechdpfi_tclMsgGetUserWordDataMethodStart& coRef);
   sds_speechdpfi_tclMsgGetUserWordDataMethodStart(const sds_speechdpfi_tclMsgGetUserWordDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_FileAccessMode FileAccessMode;
   sds_fi_tcl_SDSLanguageID LanguageID;
   tU16 UserID;
   virtual ~sds_speechdpfi_tclMsgGetUserWordDataMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetUserWordDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetUserWordDataMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetUserWordDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetUserWordDataMethodResult& operator=(const sds_speechdpfi_tclMsgGetUserWordDataMethodResult& coRef);
   sds_speechdpfi_tclMsgGetUserWordDataMethodResult(const sds_speechdpfi_tclMsgGetUserWordDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString Grammar;
   sds_fi_tclString LabelFile;
   virtual ~sds_speechdpfi_tclMsgGetUserWordDataMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetUserWordDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetUserWordAudioFileMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetUserWordAudioFileMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetUserWordAudioFileMethodStart& operator=(const sds_speechdpfi_tclMsgGetUserWordAudioFileMethodStart& coRef);
   sds_speechdpfi_tclMsgGetUserWordAudioFileMethodStart(const sds_speechdpfi_tclMsgGetUserWordAudioFileMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_FileAccessMode FileAccessMode;
   sds_fi_tcl_SDSLanguageID LanguageID;
   tU16 UserID;
   sds_fi_tcl_e8_UwCategories UserWordCategory;
   tU16 UserWordIndex;
   virtual ~sds_speechdpfi_tclMsgGetUserWordAudioFileMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetUserWordAudioFileMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetUserWordAudioFileMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetUserWordAudioFileMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetUserWordAudioFileMethodResult& operator=(const sds_speechdpfi_tclMsgGetUserWordAudioFileMethodResult& coRef);
   sds_speechdpfi_tclMsgGetUserWordAudioFileMethodResult(const sds_speechdpfi_tclMsgGetUserWordAudioFileMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tclString, std::allocator<sds_fi_tclString> > UserWordAudioFiles;
   virtual ~sds_speechdpfi_tclMsgGetUserWordAudioFileMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetUserWordAudioFileMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDeleteUserWordsMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDeleteUserWordsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgDeleteUserWordsMethodStart& operator=(const sds_speechdpfi_tclMsgDeleteUserWordsMethodStart& coRef);
   sds_speechdpfi_tclMsgDeleteUserWordsMethodStart(const sds_speechdpfi_tclMsgDeleteUserWordsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_FileAccessMode FileAccessMode;
   sds_fi_tcl_SDSLanguageID LanguageID;
   tU16 UserID;
   sds_fi_tcl_e8_UwCategories UserWordCategory;
   tU16 UserWordIndex;
   virtual ~sds_speechdpfi_tclMsgDeleteUserWordsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgDeleteUserWordsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDeleteUserWordsMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDeleteUserWordsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgDeleteUserWordsMethodResult& operator=(const sds_speechdpfi_tclMsgDeleteUserWordsMethodResult& coRef);
   sds_speechdpfi_tclMsgDeleteUserWordsMethodResult(const sds_speechdpfi_tclMsgDeleteUserWordsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 Cookie;
   sds_fi_tclString Grammar;
   sds_fi_tclString LabelFile;
   sds_fi_tclString Dictionary;
   virtual ~sds_speechdpfi_tclMsgDeleteUserWordsMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgDeleteUserWordsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodStart& operator=(const sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodStart& coRef);
   sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodStart(const sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   tU16 UserID;
   virtual ~sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodResult();

   virtual ~sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodResult();

   inline tBool operator==(const sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetASRAudioFileMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetASRAudioFileMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetASRAudioFileMethodStart& operator=(const sds_speechdpfi_tclMsgGetASRAudioFileMethodStart& coRef);
   sds_speechdpfi_tclMsgGetASRAudioFileMethodStart(const sds_speechdpfi_tclMsgGetASRAudioFileMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_FileAccessMode FileAccessMode;
   tU16 FileID;
   sds_fi_tcl_e8_StorageDevice StorageDevice;
   virtual ~sds_speechdpfi_tclMsgGetASRAudioFileMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetASRAudioFileMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetASRAudioFileMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetASRAudioFileMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetASRAudioFileMethodResult& operator=(const sds_speechdpfi_tclMsgGetASRAudioFileMethodResult& coRef);
   sds_speechdpfi_tclMsgGetASRAudioFileMethodResult(const sds_speechdpfi_tclMsgGetASRAudioFileMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 Cookie;
   sds_fi_tclString FileName;
   sds_fi_tcl_e8_FileAvailability FileAvailability;
   virtual ~sds_speechdpfi_tclMsgGetASRAudioFileMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetASRAudioFileMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDeleteASRAudioFileMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDeleteASRAudioFileMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgDeleteASRAudioFileMethodStart& operator=(const sds_speechdpfi_tclMsgDeleteASRAudioFileMethodStart& coRef);
   sds_speechdpfi_tclMsgDeleteASRAudioFileMethodStart(const sds_speechdpfi_tclMsgDeleteASRAudioFileMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 FileID;
   virtual ~sds_speechdpfi_tclMsgDeleteASRAudioFileMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgDeleteASRAudioFileMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDeleteASRAudioFileMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDeleteASRAudioFileMethodResult();

   virtual ~sds_speechdpfi_tclMsgDeleteASRAudioFileMethodResult();

   inline tBool operator==(const sds_speechdpfi_tclMsgDeleteASRAudioFileMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetAvailablePoiCatMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetAvailablePoiCatMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetAvailablePoiCatMethodStart& operator=(const sds_speechdpfi_tclMsgGetAvailablePoiCatMethodStart& coRef);
   sds_speechdpfi_tclMsgGetAvailablePoiCatMethodStart(const sds_speechdpfi_tclMsgGetAvailablePoiCatMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_FileType FileType;
   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tcl_e16_ISOCountryCode Country;
   sds_fi_tclString State;
   virtual ~sds_speechdpfi_tclMsgGetAvailablePoiCatMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetAvailablePoiCatMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetAvailablePoiCatMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetAvailablePoiCatMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetAvailablePoiCatMethodResult& operator=(const sds_speechdpfi_tclMsgGetAvailablePoiCatMethodResult& coRef);
   sds_speechdpfi_tclMsgGetAvailablePoiCatMethodResult(const sds_speechdpfi_tclMsgGetAvailablePoiCatMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_e16_SelectionCriterionType, std::allocator<sds_fi_tcl_e16_SelectionCriterionType> > Category;
   virtual ~sds_speechdpfi_tclMsgGetAvailablePoiCatMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetAvailablePoiCatMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetDestinationContextMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetDestinationContextMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetDestinationContextMethodStart& operator=(const sds_speechdpfi_tclMsgGetDestinationContextMethodStart& coRef);
   sds_speechdpfi_tclMsgGetDestinationContextMethodStart(const sds_speechdpfi_tclMsgGetDestinationContextMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tcl_CurrentCountry Country;
   sds_fi_tcl_CurrentState StateName;
   sds_fi_tclString LogicalName;
   sds_fi_tclString AcmodVersion;
   virtual ~sds_speechdpfi_tclMsgGetDestinationContextMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetDestinationContextMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetDestinationContextMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetDestinationContextMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetDestinationContextMethodResult& operator=(const sds_speechdpfi_tclMsgGetDestinationContextMethodResult& coRef);
   sds_speechdpfi_tclMsgGetDestinationContextMethodResult(const sds_speechdpfi_tclMsgGetDestinationContextMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString FileName;
   std::vector<sds_fi_tcl_BlobData, std::allocator<sds_fi_tcl_BlobData> > Data;
   virtual ~sds_speechdpfi_tclMsgGetDestinationContextMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetDestinationContextMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodStart& operator=(const sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodStart& coRef);
   sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodStart(const sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tclString CountryName;
   sds_fi_tcl_e16_ISOCountryCode CountryCode;
   sds_fi_tclString StateName;
   sds_fi_tclString StateShort;
   sds_fi_tclString LogicalName;
   virtual ~sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodResult& operator=(const sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodResult& coRef);
   sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodResult(const sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString FileName;
   virtual ~sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetSpecialContextMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetSpecialContextMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetSpecialContextMethodStart& operator=(const sds_speechdpfi_tclMsgGetSpecialContextMethodStart& coRef);
   sds_speechdpfi_tclMsgGetSpecialContextMethodStart(const sds_speechdpfi_tclMsgGetSpecialContextMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tcl_e16_ISOCountryCode Country;
   sds_fi_tcl_e8_ContextType ContextType;
   std::vector<sds_fi_tclString, std::allocator<sds_fi_tclString> > AlphabetRange;
   sds_fi_tclString State;
   virtual ~sds_speechdpfi_tclMsgGetSpecialContextMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetSpecialContextMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetSpecialContextMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetSpecialContextMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetSpecialContextMethodResult& operator=(const sds_speechdpfi_tclMsgGetSpecialContextMethodResult& coRef);
   sds_speechdpfi_tclMsgGetSpecialContextMethodResult(const sds_speechdpfi_tclMsgGetSpecialContextMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tclString, std::allocator<sds_fi_tclString> > FileNames;
   virtual ~sds_speechdpfi_tclMsgGetSpecialContextMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetSpecialContextMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodStart& operator=(const sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodStart& coRef);
   sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodStart(const sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e16_SelectionCriterionType DestinationCategory;
   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tcl_e16_ISOCountryCode Country;
   std::vector<sds_fi_tclString, std::allocator<sds_fi_tclString> > NameList;
   sds_fi_tclString State;
   virtual ~sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodResult& operator=(const sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodResult& coRef);
   sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodResult(const sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_DictionaryGroup, std::allocator<sds_fi_tcl_DictionaryGroup> > DictionaryGroup;
   virtual ~sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodStart();

   virtual ~sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodStart();

   inline tBool operator==(const sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodResult& operator=(const sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodResult& coRef);
   sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodResult(const sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_VoiceDescription, std::allocator<sds_fi_tcl_VoiceDescription> > AvailablePromptVoices;
   virtual ~sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetPromptVoiceDataMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetPromptVoiceDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetPromptVoiceDataMethodStart& operator=(const sds_speechdpfi_tclMsgGetPromptVoiceDataMethodStart& coRef);
   sds_speechdpfi_tclMsgGetPromptVoiceDataMethodStart(const sds_speechdpfi_tclMsgGetPromptVoiceDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_VoiceType PromptVoice;
   virtual ~sds_speechdpfi_tclMsgGetPromptVoiceDataMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetPromptVoiceDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetPromptVoiceDataMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetPromptVoiceDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetPromptVoiceDataMethodResult& operator=(const sds_speechdpfi_tclMsgGetPromptVoiceDataMethodResult& coRef);
   sds_speechdpfi_tclMsgGetPromptVoiceDataMethodResult(const sds_speechdpfi_tclMsgGetPromptVoiceDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tclString, std::allocator<sds_fi_tclString> > SentenceTables;
   std::vector<sds_fi_tclString, std::allocator<sds_fi_tclString> > DataPackages;
   std::vector<sds_fi_tclString, std::allocator<sds_fi_tclString> > CommonFile;
   virtual ~sds_speechdpfi_tclMsgGetPromptVoiceDataMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetPromptVoiceDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodStart();

   virtual ~sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodStart();

   inline tBool operator==(const sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodResult& operator=(const sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodResult& coRef);
   sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodResult(const sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_VoiceDescription, std::allocator<sds_fi_tcl_VoiceDescription> > AvailableTTSVoices;
   virtual ~sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetSpeechDialogMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetSpeechDialogMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetSpeechDialogMethodStart& operator=(const sds_speechdpfi_tclMsgGetSpeechDialogMethodStart& coRef);
   sds_speechdpfi_tclMsgGetSpeechDialogMethodStart(const sds_speechdpfi_tclMsgGetSpeechDialogMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   virtual ~sds_speechdpfi_tclMsgGetSpeechDialogMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetSpeechDialogMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetSpeechDialogMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetSpeechDialogMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetSpeechDialogMethodResult& operator=(const sds_speechdpfi_tclMsgGetSpeechDialogMethodResult& coRef);
   sds_speechdpfi_tclMsgGetSpeechDialogMethodResult(const sds_speechdpfi_tclMsgGetSpeechDialogMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString DialogFile;
   virtual ~sds_speechdpfi_tclMsgGetSpeechDialogMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetSpeechDialogMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgAccessCompletedMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgAccessCompletedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgAccessCompletedMethodStart& operator=(const sds_speechdpfi_tclMsgAccessCompletedMethodStart& coRef);
   sds_speechdpfi_tclMsgAccessCompletedMethodStart(const sds_speechdpfi_tclMsgAccessCompletedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 Cookie;
   sds_fi_tcl_e8_FileAccessResult FileAccessResult;
   virtual ~sds_speechdpfi_tclMsgAccessCompletedMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgAccessCompletedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgAccessCompletedMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgAccessCompletedMethodResult();

   virtual ~sds_speechdpfi_tclMsgAccessCompletedMethodResult();

   inline tBool operator==(const sds_speechdpfi_tclMsgAccessCompletedMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetVocalizerDataMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetVocalizerDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetVocalizerDataMethodStart& operator=(const sds_speechdpfi_tclMsgGetVocalizerDataMethodStart& coRef);
   sds_speechdpfi_tclMsgGetVocalizerDataMethodStart(const sds_speechdpfi_tclMsgGetVocalizerDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_VoiceType TTSVoice;
   virtual ~sds_speechdpfi_tclMsgGetVocalizerDataMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetVocalizerDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetVocalizerDataMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetVocalizerDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetVocalizerDataMethodResult& operator=(const sds_speechdpfi_tclMsgGetVocalizerDataMethodResult& coRef);
   sds_speechdpfi_tclMsgGetVocalizerDataMethodResult(const sds_speechdpfi_tclMsgGetVocalizerDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_TTSTunningFile, std::allocator<sds_fi_tcl_TTSTunningFile> > TTSTunningFiles;
   std::vector<sds_fi_tcl_TTSVoiceFile, std::allocator<sds_fi_tcl_TTSVoiceFile> > TTSVoiceFiles;
   sds_fi_tcl_e8_TTSEngineType TTSEngine;
   virtual ~sds_speechdpfi_tclMsgGetVocalizerDataMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetVocalizerDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetVoconDataMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetVoconDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetVoconDataMethodStart& operator=(const sds_speechdpfi_tclMsgGetVoconDataMethodStart& coRef);
   sds_speechdpfi_tclMsgGetVoconDataMethodStart(const sds_speechdpfi_tclMsgGetVoconDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   virtual ~sds_speechdpfi_tclMsgGetVoconDataMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetVoconDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetVoconDataMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetVoconDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetVoconDataMethodResult& operator=(const sds_speechdpfi_tclMsgGetVoconDataMethodResult& coRef);
   sds_speechdpfi_tclMsgGetVoconDataMethodResult(const sds_speechdpfi_tclMsgGetVoconDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString ConfigFile;
   sds_fi_tclString LanguageModel;
   sds_fi_tclString SessionData_LM;
   sds_fi_tclString SessionData_FE;
   virtual ~sds_speechdpfi_tclMsgGetVoconDataMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetVoconDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetContextMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetContextMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetContextMethodStart& operator=(const sds_speechdpfi_tclMsgGetContextMethodStart& coRef);
   sds_speechdpfi_tclMsgGetContextMethodStart(const sds_speechdpfi_tclMsgGetContextMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tclString LogicalName;
   virtual ~sds_speechdpfi_tclMsgGetContextMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetContextMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetContextMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetContextMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetContextMethodResult& operator=(const sds_speechdpfi_tclMsgGetContextMethodResult& coRef);
   sds_speechdpfi_tclMsgGetContextMethodResult(const sds_speechdpfi_tclMsgGetContextMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_ContextFile, std::allocator<sds_fi_tcl_ContextFile> > ContextFiles;
   virtual ~sds_speechdpfi_tclMsgGetContextMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetContextMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetSemBufferMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetSemBufferMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetSemBufferMethodStart& operator=(const sds_speechdpfi_tclMsgGetSemBufferMethodStart& coRef);
   sds_speechdpfi_tclMsgGetSemBufferMethodStart(const sds_speechdpfi_tclMsgGetSemBufferMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tclString LogicalName;
   virtual ~sds_speechdpfi_tclMsgGetSemBufferMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetSemBufferMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetSemBufferMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetSemBufferMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetSemBufferMethodResult& operator=(const sds_speechdpfi_tclMsgGetSemBufferMethodResult& coRef);
   sds_speechdpfi_tclMsgGetSemBufferMethodResult(const sds_speechdpfi_tclMsgGetSemBufferMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_SemBufferFile, std::allocator<sds_fi_tcl_SemBufferFile> > BufferFiles;
   virtual ~sds_speechdpfi_tclMsgGetSemBufferMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetSemBufferMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgCheckDynamicContextMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgCheckDynamicContextMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgCheckDynamicContextMethodStart& operator=(const sds_speechdpfi_tclMsgCheckDynamicContextMethodStart& coRef);
   sds_speechdpfi_tclMsgCheckDynamicContextMethodStart(const sds_speechdpfi_tclMsgCheckDynamicContextMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tcl_e8_Domain DomainID;
   std::vector<sds_fi_tcl_ConnectDevice, std::allocator<sds_fi_tcl_ConnectDevice> > Devices;
   virtual ~sds_speechdpfi_tclMsgCheckDynamicContextMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgCheckDynamicContextMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgCheckDynamicContextMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgCheckDynamicContextMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgCheckDynamicContextMethodResult& operator=(const sds_speechdpfi_tclMsgCheckDynamicContextMethodResult& coRef);
   sds_speechdpfi_tclMsgCheckDynamicContextMethodResult(const sds_speechdpfi_tclMsgCheckDynamicContextMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_ConnectDevice, std::allocator<sds_fi_tcl_ConnectDevice> > Devices;
   virtual ~sds_speechdpfi_tclMsgCheckDynamicContextMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgCheckDynamicContextMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetDynamicContextMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetDynamicContextMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetDynamicContextMethodStart& operator=(const sds_speechdpfi_tclMsgGetDynamicContextMethodStart& coRef);
   sds_speechdpfi_tclMsgGetDynamicContextMethodStart(const sds_speechdpfi_tclMsgGetDynamicContextMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tcl_e8_Domain DomainID;
   tU32 DeviceID;
   virtual ~sds_speechdpfi_tclMsgGetDynamicContextMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetDynamicContextMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetDynamicContextMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetDynamicContextMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetDynamicContextMethodResult& operator=(const sds_speechdpfi_tclMsgGetDynamicContextMethodResult& coRef);
   sds_speechdpfi_tclMsgGetDynamicContextMethodResult(const sds_speechdpfi_tclMsgGetDynamicContextMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString DeviceMetaFile;
   virtual ~sds_speechdpfi_tclMsgGetDynamicContextMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetDynamicContextMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodStart& operator=(const sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodStart& coRef);
   sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodStart(const sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_StorageDevice StorageLocation;
   virtual ~sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodResult& operator=(const sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodResult& coRef);
   sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodResult(const sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString FolderName;
   tU32 FreeSpace;
   tU32 Cookie;
   virtual ~sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodStart& operator=(const sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodStart& coRef);
   sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodStart(const sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Cookie;
   sds_fi_tclString MetafileName;
   virtual ~sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodResult();

   virtual ~sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodResult();

   inline tBool operator==(const sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodStart& operator=(const sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodStart& coRef);
   sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodStart(const sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Cookie;
   virtual ~sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodResult();

   virtual ~sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodResult();

   inline tBool operator==(const sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodStart& operator=(const sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodStart& coRef);
   sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodStart(const sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 NeededSpace;
   sds_fi_tcl_e8_Domain DomainID;
   sds_fi_tcl_e8_StorageDevice StorageLocation;
   virtual ~sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodResult& operator=(const sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodResult& coRef);
   sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodResult(const sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 FreeSpace;
   virtual ~sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDeleteFolderMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDeleteFolderMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgDeleteFolderMethodStart& operator=(const sds_speechdpfi_tclMsgDeleteFolderMethodStart& coRef);
   sds_speechdpfi_tclMsgDeleteFolderMethodStart(const sds_speechdpfi_tclMsgDeleteFolderMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString FolderName;
   virtual ~sds_speechdpfi_tclMsgDeleteFolderMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgDeleteFolderMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDeleteFolderMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDeleteFolderMethodResult();

   virtual ~sds_speechdpfi_tclMsgDeleteFolderMethodResult();

   inline tBool operator==(const sds_speechdpfi_tclMsgDeleteFolderMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetTranscriptionDataMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetTranscriptionDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetTranscriptionDataMethodStart& operator=(const sds_speechdpfi_tclMsgGetTranscriptionDataMethodStart& coRef);
   sds_speechdpfi_tclMsgGetTranscriptionDataMethodStart(const sds_speechdpfi_tclMsgGetTranscriptionDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   virtual ~sds_speechdpfi_tclMsgGetTranscriptionDataMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetTranscriptionDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetTranscriptionDataMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetTranscriptionDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetTranscriptionDataMethodResult& operator=(const sds_speechdpfi_tclMsgGetTranscriptionDataMethodResult& coRef);
   sds_speechdpfi_tclMsgGetTranscriptionDataMethodResult(const sds_speechdpfi_tclMsgGetTranscriptionDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString ConfigFile;
   sds_fi_tclString LanguageModelFile;
   virtual ~sds_speechdpfi_tclMsgGetTranscriptionDataMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetTranscriptionDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetTranscriptionBufferMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetTranscriptionBufferMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetTranscriptionBufferMethodStart& operator=(const sds_speechdpfi_tclMsgGetTranscriptionBufferMethodStart& coRef);
   sds_speechdpfi_tclMsgGetTranscriptionBufferMethodStart(const sds_speechdpfi_tclMsgGetTranscriptionBufferMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tclString LogicalName;
   virtual ~sds_speechdpfi_tclMsgGetTranscriptionBufferMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetTranscriptionBufferMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetTranscriptionBufferMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetTranscriptionBufferMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetTranscriptionBufferMethodResult& operator=(const sds_speechdpfi_tclMsgGetTranscriptionBufferMethodResult& coRef);
   sds_speechdpfi_tclMsgGetTranscriptionBufferMethodResult(const sds_speechdpfi_tclMsgGetTranscriptionBufferMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_TranscriptionFile, std::allocator<sds_fi_tcl_TranscriptionFile> > Files;
   virtual ~sds_speechdpfi_tclMsgGetTranscriptionBufferMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetTranscriptionBufferMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodStart& operator=(const sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodStart& coRef);
   sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodStart(const sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tclString SlotName;
   virtual ~sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodResult& operator=(const sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodResult& coRef);
   sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodResult(const sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tclString, std::allocator<sds_fi_tclString> > DictionaryFiles;
   virtual ~sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodStart& operator=(const sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodStart& coRef);
   sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodStart(const sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tclString SlotName;
   virtual ~sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodResult& operator=(const sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodResult& coRef);
   sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodResult(const sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tclString, std::allocator<sds_fi_tclString> > RulesetFiles;
   virtual ~sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetDataPathMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetDataPathMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetDataPathMethodStart& operator=(const sds_speechdpfi_tclMsgGetDataPathMethodStart& coRef);
   sds_speechdpfi_tclMsgGetDataPathMethodStart(const sds_speechdpfi_tclMsgGetDataPathMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_PathType Type;
   virtual ~sds_speechdpfi_tclMsgGetDataPathMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetDataPathMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetDataPathMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetDataPathMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetDataPathMethodResult& operator=(const sds_speechdpfi_tclMsgGetDataPathMethodResult& coRef);
   sds_speechdpfi_tclMsgGetDataPathMethodResult(const sds_speechdpfi_tclMsgGetDataPathMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString Path;
   virtual ~sds_speechdpfi_tclMsgGetDataPathMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetDataPathMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetStringFromIDMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetStringFromIDMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetStringFromIDMethodStart& operator=(const sds_speechdpfi_tclMsgGetStringFromIDMethodStart& coRef);
   sds_speechdpfi_tclMsgGetStringFromIDMethodStart(const sds_speechdpfi_tclMsgGetStringFromIDMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_NameID, std::allocator<sds_fi_tcl_NameID> > IDs;
   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tcl_e16_ISOCountryCode CountryCode;
   sds_fi_tclString CountryName;
   virtual ~sds_speechdpfi_tclMsgGetStringFromIDMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetStringFromIDMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetStringFromIDMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetStringFromIDMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetStringFromIDMethodResult& operator=(const sds_speechdpfi_tclMsgGetStringFromIDMethodResult& coRef);
   sds_speechdpfi_tclMsgGetStringFromIDMethodResult(const sds_speechdpfi_tclMsgGetStringFromIDMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_SDSDestinationEntry, std::allocator<sds_fi_tcl_SDSDestinationEntry> > StringsAndTypes;
   virtual ~sds_speechdpfi_tclMsgGetStringFromIDMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetStringFromIDMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetPhonemeFromIDMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetPhonemeFromIDMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetPhonemeFromIDMethodStart& operator=(const sds_speechdpfi_tclMsgGetPhonemeFromIDMethodStart& coRef);
   sds_speechdpfi_tclMsgGetPhonemeFromIDMethodStart(const sds_speechdpfi_tclMsgGetPhonemeFromIDMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_NDSID ID;
   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tcl_CurrentCountry Country;
   virtual ~sds_speechdpfi_tclMsgGetPhonemeFromIDMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetPhonemeFromIDMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetPhonemeFromIDMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetPhonemeFromIDMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetPhonemeFromIDMethodResult& operator=(const sds_speechdpfi_tclMsgGetPhonemeFromIDMethodResult& coRef);
   sds_speechdpfi_tclMsgGetPhonemeFromIDMethodResult(const sds_speechdpfi_tclMsgGetPhonemeFromIDMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString Phoneme;
   virtual ~sds_speechdpfi_tclMsgGetPhonemeFromIDMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetPhonemeFromIDMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetPhonemeFromStringMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetPhonemeFromStringMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetPhonemeFromStringMethodStart& operator=(const sds_speechdpfi_tclMsgGetPhonemeFromStringMethodStart& coRef);
   sds_speechdpfi_tclMsgGetPhonemeFromStringMethodStart(const sds_speechdpfi_tclMsgGetPhonemeFromStringMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSDestinationEntry StringAndType;
   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tcl_e16_ISOCountryCode CountryCode;
   sds_fi_tclString CountryName;
   virtual ~sds_speechdpfi_tclMsgGetPhonemeFromStringMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetPhonemeFromStringMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetPhonemeFromStringMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetPhonemeFromStringMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetPhonemeFromStringMethodResult& operator=(const sds_speechdpfi_tclMsgGetPhonemeFromStringMethodResult& coRef);
   sds_speechdpfi_tclMsgGetPhonemeFromStringMethodResult(const sds_speechdpfi_tclMsgGetPhonemeFromStringMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString Phoneme;
   virtual ~sds_speechdpfi_tclMsgGetPhonemeFromStringMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetPhonemeFromStringMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetIDFromStringMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetIDFromStringMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetIDFromStringMethodStart& operator=(const sds_speechdpfi_tclMsgGetIDFromStringMethodStart& coRef);
   sds_speechdpfi_tclMsgGetIDFromStringMethodStart(const sds_speechdpfi_tclMsgGetIDFromStringMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_SDSDestinationEntry, std::allocator<sds_fi_tcl_SDSDestinationEntry> > StringAndTypes;
   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tcl_e16_ISOCountryCode CountryCode;
   sds_fi_tclString CountryName;
   virtual ~sds_speechdpfi_tclMsgGetIDFromStringMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetIDFromStringMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetIDFromStringMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetIDFromStringMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetIDFromStringMethodResult& operator=(const sds_speechdpfi_tclMsgGetIDFromStringMethodResult& coRef);
   sds_speechdpfi_tclMsgGetIDFromStringMethodResult(const sds_speechdpfi_tclMsgGetIDFromStringMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_NameID, std::allocator<sds_fi_tcl_NameID> > IDs;
   virtual ~sds_speechdpfi_tclMsgGetIDFromStringMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetIDFromStringMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetDestinationSupportMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetDestinationSupportMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetDestinationSupportMethodStart& operator=(const sds_speechdpfi_tclMsgGetDestinationSupportMethodStart& coRef);
   sds_speechdpfi_tclMsgGetDestinationSupportMethodStart(const sds_speechdpfi_tclMsgGetDestinationSupportMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tcl_CurrentCountry Country;
   sds_fi_tcl_CurrentState State;
   virtual ~sds_speechdpfi_tclMsgGetDestinationSupportMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetDestinationSupportMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetDestinationSupportMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetDestinationSupportMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetDestinationSupportMethodResult& operator=(const sds_speechdpfi_tclMsgGetDestinationSupportMethodResult& coRef);
   sds_speechdpfi_tclMsgGetDestinationSupportMethodResult(const sds_speechdpfi_tclMsgGetDestinationSupportMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_CountrySupportType CountrySupported;
   tBool CountryHasProvinces;
   sds_fi_tcl_e8_CountrySupportType StateSupported;
   sds_fi_tcl_e8_CountrySupportType RegionSupported;
   tBool POICategorySupported;
   tBool POINameSupported;
   tBool POIBrandNameSupported;
   virtual ~sds_speechdpfi_tclMsgGetDestinationSupportMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetDestinationSupportMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetAvailableUserwordsMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetAvailableUserwordsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetAvailableUserwordsMethodStart& operator=(const sds_speechdpfi_tclMsgGetAvailableUserwordsMethodStart& coRef);
   sds_speechdpfi_tclMsgGetAvailableUserwordsMethodStart(const sds_speechdpfi_tclMsgGetAvailableUserwordsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tcl_e8_Domain DomainID;
   tU32 ProfileID;
   virtual ~sds_speechdpfi_tclMsgGetAvailableUserwordsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetAvailableUserwordsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetAvailableUserwordsMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetAvailableUserwordsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetAvailableUserwordsMethodResult& operator=(const sds_speechdpfi_tclMsgGetAvailableUserwordsMethodResult& coRef);
   sds_speechdpfi_tclMsgGetAvailableUserwordsMethodResult(const sds_speechdpfi_tclMsgGetAvailableUserwordsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU32, std::allocator<tU32> > Userwords;
   virtual ~sds_speechdpfi_tclMsgGetAvailableUserwordsMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetAvailableUserwordsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetUserwordContextMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetUserwordContextMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetUserwordContextMethodStart& operator=(const sds_speechdpfi_tclMsgGetUserwordContextMethodStart& coRef);
   sds_speechdpfi_tclMsgGetUserwordContextMethodStart(const sds_speechdpfi_tclMsgGetUserwordContextMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tcl_e8_Domain DomainID;
   tU32 ProfileID;
   virtual ~sds_speechdpfi_tclMsgGetUserwordContextMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetUserwordContextMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetUserwordContextMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetUserwordContextMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetUserwordContextMethodResult& operator=(const sds_speechdpfi_tclMsgGetUserwordContextMethodResult& coRef);
   sds_speechdpfi_tclMsgGetUserwordContextMethodResult(const sds_speechdpfi_tclMsgGetUserwordContextMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString ContextFile;
   virtual ~sds_speechdpfi_tclMsgGetUserwordContextMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetUserwordContextMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetUserwordAudioMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetUserwordAudioMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetUserwordAudioMethodStart& operator=(const sds_speechdpfi_tclMsgGetUserwordAudioMethodStart& coRef);
   sds_speechdpfi_tclMsgGetUserwordAudioMethodStart(const sds_speechdpfi_tclMsgGetUserwordAudioMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tcl_e8_Domain DomainID;
   tU32 ProfileID;
   std::vector<tU32, std::allocator<tU32> > UserwordID;
   virtual ~sds_speechdpfi_tclMsgGetUserwordAudioMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetUserwordAudioMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetUserwordAudioMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetUserwordAudioMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetUserwordAudioMethodResult& operator=(const sds_speechdpfi_tclMsgGetUserwordAudioMethodResult& coRef);
   sds_speechdpfi_tclMsgGetUserwordAudioMethodResult(const sds_speechdpfi_tclMsgGetUserwordAudioMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_UserAudioFile, std::allocator<sds_fi_tcl_UserAudioFile> > AudioFiles;
   virtual ~sds_speechdpfi_tclMsgGetUserwordAudioMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetUserwordAudioMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgCreateUserwordFolderMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgCreateUserwordFolderMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgCreateUserwordFolderMethodStart& operator=(const sds_speechdpfi_tclMsgCreateUserwordFolderMethodStart& coRef);
   sds_speechdpfi_tclMsgCreateUserwordFolderMethodStart(const sds_speechdpfi_tclMsgCreateUserwordFolderMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   virtual ~sds_speechdpfi_tclMsgCreateUserwordFolderMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgCreateUserwordFolderMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgCreateUserwordFolderMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgCreateUserwordFolderMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgCreateUserwordFolderMethodResult& operator=(const sds_speechdpfi_tclMsgCreateUserwordFolderMethodResult& coRef);
   sds_speechdpfi_tclMsgCreateUserwordFolderMethodResult(const sds_speechdpfi_tclMsgCreateUserwordFolderMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString FolderName;
   tU32 FreeSpace;
   tU32 Cookie;
   virtual ~sds_speechdpfi_tclMsgCreateUserwordFolderMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgCreateUserwordFolderMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgCommitUserwordFolderMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgCommitUserwordFolderMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgCommitUserwordFolderMethodStart& operator=(const sds_speechdpfi_tclMsgCommitUserwordFolderMethodStart& coRef);
   sds_speechdpfi_tclMsgCommitUserwordFolderMethodStart(const sds_speechdpfi_tclMsgCommitUserwordFolderMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Cookie;
   sds_fi_tclString MetafileName;
   virtual ~sds_speechdpfi_tclMsgCommitUserwordFolderMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgCommitUserwordFolderMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgCommitUserwordFolderMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgCommitUserwordFolderMethodResult();

   virtual ~sds_speechdpfi_tclMsgCommitUserwordFolderMethodResult();

   inline tBool operator==(const sds_speechdpfi_tclMsgCommitUserwordFolderMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgRollbackUserwordFolderMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgRollbackUserwordFolderMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgRollbackUserwordFolderMethodStart& operator=(const sds_speechdpfi_tclMsgRollbackUserwordFolderMethodStart& coRef);
   sds_speechdpfi_tclMsgRollbackUserwordFolderMethodStart(const sds_speechdpfi_tclMsgRollbackUserwordFolderMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Cookie;
   virtual ~sds_speechdpfi_tclMsgRollbackUserwordFolderMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgRollbackUserwordFolderMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgRollbackUserwordFolderMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgRollbackUserwordFolderMethodResult();

   virtual ~sds_speechdpfi_tclMsgRollbackUserwordFolderMethodResult();

   inline tBool operator==(const sds_speechdpfi_tclMsgRollbackUserwordFolderMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDeleteUserwordMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDeleteUserwordMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgDeleteUserwordMethodStart& operator=(const sds_speechdpfi_tclMsgDeleteUserwordMethodStart& coRef);
   sds_speechdpfi_tclMsgDeleteUserwordMethodStart(const sds_speechdpfi_tclMsgDeleteUserwordMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tcl_e8_Domain DomainID;
   tU32 ProfileID;
   virtual ~sds_speechdpfi_tclMsgDeleteUserwordMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgDeleteUserwordMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDeleteUserwordMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDeleteUserwordMethodResult();

   virtual ~sds_speechdpfi_tclMsgDeleteUserwordMethodResult();

   inline tBool operator==(const sds_speechdpfi_tclMsgDeleteUserwordMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodStart();

   virtual ~sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodStart();

   inline tBool operator==(const sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodResult& operator=(const sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodResult& coRef);
   sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodResult(const sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_SpeakerInfoType, std::allocator<sds_fi_tcl_SpeakerInfoType> > AvailableSDSSpeakers;
   virtual ~sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodStart& operator=(const sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodStart& coRef);
   sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodStart(const sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tclString SlotName;
   virtual ~sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodResult& operator=(const sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodResult& coRef);
   sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodResult(const sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tclString, std::allocator<sds_fi_tclString> > CLCDictionaryFiles;
   virtual ~sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodStart& operator=(const sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodStart& coRef);
   sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodStart(const sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tclString, std::allocator<sds_fi_tclString> > StateShort;
   virtual ~sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodResult& operator=(const sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodResult& coRef);
   sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodResult(const sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tclString, std::allocator<sds_fi_tclString> > StateName;
   virtual ~sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetCountryNameMappingMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetCountryNameMappingMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetCountryNameMappingMethodStart& operator=(const sds_speechdpfi_tclMsgGetCountryNameMappingMethodStart& coRef);
   sds_speechdpfi_tclMsgGetCountryNameMappingMethodStart(const sds_speechdpfi_tclMsgGetCountryNameMappingMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e16_ISOCountryCode CountryCode;
   sds_fi_tcl_SDSLanguageID LanguageID;
   virtual ~sds_speechdpfi_tclMsgGetCountryNameMappingMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetCountryNameMappingMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetCountryNameMappingMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetCountryNameMappingMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetCountryNameMappingMethodResult& operator=(const sds_speechdpfi_tclMsgGetCountryNameMappingMethodResult& coRef);
   sds_speechdpfi_tclMsgGetCountryNameMappingMethodResult(const sds_speechdpfi_tclMsgGetCountryNameMappingMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString MappingCountryName;
   virtual ~sds_speechdpfi_tclMsgGetCountryNameMappingMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetCountryNameMappingMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodStart& operator=(const sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodStart& coRef);
   sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodStart(const sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSDestinationEntry FindCity;
   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tcl_e16_ISOCountryCode CountryCode;
   sds_fi_tclString CountryName;
   sds_fi_tcl_SDSDestinationEntry BelongingState;
   virtual ~sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodResult& operator=(const sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodResult& coRef);
   sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodResult(const sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU32, std::allocator<tU32> > IDs;
   virtual ~sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetDynamicContextListMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetDynamicContextListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetDynamicContextListMethodStart& operator=(const sds_speechdpfi_tclMsgGetDynamicContextListMethodStart& coRef);
   sds_speechdpfi_tclMsgGetDynamicContextListMethodStart(const sds_speechdpfi_tclMsgGetDynamicContextListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   std::vector<sds_fi_tcl_DynamicCtxStatus, std::allocator<sds_fi_tcl_DynamicCtxStatus> > DomainDeviceIDs;
   virtual ~sds_speechdpfi_tclMsgGetDynamicContextListMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetDynamicContextListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetDynamicContextListMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetDynamicContextListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetDynamicContextListMethodResult& operator=(const sds_speechdpfi_tclMsgGetDynamicContextListMethodResult& coRef);
   sds_speechdpfi_tclMsgGetDynamicContextListMethodResult(const sds_speechdpfi_tclMsgGetDynamicContextListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_DynamicDataContextMetaFile, std::allocator<sds_fi_tcl_DynamicDataContextMetaFile> > DeviceMetaFiles;
   virtual ~sds_speechdpfi_tclMsgGetDynamicContextListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetDynamicContextListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodStart& operator=(const sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodStart& coRef);
   sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodStart(const sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   std::vector<sds_fi_tcl_CurrentCity, std::allocator<sds_fi_tcl_CurrentCity> > CityIDs;
   virtual ~sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodResult& operator=(const sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodResult& coRef);
   sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodResult(const sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_CityWithStreets, std::allocator<sds_fi_tcl_CityWithStreets> > StreetsAvailability;
   virtual ~sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodStart& operator=(const sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodStart& coRef);
   sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodStart(const sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e16_ISOCountryCode CountryCode;
   sds_fi_tcl_SDSLanguageID LanguageID;
   tBool OnlyLanguageCodeMatch;
   virtual ~sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodResult& operator=(const sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodResult& coRef);
   sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodResult(const sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString MappingCountryName;
   virtual ~sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodStart& operator=(const sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodStart& coRef);
   sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodStart(const sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_SDSDestinationEntry, std::allocator<sds_fi_tcl_SDSDestinationEntry> > DestinationList;
   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tcl_e16_ISOCountryCode CountryCode;
   sds_fi_tclString CountryName;
   virtual ~sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodResult& operator=(const sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodResult& coRef);
   sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodResult(const sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_WordWithPhoneme, std::allocator<sds_fi_tcl_WordWithPhoneme> > PhonemeList;
   virtual ~sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodStart& operator=(const sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodStart& coRef);
   sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodStart(const sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_CurrentCountry Country;
   virtual ~sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodResult& operator=(const sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodResult& coRef);
   sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodResult(const sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_SDSLanguageID, std::allocator<sds_fi_tcl_SDSLanguageID> > SupportedLanguageList;
   virtual ~sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodStart();

   virtual ~sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodStart();

   inline tBool operator==(const sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodResult& operator=(const sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodResult& coRef);
   sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodResult(const sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID DefaultLanguageID;
   sds_fi_tclString DefaultSDSSpeaker;
   virtual ~sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetVcDataFilesMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetVcDataFilesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetVcDataFilesMethodStart& operator=(const sds_speechdpfi_tclMsgGetVcDataFilesMethodStart& coRef);
   sds_speechdpfi_tclMsgGetVcDataFilesMethodStart(const sds_speechdpfi_tclMsgGetVcDataFilesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tclString, std::allocator<sds_fi_tclString> > SectionList;
   virtual ~sds_speechdpfi_tclMsgGetVcDataFilesMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetVcDataFilesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetVcDataFilesMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetVcDataFilesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetVcDataFilesMethodResult& operator=(const sds_speechdpfi_tclMsgGetVcDataFilesMethodResult& coRef);
   sds_speechdpfi_tclMsgGetVcDataFilesMethodResult(const sds_speechdpfi_tclMsgGetVcDataFilesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_VcData, std::allocator<sds_fi_tcl_VcData> > DataFiles;
   virtual ~sds_speechdpfi_tclMsgGetVcDataFilesMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetVcDataFilesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetWUWordContextMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetWUWordContextMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetWUWordContextMethodStart& operator=(const sds_speechdpfi_tclMsgGetWUWordContextMethodStart& coRef);
   sds_speechdpfi_tclMsgGetWUWordContextMethodStart(const sds_speechdpfi_tclMsgGetWUWordContextMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   tU32 DeviceID;
   sds_fi_tcl_e8_Domain WUWDomainID;
   virtual ~sds_speechdpfi_tclMsgGetWUWordContextMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetWUWordContextMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetWUWordContextMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetWUWordContextMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetWUWordContextMethodResult& operator=(const sds_speechdpfi_tclMsgGetWUWordContextMethodResult& coRef);
   sds_speechdpfi_tclMsgGetWUWordContextMethodResult(const sds_speechdpfi_tclMsgGetWUWordContextMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString DynamicWUWMetaFile;
   sds_fi_tclString StaticWUWContext;
   virtual ~sds_speechdpfi_tclMsgGetWUWordContextMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetWUWordContextMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodStart& operator=(const sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodStart& coRef);
   sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodStart(const sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 FunctionID;
   virtual ~sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodResult();

   virtual ~sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodResult();

   inline tBool operator==(const sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodStart& operator=(const sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodStart& coRef);
   sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodStart(const sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > u8CmdValue;
   std::vector<sds_fi_tclString, std::allocator<sds_fi_tclString> > szStringParam;
   virtual ~sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodResult();

   virtual ~sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodResult();

   inline tBool operator==(const sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDeleteDynamicContextListMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDeleteDynamicContextListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgDeleteDynamicContextListMethodStart& operator=(const sds_speechdpfi_tclMsgDeleteDynamicContextListMethodStart& coRef);
   sds_speechdpfi_tclMsgDeleteDynamicContextListMethodStart(const sds_speechdpfi_tclMsgDeleteDynamicContextListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   std::vector<sds_fi_tcl_DynamicCtxStatus, std::allocator<sds_fi_tcl_DynamicCtxStatus> > DomainDeviceIDs;
   sds_fi_tcl_e8_StorageDevice StorageLocation;
   virtual ~sds_speechdpfi_tclMsgDeleteDynamicContextListMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgDeleteDynamicContextListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDeleteDynamicContextListMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDeleteDynamicContextListMethodResult();

   virtual ~sds_speechdpfi_tclMsgDeleteDynamicContextListMethodResult();

   inline tBool operator==(const sds_speechdpfi_tclMsgDeleteDynamicContextListMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetNaviAddressTypeMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetNaviAddressTypeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetNaviAddressTypeMethodStart& operator=(const sds_speechdpfi_tclMsgGetNaviAddressTypeMethodStart& coRef);
   sds_speechdpfi_tclMsgGetNaviAddressTypeMethodStart(const sds_speechdpfi_tclMsgGetNaviAddressTypeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tcl_CurrentCountry Country;
   sds_fi_tcl_CurrentState StateName;
   virtual ~sds_speechdpfi_tclMsgGetNaviAddressTypeMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetNaviAddressTypeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetNaviAddressTypeMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetNaviAddressTypeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetNaviAddressTypeMethodResult& operator=(const sds_speechdpfi_tclMsgGetNaviAddressTypeMethodResult& coRef);
   sds_speechdpfi_tclMsgGetNaviAddressTypeMethodResult(const sds_speechdpfi_tclMsgGetNaviAddressTypeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_e8_AddressType, std::allocator<sds_fi_tcl_e8_AddressType> > TypeList;
   virtual ~sds_speechdpfi_tclMsgGetNaviAddressTypeMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetNaviAddressTypeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodStart& operator=(const sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodStart& coRef);
   sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodStart(const sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tcl_CurrentCountry Country;
   sds_fi_tcl_CurrentState StateName;
   virtual ~sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodResult& operator=(const sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodResult& coRef);
   sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodResult(const sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_CurrentCountry CountryURIds;
   sds_fi_tcl_CurrentState StateURIds;
   virtual ~sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetVoconConfigurationMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetVoconConfigurationMethodStart();

   virtual ~sds_speechdpfi_tclMsgGetVoconConfigurationMethodStart();

   inline tBool operator==(const sds_speechdpfi_tclMsgGetVoconConfigurationMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetVoconConfigurationMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetVoconConfigurationMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetVoconConfigurationMethodResult& operator=(const sds_speechdpfi_tclMsgGetVoconConfigurationMethodResult& coRef);
   sds_speechdpfi_tclMsgGetVoconConfigurationMethodResult(const sds_speechdpfi_tclMsgGetVoconConfigurationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString ConfigFile;
   virtual ~sds_speechdpfi_tclMsgGetVoconConfigurationMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetVoconConfigurationMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetNumericCountryCodeMethodStart : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetNumericCountryCodeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetNumericCountryCodeMethodStart& operator=(const sds_speechdpfi_tclMsgGetNumericCountryCodeMethodStart& coRef);
   sds_speechdpfi_tclMsgGetNumericCountryCodeMethodStart(const sds_speechdpfi_tclMsgGetNumericCountryCodeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_NDSID Country;
   sds_fi_tclString CountryName;
   virtual ~sds_speechdpfi_tclMsgGetNumericCountryCodeMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetNumericCountryCodeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgGetNumericCountryCodeMethodResult : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgGetNumericCountryCodeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgGetNumericCountryCodeMethodResult& operator=(const sds_speechdpfi_tclMsgGetNumericCountryCodeMethodResult& coRef);
   sds_speechdpfi_tclMsgGetNumericCountryCodeMethodResult(const sds_speechdpfi_tclMsgGetNumericCountryCodeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e16_ISOCountryCode ISOCountrycode;
   virtual ~sds_speechdpfi_tclMsgGetNumericCountryCodeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgGetNumericCountryCodeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDataCarrierInsertedGet : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDataCarrierInsertedGet();

   virtual ~sds_speechdpfi_tclMsgDataCarrierInsertedGet();

   inline tBool operator==(const sds_speechdpfi_tclMsgDataCarrierInsertedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDataCarrierInsertedUpReg : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDataCarrierInsertedUpReg();

   virtual ~sds_speechdpfi_tclMsgDataCarrierInsertedUpReg();

   inline tBool operator==(const sds_speechdpfi_tclMsgDataCarrierInsertedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDataCarrierInsertedRelUpReg : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDataCarrierInsertedRelUpReg();

   virtual ~sds_speechdpfi_tclMsgDataCarrierInsertedRelUpReg();

   inline tBool operator==(const sds_speechdpfi_tclMsgDataCarrierInsertedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDataCarrierInsertedStatus : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDataCarrierInsertedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgDataCarrierInsertedStatus& operator=(const sds_speechdpfi_tclMsgDataCarrierInsertedStatus& coRef);
   sds_speechdpfi_tclMsgDataCarrierInsertedStatus(const sds_speechdpfi_tclMsgDataCarrierInsertedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool DataCarrierInserted;
   virtual ~sds_speechdpfi_tclMsgDataCarrierInsertedStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgDataCarrierInsertedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgConsistencyCheckReadyGet : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgConsistencyCheckReadyGet();

   virtual ~sds_speechdpfi_tclMsgConsistencyCheckReadyGet();

   inline tBool operator==(const sds_speechdpfi_tclMsgConsistencyCheckReadyGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgConsistencyCheckReadyUpReg : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgConsistencyCheckReadyUpReg();

   virtual ~sds_speechdpfi_tclMsgConsistencyCheckReadyUpReg();

   inline tBool operator==(const sds_speechdpfi_tclMsgConsistencyCheckReadyUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgConsistencyCheckReadyRelUpReg : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgConsistencyCheckReadyRelUpReg();

   virtual ~sds_speechdpfi_tclMsgConsistencyCheckReadyRelUpReg();

   inline tBool operator==(const sds_speechdpfi_tclMsgConsistencyCheckReadyRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgConsistencyCheckReadyStatus : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgConsistencyCheckReadyStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgConsistencyCheckReadyStatus& operator=(const sds_speechdpfi_tclMsgConsistencyCheckReadyStatus& coRef);
   sds_speechdpfi_tclMsgConsistencyCheckReadyStatus(const sds_speechdpfi_tclMsgConsistencyCheckReadyStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Complete;
   virtual ~sds_speechdpfi_tclMsgConsistencyCheckReadyStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgConsistencyCheckReadyStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgSDPSWVersionGet : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgSDPSWVersionGet();

   virtual ~sds_speechdpfi_tclMsgSDPSWVersionGet();

   inline tBool operator==(const sds_speechdpfi_tclMsgSDPSWVersionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgSDPSWVersionUpReg : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgSDPSWVersionUpReg();

   virtual ~sds_speechdpfi_tclMsgSDPSWVersionUpReg();

   inline tBool operator==(const sds_speechdpfi_tclMsgSDPSWVersionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgSDPSWVersionRelUpReg : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgSDPSWVersionRelUpReg();

   virtual ~sds_speechdpfi_tclMsgSDPSWVersionRelUpReg();

   inline tBool operator==(const sds_speechdpfi_tclMsgSDPSWVersionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgSDPSWVersionStatus : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgSDPSWVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgSDPSWVersionStatus& operator=(const sds_speechdpfi_tclMsgSDPSWVersionStatus& coRef);
   sds_speechdpfi_tclMsgSDPSWVersionStatus(const sds_speechdpfi_tclMsgSDPSWVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString SWVersion;
   virtual ~sds_speechdpfi_tclMsgSDPSWVersionStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgSDPSWVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDownloadCompleteGet : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDownloadCompleteGet();

   virtual ~sds_speechdpfi_tclMsgDownloadCompleteGet();

   inline tBool operator==(const sds_speechdpfi_tclMsgDownloadCompleteGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDownloadCompleteUpReg : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDownloadCompleteUpReg();

   virtual ~sds_speechdpfi_tclMsgDownloadCompleteUpReg();

   inline tBool operator==(const sds_speechdpfi_tclMsgDownloadCompleteUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDownloadCompleteRelUpReg : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDownloadCompleteRelUpReg();

   virtual ~sds_speechdpfi_tclMsgDownloadCompleteRelUpReg();

   inline tBool operator==(const sds_speechdpfi_tclMsgDownloadCompleteRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgDownloadCompleteStatus : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgDownloadCompleteStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgDownloadCompleteStatus& operator=(const sds_speechdpfi_tclMsgDownloadCompleteStatus& coRef);
   sds_speechdpfi_tclMsgDownloadCompleteStatus(const sds_speechdpfi_tclMsgDownloadCompleteStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Complete;
   virtual ~sds_speechdpfi_tclMsgDownloadCompleteStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgDownloadCompleteStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgLanguageDownloadCompleteGet : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgLanguageDownloadCompleteGet();

   virtual ~sds_speechdpfi_tclMsgLanguageDownloadCompleteGet();

   inline tBool operator==(const sds_speechdpfi_tclMsgLanguageDownloadCompleteGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgLanguageDownloadCompleteUpReg : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgLanguageDownloadCompleteUpReg();

   virtual ~sds_speechdpfi_tclMsgLanguageDownloadCompleteUpReg();

   inline tBool operator==(const sds_speechdpfi_tclMsgLanguageDownloadCompleteUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgLanguageDownloadCompleteRelUpReg : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgLanguageDownloadCompleteRelUpReg();

   virtual ~sds_speechdpfi_tclMsgLanguageDownloadCompleteRelUpReg();

   inline tBool operator==(const sds_speechdpfi_tclMsgLanguageDownloadCompleteRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgLanguageDownloadCompleteStatus : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgLanguageDownloadCompleteStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgLanguageDownloadCompleteStatus& operator=(const sds_speechdpfi_tclMsgLanguageDownloadCompleteStatus& coRef);
   sds_speechdpfi_tclMsgLanguageDownloadCompleteStatus(const sds_speechdpfi_tclMsgLanguageDownloadCompleteStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Complete;
   virtual ~sds_speechdpfi_tclMsgLanguageDownloadCompleteStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgLanguageDownloadCompleteStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgCountryDownloadCompleteGet : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgCountryDownloadCompleteGet();

   virtual ~sds_speechdpfi_tclMsgCountryDownloadCompleteGet();

   inline tBool operator==(const sds_speechdpfi_tclMsgCountryDownloadCompleteGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgCountryDownloadCompleteUpReg : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgCountryDownloadCompleteUpReg();

   virtual ~sds_speechdpfi_tclMsgCountryDownloadCompleteUpReg();

   inline tBool operator==(const sds_speechdpfi_tclMsgCountryDownloadCompleteUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgCountryDownloadCompleteRelUpReg : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgCountryDownloadCompleteRelUpReg();

   virtual ~sds_speechdpfi_tclMsgCountryDownloadCompleteRelUpReg();

   inline tBool operator==(const sds_speechdpfi_tclMsgCountryDownloadCompleteRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgCountryDownloadCompleteStatus : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgCountryDownloadCompleteStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgCountryDownloadCompleteStatus& operator=(const sds_speechdpfi_tclMsgCountryDownloadCompleteStatus& coRef);
   sds_speechdpfi_tclMsgCountryDownloadCompleteStatus(const sds_speechdpfi_tclMsgCountryDownloadCompleteStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Complete;
   virtual ~sds_speechdpfi_tclMsgCountryDownloadCompleteStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgCountryDownloadCompleteStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgSDNLocationFoundGet : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgSDNLocationFoundGet();

   virtual ~sds_speechdpfi_tclMsgSDNLocationFoundGet();

   inline tBool operator==(const sds_speechdpfi_tclMsgSDNLocationFoundGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgSDNLocationFoundUpReg : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgSDNLocationFoundUpReg();

   virtual ~sds_speechdpfi_tclMsgSDNLocationFoundUpReg();

   inline tBool operator==(const sds_speechdpfi_tclMsgSDNLocationFoundUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgSDNLocationFoundRelUpReg : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgSDNLocationFoundRelUpReg();

   virtual ~sds_speechdpfi_tclMsgSDNLocationFoundRelUpReg();

   inline tBool operator==(const sds_speechdpfi_tclMsgSDNLocationFoundRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgSDNLocationFoundStatus : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgSDNLocationFoundStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgSDNLocationFoundStatus& operator=(const sds_speechdpfi_tclMsgSDNLocationFoundStatus& coRef);
   sds_speechdpfi_tclMsgSDNLocationFoundStatus(const sds_speechdpfi_tclMsgSDNLocationFoundStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_SDNLocation SDNLocation;
   virtual ~sds_speechdpfi_tclMsgSDNLocationFoundStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgSDNLocationFoundStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgUpdateCountryStateListGet : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgUpdateCountryStateListGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgUpdateCountryStateListGet& operator=(const sds_speechdpfi_tclMsgUpdateCountryStateListGet& coRef);
   sds_speechdpfi_tclMsgUpdateCountryStateListGet(const sds_speechdpfi_tclMsgUpdateCountryStateListGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_CountryPhoneme, std::allocator<sds_fi_tcl_CountryPhoneme> > CountryStateList;
   virtual ~sds_speechdpfi_tclMsgUpdateCountryStateListGet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgUpdateCountryStateListGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgUpdateCountryStateListRelUpReg : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgUpdateCountryStateListRelUpReg();

   virtual ~sds_speechdpfi_tclMsgUpdateCountryStateListRelUpReg();

   inline tBool operator==(const sds_speechdpfi_tclMsgUpdateCountryStateListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgUpdateCountryStateListStatus : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgUpdateCountryStateListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_speechdpfi_tclMsgUpdateCountryStateListStatus& operator=(const sds_speechdpfi_tclMsgUpdateCountryStateListStatus& coRef);
   sds_speechdpfi_tclMsgUpdateCountryStateListStatus(const sds_speechdpfi_tclMsgUpdateCountryStateListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_CountryPhoneme, std::allocator<sds_fi_tcl_CountryPhoneme> > CountryStateList;
   virtual ~sds_speechdpfi_tclMsgUpdateCountryStateListStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_speechdpfi_tclMsgUpdateCountryStateListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_speechdpfi_tclMsgUpdateCountryStateListUpReg : public sds_speechdpfi_tclMsgBaseMessage
{
public:

   sds_speechdpfi_tclMsgUpdateCountryStateListUpReg();

   virtual ~sds_speechdpfi_tclMsgUpdateCountryStateListUpReg();

   inline tBool operator==(const sds_speechdpfi_tclMsgUpdateCountryStateListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};


#endif
