/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef SDS_REC_VOCONSERVICEFITYPES_HEADER
#define SDS_REC_VOCONSERVICEFITYPES_HEADER


class sds_rec_voconservicefi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for SDS_REC_VOCONSERVICE_FI message types

fi_tclMessageBase* sds_rec_voconservicefi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class sds_rec_voconservicefi_tclMsgBaseMessage : public sds_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   sds_rec_voconservicefi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodStart : public sds_rec_voconservicefi_tclMsgBaseMessage
{
public:

   sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodStart& operator=(const sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodStart& coRef);
   sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodStart(const sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_VoconComponent e8VoconComponent;
   virtual ~sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodResult : public sds_rec_voconservicefi_tclMsgBaseMessage
{
public:

   sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodResult& operator=(const sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodResult& coRef);
   sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodResult(const sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_u64_tPVoid poComponent;
   virtual ~sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodStart : public sds_rec_voconservicefi_tclMsgBaseMessage
{
public:

   sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodStart& operator=(const sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodStart& coRef);
   sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodStart(const sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_VoconComponent e8VoconComponent;
   virtual ~sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodResult : public sds_rec_voconservicefi_tclMsgBaseMessage
{
public:

   sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodResult();

   virtual ~sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodResult();

   inline tBool operator==(const sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_voconservicefi_tclMsgReInitializeVoconComponentMethodStart : public sds_rec_voconservicefi_tclMsgBaseMessage
{
public:

   sds_rec_voconservicefi_tclMsgReInitializeVoconComponentMethodStart();

   virtual ~sds_rec_voconservicefi_tclMsgReInitializeVoconComponentMethodStart();

   inline tBool operator==(const sds_rec_voconservicefi_tclMsgReInitializeVoconComponentMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_voconservicefi_tclMsgReInitializeVoconComponentMethodResult : public sds_rec_voconservicefi_tclMsgBaseMessage
{
public:

   sds_rec_voconservicefi_tclMsgReInitializeVoconComponentMethodResult();

   virtual ~sds_rec_voconservicefi_tclMsgReInitializeVoconComponentMethodResult();

   inline tBool operator==(const sds_rec_voconservicefi_tclMsgReInitializeVoconComponentMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_voconservicefi_tclMsgVoconComponentsStatusGet : public sds_rec_voconservicefi_tclMsgBaseMessage
{
public:

   sds_rec_voconservicefi_tclMsgVoconComponentsStatusGet();

   virtual ~sds_rec_voconservicefi_tclMsgVoconComponentsStatusGet();

   inline tBool operator==(const sds_rec_voconservicefi_tclMsgVoconComponentsStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_voconservicefi_tclMsgVoconComponentsStatusUpReg : public sds_rec_voconservicefi_tclMsgBaseMessage
{
public:

   sds_rec_voconservicefi_tclMsgVoconComponentsStatusUpReg();

   virtual ~sds_rec_voconservicefi_tclMsgVoconComponentsStatusUpReg();

   inline tBool operator==(const sds_rec_voconservicefi_tclMsgVoconComponentsStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_voconservicefi_tclMsgVoconComponentsStatusRelUpReg : public sds_rec_voconservicefi_tclMsgBaseMessage
{
public:

   sds_rec_voconservicefi_tclMsgVoconComponentsStatusRelUpReg();

   virtual ~sds_rec_voconservicefi_tclMsgVoconComponentsStatusRelUpReg();

   inline tBool operator==(const sds_rec_voconservicefi_tclMsgVoconComponentsStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_voconservicefi_tclMsgVoconComponentsStatusStatus : public sds_rec_voconservicefi_tclMsgBaseMessage
{
public:

   sds_rec_voconservicefi_tclMsgVoconComponentsStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_voconservicefi_tclMsgVoconComponentsStatusStatus& operator=(const sds_rec_voconservicefi_tclMsgVoconComponentsStatusStatus& coRef);
   sds_rec_voconservicefi_tclMsgVoconComponentsStatusStatus(const sds_rec_voconservicefi_tclMsgVoconComponentsStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_VoconComponentStatus VoconAsrStatus;
   sds_fi_tcl_e8_VoconComponentStatus VoconSemStatus;
   sds_fi_tcl_e8_VoconComponentStatus VoconPronStatus;
   virtual ~sds_rec_voconservicefi_tclMsgVoconComponentsStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_voconservicefi_tclMsgVoconComponentsStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
