/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
// =============================================================================
//
//                Factory for SDS_REC_VOCONSERVICE_FI message types

fi_tclMessageBase* sds_rec_voconservicefi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case sds_rec_voconservicefi_tclToken::EN_MSG_GETVOCONBASECOMPONENTMETHODSTART:
         return OSAL_NEW sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodStart;

      case sds_rec_voconservicefi_tclToken::EN_MSG_GETVOCONBASECOMPONENTMETHODRESULT:
         return OSAL_NEW sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodResult;

      case sds_rec_voconservicefi_tclToken::EN_MSG_CLOSEVOCONOBJECTSMETHODSTART:
         return OSAL_NEW sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodStart;

      case sds_rec_voconservicefi_tclToken::EN_MSG_CLOSEVOCONOBJECTSMETHODRESULT:
         return OSAL_NEW sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodResult;

      case sds_rec_voconservicefi_tclToken::EN_MSG_REINITIALIZEVOCONCOMPONENTMETHODSTART:
         return OSAL_NEW sds_rec_voconservicefi_tclMsgReInitializeVoconComponentMethodStart;

      case sds_rec_voconservicefi_tclToken::EN_MSG_REINITIALIZEVOCONCOMPONENTMETHODRESULT:
         return OSAL_NEW sds_rec_voconservicefi_tclMsgReInitializeVoconComponentMethodResult;

      case sds_rec_voconservicefi_tclToken::EN_MSG_VOCONCOMPONENTSSTATUSGET:
         return OSAL_NEW sds_rec_voconservicefi_tclMsgVoconComponentsStatusGet;

      case sds_rec_voconservicefi_tclToken::EN_MSG_VOCONCOMPONENTSSTATUSUPREG:
         return OSAL_NEW sds_rec_voconservicefi_tclMsgVoconComponentsStatusUpReg;

      case sds_rec_voconservicefi_tclToken::EN_MSG_VOCONCOMPONENTSSTATUSRELUPREG:
         return OSAL_NEW sds_rec_voconservicefi_tclMsgVoconComponentsStatusRelUpReg;

      case sds_rec_voconservicefi_tclToken::EN_MSG_VOCONCOMPONENTSSTATUSSTATUS:
         return OSAL_NEW sds_rec_voconservicefi_tclMsgVoconComponentsStatusStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all sds_rec_voconservicefifi messages

// common functions

tU16 sds_rec_voconservicefi_tclMsgBaseMessage::u16GetServiceID() const
{
   return SDS_REC_VOCONSERVICEFI_C_U16_SERVICE_ID;
}

tU16 sds_rec_voconservicefi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 sds_rec_voconservicefi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& sds_rec_voconservicefi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& sds_rec_voconservicefi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 sds_rec_voconservicefi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& sds_rec_voconservicefi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& sds_rec_voconservicefi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodStart::sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodStart(const sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodStart& coRef)
   : sds_rec_voconservicefi_tclMsgBaseMessage(coRef)
{
   e8VoconComponent = coRef.e8VoconComponent;
}
sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodStart& sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodStart::operator=(const sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8VoconComponent = coRef.e8VoconComponent;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodStart::sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodStart()
:e8VoconComponent()
 {}

tS32 sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_voconservicefi_tclToken::EN_MSG_GETVOCONBASECOMPONENTMETHODSTART;
}


sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodStart::~sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodStart()
{}

tU32 sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8VoconComponent);
   return oIn;
}

fi_tclOutContext& sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8VoconComponent);
   return oOut;
}

tBool sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodStart::operator==(const sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8VoconComponent == roRef.e8VoconComponent);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodResult::sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodResult(const sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodResult& coRef)
   : sds_rec_voconservicefi_tclMsgBaseMessage(coRef)
{
   poComponent = coRef.poComponent;
}
sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodResult& sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodResult::operator=(const sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodResult& coRef)
{
   if (this == &coRef) return *this;
   poComponent = coRef.poComponent;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodResult::sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodResult()
:poComponent()
 {}

tS32 sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_voconservicefi_tclToken::EN_MSG_GETVOCONBASECOMPONENTMETHODRESULT;
}


sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodResult::~sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodResult()
{}

tU32 sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> poComponent);
   return oIn;
}

fi_tclOutContext& sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << poComponent);
   return oOut;
}

tBool sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodResult::operator==(const sds_rec_voconservicefi_tclMsgGetVoconBaseComponentMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (poComponent == roRef.poComponent);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodStart::sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodStart(const sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodStart& coRef)
   : sds_rec_voconservicefi_tclMsgBaseMessage(coRef)
{
   e8VoconComponent = coRef.e8VoconComponent;
}
sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodStart& sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodStart::operator=(const sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8VoconComponent = coRef.e8VoconComponent;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodStart::sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodStart()
:e8VoconComponent()
 {}

tS32 sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_voconservicefi_tclToken::EN_MSG_CLOSEVOCONOBJECTSMETHODSTART;
}


sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodStart::~sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodStart()
{}

tU32 sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8VoconComponent);
   return oIn;
}

fi_tclOutContext& sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8VoconComponent);
   return oOut;
}

tBool sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodStart::operator==(const sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8VoconComponent == roRef.e8VoconComponent);
   return bResult;
}

//=============================================================================

sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodResult::sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodResult()
 {}

tS32 sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_voconservicefi_tclToken::EN_MSG_CLOSEVOCONOBJECTSMETHODRESULT;
}


sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodResult::~sds_rec_voconservicefi_tclMsgCloseVoconObjectsMethodResult()
{}

//=============================================================================

sds_rec_voconservicefi_tclMsgReInitializeVoconComponentMethodStart::sds_rec_voconservicefi_tclMsgReInitializeVoconComponentMethodStart()
 {}

tS32 sds_rec_voconservicefi_tclMsgReInitializeVoconComponentMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_voconservicefi_tclToken::EN_MSG_REINITIALIZEVOCONCOMPONENTMETHODSTART;
}


sds_rec_voconservicefi_tclMsgReInitializeVoconComponentMethodStart::~sds_rec_voconservicefi_tclMsgReInitializeVoconComponentMethodStart()
{}

//=============================================================================

sds_rec_voconservicefi_tclMsgReInitializeVoconComponentMethodResult::sds_rec_voconservicefi_tclMsgReInitializeVoconComponentMethodResult()
 {}

tS32 sds_rec_voconservicefi_tclMsgReInitializeVoconComponentMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_voconservicefi_tclToken::EN_MSG_REINITIALIZEVOCONCOMPONENTMETHODRESULT;
}


sds_rec_voconservicefi_tclMsgReInitializeVoconComponentMethodResult::~sds_rec_voconservicefi_tclMsgReInitializeVoconComponentMethodResult()
{}

//=============================================================================

sds_rec_voconservicefi_tclMsgVoconComponentsStatusGet::sds_rec_voconservicefi_tclMsgVoconComponentsStatusGet()
 {}

tS32 sds_rec_voconservicefi_tclMsgVoconComponentsStatusGet::s32GetTypeId() const
{
   return (tS32) sds_rec_voconservicefi_tclToken::EN_MSG_VOCONCOMPONENTSSTATUSGET;
}


sds_rec_voconservicefi_tclMsgVoconComponentsStatusGet::~sds_rec_voconservicefi_tclMsgVoconComponentsStatusGet()
{}

//=============================================================================

sds_rec_voconservicefi_tclMsgVoconComponentsStatusUpReg::sds_rec_voconservicefi_tclMsgVoconComponentsStatusUpReg()
 {}

tS32 sds_rec_voconservicefi_tclMsgVoconComponentsStatusUpReg::s32GetTypeId() const
{
   return (tS32) sds_rec_voconservicefi_tclToken::EN_MSG_VOCONCOMPONENTSSTATUSUPREG;
}


sds_rec_voconservicefi_tclMsgVoconComponentsStatusUpReg::~sds_rec_voconservicefi_tclMsgVoconComponentsStatusUpReg()
{}

//=============================================================================

sds_rec_voconservicefi_tclMsgVoconComponentsStatusRelUpReg::sds_rec_voconservicefi_tclMsgVoconComponentsStatusRelUpReg()
 {}

tS32 sds_rec_voconservicefi_tclMsgVoconComponentsStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_rec_voconservicefi_tclToken::EN_MSG_VOCONCOMPONENTSSTATUSRELUPREG;
}


sds_rec_voconservicefi_tclMsgVoconComponentsStatusRelUpReg::~sds_rec_voconservicefi_tclMsgVoconComponentsStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_voconservicefi_tclMsgVoconComponentsStatusStatus::sds_rec_voconservicefi_tclMsgVoconComponentsStatusStatus(const sds_rec_voconservicefi_tclMsgVoconComponentsStatusStatus& coRef)
   : sds_rec_voconservicefi_tclMsgBaseMessage(coRef)
{
   VoconAsrStatus = coRef.VoconAsrStatus;
   VoconSemStatus = coRef.VoconSemStatus;
   VoconPronStatus = coRef.VoconPronStatus;
}
sds_rec_voconservicefi_tclMsgVoconComponentsStatusStatus& sds_rec_voconservicefi_tclMsgVoconComponentsStatusStatus::operator=(const sds_rec_voconservicefi_tclMsgVoconComponentsStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   VoconAsrStatus = coRef.VoconAsrStatus;
   VoconSemStatus = coRef.VoconSemStatus;
   VoconPronStatus = coRef.VoconPronStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_rec_voconservicefi_tclMsgVoconComponentsStatusStatus::sds_rec_voconservicefi_tclMsgVoconComponentsStatusStatus()
:VoconAsrStatus()
,VoconSemStatus()
,VoconPronStatus()
 {}

tS32 sds_rec_voconservicefi_tclMsgVoconComponentsStatusStatus::s32GetTypeId() const
{
   return (tS32) sds_rec_voconservicefi_tclToken::EN_MSG_VOCONCOMPONENTSSTATUSSTATUS;
}


sds_rec_voconservicefi_tclMsgVoconComponentsStatusStatus::~sds_rec_voconservicefi_tclMsgVoconComponentsStatusStatus()
{}

tU32 sds_rec_voconservicefi_tclMsgVoconComponentsStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& sds_rec_voconservicefi_tclMsgVoconComponentsStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VoconAsrStatus);
   (tVoid) (oIn >> VoconSemStatus);
   (tVoid) (oIn >> VoconPronStatus);
   return oIn;
}

fi_tclOutContext& sds_rec_voconservicefi_tclMsgVoconComponentsStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VoconAsrStatus);
   (tVoid) (oOut << VoconSemStatus);
   (tVoid) (oOut << VoconPronStatus);
   return oOut;
}

tBool sds_rec_voconservicefi_tclMsgVoconComponentsStatusStatus::operator==(const sds_rec_voconservicefi_tclMsgVoconComponentsStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VoconAsrStatus == roRef.VoconAsrStatus);
   bResult = bResult && (VoconSemStatus == roRef.VoconSemStatus);
   bResult = bResult && (VoconPronStatus == roRef.VoconPronStatus);
   return bResult;
}

