/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef SDS_PROMPTPLAYERFITYPES_HEADER
#define SDS_PROMPTPLAYERFITYPES_HEADER


class sds_promptplayerfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for SDS_PROMPTPLAYER_FI message types

fi_tclMessageBase* sds_promptplayerfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class sds_promptplayerfi_tclMsgBaseMessage : public sds_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   sds_promptplayerfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class sds_promptplayerfi_tclMsgSetSpeakerMethodStart : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgSetSpeakerMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_promptplayerfi_tclMsgSetSpeakerMethodStart& operator=(const sds_promptplayerfi_tclMsgSetSpeakerMethodStart& coRef);
   sds_promptplayerfi_tclMsgSetSpeakerMethodStart(const sds_promptplayerfi_tclMsgSetSpeakerMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_VoiceType Speaker;
   virtual ~sds_promptplayerfi_tclMsgSetSpeakerMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_promptplayerfi_tclMsgSetSpeakerMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgSetSpeakerMethodResult : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgSetSpeakerMethodResult();

   virtual ~sds_promptplayerfi_tclMsgSetSpeakerMethodResult();

   inline tBool operator==(const sds_promptplayerfi_tclMsgSetSpeakerMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgSpeechDataContentsMethodStart : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgSpeechDataContentsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_promptplayerfi_tclMsgSpeechDataContentsMethodStart& operator=(const sds_promptplayerfi_tclMsgSpeechDataContentsMethodStart& coRef);
   sds_promptplayerfi_tclMsgSpeechDataContentsMethodStart(const sds_promptplayerfi_tclMsgSpeechDataContentsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString FileName;
   tU32 StartAddress;
   tU32 NoOfBytes;
   virtual ~sds_promptplayerfi_tclMsgSpeechDataContentsMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_promptplayerfi_tclMsgSpeechDataContentsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgSpeechDataContentsMethodResult : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgSpeechDataContentsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_promptplayerfi_tclMsgSpeechDataContentsMethodResult& operator=(const sds_promptplayerfi_tclMsgSpeechDataContentsMethodResult& coRef);
   sds_promptplayerfi_tclMsgSpeechDataContentsMethodResult(const sds_promptplayerfi_tclMsgSpeechDataContentsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > SD_Contents;
   virtual ~sds_promptplayerfi_tclMsgSpeechDataContentsMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_promptplayerfi_tclMsgSpeechDataContentsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgReleaseDataMethodStart : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgReleaseDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_promptplayerfi_tclMsgReleaseDataMethodStart& operator=(const sds_promptplayerfi_tclMsgReleaseDataMethodStart& coRef);
   sds_promptplayerfi_tclMsgReleaseDataMethodStart(const sds_promptplayerfi_tclMsgReleaseDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_ReleaseTypePP ReleaseType;
   virtual ~sds_promptplayerfi_tclMsgReleaseDataMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_promptplayerfi_tclMsgReleaseDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgReleaseDataMethodResult : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgReleaseDataMethodResult();

   virtual ~sds_promptplayerfi_tclMsgReleaseDataMethodResult();

   inline tBool operator==(const sds_promptplayerfi_tclMsgReleaseDataMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgSetDlgApplicationMethodStart : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgSetDlgApplicationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_promptplayerfi_tclMsgSetDlgApplicationMethodStart& operator=(const sds_promptplayerfi_tclMsgSetDlgApplicationMethodStart& coRef);
   sds_promptplayerfi_tclMsgSetDlgApplicationMethodStart(const sds_promptplayerfi_tclMsgSetDlgApplicationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_DlgAppID DlgApplication;
   virtual ~sds_promptplayerfi_tclMsgSetDlgApplicationMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_promptplayerfi_tclMsgSetDlgApplicationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgSetDlgApplicationMethodResult : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgSetDlgApplicationMethodResult();

   virtual ~sds_promptplayerfi_tclMsgSetDlgApplicationMethodResult();

   inline tBool operator==(const sds_promptplayerfi_tclMsgSetDlgApplicationMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgPlayMethodStart : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgPlayMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_promptplayerfi_tclMsgPlayMethodStart& operator=(const sds_promptplayerfi_tclMsgPlayMethodStart& coRef);
   sds_promptplayerfi_tclMsgPlayMethodStart(const sds_promptplayerfi_tclMsgPlayMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 SentenceID;
   std::vector<sds_fi_tcl_PhraseVariable, std::allocator<sds_fi_tcl_PhraseVariable> > PhraseVariables;
   virtual ~sds_promptplayerfi_tclMsgPlayMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_promptplayerfi_tclMsgPlayMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgPlayMethodResultFirst : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgPlayMethodResultFirst();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_promptplayerfi_tclMsgPlayMethodResultFirst& operator=(const sds_promptplayerfi_tclMsgPlayMethodResultFirst& coRef);
   sds_promptplayerfi_tclMsgPlayMethodResultFirst(const sds_promptplayerfi_tclMsgPlayMethodResultFirst& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_PlayProgress PlayProgress;
   virtual ~sds_promptplayerfi_tclMsgPlayMethodResultFirst();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_promptplayerfi_tclMsgPlayMethodResultFirst& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgPlayMethodResultMiddle : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgPlayMethodResultMiddle();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_promptplayerfi_tclMsgPlayMethodResultMiddle& operator=(const sds_promptplayerfi_tclMsgPlayMethodResultMiddle& coRef);
   sds_promptplayerfi_tclMsgPlayMethodResultMiddle(const sds_promptplayerfi_tclMsgPlayMethodResultMiddle& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_PlayProgress, std::allocator<sds_fi_tcl_PlayProgress> > PlayProgress;
   virtual ~sds_promptplayerfi_tclMsgPlayMethodResultMiddle();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_promptplayerfi_tclMsgPlayMethodResultMiddle& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgPlayMethodResultLast : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgPlayMethodResultLast();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_promptplayerfi_tclMsgPlayMethodResultLast& operator=(const sds_promptplayerfi_tclMsgPlayMethodResultLast& coRef);
   sds_promptplayerfi_tclMsgPlayMethodResultLast(const sds_promptplayerfi_tclMsgPlayMethodResultLast& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_PlayProgress PlayProgress;
   virtual ~sds_promptplayerfi_tclMsgPlayMethodResultLast();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_promptplayerfi_tclMsgPlayMethodResultLast& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgStopMethodStart : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgStopMethodStart();

   virtual ~sds_promptplayerfi_tclMsgStopMethodStart();

   inline tBool operator==(const sds_promptplayerfi_tclMsgStopMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgStopMethodResult : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgStopMethodResult();

   virtual ~sds_promptplayerfi_tclMsgStopMethodResult();

   inline tBool operator==(const sds_promptplayerfi_tclMsgStopMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgPauseMethodStart : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgPauseMethodStart();

   virtual ~sds_promptplayerfi_tclMsgPauseMethodStart();

   inline tBool operator==(const sds_promptplayerfi_tclMsgPauseMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgPauseMethodResult : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgPauseMethodResult();

   virtual ~sds_promptplayerfi_tclMsgPauseMethodResult();

   inline tBool operator==(const sds_promptplayerfi_tclMsgPauseMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgResumeMethodStart : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgResumeMethodStart();

   virtual ~sds_promptplayerfi_tclMsgResumeMethodStart();

   inline tBool operator==(const sds_promptplayerfi_tclMsgResumeMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgResumeMethodResult : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgResumeMethodResult();

   virtual ~sds_promptplayerfi_tclMsgResumeMethodResult();

   inline tBool operator==(const sds_promptplayerfi_tclMsgResumeMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgtesttestMethodStart : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgtesttestMethodStart();

   virtual ~sds_promptplayerfi_tclMsgtesttestMethodStart();

   inline tBool operator==(const sds_promptplayerfi_tclMsgtesttestMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgtesttestMethodResult : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgtesttestMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_promptplayerfi_tclMsgtesttestMethodResult& operator=(const sds_promptplayerfi_tclMsgtesttestMethodResult& coRef);
   sds_promptplayerfi_tclMsgtesttestMethodResult(const sds_promptplayerfi_tclMsgtesttestMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 abctest;
   virtual ~sds_promptplayerfi_tclMsgtesttestMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_promptplayerfi_tclMsgtesttestMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgSet2DefaultMethodStart : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgSet2DefaultMethodStart();

   virtual ~sds_promptplayerfi_tclMsgSet2DefaultMethodStart();

   inline tBool operator==(const sds_promptplayerfi_tclMsgSet2DefaultMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgSet2DefaultMethodResult : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgSet2DefaultMethodResult();

   virtual ~sds_promptplayerfi_tclMsgSet2DefaultMethodResult();

   inline tBool operator==(const sds_promptplayerfi_tclMsgSet2DefaultMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgVoiceAdviceMethodStart : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgVoiceAdviceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_promptplayerfi_tclMsgVoiceAdviceMethodStart& operator=(const sds_promptplayerfi_tclMsgVoiceAdviceMethodStart& coRef);
   sds_promptplayerfi_tclMsgVoiceAdviceMethodStart(const sds_promptplayerfi_tclMsgVoiceAdviceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_AudioChannelAdvice AudioChannelAdvice;
   virtual ~sds_promptplayerfi_tclMsgVoiceAdviceMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_promptplayerfi_tclMsgVoiceAdviceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgVoiceAdviceMethodResult : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgVoiceAdviceMethodResult();

   virtual ~sds_promptplayerfi_tclMsgVoiceAdviceMethodResult();

   inline tBool operator==(const sds_promptplayerfi_tclMsgVoiceAdviceMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgInitializeMethodStart : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgInitializeMethodStart();

   virtual ~sds_promptplayerfi_tclMsgInitializeMethodStart();

   inline tBool operator==(const sds_promptplayerfi_tclMsgInitializeMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgInitializeMethodResult : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgInitializeMethodResult();

   virtual ~sds_promptplayerfi_tclMsgInitializeMethodResult();

   inline tBool operator==(const sds_promptplayerfi_tclMsgInitializeMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgSpeechDataMemoryGet : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgSpeechDataMemoryGet();

   virtual ~sds_promptplayerfi_tclMsgSpeechDataMemoryGet();

   inline tBool operator==(const sds_promptplayerfi_tclMsgSpeechDataMemoryGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgSpeechDataMemoryUpReg : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgSpeechDataMemoryUpReg();

   virtual ~sds_promptplayerfi_tclMsgSpeechDataMemoryUpReg();

   inline tBool operator==(const sds_promptplayerfi_tclMsgSpeechDataMemoryUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgSpeechDataMemoryRelUpReg : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgSpeechDataMemoryRelUpReg();

   virtual ~sds_promptplayerfi_tclMsgSpeechDataMemoryRelUpReg();

   inline tBool operator==(const sds_promptplayerfi_tclMsgSpeechDataMemoryRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgSpeechDataMemoryStatus : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgSpeechDataMemoryStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_promptplayerfi_tclMsgSpeechDataMemoryStatus& operator=(const sds_promptplayerfi_tclMsgSpeechDataMemoryStatus& coRef);
   sds_promptplayerfi_tclMsgSpeechDataMemoryStatus(const sds_promptplayerfi_tclMsgSpeechDataMemoryStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SD_MB_Size;
   virtual ~sds_promptplayerfi_tclMsgSpeechDataMemoryStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_promptplayerfi_tclMsgSpeechDataMemoryStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgSpeechDataFormatGet : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgSpeechDataFormatGet();

   virtual ~sds_promptplayerfi_tclMsgSpeechDataFormatGet();

   inline tBool operator==(const sds_promptplayerfi_tclMsgSpeechDataFormatGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgSpeechDataFormatUpReg : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgSpeechDataFormatUpReg();

   virtual ~sds_promptplayerfi_tclMsgSpeechDataFormatUpReg();

   inline tBool operator==(const sds_promptplayerfi_tclMsgSpeechDataFormatUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgSpeechDataFormatRelUpReg : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgSpeechDataFormatRelUpReg();

   virtual ~sds_promptplayerfi_tclMsgSpeechDataFormatRelUpReg();

   inline tBool operator==(const sds_promptplayerfi_tclMsgSpeechDataFormatRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgSpeechDataFormatStatus : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgSpeechDataFormatStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_promptplayerfi_tclMsgSpeechDataFormatStatus& operator=(const sds_promptplayerfi_tclMsgSpeechDataFormatStatus& coRef);
   sds_promptplayerfi_tclMsgSpeechDataFormatStatus(const sds_promptplayerfi_tclMsgSpeechDataFormatStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_SD_Format SD_Format;
   virtual ~sds_promptplayerfi_tclMsgSpeechDataFormatStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_promptplayerfi_tclMsgSpeechDataFormatStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgSpeechDataSettingsGet : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgSpeechDataSettingsGet();

   virtual ~sds_promptplayerfi_tclMsgSpeechDataSettingsGet();

   inline tBool operator==(const sds_promptplayerfi_tclMsgSpeechDataSettingsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgSpeechDataSettingsStatus : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgSpeechDataSettingsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_promptplayerfi_tclMsgSpeechDataSettingsStatus& operator=(const sds_promptplayerfi_tclMsgSpeechDataSettingsStatus& coRef);
   sds_promptplayerfi_tclMsgSpeechDataSettingsStatus(const sds_promptplayerfi_tclMsgSpeechDataSettingsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SD_Settings SD_Settings;
   virtual ~sds_promptplayerfi_tclMsgSpeechDataSettingsStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_promptplayerfi_tclMsgSpeechDataSettingsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgPrompterStatusGet : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgPrompterStatusGet();

   virtual ~sds_promptplayerfi_tclMsgPrompterStatusGet();

   inline tBool operator==(const sds_promptplayerfi_tclMsgPrompterStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgPrompterStatusUpReg : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgPrompterStatusUpReg();

   virtual ~sds_promptplayerfi_tclMsgPrompterStatusUpReg();

   inline tBool operator==(const sds_promptplayerfi_tclMsgPrompterStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgPrompterStatusRelUpReg : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgPrompterStatusRelUpReg();

   virtual ~sds_promptplayerfi_tclMsgPrompterStatusRelUpReg();

   inline tBool operator==(const sds_promptplayerfi_tclMsgPrompterStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgPrompterStatusStatus : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgPrompterStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_promptplayerfi_tclMsgPrompterStatusStatus& operator=(const sds_promptplayerfi_tclMsgPrompterStatusStatus& coRef);
   sds_promptplayerfi_tclMsgPrompterStatusStatus(const sds_promptplayerfi_tclMsgPrompterStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_PrompterStatus PP_Status;
   tU16 PromptID;
   virtual ~sds_promptplayerfi_tclMsgPrompterStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_promptplayerfi_tclMsgPrompterStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgPrompterSWVersionGet : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgPrompterSWVersionGet();

   virtual ~sds_promptplayerfi_tclMsgPrompterSWVersionGet();

   inline tBool operator==(const sds_promptplayerfi_tclMsgPrompterSWVersionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgPrompterSWVersionUpReg : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgPrompterSWVersionUpReg();

   virtual ~sds_promptplayerfi_tclMsgPrompterSWVersionUpReg();

   inline tBool operator==(const sds_promptplayerfi_tclMsgPrompterSWVersionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgPrompterSWVersionRelUpReg : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgPrompterSWVersionRelUpReg();

   virtual ~sds_promptplayerfi_tclMsgPrompterSWVersionRelUpReg();

   inline tBool operator==(const sds_promptplayerfi_tclMsgPrompterSWVersionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgPrompterSWVersionStatus : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgPrompterSWVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_promptplayerfi_tclMsgPrompterSWVersionStatus& operator=(const sds_promptplayerfi_tclMsgPrompterSWVersionStatus& coRef);
   sds_promptplayerfi_tclMsgPrompterSWVersionStatus(const sds_promptplayerfi_tclMsgPrompterSWVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString sPPVersion;
   virtual ~sds_promptplayerfi_tclMsgPrompterSWVersionStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_promptplayerfi_tclMsgPrompterSWVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgSpeakerGet : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgSpeakerGet();

   virtual ~sds_promptplayerfi_tclMsgSpeakerGet();

   inline tBool operator==(const sds_promptplayerfi_tclMsgSpeakerGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgSpeakerUpReg : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgSpeakerUpReg();

   virtual ~sds_promptplayerfi_tclMsgSpeakerUpReg();

   inline tBool operator==(const sds_promptplayerfi_tclMsgSpeakerUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgSpeakerRelUpReg : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgSpeakerRelUpReg();

   virtual ~sds_promptplayerfi_tclMsgSpeakerRelUpReg();

   inline tBool operator==(const sds_promptplayerfi_tclMsgSpeakerRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgSpeakerStatus : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgSpeakerStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_promptplayerfi_tclMsgSpeakerStatus& operator=(const sds_promptplayerfi_tclMsgSpeakerStatus& coRef);
   sds_promptplayerfi_tclMsgSpeakerStatus(const sds_promptplayerfi_tclMsgSpeakerStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_VoiceType Speaker;
   virtual ~sds_promptplayerfi_tclMsgSpeakerStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_promptplayerfi_tclMsgSpeakerStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgAvailableSpeakersGet : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgAvailableSpeakersGet();

   virtual ~sds_promptplayerfi_tclMsgAvailableSpeakersGet();

   inline tBool operator==(const sds_promptplayerfi_tclMsgAvailableSpeakersGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgAvailableSpeakersUpReg : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgAvailableSpeakersUpReg();

   virtual ~sds_promptplayerfi_tclMsgAvailableSpeakersUpReg();

   inline tBool operator==(const sds_promptplayerfi_tclMsgAvailableSpeakersUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgAvailableSpeakersRelUpReg : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgAvailableSpeakersRelUpReg();

   virtual ~sds_promptplayerfi_tclMsgAvailableSpeakersRelUpReg();

   inline tBool operator==(const sds_promptplayerfi_tclMsgAvailableSpeakersRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgAvailableSpeakersStatus : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgAvailableSpeakersStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_promptplayerfi_tclMsgAvailableSpeakersStatus& operator=(const sds_promptplayerfi_tclMsgAvailableSpeakersStatus& coRef);
   sds_promptplayerfi_tclMsgAvailableSpeakersStatus(const sds_promptplayerfi_tclMsgAvailableSpeakersStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_VoiceType, std::allocator<sds_fi_tcl_VoiceType> > AvailableSpeakers;
   virtual ~sds_promptplayerfi_tclMsgAvailableSpeakersStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_promptplayerfi_tclMsgAvailableSpeakersStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgSpeechDataCustomerGet : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgSpeechDataCustomerGet();

   virtual ~sds_promptplayerfi_tclMsgSpeechDataCustomerGet();

   inline tBool operator==(const sds_promptplayerfi_tclMsgSpeechDataCustomerGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgSpeechDataCustomerStatus : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgSpeechDataCustomerStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_promptplayerfi_tclMsgSpeechDataCustomerStatus& operator=(const sds_promptplayerfi_tclMsgSpeechDataCustomerStatus& coRef);
   sds_promptplayerfi_tclMsgSpeechDataCustomerStatus(const sds_promptplayerfi_tclMsgSpeechDataCustomerStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU32, std::allocator<tU32> > SD_CustomerIDs;
   virtual ~sds_promptplayerfi_tclMsgSpeechDataCustomerStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_promptplayerfi_tclMsgSpeechDataCustomerStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgAvailableDlgApplicationsGet : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgAvailableDlgApplicationsGet();

   virtual ~sds_promptplayerfi_tclMsgAvailableDlgApplicationsGet();

   inline tBool operator==(const sds_promptplayerfi_tclMsgAvailableDlgApplicationsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgAvailableDlgApplicationsUpReg : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgAvailableDlgApplicationsUpReg();

   virtual ~sds_promptplayerfi_tclMsgAvailableDlgApplicationsUpReg();

   inline tBool operator==(const sds_promptplayerfi_tclMsgAvailableDlgApplicationsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgAvailableDlgApplicationsRelUpReg : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgAvailableDlgApplicationsRelUpReg();

   virtual ~sds_promptplayerfi_tclMsgAvailableDlgApplicationsRelUpReg();

   inline tBool operator==(const sds_promptplayerfi_tclMsgAvailableDlgApplicationsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgAvailableDlgApplicationsStatus : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgAvailableDlgApplicationsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_promptplayerfi_tclMsgAvailableDlgApplicationsStatus& operator=(const sds_promptplayerfi_tclMsgAvailableDlgApplicationsStatus& coRef);
   sds_promptplayerfi_tclMsgAvailableDlgApplicationsStatus(const sds_promptplayerfi_tclMsgAvailableDlgApplicationsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_e8_DlgAppID, std::allocator<sds_fi_tcl_e8_DlgAppID> > AvailableDlgApps;
   virtual ~sds_promptplayerfi_tclMsgAvailableDlgApplicationsStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_promptplayerfi_tclMsgAvailableDlgApplicationsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgDlgApplicationsGet : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgDlgApplicationsGet();

   virtual ~sds_promptplayerfi_tclMsgDlgApplicationsGet();

   inline tBool operator==(const sds_promptplayerfi_tclMsgDlgApplicationsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgDlgApplicationsUpReg : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgDlgApplicationsUpReg();

   virtual ~sds_promptplayerfi_tclMsgDlgApplicationsUpReg();

   inline tBool operator==(const sds_promptplayerfi_tclMsgDlgApplicationsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgDlgApplicationsRelUpReg : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgDlgApplicationsRelUpReg();

   virtual ~sds_promptplayerfi_tclMsgDlgApplicationsRelUpReg();

   inline tBool operator==(const sds_promptplayerfi_tclMsgDlgApplicationsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgDlgApplicationsStatus : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgDlgApplicationsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_promptplayerfi_tclMsgDlgApplicationsStatus& operator=(const sds_promptplayerfi_tclMsgDlgApplicationsStatus& coRef);
   sds_promptplayerfi_tclMsgDlgApplicationsStatus(const sds_promptplayerfi_tclMsgDlgApplicationsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_e8_DlgAppID, std::allocator<sds_fi_tcl_e8_DlgAppID> > DlgApps;
   virtual ~sds_promptplayerfi_tclMsgDlgApplicationsStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_promptplayerfi_tclMsgDlgApplicationsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgPromptLengthGet : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgPromptLengthGet();

   virtual ~sds_promptplayerfi_tclMsgPromptLengthGet();

   inline tBool operator==(const sds_promptplayerfi_tclMsgPromptLengthGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgPromptLengthUpReg : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgPromptLengthUpReg();

   virtual ~sds_promptplayerfi_tclMsgPromptLengthUpReg();

   inline tBool operator==(const sds_promptplayerfi_tclMsgPromptLengthUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgPromptLengthRelUpReg : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgPromptLengthRelUpReg();

   virtual ~sds_promptplayerfi_tclMsgPromptLengthRelUpReg();

   inline tBool operator==(const sds_promptplayerfi_tclMsgPromptLengthRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgPromptLengthSet : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgPromptLengthSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_promptplayerfi_tclMsgPromptLengthSet& operator=(const sds_promptplayerfi_tclMsgPromptLengthSet& coRef);
   sds_promptplayerfi_tclMsgPromptLengthSet(const sds_promptplayerfi_tclMsgPromptLengthSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_PromptSetting PromptLength;
   tBool SetDefault;
   virtual ~sds_promptplayerfi_tclMsgPromptLengthSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_promptplayerfi_tclMsgPromptLengthSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgPromptLengthStatus : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgPromptLengthStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_promptplayerfi_tclMsgPromptLengthStatus& operator=(const sds_promptplayerfi_tclMsgPromptLengthStatus& coRef);
   sds_promptplayerfi_tclMsgPromptLengthStatus(const sds_promptplayerfi_tclMsgPromptLengthStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_PromptSetting PromptLength;
   virtual ~sds_promptplayerfi_tclMsgPromptLengthStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_promptplayerfi_tclMsgPromptLengthStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgPromptListFlagUpdateGet : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgPromptListFlagUpdateGet();

   virtual ~sds_promptplayerfi_tclMsgPromptListFlagUpdateGet();

   inline tBool operator==(const sds_promptplayerfi_tclMsgPromptListFlagUpdateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgPromptListFlagUpdateUpReg : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgPromptListFlagUpdateUpReg();

   virtual ~sds_promptplayerfi_tclMsgPromptListFlagUpdateUpReg();

   inline tBool operator==(const sds_promptplayerfi_tclMsgPromptListFlagUpdateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgPromptListFlagUpdateRelUpReg : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgPromptListFlagUpdateRelUpReg();

   virtual ~sds_promptplayerfi_tclMsgPromptListFlagUpdateRelUpReg();

   inline tBool operator==(const sds_promptplayerfi_tclMsgPromptListFlagUpdateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgPromptListFlagUpdateSet : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgPromptListFlagUpdateSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_promptplayerfi_tclMsgPromptListFlagUpdateSet& operator=(const sds_promptplayerfi_tclMsgPromptListFlagUpdateSet& coRef);
   sds_promptplayerfi_tclMsgPromptListFlagUpdateSet(const sds_promptplayerfi_tclMsgPromptListFlagUpdateSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_PromptListStatus, std::allocator<sds_fi_tcl_PromptListStatus> > PromptListFlags;
   virtual ~sds_promptplayerfi_tclMsgPromptListFlagUpdateSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_promptplayerfi_tclMsgPromptListFlagUpdateSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_promptplayerfi_tclMsgPromptListFlagUpdateStatus : public sds_promptplayerfi_tclMsgBaseMessage
{
public:

   sds_promptplayerfi_tclMsgPromptListFlagUpdateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_promptplayerfi_tclMsgPromptListFlagUpdateStatus& operator=(const sds_promptplayerfi_tclMsgPromptListFlagUpdateStatus& coRef);
   sds_promptplayerfi_tclMsgPromptListFlagUpdateStatus(const sds_promptplayerfi_tclMsgPromptListFlagUpdateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_PromptListStatus, std::allocator<sds_fi_tcl_PromptListStatus> > PromptListFlags;
   virtual ~sds_promptplayerfi_tclMsgPromptListFlagUpdateStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_promptplayerfi_tclMsgPromptListFlagUpdateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
