#include "precompiled.hh"

tBool sds_promptplayerfi_tclDescription::bInitMessage(sds_promptplayerfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case sds_promptplayerfi_tclToken::EN_LAST_TOKEN:
   case sds_promptplayerfi_tclToken::EN_LIST:
   case sds_promptplayerfi_tclToken::EN_END_OF_STRUCT:
   case sds_promptplayerfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case sds_promptplayerfi_tclToken::EN_MSG_SETSPEAKERMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_VOICETYPE,sds_promptplayerfi_tclSemanticDomain::EN_MSG_SPEAKER)) && bResult;
   } break;
   case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATACONTENTSMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_U32,sds_promptplayerfi_tclSemanticDomain::EN_MSG_NOOFBYTES)) && bResult;
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_U32,sds_promptplayerfi_tclSemanticDomain::EN_MSG_STARTADDRESS)) && bResult;
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_STRING,sds_promptplayerfi_tclSemanticDomain::EN_MSG_FILENAME)) && bResult;
   } break;
   case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATACONTENTSMETHODRESULT:
   {
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_U8,sds_promptplayerfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_LIST,sds_promptplayerfi_tclSemanticDomain::EN_MSG_SD_CONTENTS)) && bResult;
   } break;
   case sds_promptplayerfi_tclToken::EN_MSG_RELEASEDATAMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_E8_RELEASETYPEPP,sds_promptplayerfi_tclSemanticDomain::EN_MSG_RELEASETYPE)) && bResult;
   } break;
   case sds_promptplayerfi_tclToken::EN_MSG_SETDLGAPPLICATIONMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_E8_DLGAPPID,sds_promptplayerfi_tclSemanticDomain::EN_MSG_DLGAPPLICATION)) && bResult;
   } break;
   case sds_promptplayerfi_tclToken::EN_MSG_PLAYMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_PHRASEVARIABLE,sds_promptplayerfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_LIST,sds_promptplayerfi_tclSemanticDomain::EN_MSG_PHRASEVARIABLES)) && bResult;
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_U16,sds_promptplayerfi_tclSemanticDomain::EN_MSG_SENTENCEID)) && bResult;
   } break;
   case sds_promptplayerfi_tclToken::EN_MSG_PLAYMETHODRESULTFIRST:
   {
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_PLAYPROGRESS,sds_promptplayerfi_tclSemanticDomain::EN_MSG_PLAYPROGRESS)) && bResult;
   } break;
   case sds_promptplayerfi_tclToken::EN_MSG_PLAYMETHODRESULTMIDDLE:
   {
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_PLAYPROGRESS,sds_promptplayerfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_LIST,sds_promptplayerfi_tclSemanticDomain::EN_MSG_PLAYPROGRESS)) && bResult;
   } break;
   case sds_promptplayerfi_tclToken::EN_MSG_PLAYMETHODRESULTLAST:
   {
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_PLAYPROGRESS,sds_promptplayerfi_tclSemanticDomain::EN_MSG_PLAYPROGRESS)) && bResult;
   } break;
   case sds_promptplayerfi_tclToken::EN_MSG_TESTTESTMETHODRESULT:
   {
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_U16,sds_promptplayerfi_tclSemanticDomain::EN_MSG_ABCTEST)) && bResult;
   } break;
   case sds_promptplayerfi_tclToken::EN_MSG_VOICEADVICEMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_AUDIOCHANNELADVICE,sds_promptplayerfi_tclSemanticDomain::EN_MSG_AUDIOCHANNELADVICE)) && bResult;
   } break;
   case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAMEMORYSTATUS:
   {
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_U8,sds_promptplayerfi_tclSemanticDomain::EN_MSG_SD_MB_SIZE)) && bResult;
   } break;
   case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAFORMATSTATUS:
   {
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_E8_SD_FORMAT,sds_promptplayerfi_tclSemanticDomain::EN_MSG_SD_FORMAT)) && bResult;
   } break;
   case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATASETTINGSSTATUS:
   {
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_SD_SETTINGS,sds_promptplayerfi_tclSemanticDomain::EN_MSG_SD_SETTINGS)) && bResult;
   } break;
   case sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_U16,sds_promptplayerfi_tclSemanticDomain::EN_MSG_PROMPTID)) && bResult;
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_E8_PROMPTERSTATUS,sds_promptplayerfi_tclSemanticDomain::EN_MSG_PP_STATUS)) && bResult;
   } break;
   case sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSWVERSIONSTATUS:
   {
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_STRING,sds_promptplayerfi_tclSemanticDomain::EN_MSG_SPPVERSION)) && bResult;
   } break;
   case sds_promptplayerfi_tclToken::EN_MSG_SPEAKERSTATUS:
   {
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_VOICETYPE,sds_promptplayerfi_tclSemanticDomain::EN_MSG_SPEAKER)) && bResult;
   } break;
   case sds_promptplayerfi_tclToken::EN_MSG_AVAILABLESPEAKERSSTATUS:
   {
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_VOICETYPE,sds_promptplayerfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_LIST,sds_promptplayerfi_tclSemanticDomain::EN_MSG_AVAILABLESPEAKERS)) && bResult;
   } break;
   case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATACUSTOMERSTATUS:
   {
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_U32,sds_promptplayerfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_LIST,sds_promptplayerfi_tclSemanticDomain::EN_MSG_SD_CUSTOMERIDS)) && bResult;
   } break;
   case sds_promptplayerfi_tclToken::EN_MSG_AVAILABLEDLGAPPLICATIONSSTATUS:
   {
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_E8_DLGAPPID,sds_promptplayerfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_LIST,sds_promptplayerfi_tclSemanticDomain::EN_MSG_AVAILABLEDLGAPPS)) && bResult;
   } break;
   case sds_promptplayerfi_tclToken::EN_MSG_DLGAPPLICATIONSSTATUS:
   {
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_E8_DLGAPPID,sds_promptplayerfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_LIST,sds_promptplayerfi_tclSemanticDomain::EN_MSG_DLGAPPS)) && bResult;
   } break;
   case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLENGTHSET:
   {
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_BOOL,sds_promptplayerfi_tclSemanticDomain::EN_MSG_SETDEFAULT)) && bResult;
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_E8_PROMPTSETTING,sds_promptplayerfi_tclSemanticDomain::EN_MSG_PROMPTLENGTH)) && bResult;
   } break;
   case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLENGTHSTATUS:
   {
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_E8_PROMPTSETTING,sds_promptplayerfi_tclSemanticDomain::EN_MSG_PROMPTLENGTH)) && bResult;
   } break;
   case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLISTFLAGUPDATESET:
   {
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_PROMPTLISTSTATUS,sds_promptplayerfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_LIST,sds_promptplayerfi_tclSemanticDomain::EN_MSG_PROMPTLISTFLAGS)) && bResult;
   } break;
   case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLISTFLAGUPDATESTATUS:
   {
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_PROMPTLISTSTATUS,sds_promptplayerfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_LIST,sds_promptplayerfi_tclSemanticDomain::EN_MSG_PROMPTLISTFLAGS)) && bResult;
   } break;
   case sds_promptplayerfi_tclToken::EN_MSG_SETSPEAKERMETHODRESULT:
   case sds_promptplayerfi_tclToken::EN_MSG_RELEASEDATAMETHODRESULT:
   case sds_promptplayerfi_tclToken::EN_MSG_SETDLGAPPLICATIONMETHODRESULT:
   case sds_promptplayerfi_tclToken::EN_MSG_STOPMETHODSTART:
   case sds_promptplayerfi_tclToken::EN_MSG_STOPMETHODRESULT:
   case sds_promptplayerfi_tclToken::EN_MSG_PAUSEMETHODSTART:
   case sds_promptplayerfi_tclToken::EN_MSG_PAUSEMETHODRESULT:
   case sds_promptplayerfi_tclToken::EN_MSG_RESUMEMETHODSTART:
   case sds_promptplayerfi_tclToken::EN_MSG_RESUMEMETHODRESULT:
   case sds_promptplayerfi_tclToken::EN_MSG_TESTTESTMETHODSTART:
   case sds_promptplayerfi_tclToken::EN_MSG_SET2DEFAULTMETHODSTART:
   case sds_promptplayerfi_tclToken::EN_MSG_SET2DEFAULTMETHODRESULT:
   case sds_promptplayerfi_tclToken::EN_MSG_VOICEADVICEMETHODRESULT:
   case sds_promptplayerfi_tclToken::EN_MSG_INITIALIZEMETHODSTART:
   case sds_promptplayerfi_tclToken::EN_MSG_INITIALIZEMETHODRESULT:
   case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAMEMORYGET:
   case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAMEMORYUPREG:
   case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAMEMORYRELUPREG:
   case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAFORMATGET:
   case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAFORMATUPREG:
   case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAFORMATRELUPREG:
   case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATASETTINGSGET:
   case sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSTATUSGET:
   case sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSTATUSUPREG:
   case sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSTATUSRELUPREG:
   case sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSWVERSIONGET:
   case sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSWVERSIONUPREG:
   case sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSWVERSIONRELUPREG:
   case sds_promptplayerfi_tclToken::EN_MSG_SPEAKERGET:
   case sds_promptplayerfi_tclToken::EN_MSG_SPEAKERUPREG:
   case sds_promptplayerfi_tclToken::EN_MSG_SPEAKERRELUPREG:
   case sds_promptplayerfi_tclToken::EN_MSG_AVAILABLESPEAKERSGET:
   case sds_promptplayerfi_tclToken::EN_MSG_AVAILABLESPEAKERSUPREG:
   case sds_promptplayerfi_tclToken::EN_MSG_AVAILABLESPEAKERSRELUPREG:
   case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATACUSTOMERGET:
   case sds_promptplayerfi_tclToken::EN_MSG_AVAILABLEDLGAPPLICATIONSGET:
   case sds_promptplayerfi_tclToken::EN_MSG_AVAILABLEDLGAPPLICATIONSUPREG:
   case sds_promptplayerfi_tclToken::EN_MSG_AVAILABLEDLGAPPLICATIONSRELUPREG:
   case sds_promptplayerfi_tclToken::EN_MSG_DLGAPPLICATIONSGET:
   case sds_promptplayerfi_tclToken::EN_MSG_DLGAPPLICATIONSUPREG:
   case sds_promptplayerfi_tclToken::EN_MSG_DLGAPPLICATIONSRELUPREG:
   case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLENGTHGET:
   case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLENGTHUPREG:
   case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLENGTHRELUPREG:
   case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLISTFLAGUPDATEGET:
   case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLISTFLAGUPDATEUPREG:
   case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLISTFLAGUPDATERELUPREG:
   case sds_promptplayerfi_tclToken::EN_BINCONTAINER:
   case sds_promptplayerfi_tclToken::EN_E16_ISOCOUNTRYCODE:
   case sds_promptplayerfi_tclToken::EN_E16_ISO639_3_SDSLANGUAGECODE:
   case sds_promptplayerfi_tclToken::EN_E8_PROMPTSETTING:
   case sds_promptplayerfi_tclToken::EN_SDSLANGUAGEID:
   case sds_promptplayerfi_tclToken::EN_E8_VOICEGENDER:
   case sds_promptplayerfi_tclToken::EN_VOICETYPE:
   case sds_promptplayerfi_tclToken::EN_E8_AUDIOCHANNELADVICE:
   case sds_promptplayerfi_tclToken::EN_AUDIOCHANNELADVICE:
   case sds_promptplayerfi_tclToken::EN_E8_PROMPTERSTATUS:
   case sds_promptplayerfi_tclToken::EN_E8_RELEASETYPEPP:
   case sds_promptplayerfi_tclToken::EN_E8_VARTYPE:
   case sds_promptplayerfi_tclToken::EN_E8_PPJOBSTATUS:
   case sds_promptplayerfi_tclToken::EN_E8_DLGAPPID:
   case sds_promptplayerfi_tclToken::EN_PROMPTLISTSTATUS:
   case sds_promptplayerfi_tclToken::EN_PHRASEVARIABLE:
   case sds_promptplayerfi_tclToken::EN_PLAYPROGRESS:
   case sds_promptplayerfi_tclToken::EN_E8_SD_FORMAT:
   case sds_promptplayerfi_tclToken::EN_U16_SD_SAMPLEFREQUENCY:
   case sds_promptplayerfi_tclToken::EN_SD_SETTINGS:
   case sds_promptplayerfi_tclToken::EN_U8:   
   case sds_promptplayerfi_tclToken::EN_S8:   
   case sds_promptplayerfi_tclToken::EN_U16:   
   case sds_promptplayerfi_tclToken::EN_S16:   
   case sds_promptplayerfi_tclToken::EN_U24:   
   case sds_promptplayerfi_tclToken::EN_S24:   
   case sds_promptplayerfi_tclToken::EN_U32:   
   case sds_promptplayerfi_tclToken::EN_S32:   
   case sds_promptplayerfi_tclToken::EN_U64:   
   case sds_promptplayerfi_tclToken::EN_S64:   
   case sds_promptplayerfi_tclToken::EN_F32:   
   case sds_promptplayerfi_tclToken::EN_F64:   
   case sds_promptplayerfi_tclToken::EN_BOOL:   
   case sds_promptplayerfi_tclToken::EN_STRING:   
   case sds_promptplayerfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(enMsgToken,sds_promptplayerfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool sds_promptplayerfi_tclDescription::bDoIt(sds_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool sds_promptplayerfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      sds_promptplayerfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      sds_promptplayerfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      sds_promptplayerfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == sds_promptplayerfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(sds_promptplayerfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case sds_promptplayerfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == sds_promptplayerfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case sds_promptplayerfi_tclToken::EN_LIST: 
      {
         sds_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            sds_promptplayerfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            sds_promptplayerfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case sds_promptplayerfi_tclToken::EN_U8: 
      {
         sds_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case sds_promptplayerfi_tclToken::EN_U16: 
      {
         sds_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_promptplayerfi_tclToken::EN_U24: 
      {
         sds_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_promptplayerfi_tclToken::EN_U32: 
      {
         sds_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_promptplayerfi_tclToken::EN_U64: 
      {
         sds_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_promptplayerfi_tclToken::EN_S8: 
      {
         sds_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_promptplayerfi_tclToken::EN_S16: 
      {
         sds_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_promptplayerfi_tclToken::EN_S24: 
      {
         sds_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_promptplayerfi_tclToken::EN_S32: 
      {
         sds_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_promptplayerfi_tclToken::EN_S64: 
      {
         sds_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_promptplayerfi_tclToken::EN_F32: 
      {
         sds_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_promptplayerfi_tclToken::EN_F64: 
      {
         sds_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_promptplayerfi_tclToken::EN_BOOL: 
      {
         sds_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_promptplayerfi_tclToken::EN_STRING: 
      {
         sds_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_promptplayerfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         sds_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case sds_promptplayerfi_tclToken::EN_MSG_SETSPEAKERMETHODSTART:
      case sds_promptplayerfi_tclToken::EN_MSG_SETSPEAKERMETHODRESULT:
      case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATACONTENTSMETHODSTART:
      case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATACONTENTSMETHODRESULT:
      case sds_promptplayerfi_tclToken::EN_MSG_RELEASEDATAMETHODSTART:
      case sds_promptplayerfi_tclToken::EN_MSG_RELEASEDATAMETHODRESULT:
      case sds_promptplayerfi_tclToken::EN_MSG_SETDLGAPPLICATIONMETHODSTART:
      case sds_promptplayerfi_tclToken::EN_MSG_SETDLGAPPLICATIONMETHODRESULT:
      case sds_promptplayerfi_tclToken::EN_MSG_PLAYMETHODSTART:
      case sds_promptplayerfi_tclToken::EN_MSG_PLAYMETHODRESULTFIRST:
      case sds_promptplayerfi_tclToken::EN_MSG_PLAYMETHODRESULTMIDDLE:
      case sds_promptplayerfi_tclToken::EN_MSG_PLAYMETHODRESULTLAST:
      case sds_promptplayerfi_tclToken::EN_MSG_STOPMETHODSTART:
      case sds_promptplayerfi_tclToken::EN_MSG_STOPMETHODRESULT:
      case sds_promptplayerfi_tclToken::EN_MSG_PAUSEMETHODSTART:
      case sds_promptplayerfi_tclToken::EN_MSG_PAUSEMETHODRESULT:
      case sds_promptplayerfi_tclToken::EN_MSG_RESUMEMETHODSTART:
      case sds_promptplayerfi_tclToken::EN_MSG_RESUMEMETHODRESULT:
      case sds_promptplayerfi_tclToken::EN_MSG_TESTTESTMETHODSTART:
      case sds_promptplayerfi_tclToken::EN_MSG_TESTTESTMETHODRESULT:
      case sds_promptplayerfi_tclToken::EN_MSG_SET2DEFAULTMETHODSTART:
      case sds_promptplayerfi_tclToken::EN_MSG_SET2DEFAULTMETHODRESULT:
      case sds_promptplayerfi_tclToken::EN_MSG_VOICEADVICEMETHODSTART:
      case sds_promptplayerfi_tclToken::EN_MSG_VOICEADVICEMETHODRESULT:
      case sds_promptplayerfi_tclToken::EN_MSG_INITIALIZEMETHODSTART:
      case sds_promptplayerfi_tclToken::EN_MSG_INITIALIZEMETHODRESULT:
      case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAMEMORYGET:
      case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAMEMORYUPREG:
      case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAMEMORYRELUPREG:
      case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAMEMORYSTATUS:
      case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAFORMATGET:
      case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAFORMATUPREG:
      case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAFORMATRELUPREG:
      case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAFORMATSTATUS:
      case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATASETTINGSGET:
      case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATASETTINGSSTATUS:
      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSTATUSGET:
      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSTATUSUPREG:
      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSTATUSRELUPREG:
      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSTATUSSTATUS:
      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSWVERSIONGET:
      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSWVERSIONUPREG:
      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSWVERSIONRELUPREG:
      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSWVERSIONSTATUS:
      case sds_promptplayerfi_tclToken::EN_MSG_SPEAKERGET:
      case sds_promptplayerfi_tclToken::EN_MSG_SPEAKERUPREG:
      case sds_promptplayerfi_tclToken::EN_MSG_SPEAKERRELUPREG:
      case sds_promptplayerfi_tclToken::EN_MSG_SPEAKERSTATUS:
      case sds_promptplayerfi_tclToken::EN_MSG_AVAILABLESPEAKERSGET:
      case sds_promptplayerfi_tclToken::EN_MSG_AVAILABLESPEAKERSUPREG:
      case sds_promptplayerfi_tclToken::EN_MSG_AVAILABLESPEAKERSRELUPREG:
      case sds_promptplayerfi_tclToken::EN_MSG_AVAILABLESPEAKERSSTATUS:
      case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATACUSTOMERGET:
      case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATACUSTOMERSTATUS:
      case sds_promptplayerfi_tclToken::EN_MSG_AVAILABLEDLGAPPLICATIONSGET:
      case sds_promptplayerfi_tclToken::EN_MSG_AVAILABLEDLGAPPLICATIONSUPREG:
      case sds_promptplayerfi_tclToken::EN_MSG_AVAILABLEDLGAPPLICATIONSRELUPREG:
      case sds_promptplayerfi_tclToken::EN_MSG_AVAILABLEDLGAPPLICATIONSSTATUS:
      case sds_promptplayerfi_tclToken::EN_MSG_DLGAPPLICATIONSGET:
      case sds_promptplayerfi_tclToken::EN_MSG_DLGAPPLICATIONSUPREG:
      case sds_promptplayerfi_tclToken::EN_MSG_DLGAPPLICATIONSRELUPREG:
      case sds_promptplayerfi_tclToken::EN_MSG_DLGAPPLICATIONSSTATUS:
      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLENGTHGET:
      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLENGTHUPREG:
      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLENGTHRELUPREG:
      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLENGTHSET:
      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLENGTHSTATUS:
      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLISTFLAGUPDATEGET:
      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLISTFLAGUPDATEUPREG:
      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLISTFLAGUPDATERELUPREG:
      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLISTFLAGUPDATESET:
      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLISTFLAGUPDATESTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case sds_promptplayerfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_END_OF_STRUCT,sds_promptplayerfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_U8,sds_promptplayerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_LIST,sds_promptplayerfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         sds_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_promptplayerfi_tclToken::EN_E16_ISOCOUNTRYCODE:
      {
         sds_fi_tcl_e16_ISOCountryCode o_e16_ISOCountryCode;
         if (!bDoIt(o_e16_ISOCountryCode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_promptplayerfi_tclToken::EN_E16_ISO639_3_SDSLANGUAGECODE:
      {
         sds_fi_tcl_e16_ISO639_3_SDSLanguageCode o_e16_ISO639_3_SDSLanguageCode;
         if (!bDoIt(o_e16_ISO639_3_SDSLanguageCode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_promptplayerfi_tclToken::EN_E8_PROMPTSETTING:
      {
         sds_fi_tcl_e8_PromptSetting o_e8_PromptSetting;
         if (!bDoIt(o_e8_PromptSetting))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_promptplayerfi_tclToken::EN_SDSLANGUAGEID:
      {
      if (poVisitor->bDoExpand_SDSLanguageID(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_END_OF_STRUCT,sds_promptplayerfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_E16_ISOCOUNTRYCODE,sds_promptplayerfi_tclSemanticDomain::EN_ISO3166_COUNTRYCODE));
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_E16_ISO639_3_SDSLANGUAGECODE,sds_promptplayerfi_tclSemanticDomain::EN_ISO639_3_SDSLANGUAGECODE));
      }
      else
      {
         sds_fi_tcl_SDSLanguageID o_SDSLanguageID;
         if (!bDoIt(o_SDSLanguageID))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SDSLanguageID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SDSLanguageID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_promptplayerfi_tclToken::EN_E8_VOICEGENDER:
      {
         sds_fi_tcl_e8_VoiceGender o_e8_VoiceGender;
         if (!bDoIt(o_e8_VoiceGender))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_promptplayerfi_tclToken::EN_VOICETYPE:
      {
      if (poVisitor->bDoExpand_VoiceType(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_END_OF_STRUCT,sds_promptplayerfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_E8_VOICEGENDER,sds_promptplayerfi_tclSemanticDomain::EN_VOICEGENDER));
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_STRING,sds_promptplayerfi_tclSemanticDomain::EN_VOICENAME));
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_SDSLANGUAGEID,sds_promptplayerfi_tclSemanticDomain::EN_LANGUAGEID));
      }
      else
      {
         sds_fi_tcl_VoiceType o_VoiceType;
         if (!bDoIt(o_VoiceType))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VoiceType.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_VoiceType.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_promptplayerfi_tclToken::EN_E8_AUDIOCHANNELADVICE:
      {
         sds_fi_tcl_e8_AudioChannelAdvice o_e8_AudioChannelAdvice;
         if (!bDoIt(o_e8_AudioChannelAdvice))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_promptplayerfi_tclToken::EN_AUDIOCHANNELADVICE:
      {
      if (poVisitor->bDoExpand_AudioChannelAdvice(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_END_OF_STRUCT,sds_promptplayerfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_STRING,sds_promptplayerfi_tclSemanticDomain::EN_DEVICE));
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_U8,sds_promptplayerfi_tclSemanticDomain::EN_INDEX));
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_E8_AUDIOCHANNELADVICE,sds_promptplayerfi_tclSemanticDomain::EN_CHANNELADVICE));
      }
      else
      {
         sds_fi_tcl_AudioChannelAdvice o_AudioChannelAdvice;
         if (!bDoIt(o_AudioChannelAdvice))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AudioChannelAdvice.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AudioChannelAdvice.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_promptplayerfi_tclToken::EN_E8_PROMPTERSTATUS:
      {
         sds_fi_tcl_e8_PrompterStatus o_e8_PrompterStatus;
         if (!bDoIt(o_e8_PrompterStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_promptplayerfi_tclToken::EN_E8_RELEASETYPEPP:
      {
         sds_fi_tcl_e8_ReleaseTypePP o_e8_ReleaseTypePP;
         if (!bDoIt(o_e8_ReleaseTypePP))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_promptplayerfi_tclToken::EN_E8_VARTYPE:
      {
         sds_fi_tcl_e8_VarType o_e8_VarType;
         if (!bDoIt(o_e8_VarType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_promptplayerfi_tclToken::EN_E8_PPJOBSTATUS:
      {
         sds_fi_tcl_e8_PPJobStatus o_e8_PPJobStatus;
         if (!bDoIt(o_e8_PPJobStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_promptplayerfi_tclToken::EN_E8_DLGAPPID:
      {
         sds_fi_tcl_e8_DlgAppID o_e8_DlgAppID;
         if (!bDoIt(o_e8_DlgAppID))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_promptplayerfi_tclToken::EN_PROMPTLISTSTATUS:
      {
      if (poVisitor->bDoExpand_PromptListStatus(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_END_OF_STRUCT,sds_promptplayerfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_U16,sds_promptplayerfi_tclSemanticDomain::EN_FLAGVALUE));
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_STRING,sds_promptplayerfi_tclSemanticDomain::EN_FLAGNAME));
      }
      else
      {
         sds_fi_tcl_PromptListStatus o_PromptListStatus;
         if (!bDoIt(o_PromptListStatus))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PromptListStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PromptListStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_promptplayerfi_tclToken::EN_PHRASEVARIABLE:
      {
      if (poVisitor->bDoExpand_PhraseVariable(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_END_OF_STRUCT,sds_promptplayerfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_SDSLANGUAGEID,sds_promptplayerfi_tclSemanticDomain::EN_TTSLANGUAGEID));
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_STRING,sds_promptplayerfi_tclSemanticDomain::EN_VARADDITIONALINFO ));
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_STRING,sds_promptplayerfi_tclSemanticDomain::EN_DICTCOUNTRYNAME));
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_E16_ISOCOUNTRYCODE,sds_promptplayerfi_tclSemanticDomain::EN_DICTCOUNTRYID));
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_U16,sds_promptplayerfi_tclSemanticDomain::EN_TTSDICTIONARYTYPE));
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_E8_VARTYPE,sds_promptplayerfi_tclSemanticDomain::EN_VARTYPE));
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_STRING,sds_promptplayerfi_tclSemanticDomain::EN_VARTEXT));
      }
      else
      {
         sds_fi_tcl_PhraseVariable o_PhraseVariable;
         if (!bDoIt(o_PhraseVariable))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PhraseVariable.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PhraseVariable.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_promptplayerfi_tclToken::EN_PLAYPROGRESS:
      {
      if (poVisitor->bDoExpand_PlayProgress(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_END_OF_STRUCT,sds_promptplayerfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_E8_PPJOBSTATUS,sds_promptplayerfi_tclSemanticDomain::EN_PPJOBSTATUS));
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_STRING,sds_promptplayerfi_tclSemanticDomain::EN_MARKERVALUE));
      }
      else
      {
         sds_fi_tcl_PlayProgress o_PlayProgress;
         if (!bDoIt(o_PlayProgress))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PlayProgress.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PlayProgress.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_promptplayerfi_tclToken::EN_E8_SD_FORMAT:
      {
         sds_fi_tcl_e8_SD_Format o_e8_SD_Format;
         if (!bDoIt(o_e8_SD_Format))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_promptplayerfi_tclToken::EN_U16_SD_SAMPLEFREQUENCY:
      {
         sds_fi_tcl_u16_SD_SampleFrequency o_u16_SD_SampleFrequency;
         if (!bDoIt(o_u16_SD_SampleFrequency))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_promptplayerfi_tclToken::EN_SD_SETTINGS:
      {
      if (poVisitor->bDoExpand_SD_Settings(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_END_OF_STRUCT,sds_promptplayerfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_BOOL,sds_promptplayerfi_tclSemanticDomain::EN_MONO));
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_U8,sds_promptplayerfi_tclSemanticDomain::EN_RESOLUTION));
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_U16_SD_SAMPLEFREQUENCY,sds_promptplayerfi_tclSemanticDomain::EN_SAMPLEFREQUENCY));
         (tVoid) oPath.bGoDown(sds_promptplayerfi_tclKnot(sds_promptplayerfi_tclToken::EN_E8_SD_FORMAT,sds_promptplayerfi_tclSemanticDomain::EN_SPEECHDATAFORMAT));
      }
      else
      {
         sds_fi_tcl_SD_Settings o_SD_Settings;
         if (!bDoIt(o_SD_Settings))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SD_Settings.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SD_Settings.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_promptplayerfi_tclToken::EN_UNKNOWN:
      case sds_promptplayerfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

