/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef SDS_MSTTESTCOMPONENTFITYPES_HEADER
#define SDS_MSTTESTCOMPONENTFITYPES_HEADER


class sds_msttestcomponentfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for SDS_MSTTESTCOMPONENT_FI message types

fi_tclMessageBase* sds_msttestcomponentfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class sds_msttestcomponentfi_tclMsgBaseMessage : public sds_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   sds_msttestcomponentfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class sds_msttestcomponentfi_tclMsgSetMediaStatusMethodStart : public sds_msttestcomponentfi_tclMsgBaseMessage
{
public:

   sds_msttestcomponentfi_tclMsgSetMediaStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_msttestcomponentfi_tclMsgSetMediaStatusMethodStart& operator=(const sds_msttestcomponentfi_tclMsgSetMediaStatusMethodStart& coRef);
   sds_msttestcomponentfi_tclMsgSetMediaStatusMethodStart(const sds_msttestcomponentfi_tclMsgSetMediaStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_MPL_Status Status;
   sds_fi_tcl_e8_MPL_MenuType MenuType;
   sds_fi_tcl_e8_MPL_SourceType SourceType;
   tU32 SourceId;
   std::vector<sds_fi_tcl_DeviceStatus, std::allocator<sds_fi_tcl_DeviceStatus> > DeviceList;
   virtual ~sds_msttestcomponentfi_tclMsgSetMediaStatusMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_msttestcomponentfi_tclMsgSetMediaStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_msttestcomponentfi_tclMsgSetMediaStatusMethodResult : public sds_msttestcomponentfi_tclMsgBaseMessage
{
public:

   sds_msttestcomponentfi_tclMsgSetMediaStatusMethodResult();

   virtual ~sds_msttestcomponentfi_tclMsgSetMediaStatusMethodResult();

   inline tBool operator==(const sds_msttestcomponentfi_tclMsgSetMediaStatusMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodStart : public sds_msttestcomponentfi_tclMsgBaseMessage
{
public:

   sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodStart& operator=(const sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodStart& coRef);
   sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodStart(const sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_SDS2HMI_PHN_Status Status;
   sds_fi_tcl_e8_SDS2HMI_PHN_MenuType MenuType;
   tU32 SourceId;
   std::vector<sds_fi_tcl_DeviceStatus, std::allocator<sds_fi_tcl_DeviceStatus> > DeviceList;
   virtual ~sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodResult : public sds_msttestcomponentfi_tclMsgBaseMessage
{
public:

   sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodResult();

   virtual ~sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodResult();

   inline tBool operator==(const sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_msttestcomponentfi_tclMsgSetTunerStatusMethodStart : public sds_msttestcomponentfi_tclMsgBaseMessage
{
public:

   sds_msttestcomponentfi_tclMsgSetTunerStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_msttestcomponentfi_tclMsgSetTunerStatusMethodStart& operator=(const sds_msttestcomponentfi_tclMsgSetTunerStatusMethodStart& coRef);
   sds_msttestcomponentfi_tclMsgSetTunerStatusMethodStart(const sds_msttestcomponentfi_tclMsgSetTunerStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_SDS2HMI_TUN_Status Status;
   sds_fi_tcl_e8_SDS2HMI_TUN_Band Band;
   tU16 PresetNr;
   sds_fi_tclString StationName;
   std::vector<sds_fi_tcl_DeviceStatus, std::allocator<sds_fi_tcl_DeviceStatus> > DeviceList;
   virtual ~sds_msttestcomponentfi_tclMsgSetTunerStatusMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_msttestcomponentfi_tclMsgSetTunerStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_msttestcomponentfi_tclMsgSetTunerStatusMethodResult : public sds_msttestcomponentfi_tclMsgBaseMessage
{
public:

   sds_msttestcomponentfi_tclMsgSetTunerStatusMethodResult();

   virtual ~sds_msttestcomponentfi_tclMsgSetTunerStatusMethodResult();

   inline tBool operator==(const sds_msttestcomponentfi_tclMsgSetTunerStatusMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_msttestcomponentfi_tclMsgSetVDLStatusMethodStart : public sds_msttestcomponentfi_tclMsgBaseMessage
{
public:

   sds_msttestcomponentfi_tclMsgSetVDLStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_msttestcomponentfi_tclMsgSetVDLStatusMethodStart& operator=(const sds_msttestcomponentfi_tclMsgSetVDLStatusMethodStart& coRef);
   sds_msttestcomponentfi_tclMsgSetVDLStatusMethodStart(const sds_msttestcomponentfi_tclMsgSetVDLStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_DeviceStatus, std::allocator<sds_fi_tcl_DeviceStatus> > Slots;
   virtual ~sds_msttestcomponentfi_tclMsgSetVDLStatusMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_msttestcomponentfi_tclMsgSetVDLStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_msttestcomponentfi_tclMsgSetVDLStatusMethodResult : public sds_msttestcomponentfi_tclMsgBaseMessage
{
public:

   sds_msttestcomponentfi_tclMsgSetVDLStatusMethodResult();

   virtual ~sds_msttestcomponentfi_tclMsgSetVDLStatusMethodResult();

   inline tBool operator==(const sds_msttestcomponentfi_tclMsgSetVDLStatusMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodStart : public sds_msttestcomponentfi_tclMsgBaseMessage
{
public:

   sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodStart& operator=(const sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodStart& coRef);
   sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodStart(const sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_NDS_SDN_Status Status;
   tU32 DataSetId;
   virtual ~sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodResult : public sds_msttestcomponentfi_tclMsgBaseMessage
{
public:

   sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodResult();

   virtual ~sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodResult();

   inline tBool operator==(const sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};


#endif
