#ifndef SDS2HMI_FIVISITOR_HEADER
#define SDS2HMI_FIVISITOR_HEADER

// --Basisklasse fuer eine FI-Besucher-Klasse

class sds2hmi_fi_tclOutput {
public:
   sds2hmi_fi_tclOutput();
   virtual ~sds2hmi_fi_tclOutput(){};

   virtual tVoid vPrintLine(tCString coszLine) = 0;
};

class sds2hmi_fi_tclFileOutput : public sds2hmi_fi_tclOutput 
{
public:
   sds2hmi_fi_tclFileOutput(OSAL_tIODescriptor rIOD):fd(rIOD) {}
   virtual tVoid vPrintLine(tCString coszLine);
protected:
   OSAL_tIODescriptor fd;
private:
   sds2hmi_fi_tclFileOutput(); //lint !e1704
   sds2hmi_fi_tclFileOutput& operator=(const sds2hmi_fi_tclFileOutput& coRef);
   sds2hmi_fi_tclFileOutput(const sds2hmi_fi_tclFileOutput& coRef); //lint !e1704
};

class sds2hmi_fi_tclMemOutput : public sds2hmi_fi_tclOutput
{
public:
   sds2hmi_fi_tclMemOutput(tU32 u32MemSize);
   virtual ~sds2hmi_fi_tclMemOutput();
   virtual tVoid vPrintLine(tCString coszLine);
   tString szGetBuffer();
protected:
   tChar* szBuf;
   tChar* szEndBuf;
   tChar* s8BufPos;
private:
   sds2hmi_fi_tclMemOutput(); //lint !e1704
   sds2hmi_fi_tclMemOutput(const sds2hmi_fi_tclMemOutput& coRef); //lint !e1704
   sds2hmi_fi_tclMemOutput& operator=(const sds2hmi_fi_tclMemOutput& coRef); //lint !e1704
};

class MY_DECL sds2hmi_fi_tclVisitorBase {
public:

   // --Konstruktor
   sds2hmi_fi_tclVisitorBase():bBreakNow(FALSE),bIsVisitorValid(FALSE) {}
   virtual ~sds2hmi_fi_tclVisitorBase() {}

   tBool bIsValid() const { return bIsVisitorValid; }
   tVoid vInvalidate() { bIsVisitorValid=FALSE; }
   tVoid vValidate() { bIsVisitorValid=TRUE; }
   tBool bBreak() const { return bBreakNow; }
   tVoid vReleaseBreak() { bBreakNow = FALSE; }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(sds2hmi_fi_tclU8& oU8);
   virtual tVoid vVisitS8(sds2hmi_fi_tclS8& oS8);
   virtual tVoid vVisitU16(sds2hmi_fi_tclU16& oU16);
   virtual tVoid vVisitS16(sds2hmi_fi_tclS16& oS16);
   virtual tVoid vVisitU24(sds2hmi_fi_tclU24& oU24);
   virtual tVoid vVisitS24(sds2hmi_fi_tclS24& oS24);
   virtual tVoid vVisitU32(sds2hmi_fi_tclU32& oU32);
   virtual tVoid vVisitS32(sds2hmi_fi_tclS32& oS32);
   virtual tVoid vVisitU64(sds2hmi_fi_tclU64& oU64);
   virtual tVoid vVisitS64(sds2hmi_fi_tclS64& oS64);
   virtual tVoid vVisitF32(sds2hmi_fi_tclF32& oF32);
   virtual tVoid vVisitF64(sds2hmi_fi_tclF64& oF64);
   virtual tVoid vVisitBool(sds2hmi_fi_tclBool& oBool);
   virtual tVoid vVisitString(sds2hmi_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(sds2hmi_fi_tclMultiLanguageString& oString);

   virtual tVoid vVisitList(sds2hmi_fi_tclList& oList);
   virtual tVoid vVisit_e8_BinContainerTypes(sds2hmi_fi_tcl_e8_BinContainerTypes& oe8_BinContainerTypes);

   virtual tVoid vVisit_BinContainer(sds2hmi_fi_tcl_BinContainer& oBinContainer);

   virtual tVoid vVisit_Reserved(sds2hmi_fi_tcl_Reserved& oReserved);

   virtual tVoid vVisit_u8_Percent(sds2hmi_fi_tcl_u8_Percent& ou8_Percent);

   virtual tVoid vVisit_s16_PerThousand(sds2hmi_fi_tcl_s16_PerThousand& os16_PerThousand);

   virtual tVoid vVisit_u16_IndexInReferenceList(sds2hmi_fi_tcl_u16_IndexInReferenceList& ou16_IndexInReferenceList);

   virtual tVoid vVisit_u16_ErrorCode(sds2hmi_fi_tcl_u16_ErrorCode& ou16_ErrorCode);

   virtual tVoid vVisit_u16_RPM(sds2hmi_fi_tcl_u16_RPM& ou16_RPM);

   virtual tVoid vVisit_s32_Kilogram(sds2hmi_fi_tcl_s32_Kilogram& os32_Kilogram);

   virtual tVoid vVisit_s32_Pound(sds2hmi_fi_tcl_s32_Pound& os32_Pound);

   virtual tVoid vVisit_s16_Meter(sds2hmi_fi_tcl_s16_Meter& os16_Meter);

   virtual tVoid vVisit_s32_Meter(sds2hmi_fi_tcl_s32_Meter& os32_Meter);

   virtual tVoid vVisit_s32_Yards(sds2hmi_fi_tcl_s32_Yards& os32_Yards);

   virtual tVoid vVisit_s32_Foot(sds2hmi_fi_tcl_s32_Foot& os32_Foot);

   virtual tVoid vVisit_s32_Centimeter(sds2hmi_fi_tcl_s32_Centimeter& os32_Centimeter);

   virtual tVoid vVisit_s32_Inch(sds2hmi_fi_tcl_s32_Inch& os32_Inch);

   virtual tVoid vVisit_s32_Millimeter(sds2hmi_fi_tcl_s32_Millimeter& os32_Millimeter);

   virtual tVoid vVisit_s32_Microliter(sds2hmi_fi_tcl_s32_Microliter& os32_Microliter);

   virtual tVoid vVisit_s32_Second(sds2hmi_fi_tcl_s32_Second& os32_Second);

   virtual tVoid vVisit_u16_MilliSecond(sds2hmi_fi_tcl_u16_MilliSecond& ou16_MilliSecond);

   virtual tVoid vVisit_s32_MilliSecond(sds2hmi_fi_tcl_s32_MilliSecond& os32_MilliSecond);

   virtual tVoid vVisit_POSIXTime(sds2hmi_fi_tcl_POSIXTime& oPOSIXTime);

   virtual tVoid vVisit_e8_DST_State(sds2hmi_fi_tcl_e8_DST_State& oe8_DST_State);

   virtual tVoid vVisit_TimeZoneElement(sds2hmi_fi_tcl_TimeZoneElement& oTimeZoneElement);

   virtual tVoid vVisit_s16_KmPerHour(sds2hmi_fi_tcl_s16_KmPerHour& os16_KmPerHour);

   virtual tVoid vVisit_s16_MilesPerHour(sds2hmi_fi_tcl_s16_MilesPerHour& os16_MilesPerHour);

   virtual tVoid vVisit_s16_Knot(sds2hmi_fi_tcl_s16_Knot& os16_Knot);

   virtual tVoid vVisit_s16_CentimeterSecond(sds2hmi_fi_tcl_s16_CentimeterSecond& os16_CentimeterSecond);

   virtual tVoid vVisit_s16_Kelvin(sds2hmi_fi_tcl_s16_Kelvin& os16_Kelvin);

   virtual tVoid vVisit_s16_Fahrenheit(sds2hmi_fi_tcl_s16_Fahrenheit& os16_Fahrenheit);

   virtual tVoid vVisit_s32_Pascal(sds2hmi_fi_tcl_s32_Pascal& os32_Pascal);

   virtual tVoid vVisit_s32_Watt(sds2hmi_fi_tcl_s32_Watt& os32_Watt);

   virtual tVoid vVisit_FIVersion(sds2hmi_fi_tcl_FIVersion& oFIVersion);

   virtual tVoid vVisit_s32_Longitude(sds2hmi_fi_tcl_s32_Longitude& os32_Longitude);

   virtual tVoid vVisit_s32_Latitude(sds2hmi_fi_tcl_s32_Latitude& os32_Latitude);

   virtual tVoid vVisit_PositionWGS84(sds2hmi_fi_tcl_PositionWGS84& oPositionWGS84);

   virtual tVoid vVisit_RectangleWGS84(sds2hmi_fi_tcl_RectangleWGS84& oRectangleWGS84);

   virtual tVoid vVisit_e16_ISOCountryCode(sds2hmi_fi_tcl_e16_ISOCountryCode& oe16_ISOCountryCode);

   virtual tVoid vVisit_e16_ISOLanguageCode(sds2hmi_fi_tcl_e16_ISOLanguageCode& oe16_ISOLanguageCode);

   virtual tVoid vVisit_LanguageID(sds2hmi_fi_tcl_LanguageID& oLanguageID);

   virtual tVoid vVisit_u8_DirectionAbsolute(sds2hmi_fi_tcl_u8_DirectionAbsolute& ou8_DirectionAbsolute);

   virtual tVoid vVisit_u8_DirectionRelative(sds2hmi_fi_tcl_u8_DirectionRelative& ou8_DirectionRelative);

   virtual tVoid vVisit_s16_CentiDegree(sds2hmi_fi_tcl_s16_CentiDegree& os16_CentiDegree);

   virtual tVoid vVisit_s16_Degree(sds2hmi_fi_tcl_s16_Degree& os16_Degree);

   virtual tVoid vVisit_u16_DirectionAbsolute_CentiDegree(sds2hmi_fi_tcl_u16_DirectionAbsolute_CentiDegree& ou16_DirectionAbsolute_CentiDegree);

   virtual tVoid vVisit_s16_DirectionRelative_CentiDegree(sds2hmi_fi_tcl_s16_DirectionRelative_CentiDegree& os16_DirectionRelative_CentiDegree);

   virtual tVoid vVisit_e8_FuelType(sds2hmi_fi_tcl_e8_FuelType& oe8_FuelType);

   virtual tVoid vVisit_DistTimeFuel(sds2hmi_fi_tcl_DistTimeFuel& oDistTimeFuel);

   virtual tVoid vVisit_e16_ISO639_3_SDSLanguageCode(sds2hmi_fi_tcl_e16_ISO639_3_SDSLanguageCode& oe16_ISO639_3_SDSLanguageCode);

   virtual tVoid vVisit_e8_Slot(sds2hmi_fi_tcl_e8_Slot& oe8_Slot);

   virtual tVoid vVisit_e8_Domain(sds2hmi_fi_tcl_e8_Domain& oe8_Domain);

   virtual tVoid vVisit_e8_ConnectedDeviceUpdateStatus(sds2hmi_fi_tcl_e8_ConnectedDeviceUpdateStatus& oe8_ConnectedDeviceUpdateStatus);

   virtual tVoid vVisit_e8_PromptSetting(sds2hmi_fi_tcl_e8_PromptSetting& oe8_PromptSetting);

   virtual tVoid vVisit_e8_WordType(sds2hmi_fi_tcl_e8_WordType& oe8_WordType);

   virtual tVoid vVisit_e8_NDSFeatureType(sds2hmi_fi_tcl_e8_NDSFeatureType& oe8_NDSFeatureType);

   virtual tVoid vVisit_e32_SSE_ASR_Mode(sds2hmi_fi_tcl_e32_SSE_ASR_Mode& oe32_SSE_ASR_Mode);

   virtual tVoid vVisit_e8_SDSDestinationType(sds2hmi_fi_tcl_e8_SDSDestinationType& oe8_SDSDestinationType);

   virtual tVoid vVisit_SDSLanguageID(sds2hmi_fi_tcl_SDSLanguageID& oSDSLanguageID);

   virtual tVoid vVisit_ConnectedDeviceStatus(sds2hmi_fi_tcl_ConnectedDeviceStatus& oConnectedDeviceStatus);

   virtual tVoid vVisit_NDSLanguageID(sds2hmi_fi_tcl_NDSLanguageID& oNDSLanguageID);

   virtual tVoid vVisit_NDSID(sds2hmi_fi_tcl_NDSID& oNDSID);

   virtual tVoid vVisit_StreetAvailability(sds2hmi_fi_tcl_StreetAvailability& oStreetAvailability);

   virtual tVoid vVisit_PhonemeForLanguage(sds2hmi_fi_tcl_PhonemeForLanguage& oPhonemeForLanguage);

   virtual tVoid vVisit_StringAndPhoneme(sds2hmi_fi_tcl_StringAndPhoneme& oStringAndPhoneme);

   virtual tVoid vVisit_StatePhoneme(sds2hmi_fi_tcl_StatePhoneme& oStatePhoneme);

   virtual tVoid vVisit_CountryPhoneme(sds2hmi_fi_tcl_CountryPhoneme& oCountryPhoneme);

   virtual tVoid vVisit_CityId(sds2hmi_fi_tcl_CityId& oCityId);

   virtual tVoid vVisit_ECNR_ASR_Mode_Status(sds2hmi_fi_tcl_ECNR_ASR_Mode_Status& oECNR_ASR_Mode_Status);

   virtual tVoid vVisit_e16_SelectionCriterionType(sds2hmi_fi_tcl_e16_SelectionCriterionType& oe16_SelectionCriterionType);

   virtual tVoid vVisit_e8_LocationDescriptionDataType(sds2hmi_fi_tcl_e8_LocationDescriptionDataType& oe8_LocationDescriptionDataType);

   virtual tVoid vVisit_b8_LocationDescriptorStatus(sds2hmi_fi_tcl_b8_LocationDescriptorStatus& ob8_LocationDescriptorStatus);

   virtual tVoid vVisit_LocationDescriptor(sds2hmi_fi_tcl_LocationDescriptor& oLocationDescriptor);

   virtual tVoid vVisit_LocationDescription(sds2hmi_fi_tcl_LocationDescription& oLocationDescription);

   virtual tVoid vVisit_StringPosition(sds2hmi_fi_tcl_StringPosition& oStringPosition);

   virtual tVoid vVisit_StringID(sds2hmi_fi_tcl_StringID& oStringID);

   virtual tVoid vVisit_FLIString(sds2hmi_fi_tcl_FLIString& oFLIString);

   virtual tVoid vVisit_b8_PositionStatus(sds2hmi_fi_tcl_b8_PositionStatus& ob8_PositionStatus);

   virtual tVoid vVisit_ListOfPositions(sds2hmi_fi_tcl_ListOfPositions& oListOfPositions);

   virtual tVoid vVisit_e8_FilterAttributeType(sds2hmi_fi_tcl_e8_FilterAttributeType& oe8_FilterAttributeType);

   virtual tVoid vVisit_FilterAttribute(sds2hmi_fi_tcl_FilterAttribute& oFilterAttribute);

   virtual tVoid vVisit_e16_MenuItemType(sds2hmi_fi_tcl_e16_MenuItemType& oe16_MenuItemType);

   virtual tVoid vVisit_e8_LocationValueListType(sds2hmi_fi_tcl_e8_LocationValueListType& oe8_LocationValueListType);

   virtual tVoid vVisit_b8_ListResultOptions(sds2hmi_fi_tcl_b8_ListResultOptions& ob8_ListResultOptions);

   virtual tVoid vVisit_b8_ListGetOptions(sds2hmi_fi_tcl_b8_ListGetOptions& ob8_ListGetOptions);

   virtual tVoid vVisit_LocationValueListUnion(sds2hmi_fi_tcl_LocationValueListUnion& oLocationValueListUnion);

   virtual tVoid vVisit_b16_ElementProperties(sds2hmi_fi_tcl_b16_ElementProperties& ob16_ElementProperties);

   virtual tVoid vVisit_StringElement(sds2hmi_fi_tcl_StringElement& oStringElement);

   virtual tVoid vVisit_StringList(sds2hmi_fi_tcl_StringList& oStringList);

   virtual tVoid vVisit_StringDescriptionElement(sds2hmi_fi_tcl_StringDescriptionElement& oStringDescriptionElement);

   virtual tVoid vVisit_StringDescriptionList(sds2hmi_fi_tcl_StringDescriptionList& oStringDescriptionList);

   virtual tVoid vVisit_StringIDElement(sds2hmi_fi_tcl_StringIDElement& oStringIDElement);

   virtual tVoid vVisit_StringIDList(sds2hmi_fi_tcl_StringIDList& oStringIDList);

   virtual tVoid vVisit_PositionWGS84Element(sds2hmi_fi_tcl_PositionWGS84Element& oPositionWGS84Element);

   virtual tVoid vVisit_PositionWGS84List(sds2hmi_fi_tcl_PositionWGS84List& oPositionWGS84List);

   virtual tVoid vVisit_StringPositionElement(sds2hmi_fi_tcl_StringPositionElement& oStringPositionElement);

   virtual tVoid vVisit_StringPositionList(sds2hmi_fi_tcl_StringPositionList& oStringPositionList);

   virtual tVoid vVisit_StringPositionDescriptionElement(sds2hmi_fi_tcl_StringPositionDescriptionElement& oStringPositionDescriptionElement);

   virtual tVoid vVisit_StringPositionDescriptionList(sds2hmi_fi_tcl_StringPositionDescriptionList& oStringPositionDescriptionList);

   virtual tVoid vVisit_b8_CriterionStatus(sds2hmi_fi_tcl_b8_CriterionStatus& ob8_CriterionStatus);

   virtual tVoid vVisit_b8_ListSortOptions(sds2hmi_fi_tcl_b8_ListSortOptions& ob8_ListSortOptions);

   virtual tVoid vVisit_SelectionCriterionDescription(sds2hmi_fi_tcl_SelectionCriterionDescription& oSelectionCriterionDescription);

   virtual tVoid vVisit_b8_CriteriaGetOptions(sds2hmi_fi_tcl_b8_CriteriaGetOptions& ob8_CriteriaGetOptions);

   virtual tVoid vVisit_SelectableCriterion(sds2hmi_fi_tcl_SelectableCriterion& oSelectableCriterion);

   virtual tVoid vVisit_e8_TransformMode(sds2hmi_fi_tcl_e8_TransformMode& oe8_TransformMode);

   virtual tVoid vVisit_b16_PositionReliability(sds2hmi_fi_tcl_b16_PositionReliability& ob16_PositionReliability);

   virtual tVoid vVisit_PositionHeadingSpeed(sds2hmi_fi_tcl_PositionHeadingSpeed& oPositionHeadingSpeed);

   virtual tVoid vVisit_e8_NavLocationDescType(sds2hmi_fi_tcl_e8_NavLocationDescType& oe8_NavLocationDescType);

   virtual tVoid vVisit_NavLocationDesc(sds2hmi_fi_tcl_NavLocationDesc& oNavLocationDesc);

#ifndef FI_S_EXTERNAL_FI
   virtual tVoid vVisit_NavLocationBinContainer(sds2hmi_fi_tcl_NavLocationBinContainer& oNavLocationBinContainer);

#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_e8_NavIndexZFDestinationType(sds2hmi_fi_tcl_e8_NavIndexZFDestinationType& oe8_NavIndexZFDestinationType);

   virtual tVoid vVisit_e8_NavLocationNavDataType(sds2hmi_fi_tcl_e8_NavLocationNavDataType& oe8_NavLocationNavDataType);

   virtual tVoid vVisit_u32_DataSetId(sds2hmi_fi_tcl_u32_DataSetId& ou32_DataSetId);

   virtual tVoid vVisit_e8_SideInfo(sds2hmi_fi_tcl_e8_SideInfo& oe8_SideInfo);

   virtual tVoid vVisit_e8_NavOneCellDirection(sds2hmi_fi_tcl_e8_NavOneCellDirection& oe8_NavOneCellDirection);

   virtual tVoid vVisit_NavClusterDesc(sds2hmi_fi_tcl_NavClusterDesc& oNavClusterDesc);

   virtual tVoid vVisit_NavStreetDestinationOneCellProperty(sds2hmi_fi_tcl_NavStreetDestinationOneCellProperty& oNavStreetDestinationOneCellProperty);

   virtual tVoid vVisit_NavOneCellDesc(sds2hmi_fi_tcl_NavOneCellDesc& oNavOneCellDesc);

   virtual tVoid vVisit_NavStreetDestinationOneCellDesc(sds2hmi_fi_tcl_NavStreetDestinationOneCellDesc& oNavStreetDestinationOneCellDesc);

   virtual tVoid vVisit_e8_NavIntersectionType(sds2hmi_fi_tcl_e8_NavIntersectionType& oe8_NavIntersectionType);

   virtual tVoid vVisit_NavZeroCellDesc(sds2hmi_fi_tcl_NavZeroCellDesc& oNavZeroCellDesc);

   virtual tVoid vVisit_NavIntersectionDestinationZeroCellProperty(sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellProperty& oNavIntersectionDestinationZeroCellProperty);

   virtual tVoid vVisit_NavIntersectionDestinationZeroCellDesc(sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellDesc& oNavIntersectionDestinationZeroCellDesc);

   virtual tVoid vVisit_NavAreaDescriptionCircle(sds2hmi_fi_tcl_NavAreaDescriptionCircle& oNavAreaDescriptionCircle);

   virtual tVoid vVisit_NavAreaDescriptionPolygon(sds2hmi_fi_tcl_NavAreaDescriptionPolygon& oNavAreaDescriptionPolygon);

   virtual tVoid vVisit_NavLocationDataDesc(sds2hmi_fi_tcl_NavLocationDataDesc& oNavLocationDataDesc);

   virtual tVoid vVisit_u32_MediaId(sds2hmi_fi_tcl_u32_MediaId& ou32_MediaId);

   virtual tVoid vVisit_s32_EMU(sds2hmi_fi_tcl_s32_EMU& os32_EMU);

   virtual tVoid vVisit_e8_NavDataLevel(sds2hmi_fi_tcl_e8_NavDataLevel& oe8_NavDataLevel);

   virtual tVoid vVisit_NavSpotDestinationOneCellProperty(sds2hmi_fi_tcl_NavSpotDestinationOneCellProperty& oNavSpotDestinationOneCellProperty);

   virtual tVoid vVisit_NavStreetDestinationOneCellListSet(sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet& oNavStreetDestinationOneCellListSet);

   virtual tVoid vVisit_NavSpotDestinationOneCellDesc(sds2hmi_fi_tcl_NavSpotDestinationOneCellDesc& oNavSpotDestinationOneCellDesc);

   virtual tVoid vVisit_NavSpotDestinationOneCellListSet(sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet& oNavSpotDestinationOneCellListSet);

   virtual tVoid vVisit_NavIntersectionDestinationZeroCellListSet(sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet& oNavIntersectionDestinationZeroCellListSet);

   virtual tVoid vVisit_NavOneCell(sds2hmi_fi_tcl_NavOneCell& oNavOneCell);

   virtual tVoid vVisit_e8_NavOneCellCategory(sds2hmi_fi_tcl_e8_NavOneCellCategory& oe8_NavOneCellCategory);

   virtual tVoid vVisit_e8_Action(sds2hmi_fi_tcl_e8_Action& oe8_Action);

   virtual tVoid vVisit_e8_Application(sds2hmi_fi_tcl_e8_Application& oe8_Application);

   virtual tVoid vVisit_e8_PopUp_UpdateType(sds2hmi_fi_tcl_e8_PopUp_UpdateType& oe8_PopUp_UpdateType);

   virtual tVoid vVisit_e8_PopUp_ListType(sds2hmi_fi_tcl_e8_PopUp_ListType& oe8_PopUp_ListType);

   virtual tVoid vVisit_e8_GEN_SelectionType(sds2hmi_fi_tcl_e8_GEN_SelectionType& oe8_GEN_SelectionType);

   virtual tVoid vVisit_e8_PlayAction(sds2hmi_fi_tcl_e8_PlayAction& oe8_PlayAction);

   virtual tVoid vVisit_e8_TUN_SelectionType(sds2hmi_fi_tcl_e8_TUN_SelectionType& oe8_TUN_SelectionType);

   virtual tVoid vVisit_e8_TUN_Status(sds2hmi_fi_tcl_e8_TUN_Status& oe8_TUN_Status);

   virtual tVoid vVisit_e8_TUN_Band(sds2hmi_fi_tcl_e8_TUN_Band& oe8_TUN_Band);

   virtual tVoid vVisit_e8_TUN_MemBank(sds2hmi_fi_tcl_e8_TUN_MemBank& oe8_TUN_MemBank);

   virtual tVoid vVisit_e8_TUN_Setting(sds2hmi_fi_tcl_e8_TUN_Setting& oe8_TUN_Setting);

   virtual tVoid vVisit_e8_GLOBAL_Status(sds2hmi_fi_tcl_e8_GLOBAL_Status& oe8_GLOBAL_Status);

   virtual tVoid vVisit_e8_MediaDataType(sds2hmi_fi_tcl_e8_MediaDataType& oe8_MediaDataType);

   virtual tVoid vVisit_e8_SMS_Status(sds2hmi_fi_tcl_e8_SMS_Status& oe8_SMS_Status);

   virtual tVoid vVisit_e8_PHN_Status(sds2hmi_fi_tcl_e8_PHN_Status& oe8_PHN_Status);

   virtual tVoid vVisit_e8_PHN_MenuType(sds2hmi_fi_tcl_e8_PHN_MenuType& oe8_PHN_MenuType);

   virtual tVoid vVisit_e8_PHN_Setting(sds2hmi_fi_tcl_e8_PHN_Setting& oe8_PHN_Setting);

   virtual tVoid vVisit_e8_PHN_ListType(sds2hmi_fi_tcl_e8_PHN_ListType& oe8_PHN_ListType);

   virtual tVoid vVisit_e8_PHN_NumberType(sds2hmi_fi_tcl_e8_PHN_NumberType& oe8_PHN_NumberType);

   virtual tVoid vVisit_e8_PHN_SelectionType(sds2hmi_fi_tcl_e8_PHN_SelectionType& oe8_PHN_SelectionType);

   virtual tVoid vVisit_e8_PHN_Transorder(sds2hmi_fi_tcl_e8_PHN_Transorder& oe8_PHN_Transorder);

   virtual tVoid vVisit_e8_NAV_Status(sds2hmi_fi_tcl_e8_NAV_Status& oe8_NAV_Status);

   virtual tVoid vVisit_e8_NAV_MenuType(sds2hmi_fi_tcl_e8_NAV_MenuType& oe8_NAV_MenuType);

   virtual tVoid vVisit_e8_NAV_RouteCriteria(sds2hmi_fi_tcl_e8_NAV_RouteCriteria& oe8_NAV_RouteCriteria);

   virtual tVoid vVisit_e8_NAV_ZoomLevel(sds2hmi_fi_tcl_e8_NAV_ZoomLevel& oe8_NAV_ZoomLevel);

   virtual tVoid vVisit_e8_NAV_ListType(sds2hmi_fi_tcl_e8_NAV_ListType& oe8_NAV_ListType);

   virtual tVoid vVisit_e8_NAV_NavUnit(sds2hmi_fi_tcl_e8_NAV_NavUnit& oe8_NAV_NavUnit);

   virtual tVoid vVisit_e8_NAV_VDEAvailInfo(sds2hmi_fi_tcl_e8_NAV_VDEAvailInfo& oe8_NAV_VDEAvailInfo);

   virtual tVoid vVisit_e8_NAV_Setting(sds2hmi_fi_tcl_e8_NAV_Setting& oe8_NAV_Setting);

   virtual tVoid vVisit_e8_NAV_MapMode(sds2hmi_fi_tcl_e8_NAV_MapMode& oe8_NAV_MapMode);

   virtual tVoid vVisit_e8_NAV_AutoZoom(sds2hmi_fi_tcl_e8_NAV_AutoZoom& oe8_NAV_AutoZoom);

   virtual tVoid vVisit_e8_NAV_MapView(sds2hmi_fi_tcl_e8_NAV_MapView& oe8_NAV_MapView);

   virtual tVoid vVisit_e8_NAV_MapOrientation(sds2hmi_fi_tcl_e8_NAV_MapOrientation& oe8_NAV_MapOrientation);

   virtual tVoid vVisit_e8_NAV_TBT_Symbols(sds2hmi_fi_tcl_e8_NAV_TBT_Symbols& oe8_NAV_TBT_Symbols);

   virtual tVoid vVisit_e8_NAV_POIListType(sds2hmi_fi_tcl_e8_NAV_POIListType& oe8_NAV_POIListType);

   virtual tVoid vVisit_e8_SET_DisplayMode(sds2hmi_fi_tcl_e8_SET_DisplayMode& oe8_SET_DisplayMode);

   virtual tVoid vVisit_e8_TMCListContent(sds2hmi_fi_tcl_e8_TMCListContent& oe8_TMCListContent);

   virtual tVoid vVisit_b8_PopUp_ResultOptions(sds2hmi_fi_tcl_b8_PopUp_ResultOptions& ob8_PopUp_ResultOptions);

   virtual tVoid vVisit_b16_AnsOptions(sds2hmi_fi_tcl_b16_AnsOptions& ob16_AnsOptions);

   virtual tVoid vVisit_b8_StringPhonemeSearchSetting(sds2hmi_fi_tcl_b8_StringPhonemeSearchSetting& ob8_StringPhonemeSearchSetting);

   virtual tVoid vVisit_e8_UPOI_Source(sds2hmi_fi_tcl_e8_UPOI_Source& oe8_UPOI_Source);

   virtual tVoid vVisit_e8_Gender(sds2hmi_fi_tcl_e8_Gender& oe8_Gender);

   virtual tVoid vVisit_e8_SDS_Status(sds2hmi_fi_tcl_e8_SDS_Status& oe8_SDS_Status);

   virtual tVoid vVisit_e8_DeviceStatus(sds2hmi_fi_tcl_e8_DeviceStatus& oe8_DeviceStatus);

   virtual tVoid vVisit_e8_MPL_ListType(sds2hmi_fi_tcl_e8_MPL_ListType& oe8_MPL_ListType);

   virtual tVoid vVisit_e8_MPL_MenuType(sds2hmi_fi_tcl_e8_MPL_MenuType& oe8_MPL_MenuType);

   virtual tVoid vVisit_e8_MPL_SourceType(sds2hmi_fi_tcl_e8_MPL_SourceType& oe8_MPL_SourceType);

   virtual tVoid vVisit_e8_MPL_Status(sds2hmi_fi_tcl_e8_MPL_Status& oe8_MPL_Status);

   virtual tVoid vVisit_e8_WEA_MenuType(sds2hmi_fi_tcl_e8_WEA_MenuType& oe8_WEA_MenuType);

   virtual tVoid vVisit_e8_WEA_Status(sds2hmi_fi_tcl_e8_WEA_Status& oe8_WEA_Status);

   virtual tVoid vVisit_e8_WEA_Location(sds2hmi_fi_tcl_e8_WEA_Location& oe8_WEA_Location);

   virtual tVoid vVisit_e8_NAV_LocationType(sds2hmi_fi_tcl_e8_NAV_LocationType& oe8_NAV_LocationType);

   virtual tVoid vVisit_e8_CON_AmbiguityListType(sds2hmi_fi_tcl_e8_CON_AmbiguityListType& oe8_CON_AmbiguityListType);

   virtual tVoid vVisit_e8_CON_EntryType(sds2hmi_fi_tcl_e8_CON_EntryType& oe8_CON_EntryType);

   virtual tVoid vVisit_e8_LOG_ConfidenceThreshold(sds2hmi_fi_tcl_e8_LOG_ConfidenceThreshold& oe8_LOG_ConfidenceThreshold);

   virtual tVoid vVisit_e8_ParameterAction(sds2hmi_fi_tcl_e8_ParameterAction& oe8_ParameterAction);

   virtual tVoid vVisit_e8_SDS_ParameterType(sds2hmi_fi_tcl_e8_SDS_ParameterType& oe8_SDS_ParameterType);

   virtual tVoid vVisit_e8_SDSSettings(sds2hmi_fi_tcl_e8_SDSSettings& oe8_SDSSettings);

   virtual tVoid vVisit_e8_SettingsError(sds2hmi_fi_tcl_e8_SettingsError& oe8_SettingsError);

   virtual tVoid vVisit_e8_HMI_ListType(sds2hmi_fi_tcl_e8_HMI_ListType& oe8_HMI_ListType);

   virtual tVoid vVisit_e8_HMI_ListSize(sds2hmi_fi_tcl_e8_HMI_ListSize& oe8_HMI_ListSize);

   virtual tVoid vVisit_e8_Info_Menu(sds2hmi_fi_tcl_e8_Info_Menu& oe8_Info_Menu);

   virtual tVoid vVisit_e8_Info_SXM_Services(sds2hmi_fi_tcl_e8_Info_SXM_Services& oe8_Info_SXM_Services);

   virtual tVoid vVisit_e8_SpecialAppId(sds2hmi_fi_tcl_e8_SpecialAppId& oe8_SpecialAppId);

   virtual tVoid vVisit_e8_SpecialAppStatus(sds2hmi_fi_tcl_e8_SpecialAppStatus& oe8_SpecialAppStatus);

   virtual tVoid vVisit_e8_INFO_TCUType(sds2hmi_fi_tcl_e8_INFO_TCUType& oe8_INFO_TCUType);

   virtual tVoid vVisit_e8_TUN_Band_Group(sds2hmi_fi_tcl_e8_TUN_Band_Group& oe8_TUN_Band_Group);

   virtual tVoid vVisit_e8_HMIElementDescriptorMode(sds2hmi_fi_tcl_e8_HMIElementDescriptorMode& oe8_HMIElementDescriptorMode);

   virtual tVoid vVisit_e8_NAV_ZoomAction(sds2hmi_fi_tcl_e8_NAV_ZoomAction& oe8_NAV_ZoomAction);

   virtual tVoid vVisit_e8_NAV_IconDisplayAction(sds2hmi_fi_tcl_e8_NAV_IconDisplayAction& oe8_NAV_IconDisplayAction);

   virtual tVoid vVisit_e8_SDS_EntryPoint(sds2hmi_fi_tcl_e8_SDS_EntryPoint& oe8_SDS_EntryPoint);

   virtual tVoid vVisit_e8_MainDomains(sds2hmi_fi_tcl_e8_MainDomains& oe8_MainDomains);

   virtual tVoid vVisit_e8_HMIElementReference(sds2hmi_fi_tcl_e8_HMIElementReference& oe8_HMIElementReference);

   virtual tVoid vVisit_e8_CoreSpeechParameters(sds2hmi_fi_tcl_e8_CoreSpeechParameters& oe8_CoreSpeechParameters);

   virtual tVoid vVisit_e8_ActionInfoCategory(sds2hmi_fi_tcl_e8_ActionInfoCategory& oe8_ActionInfoCategory);

   virtual tVoid vVisit_e8_PhBook_Update_Action(sds2hmi_fi_tcl_e8_PhBook_Update_Action& oe8_PhBook_Update_Action);

   virtual tVoid vVisit_e16_PHN_Relationship(sds2hmi_fi_tcl_e16_PHN_Relationship& oe16_PHN_Relationship);

   virtual tVoid vVisit_e8_Data_Exchange_Type(sds2hmi_fi_tcl_e8_Data_Exchange_Type& oe8_Data_Exchange_Type);

   virtual tVoid vVisit_e8_Common_SDS_Evnt(sds2hmi_fi_tcl_e8_Common_SDS_Evnt& oe8_Common_SDS_Evnt);

   virtual tVoid vVisit_e8NDSPhoneticTranscriptionFormat(sds2hmi_fi_tcl_e8NDSPhoneticTranscriptionFormat& oe8NDSPhoneticTranscriptionFormat);

   virtual tVoid vVisit_e8_NDS_SDN_Status(sds2hmi_fi_tcl_e8_NDS_SDN_Status& oe8_NDS_SDN_Status);

   virtual tVoid vVisit_e8_Info_Menu_Srvc_Status(sds2hmi_fi_tcl_e8_Info_Menu_Srvc_Status& oe8_Info_Menu_Srvc_Status);

   virtual tVoid vVisit_e8_EventForLogging(sds2hmi_fi_tcl_e8_EventForLogging& oe8_EventForLogging);

   virtual tVoid vVisit_e8_Distance_Unit(sds2hmi_fi_tcl_e8_Distance_Unit& oe8_Distance_Unit);

   virtual tVoid vVisit_e8_SharedDataAccess(sds2hmi_fi_tcl_e8_SharedDataAccess& oe8_SharedDataAccess);

   virtual tVoid vVisit_e8_JournalingMode(sds2hmi_fi_tcl_e8_JournalingMode& oe8_JournalingMode);

   virtual tVoid vVisit_e8_LockType(sds2hmi_fi_tcl_e8_LockType& oe8_LockType);

   virtual tVoid vVisit_e8_NDSDataAccessType(sds2hmi_fi_tcl_e8_NDSDataAccessType& oe8_NDSDataAccessType);

   virtual tVoid vVisit_e8_RegistrationAndDeRegistrationStatus(sds2hmi_fi_tcl_e8_RegistrationAndDeRegistrationStatus& oe8_RegistrationAndDeRegistrationStatus);

   virtual tVoid vVisit_DestEntry(sds2hmi_fi_tcl_DestEntry& oDestEntry);

   virtual tVoid vVisit_PhoneEntry(sds2hmi_fi_tcl_PhoneEntry& oPhoneEntry);

   virtual tVoid vVisit_ContactData(sds2hmi_fi_tcl_ContactData& oContactData);

   virtual tVoid vVisit_TmcEntry(sds2hmi_fi_tcl_TmcEntry& oTmcEntry);

   virtual tVoid vVisit_DeviceStatus(sds2hmi_fi_tcl_DeviceStatus& oDeviceStatus);

   virtual tVoid vVisit_TunerEntry(sds2hmi_fi_tcl_TunerEntry& oTunerEntry);

   virtual tVoid vVisit_Userword(sds2hmi_fi_tcl_Userword& oUserword);

   virtual tVoid vVisit_LanguageAndSpeaker(sds2hmi_fi_tcl_LanguageAndSpeaker& oLanguageAndSpeaker);

   virtual tVoid vVisit_MediaData(sds2hmi_fi_tcl_MediaData& oMediaData);

   virtual tVoid vVisit_MediaEntry(sds2hmi_fi_tcl_MediaEntry& oMediaEntry);

   virtual tVoid vVisit_DeviceDatabase(sds2hmi_fi_tcl_DeviceDatabase& oDeviceDatabase);

   virtual tVoid vVisit_CON_AmbiguityResultEntry(sds2hmi_fi_tcl_CON_AmbiguityResultEntry& oCON_AmbiguityResultEntry);

   virtual tVoid vVisit_StringIDPair(sds2hmi_fi_tcl_StringIDPair& oStringIDPair);

   virtual tVoid vVisit_e8_MediaType(sds2hmi_fi_tcl_e8_MediaType& oe8_MediaType);

   virtual tVoid vVisit_TypedMediaID(sds2hmi_fi_tcl_TypedMediaID& oTypedMediaID);

   virtual tVoid vVisit_MediaIDString(sds2hmi_fi_tcl_MediaIDString& oMediaIDString);

   virtual tVoid vVisit_SDS_SettingsUnion(sds2hmi_fi_tcl_SDS_SettingsUnion& oSDS_SettingsUnion);

   virtual tVoid vVisit_SDS_SettingsRequest(sds2hmi_fi_tcl_SDS_SettingsRequest& oSDS_SettingsRequest);

   virtual tVoid vVisit_SDS_Settings(sds2hmi_fi_tcl_SDS_Settings& oSDS_Settings);

   virtual tVoid vVisit_NeighboringLocation(sds2hmi_fi_tcl_NeighboringLocation& oNeighboringLocation);

   virtual tVoid vVisit_SpecialAppAndStatus(sds2hmi_fi_tcl_SpecialAppAndStatus& oSpecialAppAndStatus);

   virtual tVoid vVisit_HMIElementDescription(sds2hmi_fi_tcl_HMIElementDescription& oHMIElementDescription);

   virtual tVoid vVisit_Nav_IconSetting(sds2hmi_fi_tcl_Nav_IconSetting& oNav_IconSetting);

   virtual tVoid vVisit_HMIElementDescrptionList(sds2hmi_fi_tcl_HMIElementDescrptionList& oHMIElementDescrptionList);

   virtual tVoid vVisit_CoreSpeechParameter(sds2hmi_fi_tcl_CoreSpeechParameter& oCoreSpeechParameter);

   virtual tVoid vVisit_Action_AdditionalInfo(sds2hmi_fi_tcl_Action_AdditionalInfo& oAction_AdditionalInfo);

   virtual tVoid vVisit_RegionMetaData(sds2hmi_fi_tcl_RegionMetaData& oRegionMetaData);

   virtual tVoid vVisit_MetaData(sds2hmi_fi_tcl_MetaData& oMetaData);

   virtual tVoid vVisit_BuildingBlock(sds2hmi_fi_tcl_BuildingBlock& oBuildingBlock);

   virtual tVoid vVisit_UpdateRegion(sds2hmi_fi_tcl_UpdateRegion& oUpdateRegion);

   virtual tVoid vVisit_SDSProduct(sds2hmi_fi_tcl_SDSProduct& oSDSProduct);

   virtual tVoid vVisit_NDSLocationDetails(sds2hmi_fi_tcl_NDSLocationDetails& oNDSLocationDetails);

   virtual tVoid vVisit_Info_Menu_Srvice_Status(sds2hmi_fi_tcl_Info_Menu_Srvice_Status& oInfo_Menu_Srvice_Status);

   virtual tVoid vVisit_RecResult(sds2hmi_fi_tcl_RecResult& oRecResult);

   virtual tVoid vVisit_ConfThresholdSet(sds2hmi_fi_tcl_ConfThresholdSet& oConfThresholdSet);

   virtual tVoid vVisit_DestinationAndLanguageDetails(sds2hmi_fi_tcl_DestinationAndLanguageDetails& oDestinationAndLanguageDetails);

   virtual tVoid vVisit_SharedDataAccessAttributes(sds2hmi_fi_tcl_SharedDataAccessAttributes& oSharedDataAccessAttributes);

   virtual tVoid vVisit_DestinationElement(sds2hmi_fi_tcl_DestinationElement& oDestinationElement);

   virtual tVoid vVisit_DestinationItem(sds2hmi_fi_tcl_DestinationItem& oDestinationItem);

   virtual tVoid vVisit_ValidatedDestinationDetails(sds2hmi_fi_tcl_ValidatedDestinationDetails& oValidatedDestinationDetails);


 	fi_tclTraversePath<fi_tclKnot>::tclIterator oIterator;		
	
protected:
	tBool bBreakNow;
	tBool bIsVisitorValid;
private:

};

#endif
