#ifndef __SDS2HMI_SDSFIDEBUGVISITOR_H__
#define __SDS2HMI_SDSFIDEBUGVISITOR_H__

class MY_DECL sds2hmi_sdsfi_tclPrintVisitor : public sds2hmi_sdsfi_tclVisitorBase {

private:
   /* default constructor */ sds2hmi_sdsfi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   sds2hmi_sdsfi_tclPrintVisitor(sds2hmi_fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(sds2hmi_fi_tclU8& oU8);
   virtual tVoid vVisitS8(sds2hmi_fi_tclS8& oS8);
   virtual tVoid vVisitU16(sds2hmi_fi_tclU16& oU16);
   virtual tVoid vVisitS16(sds2hmi_fi_tclS16& oS16);
   virtual tVoid vVisitU24(sds2hmi_fi_tclU24& oU24);
   virtual tVoid vVisitS24(sds2hmi_fi_tclS24& oS24);
   virtual tVoid vVisitU32(sds2hmi_fi_tclU32& oU32);
   virtual tVoid vVisitS32(sds2hmi_fi_tclS32& oS32);
   virtual tVoid vVisitU64(sds2hmi_fi_tclU64& oU64);
   virtual tVoid vVisitS64(sds2hmi_fi_tclS64& oS64);
   virtual tVoid vVisitBool(sds2hmi_fi_tclBool& oBool);
   virtual tVoid vVisitString(sds2hmi_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(sds2hmi_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(sds2hmi_fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tVoid vVisit_e8_BinContainerTypes(sds2hmi_fi_tcl_e8_BinContainerTypes& o_e8_BinContainerTypes);
   virtual tBool bDoExpand_BinContainer(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e16_ISO639_3_SDSLanguageCode(sds2hmi_fi_tcl_e16_ISO639_3_SDSLanguageCode& o_e16_ISO639_3_SDSLanguageCode);
   virtual tVoid vVisit_e8_Slot(sds2hmi_fi_tcl_e8_Slot& o_e8_Slot);
   virtual tVoid vVisit_e8_Domain(sds2hmi_fi_tcl_e8_Domain& o_e8_Domain);
   virtual tVoid vVisit_e8_ConnectedDeviceUpdateStatus(sds2hmi_fi_tcl_e8_ConnectedDeviceUpdateStatus& o_e8_ConnectedDeviceUpdateStatus);
   virtual tVoid vVisit_e8_WordType(sds2hmi_fi_tcl_e8_WordType& o_e8_WordType);
   virtual tVoid vVisit_e8_NDSFeatureType(sds2hmi_fi_tcl_e8_NDSFeatureType& o_e8_NDSFeatureType);
   virtual tVoid vVisit_e32_SSE_ASR_Mode(sds2hmi_fi_tcl_e32_SSE_ASR_Mode& o_e32_SSE_ASR_Mode);
   virtual tVoid vVisit_e8_SDSDestinationType(sds2hmi_fi_tcl_e8_SDSDestinationType& o_e8_SDSDestinationType);
   virtual tVoid vVisit_e16_ISOCountryCode(sds2hmi_fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tBool bDoExpand_ConnectedDeviceStatus(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NDSLanguageID(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NDSID(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StreetAvailability(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PhonemeForLanguage(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StringAndPhoneme(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StatePhoneme(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CountryPhoneme(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ECNR_ASR_Mode_Status(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Reserved(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u16_IndexInReferenceList(sds2hmi_fi_tcl_u16_IndexInReferenceList& o_u16_IndexInReferenceList);
   virtual tVoid vVisit_s32_Meter(sds2hmi_fi_tcl_s32_Meter& o_s32_Meter);
   virtual tVoid vVisit_s16_CentimeterSecond(sds2hmi_fi_tcl_s16_CentimeterSecond& o_s16_CentimeterSecond);
   virtual tBool bDoExpand_FIVersion(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s32_Longitude(sds2hmi_fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(sds2hmi_fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tBool bDoExpand_PositionWGS84(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SDSLanguageID(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_u8_DirectionAbsolute(sds2hmi_fi_tcl_u8_DirectionAbsolute& o_u8_DirectionAbsolute);
   virtual tVoid vVisit_e16_SelectionCriterionType(sds2hmi_fi_tcl_e16_SelectionCriterionType& o_e16_SelectionCriterionType);
   virtual tVoid vVisit_e8_LocationDescriptionDataType(sds2hmi_fi_tcl_e8_LocationDescriptionDataType& o_e8_LocationDescriptionDataType);
   virtual tVoid vVisit_b8_LocationDescriptorStatus(sds2hmi_fi_tcl_b8_LocationDescriptorStatus& o_b8_LocationDescriptorStatus);
   virtual tBool bDoExpand_LocationDescriptor(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LocationDescription(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StringPosition(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StringID(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_FLIString(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_PositionStatus(sds2hmi_fi_tcl_b8_PositionStatus& o_b8_PositionStatus);
   virtual tBool bDoExpand_ListOfPositions(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_LocationValueListType(sds2hmi_fi_tcl_e8_LocationValueListType& o_e8_LocationValueListType);
   virtual tVoid vVisit_b8_ListResultOptions(sds2hmi_fi_tcl_b8_ListResultOptions& o_b8_ListResultOptions);
   virtual tBool bDoExpand_LocationValueListUnion(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b16_ElementProperties(sds2hmi_fi_tcl_b16_ElementProperties& o_b16_ElementProperties);
   virtual tBool bDoExpand_StringElement(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StringList(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StringDescriptionElement(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StringDescriptionList(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StringIDElement(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StringIDList(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PositionWGS84Element(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PositionWGS84List(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StringPositionElement(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StringPositionList(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StringPositionDescriptionElement(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StringPositionDescriptionList(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_ListSortOptions(sds2hmi_fi_tcl_b8_ListSortOptions& o_b8_ListSortOptions);
   virtual tVoid vVisit_b16_PositionReliability(sds2hmi_fi_tcl_b16_PositionReliability& o_b16_PositionReliability);
   virtual tBool bDoExpand_PositionHeadingSpeed(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_NavLocationDescType(sds2hmi_fi_tcl_e8_NavLocationDescType& o_e8_NavLocationDescType);
   virtual tBool bDoExpand_NavLocationDesc(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
#ifndef FI_S_EXTERNAL_FI
   virtual tBool bDoExpand_NavLocationBinContainer(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_e8_NavIndexZFDestinationType(sds2hmi_fi_tcl_e8_NavIndexZFDestinationType& o_e8_NavIndexZFDestinationType);
   virtual tVoid vVisit_e8_NavLocationNavDataType(sds2hmi_fi_tcl_e8_NavLocationNavDataType& o_e8_NavLocationNavDataType);
   virtual tVoid vVisit_u32_DataSetId(sds2hmi_fi_tcl_u32_DataSetId& o_u32_DataSetId);
   virtual tVoid vVisit_e8_SideInfo(sds2hmi_fi_tcl_e8_SideInfo& o_e8_SideInfo);
   virtual tVoid vVisit_e8_NavOneCellDirection(sds2hmi_fi_tcl_e8_NavOneCellDirection& o_e8_NavOneCellDirection);
   virtual tBool bDoExpand_NavClusterDesc(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavStreetDestinationOneCellProperty(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavOneCellDesc(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavStreetDestinationOneCellDesc(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_NavIntersectionType(sds2hmi_fi_tcl_e8_NavIntersectionType& o_e8_NavIntersectionType);
   virtual tBool bDoExpand_NavZeroCellDesc(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavIntersectionDestinationZeroCellProperty(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavIntersectionDestinationZeroCellDesc(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavAreaDescriptionCircle(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavAreaDescriptionPolygon(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavLocationDataDesc(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s32_EMU(sds2hmi_fi_tcl_s32_EMU& o_s32_EMU);
   virtual tBool bDoExpand_NavSpotDestinationOneCellProperty(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavStreetDestinationOneCellListSet(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavSpotDestinationOneCellDesc(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavSpotDestinationOneCellListSet(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NavIntersectionDestinationZeroCellListSet(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Action(sds2hmi_fi_tcl_e8_Action& o_e8_Action);
   virtual tVoid vVisit_e8_Application(sds2hmi_fi_tcl_e8_Application& o_e8_Application);
   virtual tVoid vVisit_e8_PopUp_UpdateType(sds2hmi_fi_tcl_e8_PopUp_UpdateType& o_e8_PopUp_UpdateType);
   virtual tVoid vVisit_e8_PopUp_ListType(sds2hmi_fi_tcl_e8_PopUp_ListType& o_e8_PopUp_ListType);
   virtual tVoid vVisit_e8_GEN_SelectionType(sds2hmi_fi_tcl_e8_GEN_SelectionType& o_e8_GEN_SelectionType);
   virtual tVoid vVisit_e8_PlayAction(sds2hmi_fi_tcl_e8_PlayAction& o_e8_PlayAction);
   virtual tVoid vVisit_e8_TUN_SelectionType(sds2hmi_fi_tcl_e8_TUN_SelectionType& o_e8_TUN_SelectionType);
   virtual tVoid vVisit_e8_TUN_Status(sds2hmi_fi_tcl_e8_TUN_Status& o_e8_TUN_Status);
   virtual tVoid vVisit_e8_TUN_Band(sds2hmi_fi_tcl_e8_TUN_Band& o_e8_TUN_Band);
   virtual tVoid vVisit_e8_TUN_MemBank(sds2hmi_fi_tcl_e8_TUN_MemBank& o_e8_TUN_MemBank);
   virtual tVoid vVisit_e8_TUN_Setting(sds2hmi_fi_tcl_e8_TUN_Setting& o_e8_TUN_Setting);
   virtual tVoid vVisit_e8_GLOBAL_Status(sds2hmi_fi_tcl_e8_GLOBAL_Status& o_e8_GLOBAL_Status);
   virtual tVoid vVisit_e8_SMS_Status(sds2hmi_fi_tcl_e8_SMS_Status& o_e8_SMS_Status);
   virtual tVoid vVisit_e8_PHN_Status(sds2hmi_fi_tcl_e8_PHN_Status& o_e8_PHN_Status);
   virtual tVoid vVisit_e8_PHN_MenuType(sds2hmi_fi_tcl_e8_PHN_MenuType& o_e8_PHN_MenuType);
   virtual tVoid vVisit_e8_PHN_Setting(sds2hmi_fi_tcl_e8_PHN_Setting& o_e8_PHN_Setting);
   virtual tVoid vVisit_e8_PHN_ListType(sds2hmi_fi_tcl_e8_PHN_ListType& o_e8_PHN_ListType);
   virtual tVoid vVisit_e8_PHN_NumberType(sds2hmi_fi_tcl_e8_PHN_NumberType& o_e8_PHN_NumberType);
   virtual tVoid vVisit_e8_PHN_SelectionType(sds2hmi_fi_tcl_e8_PHN_SelectionType& o_e8_PHN_SelectionType);
   virtual tVoid vVisit_e8_PHN_Transorder(sds2hmi_fi_tcl_e8_PHN_Transorder& o_e8_PHN_Transorder);
   virtual tVoid vVisit_e8_NAV_Status(sds2hmi_fi_tcl_e8_NAV_Status& o_e8_NAV_Status);
   virtual tVoid vVisit_e8_NAV_MenuType(sds2hmi_fi_tcl_e8_NAV_MenuType& o_e8_NAV_MenuType);
   virtual tVoid vVisit_e8_NAV_RouteCriteria(sds2hmi_fi_tcl_e8_NAV_RouteCriteria& o_e8_NAV_RouteCriteria);
   virtual tVoid vVisit_e8_NAV_ZoomLevel(sds2hmi_fi_tcl_e8_NAV_ZoomLevel& o_e8_NAV_ZoomLevel);
   virtual tVoid vVisit_e8_NAV_ListType(sds2hmi_fi_tcl_e8_NAV_ListType& o_e8_NAV_ListType);
   virtual tVoid vVisit_e8_NAV_NavUnit(sds2hmi_fi_tcl_e8_NAV_NavUnit& o_e8_NAV_NavUnit);
   virtual tVoid vVisit_e8_NAV_VDEAvailInfo(sds2hmi_fi_tcl_e8_NAV_VDEAvailInfo& o_e8_NAV_VDEAvailInfo);
   virtual tVoid vVisit_e8_NAV_Setting(sds2hmi_fi_tcl_e8_NAV_Setting& o_e8_NAV_Setting);
   virtual tVoid vVisit_e8_NAV_MapMode(sds2hmi_fi_tcl_e8_NAV_MapMode& o_e8_NAV_MapMode);
   virtual tVoid vVisit_e8_NAV_AutoZoom(sds2hmi_fi_tcl_e8_NAV_AutoZoom& o_e8_NAV_AutoZoom);
   virtual tVoid vVisit_e8_NAV_MapView(sds2hmi_fi_tcl_e8_NAV_MapView& o_e8_NAV_MapView);
   virtual tVoid vVisit_e8_NAV_MapOrientation(sds2hmi_fi_tcl_e8_NAV_MapOrientation& o_e8_NAV_MapOrientation);
   virtual tVoid vVisit_e8_NAV_TBT_Symbols(sds2hmi_fi_tcl_e8_NAV_TBT_Symbols& o_e8_NAV_TBT_Symbols);
   virtual tVoid vVisit_e8_NAV_POIListType(sds2hmi_fi_tcl_e8_NAV_POIListType& o_e8_NAV_POIListType);
   virtual tVoid vVisit_e8_TMCListContent(sds2hmi_fi_tcl_e8_TMCListContent& o_e8_TMCListContent);
   virtual tVoid vVisit_b8_PopUp_ResultOptions(sds2hmi_fi_tcl_b8_PopUp_ResultOptions& o_b8_PopUp_ResultOptions);
   virtual tVoid vVisit_b16_AnsOptions(sds2hmi_fi_tcl_b16_AnsOptions& o_b16_AnsOptions);
   virtual tVoid vVisit_b8_StringPhonemeSearchSetting(sds2hmi_fi_tcl_b8_StringPhonemeSearchSetting& o_b8_StringPhonemeSearchSetting);
   virtual tVoid vVisit_e8_UPOI_Source(sds2hmi_fi_tcl_e8_UPOI_Source& o_e8_UPOI_Source);
   virtual tVoid vVisit_e8_Gender(sds2hmi_fi_tcl_e8_Gender& o_e8_Gender);
   virtual tVoid vVisit_e8_SDS_Status(sds2hmi_fi_tcl_e8_SDS_Status& o_e8_SDS_Status);
   virtual tVoid vVisit_e8_DeviceStatus(sds2hmi_fi_tcl_e8_DeviceStatus& o_e8_DeviceStatus);
   virtual tVoid vVisit_e8_MPL_ListType(sds2hmi_fi_tcl_e8_MPL_ListType& o_e8_MPL_ListType);
   virtual tVoid vVisit_e8_MPL_MenuType(sds2hmi_fi_tcl_e8_MPL_MenuType& o_e8_MPL_MenuType);
   virtual tVoid vVisit_e8_MPL_SourceType(sds2hmi_fi_tcl_e8_MPL_SourceType& o_e8_MPL_SourceType);
   virtual tVoid vVisit_e8_MPL_Status(sds2hmi_fi_tcl_e8_MPL_Status& o_e8_MPL_Status);
   virtual tVoid vVisit_e8_WEA_MenuType(sds2hmi_fi_tcl_e8_WEA_MenuType& o_e8_WEA_MenuType);
   virtual tVoid vVisit_e8_WEA_Status(sds2hmi_fi_tcl_e8_WEA_Status& o_e8_WEA_Status);
   virtual tVoid vVisit_e8_NAV_LocationType(sds2hmi_fi_tcl_e8_NAV_LocationType& o_e8_NAV_LocationType);
   virtual tVoid vVisit_e8_CON_AmbiguityListType(sds2hmi_fi_tcl_e8_CON_AmbiguityListType& o_e8_CON_AmbiguityListType);
   virtual tVoid vVisit_e8_CON_EntryType(sds2hmi_fi_tcl_e8_CON_EntryType& o_e8_CON_EntryType);
   virtual tVoid vVisit_e8_LOG_ConfidenceThreshold(sds2hmi_fi_tcl_e8_LOG_ConfidenceThreshold& o_e8_LOG_ConfidenceThreshold);
   virtual tVoid vVisit_e8_ParameterAction(sds2hmi_fi_tcl_e8_ParameterAction& o_e8_ParameterAction);
   virtual tVoid vVisit_e8_SDS_ParameterType(sds2hmi_fi_tcl_e8_SDS_ParameterType& o_e8_SDS_ParameterType);
   virtual tVoid vVisit_e8_SDSSettings(sds2hmi_fi_tcl_e8_SDSSettings& o_e8_SDSSettings);
   virtual tVoid vVisit_e8_SettingsError(sds2hmi_fi_tcl_e8_SettingsError& o_e8_SettingsError);
   virtual tVoid vVisit_e8_HMI_ListType(sds2hmi_fi_tcl_e8_HMI_ListType& o_e8_HMI_ListType);
   virtual tVoid vVisit_e8_HMI_ListSize(sds2hmi_fi_tcl_e8_HMI_ListSize& o_e8_HMI_ListSize);
   virtual tVoid vVisit_e8_Info_Menu(sds2hmi_fi_tcl_e8_Info_Menu& o_e8_Info_Menu);
   virtual tVoid vVisit_e8_Info_SXM_Services(sds2hmi_fi_tcl_e8_Info_SXM_Services& o_e8_Info_SXM_Services);
   virtual tVoid vVisit_e8_SpecialAppId(sds2hmi_fi_tcl_e8_SpecialAppId& o_e8_SpecialAppId);
   virtual tVoid vVisit_e8_SpecialAppStatus(sds2hmi_fi_tcl_e8_SpecialAppStatus& o_e8_SpecialAppStatus);
   virtual tVoid vVisit_e8_HMIElementDescriptorMode(sds2hmi_fi_tcl_e8_HMIElementDescriptorMode& o_e8_HMIElementDescriptorMode);
   virtual tVoid vVisit_e8_NAV_ZoomAction(sds2hmi_fi_tcl_e8_NAV_ZoomAction& o_e8_NAV_ZoomAction);
   virtual tVoid vVisit_e8_NAV_IconDisplayAction(sds2hmi_fi_tcl_e8_NAV_IconDisplayAction& o_e8_NAV_IconDisplayAction);
   virtual tVoid vVisit_e8_MainDomains(sds2hmi_fi_tcl_e8_MainDomains& o_e8_MainDomains);
   virtual tVoid vVisit_e8_HMIElementReference(sds2hmi_fi_tcl_e8_HMIElementReference& o_e8_HMIElementReference);
   virtual tVoid vVisit_e8_CoreSpeechParameters(sds2hmi_fi_tcl_e8_CoreSpeechParameters& o_e8_CoreSpeechParameters);
   virtual tVoid vVisit_e8_ActionInfoCategory(sds2hmi_fi_tcl_e8_ActionInfoCategory& o_e8_ActionInfoCategory);
   virtual tVoid vVisit_e8_PhBook_Update_Action(sds2hmi_fi_tcl_e8_PhBook_Update_Action& o_e8_PhBook_Update_Action);
   virtual tVoid vVisit_e16_PHN_Relationship(sds2hmi_fi_tcl_e16_PHN_Relationship& o_e16_PHN_Relationship);
   virtual tVoid vVisit_e8_Common_SDS_Evnt(sds2hmi_fi_tcl_e8_Common_SDS_Evnt& o_e8_Common_SDS_Evnt);
   virtual tVoid vVisit_e8NDSPhoneticTranscriptionFormat(sds2hmi_fi_tcl_e8NDSPhoneticTranscriptionFormat& o_e8NDSPhoneticTranscriptionFormat);
   virtual tVoid vVisit_e8_NDS_SDN_Status(sds2hmi_fi_tcl_e8_NDS_SDN_Status& o_e8_NDS_SDN_Status);
   virtual tVoid vVisit_e8_Info_Menu_Srvc_Status(sds2hmi_fi_tcl_e8_Info_Menu_Srvc_Status& o_e8_Info_Menu_Srvc_Status);
   virtual tVoid vVisit_e8_EventForLogging(sds2hmi_fi_tcl_e8_EventForLogging& o_e8_EventForLogging);
   virtual tVoid vVisit_e8_Distance_Unit(sds2hmi_fi_tcl_e8_Distance_Unit& o_e8_Distance_Unit);
   virtual tVoid vVisit_e8_SharedDataAccess(sds2hmi_fi_tcl_e8_SharedDataAccess& o_e8_SharedDataAccess);
   virtual tVoid vVisit_e8_JournalingMode(sds2hmi_fi_tcl_e8_JournalingMode& o_e8_JournalingMode);
   virtual tVoid vVisit_e8_LockType(sds2hmi_fi_tcl_e8_LockType& o_e8_LockType);
   virtual tVoid vVisit_e8_NDSDataAccessType(sds2hmi_fi_tcl_e8_NDSDataAccessType& o_e8_NDSDataAccessType);
   virtual tVoid vVisit_e8_RegistrationAndDeRegistrationStatus(sds2hmi_fi_tcl_e8_RegistrationAndDeRegistrationStatus& o_e8_RegistrationAndDeRegistrationStatus);
   virtual tBool bDoExpand_PhoneEntry(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ContactData(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TmcEntry(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DeviceStatus(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TunerEntry(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Userword(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_LanguageAndSpeaker(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DeviceDatabase(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CON_AmbiguityResultEntry(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StringIDPair(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_MediaType(sds2hmi_fi_tcl_e8_MediaType& o_e8_MediaType);
   virtual tBool bDoExpand_TypedMediaID(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MediaIDString(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SDS_SettingsUnion(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SDS_SettingsRequest(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SDS_Settings(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NeighboringLocation(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SpecialAppAndStatus(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_HMIElementDescription(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Nav_IconSetting(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_HMIElementDescrptionList(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CoreSpeechParameter(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Action_AdditionalInfo(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RegionMetaData(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MetaData(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_BuildingBlock(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_UpdateRegion(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SDSProduct(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NDSLocationDetails(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Info_Menu_Srvice_Status(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RecResult(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ConfThresholdSet(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DestinationAndLanguageDetails(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SharedDataAccessAttributes(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DestinationElement(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DestinationItem(sds2hmi_sdsfi_tclSemanticDomain::tenType enSemantic);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   sds2hmi_fi_tclOutput* poOutput;
};


class MY_DECL sds2hmi_sdsfi_tclRandomInitVisitor : public sds2hmi_sdsfi_tclVisitorBase {
public:

   sds2hmi_sdsfi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(sds2hmi_fi_tclU8& oU8);
   virtual tVoid vVisitS8(sds2hmi_fi_tclS8& oS8);
   virtual tVoid vVisitU16(sds2hmi_fi_tclU16& oU16);
   virtual tVoid vVisitS16(sds2hmi_fi_tclS16& oS16);
   virtual tVoid vVisitU24(sds2hmi_fi_tclU24& oU24);
   virtual tVoid vVisitS24(sds2hmi_fi_tclS24& oS24);
   virtual tVoid vVisitU32(sds2hmi_fi_tclU32& oU32);
   virtual tVoid vVisitS32(sds2hmi_fi_tclS32& oS32);
   virtual tVoid vVisitU64(sds2hmi_fi_tclU64& oU64);
   virtual tVoid vVisitS64(sds2hmi_fi_tclS64& oS64);
   virtual tVoid vVisitBool(sds2hmi_fi_tclBool& oBool);
   virtual tVoid vVisitString(sds2hmi_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(sds2hmi_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(sds2hmi_fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_e8_BinContainerTypes(sds2hmi_fi_tcl_e8_BinContainerTypes& o_e8_BinContainerTypes);
   virtual tVoid vVisit_e16_ISO639_3_SDSLanguageCode(sds2hmi_fi_tcl_e16_ISO639_3_SDSLanguageCode& o_e16_ISO639_3_SDSLanguageCode);
   virtual tVoid vVisit_e8_Slot(sds2hmi_fi_tcl_e8_Slot& o_e8_Slot);
   virtual tVoid vVisit_e8_Domain(sds2hmi_fi_tcl_e8_Domain& o_e8_Domain);
   virtual tVoid vVisit_e8_ConnectedDeviceUpdateStatus(sds2hmi_fi_tcl_e8_ConnectedDeviceUpdateStatus& o_e8_ConnectedDeviceUpdateStatus);
   virtual tVoid vVisit_e8_WordType(sds2hmi_fi_tcl_e8_WordType& o_e8_WordType);
   virtual tVoid vVisit_e8_NDSFeatureType(sds2hmi_fi_tcl_e8_NDSFeatureType& o_e8_NDSFeatureType);
   virtual tVoid vVisit_e32_SSE_ASR_Mode(sds2hmi_fi_tcl_e32_SSE_ASR_Mode& o_e32_SSE_ASR_Mode);
   virtual tVoid vVisit_e8_SDSDestinationType(sds2hmi_fi_tcl_e8_SDSDestinationType& o_e8_SDSDestinationType);
   virtual tVoid vVisit_e16_ISOCountryCode(sds2hmi_fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_u16_IndexInReferenceList(sds2hmi_fi_tcl_u16_IndexInReferenceList& o_u16_IndexInReferenceList);
   virtual tVoid vVisit_s32_Meter(sds2hmi_fi_tcl_s32_Meter& o_s32_Meter);
   virtual tVoid vVisit_s16_CentimeterSecond(sds2hmi_fi_tcl_s16_CentimeterSecond& o_s16_CentimeterSecond);
   virtual tVoid vVisit_s32_Longitude(sds2hmi_fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(sds2hmi_fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tVoid vVisit_u8_DirectionAbsolute(sds2hmi_fi_tcl_u8_DirectionAbsolute& o_u8_DirectionAbsolute);
   virtual tVoid vVisit_e16_SelectionCriterionType(sds2hmi_fi_tcl_e16_SelectionCriterionType& o_e16_SelectionCriterionType);
   virtual tVoid vVisit_e8_LocationDescriptionDataType(sds2hmi_fi_tcl_e8_LocationDescriptionDataType& o_e8_LocationDescriptionDataType);
   virtual tVoid vVisit_b8_LocationDescriptorStatus(sds2hmi_fi_tcl_b8_LocationDescriptorStatus& o_b8_LocationDescriptorStatus);
   virtual tVoid vVisit_b8_PositionStatus(sds2hmi_fi_tcl_b8_PositionStatus& o_b8_PositionStatus);
   virtual tVoid vVisit_e8_LocationValueListType(sds2hmi_fi_tcl_e8_LocationValueListType& o_e8_LocationValueListType);
   virtual tVoid vVisit_b8_ListResultOptions(sds2hmi_fi_tcl_b8_ListResultOptions& o_b8_ListResultOptions);
   virtual tVoid vVisit_b16_ElementProperties(sds2hmi_fi_tcl_b16_ElementProperties& o_b16_ElementProperties);
   virtual tVoid vVisit_b8_ListSortOptions(sds2hmi_fi_tcl_b8_ListSortOptions& o_b8_ListSortOptions);
   virtual tVoid vVisit_b16_PositionReliability(sds2hmi_fi_tcl_b16_PositionReliability& o_b16_PositionReliability);
   virtual tVoid vVisit_e8_NavLocationDescType(sds2hmi_fi_tcl_e8_NavLocationDescType& o_e8_NavLocationDescType);
#ifndef FI_S_EXTERNAL_FI
#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_e8_NavIndexZFDestinationType(sds2hmi_fi_tcl_e8_NavIndexZFDestinationType& o_e8_NavIndexZFDestinationType);
   virtual tVoid vVisit_e8_NavLocationNavDataType(sds2hmi_fi_tcl_e8_NavLocationNavDataType& o_e8_NavLocationNavDataType);
   virtual tVoid vVisit_u32_DataSetId(sds2hmi_fi_tcl_u32_DataSetId& o_u32_DataSetId);
   virtual tVoid vVisit_e8_SideInfo(sds2hmi_fi_tcl_e8_SideInfo& o_e8_SideInfo);
   virtual tVoid vVisit_e8_NavOneCellDirection(sds2hmi_fi_tcl_e8_NavOneCellDirection& o_e8_NavOneCellDirection);
   virtual tVoid vVisit_e8_NavIntersectionType(sds2hmi_fi_tcl_e8_NavIntersectionType& o_e8_NavIntersectionType);
   virtual tVoid vVisit_s32_EMU(sds2hmi_fi_tcl_s32_EMU& o_s32_EMU);
   virtual tVoid vVisit_e8_Action(sds2hmi_fi_tcl_e8_Action& o_e8_Action);
   virtual tVoid vVisit_e8_Application(sds2hmi_fi_tcl_e8_Application& o_e8_Application);
   virtual tVoid vVisit_e8_PopUp_UpdateType(sds2hmi_fi_tcl_e8_PopUp_UpdateType& o_e8_PopUp_UpdateType);
   virtual tVoid vVisit_e8_PopUp_ListType(sds2hmi_fi_tcl_e8_PopUp_ListType& o_e8_PopUp_ListType);
   virtual tVoid vVisit_e8_GEN_SelectionType(sds2hmi_fi_tcl_e8_GEN_SelectionType& o_e8_GEN_SelectionType);
   virtual tVoid vVisit_e8_PlayAction(sds2hmi_fi_tcl_e8_PlayAction& o_e8_PlayAction);
   virtual tVoid vVisit_e8_TUN_SelectionType(sds2hmi_fi_tcl_e8_TUN_SelectionType& o_e8_TUN_SelectionType);
   virtual tVoid vVisit_e8_TUN_Status(sds2hmi_fi_tcl_e8_TUN_Status& o_e8_TUN_Status);
   virtual tVoid vVisit_e8_TUN_Band(sds2hmi_fi_tcl_e8_TUN_Band& o_e8_TUN_Band);
   virtual tVoid vVisit_e8_TUN_MemBank(sds2hmi_fi_tcl_e8_TUN_MemBank& o_e8_TUN_MemBank);
   virtual tVoid vVisit_e8_TUN_Setting(sds2hmi_fi_tcl_e8_TUN_Setting& o_e8_TUN_Setting);
   virtual tVoid vVisit_e8_GLOBAL_Status(sds2hmi_fi_tcl_e8_GLOBAL_Status& o_e8_GLOBAL_Status);
   virtual tVoid vVisit_e8_SMS_Status(sds2hmi_fi_tcl_e8_SMS_Status& o_e8_SMS_Status);
   virtual tVoid vVisit_e8_PHN_Status(sds2hmi_fi_tcl_e8_PHN_Status& o_e8_PHN_Status);
   virtual tVoid vVisit_e8_PHN_MenuType(sds2hmi_fi_tcl_e8_PHN_MenuType& o_e8_PHN_MenuType);
   virtual tVoid vVisit_e8_PHN_Setting(sds2hmi_fi_tcl_e8_PHN_Setting& o_e8_PHN_Setting);
   virtual tVoid vVisit_e8_PHN_ListType(sds2hmi_fi_tcl_e8_PHN_ListType& o_e8_PHN_ListType);
   virtual tVoid vVisit_e8_PHN_NumberType(sds2hmi_fi_tcl_e8_PHN_NumberType& o_e8_PHN_NumberType);
   virtual tVoid vVisit_e8_PHN_SelectionType(sds2hmi_fi_tcl_e8_PHN_SelectionType& o_e8_PHN_SelectionType);
   virtual tVoid vVisit_e8_PHN_Transorder(sds2hmi_fi_tcl_e8_PHN_Transorder& o_e8_PHN_Transorder);
   virtual tVoid vVisit_e8_NAV_Status(sds2hmi_fi_tcl_e8_NAV_Status& o_e8_NAV_Status);
   virtual tVoid vVisit_e8_NAV_MenuType(sds2hmi_fi_tcl_e8_NAV_MenuType& o_e8_NAV_MenuType);
   virtual tVoid vVisit_e8_NAV_RouteCriteria(sds2hmi_fi_tcl_e8_NAV_RouteCriteria& o_e8_NAV_RouteCriteria);
   virtual tVoid vVisit_e8_NAV_ZoomLevel(sds2hmi_fi_tcl_e8_NAV_ZoomLevel& o_e8_NAV_ZoomLevel);
   virtual tVoid vVisit_e8_NAV_ListType(sds2hmi_fi_tcl_e8_NAV_ListType& o_e8_NAV_ListType);
   virtual tVoid vVisit_e8_NAV_NavUnit(sds2hmi_fi_tcl_e8_NAV_NavUnit& o_e8_NAV_NavUnit);
   virtual tVoid vVisit_e8_NAV_VDEAvailInfo(sds2hmi_fi_tcl_e8_NAV_VDEAvailInfo& o_e8_NAV_VDEAvailInfo);
   virtual tVoid vVisit_e8_NAV_Setting(sds2hmi_fi_tcl_e8_NAV_Setting& o_e8_NAV_Setting);
   virtual tVoid vVisit_e8_NAV_MapMode(sds2hmi_fi_tcl_e8_NAV_MapMode& o_e8_NAV_MapMode);
   virtual tVoid vVisit_e8_NAV_AutoZoom(sds2hmi_fi_tcl_e8_NAV_AutoZoom& o_e8_NAV_AutoZoom);
   virtual tVoid vVisit_e8_NAV_MapView(sds2hmi_fi_tcl_e8_NAV_MapView& o_e8_NAV_MapView);
   virtual tVoid vVisit_e8_NAV_MapOrientation(sds2hmi_fi_tcl_e8_NAV_MapOrientation& o_e8_NAV_MapOrientation);
   virtual tVoid vVisit_e8_NAV_TBT_Symbols(sds2hmi_fi_tcl_e8_NAV_TBT_Symbols& o_e8_NAV_TBT_Symbols);
   virtual tVoid vVisit_e8_NAV_POIListType(sds2hmi_fi_tcl_e8_NAV_POIListType& o_e8_NAV_POIListType);
   virtual tVoid vVisit_e8_TMCListContent(sds2hmi_fi_tcl_e8_TMCListContent& o_e8_TMCListContent);
   virtual tVoid vVisit_b8_PopUp_ResultOptions(sds2hmi_fi_tcl_b8_PopUp_ResultOptions& o_b8_PopUp_ResultOptions);
   virtual tVoid vVisit_b16_AnsOptions(sds2hmi_fi_tcl_b16_AnsOptions& o_b16_AnsOptions);
   virtual tVoid vVisit_b8_StringPhonemeSearchSetting(sds2hmi_fi_tcl_b8_StringPhonemeSearchSetting& o_b8_StringPhonemeSearchSetting);
   virtual tVoid vVisit_e8_UPOI_Source(sds2hmi_fi_tcl_e8_UPOI_Source& o_e8_UPOI_Source);
   virtual tVoid vVisit_e8_Gender(sds2hmi_fi_tcl_e8_Gender& o_e8_Gender);
   virtual tVoid vVisit_e8_SDS_Status(sds2hmi_fi_tcl_e8_SDS_Status& o_e8_SDS_Status);
   virtual tVoid vVisit_e8_DeviceStatus(sds2hmi_fi_tcl_e8_DeviceStatus& o_e8_DeviceStatus);
   virtual tVoid vVisit_e8_MPL_ListType(sds2hmi_fi_tcl_e8_MPL_ListType& o_e8_MPL_ListType);
   virtual tVoid vVisit_e8_MPL_MenuType(sds2hmi_fi_tcl_e8_MPL_MenuType& o_e8_MPL_MenuType);
   virtual tVoid vVisit_e8_MPL_SourceType(sds2hmi_fi_tcl_e8_MPL_SourceType& o_e8_MPL_SourceType);
   virtual tVoid vVisit_e8_MPL_Status(sds2hmi_fi_tcl_e8_MPL_Status& o_e8_MPL_Status);
   virtual tVoid vVisit_e8_WEA_MenuType(sds2hmi_fi_tcl_e8_WEA_MenuType& o_e8_WEA_MenuType);
   virtual tVoid vVisit_e8_WEA_Status(sds2hmi_fi_tcl_e8_WEA_Status& o_e8_WEA_Status);
   virtual tVoid vVisit_e8_NAV_LocationType(sds2hmi_fi_tcl_e8_NAV_LocationType& o_e8_NAV_LocationType);
   virtual tVoid vVisit_e8_CON_AmbiguityListType(sds2hmi_fi_tcl_e8_CON_AmbiguityListType& o_e8_CON_AmbiguityListType);
   virtual tVoid vVisit_e8_CON_EntryType(sds2hmi_fi_tcl_e8_CON_EntryType& o_e8_CON_EntryType);
   virtual tVoid vVisit_e8_LOG_ConfidenceThreshold(sds2hmi_fi_tcl_e8_LOG_ConfidenceThreshold& o_e8_LOG_ConfidenceThreshold);
   virtual tVoid vVisit_e8_ParameterAction(sds2hmi_fi_tcl_e8_ParameterAction& o_e8_ParameterAction);
   virtual tVoid vVisit_e8_SDS_ParameterType(sds2hmi_fi_tcl_e8_SDS_ParameterType& o_e8_SDS_ParameterType);
   virtual tVoid vVisit_e8_SDSSettings(sds2hmi_fi_tcl_e8_SDSSettings& o_e8_SDSSettings);
   virtual tVoid vVisit_e8_SettingsError(sds2hmi_fi_tcl_e8_SettingsError& o_e8_SettingsError);
   virtual tVoid vVisit_e8_HMI_ListType(sds2hmi_fi_tcl_e8_HMI_ListType& o_e8_HMI_ListType);
   virtual tVoid vVisit_e8_HMI_ListSize(sds2hmi_fi_tcl_e8_HMI_ListSize& o_e8_HMI_ListSize);
   virtual tVoid vVisit_e8_Info_Menu(sds2hmi_fi_tcl_e8_Info_Menu& o_e8_Info_Menu);
   virtual tVoid vVisit_e8_Info_SXM_Services(sds2hmi_fi_tcl_e8_Info_SXM_Services& o_e8_Info_SXM_Services);
   virtual tVoid vVisit_e8_SpecialAppId(sds2hmi_fi_tcl_e8_SpecialAppId& o_e8_SpecialAppId);
   virtual tVoid vVisit_e8_SpecialAppStatus(sds2hmi_fi_tcl_e8_SpecialAppStatus& o_e8_SpecialAppStatus);
   virtual tVoid vVisit_e8_HMIElementDescriptorMode(sds2hmi_fi_tcl_e8_HMIElementDescriptorMode& o_e8_HMIElementDescriptorMode);
   virtual tVoid vVisit_e8_NAV_ZoomAction(sds2hmi_fi_tcl_e8_NAV_ZoomAction& o_e8_NAV_ZoomAction);
   virtual tVoid vVisit_e8_NAV_IconDisplayAction(sds2hmi_fi_tcl_e8_NAV_IconDisplayAction& o_e8_NAV_IconDisplayAction);
   virtual tVoid vVisit_e8_MainDomains(sds2hmi_fi_tcl_e8_MainDomains& o_e8_MainDomains);
   virtual tVoid vVisit_e8_HMIElementReference(sds2hmi_fi_tcl_e8_HMIElementReference& o_e8_HMIElementReference);
   virtual tVoid vVisit_e8_CoreSpeechParameters(sds2hmi_fi_tcl_e8_CoreSpeechParameters& o_e8_CoreSpeechParameters);
   virtual tVoid vVisit_e8_ActionInfoCategory(sds2hmi_fi_tcl_e8_ActionInfoCategory& o_e8_ActionInfoCategory);
   virtual tVoid vVisit_e8_PhBook_Update_Action(sds2hmi_fi_tcl_e8_PhBook_Update_Action& o_e8_PhBook_Update_Action);
   virtual tVoid vVisit_e16_PHN_Relationship(sds2hmi_fi_tcl_e16_PHN_Relationship& o_e16_PHN_Relationship);
   virtual tVoid vVisit_e8_Common_SDS_Evnt(sds2hmi_fi_tcl_e8_Common_SDS_Evnt& o_e8_Common_SDS_Evnt);
   virtual tVoid vVisit_e8NDSPhoneticTranscriptionFormat(sds2hmi_fi_tcl_e8NDSPhoneticTranscriptionFormat& o_e8NDSPhoneticTranscriptionFormat);
   virtual tVoid vVisit_e8_NDS_SDN_Status(sds2hmi_fi_tcl_e8_NDS_SDN_Status& o_e8_NDS_SDN_Status);
   virtual tVoid vVisit_e8_Info_Menu_Srvc_Status(sds2hmi_fi_tcl_e8_Info_Menu_Srvc_Status& o_e8_Info_Menu_Srvc_Status);
   virtual tVoid vVisit_e8_EventForLogging(sds2hmi_fi_tcl_e8_EventForLogging& o_e8_EventForLogging);
   virtual tVoid vVisit_e8_Distance_Unit(sds2hmi_fi_tcl_e8_Distance_Unit& o_e8_Distance_Unit);
   virtual tVoid vVisit_e8_SharedDataAccess(sds2hmi_fi_tcl_e8_SharedDataAccess& o_e8_SharedDataAccess);
   virtual tVoid vVisit_e8_JournalingMode(sds2hmi_fi_tcl_e8_JournalingMode& o_e8_JournalingMode);
   virtual tVoid vVisit_e8_LockType(sds2hmi_fi_tcl_e8_LockType& o_e8_LockType);
   virtual tVoid vVisit_e8_NDSDataAccessType(sds2hmi_fi_tcl_e8_NDSDataAccessType& o_e8_NDSDataAccessType);
   virtual tVoid vVisit_e8_RegistrationAndDeRegistrationStatus(sds2hmi_fi_tcl_e8_RegistrationAndDeRegistrationStatus& o_e8_RegistrationAndDeRegistrationStatus);
   virtual tVoid vVisit_e8_MediaType(sds2hmi_fi_tcl_e8_MediaType& o_e8_MediaType);
	tU32 u32ListSize;
};

#endif
