/************************************************************************
 
 *FILE:           alltypes.cpp
 
 *SW-COMPONENT:   FI Functional Interface
 
 *DESCRIPTION:    Interface fuer alle Typdefinitionen
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#if !defined(FI_S_NO_STRING_ACCESS_METHODS) || !defined(FI_S_UTFMODE_TRANSPARENT)
   #define UTFUTIL_S_IMPORT_INTERFACE_GENERIC
   #include "utf_if.h"
#endif

#define RVC_FI_S_IMPORT_INTERFACE_FI_TYPES
#include "rvc_fi_if.h"
// -----------------------------------------------------------------------------

fi_tclOutContext& rvc_fi_tclU8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u8Value);
  return oOut;
}

fi_tclInContext& rvc_fi_tclU8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u8Value);
  return oIn;
}

tU32 rvc_fi_tclU8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& rvc_fi_tclS8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s8Value);
  return oOut;
}

fi_tclInContext& rvc_fi_tclS8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s8Value);
  return oIn;
}

tU32 rvc_fi_tclS8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& rvc_fi_tclU16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u16Value);
  return oOut;
}

fi_tclInContext& rvc_fi_tclU16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u16Value);
  return oIn;
}

tU32 rvc_fi_tclU16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& rvc_fi_tclS16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s16Value);
  return oOut;
}

fi_tclInContext& rvc_fi_tclS16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s16Value);
  return oIn;
}

tU32 rvc_fi_tclS16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& rvc_fi_tclU24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u24Value);
  return oOut;
}

fi_tclInContext& rvc_fi_tclU24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u24Value);
  return oIn;
}

tU32 rvc_fi_tclU24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& rvc_fi_tclS24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s24Value);
  return oOut;
}

fi_tclInContext& rvc_fi_tclS24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s24Value);
  return oIn;
}

tU32 rvc_fi_tclS24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& rvc_fi_tclU32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u32Value);
  return oOut;
}

fi_tclInContext& rvc_fi_tclU32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u32Value);
  return oIn;
}

tU32 rvc_fi_tclU32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& rvc_fi_tclU64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u64Value);
  return oOut;
}

fi_tclInContext& rvc_fi_tclU64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u64Value);
  return oIn;
}

tU32 rvc_fi_tclU64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& rvc_fi_tclS32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s32Value);
  return oOut;
}

fi_tclInContext& rvc_fi_tclS32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s32Value);
  return oIn;
}

tU32 rvc_fi_tclS32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& rvc_fi_tclS64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s64Value);
  return oOut;
}

fi_tclInContext& rvc_fi_tclS64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s64Value);
  return oIn;
}

tU32 rvc_fi_tclS64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& rvc_fi_tclF32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f32Value);
  return oOut;
}

fi_tclInContext& rvc_fi_tclF32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f32Value);
  return oIn;
}

tU32 rvc_fi_tclF32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& rvc_fi_tclF64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f64Value);
  return oOut;
}

fi_tclInContext& rvc_fi_tclF64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f64Value);
  return oIn;
}

tU32 rvc_fi_tclF64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& rvc_fi_tclBool::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(bValue);
  return oOut;
}

fi_tclInContext& rvc_fi_tclBool::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(bValue);
  return oIn;
}

tU32 rvc_fi_tclBool::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& rvc_fi_tclString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid rvc_fi_tclString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_fi_tclString::~rvc_fi_tclString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

rvc_fi_tclString& rvc_fi_tclString::operator=(const rvc_fi_tclString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

rvc_fi_tclString::rvc_fi_tclString(const rvc_fi_tclString& coRef):rvc_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& rvc_fi_tclString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool rvc_fi_tclString::operator==(const rvc_fi_tclString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 rvc_fi_tclString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
rvc_fi_tclString& rvc_fi_tclString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclString::fi_tclString(const tString& coszString) // ADDED (changed from const tString to const tString&)
rvc_fi_tclString::rvc_fi_tclString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool rvc_fi_tclString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

rvc_fi_tclString::operator tString&() // ADDED
{
   return szValue;
}

rvc_fi_tclString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool rvc_fi_tclString::operator!=(intptr_t iNULL) const // ADDED
{
   return szValue != (char*)iNULL;
}

static tChar rvc_FI_C_U8_NULLCHAR = '\0';

tChar* rvc_fi_tclString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* rvc_fi_tclString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* rvc_fi_tclString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& rvc_fi_tclString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return rvc_FI_C_U8_NULLCHAR;
}

tChar& rvc_fi_tclString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return rvc_FI_C_U8_NULLCHAR;
}

tChar& rvc_fi_tclString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return rvc_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool rvc_fi_tclString::bSet(const rvc_fi_tclString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool rvc_fi_tclString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
case FI_EN_ISO8859_1M :
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = util_u32ConvertISO8859_1Mod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            util_u32ConvertISO8859_1Mod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
   return bSuccess;
}

tString rvc_fi_tclString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

// -----------------------------------------------------------------------------

fi_tclOutContext& rvc_fi_tclList::oWrite(fi_tclOutContext& oOut) const 
{
   // --Schreibe die Listenlaenge in den Kontext
   (tVoid) oOut.oWrite(u32ListSize);
   return oOut;
}

fi_tclInContext& rvc_fi_tclList::oRead(fi_tclInContext& oIn) 
{
  // --Lese die Listenlaenge aus dem Kontext
  (tVoid) oIn.oRead(u32ListSize);
  return oIn;
}

tBool rvc_fi_tclList::operator==(const rvc_fi_tclList& roRef) const
{
   return roRef.u32ListSize == u32ListSize;
}

tU32 rvc_fi_tclList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& rvc_fi_tclMultiLanguageString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid rvc_fi_tclMultiLanguageString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_fi_tclMultiLanguageString::~rvc_fi_tclMultiLanguageString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

rvc_fi_tclMultiLanguageString& rvc_fi_tclMultiLanguageString::operator=(const rvc_fi_tclMultiLanguageString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

rvc_fi_tclMultiLanguageString::rvc_fi_tclMultiLanguageString(const rvc_fi_tclMultiLanguageString& coRef):rvc_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& rvc_fi_tclMultiLanguageString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool rvc_fi_tclMultiLanguageString::operator==(const rvc_fi_tclMultiLanguageString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 rvc_fi_tclMultiLanguageString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
rvc_fi_tclMultiLanguageString& rvc_fi_tclMultiLanguageString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclMultiLanguageString::fi_tclMultiLanguageString(const tString& coszString) // ADDED (changed from const tString to const tString&)
rvc_fi_tclMultiLanguageString::rvc_fi_tclMultiLanguageString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool rvc_fi_tclMultiLanguageString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

rvc_fi_tclMultiLanguageString::operator tString&() // ADDED
{
   return szValue;
}

rvc_fi_tclMultiLanguageString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool rvc_fi_tclMultiLanguageString::operator!=(intptr_t iNULL) const// ADDED
{
   return szValue != (char*)iNULL;
}

tChar* rvc_fi_tclMultiLanguageString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* rvc_fi_tclMultiLanguageString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* rvc_fi_tclMultiLanguageString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& rvc_fi_tclMultiLanguageString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return rvc_FI_C_U8_NULLCHAR;
}

tChar& rvc_fi_tclMultiLanguageString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return rvc_FI_C_U8_NULLCHAR;
}

tChar& rvc_fi_tclMultiLanguageString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return rvc_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool rvc_fi_tclMultiLanguageString::bSet(const rvc_fi_tclMultiLanguageString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclMultiLanguageString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool rvc_fi_tclMultiLanguageString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }

   return bSuccess;
}

tString rvc_fi_tclMultiLanguageString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_fi_tcl_BinContainer::rvc_fi_tcl_BinContainer(const rvc_fi_tcl_BinContainer& coRef)
   : rvc_fi_tclVisitableTypeBase(coRef)
{
   ContainerDataList = coRef.ContainerDataList;
}
rvc_fi_tcl_BinContainer& rvc_fi_tcl_BinContainer::operator=(const rvc_fi_tcl_BinContainer& coRef)
{
   if (this == &coRef) return *this;
   ContainerDataList = coRef.ContainerDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid rvc_fi_tcl_BinContainer::vDestroy()
{
   {
   ContainerDataList.clear();
   }
}

rvc_fi_tcl_BinContainer::rvc_fi_tcl_BinContainer()

 {}

tS32 rvc_fi_tcl_BinContainer::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_BINCONTAINER;
}


rvc_fi_tcl_BinContainer::~rvc_fi_tcl_BinContainer()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 rvc_fi_tcl_BinContainer::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ContainerDataList.size()*1);
}

fi_tclInContext& rvc_fi_tcl_BinContainer::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ContainerDataList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ContainerDataList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_BinContainer::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ContainerDataList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ContainerDataList.size(); ++u32Idx)
         (tVoid) (oOut << ContainerDataList[u32Idx]);
   }
   return oOut;
}

tBool rvc_fi_tcl_BinContainer::operator==(const rvc_fi_tcl_BinContainer& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ContainerDataList.size() == roRef.ContainerDataList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ContainerDataList.size()); ++u32Idx)
            bResult = bResult && (ContainerDataList[u32Idx] == roRef.ContainerDataList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

rvc_fi_tcl_Reserved::rvc_fi_tcl_Reserved()
 {}

tS32 rvc_fi_tcl_Reserved::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_RESERVED;
}


rvc_fi_tcl_Reserved::~rvc_fi_tcl_Reserved()
{}

tU32 rvc_fi_tcl_Reserved::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

fi_tclInContext& rvc_fi_tcl_Reserved::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_Reserved::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_u8_Percent::rvc_fi_tcl_u8_Percent(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 rvc_fi_tcl_u8_Percent::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_U8_PERCENT;
}


rvc_fi_tcl_u8_Percent::~rvc_fi_tcl_u8_Percent()
{}

tU32 rvc_fi_tcl_u8_Percent::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_u8_Percent::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& rvc_fi_tcl_u8_Percent::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_s16_PerThousand::rvc_fi_tcl_s16_PerThousand(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 rvc_fi_tcl_s16_PerThousand::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_S16_PERTHOUSAND;
}


rvc_fi_tcl_s16_PerThousand::~rvc_fi_tcl_s16_PerThousand()
{}

tU32 rvc_fi_tcl_s16_PerThousand::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_fi_tcl_s16_PerThousand::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& rvc_fi_tcl_s16_PerThousand::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_u16_IndexInReferenceList::rvc_fi_tcl_u16_IndexInReferenceList(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 rvc_fi_tcl_u16_IndexInReferenceList::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_U16_INDEXINREFERENCELIST;
}


rvc_fi_tcl_u16_IndexInReferenceList::~rvc_fi_tcl_u16_IndexInReferenceList()
{}

tU32 rvc_fi_tcl_u16_IndexInReferenceList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_fi_tcl_u16_IndexInReferenceList::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& rvc_fi_tcl_u16_IndexInReferenceList::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_u16_ErrorCode::rvc_fi_tcl_u16_ErrorCode(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 rvc_fi_tcl_u16_ErrorCode::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_U16_ERRORCODE;
}


rvc_fi_tcl_u16_ErrorCode::~rvc_fi_tcl_u16_ErrorCode()
{}

tU32 rvc_fi_tcl_u16_ErrorCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_fi_tcl_u16_ErrorCode::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& rvc_fi_tcl_u16_ErrorCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_u16_RPM::rvc_fi_tcl_u16_RPM(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 rvc_fi_tcl_u16_RPM::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_U16_RPM;
}


rvc_fi_tcl_u16_RPM::~rvc_fi_tcl_u16_RPM()
{}

tU32 rvc_fi_tcl_u16_RPM::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_fi_tcl_u16_RPM::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& rvc_fi_tcl_u16_RPM::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_s32_Kilogram::rvc_fi_tcl_s32_Kilogram(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 rvc_fi_tcl_s32_Kilogram::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_S32_KILOGRAM;
}


rvc_fi_tcl_s32_Kilogram::~rvc_fi_tcl_s32_Kilogram()
{}

tU32 rvc_fi_tcl_s32_Kilogram::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& rvc_fi_tcl_s32_Kilogram::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& rvc_fi_tcl_s32_Kilogram::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_s32_Pound::rvc_fi_tcl_s32_Pound(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 rvc_fi_tcl_s32_Pound::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_S32_POUND;
}


rvc_fi_tcl_s32_Pound::~rvc_fi_tcl_s32_Pound()
{}

tU32 rvc_fi_tcl_s32_Pound::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& rvc_fi_tcl_s32_Pound::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& rvc_fi_tcl_s32_Pound::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_s16_Meter::rvc_fi_tcl_s16_Meter(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 rvc_fi_tcl_s16_Meter::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_S16_METER;
}


rvc_fi_tcl_s16_Meter::~rvc_fi_tcl_s16_Meter()
{}

tU32 rvc_fi_tcl_s16_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_fi_tcl_s16_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& rvc_fi_tcl_s16_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_s32_Meter::rvc_fi_tcl_s32_Meter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 rvc_fi_tcl_s32_Meter::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_S32_METER;
}


rvc_fi_tcl_s32_Meter::~rvc_fi_tcl_s32_Meter()
{}

tU32 rvc_fi_tcl_s32_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& rvc_fi_tcl_s32_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& rvc_fi_tcl_s32_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_s32_Yards::rvc_fi_tcl_s32_Yards(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 rvc_fi_tcl_s32_Yards::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_S32_YARDS;
}


rvc_fi_tcl_s32_Yards::~rvc_fi_tcl_s32_Yards()
{}

tU32 rvc_fi_tcl_s32_Yards::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& rvc_fi_tcl_s32_Yards::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& rvc_fi_tcl_s32_Yards::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_s32_Foot::rvc_fi_tcl_s32_Foot(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 rvc_fi_tcl_s32_Foot::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_S32_FOOT;
}


rvc_fi_tcl_s32_Foot::~rvc_fi_tcl_s32_Foot()
{}

tU32 rvc_fi_tcl_s32_Foot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& rvc_fi_tcl_s32_Foot::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& rvc_fi_tcl_s32_Foot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_s32_Centimeter::rvc_fi_tcl_s32_Centimeter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 rvc_fi_tcl_s32_Centimeter::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_S32_CENTIMETER;
}


rvc_fi_tcl_s32_Centimeter::~rvc_fi_tcl_s32_Centimeter()
{}

tU32 rvc_fi_tcl_s32_Centimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& rvc_fi_tcl_s32_Centimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& rvc_fi_tcl_s32_Centimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_s32_Inch::rvc_fi_tcl_s32_Inch(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 rvc_fi_tcl_s32_Inch::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_S32_INCH;
}


rvc_fi_tcl_s32_Inch::~rvc_fi_tcl_s32_Inch()
{}

tU32 rvc_fi_tcl_s32_Inch::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& rvc_fi_tcl_s32_Inch::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& rvc_fi_tcl_s32_Inch::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_s32_Millimeter::rvc_fi_tcl_s32_Millimeter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 rvc_fi_tcl_s32_Millimeter::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_S32_MILLIMETER;
}


rvc_fi_tcl_s32_Millimeter::~rvc_fi_tcl_s32_Millimeter()
{}

tU32 rvc_fi_tcl_s32_Millimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& rvc_fi_tcl_s32_Millimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& rvc_fi_tcl_s32_Millimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_s32_Microliter::rvc_fi_tcl_s32_Microliter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 rvc_fi_tcl_s32_Microliter::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_S32_MICROLITER;
}


rvc_fi_tcl_s32_Microliter::~rvc_fi_tcl_s32_Microliter()
{}

tU32 rvc_fi_tcl_s32_Microliter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& rvc_fi_tcl_s32_Microliter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& rvc_fi_tcl_s32_Microliter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_s32_Second::rvc_fi_tcl_s32_Second(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 rvc_fi_tcl_s32_Second::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_S32_SECOND;
}


rvc_fi_tcl_s32_Second::~rvc_fi_tcl_s32_Second()
{}

tU32 rvc_fi_tcl_s32_Second::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& rvc_fi_tcl_s32_Second::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& rvc_fi_tcl_s32_Second::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_u16_MilliSecond::rvc_fi_tcl_u16_MilliSecond(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 rvc_fi_tcl_u16_MilliSecond::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_U16_MILLISECOND;
}


rvc_fi_tcl_u16_MilliSecond::~rvc_fi_tcl_u16_MilliSecond()
{}

tU32 rvc_fi_tcl_u16_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_fi_tcl_u16_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& rvc_fi_tcl_u16_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_s32_MilliSecond::rvc_fi_tcl_s32_MilliSecond(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 rvc_fi_tcl_s32_MilliSecond::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_S32_MILLISECOND;
}


rvc_fi_tcl_s32_MilliSecond::~rvc_fi_tcl_s32_MilliSecond()
{}

tU32 rvc_fi_tcl_s32_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& rvc_fi_tcl_s32_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& rvc_fi_tcl_s32_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_fi_tcl_POSIXTime::rvc_fi_tcl_POSIXTime(const rvc_fi_tcl_POSIXTime& coRef)
   : rvc_fi_tclVisitableTypeBase(coRef)
{
   Time = coRef.Time;
}
rvc_fi_tcl_POSIXTime& rvc_fi_tcl_POSIXTime::operator=(const rvc_fi_tcl_POSIXTime& coRef)
{
   if (this == &coRef) return *this;
   Time = coRef.Time;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_POSIXTime::rvc_fi_tcl_POSIXTime()
:Time(0)
 {}

tS32 rvc_fi_tcl_POSIXTime::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_POSIXTIME;
}


rvc_fi_tcl_POSIXTime::~rvc_fi_tcl_POSIXTime()
{}

tU32 rvc_fi_tcl_POSIXTime::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& rvc_fi_tcl_POSIXTime::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Time);
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_POSIXTime::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Time);
   return oOut;
}

tBool rvc_fi_tcl_POSIXTime::operator==(const rvc_fi_tcl_POSIXTime& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Time == roRef.Time);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_DST_State::rvc_fi_tcl_e8_DST_State():enType(FI_EN_T_STANDARDTIME) {}

tS32 rvc_fi_tcl_e8_DST_State::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_DST_STATE;
}


rvc_fi_tcl_e8_DST_State::~rvc_fi_tcl_e8_DST_State()
{}

tU32 rvc_fi_tcl_e8_DST_State::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_DST_State::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_DST_State::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_fi_tcl_TimeZoneElement::rvc_fi_tcl_TimeZoneElement(const rvc_fi_tcl_TimeZoneElement& coRef)
   : rvc_fi_tclVisitableTypeBase(coRef)
{
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
}
rvc_fi_tcl_TimeZoneElement& rvc_fi_tcl_TimeZoneElement::operator=(const rvc_fi_tcl_TimeZoneElement& coRef)
{
   if (this == &coRef) return *this;
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid rvc_fi_tcl_TimeZoneElement::vDestroy()
{
   Abbreviation_StandardTime.vDestroy();
   Abbreviation_DST_in_effect.vDestroy();
   {
   DST_TimeDomain.clear();
   }
}

rvc_fi_tcl_TimeZoneElement::rvc_fi_tcl_TimeZoneElement()
:Abbreviation_StandardTime(0)
,Abbreviation_DST_in_effect(0)
,TimeZoneDifference()
,DST_State()
,DSTDifference()

 {}

tS32 rvc_fi_tcl_TimeZoneElement::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_TIMEZONEELEMENT;
}


rvc_fi_tcl_TimeZoneElement::~rvc_fi_tcl_TimeZoneElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 rvc_fi_tcl_TimeZoneElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 13+Abbreviation_StandardTime.u32GetSize(u16MajorVersion)+Abbreviation_DST_in_effect.u32GetSize(u16MajorVersion)+ static_cast<tU32>(DST_TimeDomain.size()*1);
}

fi_tclInContext& rvc_fi_tcl_TimeZoneElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Abbreviation_StandardTime);
   (tVoid) (oIn >> Abbreviation_DST_in_effect);
   (tVoid) (oIn >> TimeZoneDifference);
   (tVoid) (oIn >> DST_State);
   (tVoid) (oIn >> DSTDifference);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      DST_TimeDomain.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DST_TimeDomain[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_TimeZoneElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Abbreviation_StandardTime);
   (tVoid) (oOut << Abbreviation_DST_in_effect);
   (tVoid) (oOut << TimeZoneDifference);
   (tVoid) (oOut << DST_State);
   (tVoid) (oOut << DSTDifference);
   (tVoid) (oOut << (tU32)DST_TimeDomain.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DST_TimeDomain.size(); ++u32Idx)
         (tVoid) (oOut << DST_TimeDomain[u32Idx]);
   }
   return oOut;
}

tBool rvc_fi_tcl_TimeZoneElement::operator==(const rvc_fi_tcl_TimeZoneElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Abbreviation_StandardTime == roRef.Abbreviation_StandardTime);
   bResult = bResult && (Abbreviation_DST_in_effect == roRef.Abbreviation_DST_in_effect);
   bResult = bResult && (TimeZoneDifference == roRef.TimeZoneDifference);
   bResult = bResult && (DST_State == roRef.DST_State);
   bResult = bResult && (DSTDifference == roRef.DSTDifference);
      bResult = bResult && (DST_TimeDomain.size() == roRef.DST_TimeDomain.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DST_TimeDomain.size()); ++u32Idx)
            bResult = bResult && (DST_TimeDomain[u32Idx] == roRef.DST_TimeDomain[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_s16_KmPerHour::rvc_fi_tcl_s16_KmPerHour(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 rvc_fi_tcl_s16_KmPerHour::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_S16_KMPERHOUR;
}


rvc_fi_tcl_s16_KmPerHour::~rvc_fi_tcl_s16_KmPerHour()
{}

tU32 rvc_fi_tcl_s16_KmPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_fi_tcl_s16_KmPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& rvc_fi_tcl_s16_KmPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_s16_MilesPerHour::rvc_fi_tcl_s16_MilesPerHour(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 rvc_fi_tcl_s16_MilesPerHour::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_S16_MILESPERHOUR;
}


rvc_fi_tcl_s16_MilesPerHour::~rvc_fi_tcl_s16_MilesPerHour()
{}

tU32 rvc_fi_tcl_s16_MilesPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_fi_tcl_s16_MilesPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& rvc_fi_tcl_s16_MilesPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_s16_Knot::rvc_fi_tcl_s16_Knot(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 rvc_fi_tcl_s16_Knot::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_S16_KNOT;
}


rvc_fi_tcl_s16_Knot::~rvc_fi_tcl_s16_Knot()
{}

tU32 rvc_fi_tcl_s16_Knot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_fi_tcl_s16_Knot::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& rvc_fi_tcl_s16_Knot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_s16_CentimeterSecond::rvc_fi_tcl_s16_CentimeterSecond(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 rvc_fi_tcl_s16_CentimeterSecond::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_S16_CENTIMETERSECOND;
}


rvc_fi_tcl_s16_CentimeterSecond::~rvc_fi_tcl_s16_CentimeterSecond()
{}

tU32 rvc_fi_tcl_s16_CentimeterSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_fi_tcl_s16_CentimeterSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& rvc_fi_tcl_s16_CentimeterSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_s16_Kelvin::rvc_fi_tcl_s16_Kelvin(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 rvc_fi_tcl_s16_Kelvin::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_S16_KELVIN;
}


rvc_fi_tcl_s16_Kelvin::~rvc_fi_tcl_s16_Kelvin()
{}

tU32 rvc_fi_tcl_s16_Kelvin::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_fi_tcl_s16_Kelvin::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& rvc_fi_tcl_s16_Kelvin::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_s16_Fahrenheit::rvc_fi_tcl_s16_Fahrenheit(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 rvc_fi_tcl_s16_Fahrenheit::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_S16_FAHRENHEIT;
}


rvc_fi_tcl_s16_Fahrenheit::~rvc_fi_tcl_s16_Fahrenheit()
{}

tU32 rvc_fi_tcl_s16_Fahrenheit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_fi_tcl_s16_Fahrenheit::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& rvc_fi_tcl_s16_Fahrenheit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_s32_Pascal::rvc_fi_tcl_s32_Pascal(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 rvc_fi_tcl_s32_Pascal::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_S32_PASCAL;
}


rvc_fi_tcl_s32_Pascal::~rvc_fi_tcl_s32_Pascal()
{}

tU32 rvc_fi_tcl_s32_Pascal::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& rvc_fi_tcl_s32_Pascal::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& rvc_fi_tcl_s32_Pascal::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_s32_Watt::rvc_fi_tcl_s32_Watt(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 rvc_fi_tcl_s32_Watt::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_S32_WATT;
}


rvc_fi_tcl_s32_Watt::~rvc_fi_tcl_s32_Watt()
{}

tU32 rvc_fi_tcl_s32_Watt::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& rvc_fi_tcl_s32_Watt::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& rvc_fi_tcl_s32_Watt::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_fi_tcl_FIVersion::rvc_fi_tcl_FIVersion(const rvc_fi_tcl_FIVersion& coRef)
   : rvc_fi_tclVisitableTypeBase(coRef)
{
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
}
rvc_fi_tcl_FIVersion& rvc_fi_tcl_FIVersion::operator=(const rvc_fi_tcl_FIVersion& coRef)
{
   if (this == &coRef) return *this;
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_FIVersion::rvc_fi_tcl_FIVersion()
:MajorVersion(0)
,MinorVersion(0)
,PatchVersion(0)
 {}

tS32 rvc_fi_tcl_FIVersion::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_FIVERSION;
}


rvc_fi_tcl_FIVersion::~rvc_fi_tcl_FIVersion()
{}

tU32 rvc_fi_tcl_FIVersion::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& rvc_fi_tcl_FIVersion::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MajorVersion);
   (tVoid) (oIn >> MinorVersion);
   (tVoid) (oIn >> PatchVersion);
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_FIVersion::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MajorVersion);
   (tVoid) (oOut << MinorVersion);
   (tVoid) (oOut << PatchVersion);
   return oOut;
}

tBool rvc_fi_tcl_FIVersion::operator==(const rvc_fi_tcl_FIVersion& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MajorVersion == roRef.MajorVersion);
   bResult = bResult && (MinorVersion == roRef.MinorVersion);
   bResult = bResult && (PatchVersion == roRef.PatchVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_s32_Longitude::rvc_fi_tcl_s32_Longitude(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 rvc_fi_tcl_s32_Longitude::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_S32_LONGITUDE;
}


rvc_fi_tcl_s32_Longitude::~rvc_fi_tcl_s32_Longitude()
{}

tU32 rvc_fi_tcl_s32_Longitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& rvc_fi_tcl_s32_Longitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& rvc_fi_tcl_s32_Longitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_s32_Latitude::rvc_fi_tcl_s32_Latitude(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 rvc_fi_tcl_s32_Latitude::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_S32_LATITUDE;
}


rvc_fi_tcl_s32_Latitude::~rvc_fi_tcl_s32_Latitude()
{}

tU32 rvc_fi_tcl_s32_Latitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& rvc_fi_tcl_s32_Latitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& rvc_fi_tcl_s32_Latitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_fi_tcl_PositionWGS84::rvc_fi_tcl_PositionWGS84(const rvc_fi_tcl_PositionWGS84& coRef)
   : rvc_fi_tclVisitableTypeBase(coRef)
{
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
}
rvc_fi_tcl_PositionWGS84& rvc_fi_tcl_PositionWGS84::operator=(const rvc_fi_tcl_PositionWGS84& coRef)
{
   if (this == &coRef) return *this;
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_PositionWGS84::rvc_fi_tcl_PositionWGS84()
:Longitude()
,Latitude()
 {}

tS32 rvc_fi_tcl_PositionWGS84::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_POSITIONWGS84;
}


rvc_fi_tcl_PositionWGS84::~rvc_fi_tcl_PositionWGS84()
{}

tU32 rvc_fi_tcl_PositionWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& rvc_fi_tcl_PositionWGS84::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Longitude);
   (tVoid) (oIn >> Latitude);
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_PositionWGS84::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Longitude);
   (tVoid) (oOut << Latitude);
   return oOut;
}

tBool rvc_fi_tcl_PositionWGS84::operator==(const rvc_fi_tcl_PositionWGS84& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Longitude == roRef.Longitude);
   bResult = bResult && (Latitude == roRef.Latitude);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_fi_tcl_RectangleWGS84::rvc_fi_tcl_RectangleWGS84(const rvc_fi_tcl_RectangleWGS84& coRef)
   : rvc_fi_tclVisitableTypeBase(coRef)
{
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
}
rvc_fi_tcl_RectangleWGS84& rvc_fi_tcl_RectangleWGS84::operator=(const rvc_fi_tcl_RectangleWGS84& coRef)
{
   if (this == &coRef) return *this;
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_RectangleWGS84::rvc_fi_tcl_RectangleWGS84()
:LongitudeMin()
,LatitudeMin()
,LongitudeMax()
,LatitudeMax()
 {}

tS32 rvc_fi_tcl_RectangleWGS84::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_RECTANGLEWGS84;
}


rvc_fi_tcl_RectangleWGS84::~rvc_fi_tcl_RectangleWGS84()
{}

tU32 rvc_fi_tcl_RectangleWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

fi_tclInContext& rvc_fi_tcl_RectangleWGS84::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LongitudeMin);
   (tVoid) (oIn >> LatitudeMin);
   (tVoid) (oIn >> LongitudeMax);
   (tVoid) (oIn >> LatitudeMax);
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_RectangleWGS84::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LongitudeMin);
   (tVoid) (oOut << LatitudeMin);
   (tVoid) (oOut << LongitudeMax);
   (tVoid) (oOut << LatitudeMax);
   return oOut;
}

tBool rvc_fi_tcl_RectangleWGS84::operator==(const rvc_fi_tcl_RectangleWGS84& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LongitudeMin == roRef.LongitudeMin);
   bResult = bResult && (LatitudeMin == roRef.LatitudeMin);
   bResult = bResult && (LongitudeMax == roRef.LongitudeMax);
   bResult = bResult && (LatitudeMax == roRef.LatitudeMax);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e16_ISOCountryCode::rvc_fi_tcl_e16_ISOCountryCode():enType(FI_EN_ISO_ALPHA_3_UNDEFINED) {}

tS32 rvc_fi_tcl_e16_ISOCountryCode::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E16_ISOCOUNTRYCODE;
}


rvc_fi_tcl_e16_ISOCountryCode::~rvc_fi_tcl_e16_ISOCountryCode()
{}

tU32 rvc_fi_tcl_e16_ISOCountryCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_fi_tcl_e16_ISOCountryCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e16_ISOCountryCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e16_ISOLanguageCode::rvc_fi_tcl_e16_ISOLanguageCode():enType(FI_EN_ISO_639_1_UNDEFINED) {}

tS32 rvc_fi_tcl_e16_ISOLanguageCode::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E16_ISOLANGUAGECODE;
}


rvc_fi_tcl_e16_ISOLanguageCode::~rvc_fi_tcl_e16_ISOLanguageCode()
{}

tU32 rvc_fi_tcl_e16_ISOLanguageCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_fi_tcl_e16_ISOLanguageCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e16_ISOLanguageCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_fi_tcl_LanguageID::rvc_fi_tcl_LanguageID(const rvc_fi_tcl_LanguageID& coRef)
   : rvc_fi_tclVisitableTypeBase(coRef)
{
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
}
rvc_fi_tcl_LanguageID& rvc_fi_tcl_LanguageID::operator=(const rvc_fi_tcl_LanguageID& coRef)
{
   if (this == &coRef) return *this;
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_LanguageID::rvc_fi_tcl_LanguageID()
:ISO639_LanguageCode()
,ISO3166_CountryCode()
 {}

tS32 rvc_fi_tcl_LanguageID::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_LANGUAGEID;
}


rvc_fi_tcl_LanguageID::~rvc_fi_tcl_LanguageID()
{}

tU32 rvc_fi_tcl_LanguageID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& rvc_fi_tcl_LanguageID::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ISO639_LanguageCode);
   (tVoid) (oIn >> ISO3166_CountryCode);
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_LanguageID::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ISO639_LanguageCode);
   (tVoid) (oOut << ISO3166_CountryCode);
   return oOut;
}

tBool rvc_fi_tcl_LanguageID::operator==(const rvc_fi_tcl_LanguageID& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ISO639_LanguageCode == roRef.ISO639_LanguageCode);
   bResult = bResult && (ISO3166_CountryCode == roRef.ISO3166_CountryCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_u8_DirectionAbsolute::rvc_fi_tcl_u8_DirectionAbsolute(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 rvc_fi_tcl_u8_DirectionAbsolute::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_U8_DIRECTIONABSOLUTE;
}


rvc_fi_tcl_u8_DirectionAbsolute::~rvc_fi_tcl_u8_DirectionAbsolute()
{}

tU32 rvc_fi_tcl_u8_DirectionAbsolute::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_u8_DirectionAbsolute::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& rvc_fi_tcl_u8_DirectionAbsolute::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_u8_DirectionRelative::rvc_fi_tcl_u8_DirectionRelative(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 rvc_fi_tcl_u8_DirectionRelative::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_U8_DIRECTIONRELATIVE;
}


rvc_fi_tcl_u8_DirectionRelative::~rvc_fi_tcl_u8_DirectionRelative()
{}

tU32 rvc_fi_tcl_u8_DirectionRelative::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_u8_DirectionRelative::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& rvc_fi_tcl_u8_DirectionRelative::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_s16_CentiDegree::rvc_fi_tcl_s16_CentiDegree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 rvc_fi_tcl_s16_CentiDegree::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_S16_CENTIDEGREE;
}


rvc_fi_tcl_s16_CentiDegree::~rvc_fi_tcl_s16_CentiDegree()
{}

tU32 rvc_fi_tcl_s16_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_fi_tcl_s16_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& rvc_fi_tcl_s16_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_s16_Degree::rvc_fi_tcl_s16_Degree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 rvc_fi_tcl_s16_Degree::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_S16_DEGREE;
}


rvc_fi_tcl_s16_Degree::~rvc_fi_tcl_s16_Degree()
{}

tU32 rvc_fi_tcl_s16_Degree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_fi_tcl_s16_Degree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& rvc_fi_tcl_s16_Degree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_u16_DirectionAbsolute_CentiDegree::rvc_fi_tcl_u16_DirectionAbsolute_CentiDegree(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 rvc_fi_tcl_u16_DirectionAbsolute_CentiDegree::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_U16_DIRECTIONABSOLUTE_CENTIDEGREE;
}


rvc_fi_tcl_u16_DirectionAbsolute_CentiDegree::~rvc_fi_tcl_u16_DirectionAbsolute_CentiDegree()
{}

tU32 rvc_fi_tcl_u16_DirectionAbsolute_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_fi_tcl_u16_DirectionAbsolute_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& rvc_fi_tcl_u16_DirectionAbsolute_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_s16_DirectionRelative_CentiDegree::rvc_fi_tcl_s16_DirectionRelative_CentiDegree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 rvc_fi_tcl_s16_DirectionRelative_CentiDegree::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_S16_DIRECTIONRELATIVE_CENTIDEGREE;
}


rvc_fi_tcl_s16_DirectionRelative_CentiDegree::~rvc_fi_tcl_s16_DirectionRelative_CentiDegree()
{}

tU32 rvc_fi_tcl_s16_DirectionRelative_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_fi_tcl_s16_DirectionRelative_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& rvc_fi_tcl_s16_DirectionRelative_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_FuelType::rvc_fi_tcl_e8_FuelType():enType(FI_EN_RESERVED) {}

tS32 rvc_fi_tcl_e8_FuelType::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_FUELTYPE;
}


rvc_fi_tcl_e8_FuelType::~rvc_fi_tcl_e8_FuelType()
{}

tU32 rvc_fi_tcl_e8_FuelType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_FuelType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_FuelType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_fi_tcl_DistTimeFuel::rvc_fi_tcl_DistTimeFuel(const rvc_fi_tcl_DistTimeFuel& coRef)
   : rvc_fi_tclVisitableTypeBase(coRef)
{
   Distance = coRef.Distance;
   Time = coRef.Time;
   Fuel = coRef.Fuel;
}
rvc_fi_tcl_DistTimeFuel& rvc_fi_tcl_DistTimeFuel::operator=(const rvc_fi_tcl_DistTimeFuel& coRef)
{
   if (this == &coRef) return *this;
   Distance = coRef.Distance;
   Time = coRef.Time;
   Fuel = coRef.Fuel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_DistTimeFuel::rvc_fi_tcl_DistTimeFuel()
:Distance()
,Time()
,Fuel()
 {}

tS32 rvc_fi_tcl_DistTimeFuel::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_DISTTIMEFUEL;
}


rvc_fi_tcl_DistTimeFuel::~rvc_fi_tcl_DistTimeFuel()
{}

tU32 rvc_fi_tcl_DistTimeFuel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& rvc_fi_tcl_DistTimeFuel::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Distance);
   (tVoid) (oIn >> Time);
   (tVoid) (oIn >> Fuel);
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_DistTimeFuel::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Distance);
   (tVoid) (oOut << Time);
   (tVoid) (oOut << Fuel);
   return oOut;
}

tBool rvc_fi_tcl_DistTimeFuel::operator==(const rvc_fi_tcl_DistTimeFuel& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Distance == roRef.Distance);
   bResult = bResult && (Time == roRef.Time);
   bResult = bResult && (Fuel == roRef.Fuel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_RVC_CCAError::rvc_fi_tcl_e8_RVC_CCAError():enType(FI_EN_RVC_OPCODE_NOT_SUPPORTED) {}

tS32 rvc_fi_tcl_e8_RVC_CCAError::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_RVC_CCAERROR;
}


rvc_fi_tcl_e8_RVC_CCAError::~rvc_fi_tcl_e8_RVC_CCAError()
{}

tU32 rvc_fi_tcl_e8_RVC_CCAError::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_RVC_CCAError::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_RVC_CCAError::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_RVC_Camera_System_Type::rvc_fi_tcl_e8_RVC_Camera_System_Type():enType(FI_EN_NONE) {}

tS32 rvc_fi_tcl_e8_RVC_Camera_System_Type::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_RVC_CAMERA_SYSTEM_TYPE;
}


rvc_fi_tcl_e8_RVC_Camera_System_Type::~rvc_fi_tcl_e8_RVC_Camera_System_Type()
{}

tU32 rvc_fi_tcl_e8_RVC_Camera_System_Type::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_RVC_Camera_System_Type::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_RVC_Camera_System_Type::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_RVC_SignalStatus::rvc_fi_tcl_e8_RVC_SignalStatus():enType(FI_EN_SIGNAL_OK) {}

tS32 rvc_fi_tcl_e8_RVC_SignalStatus::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_RVC_SIGNALSTATUS;
}


rvc_fi_tcl_e8_RVC_SignalStatus::~rvc_fi_tcl_e8_RVC_SignalStatus()
{}

tU32 rvc_fi_tcl_e8_RVC_SignalStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_RVC_SignalStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_RVC_SignalStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_RVC_SystemStatus::rvc_fi_tcl_e8_RVC_SystemStatus():enType(FI_EN_INITIALISATION) {}

tS32 rvc_fi_tcl_e8_RVC_SystemStatus::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_RVC_SYSTEMSTATUS;
}


rvc_fi_tcl_e8_RVC_SystemStatus::~rvc_fi_tcl_e8_RVC_SystemStatus()
{}

tU32 rvc_fi_tcl_e8_RVC_SystemStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_RVC_SystemStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_RVC_SystemStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_RVC_StatusGuideLine::rvc_fi_tcl_e8_RVC_StatusGuideLine():enType(FI_EN_STATICGUIDELINEOFF) {}

tS32 rvc_fi_tcl_e8_RVC_StatusGuideLine::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_RVC_STATUSGUIDELINE;
}


rvc_fi_tcl_e8_RVC_StatusGuideLine::~rvc_fi_tcl_e8_RVC_StatusGuideLine()
{}

tU32 rvc_fi_tcl_e8_RVC_StatusGuideLine::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_RVC_StatusGuideLine::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_RVC_StatusGuideLine::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_RVC_StatusWarningText::rvc_fi_tcl_e8_RVC_StatusWarningText():enType(FI_EN_WARNINGTEXTOFF) {}

tS32 rvc_fi_tcl_e8_RVC_StatusWarningText::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_RVC_STATUSWARNINGTEXT;
}


rvc_fi_tcl_e8_RVC_StatusWarningText::~rvc_fi_tcl_e8_RVC_StatusWarningText()
{}

tU32 rvc_fi_tcl_e8_RVC_StatusWarningText::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_RVC_StatusWarningText::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_RVC_StatusWarningText::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_RVC_Status::rvc_fi_tcl_e8_RVC_Status():enType(FI_EN_NOT_AVAILABLE) {}

tS32 rvc_fi_tcl_e8_RVC_Status::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_RVC_STATUS;
}


rvc_fi_tcl_e8_RVC_Status::~rvc_fi_tcl_e8_RVC_Status()
{}

tU32 rvc_fi_tcl_e8_RVC_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_RVC_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_RVC_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_RVC_ButtonState::rvc_fi_tcl_e8_RVC_ButtonState():enType(FI_EN_RELEASED) {}

tS32 rvc_fi_tcl_e8_RVC_ButtonState::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_RVC_BUTTONSTATE;
}


rvc_fi_tcl_e8_RVC_ButtonState::~rvc_fi_tcl_e8_RVC_ButtonState()
{}

tU32 rvc_fi_tcl_e8_RVC_ButtonState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_RVC_ButtonState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_RVC_ButtonState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_RVC_Language::rvc_fi_tcl_e8_RVC_Language():enType(FI_EN_ENGLISH_US) {}

tS32 rvc_fi_tcl_e8_RVC_Language::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_RVC_LANGUAGE;
}


rvc_fi_tcl_e8_RVC_Language::~rvc_fi_tcl_e8_RVC_Language()
{}

tU32 rvc_fi_tcl_e8_RVC_Language::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_RVC_Language::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_RVC_Language::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_AVM_StatusBeep::rvc_fi_tcl_e8_AVM_StatusBeep():enType(FI_EN_ALLBEEPTYPESNOTACTIVE) {}

tS32 rvc_fi_tcl_e8_AVM_StatusBeep::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_AVM_STATUSBEEP;
}


rvc_fi_tcl_e8_AVM_StatusBeep::~rvc_fi_tcl_e8_AVM_StatusBeep()
{}

tU32 rvc_fi_tcl_e8_AVM_StatusBeep::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_AVM_StatusBeep::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_AVM_StatusBeep::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_AffordableIts_Status::rvc_fi_tcl_e8_AffordableIts_Status():enType(FI_EN_NOT_AVAILABLE) {}

tS32 rvc_fi_tcl_e8_AffordableIts_Status::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_AFFORDABLEITS_STATUS;
}


rvc_fi_tcl_e8_AffordableIts_Status::~rvc_fi_tcl_e8_AffordableIts_Status()
{}

tU32 rvc_fi_tcl_e8_AffordableIts_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_AffordableIts_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_AffordableIts_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_RVC_VideoParameterType::rvc_fi_tcl_e8_RVC_VideoParameterType():enType(FI_EN_BRIGHTNESS) {}

tS32 rvc_fi_tcl_e8_RVC_VideoParameterType::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_RVC_VIDEOPARAMETERTYPE;
}


rvc_fi_tcl_e8_RVC_VideoParameterType::~rvc_fi_tcl_e8_RVC_VideoParameterType()
{}

tU32 rvc_fi_tcl_e8_RVC_VideoParameterType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_RVC_VideoParameterType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_RVC_VideoParameterType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode::rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode():enType(FI_EN_DAY) {}

tS32 rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_RVC_VIDEOPARAMETERDIMMINGMODE;
}


rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode::~rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode()
{}

tU32 rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_AffordableIts_StatusFeature::rvc_fi_tcl_e8_AffordableIts_StatusFeature():enType(FI_EN_UNKNOWN) {}

tS32 rvc_fi_tcl_e8_AffordableIts_StatusFeature::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_AFFORDABLEITS_STATUSFEATURE;
}


rvc_fi_tcl_e8_AffordableIts_StatusFeature::~rvc_fi_tcl_e8_AffordableIts_StatusFeature()
{}

tU32 rvc_fi_tcl_e8_AffordableIts_StatusFeature::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_AffordableIts_StatusFeature::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_AffordableIts_StatusFeature::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_Exit_Authorized::rvc_fi_tcl_e8_Exit_Authorized():enType(FI_EN_NOT_ALLOWED) {}

tS32 rvc_fi_tcl_e8_Exit_Authorized::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_EXIT_AUTHORIZED;
}


rvc_fi_tcl_e8_Exit_Authorized::~rvc_fi_tcl_e8_Exit_Authorized()
{}

tU32 rvc_fi_tcl_e8_Exit_Authorized::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_Exit_Authorized::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_Exit_Authorized::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_fi_tcl_RVC_VideoAnalogLevels::rvc_fi_tcl_RVC_VideoAnalogLevels(const rvc_fi_tcl_RVC_VideoAnalogLevels& coRef)
   : rvc_fi_tclVisitableTypeBase(coRef)
{
   e8Type = coRef.e8Type;
   e8DimmingMode = coRef.e8DimmingMode;
   u8Value = coRef.u8Value;
}
rvc_fi_tcl_RVC_VideoAnalogLevels& rvc_fi_tcl_RVC_VideoAnalogLevels::operator=(const rvc_fi_tcl_RVC_VideoAnalogLevels& coRef)
{
   if (this == &coRef) return *this;
   e8Type = coRef.e8Type;
   e8DimmingMode = coRef.e8DimmingMode;
   u8Value = coRef.u8Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_RVC_VideoAnalogLevels::rvc_fi_tcl_RVC_VideoAnalogLevels()
:e8Type()
,e8DimmingMode()
,u8Value(0)
 {}

tS32 rvc_fi_tcl_RVC_VideoAnalogLevels::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_RVC_VIDEOANALOGLEVELS;
}


rvc_fi_tcl_RVC_VideoAnalogLevels::~rvc_fi_tcl_RVC_VideoAnalogLevels()
{}

tU32 rvc_fi_tcl_RVC_VideoAnalogLevels::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& rvc_fi_tcl_RVC_VideoAnalogLevels::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Type);
   (tVoid) (oIn >> e8DimmingMode);
   (tVoid) (oIn >> u8Value);
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_RVC_VideoAnalogLevels::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Type);
   (tVoid) (oOut << e8DimmingMode);
   (tVoid) (oOut << u8Value);
   return oOut;
}

tBool rvc_fi_tcl_RVC_VideoAnalogLevels::operator==(const rvc_fi_tcl_RVC_VideoAnalogLevels& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Type == roRef.e8Type);
   bResult = bResult && (e8DimmingMode == roRef.e8DimmingMode);
   bResult = bResult && (u8Value == roRef.u8Value);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_RVC_CameraState::rvc_fi_tcl_e8_RVC_CameraState():enType(FI_EN_RVC_CAMSTATE_INIT) {}

tS32 rvc_fi_tcl_e8_RVC_CameraState::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_RVC_CAMERASTATE;
}


rvc_fi_tcl_e8_RVC_CameraState::~rvc_fi_tcl_e8_RVC_CameraState()
{}

tU32 rvc_fi_tcl_e8_RVC_CameraState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_RVC_CameraState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_RVC_CameraState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_IPA_BUTTON_ID::rvc_fi_tcl_e8_IPA_BUTTON_ID():enType(FI_EN_NO_SWITCH) {}

tS32 rvc_fi_tcl_e8_IPA_BUTTON_ID::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_IPA_BUTTON_ID;
}


rvc_fi_tcl_e8_IPA_BUTTON_ID::~rvc_fi_tcl_e8_IPA_BUTTON_ID()
{}

tU32 rvc_fi_tcl_e8_IPA_BUTTON_ID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_IPA_BUTTON_ID::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_IPA_BUTTON_ID::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_IPA_PatternID::rvc_fi_tcl_e8_IPA_PatternID():enType(FI_EN_PATTERN_1) {}

tS32 rvc_fi_tcl_e8_IPA_PatternID::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_IPA_PATTERNID;
}


rvc_fi_tcl_e8_IPA_PatternID::~rvc_fi_tcl_e8_IPA_PatternID()
{}

tU32 rvc_fi_tcl_e8_IPA_PatternID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_IPA_PatternID::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_IPA_PatternID::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_IPA_MessageID::rvc_fi_tcl_e8_IPA_MessageID():enType(FI_EN_NO_MESSAGE_DISPLAYED) {}

tS32 rvc_fi_tcl_e8_IPA_MessageID::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_IPA_MESSAGEID;
}


rvc_fi_tcl_e8_IPA_MessageID::~rvc_fi_tcl_e8_IPA_MessageID()
{}

tU32 rvc_fi_tcl_e8_IPA_MessageID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_IPA_MessageID::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_IPA_MessageID::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_IPA_OperationStatus::rvc_fi_tcl_e8_IPA_OperationStatus():enType(FI_EN_NORMAL) {}

tS32 rvc_fi_tcl_e8_IPA_OperationStatus::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_IPA_OPERATIONSTATUS;
}


rvc_fi_tcl_e8_IPA_OperationStatus::~rvc_fi_tcl_e8_IPA_OperationStatus()
{}

tU32 rvc_fi_tcl_e8_IPA_OperationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_IPA_OperationStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_IPA_OperationStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_IPA_ModeChangeRequest::rvc_fi_tcl_e8_IPA_ModeChangeRequest():enType(FI_EN_NORMAL) {}

tS32 rvc_fi_tcl_e8_IPA_ModeChangeRequest::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_IPA_MODECHANGEREQUEST;
}


rvc_fi_tcl_e8_IPA_ModeChangeRequest::~rvc_fi_tcl_e8_IPA_ModeChangeRequest()
{}

tU32 rvc_fi_tcl_e8_IPA_ModeChangeRequest::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_IPA_ModeChangeRequest::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_IPA_ModeChangeRequest::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_IPA_HMIStatus::rvc_fi_tcl_e8_IPA_HMIStatus():enType(FI_EN_NOTACTIVATED) {}

tS32 rvc_fi_tcl_e8_IPA_HMIStatus::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_IPA_HMISTATUS;
}


rvc_fi_tcl_e8_IPA_HMIStatus::~rvc_fi_tcl_e8_IPA_HMIStatus()
{}

tU32 rvc_fi_tcl_e8_IPA_HMIStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_IPA_HMIStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_IPA_HMIStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_IPA_RegionalSelection::rvc_fi_tcl_e8_IPA_RegionalSelection():enType(FI_EN_JAPAN) {}

tS32 rvc_fi_tcl_e8_IPA_RegionalSelection::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_IPA_REGIONALSELECTION;
}


rvc_fi_tcl_e8_IPA_RegionalSelection::~rvc_fi_tcl_e8_IPA_RegionalSelection()
{}

tU32 rvc_fi_tcl_e8_IPA_RegionalSelection::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_IPA_RegionalSelection::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_IPA_RegionalSelection::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_IPA_AvailabilityStatus::rvc_fi_tcl_e8_IPA_AvailabilityStatus():enType(FI_EN_NOT_AVAILABLE) {}

tS32 rvc_fi_tcl_e8_IPA_AvailabilityStatus::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_IPA_AVAILABILITYSTATUS;
}


rvc_fi_tcl_e8_IPA_AvailabilityStatus::~rvc_fi_tcl_e8_IPA_AvailabilityStatus()
{}

tU32 rvc_fi_tcl_e8_IPA_AvailabilityStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_IPA_AvailabilityStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_IPA_AvailabilityStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_IPA_SwitchMask::rvc_fi_tcl_e8_IPA_SwitchMask():enType(FI_EN_NOMASK) {}

tS32 rvc_fi_tcl_e8_IPA_SwitchMask::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_IPA_SWITCHMASK;
}


rvc_fi_tcl_e8_IPA_SwitchMask::~rvc_fi_tcl_e8_IPA_SwitchMask()
{}

tU32 rvc_fi_tcl_e8_IPA_SwitchMask::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_IPA_SwitchMask::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_IPA_SwitchMask::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_Set_MicState::rvc_fi_tcl_e8_Set_MicState():enType(FI_EN_OFF) {}

tS32 rvc_fi_tcl_e8_Set_MicState::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_SET_MICSTATE;
}


rvc_fi_tcl_e8_Set_MicState::~rvc_fi_tcl_e8_Set_MicState()
{}

tU32 rvc_fi_tcl_e8_Set_MicState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_Set_MicState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_Set_MicState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_IPA_DirectionIndicator::rvc_fi_tcl_e8_IPA_DirectionIndicator():enType(FI_EN_FORWARD) {}

tS32 rvc_fi_tcl_e8_IPA_DirectionIndicator::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_IPA_DIRECTIONINDICATOR;
}


rvc_fi_tcl_e8_IPA_DirectionIndicator::~rvc_fi_tcl_e8_IPA_DirectionIndicator()
{}

tU32 rvc_fi_tcl_e8_IPA_DirectionIndicator::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_IPA_DirectionIndicator::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_IPA_DirectionIndicator::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_IPA_VoiceText::rvc_fi_tcl_e8_IPA_VoiceText():enType(FI_EN_NO_SOUND) {}

tS32 rvc_fi_tcl_e8_IPA_VoiceText::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_IPA_VOICETEXT;
}


rvc_fi_tcl_e8_IPA_VoiceText::~rvc_fi_tcl_e8_IPA_VoiceText()
{}

tU32 rvc_fi_tcl_e8_IPA_VoiceText::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_IPA_VoiceText::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_IPA_VoiceText::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_fi_tcl_IPA_Voice_Text_Strings::rvc_fi_tcl_IPA_Voice_Text_Strings(const rvc_fi_tcl_IPA_Voice_Text_Strings& coRef)
   : rvc_fi_tclVisitableTypeBase(coRef)
{
   e8RequestId = coRef.e8RequestId;
   szText = coRef.szText;
}
rvc_fi_tcl_IPA_Voice_Text_Strings& rvc_fi_tcl_IPA_Voice_Text_Strings::operator=(const rvc_fi_tcl_IPA_Voice_Text_Strings& coRef)
{
   if (this == &coRef) return *this;
   e8RequestId = coRef.e8RequestId;
   szText = coRef.szText;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid rvc_fi_tcl_IPA_Voice_Text_Strings::vDestroy()
{
   szText.vDestroy();
}

rvc_fi_tcl_IPA_Voice_Text_Strings::rvc_fi_tcl_IPA_Voice_Text_Strings()
:e8RequestId()
,szText()
 {}

tS32 rvc_fi_tcl_IPA_Voice_Text_Strings::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_IPA_VOICE_TEXT_STRINGS;
}


rvc_fi_tcl_IPA_Voice_Text_Strings::~rvc_fi_tcl_IPA_Voice_Text_Strings()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 rvc_fi_tcl_IPA_Voice_Text_Strings::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+szText.u32GetSize(u16MajorVersion);
}

fi_tclInContext& rvc_fi_tcl_IPA_Voice_Text_Strings::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8RequestId);
   (tVoid) (oIn >> szText);
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_IPA_Voice_Text_Strings::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8RequestId);
   (tVoid) (oOut << szText);
   return oOut;
}

tBool rvc_fi_tcl_IPA_Voice_Text_Strings::operator==(const rvc_fi_tcl_IPA_Voice_Text_Strings& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8RequestId == roRef.e8RequestId);
   bResult = bResult && (szText == roRef.szText);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_Camera_PowerSupplyStatus::rvc_fi_tcl_e8_Camera_PowerSupplyStatus():enType(FI_EN_UNKNOWN) {}

tS32 rvc_fi_tcl_e8_Camera_PowerSupplyStatus::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_CAMERA_POWERSUPPLYSTATUS;
}


rvc_fi_tcl_e8_Camera_PowerSupplyStatus::~rvc_fi_tcl_e8_Camera_PowerSupplyStatus()
{}

tU32 rvc_fi_tcl_e8_Camera_PowerSupplyStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_Camera_PowerSupplyStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_Camera_PowerSupplyStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_Microphone_PowerSupplyStatus::rvc_fi_tcl_e8_Microphone_PowerSupplyStatus():enType(FI_EN_UNKNOWN) {}

tS32 rvc_fi_tcl_e8_Microphone_PowerSupplyStatus::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_MICROPHONE_POWERSUPPLYSTATUS;
}


rvc_fi_tcl_e8_Microphone_PowerSupplyStatus::~rvc_fi_tcl_e8_Microphone_PowerSupplyStatus()
{}

tU32 rvc_fi_tcl_e8_Microphone_PowerSupplyStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_Microphone_PowerSupplyStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_Microphone_PowerSupplyStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_RVC_Module::rvc_fi_tcl_e8_RVC_Module():enType(FI_EN_RESERVED) {}

tS32 rvc_fi_tcl_e8_RVC_Module::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_RVC_MODULE;
}


rvc_fi_tcl_e8_RVC_Module::~rvc_fi_tcl_e8_RVC_Module()
{}

tU32 rvc_fi_tcl_e8_RVC_Module::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_RVC_Module::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_RVC_Module::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_RVC_ReverseSignalStatus::rvc_fi_tcl_e8_RVC_ReverseSignalStatus():enType(FI_EN_OFF) {}

tS32 rvc_fi_tcl_e8_RVC_ReverseSignalStatus::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_RVC_REVERSESIGNALSTATUS;
}


rvc_fi_tcl_e8_RVC_ReverseSignalStatus::~rvc_fi_tcl_e8_RVC_ReverseSignalStatus()
{}

tU32 rvc_fi_tcl_e8_RVC_ReverseSignalStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_RVC_ReverseSignalStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_RVC_ReverseSignalStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_ParkAssist_UserConfigurationType::rvc_fi_tcl_e8_ParkAssist_UserConfigurationType():enType(FI_EN_REAR_VIEW_CAMERA) {}

tS32 rvc_fi_tcl_e8_ParkAssist_UserConfigurationType::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_PARKASSIST_USERCONFIGURATIONTYPE;
}


rvc_fi_tcl_e8_ParkAssist_UserConfigurationType::~rvc_fi_tcl_e8_ParkAssist_UserConfigurationType()
{}

tU32 rvc_fi_tcl_e8_ParkAssist_UserConfigurationType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_ParkAssist_UserConfigurationType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_ParkAssist_UserConfigurationType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_ParkAssist_UserConfigurationMode::rvc_fi_tcl_e8_ParkAssist_UserConfigurationMode():enType(FI_EN_OFF) {}

tS32 rvc_fi_tcl_e8_ParkAssist_UserConfigurationMode::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_PARKASSIST_USERCONFIGURATIONMODE;
}


rvc_fi_tcl_e8_ParkAssist_UserConfigurationMode::~rvc_fi_tcl_e8_ParkAssist_UserConfigurationMode()
{}

tU32 rvc_fi_tcl_e8_ParkAssist_UserConfigurationMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_ParkAssist_UserConfigurationMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_ParkAssist_UserConfigurationMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_fi_tcl_ParkAssist_UserConfiguration::rvc_fi_tcl_ParkAssist_UserConfiguration(const rvc_fi_tcl_ParkAssist_UserConfiguration& coRef)
   : rvc_fi_tclVisitableTypeBase(coRef)
{
   e8Type = coRef.e8Type;
   e8Mode = coRef.e8Mode;
}
rvc_fi_tcl_ParkAssist_UserConfiguration& rvc_fi_tcl_ParkAssist_UserConfiguration::operator=(const rvc_fi_tcl_ParkAssist_UserConfiguration& coRef)
{
   if (this == &coRef) return *this;
   e8Type = coRef.e8Type;
   e8Mode = coRef.e8Mode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_ParkAssist_UserConfiguration::rvc_fi_tcl_ParkAssist_UserConfiguration()
:e8Type()
,e8Mode()
 {}

tS32 rvc_fi_tcl_ParkAssist_UserConfiguration::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_PARKASSIST_USERCONFIGURATION;
}


rvc_fi_tcl_ParkAssist_UserConfiguration::~rvc_fi_tcl_ParkAssist_UserConfiguration()
{}

tU32 rvc_fi_tcl_ParkAssist_UserConfiguration::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_fi_tcl_ParkAssist_UserConfiguration::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Type);
   (tVoid) (oIn >> e8Mode);
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_ParkAssist_UserConfiguration::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Type);
   (tVoid) (oOut << e8Mode);
   return oOut;
}

tBool rvc_fi_tcl_ParkAssist_UserConfiguration::operator==(const rvc_fi_tcl_ParkAssist_UserConfiguration& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Type == roRef.e8Type);
   bResult = bResult && (e8Mode == roRef.e8Mode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_GdlAdj_AdjustButton::rvc_fi_tcl_e8_GdlAdj_AdjustButton():enType(FI_EN_UP) {}

tS32 rvc_fi_tcl_e8_GdlAdj_AdjustButton::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_GDLADJ_ADJUSTBUTTON;
}


rvc_fi_tcl_e8_GdlAdj_AdjustButton::~rvc_fi_tcl_e8_GdlAdj_AdjustButton()
{}

tU32 rvc_fi_tcl_e8_GdlAdj_AdjustButton::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_GdlAdj_AdjustButton::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_GdlAdj_AdjustButton::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_GdlAdj_Completion::rvc_fi_tcl_e8_GdlAdj_Completion():enType(FI_EN_CONFIRM) {}

tS32 rvc_fi_tcl_e8_GdlAdj_Completion::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_GDLADJ_COMPLETION;
}


rvc_fi_tcl_e8_GdlAdj_Completion::~rvc_fi_tcl_e8_GdlAdj_Completion()
{}

tU32 rvc_fi_tcl_e8_GdlAdj_Completion::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_GdlAdj_Completion::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_GdlAdj_Completion::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_GdlAdj_Request::rvc_fi_tcl_e8_GdlAdj_Request():enType(FI_EN_GET_ALL) {}

tS32 rvc_fi_tcl_e8_GdlAdj_Request::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_GDLADJ_REQUEST;
}


rvc_fi_tcl_e8_GdlAdj_Request::~rvc_fi_tcl_e8_GdlAdj_Request()
{}

tU32 rvc_fi_tcl_e8_GdlAdj_Request::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_GdlAdj_Request::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_GdlAdj_Request::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_GdlAdj_ConfigurationItem::rvc_fi_tcl_e8_GdlAdj_ConfigurationItem():enType(FI_EN_NONE) {}

tS32 rvc_fi_tcl_e8_GdlAdj_ConfigurationItem::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_GDLADJ_CONFIGURATIONITEM;
}


rvc_fi_tcl_e8_GdlAdj_ConfigurationItem::~rvc_fi_tcl_e8_GdlAdj_ConfigurationItem()
{}

tU32 rvc_fi_tcl_e8_GdlAdj_ConfigurationItem::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_GdlAdj_ConfigurationItem::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_GdlAdj_ConfigurationItem::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_fi_tcl_GdlAdj_ConfigParameterData::rvc_fi_tcl_GdlAdj_ConfigParameterData(const rvc_fi_tcl_GdlAdj_ConfigParameterData& coRef)
   : rvc_fi_tclVisitableTypeBase(coRef)
{
   e8Item = coRef.e8Item;
   f64Value = coRef.f64Value;
}
rvc_fi_tcl_GdlAdj_ConfigParameterData& rvc_fi_tcl_GdlAdj_ConfigParameterData::operator=(const rvc_fi_tcl_GdlAdj_ConfigParameterData& coRef)
{
   if (this == &coRef) return *this;
   e8Item = coRef.e8Item;
   f64Value = coRef.f64Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_GdlAdj_ConfigParameterData::rvc_fi_tcl_GdlAdj_ConfigParameterData()
:e8Item()
,f64Value(0)
 {}

tS32 rvc_fi_tcl_GdlAdj_ConfigParameterData::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_GDLADJ_CONFIGPARAMETERDATA;
}


rvc_fi_tcl_GdlAdj_ConfigParameterData::~rvc_fi_tcl_GdlAdj_ConfigParameterData()
{}

tU32 rvc_fi_tcl_GdlAdj_ConfigParameterData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& rvc_fi_tcl_GdlAdj_ConfigParameterData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Item);
   (tVoid) (oIn >> f64Value);
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_GdlAdj_ConfigParameterData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Item);
   (tVoid) (oOut << f64Value);
   return oOut;
}

tBool rvc_fi_tcl_GdlAdj_ConfigParameterData::operator==(const rvc_fi_tcl_GdlAdj_ConfigParameterData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Item == roRef.e8Item);
   bResult = bResult && (f64Value == roRef.f64Value);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_MVCViewingState::rvc_fi_tcl_e8_MVCViewingState():enType(FI_EN_NOVIEW) {}

tS32 rvc_fi_tcl_e8_MVCViewingState::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_MVCVIEWINGSTATE;
}


rvc_fi_tcl_e8_MVCViewingState::~rvc_fi_tcl_e8_MVCViewingState()
{}

tU32 rvc_fi_tcl_e8_MVCViewingState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_MVCViewingState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_MVCViewingState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_AVM_View_Request::rvc_fi_tcl_e8_AVM_View_Request():enType(FI_EN_NO_REQUEST) {}

tS32 rvc_fi_tcl_e8_AVM_View_Request::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_AVM_VIEW_REQUEST;
}


rvc_fi_tcl_e8_AVM_View_Request::~rvc_fi_tcl_e8_AVM_View_Request()
{}

tU32 rvc_fi_tcl_e8_AVM_View_Request::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_AVM_View_Request::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_AVM_View_Request::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_AVM_View_Status::rvc_fi_tcl_e8_AVM_View_Status():enType(FI_EN_FRONT_BIRD_VIEW) {}

tS32 rvc_fi_tcl_e8_AVM_View_Status::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_AVM_VIEW_STATUS;
}


rvc_fi_tcl_e8_AVM_View_Status::~rvc_fi_tcl_e8_AVM_View_Status()
{}

tU32 rvc_fi_tcl_e8_AVM_View_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_AVM_View_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_AVM_View_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_Tailgate_State::rvc_fi_tcl_e8_Tailgate_State():enType(FI_EN_UNAVAILABLE) {}

tS32 rvc_fi_tcl_e8_Tailgate_State::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_TAILGATE_STATE;
}


rvc_fi_tcl_e8_Tailgate_State::~rvc_fi_tcl_e8_Tailgate_State()
{}

tU32 rvc_fi_tcl_e8_Tailgate_State::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_Tailgate_State::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_Tailgate_State::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_TouchGesture::rvc_fi_tcl_e8_TouchGesture():enType(FI_EN_NONE) {}

tS32 rvc_fi_tcl_e8_TouchGesture::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_TOUCHGESTURE;
}


rvc_fi_tcl_e8_TouchGesture::~rvc_fi_tcl_e8_TouchGesture()
{}

tU32 rvc_fi_tcl_e8_TouchGesture::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_TouchGesture::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_TouchGesture::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_Direction::rvc_fi_tcl_e8_Direction():enType(FI_EN_INVALID) {}

tS32 rvc_fi_tcl_e8_Direction::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_DIRECTION;
}


rvc_fi_tcl_e8_Direction::~rvc_fi_tcl_e8_Direction()
{}

tU32 rvc_fi_tcl_e8_Direction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_Direction::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_Direction::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_FAP_SettingItem::rvc_fi_tcl_e8_FAP_SettingItem():enType(FI_EN_SETTINGSBUTTONAVAIL) {}

tS32 rvc_fi_tcl_e8_FAP_SettingItem::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_FAP_SETTINGITEM;
}


rvc_fi_tcl_e8_FAP_SettingItem::~rvc_fi_tcl_e8_FAP_SettingItem()
{}

tU32 rvc_fi_tcl_e8_FAP_SettingItem::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_FAP_SettingItem::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_FAP_SettingItem::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_AVM_FAP_SettingState::rvc_fi_tcl_e8_AVM_FAP_SettingState():enType(FI_EN_NOT_DISPLAYED) {}

tS32 rvc_fi_tcl_e8_AVM_FAP_SettingState::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_AVM_FAP_SETTINGSTATE;
}


rvc_fi_tcl_e8_AVM_FAP_SettingState::~rvc_fi_tcl_e8_AVM_FAP_SettingState()
{}

tU32 rvc_fi_tcl_e8_AVM_FAP_SettingState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_AVM_FAP_SettingState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_AVM_FAP_SettingState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_AVM_SettingItem::rvc_fi_tcl_e8_AVM_SettingItem():enType(FI_EN_SETTINGSBUTTONAVAIL) {}

tS32 rvc_fi_tcl_e8_AVM_SettingItem::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_AVM_SETTINGITEM;
}


rvc_fi_tcl_e8_AVM_SettingItem::~rvc_fi_tcl_e8_AVM_SettingItem()
{}

tU32 rvc_fi_tcl_e8_AVM_SettingItem::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_AVM_SettingItem::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_AVM_SettingItem::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_fi_tcl_FAP_Settings_State::rvc_fi_tcl_FAP_Settings_State(const rvc_fi_tcl_FAP_Settings_State& coRef)
   : rvc_fi_tclVisitableTypeBase(coRef)
{
   e8Type = coRef.e8Type;
   e8State = coRef.e8State;
}
rvc_fi_tcl_FAP_Settings_State& rvc_fi_tcl_FAP_Settings_State::operator=(const rvc_fi_tcl_FAP_Settings_State& coRef)
{
   if (this == &coRef) return *this;
   e8Type = coRef.e8Type;
   e8State = coRef.e8State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_FAP_Settings_State::rvc_fi_tcl_FAP_Settings_State()
:e8Type()
,e8State()
 {}

tS32 rvc_fi_tcl_FAP_Settings_State::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_FAP_SETTINGS_STATE;
}


rvc_fi_tcl_FAP_Settings_State::~rvc_fi_tcl_FAP_Settings_State()
{}

tU32 rvc_fi_tcl_FAP_Settings_State::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_fi_tcl_FAP_Settings_State::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Type);
   (tVoid) (oIn >> e8State);
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_FAP_Settings_State::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Type);
   (tVoid) (oOut << e8State);
   return oOut;
}

tBool rvc_fi_tcl_FAP_Settings_State::operator==(const rvc_fi_tcl_FAP_Settings_State& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Type == roRef.e8Type);
   bResult = bResult && (e8State == roRef.e8State);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_fi_tcl_AVM_Settings_State::rvc_fi_tcl_AVM_Settings_State(const rvc_fi_tcl_AVM_Settings_State& coRef)
   : rvc_fi_tclVisitableTypeBase(coRef)
{
   e8Type = coRef.e8Type;
   e8State = coRef.e8State;
}
rvc_fi_tcl_AVM_Settings_State& rvc_fi_tcl_AVM_Settings_State::operator=(const rvc_fi_tcl_AVM_Settings_State& coRef)
{
   if (this == &coRef) return *this;
   e8Type = coRef.e8Type;
   e8State = coRef.e8State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_AVM_Settings_State::rvc_fi_tcl_AVM_Settings_State()
:e8Type()
,e8State()
 {}

tS32 rvc_fi_tcl_AVM_Settings_State::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_AVM_SETTINGS_STATE;
}


rvc_fi_tcl_AVM_Settings_State::~rvc_fi_tcl_AVM_Settings_State()
{}

tU32 rvc_fi_tcl_AVM_Settings_State::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_fi_tcl_AVM_Settings_State::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Type);
   (tVoid) (oIn >> e8State);
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_AVM_Settings_State::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Type);
   (tVoid) (oOut << e8State);
   return oOut;
}

tBool rvc_fi_tcl_AVM_Settings_State::operator==(const rvc_fi_tcl_AVM_Settings_State& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Type == roRef.e8Type);
   bResult = bResult && (e8State == roRef.e8State);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_fi_tcl_GPS_Data::rvc_fi_tcl_GPS_Data(const rvc_fi_tcl_GPS_Data& coRef)
   : rvc_fi_tclVisitableTypeBase(coRef)
{
   GPS_latitude = coRef.GPS_latitude;
   GPS_longitude = coRef.GPS_longitude;
   GPS_altitude = coRef.GPS_altitude;
   GPS_azimuth = coRef.GPS_azimuth;
   HDOP = coRef.HDOP;
   VDOP = coRef.VDOP;
   numOfSatellites = coRef.numOfSatellites;
   groundSpeed = coRef.groundSpeed;
}
rvc_fi_tcl_GPS_Data& rvc_fi_tcl_GPS_Data::operator=(const rvc_fi_tcl_GPS_Data& coRef)
{
   if (this == &coRef) return *this;
   GPS_latitude = coRef.GPS_latitude;
   GPS_longitude = coRef.GPS_longitude;
   GPS_altitude = coRef.GPS_altitude;
   GPS_azimuth = coRef.GPS_azimuth;
   HDOP = coRef.HDOP;
   VDOP = coRef.VDOP;
   numOfSatellites = coRef.numOfSatellites;
   groundSpeed = coRef.groundSpeed;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_GPS_Data::rvc_fi_tcl_GPS_Data()
:GPS_latitude(0)
,GPS_longitude(0)
,GPS_altitude(0)
,GPS_azimuth(0)
,HDOP(0)
,VDOP(0)
,numOfSatellites(0)
,groundSpeed(0)
 {}

tS32 rvc_fi_tcl_GPS_Data::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_GPS_DATA;
}


rvc_fi_tcl_GPS_Data::~rvc_fi_tcl_GPS_Data()
{}

tU32 rvc_fi_tcl_GPS_Data::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 32;
}

fi_tclInContext& rvc_fi_tcl_GPS_Data::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GPS_latitude);
   (tVoid) (oIn >> GPS_longitude);
   (tVoid) (oIn >> GPS_altitude);
   (tVoid) (oIn >> GPS_azimuth);
   (tVoid) (oIn >> HDOP);
   (tVoid) (oIn >> VDOP);
   (tVoid) (oIn >> numOfSatellites);
   (tVoid) (oIn >> groundSpeed);
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_GPS_Data::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GPS_latitude);
   (tVoid) (oOut << GPS_longitude);
   (tVoid) (oOut << GPS_altitude);
   (tVoid) (oOut << GPS_azimuth);
   (tVoid) (oOut << HDOP);
   (tVoid) (oOut << VDOP);
   (tVoid) (oOut << numOfSatellites);
   (tVoid) (oOut << groundSpeed);
   return oOut;
}

tBool rvc_fi_tcl_GPS_Data::operator==(const rvc_fi_tcl_GPS_Data& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GPS_latitude == roRef.GPS_latitude);
   bResult = bResult && (GPS_longitude == roRef.GPS_longitude);
   bResult = bResult && (GPS_altitude == roRef.GPS_altitude);
   bResult = bResult && (GPS_azimuth == roRef.GPS_azimuth);
   bResult = bResult && (HDOP == roRef.HDOP);
   bResult = bResult && (VDOP == roRef.VDOP);
   bResult = bResult && (numOfSatellites == roRef.numOfSatellites);
   bResult = bResult && (groundSpeed == roRef.groundSpeed);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_fi_tcl_MapMatched_Data::rvc_fi_tcl_MapMatched_Data(const rvc_fi_tcl_MapMatched_Data& coRef)
   : rvc_fi_tclVisitableTypeBase(coRef)
{
   MM_latitude = coRef.MM_latitude;
   MM_longitude = coRef.MM_longitude;
   MM_azimuth = coRef.MM_azimuth;
   MM_accuracy = coRef.MM_accuracy;
}
rvc_fi_tcl_MapMatched_Data& rvc_fi_tcl_MapMatched_Data::operator=(const rvc_fi_tcl_MapMatched_Data& coRef)
{
   if (this == &coRef) return *this;
   MM_latitude = coRef.MM_latitude;
   MM_longitude = coRef.MM_longitude;
   MM_azimuth = coRef.MM_azimuth;
   MM_accuracy = coRef.MM_accuracy;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_MapMatched_Data::rvc_fi_tcl_MapMatched_Data()
:MM_latitude(0)
,MM_longitude(0)
,MM_azimuth(0)
,MM_accuracy(0)
 {}

tS32 rvc_fi_tcl_MapMatched_Data::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_MAPMATCHED_DATA;
}


rvc_fi_tcl_MapMatched_Data::~rvc_fi_tcl_MapMatched_Data()
{}

tU32 rvc_fi_tcl_MapMatched_Data::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

fi_tclInContext& rvc_fi_tcl_MapMatched_Data::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MM_latitude);
   (tVoid) (oIn >> MM_longitude);
   (tVoid) (oIn >> MM_azimuth);
   (tVoid) (oIn >> MM_accuracy);
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_MapMatched_Data::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MM_latitude);
   (tVoid) (oOut << MM_longitude);
   (tVoid) (oOut << MM_azimuth);
   (tVoid) (oOut << MM_accuracy);
   return oOut;
}

tBool rvc_fi_tcl_MapMatched_Data::operator==(const rvc_fi_tcl_MapMatched_Data& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MM_latitude == roRef.MM_latitude);
   bResult = bResult && (MM_longitude == roRef.MM_longitude);
   bResult = bResult && (MM_azimuth == roRef.MM_azimuth);
   bResult = bResult && (MM_accuracy == roRef.MM_accuracy);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_fi_tcl_Touch_Data::rvc_fi_tcl_Touch_Data(const rvc_fi_tcl_Touch_Data& coRef)
   : rvc_fi_tclVisitableTypeBase(coRef)
{
   x_ordinate = coRef.x_ordinate;
   y_ordinate = coRef.y_ordinate;
   x1_ordinate = coRef.x1_ordinate;
   y1_ordinate = coRef.y1_ordinate;
   e8Gesture = coRef.e8Gesture;
   e8Direction = coRef.e8Direction;
   SpeedOfMovement = coRef.SpeedOfMovement;
}
rvc_fi_tcl_Touch_Data& rvc_fi_tcl_Touch_Data::operator=(const rvc_fi_tcl_Touch_Data& coRef)
{
   if (this == &coRef) return *this;
   x_ordinate = coRef.x_ordinate;
   y_ordinate = coRef.y_ordinate;
   x1_ordinate = coRef.x1_ordinate;
   y1_ordinate = coRef.y1_ordinate;
   e8Gesture = coRef.e8Gesture;
   e8Direction = coRef.e8Direction;
   SpeedOfMovement = coRef.SpeedOfMovement;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_Touch_Data::rvc_fi_tcl_Touch_Data()
:x_ordinate(0)
,y_ordinate(0)
,x1_ordinate(0)
,y1_ordinate(0)
,e8Gesture()
,e8Direction()
,SpeedOfMovement(0)
 {}

tS32 rvc_fi_tcl_Touch_Data::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_TOUCH_DATA;
}


rvc_fi_tcl_Touch_Data::~rvc_fi_tcl_Touch_Data()
{}

tU32 rvc_fi_tcl_Touch_Data::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 19;
}

fi_tclInContext& rvc_fi_tcl_Touch_Data::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> x_ordinate);
   (tVoid) (oIn >> y_ordinate);
   (tVoid) (oIn >> x1_ordinate);
   (tVoid) (oIn >> y1_ordinate);
   (tVoid) (oIn >> e8Gesture);
   (tVoid) (oIn >> e8Direction);
   (tVoid) (oIn >> SpeedOfMovement);
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_Touch_Data::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << x_ordinate);
   (tVoid) (oOut << y_ordinate);
   (tVoid) (oOut << x1_ordinate);
   (tVoid) (oOut << y1_ordinate);
   (tVoid) (oOut << e8Gesture);
   (tVoid) (oOut << e8Direction);
   (tVoid) (oOut << SpeedOfMovement);
   return oOut;
}

tBool rvc_fi_tcl_Touch_Data::operator==(const rvc_fi_tcl_Touch_Data& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (x_ordinate == roRef.x_ordinate);
   bResult = bResult && (y_ordinate == roRef.y_ordinate);
   bResult = bResult && (x1_ordinate == roRef.x1_ordinate);
   bResult = bResult && (y1_ordinate == roRef.y1_ordinate);
   bResult = bResult && (e8Gesture == roRef.e8Gesture);
   bResult = bResult && (e8Direction == roRef.e8Direction);
   bResult = bResult && (SpeedOfMovement == roRef.SpeedOfMovement);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_AVMph3_SwitchId::rvc_fi_tcl_e8_AVMph3_SwitchId():enType(FI_EN_NONE) {}

tS32 rvc_fi_tcl_e8_AVMph3_SwitchId::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_AVMPH3_SWITCHID;
}


rvc_fi_tcl_e8_AVMph3_SwitchId::~rvc_fi_tcl_e8_AVMph3_SwitchId()
{}

tU32 rvc_fi_tcl_e8_AVMph3_SwitchId::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_AVMph3_SwitchId::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_AVMph3_SwitchId::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_AVMph3_SwitchStatus::rvc_fi_tcl_e8_AVMph3_SwitchStatus():enType(FI_EN_NORMAL) {}

tS32 rvc_fi_tcl_e8_AVMph3_SwitchStatus::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_AVMPH3_SWITCHSTATUS;
}


rvc_fi_tcl_e8_AVMph3_SwitchStatus::~rvc_fi_tcl_e8_AVMph3_SwitchStatus()
{}

tU32 rvc_fi_tcl_e8_AVMph3_SwitchStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_AVMph3_SwitchStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_AVMph3_SwitchStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_fi_tcl_AVMph3_SwitchDescriptor::rvc_fi_tcl_AVMph3_SwitchDescriptor(const rvc_fi_tcl_AVMph3_SwitchDescriptor& coRef)
   : rvc_fi_tclVisitableTypeBase(coRef)
{
   Id = coRef.Id;
   Status = coRef.Status;
}
rvc_fi_tcl_AVMph3_SwitchDescriptor& rvc_fi_tcl_AVMph3_SwitchDescriptor::operator=(const rvc_fi_tcl_AVMph3_SwitchDescriptor& coRef)
{
   if (this == &coRef) return *this;
   Id = coRef.Id;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_AVMph3_SwitchDescriptor::rvc_fi_tcl_AVMph3_SwitchDescriptor()
:Id()
,Status()
 {}

tS32 rvc_fi_tcl_AVMph3_SwitchDescriptor::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_AVMPH3_SWITCHDESCRIPTOR;
}


rvc_fi_tcl_AVMph3_SwitchDescriptor::~rvc_fi_tcl_AVMph3_SwitchDescriptor()
{}

tU32 rvc_fi_tcl_AVMph3_SwitchDescriptor::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_fi_tcl_AVMph3_SwitchDescriptor::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Id);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_AVMph3_SwitchDescriptor::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Id);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool rvc_fi_tcl_AVMph3_SwitchDescriptor::operator==(const rvc_fi_tcl_AVMph3_SwitchDescriptor& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Id == roRef.Id);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_AVMph3_DispStatus::rvc_fi_tcl_e8_AVMph3_DispStatus():enType(FI_EN_OTHERTHANCAMERA) {}

tS32 rvc_fi_tcl_e8_AVMph3_DispStatus::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_AVMPH3_DISPSTATUS;
}


rvc_fi_tcl_e8_AVMph3_DispStatus::~rvc_fi_tcl_e8_AVMph3_DispStatus()
{}

tU32 rvc_fi_tcl_e8_AVMph3_DispStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_AVMph3_DispStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_AVMph3_DispStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_AVMph3_ViewPattern::rvc_fi_tcl_e8_AVMph3_ViewPattern():enType(FI_EN_NONE) {}

tS32 rvc_fi_tcl_e8_AVMph3_ViewPattern::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_AVMPH3_VIEWPATTERN;
}


rvc_fi_tcl_e8_AVMph3_ViewPattern::~rvc_fi_tcl_e8_AVMph3_ViewPattern()
{}

tU32 rvc_fi_tcl_e8_AVMph3_ViewPattern::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_AVMph3_ViewPattern::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_AVMph3_ViewPattern::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_AVMph3_CautionId::rvc_fi_tcl_e8_AVMph3_CautionId():enType(FI_EN_NONE) {}

tS32 rvc_fi_tcl_e8_AVMph3_CautionId::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_AVMPH3_CAUTIONID;
}


rvc_fi_tcl_e8_AVMph3_CautionId::~rvc_fi_tcl_e8_AVMph3_CautionId()
{}

tU32 rvc_fi_tcl_e8_AVMph3_CautionId::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_AVMph3_CautionId::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_AVMph3_CautionId::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_AVMph3_IconId::rvc_fi_tcl_e8_AVMph3_IconId():enType(FI_EN_NONE) {}

tS32 rvc_fi_tcl_e8_AVMph3_IconId::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_AVMPH3_ICONID;
}


rvc_fi_tcl_e8_AVMph3_IconId::~rvc_fi_tcl_e8_AVMph3_IconId()
{}

tU32 rvc_fi_tcl_e8_AVMph3_IconId::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_AVMph3_IconId::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_AVMph3_IconId::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_AVMph3_BuzzerStatus::rvc_fi_tcl_e8_AVMph3_BuzzerStatus():enType(FI_EN_BUZZER_OFF) {}

tS32 rvc_fi_tcl_e8_AVMph3_BuzzerStatus::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_AVMPH3_BUZZERSTATUS;
}


rvc_fi_tcl_e8_AVMph3_BuzzerStatus::~rvc_fi_tcl_e8_AVMph3_BuzzerStatus()
{}

tU32 rvc_fi_tcl_e8_AVMph3_BuzzerStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_AVMph3_BuzzerStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_AVMph3_BuzzerStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_AVMph3_ErrorMessage::rvc_fi_tcl_e8_AVMph3_ErrorMessage():enType(FI_EN_NONE) {}

tS32 rvc_fi_tcl_e8_AVMph3_ErrorMessage::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_AVMPH3_ERRORMESSAGE;
}


rvc_fi_tcl_e8_AVMph3_ErrorMessage::~rvc_fi_tcl_e8_AVMph3_ErrorMessage()
{}

tU32 rvc_fi_tcl_e8_AVMph3_ErrorMessage::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_AVMph3_ErrorMessage::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_AVMph3_ErrorMessage::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_AVMph3_SettingItemId::rvc_fi_tcl_e8_AVMph3_SettingItemId():enType(FI_EN_VEHICLE_SPEED) {}

tS32 rvc_fi_tcl_e8_AVMph3_SettingItemId::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_AVMPH3_SETTINGITEMID;
}


rvc_fi_tcl_e8_AVMph3_SettingItemId::~rvc_fi_tcl_e8_AVMph3_SettingItemId()
{}

tU32 rvc_fi_tcl_e8_AVMph3_SettingItemId::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_AVMph3_SettingItemId::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_AVMph3_SettingItemId::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_fi_tcl_AVMph3_Setting_Item::rvc_fi_tcl_AVMph3_Setting_Item(const rvc_fi_tcl_AVMph3_Setting_Item& coRef)
   : rvc_fi_tclVisitableTypeBase(coRef)
{
   e8ItemId = coRef.e8ItemId;
   u8ItemState = coRef.u8ItemState;
}
rvc_fi_tcl_AVMph3_Setting_Item& rvc_fi_tcl_AVMph3_Setting_Item::operator=(const rvc_fi_tcl_AVMph3_Setting_Item& coRef)
{
   if (this == &coRef) return *this;
   e8ItemId = coRef.e8ItemId;
   u8ItemState = coRef.u8ItemState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_AVMph3_Setting_Item::rvc_fi_tcl_AVMph3_Setting_Item()
:e8ItemId()
,u8ItemState(0)
 {}

tS32 rvc_fi_tcl_AVMph3_Setting_Item::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_AVMPH3_SETTING_ITEM;
}


rvc_fi_tcl_AVMph3_Setting_Item::~rvc_fi_tcl_AVMph3_Setting_Item()
{}

tU32 rvc_fi_tcl_AVMph3_Setting_Item::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_fi_tcl_AVMph3_Setting_Item::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ItemId);
   (tVoid) (oIn >> u8ItemState);
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_AVMph3_Setting_Item::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ItemId);
   (tVoid) (oOut << u8ItemState);
   return oOut;
}

tBool rvc_fi_tcl_AVMph3_Setting_Item::operator==(const rvc_fi_tcl_AVMph3_Setting_Item& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ItemId == roRef.e8ItemId);
   bResult = bResult && (u8ItemState == roRef.u8ItemState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_AVMph3_SettingOptionState::rvc_fi_tcl_e8_AVMph3_SettingOptionState():enType(FI_EN_UNAVAIL) {}

tS32 rvc_fi_tcl_e8_AVMph3_SettingOptionState::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_AVMPH3_SETTINGOPTIONSTATE;
}


rvc_fi_tcl_e8_AVMph3_SettingOptionState::~rvc_fi_tcl_e8_AVMph3_SettingOptionState()
{}

tU32 rvc_fi_tcl_e8_AVMph3_SettingOptionState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_AVMph3_SettingOptionState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_AVMph3_SettingOptionState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_fi_tcl_AVMph3_Setting_Option::rvc_fi_tcl_AVMph3_Setting_Option(const rvc_fi_tcl_AVMph3_Setting_Option& coRef)
   : rvc_fi_tclVisitableTypeBase(coRef)
{
   e8ItemId = coRef.e8ItemId;
   e8ItemState = coRef.e8ItemState;
}
rvc_fi_tcl_AVMph3_Setting_Option& rvc_fi_tcl_AVMph3_Setting_Option::operator=(const rvc_fi_tcl_AVMph3_Setting_Option& coRef)
{
   if (this == &coRef) return *this;
   e8ItemId = coRef.e8ItemId;
   e8ItemState = coRef.e8ItemState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_AVMph3_Setting_Option::rvc_fi_tcl_AVMph3_Setting_Option()
:e8ItemId()
,e8ItemState()
 {}

tS32 rvc_fi_tcl_AVMph3_Setting_Option::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_AVMPH3_SETTING_OPTION;
}


rvc_fi_tcl_AVMph3_Setting_Option::~rvc_fi_tcl_AVMph3_Setting_Option()
{}

tU32 rvc_fi_tcl_AVMph3_Setting_Option::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_fi_tcl_AVMph3_Setting_Option::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ItemId);
   (tVoid) (oIn >> e8ItemState);
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_AVMph3_Setting_Option::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ItemId);
   (tVoid) (oOut << e8ItemState);
   return oOut;
}

tBool rvc_fi_tcl_AVMph3_Setting_Option::operator==(const rvc_fi_tcl_AVMph3_Setting_Option& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ItemId == roRef.e8ItemId);
   bResult = bResult && (e8ItemState == roRef.e8ItemState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_AVMph3_Setting_PrioView::rvc_fi_tcl_e8_AVMph3_Setting_PrioView():enType(FI_EN_UNAVAIL) {}

tS32 rvc_fi_tcl_e8_AVMph3_Setting_PrioView::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_AVMPH3_SETTING_PRIOVIEW;
}


rvc_fi_tcl_e8_AVMph3_Setting_PrioView::~rvc_fi_tcl_e8_AVMph3_Setting_PrioView()
{}

tU32 rvc_fi_tcl_e8_AVMph3_Setting_PrioView::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_AVMph3_Setting_PrioView::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_AVMph3_Setting_PrioView::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_AVMph3_Setting_PrioWide::rvc_fi_tcl_e8_AVMph3_Setting_PrioWide():enType(FI_EN_UNAVAIL) {}

tS32 rvc_fi_tcl_e8_AVMph3_Setting_PrioWide::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_AVMPH3_SETTING_PRIOWIDE;
}


rvc_fi_tcl_e8_AVMph3_Setting_PrioWide::~rvc_fi_tcl_e8_AVMph3_Setting_PrioWide()
{}

tU32 rvc_fi_tcl_e8_AVMph3_Setting_PrioWide::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_AVMph3_Setting_PrioWide::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_AVMph3_Setting_PrioWide::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_AVMph3_Setting_AutoCamPos::rvc_fi_tcl_e8_AVMph3_Setting_AutoCamPos():enType(FI_EN_UNAVAIL) {}

tS32 rvc_fi_tcl_e8_AVMph3_Setting_AutoCamPos::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_AVMPH3_SETTING_AUTOCAMPOS;
}


rvc_fi_tcl_e8_AVMph3_Setting_AutoCamPos::~rvc_fi_tcl_e8_AVMph3_Setting_AutoCamPos()
{}

tU32 rvc_fi_tcl_e8_AVMph3_Setting_AutoCamPos::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_AVMph3_Setting_AutoCamPos::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_AVMph3_Setting_AutoCamPos::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_AVMph3_CornerSonarSensLvl::rvc_fi_tcl_e8_AVMph3_CornerSonarSensLvl():enType(FI_EN_LEVEL1) {}

tS32 rvc_fi_tcl_e8_AVMph3_CornerSonarSensLvl::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_AVMPH3_CORNERSONARSENSLVL;
}


rvc_fi_tcl_e8_AVMph3_CornerSonarSensLvl::~rvc_fi_tcl_e8_AVMph3_CornerSonarSensLvl()
{}

tU32 rvc_fi_tcl_e8_AVMph3_CornerSonarSensLvl::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_AVMph3_CornerSonarSensLvl::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_AVMph3_CornerSonarSensLvl::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_fi_tcl_AVMph3_Setting_CornerSonarSensLvl::rvc_fi_tcl_AVMph3_Setting_CornerSonarSensLvl(const rvc_fi_tcl_AVMph3_Setting_CornerSonarSensLvl& coRef)
   : rvc_fi_tclVisitableTypeBase(coRef)
{
   bAvail = coRef.bAvail;
   e8Level = coRef.e8Level;
}
rvc_fi_tcl_AVMph3_Setting_CornerSonarSensLvl& rvc_fi_tcl_AVMph3_Setting_CornerSonarSensLvl::operator=(const rvc_fi_tcl_AVMph3_Setting_CornerSonarSensLvl& coRef)
{
   if (this == &coRef) return *this;
   bAvail = coRef.bAvail;
   e8Level = coRef.e8Level;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_AVMph3_Setting_CornerSonarSensLvl::rvc_fi_tcl_AVMph3_Setting_CornerSonarSensLvl()
:bAvail(0)
,e8Level()
 {}

tS32 rvc_fi_tcl_AVMph3_Setting_CornerSonarSensLvl::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_AVMPH3_SETTING_CORNERSONARSENSLVL;
}


rvc_fi_tcl_AVMph3_Setting_CornerSonarSensLvl::~rvc_fi_tcl_AVMph3_Setting_CornerSonarSensLvl()
{}

tU32 rvc_fi_tcl_AVMph3_Setting_CornerSonarSensLvl::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_fi_tcl_AVMph3_Setting_CornerSonarSensLvl::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bAvail);
   (tVoid) (oIn >> e8Level);
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_AVMph3_Setting_CornerSonarSensLvl::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bAvail);
   (tVoid) (oOut << e8Level);
   return oOut;
}

tBool rvc_fi_tcl_AVMph3_Setting_CornerSonarSensLvl::operator==(const rvc_fi_tcl_AVMph3_Setting_CornerSonarSensLvl& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bAvail == roRef.bAvail);
   bResult = bResult && (e8Level == roRef.e8Level);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_AVMph3_SonarSensLvl::rvc_fi_tcl_e8_AVMph3_SonarSensLvl():enType(FI_EN_UNDEFINED) {}

tS32 rvc_fi_tcl_e8_AVMph3_SonarSensLvl::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_AVMPH3_SONARSENSLVL;
}


rvc_fi_tcl_e8_AVMph3_SonarSensLvl::~rvc_fi_tcl_e8_AVMph3_SonarSensLvl()
{}

tU32 rvc_fi_tcl_e8_AVMph3_SonarSensLvl::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_AVMph3_SonarSensLvl::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_AVMph3_SonarSensLvl::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_fi_tcl_AVMph3_Setting_SonarSensLvl::rvc_fi_tcl_AVMph3_Setting_SonarSensLvl(const rvc_fi_tcl_AVMph3_Setting_SonarSensLvl& coRef)
   : rvc_fi_tclVisitableTypeBase(coRef)
{
   bAvail = coRef.bAvail;
   e8Level = coRef.e8Level;
}
rvc_fi_tcl_AVMph3_Setting_SonarSensLvl& rvc_fi_tcl_AVMph3_Setting_SonarSensLvl::operator=(const rvc_fi_tcl_AVMph3_Setting_SonarSensLvl& coRef)
{
   if (this == &coRef) return *this;
   bAvail = coRef.bAvail;
   e8Level = coRef.e8Level;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_AVMph3_Setting_SonarSensLvl::rvc_fi_tcl_AVMph3_Setting_SonarSensLvl()
:bAvail(0)
,e8Level()
 {}

tS32 rvc_fi_tcl_AVMph3_Setting_SonarSensLvl::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_AVMPH3_SETTING_SONARSENSLVL;
}


rvc_fi_tcl_AVMph3_Setting_SonarSensLvl::~rvc_fi_tcl_AVMph3_Setting_SonarSensLvl()
{}

tU32 rvc_fi_tcl_AVMph3_Setting_SonarSensLvl::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_fi_tcl_AVMph3_Setting_SonarSensLvl::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bAvail);
   (tVoid) (oIn >> e8Level);
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_AVMph3_Setting_SonarSensLvl::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bAvail);
   (tVoid) (oOut << e8Level);
   return oOut;
}

tBool rvc_fi_tcl_AVMph3_Setting_SonarSensLvl::operator==(const rvc_fi_tcl_AVMph3_Setting_SonarSensLvl& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bAvail == roRef.bAvail);
   bResult = bResult && (e8Level == roRef.e8Level);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_AVMph3_BuzzerSoundLvl::rvc_fi_tcl_e8_AVMph3_BuzzerSoundLvl():enType(FI_EN_UNDEFINED) {}

tS32 rvc_fi_tcl_e8_AVMph3_BuzzerSoundLvl::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_AVMPH3_BUZZERSOUNDLVL;
}


rvc_fi_tcl_e8_AVMph3_BuzzerSoundLvl::~rvc_fi_tcl_e8_AVMph3_BuzzerSoundLvl()
{}

tU32 rvc_fi_tcl_e8_AVMph3_BuzzerSoundLvl::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_AVMph3_BuzzerSoundLvl::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_AVMph3_BuzzerSoundLvl::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_fi_tcl_AVMph3_Setting_BuzzerSoundLvl::rvc_fi_tcl_AVMph3_Setting_BuzzerSoundLvl(const rvc_fi_tcl_AVMph3_Setting_BuzzerSoundLvl& coRef)
   : rvc_fi_tclVisitableTypeBase(coRef)
{
   bAvail = coRef.bAvail;
   e8Level = coRef.e8Level;
}
rvc_fi_tcl_AVMph3_Setting_BuzzerSoundLvl& rvc_fi_tcl_AVMph3_Setting_BuzzerSoundLvl::operator=(const rvc_fi_tcl_AVMph3_Setting_BuzzerSoundLvl& coRef)
{
   if (this == &coRef) return *this;
   bAvail = coRef.bAvail;
   e8Level = coRef.e8Level;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_AVMph3_Setting_BuzzerSoundLvl::rvc_fi_tcl_AVMph3_Setting_BuzzerSoundLvl()
:bAvail(0)
,e8Level()
 {}

tS32 rvc_fi_tcl_AVMph3_Setting_BuzzerSoundLvl::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_AVMPH3_SETTING_BUZZERSOUNDLVL;
}


rvc_fi_tcl_AVMph3_Setting_BuzzerSoundLvl::~rvc_fi_tcl_AVMph3_Setting_BuzzerSoundLvl()
{}

tU32 rvc_fi_tcl_AVMph3_Setting_BuzzerSoundLvl::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_fi_tcl_AVMph3_Setting_BuzzerSoundLvl::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bAvail);
   (tVoid) (oIn >> e8Level);
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_AVMph3_Setting_BuzzerSoundLvl::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bAvail);
   (tVoid) (oOut << e8Level);
   return oOut;
}

tBool rvc_fi_tcl_AVMph3_Setting_BuzzerSoundLvl::operator==(const rvc_fi_tcl_AVMph3_Setting_BuzzerSoundLvl& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bAvail == roRef.bAvail);
   bResult = bResult && (e8Level == roRef.e8Level);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_AVMph3_RequestType::rvc_fi_tcl_e8_AVMph3_RequestType():enType(FI_EN_GET) {}

tS32 rvc_fi_tcl_e8_AVMph3_RequestType::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_AVMPH3_REQUESTTYPE;
}


rvc_fi_tcl_e8_AVMph3_RequestType::~rvc_fi_tcl_e8_AVMph3_RequestType()
{}

tU32 rvc_fi_tcl_e8_AVMph3_RequestType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_AVMph3_RequestType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_AVMph3_RequestType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_AVMph3_VersionInfoType::rvc_fi_tcl_e8_AVMph3_VersionInfoType():enType(FI_EN_UNKNOWN) {}

tS32 rvc_fi_tcl_e8_AVMph3_VersionInfoType::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_AVMPH3_VERSIONINFOTYPE;
}


rvc_fi_tcl_e8_AVMph3_VersionInfoType::~rvc_fi_tcl_e8_AVMph3_VersionInfoType()
{}

tU32 rvc_fi_tcl_e8_AVMph3_VersionInfoType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_AVMph3_VersionInfoType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_AVMph3_VersionInfoType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_fi_tcl_AVMph3_VersionInfo::rvc_fi_tcl_AVMph3_VersionInfo(const rvc_fi_tcl_AVMph3_VersionInfo& coRef)
   : rvc_fi_tclVisitableTypeBase(coRef)
{
   u8Upper = coRef.u8Upper;
   u8Middle = coRef.u8Middle;
   u8Lower = coRef.u8Lower;
}
rvc_fi_tcl_AVMph3_VersionInfo& rvc_fi_tcl_AVMph3_VersionInfo::operator=(const rvc_fi_tcl_AVMph3_VersionInfo& coRef)
{
   if (this == &coRef) return *this;
   u8Upper = coRef.u8Upper;
   u8Middle = coRef.u8Middle;
   u8Lower = coRef.u8Lower;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_AVMph3_VersionInfo::rvc_fi_tcl_AVMph3_VersionInfo()
:u8Upper(0)
,u8Middle(0)
,u8Lower(0)
 {}

tS32 rvc_fi_tcl_AVMph3_VersionInfo::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_AVMPH3_VERSIONINFO;
}


rvc_fi_tcl_AVMph3_VersionInfo::~rvc_fi_tcl_AVMph3_VersionInfo()
{}

tU32 rvc_fi_tcl_AVMph3_VersionInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& rvc_fi_tcl_AVMph3_VersionInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Upper);
   (tVoid) (oIn >> u8Middle);
   (tVoid) (oIn >> u8Lower);
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_AVMph3_VersionInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Upper);
   (tVoid) (oOut << u8Middle);
   (tVoid) (oOut << u8Lower);
   return oOut;
}

tBool rvc_fi_tcl_AVMph3_VersionInfo::operator==(const rvc_fi_tcl_AVMph3_VersionInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Upper == roRef.u8Upper);
   bResult = bResult && (u8Middle == roRef.u8Middle);
   bResult = bResult && (u8Lower == roRef.u8Lower);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_AVMph3_ConfigurationStatus::rvc_fi_tcl_e8_AVMph3_ConfigurationStatus():enType(FI_EN_UNDEFINED) {}

tS32 rvc_fi_tcl_e8_AVMph3_ConfigurationStatus::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_AVMPH3_CONFIGURATIONSTATUS;
}


rvc_fi_tcl_e8_AVMph3_ConfigurationStatus::~rvc_fi_tcl_e8_AVMph3_ConfigurationStatus()
{}

tU32 rvc_fi_tcl_e8_AVMph3_ConfigurationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_AVMph3_ConfigurationStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_AVMph3_ConfigurationStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_e8_AVMph3_Variant::rvc_fi_tcl_e8_AVMph3_Variant():enType(FI_EN_VAR_06AVM) {}

tS32 rvc_fi_tcl_e8_AVMph3_Variant::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_E8_AVMPH3_VARIANT;
}


rvc_fi_tcl_e8_AVMph3_Variant::~rvc_fi_tcl_e8_AVMph3_Variant()
{}

tU32 rvc_fi_tcl_e8_AVMph3_Variant::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_fi_tcl_e8_AVMph3_Variant::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_e8_AVMph3_Variant::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_fi_tcl_AVMph3_Unit_ID::rvc_fi_tcl_AVMph3_Unit_ID(const rvc_fi_tcl_AVMph3_Unit_ID& coRef)
   : rvc_fi_tclVisitableTypeBase(coRef)
{
   u8Unit_ID = coRef.u8Unit_ID;
   e8Variant = coRef.e8Variant;
   bLeftHandDrive = coRef.bLeftHandDrive;
   bWithSonar = coRef.bWithSonar;
}
rvc_fi_tcl_AVMph3_Unit_ID& rvc_fi_tcl_AVMph3_Unit_ID::operator=(const rvc_fi_tcl_AVMph3_Unit_ID& coRef)
{
   if (this == &coRef) return *this;
   u8Unit_ID = coRef.u8Unit_ID;
   e8Variant = coRef.e8Variant;
   bLeftHandDrive = coRef.bLeftHandDrive;
   bWithSonar = coRef.bWithSonar;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_AVMph3_Unit_ID::rvc_fi_tcl_AVMph3_Unit_ID()
:u8Unit_ID(0)
,e8Variant()
,bLeftHandDrive(0)
,bWithSonar(0)
 {}

tS32 rvc_fi_tcl_AVMph3_Unit_ID::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_AVMPH3_UNIT_ID;
}


rvc_fi_tcl_AVMph3_Unit_ID::~rvc_fi_tcl_AVMph3_Unit_ID()
{}

tU32 rvc_fi_tcl_AVMph3_Unit_ID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& rvc_fi_tcl_AVMph3_Unit_ID::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Unit_ID);
   (tVoid) (oIn >> e8Variant);
   (tVoid) (oIn >> bLeftHandDrive);
   (tVoid) (oIn >> bWithSonar);
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_AVMph3_Unit_ID::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Unit_ID);
   (tVoid) (oOut << e8Variant);
   (tVoid) (oOut << bLeftHandDrive);
   (tVoid) (oOut << bWithSonar);
   return oOut;
}

tBool rvc_fi_tcl_AVMph3_Unit_ID::operator==(const rvc_fi_tcl_AVMph3_Unit_ID& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Unit_ID == roRef.u8Unit_ID);
   bResult = bResult && (e8Variant == roRef.e8Variant);
   bResult = bResult && (bLeftHandDrive == roRef.bLeftHandDrive);
   bResult = bResult && (bWithSonar == roRef.bWithSonar);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_fi_tcl_AVMph3_MCAN_CommunicationErrors::rvc_fi_tcl_AVMph3_MCAN_CommunicationErrors(const rvc_fi_tcl_AVMph3_MCAN_CommunicationErrors& coRef)
   : rvc_fi_tclVisitableTypeBase(coRef)
{
   u8BusOff = coRef.u8BusOff;
   u8TxCmfToMaster = coRef.u8TxCmfToMaster;
   u8RxCmfFromSonar = coRef.u8RxCmfFromSonar;
   u8TxMpdtToSonar = coRef.u8TxMpdtToSonar;
}
rvc_fi_tcl_AVMph3_MCAN_CommunicationErrors& rvc_fi_tcl_AVMph3_MCAN_CommunicationErrors::operator=(const rvc_fi_tcl_AVMph3_MCAN_CommunicationErrors& coRef)
{
   if (this == &coRef) return *this;
   u8BusOff = coRef.u8BusOff;
   u8TxCmfToMaster = coRef.u8TxCmfToMaster;
   u8RxCmfFromSonar = coRef.u8RxCmfFromSonar;
   u8TxMpdtToSonar = coRef.u8TxMpdtToSonar;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_fi_tcl_AVMph3_MCAN_CommunicationErrors::rvc_fi_tcl_AVMph3_MCAN_CommunicationErrors()
:u8BusOff(0)
,u8TxCmfToMaster(0)
,u8RxCmfFromSonar(0)
,u8TxMpdtToSonar(0)
 {}

tS32 rvc_fi_tcl_AVMph3_MCAN_CommunicationErrors::s32GetTypeId() const
{
   return (tS32) rvc_typesfi_tclToken::EN_AVMPH3_MCAN_COMMUNICATIONERRORS;
}


rvc_fi_tcl_AVMph3_MCAN_CommunicationErrors::~rvc_fi_tcl_AVMph3_MCAN_CommunicationErrors()
{}

tU32 rvc_fi_tcl_AVMph3_MCAN_CommunicationErrors::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& rvc_fi_tcl_AVMph3_MCAN_CommunicationErrors::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8BusOff);
   (tVoid) (oIn >> u8TxCmfToMaster);
   (tVoid) (oIn >> u8RxCmfFromSonar);
   (tVoid) (oIn >> u8TxMpdtToSonar);
   return oIn;
}

fi_tclOutContext& rvc_fi_tcl_AVMph3_MCAN_CommunicationErrors::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8BusOff);
   (tVoid) (oOut << u8TxCmfToMaster);
   (tVoid) (oOut << u8RxCmfFromSonar);
   (tVoid) (oOut << u8TxMpdtToSonar);
   return oOut;
}

tBool rvc_fi_tcl_AVMph3_MCAN_CommunicationErrors::operator==(const rvc_fi_tcl_AVMph3_MCAN_CommunicationErrors& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8BusOff == roRef.u8BusOff);
   bResult = bResult && (u8TxCmfToMaster == roRef.u8TxCmfToMaster);
   bResult = bResult && (u8RxCmfFromSonar == roRef.u8RxCmfFromSonar);
   bResult = bResult && (u8TxMpdtToSonar == roRef.u8TxMpdtToSonar);
   return bResult;
}

