#ifndef RVC_FIVISITOR_HEADER
#define RVC_FIVISITOR_HEADER

// --Basisklasse fuer eine FI-Besucher-Klasse

class rvc_fi_tclOutput {
public:
   rvc_fi_tclOutput();
   virtual ~rvc_fi_tclOutput(){};

   virtual tVoid vPrintLine(tCString coszLine) = 0;
};

class rvc_fi_tclFileOutput : public rvc_fi_tclOutput 
{
public:
   rvc_fi_tclFileOutput(OSAL_tIODescriptor rIOD):fd(rIOD) {}
   virtual tVoid vPrintLine(tCString coszLine);
protected:
   OSAL_tIODescriptor fd;
private:
   rvc_fi_tclFileOutput(); //lint !e1704
   rvc_fi_tclFileOutput& operator=(const rvc_fi_tclFileOutput& coRef);
   rvc_fi_tclFileOutput(const rvc_fi_tclFileOutput& coRef); //lint !e1704
};

class rvc_fi_tclMemOutput : public rvc_fi_tclOutput
{
public:
   rvc_fi_tclMemOutput(tU32 u32MemSize);
   virtual ~rvc_fi_tclMemOutput();
   virtual tVoid vPrintLine(tCString coszLine);
   tString szGetBuffer();
protected:
   tChar* szBuf;
   tChar* szEndBuf;
   tChar* s8BufPos;
private:
   rvc_fi_tclMemOutput(); //lint !e1704
   rvc_fi_tclMemOutput(const rvc_fi_tclMemOutput& coRef); //lint !e1704
   rvc_fi_tclMemOutput& operator=(const rvc_fi_tclMemOutput& coRef); //lint !e1704
};

class MY_DECL rvc_fi_tclVisitorBase {
public:

   // --Konstruktor
   rvc_fi_tclVisitorBase():bBreakNow(FALSE),bIsVisitorValid(FALSE) {}
   virtual ~rvc_fi_tclVisitorBase() {}

   tBool bIsValid() const { return bIsVisitorValid; }
   tVoid vInvalidate() { bIsVisitorValid=FALSE; }
   tVoid vValidate() { bIsVisitorValid=TRUE; }
   tBool bBreak() const { return bBreakNow; }
   tVoid vReleaseBreak() { bBreakNow = FALSE; }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(rvc_fi_tclU8& oU8);
   virtual tVoid vVisitS8(rvc_fi_tclS8& oS8);
   virtual tVoid vVisitU16(rvc_fi_tclU16& oU16);
   virtual tVoid vVisitS16(rvc_fi_tclS16& oS16);
   virtual tVoid vVisitU24(rvc_fi_tclU24& oU24);
   virtual tVoid vVisitS24(rvc_fi_tclS24& oS24);
   virtual tVoid vVisitU32(rvc_fi_tclU32& oU32);
   virtual tVoid vVisitS32(rvc_fi_tclS32& oS32);
   virtual tVoid vVisitU64(rvc_fi_tclU64& oU64);
   virtual tVoid vVisitS64(rvc_fi_tclS64& oS64);
   virtual tVoid vVisitF32(rvc_fi_tclF32& oF32);
   virtual tVoid vVisitF64(rvc_fi_tclF64& oF64);
   virtual tVoid vVisitBool(rvc_fi_tclBool& oBool);
   virtual tVoid vVisitString(rvc_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(rvc_fi_tclMultiLanguageString& oString);

   virtual tVoid vVisitList(rvc_fi_tclList& oList);
   virtual tVoid vVisit_BinContainer(rvc_fi_tcl_BinContainer& oBinContainer);

   virtual tVoid vVisit_Reserved(rvc_fi_tcl_Reserved& oReserved);

   virtual tVoid vVisit_u8_Percent(rvc_fi_tcl_u8_Percent& ou8_Percent);

   virtual tVoid vVisit_s16_PerThousand(rvc_fi_tcl_s16_PerThousand& os16_PerThousand);

   virtual tVoid vVisit_u16_IndexInReferenceList(rvc_fi_tcl_u16_IndexInReferenceList& ou16_IndexInReferenceList);

   virtual tVoid vVisit_u16_ErrorCode(rvc_fi_tcl_u16_ErrorCode& ou16_ErrorCode);

   virtual tVoid vVisit_u16_RPM(rvc_fi_tcl_u16_RPM& ou16_RPM);

   virtual tVoid vVisit_s32_Kilogram(rvc_fi_tcl_s32_Kilogram& os32_Kilogram);

   virtual tVoid vVisit_s32_Pound(rvc_fi_tcl_s32_Pound& os32_Pound);

   virtual tVoid vVisit_s16_Meter(rvc_fi_tcl_s16_Meter& os16_Meter);

   virtual tVoid vVisit_s32_Meter(rvc_fi_tcl_s32_Meter& os32_Meter);

   virtual tVoid vVisit_s32_Yards(rvc_fi_tcl_s32_Yards& os32_Yards);

   virtual tVoid vVisit_s32_Foot(rvc_fi_tcl_s32_Foot& os32_Foot);

   virtual tVoid vVisit_s32_Centimeter(rvc_fi_tcl_s32_Centimeter& os32_Centimeter);

   virtual tVoid vVisit_s32_Inch(rvc_fi_tcl_s32_Inch& os32_Inch);

   virtual tVoid vVisit_s32_Millimeter(rvc_fi_tcl_s32_Millimeter& os32_Millimeter);

   virtual tVoid vVisit_s32_Microliter(rvc_fi_tcl_s32_Microliter& os32_Microliter);

   virtual tVoid vVisit_s32_Second(rvc_fi_tcl_s32_Second& os32_Second);

   virtual tVoid vVisit_u16_MilliSecond(rvc_fi_tcl_u16_MilliSecond& ou16_MilliSecond);

   virtual tVoid vVisit_s32_MilliSecond(rvc_fi_tcl_s32_MilliSecond& os32_MilliSecond);

   virtual tVoid vVisit_POSIXTime(rvc_fi_tcl_POSIXTime& oPOSIXTime);

   virtual tVoid vVisit_e8_DST_State(rvc_fi_tcl_e8_DST_State& oe8_DST_State);

   virtual tVoid vVisit_TimeZoneElement(rvc_fi_tcl_TimeZoneElement& oTimeZoneElement);

   virtual tVoid vVisit_s16_KmPerHour(rvc_fi_tcl_s16_KmPerHour& os16_KmPerHour);

   virtual tVoid vVisit_s16_MilesPerHour(rvc_fi_tcl_s16_MilesPerHour& os16_MilesPerHour);

   virtual tVoid vVisit_s16_Knot(rvc_fi_tcl_s16_Knot& os16_Knot);

   virtual tVoid vVisit_s16_CentimeterSecond(rvc_fi_tcl_s16_CentimeterSecond& os16_CentimeterSecond);

   virtual tVoid vVisit_s16_Kelvin(rvc_fi_tcl_s16_Kelvin& os16_Kelvin);

   virtual tVoid vVisit_s16_Fahrenheit(rvc_fi_tcl_s16_Fahrenheit& os16_Fahrenheit);

   virtual tVoid vVisit_s32_Pascal(rvc_fi_tcl_s32_Pascal& os32_Pascal);

   virtual tVoid vVisit_s32_Watt(rvc_fi_tcl_s32_Watt& os32_Watt);

   virtual tVoid vVisit_FIVersion(rvc_fi_tcl_FIVersion& oFIVersion);

   virtual tVoid vVisit_s32_Longitude(rvc_fi_tcl_s32_Longitude& os32_Longitude);

   virtual tVoid vVisit_s32_Latitude(rvc_fi_tcl_s32_Latitude& os32_Latitude);

   virtual tVoid vVisit_PositionWGS84(rvc_fi_tcl_PositionWGS84& oPositionWGS84);

   virtual tVoid vVisit_RectangleWGS84(rvc_fi_tcl_RectangleWGS84& oRectangleWGS84);

   virtual tVoid vVisit_e16_ISOCountryCode(rvc_fi_tcl_e16_ISOCountryCode& oe16_ISOCountryCode);

   virtual tVoid vVisit_e16_ISOLanguageCode(rvc_fi_tcl_e16_ISOLanguageCode& oe16_ISOLanguageCode);

   virtual tVoid vVisit_LanguageID(rvc_fi_tcl_LanguageID& oLanguageID);

   virtual tVoid vVisit_u8_DirectionAbsolute(rvc_fi_tcl_u8_DirectionAbsolute& ou8_DirectionAbsolute);

   virtual tVoid vVisit_u8_DirectionRelative(rvc_fi_tcl_u8_DirectionRelative& ou8_DirectionRelative);

   virtual tVoid vVisit_s16_CentiDegree(rvc_fi_tcl_s16_CentiDegree& os16_CentiDegree);

   virtual tVoid vVisit_s16_Degree(rvc_fi_tcl_s16_Degree& os16_Degree);

   virtual tVoid vVisit_u16_DirectionAbsolute_CentiDegree(rvc_fi_tcl_u16_DirectionAbsolute_CentiDegree& ou16_DirectionAbsolute_CentiDegree);

   virtual tVoid vVisit_s16_DirectionRelative_CentiDegree(rvc_fi_tcl_s16_DirectionRelative_CentiDegree& os16_DirectionRelative_CentiDegree);

   virtual tVoid vVisit_e8_FuelType(rvc_fi_tcl_e8_FuelType& oe8_FuelType);

   virtual tVoid vVisit_DistTimeFuel(rvc_fi_tcl_DistTimeFuel& oDistTimeFuel);

   virtual tVoid vVisit_e8_RVC_CCAError(rvc_fi_tcl_e8_RVC_CCAError& oe8_RVC_CCAError);

   virtual tVoid vVisit_e8_RVC_Camera_System_Type(rvc_fi_tcl_e8_RVC_Camera_System_Type& oe8_RVC_Camera_System_Type);

   virtual tVoid vVisit_e8_RVC_SignalStatus(rvc_fi_tcl_e8_RVC_SignalStatus& oe8_RVC_SignalStatus);

   virtual tVoid vVisit_e8_RVC_SystemStatus(rvc_fi_tcl_e8_RVC_SystemStatus& oe8_RVC_SystemStatus);

   virtual tVoid vVisit_e8_RVC_StatusGuideLine(rvc_fi_tcl_e8_RVC_StatusGuideLine& oe8_RVC_StatusGuideLine);

   virtual tVoid vVisit_e8_RVC_StatusWarningText(rvc_fi_tcl_e8_RVC_StatusWarningText& oe8_RVC_StatusWarningText);

   virtual tVoid vVisit_e8_RVC_Status(rvc_fi_tcl_e8_RVC_Status& oe8_RVC_Status);

   virtual tVoid vVisit_e8_RVC_ButtonState(rvc_fi_tcl_e8_RVC_ButtonState& oe8_RVC_ButtonState);

   virtual tVoid vVisit_e8_RVC_Language(rvc_fi_tcl_e8_RVC_Language& oe8_RVC_Language);

   virtual tVoid vVisit_e8_AVM_StatusBeep(rvc_fi_tcl_e8_AVM_StatusBeep& oe8_AVM_StatusBeep);

   virtual tVoid vVisit_e8_AffordableIts_Status(rvc_fi_tcl_e8_AffordableIts_Status& oe8_AffordableIts_Status);

   virtual tVoid vVisit_e8_RVC_VideoParameterType(rvc_fi_tcl_e8_RVC_VideoParameterType& oe8_RVC_VideoParameterType);

   virtual tVoid vVisit_e8_RVC_VideoParameterDimmingMode(rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode& oe8_RVC_VideoParameterDimmingMode);

   virtual tVoid vVisit_e8_AffordableIts_StatusFeature(rvc_fi_tcl_e8_AffordableIts_StatusFeature& oe8_AffordableIts_StatusFeature);

   virtual tVoid vVisit_e8_Exit_Authorized(rvc_fi_tcl_e8_Exit_Authorized& oe8_Exit_Authorized);

   virtual tVoid vVisit_RVC_VideoAnalogLevels(rvc_fi_tcl_RVC_VideoAnalogLevels& oRVC_VideoAnalogLevels);

   virtual tVoid vVisit_e8_RVC_CameraState(rvc_fi_tcl_e8_RVC_CameraState& oe8_RVC_CameraState);

   virtual tVoid vVisit_e8_IPA_BUTTON_ID(rvc_fi_tcl_e8_IPA_BUTTON_ID& oe8_IPA_BUTTON_ID);

   virtual tVoid vVisit_e8_IPA_PatternID(rvc_fi_tcl_e8_IPA_PatternID& oe8_IPA_PatternID);

   virtual tVoid vVisit_e8_IPA_MessageID(rvc_fi_tcl_e8_IPA_MessageID& oe8_IPA_MessageID);

   virtual tVoid vVisit_e8_IPA_OperationStatus(rvc_fi_tcl_e8_IPA_OperationStatus& oe8_IPA_OperationStatus);

   virtual tVoid vVisit_e8_IPA_ModeChangeRequest(rvc_fi_tcl_e8_IPA_ModeChangeRequest& oe8_IPA_ModeChangeRequest);

   virtual tVoid vVisit_e8_IPA_HMIStatus(rvc_fi_tcl_e8_IPA_HMIStatus& oe8_IPA_HMIStatus);

   virtual tVoid vVisit_e8_IPA_RegionalSelection(rvc_fi_tcl_e8_IPA_RegionalSelection& oe8_IPA_RegionalSelection);

   virtual tVoid vVisit_e8_IPA_AvailabilityStatus(rvc_fi_tcl_e8_IPA_AvailabilityStatus& oe8_IPA_AvailabilityStatus);

   virtual tVoid vVisit_e8_IPA_SwitchMask(rvc_fi_tcl_e8_IPA_SwitchMask& oe8_IPA_SwitchMask);

   virtual tVoid vVisit_e8_Set_MicState(rvc_fi_tcl_e8_Set_MicState& oe8_Set_MicState);

   virtual tVoid vVisit_e8_IPA_DirectionIndicator(rvc_fi_tcl_e8_IPA_DirectionIndicator& oe8_IPA_DirectionIndicator);

   virtual tVoid vVisit_e8_IPA_VoiceText(rvc_fi_tcl_e8_IPA_VoiceText& oe8_IPA_VoiceText);

   virtual tVoid vVisit_IPA_Voice_Text_Strings(rvc_fi_tcl_IPA_Voice_Text_Strings& oIPA_Voice_Text_Strings);

   virtual tVoid vVisit_e8_Camera_PowerSupplyStatus(rvc_fi_tcl_e8_Camera_PowerSupplyStatus& oe8_Camera_PowerSupplyStatus);

   virtual tVoid vVisit_e8_Microphone_PowerSupplyStatus(rvc_fi_tcl_e8_Microphone_PowerSupplyStatus& oe8_Microphone_PowerSupplyStatus);

   virtual tVoid vVisit_e8_RVC_Module(rvc_fi_tcl_e8_RVC_Module& oe8_RVC_Module);

   virtual tVoid vVisit_e8_RVC_ReverseSignalStatus(rvc_fi_tcl_e8_RVC_ReverseSignalStatus& oe8_RVC_ReverseSignalStatus);

   virtual tVoid vVisit_e8_ParkAssist_UserConfigurationType(rvc_fi_tcl_e8_ParkAssist_UserConfigurationType& oe8_ParkAssist_UserConfigurationType);

   virtual tVoid vVisit_e8_ParkAssist_UserConfigurationMode(rvc_fi_tcl_e8_ParkAssist_UserConfigurationMode& oe8_ParkAssist_UserConfigurationMode);

   virtual tVoid vVisit_ParkAssist_UserConfiguration(rvc_fi_tcl_ParkAssist_UserConfiguration& oParkAssist_UserConfiguration);

   virtual tVoid vVisit_e8_GdlAdj_AdjustButton(rvc_fi_tcl_e8_GdlAdj_AdjustButton& oe8_GdlAdj_AdjustButton);

   virtual tVoid vVisit_e8_GdlAdj_Completion(rvc_fi_tcl_e8_GdlAdj_Completion& oe8_GdlAdj_Completion);

   virtual tVoid vVisit_e8_GdlAdj_Request(rvc_fi_tcl_e8_GdlAdj_Request& oe8_GdlAdj_Request);

   virtual tVoid vVisit_e8_GdlAdj_ConfigurationItem(rvc_fi_tcl_e8_GdlAdj_ConfigurationItem& oe8_GdlAdj_ConfigurationItem);

   virtual tVoid vVisit_GdlAdj_ConfigParameterData(rvc_fi_tcl_GdlAdj_ConfigParameterData& oGdlAdj_ConfigParameterData);

   virtual tVoid vVisit_e8_MVCViewingState(rvc_fi_tcl_e8_MVCViewingState& oe8_MVCViewingState);

   virtual tVoid vVisit_e8_AVM_View_Request(rvc_fi_tcl_e8_AVM_View_Request& oe8_AVM_View_Request);

   virtual tVoid vVisit_e8_AVM_View_Status(rvc_fi_tcl_e8_AVM_View_Status& oe8_AVM_View_Status);

   virtual tVoid vVisit_e8_Tailgate_State(rvc_fi_tcl_e8_Tailgate_State& oe8_Tailgate_State);

   virtual tVoid vVisit_e8_TouchGesture(rvc_fi_tcl_e8_TouchGesture& oe8_TouchGesture);

   virtual tVoid vVisit_e8_Direction(rvc_fi_tcl_e8_Direction& oe8_Direction);

   virtual tVoid vVisit_e8_FAP_SettingItem(rvc_fi_tcl_e8_FAP_SettingItem& oe8_FAP_SettingItem);

   virtual tVoid vVisit_e8_AVM_FAP_SettingState(rvc_fi_tcl_e8_AVM_FAP_SettingState& oe8_AVM_FAP_SettingState);

   virtual tVoid vVisit_e8_AVM_SettingItem(rvc_fi_tcl_e8_AVM_SettingItem& oe8_AVM_SettingItem);

   virtual tVoid vVisit_FAP_Settings_State(rvc_fi_tcl_FAP_Settings_State& oFAP_Settings_State);

   virtual tVoid vVisit_AVM_Settings_State(rvc_fi_tcl_AVM_Settings_State& oAVM_Settings_State);

   virtual tVoid vVisit_GPS_Data(rvc_fi_tcl_GPS_Data& oGPS_Data);

   virtual tVoid vVisit_MapMatched_Data(rvc_fi_tcl_MapMatched_Data& oMapMatched_Data);

   virtual tVoid vVisit_Touch_Data(rvc_fi_tcl_Touch_Data& oTouch_Data);

   virtual tVoid vVisit_e8_AVMph3_SwitchId(rvc_fi_tcl_e8_AVMph3_SwitchId& oe8_AVMph3_SwitchId);

   virtual tVoid vVisit_e8_AVMph3_SwitchStatus(rvc_fi_tcl_e8_AVMph3_SwitchStatus& oe8_AVMph3_SwitchStatus);

   virtual tVoid vVisit_AVMph3_SwitchDescriptor(rvc_fi_tcl_AVMph3_SwitchDescriptor& oAVMph3_SwitchDescriptor);

   virtual tVoid vVisit_e8_AVMph3_DispStatus(rvc_fi_tcl_e8_AVMph3_DispStatus& oe8_AVMph3_DispStatus);

   virtual tVoid vVisit_e8_AVMph3_ViewPattern(rvc_fi_tcl_e8_AVMph3_ViewPattern& oe8_AVMph3_ViewPattern);

   virtual tVoid vVisit_e8_AVMph3_CautionId(rvc_fi_tcl_e8_AVMph3_CautionId& oe8_AVMph3_CautionId);

   virtual tVoid vVisit_e8_AVMph3_IconId(rvc_fi_tcl_e8_AVMph3_IconId& oe8_AVMph3_IconId);

   virtual tVoid vVisit_e8_AVMph3_BuzzerStatus(rvc_fi_tcl_e8_AVMph3_BuzzerStatus& oe8_AVMph3_BuzzerStatus);

   virtual tVoid vVisit_e8_AVMph3_ErrorMessage(rvc_fi_tcl_e8_AVMph3_ErrorMessage& oe8_AVMph3_ErrorMessage);

   virtual tVoid vVisit_e8_AVMph3_SettingItemId(rvc_fi_tcl_e8_AVMph3_SettingItemId& oe8_AVMph3_SettingItemId);

   virtual tVoid vVisit_AVMph3_Setting_Item(rvc_fi_tcl_AVMph3_Setting_Item& oAVMph3_Setting_Item);

   virtual tVoid vVisit_e8_AVMph3_SettingOptionState(rvc_fi_tcl_e8_AVMph3_SettingOptionState& oe8_AVMph3_SettingOptionState);

   virtual tVoid vVisit_AVMph3_Setting_Option(rvc_fi_tcl_AVMph3_Setting_Option& oAVMph3_Setting_Option);

   virtual tVoid vVisit_e8_AVMph3_Setting_PrioView(rvc_fi_tcl_e8_AVMph3_Setting_PrioView& oe8_AVMph3_Setting_PrioView);

   virtual tVoid vVisit_e8_AVMph3_Setting_PrioWide(rvc_fi_tcl_e8_AVMph3_Setting_PrioWide& oe8_AVMph3_Setting_PrioWide);

   virtual tVoid vVisit_e8_AVMph3_Setting_AutoCamPos(rvc_fi_tcl_e8_AVMph3_Setting_AutoCamPos& oe8_AVMph3_Setting_AutoCamPos);

   virtual tVoid vVisit_e8_AVMph3_CornerSonarSensLvl(rvc_fi_tcl_e8_AVMph3_CornerSonarSensLvl& oe8_AVMph3_CornerSonarSensLvl);

   virtual tVoid vVisit_AVMph3_Setting_CornerSonarSensLvl(rvc_fi_tcl_AVMph3_Setting_CornerSonarSensLvl& oAVMph3_Setting_CornerSonarSensLvl);

   virtual tVoid vVisit_e8_AVMph3_SonarSensLvl(rvc_fi_tcl_e8_AVMph3_SonarSensLvl& oe8_AVMph3_SonarSensLvl);

   virtual tVoid vVisit_AVMph3_Setting_SonarSensLvl(rvc_fi_tcl_AVMph3_Setting_SonarSensLvl& oAVMph3_Setting_SonarSensLvl);

   virtual tVoid vVisit_e8_AVMph3_BuzzerSoundLvl(rvc_fi_tcl_e8_AVMph3_BuzzerSoundLvl& oe8_AVMph3_BuzzerSoundLvl);

   virtual tVoid vVisit_AVMph3_Setting_BuzzerSoundLvl(rvc_fi_tcl_AVMph3_Setting_BuzzerSoundLvl& oAVMph3_Setting_BuzzerSoundLvl);

   virtual tVoid vVisit_e8_AVMph3_RequestType(rvc_fi_tcl_e8_AVMph3_RequestType& oe8_AVMph3_RequestType);

   virtual tVoid vVisit_e8_AVMph3_VersionInfoType(rvc_fi_tcl_e8_AVMph3_VersionInfoType& oe8_AVMph3_VersionInfoType);

   virtual tVoid vVisit_AVMph3_VersionInfo(rvc_fi_tcl_AVMph3_VersionInfo& oAVMph3_VersionInfo);

   virtual tVoid vVisit_e8_AVMph3_ConfigurationStatus(rvc_fi_tcl_e8_AVMph3_ConfigurationStatus& oe8_AVMph3_ConfigurationStatus);

   virtual tVoid vVisit_e8_AVMph3_Variant(rvc_fi_tcl_e8_AVMph3_Variant& oe8_AVMph3_Variant);

   virtual tVoid vVisit_AVMph3_Unit_ID(rvc_fi_tcl_AVMph3_Unit_ID& oAVMph3_Unit_ID);

   virtual tVoid vVisit_AVMph3_MCAN_CommunicationErrors(rvc_fi_tcl_AVMph3_MCAN_CommunicationErrors& oAVMph3_MCAN_CommunicationErrors);


 	fi_tclTraversePath<fi_tclKnot>::tclIterator oIterator;		
	
protected:
	tBool bBreakNow;
	tBool bIsVisitorValid;
private:

};

#endif
