#ifndef RVC_CCAFILANGUAGE_HEADER
#define RVC_CCAFILANGUAGE_HEADER

class rvc_ccafi_tclInContext;
class rvc_ccafi_tclOutContext;
class rvc_ccafi_tclVisitorBase;

class MY_DECL rvc_ccafi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  rvc_ccafi_tclDescription(fi_tclInContext* poIn, rvc_ccafi_tclVisitorBase* poVisit);
  rvc_ccafi_tclDescription(fi_tclOutContext* poOut, rvc_ccafi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(rvc_ccafi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(rvc_fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ rvc_ccafi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  rvc_ccafi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<rvc_ccafi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<rvc_ccafi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline rvc_ccafi_tclDescription::rvc_ccafi_tclDescription(fi_tclInContext* poIn, rvc_ccafi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline rvc_ccafi_tclDescription::rvc_ccafi_tclDescription(fi_tclOutContext* poOut, rvc_ccafi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

