#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define RVC_FI_S_IMPORT_INTERFACE_RVC_CCAFI_STDVISITORS
#include "rvc_fi_if.h"

tBool rvc_ccafi_tclDescription::bInitMessage(rvc_ccafi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case rvc_ccafi_tclToken::EN_LAST_TOKEN:
   case rvc_ccafi_tclToken::EN_LIST:
   case rvc_ccafi_tclToken::EN_END_OF_STRUCT:
   case rvc_ccafi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case rvc_ccafi_tclToken::EN_MSG_CAMERABUTTONMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_RVC_BUTTONSTATE,rvc_ccafi_tclSemanticDomain::EN_MSG_E8BUTTONSTATE)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_CAMERABUTTONMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_SETSTATUSHMIMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_RVC_STATUS,rvc_ccafi_tclSemanticDomain::EN_MSG_E8STATUSHMI)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_SETSTATUSHMIMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_RVC_SYSTEMSTATUS,rvc_ccafi_tclSemanticDomain::EN_MSG_E8SYSTEMSTATUS)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_SETUPLANGUAGEMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_RVC_LANGUAGE,rvc_ccafi_tclSemanticDomain::EN_MSG_E8LANGUAGE)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_SETUPLANGUAGEMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_SETUPGUIDELINEMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_RVC_STATUSGUIDELINE,rvc_ccafi_tclSemanticDomain::EN_MSG_E8GUIDELINE)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_SETUPGUIDELINEMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_SETUPVIDEOCONTROLSMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_MVCVIEWINGSTATE,rvc_ccafi_tclSemanticDomain::EN_MSG_E8MVCVIEWINGSTATE)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_RVC_VIDEOANALOGLEVELS,rvc_ccafi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_LIST,rvc_ccafi_tclSemanticDomain::EN_MSG_ARVIDEOCONTROLPARAMETER)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_RVC_VIDEOPARAMETERDIMMINGMODE,rvc_ccafi_tclSemanticDomain::EN_MSG_E8HMIDIMMINGMODE)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_SETUPVIDEOCONTROLSMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_SETSYSTEMSTATUSMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_RVC_STATUSWARNINGTEXT,rvc_ccafi_tclSemanticDomain::EN_MSG_E8WARNINGTEXT)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_RVC_STATUSGUIDELINE,rvc_ccafi_tclSemanticDomain::EN_MSG_E8GUIDELINE)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_RVC_SYSTEMSTATUS,rvc_ccafi_tclSemanticDomain::EN_MSG_E8SYSTEMSTATUS)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_SETSYSTEMSTATUSMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_RUNEXTDEVICEPOWERSUPPLYTESTMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U16,rvc_ccafi_tclSemanticDomain::EN_MSG_PWRSUPPLYID)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_RUNEXTDEVICEPOWERSUPPLYTESTMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U32,rvc_ccafi_tclSemanticDomain::EN_MSG_CURRENT)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_CAMERA_POWERSUPPLYSTATUS,rvc_ccafi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U16,rvc_ccafi_tclSemanticDomain::EN_MSG_PWRSUPPLYID)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_INITIALIZEMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_RVC_MODULE,rvc_ccafi_tclSemanticDomain::EN_MSG_E8MODULE)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_INITIALIZEMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_CONFIRMSYSTEMSTATUSMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_RVC_SYSTEMSTATUS,rvc_ccafi_tclSemanticDomain::EN_MSG_E8SYSTEMSTATUS)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_CONFIRMSYSTEMSTATUSMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_SETUPUSERCONFIGURATIONMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_PARKASSIST_USERCONFIGURATION,rvc_ccafi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_LIST,rvc_ccafi_tclSemanticDomain::EN_MSG_ARUSERCONFIGURATION)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_SETUPUSERCONFIGURATIONMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_SETMICROPHONESTATEMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_SET_MICSTATE,rvc_ccafi_tclSemanticDomain::EN_MSG_E8REQUESTSTATE)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_SETMICROPHONESTATEMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_SETRVCSTATUSMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U8,rvc_ccafi_tclSemanticDomain::EN_MSG_E8REQUESTSTATE)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_SETRVCSTATUSMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_CAMERA_SETUPBEEPMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVM_STATUSBEEP,rvc_ccafi_tclSemanticDomain::EN_MSG_E8SETUPBEEP)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_CAMERA_SETUPBEEPMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVM_STATUSBEEP,rvc_ccafi_tclSemanticDomain::EN_MSG_E8STATUSBEEP)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_SETCAMERASTATEMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_RVC_CAMERASTATE,rvc_ccafi_tclSemanticDomain::EN_MSG_CAMERASTATE)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_SETCAMERASTATEMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_CHANGEVIEWREQUESTMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVM_VIEW_REQUEST,rvc_ccafi_tclSemanticDomain::EN_MSG_U8STATUS)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_CHANGEVIEWREQUESTMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITS_SETUPBSWMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U8,rvc_ccafi_tclSemanticDomain::EN_MSG_U8STATUS)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITS_SETUPBSWMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITS_SETUPMODMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U8,rvc_ccafi_tclSemanticDomain::EN_MSG_U8STATUS)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITS_SETUPMODMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITS_SETUPLDWMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U8,rvc_ccafi_tclSemanticDomain::EN_MSG_U8STATUS)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITS_SETUPLDWMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_IPA_SETHMISTATUSMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_IPA_HMISTATUS,rvc_ccafi_tclSemanticDomain::EN_MSG_E8IPASTATUS)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_IPA_SETHMISTATUSMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_IPA_SETBUTTONMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_RVC_BUTTONSTATE,rvc_ccafi_tclSemanticDomain::EN_MSG_E8BUTTONSTATUS)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_IPA_BUTTON_ID,rvc_ccafi_tclSemanticDomain::EN_MSG_E8BUTTONIDENTIFIER)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_IPA_SETBUTTONMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_IPA_VOICE_TEXTSMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_RVC_LANGUAGE,rvc_ccafi_tclSemanticDomain::EN_MSG_LANGUAGE)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_IPA_VOICE_TEXT_STRINGS,rvc_ccafi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_LIST,rvc_ccafi_tclSemanticDomain::EN_MSG_ARTEXTS)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_IPA_VOICE_TEXTSMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_MVC_HMI_VIEWREQUESTMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_MVCVIEWINGSTATE,rvc_ccafi_tclSemanticDomain::EN_MSG_E8REQUEST)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_MVC_HMI_VIEWREQUESTMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_GDLADJ_ADJUSTMENTCOMPLETEMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_GDLADJ_COMPLETION,rvc_ccafi_tclSemanticDomain::EN_MSG_E8COMPLETION)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_GDLADJ_ADJUSTMENTCOMPLETEMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_GDLADJ_ADJUSTBUTTONMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_GDLADJ_ADJUSTBUTTON,rvc_ccafi_tclSemanticDomain::EN_MSG_E8BUTTON)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_GDLADJ_ADJUSTBUTTONMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_GDLADJ_CONFIGURATIONDATAMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_GDLADJ_CONFIGPARAMETERDATA,rvc_ccafi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_LIST,rvc_ccafi_tclSemanticDomain::EN_MSG_ARCONFIGPARAMETERDATA)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_GDLADJ_REQUEST,rvc_ccafi_tclSemanticDomain::EN_MSG_E8REQUEST)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_GDLADJ_CONFIGURATIONDATAMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_GDLADJ_CONFIGPARAMETERDATA,rvc_ccafi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_LIST,rvc_ccafi_tclSemanticDomain::EN_MSG_ARCONFIGPARAMETERDATA)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_GDLADJ_REQUEST,rvc_ccafi_tclSemanticDomain::EN_MSG_E8REQUEST)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_FAP_SETBUTTONMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_RVC_BUTTONSTATE,rvc_ccafi_tclSemanticDomain::EN_MSG_E8BUTTONSTATUS)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_IPA_BUTTON_ID,rvc_ccafi_tclSemanticDomain::EN_MSG_E8BUTTONIDENTIFIER)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_FAP_SETBUTTONMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_TOUCHEVENTMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_TOUCH_DATA,rvc_ccafi_tclSemanticDomain::EN_MSG_ARTOUCHDATA)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_TOUCHEVENTMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_GPSINFOMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_GPS_DATA,rvc_ccafi_tclSemanticDomain::EN_MSG_ARGPSDATA)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_GPSINFOMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_MAPMATCHEDINFOMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_MAPMATCHED_DATA,rvc_ccafi_tclSemanticDomain::EN_MSG_ARMAPMATCHEDDATA)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_MAPMATCHEDINFOMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_FAPLEARNPARKPOSITIONMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_REQUESTON)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_FAPLEARNPARKPOSITIONMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_SETFAPGUIDANCEMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_REQUEST)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_SETFAPGUIDANCEMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AVM3_SETSWITCHMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVMPH3_SWITCHID,rvc_ccafi_tclSemanticDomain::EN_MSG_E8SWITCHID)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AVM3_SETSWITCHMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_BRESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AVM3_SETSONARBUZZERSTATUSMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVMPH3_BUZZERSTATUS,rvc_ccafi_tclSemanticDomain::EN_MSG_E8BUZZERSTATUS)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AVM3_SETSONARBUZZERSTATUSMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_BRESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_DETAILED_SENDREQMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_AVMPH3_SETTING_ITEM,rvc_ccafi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_LIST,rvc_ccafi_tclSemanticDomain::EN_MSG_ARCHANGEDITEMS)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVMPH3_REQUESTTYPE,rvc_ccafi_tclSemanticDomain::EN_MSG_E8REQUESTTYPE)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_DETAILED_SENDREQMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_BRESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_PRIMARY_SENDREQMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_BIMAGEQUALITYSETTINGAVAIL)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_BDETAILSSETTINGSAVAIL)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVMPH3_SETTINGOPTIONSTATE,rvc_ccafi_tclSemanticDomain::EN_MSG_E8AVMSONARBUZZER)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVMPH3_REQUESTTYPE,rvc_ccafi_tclSemanticDomain::EN_MSG_E8REQUESTTYPE)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_PRIMARY_SENDREQMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_BRESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AVM3_GETVERSIONINFOMETHODSTART:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVMPH3_VERSIONINFOTYPE,rvc_ccafi_tclSemanticDomain::EN_MSG_E8VERSIONTYPE)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AVM3_GETVERSIONINFOMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_BRESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AVM3_GETCOMMUNICATIONERRORSMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_BRESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AVM3_CLEARCOMMUNICATIONERRORSMETHODRESULT:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_BRESULT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_SYSTEMCONFIGURATIONSSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U8,rvc_ccafi_tclSemanticDomain::EN_MSG_U8BRIGHTNESS)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U8,rvc_ccafi_tclSemanticDomain::EN_MSG_U8RVCGUIDELINE)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_RVC_CAMERA_SYSTEM_TYPE,rvc_ccafi_tclSemanticDomain::EN_MSG_E8CAMERASYSTEM)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_SYSTEMSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_RVC_SYSTEMSTATUS,rvc_ccafi_tclSemanticDomain::EN_MSG_E8SYSTEMSTATUS)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_VIDEOSIGNALSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_RVC_SIGNALSTATUS,rvc_ccafi_tclSemanticDomain::EN_MSG_E8STATUSVIDEOSIGNAL)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_REVERSESIGNALSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_RVC_REVERSESIGNALSTATUS,rvc_ccafi_tclSemanticDomain::EN_MSG_E8STATUSREVERSESIGNAL)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_CAMERA_PWRSUPPLYSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U32,rvc_ccafi_tclSemanticDomain::EN_MSG_CURRENT)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_CAMERA_POWERSUPPLYSTATUS,rvc_ccafi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U16,rvc_ccafi_tclSemanticDomain::EN_MSG_PWRSUPPLYID)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_MICROPHONE_PWRSUPPLYSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U32,rvc_ccafi_tclSemanticDomain::EN_MSG_CURRENT)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_MICROPHONE_POWERSUPPLYSTATUS,rvc_ccafi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U16,rvc_ccafi_tclSemanticDomain::EN_MSG_PWRSUPPLYID)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_TAILGATE_STATUSSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_TAILGATE_STATE,rvc_ccafi_tclSemanticDomain::EN_MSG_STATE)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_VIEW_CLOSE_AUTHORIZEDSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_EXIT_AUTHORIZED,rvc_ccafi_tclSemanticDomain::EN_MSG_E8ALLOWED)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AVMR_CURRENT_VIEWSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVM_VIEW_STATUS,rvc_ccafi_tclSemanticDomain::EN_MSG_E8VIEW)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITSSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AFFORDABLEITS_STATUSFEATURE,rvc_ccafi_tclSemanticDomain::EN_MSG_E8LDWSTATUS)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AFFORDABLEITS_STATUSFEATURE,rvc_ccafi_tclSemanticDomain::EN_MSG_E8MODSTATUS)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AFFORDABLEITS_STATUSFEATURE,rvc_ccafi_tclSemanticDomain::EN_MSG_E8BSWSTATUS)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AFFORDABLEITS_STATUS,rvc_ccafi_tclSemanticDomain::EN_MSG_E8AFFORDABLEITSAVAILABLE)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_IPACONFIGURATIONSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_IPA_REGIONALSELECTION,rvc_ccafi_tclSemanticDomain::EN_MSG_E8REGIONALSELECTION)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_IPA_AVAILABILITYSTATUS,rvc_ccafi_tclSemanticDomain::EN_MSG_E8AVAILABILITYSTATUS)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_IPASTATUSSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_IPA_MODECHANGEREQUEST,rvc_ccafi_tclSemanticDomain::EN_MSG_E8REQUEST)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_IPA_OPERATIONSTATUS,rvc_ccafi_tclSemanticDomain::EN_MSG_E8OPERATIONSTATUS)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_IPAPATTERNREQUESTSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_IPA_PATTERNID,rvc_ccafi_tclSemanticDomain::EN_MSG_E8DISPLAYPATTERN)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_IPAMESSAGEREQUESTSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_IPA_MESSAGEID,rvc_ccafi_tclSemanticDomain::EN_MSG_E8MESSAGEID)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_IPASWITCHMASKREQUESTSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_IPA_SWITCHMASK,rvc_ccafi_tclSemanticDomain::EN_MSG_E8SWITCHMASK)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_IPASWITCHGREYOUTREQUESTSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U8,rvc_ccafi_tclSemanticDomain::EN_MSG_U8SWITCHGREYOUT)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_IPADIRECTIONINDICATORSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_IPA_DIRECTIONINDICATOR,rvc_ccafi_tclSemanticDomain::EN_MSG_E8DIRECTION)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_GDLADJ_STEERINGANGLESTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_STRING,rvc_ccafi_tclSemanticDomain::EN_MSG_STEERINGANGLESIGNALSTATE)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_S32,rvc_ccafi_tclSemanticDomain::EN_MSG_S32STEERINGANGLECENTREADJUSTED)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U8,rvc_ccafi_tclSemanticDomain::EN_MSG_U8CENTREADJUSTMENTSTATE)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_BSHOWVALUES)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_GDLADJ_CAMERAANGLESTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_F32,rvc_ccafi_tclSemanticDomain::EN_MSG_F32CAMERAPITCHANGLE)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_F32,rvc_ccafi_tclSemanticDomain::EN_MSG_F32CAMERAYAWANGLE)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_F32,rvc_ccafi_tclSemanticDomain::EN_MSG_F32CAMERAROLLANGLE)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_CANFRAMESTATUSSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_RVC_SIGNALSTATUS,rvc_ccafi_tclSemanticDomain::EN_MSG_E8STATUSCANFRAME)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_MVCVIEWSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_MVCVIEWINGSTATE,rvc_ccafi_tclSemanticDomain::EN_MSG_E8VIEW)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_MVCALERTREQUESTSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_BREQUEST)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_FAPMODESTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_E8STATE)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_FAPSETTINGSSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_AVM_SETTINGS_STATE,rvc_ccafi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_LIST,rvc_ccafi_tclSemanticDomain::EN_MSG_ARAVMSETTINGSTATE)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_FAP_SETTINGS_STATE,rvc_ccafi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_LIST,rvc_ccafi_tclSemanticDomain::EN_MSG_ARFAPSETTINGSTATE)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_FAPGUIDANCESTATESTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_E8STATE)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AVM3_DISPSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVMPH3_DISPSTATUS,rvc_ccafi_tclSemanticDomain::EN_MSG_E8DISPSTATUS)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AVM3_VIEWSETUPSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVMPH3_BUZZERSTATUS,rvc_ccafi_tclSemanticDomain::EN_MSG_E8BUZZERSTATUS)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVMPH3_ICONID,rvc_ccafi_tclSemanticDomain::EN_MSG_E8ICONID)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_AVMPH3_SWITCHDESCRIPTOR,rvc_ccafi_tclSemanticDomain::EN_MSG_SWITCH8)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_AVMPH3_SWITCHDESCRIPTOR,rvc_ccafi_tclSemanticDomain::EN_MSG_SWITCH7)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_AVMPH3_SWITCHDESCRIPTOR,rvc_ccafi_tclSemanticDomain::EN_MSG_SWITCH6)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_AVMPH3_SWITCHDESCRIPTOR,rvc_ccafi_tclSemanticDomain::EN_MSG_SWITCH5)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_AVMPH3_SWITCHDESCRIPTOR,rvc_ccafi_tclSemanticDomain::EN_MSG_SWITCH4)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_AVMPH3_SWITCHDESCRIPTOR,rvc_ccafi_tclSemanticDomain::EN_MSG_SWITCH3)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_AVMPH3_SWITCHDESCRIPTOR,rvc_ccafi_tclSemanticDomain::EN_MSG_SWITCH2)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_AVMPH3_SWITCHDESCRIPTOR,rvc_ccafi_tclSemanticDomain::EN_MSG_SWITCH1)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVMPH3_CAUTIONID,rvc_ccafi_tclSemanticDomain::EN_MSG_E8CAUTIONID)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVMPH3_VIEWPATTERN,rvc_ccafi_tclSemanticDomain::EN_MSG_E8VIEWPATTERN)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AVM3_ERRORMESSAGESTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVMPH3_ERRORMESSAGE,rvc_ccafi_tclSemanticDomain::EN_MSG_E8ERRORMESSAGE)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AVM3_SONARBUZZERSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVMPH3_BUZZERSTATUS,rvc_ccafi_tclSemanticDomain::EN_MSG_E8BUZZERSTATUS)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_DETAILEDSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_AVMPH3_SETTING_BUZZERSOUNDLVL,rvc_ccafi_tclSemanticDomain::EN_MSG_RBUZZERSOUNDLVL)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_AVMPH3_SETTING_SONARSENSLVL,rvc_ccafi_tclSemanticDomain::EN_MSG_RSONARSENSLVL)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_AVMPH3_SETTING_CORNERSONARSENSLVL,rvc_ccafi_tclSemanticDomain::EN_MSG_RCORNERSONARSENSLVL)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVMPH3_SETTING_AUTOCAMPOS,rvc_ccafi_tclSemanticDomain::EN_MSG_E8AUTOCAMPOS)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVMPH3_SETTING_PRIOWIDE,rvc_ccafi_tclSemanticDomain::EN_MSG_E8PRIORITYWIDE)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVMPH3_SETTING_PRIOVIEW,rvc_ccafi_tclSemanticDomain::EN_MSG_E8PRIORITYVIEW)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_AVMPH3_SETTING_OPTION,rvc_ccafi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_LIST,rvc_ccafi_tclSemanticDomain::EN_MSG_ARSETTINGSOPTION)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_PRIMARYSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_BIMAGEQUALITYSETTINGAVAIL)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_MSG_BDETAILSSETTINGSAVAIL)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVMPH3_SETTINGOPTIONSTATE,rvc_ccafi_tclSemanticDomain::EN_MSG_E8AVMSONARBUZZER)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AVM3_CONFIGURATIONSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_AVMPH3_VERSIONINFO,rvc_ccafi_tclSemanticDomain::EN_MSG_RMSGSETVERSION)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_AVMPH3_UNIT_ID,rvc_ccafi_tclSemanticDomain::EN_MSG_RUNIT_ID)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVMPH3_CONFIGURATIONSTATUS,rvc_ccafi_tclSemanticDomain::EN_MSG_E8CONFIGSTATUS)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AVM3_SOFTWARE_VERSIONSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_AVMPH3_VERSIONINFO,rvc_ccafi_tclSemanticDomain::EN_MSG_RSW_VERSION_SONAR)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_AVMPH3_VERSIONINFO,rvc_ccafi_tclSemanticDomain::EN_MSG_RSW_VERSION_AVM)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AVM3_HARDWARE_VERSIONSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_AVMPH3_VERSIONINFO,rvc_ccafi_tclSemanticDomain::EN_MSG_RHW_VERSION_SONAR)) && bResult;
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_AVMPH3_VERSIONINFO,rvc_ccafi_tclSemanticDomain::EN_MSG_RHW_VERSION_AVM)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AVM3_COMMUNICATIONERRORSSTATUS:
   {
      bResult = oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_AVMPH3_MCAN_COMMUNICATIONERRORS,rvc_ccafi_tclSemanticDomain::EN_MSG_RCOMMERRORS)) && bResult;
   } break;
   case rvc_ccafi_tclToken::EN_MSG_AVM3_GETCOMMUNICATIONERRORSMETHODSTART:
   case rvc_ccafi_tclToken::EN_MSG_AVM3_CLEARCOMMUNICATIONERRORSMETHODSTART:
   case rvc_ccafi_tclToken::EN_MSG_TOGGLEGPIOPINONOFFMETHODSTART:
   case rvc_ccafi_tclToken::EN_MSG_TOGGLEGPIOPINONOFFMETHODRESULT:
   case rvc_ccafi_tclToken::EN_MSG_SYSTEMCONFIGURATIONSUPREG:
   case rvc_ccafi_tclToken::EN_MSG_SYSTEMCONFIGURATIONSRELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_SYSTEMSTATUSUPREG:
   case rvc_ccafi_tclToken::EN_MSG_SYSTEMSTATUSRELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_VIDEOSIGNALSTATUSUPREG:
   case rvc_ccafi_tclToken::EN_MSG_VIDEOSIGNALSTATUSRELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_REVERSESIGNALSTATUSUPREG:
   case rvc_ccafi_tclToken::EN_MSG_REVERSESIGNALSTATUSRELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_CAMERA_PWRSUPPLYSTATUSUPREG:
   case rvc_ccafi_tclToken::EN_MSG_CAMERA_PWRSUPPLYSTATUSRELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_CAMERA_PWRSUPPLYSTATUSGET:
   case rvc_ccafi_tclToken::EN_MSG_MICROPHONE_PWRSUPPLYSTATUSUPREG:
   case rvc_ccafi_tclToken::EN_MSG_MICROPHONE_PWRSUPPLYSTATUSRELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_MICROPHONE_PWRSUPPLYSTATUSGET:
   case rvc_ccafi_tclToken::EN_MSG_TAILGATE_STATUSUPREG:
   case rvc_ccafi_tclToken::EN_MSG_TAILGATE_STATUSRELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_TAILGATE_STATUSGET:
   case rvc_ccafi_tclToken::EN_MSG_VIEW_CLOSE_AUTHORIZEDUPREG:
   case rvc_ccafi_tclToken::EN_MSG_VIEW_CLOSE_AUTHORIZEDRELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_AVMR_CURRENT_VIEWUPREG:
   case rvc_ccafi_tclToken::EN_MSG_AVMR_CURRENT_VIEWRELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITSUPREG:
   case rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITSRELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_IPACONFIGURATIONUPREG:
   case rvc_ccafi_tclToken::EN_MSG_IPACONFIGURATIONRELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_IPASTATUSUPREG:
   case rvc_ccafi_tclToken::EN_MSG_IPASTATUSRELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_IPAPATTERNREQUESTUPREG:
   case rvc_ccafi_tclToken::EN_MSG_IPAPATTERNREQUESTRELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_IPAMESSAGEREQUESTUPREG:
   case rvc_ccafi_tclToken::EN_MSG_IPAMESSAGEREQUESTRELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_IPASWITCHMASKREQUESTUPREG:
   case rvc_ccafi_tclToken::EN_MSG_IPASWITCHMASKREQUESTRELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_IPASWITCHGREYOUTREQUESTUPREG:
   case rvc_ccafi_tclToken::EN_MSG_IPASWITCHGREYOUTREQUESTRELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_IPADIRECTIONINDICATORUPREG:
   case rvc_ccafi_tclToken::EN_MSG_IPADIRECTIONINDICATORRELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_GDLADJ_STEERINGANGLEUPREG:
   case rvc_ccafi_tclToken::EN_MSG_GDLADJ_STEERINGANGLERELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_GDLADJ_CAMERAANGLEUPREG:
   case rvc_ccafi_tclToken::EN_MSG_GDLADJ_CAMERAANGLERELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_CANFRAMESTATUSUPREG:
   case rvc_ccafi_tclToken::EN_MSG_CANFRAMESTATUSRELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_MVCVIEWSTATUSUPREG:
   case rvc_ccafi_tclToken::EN_MSG_MVCVIEWSTATUSRELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_MVCALERTREQUESTUPREG:
   case rvc_ccafi_tclToken::EN_MSG_MVCALERTREQUESTRELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_FAPMODEUPREG:
   case rvc_ccafi_tclToken::EN_MSG_FAPMODERELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_FAPSETTINGSUPREG:
   case rvc_ccafi_tclToken::EN_MSG_FAPSETTINGSRELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_FAPGUIDANCESTATEUPREG:
   case rvc_ccafi_tclToken::EN_MSG_FAPGUIDANCESTATERELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_AVM3_DISPSTATUSUPREG:
   case rvc_ccafi_tclToken::EN_MSG_AVM3_DISPSTATUSRELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_AVM3_VIEWSETUPUPREG:
   case rvc_ccafi_tclToken::EN_MSG_AVM3_VIEWSETUPRELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_AVM3_ERRORMESSAGEUPREG:
   case rvc_ccafi_tclToken::EN_MSG_AVM3_ERRORMESSAGERELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_AVM3_SONARBUZZERSTATUSUPREG:
   case rvc_ccafi_tclToken::EN_MSG_AVM3_SONARBUZZERSTATUSRELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_DETAILEDUPREG:
   case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_DETAILEDRELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_PRIMARYUPREG:
   case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_PRIMARYRELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_AVM3_CONFIGURATIONUPREG:
   case rvc_ccafi_tclToken::EN_MSG_AVM3_CONFIGURATIONRELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_AVM3_SOFTWARE_VERSIONUPREG:
   case rvc_ccafi_tclToken::EN_MSG_AVM3_SOFTWARE_VERSIONRELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_AVM3_HARDWARE_VERSIONUPREG:
   case rvc_ccafi_tclToken::EN_MSG_AVM3_HARDWARE_VERSIONRELUPREG:
   case rvc_ccafi_tclToken::EN_MSG_AVM3_COMMUNICATIONERRORSUPREG:
   case rvc_ccafi_tclToken::EN_MSG_AVM3_COMMUNICATIONERRORSRELUPREG:
   case rvc_ccafi_tclToken::EN_BINCONTAINER:
   case rvc_ccafi_tclToken::EN_E8_RVC_CAMERA_SYSTEM_TYPE:
   case rvc_ccafi_tclToken::EN_E8_RVC_SIGNALSTATUS:
   case rvc_ccafi_tclToken::EN_E8_RVC_SYSTEMSTATUS:
   case rvc_ccafi_tclToken::EN_E8_RVC_STATUSGUIDELINE:
   case rvc_ccafi_tclToken::EN_E8_RVC_STATUSWARNINGTEXT:
   case rvc_ccafi_tclToken::EN_E8_RVC_STATUS:
   case rvc_ccafi_tclToken::EN_E8_RVC_BUTTONSTATE:
   case rvc_ccafi_tclToken::EN_E8_RVC_LANGUAGE:
   case rvc_ccafi_tclToken::EN_E8_AVM_STATUSBEEP:
   case rvc_ccafi_tclToken::EN_E8_AFFORDABLEITS_STATUS:
   case rvc_ccafi_tclToken::EN_E8_RVC_VIDEOPARAMETERTYPE:
   case rvc_ccafi_tclToken::EN_E8_RVC_VIDEOPARAMETERDIMMINGMODE:
   case rvc_ccafi_tclToken::EN_E8_AFFORDABLEITS_STATUSFEATURE:
   case rvc_ccafi_tclToken::EN_E8_EXIT_AUTHORIZED:
   case rvc_ccafi_tclToken::EN_RVC_VIDEOANALOGLEVELS:
   case rvc_ccafi_tclToken::EN_E8_RVC_CAMERASTATE:
   case rvc_ccafi_tclToken::EN_E8_IPA_BUTTON_ID:
   case rvc_ccafi_tclToken::EN_E8_IPA_PATTERNID:
   case rvc_ccafi_tclToken::EN_E8_IPA_MESSAGEID:
   case rvc_ccafi_tclToken::EN_E8_IPA_OPERATIONSTATUS:
   case rvc_ccafi_tclToken::EN_E8_IPA_MODECHANGEREQUEST:
   case rvc_ccafi_tclToken::EN_E8_IPA_HMISTATUS:
   case rvc_ccafi_tclToken::EN_E8_IPA_REGIONALSELECTION:
   case rvc_ccafi_tclToken::EN_E8_IPA_AVAILABILITYSTATUS:
   case rvc_ccafi_tclToken::EN_E8_IPA_SWITCHMASK:
   case rvc_ccafi_tclToken::EN_E8_SET_MICSTATE:
   case rvc_ccafi_tclToken::EN_E8_IPA_DIRECTIONINDICATOR:
   case rvc_ccafi_tclToken::EN_E8_IPA_VOICETEXT:
   case rvc_ccafi_tclToken::EN_IPA_VOICE_TEXT_STRINGS:
   case rvc_ccafi_tclToken::EN_E8_CAMERA_POWERSUPPLYSTATUS:
   case rvc_ccafi_tclToken::EN_E8_MICROPHONE_POWERSUPPLYSTATUS:
   case rvc_ccafi_tclToken::EN_E8_RVC_MODULE:
   case rvc_ccafi_tclToken::EN_E8_RVC_REVERSESIGNALSTATUS:
   case rvc_ccafi_tclToken::EN_E8_PARKASSIST_USERCONFIGURATIONTYPE:
   case rvc_ccafi_tclToken::EN_E8_PARKASSIST_USERCONFIGURATIONMODE:
   case rvc_ccafi_tclToken::EN_PARKASSIST_USERCONFIGURATION:
   case rvc_ccafi_tclToken::EN_E8_GDLADJ_ADJUSTBUTTON:
   case rvc_ccafi_tclToken::EN_E8_GDLADJ_COMPLETION:
   case rvc_ccafi_tclToken::EN_E8_GDLADJ_REQUEST:
   case rvc_ccafi_tclToken::EN_E8_GDLADJ_CONFIGURATIONITEM:
   case rvc_ccafi_tclToken::EN_GDLADJ_CONFIGPARAMETERDATA:
   case rvc_ccafi_tclToken::EN_E8_MVCVIEWINGSTATE:
   case rvc_ccafi_tclToken::EN_E8_AVM_VIEW_REQUEST:
   case rvc_ccafi_tclToken::EN_E8_AVM_VIEW_STATUS:
   case rvc_ccafi_tclToken::EN_E8_TAILGATE_STATE:
   case rvc_ccafi_tclToken::EN_E8_TOUCHGESTURE:
   case rvc_ccafi_tclToken::EN_E8_DIRECTION:
   case rvc_ccafi_tclToken::EN_E8_FAP_SETTINGITEM:
   case rvc_ccafi_tclToken::EN_E8_AVM_FAP_SETTINGSTATE:
   case rvc_ccafi_tclToken::EN_E8_AVM_SETTINGITEM:
   case rvc_ccafi_tclToken::EN_FAP_SETTINGS_STATE:
   case rvc_ccafi_tclToken::EN_AVM_SETTINGS_STATE:
   case rvc_ccafi_tclToken::EN_GPS_DATA:
   case rvc_ccafi_tclToken::EN_MAPMATCHED_DATA:
   case rvc_ccafi_tclToken::EN_TOUCH_DATA:
   case rvc_ccafi_tclToken::EN_E8_AVMPH3_SWITCHID:
   case rvc_ccafi_tclToken::EN_E8_AVMPH3_SWITCHSTATUS:
   case rvc_ccafi_tclToken::EN_AVMPH3_SWITCHDESCRIPTOR:
   case rvc_ccafi_tclToken::EN_E8_AVMPH3_DISPSTATUS:
   case rvc_ccafi_tclToken::EN_E8_AVMPH3_VIEWPATTERN:
   case rvc_ccafi_tclToken::EN_E8_AVMPH3_CAUTIONID:
   case rvc_ccafi_tclToken::EN_E8_AVMPH3_ICONID:
   case rvc_ccafi_tclToken::EN_E8_AVMPH3_BUZZERSTATUS:
   case rvc_ccafi_tclToken::EN_E8_AVMPH3_ERRORMESSAGE:
   case rvc_ccafi_tclToken::EN_E8_AVMPH3_SETTINGITEMID:
   case rvc_ccafi_tclToken::EN_AVMPH3_SETTING_ITEM:
   case rvc_ccafi_tclToken::EN_E8_AVMPH3_SETTINGOPTIONSTATE:
   case rvc_ccafi_tclToken::EN_AVMPH3_SETTING_OPTION:
   case rvc_ccafi_tclToken::EN_E8_AVMPH3_SETTING_PRIOVIEW:
   case rvc_ccafi_tclToken::EN_E8_AVMPH3_SETTING_PRIOWIDE:
   case rvc_ccafi_tclToken::EN_E8_AVMPH3_SETTING_AUTOCAMPOS:
   case rvc_ccafi_tclToken::EN_E8_AVMPH3_CORNERSONARSENSLVL:
   case rvc_ccafi_tclToken::EN_AVMPH3_SETTING_CORNERSONARSENSLVL:
   case rvc_ccafi_tclToken::EN_E8_AVMPH3_SONARSENSLVL:
   case rvc_ccafi_tclToken::EN_AVMPH3_SETTING_SONARSENSLVL:
   case rvc_ccafi_tclToken::EN_E8_AVMPH3_BUZZERSOUNDLVL:
   case rvc_ccafi_tclToken::EN_AVMPH3_SETTING_BUZZERSOUNDLVL:
   case rvc_ccafi_tclToken::EN_E8_AVMPH3_REQUESTTYPE:
   case rvc_ccafi_tclToken::EN_E8_AVMPH3_VERSIONINFOTYPE:
   case rvc_ccafi_tclToken::EN_AVMPH3_VERSIONINFO:
   case rvc_ccafi_tclToken::EN_E8_AVMPH3_CONFIGURATIONSTATUS:
   case rvc_ccafi_tclToken::EN_E8_AVMPH3_VARIANT:
   case rvc_ccafi_tclToken::EN_AVMPH3_UNIT_ID:
   case rvc_ccafi_tclToken::EN_AVMPH3_MCAN_COMMUNICATIONERRORS:
   case rvc_ccafi_tclToken::EN_U8:   
   case rvc_ccafi_tclToken::EN_S8:   
   case rvc_ccafi_tclToken::EN_U16:   
   case rvc_ccafi_tclToken::EN_S16:   
   case rvc_ccafi_tclToken::EN_U24:   
   case rvc_ccafi_tclToken::EN_S24:   
   case rvc_ccafi_tclToken::EN_U32:   
   case rvc_ccafi_tclToken::EN_S32:   
   case rvc_ccafi_tclToken::EN_U64:   
   case rvc_ccafi_tclToken::EN_S64:   
   case rvc_ccafi_tclToken::EN_F32:   
   case rvc_ccafi_tclToken::EN_F64:   
   case rvc_ccafi_tclToken::EN_BOOL:   
   case rvc_ccafi_tclToken::EN_STRING:   
   case rvc_ccafi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(enMsgToken,rvc_ccafi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool rvc_ccafi_tclDescription::bDoIt(rvc_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool rvc_ccafi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      rvc_ccafi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      rvc_ccafi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      rvc_ccafi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == rvc_ccafi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(rvc_ccafi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case rvc_ccafi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == rvc_ccafi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_LIST: 
      {
         rvc_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            rvc_ccafi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            rvc_ccafi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case rvc_ccafi_tclToken::EN_U8: 
      {
         rvc_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case rvc_ccafi_tclToken::EN_U16: 
      {
         rvc_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_U24: 
      {
         rvc_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_U32: 
      {
         rvc_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_U64: 
      {
         rvc_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_S8: 
      {
         rvc_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_S16: 
      {
         rvc_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_S24: 
      {
         rvc_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_S32: 
      {
         rvc_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_S64: 
      {
         rvc_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_F32: 
      {
         rvc_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_F64: 
      {
         rvc_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_BOOL: 
      {
         rvc_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_STRING: 
      {
         rvc_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         rvc_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case rvc_ccafi_tclToken::EN_MSG_CAMERABUTTONMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_CAMERABUTTONMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_SETSTATUSHMIMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_SETSTATUSHMIMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_SETUPLANGUAGEMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_SETUPLANGUAGEMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_SETUPGUIDELINEMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_SETUPGUIDELINEMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_SETUPVIDEOCONTROLSMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_SETUPVIDEOCONTROLSMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_SETSYSTEMSTATUSMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_SETSYSTEMSTATUSMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_RUNEXTDEVICEPOWERSUPPLYTESTMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_RUNEXTDEVICEPOWERSUPPLYTESTMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_INITIALIZEMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_INITIALIZEMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_CONFIRMSYSTEMSTATUSMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_CONFIRMSYSTEMSTATUSMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_SETUPUSERCONFIGURATIONMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_SETUPUSERCONFIGURATIONMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_SETMICROPHONESTATEMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_SETMICROPHONESTATEMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_SETRVCSTATUSMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_SETRVCSTATUSMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_CAMERA_SETUPBEEPMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_CAMERA_SETUPBEEPMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_SETCAMERASTATEMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_SETCAMERASTATEMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_CHANGEVIEWREQUESTMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_CHANGEVIEWREQUESTMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITS_SETUPBSWMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITS_SETUPBSWMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITS_SETUPMODMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITS_SETUPMODMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITS_SETUPLDWMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITS_SETUPLDWMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_IPA_SETHMISTATUSMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_IPA_SETHMISTATUSMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_IPA_SETBUTTONMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_IPA_SETBUTTONMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_IPA_VOICE_TEXTSMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_IPA_VOICE_TEXTSMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_MVC_HMI_VIEWREQUESTMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_MVC_HMI_VIEWREQUESTMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_GDLADJ_ADJUSTMENTCOMPLETEMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_GDLADJ_ADJUSTMENTCOMPLETEMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_GDLADJ_ADJUSTBUTTONMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_GDLADJ_ADJUSTBUTTONMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_GDLADJ_CONFIGURATIONDATAMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_GDLADJ_CONFIGURATIONDATAMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_FAP_SETBUTTONMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_FAP_SETBUTTONMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_TOUCHEVENTMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_TOUCHEVENTMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_GPSINFOMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_GPSINFOMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_MAPMATCHEDINFOMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_MAPMATCHEDINFOMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_FAPLEARNPARKPOSITIONMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_FAPLEARNPARKPOSITIONMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_SETFAPGUIDANCEMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_SETFAPGUIDANCEMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_SETSWITCHMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_SETSWITCHMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_SETSONARBUZZERSTATUSMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_SETSONARBUZZERSTATUSMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_DETAILED_SENDREQMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_DETAILED_SENDREQMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_PRIMARY_SENDREQMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_PRIMARY_SENDREQMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_GETVERSIONINFOMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_GETVERSIONINFOMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_GETCOMMUNICATIONERRORSMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_GETCOMMUNICATIONERRORSMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_CLEARCOMMUNICATIONERRORSMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_CLEARCOMMUNICATIONERRORSMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_TOGGLEGPIOPINONOFFMETHODSTART:
      case rvc_ccafi_tclToken::EN_MSG_TOGGLEGPIOPINONOFFMETHODRESULT:
      case rvc_ccafi_tclToken::EN_MSG_SYSTEMCONFIGURATIONSUPREG:
      case rvc_ccafi_tclToken::EN_MSG_SYSTEMCONFIGURATIONSRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_SYSTEMCONFIGURATIONSSTATUS:
      case rvc_ccafi_tclToken::EN_MSG_SYSTEMSTATUSUPREG:
      case rvc_ccafi_tclToken::EN_MSG_SYSTEMSTATUSRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_SYSTEMSTATUSSTATUS:
      case rvc_ccafi_tclToken::EN_MSG_VIDEOSIGNALSTATUSUPREG:
      case rvc_ccafi_tclToken::EN_MSG_VIDEOSIGNALSTATUSRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_VIDEOSIGNALSTATUSSTATUS:
      case rvc_ccafi_tclToken::EN_MSG_REVERSESIGNALSTATUSUPREG:
      case rvc_ccafi_tclToken::EN_MSG_REVERSESIGNALSTATUSRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_REVERSESIGNALSTATUSSTATUS:
      case rvc_ccafi_tclToken::EN_MSG_CAMERA_PWRSUPPLYSTATUSUPREG:
      case rvc_ccafi_tclToken::EN_MSG_CAMERA_PWRSUPPLYSTATUSRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_CAMERA_PWRSUPPLYSTATUSGET:
      case rvc_ccafi_tclToken::EN_MSG_CAMERA_PWRSUPPLYSTATUSSTATUS:
      case rvc_ccafi_tclToken::EN_MSG_MICROPHONE_PWRSUPPLYSTATUSUPREG:
      case rvc_ccafi_tclToken::EN_MSG_MICROPHONE_PWRSUPPLYSTATUSRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_MICROPHONE_PWRSUPPLYSTATUSGET:
      case rvc_ccafi_tclToken::EN_MSG_MICROPHONE_PWRSUPPLYSTATUSSTATUS:
      case rvc_ccafi_tclToken::EN_MSG_TAILGATE_STATUSUPREG:
      case rvc_ccafi_tclToken::EN_MSG_TAILGATE_STATUSRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_TAILGATE_STATUSGET:
      case rvc_ccafi_tclToken::EN_MSG_TAILGATE_STATUSSTATUS:
      case rvc_ccafi_tclToken::EN_MSG_VIEW_CLOSE_AUTHORIZEDUPREG:
      case rvc_ccafi_tclToken::EN_MSG_VIEW_CLOSE_AUTHORIZEDRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_VIEW_CLOSE_AUTHORIZEDSTATUS:
      case rvc_ccafi_tclToken::EN_MSG_AVMR_CURRENT_VIEWUPREG:
      case rvc_ccafi_tclToken::EN_MSG_AVMR_CURRENT_VIEWRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_AVMR_CURRENT_VIEWSTATUS:
      case rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITSUPREG:
      case rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITSRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITSSTATUS:
      case rvc_ccafi_tclToken::EN_MSG_IPACONFIGURATIONUPREG:
      case rvc_ccafi_tclToken::EN_MSG_IPACONFIGURATIONRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_IPACONFIGURATIONSTATUS:
      case rvc_ccafi_tclToken::EN_MSG_IPASTATUSUPREG:
      case rvc_ccafi_tclToken::EN_MSG_IPASTATUSRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_IPASTATUSSTATUS:
      case rvc_ccafi_tclToken::EN_MSG_IPAPATTERNREQUESTUPREG:
      case rvc_ccafi_tclToken::EN_MSG_IPAPATTERNREQUESTRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_IPAPATTERNREQUESTSTATUS:
      case rvc_ccafi_tclToken::EN_MSG_IPAMESSAGEREQUESTUPREG:
      case rvc_ccafi_tclToken::EN_MSG_IPAMESSAGEREQUESTRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_IPAMESSAGEREQUESTSTATUS:
      case rvc_ccafi_tclToken::EN_MSG_IPASWITCHMASKREQUESTUPREG:
      case rvc_ccafi_tclToken::EN_MSG_IPASWITCHMASKREQUESTRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_IPASWITCHMASKREQUESTSTATUS:
      case rvc_ccafi_tclToken::EN_MSG_IPASWITCHGREYOUTREQUESTUPREG:
      case rvc_ccafi_tclToken::EN_MSG_IPASWITCHGREYOUTREQUESTRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_IPASWITCHGREYOUTREQUESTSTATUS:
      case rvc_ccafi_tclToken::EN_MSG_IPADIRECTIONINDICATORUPREG:
      case rvc_ccafi_tclToken::EN_MSG_IPADIRECTIONINDICATORRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_IPADIRECTIONINDICATORSTATUS:
      case rvc_ccafi_tclToken::EN_MSG_GDLADJ_STEERINGANGLEUPREG:
      case rvc_ccafi_tclToken::EN_MSG_GDLADJ_STEERINGANGLERELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_GDLADJ_STEERINGANGLESTATUS:
      case rvc_ccafi_tclToken::EN_MSG_GDLADJ_CAMERAANGLEUPREG:
      case rvc_ccafi_tclToken::EN_MSG_GDLADJ_CAMERAANGLERELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_GDLADJ_CAMERAANGLESTATUS:
      case rvc_ccafi_tclToken::EN_MSG_CANFRAMESTATUSUPREG:
      case rvc_ccafi_tclToken::EN_MSG_CANFRAMESTATUSRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_CANFRAMESTATUSSTATUS:
      case rvc_ccafi_tclToken::EN_MSG_MVCVIEWSTATUSUPREG:
      case rvc_ccafi_tclToken::EN_MSG_MVCVIEWSTATUSRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_MVCVIEWSTATUSSTATUS:
      case rvc_ccafi_tclToken::EN_MSG_MVCALERTREQUESTUPREG:
      case rvc_ccafi_tclToken::EN_MSG_MVCALERTREQUESTRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_MVCALERTREQUESTSTATUS:
      case rvc_ccafi_tclToken::EN_MSG_FAPMODEUPREG:
      case rvc_ccafi_tclToken::EN_MSG_FAPMODERELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_FAPMODESTATUS:
      case rvc_ccafi_tclToken::EN_MSG_FAPSETTINGSUPREG:
      case rvc_ccafi_tclToken::EN_MSG_FAPSETTINGSRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_FAPSETTINGSSTATUS:
      case rvc_ccafi_tclToken::EN_MSG_FAPGUIDANCESTATEUPREG:
      case rvc_ccafi_tclToken::EN_MSG_FAPGUIDANCESTATERELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_FAPGUIDANCESTATESTATUS:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_DISPSTATUSUPREG:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_DISPSTATUSRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_DISPSTATUSSTATUS:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_VIEWSETUPUPREG:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_VIEWSETUPRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_VIEWSETUPSTATUS:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_ERRORMESSAGEUPREG:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_ERRORMESSAGERELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_ERRORMESSAGESTATUS:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_SONARBUZZERSTATUSUPREG:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_SONARBUZZERSTATUSRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_SONARBUZZERSTATUSSTATUS:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_DETAILEDUPREG:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_DETAILEDRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_DETAILEDSTATUS:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_PRIMARYUPREG:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_PRIMARYRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_PRIMARYSTATUS:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_CONFIGURATIONUPREG:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_CONFIGURATIONRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_CONFIGURATIONSTATUS:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_SOFTWARE_VERSIONUPREG:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_SOFTWARE_VERSIONRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_SOFTWARE_VERSIONSTATUS:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_HARDWARE_VERSIONUPREG:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_HARDWARE_VERSIONRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_HARDWARE_VERSIONSTATUS:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_COMMUNICATIONERRORSUPREG:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_COMMUNICATIONERRORSRELUPREG:
      case rvc_ccafi_tclToken::EN_MSG_AVM3_COMMUNICATIONERRORSSTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case rvc_ccafi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_END_OF_STRUCT,rvc_ccafi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U8,rvc_ccafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_LIST,rvc_ccafi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         rvc_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case rvc_ccafi_tclToken::EN_E8_RVC_CAMERA_SYSTEM_TYPE:
      {
         rvc_fi_tcl_e8_RVC_Camera_System_Type o_e8_RVC_Camera_System_Type;
         if (!bDoIt(o_e8_RVC_Camera_System_Type))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_RVC_SIGNALSTATUS:
      {
         rvc_fi_tcl_e8_RVC_SignalStatus o_e8_RVC_SignalStatus;
         if (!bDoIt(o_e8_RVC_SignalStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_RVC_SYSTEMSTATUS:
      {
         rvc_fi_tcl_e8_RVC_SystemStatus o_e8_RVC_SystemStatus;
         if (!bDoIt(o_e8_RVC_SystemStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_RVC_STATUSGUIDELINE:
      {
         rvc_fi_tcl_e8_RVC_StatusGuideLine o_e8_RVC_StatusGuideLine;
         if (!bDoIt(o_e8_RVC_StatusGuideLine))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_RVC_STATUSWARNINGTEXT:
      {
         rvc_fi_tcl_e8_RVC_StatusWarningText o_e8_RVC_StatusWarningText;
         if (!bDoIt(o_e8_RVC_StatusWarningText))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_RVC_STATUS:
      {
         rvc_fi_tcl_e8_RVC_Status o_e8_RVC_Status;
         if (!bDoIt(o_e8_RVC_Status))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_RVC_BUTTONSTATE:
      {
         rvc_fi_tcl_e8_RVC_ButtonState o_e8_RVC_ButtonState;
         if (!bDoIt(o_e8_RVC_ButtonState))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_RVC_LANGUAGE:
      {
         rvc_fi_tcl_e8_RVC_Language o_e8_RVC_Language;
         if (!bDoIt(o_e8_RVC_Language))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_AVM_STATUSBEEP:
      {
         rvc_fi_tcl_e8_AVM_StatusBeep o_e8_AVM_StatusBeep;
         if (!bDoIt(o_e8_AVM_StatusBeep))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_AFFORDABLEITS_STATUS:
      {
         rvc_fi_tcl_e8_AffordableIts_Status o_e8_AffordableIts_Status;
         if (!bDoIt(o_e8_AffordableIts_Status))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_RVC_VIDEOPARAMETERTYPE:
      {
         rvc_fi_tcl_e8_RVC_VideoParameterType o_e8_RVC_VideoParameterType;
         if (!bDoIt(o_e8_RVC_VideoParameterType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_RVC_VIDEOPARAMETERDIMMINGMODE:
      {
         rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode o_e8_RVC_VideoParameterDimmingMode;
         if (!bDoIt(o_e8_RVC_VideoParameterDimmingMode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_AFFORDABLEITS_STATUSFEATURE:
      {
         rvc_fi_tcl_e8_AffordableIts_StatusFeature o_e8_AffordableIts_StatusFeature;
         if (!bDoIt(o_e8_AffordableIts_StatusFeature))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_EXIT_AUTHORIZED:
      {
         rvc_fi_tcl_e8_Exit_Authorized o_e8_Exit_Authorized;
         if (!bDoIt(o_e8_Exit_Authorized))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_RVC_VIDEOANALOGLEVELS:
      {
      if (poVisitor->bDoExpand_RVC_VideoAnalogLevels(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_END_OF_STRUCT,rvc_ccafi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U8,rvc_ccafi_tclSemanticDomain::EN_U8VALUE));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_RVC_VIDEOPARAMETERDIMMINGMODE,rvc_ccafi_tclSemanticDomain::EN_E8DIMMINGMODE));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_RVC_VIDEOPARAMETERTYPE,rvc_ccafi_tclSemanticDomain::EN_E8TYPE));
      }
      else
      {
         rvc_fi_tcl_RVC_VideoAnalogLevels o_RVC_VideoAnalogLevels;
         if (!bDoIt(o_RVC_VideoAnalogLevels))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RVC_VideoAnalogLevels.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RVC_VideoAnalogLevels.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case rvc_ccafi_tclToken::EN_E8_RVC_CAMERASTATE:
      {
         rvc_fi_tcl_e8_RVC_CameraState o_e8_RVC_CameraState;
         if (!bDoIt(o_e8_RVC_CameraState))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_IPA_BUTTON_ID:
      {
         rvc_fi_tcl_e8_IPA_BUTTON_ID o_e8_IPA_BUTTON_ID;
         if (!bDoIt(o_e8_IPA_BUTTON_ID))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_IPA_PATTERNID:
      {
         rvc_fi_tcl_e8_IPA_PatternID o_e8_IPA_PatternID;
         if (!bDoIt(o_e8_IPA_PatternID))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_IPA_MESSAGEID:
      {
         rvc_fi_tcl_e8_IPA_MessageID o_e8_IPA_MessageID;
         if (!bDoIt(o_e8_IPA_MessageID))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_IPA_OPERATIONSTATUS:
      {
         rvc_fi_tcl_e8_IPA_OperationStatus o_e8_IPA_OperationStatus;
         if (!bDoIt(o_e8_IPA_OperationStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_IPA_MODECHANGEREQUEST:
      {
         rvc_fi_tcl_e8_IPA_ModeChangeRequest o_e8_IPA_ModeChangeRequest;
         if (!bDoIt(o_e8_IPA_ModeChangeRequest))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_IPA_HMISTATUS:
      {
         rvc_fi_tcl_e8_IPA_HMIStatus o_e8_IPA_HMIStatus;
         if (!bDoIt(o_e8_IPA_HMIStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_IPA_REGIONALSELECTION:
      {
         rvc_fi_tcl_e8_IPA_RegionalSelection o_e8_IPA_RegionalSelection;
         if (!bDoIt(o_e8_IPA_RegionalSelection))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_IPA_AVAILABILITYSTATUS:
      {
         rvc_fi_tcl_e8_IPA_AvailabilityStatus o_e8_IPA_AvailabilityStatus;
         if (!bDoIt(o_e8_IPA_AvailabilityStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_IPA_SWITCHMASK:
      {
         rvc_fi_tcl_e8_IPA_SwitchMask o_e8_IPA_SwitchMask;
         if (!bDoIt(o_e8_IPA_SwitchMask))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_SET_MICSTATE:
      {
         rvc_fi_tcl_e8_Set_MicState o_e8_Set_MicState;
         if (!bDoIt(o_e8_Set_MicState))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_IPA_DIRECTIONINDICATOR:
      {
         rvc_fi_tcl_e8_IPA_DirectionIndicator o_e8_IPA_DirectionIndicator;
         if (!bDoIt(o_e8_IPA_DirectionIndicator))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_IPA_VOICETEXT:
      {
         rvc_fi_tcl_e8_IPA_VoiceText o_e8_IPA_VoiceText;
         if (!bDoIt(o_e8_IPA_VoiceText))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_IPA_VOICE_TEXT_STRINGS:
      {
      if (poVisitor->bDoExpand_IPA_Voice_Text_Strings(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_END_OF_STRUCT,rvc_ccafi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_STRING,rvc_ccafi_tclSemanticDomain::EN_SZTEXT));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_IPA_VOICETEXT,rvc_ccafi_tclSemanticDomain::EN_E8REQUESTID));
      }
      else
      {
         rvc_fi_tcl_IPA_Voice_Text_Strings o_IPA_Voice_Text_Strings;
         if (!bDoIt(o_IPA_Voice_Text_Strings))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IPA_Voice_Text_Strings.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_IPA_Voice_Text_Strings.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case rvc_ccafi_tclToken::EN_E8_CAMERA_POWERSUPPLYSTATUS:
      {
         rvc_fi_tcl_e8_Camera_PowerSupplyStatus o_e8_Camera_PowerSupplyStatus;
         if (!bDoIt(o_e8_Camera_PowerSupplyStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_MICROPHONE_POWERSUPPLYSTATUS:
      {
         rvc_fi_tcl_e8_Microphone_PowerSupplyStatus o_e8_Microphone_PowerSupplyStatus;
         if (!bDoIt(o_e8_Microphone_PowerSupplyStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_RVC_MODULE:
      {
         rvc_fi_tcl_e8_RVC_Module o_e8_RVC_Module;
         if (!bDoIt(o_e8_RVC_Module))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_RVC_REVERSESIGNALSTATUS:
      {
         rvc_fi_tcl_e8_RVC_ReverseSignalStatus o_e8_RVC_ReverseSignalStatus;
         if (!bDoIt(o_e8_RVC_ReverseSignalStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_PARKASSIST_USERCONFIGURATIONTYPE:
      {
         rvc_fi_tcl_e8_ParkAssist_UserConfigurationType o_e8_ParkAssist_UserConfigurationType;
         if (!bDoIt(o_e8_ParkAssist_UserConfigurationType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_PARKASSIST_USERCONFIGURATIONMODE:
      {
         rvc_fi_tcl_e8_ParkAssist_UserConfigurationMode o_e8_ParkAssist_UserConfigurationMode;
         if (!bDoIt(o_e8_ParkAssist_UserConfigurationMode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_PARKASSIST_USERCONFIGURATION:
      {
      if (poVisitor->bDoExpand_ParkAssist_UserConfiguration(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_END_OF_STRUCT,rvc_ccafi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_PARKASSIST_USERCONFIGURATIONMODE,rvc_ccafi_tclSemanticDomain::EN_E8MODE));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_PARKASSIST_USERCONFIGURATIONTYPE,rvc_ccafi_tclSemanticDomain::EN_E8TYPE));
      }
      else
      {
         rvc_fi_tcl_ParkAssist_UserConfiguration o_ParkAssist_UserConfiguration;
         if (!bDoIt(o_ParkAssist_UserConfiguration))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ParkAssist_UserConfiguration.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ParkAssist_UserConfiguration.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case rvc_ccafi_tclToken::EN_E8_GDLADJ_ADJUSTBUTTON:
      {
         rvc_fi_tcl_e8_GdlAdj_AdjustButton o_e8_GdlAdj_AdjustButton;
         if (!bDoIt(o_e8_GdlAdj_AdjustButton))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_GDLADJ_COMPLETION:
      {
         rvc_fi_tcl_e8_GdlAdj_Completion o_e8_GdlAdj_Completion;
         if (!bDoIt(o_e8_GdlAdj_Completion))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_GDLADJ_REQUEST:
      {
         rvc_fi_tcl_e8_GdlAdj_Request o_e8_GdlAdj_Request;
         if (!bDoIt(o_e8_GdlAdj_Request))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_GDLADJ_CONFIGURATIONITEM:
      {
         rvc_fi_tcl_e8_GdlAdj_ConfigurationItem o_e8_GdlAdj_ConfigurationItem;
         if (!bDoIt(o_e8_GdlAdj_ConfigurationItem))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_GDLADJ_CONFIGPARAMETERDATA:
      {
      if (poVisitor->bDoExpand_GdlAdj_ConfigParameterData(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_END_OF_STRUCT,rvc_ccafi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_F64,rvc_ccafi_tclSemanticDomain::EN_F64VALUE));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_GDLADJ_CONFIGURATIONITEM,rvc_ccafi_tclSemanticDomain::EN_E8ITEM));
      }
      else
      {
         rvc_fi_tcl_GdlAdj_ConfigParameterData o_GdlAdj_ConfigParameterData;
         if (!bDoIt(o_GdlAdj_ConfigParameterData))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GdlAdj_ConfigParameterData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GdlAdj_ConfigParameterData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case rvc_ccafi_tclToken::EN_E8_MVCVIEWINGSTATE:
      {
         rvc_fi_tcl_e8_MVCViewingState o_e8_MVCViewingState;
         if (!bDoIt(o_e8_MVCViewingState))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_AVM_VIEW_REQUEST:
      {
         rvc_fi_tcl_e8_AVM_View_Request o_e8_AVM_View_Request;
         if (!bDoIt(o_e8_AVM_View_Request))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_AVM_VIEW_STATUS:
      {
         rvc_fi_tcl_e8_AVM_View_Status o_e8_AVM_View_Status;
         if (!bDoIt(o_e8_AVM_View_Status))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_TAILGATE_STATE:
      {
         rvc_fi_tcl_e8_Tailgate_State o_e8_Tailgate_State;
         if (!bDoIt(o_e8_Tailgate_State))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_TOUCHGESTURE:
      {
         rvc_fi_tcl_e8_TouchGesture o_e8_TouchGesture;
         if (!bDoIt(o_e8_TouchGesture))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_DIRECTION:
      {
         rvc_fi_tcl_e8_Direction o_e8_Direction;
         if (!bDoIt(o_e8_Direction))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_FAP_SETTINGITEM:
      {
         rvc_fi_tcl_e8_FAP_SettingItem o_e8_FAP_SettingItem;
         if (!bDoIt(o_e8_FAP_SettingItem))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_AVM_FAP_SETTINGSTATE:
      {
         rvc_fi_tcl_e8_AVM_FAP_SettingState o_e8_AVM_FAP_SettingState;
         if (!bDoIt(o_e8_AVM_FAP_SettingState))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_AVM_SETTINGITEM:
      {
         rvc_fi_tcl_e8_AVM_SettingItem o_e8_AVM_SettingItem;
         if (!bDoIt(o_e8_AVM_SettingItem))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_FAP_SETTINGS_STATE:
      {
      if (poVisitor->bDoExpand_FAP_Settings_State(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_END_OF_STRUCT,rvc_ccafi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVM_FAP_SETTINGSTATE,rvc_ccafi_tclSemanticDomain::EN_E8STATE));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_FAP_SETTINGITEM,rvc_ccafi_tclSemanticDomain::EN_E8TYPE));
      }
      else
      {
         rvc_fi_tcl_FAP_Settings_State o_FAP_Settings_State;
         if (!bDoIt(o_FAP_Settings_State))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FAP_Settings_State.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FAP_Settings_State.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case rvc_ccafi_tclToken::EN_AVM_SETTINGS_STATE:
      {
      if (poVisitor->bDoExpand_AVM_Settings_State(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_END_OF_STRUCT,rvc_ccafi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVM_FAP_SETTINGSTATE,rvc_ccafi_tclSemanticDomain::EN_E8STATE));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVM_SETTINGITEM,rvc_ccafi_tclSemanticDomain::EN_E8TYPE));
      }
      else
      {
         rvc_fi_tcl_AVM_Settings_State o_AVM_Settings_State;
         if (!bDoIt(o_AVM_Settings_State))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AVM_Settings_State.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AVM_Settings_State.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case rvc_ccafi_tclToken::EN_GPS_DATA:
      {
      if (poVisitor->bDoExpand_GPS_Data(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_END_OF_STRUCT,rvc_ccafi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U32,rvc_ccafi_tclSemanticDomain::EN_GROUNDSPEED));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U32,rvc_ccafi_tclSemanticDomain::EN_NUMOFSATELLITES));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_F32,rvc_ccafi_tclSemanticDomain::EN_VDOP));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_F32,rvc_ccafi_tclSemanticDomain::EN_HDOP));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_F32,rvc_ccafi_tclSemanticDomain::EN_GPS_AZIMUTH));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_F32,rvc_ccafi_tclSemanticDomain::EN_GPS_ALTITUDE));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_F32,rvc_ccafi_tclSemanticDomain::EN_GPS_LONGITUDE));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_F32,rvc_ccafi_tclSemanticDomain::EN_GPS_LATITUDE));
      }
      else
      {
         rvc_fi_tcl_GPS_Data o_GPS_Data;
         if (!bDoIt(o_GPS_Data))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GPS_Data.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GPS_Data.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case rvc_ccafi_tclToken::EN_MAPMATCHED_DATA:
      {
      if (poVisitor->bDoExpand_MapMatched_Data(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_END_OF_STRUCT,rvc_ccafi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_F32,rvc_ccafi_tclSemanticDomain::EN_MM_ACCURACY));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_F32,rvc_ccafi_tclSemanticDomain::EN_MM_AZIMUTH));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_F32,rvc_ccafi_tclSemanticDomain::EN_MM_LONGITUDE));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_F32,rvc_ccafi_tclSemanticDomain::EN_MM_LATITUDE));
      }
      else
      {
         rvc_fi_tcl_MapMatched_Data o_MapMatched_Data;
         if (!bDoIt(o_MapMatched_Data))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapMatched_Data.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MapMatched_Data.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case rvc_ccafi_tclToken::EN_TOUCH_DATA:
      {
      if (poVisitor->bDoExpand_Touch_Data(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_END_OF_STRUCT,rvc_ccafi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U8,rvc_ccafi_tclSemanticDomain::EN_SPEEDOFMOVEMENT));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_DIRECTION,rvc_ccafi_tclSemanticDomain::EN_E8DIRECTION));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_TOUCHGESTURE,rvc_ccafi_tclSemanticDomain::EN_E8GESTURE));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U32,rvc_ccafi_tclSemanticDomain::EN_Y1_ORDINATE));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U32,rvc_ccafi_tclSemanticDomain::EN_X1_ORDINATE));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U32,rvc_ccafi_tclSemanticDomain::EN_Y_ORDINATE));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U32,rvc_ccafi_tclSemanticDomain::EN_X_ORDINATE));
      }
      else
      {
         rvc_fi_tcl_Touch_Data o_Touch_Data;
         if (!bDoIt(o_Touch_Data))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Touch_Data.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Touch_Data.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case rvc_ccafi_tclToken::EN_E8_AVMPH3_SWITCHID:
      {
         rvc_fi_tcl_e8_AVMph3_SwitchId o_e8_AVMph3_SwitchId;
         if (!bDoIt(o_e8_AVMph3_SwitchId))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_AVMPH3_SWITCHSTATUS:
      {
         rvc_fi_tcl_e8_AVMph3_SwitchStatus o_e8_AVMph3_SwitchStatus;
         if (!bDoIt(o_e8_AVMph3_SwitchStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_AVMPH3_SWITCHDESCRIPTOR:
      {
      if (poVisitor->bDoExpand_AVMph3_SwitchDescriptor(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_END_OF_STRUCT,rvc_ccafi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVMPH3_SWITCHSTATUS,rvc_ccafi_tclSemanticDomain::EN_STATUS));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVMPH3_SWITCHID,rvc_ccafi_tclSemanticDomain::EN_ID));
      }
      else
      {
         rvc_fi_tcl_AVMph3_SwitchDescriptor o_AVMph3_SwitchDescriptor;
         if (!bDoIt(o_AVMph3_SwitchDescriptor))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AVMph3_SwitchDescriptor.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AVMph3_SwitchDescriptor.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case rvc_ccafi_tclToken::EN_E8_AVMPH3_DISPSTATUS:
      {
         rvc_fi_tcl_e8_AVMph3_DispStatus o_e8_AVMph3_DispStatus;
         if (!bDoIt(o_e8_AVMph3_DispStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_AVMPH3_VIEWPATTERN:
      {
         rvc_fi_tcl_e8_AVMph3_ViewPattern o_e8_AVMph3_ViewPattern;
         if (!bDoIt(o_e8_AVMph3_ViewPattern))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_AVMPH3_CAUTIONID:
      {
         rvc_fi_tcl_e8_AVMph3_CautionId o_e8_AVMph3_CautionId;
         if (!bDoIt(o_e8_AVMph3_CautionId))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_AVMPH3_ICONID:
      {
         rvc_fi_tcl_e8_AVMph3_IconId o_e8_AVMph3_IconId;
         if (!bDoIt(o_e8_AVMph3_IconId))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_AVMPH3_BUZZERSTATUS:
      {
         rvc_fi_tcl_e8_AVMph3_BuzzerStatus o_e8_AVMph3_BuzzerStatus;
         if (!bDoIt(o_e8_AVMph3_BuzzerStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_AVMPH3_ERRORMESSAGE:
      {
         rvc_fi_tcl_e8_AVMph3_ErrorMessage o_e8_AVMph3_ErrorMessage;
         if (!bDoIt(o_e8_AVMph3_ErrorMessage))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_AVMPH3_SETTINGITEMID:
      {
         rvc_fi_tcl_e8_AVMph3_SettingItemId o_e8_AVMph3_SettingItemId;
         if (!bDoIt(o_e8_AVMph3_SettingItemId))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_AVMPH3_SETTING_ITEM:
      {
      if (poVisitor->bDoExpand_AVMph3_Setting_Item(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_END_OF_STRUCT,rvc_ccafi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U8,rvc_ccafi_tclSemanticDomain::EN_U8ITEMSTATE));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVMPH3_SETTINGITEMID,rvc_ccafi_tclSemanticDomain::EN_E8ITEMID));
      }
      else
      {
         rvc_fi_tcl_AVMph3_Setting_Item o_AVMph3_Setting_Item;
         if (!bDoIt(o_AVMph3_Setting_Item))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AVMph3_Setting_Item.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AVMph3_Setting_Item.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case rvc_ccafi_tclToken::EN_E8_AVMPH3_SETTINGOPTIONSTATE:
      {
         rvc_fi_tcl_e8_AVMph3_SettingOptionState o_e8_AVMph3_SettingOptionState;
         if (!bDoIt(o_e8_AVMph3_SettingOptionState))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_AVMPH3_SETTING_OPTION:
      {
      if (poVisitor->bDoExpand_AVMph3_Setting_Option(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_END_OF_STRUCT,rvc_ccafi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVMPH3_SETTINGOPTIONSTATE,rvc_ccafi_tclSemanticDomain::EN_E8ITEMSTATE));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVMPH3_SETTINGITEMID,rvc_ccafi_tclSemanticDomain::EN_E8ITEMID));
      }
      else
      {
         rvc_fi_tcl_AVMph3_Setting_Option o_AVMph3_Setting_Option;
         if (!bDoIt(o_AVMph3_Setting_Option))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AVMph3_Setting_Option.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AVMph3_Setting_Option.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case rvc_ccafi_tclToken::EN_E8_AVMPH3_SETTING_PRIOVIEW:
      {
         rvc_fi_tcl_e8_AVMph3_Setting_PrioView o_e8_AVMph3_Setting_PrioView;
         if (!bDoIt(o_e8_AVMph3_Setting_PrioView))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_AVMPH3_SETTING_PRIOWIDE:
      {
         rvc_fi_tcl_e8_AVMph3_Setting_PrioWide o_e8_AVMph3_Setting_PrioWide;
         if (!bDoIt(o_e8_AVMph3_Setting_PrioWide))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_AVMPH3_SETTING_AUTOCAMPOS:
      {
         rvc_fi_tcl_e8_AVMph3_Setting_AutoCamPos o_e8_AVMph3_Setting_AutoCamPos;
         if (!bDoIt(o_e8_AVMph3_Setting_AutoCamPos))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_AVMPH3_CORNERSONARSENSLVL:
      {
         rvc_fi_tcl_e8_AVMph3_CornerSonarSensLvl o_e8_AVMph3_CornerSonarSensLvl;
         if (!bDoIt(o_e8_AVMph3_CornerSonarSensLvl))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_AVMPH3_SETTING_CORNERSONARSENSLVL:
      {
      if (poVisitor->bDoExpand_AVMph3_Setting_CornerSonarSensLvl(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_END_OF_STRUCT,rvc_ccafi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVMPH3_CORNERSONARSENSLVL,rvc_ccafi_tclSemanticDomain::EN_E8LEVEL));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_BAVAIL));
      }
      else
      {
         rvc_fi_tcl_AVMph3_Setting_CornerSonarSensLvl o_AVMph3_Setting_CornerSonarSensLvl;
         if (!bDoIt(o_AVMph3_Setting_CornerSonarSensLvl))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AVMph3_Setting_CornerSonarSensLvl.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AVMph3_Setting_CornerSonarSensLvl.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case rvc_ccafi_tclToken::EN_E8_AVMPH3_SONARSENSLVL:
      {
         rvc_fi_tcl_e8_AVMph3_SonarSensLvl o_e8_AVMph3_SonarSensLvl;
         if (!bDoIt(o_e8_AVMph3_SonarSensLvl))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_AVMPH3_SETTING_SONARSENSLVL:
      {
      if (poVisitor->bDoExpand_AVMph3_Setting_SonarSensLvl(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_END_OF_STRUCT,rvc_ccafi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVMPH3_SONARSENSLVL,rvc_ccafi_tclSemanticDomain::EN_E8LEVEL));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_BAVAIL));
      }
      else
      {
         rvc_fi_tcl_AVMph3_Setting_SonarSensLvl o_AVMph3_Setting_SonarSensLvl;
         if (!bDoIt(o_AVMph3_Setting_SonarSensLvl))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AVMph3_Setting_SonarSensLvl.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AVMph3_Setting_SonarSensLvl.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case rvc_ccafi_tclToken::EN_E8_AVMPH3_BUZZERSOUNDLVL:
      {
         rvc_fi_tcl_e8_AVMph3_BuzzerSoundLvl o_e8_AVMph3_BuzzerSoundLvl;
         if (!bDoIt(o_e8_AVMph3_BuzzerSoundLvl))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_AVMPH3_SETTING_BUZZERSOUNDLVL:
      {
      if (poVisitor->bDoExpand_AVMph3_Setting_BuzzerSoundLvl(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_END_OF_STRUCT,rvc_ccafi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVMPH3_BUZZERSOUNDLVL,rvc_ccafi_tclSemanticDomain::EN_E8LEVEL));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_BAVAIL));
      }
      else
      {
         rvc_fi_tcl_AVMph3_Setting_BuzzerSoundLvl o_AVMph3_Setting_BuzzerSoundLvl;
         if (!bDoIt(o_AVMph3_Setting_BuzzerSoundLvl))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AVMph3_Setting_BuzzerSoundLvl.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AVMph3_Setting_BuzzerSoundLvl.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case rvc_ccafi_tclToken::EN_E8_AVMPH3_REQUESTTYPE:
      {
         rvc_fi_tcl_e8_AVMph3_RequestType o_e8_AVMph3_RequestType;
         if (!bDoIt(o_e8_AVMph3_RequestType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_AVMPH3_VERSIONINFOTYPE:
      {
         rvc_fi_tcl_e8_AVMph3_VersionInfoType o_e8_AVMph3_VersionInfoType;
         if (!bDoIt(o_e8_AVMph3_VersionInfoType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_AVMPH3_VERSIONINFO:
      {
      if (poVisitor->bDoExpand_AVMph3_VersionInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_END_OF_STRUCT,rvc_ccafi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U8,rvc_ccafi_tclSemanticDomain::EN_U8LOWER));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U8,rvc_ccafi_tclSemanticDomain::EN_U8MIDDLE));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U8,rvc_ccafi_tclSemanticDomain::EN_U8UPPER));
      }
      else
      {
         rvc_fi_tcl_AVMph3_VersionInfo o_AVMph3_VersionInfo;
         if (!bDoIt(o_AVMph3_VersionInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AVMph3_VersionInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AVMph3_VersionInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case rvc_ccafi_tclToken::EN_E8_AVMPH3_CONFIGURATIONSTATUS:
      {
         rvc_fi_tcl_e8_AVMph3_ConfigurationStatus o_e8_AVMph3_ConfigurationStatus;
         if (!bDoIt(o_e8_AVMph3_ConfigurationStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_E8_AVMPH3_VARIANT:
      {
         rvc_fi_tcl_e8_AVMph3_Variant o_e8_AVMph3_Variant;
         if (!bDoIt(o_e8_AVMph3_Variant))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case rvc_ccafi_tclToken::EN_AVMPH3_UNIT_ID:
      {
      if (poVisitor->bDoExpand_AVMph3_Unit_ID(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_END_OF_STRUCT,rvc_ccafi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_BWITHSONAR));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_BOOL,rvc_ccafi_tclSemanticDomain::EN_BLEFTHANDDRIVE));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_E8_AVMPH3_VARIANT,rvc_ccafi_tclSemanticDomain::EN_E8VARIANT));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U8,rvc_ccafi_tclSemanticDomain::EN_U8UNIT_ID));
      }
      else
      {
         rvc_fi_tcl_AVMph3_Unit_ID o_AVMph3_Unit_ID;
         if (!bDoIt(o_AVMph3_Unit_ID))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AVMph3_Unit_ID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AVMph3_Unit_ID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case rvc_ccafi_tclToken::EN_AVMPH3_MCAN_COMMUNICATIONERRORS:
      {
      if (poVisitor->bDoExpand_AVMph3_MCAN_CommunicationErrors(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_END_OF_STRUCT,rvc_ccafi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U8,rvc_ccafi_tclSemanticDomain::EN_U8TXMPDTTOSONAR));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U8,rvc_ccafi_tclSemanticDomain::EN_U8RXCMFFROMSONAR));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U8,rvc_ccafi_tclSemanticDomain::EN_U8TXCMFTOMASTER));
         (tVoid) oPath.bGoDown(rvc_ccafi_tclKnot(rvc_ccafi_tclToken::EN_U8,rvc_ccafi_tclSemanticDomain::EN_U8BUSOFF));
      }
      else
      {
         rvc_fi_tcl_AVMph3_MCAN_CommunicationErrors o_AVMph3_MCAN_CommunicationErrors;
         if (!bDoIt(o_AVMph3_MCAN_CommunicationErrors))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AVMph3_MCAN_CommunicationErrors.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AVMph3_MCAN_CommunicationErrors.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case rvc_ccafi_tclToken::EN_UNKNOWN:
      case rvc_ccafi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

