/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef PROFILE_MAINFITYPES_HEADER
#define PROFILE_MAINFITYPES_HEADER


class profile_mainfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for profile_main_fi message types

fi_tclMessageBase* profile_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class profile_mainfi_tclMsgBaseMessage : public profile_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   profile_mainfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class profile_mainfi_tclMsgdoChangeToProfileMethodStart : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgdoChangeToProfileMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   profile_mainfi_tclMsgdoChangeToProfileMethodStart& operator=(const profile_mainfi_tclMsgdoChangeToProfileMethodStart& coRef);
   profile_mainfi_tclMsgdoChangeToProfileMethodStart(const profile_mainfi_tclMsgdoChangeToProfileMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 newUserID;
   virtual ~profile_mainfi_tclMsgdoChangeToProfileMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const profile_mainfi_tclMsgdoChangeToProfileMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgdoChangeToProfileMethodResult : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgdoChangeToProfileMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   profile_mainfi_tclMsgdoChangeToProfileMethodResult& operator=(const profile_mainfi_tclMsgdoChangeToProfileMethodResult& coRef);
   profile_mainfi_tclMsgdoChangeToProfileMethodResult(const profile_mainfi_tclMsgdoChangeToProfileMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   profile_fi_tcl_e8_ChangeProfileResult result;
   virtual ~profile_mainfi_tclMsgdoChangeToProfileMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const profile_mainfi_tclMsgdoChangeToProfileMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgdoCopyProfileMethodStart : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgdoCopyProfileMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   profile_mainfi_tclMsgdoCopyProfileMethodStart& operator=(const profile_mainfi_tclMsgdoCopyProfileMethodStart& coRef);
   profile_mainfi_tclMsgdoCopyProfileMethodStart(const profile_mainfi_tclMsgdoCopyProfileMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 sourceID;
   tU8 destinationID;
   virtual ~profile_mainfi_tclMsgdoCopyProfileMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const profile_mainfi_tclMsgdoCopyProfileMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgdoCopyProfileMethodResult : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgdoCopyProfileMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   profile_mainfi_tclMsgdoCopyProfileMethodResult& operator=(const profile_mainfi_tclMsgdoCopyProfileMethodResult& coRef);
   profile_mainfi_tclMsgdoCopyProfileMethodResult(const profile_mainfi_tclMsgdoCopyProfileMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   profile_fi_tcl_e8_ChangeProfileResult result;
   virtual ~profile_mainfi_tclMsgdoCopyProfileMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const profile_mainfi_tclMsgdoCopyProfileMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgdoDeleteProfileMethodStart : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgdoDeleteProfileMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   profile_mainfi_tclMsgdoDeleteProfileMethodStart& operator=(const profile_mainfi_tclMsgdoDeleteProfileMethodStart& coRef);
   profile_mainfi_tclMsgdoDeleteProfileMethodStart(const profile_mainfi_tclMsgdoDeleteProfileMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 UserID;
   virtual ~profile_mainfi_tclMsgdoDeleteProfileMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const profile_mainfi_tclMsgdoDeleteProfileMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgdoDeleteProfileMethodResult : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgdoDeleteProfileMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   profile_mainfi_tclMsgdoDeleteProfileMethodResult& operator=(const profile_mainfi_tclMsgdoDeleteProfileMethodResult& coRef);
   profile_mainfi_tclMsgdoDeleteProfileMethodResult(const profile_mainfi_tclMsgdoDeleteProfileMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   profile_fi_tcl_e8_ChangeProfileResult result;
   virtual ~profile_mainfi_tclMsgdoDeleteProfileMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const profile_mainfi_tclMsgdoDeleteProfileMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgdoCreateProfileMethodStart : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgdoCreateProfileMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   profile_mainfi_tclMsgdoCreateProfileMethodStart& operator=(const profile_mainfi_tclMsgdoCreateProfileMethodStart& coRef);
   profile_mainfi_tclMsgdoCreateProfileMethodStart(const profile_mainfi_tclMsgdoCreateProfileMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   profile_fi_tclString Name;
   tU8 ImageID;
   virtual ~profile_mainfi_tclMsgdoCreateProfileMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const profile_mainfi_tclMsgdoCreateProfileMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgdoCreateProfileMethodResult : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgdoCreateProfileMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   profile_mainfi_tclMsgdoCreateProfileMethodResult& operator=(const profile_mainfi_tclMsgdoCreateProfileMethodResult& coRef);
   profile_mainfi_tclMsgdoCreateProfileMethodResult(const profile_mainfi_tclMsgdoCreateProfileMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   profile_fi_tcl_e8_ChangeProfileResult result;
   tU8 UserID;
   virtual ~profile_mainfi_tclMsgdoCreateProfileMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const profile_mainfi_tclMsgdoCreateProfileMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgonDataChangedMethodStart : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgonDataChangedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   profile_mainfi_tclMsgonDataChangedMethodStart& operator=(const profile_mainfi_tclMsgonDataChangedMethodStart& coRef);
   profile_mainfi_tclMsgonDataChangedMethodStart(const profile_mainfi_tclMsgonDataChangedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   profile_fi_tcl_e8_DataChangedResponse result;
   virtual ~profile_mainfi_tclMsgonDataChangedMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const profile_mainfi_tclMsgonDataChangedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgonProfileCreatedMethodStart : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgonProfileCreatedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   profile_mainfi_tclMsgonProfileCreatedMethodStart& operator=(const profile_mainfi_tclMsgonProfileCreatedMethodStart& coRef);
   profile_mainfi_tclMsgonProfileCreatedMethodStart(const profile_mainfi_tclMsgonProfileCreatedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   profile_fi_tcl_e8_ClientResponse result;
   virtual ~profile_mainfi_tclMsgonProfileCreatedMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const profile_mainfi_tclMsgonProfileCreatedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgonProfileCopiedMethodStart : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgonProfileCopiedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   profile_mainfi_tclMsgonProfileCopiedMethodStart& operator=(const profile_mainfi_tclMsgonProfileCopiedMethodStart& coRef);
   profile_mainfi_tclMsgonProfileCopiedMethodStart(const profile_mainfi_tclMsgonProfileCopiedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   profile_fi_tcl_e8_ClientResponse result;
   virtual ~profile_mainfi_tclMsgonProfileCopiedMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const profile_mainfi_tclMsgonProfileCopiedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgonProfileDeletedMethodStart : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgonProfileDeletedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   profile_mainfi_tclMsgonProfileDeletedMethodStart& operator=(const profile_mainfi_tclMsgonProfileDeletedMethodStart& coRef);
   profile_mainfi_tclMsgonProfileDeletedMethodStart(const profile_mainfi_tclMsgonProfileDeletedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   profile_fi_tcl_e8_ClientResponse result;
   virtual ~profile_mainfi_tclMsgonProfileDeletedMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const profile_mainfi_tclMsgonProfileDeletedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgRegisterClientMethodStart : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgRegisterClientMethodStart();

   virtual ~profile_mainfi_tclMsgRegisterClientMethodStart();

   inline tBool operator==(const profile_mainfi_tclMsgRegisterClientMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgRegisterClientMethodResult : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgRegisterClientMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   profile_mainfi_tclMsgRegisterClientMethodResult& operator=(const profile_mainfi_tclMsgRegisterClientMethodResult& coRef);
   profile_mainfi_tclMsgRegisterClientMethodResult(const profile_mainfi_tclMsgRegisterClientMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bReloadData;
   virtual ~profile_mainfi_tclMsgRegisterClientMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const profile_mainfi_tclMsgRegisterClientMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgactiveProfileUpReg : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgactiveProfileUpReg();

   virtual ~profile_mainfi_tclMsgactiveProfileUpReg();

   inline tBool operator==(const profile_mainfi_tclMsgactiveProfileUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgactiveProfileRelUpReg : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgactiveProfileRelUpReg();

   virtual ~profile_mainfi_tclMsgactiveProfileRelUpReg();

   inline tBool operator==(const profile_mainfi_tclMsgactiveProfileRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgactiveProfileGet : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgactiveProfileGet();

   virtual ~profile_mainfi_tclMsgactiveProfileGet();

   inline tBool operator==(const profile_mainfi_tclMsgactiveProfileGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgactiveProfileStatus : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgactiveProfileStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   profile_mainfi_tclMsgactiveProfileStatus& operator=(const profile_mainfi_tclMsgactiveProfileStatus& coRef);
   profile_mainfi_tclMsgactiveProfileStatus(const profile_mainfi_tclMsgactiveProfileStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ID;
   virtual ~profile_mainfi_tclMsgactiveProfileStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const profile_mainfi_tclMsgactiveProfileStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgstatusUpReg : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgstatusUpReg();

   virtual ~profile_mainfi_tclMsgstatusUpReg();

   inline tBool operator==(const profile_mainfi_tclMsgstatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgstatusRelUpReg : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgstatusRelUpReg();

   virtual ~profile_mainfi_tclMsgstatusRelUpReg();

   inline tBool operator==(const profile_mainfi_tclMsgstatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgstatusGet : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgstatusGet();

   virtual ~profile_mainfi_tclMsgstatusGet();

   inline tBool operator==(const profile_mainfi_tclMsgstatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgstatusStatus : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgstatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   profile_mainfi_tclMsgstatusStatus& operator=(const profile_mainfi_tclMsgstatusStatus& coRef);
   profile_mainfi_tclMsgstatusStatus(const profile_mainfi_tclMsgstatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   profile_fi_tcl_e8_profileStatus status;
   virtual ~profile_mainfi_tclMsgstatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const profile_mainfi_tclMsgstatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgcopyProfileUpReg : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgcopyProfileUpReg();

   virtual ~profile_mainfi_tclMsgcopyProfileUpReg();

   inline tBool operator==(const profile_mainfi_tclMsgcopyProfileUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgcopyProfileRelUpReg : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgcopyProfileRelUpReg();

   virtual ~profile_mainfi_tclMsgcopyProfileRelUpReg();

   inline tBool operator==(const profile_mainfi_tclMsgcopyProfileRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgcopyProfileStatus : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgcopyProfileStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   profile_mainfi_tclMsgcopyProfileStatus& operator=(const profile_mainfi_tclMsgcopyProfileStatus& coRef);
   profile_mainfi_tclMsgcopyProfileStatus(const profile_mainfi_tclMsgcopyProfileStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 sourceID;
   tU8 destinationID;
   virtual ~profile_mainfi_tclMsgcopyProfileStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const profile_mainfi_tclMsgcopyProfileStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgdeleteProfileUpReg : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgdeleteProfileUpReg();

   virtual ~profile_mainfi_tclMsgdeleteProfileUpReg();

   inline tBool operator==(const profile_mainfi_tclMsgdeleteProfileUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgdeleteProfileRelUpReg : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgdeleteProfileRelUpReg();

   virtual ~profile_mainfi_tclMsgdeleteProfileRelUpReg();

   inline tBool operator==(const profile_mainfi_tclMsgdeleteProfileRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgdeleteProfileStatus : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgdeleteProfileStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   profile_mainfi_tclMsgdeleteProfileStatus& operator=(const profile_mainfi_tclMsgdeleteProfileStatus& coRef);
   profile_mainfi_tclMsgdeleteProfileStatus(const profile_mainfi_tclMsgdeleteProfileStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ProfileID;
   virtual ~profile_mainfi_tclMsgdeleteProfileStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const profile_mainfi_tclMsgdeleteProfileStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgdataChangedUpReg : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgdataChangedUpReg();

   virtual ~profile_mainfi_tclMsgdataChangedUpReg();

   inline tBool operator==(const profile_mainfi_tclMsgdataChangedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgdataChangedRelUpReg : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgdataChangedRelUpReg();

   virtual ~profile_mainfi_tclMsgdataChangedRelUpReg();

   inline tBool operator==(const profile_mainfi_tclMsgdataChangedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgdataChangedStatus : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgdataChangedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   profile_mainfi_tclMsgdataChangedStatus& operator=(const profile_mainfi_tclMsgdataChangedStatus& coRef);
   profile_mainfi_tclMsgdataChangedStatus(const profile_mainfi_tclMsgdataChangedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   profile_fi_tcl_e8_changeProfile reason;
   virtual ~profile_mainfi_tclMsgdataChangedStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const profile_mainfi_tclMsgdataChangedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgcreateProfileUpReg : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgcreateProfileUpReg();

   virtual ~profile_mainfi_tclMsgcreateProfileUpReg();

   inline tBool operator==(const profile_mainfi_tclMsgcreateProfileUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgcreateProfileRelUpReg : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgcreateProfileRelUpReg();

   virtual ~profile_mainfi_tclMsgcreateProfileRelUpReg();

   inline tBool operator==(const profile_mainfi_tclMsgcreateProfileRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgcreateProfileStatus : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgcreateProfileStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   profile_mainfi_tclMsgcreateProfileStatus& operator=(const profile_mainfi_tclMsgcreateProfileStatus& coRef);
   profile_mainfi_tclMsgcreateProfileStatus(const profile_mainfi_tclMsgcreateProfileStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ID;
   virtual ~profile_mainfi_tclMsgcreateProfileStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const profile_mainfi_tclMsgcreateProfileStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgprivacyStatusUpReg : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgprivacyStatusUpReg();

   virtual ~profile_mainfi_tclMsgprivacyStatusUpReg();

   inline tBool operator==(const profile_mainfi_tclMsgprivacyStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgprivacyStatusRelUpReg : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgprivacyStatusRelUpReg();

   virtual ~profile_mainfi_tclMsgprivacyStatusRelUpReg();

   inline tBool operator==(const profile_mainfi_tclMsgprivacyStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgprivacyStatusGet : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgprivacyStatusGet();

   virtual ~profile_mainfi_tclMsgprivacyStatusGet();

   inline tBool operator==(const profile_mainfi_tclMsgprivacyStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class profile_mainfi_tclMsgprivacyStatusStatus : public profile_mainfi_tclMsgBaseMessage
{
public:

   profile_mainfi_tclMsgprivacyStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   profile_mainfi_tclMsgprivacyStatusStatus& operator=(const profile_mainfi_tclMsgprivacyStatusStatus& coRef);
   profile_mainfi_tclMsgprivacyStatusStatus(const profile_mainfi_tclMsgprivacyStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Privacy;
   virtual ~profile_mainfi_tclMsgprivacyStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const profile_mainfi_tclMsgprivacyStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
