#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define PROFILE_FI_S_IMPORT_INTERFACE_PROFILE_MAINFI_STDVISITORS
#include "profile_fi_if.h"

tBool profile_mainfi_tclDescription::bInitMessage(profile_mainfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case profile_mainfi_tclToken::EN_LAST_TOKEN:
   case profile_mainfi_tclToken::EN_LIST:
   case profile_mainfi_tclToken::EN_END_OF_STRUCT:
   case profile_mainfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case profile_mainfi_tclToken::EN_MSG_DOCHANGETOPROFILEMETHODSTART:
   {
      bResult = oPath.bGoDown(profile_mainfi_tclKnot(profile_mainfi_tclToken::EN_U8,profile_mainfi_tclSemanticDomain::EN_MSG_NEWUSERID)) && bResult;
   } break;
   case profile_mainfi_tclToken::EN_MSG_DOCHANGETOPROFILEMETHODRESULT:
   {
      bResult = oPath.bGoDown(profile_mainfi_tclKnot(profile_mainfi_tclToken::EN_E8_CHANGEPROFILERESULT,profile_mainfi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case profile_mainfi_tclToken::EN_MSG_DOCOPYPROFILEMETHODSTART:
   {
      bResult = oPath.bGoDown(profile_mainfi_tclKnot(profile_mainfi_tclToken::EN_U8,profile_mainfi_tclSemanticDomain::EN_MSG_DESTINATIONID)) && bResult;
      bResult = oPath.bGoDown(profile_mainfi_tclKnot(profile_mainfi_tclToken::EN_U8,profile_mainfi_tclSemanticDomain::EN_MSG_SOURCEID)) && bResult;
   } break;
   case profile_mainfi_tclToken::EN_MSG_DOCOPYPROFILEMETHODRESULT:
   {
      bResult = oPath.bGoDown(profile_mainfi_tclKnot(profile_mainfi_tclToken::EN_E8_CHANGEPROFILERESULT,profile_mainfi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case profile_mainfi_tclToken::EN_MSG_DODELETEPROFILEMETHODSTART:
   {
      bResult = oPath.bGoDown(profile_mainfi_tclKnot(profile_mainfi_tclToken::EN_U8,profile_mainfi_tclSemanticDomain::EN_MSG_USERID)) && bResult;
   } break;
   case profile_mainfi_tclToken::EN_MSG_DODELETEPROFILEMETHODRESULT:
   {
      bResult = oPath.bGoDown(profile_mainfi_tclKnot(profile_mainfi_tclToken::EN_E8_CHANGEPROFILERESULT,profile_mainfi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case profile_mainfi_tclToken::EN_MSG_DOCREATEPROFILEMETHODSTART:
   {
      bResult = oPath.bGoDown(profile_mainfi_tclKnot(profile_mainfi_tclToken::EN_U8,profile_mainfi_tclSemanticDomain::EN_MSG_IMAGEID)) && bResult;
      bResult = oPath.bGoDown(profile_mainfi_tclKnot(profile_mainfi_tclToken::EN_STRING,profile_mainfi_tclSemanticDomain::EN_MSG_NAME)) && bResult;
   } break;
   case profile_mainfi_tclToken::EN_MSG_DOCREATEPROFILEMETHODRESULT:
   {
      bResult = oPath.bGoDown(profile_mainfi_tclKnot(profile_mainfi_tclToken::EN_U8,profile_mainfi_tclSemanticDomain::EN_MSG_USERID)) && bResult;
      bResult = oPath.bGoDown(profile_mainfi_tclKnot(profile_mainfi_tclToken::EN_E8_CHANGEPROFILERESULT,profile_mainfi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case profile_mainfi_tclToken::EN_MSG_ONDATACHANGEDMETHODSTART:
   {
      bResult = oPath.bGoDown(profile_mainfi_tclKnot(profile_mainfi_tclToken::EN_E8_DATACHANGEDRESPONSE,profile_mainfi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case profile_mainfi_tclToken::EN_MSG_ONPROFILECREATEDMETHODSTART:
   {
      bResult = oPath.bGoDown(profile_mainfi_tclKnot(profile_mainfi_tclToken::EN_E8_CLIENTRESPONSE,profile_mainfi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case profile_mainfi_tclToken::EN_MSG_ONPROFILECOPIEDMETHODSTART:
   {
      bResult = oPath.bGoDown(profile_mainfi_tclKnot(profile_mainfi_tclToken::EN_E8_CLIENTRESPONSE,profile_mainfi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case profile_mainfi_tclToken::EN_MSG_ONPROFILEDELETEDMETHODSTART:
   {
      bResult = oPath.bGoDown(profile_mainfi_tclKnot(profile_mainfi_tclToken::EN_E8_CLIENTRESPONSE,profile_mainfi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case profile_mainfi_tclToken::EN_MSG_REGISTERCLIENTMETHODRESULT:
   {
      bResult = oPath.bGoDown(profile_mainfi_tclKnot(profile_mainfi_tclToken::EN_BOOL,profile_mainfi_tclSemanticDomain::EN_MSG_BRELOADDATA)) && bResult;
   } break;
   case profile_mainfi_tclToken::EN_MSG_ACTIVEPROFILESTATUS:
   {
      bResult = oPath.bGoDown(profile_mainfi_tclKnot(profile_mainfi_tclToken::EN_U8,profile_mainfi_tclSemanticDomain::EN_MSG_ID)) && bResult;
   } break;
   case profile_mainfi_tclToken::EN_MSG_STATUSSTATUS:
   {
      bResult = oPath.bGoDown(profile_mainfi_tclKnot(profile_mainfi_tclToken::EN_E8_PROFILESTATUS,profile_mainfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
   } break;
   case profile_mainfi_tclToken::EN_MSG_COPYPROFILESTATUS:
   {
      bResult = oPath.bGoDown(profile_mainfi_tclKnot(profile_mainfi_tclToken::EN_U8,profile_mainfi_tclSemanticDomain::EN_MSG_DESTINATIONID)) && bResult;
      bResult = oPath.bGoDown(profile_mainfi_tclKnot(profile_mainfi_tclToken::EN_U8,profile_mainfi_tclSemanticDomain::EN_MSG_SOURCEID)) && bResult;
   } break;
   case profile_mainfi_tclToken::EN_MSG_DELETEPROFILESTATUS:
   {
      bResult = oPath.bGoDown(profile_mainfi_tclKnot(profile_mainfi_tclToken::EN_U8,profile_mainfi_tclSemanticDomain::EN_MSG_PROFILEID)) && bResult;
   } break;
   case profile_mainfi_tclToken::EN_MSG_DATACHANGEDSTATUS:
   {
      bResult = oPath.bGoDown(profile_mainfi_tclKnot(profile_mainfi_tclToken::EN_E8_CHANGEPROFILE,profile_mainfi_tclSemanticDomain::EN_MSG_REASON)) && bResult;
   } break;
   case profile_mainfi_tclToken::EN_MSG_CREATEPROFILESTATUS:
   {
      bResult = oPath.bGoDown(profile_mainfi_tclKnot(profile_mainfi_tclToken::EN_U8,profile_mainfi_tclSemanticDomain::EN_MSG_ID)) && bResult;
   } break;
   case profile_mainfi_tclToken::EN_MSG_PRIVACYSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(profile_mainfi_tclKnot(profile_mainfi_tclToken::EN_U32,profile_mainfi_tclSemanticDomain::EN_MSG_PRIVACY)) && bResult;
   } break;
   case profile_mainfi_tclToken::EN_MSG_REGISTERCLIENTMETHODSTART:
   case profile_mainfi_tclToken::EN_MSG_ACTIVEPROFILEUPREG:
   case profile_mainfi_tclToken::EN_MSG_ACTIVEPROFILERELUPREG:
   case profile_mainfi_tclToken::EN_MSG_ACTIVEPROFILEGET:
   case profile_mainfi_tclToken::EN_MSG_STATUSUPREG:
   case profile_mainfi_tclToken::EN_MSG_STATUSRELUPREG:
   case profile_mainfi_tclToken::EN_MSG_STATUSGET:
   case profile_mainfi_tclToken::EN_MSG_COPYPROFILEUPREG:
   case profile_mainfi_tclToken::EN_MSG_COPYPROFILERELUPREG:
   case profile_mainfi_tclToken::EN_MSG_DELETEPROFILEUPREG:
   case profile_mainfi_tclToken::EN_MSG_DELETEPROFILERELUPREG:
   case profile_mainfi_tclToken::EN_MSG_DATACHANGEDUPREG:
   case profile_mainfi_tclToken::EN_MSG_DATACHANGEDRELUPREG:
   case profile_mainfi_tclToken::EN_MSG_CREATEPROFILEUPREG:
   case profile_mainfi_tclToken::EN_MSG_CREATEPROFILERELUPREG:
   case profile_mainfi_tclToken::EN_MSG_PRIVACYSTATUSUPREG:
   case profile_mainfi_tclToken::EN_MSG_PRIVACYSTATUSRELUPREG:
   case profile_mainfi_tclToken::EN_MSG_PRIVACYSTATUSGET:
   case profile_mainfi_tclToken::EN_BINCONTAINER:
   case profile_mainfi_tclToken::EN_E8_CHANGEPROFILERESULT:
   case profile_mainfi_tclToken::EN_E8_CLIENTRESPONSE:
   case profile_mainfi_tclToken::EN_E8_DATACHANGEDRESPONSE:
   case profile_mainfi_tclToken::EN_E8_PROFILESTATUS:
   case profile_mainfi_tclToken::EN_E8_CHANGEPROFILE:
   case profile_mainfi_tclToken::EN_U8:   
   case profile_mainfi_tclToken::EN_S8:   
   case profile_mainfi_tclToken::EN_U16:   
   case profile_mainfi_tclToken::EN_S16:   
   case profile_mainfi_tclToken::EN_U24:   
   case profile_mainfi_tclToken::EN_S24:   
   case profile_mainfi_tclToken::EN_U32:   
   case profile_mainfi_tclToken::EN_S32:   
   case profile_mainfi_tclToken::EN_U64:   
   case profile_mainfi_tclToken::EN_S64:   
   case profile_mainfi_tclToken::EN_F32:   
   case profile_mainfi_tclToken::EN_F64:   
   case profile_mainfi_tclToken::EN_BOOL:   
   case profile_mainfi_tclToken::EN_STRING:   
   case profile_mainfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(profile_mainfi_tclKnot(enMsgToken,profile_mainfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool profile_mainfi_tclDescription::bDoIt(profile_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool profile_mainfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      profile_mainfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      profile_mainfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      profile_mainfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == profile_mainfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(profile_mainfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(profile_mainfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(profile_mainfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case profile_mainfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == profile_mainfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case profile_mainfi_tclToken::EN_LIST: 
      {
         profile_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            profile_mainfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(profile_mainfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            profile_mainfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(profile_mainfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case profile_mainfi_tclToken::EN_U8: 
      {
         profile_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case profile_mainfi_tclToken::EN_U16: 
      {
         profile_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case profile_mainfi_tclToken::EN_U24: 
      {
         profile_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case profile_mainfi_tclToken::EN_U32: 
      {
         profile_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case profile_mainfi_tclToken::EN_U64: 
      {
         profile_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case profile_mainfi_tclToken::EN_S8: 
      {
         profile_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case profile_mainfi_tclToken::EN_S16: 
      {
         profile_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case profile_mainfi_tclToken::EN_S24: 
      {
         profile_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case profile_mainfi_tclToken::EN_S32: 
      {
         profile_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case profile_mainfi_tclToken::EN_S64: 
      {
         profile_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case profile_mainfi_tclToken::EN_F32: 
      {
         profile_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case profile_mainfi_tclToken::EN_F64: 
      {
         profile_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case profile_mainfi_tclToken::EN_BOOL: 
      {
         profile_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case profile_mainfi_tclToken::EN_STRING: 
      {
         profile_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case profile_mainfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         profile_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case profile_mainfi_tclToken::EN_MSG_DOCHANGETOPROFILEMETHODSTART:
      case profile_mainfi_tclToken::EN_MSG_DOCHANGETOPROFILEMETHODRESULT:
      case profile_mainfi_tclToken::EN_MSG_DOCOPYPROFILEMETHODSTART:
      case profile_mainfi_tclToken::EN_MSG_DOCOPYPROFILEMETHODRESULT:
      case profile_mainfi_tclToken::EN_MSG_DODELETEPROFILEMETHODSTART:
      case profile_mainfi_tclToken::EN_MSG_DODELETEPROFILEMETHODRESULT:
      case profile_mainfi_tclToken::EN_MSG_DOCREATEPROFILEMETHODSTART:
      case profile_mainfi_tclToken::EN_MSG_DOCREATEPROFILEMETHODRESULT:
      case profile_mainfi_tclToken::EN_MSG_ONDATACHANGEDMETHODSTART:
      case profile_mainfi_tclToken::EN_MSG_ONPROFILECREATEDMETHODSTART:
      case profile_mainfi_tclToken::EN_MSG_ONPROFILECOPIEDMETHODSTART:
      case profile_mainfi_tclToken::EN_MSG_ONPROFILEDELETEDMETHODSTART:
      case profile_mainfi_tclToken::EN_MSG_REGISTERCLIENTMETHODSTART:
      case profile_mainfi_tclToken::EN_MSG_REGISTERCLIENTMETHODRESULT:
      case profile_mainfi_tclToken::EN_MSG_ACTIVEPROFILEUPREG:
      case profile_mainfi_tclToken::EN_MSG_ACTIVEPROFILERELUPREG:
      case profile_mainfi_tclToken::EN_MSG_ACTIVEPROFILEGET:
      case profile_mainfi_tclToken::EN_MSG_ACTIVEPROFILESTATUS:
      case profile_mainfi_tclToken::EN_MSG_STATUSUPREG:
      case profile_mainfi_tclToken::EN_MSG_STATUSRELUPREG:
      case profile_mainfi_tclToken::EN_MSG_STATUSGET:
      case profile_mainfi_tclToken::EN_MSG_STATUSSTATUS:
      case profile_mainfi_tclToken::EN_MSG_COPYPROFILEUPREG:
      case profile_mainfi_tclToken::EN_MSG_COPYPROFILERELUPREG:
      case profile_mainfi_tclToken::EN_MSG_COPYPROFILESTATUS:
      case profile_mainfi_tclToken::EN_MSG_DELETEPROFILEUPREG:
      case profile_mainfi_tclToken::EN_MSG_DELETEPROFILERELUPREG:
      case profile_mainfi_tclToken::EN_MSG_DELETEPROFILESTATUS:
      case profile_mainfi_tclToken::EN_MSG_DATACHANGEDUPREG:
      case profile_mainfi_tclToken::EN_MSG_DATACHANGEDRELUPREG:
      case profile_mainfi_tclToken::EN_MSG_DATACHANGEDSTATUS:
      case profile_mainfi_tclToken::EN_MSG_CREATEPROFILEUPREG:
      case profile_mainfi_tclToken::EN_MSG_CREATEPROFILERELUPREG:
      case profile_mainfi_tclToken::EN_MSG_CREATEPROFILESTATUS:
      case profile_mainfi_tclToken::EN_MSG_PRIVACYSTATUSUPREG:
      case profile_mainfi_tclToken::EN_MSG_PRIVACYSTATUSRELUPREG:
      case profile_mainfi_tclToken::EN_MSG_PRIVACYSTATUSGET:
      case profile_mainfi_tclToken::EN_MSG_PRIVACYSTATUSSTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case profile_mainfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(profile_mainfi_tclKnot(profile_mainfi_tclToken::EN_END_OF_STRUCT,profile_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(profile_mainfi_tclKnot(profile_mainfi_tclToken::EN_U8,profile_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(profile_mainfi_tclKnot(profile_mainfi_tclToken::EN_LIST,profile_mainfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         profile_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case profile_mainfi_tclToken::EN_E8_CHANGEPROFILERESULT:
      {
         profile_fi_tcl_e8_ChangeProfileResult o_e8_ChangeProfileResult;
         if (!bDoIt(o_e8_ChangeProfileResult))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case profile_mainfi_tclToken::EN_E8_CLIENTRESPONSE:
      {
         profile_fi_tcl_e8_ClientResponse o_e8_ClientResponse;
         if (!bDoIt(o_e8_ClientResponse))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case profile_mainfi_tclToken::EN_E8_DATACHANGEDRESPONSE:
      {
         profile_fi_tcl_e8_DataChangedResponse o_e8_DataChangedResponse;
         if (!bDoIt(o_e8_DataChangedResponse))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case profile_mainfi_tclToken::EN_E8_PROFILESTATUS:
      {
         profile_fi_tcl_e8_profileStatus o_e8_profileStatus;
         if (!bDoIt(o_e8_profileStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case profile_mainfi_tclToken::EN_E8_CHANGEPROFILE:
      {
         profile_fi_tcl_e8_changeProfile o_e8_changeProfile;
         if (!bDoIt(o_e8_changeProfile))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case profile_mainfi_tclToken::EN_UNKNOWN:
      case profile_mainfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

