#ifndef MPLAY_FIVISITOR_HEADER
#define MPLAY_FIVISITOR_HEADER

// --Basisklasse fuer eine FI-Besucher-Klasse

class mplay_fi_tclOutput {
public:
   mplay_fi_tclOutput();
   virtual ~mplay_fi_tclOutput(){};

   virtual tVoid vPrintLine(tCString coszLine) = 0;
};

class mplay_fi_tclFileOutput : public mplay_fi_tclOutput 
{
public:
   mplay_fi_tclFileOutput(OSAL_tIODescriptor rIOD):fd(rIOD) {}
   virtual tVoid vPrintLine(tCString coszLine);
protected:
   OSAL_tIODescriptor fd;
private:
   mplay_fi_tclFileOutput(); //lint !e1704
   mplay_fi_tclFileOutput& operator=(const mplay_fi_tclFileOutput& coRef);
   mplay_fi_tclFileOutput(const mplay_fi_tclFileOutput& coRef); //lint !e1704
};

class mplay_fi_tclMemOutput : public mplay_fi_tclOutput
{
public:
   mplay_fi_tclMemOutput(tU32 u32MemSize);
   virtual ~mplay_fi_tclMemOutput();
   virtual tVoid vPrintLine(tCString coszLine);
   tString szGetBuffer();
protected:
   tChar* szBuf;
   tChar* szEndBuf;
   tChar* s8BufPos;
private:
   mplay_fi_tclMemOutput(); //lint !e1704
   mplay_fi_tclMemOutput(const mplay_fi_tclMemOutput& coRef); //lint !e1704
   mplay_fi_tclMemOutput& operator=(const mplay_fi_tclMemOutput& coRef); //lint !e1704
};

class MY_DECL mplay_fi_tclVisitorBase {
public:

   // --Konstruktor
   mplay_fi_tclVisitorBase():bBreakNow(FALSE),bIsVisitorValid(FALSE) {}
   virtual ~mplay_fi_tclVisitorBase() {}

   tBool bIsValid() const { return bIsVisitorValid; }
   tVoid vInvalidate() { bIsVisitorValid=FALSE; }
   tVoid vValidate() { bIsVisitorValid=TRUE; }
   tBool bBreak() const { return bBreakNow; }
   tVoid vReleaseBreak() { bBreakNow = FALSE; }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(mplay_fi_tclU8& oU8);
   virtual tVoid vVisitS8(mplay_fi_tclS8& oS8);
   virtual tVoid vVisitU16(mplay_fi_tclU16& oU16);
   virtual tVoid vVisitS16(mplay_fi_tclS16& oS16);
   virtual tVoid vVisitU24(mplay_fi_tclU24& oU24);
   virtual tVoid vVisitS24(mplay_fi_tclS24& oS24);
   virtual tVoid vVisitU32(mplay_fi_tclU32& oU32);
   virtual tVoid vVisitS32(mplay_fi_tclS32& oS32);
   virtual tVoid vVisitU64(mplay_fi_tclU64& oU64);
   virtual tVoid vVisitS64(mplay_fi_tclS64& oS64);
   virtual tVoid vVisitF32(mplay_fi_tclF32& oF32);
   virtual tVoid vVisitF64(mplay_fi_tclF64& oF64);
   virtual tVoid vVisitBool(mplay_fi_tclBool& oBool);
   virtual tVoid vVisitString(mplay_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(mplay_fi_tclMultiLanguageString& oString);

   virtual tVoid vVisitList(mplay_fi_tclList& oList);
   virtual tVoid vVisit_BinContainer(mplay_fi_tcl_BinContainer& oBinContainer);

   virtual tVoid vVisit_ShortStream(mplay_fi_tcl_ShortStream& oShortStream);

   virtual tVoid vVisit_e8_EjectOpticalDisc_MethodResult(mplay_fi_tcl_e8_EjectOpticalDisc_MethodResult& oe8_EjectOpticalDisc_MethodResult);

   virtual tVoid vVisit_e8_SlotStateOpticalDiscType(mplay_fi_tcl_e8_SlotStateOpticalDiscType& oe8_SlotStateOpticalDiscType);

   virtual tVoid vVisit_e8_EjectParmType(mplay_fi_tcl_e8_EjectParmType& oe8_EjectParmType);

   virtual tVoid vVisit_e8DeviceState(mplay_fi_tcl_e8DeviceState& oe8DeviceState);

   virtual tVoid vVisit_e8_CDInfo(mplay_fi_tcl_e8_CDInfo& oe8_CDInfo);

   virtual tVoid vVisit_e8_DVDCommandStatus(mplay_fi_tcl_e8_DVDCommandStatus& oe8_DVDCommandStatus);

   virtual tVoid vVisit_e8_MDVDDiscType(mplay_fi_tcl_e8_MDVDDiscType& oe8_MDVDDiscType);

   virtual tVoid vVisit_e8_MDVDDriveMode(mplay_fi_tcl_e8_MDVDDriveMode& oe8_MDVDDriveMode);

   virtual tVoid vVisit_e8_MAngle(mplay_fi_tcl_e8_MAngle& oe8_MAngle);

   virtual tVoid vVisit_e8_MAudioOutputNumber(mplay_fi_tcl_e8_MAudioOutputNumber& oe8_MAudioOutputNumber);

   virtual tVoid vVisit_e8_MChannelAssignment(mplay_fi_tcl_e8_MChannelAssignment& oe8_MChannelAssignment);

   virtual tVoid vVisit_e8_MCMSkipValue(mplay_fi_tcl_e8_MCMSkipValue& oe8_MCMSkipValue);

   virtual tVoid vVisit_e8_MDiscError(mplay_fi_tcl_e8_MDiscError& oe8_MDiscError);

   virtual tVoid vVisit_e8_MDiscMechanicalInfo(mplay_fi_tcl_e8_MDiscMechanicalInfo& oe8_MDiscMechanicalInfo);

   virtual tVoid vVisit_e8_MDiscOperation(mplay_fi_tcl_e8_MDiscOperation& oe8_MDiscOperation);

   virtual tVoid vVisit_e8_MDiscType(mplay_fi_tcl_e8_MDiscType& oe8_MDiscType);

   virtual tVoid vVisit_e8_MDisplayMode(mplay_fi_tcl_e8_MDisplayMode& oe8_MDisplayMode);

   virtual tVoid vVisit_e8_MDRCSetting(mplay_fi_tcl_e8_MDRCSetting& oe8_MDRCSetting);

   virtual tVoid vVisit_e8_MGeneralSelectionType(mplay_fi_tcl_e8_MGeneralSelectionType& oe8_MGeneralSelectionType);

   virtual tVoid vVisit_e8_MMenuControlData(mplay_fi_tcl_e8_MMenuControlData& oe8_MMenuControlData);

   virtual tVoid vVisit_e8_MNavigationKey(mplay_fi_tcl_e8_MNavigationKey& oe8_MNavigationKey);

   virtual tVoid vVisit_e8_MPlayAction(mplay_fi_tcl_e8_MPlayAction& oe8_MPlayAction);

   virtual tVoid vVisit_e8_MPlayAudioChannelFormat(mplay_fi_tcl_e8_MPlayAudioChannelFormat& oe8_MPlayAudioChannelFormat);

   virtual tVoid vVisit_e8_MPlayAvailabilityReason(mplay_fi_tcl_e8_MPlayAvailabilityReason& oe8_MPlayAvailabilityReason);

   virtual tVoid vVisit_e8_MPlaybackDirection(mplay_fi_tcl_e8_MPlaybackDirection& oe8_MPlaybackDirection);

   virtual tVoid vVisit_e8_MPlaybackSpeed(mplay_fi_tcl_e8_MPlaybackSpeed& oe8_MPlaybackSpeed);

   virtual tVoid vVisit_e8_MPlayCategoryType(mplay_fi_tcl_e8_MPlayCategoryType& oe8_MPlayCategoryType);

   virtual tVoid vVisit_e8_MPlayChange(mplay_fi_tcl_e8_MPlayChange& oe8_MPlayChange);

   virtual tVoid vVisit_e8_MPlayConnectionState(mplay_fi_tcl_e8_MPlayConnectionState& oe8_MPlayConnectionState);

   virtual tVoid vVisit_e8_MPlayConnectionType(mplay_fi_tcl_e8_MPlayConnectionType& oe8_MPlayConnectionType);

   virtual tVoid vVisit_e8_MPlayDeleteMediaContentTaskResult(mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult& oe8_MPlayDeleteMediaContentTaskResult);

   virtual tVoid vVisit_e8_MPlayDeviceControlSupport(mplay_fi_tcl_e8_MPlayDeviceControlSupport& oe8_MPlayDeviceControlSupport);

   virtual tVoid vVisit_e8_MPlayDeviceIndexedState(mplay_fi_tcl_e8_MPlayDeviceIndexedState& oe8_MPlayDeviceIndexedState);

   virtual tVoid vVisit_e8_MPlayDeviceRippingState(mplay_fi_tcl_e8_MPlayDeviceRippingState& oe8_MPlayDeviceRippingState);

   virtual tVoid vVisit_e8_MPlayDeviceStatus(mplay_fi_tcl_e8_MPlayDeviceStatus& oe8_MPlayDeviceStatus);

   virtual tVoid vVisit_e8_MPlayDeviceType(mplay_fi_tcl_e8_MPlayDeviceType& oe8_MPlayDeviceType);

   virtual tVoid vVisit_e8_MPlayDisconnectReason(mplay_fi_tcl_e8_MPlayDisconnectReason& oe8_MPlayDisconnectReason);

   virtual tVoid vVisit_e8_MPlayEditMetaDataTaskResult(mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult& oe8_MPlayEditMetaDataTaskResult);

   virtual tVoid vVisit_e8_MPlayEncodingQuality(mplay_fi_tcl_e8_MPlayEncodingQuality& oe8_MPlayEncodingQuality);

   virtual tVoid vVisit_e8_MPlayFileFormat(mplay_fi_tcl_e8_MPlayFileFormat& oe8_MPlayFileFormat);

   virtual tVoid vVisit_e8_MPlayFileSystemType(mplay_fi_tcl_e8_MPlayFileSystemType& oe8_MPlayFileSystemType);

   virtual tVoid vVisit_e8_MPlayFileType(mplay_fi_tcl_e8_MPlayFileType& oe8_MPlayFileType);

   virtual tVoid vVisit_e8_MPlayFileTypeSelection(mplay_fi_tcl_e8_MPlayFileTypeSelection& oe8_MPlayFileTypeSelection);

   virtual tVoid vVisit_e8_MPlayGNmetadataExtractionResult(mplay_fi_tcl_e8_MPlayGNmetadataExtractionResult& oe8_MPlayGNmetadataExtractionResult);

   virtual tVoid vVisit_e8_MPlayInternalPlaylistTaskResult(mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult& oe8_MPlayInternalPlaylistTaskResult);

   virtual tVoid vVisit_e8_MPlayiPodCommunicationError(mplay_fi_tcl_e8_MPlayiPodCommunicationError& oe8_MPlayiPodCommunicationError);

   virtual tVoid vVisit_e8_MPlayLanguage(mplay_fi_tcl_e8_MPlayLanguage& oe8_MPlayLanguage);

   virtual tVoid vVisit_e8_MPlayListType(mplay_fi_tcl_e8_MPlayListType& oe8_MPlayListType);

   virtual tVoid vVisit_e8_MPlayMediaType(mplay_fi_tcl_e8_MPlayMediaType& oe8_MPlayMediaType);

   virtual tVoid vVisit_e8_MPlayMode(mplay_fi_tcl_e8_MPlayMode& oe8_MPlayMode);

   virtual tVoid vVisit_e8_MPlayNowPlayingState(mplay_fi_tcl_e8_MPlayNowPlayingState& oe8_MPlayNowPlayingState);

   virtual tVoid vVisit_e8_MPlayPlayableStatus(mplay_fi_tcl_e8_MPlayPlayableStatus& oe8_MPlayPlayableStatus);

   virtual tVoid vVisit_e8_MPlayPlaypointFormat(mplay_fi_tcl_e8_MPlayPlaypointFormat& oe8_MPlayPlaypointFormat);

   virtual tVoid vVisit_e8_MPlayRepeat(mplay_fi_tcl_e8_MPlayRepeat& oe8_MPlayRepeat);

   virtual tVoid vVisit_e8_MPlayState(mplay_fi_tcl_e8_MPlayState& oe8_MPlayState);

   virtual tVoid vVisit_e8_MPlayStreamingInfo(mplay_fi_tcl_e8_MPlayStreamingInfo& oe8_MPlayStreamingInfo);

   virtual tVoid vVisit_e8_MPlayTagTransferStatus(mplay_fi_tcl_e8_MPlayTagTransferStatus& oe8_MPlayTagTransferStatus);

   virtual tVoid vVisit_e8_MPlayUmountResult(mplay_fi_tcl_e8_MPlayUmountResult& oe8_MPlayUmountResult);

   virtual tVoid vVisit_e8_MSoundFormat(mplay_fi_tcl_e8_MSoundFormat& oe8_MSoundFormat);

   virtual tVoid vVisit_e8_MSubtitleSelectionType(mplay_fi_tcl_e8_MSubtitleSelectionType& oe8_MSubtitleSelectionType);

   virtual tVoid vVisit_e8_MTotalChannel(mplay_fi_tcl_e8_MTotalChannel& oe8_MTotalChannel);

   virtual tVoid vVisit_e8_MTouchAction(mplay_fi_tcl_e8_MTouchAction& oe8_MTouchAction);

   virtual tVoid vVisit_e8_MVCDAudioMode(mplay_fi_tcl_e8_MVCDAudioMode& oe8_MVCDAudioMode);

   virtual tVoid vVisit_e8_QuickSearchResult(mplay_fi_tcl_e8_QuickSearchResult& oe8_QuickSearchResult);

   virtual tVoid vVisit_MInternalDVDLangSetting(mplay_fi_tcl_MInternalDVDLangSetting& oMInternalDVDLangSetting);

   virtual tVoid vVisit_e_MPlayDeviceDBViewStatus(mplay_fi_tcl_e_MPlayDeviceDBViewStatus& oe_MPlayDeviceDBViewStatus);

   virtual tVoid vVisit_MPlayDeviceInfoItem(mplay_fi_tcl_MPlayDeviceInfoItem& oMPlayDeviceInfoItem);

   virtual tVoid vVisit_MPlayFavoritesList(mplay_fi_tcl_MPlayFavoritesList& oMPlayFavoritesList);

   virtual tVoid vVisit_MPlayFileListItem(mplay_fi_tcl_MPlayFileListItem& oMPlayFileListItem);

   virtual tVoid vVisit_MPlayFileList(mplay_fi_tcl_MPlayFileList& oMPlayFileList);

   virtual tVoid vVisit_MPlayImageData(mplay_fi_tcl_MPlayImageData& oMPlayImageData);

   virtual tVoid vVisit_MPlayImageObjectItem(mplay_fi_tcl_MPlayImageObjectItem& oMPlayImageObjectItem);

   virtual tVoid vVisit_MPlayImageObjects(mplay_fi_tcl_MPlayImageObjects& oMPlayImageObjects);

   virtual tVoid vVisit_MPlayIndexingStateResultItem(mplay_fi_tcl_MPlayIndexingStateResultItem& oMPlayIndexingStateResultItem);

   virtual tVoid vVisit_MPlayIndexingStateResult(mplay_fi_tcl_MPlayIndexingStateResult& oMPlayIndexingStateResult);

   virtual tVoid vVisit_MPlayItems(mplay_fi_tcl_MPlayItems& oMPlayItems);

   virtual tVoid vVisit_MPlayMediaAlbums(mplay_fi_tcl_MPlayMediaAlbums& oMPlayMediaAlbums);

   virtual tVoid vVisit_MPlayMediaObject(mplay_fi_tcl_MPlayMediaObject& oMPlayMediaObject);

   virtual tVoid vVisit_MPlayMediaObjectsItem(mplay_fi_tcl_MPlayMediaObjectsItem& oMPlayMediaObjectsItem);

   virtual tVoid vVisit_MPlayMediaObjects(mplay_fi_tcl_MPlayMediaObjects& oMPlayMediaObjects);

   virtual tVoid vVisit_MPlayMediaObjectTag(mplay_fi_tcl_MPlayMediaObjectTag& oMPlayMediaObjectTag);

   virtual tVoid vVisit_MPlayMediaObjectUrl(mplay_fi_tcl_MPlayMediaObjectUrl& oMPlayMediaObjectUrl);

   virtual tVoid vVisit_PermissionByTag(mplay_fi_tcl_PermissionByTag& oPermissionByTag);

   virtual tVoid vVisit_MPlayPlayListPosition(mplay_fi_tcl_MPlayPlayListPosition& oMPlayPlayListPosition);

   virtual tVoid vVisit_MPlayRippingErrors(mplay_fi_tcl_MPlayRippingErrors& oMPlayRippingErrors);

   virtual tVoid vVisit_MPlayRippingStateResultItem(mplay_fi_tcl_MPlayRippingStateResultItem& oMPlayRippingStateResultItem);

   virtual tVoid vVisit_MPlaySearchKeyboardListItem(mplay_fi_tcl_MPlaySearchKeyboardListItem& oMPlaySearchKeyboardListItem);

   virtual tVoid vVisit_MPlaySearchKeyboardList(mplay_fi_tcl_MPlaySearchKeyboardList& oMPlaySearchKeyboardList);

   virtual tVoid vVisit_MPlayTagTransferItem_1(mplay_fi_tcl_MPlayTagTransferItem_1& oMPlayTagTransferItem_1);

   virtual tVoid vVisit_MPlayTagTransferItem_2(mplay_fi_tcl_MPlayTagTransferItem_2& oMPlayTagTransferItem_2);

   virtual tVoid vVisit_MPlayTagTransfer_1(mplay_fi_tcl_MPlayTagTransfer_1& oMPlayTagTransfer_1);

   virtual tVoid vVisit_MPlayTagTransfer_2(mplay_fi_tcl_MPlayTagTransfer_2& oMPlayTagTransfer_2);

   virtual tVoid vVisit_MPlayUntransferredTagStreamItem(mplay_fi_tcl_MPlayUntransferredTagStreamItem& oMPlayUntransferredTagStreamItem);

   virtual tVoid vVisit_MPlayUntransferredTagStream(mplay_fi_tcl_MPlayUntransferredTagStream& oMPlayUntransferredTagStream);

   virtual tVoid vVisit_MPlayPermissionByTag(mplay_fi_tcl_MPlayPermissionByTag& oMPlayPermissionByTag);

   virtual tVoid vVisit_SearchString(mplay_fi_tcl_SearchString& oSearchString);

   virtual tVoid vVisit_MPlaySearchType(mplay_fi_tcl_MPlaySearchType& oMPlaySearchType);

   virtual tVoid vVisit_VideoScalingType(mplay_fi_tcl_VideoScalingType& oVideoScalingType);

   virtual tVoid vVisit_IndicesType(mplay_fi_tcl_IndicesType& oIndicesType);

   virtual tVoid vVisit_IndicesList(mplay_fi_tcl_IndicesList& oIndicesList);

   virtual tVoid vVisit_AlbumArtUrlList(mplay_fi_tcl_AlbumArtUrlList& oAlbumArtUrlList);

   virtual tVoid vVisit_e_MPlayHIDCommand(mplay_fi_tcl_e_MPlayHIDCommand& oe_MPlayHIDCommand);

   virtual tVoid vVisit_e_MPlayKeyEvent(mplay_fi_tcl_e_MPlayKeyEvent& oe_MPlayKeyEvent);

   virtual tVoid vVisit_MPlayDeviceInfo(mplay_fi_tcl_MPlayDeviceInfo& oMPlayDeviceInfo);

   virtual tVoid vVisit_e8_DeviceConnectStatus(mplay_fi_tcl_e8_DeviceConnectStatus& oe8_DeviceConnectStatus);

   virtual tVoid vVisit_e8_Device(mplay_fi_tcl_e8_Device& oe8_Device);

   virtual tVoid vVisit_DevManager_PortStates(mplay_fi_tcl_DevManager_PortStates& oDevManager_PortStates);

   virtual tVoid vVisit_DVM_CardIdentifierRegister(mplay_fi_tcl_DVM_CardIdentifierRegister& oDVM_CardIdentifierRegister);

   virtual tVoid vVisit_e8_DVM_MediaState(mplay_fi_tcl_e8_DVM_MediaState& oe8_DVM_MediaState);

   virtual tVoid vVisit_e8_DVM_DeviceSpeedUsb(mplay_fi_tcl_e8_DVM_DeviceSpeedUsb& oe8_DVM_DeviceSpeedUsb);

   virtual tVoid vVisit_e8_DVM_UnsupportedReason(mplay_fi_tcl_e8_DVM_UnsupportedReason& oe8_DVM_UnsupportedReason);

   virtual tVoid vVisit_e8_FileSystem(mplay_fi_tcl_e8_FileSystem& oe8_FileSystem);

   virtual tVoid vVisit_e8_DVM_MediaType(mplay_fi_tcl_e8_DVM_MediaType& oe8_DVM_MediaType);

   virtual tVoid vVisit_e8_PowerStatus(mplay_fi_tcl_e8_PowerStatus& oe8_PowerStatus);

   virtual tVoid vVisit_DevManager_DeviceProperty(mplay_fi_tcl_DevManager_DeviceProperty& oDevManager_DeviceProperty);

   virtual tVoid vVisit_DevManager_DevInfoStr(mplay_fi_tcl_DevManager_DevInfoStr& oDevManager_DevInfoStr);

   virtual tVoid vVisit_DevManager_SDCardInfo(mplay_fi_tcl_DevManager_SDCardInfo& oDevManager_SDCardInfo);

   virtual tVoid vVisit_e8_SettingsMode(mplay_fi_tcl_e8_SettingsMode& oe8_SettingsMode);

   virtual tVoid vVisit_e8_AccessoryPowerMode(mplay_fi_tcl_e8_AccessoryPowerMode& oe8_AccessoryPowerMode);

   virtual tVoid vVisit_e8_BatteryChargingState(mplay_fi_tcl_e8_BatteryChargingState& oe8_BatteryChargingState);

   virtual tVoid vVisit_e8_DiPODeviceType(mplay_fi_tcl_e8_DiPODeviceType& oe8_DiPODeviceType);

   virtual tVoid vVisit_e8_DiPOConnectionType(mplay_fi_tcl_e8_DiPOConnectionType& oe8_DiPOConnectionType);

   virtual tVoid vVisit_e8_DiPOConnectionState(mplay_fi_tcl_e8_DiPOConnectionState& oe8_DiPOConnectionState);

   virtual tVoid vVisit_e8_DiPOCaps(mplay_fi_tcl_e8_DiPOCaps& oe8_DiPOCaps);

   virtual tVoid vVisit_e8_DiPODeviceStatus(mplay_fi_tcl_e8_DiPODeviceStatus& oe8_DiPODeviceStatus);

   virtual tVoid vVisit_e8_DiPOPlaypackAction(mplay_fi_tcl_e8_DiPOPlaypackAction& oe8_DiPOPlaypackAction);

   virtual tVoid vVisit_e8_DiPOPlaybackStatus(mplay_fi_tcl_e8_DiPOPlaybackStatus& oe8_DiPOPlaybackStatus);

   virtual tVoid vVisit_e8_DiPOPlaybackShuffleMode(mplay_fi_tcl_e8_DiPOPlaybackShuffleMode& oe8_DiPOPlaybackShuffleMode);

   virtual tVoid vVisit_e8_DiPOPlaybackRepeatMode(mplay_fi_tcl_e8_DiPOPlaybackRepeatMode& oe8_DiPOPlaybackRepeatMode);

   virtual tVoid vVisit_e8_DiPOResponse(mplay_fi_tcl_e8_DiPOResponse& oe8_DiPOResponse);

   virtual tVoid vVisit_e8_DiPORoleStatus(mplay_fi_tcl_e8_DiPORoleStatus& oe8_DiPORoleStatus);

   virtual tVoid vVisit_DiPODeviceInfoItem(mplay_fi_tcl_DiPODeviceInfoItem& oDiPODeviceInfoItem);

   virtual tVoid vVisit_DiPODeviceInfo(mplay_fi_tcl_DiPODeviceInfo& oDiPODeviceInfo);

   virtual tVoid vVisit_DiPOImageData(mplay_fi_tcl_DiPOImageData& oDiPOImageData);

   virtual tVoid vVisit_b8_DiPOLocationInfoType(mplay_fi_tcl_b8_DiPOLocationInfoType& ob8_DiPOLocationInfoType);

   virtual tVoid vVisit_b8_DiPOGPRMCDataStatusValues(mplay_fi_tcl_b8_DiPOGPRMCDataStatusValues& ob8_DiPOGPRMCDataStatusValues);

   virtual tVoid vVisit_e8_AudioError(mplay_fi_tcl_e8_AudioError& oe8_AudioError);

   virtual tVoid vVisit_e8_AppLaunchOption(mplay_fi_tcl_e8_AppLaunchOption& oe8_AppLaunchOption);

   virtual tVoid vVisit_b32_BTProfileType(mplay_fi_tcl_b32_BTProfileType& ob32_BTProfileType);

   virtual tVoid vVisit_BTProfileItem(mplay_fi_tcl_BTProfileItem& oBTProfileItem);

   virtual tVoid vVisit_BTProfileInfo(mplay_fi_tcl_BTProfileInfo& oBTProfileInfo);

   virtual tVoid vVisit_e8_DiPOCallStateUpdateStatus(mplay_fi_tcl_e8_DiPOCallStateUpdateStatus& oe8_DiPOCallStateUpdateStatus);

   virtual tVoid vVisit_e8_DiPOCallStateUpdateDirection(mplay_fi_tcl_e8_DiPOCallStateUpdateDirection& oe8_DiPOCallStateUpdateDirection);

   virtual tVoid vVisit_e8_DiPOCallStateUpdateService(mplay_fi_tcl_e8_DiPOCallStateUpdateService& oe8_DiPOCallStateUpdateService);

   virtual tVoid vVisit_e8_DiPOCallStateUpdateDisconnectReason(mplay_fi_tcl_e8_DiPOCallStateUpdateDisconnectReason& oe8_DiPOCallStateUpdateDisconnectReason);

   virtual tVoid vVisit_DiPOCallStateItem(mplay_fi_tcl_DiPOCallStateItem& oDiPOCallStateItem);

   virtual tVoid vVisit_DiPOCallStateUpdate(mplay_fi_tcl_DiPOCallStateUpdate& oDiPOCallStateUpdate);

   virtual tVoid vVisit_e8_DiPOCommunicationsUpdateSignalStrength(mplay_fi_tcl_e8_DiPOCommunicationsUpdateSignalStrength& oe8_DiPOCommunicationsUpdateSignalStrength);

   virtual tVoid vVisit_e8_DiPOCommunicationsUpdateRegistrationStatus(mplay_fi_tcl_e8_DiPOCommunicationsUpdateRegistrationStatus& oe8_DiPOCommunicationsUpdateRegistrationStatus);

   virtual tVoid vVisit_RouteGuidanceDisplayComponentIDs(mplay_fi_tcl_RouteGuidanceDisplayComponentIDs& oRouteGuidanceDisplayComponentIDs);

   virtual tVoid vVisit_e8_RouteGuidanceState(mplay_fi_tcl_e8_RouteGuidanceState& oe8_RouteGuidanceState);

   virtual tVoid vVisit_e8_ManeuverState(mplay_fi_tcl_e8_ManeuverState& oe8_ManeuverState);

   virtual tVoid vVisit_e8_DistanceDisplayUnits(mplay_fi_tcl_e8_DistanceDisplayUnits& oe8_DistanceDisplayUnits);

   virtual tVoid vVisit_RouteGuidanceManeuverCurrentList(mplay_fi_tcl_RouteGuidanceManeuverCurrentList& oRouteGuidanceManeuverCurrentList);

   virtual tVoid vVisit_e8_ManeuverType(mplay_fi_tcl_e8_ManeuverType& oe8_ManeuverType);

   virtual tVoid vVisit_e8_DrivingSide(mplay_fi_tcl_e8_DrivingSide& oe8_DrivingSide);

   virtual tVoid vVisit_e8_JunctionType(mplay_fi_tcl_e8_JunctionType& oe8_JunctionType);

   virtual tVoid vVisit_JunctionElementAngles(mplay_fi_tcl_JunctionElementAngles& oJunctionElementAngles);

   virtual tVoid vVisit_RouteGuidanceDisplayComponentItem(mplay_fi_tcl_RouteGuidanceDisplayComponentItem& oRouteGuidanceDisplayComponentItem);

   virtual tVoid vVisit_RouteGuidanceDisplayComponents(mplay_fi_tcl_RouteGuidanceDisplayComponents& oRouteGuidanceDisplayComponents);

   virtual tVoid vVisit_RouteGuidanceUpdate(mplay_fi_tcl_RouteGuidanceUpdate& oRouteGuidanceUpdate);

   virtual tVoid vVisit_RouteGuidanceManeuverUpdate(mplay_fi_tcl_RouteGuidanceManeuverUpdate& oRouteGuidanceManeuverUpdate);

   virtual tVoid vVisit_CallControlsConfiguration(mplay_fi_tcl_CallControlsConfiguration& oCallControlsConfiguration);

   virtual tVoid vVisit_e_InitiateCallType(mplay_fi_tcl_e_InitiateCallType& oe_InitiateCallType);

   virtual tVoid vVisit_e_InitiateCallService(mplay_fi_tcl_e_InitiateCallService& oe_InitiateCallService);

   virtual tVoid vVisit_e_AcceptAction(mplay_fi_tcl_e_AcceptAction& oe_AcceptAction);

   virtual tVoid vVisit_e_EndAction(mplay_fi_tcl_e_EndAction& oe_EndAction);

   virtual tVoid vVisit_e_SendDTMFTone(mplay_fi_tcl_e_SendDTMFTone& oe_SendDTMFTone);

   virtual tVoid vVisit_e8_DiPOCommunicationError(mplay_fi_tcl_e8_DiPOCommunicationError& oe8_DiPOCommunicationError);

   virtual tVoid vVisit_AppInfo(mplay_fi_tcl_AppInfo& oAppInfo);

   virtual tVoid vVisit_DeviceTimeUpdate(mplay_fi_tcl_DeviceTimeUpdate& oDeviceTimeUpdate);

   virtual tVoid vVisit_e8_CdType(mplay_fi_tcl_e8_CdType& oe8_CdType);

   virtual tVoid vVisit_e8_MediaState(mplay_fi_tcl_e8_MediaState& oe8_MediaState);

   virtual tVoid vVisit_e8_InsertState(mplay_fi_tcl_e8_InsertState& oe8_InsertState);

   virtual tVoid vVisit_e8_MMgr_MethodResult(mplay_fi_tcl_e8_MMgr_MethodResult& oe8_MMgr_MethodResult);

   virtual tVoid vVisit_e8DriveTempSensorStatus(mplay_fi_tcl_e8DriveTempSensorStatus& oe8DriveTempSensorStatus);

   virtual tVoid vVisit_e16_DiagDrv(mplay_fi_tcl_e16_DiagDrv& oe16_DiagDrv);

   virtual tVoid vVisit_e16_DiagDrvTestCmd(mplay_fi_tcl_e16_DiagDrvTestCmd& oe16_DiagDrvTestCmd);

   virtual tVoid vVisit_e16_DiagDrvTestParam(mplay_fi_tcl_e16_DiagDrvTestParam& oe16_DiagDrvTestParam);

   virtual tVoid vVisit_e16_DiagResultEject(mplay_fi_tcl_e16_DiagResultEject& oe16_DiagResultEject);

   virtual tVoid vVisit_e8_DiagLoadStatus(mplay_fi_tcl_e8_DiagLoadStatus& oe8_DiagLoadStatus);

   virtual tVoid vVisit_e8_DiagDuration(mplay_fi_tcl_e8_DiagDuration& oe8_DiagDuration);

   virtual tVoid vVisit_e8_DiagRetValueDriveTest(mplay_fi_tcl_e8_DiagRetValueDriveTest& oe8_DiagRetValueDriveTest);

   virtual tVoid vVisit_e16_DiagTroubleCode(mplay_fi_tcl_e16_DiagTroubleCode& oe16_DiagTroubleCode);

   virtual tVoid vVisit_e8_DiagMonitoringMode(mplay_fi_tcl_e8_DiagMonitoringMode& oe8_DiagMonitoringMode);

   virtual tVoid vVisit_e8_DiagSupervisionControl(mplay_fi_tcl_e8_DiagSupervisionControl& oe8_DiagSupervisionControl);

   virtual tVoid vVisit_e16_DiagErrorStatus(mplay_fi_tcl_e16_DiagErrorStatus& oe16_DiagErrorStatus);

   virtual tVoid vVisit_e16_DiagRoutineStatus(mplay_fi_tcl_e16_DiagRoutineStatus& oe16_DiagRoutineStatus);

   virtual tVoid vVisit_e8_TrackType(mplay_fi_tcl_e8_TrackType& oe8_TrackType);

   virtual tVoid vVisit_e8_TrackTypeResult(mplay_fi_tcl_e8_TrackTypeResult& oe8_TrackTypeResult);

   virtual tVoid vVisit_DiagDrvTestParameter(mplay_fi_tcl_DiagDrvTestParameter& oDiagDrvTestParameter);

   virtual tVoid vVisit_DiagMethodResultDrvTest(mplay_fi_tcl_DiagMethodResultDrvTest& oDiagMethodResultDrvTest);

   virtual tVoid vVisit_DiagEjectParam(mplay_fi_tcl_DiagEjectParam& oDiagEjectParam);

   virtual tVoid vVisit_DiagMethodResultEject(mplay_fi_tcl_DiagMethodResultEject& oDiagMethodResultEject);

   virtual tVoid vVisit_DiagFirmwareVersion(mplay_fi_tcl_DiagFirmwareVersion& oDiagFirmwareVersion);

   virtual tVoid vVisit_DiagDriveVersion(mplay_fi_tcl_DiagDriveVersion& oDiagDriveVersion);

   virtual tVoid vVisit_DiagTestRoutineParameter(mplay_fi_tcl_DiagTestRoutineParameter& oDiagTestRoutineParameter);

   virtual tVoid vVisit_DiagTestRoutineList(mplay_fi_tcl_DiagTestRoutineList& oDiagTestRoutineList);

   virtual tVoid vVisit_DiagTroubleCodeList(mplay_fi_tcl_DiagTroubleCodeList& oDiagTroubleCodeList);

   virtual tVoid vVisit_DiagTroubleStatus(mplay_fi_tcl_DiagTroubleStatus& oDiagTroubleStatus);

   virtual tVoid vVisit_DiagTroubleCodeStatusList(mplay_fi_tcl_DiagTroubleCodeStatusList& oDiagTroubleCodeStatusList);

   virtual tVoid vVisit_e8_DiagnosisTestType(mplay_fi_tcl_e8_DiagnosisTestType& oe8_DiagnosisTestType);

   virtual tVoid vVisit_e16_DiagTestType(mplay_fi_tcl_e16_DiagTestType& oe16_DiagTestType);

   virtual tVoid vVisit_DiagReadDevInterfaceTestParam(mplay_fi_tcl_DiagReadDevInterfaceTestParam& oDiagReadDevInterfaceTestParam);

   virtual tVoid vVisit_DiagTestResult(mplay_fi_tcl_DiagTestResult& oDiagTestResult);

   virtual tVoid vVisit_e16_DriveErrorValue(mplay_fi_tcl_e16_DriveErrorValue& oe16_DriveErrorValue);

   virtual tVoid vVisit_DriveErrorInfo(mplay_fi_tcl_DriveErrorInfo& oDriveErrorInfo);


 	fi_tclTraversePath<fi_tclKnot>::tclIterator oIterator;		
	
protected:
	tBool bBreakNow;
	tBool bIsVisitorValid;
private:

};

#endif
