/************************************************************************
 
 *FILE:           alltypes.h
 
 *SW-COMPONENT:   FI, framework for Functional Interface
 
 *DESCRIPTION:    Interface for all types defined in the different FIs
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           $ Log $
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MPLAY_ALLFITYPES_HEADER
#define MPLAY_ALLFITYPES_HEADER

#include <vector>

class mplay_fi_tclVisitorBase;

const tU16 MPLAY_FI_C_U16_ERROR_INTERNALFAILURE = 1;
const tU16 MPLAY_FI_C_U16_ERROR_INVALIDBINCONTAINERWRONGVERSION = 2;
const tU16 MPLAY_FI_C_U16_ERROR_INVALIDBINCONTAINERUNEXPECTEDDATA = 3;

class mplay_fi_tclTypeBase : public fi_tclTypeBase
{
public:
  mplay_fi_tclTypeBase() {}
  virtual ~mplay_fi_tclTypeBase() {}
   
  virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& /*oVisitor*/) {}
};

class mplay_fi_tclVisitableTypeBase :public mplay_fi_tclTypeBase
{
public:
   virtual void vTakeVisitor(mplay_fi_tclVisitorBase& /*oVisitor*/) {}
};

class mplay_fi_tclU8 : public mplay_fi_tclVisitableTypeBase
{
public:
   mplay_fi_tclU8():u8Value(0) {}
   tU8 u8Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const mplay_fi_tclU8& roRef) const
      { return (u8Value == roRef.u8Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mplay_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return mplay_typesfi_tclToken::EN_U8;}
};

class mplay_fi_tclS8 : public mplay_fi_tclVisitableTypeBase
{
public:
   mplay_fi_tclS8():s8Value(0) {}
   tS8 s8Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const mplay_fi_tclS8& roRef) const
      { return (s8Value == roRef.s8Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mplay_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return mplay_typesfi_tclToken::EN_S8;}
};

class mplay_fi_tclU16 : public mplay_fi_tclVisitableTypeBase
{
public:
   mplay_fi_tclU16():u16Value(0) {}
   tU16 u16Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const mplay_fi_tclU16& roRef) const
      { return (u16Value == roRef.u16Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mplay_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return mplay_typesfi_tclToken::EN_U16;}
};

class mplay_fi_tclS16 : public mplay_fi_tclVisitableTypeBase
{
public:
   mplay_fi_tclS16():s16Value(0) {}
   tS16 s16Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const mplay_fi_tclS16& roRef) const
      { return (s16Value == roRef.s16Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mplay_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return mplay_typesfi_tclToken::EN_S16;}
};

class mplay_fi_tclU24 : public mplay_fi_tclVisitableTypeBase
{
public:
   mplay_fi_tclU24():u24Value(0) {}
   tU24 u24Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const mplay_fi_tclU24& roRef) const
      { return (u24Value == roRef.u24Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mplay_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return mplay_typesfi_tclToken::EN_U24;}
};

class mplay_fi_tclS24 : public mplay_fi_tclVisitableTypeBase
{
public:
   mplay_fi_tclS24():s24Value(0) {}
   tS24 s24Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const mplay_fi_tclS24& roRef) const
      { return (s24Value == roRef.s24Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mplay_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return mplay_typesfi_tclToken::EN_S24;}
};

class mplay_fi_tclU32 : public mplay_fi_tclVisitableTypeBase
{
public:
   mplay_fi_tclU32():u32Value(0) {}
   tU32 u32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const mplay_fi_tclU32& roRef) const
      { return (u32Value == roRef.u32Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mplay_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return mplay_typesfi_tclToken::EN_U32;}
};

class mplay_fi_tclS32 : public mplay_fi_tclVisitableTypeBase
{
public:
   mplay_fi_tclS32():s32Value(0) {}
   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const mplay_fi_tclS32& roRef) const
      { return (s32Value == roRef.s32Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mplay_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return mplay_typesfi_tclToken::EN_S32;}
};

class mplay_fi_tclU64 : public mplay_fi_tclVisitableTypeBase
{
public:
   mplay_fi_tclU64():u64Value(0) {}
   tU64 u64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const mplay_fi_tclU64& roRef) const
      { return (u64Value == roRef.u64Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mplay_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return mplay_typesfi_tclToken::EN_U64;}
};

class mplay_fi_tclS64 : public mplay_fi_tclVisitableTypeBase
{
public:
   mplay_fi_tclS64():s64Value(0) {}
   tS64 s64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const mplay_fi_tclS64& roRef) const
      { return (s64Value == roRef.s64Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mplay_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return mplay_typesfi_tclToken::EN_S64;}
};

class mplay_fi_tclF32 : public mplay_fi_tclVisitableTypeBase
{
public:
   mplay_fi_tclF32():f32Value(0) {}
   tFloat f32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const mplay_fi_tclF32& roRef) const
      { return (f32Value == roRef.f32Value);  } //lint !e777
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mplay_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return mplay_typesfi_tclToken::EN_F32;}
};

class mplay_fi_tclF64 : public mplay_fi_tclVisitableTypeBase
{
public:
   mplay_fi_tclF64():f64Value(0) {}
   tDouble f64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const mplay_fi_tclF64& roRef) const
      { return (f64Value == roRef.f64Value); } //lint !e777
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mplay_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return mplay_typesfi_tclToken::EN_F64;}
};

class mplay_fi_tclBool : public mplay_fi_tclVisitableTypeBase
{
public:
   mplay_fi_tclBool():bValue(0) {}
   tBool bValue;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const mplay_fi_tclBool& roRef) const
      { return (bValue == roRef.bValue); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mplay_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return mplay_typesfi_tclToken::EN_BOOL;}
};

class mplay_fi_tclString : public mplay_fi_tclVisitableTypeBase
{
public:
   mplay_fi_tclString():szValue(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tclString(const mplay_fi_tclString& coRef);
   mplay_fi_tclString& operator=(const mplay_fi_tclString& coRef);
   virtual ~mplay_fi_tclString();
#endif

   tString szValue;

   virtual void vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const mplay_fi_tclString& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mplay_fi_tclVisitorBase& oVisitor);
#ifndef FI_DO_NOT_USE_TSTRING
   mplay_fi_tclString& operator=(tCString coszString); // ADDED
   mplay_fi_tclString(tCString coszInit); //ADDED
   tBool operator==(tCString coszString) const; // ADDED
   operator const tChar* () const; // ADDED
   operator tString&(); // ADDED
   tBool operator!=(intptr_t iNULL) const; // ADDED
   tChar* operator+(int iOffset); // ADDED
   tChar* operator+(tU8  u8Offset); // ADDED
   tChar* operator+(tU32 u32Offset); // ADDED
   tChar& operator[](tU16 u16Index); //ADDED
   tChar& operator[](tU32 u32Index); //ADDED
   tChar& operator[](tS32 s32Index); //ADDED
#endif
   enum tenCharSet {
      FI_EN_UNDEFINED = 0,
      FI_EN_ISO8859_15M,
      FI_EN_UTF8,
      FI_EN_ISO8859_1M
   };
   virtual tS32 s32GetTypeId() const { return mplay_typesfi_tclToken::EN_STRING;}
   /* The following functions are used to import string values into FI-objects
    * and to export strings from FI-Objects.
    * The character encoding (ISO-Modified or UTF8) is provided as parameter
    * Attention: string values are copied by these functions, thus incoming and/or
    * outgoing strings have to be deleted externally.
    */
   tBool bSet(const mplay_fi_tclString& corfoInit, tenCharSet enCharSet);
   tBool bSet(tCString coszInit, tenCharSet enCharSet);
   tString szGet(tenCharSet enCharSet) const;
};

class mplay_fi_tclList : public mplay_fi_tclVisitableTypeBase
{
public:
   mplay_fi_tclList():u32ListSize(0) {}
   tU32 u32ListSize;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const mplay_fi_tclList& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oIn);
   virtual void vTakeVisitor(mplay_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return mplay_typesfi_tclToken::EN_LIST;}
};

class mplay_fi_tclMultiLanguageString : public mplay_fi_tclVisitableTypeBase
{
public:
   mplay_fi_tclMultiLanguageString():szValue(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tclMultiLanguageString(const mplay_fi_tclMultiLanguageString& coRef);
   mplay_fi_tclMultiLanguageString& operator=(const mplay_fi_tclMultiLanguageString& coRef);
   virtual ~mplay_fi_tclMultiLanguageString();
#endif

   tString szValue;

   virtual void vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const mplay_fi_tclMultiLanguageString& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mplay_fi_tclVisitorBase& oVisitor);
#ifndef FI_DO_NOT_USE_TSTRING
   mplay_fi_tclMultiLanguageString& operator=(tCString coszString); // ADDED
   mplay_fi_tclMultiLanguageString(tCString coszInit); //ADDED
   tBool operator==(tCString coszString) const; // ADDED
   operator const tChar* () const; // ADDED
   operator tString&(); // ADDED
   tBool operator!=(intptr_t iNULL) const; // ADDED
   tChar* operator+(int iOffset); // ADDED
   tChar* operator+(tU8  u8Offset); // ADDED
   tChar* operator+(tU32 u32Offset); // ADDED
   tChar& operator[](tU16 u16Index); //ADDED
   tChar& operator[](tU32 u32Index); //ADDED
   tChar& operator[](tS32 s32Index); //ADDED
#endif
   enum tenCharSet {
      FI_EN_UNDEFINED = 0,
      FI_EN_ISO8859_15M,
      FI_EN_UTF8
   };
   virtual tS32 s32GetTypeId() const { return mplay_typesfi_tclToken::EN_STRING;}
   /* The following functions are used to import string values into FI-objects
    * and to export strings from FI-Objects.
    * The character encoding (ISO-Modified or UTF8) is provided as parameter
    * Attention: string values are copied by these functions, thus incoming and/or
    * outgoing strings have to be deleted externally.
    */
   tBool bSet(const mplay_fi_tclMultiLanguageString& corfoInit, tenCharSet enCharSet);
   tBool bSet(tCString coszInit, tenCharSet enCharSet);
   tString szGet(tenCharSet enCharSet) const;
};
class mplay_fi_tcl_BinContainer;
class mplay_fi_tcl_ShortStream;
class mplay_fi_tcl_e8_EjectOpticalDisc_MethodResult;
class mplay_fi_tcl_e8_SlotStateOpticalDiscType;
class mplay_fi_tcl_e8_EjectParmType;
class mplay_fi_tcl_e8DeviceState;
class mplay_fi_tcl_e8_CDInfo;
class mplay_fi_tcl_e8_DVDCommandStatus;
class mplay_fi_tcl_e8_MDVDDiscType;
class mplay_fi_tcl_e8_MDVDDriveMode;
class mplay_fi_tcl_e8_MAngle;
class mplay_fi_tcl_e8_MAudioOutputNumber;
class mplay_fi_tcl_e8_MChannelAssignment;
class mplay_fi_tcl_e8_MCMSkipValue;
class mplay_fi_tcl_e8_MDiscError;
class mplay_fi_tcl_e8_MDiscMechanicalInfo;
class mplay_fi_tcl_e8_MDiscOperation;
class mplay_fi_tcl_e8_MDiscType;
class mplay_fi_tcl_e8_MDisplayMode;
class mplay_fi_tcl_e8_MDRCSetting;
class mplay_fi_tcl_e8_MGeneralSelectionType;
class mplay_fi_tcl_e8_MMenuControlData;
class mplay_fi_tcl_e8_MNavigationKey;
class mplay_fi_tcl_e8_MPlayAction;
class mplay_fi_tcl_e8_MPlayAudioChannelFormat;
class mplay_fi_tcl_e8_MPlayAvailabilityReason;
class mplay_fi_tcl_e8_MPlaybackDirection;
class mplay_fi_tcl_e8_MPlaybackSpeed;
class mplay_fi_tcl_e8_MPlayCategoryType;
class mplay_fi_tcl_e8_MPlayChange;
class mplay_fi_tcl_e8_MPlayConnectionState;
class mplay_fi_tcl_e8_MPlayConnectionType;
class mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult;
class mplay_fi_tcl_e8_MPlayDeviceControlSupport;
class mplay_fi_tcl_e8_MPlayDeviceIndexedState;
class mplay_fi_tcl_e8_MPlayDeviceRippingState;
class mplay_fi_tcl_e8_MPlayDeviceStatus;
class mplay_fi_tcl_e8_MPlayDeviceType;
class mplay_fi_tcl_e8_MPlayDisconnectReason;
class mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult;
class mplay_fi_tcl_e8_MPlayEncodingQuality;
class mplay_fi_tcl_e8_MPlayFileFormat;
class mplay_fi_tcl_e8_MPlayFileSystemType;
class mplay_fi_tcl_e8_MPlayFileType;
class mplay_fi_tcl_e8_MPlayFileTypeSelection;
class mplay_fi_tcl_e8_MPlayGNmetadataExtractionResult;
class mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult;
class mplay_fi_tcl_e8_MPlayiPodCommunicationError;
class mplay_fi_tcl_e8_MPlayLanguage;
class mplay_fi_tcl_e8_MPlayListType;
class mplay_fi_tcl_e8_MPlayMediaType;
class mplay_fi_tcl_e8_MPlayMode;
class mplay_fi_tcl_e8_MPlayNowPlayingState;
class mplay_fi_tcl_e8_MPlayPlayableStatus;
class mplay_fi_tcl_e8_MPlayPlaypointFormat;
class mplay_fi_tcl_e8_MPlayRepeat;
class mplay_fi_tcl_e8_MPlayState;
class mplay_fi_tcl_e8_MPlayStreamingInfo;
class mplay_fi_tcl_e8_MPlayTagTransferStatus;
class mplay_fi_tcl_e8_MPlayUmountResult;
class mplay_fi_tcl_e8_MSoundFormat;
class mplay_fi_tcl_e8_MSubtitleSelectionType;
class mplay_fi_tcl_e8_MTotalChannel;
class mplay_fi_tcl_e8_MTouchAction;
class mplay_fi_tcl_e8_MVCDAudioMode;
class mplay_fi_tcl_e8_QuickSearchResult;
class mplay_fi_tcl_MInternalDVDLangSetting;
class mplay_fi_tcl_e_MPlayDeviceDBViewStatus;
class mplay_fi_tcl_MPlayDeviceInfoItem;
class mplay_fi_tcl_MPlayFavoritesList;
class mplay_fi_tcl_MPlayFileListItem;
class mplay_fi_tcl_MPlayFileList;
class mplay_fi_tcl_MPlayImageData;
class mplay_fi_tcl_MPlayImageObjectItem;
class mplay_fi_tcl_MPlayImageObjects;
class mplay_fi_tcl_MPlayIndexingStateResultItem;
class mplay_fi_tcl_MPlayIndexingStateResult;
class mplay_fi_tcl_MPlayItems;
class mplay_fi_tcl_MPlayMediaAlbums;
class mplay_fi_tcl_MPlayMediaObject;
class mplay_fi_tcl_MPlayMediaObjectsItem;
class mplay_fi_tcl_MPlayMediaObjects;
class mplay_fi_tcl_MPlayMediaObjectTag;
class mplay_fi_tcl_MPlayMediaObjectUrl;
class mplay_fi_tcl_PermissionByTag;
class mplay_fi_tcl_MPlayPlayListPosition;
class mplay_fi_tcl_MPlayRippingErrors;
class mplay_fi_tcl_MPlayRippingStateResultItem;
class mplay_fi_tcl_MPlaySearchKeyboardListItem;
class mplay_fi_tcl_MPlaySearchKeyboardList;
class mplay_fi_tcl_MPlayTagTransferItem_1;
class mplay_fi_tcl_MPlayTagTransferItem_2;
class mplay_fi_tcl_MPlayTagTransfer_1;
class mplay_fi_tcl_MPlayTagTransfer_2;
class mplay_fi_tcl_MPlayUntransferredTagStreamItem;
class mplay_fi_tcl_MPlayUntransferredTagStream;
class mplay_fi_tcl_MPlayPermissionByTag;
class mplay_fi_tcl_SearchString;
class mplay_fi_tcl_MPlaySearchType;
class mplay_fi_tcl_VideoScalingType;
class mplay_fi_tcl_IndicesType;
class mplay_fi_tcl_IndicesList;
class mplay_fi_tcl_AlbumArtUrlList;
class mplay_fi_tcl_e_MPlayHIDCommand;
class mplay_fi_tcl_e_MPlayKeyEvent;
class mplay_fi_tcl_MPlayDeviceInfo;
class mplay_fi_tcl_e8_DeviceConnectStatus;
class mplay_fi_tcl_e8_Device;
class mplay_fi_tcl_DevManager_PortStates;
class mplay_fi_tcl_DVM_CardIdentifierRegister;
class mplay_fi_tcl_e8_DVM_MediaState;
class mplay_fi_tcl_e8_DVM_DeviceSpeedUsb;
class mplay_fi_tcl_e8_DVM_UnsupportedReason;
class mplay_fi_tcl_e8_FileSystem;
class mplay_fi_tcl_e8_DVM_MediaType;
class mplay_fi_tcl_e8_PowerStatus;
class mplay_fi_tcl_DevManager_DeviceProperty;
class mplay_fi_tcl_DevManager_DevInfoStr;
class mplay_fi_tcl_DevManager_SDCardInfo;
class mplay_fi_tcl_e8_SettingsMode;
class mplay_fi_tcl_e8_AccessoryPowerMode;
class mplay_fi_tcl_e8_BatteryChargingState;
class mplay_fi_tcl_e8_DiPODeviceType;
class mplay_fi_tcl_e8_DiPOConnectionType;
class mplay_fi_tcl_e8_DiPOConnectionState;
class mplay_fi_tcl_e8_DiPOCaps;
class mplay_fi_tcl_e8_DiPODeviceStatus;
class mplay_fi_tcl_e8_DiPOPlaypackAction;
class mplay_fi_tcl_e8_DiPOPlaybackStatus;
class mplay_fi_tcl_e8_DiPOPlaybackShuffleMode;
class mplay_fi_tcl_e8_DiPOPlaybackRepeatMode;
class mplay_fi_tcl_e8_DiPOResponse;
class mplay_fi_tcl_e8_DiPORoleStatus;
class mplay_fi_tcl_DiPODeviceInfoItem;
class mplay_fi_tcl_DiPODeviceInfo;
class mplay_fi_tcl_DiPOImageData;
class mplay_fi_tcl_b8_DiPOLocationInfoType;
class mplay_fi_tcl_b8_DiPOGPRMCDataStatusValues;
class mplay_fi_tcl_e8_AudioError;
class mplay_fi_tcl_e8_AppLaunchOption;
class mplay_fi_tcl_b32_BTProfileType;
class mplay_fi_tcl_BTProfileItem;
class mplay_fi_tcl_BTProfileInfo;
class mplay_fi_tcl_e8_DiPOCallStateUpdateStatus;
class mplay_fi_tcl_e8_DiPOCallStateUpdateDirection;
class mplay_fi_tcl_e8_DiPOCallStateUpdateService;
class mplay_fi_tcl_e8_DiPOCallStateUpdateDisconnectReason;
class mplay_fi_tcl_DiPOCallStateItem;
class mplay_fi_tcl_DiPOCallStateUpdate;
class mplay_fi_tcl_e8_DiPOCommunicationsUpdateSignalStrength;
class mplay_fi_tcl_e8_DiPOCommunicationsUpdateRegistrationStatus;
class mplay_fi_tcl_RouteGuidanceDisplayComponentIDs;
class mplay_fi_tcl_e8_RouteGuidanceState;
class mplay_fi_tcl_e8_ManeuverState;
class mplay_fi_tcl_e8_DistanceDisplayUnits;
class mplay_fi_tcl_RouteGuidanceManeuverCurrentList;
class mplay_fi_tcl_e8_ManeuverType;
class mplay_fi_tcl_e8_DrivingSide;
class mplay_fi_tcl_e8_JunctionType;
class mplay_fi_tcl_JunctionElementAngles;
class mplay_fi_tcl_RouteGuidanceDisplayComponentItem;
class mplay_fi_tcl_RouteGuidanceDisplayComponents;
class mplay_fi_tcl_RouteGuidanceUpdate;
class mplay_fi_tcl_RouteGuidanceManeuverUpdate;
class mplay_fi_tcl_CallControlsConfiguration;
class mplay_fi_tcl_e_InitiateCallType;
class mplay_fi_tcl_e_InitiateCallService;
class mplay_fi_tcl_e_AcceptAction;
class mplay_fi_tcl_e_EndAction;
class mplay_fi_tcl_e_SendDTMFTone;
class mplay_fi_tcl_e8_DiPOCommunicationError;
class mplay_fi_tcl_AppInfo;
class mplay_fi_tcl_DeviceTimeUpdate;
class mplay_fi_tcl_e8_CdType;
class mplay_fi_tcl_e8_MediaState;
class mplay_fi_tcl_e8_InsertState;
class mplay_fi_tcl_e8_MMgr_MethodResult;
class mplay_fi_tcl_e8DriveTempSensorStatus;
class mplay_fi_tcl_e16_DiagDrv;
class mplay_fi_tcl_e16_DiagDrvTestCmd;
class mplay_fi_tcl_e16_DiagDrvTestParam;
class mplay_fi_tcl_e16_DiagResultEject;
class mplay_fi_tcl_e8_DiagLoadStatus;
class mplay_fi_tcl_e8_DiagDuration;
class mplay_fi_tcl_e8_DiagRetValueDriveTest;
class mplay_fi_tcl_e16_DiagTroubleCode;
class mplay_fi_tcl_e8_DiagMonitoringMode;
class mplay_fi_tcl_e8_DiagSupervisionControl;
class mplay_fi_tcl_e16_DiagErrorStatus;
class mplay_fi_tcl_e16_DiagRoutineStatus;
class mplay_fi_tcl_e8_TrackType;
class mplay_fi_tcl_e8_TrackTypeResult;
class mplay_fi_tcl_DiagDrvTestParameter;
class mplay_fi_tcl_DiagMethodResultDrvTest;
class mplay_fi_tcl_DiagEjectParam;
class mplay_fi_tcl_DiagMethodResultEject;
class mplay_fi_tcl_DiagFirmwareVersion;
class mplay_fi_tcl_DiagDriveVersion;
class mplay_fi_tcl_DiagTestRoutineParameter;
class mplay_fi_tcl_DiagTestRoutineList;
class mplay_fi_tcl_DiagTroubleCodeList;
class mplay_fi_tcl_DiagTroubleStatus;
class mplay_fi_tcl_DiagTroubleCodeStatusList;
class mplay_fi_tcl_e8_DiagnosisTestType;
class mplay_fi_tcl_e16_DiagTestType;
class mplay_fi_tcl_DiagReadDevInterfaceTestParam;
class mplay_fi_tcl_DiagTestResult;
class mplay_fi_tcl_e16_DriveErrorValue;
class mplay_fi_tcl_DriveErrorInfo;
class mplay_fi_tcl_BinContainer : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_BinContainer();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_BinContainer& operator=(const mplay_fi_tcl_BinContainer& coRef);
   mplay_fi_tcl_BinContainer(const mplay_fi_tcl_BinContainer& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > ContainerDataList;
   virtual ~mplay_fi_tcl_BinContainer();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_BinContainer& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_ShortStream : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_ShortStream();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_ShortStream& operator=(const mplay_fi_tcl_ShortStream& coRef);
   mplay_fi_tcl_ShortStream(const mplay_fi_tcl_ShortStream& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > u8Data;
   virtual ~mplay_fi_tcl_ShortStream();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_ShortStream& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_EjectOpticalDisc_MethodResult : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_EjectOpticalDisc_MethodResult();
   enum tenType {
      FI_EN_ACCEPTED = 1UL,
      FI_EN_NOTACCEPTED = 2UL,
      FI_EN_DEVICENOTREADY = 3UL
   };
   tenType enType;

   mplay_fi_tcl_e8_EjectOpticalDisc_MethodResult(mplay_fi_tcl_e8_EjectOpticalDisc_MethodResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_EjectOpticalDisc_MethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_EjectOpticalDisc_MethodResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_SlotStateOpticalDiscType : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_SlotStateOpticalDiscType();
   enum tenType {
      FI_EN_INITIALISING = 1UL,
      FI_EN_INITIALISED = 2UL,
      FI_EN_LASTMODE_EMTPY = 3UL,
      FI_EN_LASTMODE_INSERTED_CDDA = 4UL,
      FI_EN_LASTMODE_INSERTED_CDROM = 5UL,
      FI_EN_LASTMODE_INSERTED_CDERROR = 6UL,
      FI_EN_INSERTING = 7UL,
      FI_EN_INSERTED_CDAUDIO = 8UL,
      FI_EN_INSERTED_CDROM = 9UL,
      FI_EN_INSERTED_CDERROR = 10UL,
      FI_EN_INSERTED_AUTOMATIC_CDAUDIO = 11UL,
      FI_EN_INSERTED_AUTOMATIC_CDROM = 12UL,
      FI_EN_INSERTED_AUTOMATIC_CDERROR = 13UL,
      FI_EN_EJECTING = 14UL,
      FI_EN_EJECTED_READY_TO_REMOVE = 15UL,
      FI_EN_EJECTED_EMPTY = 16UL,
      FI_EN_UNDEFINED = 255UL
   };
   tenType enType;

   mplay_fi_tcl_e8_SlotStateOpticalDiscType(mplay_fi_tcl_e8_SlotStateOpticalDiscType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_SlotStateOpticalDiscType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_SlotStateOpticalDiscType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_EjectParmType : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_EjectParmType();
   enum tenType {
      FI_EN_E8CMD_EJECT = 1UL,
      FI_EN_E8CMD_INSERT = 2UL
   };
   tenType enType;

   mplay_fi_tcl_e8_EjectParmType(mplay_fi_tcl_e8_EjectParmType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_EjectParmType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_EjectParmType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8DeviceState : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8DeviceState();
   enum tenType {
      FI_EN_MMGR_DEVICE_NOT_READY = 0UL,
      FI_EN_MMGR_DEVICE_READY = 1UL
   };
   tenType enType;

   mplay_fi_tcl_e8DeviceState(mplay_fi_tcl_e8DeviceState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8DeviceState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8DeviceState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_CDInfo : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_CDInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_e8_CDInfo& operator=(const mplay_fi_tcl_e8_CDInfo& coRef);
   mplay_fi_tcl_e8_CDInfo(const mplay_fi_tcl_e8_CDInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString DriveVersion;
   mplay_fi_tcl_e8DeviceState e8DeviceState;
   virtual ~mplay_fi_tcl_e8_CDInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_e8_CDInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DVDCommandStatus : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DVDCommandStatus();
   enum tenType {
      FI_EN_E8INVALID_INPUT = 3UL,
      FI_EN_E8PROHIBITED_BY_DISC = 2UL,
      FI_EN_E8PROHIBITED_BY_PLAYER = 1UL,
      FI_EN_E8VALID_OPERATION = 0UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DVDCommandStatus(mplay_fi_tcl_e8_DVDCommandStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DVDCommandStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DVDCommandStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MDVDDiscType : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MDVDDiscType();
   enum tenType {
      FI_EN_E8NON_DISC_DATA = 0UL,
      FI_EN_E8DISC_DATA = 1UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MDVDDiscType(mplay_fi_tcl_e8_MDVDDiscType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MDVDDiscType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MDVDDiscType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MDVDDriveMode : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MDVDDriveMode();
   enum tenType {
      FI_EN_E8MASS_STORAGE_MODE = 0UL,
      FI_EN_E8TRANSITION_TO_MASS_STORAGE_MODE = 16UL,
      FI_EN_E8BACKEND_MODE = 1UL,
      FI_EN_E8TRANSITION_TO_BACKEND_MODE = 17UL,
      FI_EN_E8INVALID_MODE = 255UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MDVDDriveMode(mplay_fi_tcl_e8_MDVDDriveMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MDVDDriveMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MDVDDriveMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MAngle : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MAngle();
   enum tenType {
      FI_EN_E8DVD_ANGLE_1 = 1UL,
      FI_EN_E8DVD_ANGLE_2 = 2UL,
      FI_EN_E8DVD_ANGLE_3 = 3UL,
      FI_EN_E8DVD_ANGLE_4 = 4UL,
      FI_EN_E8DVD_ANGLE_5 = 5UL,
      FI_EN_E8DVD_ANGLE_6 = 6UL,
      FI_EN_E8DVD_ANGLE_7 = 7UL,
      FI_EN_E8DVD_ANGLE_8 = 8UL,
      FI_EN_E8DVD_ANGLE_9 = 9UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MAngle(mplay_fi_tcl_e8_MAngle::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MAngle();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MAngle& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MAudioOutputNumber : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MAudioOutputNumber();
   enum tenType {
      FI_EN_E8DVD_AUDIO_NUMBER_1 = 1UL,
      FI_EN_E8DVD_AUDIO_NUMBER_2 = 2UL,
      FI_EN_E8DVD_AUDIO_NUMBER_3 = 3UL,
      FI_EN_E8DVD_AUDIO_NUMBER_4 = 4UL,
      FI_EN_E8DVD_AUDIO_NUMBER_5 = 5UL,
      FI_EN_E8DVD_AUDIO_NUMBER_6 = 6UL,
      FI_EN_E8DVD_AUDIO_NUMBER_7 = 7UL,
      FI_EN_E8DVD_AUDIO_NUMBER_8 = 8UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MAudioOutputNumber(mplay_fi_tcl_e8_MAudioOutputNumber::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MAudioOutputNumber();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MAudioOutputNumber& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MChannelAssignment : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MChannelAssignment();
   enum tenType {
      FI_EN_E8DVD_AUDIO_0_0 = 0UL,
      FI_EN_E8DVD_AUDIO_1_0 = 1UL,
      FI_EN_E8DVD_AUDIO_1_PLUS_1 = 8UL,
      FI_EN_E8DVD_AUDIO_2_0 = 2UL,
      FI_EN_E8DVD_AUDIO_2_1 = 4UL,
      FI_EN_E8DVD_AUDIO_2_2 = 5UL,
      FI_EN_E8DVD_AUDIO_3_0 = 3UL,
      FI_EN_E8DVD_AUDIO_3_1 = 6UL,
      FI_EN_E8DVD_AUDIO_3_2 = 7UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MChannelAssignment(mplay_fi_tcl_e8_MChannelAssignment::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MChannelAssignment();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MChannelAssignment& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MCMSkipValue : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MCMSkipValue();
   enum tenType {
      FI_EN_E8FORWARD_15 = 15UL,
      FI_EN_E8FORWARD_30 = 30UL,
      FI_EN_E8FORWARD_60 = 60UL,
      FI_EN_E8REVERSE_15 = 241UL,
      FI_EN_E8REVERSE_30 = 226UL,
      FI_EN_E8REVERSE_60 = 196UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MCMSkipValue(mplay_fi_tcl_e8_MCMSkipValue::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MCMSkipValue();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MCMSkipValue& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MDiscError : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MDiscError();
   enum tenType {
      FI_EN_E8DISC_HOT_ERROR = 13UL,
      FI_EN_E8DISK_MECHA_ERROR = 153UL,
      FI_EN_E8DVD_DESCRAMBLE_FAILED = 35UL,
      FI_EN_E8DVD_DISC_NO_ERROR = 0UL,
      FI_EN_E8DVD_PARENTAL_LEVEL_ERROR = 19UL,
      FI_EN_E8DVD_REGION_CODE_ERROR = 3UL,
      FI_EN_E8READ_ERROR = 4UL,
      FI_EN_E8UNKNOWN_CD = 21UL,
      FI_EN_E8UNKNOWN_DVD = 37UL,
      FI_EN_E8UNKNOWN_ERROR = 5UL,
      FI_EN_E8UPDATE_DISC_ERROR = 6UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MDiscError(mplay_fi_tcl_e8_MDiscError::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MDiscError();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MDiscError& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MDiscMechanicalInfo : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MDiscMechanicalInfo();
   enum tenType {
      FI_EN_E8DISC_CHUCKING = 0UL,
      FI_EN_E8DISC_EJECT_FINISH_DISC_EXIST = 2UL,
      FI_EN_E8DISC_EJECT_FINISH_NO_DISC = 34UL,
      FI_EN_E8DISC_MECHANISM_UNDECIDED = 255UL,
      FI_EN_E8DISC_STOP = 3UL,
      FI_EN_E8DURING_DISC_EJECT = 18UL,
      FI_EN_E8DURING_DISC_LOADING = 1UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MDiscMechanicalInfo(mplay_fi_tcl_e8_MDiscMechanicalInfo::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MDiscMechanicalInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MDiscMechanicalInfo& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MDiscOperation : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MDiscOperation();
   enum tenType {
      FI_EN_E8DISC_EJECT = 1UL,
      FI_EN_E8DISC_LOAD = 0UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MDiscOperation(mplay_fi_tcl_e8_MDiscOperation::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MDiscOperation();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MDiscOperation& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MDiscType : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MDiscType();
   enum tenType {
      FI_EN_E8AUDIO_CD_DISC = 0UL,
      FI_EN_E8DATA_DISC = 6UL,
      FI_EN_E8DVD_AUDIO_DISC = 5UL,
      FI_EN_E8DVD_ERROR_DISC = 9UL,
      FI_EN_E8DVD_VIDEO_DISC = 7UL,
      FI_EN_E8DVD_VR_DISC = 8UL,
      FI_EN_E8SUPER_VCD_DISC_PBC_OFF = 3UL,
      FI_EN_E8SUPER_VCD_DISC_PBC_ON = 4UL,
      FI_EN_E8VCD_VER1_DISC = 10UL,
      FI_EN_E8VCD_VER2_DISC_PBC_OFF = 1UL,
      FI_EN_E8VCD_VER2_DISC_PBC_ON = 2UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MDiscType(mplay_fi_tcl_e8_MDiscType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MDiscType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MDiscType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MDisplayMode : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MDisplayMode();
   enum tenType {
      FI_EN_E8DISPLAY_MODE_16_9 = 0UL,
      FI_EN_E8DISPLAY_MODE_4_3_LETTER_BOX = 1UL,
      FI_EN_E8DISPLAY_MODE_4_3_PAN_SCAN = 2UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MDisplayMode(mplay_fi_tcl_e8_MDisplayMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MDisplayMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MDisplayMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MDRCSetting : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MDRCSetting();
   enum tenType {
      FI_EN_E8DRC_BOOST = 15UL,
      FI_EN_E8DRC_NORMAL = 10UL,
      FI_EN_E8DRC_WIDE = 0UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MDRCSetting(mplay_fi_tcl_e8_MDRCSetting::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MDRCSetting();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MDRCSetting& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MGeneralSelectionType : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MGeneralSelectionType();
   enum tenType {
      FI_EN_E8SEL_CYCLIC = 0UL,
      FI_EN_E8SEL_DIRECT = 2UL,
      FI_EN_E8SEL_REV_CYCLIC = 1UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MGeneralSelectionType(mplay_fi_tcl_e8_MGeneralSelectionType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MGeneralSelectionType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MGeneralSelectionType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MMenuControlData : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MMenuControlData();
   enum tenType {
      FI_EN_E8MENU = 1UL,
      FI_EN_E8TOP_MENU = 0UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MMenuControlData(mplay_fi_tcl_e8_MMenuControlData::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MMenuControlData();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MMenuControlData& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MNavigationKey : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MNavigationKey();
   enum tenType {
      FI_EN_E8NAVIGATE_ENTER = 19UL,
      FI_EN_E8NAVIGATE_LEFT = 3UL,
      FI_EN_E8NAVIGATE_LOWER = 1UL,
      FI_EN_E8NAVIGATE_RETURN = 20UL,
      FI_EN_E8NAVIGATE_RIGHT = 2UL,
      FI_EN_E8NAVIGATE_UPPER = 0UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MNavigationKey(mplay_fi_tcl_e8_MNavigationKey::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MNavigationKey();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MNavigationKey& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayAction : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayAction();
   enum tenType {
      FI_EN_E8PBA_PLAY = 0UL,
      FI_EN_E8PBA_PAUSE = 1UL,
      FI_EN_E8PBA_STOP = 2UL,
      FI_EN_E8PBA_PREV = 3UL,
      FI_EN_E8PBA_NEXT = 4UL,
      FI_EN_E8PBA_FREV_START = 5UL,
      FI_EN_E8PBA_FREV_STOP = 6UL,
      FI_EN_E8PBA_FFWD_START = 7UL,
      FI_EN_E8PBA_FFWD_STOP = 8UL,
      FI_EN_E8PBA_FOLDER_UP = 9UL,
      FI_EN_E8PBA_FOLDER_DOWN = 10UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayAction(mplay_fi_tcl_e8_MPlayAction::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayAction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayAction& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayAudioChannelFormat : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayAudioChannelFormat();
   enum tenType {
      FI_EN_E8ACF_MONO = 1UL,
      FI_EN_E8ACF_STEREO = 2UL,
      FI_EN_E8ACF_UNKNOWN = 0UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayAudioChannelFormat(mplay_fi_tcl_e8_MPlayAudioChannelFormat::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayAudioChannelFormat();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayAudioChannelFormat& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayAvailabilityReason : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayAvailabilityReason();
   enum tenType {
      FI_EN_E8AR_NEW_MEDIA = 0UL,
      FI_EN_E8AR_NO_CONTENT = 2UL,
      FI_EN_E8AR_SAME_MEDIA = 1UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayAvailabilityReason(mplay_fi_tcl_e8_MPlayAvailabilityReason::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayAvailabilityReason();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayAvailabilityReason& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlaybackDirection : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlaybackDirection();
   enum tenType {
      FI_EN_E8PBK_BACKWARD = 1UL,
      FI_EN_E8PBK_FORWARD = 0UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlaybackDirection(mplay_fi_tcl_e8_MPlaybackDirection::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlaybackDirection();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlaybackDirection& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlaybackSpeed : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlaybackSpeed();
   enum tenType {
      FI_EN_E8PBK_SPEED_0_2X = 0UL,
      FI_EN_E8PBK_SPEED_0_5X = 1UL,
      FI_EN_E8PBK_SPEED_16X = 6UL,
      FI_EN_E8PBK_SPEED_1X = 2UL,
      FI_EN_E8PBK_SPEED_2X = 3UL,
      FI_EN_E8PBK_SPEED_32X = 7UL,
      FI_EN_E8PBK_SPEED_4X = 4UL,
      FI_EN_E8PBK_SPEED_8X = 5UL,
      FI_EN_E8PBK_SPEED_DECREASE = 9UL,
      FI_EN_E8PBK_SPEED_INCREASE = 8UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlaybackSpeed(mplay_fi_tcl_e8_MPlaybackSpeed::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlaybackSpeed();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlaybackSpeed& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayCategoryType : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayCategoryType();
   enum tenType {
      FI_EN_E8CTY_ALBUM = 3UL,
      FI_EN_E8CTY_ARTIST = 2UL,
      FI_EN_E8CTY_AUTHOR = 6UL,
      FI_EN_E8CTY_CHAPTER = 8UL,
      FI_EN_E8CTY_COMPOSER = 5UL,
      FI_EN_E8CTY_EPISODE = 10UL,
      FI_EN_E8CTY_GENRE = 1UL,
      FI_EN_E8CTY_IMAGE = 13UL,
      FI_EN_E8CTY_NAME = 9UL,
      FI_EN_E8CTY_NONE = 0UL,
      FI_EN_E8CTY_PLAYLIST_INTERNAL = 12UL,
      FI_EN_E8CTY_PLAYLIST = 11UL,
      FI_EN_E8CTY_SONG = 4UL,
      FI_EN_E8CTY_TITLE = 7UL,
      FI_EN_E8CTY_YEAR = 14UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayCategoryType(mplay_fi_tcl_e8_MPlayCategoryType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayCategoryType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayCategoryType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayChange : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayChange();
   enum tenType {
      FI_EN_E8LCH_CONTENT_CHANGED = 0UL,
      FI_EN_E8LCH_ITEMS_ADDED = 1UL,
      FI_EN_E8LCH_ITEMS_CHANGED = 3UL,
      FI_EN_E8LCH_ITEMS_REMOVED = 2UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayChange(mplay_fi_tcl_e8_MPlayChange::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayChange();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayChange& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayConnectionState : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayConnectionState();
   enum tenType {
      FI_EN_E8CS_ATTACHED = 1UL,
      FI_EN_E8CS_CONNECTED = 0UL,
      FI_EN_E8CS_DISCONNECTED = 2UL,
      FI_EN_E8CS_HW_MALFUNCTION = 3UL,
      FI_EN_E8CS_ON_HOLD = 7UL,
      FI_EN_E8CS_OVERTEMP = 6UL,
      FI_EN_E8CS_UNDEFINED = 8UL,
      FI_EN_E8CS_UNDERVOLTAGE = 4UL,
      FI_EN_E8CS_UNSUPPORTED = 5UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayConnectionState(mplay_fi_tcl_e8_MPlayConnectionState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayConnectionState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayConnectionState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayConnectionType : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayConnectionType();
   enum tenType {
      FI_EN_E8DCT_BLUETOOTH = 2UL,
      FI_EN_E8DCT_CDROM = 3UL,
      FI_EN_E8DCT_FLASH = 4UL,
      FI_EN_E8DCT_UNKNOWN = 0UL,
      FI_EN_E8DCT_USB = 1UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayConnectionType(mplay_fi_tcl_e8_MPlayConnectionType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayConnectionType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayConnectionType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult();
   enum tenType {
      FI_EN_E8DATABASE_ERROR = 2UL,
      FI_EN_E8DEVICE_ERROR = 6UL,
      FI_EN_E8DEVICE_NOT_EXIST = 3UL,
      FI_EN_E8FILE_OP_ERROR = 5UL,
      FI_EN_E8LISTTYPE_NOT_FOUND = 4UL,
      FI_EN_E8PERM_ISSUE = 1UL,
      FI_EN_OK = 0UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult(mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayDeviceControlSupport : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayDeviceControlSupport();
   enum tenType {
      FI_EN_E8DCS_BROWSING = 0UL,
      FI_EN_E8DCS_METADATA = 1UL,
      FI_EN_E8DCS_NO_METADATA = 2UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayDeviceControlSupport(mplay_fi_tcl_e8_MPlayDeviceControlSupport::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayDeviceControlSupport();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayDeviceControlSupport& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayDeviceIndexedState : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayDeviceIndexedState();
   enum tenType {
      FI_EN_E8IDS_COMPLETE = 3UL,
      FI_EN_E8IDS_NOT_STARTED = 1UL,
      FI_EN_E8IDS_NOT_SUPPORTED = 0UL,
      FI_EN_E8IDS_PARTIAL = 2UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayDeviceIndexedState(mplay_fi_tcl_e8_MPlayDeviceIndexedState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayDeviceIndexedState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayDeviceIndexedState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayDeviceRippingState : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayDeviceRippingState();
   enum tenType {
      FI_EN_E8RS_COMPLETE = 3UL,
      FI_EN_E8RS_NOT_STARTED = 1UL,
      FI_EN_E8RS_NOT_SUPPORTED = 0UL,
      FI_EN_E8RS_PARTIAL = 2UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayDeviceRippingState(mplay_fi_tcl_e8_MPlayDeviceRippingState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayDeviceRippingState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayDeviceRippingState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayDeviceStatus : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayDeviceStatus();
   enum tenType {
      FI_EN_E8DS_COMMUNICATION_ERROR = 6UL,
      FI_EN_E8DS_INITIALIZING = 1UL,
      FI_EN_E8DS_NONE = 0UL,
      FI_EN_E8DS_OK = 2UL,
      FI_EN_E8DS_UNSUPPORTED_FILESYSTEM = 4UL,
      FI_EN_E8DS_UNSUPPORTED_PARTITION = 5UL,
      FI_EN_E8DS_UNSUPPORTED = 3UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayDeviceStatus(mplay_fi_tcl_e8_MPlayDeviceStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayDeviceStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayDeviceStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayDeviceType : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayDeviceType();
   enum tenType {
      FI_EN_E8DTY_BLUETOOTH = 4UL,
      FI_EN_E8DTY_CDDA = 9UL,
      FI_EN_E8DTY_CDROM = 7UL,
      FI_EN_E8DTY_DVD_DRIVE = 10UL,
      FI_EN_E8DTY_FLASH = 8UL,
      FI_EN_E8DTY_IPHONE = 5UL,
      FI_EN_E8DTY_IPOD = 2UL,
      FI_EN_E8DTY_MTP = 6UL,
      FI_EN_E8DTY_MUSICBOX = 11UL,
      FI_EN_E8DTY_SD = 3UL,
      FI_EN_E8DTY_UNKNOWN = 0UL,
      FI_EN_E8DTY_UNSUPPORTED = 14UL,
      FI_EN_E8DTY_RMS = 12UL,
      FI_EN_E8DTY_USB = 1UL,
      FI_EN_E8DTY_CONTROLPOINT = 13UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayDeviceType(mplay_fi_tcl_e8_MPlayDeviceType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayDeviceType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayDeviceType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayDisconnectReason : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayDisconnectReason();
   enum tenType {
      FI_EN_E8DR_AUTOMATIC = 9UL,
      FI_EN_E8DR_AVP_DISCONNECTED = 4UL,
      FI_EN_E8DR_CONNECT_FAILED = 14UL,
      FI_EN_E8DR_CONNECT_REJECTED = 12UL,
      FI_EN_E8DR_CONNECT_TIMEOUT = 11UL,
      FI_EN_E8DR_CONNECTED_OVER_USB = 5UL,
      FI_EN_E8DR_DEVICE_REQUEST = 7UL,
      FI_EN_E8DR_HW_MALFUNC = 2UL,
      FI_EN_E8DR_INTERNALDISCONNECT = 3UL,
      FI_EN_E8DR_MODULE_REQUEST = 8UL,
      FI_EN_E8DR_NOT_APPLICABLE = 6UL,
      FI_EN_E8DR_OUT_OF_RANGE = 10UL,
      FI_EN_E8DR_PROTOCOL_NOT_SUPPORTED = 13UL,
      FI_EN_E8DR_REMOVED = 0UL,
      FI_EN_E8DR_TEMPERATURE = 1UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayDisconnectReason(mplay_fi_tcl_e8_MPlayDisconnectReason::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayDisconnectReason();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayDisconnectReason& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult();
   enum tenType {
      FI_EN_E8DATABASE_ERROR = 2UL,
      FI_EN_E8DEVICE_ERROR = 7UL,
      FI_EN_E8DEVICE_NOT_EXIST = 3UL,
      FI_EN_E8FILE_OP_ERROR = 5UL,
      FI_EN_E8MEDIAOBJECT_NOT_FOUND = 4UL,
      FI_EN_E8PERM_ISSUE = 1UL,
      FI_EN_E8TAG_EDIT_ERROR = 6UL,
      FI_EN_OK = 0UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult(mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayEncodingQuality : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayEncodingQuality();
   enum tenType {
      FI_EN_E8CD_QUALIY = 1UL,
      FI_EN_E8FM_QUALITY = 0UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayEncodingQuality(mplay_fi_tcl_e8_MPlayEncodingQuality::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayEncodingQuality();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayEncodingQuality& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayFileFormat : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayFileFormat();
   enum tenType {
      FI_EN_E8FFT_3G2 = 9UL,
      FI_EN_E8FFT_3GP = 8UL,
      FI_EN_E8FFT_AAC_PLUS = 3UL,
      FI_EN_E8FFT_AAC = 2UL,
      FI_EN_E8FFT_AA = 11UL,
      FI_EN_E8FFT_AIFF = 10UL,
      FI_EN_E8FFT_ASX = 25UL,
      FI_EN_E8FFT_AVI = 14UL,
      FI_EN_E8FFT_B4S = 24UL,
      FI_EN_E8FFT_BMP = 28UL,
      FI_EN_E8FFT_DIVX = 16UL,
      FI_EN_E8FFT_FLAC = 31UL,
      FI_EN_E8FFT_FLV = 19UL,
      FI_EN_E8FFT_GIF = 27UL,
      FI_EN_E8FFT_JPEG = 26UL,
      FI_EN_E8FFT_M3U = 20UL,
      FI_EN_E8FFT_M4A = 4UL,
      FI_EN_E8FFT_M4B = 32UL,
      FI_EN_E8FFT_M4P = 33UL,
      FI_EN_E8FFT_M4R = 34UL,
      FI_EN_E8FFT_M4V = 18UL,
      FI_EN_E8FFT_MKV = 35UL,
      FI_EN_E8FFT_MOV = 15UL,
      FI_EN_E8FFT_MP3 = 0UL,
      FI_EN_E8FFT_MP4 = 5UL,
      FI_EN_E8FFT_MPEG = 13UL,
      FI_EN_E8FFT_OGG = 7UL,
      FI_EN_E8FFT_PLS = 21UL,
      FI_EN_E8FFT_PNG = 29UL,
      FI_EN_E8FFT_SBC = 12UL,
      FI_EN_E8FFT_TIF = 30UL,
      FI_EN_E8FFT_WAV = 6UL,
      FI_EN_E8FFT_WMA = 1UL,
      FI_EN_E8FFT_WMV = 17UL,
      FI_EN_E8FFT_WPL = 23UL,
      FI_EN_E8FFT_XSPF = 22UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayFileFormat(mplay_fi_tcl_e8_MPlayFileFormat::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayFileFormat();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayFileFormat& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayFileSystemType : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayFileSystemType();
   enum tenType {
      FI_EN_E8FSTY_EXFAT = 5UL,
      FI_EN_E8FSTY_EXT4 = 3UL,
      FI_EN_E8FSTY_FAT = 1UL,
      FI_EN_E8FSTY_HFS = 4UL,
      FI_EN_E8FSTY_ISO9660 = 7UL,
      FI_EN_E8FSTY_NTFS = 2UL,
      FI_EN_E8FSTY_UDF = 6UL,
      FI_EN_E8FSTY_UNKNOWN = 0UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayFileSystemType(mplay_fi_tcl_e8_MPlayFileSystemType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayFileSystemType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayFileSystemType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayFileType : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayFileType();
   enum tenType {
      FI_EN_E8FT_AUDIO = 1UL,
      FI_EN_E8FT_FOLDER = 0UL,
      FI_EN_E8FT_IMAGE = 4UL,
      FI_EN_E8FT_PLAYLIST = 3UL,
      FI_EN_E8FT_VIDEO = 2UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayFileType(mplay_fi_tcl_e8_MPlayFileType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayFileType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayFileType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayFileTypeSelection : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayFileTypeSelection();
   enum tenType {
      FI_EN_E8FTS_ALL = 6UL,
      FI_EN_E8FTS_AUDIO_PLAYLIST = 5UL,
      FI_EN_E8FTS_AUDIO_VIDEO_PLAYLIST = 0UL,
      FI_EN_E8FTS_AUDIO = 1UL,
      FI_EN_E8FTS_IMAGE = 4UL,
      FI_EN_E8FTS_PLAYLIST = 3UL,
      FI_EN_E8FTS_VIDEO = 2UL,
      FI_EN_E8FTS_AUDIO_VIDEO = 7UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayFileTypeSelection(mplay_fi_tcl_e8_MPlayFileTypeSelection::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayFileTypeSelection();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayFileTypeSelection& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayGNmetadataExtractionResult : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayGNmetadataExtractionResult();
   enum tenType {
      FI_EN_E8GNMETADATA_EXTRACTION_SUCCESS = 1UL,
      FI_EN_E8GNMETADATA_NOMATCHFOUND = 0UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayGNmetadataExtractionResult(mplay_fi_tcl_e8_MPlayGNmetadataExtractionResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayGNmetadataExtractionResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayGNmetadataExtractionResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult();
   enum tenType {
      FI_EN_E8DATABASE_ERROR = 3UL,
      FI_EN_E8DISK_FULL = 5UL,
      FI_EN_E8FILE_CREATE_ERROR = 1UL,
      FI_EN_E8FILE_NOT_EXIST = 4UL,
      FI_EN_E8FILE_OP_ERROR = 6UL,
      FI_EN_E8MULTIPLE_ENTRIES_FOUND = 7UL,
      FI_EN_E8PERM_ISSUE = 2UL,
      FI_EN_OK = 0UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult(mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayiPodCommunicationError : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayiPodCommunicationError();
   enum tenType {
      FI_EN_E8IPOD_COMM_ERROR = 1UL,
      FI_EN_E8IPOD_NO_ERROR = 0UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayiPodCommunicationError(mplay_fi_tcl_e8_MPlayiPodCommunicationError::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayiPodCommunicationError();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayiPodCommunicationError& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayLanguage : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayLanguage();
   enum tenType {
      FI_EN_E8LANGUAGE_SELECTION_ARABIC = 13UL,
      FI_EN_E8LANGUAGE_SELECTION_BRAZILIAN_PORTUGUESE = 24UL,
      FI_EN_E8LANGUAGE_SELECTION_BULGARIAN = 26UL,
      FI_EN_E8LANGUAGE_SELECTION_CANTONESE = 33UL,
      FI_EN_E8LANGUAGE_SELECTION_CROATIAN = 29UL,
      FI_EN_E8LANGUAGE_SELECTION_CZECH = 21UL,
      FI_EN_E8LANGUAGE_SELECTION_DANISH = 10UL,
      FI_EN_E8LANGUAGE_SELECTION_DEVANAGARI = 40UL,
      FI_EN_E8LANGUAGE_SELECTION_DUTCH = 6UL,
      FI_EN_E8LANGUAGE_SELECTION_ESTONIAN = 37UL,
      FI_EN_E8LANGUAGE_SELECTION_FINNISH = 9UL,
      FI_EN_E8LANGUAGE_SELECTION_FRENCH = 4UL,
      FI_EN_E8LANGUAGE_SELECTION_GERMAN = 1UL,
      FI_EN_E8LANGUAGE_SELECTION_GREEK = 11UL,
      FI_EN_E8LANGUAGE_SELECTION_HEBREW = 39UL,
      FI_EN_E8LANGUAGE_SELECTION_HUNGARIAN = 20UL,
      FI_EN_E8LANGUAGE_SELECTION_ITALIAN = 2UL,
      FI_EN_E8LANGUAGE_SELECTION_JAPANESE = 12UL,
      FI_EN_E8LANGUAGE_SELECTION_KOREAN = 17UL,
      FI_EN_E8LANGUAGE_SELECTION_LATVIAN = 38UL,
      FI_EN_E8LANGUAGE_SELECTION_LITHUANIAN = 36UL,
      FI_EN_E8LANGUAGE_SELECTION_NA_ENGLISH = 0UL,
      FI_EN_E8LANGUAGE_SELECTION_NA_FRENCH = 31UL,
      FI_EN_E8LANGUAGE_SELECTION_NA_SPANISH = 32UL,
      FI_EN_E8LANGUAGE_SELECTION_NORWEGIAN = 8UL,
      FI_EN_E8LANGUAGE_SELECTION_POLISH = 15UL,
      FI_EN_E8LANGUAGE_SELECTION_PORTUGUESE = 7UL,
      FI_EN_E8LANGUAGE_SELECTION_ROMANIAN = 27UL,
      FI_EN_E8LANGUAGE_SELECTION_RUSSIAN = 23UL,
      FI_EN_E8LANGUAGE_SELECTION_SERBIAN = 35UL,
      FI_EN_E8LANGUAGE_SELECTION_SLOVAK = 22UL,
      FI_EN_E8LANGUAGE_SELECTION_SLOVENIAN = 28UL,
      FI_EN_E8LANGUAGE_SELECTION_SPANISH = 5UL,
      FI_EN_E8LANGUAGE_SELECTION_STANDARD_CHINESE = 14UL,
      FI_EN_E8LANGUAGE_SELECTION_SWEDISH = 3UL,
      FI_EN_E8LANGUAGE_SELECTION_THAI = 25UL,
      FI_EN_E8LANGUAGE_SELECTION_TRADITIONAL_CHINESE = 18UL,
      FI_EN_E8LANGUAGE_SELECTION_TURKISH = 16UL,
      FI_EN_E8LANGUAGE_SELECTION_UK_ENGLISH = 19UL,
      FI_EN_E8LANGUAGE_SELECTION_UKRAINIAN = 30UL,
      FI_EN_E8LANGUAGE_SELECTION_UZBEK = 34UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayLanguage(mplay_fi_tcl_e8_MPlayLanguage::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayLanguage();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayLanguage& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayListType : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayListType();
   enum tenType {
      FI_EN_E8LTY_ALBUM_SONG = 14UL,
      FI_EN_E8LTY_ALBUM = 2UL,
      FI_EN_E8LTY_ARTIST_ALBUM_SONG = 12UL,
      FI_EN_E8LTY_ARTIST_ALBUM = 11UL,
      FI_EN_E8LTY_ARTIST_SONG = 13UL,
      FI_EN_E8LTY_ARTIST = 1UL,
      FI_EN_E8LTY_AUDIOBOOK = 17UL,
      FI_EN_E8LTY_AUTHOR_BOOKTITLE_CHAPTER = 21UL,
      FI_EN_E8LTY_AUTHOR_BOOKTITLE = 20UL,
      FI_EN_E8LTY_AUTHOR = 19UL,
      FI_EN_E8LTY_BOOKTITLE_CHAPTER = 18UL,
      FI_EN_E8LTY_COMPILATION_SONG = 35UL,
      FI_EN_E8LTY_COMPILATION = 34UL,
      FI_EN_E8LTY_COMPOSER_ALBUM_SONG = 24UL,
      FI_EN_E8LTY_COMPOSER_ALBUM = 23UL,
      FI_EN_E8LTY_COMPOSER_SONG = 25UL,
      FI_EN_E8LTY_COMPOSER = 22UL,
      FI_EN_E8LTY_CURRENT_SELECTION = 30UL,
      FI_EN_E8LTY_GENRE_ALBUM_SONG = 9UL,
      FI_EN_E8LTY_GENRE_ALBUM = 8UL,
      FI_EN_E8LTY_GENRE_ARTIST_ALBUM_SONG = 6UL,
      FI_EN_E8LTY_GENRE_ARTIST_ALBUM = 5UL,
      FI_EN_E8LTY_GENRE_ARTIST_SONG = 7UL,
      FI_EN_E8LTY_GENRE_ARTIST = 4UL,
      FI_EN_E8LTY_GENRE_SONG = 10UL,
      FI_EN_E8LTY_GENRE = 0UL,
      FI_EN_E8LTY_IMAGE_FOLDER_ITEM = 33UL,
      FI_EN_E8LTY_IMAGE_FOLDER = 32UL,
      FI_EN_E8LTY_IMAGE = 31UL,
      FI_EN_E8LTY_PLAYLIST_SONG = 29UL,
      FI_EN_E8LTY_PLAYLIST = 28UL,
      FI_EN_E8LTY_PODCAST_EPISODE = 16UL,
      FI_EN_E8LTY_PODCAST = 15UL,
      FI_EN_E8LTY_SONG = 3UL,
      FI_EN_E8LTY_USER_FAVORITES_SONG = 83UL,
      FI_EN_E8LTY_VIDEO_EPISODE = 27UL,
      FI_EN_E8LTY_VIDEO = 26UL,
      FI_EN_E8LTY_YEAR_ALBUM_SONG = 38UL,
      FI_EN_E8LTY_YEAR_ALBUM = 37UL,
      FI_EN_E8LTY_YEAR = 36UL,
      FI_EN_E8LTY_EPISODE_OF_VIDEO = 68UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayListType(mplay_fi_tcl_e8_MPlayListType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayListType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayListType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayMediaType : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayMediaType();
   enum tenType {
      FI_EN_E8MRY_AUDIO_STREAM = 6UL,
      FI_EN_E8MTY_AUDIOBOOK = 3UL,
      FI_EN_E8MTY_IMAGE = 8UL,
      FI_EN_E8MTY_MUSIC_FILE = 1UL,
      FI_EN_E8MTY_PLAYLIST_INTERNAL = 7UL,
      FI_EN_E8MTY_PLAYLIST = 5UL,
      FI_EN_E8MTY_PODCAST = 2UL,
      FI_EN_E8MTY_UNKNOWN = 0UL,
      FI_EN_E8MTY_VIDEO = 4UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayMediaType(mplay_fi_tcl_e8_MPlayMediaType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayMediaType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayMediaType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayMode : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayMode();
   enum tenType {
      FI_EN_E8PBM_NORMAL = 0UL,
      FI_EN_E8PBM_RANDOM = 1UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayMode(mplay_fi_tcl_e8_MPlayMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayNowPlayingState : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayNowPlayingState();
   enum tenType {
      FI_EN_E8NP_INVALID = 7UL,
      FI_EN_E8NP_LIST_COMPLETE = 5UL,
      FI_EN_E8NP_LIST_START = 4UL,
      FI_EN_E8NP_NEW_TRACK = 0UL,
      FI_EN_E8NP_NO_DEVICE = 6UL,
      FI_EN_E8NP_SAME_TRACK = 1UL,
      FI_EN_E8NP_TRACK_COMPLETE = 3UL,
      FI_EN_E8NP_TRACK_START = 2UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayNowPlayingState(mplay_fi_tcl_e8_MPlayNowPlayingState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayNowPlayingState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayNowPlayingState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayPlayableStatus : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayPlayableStatus();
   enum tenType {
      FI_EN_E8FP_DRM_PROTECTED = 2UL,
      FI_EN_E8FP_FORMAT_ERROR = 4UL,
      FI_EN_E8FP_NOT_PLAYABLE = 1UL,
      FI_EN_E8FP_PLAYABLE = 0UL,
      FI_EN_E8FP_READ_ERROR = 3UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayPlayableStatus(mplay_fi_tcl_e8_MPlayPlayableStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayPlayableStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayPlayableStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayPlaypointFormat : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayPlaypointFormat();
   enum tenType {
      FI_EN_E8PPF_ABSOLUTE = 1UL,
      FI_EN_E8PPF_PERCENTAGE = 0UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayPlaypointFormat(mplay_fi_tcl_e8_MPlayPlaypointFormat::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayPlaypointFormat();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayPlaypointFormat& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayRepeat : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayRepeat();
   enum tenType {
      FI_EN_E8RPT_ALL_LISTS = 4UL,
      FI_EN_E8RPT_ALL = 5UL,
      FI_EN_E8RPT_LIST_WITH_SUBLISTS = 3UL,
      FI_EN_E8RPT_LIST = 2UL,
      FI_EN_E8RPT_NONE = 0UL,
      FI_EN_E8RPT_ONE = 1UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayRepeat(mplay_fi_tcl_e8_MPlayRepeat::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayRepeat();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayRepeat& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayState : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayState();
   enum tenType {
      FI_EN_E8PBS_FFWD = 3UL,
      FI_EN_E8PBS_FREV = 4UL,
      FI_EN_E8PBS_PAUSED = 1UL,
      FI_EN_E8PBS_PLAYING = 0UL,
      FI_EN_E8PBS_STOPPED = 2UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayState(mplay_fi_tcl_e8_MPlayState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayStreamingInfo : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayStreamingInfo();
   enum tenType {
      FI_EN_E16REASON_ACTION_ERROR = 4294967294UL,
      FI_EN_E16REASON_ARGUMENT_ERROR = 4294966784UL,
      FI_EN_E16REASON_CODEC_ERROR = 4294966272UL,
      FI_EN_E16REASON_DEVICE_ERROR = 4294967264UL,
      FI_EN_E16REASON_DRM_ERROR = 4294967280UL,
      FI_EN_E16REASON_ERROR = 4294967295UL,
      FI_EN_E16REASON_FATAL_READ_ERROR = 4294967168UL,
      FI_EN_E16REASON_FORK_ERROR = 4294963200UL,
      FI_EN_E16REASON_FORMAT_ERROR = 4294967288UL,
      FI_EN_E16REASON_OK = 0UL,
      FI_EN_E16REASON_PIPELINE_ERROR = 4294965248UL,
      FI_EN_E16REASON_READ_ERROR = 4294967232UL,
      FI_EN_E16REASON_RESTART_ERROR = 4294959104UL,
      FI_EN_E16REASON_UNDERVOLTAGE_ERROR = 4294967040UL,
      FI_EN_E16REASON_URL_ERROR = 4294967292UL,
      FI_EN_E8REASON_STREAM_INPROGRESS = 4096UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayStreamingInfo(mplay_fi_tcl_e8_MPlayStreamingInfo::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayStreamingInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayStreamingInfo& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayTagTransferStatus : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayTagTransferStatus();
   enum tenType {
      FI_EN_E8TAG_TRANSFER_COMM_ERROR = 1UL,
      FI_EN_E8TAG_TRANSFER_DEVICE_FULL = 2UL,
      FI_EN_E8TAG_TRANSFER_NOT_SUPPORTED = 3UL,
      FI_EN_E8TAG_TRANSFER_SUCCESS = 0UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayTagTransferStatus(mplay_fi_tcl_e8_MPlayTagTransferStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayTagTransferStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayTagTransferStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MPlayUmountResult : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MPlayUmountResult();
   enum tenType {
      FI_EN_E8UMOUNT_BUSY = 1UL,
      FI_EN_E8UMOUNT_ERROR = 3UL,
      FI_EN_E8UMOUNT_NOT_SUPPORTED = 2UL,
      FI_EN_E8UMOUNT_OK = 0UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MPlayUmountResult(mplay_fi_tcl_e8_MPlayUmountResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MPlayUmountResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MPlayUmountResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MSoundFormat : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MSoundFormat();
   enum tenType {
      FI_EN_E8AUDIO_CD_DTS = 16UL,
      FI_EN_E8AUDIO_DVD_DTS = 5UL,
      FI_EN_E8AUDIO_SDDS_RESERVED = 6UL,
      FI_EN_E8AUDIO_UNKNOWN = 255UL,
      FI_EN_E8DOLBY = 2UL,
      FI_EN_E8LINEAR_PCM = 0UL,
      FI_EN_E8MPEG_1_2_WITHOUT_EXTENSION = 3UL,
      FI_EN_E8MPEG_2_WITH_EXTENSION = 4UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MSoundFormat(mplay_fi_tcl_e8_MSoundFormat::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MSoundFormat();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MSoundFormat& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MSubtitleSelectionType : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MSubtitleSelectionType();
   enum tenType {
      FI_EN_E8SUB_SEL_CYCLIC_OFF = 3UL,
      FI_EN_E8SUB_SEL_CYCLIC = 1UL,
      FI_EN_E8SUB_SEL_DIRECT = 5UL,
      FI_EN_E8SUB_SEL_ON_OFF = 0UL,
      FI_EN_E8SUB_SEL_REV_CYCLIC_OFF = 4UL,
      FI_EN_E8SUB_SEL_REV_CYCLIC = 2UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MSubtitleSelectionType(mplay_fi_tcl_e8_MSubtitleSelectionType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MSubtitleSelectionType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MSubtitleSelectionType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MTotalChannel : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MTotalChannel();
   enum tenType {
      FI_EN_E8DVD_AUDIO_CHANNEL_0 = 0UL,
      FI_EN_E8DVD_AUDIO_CHANNEL_1 = 1UL,
      FI_EN_E8DVD_AUDIO_CHANNEL_2 = 2UL,
      FI_EN_E8DVD_AUDIO_CHANNEL_3 = 3UL,
      FI_EN_E8DVD_AUDIO_CHANNEL_4 = 4UL,
      FI_EN_E8DVD_AUDIO_CHANNEL_5 = 5UL,
      FI_EN_E8DVD_AUDIO_CHANNEL_6 = 6UL,
      FI_EN_E8DVD_AUDIO_CHANNEL_7 = 7UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MTotalChannel(mplay_fi_tcl_e8_MTotalChannel::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MTotalChannel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MTotalChannel& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MTouchAction : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MTouchAction();
   enum tenType {
      FI_EN_E8DISPLAY_TOUCH_OFF = 1UL,
      FI_EN_E8DISPLAY_TOUCH_ON = 0UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MTouchAction(mplay_fi_tcl_e8_MTouchAction::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MTouchAction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MTouchAction& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MVCDAudioMode : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MVCDAudioMode();
   enum tenType {
      FI_EN_E8VCD_CHANNEL_2_LL = 80UL,
      FI_EN_E8VCD_CHANNEL_2_MONO = 112UL,
      FI_EN_E8VCD_CHANNEL_2_RR = 96UL,
      FI_EN_E8VCD_CHANNEL_2_STEREO = 64UL,
      FI_EN_E8VCD_CHANNEL_LL = 16UL,
      FI_EN_E8VCD_CHANNEL_MONO = 48UL,
      FI_EN_E8VCD_CHANNEL_RR = 32UL,
      FI_EN_E8VCD_CHANNEL_STEREO = 0UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MVCDAudioMode(mplay_fi_tcl_e8_MVCDAudioMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MVCDAudioMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MVCDAudioMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_QuickSearchResult : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_QuickSearchResult();
   enum tenType {
      FI_EN_E8ENDOFLIST = 2UL,
      FI_EN_E8FOLLOWING = 1UL,
      FI_EN_E8FOUND = 0UL,
      FI_EN_E8NOTSUPPORTED = 3UL
   };
   tenType enType;

   mplay_fi_tcl_e8_QuickSearchResult(mplay_fi_tcl_e8_QuickSearchResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_QuickSearchResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_QuickSearchResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MInternalDVDLangSetting : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MInternalDVDLangSetting();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_MInternalDVDLangSetting& operator=(const mplay_fi_tcl_MInternalDVDLangSetting& coRef);
   mplay_fi_tcl_MInternalDVDLangSetting(const mplay_fi_tcl_MInternalDVDLangSetting& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16AudioLanguage;
   tU16 u16MenuLanguage;
   tU16 u16SubtitleLanguage;
   virtual ~mplay_fi_tcl_MInternalDVDLangSetting();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_MInternalDVDLangSetting& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e_MPlayDeviceDBViewStatus : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e_MPlayDeviceDBViewStatus();
   enum tenType {
      FI_EN_DB_VIEWS_DONT_CARE = 0UL,
      FI_EN_DB_VIEW_STATUS_NOT_AVAILABLE = 1UL,
      FI_EN_DB_VIEW_STATUS_AVAILABLE = 2UL
   };
   tenType enType;

   mplay_fi_tcl_e_MPlayDeviceDBViewStatus(mplay_fi_tcl_e_MPlayDeviceDBViewStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e_MPlayDeviceDBViewStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e_MPlayDeviceDBViewStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlayDeviceInfoItem : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlayDeviceInfoItem();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_MPlayDeviceInfoItem& operator=(const mplay_fi_tcl_MPlayDeviceInfoItem& coRef);
   mplay_fi_tcl_MPlayDeviceInfoItem(const mplay_fi_tcl_MPlayDeviceInfoItem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MDiscType e8DiscType;
   mplay_fi_tcl_e8_MPlayAvailabilityReason e8AvailabilityReason;
   mplay_fi_tcl_e8_MPlayConnectionState e8ConnectionState;
   mplay_fi_tcl_e8_MPlayConnectionType e8ConnectionType;
   mplay_fi_tcl_e8_MPlayDeviceControlSupport e8DeviceControlSupport;
   mplay_fi_tcl_e8_MPlayDeviceIndexedState e8DeviceIndexedState;
   mplay_fi_tcl_e8_MPlayDeviceStatus e8DeviceState;
   mplay_fi_tcl_e8_MPlayDeviceType e8DeviceType;
   mplay_fi_tcl_e8_MPlayDisconnectReason e8DisconnectReason;
   mplay_fi_tcl_e8_MPlayFileSystemType e8FileSystemType;
   tBool bDeviceActiveSource;
   tBool bDeviceConnected;
   tBool bIsNowPlayingListAvailable;
   tBool bRepeatSupported;
   tBool bScanSupported;
   tBool bShuffleSupported;
   mplay_fi_tclString sDeviceName;
   mplay_fi_tclString sDeviceSerialNumber;
   mplay_fi_tclString sDeviceSysPath;
   mplay_fi_tclString sDeviceVersion;
   mplay_fi_tclString sLastPlayedFile;
   mplay_fi_tclString sMountPoint;
   tU32 u32FreeSize;
   tU32 u32NumberOfFiles;
   tU32 u32NumberOfImageFiles;
   tU32 u32NumberOfVideoFiles;
   tU32 u32PartitionNumber;
   tU32 u32TotalSize;
   tU8 u8DeviceTag;
   mplay_fi_tcl_e_MPlayDeviceDBViewStatus DeviceDBViewStatus;
   virtual ~mplay_fi_tcl_MPlayDeviceInfoItem();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_MPlayDeviceInfoItem& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlayFavoritesList : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlayFavoritesList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_MPlayFavoritesList& operator=(const mplay_fi_tcl_MPlayFavoritesList& coRef);
   mplay_fi_tcl_MPlayFavoritesList(const mplay_fi_tcl_MPlayFavoritesList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU64, std::allocator<tU64> > u64FavoriteID;
   virtual ~mplay_fi_tcl_MPlayFavoritesList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_MPlayFavoritesList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlayFileListItem : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlayFileListItem();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_MPlayFileListItem& operator=(const mplay_fi_tcl_MPlayFileListItem& coRef);
   mplay_fi_tcl_MPlayFileListItem(const mplay_fi_tcl_MPlayFileListItem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayFileFormat e8FileFormat;
   mplay_fi_tcl_e8_MPlayFileType e8FileType;
   mplay_fi_tcl_e8_MPlayPlayableStatus e8PlayableStatus;
   tBool bIsPlaying;
   tBool bReadOnlyFlag;
   mplay_fi_tclString sFilename;
   tU32 u32Tag;
   tU8 u8TrackNumber;
   mplay_fi_tclString sDateTime;
   tU32 u32TotalPlaytime;
   tU64 u64FileSize;
   mplay_fi_tclString sCoverArt;
   tU64 Tag;
   tU64 ParentTag;
   virtual ~mplay_fi_tcl_MPlayFileListItem();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_MPlayFileListItem& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlayFileList : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlayFileList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_MPlayFileList& operator=(const mplay_fi_tcl_MPlayFileList& coRef);
   mplay_fi_tcl_MPlayFileList(const mplay_fi_tcl_MPlayFileList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mplay_fi_tcl_MPlayFileListItem, std::allocator<mplay_fi_tcl_MPlayFileListItem> > oItems;
   virtual ~mplay_fi_tcl_MPlayFileList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_MPlayFileList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlayImageData : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlayImageData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_MPlayImageData& operator=(const mplay_fi_tcl_MPlayImageData& coRef);
   mplay_fi_tcl_MPlayImageData(const mplay_fi_tcl_MPlayImageData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > u8Items;
   virtual ~mplay_fi_tcl_MPlayImageData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_MPlayImageData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlayImageObjectItem : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlayImageObjectItem();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_MPlayImageObjectItem& operator=(const mplay_fi_tcl_MPlayImageObjectItem& coRef);
   mplay_fi_tcl_MPlayImageObjectItem(const mplay_fi_tcl_MPlayImageObjectItem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayFileFormat e8FileFormat;
   mplay_fi_tcl_e8_MPlayFileType e8FileType;
   mplay_fi_tclString sDateTime;
   mplay_fi_tclString sDimension;
   mplay_fi_tclString sFolderTitle;
   mplay_fi_tclString sImageFile;
   mplay_fi_tclString sImageSize;
   mplay_fi_tclString sImageTitle;
   mplay_fi_tclString sMountPoint;
   mplay_fi_tclString sPath;
   mplay_fi_tclString sResolution;
   tU32 u32NumberOfImages;
   tU32 u32Tag;
   tU8 u8DeviceTag;
   virtual ~mplay_fi_tcl_MPlayImageObjectItem();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_MPlayImageObjectItem& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlayImageObjects : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlayImageObjects();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_MPlayImageObjects& operator=(const mplay_fi_tcl_MPlayImageObjects& coRef);
   mplay_fi_tcl_MPlayImageObjects(const mplay_fi_tcl_MPlayImageObjects& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mplay_fi_tcl_MPlayImageObjectItem, std::allocator<mplay_fi_tcl_MPlayImageObjectItem> > oItems;
   virtual ~mplay_fi_tcl_MPlayImageObjects();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_MPlayImageObjects& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlayIndexingStateResultItem : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlayIndexingStateResultItem();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_MPlayIndexingStateResultItem& operator=(const mplay_fi_tcl_MPlayIndexingStateResultItem& coRef);
   mplay_fi_tcl_MPlayIndexingStateResultItem(const mplay_fi_tcl_MPlayIndexingStateResultItem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayDeviceIndexedState e8DeviceIndexedState;
   tU8 u8DeviceTag;
   tU8 u8IndexingPercentComplete;
   virtual ~mplay_fi_tcl_MPlayIndexingStateResultItem();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_MPlayIndexingStateResultItem& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlayIndexingStateResult : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlayIndexingStateResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_MPlayIndexingStateResult& operator=(const mplay_fi_tcl_MPlayIndexingStateResult& coRef);
   mplay_fi_tcl_MPlayIndexingStateResult(const mplay_fi_tcl_MPlayIndexingStateResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mplay_fi_tcl_MPlayIndexingStateResultItem, std::allocator<mplay_fi_tcl_MPlayIndexingStateResultItem> > oItems;
   virtual ~mplay_fi_tcl_MPlayIndexingStateResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_MPlayIndexingStateResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlayItems : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlayItems();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_MPlayItems& operator=(const mplay_fi_tcl_MPlayItems& coRef);
   mplay_fi_tcl_MPlayItems(const mplay_fi_tcl_MPlayItems& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU32, std::allocator<tU32> > u32Items;
   virtual ~mplay_fi_tcl_MPlayItems();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_MPlayItems& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlayMediaAlbums : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlayMediaAlbums();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_MPlayMediaAlbums& operator=(const mplay_fi_tcl_MPlayMediaAlbums& coRef);
   mplay_fi_tcl_MPlayMediaAlbums(const mplay_fi_tcl_MPlayMediaAlbums& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mplay_fi_tclString, std::allocator<mplay_fi_tclString> > sAlbumTitle;
   virtual ~mplay_fi_tcl_MPlayMediaAlbums();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_MPlayMediaAlbums& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlayMediaObject : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlayMediaObject();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_MPlayMediaObject& operator=(const mplay_fi_tcl_MPlayMediaObject& coRef);
   mplay_fi_tcl_MPlayMediaObject(const mplay_fi_tcl_MPlayMediaObject& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayAudioChannelFormat e8AudioChannelFormat;
   mplay_fi_tcl_e8_MPlayCategoryType e8CategoryType;
   mplay_fi_tcl_e8_MPlayDeviceType e8DeviceType;
   mplay_fi_tcl_e8_MPlayFileFormat e8FileFormat;
   mplay_fi_tcl_e8_MPlayMediaType e8MediaType;
   mplay_fi_tcl_e8_MPlayPlayableStatus e8PlayableStatus;
   tBool bIsPlaying;
   tBool bVBR;
   mplay_fi_tclString sAlbumArt;
   mplay_fi_tclString sDateTime;
   mplay_fi_tclString sDeviceVersion;
   mplay_fi_tclString sFilename;
   mplay_fi_tclString sMetaDataField1;
   mplay_fi_tclString sMetaDataField2;
   mplay_fi_tclString sMetaDataField3;
   mplay_fi_tclString sMetaDataField4;
   mplay_fi_tclString sYomiMetaDataTitle;
   mplay_fi_tclString sYomiMetaDataArtist;
   mplay_fi_tclString sYomiMetaDataAlbum;
   mplay_fi_tclString sResolution;
   tU16 u16ExtendedTrackNumber;
   tU32 u32BitRate;
   tU32 u32MetaDataTag1;
   tU32 u32MetaDataTag2;
   tU32 u32MetaDataTag3;
   tU32 u32MetaDataTag4;
   tU32 u32SampleRate;
   tU32 u32Tag;
   tU32 u32TotalPlaytime;
   tU32 u32Year;
   tU32 u32YearID;
   tU64 u64FileSize;
   tU8 u8DeviceTag;
   tU8 u8TrackNumber;
   tBool bIsFavorite;
   virtual ~mplay_fi_tcl_MPlayMediaObject();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_MPlayMediaObject& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlayMediaObjectsItem : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlayMediaObjectsItem();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_MPlayMediaObjectsItem& operator=(const mplay_fi_tcl_MPlayMediaObjectsItem& coRef);
   mplay_fi_tcl_MPlayMediaObjectsItem(const mplay_fi_tcl_MPlayMediaObjectsItem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayCategoryType e8CategoryType;
   mplay_fi_tcl_e8_MPlayDeviceType e8DeviceType;
   mplay_fi_tcl_e8_MPlayFileFormat e8FileFormat;
   mplay_fi_tcl_e8_MPlayMediaType e8MediaType;
   mplay_fi_tcl_e8_MPlayPlayableStatus e8PlayableStatus;
   mplay_fi_tcl_MPlayImageData oThumbnailData;
   tBool bIsPlaying;
   tBool bReadOnlyFlag;
   mplay_fi_tclString sAlbumArt;
   mplay_fi_tclString sCoverArt;
   mplay_fi_tclString sDateTime;
   mplay_fi_tclString sDeviceVersion;
   mplay_fi_tclString sFilename;
   mplay_fi_tclString sMetaDataField1;
   mplay_fi_tclString sMetaDataField2;
   mplay_fi_tclString sMetaDataField3;
   mplay_fi_tclString sMetaDataField4;
   tU32 u32MetaDataTag1;
   tU32 u32MetaDataTag2;
   tU32 u32MetaDataTag3;
   tU32 u32MetaDataTag4;
   mplay_fi_tclString sYomiMetaDataTitle;
   mplay_fi_tclString sYomiMetaDataArtist;
   mplay_fi_tclString sYomiMetaDataAlbum;
   tU32 u32Tag;
   tU32 u32TotalPlaytime;
   tU32 u32Year;
   tU32 u32YearID;
   tU64 u64FileSize;
   tU8 u8DeviceTag;
   tU8 u8TrackNumber;
   tBool bIsFavorite;
   virtual ~mplay_fi_tcl_MPlayMediaObjectsItem();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_MPlayMediaObjectsItem& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlayMediaObjects : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlayMediaObjects();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_MPlayMediaObjects& operator=(const mplay_fi_tcl_MPlayMediaObjects& coRef);
   mplay_fi_tcl_MPlayMediaObjects(const mplay_fi_tcl_MPlayMediaObjects& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mplay_fi_tcl_MPlayMediaObjectsItem, std::allocator<mplay_fi_tcl_MPlayMediaObjectsItem> > oItems;
   virtual ~mplay_fi_tcl_MPlayMediaObjects();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_MPlayMediaObjects& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlayMediaObjectTag : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlayMediaObjectTag();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_MPlayMediaObjectTag& operator=(const mplay_fi_tcl_MPlayMediaObjectTag& coRef);
   mplay_fi_tcl_MPlayMediaObjectTag(const mplay_fi_tcl_MPlayMediaObjectTag& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU32, std::allocator<tU32> > MediaObjectTag;
   virtual ~mplay_fi_tcl_MPlayMediaObjectTag();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_MPlayMediaObjectTag& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlayMediaObjectUrl : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlayMediaObjectUrl();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_MPlayMediaObjectUrl& operator=(const mplay_fi_tcl_MPlayMediaObjectUrl& coRef);
   mplay_fi_tcl_MPlayMediaObjectUrl(const mplay_fi_tcl_MPlayMediaObjectUrl& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mplay_fi_tclString, std::allocator<mplay_fi_tclString> > sMediaObjectUrl;
   virtual ~mplay_fi_tcl_MPlayMediaObjectUrl();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_MPlayMediaObjectUrl& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_PermissionByTag : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_PermissionByTag();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_PermissionByTag& operator=(const mplay_fi_tcl_PermissionByTag& coRef);
   mplay_fi_tcl_PermissionByTag(const mplay_fi_tcl_PermissionByTag& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bReadOnlyFlag;
   tU32 MediaObjectTag;
   virtual ~mplay_fi_tcl_PermissionByTag();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_PermissionByTag& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlayPlayListPosition : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlayPlayListPosition();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_MPlayPlayListPosition& operator=(const mplay_fi_tcl_MPlayPlayListPosition& coRef);
   mplay_fi_tcl_MPlayPlayListPosition(const mplay_fi_tcl_MPlayPlayListPosition& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU32, std::allocator<tU32> > Position;
   virtual ~mplay_fi_tcl_MPlayPlayListPosition();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_MPlayPlayListPosition& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlayRippingErrors : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlayRippingErrors();
   enum tenType {
      FI_EN_E8RE_OK = 0UL,
      FI_EN_E8RE_TRACK_READ_ERROR = 1UL,
      FI_EN_E8RS_COPY_PROTECTED_DISC = 2UL,
      FI_EN_E8RS_DISK_FULL = 4UL,
      FI_EN_E8RS_GENERAL_IO_ERROR = 3UL,
      FI_EN_E8RS_PERM_FULL = 5UL
   };
   tenType enType;

   mplay_fi_tcl_MPlayRippingErrors(mplay_fi_tcl_MPlayRippingErrors::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_MPlayRippingErrors();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_MPlayRippingErrors& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlayRippingStateResultItem : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlayRippingStateResultItem();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_MPlayRippingStateResultItem& operator=(const mplay_fi_tcl_MPlayRippingStateResultItem& coRef);
   mplay_fi_tcl_MPlayRippingStateResultItem(const mplay_fi_tcl_MPlayRippingStateResultItem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayDeviceRippingState e8DeviceRippingState;
   tU8 u8DeviceTag;
   tU8 u8RippingPercentComplete;
   tU8 TotalTracksInCD;
   tU8 CurrentRippedTrackIndex;
   virtual ~mplay_fi_tcl_MPlayRippingStateResultItem();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_MPlayRippingStateResultItem& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlaySearchKeyboardListItem : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlaySearchKeyboardListItem();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_MPlaySearchKeyboardListItem& operator=(const mplay_fi_tcl_MPlaySearchKeyboardListItem& coRef);
   mplay_fi_tcl_MPlaySearchKeyboardListItem(const mplay_fi_tcl_MPlaySearchKeyboardListItem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bLetterAvailable;
   mplay_fi_tclString sSearchKeyboardLetter;
   tU32 u32LetterEndIndex;
   tU32 u32LetterStartIndex;
   virtual ~mplay_fi_tcl_MPlaySearchKeyboardListItem();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_MPlaySearchKeyboardListItem& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlaySearchKeyboardList : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlaySearchKeyboardList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_MPlaySearchKeyboardList& operator=(const mplay_fi_tcl_MPlaySearchKeyboardList& coRef);
   mplay_fi_tcl_MPlaySearchKeyboardList(const mplay_fi_tcl_MPlaySearchKeyboardList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mplay_fi_tcl_MPlaySearchKeyboardListItem, std::allocator<mplay_fi_tcl_MPlaySearchKeyboardListItem> > oItems;
   virtual ~mplay_fi_tcl_MPlaySearchKeyboardList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_MPlaySearchKeyboardList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlayTagTransferItem_1 : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlayTagTransferItem_1();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_MPlayTagTransferItem_1& operator=(const mplay_fi_tcl_MPlayTagTransferItem_1& coRef);
   mplay_fi_tcl_MPlayTagTransferItem_1(const mplay_fi_tcl_MPlayTagTransferItem_1& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_ShortStream oUnknownData;
   mplay_fi_tclString sPodCastFeedURL;
   mplay_fi_tclString sStationURL;
   mplay_fi_tclString sStationURLFrequency;
   mplay_fi_tclString sTagAffiliateID;
   mplay_fi_tclString sTagAlbum;
   mplay_fi_tclString sTagArtistName;
   mplay_fi_tclString sTagChannelName;
   mplay_fi_tclString sTagChannelNumber;
   mplay_fi_tclString sTagGenre;
   mplay_fi_tclString sTagTimeStamp;
   mplay_fi_tclString sTagTrackName;
   tU32 u32TagSongID;
   tU8 u8AmbiguousTag;
   tU8 u8ButtonPressed;
   tU8 u8TagProgramNumber;
   tU8 u8TagStorefrontID;
   virtual ~mplay_fi_tcl_MPlayTagTransferItem_1();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_MPlayTagTransferItem_1& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlayTagTransferItem_2 : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlayTagTransferItem_2();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_MPlayTagTransferItem_2& operator=(const mplay_fi_tcl_MPlayTagTransferItem_2& coRef);
   mplay_fi_tcl_MPlayTagTransferItem_2(const mplay_fi_tcl_MPlayTagTransferItem_2& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_ShortStream oUnknownData;
   mplay_fi_tclString sPodCastFeedURL;
   mplay_fi_tclString sStationURL;
   mplay_fi_tclString sStationURLFrequency;
   mplay_fi_tclString sTagAffiliateID;
   mplay_fi_tclString sTagAlbum;
   mplay_fi_tclString sTagArtistName;
   mplay_fi_tclString sTagChannelName;
   mplay_fi_tclString sTagChannelNumber;
   mplay_fi_tclString sTagGenre;
   mplay_fi_tclString sTagTimeStamp;
   mplay_fi_tclString sTagTrackName;
   tU32 u32TagSongID;
   tU32 u32TagStorefrontID;
   tU8 u8AmbiguousTag;
   tU8 u8ButtonPressed;
   tU8 u8TagProgramNumber;
   virtual ~mplay_fi_tcl_MPlayTagTransferItem_2();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_MPlayTagTransferItem_2& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlayTagTransfer_1 : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlayTagTransfer_1();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_MPlayTagTransfer_1& operator=(const mplay_fi_tcl_MPlayTagTransfer_1& coRef);
   mplay_fi_tcl_MPlayTagTransfer_1(const mplay_fi_tcl_MPlayTagTransfer_1& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mplay_fi_tcl_MPlayTagTransferItem_1, std::allocator<mplay_fi_tcl_MPlayTagTransferItem_1> > oItems;
   virtual ~mplay_fi_tcl_MPlayTagTransfer_1();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_MPlayTagTransfer_1& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlayTagTransfer_2 : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlayTagTransfer_2();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_MPlayTagTransfer_2& operator=(const mplay_fi_tcl_MPlayTagTransfer_2& coRef);
   mplay_fi_tcl_MPlayTagTransfer_2(const mplay_fi_tcl_MPlayTagTransfer_2& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mplay_fi_tcl_MPlayTagTransferItem_2, std::allocator<mplay_fi_tcl_MPlayTagTransferItem_2> > oItems;
   virtual ~mplay_fi_tcl_MPlayTagTransfer_2();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_MPlayTagTransfer_2& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlayUntransferredTagStreamItem : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlayUntransferredTagStreamItem();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_MPlayUntransferredTagStreamItem& operator=(const mplay_fi_tcl_MPlayUntransferredTagStreamItem& coRef);
   mplay_fi_tcl_MPlayUntransferredTagStreamItem(const mplay_fi_tcl_MPlayUntransferredTagStreamItem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sTagArtistName;
   mplay_fi_tclString sTagTrackName;
   tU32 u32TagSongID;
   virtual ~mplay_fi_tcl_MPlayUntransferredTagStreamItem();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_MPlayUntransferredTagStreamItem& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlayUntransferredTagStream : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlayUntransferredTagStream();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_MPlayUntransferredTagStream& operator=(const mplay_fi_tcl_MPlayUntransferredTagStream& coRef);
   mplay_fi_tcl_MPlayUntransferredTagStream(const mplay_fi_tcl_MPlayUntransferredTagStream& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mplay_fi_tcl_MPlayUntransferredTagStreamItem, std::allocator<mplay_fi_tcl_MPlayUntransferredTagStreamItem> > oItems;
   virtual ~mplay_fi_tcl_MPlayUntransferredTagStream();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_MPlayUntransferredTagStream& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlayPermissionByTag : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlayPermissionByTag();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_MPlayPermissionByTag& operator=(const mplay_fi_tcl_MPlayPermissionByTag& coRef);
   mplay_fi_tcl_MPlayPermissionByTag(const mplay_fi_tcl_MPlayPermissionByTag& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mplay_fi_tcl_PermissionByTag, std::allocator<mplay_fi_tcl_PermissionByTag> > PermissionTag;
   virtual ~mplay_fi_tcl_MPlayPermissionByTag();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_MPlayPermissionByTag& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_SearchString : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_SearchString();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_SearchString& operator=(const mplay_fi_tcl_SearchString& coRef);
   mplay_fi_tcl_SearchString(const mplay_fi_tcl_SearchString& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sText;
   tU8 u8Encoding;
   virtual ~mplay_fi_tcl_SearchString();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_SearchString& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlaySearchType : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlaySearchType();
   enum tenType {
      FI_EN_E8GLOBAL_AUDIO_INDEXED_SEARCH = 0UL,
      FI_EN_E8GLOBAL_VIDEO_INDEXED_SEARCH = 4UL,
      FI_EN_E8GLOBAL_AUDIO_VIDEO_INDEXED_SEARCH = 5UL,
      FI_EN_E8GLOBAL_AUDIO_FOLDER_SEARCH = 1UL,
      FI_EN_E8GLOBAL_VIDEO_FOLDER_SEARCH = 2UL,
      FI_EN_E8GLOBAL_AUDIO_VIDEO_FOLDER_SEARCH = 3UL
   };
   tenType enType;

   mplay_fi_tcl_MPlaySearchType(mplay_fi_tcl_MPlaySearchType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_MPlaySearchType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_MPlaySearchType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_VideoScalingType : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_VideoScalingType();
   enum tenType {
      FI_EN_EUNSPECIFIED = 0UL,
      FI_EN_ENORMAL = 1UL,
      FI_EN_EFULL = 2UL,
      FI_EN_ESTRECH = 3UL
   };
   tenType enType;

   mplay_fi_tcl_VideoScalingType(mplay_fi_tcl_VideoScalingType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_VideoScalingType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_VideoScalingType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_IndicesType : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_IndicesType();
   enum tenType {
      FI_EN_INDEX_RANGE = 0UL,
      FI_EN_INDEX_DIRECT = 1UL
   };
   tenType enType;

   mplay_fi_tcl_IndicesType(mplay_fi_tcl_IndicesType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_IndicesType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_IndicesType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_IndicesList : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_IndicesList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_IndicesList& operator=(const mplay_fi_tcl_IndicesList& coRef);
   mplay_fi_tcl_IndicesList(const mplay_fi_tcl_IndicesList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU32, std::allocator<tU32> > oItems;
   virtual ~mplay_fi_tcl_IndicesList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_IndicesList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_AlbumArtUrlList : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_AlbumArtUrlList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_AlbumArtUrlList& operator=(const mplay_fi_tcl_AlbumArtUrlList& coRef);
   mplay_fi_tcl_AlbumArtUrlList(const mplay_fi_tcl_AlbumArtUrlList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mplay_fi_tclString, std::allocator<mplay_fi_tclString> > oItems;
   virtual ~mplay_fi_tcl_AlbumArtUrlList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_AlbumArtUrlList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e_MPlayHIDCommand : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e_MPlayHIDCommand();
   enum tenType {
      FI_EN_HID_PLAY = 0UL,
      FI_EN_HID_PAUSE = 1UL,
      FI_EN_HID_SCAN_NEXT_TRACK = 2UL,
      FI_EN_HID_SCAN_PREV_TRACK = 3UL,
      FI_EN_HID_RANDOM = 4UL,
      FI_EN_HID_REPEAT = 5UL,
      FI_EN_HID_VOICE = 10UL,
      FI_EN_HID_MUTE = 11UL
   };
   tenType enType;

   mplay_fi_tcl_e_MPlayHIDCommand(mplay_fi_tcl_e_MPlayHIDCommand::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e_MPlayHIDCommand();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e_MPlayHIDCommand& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e_MPlayKeyEvent : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e_MPlayKeyEvent();
   enum tenType {
      FI_EN_KEY_PRESS = 0UL,
      FI_EN_KEY_RELEASE = 1UL
   };
   tenType enType;

   mplay_fi_tcl_e_MPlayKeyEvent(mplay_fi_tcl_e_MPlayKeyEvent::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e_MPlayKeyEvent();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e_MPlayKeyEvent& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_MPlayDeviceInfo : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_MPlayDeviceInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_MPlayDeviceInfo& operator=(const mplay_fi_tcl_MPlayDeviceInfo& coRef);
   mplay_fi_tcl_MPlayDeviceInfo(const mplay_fi_tcl_MPlayDeviceInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mplay_fi_tcl_MPlayDeviceInfoItem, std::allocator<mplay_fi_tcl_MPlayDeviceInfoItem> > oItems;
   virtual ~mplay_fi_tcl_MPlayDeviceInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_MPlayDeviceInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DeviceConnectStatus : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DeviceConnectStatus();
   enum tenType {
      FI_EN_USB_DEV_CONNECTED = 2UL,
      FI_EN_USB_DEV_REMOVED_BY_USR = 3UL,
      FI_EN_USB_DEV_UNAVAIL_BAT_LOWVOLT = 4UL,
      FI_EN_USB_DEV_UNAVAIL_HW_MALFUNC_PERMANENT = 6UL,
      FI_EN_USB_DEV_UNAVAIL_HW_MALFUNC = 5UL,
      FI_EN_USB_DEV_UNAVAIL_OVERTEMP = 7UL,
      FI_EN_USB_DEV_UNDEFINED = 0UL,
      FI_EN_USB_DEV_WARNING = 1UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DeviceConnectStatus(mplay_fi_tcl_e8_DeviceConnectStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DeviceConnectStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DeviceConnectStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_Device : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_Device();
   enum tenType {
      FI_EN_DTY_BTA = 13UL,
      FI_EN_DTY_CDDA = 14UL,
      FI_EN_DTY_CDROM = 7UL,
      FI_EN_DTY_DIGITALAUX = 12UL,
      FI_EN_DTY_DVD_DRIVE = 15UL,
      FI_EN_DTY_HUB = 11UL,
      FI_EN_DTY_IPAD = 8UL,
      FI_EN_DTY_IPHONE = 4UL,
      FI_EN_DTY_IPOD = 3UL,
      FI_EN_DTY_MSZUNE = 6UL,
      FI_EN_DTY_MTP = 5UL,
      FI_EN_DTY_NOT_SUPPORTED = 10UL,
      FI_EN_DTY_SDCARD_INTERNAL = 9UL,
      FI_EN_DTY_SDCARD = 2UL,
      FI_EN_DTY_UNKNOWN = 0UL,
      FI_EN_DTY_USB = 1UL
   };
   tenType enType;

   mplay_fi_tcl_e8_Device(mplay_fi_tcl_e8_Device::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_Device();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_Device& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_DevManager_PortStates : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_DevManager_PortStates();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_DevManager_PortStates& operator=(const mplay_fi_tcl_DevManager_PortStates& coRef);
   mplay_fi_tcl_DevManager_PortStates(const mplay_fi_tcl_DevManager_PortStates& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool ElectricalFailure;
   tBool HubConnected;
   tBool OpenCircuit;
   tBool OverCurrent;
   tBool UnderVoltage;
   tBool USBPortConfiguredUsed;
   tBool USBPowerON;
   tU8 USBPortNo;
   virtual ~mplay_fi_tcl_DevManager_PortStates();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_DevManager_PortStates& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_DVM_CardIdentifierRegister : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_DVM_CardIdentifierRegister();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_DVM_CardIdentifierRegister& operator=(const mplay_fi_tcl_DVM_CardIdentifierRegister& coRef);
   mplay_fi_tcl_DVM_CardIdentifierRegister(const mplay_fi_tcl_DVM_CardIdentifierRegister& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > CID;
   virtual ~mplay_fi_tcl_DVM_CardIdentifierRegister();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_DVM_CardIdentifierRegister& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DVM_MediaState : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DVM_MediaState();
   enum tenType {
      FI_EN_MEDIA_NOT_READY = 0UL,
      FI_EN_MEDIA_READY = 1UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DVM_MediaState(mplay_fi_tcl_e8_DVM_MediaState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DVM_MediaState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DVM_MediaState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DVM_DeviceSpeedUsb : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DVM_DeviceSpeedUsb();
   enum tenType {
      FI_EN_FULL_SPEED = 2UL,
      FI_EN_HI_SPEED = 3UL,
      FI_EN_LOW_SPEED = 1UL,
      FI_EN_SUPER_SPEED = 4UL,
      FI_EN_UNKNOWN = 0UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DVM_DeviceSpeedUsb(mplay_fi_tcl_e8_DVM_DeviceSpeedUsb::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DVM_DeviceSpeedUsb();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DVM_DeviceSpeedUsb& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DVM_UnsupportedReason : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DVM_UnsupportedReason();
   enum tenType {
      FI_EN_DISABLEDINCONFIGURATION = 2UL,
      FI_EN_HUBBUTNOTCUSTOMERHUB = 4UL,
      FI_EN_NOTMOUNTEDDEVICE = 1UL,
      FI_EN_NOTSUPPORTEDBYDVM = 3UL,
      FI_EN_OK = 0UL,
      FI_EN_POSSIBLYSUPPORTEDBYOTHERCLIENT = 5UL,
      FI_EN_MULTIPART_UNSUPPORTEDPARTITION = 6UL,
      FI_EN_APPLEDEVICENOTCONNECTEDONCUSTOMERHUB = 7UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DVM_UnsupportedReason(mplay_fi_tcl_e8_DVM_UnsupportedReason::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DVM_UnsupportedReason();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DVM_UnsupportedReason& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_FileSystem : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_FileSystem();
   enum tenType {
      FI_EN_FSTY_EXFAT = 5UL,
      FI_EN_FSTY_EXT4 = 3UL,
      FI_EN_FSTY_FAT = 1UL,
      FI_EN_FSTY_HFS = 4UL,
      FI_EN_FSTY_ISO9660 = 6UL,
      FI_EN_FSTY_NTFS = 2UL,
      FI_EN_FSTY_UDF = 7UL,
      FI_EN_FSTY_UNKNOWN = 0UL
   };
   tenType enType;

   mplay_fi_tcl_e8_FileSystem(mplay_fi_tcl_e8_FileSystem::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_FileSystem();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_FileSystem& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DVM_MediaType : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DVM_MediaType();
   enum tenType {
      FI_EN_DATA_MEDIA = 4UL,
      FI_EN_INCORRECT_MEDIA = 2UL,
      FI_EN_MEDIA_EJECTED = 1UL,
      FI_EN_UNKNOWN_MEDIA = 16UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DVM_MediaType(mplay_fi_tcl_e8_DVM_MediaType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DVM_MediaType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DVM_MediaType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_PowerStatus : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_PowerStatus();
   enum tenType {
      FI_EN_POWER_STATUS_INIT = 0UL,
      FI_EN_POWER_STATUS_NOT_AVAILABLE = 3UL,
      FI_EN_POWER_STATUS_OVERCURRENT_ACTIVE = 2UL,
      FI_EN_POWER_STATUS_OVERCURRENT_INACTIVE = 1UL
   };
   tenType enType;

   mplay_fi_tcl_e8_PowerStatus(mplay_fi_tcl_e8_PowerStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_PowerStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_PowerStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_DevManager_DeviceProperty : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_DevManager_DeviceProperty();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_DevManager_DeviceProperty& operator=(const mplay_fi_tcl_DevManager_DeviceProperty& coRef);
   mplay_fi_tcl_DevManager_DeviceProperty(const mplay_fi_tcl_DevManager_DeviceProperty& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_DeviceConnectStatus DeviceConnectStatus;
   mplay_fi_tcl_e8_Device DeviceType;
   mplay_fi_tcl_e8_DVM_DeviceSpeedUsb DeviceSpeedUsb;
   mplay_fi_tcl_e8_DVM_UnsupportedReason UnsupportedReason;
   mplay_fi_tcl_e8_FileSystem FileSystemType;
   mplay_fi_tclString AccessoryName2;
   mplay_fi_tclString AccessoryName;
   mplay_fi_tclString DeviceName;
   mplay_fi_tclString DeviceSerialNo;
   mplay_fi_tclString DeviceVersion;
   mplay_fi_tclString Manufacturer;
   mplay_fi_tclString MountPoint;
   mplay_fi_tclString USBPortNo;
   tU16 ProductID;
   tU16 VendorID;
   tU64 FreeSize_kB;
   tU64 TotalSize_kB;
   tU64 TotalSize;
   tU64 UsedSize_kB;
   tU8 BaseClassCodeUsb;
   tU8 ParitionNum;
   tU8 ProtocolUsb;
   tU8 SubClassCodeUsb;
   mplay_fi_tclString DevicePath;
   mplay_fi_tclString DeviceNode;
   virtual ~mplay_fi_tcl_DevManager_DeviceProperty();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_DevManager_DeviceProperty& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_DevManager_DevInfoStr : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_DevManager_DevInfoStr();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_DevManager_DevInfoStr& operator=(const mplay_fi_tcl_DevManager_DevInfoStr& coRef);
   mplay_fi_tcl_DevManager_DevInfoStr(const mplay_fi_tcl_DevManager_DevInfoStr& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mplay_fi_tcl_DevManager_DeviceProperty, std::allocator<mplay_fi_tcl_DevManager_DeviceProperty> > DevList;
   virtual ~mplay_fi_tcl_DevManager_DevInfoStr();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_DevManager_DevInfoStr& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_DevManager_SDCardInfo : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_DevManager_SDCardInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_DevManager_SDCardInfo& operator=(const mplay_fi_tcl_DevManager_SDCardInfo& coRef);
   mplay_fi_tcl_DevManager_SDCardInfo(const mplay_fi_tcl_DevManager_SDCardInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_DVM_CardIdentifierRegister CardIdentifierRegister;
   mplay_fi_tcl_e8_DVM_MediaState SDCardState;
   mplay_fi_tcl_e8_DVM_MediaType SDCardMedia;
   mplay_fi_tcl_e8_PowerStatus PowerStatus;
   tBool HW_WriteProtected;
   tBool Mounted;
   tBool SW_WriteProtected;
   mplay_fi_tclString MountPoint;
   tU32 DeviceSerialNo;
   tU64 TotalSize;
   tU8 DevManufactureId;
   tU8 DevSpecVersion;
   tU8 SDCardSlot;
   virtual ~mplay_fi_tcl_DevManager_SDCardInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_DevManager_SDCardInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_SettingsMode : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_SettingsMode();
   enum tenType {
      FI_EN_DEFAULT = 2UL,
      FI_EN_PERMANENT = 1UL,
      FI_EN_TEMPORARY = 0UL
   };
   tenType enType;

   mplay_fi_tcl_e8_SettingsMode(mplay_fi_tcl_e8_SettingsMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_SettingsMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_SettingsMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_AccessoryPowerMode : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_AccessoryPowerMode();
   enum tenType {
      FI_EN_E8DIPO_APM_INTERMITTENT_HIGH_POWER_MODE = 2UL,
      FI_EN_E8DIPO_APM_LOW_POWER_MODE = 1UL,
      FI_EN_E8DIPO_APM_RESERVED = 0UL
   };
   tenType enType;

   mplay_fi_tcl_e8_AccessoryPowerMode(mplay_fi_tcl_e8_AccessoryPowerMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_AccessoryPowerMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_AccessoryPowerMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_BatteryChargingState : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_BatteryChargingState();
   enum tenType {
      FI_EN_E8DIPO_BCS_CHARGED = 2UL,
      FI_EN_E8DIPO_BCS_CHARGING = 1UL,
      FI_EN_E8DIPO_BCS_DISABLED = 0UL
   };
   tenType enType;

   mplay_fi_tcl_e8_BatteryChargingState(mplay_fi_tcl_e8_BatteryChargingState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_BatteryChargingState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_BatteryChargingState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DiPODeviceType : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DiPODeviceType();
   enum tenType {
      FI_EN_E8DTY_UNKNOWN = 0UL,
      FI_EN_E8DTY_USB = 1UL,
      FI_EN_E8DTY_IPOD = 2UL,
      FI_EN_E8DTY_SD = 3UL,
      FI_EN_E8DTY_BLUETOOTH = 4UL,
      FI_EN_E8DTY_IPHONE = 5UL,
      FI_EN_E8DTY_MTP = 6UL,
      FI_EN_E8DTY_CDROM = 7UL,
      FI_EN_E8DTY_FLASH = 8UL,
      FI_EN_E8DTY_UNSUPPORTED = 9UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DiPODeviceType(mplay_fi_tcl_e8_DiPODeviceType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DiPODeviceType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DiPODeviceType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DiPOConnectionType : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DiPOConnectionType();
   enum tenType {
      FI_EN_E8DCT_UNKNOWN = 0UL,
      FI_EN_E8DCT_USB = 1UL,
      FI_EN_E8DCT_BLUETOOTH = 2UL,
      FI_EN_E8DCT_CDROM = 3UL,
      FI_EN_E8DCT_FLASH = 4UL,
      FI_EN_E8DCT_WIFI = 5UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DiPOConnectionType(mplay_fi_tcl_e8_DiPOConnectionType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DiPOConnectionType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DiPOConnectionType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DiPOConnectionState : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DiPOConnectionState();
   enum tenType {
      FI_EN_E8CS_CONNECTED = 0UL,
      FI_EN_E8CS_ATTACHED = 1UL,
      FI_EN_E8CS_DISCONNECTED = 2UL,
      FI_EN_E8CS_HW_MALFUNCTION = 3UL,
      FI_EN_E8CS_UNDERVOLTAGE = 4UL,
      FI_EN_E8CS_UNSUPPORTED = 5UL,
      FI_EN_E8CS_OVERTEMP = 6UL,
      FI_EN_E8CS_ON_HOLD = 7UL,
      FI_EN_E8CS_UNDEFINED = 8UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DiPOConnectionState(mplay_fi_tcl_e8_DiPOConnectionState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DiPOConnectionState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DiPOConnectionState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DiPOCaps : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DiPOCaps();
   enum tenType {
      FI_EN_E8DIPO_CAP_NONE = 0UL,
      FI_EN_E8DIPO_CAP_CARPLAY = 1UL,
      FI_EN_E8DIPO_CAP_NATIVE_TRANSPORT = 2UL,
      FI_EN_E8DIPO_CAP_CARPLAY_NATIVE_TRANSPORT = 3UL,
      FI_EN_E8DIPO_CAP_HOSTMODE_FEASIBLE = 4UL,
      FI_EN_E8DIPO_CAP_CARPLAY_FEASIBLE = 5UL,
      FI_EN_E8DIPO_CAP_CARPLAY_WIFI_FEASIBLE = 6UL,
      FI_EN_E8DIPO_CAP_CARPLAY_WIFI_NOT_FEASIBLE = 7UL,
      FI_EN_E8DIPO_CAP_CARPLAY_WIFI = 8UL,
      FI_EN_E8DIPO_CAP_IAP2BT = 9UL,
      FI_EN_E8DIPO_CAP_CARLIFE = 10UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DiPOCaps(mplay_fi_tcl_e8_DiPOCaps::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DiPOCaps();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DiPOCaps& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DiPODeviceStatus : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DiPODeviceStatus();
   enum tenType {
      FI_EN_E8DS_NONE = 0UL,
      FI_EN_E8DS_INITIALIZING = 1UL,
      FI_EN_E8DS_OK = 2UL,
      FI_EN_E8DS_UNSUPPORTED = 3UL,
      FI_EN_E8DS_UNSUPPORTED_FILESYSTEM = 4UL,
      FI_EN_E8DS_UNSUPPORTED_PARTITION = 5UL,
      FI_EN_E8DS_COMMUNICATION_ERROR = 6UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DiPODeviceStatus(mplay_fi_tcl_e8_DiPODeviceStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DiPODeviceStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DiPODeviceStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DiPOPlaypackAction : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DiPOPlaypackAction();
   enum tenType {
      FI_EN_E8DIPO_PBA_PLAY = 0UL,
      FI_EN_E8DIPO_PBA_PAUSE = 1UL,
      FI_EN_E8DIPO_PBA_STOP = 2UL,
      FI_EN_E8DIPO_PBA_PREV = 3UL,
      FI_EN_E8DIPO_PBA_NEXT = 4UL,
      FI_EN_E8DIPO_PBA_FREV_START = 5UL,
      FI_EN_E8DIPO_PBA_FREV_STOP = 6UL,
      FI_EN_E8DIPO_PBA_FFWD_START = 7UL,
      FI_EN_E8DIPO_PBA_FFWD_STOP = 8UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DiPOPlaypackAction(mplay_fi_tcl_e8_DiPOPlaypackAction::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DiPOPlaypackAction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DiPOPlaypackAction& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DiPOPlaybackStatus : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DiPOPlaybackStatus();
   enum tenType {
      FI_EN_E8DIPO_PBS_STOPPED = 0UL,
      FI_EN_E8DIPO_PBS_PLAYING = 1UL,
      FI_EN_E8DIPO_PBS_PAUSED = 2UL,
      FI_EN_E8DIPO_PBS_SEEKFORWARD = 3UL,
      FI_EN_E8DIPO_PBS_SEEKBACKWARD = 4UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DiPOPlaybackStatus(mplay_fi_tcl_e8_DiPOPlaybackStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DiPOPlaybackStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DiPOPlaybackStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DiPOPlaybackShuffleMode : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DiPOPlaybackShuffleMode();
   enum tenType {
      FI_EN_E8DIPO_PBSM_OFF = 0UL,
      FI_EN_E8DIPO_PBSM_SONGS = 1UL,
      FI_EN_E8DIPO_PBSM_ALBUMS = 2UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DiPOPlaybackShuffleMode(mplay_fi_tcl_e8_DiPOPlaybackShuffleMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DiPOPlaybackShuffleMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DiPOPlaybackShuffleMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DiPOPlaybackRepeatMode : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DiPOPlaybackRepeatMode();
   enum tenType {
      FI_EN_E8DIPO_PBRM_OFF = 0UL,
      FI_EN_E8DIPO_PBRM_ONE = 1UL,
      FI_EN_E8DIPO_PBRM_ALL = 2UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DiPOPlaybackRepeatMode(mplay_fi_tcl_e8_DiPOPlaybackRepeatMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DiPOPlaybackRepeatMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DiPOPlaybackRepeatMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DiPOResponse : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DiPOResponse();
   enum tenType {
      FI_EN_E8DIPO_OK = 0UL,
      FI_EN_E8DIPO_ERROR_UNKNOWN = 1UL,
      FI_EN_E8DIPO_ERROR_INVALIDHANLDE = 2UL,
      FI_EN_E8DIPO_ERROR_NOTSUPPORTED = 3UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DiPOResponse(mplay_fi_tcl_e8_DiPOResponse::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DiPOResponse();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DiPOResponse& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DiPORoleStatus : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DiPORoleStatus();
   enum tenType {
      FI_EN_E8DIPO_CLIENTMODE = 0UL,
      FI_EN_E8DIPO_HOSTMODE = 1UL,
      FI_EN_E8DIPO_CARPLAY_MODE = 2UL,
      FI_EN_E8DIPO_NATIVE_TRANSPORT_MODE = 3UL,
      FI_EN_E8DIPO_CARPLAY_NATIVE_TRANSPORT_MODE = 4UL,
      FI_EN_E8DIPO_CARLIFE_NATIVE_TRANSPORT_MODE = 5UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DiPORoleStatus(mplay_fi_tcl_e8_DiPORoleStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DiPORoleStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DiPORoleStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_DiPODeviceInfoItem : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_DiPODeviceInfoItem();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_DiPODeviceInfoItem& operator=(const mplay_fi_tcl_DiPODeviceInfoItem& coRef);
   mplay_fi_tcl_DiPODeviceInfoItem(const mplay_fi_tcl_DiPODeviceInfoItem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceTag;
   mplay_fi_tclString sDeviceName;
   mplay_fi_tcl_e8_DiPODeviceType e8DeviceType;
   mplay_fi_tclString sDeviceSerialNumber;
   tBool bDeviceConnected;
   tBool bDeviceActiveSource;
   tBool bDiPOCapable;
   tBool bDiPOActive;
   mplay_fi_tclString sDiPOVersion;
   mplay_fi_tcl_e8_DiPOConnectionType e8ConnectionType;
   mplay_fi_tcl_e8_DiPOConnectionState e8ConnectionState;
   mplay_fi_tclString sMountPoint;
   mplay_fi_tclString sAccessoryName;
   mplay_fi_tcl_e8_DiPOCaps e8DiPOCaps;
   mplay_fi_tcl_e8_DiPODeviceStatus e8DeviceState;
   mplay_fi_tclString sDeviceUUID;
   mplay_fi_tclString sDeviceBTMacAddress;
   mplay_fi_tclString sDeviceUSBSerialNumber;
   virtual ~mplay_fi_tcl_DiPODeviceInfoItem();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_DiPODeviceInfoItem& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_DiPODeviceInfo : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_DiPODeviceInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_DiPODeviceInfo& operator=(const mplay_fi_tcl_DiPODeviceInfo& coRef);
   mplay_fi_tcl_DiPODeviceInfo(const mplay_fi_tcl_DiPODeviceInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mplay_fi_tcl_DiPODeviceInfoItem, std::allocator<mplay_fi_tcl_DiPODeviceInfoItem> > oItems;
   virtual ~mplay_fi_tcl_DiPODeviceInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_DiPODeviceInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_DiPOImageData : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_DiPOImageData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_DiPOImageData& operator=(const mplay_fi_tcl_DiPOImageData& coRef);
   mplay_fi_tcl_DiPOImageData(const mplay_fi_tcl_DiPOImageData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > u8Items;
   virtual ~mplay_fi_tcl_DiPOImageData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_DiPOImageData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_b8_DiPOLocationInfoType : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_b8_DiPOLocationInfoType();

   enum {
      FI_C_U8_BIT_GPGGA = 0x1UL,
      FI_C_U8_BIT_GPRMC = 0x2UL,
      FI_C_U8_BIT_GPGSV = 0x4UL,
      FI_C_U8_BIT_GPHDT = 0x8UL,
      FI_C_U8_BIT_PASCD = 0x10UL,
      FI_C_U8_BIT_PAGCD = 0x20UL,
      FI_C_U8_BIT_PAACD = 0x40UL
   };
   tBool bGPGGA() const {return (u8Value & FI_C_U8_BIT_GPGGA) != 0; }
   tVoid vSetGPGGA(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_GPGGA):(u8Value & ~(tU8)FI_C_U8_BIT_GPGGA)); }
   tBool bGPRMC() const {return (u8Value & FI_C_U8_BIT_GPRMC) != 0; }
   tVoid vSetGPRMC(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_GPRMC):(u8Value & ~(tU8)FI_C_U8_BIT_GPRMC)); }
   tBool bGPGSV() const {return (u8Value & FI_C_U8_BIT_GPGSV) != 0; }
   tVoid vSetGPGSV(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_GPGSV):(u8Value & ~(tU8)FI_C_U8_BIT_GPGSV)); }
   tBool bGPHDT() const {return (u8Value & FI_C_U8_BIT_GPHDT) != 0; }
   tVoid vSetGPHDT(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_GPHDT):(u8Value & ~(tU8)FI_C_U8_BIT_GPHDT)); }
   tBool bPASCD() const {return (u8Value & FI_C_U8_BIT_PASCD) != 0; }
   tVoid vSetPASCD(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_PASCD):(u8Value & ~(tU8)FI_C_U8_BIT_PASCD)); }
   tBool bPAGCD() const {return (u8Value & FI_C_U8_BIT_PAGCD) != 0; }
   tVoid vSetPAGCD(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_PAGCD):(u8Value & ~(tU8)FI_C_U8_BIT_PAGCD)); }
   tBool bPAACD() const {return (u8Value & FI_C_U8_BIT_PAACD) != 0; }
   tVoid vSetPAACD(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_PAACD):(u8Value & ~(tU8)FI_C_U8_BIT_PAACD)); }
   struct rBitValues {
      tBool GPGGA:1;
      tBool GPRMC:1;
      tBool GPGSV:1;
      tBool GPHDT:1;
      tBool PASCD:1;
      tBool PAGCD:1;
      tBool PAACD:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~mplay_fi_tcl_b8_DiPOLocationInfoType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_b8_DiPOLocationInfoType& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_b8_DiPOGPRMCDataStatusValues : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_b8_DiPOGPRMCDataStatusValues();

   enum {
      FI_C_U8_BIT_GPRMCDATASTATUSVALUEA = 0x1UL,
      FI_C_U8_BIT_GPRMCDATASTATUSVALUEV = 0x2UL,
      FI_C_U8_BIT_GPRMCDATASTATUSVALUEX = 0x4UL
   };
   tBool bGPRMCDataStatusValueA() const {return (u8Value & FI_C_U8_BIT_GPRMCDATASTATUSVALUEA) != 0; }
   tVoid vSetGPRMCDataStatusValueA(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_GPRMCDATASTATUSVALUEA):(u8Value & ~(tU8)FI_C_U8_BIT_GPRMCDATASTATUSVALUEA)); }
   tBool bGPRMCDataStatusValueV() const {return (u8Value & FI_C_U8_BIT_GPRMCDATASTATUSVALUEV) != 0; }
   tVoid vSetGPRMCDataStatusValueV(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_GPRMCDATASTATUSVALUEV):(u8Value & ~(tU8)FI_C_U8_BIT_GPRMCDATASTATUSVALUEV)); }
   tBool bGPRMCDataStatusValueX() const {return (u8Value & FI_C_U8_BIT_GPRMCDATASTATUSVALUEX) != 0; }
   tVoid vSetGPRMCDataStatusValueX(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_GPRMCDATASTATUSVALUEX):(u8Value & ~(tU8)FI_C_U8_BIT_GPRMCDATASTATUSVALUEX)); }
   struct rBitValues {
      tBool GPRMCDataStatusValueA:1;
      tBool GPRMCDataStatusValueV:1;
      tBool GPRMCDataStatusValueX:1;
      tBool dummy3:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~mplay_fi_tcl_b8_DiPOGPRMCDataStatusValues();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_b8_DiPOGPRMCDataStatusValues& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_AudioError : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_AudioError();
   enum tenType {
      FI_EN_E8NO_ERROR = 0UL,
      FI_EN_E8UNKNOWN_ERROR = 1UL,
      FI_EN_E8ACTIVATION_ERROR = 2UL,
      FI_EN_E8ALLOCATE_ERROR = 3UL,
      FI_EN_E8SOURCEACT_ON_ERROR = 4UL,
      FI_EN_E8DEACTIVATION_ERROR = 5UL,
      FI_EN_E8DEALLOCATE_ERROR = 6UL,
      FI_EN_E8SOURCEACT_OFF_ERROR = 7UL
   };
   tenType enType;

   mplay_fi_tcl_e8_AudioError(mplay_fi_tcl_e8_AudioError::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_AudioError();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_AudioError& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_AppLaunchOption : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_AppLaunchOption();
   enum tenType {
      FI_EN_E8LAUNCH_WITH_USER_ALERT = 0UL,
      FI_EN_E8LAUNCH_WITHOUT_USER_ALERT = 1UL
   };
   tenType enType;

   mplay_fi_tcl_e8_AppLaunchOption(mplay_fi_tcl_e8_AppLaunchOption::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_AppLaunchOption();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_AppLaunchOption& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_b32_BTProfileType : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_b32_BTProfileType();

   enum {
      FI_C_U32_BIT_HANDSFREE = 0x1UL,
      FI_C_U32_BIT_PHONEBOOKACCESS = 0x2UL,
      FI_C_U32_BIT_AUDIOVIDEOREMOTECONTROL = 0x8UL,
      FI_C_U32_BIT_ADVANCEDAUDIODISTRIBUTION = 0x10UL,
      FI_C_U32_BIT_HUMANINTERFACEDEVICE = 0x20UL,
      FI_C_U32_BIT_IAP2LINK = 0x80UL,
      FI_C_U32_BIT_PERSONALAREANETWORKACCESSPOINT = 0x100UL,
      FI_C_U32_BIT_MESSAGEACCESS = 0x200UL,
      FI_C_U32_BIT_PERSONALAREANETWORKCLIENT = 0x1000UL
   };
   tBool bHandsFree() const {return (u32Value & FI_C_U32_BIT_HANDSFREE) != 0; }
   tVoid vSetHandsFree(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_HANDSFREE):(u32Value & ~(tU32)FI_C_U32_BIT_HANDSFREE)); }
   tBool bPhoneBookAccess() const {return (u32Value & FI_C_U32_BIT_PHONEBOOKACCESS) != 0; }
   tVoid vSetPhoneBookAccess(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_PHONEBOOKACCESS):(u32Value & ~(tU32)FI_C_U32_BIT_PHONEBOOKACCESS)); }
   tBool bAudioVideoRemoteControl() const {return (u32Value & FI_C_U32_BIT_AUDIOVIDEOREMOTECONTROL) != 0; }
   tVoid vSetAudioVideoRemoteControl(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_AUDIOVIDEOREMOTECONTROL):(u32Value & ~(tU32)FI_C_U32_BIT_AUDIOVIDEOREMOTECONTROL)); }
   tBool bAdvancedAudioDistribution() const {return (u32Value & FI_C_U32_BIT_ADVANCEDAUDIODISTRIBUTION) != 0; }
   tVoid vSetAdvancedAudioDistribution(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_ADVANCEDAUDIODISTRIBUTION):(u32Value & ~(tU32)FI_C_U32_BIT_ADVANCEDAUDIODISTRIBUTION)); }
   tBool bHumanInterfaceDevice() const {return (u32Value & FI_C_U32_BIT_HUMANINTERFACEDEVICE) != 0; }
   tVoid vSetHumanInterfaceDevice(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_HUMANINTERFACEDEVICE):(u32Value & ~(tU32)FI_C_U32_BIT_HUMANINTERFACEDEVICE)); }
   tBool biAP2Link() const {return (u32Value & FI_C_U32_BIT_IAP2LINK) != 0; }
   tVoid vSetiAP2Link(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_IAP2LINK):(u32Value & ~(tU32)FI_C_U32_BIT_IAP2LINK)); }
   tBool bPersonalAreaNetworkAccessPoint() const {return (u32Value & FI_C_U32_BIT_PERSONALAREANETWORKACCESSPOINT) != 0; }
   tVoid vSetPersonalAreaNetworkAccessPoint(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_PERSONALAREANETWORKACCESSPOINT):(u32Value & ~(tU32)FI_C_U32_BIT_PERSONALAREANETWORKACCESSPOINT)); }
   tBool bMessageAccess() const {return (u32Value & FI_C_U32_BIT_MESSAGEACCESS) != 0; }
   tVoid vSetMessageAccess(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_MESSAGEACCESS):(u32Value & ~(tU32)FI_C_U32_BIT_MESSAGEACCESS)); }
   tBool bPersonalAreaNetworkClient() const {return (u32Value & FI_C_U32_BIT_PERSONALAREANETWORKCLIENT) != 0; }
   tVoid vSetPersonalAreaNetworkClient(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_PERSONALAREANETWORKCLIENT):(u32Value & ~(tU32)FI_C_U32_BIT_PERSONALAREANETWORKCLIENT)); }
   struct rBitValues {
      tBool HandsFree:1;
      tBool PhoneBookAccess:1;
      tBool dummy2:1;
      tBool AudioVideoRemoteControl:1;
      tBool AdvancedAudioDistribution:1;
      tBool HumanInterfaceDevice:1;
      tBool dummy6:1;
      tBool iAP2Link:1;
      tBool PersonalAreaNetworkAccessPoint:1;
      tBool MessageAccess:1;
      tBool dummy10:1;
      tBool dummy11:1;
      tBool PersonalAreaNetworkClient:1;
      tBool dummy13:1;
      tBool dummy14:1;
      tBool dummy15:1;
      tBool dummy16:1;
      tBool dummy17:1;
      tBool dummy18:1;
      tBool dummy19:1;
      tBool dummy20:1;
      tBool dummy21:1;
      tBool dummy22:1;
      tBool dummy23:1;
      tBool dummy24:1;
      tBool dummy25:1;
      tBool dummy26:1;
      tBool dummy27:1;
      tBool dummy28:1;
      tBool dummy29:1;
      tBool dummy30:1;
      tBool dummy31:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };
   virtual ~mplay_fi_tcl_b32_BTProfileType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_b32_BTProfileType& roRef) const
      {  return (u32Value == roRef.u32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_BTProfileItem : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_BTProfileItem();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_BTProfileItem& operator=(const mplay_fi_tcl_BTProfileItem& coRef);
   mplay_fi_tcl_BTProfileItem(const mplay_fi_tcl_BTProfileItem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceId;
   mplay_fi_tcl_b32_BTProfileType b32BTProfile;
   virtual ~mplay_fi_tcl_BTProfileItem();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_BTProfileItem& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_BTProfileInfo : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_BTProfileInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_BTProfileInfo& operator=(const mplay_fi_tcl_BTProfileInfo& coRef);
   mplay_fi_tcl_BTProfileInfo(const mplay_fi_tcl_BTProfileInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mplay_fi_tcl_BTProfileItem, std::allocator<mplay_fi_tcl_BTProfileItem> > oItems;
   virtual ~mplay_fi_tcl_BTProfileInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_BTProfileInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DiPOCallStateUpdateStatus : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DiPOCallStateUpdateStatus();
   enum tenType {
      FI_EN_E8DIPO_CSUS_DISCONNECTED = 0UL,
      FI_EN_E8DIPO_CSUS_SENDING = 1UL,
      FI_EN_E8DIPO_CSUS_RINGING = 2UL,
      FI_EN_E8DIPO_CSUS_CONNECTING = 3UL,
      FI_EN_E8DIPO_CSUS_ACTIVE = 4UL,
      FI_EN_E8DIPO_CSUS_HELD = 5UL,
      FI_EN_E8DIPO_CSUS_DISCONNECTING = 6UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DiPOCallStateUpdateStatus(mplay_fi_tcl_e8_DiPOCallStateUpdateStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DiPOCallStateUpdateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DiPOCallStateUpdateStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DiPOCallStateUpdateDirection : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DiPOCallStateUpdateDirection();
   enum tenType {
      FI_EN_E8DIPO_CSUD_UNKNOWN = 0UL,
      FI_EN_E8DIPO_CSUD_INCOMING = 1UL,
      FI_EN_E8DIPO_CSUD_OUTGOING = 2UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DiPOCallStateUpdateDirection(mplay_fi_tcl_e8_DiPOCallStateUpdateDirection::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DiPOCallStateUpdateDirection();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DiPOCallStateUpdateDirection& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DiPOCallStateUpdateService : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DiPOCallStateUpdateService();
   enum tenType {
      FI_EN_E8DIPO_CSEV_UNKNOWN = 0UL,
      FI_EN_E8DIPO_CSEV_TELEPHONY = 1UL,
      FI_EN_E8DIPO_CSEV_FACETIMEAUDIO = 2UL,
      FI_EN_E8DIPO_CSEV_FACETIMEVIDEO = 3UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DiPOCallStateUpdateService(mplay_fi_tcl_e8_DiPOCallStateUpdateService::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DiPOCallStateUpdateService();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DiPOCallStateUpdateService& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DiPOCallStateUpdateDisconnectReason : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DiPOCallStateUpdateDisconnectReason();
   enum tenType {
      FI_EN_E8DIPO_CSDR_ENDED = 0UL,
      FI_EN_E8DIPO_CSDR_DECLINED = 1UL,
      FI_EN_E8DIPO_CSDR_FAILED = 2UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DiPOCallStateUpdateDisconnectReason(mplay_fi_tcl_e8_DiPOCallStateUpdateDisconnectReason::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DiPOCallStateUpdateDisconnectReason();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DiPOCallStateUpdateDisconnectReason& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_DiPOCallStateItem : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_DiPOCallStateItem();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_DiPOCallStateItem& operator=(const mplay_fi_tcl_DiPOCallStateItem& coRef);
   mplay_fi_tcl_DiPOCallStateItem(const mplay_fi_tcl_DiPOCallStateItem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sRemoteID;
   mplay_fi_tclString sDisplayName;
   mplay_fi_tcl_e8_DiPOCallStateUpdateStatus eStatus;
   mplay_fi_tcl_e8_DiPOCallStateUpdateDirection eDirection;
   mplay_fi_tclString sCallUUID;
   mplay_fi_tclString sAddressBookID;
   mplay_fi_tclString sLabel;
   mplay_fi_tcl_e8_DiPOCallStateUpdateService eService;
   tBool bIsConferenced;
   tU8 u8ConferenceGroup;
   mplay_fi_tcl_e8_DiPOCallStateUpdateDisconnectReason eDisconnectReason;
   tU64 u64StartTimestamp;
   virtual ~mplay_fi_tcl_DiPOCallStateItem();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_DiPOCallStateItem& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_DiPOCallStateUpdate : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_DiPOCallStateUpdate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_DiPOCallStateUpdate& operator=(const mplay_fi_tcl_DiPOCallStateUpdate& coRef);
   mplay_fi_tcl_DiPOCallStateUpdate(const mplay_fi_tcl_DiPOCallStateUpdate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mplay_fi_tcl_DiPOCallStateItem, std::allocator<mplay_fi_tcl_DiPOCallStateItem> > oItems;
   virtual ~mplay_fi_tcl_DiPOCallStateUpdate();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_DiPOCallStateUpdate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DiPOCommunicationsUpdateSignalStrength : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DiPOCommunicationsUpdateSignalStrength();
   enum tenType {
      FI_EN_E8DIPO_CUSS_0BARS = 0UL,
      FI_EN_E8DIPO_CUSS_1BAR = 1UL,
      FI_EN_E8DIPO_CUSS_2BARS = 2UL,
      FI_EN_E8DIPO_CUSS_3BARS = 3UL,
      FI_EN_E8DIPO_CUSS_4BARS = 4UL,
      FI_EN_E8DIPO_CUSS_5BARS = 5UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DiPOCommunicationsUpdateSignalStrength(mplay_fi_tcl_e8_DiPOCommunicationsUpdateSignalStrength::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DiPOCommunicationsUpdateSignalStrength();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DiPOCommunicationsUpdateSignalStrength& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DiPOCommunicationsUpdateRegistrationStatus : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DiPOCommunicationsUpdateRegistrationStatus();
   enum tenType {
      FI_EN_E8DIPO_CURS_UNKNONW = 0UL,
      FI_EN_E8DIPO_CURS_NOTREGISTERED = 1UL,
      FI_EN_E8DIPO_CURS_SEARCHING = 2UL,
      FI_EN_E8DIPO_CURS_DENIED = 3UL,
      FI_EN_E8DIPO_CURS_REGISTEREDHOME = 4UL,
      FI_EN_E8DIPO_CURS_REGISTEREDROAMING = 5UL,
      FI_EN_E8DIPO_CURS_EMERGENCYCALLONLY = 6UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DiPOCommunicationsUpdateRegistrationStatus(mplay_fi_tcl_e8_DiPOCommunicationsUpdateRegistrationStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DiPOCommunicationsUpdateRegistrationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DiPOCommunicationsUpdateRegistrationStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_RouteGuidanceDisplayComponentIDs : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_RouteGuidanceDisplayComponentIDs();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_RouteGuidanceDisplayComponentIDs& operator=(const mplay_fi_tcl_RouteGuidanceDisplayComponentIDs& coRef);
   mplay_fi_tcl_RouteGuidanceDisplayComponentIDs(const mplay_fi_tcl_RouteGuidanceDisplayComponentIDs& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU16, std::allocator<tU16> > Items;
   virtual ~mplay_fi_tcl_RouteGuidanceDisplayComponentIDs();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_RouteGuidanceDisplayComponentIDs& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_RouteGuidanceState : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_RouteGuidanceState();
   enum tenType {
      FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_NO_ROUTE_SET = 0UL,
      FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_ROUTE_SET = 1UL,
      FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_ARRIVED = 2UL,
      FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_LOADING = 3UL,
      FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_LOCATING = 4UL,
      FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_REROUTING = 5UL,
      FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_PROCEEDTOROUTE = 6UL
   };
   tenType enType;

   mplay_fi_tcl_e8_RouteGuidanceState(mplay_fi_tcl_e8_RouteGuidanceState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_RouteGuidanceState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_RouteGuidanceState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_ManeuverState : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_ManeuverState();
   enum tenType {
      FI_EN_E8DIPO_MANEUVER_STATE_CONTINUE = 0UL,
      FI_EN_E8DIPO_MANEUVER_STATE_INITIAL = 1UL,
      FI_EN_E8DIPO_MANEUVER_STATE_PREPARE = 2UL,
      FI_EN_E8DIPO_MANEUVER_STATE_EXECUTE = 3UL
   };
   tenType enType;

   mplay_fi_tcl_e8_ManeuverState(mplay_fi_tcl_e8_ManeuverState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_ManeuverState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_ManeuverState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DistanceDisplayUnits : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DistanceDisplayUnits();
   enum tenType {
      FI_EN_E8DIPO_DISTANCE_DISPLAY_UNIT_KM = 0UL,
      FI_EN_E8DIPO_DISTANCE_DISPLAY_UNIT_MILES = 1UL,
      FI_EN_E8DIPO_DISTANCE_DISPLAY_UNIT_M = 2UL,
      FI_EN_E8DIPO_DISTANCE_DISPLAY_UNIT_YARDS = 3UL,
      FI_EN_E8DIPO_DISTANCE_DISPLAY_UNIT_FT = 4UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DistanceDisplayUnits(mplay_fi_tcl_e8_DistanceDisplayUnits::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DistanceDisplayUnits();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DistanceDisplayUnits& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_RouteGuidanceManeuverCurrentList : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_RouteGuidanceManeuverCurrentList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_RouteGuidanceManeuverCurrentList& operator=(const mplay_fi_tcl_RouteGuidanceManeuverCurrentList& coRef);
   mplay_fi_tcl_RouteGuidanceManeuverCurrentList(const mplay_fi_tcl_RouteGuidanceManeuverCurrentList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU16, std::allocator<tU16> > u16Items;
   virtual ~mplay_fi_tcl_RouteGuidanceManeuverCurrentList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_RouteGuidanceManeuverCurrentList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_ManeuverType : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_ManeuverType();
   enum tenType {
      FI_EN_E8DIPO_MANEUVER_TYPE_NO_TURN = 0UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_LEFT_TURN = 1UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_RIGHT_TURN = 2UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_STRAIGHT_AHEAD = 3UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_MAKE_U_TURN = 4UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_CONTINUE = 5UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ENTER_ROUNDABOUT = 6UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_EXIT_ROUNDABOUT = 7UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_OFF_RAMP = 8UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ON_RAMP = 9UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ARRIVE_END_OF_NAVIGATION = 10UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_PROCEED_TO_THE_BEGINNING_OF_ROUTE = 11UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION = 12UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_KEEP_LEFT = 13UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_KEEP_RIGHT = 14UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ENTER_FERRY = 15UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_EXIT_FERRY = 16UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_CHANGE_TO_DIFFERENT_FERRY = 17UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_MAKE_U_TURN_AND_PROCEED_TO_ROUTE = 18UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_USE_ROUNDABOUT_TO_MAKE_U_TURN = 19UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_END_OF_ROAD_TURN_LEFT = 20UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_END_OF_ROAD_TURN_RIGHT = 21UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_HIGHWAY_OFF_RAMP_LEFT = 22UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_HIGHWAY_OFF_RAMP_RIGHT = 23UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION_LEFT = 24UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ARRIVE_AT_DESTINATION_RIGHT = 25UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_MAKE_U_TURN_WHEN_POSSIBLE = 26UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ARRIVE_END_OF_DIRECTIONS = 27UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_1 = 28UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_2 = 29UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_3 = 30UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_4 = 31UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_5 = 32UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_6 = 33UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_7 = 34UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_8 = 35UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_9 = 36UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_10 = 37UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_11 = 38UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_12 = 39UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_13 = 40UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_14 = 41UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_15 = 42UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_16 = 43UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_17 = 44UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_18 = 45UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_ROUNDABOUT_EXIT_19 = 46UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_SHARP_LEFT_TURN = 47UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_SHARP_RIGHT_TURN = 48UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_SLIGHT_LEFT_TURN = 49UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_SLIGHT_RIGHT_TURN = 50UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY = 51UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY_LEFT = 52UL,
      FI_EN_E8DIPO_MANEUVER_TYPE_CHANGE_HIGHWAY_RIGHT = 53UL
   };
   tenType enType;

   mplay_fi_tcl_e8_ManeuverType(mplay_fi_tcl_e8_ManeuverType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_ManeuverType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_ManeuverType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DrivingSide : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DrivingSide();
   enum tenType {
      FI_EN_E8DIPO_DRIVING_SIDE_RIGHT = 0UL,
      FI_EN_E8DIPO_DRIVING_SIDE_LEFT = 1UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DrivingSide(mplay_fi_tcl_e8_DrivingSide::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DrivingSide();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DrivingSide& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_JunctionType : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_JunctionType();
   enum tenType {
      FI_EN_E8DIPO_JUNCTION_TYPE_SINGLE_INTERSECTION = 0UL,
      FI_EN_E8DIPO_JUNCTION_TYPE_ROUNDABOUT = 1UL
   };
   tenType enType;

   mplay_fi_tcl_e8_JunctionType(mplay_fi_tcl_e8_JunctionType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_JunctionType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_JunctionType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_JunctionElementAngles : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_JunctionElementAngles();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_JunctionElementAngles& operator=(const mplay_fi_tcl_JunctionElementAngles& coRef);
   mplay_fi_tcl_JunctionElementAngles(const mplay_fi_tcl_JunctionElementAngles& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tS16, std::allocator<tS16> > Items;
   virtual ~mplay_fi_tcl_JunctionElementAngles();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_JunctionElementAngles& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_RouteGuidanceDisplayComponentItem : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_RouteGuidanceDisplayComponentItem();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_RouteGuidanceDisplayComponentItem& operator=(const mplay_fi_tcl_RouteGuidanceDisplayComponentItem& coRef);
   mplay_fi_tcl_RouteGuidanceDisplayComponentItem(const mplay_fi_tcl_RouteGuidanceDisplayComponentItem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 Identifier;
   mplay_fi_tclString Name;
   tU16 MaxCurrentRoadNameLength;
   tU16 MaxDestinationNameLength;
   tU16 MaxAfterManeuverRoadNameLength;
   tU16 MaxManeuverDescriptionLength;
   tU16 MaxGuidanceManeuverCapacity;
   virtual ~mplay_fi_tcl_RouteGuidanceDisplayComponentItem();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_RouteGuidanceDisplayComponentItem& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_RouteGuidanceDisplayComponents : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_RouteGuidanceDisplayComponents();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_RouteGuidanceDisplayComponents& operator=(const mplay_fi_tcl_RouteGuidanceDisplayComponents& coRef);
   mplay_fi_tcl_RouteGuidanceDisplayComponents(const mplay_fi_tcl_RouteGuidanceDisplayComponents& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mplay_fi_tcl_RouteGuidanceDisplayComponentItem, std::allocator<mplay_fi_tcl_RouteGuidanceDisplayComponentItem> > oItems;
   virtual ~mplay_fi_tcl_RouteGuidanceDisplayComponents();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_RouteGuidanceDisplayComponents& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_RouteGuidanceUpdate : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_RouteGuidanceUpdate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_RouteGuidanceUpdate& operator=(const mplay_fi_tcl_RouteGuidanceUpdate& coRef);
   mplay_fi_tcl_RouteGuidanceUpdate(const mplay_fi_tcl_RouteGuidanceUpdate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bRouteGuidanceDisplayComponentIDsAvailable;
   mplay_fi_tcl_RouteGuidanceDisplayComponentIDs RouteGuidanceDisplayComponentIDs;
   tBool bRouteGuidanceStateAvailable;
   mplay_fi_tcl_e8_RouteGuidanceState e8RouteGuidanceState;
   tBool bManeuverStateAvailable;
   mplay_fi_tcl_e8_ManeuverState e8ManeuverState;
   tBool bCurrentRoadNameAvailable;
   mplay_fi_tclString CurrentRoadName;
   tBool bDestinationNameAvailable;
   mplay_fi_tclString DestinationName;
   tBool bEstimatedTimeOfArrivalAvailable;
   tU64 EstimatedTimeOfArrival;
   tBool bTimeRemainingToDestinationAvailable;
   tU64 TimeRemainingToDestination;
   tBool bDistanceRemainingAvailable;
   tU32 DistanceRemaining;
   tBool bDistanceRemainingDisplayStrAvailable;
   mplay_fi_tclString DistanceRemainingDisplayStr;
   tBool bDistanceRemainingDisplayUnitsAvailable;
   mplay_fi_tcl_e8_DistanceDisplayUnits e8DistanceRemainingDisplayUnits;
   tBool bDistanceToNextManeuverAvailable;
   tU32 DistanceToNextManeuver;
   tBool bDistanceToNextManeuverDisplayStrAvailable;
   mplay_fi_tclString DistanceToNextManeuverDisplayStr;
   tBool bDistanceToNextManeuverDisplayUnitsAvailable;
   mplay_fi_tcl_e8_DistanceDisplayUnits e8DistanceToNextManeuverDisplayUnits;
   tBool bRouteGuidanceManeuverCurrentListAvailable;
   mplay_fi_tcl_RouteGuidanceManeuverCurrentList RouteGuidanceManeuverCurrentList;
   tBool bRouteGuidanceManeuverCountAvailable;
   tU16 RouteGuidanceManeuverCount;
   tBool bRouteGuidanceVisibleInAppAvailable;
   tBool RouteGuidanceVisibleInApp;
   tBool bSourceNameAvailable;
   mplay_fi_tclString SourceName;
   tBool bSourceSupportsRouteGuidanceAvailable;
   tBool SourceSupportsRouteGuidance;
   virtual ~mplay_fi_tcl_RouteGuidanceUpdate();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_RouteGuidanceUpdate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_RouteGuidanceManeuverUpdate : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_RouteGuidanceManeuverUpdate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_RouteGuidanceManeuverUpdate& operator=(const mplay_fi_tcl_RouteGuidanceManeuverUpdate& coRef);
   mplay_fi_tcl_RouteGuidanceManeuverUpdate(const mplay_fi_tcl_RouteGuidanceManeuverUpdate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bRouteGuidanceDisplayComponentIDsAvailable;
   mplay_fi_tcl_RouteGuidanceDisplayComponentIDs RouteGuidanceDisplayComponentIDs;
   tBool bIndexAvailable;
   tU16 Index;
   tBool bManeuverDescriptionAvailable;
   mplay_fi_tclString ManeuverDescription;
   tBool bManeuverTypeAvailable;
   mplay_fi_tcl_e8_ManeuverType e8ManeuverType;
   tBool bAfterManeuverRoadNameAvailable;
   mplay_fi_tclString AfterManeuverRoadName;
   tBool bDistanceBetweenManeuverAvailable;
   tU32 DistanceBetweenManeuver;
   tBool bDistanceBetweenManeuverDisplayStrAvailable;
   mplay_fi_tclString DistanceBetweenManeuverDisplayStr;
   tBool bDistanceBetweenManeuverDisplayUnitsAvailable;
   mplay_fi_tcl_e8_DistanceDisplayUnits e8DistanceBetweenManeuverDisplayUnits;
   tBool bDrivingSideAvailable;
   mplay_fi_tcl_e8_DrivingSide e8DrivingSide;
   tBool bJunctionTypeAvailable;
   mplay_fi_tcl_e8_JunctionType e8JunctionType;
   tBool bJunctionElementAngleAvailable;
   mplay_fi_tcl_JunctionElementAngles JunctionElementAngle;
   tBool bJunctionElementExitAngleAvailable;
   tS16 JunctionElementExitAngle;
   virtual ~mplay_fi_tcl_RouteGuidanceManeuverUpdate();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_RouteGuidanceManeuverUpdate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_CallControlsConfiguration : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_CallControlsConfiguration();

   enum {
      FI_C_U8_BIT_INITIATECALL = 0x1UL,
      FI_C_U8_BIT_ACCEPTCALL = 0x2UL,
      FI_C_U8_BIT_ENDCALL = 0x4UL,
      FI_C_U8_BIT_SWAPCALLS = 0x8UL,
      FI_C_U8_BIT_MERGECALLS = 0x10UL,
      FI_C_U8_BIT_HOLDSTATUSUPDATE = 0x20UL,
      FI_C_U8_BIT_MUTESTATUSUPDATE = 0x40UL,
      FI_C_U8_BIT_SENDDTMF = 0x80UL
   };
   tBool bInitiateCall() const {return (u8Value & FI_C_U8_BIT_INITIATECALL) != 0; }
   tVoid vSetInitiateCall(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_INITIATECALL):(u8Value & ~(tU8)FI_C_U8_BIT_INITIATECALL)); }
   tBool bAcceptCall() const {return (u8Value & FI_C_U8_BIT_ACCEPTCALL) != 0; }
   tVoid vSetAcceptCall(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_ACCEPTCALL):(u8Value & ~(tU8)FI_C_U8_BIT_ACCEPTCALL)); }
   tBool bEndCall() const {return (u8Value & FI_C_U8_BIT_ENDCALL) != 0; }
   tVoid vSetEndCall(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_ENDCALL):(u8Value & ~(tU8)FI_C_U8_BIT_ENDCALL)); }
   tBool bSwapCalls() const {return (u8Value & FI_C_U8_BIT_SWAPCALLS) != 0; }
   tVoid vSetSwapCalls(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_SWAPCALLS):(u8Value & ~(tU8)FI_C_U8_BIT_SWAPCALLS)); }
   tBool bMergeCalls() const {return (u8Value & FI_C_U8_BIT_MERGECALLS) != 0; }
   tVoid vSetMergeCalls(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_MERGECALLS):(u8Value & ~(tU8)FI_C_U8_BIT_MERGECALLS)); }
   tBool bHoldStatusUpdate() const {return (u8Value & FI_C_U8_BIT_HOLDSTATUSUPDATE) != 0; }
   tVoid vSetHoldStatusUpdate(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_HOLDSTATUSUPDATE):(u8Value & ~(tU8)FI_C_U8_BIT_HOLDSTATUSUPDATE)); }
   tBool bMuteStatusUpdate() const {return (u8Value & FI_C_U8_BIT_MUTESTATUSUPDATE) != 0; }
   tVoid vSetMuteStatusUpdate(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_MUTESTATUSUPDATE):(u8Value & ~(tU8)FI_C_U8_BIT_MUTESTATUSUPDATE)); }
   tBool bSendDTMF() const {return (u8Value & FI_C_U8_BIT_SENDDTMF) != 0; }
   tVoid vSetSendDTMF(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_SENDDTMF):(u8Value & ~(tU8)FI_C_U8_BIT_SENDDTMF)); }
   struct rBitValues {
      tBool InitiateCall:1;
      tBool AcceptCall:1;
      tBool EndCall:1;
      tBool SwapCalls:1;
      tBool MergeCalls:1;
      tBool HoldStatusUpdate:1;
      tBool MuteStatusUpdate:1;
      tBool SendDTMF:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~mplay_fi_tcl_CallControlsConfiguration();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_CallControlsConfiguration& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e_InitiateCallType : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e_InitiateCallType();
   enum tenType {
      FI_EN_EDESTINATION = 0UL,
      FI_EN_EVOICE_MAIL = 1UL,
      FI_EN_EREDIAL = 2UL
   };
   tenType enType;

   mplay_fi_tcl_e_InitiateCallType(mplay_fi_tcl_e_InitiateCallType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e_InitiateCallType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e_InitiateCallType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e_InitiateCallService : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e_InitiateCallService();
   enum tenType {
      FI_EN_ETELEPHONY = 1UL,
      FI_EN_EFACE_TIME_AUDIO = 2UL,
      FI_EN_EFACE_TIME_VIDEO = 3UL
   };
   tenType enType;

   mplay_fi_tcl_e_InitiateCallService(mplay_fi_tcl_e_InitiateCallService::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e_InitiateCallService();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e_InitiateCallService& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e_AcceptAction : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e_AcceptAction();
   enum tenType {
      FI_EN_EACCEPT_OR_HOLD_AND_ACCEPT = 0UL,
      FI_EN_EEND_AND_ACCEPT = 1UL
   };
   tenType enType;

   mplay_fi_tcl_e_AcceptAction(mplay_fi_tcl_e_AcceptAction::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e_AcceptAction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e_AcceptAction& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e_EndAction : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e_EndAction();
   enum tenType {
      FI_EN_EEND_OR_DECLINE = 0UL,
      FI_EN_EEND_ALL = 1UL
   };
   tenType enType;

   mplay_fi_tcl_e_EndAction(mplay_fi_tcl_e_EndAction::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e_EndAction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e_EndAction& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e_SendDTMFTone : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e_SendDTMFTone();
   enum tenType {
      FI_EN_NUMBER_0 = 0UL,
      FI_EN_NUMBER_1 = 1UL,
      FI_EN_NUMBER_2 = 2UL,
      FI_EN_NUMBER_3 = 3UL,
      FI_EN_NUMBER_4 = 4UL,
      FI_EN_NUMBER_5 = 5UL,
      FI_EN_NUMBER_6 = 6UL,
      FI_EN_NUMBER_7 = 7UL,
      FI_EN_NUMBER_8 = 8UL,
      FI_EN_NUMBER_9 = 9UL,
      FI_EN_STAR = 10UL,
      FI_EN_POUND = 11UL
   };
   tenType enType;

   mplay_fi_tcl_e_SendDTMFTone(mplay_fi_tcl_e_SendDTMFTone::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e_SendDTMFTone();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e_SendDTMFTone& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DiPOCommunicationError : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DiPOCommunicationError();
   enum tenType {
      FI_EN_E8IPOD_NO_ERROR = 0UL,
      FI_EN_E8IPOD_COMM_ERROR = 1UL,
      FI_EN_E8IPOD_ROLESWITCH_ERROR = 2UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DiPOCommunicationError(mplay_fi_tcl_e8_DiPOCommunicationError::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DiPOCommunicationError();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DiPOCommunicationError& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_AppInfo : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_AppInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_AppInfo& operator=(const mplay_fi_tcl_AppInfo& coRef);
   mplay_fi_tcl_AppInfo(const mplay_fi_tcl_AppInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sAppName;
   mplay_fi_tclString sProtocol;
   mplay_fi_tclString sBundleID;
   virtual ~mplay_fi_tcl_AppInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_AppInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_DeviceTimeUpdate : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_DeviceTimeUpdate();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_DeviceTimeUpdate& operator=(const mplay_fi_tcl_DeviceTimeUpdate& coRef);
   mplay_fi_tcl_DeviceTimeUpdate(const mplay_fi_tcl_DeviceTimeUpdate& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU64 u64SecondsSinceReferenceDate;
   tS16 s16TimeZoneOffsetMinutes;
   tS8 s8DaylightSavingsOffsetMinutes;
   virtual ~mplay_fi_tcl_DeviceTimeUpdate();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_DeviceTimeUpdate& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_CdType : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_CdType();
   enum tenType {
      FI_EN_MMGR_INIT = 0UL,
      FI_EN_MMGR_NO_MEDIA = 1UL,
      FI_EN_MMGR_INSERTION = 2UL,
      FI_EN_MMGR_INCORRECT = 3UL,
      FI_EN_MMGR_AUDIO = 4UL,
      FI_EN_MMGR_DATA = 5UL,
      FI_EN_MMGR_EJECTING = 17UL,
      FI_EN_MMGR_MEDIA_IN_SLOT = 18UL
   };
   tenType enType;

   mplay_fi_tcl_e8_CdType(mplay_fi_tcl_e8_CdType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_CdType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_CdType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MediaState : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MediaState();
   enum tenType {
      FI_EN_MMGR_MEDIA_NOT_READY = 1UL,
      FI_EN_MMGR_MEDIA_READY = 2UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MediaState(mplay_fi_tcl_e8_MediaState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MediaState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MediaState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_InsertState : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_InsertState();
   enum tenType {
      FI_EN_MMGR_INSERT_BEFOREON = 1UL,
      FI_EN_MMGR_INSERT_AFTERON = 2UL,
      FI_EN_MMGR_INSERT_AUTOMATIC = 3UL
   };
   tenType enType;

   mplay_fi_tcl_e8_InsertState(mplay_fi_tcl_e8_InsertState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_InsertState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_InsertState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_MMgr_MethodResult : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_MMgr_MethodResult();
   enum tenType {
      FI_EN_MMGR_ACCEPTED = 1UL,
      FI_EN_MMGR_NOTACCEPTED = 2UL,
      FI_EN_MMGR_DEVICENOTREADY = 3UL
   };
   tenType enType;

   mplay_fi_tcl_e8_MMgr_MethodResult(mplay_fi_tcl_e8_MMgr_MethodResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_MMgr_MethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_MMgr_MethodResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8DriveTempSensorStatus : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8DriveTempSensorStatus();
   enum tenType {
      FI_EN_INIT = 0UL,
      FI_EN_DRIVE_MOUNTED_OK = 1UL,
      FI_EN_DRIVE_MOUNTED_ERROR_READ_TEMP = 2UL,
      FI_EN_DRIVE_MOUNTED_NO_SENSOR = 3UL,
      FI_EN_DRIVE_NOT_MOUNTED = 4UL
   };
   tenType enType;

   mplay_fi_tcl_e8DriveTempSensorStatus(mplay_fi_tcl_e8DriveTempSensorStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8DriveTempSensorStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8DriveTempSensorStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e16_DiagDrv : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e16_DiagDrv();
   enum tenType {
      FI_EN_MMGR_CD = 1UL
   };
   tenType enType;

   mplay_fi_tcl_e16_DiagDrv(mplay_fi_tcl_e16_DiagDrv::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e16_DiagDrv();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e16_DiagDrv& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e16_DiagDrvTestCmd : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e16_DiagDrvTestCmd();
   enum tenType {
      FI_EN_MMGR_START = 1UL,
      FI_EN_MMGR_STOP = 2UL,
      FI_EN_MMGR_CANCEL = 3UL
   };
   tenType enType;

   mplay_fi_tcl_e16_DiagDrvTestCmd(mplay_fi_tcl_e16_DiagDrvTestCmd::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e16_DiagDrvTestCmd();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e16_DiagDrvTestCmd& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e16_DiagDrvTestParam : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e16_DiagDrvTestParam();
   enum tenType {
      FI_EN_MMGR_SHORT = 1UL,
      FI_EN_MMGR_INTENSIVE = 2UL,
      FI_EN_MMGR_SHORT_TEF_CD = 3UL
   };
   tenType enType;

   mplay_fi_tcl_e16_DiagDrvTestParam(mplay_fi_tcl_e16_DiagDrvTestParam::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e16_DiagDrvTestParam();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e16_DiagDrvTestParam& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e16_DiagResultEject : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e16_DiagResultEject();
   enum tenType {
      FI_EN_MMGR_EJECT_OK = 1UL,
      FI_EN_MMGR_EJECT_FAILED = 2UL
   };
   tenType enType;

   mplay_fi_tcl_e16_DiagResultEject(mplay_fi_tcl_e16_DiagResultEject::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e16_DiagResultEject();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e16_DiagResultEject& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DiagLoadStatus : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DiagLoadStatus();
   enum tenType {
      FI_EN_MMGR_MEDIA_IN_SLOT = 1UL,
      FI_EN_MMGR_NO_MEDIA_IN_DRIVE = 2UL,
      FI_EN_MMGR_MEDIA_INSIDE = 3UL,
      FI_EN_MMGR_EJECT_IN_PROGRESS = 5UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DiagLoadStatus(mplay_fi_tcl_e8_DiagLoadStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DiagLoadStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DiagLoadStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DiagDuration : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DiagDuration();
   enum tenType {
      FI_EN_MMGR_CONTINUOUS = 0UL,
      FI_EN_MMGR_SINGLE_RUN = 1UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DiagDuration(mplay_fi_tcl_e8_DiagDuration::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DiagDuration();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DiagDuration& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DiagRetValueDriveTest : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DiagRetValueDriveTest();
   enum tenType {
      FI_EN_MMGR_RESULT_FALSE = 0UL,
      FI_EN_MMGR_RESULT_OK = 1UL,
      FI_EN_MMGR_RESULT_NO_MEDIA = 2UL,
      FI_EN_MMGR_RESULT_INVALID_MEDIA = 3UL,
      FI_EN_MMGR_RESULT_CANCELED = 4UL,
      FI_EN_MMGR_RESULT_DEV_MMGR_BUSY = 6UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DiagRetValueDriveTest(mplay_fi_tcl_e8_DiagRetValueDriveTest::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DiagRetValueDriveTest();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DiagRetValueDriveTest& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e16_DiagTroubleCode : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e16_DiagTroubleCode();
   enum tenType {
      FI_EN_MMGR_TC_DEVICE_FAIL_CD = 256UL,
      FI_EN_MMGR_TC_CMD_TIMEOUT_CD = 257UL,
      FI_EN_MMGR_TC_COM_CD = 258UL,
      FI_EN_MMGR_TC_READ_ERR_CD = 259UL,
      FI_EN_MMGR_TC_READ_ERR_TEST_CD = 260UL,
      FI_EN_MMGR_TC_LOAD_EJECT_CD = 261UL,
      FI_EN_MMGR_TC_LOAD_INSERT_CD = 262UL,
      FI_EN_MMGR_TC_OVER_TEMPERATURE_CD = 263UL,
      FI_EN_MMGR_TC_TEMP_READ_CD = 264UL,
      FI_EN_MMGR_TC_DISCTOC_CD = 265UL
   };
   tenType enType;

   mplay_fi_tcl_e16_DiagTroubleCode(mplay_fi_tcl_e16_DiagTroubleCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e16_DiagTroubleCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e16_DiagTroubleCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DiagMonitoringMode : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DiagMonitoringMode();
   enum tenType {
      FI_EN_MMGR_OFF = 0UL,
      FI_EN_MMGR_CONTINUOUS = 1UL,
      FI_EN_MMGR_SINGLETEST = 2UL,
      FI_EN_MMGR_DEFAULTMODE = 3UL,
      FI_EN_MMGR_PREVIOUSMODE = 4UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DiagMonitoringMode(mplay_fi_tcl_e8_DiagMonitoringMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DiagMonitoringMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DiagMonitoringMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DiagSupervisionControl : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DiagSupervisionControl();
   enum tenType {
      FI_EN_MMGR_SUPERVISIONDEFAULT = 0UL,
      FI_EN_MMGR_SUPERVISIONOFF = 1UL,
      FI_EN_MMGR_SUPERVISIONON = 2UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DiagSupervisionControl(mplay_fi_tcl_e8_DiagSupervisionControl::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DiagSupervisionControl();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DiagSupervisionControl& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e16_DiagErrorStatus : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e16_DiagErrorStatus();
   enum tenType {
      FI_EN_MMGR_TESTPASSED = 0UL,
      FI_EN_MMGR_TESTFAILED = 1UL,
      FI_EN_MMGR_ROUTINENEVERRAN = 2UL
   };
   tenType enType;

   mplay_fi_tcl_e16_DiagErrorStatus(mplay_fi_tcl_e16_DiagErrorStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e16_DiagErrorStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e16_DiagErrorStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e16_DiagRoutineStatus : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e16_DiagRoutineStatus();
   enum tenType {
      FI_EN_MMGR_ROUTINENOTRUNNING = 0UL,
      FI_EN_MMGR_ROUTINERUNNING = 1UL,
      FI_EN_MMGR_ROUTINEFINISHED = 2UL
   };
   tenType enType;

   mplay_fi_tcl_e16_DiagRoutineStatus(mplay_fi_tcl_e16_DiagRoutineStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e16_DiagRoutineStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e16_DiagRoutineStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_TrackType : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_TrackType();
   enum tenType {
      FI_EN_INIT = 0UL,
      FI_EN_AUDIO = 1UL,
      FI_EN_DATA = 2UL,
      FI_EN_NONE = 3UL,
      FI_EN_INVALID = 4UL
   };
   tenType enType;

   mplay_fi_tcl_e8_TrackType(mplay_fi_tcl_e8_TrackType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_TrackType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_TrackType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_TrackTypeResult : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_TrackTypeResult();
   enum tenType {
      FI_EN_OK = 0UL,
      FI_EN_NOCD = 1UL,
      FI_EN_INCORRECTMEDIA = 2UL,
      FI_EN_FAILEDTOSELECT = 3UL,
      FI_EN_INVALIDREQUESTEDTRACKTYPE = 4UL,
      FI_EN_GENERALERROR = 5UL
   };
   tenType enType;

   mplay_fi_tcl_e8_TrackTypeResult(mplay_fi_tcl_e8_TrackTypeResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_TrackTypeResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_TrackTypeResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_DiagDrvTestParameter : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_DiagDrvTestParameter();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_DiagDrvTestParameter& operator=(const mplay_fi_tcl_DiagDrvTestParameter& coRef);
   mplay_fi_tcl_DiagDrvTestParameter(const mplay_fi_tcl_DiagDrvTestParameter& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e16_DiagDrv e16Drive;
   mplay_fi_tcl_e16_DiagDrvTestCmd e16DriveTestCmd;
   mplay_fi_tcl_e16_DiagDrvTestParam e16DriveTestParam;
   virtual ~mplay_fi_tcl_DiagDrvTestParameter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_DiagDrvTestParameter& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_DiagMethodResultDrvTest : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_DiagMethodResultDrvTest();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_DiagMethodResultDrvTest& operator=(const mplay_fi_tcl_DiagMethodResultDrvTest& coRef);
   mplay_fi_tcl_DiagMethodResultDrvTest(const mplay_fi_tcl_DiagMethodResultDrvTest& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_DiagRetValueDriveTest e8RetValueDriveTest;
   mplay_fi_tcl_e16_DiagDrvTestParam e16DiagDrvTesttype;
   mplay_fi_tcl_e16_DiagDrv e16Drive;
   tU32 u32SectorsRead;
   tU16 u16ReadAttemps;
   tU16 u16CntErrors;
   tU16 u16AverageReadtimeSector;
   tU32 u32TotalReadTime;
   tU16 u16MaxReadTimePerSector;
   tU32 u32MaxLBA;
   tU8 u8CntDVDLayer;
   virtual ~mplay_fi_tcl_DiagMethodResultDrvTest();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_DiagMethodResultDrvTest& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_DiagEjectParam : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_DiagEjectParam();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_DiagEjectParam& operator=(const mplay_fi_tcl_DiagEjectParam& coRef);
   mplay_fi_tcl_DiagEjectParam(const mplay_fi_tcl_DiagEjectParam& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e16_DiagDrv e16Drive;
   virtual ~mplay_fi_tcl_DiagEjectParam();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_DiagEjectParam& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_DiagMethodResultEject : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_DiagMethodResultEject();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_DiagMethodResultEject& operator=(const mplay_fi_tcl_DiagMethodResultEject& coRef);
   mplay_fi_tcl_DiagMethodResultEject(const mplay_fi_tcl_DiagMethodResultEject& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e16_DiagResultEject e16Result;
   virtual ~mplay_fi_tcl_DiagMethodResultEject();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_DiagMethodResultEject& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_DiagFirmwareVersion : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_DiagFirmwareVersion();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_DiagFirmwareVersion& operator=(const mplay_fi_tcl_DiagFirmwareVersion& coRef);
   mplay_fi_tcl_DiagFirmwareVersion(const mplay_fi_tcl_DiagFirmwareVersion& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8FirmwareVersion00;
   tU8 u8FirmwareVersion01;
   tU8 u8FirmwareVersion02;
   tU8 u8FirmwareVersion03;
   tU8 u8FirmwareVersion04;
   tU8 u8FirmwareVersion05;
   tU8 u8FirmwareVersion06;
   tU8 u8FirmwareVersion07;
   virtual ~mplay_fi_tcl_DiagFirmwareVersion();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_DiagFirmwareVersion& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_DiagDriveVersion : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_DiagDriveVersion();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_DiagDriveVersion& operator=(const mplay_fi_tcl_DiagDriveVersion& coRef);
   mplay_fi_tcl_DiagDriveVersion(const mplay_fi_tcl_DiagDriveVersion& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DriveVersion00;
   tU8 u8DriveVersion01;
   tU8 u8DriveVersion02;
   tU8 u8DriveVersion03;
   tU8 u8DriveVersion04;
   tU8 u8DriveVersion05;
   tU8 u8DriveVersion06;
   tU8 u8DriveVersion07;
   tU8 u8DriveVersion08;
   tU8 u8DriveVersion09;
   tU8 u8DriveVersion10;
   tU8 u8DriveVersion11;
   tU8 u8DriveVersion12;
   tU8 u8DriveVersion13;
   tU8 u8DriveVersion14;
   tU8 u8DriveVersion15;
   tU8 u8DriveVersion16;
   tU8 u8DriveVersion17;
   tU8 u8DriveVersion18;
   tU8 u8DriveVersion19;
   tU8 u8DriveVersion20;
   tU8 u8DriveVersion21;
   tU8 u8DriveVersion22;
   tU8 u8DriveVersion23;
   tU8 u8DriveVersion24;
   tU8 u8DriveVersion25;
   tU8 u8DriveVersion26;
   tU8 u8DriveVersion27;
   tU8 u8DriveVersion28;
   tU8 u8DriveVersion29;
   tU8 u8DriveVersion30;
   tU8 u8DriveVersion31;
   tU8 u8DriveVersion32;
   tU8 u8DriveVersion33;
   tU8 u8DriveVersion34;
   tU8 u8DriveVersion35;
   tU8 u8DriveVersion36;
   tU8 u8DriveVersion37;
   tU8 u8DriveVersion38;
   tU8 u8DriveVersion39;
   virtual ~mplay_fi_tcl_DiagDriveVersion();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_DiagDriveVersion& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_DiagTestRoutineParameter : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_DiagTestRoutineParameter();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_DiagTestRoutineParameter& operator=(const mplay_fi_tcl_DiagTestRoutineParameter& coRef);
   mplay_fi_tcl_DiagTestRoutineParameter(const mplay_fi_tcl_DiagTestRoutineParameter& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e16_DiagTroubleCode e16TroubleCode;
   tBool bWriteToRM;
   mplay_fi_tcl_e8_DiagMonitoringMode e8MonitoringMode;
   mplay_fi_tcl_e8_DiagSupervisionControl e8SupervisionControl;
   virtual ~mplay_fi_tcl_DiagTestRoutineParameter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_DiagTestRoutineParameter& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_DiagTestRoutineList : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_DiagTestRoutineList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_DiagTestRoutineList& operator=(const mplay_fi_tcl_DiagTestRoutineList& coRef);
   mplay_fi_tcl_DiagTestRoutineList(const mplay_fi_tcl_DiagTestRoutineList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mplay_fi_tcl_DiagTestRoutineParameter, std::allocator<mplay_fi_tcl_DiagTestRoutineParameter> > TestRoutineParameterList;
   virtual ~mplay_fi_tcl_DiagTestRoutineList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_DiagTestRoutineList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_DiagTroubleCodeList : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_DiagTroubleCodeList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_DiagTroubleCodeList& operator=(const mplay_fi_tcl_DiagTroubleCodeList& coRef);
   mplay_fi_tcl_DiagTroubleCodeList(const mplay_fi_tcl_DiagTroubleCodeList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mplay_fi_tcl_e16_DiagTroubleCode, std::allocator<mplay_fi_tcl_e16_DiagTroubleCode> > e16TroubleCodeList;
   virtual ~mplay_fi_tcl_DiagTroubleCodeList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_DiagTroubleCodeList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_DiagTroubleStatus : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_DiagTroubleStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_DiagTroubleStatus& operator=(const mplay_fi_tcl_DiagTroubleStatus& coRef);
   mplay_fi_tcl_DiagTroubleStatus(const mplay_fi_tcl_DiagTroubleStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e16_DiagTroubleCode e16TroubleCode;
   mplay_fi_tcl_e16_DiagErrorStatus e16ErrorStatus;
   mplay_fi_tcl_e16_DiagRoutineStatus e16RoutineStatus;
   virtual ~mplay_fi_tcl_DiagTroubleStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_DiagTroubleStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_DiagTroubleCodeStatusList : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_DiagTroubleCodeStatusList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_DiagTroubleCodeStatusList& operator=(const mplay_fi_tcl_DiagTroubleCodeStatusList& coRef);
   mplay_fi_tcl_DiagTroubleCodeStatusList(const mplay_fi_tcl_DiagTroubleCodeStatusList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mplay_fi_tcl_DiagTroubleStatus, std::allocator<mplay_fi_tcl_DiagTroubleStatus> > TroubleCodeStatusList;
   virtual ~mplay_fi_tcl_DiagTroubleCodeStatusList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_DiagTroubleCodeStatusList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e8_DiagnosisTestType : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e8_DiagnosisTestType();
   enum tenType {
      FI_EN_MMGR_CUSTOMER_DIAGNOSIS = 0UL,
      FI_EN_MMGR_TEF_DIAGNOSIS = 1UL,
      FI_EN_MMGR_TEST_TYPE_OTHER = 2UL
   };
   tenType enType;

   mplay_fi_tcl_e8_DiagnosisTestType(mplay_fi_tcl_e8_DiagnosisTestType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e8_DiagnosisTestType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e8_DiagnosisTestType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e16_DiagTestType : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e16_DiagTestType();
   enum tenType {
      FI_EN_MMGR_DIAGNOSIS_ON_DEMAND = 0UL,
      FI_EN_MMGR_DIAGNOSIS_CONTINUOUS = 1UL,
      FI_EN_MMGR_DIAGNOSIS_OTHER = 2UL
   };
   tenType enType;

   mplay_fi_tcl_e16_DiagTestType(mplay_fi_tcl_e16_DiagTestType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e16_DiagTestType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e16_DiagTestType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_DiagReadDevInterfaceTestParam : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_DiagReadDevInterfaceTestParam();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_DiagReadDevInterfaceTestParam& operator=(const mplay_fi_tcl_DiagReadDevInterfaceTestParam& coRef);
   mplay_fi_tcl_DiagReadDevInterfaceTestParam(const mplay_fi_tcl_DiagReadDevInterfaceTestParam& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e16_DiagDrv e16Drive;
   mplay_fi_tcl_e8_DiagnosisTestType DiagnosisTestInitiator;
   mplay_fi_tcl_e16_DiagTestType TestType;
   virtual ~mplay_fi_tcl_DiagReadDevInterfaceTestParam();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_DiagReadDevInterfaceTestParam& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_DiagTestResult : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_DiagTestResult();
   enum tenType {
      FI_EN_TEST_PASSED = 1UL,
      FI_EN_TEST_FAILED = 2UL
   };
   tenType enType;

   mplay_fi_tcl_DiagTestResult(mplay_fi_tcl_DiagTestResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_DiagTestResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_DiagTestResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_e16_DriveErrorValue : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_e16_DriveErrorValue();
   enum tenType {
      FI_EN_DEFECT_NO_ERROR = 0UL,
      FI_EN_DEFECT_LOAD_EJECT = 1UL,
      FI_EN_DEFECT_LOAD_INSERT = 2UL,
      FI_EN_DEFECT_DISCTOC = 4UL,
      FI_EN_DEFECT_INCORRECT_MEDIA = 8UL,
      FI_EN_DEFECT_COM = 16UL,
      FI_EN_DEFECT_COM_OK = 512UL,
      FI_EN_DEFECT_CMD_TIMEOUT = 128UL,
      FI_EN_DEFECT_CMD_TIMEOUT_OK = 256UL,
      FI_EN_DEFECT_READ_ERR = 1024UL,
      FI_EN_DEFECT_READ_OK = 2048UL,
      FI_EN_DEFECT_TEMP_READ = 4096UL,
      FI_EN_DEFECT_ABNORMAL_WRITE_TERMINATION = 8192UL,
      FI_EN_DEFECT_DRIVE_TEMP_ERR = 16384UL,
      FI_EN_DEFECT_DRIVE_TEMP_OK = 32768UL
   };
   tenType enType;

   mplay_fi_tcl_e16_DriveErrorValue(mplay_fi_tcl_e16_DriveErrorValue::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mplay_fi_tcl_e16_DriveErrorValue();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mplay_fi_tcl_e16_DriveErrorValue& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

class mplay_fi_tcl_DriveErrorInfo : public mplay_fi_tclVisitableTypeBase
{
public:

   mplay_fi_tcl_DriveErrorInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_fi_tcl_DriveErrorInfo& operator=(const mplay_fi_tcl_DriveErrorInfo& coRef);
   mplay_fi_tcl_DriveErrorInfo(const mplay_fi_tcl_DriveErrorInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e16_DiagDrv e16Drive;
   mplay_fi_tcl_e16_DriveErrorValue e16ErrorValue;
   virtual ~mplay_fi_tcl_DriveErrorInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_fi_tcl_DriveErrorInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mplay_fi_tclVisitorBase& rfoVisitor);
};

#endif
