/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MPLAY_MMGRFITYPES_HEADER
#define MPLAY_MMGRFITYPES_HEADER


class mplay_mmgrfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for MPLAY_MMGR_FI message types

fi_tclMessageBase* mplay_mmgrfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class mplay_mmgrfi_tclMsgBaseMessage : public mplay_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   mplay_mmgrfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class mplay_mmgrfi_tclMsgCDEjectMethodStart : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgCDEjectMethodStart();

   virtual ~mplay_mmgrfi_tclMsgCDEjectMethodStart();

   inline tBool operator==(const mplay_mmgrfi_tclMsgCDEjectMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgCDEjectMethodResult : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgCDEjectMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mmgrfi_tclMsgCDEjectMethodResult& operator=(const mplay_mmgrfi_tclMsgCDEjectMethodResult& coRef);
   mplay_mmgrfi_tclMsgCDEjectMethodResult(const mplay_mmgrfi_tclMsgCDEjectMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MMgr_MethodResult ServiceStatus;
   virtual ~mplay_mmgrfi_tclMsgCDEjectMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mmgrfi_tclMsgCDEjectMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgCDInsertMethodStart : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgCDInsertMethodStart();

   virtual ~mplay_mmgrfi_tclMsgCDInsertMethodStart();

   inline tBool operator==(const mplay_mmgrfi_tclMsgCDInsertMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgCDInsertMethodResult : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgCDInsertMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mmgrfi_tclMsgCDInsertMethodResult& operator=(const mplay_mmgrfi_tclMsgCDInsertMethodResult& coRef);
   mplay_mmgrfi_tclMsgCDInsertMethodResult(const mplay_mmgrfi_tclMsgCDInsertMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MMgr_MethodResult ServiceStatus;
   virtual ~mplay_mmgrfi_tclMsgCDInsertMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mmgrfi_tclMsgCDInsertMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgDiagControlDriveTestMethodStart : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgDiagControlDriveTestMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mmgrfi_tclMsgDiagControlDriveTestMethodStart& operator=(const mplay_mmgrfi_tclMsgDiagControlDriveTestMethodStart& coRef);
   mplay_mmgrfi_tclMsgDiagControlDriveTestMethodStart(const mplay_mmgrfi_tclMsgDiagControlDriveTestMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_DiagDuration e8Duration;
   mplay_fi_tcl_DiagDrvTestParameter StartDriveTestParam;
   virtual ~mplay_mmgrfi_tclMsgDiagControlDriveTestMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mmgrfi_tclMsgDiagControlDriveTestMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResultFirst : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResultFirst();

   virtual ~mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResultFirst();

   inline tBool operator==(const mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResultFirst& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResult : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResult& operator=(const mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResult& coRef);
   mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResult(const mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_DiagDuration e8Duration;
   mplay_fi_tcl_DiagMethodResultDrvTest ResultDriveTest;
   virtual ~mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgDiagControlEjectMethodStart : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgDiagControlEjectMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mmgrfi_tclMsgDiagControlEjectMethodStart& operator=(const mplay_mmgrfi_tclMsgDiagControlEjectMethodStart& coRef);
   mplay_mmgrfi_tclMsgDiagControlEjectMethodStart(const mplay_mmgrfi_tclMsgDiagControlEjectMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_DiagDuration e8Duration;
   mplay_fi_tcl_DiagEjectParam StartEjectParam;
   virtual ~mplay_mmgrfi_tclMsgDiagControlEjectMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mmgrfi_tclMsgDiagControlEjectMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgDiagControlEjectMethodResult : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgDiagControlEjectMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mmgrfi_tclMsgDiagControlEjectMethodResult& operator=(const mplay_mmgrfi_tclMsgDiagControlEjectMethodResult& coRef);
   mplay_mmgrfi_tclMsgDiagControlEjectMethodResult(const mplay_mmgrfi_tclMsgDiagControlEjectMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_DiagDuration e8Duration;
   mplay_fi_tcl_DiagMethodResultEject ResultEject;
   virtual ~mplay_mmgrfi_tclMsgDiagControlEjectMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mmgrfi_tclMsgDiagControlEjectMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgDiagPerformTestMethodStart : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgDiagPerformTestMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mmgrfi_tclMsgDiagPerformTestMethodStart& operator=(const mplay_mmgrfi_tclMsgDiagPerformTestMethodStart& coRef);
   mplay_mmgrfi_tclMsgDiagPerformTestMethodStart(const mplay_mmgrfi_tclMsgDiagPerformTestMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_DiagTestRoutineList TestRoutineParameterList;
   virtual ~mplay_mmgrfi_tclMsgDiagPerformTestMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mmgrfi_tclMsgDiagPerformTestMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgDiagPerformTestMethodResult : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgDiagPerformTestMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mmgrfi_tclMsgDiagPerformTestMethodResult& operator=(const mplay_mmgrfi_tclMsgDiagPerformTestMethodResult& coRef);
   mplay_mmgrfi_tclMsgDiagPerformTestMethodResult(const mplay_mmgrfi_tclMsgDiagPerformTestMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_DiagTestRoutineList TestRoutineParameterList;
   virtual ~mplay_mmgrfi_tclMsgDiagPerformTestMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mmgrfi_tclMsgDiagPerformTestMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodStart : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodStart& operator=(const mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodStart& coRef);
   mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodStart(const mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_TrackType TrackType;
   virtual ~mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodResult : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodResult& operator=(const mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodResult& coRef);
   mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodResult(const mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_TrackType ActTrackType;
   mplay_fi_tcl_e8_TrackType ReqTrackType;
   mplay_fi_tcl_e8_TrackTypeResult Result;
   virtual ~mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgCDInfoUpReg : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgCDInfoUpReg();

   virtual ~mplay_mmgrfi_tclMsgCDInfoUpReg();

   inline tBool operator==(const mplay_mmgrfi_tclMsgCDInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgCDInfoRelUpReg : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgCDInfoRelUpReg();

   virtual ~mplay_mmgrfi_tclMsgCDInfoRelUpReg();

   inline tBool operator==(const mplay_mmgrfi_tclMsgCDInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgCDInfoGet : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgCDInfoGet();

   virtual ~mplay_mmgrfi_tclMsgCDInfoGet();

   inline tBool operator==(const mplay_mmgrfi_tclMsgCDInfoGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgCDInfoStatus : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgCDInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mmgrfi_tclMsgCDInfoStatus& operator=(const mplay_mmgrfi_tclMsgCDInfoStatus& coRef);
   mplay_mmgrfi_tclMsgCDInfoStatus(const mplay_mmgrfi_tclMsgCDInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_CdType CDType;
   mplay_fi_tcl_e8_MediaState MediaState;
   mplay_fi_tcl_e8_InsertState InsertState;
   mplay_fi_tcl_e8DeviceState e8DeviceState;
   mplay_fi_tclString szcUniqueID;
   mplay_fi_tclString DriveVersion;
   virtual ~mplay_mmgrfi_tclMsgCDInfoStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mmgrfi_tclMsgCDInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgCDTempUpReg : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgCDTempUpReg();

   virtual ~mplay_mmgrfi_tclMsgCDTempUpReg();

   inline tBool operator==(const mplay_mmgrfi_tclMsgCDTempUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgCDTempRelUpReg : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgCDTempRelUpReg();

   virtual ~mplay_mmgrfi_tclMsgCDTempRelUpReg();

   inline tBool operator==(const mplay_mmgrfi_tclMsgCDTempRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgCDTempGet : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgCDTempGet();

   virtual ~mplay_mmgrfi_tclMsgCDTempGet();

   inline tBool operator==(const mplay_mmgrfi_tclMsgCDTempGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgCDTempStatus : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgCDTempStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mmgrfi_tclMsgCDTempStatus& operator=(const mplay_mmgrfi_tclMsgCDTempStatus& coRef);
   mplay_mmgrfi_tclMsgCDTempStatus(const mplay_mmgrfi_tclMsgCDTempStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 CDTemp;
   mplay_fi_tcl_e8DriveTempSensorStatus Status;
   virtual ~mplay_mmgrfi_tclMsgCDTempStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mmgrfi_tclMsgCDTempStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgDriveErrorInformationUpReg : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgDriveErrorInformationUpReg();

   virtual ~mplay_mmgrfi_tclMsgDriveErrorInformationUpReg();

   inline tBool operator==(const mplay_mmgrfi_tclMsgDriveErrorInformationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgDriveErrorInformationRelUpReg : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgDriveErrorInformationRelUpReg();

   virtual ~mplay_mmgrfi_tclMsgDriveErrorInformationRelUpReg();

   inline tBool operator==(const mplay_mmgrfi_tclMsgDriveErrorInformationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgDriveErrorInformationGet : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgDriveErrorInformationGet();

   virtual ~mplay_mmgrfi_tclMsgDriveErrorInformationGet();

   inline tBool operator==(const mplay_mmgrfi_tclMsgDriveErrorInformationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgDriveErrorInformationStatus : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgDriveErrorInformationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mmgrfi_tclMsgDriveErrorInformationStatus& operator=(const mplay_mmgrfi_tclMsgDriveErrorInformationStatus& coRef);
   mplay_mmgrfi_tclMsgDriveErrorInformationStatus(const mplay_mmgrfi_tclMsgDriveErrorInformationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_DriveErrorInfo DriveErrorInfo;
   virtual ~mplay_mmgrfi_tclMsgDriveErrorInformationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mmgrfi_tclMsgDriveErrorInformationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgDiagFirmwareVersionGet : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgDiagFirmwareVersionGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mmgrfi_tclMsgDiagFirmwareVersionGet& operator=(const mplay_mmgrfi_tclMsgDiagFirmwareVersionGet& coRef);
   mplay_mmgrfi_tclMsgDiagFirmwareVersionGet(const mplay_mmgrfi_tclMsgDiagFirmwareVersionGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e16_DiagDrv Drive;
   virtual ~mplay_mmgrfi_tclMsgDiagFirmwareVersionGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mmgrfi_tclMsgDiagFirmwareVersionGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgDiagFirmwareVersionStatus : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgDiagFirmwareVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mmgrfi_tclMsgDiagFirmwareVersionStatus& operator=(const mplay_mmgrfi_tclMsgDiagFirmwareVersionStatus& coRef);
   mplay_mmgrfi_tclMsgDiagFirmwareVersionStatus(const mplay_mmgrfi_tclMsgDiagFirmwareVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_DiagFirmwareVersion FirmwareVersion;
   virtual ~mplay_mmgrfi_tclMsgDiagFirmwareVersionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mmgrfi_tclMsgDiagFirmwareVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgDiagDriveVersionGet : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgDiagDriveVersionGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mmgrfi_tclMsgDiagDriveVersionGet& operator=(const mplay_mmgrfi_tclMsgDiagDriveVersionGet& coRef);
   mplay_mmgrfi_tclMsgDiagDriveVersionGet(const mplay_mmgrfi_tclMsgDiagDriveVersionGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e16_DiagDrv Drive;
   virtual ~mplay_mmgrfi_tclMsgDiagDriveVersionGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mmgrfi_tclMsgDiagDriveVersionGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgDiagDriveVersionStatus : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgDiagDriveVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mmgrfi_tclMsgDiagDriveVersionStatus& operator=(const mplay_mmgrfi_tclMsgDiagDriveVersionStatus& coRef);
   mplay_mmgrfi_tclMsgDiagDriveVersionStatus(const mplay_mmgrfi_tclMsgDiagDriveVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_DiagDriveVersion DriveVersion;
   virtual ~mplay_mmgrfi_tclMsgDiagDriveVersionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mmgrfi_tclMsgDiagDriveVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgDiagLoadStatusGet : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgDiagLoadStatusGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mmgrfi_tclMsgDiagLoadStatusGet& operator=(const mplay_mmgrfi_tclMsgDiagLoadStatusGet& coRef);
   mplay_mmgrfi_tclMsgDiagLoadStatusGet(const mplay_mmgrfi_tclMsgDiagLoadStatusGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e16_DiagDrv Drive;
   virtual ~mplay_mmgrfi_tclMsgDiagLoadStatusGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mmgrfi_tclMsgDiagLoadStatusGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgDiagLoadStatusStatus : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgDiagLoadStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mmgrfi_tclMsgDiagLoadStatusStatus& operator=(const mplay_mmgrfi_tclMsgDiagLoadStatusStatus& coRef);
   mplay_mmgrfi_tclMsgDiagLoadStatusStatus(const mplay_mmgrfi_tclMsgDiagLoadStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_DiagLoadStatus LoadStatus;
   virtual ~mplay_mmgrfi_tclMsgDiagLoadStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mmgrfi_tclMsgDiagLoadStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgDiagErrorStatusUpReg : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgDiagErrorStatusUpReg();

   virtual ~mplay_mmgrfi_tclMsgDiagErrorStatusUpReg();

   inline tBool operator==(const mplay_mmgrfi_tclMsgDiagErrorStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgDiagErrorStatusRelUpReg : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgDiagErrorStatusRelUpReg();

   virtual ~mplay_mmgrfi_tclMsgDiagErrorStatusRelUpReg();

   inline tBool operator==(const mplay_mmgrfi_tclMsgDiagErrorStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgDiagErrorStatusGet : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgDiagErrorStatusGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mmgrfi_tclMsgDiagErrorStatusGet& operator=(const mplay_mmgrfi_tclMsgDiagErrorStatusGet& coRef);
   mplay_mmgrfi_tclMsgDiagErrorStatusGet(const mplay_mmgrfi_tclMsgDiagErrorStatusGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_DiagTroubleCodeList TroubleCodeList;
   virtual ~mplay_mmgrfi_tclMsgDiagErrorStatusGet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mmgrfi_tclMsgDiagErrorStatusGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgDiagErrorStatusStatus : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgDiagErrorStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mmgrfi_tclMsgDiagErrorStatusStatus& operator=(const mplay_mmgrfi_tclMsgDiagErrorStatusStatus& coRef);
   mplay_mmgrfi_tclMsgDiagErrorStatusStatus(const mplay_mmgrfi_tclMsgDiagErrorStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_DiagTroubleCodeStatusList TroubleCodeStatusList;
   virtual ~mplay_mmgrfi_tclMsgDiagErrorStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mmgrfi_tclMsgDiagErrorStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestGet : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestGet& operator=(const mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestGet& coRef);
   mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestGet(const mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_DiagReadDevInterfaceTestParam DiagnosisTestParam;
   virtual ~mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestStatus : public mplay_mmgrfi_tclMsgBaseMessage
{
public:

   mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestStatus& operator=(const mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestStatus& coRef);
   mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestStatus(const mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_DiagnosisTestType DiagnosisTestType;
   mplay_fi_tcl_DiagTestResult DiagTestResult;
   virtual ~mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
