/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MPLAY_MEDIAPLAYERFITYPES_HEADER
#define MPLAY_MEDIAPLAYERFITYPES_HEADER


class mplay_mediaplayerfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for mplay_MediaPlayer_FI message types

fi_tclMessageBase* mplay_mediaplayerfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class mplay_mediaplayerfi_tclMsgBaseMessage : public mplay_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   mplay_mediaplayerfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart& operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayListType e8ListType;
   tU32 u32FilterTag1;
   tU32 u32FilterTag2;
   tU32 u32FilterTag3;
   tU32 u32FilterTag4;
   tBool bAutoPlay;
   tU8 u8DeviceTag;
   virtual ~mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult& operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32ListSize;
   tU8 u8DeviceTag;
   virtual ~mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodStart& operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodStart(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayListType e8ListType;
   tU32 u32FilterTag1;
   tU32 u32FilterTag2;
   tU32 u32FilterTag3;
   tU8 u8DeviceTag;
   tU8 u8UserID;
   virtual ~mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodResult& operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodResult(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32ListSize;
   tU8 u8DeviceTag;
   virtual ~mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart& operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32WindowStart;
   tU16 u16WindowSize;
   tU8 DeviceTag;
   virtual ~mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult& operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_MPlayMediaObjects oMediaObjects;
   virtual ~mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodStart& operator=(const mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodStart(const mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   virtual ~mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodResult();

   virtual ~mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodResult();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodStart& operator=(const mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodStart(const mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayAction e8Action;
   tU8 u8NextPrevSkipCount;
   virtual ~mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodResult();

   virtual ~mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodResult();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgSeekToMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgSeekToMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgSeekToMethodStart& operator=(const mplay_mediaplayerfi_tclMsgSeekToMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgSeekToMethodStart(const mplay_mediaplayerfi_tclMsgSeekToMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32PlaypointPosition;
   mplay_fi_tcl_e8_MPlayPlaypointFormat e8PlaypointFormat;
   virtual ~mplay_mediaplayerfi_tclMsgSeekToMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgSeekToMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgSeekToMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgSeekToMethodResult();

   virtual ~mplay_mediaplayerfi_tclMsgSeekToMethodResult();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgSeekToMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodStart& operator=(const mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodStart(const mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sAlbumArt;
   tU32 u32SizeX;
   tU32 u32SizeY;
   virtual ~mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodResult& operator=(const mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodResult(const mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_MPlayImageData oImageData;
   virtual ~mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodStart& operator=(const mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodStart(const mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   virtual ~mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodResult& operator=(const mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodResult(const mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   mplay_fi_tcl_MPlaySearchKeyboardList oSearchKeyboardList;
   virtual ~mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodStart& operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodStart(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandleOfParent;
   tU32 u32ListHandleOfReplaceableList;
   mplay_fi_tclString sSearchString;
   virtual ~mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultFirst : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultFirst();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultFirst& operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultFirst& coRef);
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultFirst(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultFirst& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32ListSize;
   tU8 u8DeviceTag;
   virtual ~mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultFirst();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultFirst& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultMiddle : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultMiddle();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultMiddle& operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultMiddle& coRef);
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultMiddle(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultMiddle& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32ListSize;
   tU8 u8DeviceTag;
   virtual ~mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultMiddle();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultMiddle& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultLast : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultLast();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultLast& operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultLast& coRef);
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultLast(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultLast& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32ListSize;
   tU8 u8DeviceTag;
   virtual ~mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultLast();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultLast& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodAbort : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodAbort();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodAbort& operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodAbort& coRef);
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodAbort(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodAbort& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32ListSize;
   tU8 u8DeviceTag;
   virtual ~mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodAbort();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodAbort& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgGetMediaObjectMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgGetMediaObjectMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgGetMediaObjectMethodStart& operator=(const mplay_mediaplayerfi_tclMsgGetMediaObjectMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgGetMediaObjectMethodStart(const mplay_mediaplayerfi_tclMsgGetMediaObjectMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32Tag;
   mplay_fi_tcl_e8_MPlayCategoryType e8CategoryType;
   virtual ~mplay_mediaplayerfi_tclMsgGetMediaObjectMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgGetMediaObjectMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgGetMediaObjectMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgGetMediaObjectMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgGetMediaObjectMethodResult& operator=(const mplay_mediaplayerfi_tclMsgGetMediaObjectMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgGetMediaObjectMethodResult(const mplay_mediaplayerfi_tclMsgGetMediaObjectMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_MPlayMediaObject oMediaObject;
   virtual ~mplay_mediaplayerfi_tclMsgGetMediaObjectMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgGetMediaObjectMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodStart& operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodStart(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sPath;
   tU8 u8DeviceTag;
   mplay_fi_tcl_e8_MPlayFileTypeSelection e8MPlayFileTypeSelection;
   tU64 Tag;
   virtual ~mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodResult& operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodResult(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32ListSize;
   tU8 u8DeviceTag;
   tU32 u32TotalNumFiles;
   tU32 u32TotalNumFolders;
   tU32 u32TotalNumMediaObjects;
   tU32 u32TotalNumPlaylists;
   virtual ~mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodStart& operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodStart(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32WindowStart;
   tU16 u16WindowSize;
   tU8 DeviceTag;
   virtual ~mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodResult& operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodResult(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_MPlayFileList oFileList;
   virtual ~mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodStart& operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodStart(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sFilename;
   tU64 Tag;
   tU8 DeviceTag;
   virtual ~mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodResult& operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodResult(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32ListSize;
   virtual ~mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart& operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32WindowStart;
   tU16 u16WindowSize;
   tU8 DeviceTag;
   virtual ~mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult& operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_MPlayFileList oFileList;
   virtual ~mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart& operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32WindowStart;
   tU16 u16WindowSize;
   tU8 DeviceTag;
   virtual ~mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult& operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_MPlayMediaObjects oMediaObjects;
   virtual ~mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart& operator=(const mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart(const mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sAlbumArt;
   tU32 u32SizeX;
   tU32 u32SizeY;
   virtual ~mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult& operator=(const mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult(const mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sMIMEImageSubtype;
   tU32 u32PhotoSize;
   virtual ~mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodStart& operator=(const mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodStart(const mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32Tag;
   tBool bAutoPlay;
   virtual ~mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodResult& operator=(const mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodResult(const mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32ListSize;
   virtual ~mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlayItemFromListMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlayItemFromListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgPlayItemFromListMethodStart& operator=(const mplay_mediaplayerfi_tclMsgPlayItemFromListMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgPlayItemFromListMethodStart(const mplay_mediaplayerfi_tclMsgPlayItemFromListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32StartIndex;
   tU32 u32StartOffset;
   virtual ~mplay_mediaplayerfi_tclMsgPlayItemFromListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgPlayItemFromListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlayItemFromListMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlayItemFromListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgPlayItemFromListMethodResult& operator=(const mplay_mediaplayerfi_tclMsgPlayItemFromListMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgPlayItemFromListMethodResult(const mplay_mediaplayerfi_tclMsgPlayItemFromListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32ListSize;
   virtual ~mplay_mediaplayerfi_tclMsgPlayItemFromListMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgPlayItemFromListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgClearMediaPlayerDataMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgClearMediaPlayerDataMethodStart();

   virtual ~mplay_mediaplayerfi_tclMsgClearMediaPlayerDataMethodStart();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgClearMediaPlayerDataMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgClearMediaPlayerDataMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgClearMediaPlayerDataMethodResult();

   virtual ~mplay_mediaplayerfi_tclMsgClearMediaPlayerDataMethodResult();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgClearMediaPlayerDataMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgUmountMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgUmountMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgUmountMethodStart& operator=(const mplay_mediaplayerfi_tclMsgUmountMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgUmountMethodStart(const mplay_mediaplayerfi_tclMsgUmountMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceTag;
   virtual ~mplay_mediaplayerfi_tclMsgUmountMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgUmountMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgUmountMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgUmountMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgUmountMethodResult& operator=(const mplay_mediaplayerfi_tclMsgUmountMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgUmountMethodResult(const mplay_mediaplayerfi_tclMsgUmountMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceTag;
   mplay_fi_tcl_e8_MPlayUmountResult e8UmountResult;
   virtual ~mplay_mediaplayerfi_tclMsgUmountMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgUmountMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgReindexingMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgReindexingMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgReindexingMethodStart& operator=(const mplay_mediaplayerfi_tclMsgReindexingMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgReindexingMethodStart(const mplay_mediaplayerfi_tclMsgReindexingMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceTag;
   virtual ~mplay_mediaplayerfi_tclMsgReindexingMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgReindexingMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgReindexingMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgReindexingMethodResult();

   virtual ~mplay_mediaplayerfi_tclMsgReindexingMethodResult();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgReindexingMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodStart& operator=(const mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodStart(const mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayDeviceType e8DeviceType;
   mplay_fi_tclString sFilename;
   virtual ~mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodResult();

   virtual ~mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodResult();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestListDetailsMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestListDetailsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestListDetailsMethodStart& operator=(const mplay_mediaplayerfi_tclMsgRequestListDetailsMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgRequestListDetailsMethodStart(const mplay_mediaplayerfi_tclMsgRequestListDetailsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   virtual ~mplay_mediaplayerfi_tclMsgRequestListDetailsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestListDetailsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestListDetailsMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestListDetailsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestListDetailsMethodResult& operator=(const mplay_mediaplayerfi_tclMsgRequestListDetailsMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgRequestListDetailsMethodResult(const mplay_mediaplayerfi_tclMsgRequestListDetailsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayListType e8ListType;
   tU32 u32ParentListHandle;
   tU8 u8DeviceTag;
   tU32 u32Position;
   virtual ~mplay_mediaplayerfi_tclMsgRequestListDetailsMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestListDetailsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestListInformationMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestListInformationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestListInformationMethodStart& operator=(const mplay_mediaplayerfi_tclMsgRequestListInformationMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgRequestListInformationMethodStart(const mplay_mediaplayerfi_tclMsgRequestListInformationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   virtual ~mplay_mediaplayerfi_tclMsgRequestListInformationMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestListInformationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestListInformationMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestListInformationMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestListInformationMethodResult& operator=(const mplay_mediaplayerfi_tclMsgRequestListInformationMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgRequestListInformationMethodResult(const mplay_mediaplayerfi_tclMsgRequestListInformationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayListType e8ListType;
   tU32 u32ParentListHandle;
   tU8 u8DeviceTag;
   tU32 u32Position;
   tU32 u32ListSize;
   mplay_fi_tclString sPath;
   virtual ~mplay_mediaplayerfi_tclMsgRequestListInformationMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestListInformationMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodStart& operator=(const mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodStart(const mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceTag;
   mplay_fi_tcl_MPlayTagTransfer_2 oTagTransfer;
   virtual ~mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodResult& operator=(const mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodResult(const mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceTag;
   mplay_fi_tcl_e8_MPlayTagTransferStatus e8TagTransferStatus;
   mplay_fi_tcl_MPlayUntransferredTagStream oUntransferredTagStream;
   virtual ~mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodStart& operator=(const mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodStart(const mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32Tag;
   virtual ~mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodResult();

   virtual ~mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodResult();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodStart& operator=(const mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodStart(const mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlaybackDirection e8PlaybackDirection;
   mplay_fi_tcl_e8_MPlaybackSpeed e8PlaybackSpeed;
   virtual ~mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodResult& operator=(const mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodResult(const mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlaybackDirection e8PlaybackDirection;
   mplay_fi_tcl_e8_MPlaybackSpeed e8PlaybackSpeed;
   virtual ~mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgClearLastModePauseMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgClearLastModePauseMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgClearLastModePauseMethodStart& operator=(const mplay_mediaplayerfi_tclMsgClearLastModePauseMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgClearLastModePauseMethodStart(const mplay_mediaplayerfi_tclMsgClearLastModePauseMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceTag;
   virtual ~mplay_mediaplayerfi_tclMsgClearLastModePauseMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgClearLastModePauseMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgClearLastModePauseMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgClearLastModePauseMethodResult();

   virtual ~mplay_mediaplayerfi_tclMsgClearLastModePauseMethodResult();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgClearLastModePauseMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodStart& operator=(const mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodStart(const mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MDiscOperation e8DiscOperation;
   virtual ~mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodResult();

   virtual ~mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodResult();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodStart& operator=(const mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodStart(const mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MGeneralSelectionType e8SelectionType;
   mplay_fi_tcl_e8_MVCDAudioMode e8AudioMode;
   virtual ~mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodResult();

   virtual ~mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodResult();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodStart& operator=(const mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodStart(const mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MGeneralSelectionType e8SelectionType;
   mplay_fi_tcl_e8_MAudioOutputNumber e8AudioNumber;
   virtual ~mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodResult();

   virtual ~mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodResult();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodStart& operator=(const mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodStart(const mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MNavigationKey e8Action;
   virtual ~mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodResult();

   virtual ~mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodResult();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgSendTouchCommandMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgSendTouchCommandMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgSendTouchCommandMethodStart& operator=(const mplay_mediaplayerfi_tclMsgSendTouchCommandMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgSendTouchCommandMethodStart(const mplay_mediaplayerfi_tclMsgSendTouchCommandMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MTouchAction e8TouchAction;
   tU16 u16Xcoordinate;
   tU16 u16Ycoordinate;
   tU16 u16MaxXcoordinate;
   tU16 u16MaxYcoordinate;
   virtual ~mplay_mediaplayerfi_tclMsgSendTouchCommandMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgSendTouchCommandMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgSendTouchCommandMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgSendTouchCommandMethodResult();

   virtual ~mplay_mediaplayerfi_tclMsgSendTouchCommandMethodResult();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgSendTouchCommandMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodStart& operator=(const mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodStart(const mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 TitleNumber;
   tU32 ChapterNumber;
   virtual ~mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodResult();

   virtual ~mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodResult();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodStart& operator=(const mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodStart(const mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MGeneralSelectionType e8SelectionType;
   mplay_fi_tcl_e8_MAngle e8Angle;
   virtual ~mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodResult();

   virtual ~mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodResult();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodStart& operator=(const mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodStart(const mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MMenuControlData e8MenuControlData;
   virtual ~mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodResult();

   virtual ~mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodResult();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodStart& operator=(const mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodStart(const mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32Number;
   virtual ~mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodResult();

   virtual ~mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodResult();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodStart& operator=(const mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodStart(const mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32SearchNumber;
   virtual ~mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodResult();

   virtual ~mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodResult();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodStart& operator=(const mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodStart(const mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool subtitleSwitchState;
   mplay_fi_tcl_e8_MSubtitleSelectionType e8SelectionType;
   tU8 u8SubtitleSelection;
   virtual ~mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodResult();

   virtual ~mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodResult();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestCMSkipMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestCMSkipMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestCMSkipMethodStart& operator=(const mplay_mediaplayerfi_tclMsgRequestCMSkipMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgRequestCMSkipMethodStart(const mplay_mediaplayerfi_tclMsgRequestCMSkipMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MCMSkipValue e8CMSkipValue;
   virtual ~mplay_mediaplayerfi_tclMsgRequestCMSkipMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestCMSkipMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestCMSkipMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestCMSkipMethodResult();

   virtual ~mplay_mediaplayerfi_tclMsgRequestCMSkipMethodResult();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgRequestCMSkipMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodResult& operator=(const mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodResult(const mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16Temperature;
   virtual ~mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodStart();

   virtual ~mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodStart();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodStart& operator=(const mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodStart(const mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sPlaylistPath;
   tU32 u32OldPosition;
   tU32 u32NewPosition;
   tU8 u8DeviceTag;
   virtual ~mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodResult& operator=(const mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodResult(const mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult Status;
   virtual ~mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodStart& operator=(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodStart(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayListType e8ListType;
   tU32 u32FilterTag1;
   tU32 u32FilterTag2;
   tU32 u32FilterTag3;
   tU8 u8DeviceTag;
   virtual ~mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodResult& operator=(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodResult(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32NumberOfFiles;
   mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult u32Status;
   virtual ~mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodStart& operator=(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodStart(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_MPlayMediaObjectTag oMediaObjectTags;
   tU8 u8DeviceTag;
   virtual ~mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodResult& operator=(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodResult(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32NumberOfFiles;
   mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult u32Status;
   virtual ~mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodStart& operator=(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodStart(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_MPlayMediaObjectUrl oMPlayMediaObjectUrls;
   tU8 u8DeviceTag;
   virtual ~mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodResult& operator=(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodResult(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32NumberOfFiles;
   mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult u32Status;
   virtual ~mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodStart& operator=(const mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodStart(const mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32Tag;
   mplay_fi_tclString sTagGenre;
   mplay_fi_tclString sTagAlbum;
   mplay_fi_tclString sTagArtist;
   mplay_fi_tclString sTagTitle;
   mplay_fi_tclString sTagComposer;
   tU16 u16TagYear;
   tU8 u8DeviceTag;
   mplay_fi_tclString sTagYomiTitle;
   mplay_fi_tclString sTagYomiArtist;
   mplay_fi_tclString sTagYomiAlbum;
   virtual ~mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodResult& operator=(const mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodResult(const mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult u32Status;
   virtual ~mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodStart& operator=(const mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodStart(const mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sMediaObjectUrl;
   mplay_fi_tclString sTagGenre;
   mplay_fi_tclString sTagAlbum;
   mplay_fi_tclString sTagArtist;
   mplay_fi_tclString sTagTitle;
   mplay_fi_tclString sTagComposer;
   tU16 u16TagYear;
   tU8 u8DeviceTag;
   mplay_fi_tclString sTagYomiTitle;
   mplay_fi_tclString sTagYomiArtist;
   mplay_fi_tclString sTagYomiAlbum;
   virtual ~mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodResult& operator=(const mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodResult(const mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult u32Status;
   virtual ~mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgStartRippingMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgStartRippingMethodStart();

   virtual ~mplay_mediaplayerfi_tclMsgStartRippingMethodStart();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgStartRippingMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgStartRippingMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgStartRippingMethodResult();

   virtual ~mplay_mediaplayerfi_tclMsgStartRippingMethodResult();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgStartRippingMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgStopRippingMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgStopRippingMethodStart();

   virtual ~mplay_mediaplayerfi_tclMsgStopRippingMethodStart();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgStopRippingMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgStopRippingMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgStopRippingMethodResult();

   virtual ~mplay_mediaplayerfi_tclMsgStopRippingMethodResult();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgStopRippingMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodStart& operator=(const mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodStart(const mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sAlbumTitle;
   tBool bMultipleAlbumSelection;
   virtual ~mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodResult();

   virtual ~mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodResult();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodStart& operator=(const mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodStart(const mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sName;
   tU8 u8DeviceTag;
   virtual ~mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodResult& operator=(const mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodResult(const mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sPlaylistPath;
   mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult Status;
   virtual ~mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodStart& operator=(const mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodStart(const mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sPlaylistPath;
   mplay_fi_tcl_MPlayMediaObjectUrl oMPlayMediaObjectUrls;
   tU8 u8DeviceTag;
   mplay_fi_tcl_MPlayPlayListPosition oMPlayPlayListPosition;
   virtual ~mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodResult& operator=(const mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodResult(const mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult Status;
   virtual ~mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodStart& operator=(const mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodStart(const mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sPlaylistPath;
   tU8 u8DeviceTag;
   mplay_fi_tcl_MPlayPlayListPosition oMPlayPlayListPosition;
   virtual ~mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodResult& operator=(const mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodResult(const mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult Status;
   virtual ~mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodStart& operator=(const mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodStart(const mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sPlaylistPath;
   mplay_fi_tclString sNewName;
   tU8 u8DeviceTag;
   virtual ~mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodResult& operator=(const mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodResult(const mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult Status;
   virtual ~mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodStart& operator=(const mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodStart(const mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sPlaylistPath;
   tU8 u8DeviceTag;
   virtual ~mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodResult& operator=(const mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodResult(const mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult Status;
   virtual ~mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodStart& operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodStart(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceTag;
   virtual ~mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodResult& operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodResult(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32ListSize;
   virtual ~mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodStart& operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodStart(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32WindowStart;
   tU16 u16WindowSize;
   tU8 DeviceTag;
   virtual ~mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodResult& operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodResult(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_MPlayMediaObjects oMediaObjects;
   virtual ~mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodStart& operator=(const mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodStart(const mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32Tag;
   virtual ~mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodResult& operator=(const mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodResult(const mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32Position;
   virtual ~mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodStart& operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodStart(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sFilename;
   tU8 u8DeviceTag;
   mplay_fi_tcl_e8_MPlayFileTypeSelection e8MPlayFileTypeSelection;
   virtual ~mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodResult& operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodResult(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32ListSize;
   tU8 u8DeviceTag;
   tU32 u32TotalNumFiles;
   tU32 u32TotalNumFolders;
   tU32 u32Position;
   tU32 u32TotalNumMediaObjects;
   tU32 u32TotalNumPlaylists;
   virtual ~mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgStartSlideshowMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgStartSlideshowMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgStartSlideshowMethodStart& operator=(const mplay_mediaplayerfi_tclMsgStartSlideshowMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgStartSlideshowMethodStart(const mplay_mediaplayerfi_tclMsgStartSlideshowMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32Tag;
   virtual ~mplay_mediaplayerfi_tclMsgStartSlideshowMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgStartSlideshowMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgStartSlideshowMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgStartSlideshowMethodResult();

   virtual ~mplay_mediaplayerfi_tclMsgStartSlideshowMethodResult();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgStartSlideshowMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodStart& operator=(const mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodStart(const mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayAction e8Action;
   tU8 u8NextPrevSkipCount;
   virtual ~mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodResult();

   virtual ~mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodResult();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgQuicksearchMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgQuicksearchMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgQuicksearchMethodStart& operator=(const mplay_mediaplayerfi_tclMsgQuicksearchMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgQuicksearchMethodStart(const mplay_mediaplayerfi_tclMsgQuicksearchMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32Position;
   mplay_fi_tcl_SearchString sSearchChar;
   virtual ~mplay_mediaplayerfi_tclMsgQuicksearchMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgQuicksearchMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgQuicksearchMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgQuicksearchMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgQuicksearchMethodResult& operator=(const mplay_mediaplayerfi_tclMsgQuicksearchMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgQuicksearchMethodResult(const mplay_mediaplayerfi_tclMsgQuicksearchMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32Position;
   mplay_fi_tcl_e8_QuickSearchResult oSearchResult;
   virtual ~mplay_mediaplayerfi_tclMsgQuicksearchMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgQuicksearchMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodStart& operator=(const mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodStart(const mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_EjectParmType eCmdParam;
   virtual ~mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodResult& operator=(const mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodResult(const mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_EjectOpticalDisc_MethodResult ServiceStatus;
   virtual ~mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodStart& operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodStart(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayListType e8ListType;
   tU8 u8DeviceTag;
   mplay_fi_tclString sPath;
   virtual ~mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodResult& operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodResult(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32ListSize;
   virtual ~mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodStart& operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodStart(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32WindowStart;
   tU16 u16WindowSize;
   tU8 DeviceTag;
   virtual ~mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodResult& operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodResult(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_MPlayImageObjects oImageObjects;
   virtual ~mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodStart& operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodStart(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sPath;
   tU8 u8DeviceTag;
   mplay_fi_tcl_e8_MPlayFileTypeSelection e8MPlayFileTypeSelection;
   virtual ~mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodResult& operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodResult(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32ListSize;
   tU8 u8DeviceTag;
   tU32 u32TotalNumFiles;
   tU32 u32TotalNumFolders;
   tU32 u32TotalNumMediaObjects;
   tU32 u32TotalNumPlaylists;
   virtual ~mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodStart& operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodStart(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sPath;
   tU8 u8DeviceTag;
   mplay_fi_tcl_e8_MPlayFileTypeSelection e8MPlayFileTypeSelection;
   virtual ~mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodResult& operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodResult(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceTag;
   mplay_fi_tclString sPath;
   tU64 u64TotalSize;
   tU32 u32TotalNumber;
   tU64 u64ProtectedSize;
   tU32 u32ProtectedNumber;
   virtual ~mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodStart& operator=(const mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodStart(const mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_MPlayPermissionByTag oFilePermissionObjectTags;
   tU8 u8DeviceTag;
   virtual ~mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodResult& operator=(const mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodResult(const mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32NumberOfFiles;
   mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult u32Status;
   virtual ~mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodStart& operator=(const mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodStart(const mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sPlaylistPath;
   mplay_fi_tcl_e8_MPlayListType e8ListType;
   tU32 u32FilterTag1;
   tU32 u32FilterTag2;
   tU32 u32FilterTag3;
   tU8 u8DeviceTag;
   virtual ~mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodResult& operator=(const mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodResult(const mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult Status;
   virtual ~mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodStart& operator=(const mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodStart(const mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ObjectID;
   tU8 u8UserID;
   virtual ~mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodResult& operator=(const mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodResult(const mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU64 u64FavoriteID;
   virtual ~mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodStart& operator=(const mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodStart(const mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ObjectID;
   tU8 u8UserID;
   virtual ~mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodResult& operator=(const mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodResult(const mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ObjectID;
   virtual ~mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodStart& operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodStart(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandleOfParent;
   tU32 u32ListHandleOfReplaceableList;
   mplay_fi_tclString sSearchString;
   tU8 u8DeviceTag;
   mplay_fi_tcl_MPlaySearchType searchType;
   virtual ~mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodResult& operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodResult(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   tU32 u32ListSize;
   tU8 u8DeviceTag;
   virtual ~mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodStart& operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodStart(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 listID;
   virtual ~mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodResult& operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodResult(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 albumArtListID;
   tU32 listSize;
   virtual ~mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodStart& operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodStart(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 albumArtListID;
   mplay_fi_tcl_IndicesType indicesType;
   mplay_fi_tcl_IndicesList oIndices;
   virtual ~mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodResult& operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodResult(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_AlbumArtUrlList oAlbumartUrls;
   virtual ~mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodStart& operator=(const mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodStart(const mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e_MPlayHIDCommand eHIDCommand;
   mplay_fi_tcl_e_MPlayKeyEvent eKeyEvent;
   virtual ~mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodResult& operator=(const mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodResult(const mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool result;
   virtual ~mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodStart : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodStart& operator=(const mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodStart& coRef);
   mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodStart(const mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bRequestAction;
   virtual ~mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodResult : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodResult& operator=(const mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodResult& coRef);
   mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodResult(const mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bRequestStatus;
   virtual ~mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgMediaPlayerListChangeUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgMediaPlayerListChangeUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgMediaPlayerListChangeUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgMediaPlayerListChangeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgMediaPlayerListChangeRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgMediaPlayerListChangeRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgMediaPlayerListChangeRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgMediaPlayerListChangeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgMediaPlayerListChangeStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgMediaPlayerListChangeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgMediaPlayerListChangeStatus& operator=(const mplay_mediaplayerfi_tclMsgMediaPlayerListChangeStatus& coRef);
   mplay_mediaplayerfi_tclMsgMediaPlayerListChangeStatus(const mplay_mediaplayerfi_tclMsgMediaPlayerListChangeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   mplay_fi_tcl_e8_MPlayChange e8Change;
   tU32 u32ListSize;
   mplay_fi_tcl_MPlayItems oItems;
   virtual ~mplay_mediaplayerfi_tclMsgMediaPlayerListChangeStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgMediaPlayerListChangeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgNowPlayingUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgNowPlayingUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgNowPlayingUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgNowPlayingUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgNowPlayingRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgNowPlayingRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgNowPlayingRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgNowPlayingRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgNowPlayingGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgNowPlayingGet();

   virtual ~mplay_mediaplayerfi_tclMsgNowPlayingGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgNowPlayingGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgNowPlayingStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgNowPlayingStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgNowPlayingStatus& operator=(const mplay_mediaplayerfi_tclMsgNowPlayingStatus& coRef);
   mplay_mediaplayerfi_tclMsgNowPlayingStatus(const mplay_mediaplayerfi_tclMsgNowPlayingStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   mplay_fi_tcl_e8_MPlayNowPlayingState e8NowPlayingState;
   tU32 u32Position;
   tU32 u32Tag;
   mplay_fi_tcl_MPlayMediaObject oMediaObject;
   virtual ~mplay_mediaplayerfi_tclMsgNowPlayingStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgNowPlayingStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlaytimeUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlaytimeUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgPlaytimeUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgPlaytimeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlaytimeRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlaytimeRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgPlaytimeRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgPlaytimeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlaytimeGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlaytimeGet();

   virtual ~mplay_mediaplayerfi_tclMsgPlaytimeGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgPlaytimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlaytimeStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlaytimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgPlaytimeStatus& operator=(const mplay_mediaplayerfi_tclMsgPlaytimeStatus& coRef);
   mplay_mediaplayerfi_tclMsgPlaytimeStatus(const mplay_mediaplayerfi_tclMsgPlaytimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ElapsedPlaytime;
   tU32 u32TotalPlaytime;
   tU32 u32Tag;
   virtual ~mplay_mediaplayerfi_tclMsgPlaytimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgPlaytimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlaybackStateUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlaybackStateUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgPlaybackStateUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgPlaybackStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlaybackStateRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlaybackStateRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgPlaybackStateRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgPlaybackStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlaybackStateGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlaybackStateGet();

   virtual ~mplay_mediaplayerfi_tclMsgPlaybackStateGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgPlaybackStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlaybackStateStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlaybackStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgPlaybackStateStatus& operator=(const mplay_mediaplayerfi_tclMsgPlaybackStateStatus& coRef);
   mplay_mediaplayerfi_tclMsgPlaybackStateStatus(const mplay_mediaplayerfi_tclMsgPlaybackStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayState e8State;
   virtual ~mplay_mediaplayerfi_tclMsgPlaybackStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgPlaybackStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlaybackModeUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlaybackModeUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgPlaybackModeUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgPlaybackModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlaybackModeRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlaybackModeRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgPlaybackModeRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgPlaybackModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlaybackModeGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlaybackModeGet();

   virtual ~mplay_mediaplayerfi_tclMsgPlaybackModeGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgPlaybackModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlaybackModeSet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlaybackModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgPlaybackModeSet& operator=(const mplay_mediaplayerfi_tclMsgPlaybackModeSet& coRef);
   mplay_mediaplayerfi_tclMsgPlaybackModeSet(const mplay_mediaplayerfi_tclMsgPlaybackModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayMode e8Mode;
   virtual ~mplay_mediaplayerfi_tclMsgPlaybackModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgPlaybackModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlaybackModeStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlaybackModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgPlaybackModeStatus& operator=(const mplay_mediaplayerfi_tclMsgPlaybackModeStatus& coRef);
   mplay_mediaplayerfi_tclMsgPlaybackModeStatus(const mplay_mediaplayerfi_tclMsgPlaybackModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayMode e8Mode;
   virtual ~mplay_mediaplayerfi_tclMsgPlaybackModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgPlaybackModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRepeatModeUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRepeatModeUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgRepeatModeUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgRepeatModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRepeatModeRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRepeatModeRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgRepeatModeRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgRepeatModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRepeatModeGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRepeatModeGet();

   virtual ~mplay_mediaplayerfi_tclMsgRepeatModeGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgRepeatModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRepeatModeSet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRepeatModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRepeatModeSet& operator=(const mplay_mediaplayerfi_tclMsgRepeatModeSet& coRef);
   mplay_mediaplayerfi_tclMsgRepeatModeSet(const mplay_mediaplayerfi_tclMsgRepeatModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayRepeat e8Repeat;
   virtual ~mplay_mediaplayerfi_tclMsgRepeatModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRepeatModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRepeatModeStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRepeatModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRepeatModeStatus& operator=(const mplay_mediaplayerfi_tclMsgRepeatModeStatus& coRef);
   mplay_mediaplayerfi_tclMsgRepeatModeStatus(const mplay_mediaplayerfi_tclMsgRepeatModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayRepeat e8Repeat;
   virtual ~mplay_mediaplayerfi_tclMsgRepeatModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRepeatModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgIndexingStateUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgIndexingStateUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgIndexingStateUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgIndexingStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgIndexingStateRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgIndexingStateRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgIndexingStateRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgIndexingStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgIndexingStateGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgIndexingStateGet();

   virtual ~mplay_mediaplayerfi_tclMsgIndexingStateGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgIndexingStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgIndexingStateStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgIndexingStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgIndexingStateStatus& operator=(const mplay_mediaplayerfi_tclMsgIndexingStateStatus& coRef);
   mplay_mediaplayerfi_tclMsgIndexingStateStatus(const mplay_mediaplayerfi_tclMsgIndexingStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_MPlayIndexingStateResult oIndexingStateResult;
   virtual ~mplay_mediaplayerfi_tclMsgIndexingStateStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgIndexingStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsGet();

   virtual ~mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsStatus& operator=(const mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsStatus& coRef);
   mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsStatus(const mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_MPlayDeviceInfo oDeviceInfo;
   virtual ~mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgActiveMediaDeviceUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgActiveMediaDeviceUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgActiveMediaDeviceUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgActiveMediaDeviceUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgActiveMediaDeviceRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgActiveMediaDeviceRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgActiveMediaDeviceRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgActiveMediaDeviceRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgActiveMediaDeviceGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgActiveMediaDeviceGet();

   virtual ~mplay_mediaplayerfi_tclMsgActiveMediaDeviceGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgActiveMediaDeviceGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgActiveMediaDeviceSet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgActiveMediaDeviceSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgActiveMediaDeviceSet& operator=(const mplay_mediaplayerfi_tclMsgActiveMediaDeviceSet& coRef);
   mplay_mediaplayerfi_tclMsgActiveMediaDeviceSet(const mplay_mediaplayerfi_tclMsgActiveMediaDeviceSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceTag;
   tBool bDeviceActiveSource;
   virtual ~mplay_mediaplayerfi_tclMsgActiveMediaDeviceSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgActiveMediaDeviceSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgActiveMediaDeviceStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgActiveMediaDeviceStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgActiveMediaDeviceStatus& operator=(const mplay_mediaplayerfi_tclMsgActiveMediaDeviceStatus& coRef);
   mplay_mediaplayerfi_tclMsgActiveMediaDeviceStatus(const mplay_mediaplayerfi_tclMsgActiveMediaDeviceStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceTag;
   tBool bDeviceActiveSource;
   tBool bScanSupported;
   virtual ~mplay_mediaplayerfi_tclMsgActiveMediaDeviceStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgActiveMediaDeviceStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgMyMediaSupportedGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgMyMediaSupportedGet();

   virtual ~mplay_mediaplayerfi_tclMsgMyMediaSupportedGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgMyMediaSupportedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgMyMediaSupportedStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgMyMediaSupportedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgMyMediaSupportedStatus& operator=(const mplay_mediaplayerfi_tclMsgMyMediaSupportedStatus& coRef);
   mplay_mediaplayerfi_tclMsgMyMediaSupportedStatus(const mplay_mediaplayerfi_tclMsgMyMediaSupportedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bMyMediaSupportedFlag;
   virtual ~mplay_mediaplayerfi_tclMsgMyMediaSupportedStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgMyMediaSupportedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCurrentFolderPathUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCurrentFolderPathUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgCurrentFolderPathUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgCurrentFolderPathUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCurrentFolderPathRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCurrentFolderPathRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgCurrentFolderPathRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgCurrentFolderPathRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCurrentFolderPathGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCurrentFolderPathGet();

   virtual ~mplay_mediaplayerfi_tclMsgCurrentFolderPathGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgCurrentFolderPathGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCurrentFolderPathStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCurrentFolderPathStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgCurrentFolderPathStatus& operator=(const mplay_mediaplayerfi_tclMsgCurrentFolderPathStatus& coRef);
   mplay_mediaplayerfi_tclMsgCurrentFolderPathStatus(const mplay_mediaplayerfi_tclMsgCurrentFolderPathStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sCurrentFolderPath;
   tU32 u32ListHandle;
   tU64 Tag;
   virtual ~mplay_mediaplayerfi_tclMsgCurrentFolderPathStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgCurrentFolderPathStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgScanModeUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgScanModeUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgScanModeUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgScanModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgScanModeRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgScanModeRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgScanModeRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgScanModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgScanModeGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgScanModeGet();

   virtual ~mplay_mediaplayerfi_tclMsgScanModeGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgScanModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgScanModeSet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgScanModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgScanModeSet& operator=(const mplay_mediaplayerfi_tclMsgScanModeSet& coRef);
   mplay_mediaplayerfi_tclMsgScanModeSet(const mplay_mediaplayerfi_tclMsgScanModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bScanMode;
   virtual ~mplay_mediaplayerfi_tclMsgScanModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgScanModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgScanModeStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgScanModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgScanModeStatus& operator=(const mplay_mediaplayerfi_tclMsgScanModeStatus& coRef);
   mplay_mediaplayerfi_tclMsgScanModeStatus(const mplay_mediaplayerfi_tclMsgScanModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bScanMode;
   virtual ~mplay_mediaplayerfi_tclMsgScanModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgScanModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDiscErrorUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDiscErrorUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgDiscErrorUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDiscErrorUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDiscErrorRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDiscErrorRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgDiscErrorRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDiscErrorRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDiscErrorGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDiscErrorGet();

   virtual ~mplay_mediaplayerfi_tclMsgDiscErrorGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDiscErrorGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDiscErrorStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDiscErrorStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDiscErrorStatus& operator=(const mplay_mediaplayerfi_tclMsgDiscErrorStatus& coRef);
   mplay_mediaplayerfi_tclMsgDiscErrorStatus(const mplay_mediaplayerfi_tclMsgDiscErrorStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bIsError;
   mplay_fi_tcl_e8_MDiscError e8DiscError;
   virtual ~mplay_mediaplayerfi_tclMsgDiscErrorStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDiscErrorStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDiscMechanicalInfoUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDiscMechanicalInfoUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgDiscMechanicalInfoUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDiscMechanicalInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDiscMechanicalInfoRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDiscMechanicalInfoRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgDiscMechanicalInfoRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDiscMechanicalInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDiscMechanicalInfoGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDiscMechanicalInfoGet();

   virtual ~mplay_mediaplayerfi_tclMsgDiscMechanicalInfoGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDiscMechanicalInfoGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDiscMechanicalInfoStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDiscMechanicalInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDiscMechanicalInfoStatus& operator=(const mplay_mediaplayerfi_tclMsgDiscMechanicalInfoStatus& coRef);
   mplay_mediaplayerfi_tclMsgDiscMechanicalInfoStatus(const mplay_mediaplayerfi_tclMsgDiscMechanicalInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MDiscMechanicalInfo e8DiscMechanicalInfo;
   virtual ~mplay_mediaplayerfi_tclMsgDiscMechanicalInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDiscMechanicalInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCMSkipAvailableUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCMSkipAvailableUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgCMSkipAvailableUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgCMSkipAvailableUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCMSkipAvailableRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCMSkipAvailableRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgCMSkipAvailableRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgCMSkipAvailableRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCMSkipAvailableGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCMSkipAvailableGet();

   virtual ~mplay_mediaplayerfi_tclMsgCMSkipAvailableGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgCMSkipAvailableGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgCMSkipAvailableStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgCMSkipAvailableStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgCMSkipAvailableStatus& operator=(const mplay_mediaplayerfi_tclMsgCMSkipAvailableStatus& coRef);
   mplay_mediaplayerfi_tclMsgCMSkipAvailableStatus(const mplay_mediaplayerfi_tclMsgCMSkipAvailableStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bCMSkipAvailable;
   virtual ~mplay_mediaplayerfi_tclMsgCMSkipAvailableStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgCMSkipAvailableStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDirectSelectAvailableUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDirectSelectAvailableUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgDirectSelectAvailableUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDirectSelectAvailableUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDirectSelectAvailableRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDirectSelectAvailableRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgDirectSelectAvailableRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDirectSelectAvailableRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDirectSelectAvailableGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDirectSelectAvailableGet();

   virtual ~mplay_mediaplayerfi_tclMsgDirectSelectAvailableGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDirectSelectAvailableGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDirectSelectAvailableStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDirectSelectAvailableStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDirectSelectAvailableStatus& operator=(const mplay_mediaplayerfi_tclMsgDirectSelectAvailableStatus& coRef);
   mplay_mediaplayerfi_tclMsgDirectSelectAvailableStatus(const mplay_mediaplayerfi_tclMsgDirectSelectAvailableStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bDirectSelectAvailable;
   virtual ~mplay_mediaplayerfi_tclMsgDirectSelectAvailableStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDirectSelectAvailableStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDAngleInfoUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDAngleInfoUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgDVDAngleInfoUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDVDAngleInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDAngleInfoRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDAngleInfoRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgDVDAngleInfoRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDVDAngleInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDAngleInfoGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDAngleInfoGet();

   virtual ~mplay_mediaplayerfi_tclMsgDVDAngleInfoGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDVDAngleInfoGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDAngleInfoStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDAngleInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDVDAngleInfoStatus& operator=(const mplay_mediaplayerfi_tclMsgDVDAngleInfoStatus& coRef);
   mplay_mediaplayerfi_tclMsgDVDAngleInfoStatus(const mplay_mediaplayerfi_tclMsgDVDAngleInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MAngle e8CurrentAngle;
   mplay_fi_tcl_e8_MAngle e8TotalAngle;
   virtual ~mplay_mediaplayerfi_tclMsgDVDAngleInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDVDAngleInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDSubtitleInfoUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDSubtitleInfoUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgDVDSubtitleInfoUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDVDSubtitleInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDSubtitleInfoRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDSubtitleInfoRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgDVDSubtitleInfoRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDVDSubtitleInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDSubtitleInfoGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDSubtitleInfoGet();

   virtual ~mplay_mediaplayerfi_tclMsgDVDSubtitleInfoGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDVDSubtitleInfoGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDSubtitleInfoStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDSubtitleInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDVDSubtitleInfoStatus& operator=(const mplay_mediaplayerfi_tclMsgDVDSubtitleInfoStatus& coRef);
   mplay_mediaplayerfi_tclMsgDVDSubtitleInfoStatus(const mplay_mediaplayerfi_tclMsgDVDSubtitleInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool subtitleState;
   tU8 u8CurrentSubtitle;
   tU8 u8TotalSubtitle;
   tU16 u16SubtitleLang;
   virtual ~mplay_mediaplayerfi_tclMsgDVDSubtitleInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDVDSubtitleInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoGet();

   virtual ~mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoStatus& operator=(const mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoStatus& coRef);
   mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoStatus(const mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MTotalChannel e8totalChannels;
   tBool bSubWooferAvailable;
   mplay_fi_tcl_e8_MChannelAssignment e8CurrentAssignment;
   virtual ~mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoGet();

   virtual ~mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoStatus& operator=(const mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoStatus& coRef);
   mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoStatus(const mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MSoundFormat e8SoundFormat;
   mplay_fi_tcl_e8_MVCDAudioMode e8VCDAudioOutput;
   mplay_fi_tcl_e8_MAudioOutputNumber e8DVDAudioChannel;
   mplay_fi_tcl_e8_MAudioOutputNumber e8DVDTotalAudio;
   tU16 u16DVDAudioLang;
   virtual ~mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDisplayModeUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDisplayModeUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgDisplayModeUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDisplayModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDisplayModeRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDisplayModeRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgDisplayModeRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDisplayModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDisplayModeSet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDisplayModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDisplayModeSet& operator=(const mplay_mediaplayerfi_tclMsgDisplayModeSet& coRef);
   mplay_mediaplayerfi_tclMsgDisplayModeSet(const mplay_mediaplayerfi_tclMsgDisplayModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MDisplayMode e8DisplayMode;
   virtual ~mplay_mediaplayerfi_tclMsgDisplayModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDisplayModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDisplayModeGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDisplayModeGet();

   virtual ~mplay_mediaplayerfi_tclMsgDisplayModeGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDisplayModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDisplayModeStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDisplayModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDisplayModeStatus& operator=(const mplay_mediaplayerfi_tclMsgDisplayModeStatus& coRef);
   mplay_mediaplayerfi_tclMsgDisplayModeStatus(const mplay_mediaplayerfi_tclMsgDisplayModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MDisplayMode e8DisplayMode;
   virtual ~mplay_mediaplayerfi_tclMsgDisplayModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDisplayModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingSet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingSet& operator=(const mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingSet& coRef);
   mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingSet(const mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_MInternalDVDLangSetting langSetting;
   virtual ~mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingGet();

   virtual ~mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingStatus& operator=(const mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingStatus& coRef);
   mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingStatus(const mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_MInternalDVDLangSetting langSetting;
   virtual ~mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgAngleMarkSettingUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgAngleMarkSettingUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgAngleMarkSettingUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgAngleMarkSettingUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgAngleMarkSettingRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgAngleMarkSettingRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgAngleMarkSettingRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgAngleMarkSettingRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgAngleMarkSettingSet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgAngleMarkSettingSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgAngleMarkSettingSet& operator=(const mplay_mediaplayerfi_tclMsgAngleMarkSettingSet& coRef);
   mplay_mediaplayerfi_tclMsgAngleMarkSettingSet(const mplay_mediaplayerfi_tclMsgAngleMarkSettingSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bAngleMark;
   virtual ~mplay_mediaplayerfi_tclMsgAngleMarkSettingSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgAngleMarkSettingSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgAngleMarkSettingGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgAngleMarkSettingGet();

   virtual ~mplay_mediaplayerfi_tclMsgAngleMarkSettingGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgAngleMarkSettingGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgAngleMarkSettingStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgAngleMarkSettingStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgAngleMarkSettingStatus& operator=(const mplay_mediaplayerfi_tclMsgAngleMarkSettingStatus& coRef);
   mplay_mediaplayerfi_tclMsgAngleMarkSettingStatus(const mplay_mediaplayerfi_tclMsgAngleMarkSettingStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bAngleMark;
   virtual ~mplay_mediaplayerfi_tclMsgAngleMarkSettingStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgAngleMarkSettingStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlayStatusSettingUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlayStatusSettingUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgPlayStatusSettingUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgPlayStatusSettingUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlayStatusSettingRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlayStatusSettingRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgPlayStatusSettingRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgPlayStatusSettingRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlayStatusSettingSet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlayStatusSettingSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgPlayStatusSettingSet& operator=(const mplay_mediaplayerfi_tclMsgPlayStatusSettingSet& coRef);
   mplay_mediaplayerfi_tclMsgPlayStatusSettingSet(const mplay_mediaplayerfi_tclMsgPlayStatusSettingSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bPlayStatus;
   virtual ~mplay_mediaplayerfi_tclMsgPlayStatusSettingSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgPlayStatusSettingSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlayStatusSettingGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlayStatusSettingGet();

   virtual ~mplay_mediaplayerfi_tclMsgPlayStatusSettingGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgPlayStatusSettingGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlayStatusSettingStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlayStatusSettingStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgPlayStatusSettingStatus& operator=(const mplay_mediaplayerfi_tclMsgPlayStatusSettingStatus& coRef);
   mplay_mediaplayerfi_tclMsgPlayStatusSettingStatus(const mplay_mediaplayerfi_tclMsgPlayStatusSettingStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bPlayStatus;
   virtual ~mplay_mediaplayerfi_tclMsgPlayStatusSettingStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgPlayStatusSettingStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDRCSettingUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDRCSettingUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgDRCSettingUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDRCSettingUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDRCSettingRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDRCSettingRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgDRCSettingRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDRCSettingRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDRCSettingSet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDRCSettingSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDRCSettingSet& operator=(const mplay_mediaplayerfi_tclMsgDRCSettingSet& coRef);
   mplay_mediaplayerfi_tclMsgDRCSettingSet(const mplay_mediaplayerfi_tclMsgDRCSettingSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MDRCSetting e8DRCSetting;
   virtual ~mplay_mediaplayerfi_tclMsgDRCSettingSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDRCSettingSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDRCSettingGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDRCSettingGet();

   virtual ~mplay_mediaplayerfi_tclMsgDRCSettingGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDRCSettingGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDRCSettingStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDRCSettingStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDRCSettingStatus& operator=(const mplay_mediaplayerfi_tclMsgDRCSettingStatus& coRef);
   mplay_mediaplayerfi_tclMsgDRCSettingStatus(const mplay_mediaplayerfi_tclMsgDRCSettingStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MDRCSetting e8DRCSetting;
   virtual ~mplay_mediaplayerfi_tclMsgDRCSettingStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDRCSettingStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDCommandStatusUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDCommandStatusUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgDVDCommandStatusUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDVDCommandStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDCommandStatusRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDCommandStatusRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgDVDCommandStatusRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDVDCommandStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDCommandStatusStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDCommandStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDVDCommandStatusStatus& operator=(const mplay_mediaplayerfi_tclMsgDVDCommandStatusStatus& coRef);
   mplay_mediaplayerfi_tclMsgDVDCommandStatusStatus(const mplay_mediaplayerfi_tclMsgDVDCommandStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_DVDCommandStatus e8CommandStatus;
   virtual ~mplay_mediaplayerfi_tclMsgDVDCommandStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDVDCommandStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgAutoRippingUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgAutoRippingUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgAutoRippingUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgAutoRippingUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgAutoRippingRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgAutoRippingRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgAutoRippingRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgAutoRippingRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgAutoRippingGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgAutoRippingGet();

   virtual ~mplay_mediaplayerfi_tclMsgAutoRippingGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgAutoRippingGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgAutoRippingSet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgAutoRippingSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgAutoRippingSet& operator=(const mplay_mediaplayerfi_tclMsgAutoRippingSet& coRef);
   mplay_mediaplayerfi_tclMsgAutoRippingSet(const mplay_mediaplayerfi_tclMsgAutoRippingSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bAutoRipping;
   virtual ~mplay_mediaplayerfi_tclMsgAutoRippingSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgAutoRippingSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgAutoRippingStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgAutoRippingStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgAutoRippingStatus& operator=(const mplay_mediaplayerfi_tclMsgAutoRippingStatus& coRef);
   mplay_mediaplayerfi_tclMsgAutoRippingStatus(const mplay_mediaplayerfi_tclMsgAutoRippingStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bAutoRipping;
   virtual ~mplay_mediaplayerfi_tclMsgAutoRippingStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgAutoRippingStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgGracenoteLookupModeUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgGracenoteLookupModeUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgGracenoteLookupModeUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgGracenoteLookupModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgGracenoteLookupModeRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgGracenoteLookupModeRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgGracenoteLookupModeRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgGracenoteLookupModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgGracenoteLookupModeGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgGracenoteLookupModeGet();

   virtual ~mplay_mediaplayerfi_tclMsgGracenoteLookupModeGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgGracenoteLookupModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgGracenoteLookupModeSet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgGracenoteLookupModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgGracenoteLookupModeSet& operator=(const mplay_mediaplayerfi_tclMsgGracenoteLookupModeSet& coRef);
   mplay_mediaplayerfi_tclMsgGracenoteLookupModeSet(const mplay_mediaplayerfi_tclMsgGracenoteLookupModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bLookupMode;
   virtual ~mplay_mediaplayerfi_tclMsgGracenoteLookupModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgGracenoteLookupModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgGracenoteLookupModeStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgGracenoteLookupModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgGracenoteLookupModeStatus& operator=(const mplay_mediaplayerfi_tclMsgGracenoteLookupModeStatus& coRef);
   mplay_mediaplayerfi_tclMsgGracenoteLookupModeStatus(const mplay_mediaplayerfi_tclMsgGracenoteLookupModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bLookupMode;
   virtual ~mplay_mediaplayerfi_tclMsgGracenoteLookupModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgGracenoteLookupModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgGracenoteVersionUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgGracenoteVersionUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgGracenoteVersionUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgGracenoteVersionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgGracenoteVersionRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgGracenoteVersionRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgGracenoteVersionRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgGracenoteVersionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgGracenoteVersionGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgGracenoteVersionGet();

   virtual ~mplay_mediaplayerfi_tclMsgGracenoteVersionGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgGracenoteVersionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgGracenoteVersionStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgGracenoteVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgGracenoteVersionStatus& operator=(const mplay_mediaplayerfi_tclMsgGracenoteVersionStatus& coRef);
   mplay_mediaplayerfi_tclMsgGracenoteVersionStatus(const mplay_mediaplayerfi_tclMsgGracenoteVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sVersion;
   virtual ~mplay_mediaplayerfi_tclMsgGracenoteVersionStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgGracenoteVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRippingErrorsUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRippingErrorsUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgRippingErrorsUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgRippingErrorsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRippingErrorsRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRippingErrorsRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgRippingErrorsRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgRippingErrorsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRippingErrorsGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRippingErrorsGet();

   virtual ~mplay_mediaplayerfi_tclMsgRippingErrorsGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgRippingErrorsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRippingErrorsStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRippingErrorsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRippingErrorsStatus& operator=(const mplay_mediaplayerfi_tclMsgRippingErrorsStatus& coRef);
   mplay_mediaplayerfi_tclMsgRippingErrorsStatus(const mplay_mediaplayerfi_tclMsgRippingErrorsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_MPlayRippingErrors oRippingErrors;
   virtual ~mplay_mediaplayerfi_tclMsgRippingErrorsStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRippingErrorsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesGet();

   virtual ~mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesStatus& operator=(const mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesStatus& coRef);
   mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesStatus(const mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sTOC;
   mplay_fi_tcl_MPlayMediaAlbums oAlbums;
   virtual ~mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingGet();

   virtual ~mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingStatus& operator=(const mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingStatus& coRef);
   mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingStatus(const mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bDVDMenuPlaybackOngoing;
   virtual ~mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDDriveInfoGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDDriveInfoGet();

   virtual ~mplay_mediaplayerfi_tclMsgDVDDriveInfoGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDVDDriveInfoGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDDriveInfoRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDDriveInfoRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgDVDDriveInfoRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDVDDriveInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDDriveInfoStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDDriveInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDVDDriveInfoStatus& operator=(const mplay_mediaplayerfi_tclMsgDVDDriveInfoStatus& coRef);
   mplay_mediaplayerfi_tclMsgDVDDriveInfoStatus(const mplay_mediaplayerfi_tclMsgDVDDriveInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MDVDDiscType e8DVDDiscType;
   mplay_fi_tcl_e8_MDVDDriveMode e8DVDDriveMode;
   virtual ~mplay_mediaplayerfi_tclMsgDVDDriveInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDVDDriveInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDVDDriveInfoUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDVDDriveInfoUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgDVDDriveInfoUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDVDDriveInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRippingStateUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRippingStateUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgRippingStateUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgRippingStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRippingStateRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRippingStateRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgRippingStateRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgRippingStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRippingStateGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRippingStateGet();

   virtual ~mplay_mediaplayerfi_tclMsgRippingStateGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgRippingStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRippingStateStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRippingStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRippingStateStatus& operator=(const mplay_mediaplayerfi_tclMsgRippingStateStatus& coRef);
   mplay_mediaplayerfi_tclMsgRippingStateStatus(const mplay_mediaplayerfi_tclMsgRippingStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_MPlayRippingStateResultItem oRippingStateResult;
   virtual ~mplay_mediaplayerfi_tclMsgRippingStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRippingStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRippingEncodingQualityUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRippingEncodingQualityUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgRippingEncodingQualityUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgRippingEncodingQualityUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRippingEncodingQualityRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRippingEncodingQualityRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgRippingEncodingQualityRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgRippingEncodingQualityRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRippingEncodingQualityGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRippingEncodingQualityGet();

   virtual ~mplay_mediaplayerfi_tclMsgRippingEncodingQualityGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgRippingEncodingQualityGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRippingEncodingQualityStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRippingEncodingQualityStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRippingEncodingQualityStatus& operator=(const mplay_mediaplayerfi_tclMsgRippingEncodingQualityStatus& coRef);
   mplay_mediaplayerfi_tclMsgRippingEncodingQualityStatus(const mplay_mediaplayerfi_tclMsgRippingEncodingQualityStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayEncodingQuality e8EncodingQuality;
   virtual ~mplay_mediaplayerfi_tclMsgRippingEncodingQualityStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRippingEncodingQualityStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgRippingEncodingQualitySet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgRippingEncodingQualitySet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgRippingEncodingQualitySet& operator=(const mplay_mediaplayerfi_tclMsgRippingEncodingQualitySet& coRef);
   mplay_mediaplayerfi_tclMsgRippingEncodingQualitySet(const mplay_mediaplayerfi_tclMsgRippingEncodingQualitySet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayEncodingQuality e8EncodingQuality;
   virtual ~mplay_mediaplayerfi_tclMsgRippingEncodingQualitySet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgRippingEncodingQualitySet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusGet();

   virtual ~mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusStatus& operator=(const mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusStatus& coRef);
   mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusStatus(const mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayGNmetadataExtractionResult e8GNmetadataExtractionResult;
   virtual ~mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgLanguageUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgLanguageUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgLanguageUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgLanguageUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgLanguageRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgLanguageRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgLanguageRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgLanguageRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgLanguageGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgLanguageGet();

   virtual ~mplay_mediaplayerfi_tclMsgLanguageGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgLanguageGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgLanguageSet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgLanguageSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgLanguageSet& operator=(const mplay_mediaplayerfi_tclMsgLanguageSet& coRef);
   mplay_mediaplayerfi_tclMsgLanguageSet(const mplay_mediaplayerfi_tclMsgLanguageSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayLanguage e8Language;
   virtual ~mplay_mediaplayerfi_tclMsgLanguageSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgLanguageSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgLanguageStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgLanguageStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgLanguageStatus& operator=(const mplay_mediaplayerfi_tclMsgLanguageStatus& coRef);
   mplay_mediaplayerfi_tclMsgLanguageStatus(const mplay_mediaplayerfi_tclMsgLanguageStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayLanguage e8Language;
   virtual ~mplay_mediaplayerfi_tclMsgLanguageStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgLanguageStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlaybackRepeatModeUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlaybackRepeatModeUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgPlaybackRepeatModeUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgPlaybackRepeatModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlaybackRepeatModeRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlaybackRepeatModeRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgPlaybackRepeatModeRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgPlaybackRepeatModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlaybackRepeatModeGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlaybackRepeatModeGet();

   virtual ~mplay_mediaplayerfi_tclMsgPlaybackRepeatModeGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgPlaybackRepeatModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlaybackRepeatModeSet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlaybackRepeatModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgPlaybackRepeatModeSet& operator=(const mplay_mediaplayerfi_tclMsgPlaybackRepeatModeSet& coRef);
   mplay_mediaplayerfi_tclMsgPlaybackRepeatModeSet(const mplay_mediaplayerfi_tclMsgPlaybackRepeatModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayMode e8Mode;
   mplay_fi_tcl_e8_MPlayRepeat e8Repeat;
   virtual ~mplay_mediaplayerfi_tclMsgPlaybackRepeatModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgPlaybackRepeatModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgPlaybackRepeatModeStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgPlaybackRepeatModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgPlaybackRepeatModeStatus& operator=(const mplay_mediaplayerfi_tclMsgPlaybackRepeatModeStatus& coRef);
   mplay_mediaplayerfi_tclMsgPlaybackRepeatModeStatus(const mplay_mediaplayerfi_tclMsgPlaybackRepeatModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayMode e8Mode;
   mplay_fi_tcl_e8_MPlayRepeat e8Repeat;
   virtual ~mplay_mediaplayerfi_tclMsgPlaybackRepeatModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgPlaybackRepeatModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgSlideshowTimeUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgSlideshowTimeUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgSlideshowTimeUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgSlideshowTimeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgSlideshowTimeRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgSlideshowTimeRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgSlideshowTimeRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgSlideshowTimeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgSlideshowTimeGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgSlideshowTimeGet();

   virtual ~mplay_mediaplayerfi_tclMsgSlideshowTimeGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgSlideshowTimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgSlideshowTimeSet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgSlideshowTimeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgSlideshowTimeSet& operator=(const mplay_mediaplayerfi_tclMsgSlideshowTimeSet& coRef);
   mplay_mediaplayerfi_tclMsgSlideshowTimeSet(const mplay_mediaplayerfi_tclMsgSlideshowTimeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32Time;
   virtual ~mplay_mediaplayerfi_tclMsgSlideshowTimeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgSlideshowTimeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgSlideshowTimeStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgSlideshowTimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgSlideshowTimeStatus& operator=(const mplay_mediaplayerfi_tclMsgSlideshowTimeStatus& coRef);
   mplay_mediaplayerfi_tclMsgSlideshowTimeStatus(const mplay_mediaplayerfi_tclMsgSlideshowTimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32Time;
   virtual ~mplay_mediaplayerfi_tclMsgSlideshowTimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgSlideshowTimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgNowShowingUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgNowShowingUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgNowShowingUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgNowShowingUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgNowShowingRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgNowShowingRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgNowShowingRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgNowShowingRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgNowShowingGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgNowShowingGet();

   virtual ~mplay_mediaplayerfi_tclMsgNowShowingGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgNowShowingGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgNowShowingStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgNowShowingStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgNowShowingStatus& operator=(const mplay_mediaplayerfi_tclMsgNowShowingStatus& coRef);
   mplay_mediaplayerfi_tclMsgNowShowingStatus(const mplay_mediaplayerfi_tclMsgNowShowingStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ListHandle;
   mplay_fi_tcl_e8_MPlayNowPlayingState e8NowPlayingState;
   tU32 u32Position;
   tU32 u32Tag;
   mplay_fi_tcl_MPlayMediaObject oMediaObject;
   mplay_fi_tclString sNextFile;
   virtual ~mplay_mediaplayerfi_tclMsgNowShowingStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgNowShowingStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgSlideshowStateUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgSlideshowStateUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgSlideshowStateUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgSlideshowStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgSlideshowStateRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgSlideshowStateRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgSlideshowStateRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgSlideshowStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgSlideshowStateGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgSlideshowStateGet();

   virtual ~mplay_mediaplayerfi_tclMsgSlideshowStateGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgSlideshowStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgSlideshowStateStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgSlideshowStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgSlideshowStateStatus& operator=(const mplay_mediaplayerfi_tclMsgSlideshowStateStatus& coRef);
   mplay_mediaplayerfi_tclMsgSlideshowStateStatus(const mplay_mediaplayerfi_tclMsgSlideshowStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayState e8State;
   virtual ~mplay_mediaplayerfi_tclMsgSlideshowStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgSlideshowStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateGet();

   virtual ~mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateStatus& operator=(const mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateStatus& coRef);
   mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateStatus(const mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_SlotStateOpticalDiscType e8State;
   virtual ~mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoGet();

   virtual ~mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoStatus& operator=(const mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoStatus& coRef);
   mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoStatus(const mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_CDInfo CDInfo;
   virtual ~mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgiPodCommunicationErrorUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgiPodCommunicationErrorUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgiPodCommunicationErrorUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgiPodCommunicationErrorUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgiPodCommunicationErrorRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgiPodCommunicationErrorRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgiPodCommunicationErrorRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgiPodCommunicationErrorRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgiPodCommunicationErrorGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgiPodCommunicationErrorGet();

   virtual ~mplay_mediaplayerfi_tclMsgiPodCommunicationErrorGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgiPodCommunicationErrorGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgiPodCommunicationErrorStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgiPodCommunicationErrorStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgiPodCommunicationErrorStatus& operator=(const mplay_mediaplayerfi_tclMsgiPodCommunicationErrorStatus& coRef);
   mplay_mediaplayerfi_tclMsgiPodCommunicationErrorStatus(const mplay_mediaplayerfi_tclMsgiPodCommunicationErrorStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceTag;
   mplay_fi_tcl_e8_MPlayiPodCommunicationError e8iPodCommunicationError;
   virtual ~mplay_mediaplayerfi_tclMsgiPodCommunicationErrorStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgiPodCommunicationErrorStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDeviceStreamingInfoGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDeviceStreamingInfoGet();

   virtual ~mplay_mediaplayerfi_tclMsgDeviceStreamingInfoGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDeviceStreamingInfoGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDeviceStreamingInfoRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDeviceStreamingInfoRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgDeviceStreamingInfoRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDeviceStreamingInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDeviceStreamingInfoStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDeviceStreamingInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgDeviceStreamingInfoStatus& operator=(const mplay_mediaplayerfi_tclMsgDeviceStreamingInfoStatus& coRef);
   mplay_mediaplayerfi_tclMsgDeviceStreamingInfoStatus(const mplay_mediaplayerfi_tclMsgDeviceStreamingInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayStreamingInfo e8StreamingInfo;
   tU8 u8DeviceTag;
   tU8 u8DeviceType;
   virtual ~mplay_mediaplayerfi_tclMsgDeviceStreamingInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgDeviceStreamingInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgDeviceStreamingInfoUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgDeviceStreamingInfoUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgDeviceStreamingInfoUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgDeviceStreamingInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoBrightnessUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoBrightnessUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgVideoBrightnessUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgVideoBrightnessUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoBrightnessRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoBrightnessRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgVideoBrightnessRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgVideoBrightnessRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoBrightnessGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoBrightnessGet();

   virtual ~mplay_mediaplayerfi_tclMsgVideoBrightnessGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgVideoBrightnessGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoBrightnessSet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoBrightnessSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgVideoBrightnessSet& operator=(const mplay_mediaplayerfi_tclMsgVideoBrightnessSet& coRef);
   mplay_mediaplayerfi_tclMsgVideoBrightnessSet(const mplay_mediaplayerfi_tclMsgVideoBrightnessSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8VideoBrightness;
   virtual ~mplay_mediaplayerfi_tclMsgVideoBrightnessSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgVideoBrightnessSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoBrightnessStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoBrightnessStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgVideoBrightnessStatus& operator=(const mplay_mediaplayerfi_tclMsgVideoBrightnessStatus& coRef);
   mplay_mediaplayerfi_tclMsgVideoBrightnessStatus(const mplay_mediaplayerfi_tclMsgVideoBrightnessStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8VideoBrightness;
   virtual ~mplay_mediaplayerfi_tclMsgVideoBrightnessStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgVideoBrightnessStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoHueUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoHueUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgVideoHueUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgVideoHueUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoHueRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoHueRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgVideoHueRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgVideoHueRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoHueGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoHueGet();

   virtual ~mplay_mediaplayerfi_tclMsgVideoHueGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgVideoHueGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoHueSet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoHueSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgVideoHueSet& operator=(const mplay_mediaplayerfi_tclMsgVideoHueSet& coRef);
   mplay_mediaplayerfi_tclMsgVideoHueSet(const mplay_mediaplayerfi_tclMsgVideoHueSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 s16VideoHue;
   virtual ~mplay_mediaplayerfi_tclMsgVideoHueSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgVideoHueSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoHueStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoHueStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgVideoHueStatus& operator=(const mplay_mediaplayerfi_tclMsgVideoHueStatus& coRef);
   mplay_mediaplayerfi_tclMsgVideoHueStatus(const mplay_mediaplayerfi_tclMsgVideoHueStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 s16VideoHue;
   virtual ~mplay_mediaplayerfi_tclMsgVideoHueStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgVideoHueStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoSaturationUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoSaturationUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgVideoSaturationUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgVideoSaturationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoSaturationRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoSaturationRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgVideoSaturationRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgVideoSaturationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoSaturationGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoSaturationGet();

   virtual ~mplay_mediaplayerfi_tclMsgVideoSaturationGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgVideoSaturationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoSaturationSet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoSaturationSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgVideoSaturationSet& operator=(const mplay_mediaplayerfi_tclMsgVideoSaturationSet& coRef);
   mplay_mediaplayerfi_tclMsgVideoSaturationSet(const mplay_mediaplayerfi_tclMsgVideoSaturationSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8VideoSaturation;
   virtual ~mplay_mediaplayerfi_tclMsgVideoSaturationSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgVideoSaturationSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoSaturationStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoSaturationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgVideoSaturationStatus& operator=(const mplay_mediaplayerfi_tclMsgVideoSaturationStatus& coRef);
   mplay_mediaplayerfi_tclMsgVideoSaturationStatus(const mplay_mediaplayerfi_tclMsgVideoSaturationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8VideoSaturation;
   virtual ~mplay_mediaplayerfi_tclMsgVideoSaturationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgVideoSaturationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoContrastUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoContrastUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgVideoContrastUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgVideoContrastUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoContrastRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoContrastRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgVideoContrastRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgVideoContrastRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoContrastGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoContrastGet();

   virtual ~mplay_mediaplayerfi_tclMsgVideoContrastGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgVideoContrastGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoContrastSet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoContrastSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgVideoContrastSet& operator=(const mplay_mediaplayerfi_tclMsgVideoContrastSet& coRef);
   mplay_mediaplayerfi_tclMsgVideoContrastSet(const mplay_mediaplayerfi_tclMsgVideoContrastSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8VideoContrast;
   virtual ~mplay_mediaplayerfi_tclMsgVideoContrastSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgVideoContrastSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoContrastStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoContrastStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgVideoContrastStatus& operator=(const mplay_mediaplayerfi_tclMsgVideoContrastStatus& coRef);
   mplay_mediaplayerfi_tclMsgVideoContrastStatus(const mplay_mediaplayerfi_tclMsgVideoContrastStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8VideoContrast;
   virtual ~mplay_mediaplayerfi_tclMsgVideoContrastStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgVideoContrastStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetGet();

   virtual ~mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetSet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetSet& operator=(const mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetSet& coRef);
   mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetSet(const mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 s16VideoBrightnessOffset;
   virtual ~mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetStatus& operator=(const mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetStatus& coRef);
   mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetStatus(const mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 s16VideoBrightnessOffset;
   virtual ~mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoHueOffsetUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoHueOffsetUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgVideoHueOffsetUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgVideoHueOffsetUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoHueOffsetRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoHueOffsetRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgVideoHueOffsetRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgVideoHueOffsetRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoHueOffsetGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoHueOffsetGet();

   virtual ~mplay_mediaplayerfi_tclMsgVideoHueOffsetGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgVideoHueOffsetGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoHueOffsetSet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoHueOffsetSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgVideoHueOffsetSet& operator=(const mplay_mediaplayerfi_tclMsgVideoHueOffsetSet& coRef);
   mplay_mediaplayerfi_tclMsgVideoHueOffsetSet(const mplay_mediaplayerfi_tclMsgVideoHueOffsetSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 s16VideoHueOffset;
   virtual ~mplay_mediaplayerfi_tclMsgVideoHueOffsetSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgVideoHueOffsetSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoHueOffsetStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoHueOffsetStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgVideoHueOffsetStatus& operator=(const mplay_mediaplayerfi_tclMsgVideoHueOffsetStatus& coRef);
   mplay_mediaplayerfi_tclMsgVideoHueOffsetStatus(const mplay_mediaplayerfi_tclMsgVideoHueOffsetStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 s16VideoHueOffset;
   virtual ~mplay_mediaplayerfi_tclMsgVideoHueOffsetStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgVideoHueOffsetStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoSaturationOffsetUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoSaturationOffsetUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgVideoSaturationOffsetUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgVideoSaturationOffsetUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoSaturationOffsetRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoSaturationOffsetRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgVideoSaturationOffsetRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgVideoSaturationOffsetRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoSaturationOffsetGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoSaturationOffsetGet();

   virtual ~mplay_mediaplayerfi_tclMsgVideoSaturationOffsetGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgVideoSaturationOffsetGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoSaturationOffsetSet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoSaturationOffsetSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgVideoSaturationOffsetSet& operator=(const mplay_mediaplayerfi_tclMsgVideoSaturationOffsetSet& coRef);
   mplay_mediaplayerfi_tclMsgVideoSaturationOffsetSet(const mplay_mediaplayerfi_tclMsgVideoSaturationOffsetSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8VideoSaturationOffset;
   virtual ~mplay_mediaplayerfi_tclMsgVideoSaturationOffsetSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgVideoSaturationOffsetSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoSaturationOffsetStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoSaturationOffsetStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgVideoSaturationOffsetStatus& operator=(const mplay_mediaplayerfi_tclMsgVideoSaturationOffsetStatus& coRef);
   mplay_mediaplayerfi_tclMsgVideoSaturationOffsetStatus(const mplay_mediaplayerfi_tclMsgVideoSaturationOffsetStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8VideoSaturationOffset;
   virtual ~mplay_mediaplayerfi_tclMsgVideoSaturationOffsetStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgVideoSaturationOffsetStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoScalingUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoScalingUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgVideoScalingUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgVideoScalingUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoScalingRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoScalingRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgVideoScalingRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgVideoScalingRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoScalingGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoScalingGet();

   virtual ~mplay_mediaplayerfi_tclMsgVideoScalingGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgVideoScalingGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoScalingSet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoScalingSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgVideoScalingSet& operator=(const mplay_mediaplayerfi_tclMsgVideoScalingSet& coRef);
   mplay_mediaplayerfi_tclMsgVideoScalingSet(const mplay_mediaplayerfi_tclMsgVideoScalingSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_VideoScalingType eVideoScaling;
   virtual ~mplay_mediaplayerfi_tclMsgVideoScalingSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgVideoScalingSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgVideoScalingStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgVideoScalingStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgVideoScalingStatus& operator=(const mplay_mediaplayerfi_tclMsgVideoScalingStatus& coRef);
   mplay_mediaplayerfi_tclMsgVideoScalingStatus(const mplay_mediaplayerfi_tclMsgVideoScalingStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_VideoScalingType eVideoScaling;
   virtual ~mplay_mediaplayerfi_tclMsgVideoScalingStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgVideoScalingStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedGet();

   virtual ~mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedSet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedSet();

   virtual ~mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedSet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedSet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedStatus& operator=(const mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedStatus& coRef);
   mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedStatus(const mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlaybackSpeed e8PlaybackSpeed;
   virtual ~mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgUserFavoritesChangedUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgUserFavoritesChangedUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgUserFavoritesChangedUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgUserFavoritesChangedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgUserFavoritesChangedRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgUserFavoritesChangedRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgUserFavoritesChangedRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgUserFavoritesChangedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgUserFavoritesChangedStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgUserFavoritesChangedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgUserFavoritesChangedStatus& operator=(const mplay_mediaplayerfi_tclMsgUserFavoritesChangedStatus& coRef);
   mplay_mediaplayerfi_tclMsgUserFavoritesChangedStatus(const mplay_mediaplayerfi_tclMsgUserFavoritesChangedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MPlayChange e8ListChangeType;
   tU32 u32ListSize;
   tU32 u32NumItems;
   mplay_fi_tcl_MPlayFavoritesList oChangedFavorites;
   virtual ~mplay_mediaplayerfi_tclMsgUserFavoritesChangedStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgUserFavoritesChangedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedStatus& operator=(const mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedStatus& coRef);
   mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedStatus(const mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceTag;
   virtual ~mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgReadyToPlayUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgReadyToPlayUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgReadyToPlayUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgReadyToPlayUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgReadyToPlayRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgReadyToPlayRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgReadyToPlayRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgReadyToPlayRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgReadyToPlayGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgReadyToPlayGet();

   virtual ~mplay_mediaplayerfi_tclMsgReadyToPlayGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgReadyToPlayGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgReadyToPlayStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgReadyToPlayStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgReadyToPlayStatus& operator=(const mplay_mediaplayerfi_tclMsgReadyToPlayStatus& coRef);
   mplay_mediaplayerfi_tclMsgReadyToPlayStatus(const mplay_mediaplayerfi_tclMsgReadyToPlayStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sDeviceSerialNumber;
   tBool bPlayingStatus;
   virtual ~mplay_mediaplayerfi_tclMsgReadyToPlayStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgReadyToPlayStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusRelUpReg : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusRelUpReg();

   virtual ~mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusRelUpReg();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusGet : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusGet();

   virtual ~mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusGet();

   inline tBool operator==(const mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusStatus : public mplay_mediaplayerfi_tclMsgBaseMessage
{
public:

   mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusStatus& operator=(const mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusStatus& coRef);
   mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusStatus(const mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bAudioDeviceStatus;
   virtual ~mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
