/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_TYPES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_FUNCTIONIDS
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_SERVICEINFO
#include "mplay_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for mplay_MediaPlayer_FI message types

fi_tclMessageBase* mplay_mediaplayerfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERQUICKPLAYLISTMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERQUICKPLAYLISTMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERINDEXEDLISTMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERINDEXEDLISTMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERINDEXEDLISTSLICEMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERINDEXEDLISTSLICEMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_RELEASEMEDIAPLAYERLISTMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_RELEASEMEDIAPLAYERLISTMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTPLAYBACKACTIONMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTPLAYBACKACTIONMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SEEKTOMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgSeekToMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SEEKTOMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgSeekToMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_GETMEDIAOBJECTALBUMARTMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_GETMEDIAOBJECTALBUMARTMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SEARCHKEYBOARDMEDIAPLAYERLISTMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SEARCHKEYBOARDMEDIAPLAYERLISTMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERLISTSEARCHSTRINGMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERLISTSEARCHSTRINGMETHODRESULTFIRST:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultFirst;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERLISTSEARCHSTRINGMETHODRESULTMIDDLE:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultMiddle;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERLISTSEARCHSTRINGMETHODRESULTLAST:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultLast;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERLISTSEARCHSTRINGMETHODABORT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodAbort;

      case mplay_mediaplayerfi_tclToken::EN_MSG_GETMEDIAOBJECTMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgGetMediaObjectMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_GETMEDIAOBJECTMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgGetMediaObjectMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERFILELISTMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERFILELISTMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERFILELISTSLICEMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERFILELISTSLICEMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERPLAYLISTLISTMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERPLAYLISTLISTMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERPLAYLISTLISTSLICEMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERPLAYLISTLISTSLICEMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERQUICKPLAYLISTSLICEMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERQUICKPLAYLISTSLICEMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_GETMEDIAOBJECTALBUMARTINFOMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_GETMEDIAOBJECTALBUMARTINFOMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYMEDIAPLAYEROBJECTMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYMEDIAPLAYEROBJECTMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYITEMFROMLISTMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlayItemFromListMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYITEMFROMLISTMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlayItemFromListMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CLEARMEDIAPLAYERDATAMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgClearMediaPlayerDataMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CLEARMEDIAPLAYERDATAMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgClearMediaPlayerDataMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_UMOUNTMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgUmountMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_UMOUNTMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgUmountMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REINDEXINGMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgReindexingMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REINDEXINGMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgReindexingMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DIAGNOSISPLAYSONGMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DIAGNOSISPLAYSONGMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTLISTDETAILSMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestListDetailsMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTLISTDETAILSMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestListDetailsMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTLISTINFORMATIONMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestListInformationMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTLISTINFORMATIONMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestListInformationMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_TRANSFERTAGSTODEVICEMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_TRANSFERTAGSTODEVICEMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYITEMFROMLISTBYTAGMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYITEMFROMLISTBYTAGMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKSPEEDSETMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKSPEEDSETMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CLEARLASTMODEPAUSEMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgClearLastModePauseMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CLEARLASTMODEPAUSEMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgClearLastModePauseMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTDISCOPERATIONMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTDISCOPERATIONMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTVCDAUDIOCHANNELMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTVCDAUDIOCHANNELMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTDVDAUDIOCHANNELMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTDVDAUDIOCHANNELMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SENDNAVIGATIONKEYMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SENDNAVIGATIONKEYMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SENDTOUCHCOMMANDMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgSendTouchCommandMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SENDTOUCHCOMMANDMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgSendTouchCommandMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTDIRECTSEARCHMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTDIRECTSEARCHMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTANGLECHANGEMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTANGLECHANGEMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SETMENUPLAYBACKCONTROLMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SETMENUPLAYBACKCONTROLMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SELECTDIRECTNUMBERMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SELECTDIRECTNUMBERMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTTITLESEARCHMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTTITLESEARCHMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTSUBTITLECHANGEMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTSUBTITLECHANGEMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTCMSKIPMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestCMSkipMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTCMSKIPMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestCMSkipMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTDVDTEMPERATUREMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTDVDTEMPERATUREMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REORDERINTERNALPLAYLISTMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REORDERINTERNALPLAYLISTMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DELETEMEDIACONTENTBYFILTERTAGSMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DELETEMEDIACONTENTBYFILTERTAGSMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DELETEMEDIACONTENTBYMEDIAOBJECTTAGSMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DELETEMEDIACONTENTBYMEDIAOBJECTTAGSMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DELETEMEDIACONTENTBYURLSMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DELETEMEDIACONTENTBYURLSMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_EDITMETADATABYMEDIAOBJECTTAGMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_EDITMETADATABYMEDIAOBJECTTAGMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_EDITMETADATABYMEDIAOBJECTURLMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_EDITMETADATABYMEDIAOBJECTURLMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_STARTRIPPINGMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgStartRippingMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_STARTRIPPINGMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgStartRippingMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_STOPRIPPINGMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgStopRippingMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_STOPRIPPINGMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgStopRippingMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_EXTRACTGRACENOTEMETADATAMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_EXTRACTGRACENOTEMETADATAMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CREATEINTERNALFILENAMEPLAYLISTMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CREATEINTERNALFILENAMEPLAYLISTMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_ADDFILENAMETOINTERNALPLAYLISTMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_ADDFILENAMETOINTERNALPLAYLISTMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DELETEENTRYFROMPLAYLISTMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DELETEENTRYFROMPLAYLISTMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_RENAMEINTERNALPLAYLISTMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_RENAMEINTERNALPLAYLISTMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DELETEINTERNALPLAYLISTMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DELETEINTERNALPLAYLISTMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERINTERNALPLAYLISTLISTMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERINTERNALPLAYLISTLISTMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERINTERNALPLAYLISTLISTSLICEMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERINTERNALPLAYLISTLISTSLICEMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_GETLISTPOSITIONOFOBJECTMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_GETLISTPOSITIONOFOBJECTMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERFILELISTEXTMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERFILELISTEXTMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_STARTSLIDESHOWMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgStartSlideshowMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_STARTSLIDESHOWMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgStartSlideshowMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTSLIDESHOWACTIONMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTSLIDESHOWACTIONMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_QUICKSEARCHMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgQuicksearchMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_QUICKSEARCHMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgQuicksearchMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_EJECTOPTICALDISCMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_EJECTOPTICALDISCMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERINDEXEDIMAGEFOLDERLISTMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERINDEXEDIMAGEFOLDERLISTMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERINDEXEDIMAGEFOLDERLISTSLICEMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERINDEXEDIMAGEFOLDERLISTSLICEMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERCDLISTMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERCDLISTMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERFOLDERINFOMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERFOLDERINFOMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SETFILEPERMISSIONBYMEDIAOBJECTTAGSMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SETFILEPERMISSIONBYMEDIAOBJECTTAGSMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_ADDFILENAMETOINTERNALPLAYLISTBYTAGSMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_ADDFILENAMETOINTERNALPLAYLISTBYTAGSMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_STOREPERSONALIZEDFAVORITEMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_STOREPERSONALIZEDFAVORITEMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DELETEPERSONALIZEDFAVORITEMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DELETEPERSONALIZEDFAVORITEMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERGLOBALSEARCHLISTMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERGLOBALSEARCHLISTMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERALBUMARTLISTMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERALBUMARTLISTMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERALBUMARTLISTSLICEMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERALBUMARTLISTSLICEMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SENDAPPLEHIDCOMMANDMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SENDAPPLEHIDCOMMANDMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTBLUETOOTHAUDIODEVICEMETHODSTART:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodStart;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTBLUETOOTHAUDIODEVICEMETHODRESULT:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodResult;

      case mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYERLISTCHANGEUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgMediaPlayerListChangeUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYERLISTCHANGERELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgMediaPlayerListChangeRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYERLISTCHANGESTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgMediaPlayerListChangeStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_NOWPLAYINGUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgNowPlayingUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_NOWPLAYINGRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgNowPlayingRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_NOWPLAYINGGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgNowPlayingGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_NOWPLAYINGSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgNowPlayingStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYTIMEUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlaytimeUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYTIMERELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlaytimeRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYTIMEGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlaytimeGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYTIMESTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlaytimeStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKSTATEUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlaybackStateUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKSTATERELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlaybackStateRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKSTATEGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlaybackStateGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKSTATESTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlaybackStateStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKMODEUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlaybackModeUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKMODERELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlaybackModeRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKMODEGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlaybackModeGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKMODESET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlaybackModeSet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKMODESTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlaybackModeStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REPEATMODEUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRepeatModeUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REPEATMODERELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRepeatModeRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REPEATMODEGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRepeatModeGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REPEATMODESET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRepeatModeSet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_REPEATMODESTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRepeatModeStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_INDEXINGSTATEUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgIndexingStateUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_INDEXINGSTATERELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgIndexingStateRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_INDEXINGSTATEGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgIndexingStateGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_INDEXINGSTATESTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgIndexingStateStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYERDEVICECONNECTIONSUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYERDEVICECONNECTIONSRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYERDEVICECONNECTIONSGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYERDEVICECONNECTIONSSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_ACTIVEMEDIADEVICEUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgActiveMediaDeviceUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_ACTIVEMEDIADEVICERELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgActiveMediaDeviceRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_ACTIVEMEDIADEVICEGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgActiveMediaDeviceGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_ACTIVEMEDIADEVICESET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgActiveMediaDeviceSet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_ACTIVEMEDIADEVICESTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgActiveMediaDeviceStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_MYMEDIASUPPORTEDGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgMyMediaSupportedGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_MYMEDIASUPPORTEDSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgMyMediaSupportedStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CURRENTFOLDERPATHUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCurrentFolderPathUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CURRENTFOLDERPATHRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCurrentFolderPathRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CURRENTFOLDERPATHGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCurrentFolderPathGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CURRENTFOLDERPATHSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCurrentFolderPathStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SCANMODEUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgScanModeUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SCANMODERELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgScanModeRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SCANMODEGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgScanModeGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SCANMODESET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgScanModeSet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SCANMODESTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgScanModeStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DISCERRORUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDiscErrorUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DISCERRORRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDiscErrorRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DISCERRORGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDiscErrorGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DISCERRORSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDiscErrorStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DISCMECHANICALINFOUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDiscMechanicalInfoUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DISCMECHANICALINFORELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDiscMechanicalInfoRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DISCMECHANICALINFOGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDiscMechanicalInfoGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DISCMECHANICALINFOSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDiscMechanicalInfoStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CMSKIPAVAILABLEUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCMSkipAvailableUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CMSKIPAVAILABLERELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCMSkipAvailableRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CMSKIPAVAILABLEGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCMSkipAvailableGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_CMSKIPAVAILABLESTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgCMSkipAvailableStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DIRECTSELECTAVAILABLEUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDirectSelectAvailableUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DIRECTSELECTAVAILABLERELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDirectSelectAvailableRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DIRECTSELECTAVAILABLEGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDirectSelectAvailableGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DIRECTSELECTAVAILABLESTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDirectSelectAvailableStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDANGLEINFOUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDAngleInfoUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDANGLEINFORELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDAngleInfoRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDANGLEINFOGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDAngleInfoGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDANGLEINFOSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDAngleInfoStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDSUBTITLEINFOUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDSubtitleInfoUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDSUBTITLEINFORELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDSubtitleInfoRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDSUBTITLEINFOGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDSubtitleInfoGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDSUBTITLEINFOSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDSubtitleInfoStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDAUDIOCHANNELINFOUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDAUDIOCHANNELINFORELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDAUDIOCHANNELINFOGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDAUDIOCHANNELINFOSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDCURRENTAUDIOINFOUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDCURRENTAUDIOINFORELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDCURRENTAUDIOINFOGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDCURRENTAUDIOINFOSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DISPLAYMODEUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDisplayModeUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DISPLAYMODERELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDisplayModeRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DISPLAYMODESET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDisplayModeSet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DISPLAYMODEGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDisplayModeGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DISPLAYMODESTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDisplayModeStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDPLAYERLANGSETTINGUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDPLAYERLANGSETTINGRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDPLAYERLANGSETTINGSET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingSet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDPLAYERLANGSETTINGGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDPLAYERLANGSETTINGSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_ANGLEMARKSETTINGUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgAngleMarkSettingUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_ANGLEMARKSETTINGRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgAngleMarkSettingRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_ANGLEMARKSETTINGSET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgAngleMarkSettingSet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_ANGLEMARKSETTINGGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgAngleMarkSettingGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_ANGLEMARKSETTINGSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgAngleMarkSettingStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYSTATUSSETTINGUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlayStatusSettingUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYSTATUSSETTINGRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlayStatusSettingRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYSTATUSSETTINGSET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlayStatusSettingSet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYSTATUSSETTINGGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlayStatusSettingGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYSTATUSSETTINGSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlayStatusSettingStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DRCSETTINGUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDRCSettingUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DRCSETTINGRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDRCSettingRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DRCSETTINGSET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDRCSettingSet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DRCSETTINGGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDRCSettingGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DRCSETTINGSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDRCSettingStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDCOMMANDSTATUSUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDCommandStatusUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDCOMMANDSTATUSRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDCommandStatusRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDCOMMANDSTATUSSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDCommandStatusStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_AUTORIPPINGUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgAutoRippingUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_AUTORIPPINGRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgAutoRippingRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_AUTORIPPINGGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgAutoRippingGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_AUTORIPPINGSET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgAutoRippingSet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_AUTORIPPINGSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgAutoRippingStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_GRACENOTELOOKUPMODEUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgGracenoteLookupModeUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_GRACENOTELOOKUPMODERELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgGracenoteLookupModeRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_GRACENOTELOOKUPMODEGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgGracenoteLookupModeGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_GRACENOTELOOKUPMODESET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgGracenoteLookupModeSet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_GRACENOTELOOKUPMODESTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgGracenoteLookupModeStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_GRACENOTEVERSIONUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgGracenoteVersionUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_GRACENOTEVERSIONRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgGracenoteVersionRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_GRACENOTEVERSIONGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgGracenoteVersionGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_GRACENOTEVERSIONSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgGracenoteVersionStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_RIPPINGERRORSUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRippingErrorsUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_RIPPINGERRORSRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRippingErrorsRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_RIPPINGERRORSGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRippingErrorsGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_RIPPINGERRORSSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRippingErrorsStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_RESOLVEGRACENOTEAMBUIGUITIESUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_RESOLVEGRACENOTEAMBUIGUITIESRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_RESOLVEGRACENOTEAMBUIGUITIESGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_RESOLVEGRACENOTEAMBUIGUITIESSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDMENUPLAYBACKONGOINGGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDMENUPLAYBACKONGOINGRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDMENUPLAYBACKONGOINGSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDMENUPLAYBACKONGOINGUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDDRIVEINFOGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDDriveInfoGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDDRIVEINFORELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDDriveInfoRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDDRIVEINFOSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDDriveInfoStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DVDDRIVEINFOUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDVDDriveInfoUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_RIPPINGSTATEUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRippingStateUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_RIPPINGSTATERELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRippingStateRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_RIPPINGSTATEGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRippingStateGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_RIPPINGSTATESTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRippingStateStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_RIPPINGENCODINGQUALITYUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRippingEncodingQualityUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_RIPPINGENCODINGQUALITYRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRippingEncodingQualityRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_RIPPINGENCODINGQUALITYGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRippingEncodingQualityGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_RIPPINGENCODINGQUALITYSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRippingEncodingQualityStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_RIPPINGENCODINGQUALITYSET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgRippingEncodingQualitySet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_GNMETADATAEXTRACTIONSTATUSGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_GNMETADATAEXTRACTIONSTATUSRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_GNMETADATAEXTRACTIONSTATUSSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_GNMETADATAEXTRACTIONSTATUSUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_LANGUAGEUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgLanguageUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_LANGUAGERELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgLanguageRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_LANGUAGEGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgLanguageGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_LANGUAGESET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgLanguageSet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_LANGUAGESTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgLanguageStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKREPEATMODEUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlaybackRepeatModeUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKREPEATMODERELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlaybackRepeatModeRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKREPEATMODEGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlaybackRepeatModeGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKREPEATMODESET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlaybackRepeatModeSet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKREPEATMODESTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgPlaybackRepeatModeStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SLIDESHOWTIMEUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgSlideshowTimeUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SLIDESHOWTIMERELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgSlideshowTimeRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SLIDESHOWTIMEGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgSlideshowTimeGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SLIDESHOWTIMESET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgSlideshowTimeSet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SLIDESHOWTIMESTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgSlideshowTimeStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_NOWSHOWINGUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgNowShowingUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_NOWSHOWINGRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgNowShowingRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_NOWSHOWINGGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgNowShowingGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_NOWSHOWINGSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgNowShowingStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SLIDESHOWSTATEUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgSlideshowStateUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SLIDESHOWSTATERELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgSlideshowStateRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SLIDESHOWSTATEGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgSlideshowStateGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_SLIDESHOWSTATESTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgSlideshowStateStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYEROPTICALDISCSLOTSTATEUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYEROPTICALDISCSLOTSTATERELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYEROPTICALDISCSLOTSTATEGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYEROPTICALDISCSLOTSTATESTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYEROPTICALDISCCDINFOUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYEROPTICALDISCCDINFORELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYEROPTICALDISCCDINFOGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYEROPTICALDISCCDINFOSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_IPODCOMMUNICATIONERRORUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgiPodCommunicationErrorUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_IPODCOMMUNICATIONERRORRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgiPodCommunicationErrorRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_IPODCOMMUNICATIONERRORGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgiPodCommunicationErrorGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_IPODCOMMUNICATIONERRORSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgiPodCommunicationErrorStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DEVICESTREAMINGINFOGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDeviceStreamingInfoGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DEVICESTREAMINGINFORELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDeviceStreamingInfoRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DEVICESTREAMINGINFOSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDeviceStreamingInfoStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_DEVICESTREAMINGINFOUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgDeviceStreamingInfoUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOBRIGHTNESSUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoBrightnessUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOBRIGHTNESSRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoBrightnessRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOBRIGHTNESSGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoBrightnessGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOBRIGHTNESSSET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoBrightnessSet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOBRIGHTNESSSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoBrightnessStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOHUEUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoHueUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOHUERELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoHueRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOHUEGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoHueGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOHUESET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoHueSet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOHUESTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoHueStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSATURATIONUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoSaturationUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSATURATIONRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoSaturationRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSATURATIONGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoSaturationGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSATURATIONSET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoSaturationSet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSATURATIONSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoSaturationStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOCONTRASTUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoContrastUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOCONTRASTRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoContrastRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOCONTRASTGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoContrastGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOCONTRASTSET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoContrastSet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOCONTRASTSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoContrastStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOBRIGHTNESSOFFSETUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOBRIGHTNESSOFFSETRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOBRIGHTNESSOFFSETGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOBRIGHTNESSOFFSETSET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetSet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOBRIGHTNESSOFFSETSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOHUEOFFSETUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoHueOffsetUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOHUEOFFSETRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoHueOffsetRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOHUEOFFSETGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoHueOffsetGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOHUEOFFSETSET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoHueOffsetSet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOHUEOFFSETSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoHueOffsetStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSATURATIONOFFSETUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoSaturationOffsetUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSATURATIONOFFSETRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoSaturationOffsetRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSATURATIONOFFSETGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoSaturationOffsetGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSATURATIONOFFSETSET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoSaturationOffsetSet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSATURATIONOFFSETSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoSaturationOffsetStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSCALINGUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoScalingUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSCALINGRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoScalingRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSCALINGGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoScalingGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSCALINGSET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoScalingSet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSCALINGSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgVideoScalingStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_UPDATEPLAYBACKSPEEDGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_UPDATEPLAYBACKSPEEDRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_UPDATEPLAYBACKSPEEDSET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedSet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_UPDATEPLAYBACKSPEEDSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_UPDATEPLAYBACKSPEEDUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_USERFAVORITESCHANGEDUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgUserFavoritesChangedUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_USERFAVORITESCHANGEDRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgUserFavoritesChangedRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_USERFAVORITESCHANGEDSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgUserFavoritesChangedStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_FOLDERBROWSESTRUCTURECLEAREDUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_FOLDERBROWSESTRUCTURECLEAREDRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_FOLDERBROWSESTRUCTURECLEAREDSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_READYTOPLAYUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgReadyToPlayUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_READYTOPLAYRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgReadyToPlayRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_READYTOPLAYGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgReadyToPlayGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_READYTOPLAYSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgReadyToPlayStatus;

      case mplay_mediaplayerfi_tclToken::EN_MSG_BLUETOOTHAUDIODEVICESTATUSUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_BLUETOOTHAUDIODEVICESTATUSRELUPREG:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusRelUpReg;

      case mplay_mediaplayerfi_tclToken::EN_MSG_BLUETOOTHAUDIODEVICESTATUSGET:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusGet;

      case mplay_mediaplayerfi_tclToken::EN_MSG_BLUETOOTHAUDIODEVICESTATUSSTATUS:
         return OSAL_NEW mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all mplay_mediaplayerfifi messages

// common functions

tU16 mplay_mediaplayerfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MPLAY_MEDIAPLAYERFI_C_U16_SERVICE_ID;
}

tU16 mplay_mediaplayerfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 mplay_mediaplayerfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& mplay_mediaplayerfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& mplay_mediaplayerfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 mplay_mediaplayerfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart::mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8ListType = coRef.e8ListType;
   u32FilterTag1 = coRef.u32FilterTag1;
   u32FilterTag2 = coRef.u32FilterTag2;
   u32FilterTag3 = coRef.u32FilterTag3;
   u32FilterTag4 = coRef.u32FilterTag4;
   bAutoPlay = coRef.bAutoPlay;
   u8DeviceTag = coRef.u8DeviceTag;
}
mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart& mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart::operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8ListType = coRef.e8ListType;
   u32FilterTag1 = coRef.u32FilterTag1;
   u32FilterTag2 = coRef.u32FilterTag2;
   u32FilterTag3 = coRef.u32FilterTag3;
   u32FilterTag4 = coRef.u32FilterTag4;
   bAutoPlay = coRef.bAutoPlay;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart::mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart()
:e8ListType()
,u32FilterTag1(0)
,u32FilterTag2(0)
,u32FilterTag3(0)
,u32FilterTag4(0)
,bAutoPlay(0)
,u8DeviceTag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERQUICKPLAYLISTMETHODSTART;
}


mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart::~mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 19;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ListType);
   (tVoid) (oIn >> u32FilterTag1);
   (tVoid) (oIn >> u32FilterTag2);
   (tVoid) (oIn >> u32FilterTag3);
   (tVoid) (oIn >> u32FilterTag4);
   (tVoid) (oIn >> bAutoPlay);
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ListType);
   (tVoid) (oOut << u32FilterTag1);
   (tVoid) (oOut << u32FilterTag2);
   (tVoid) (oOut << u32FilterTag3);
   (tVoid) (oOut << u32FilterTag4);
   (tVoid) (oOut << bAutoPlay);
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart::operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ListType == roRef.e8ListType);
   bResult = bResult && (u32FilterTag1 == roRef.u32FilterTag1);
   bResult = bResult && (u32FilterTag2 == roRef.u32FilterTag2);
   bResult = bResult && (u32FilterTag3 == roRef.u32FilterTag3);
   bResult = bResult && (u32FilterTag4 == roRef.u32FilterTag4);
   bResult = bResult && (bAutoPlay == roRef.bAutoPlay);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult::mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   u8DeviceTag = coRef.u8DeviceTag;
}
mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult& mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult::operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult::mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult()
:u32ListHandle(0)
,u32ListSize(0)
,u8DeviceTag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERQUICKPLAYLISTMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult::~mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32ListSize);
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32ListSize);
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult::operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerQuickPlayListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32ListSize == roRef.u32ListSize);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodStart::mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodStart(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8ListType = coRef.e8ListType;
   u32FilterTag1 = coRef.u32FilterTag1;
   u32FilterTag2 = coRef.u32FilterTag2;
   u32FilterTag3 = coRef.u32FilterTag3;
   u8DeviceTag = coRef.u8DeviceTag;
   u8UserID = coRef.u8UserID;
}
mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodStart& mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodStart::operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8ListType = coRef.e8ListType;
   u32FilterTag1 = coRef.u32FilterTag1;
   u32FilterTag2 = coRef.u32FilterTag2;
   u32FilterTag3 = coRef.u32FilterTag3;
   u8DeviceTag = coRef.u8DeviceTag;
   u8UserID = coRef.u8UserID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodStart::mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodStart()
:e8ListType()
,u32FilterTag1(0)
,u32FilterTag2(0)
,u32FilterTag3(0)
,u8DeviceTag(0)
,u8UserID(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERINDEXEDLISTMETHODSTART;
}


mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodStart::~mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 15;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ListType);
   (tVoid) (oIn >> u32FilterTag1);
   (tVoid) (oIn >> u32FilterTag2);
   (tVoid) (oIn >> u32FilterTag3);
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> u8UserID);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ListType);
   (tVoid) (oOut << u32FilterTag1);
   (tVoid) (oOut << u32FilterTag2);
   (tVoid) (oOut << u32FilterTag3);
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << u8UserID);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodStart::operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ListType == roRef.e8ListType);
   bResult = bResult && (u32FilterTag1 == roRef.u32FilterTag1);
   bResult = bResult && (u32FilterTag2 == roRef.u32FilterTag2);
   bResult = bResult && (u32FilterTag3 == roRef.u32FilterTag3);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (u8UserID == roRef.u8UserID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodResult::mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodResult(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   u8DeviceTag = coRef.u8DeviceTag;
}
mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodResult& mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodResult::operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodResult::mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodResult()
:u32ListHandle(0)
,u32ListSize(0)
,u8DeviceTag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERINDEXEDLISTMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodResult::~mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32ListSize);
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32ListSize);
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodResult::operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32ListSize == roRef.u32ListSize);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart::mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u16WindowSize = coRef.u16WindowSize;
   DeviceTag = coRef.DeviceTag;
}
mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart& mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart::operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u16WindowSize = coRef.u16WindowSize;
   DeviceTag = coRef.DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart::mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart()
:u32ListHandle(0)
,u32WindowStart(0)
,u16WindowSize(0)
,DeviceTag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERINDEXEDLISTSLICEMETHODSTART;
}


mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart::~mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32WindowStart);
   (tVoid) (oIn >> u16WindowSize);
   (tVoid) (oIn >> DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32WindowStart);
   (tVoid) (oOut << u16WindowSize);
   (tVoid) (oOut << DeviceTag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart::operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32WindowStart == roRef.u32WindowStart);
   bResult = bResult && (u16WindowSize == roRef.u16WindowSize);
   bResult = bResult && (DeviceTag == roRef.DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult::mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   oMediaObjects = coRef.oMediaObjects;
}
mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult& mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult::operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oMediaObjects = coRef.oMediaObjects;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult::vDestroy()
{
   oMediaObjects.vDestroy(); 
}

mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult::mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult()
:oMediaObjects()
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERINDEXEDLISTSLICEMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult::~mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+oMediaObjects.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oMediaObjects);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oMediaObjects);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult::operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oMediaObjects == roRef.oMediaObjects);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodStart::mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodStart(const mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
}
mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodStart& mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodStart::operator=(const mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodStart::mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodStart()
:u32ListHandle(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_RELEASEMEDIAPLAYERLISTMETHODSTART;
}


mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodStart::~mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodStart::operator==(const mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodResult::mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_RELEASEMEDIAPLAYERLISTMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodResult::~mplay_mediaplayerfi_tclMsgReleaseMediaPlayerListMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodStart::mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodStart(const mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8Action = coRef.e8Action;
   u8NextPrevSkipCount = coRef.u8NextPrevSkipCount;
}
mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodStart& mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodStart::operator=(const mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8Action = coRef.e8Action;
   u8NextPrevSkipCount = coRef.u8NextPrevSkipCount;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodStart::mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodStart()
:e8Action()
,u8NextPrevSkipCount(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTPLAYBACKACTIONMETHODSTART;
}


mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodStart::~mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Action);
   (tVoid) (oIn >> u8NextPrevSkipCount);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Action);
   (tVoid) (oOut << u8NextPrevSkipCount);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodStart::operator==(const mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Action == roRef.e8Action);
   bResult = bResult && (u8NextPrevSkipCount == roRef.u8NextPrevSkipCount);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodResult::mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTPLAYBACKACTIONMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodResult::~mplay_mediaplayerfi_tclMsgRequestPlaybackActionMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgSeekToMethodStart::mplay_mediaplayerfi_tclMsgSeekToMethodStart(const mplay_mediaplayerfi_tclMsgSeekToMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32PlaypointPosition = coRef.u32PlaypointPosition;
   e8PlaypointFormat = coRef.e8PlaypointFormat;
}
mplay_mediaplayerfi_tclMsgSeekToMethodStart& mplay_mediaplayerfi_tclMsgSeekToMethodStart::operator=(const mplay_mediaplayerfi_tclMsgSeekToMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32PlaypointPosition = coRef.u32PlaypointPosition;
   e8PlaypointFormat = coRef.e8PlaypointFormat;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgSeekToMethodStart::mplay_mediaplayerfi_tclMsgSeekToMethodStart()
:u32PlaypointPosition(0)
,e8PlaypointFormat()
 {}

tS32 mplay_mediaplayerfi_tclMsgSeekToMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SEEKTOMETHODSTART;
}


mplay_mediaplayerfi_tclMsgSeekToMethodStart::~mplay_mediaplayerfi_tclMsgSeekToMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgSeekToMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgSeekToMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32PlaypointPosition);
   (tVoid) (oIn >> e8PlaypointFormat);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgSeekToMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32PlaypointPosition);
   (tVoid) (oOut << e8PlaypointFormat);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgSeekToMethodStart::operator==(const mplay_mediaplayerfi_tclMsgSeekToMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32PlaypointPosition == roRef.u32PlaypointPosition);
   bResult = bResult && (e8PlaypointFormat == roRef.e8PlaypointFormat);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgSeekToMethodResult::mplay_mediaplayerfi_tclMsgSeekToMethodResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgSeekToMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SEEKTOMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgSeekToMethodResult::~mplay_mediaplayerfi_tclMsgSeekToMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodStart::mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodStart(const mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   sAlbumArt = coRef.sAlbumArt;
   u32SizeX = coRef.u32SizeX;
   u32SizeY = coRef.u32SizeY;
}
mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodStart& mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodStart::operator=(const mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sAlbumArt = coRef.sAlbumArt;
   u32SizeX = coRef.u32SizeX;
   u32SizeY = coRef.u32SizeY;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodStart::vDestroy()
{
   sAlbumArt.vDestroy();
}

mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodStart::mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodStart()
:sAlbumArt()
,u32SizeX(0)
,u32SizeY(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_GETMEDIAOBJECTALBUMARTMETHODSTART;
}


mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodStart::~mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+sAlbumArt.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sAlbumArt);
   (tVoid) (oIn >> u32SizeX);
   (tVoid) (oIn >> u32SizeY);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sAlbumArt);
   (tVoid) (oOut << u32SizeX);
   (tVoid) (oOut << u32SizeY);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodStart::operator==(const mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sAlbumArt == roRef.sAlbumArt);
   bResult = bResult && (u32SizeX == roRef.u32SizeX);
   bResult = bResult && (u32SizeY == roRef.u32SizeY);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodResult::mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodResult(const mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   oImageData = coRef.oImageData;
}
mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodResult& mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodResult::operator=(const mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oImageData = coRef.oImageData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodResult::vDestroy()
{
   oImageData.vDestroy(); 
}

mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodResult::mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodResult()
:oImageData()
 {}

tS32 mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_GETMEDIAOBJECTALBUMARTMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodResult::~mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+oImageData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oImageData);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oImageData);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodResult::operator==(const mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oImageData == roRef.oImageData);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodStart::mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodStart(const mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
}
mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodStart& mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodStart::operator=(const mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodStart::mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodStart()
:u32ListHandle(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SEARCHKEYBOARDMEDIAPLAYERLISTMETHODSTART;
}


mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodStart::~mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodStart::operator==(const mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodResult::mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodResult(const mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   oSearchKeyboardList = coRef.oSearchKeyboardList;
}
mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodResult& mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodResult::operator=(const mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   oSearchKeyboardList = coRef.oSearchKeyboardList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodResult::vDestroy()
{
   oSearchKeyboardList.vDestroy(); 
}

mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodResult::mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodResult()
:u32ListHandle(0)
,oSearchKeyboardList()
 {}

tS32 mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SEARCHKEYBOARDMEDIAPLAYERLISTMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodResult::~mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+oSearchKeyboardList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> oSearchKeyboardList);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << oSearchKeyboardList);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodResult::operator==(const mplay_mediaplayerfi_tclMsgSearchKeyboardMediaPlayerListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (oSearchKeyboardList == roRef.oSearchKeyboardList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodStart::mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodStart(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandleOfParent = coRef.u32ListHandleOfParent;
   u32ListHandleOfReplaceableList = coRef.u32ListHandleOfReplaceableList;
   sSearchString = coRef.sSearchString;
}
mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodStart& mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodStart::operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandleOfParent = coRef.u32ListHandleOfParent;
   u32ListHandleOfReplaceableList = coRef.u32ListHandleOfReplaceableList;
   sSearchString = coRef.sSearchString;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodStart::vDestroy()
{
   sSearchString.vDestroy();
}

mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodStart::mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodStart()
:u32ListHandleOfParent(0)
,u32ListHandleOfReplaceableList(0)
,sSearchString()
 {}

tS32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERLISTSEARCHSTRINGMETHODSTART;
}


mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodStart::~mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+sSearchString.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandleOfParent);
   (tVoid) (oIn >> u32ListHandleOfReplaceableList);
   (tVoid) (oIn >> sSearchString);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandleOfParent);
   (tVoid) (oOut << u32ListHandleOfReplaceableList);
   (tVoid) (oOut << sSearchString);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodStart::operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandleOfParent == roRef.u32ListHandleOfParent);
   bResult = bResult && (u32ListHandleOfReplaceableList == roRef.u32ListHandleOfReplaceableList);
   bResult = bResult && (sSearchString == roRef.sSearchString);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultFirst::mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultFirst(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultFirst& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   u8DeviceTag = coRef.u8DeviceTag;
}
mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultFirst& mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultFirst::operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultFirst& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultFirst::mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultFirst()
:u32ListHandle(0)
,u32ListSize(0)
,u8DeviceTag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultFirst::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERLISTSEARCHSTRINGMETHODRESULTFIRST;
}


mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultFirst::~mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultFirst()
{}

tU32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultFirst::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultFirst::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32ListSize);
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultFirst::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32ListSize);
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultFirst::operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultFirst& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32ListSize == roRef.u32ListSize);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultMiddle::mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultMiddle(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultMiddle& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   u8DeviceTag = coRef.u8DeviceTag;
}
mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultMiddle& mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultMiddle::operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultMiddle& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultMiddle::mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultMiddle()
:u32ListHandle(0)
,u32ListSize(0)
,u8DeviceTag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultMiddle::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERLISTSEARCHSTRINGMETHODRESULTMIDDLE;
}


mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultMiddle::~mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultMiddle()
{}

tU32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultMiddle::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultMiddle::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32ListSize);
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultMiddle::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32ListSize);
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultMiddle::operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultMiddle& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32ListSize == roRef.u32ListSize);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultLast::mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultLast(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultLast& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   u8DeviceTag = coRef.u8DeviceTag;
}
mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultLast& mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultLast::operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultLast& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultLast::mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultLast()
:u32ListHandle(0)
,u32ListSize(0)
,u8DeviceTag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultLast::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERLISTSEARCHSTRINGMETHODRESULTLAST;
}


mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultLast::~mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultLast()
{}

tU32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultLast::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultLast::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32ListSize);
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultLast::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32ListSize);
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultLast::operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodResultLast& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32ListSize == roRef.u32ListSize);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodAbort::mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodAbort(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodAbort& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   u8DeviceTag = coRef.u8DeviceTag;
}
mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodAbort& mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodAbort::operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodAbort& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodAbort::mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodAbort()
:u32ListHandle(0)
,u32ListSize(0)
,u8DeviceTag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodAbort::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERLISTSEARCHSTRINGMETHODABORT;
}


mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodAbort::~mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodAbort()
{}

tU32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodAbort::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodAbort::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32ListSize);
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodAbort::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32ListSize);
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodAbort::operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerListSearchStringMethodAbort& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32ListSize == roRef.u32ListSize);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgGetMediaObjectMethodStart::mplay_mediaplayerfi_tclMsgGetMediaObjectMethodStart(const mplay_mediaplayerfi_tclMsgGetMediaObjectMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32Tag = coRef.u32Tag;
   e8CategoryType = coRef.e8CategoryType;
}
mplay_mediaplayerfi_tclMsgGetMediaObjectMethodStart& mplay_mediaplayerfi_tclMsgGetMediaObjectMethodStart::operator=(const mplay_mediaplayerfi_tclMsgGetMediaObjectMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32Tag = coRef.u32Tag;
   e8CategoryType = coRef.e8CategoryType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgGetMediaObjectMethodStart::mplay_mediaplayerfi_tclMsgGetMediaObjectMethodStart()
:u32Tag(0)
,e8CategoryType()
 {}

tS32 mplay_mediaplayerfi_tclMsgGetMediaObjectMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_GETMEDIAOBJECTMETHODSTART;
}


mplay_mediaplayerfi_tclMsgGetMediaObjectMethodStart::~mplay_mediaplayerfi_tclMsgGetMediaObjectMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgGetMediaObjectMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgGetMediaObjectMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Tag);
   (tVoid) (oIn >> e8CategoryType);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgGetMediaObjectMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Tag);
   (tVoid) (oOut << e8CategoryType);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgGetMediaObjectMethodStart::operator==(const mplay_mediaplayerfi_tclMsgGetMediaObjectMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Tag == roRef.u32Tag);
   bResult = bResult && (e8CategoryType == roRef.e8CategoryType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgGetMediaObjectMethodResult::mplay_mediaplayerfi_tclMsgGetMediaObjectMethodResult(const mplay_mediaplayerfi_tclMsgGetMediaObjectMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   oMediaObject = coRef.oMediaObject;
}
mplay_mediaplayerfi_tclMsgGetMediaObjectMethodResult& mplay_mediaplayerfi_tclMsgGetMediaObjectMethodResult::operator=(const mplay_mediaplayerfi_tclMsgGetMediaObjectMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oMediaObject = coRef.oMediaObject;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgGetMediaObjectMethodResult::vDestroy()
{
   oMediaObject.vDestroy(); 
}

mplay_mediaplayerfi_tclMsgGetMediaObjectMethodResult::mplay_mediaplayerfi_tclMsgGetMediaObjectMethodResult()
:oMediaObject()
 {}

tS32 mplay_mediaplayerfi_tclMsgGetMediaObjectMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_GETMEDIAOBJECTMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgGetMediaObjectMethodResult::~mplay_mediaplayerfi_tclMsgGetMediaObjectMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgGetMediaObjectMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+oMediaObject.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgGetMediaObjectMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oMediaObject);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgGetMediaObjectMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oMediaObject);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgGetMediaObjectMethodResult::operator==(const mplay_mediaplayerfi_tclMsgGetMediaObjectMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oMediaObject == roRef.oMediaObject);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodStart::mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodStart(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   sPath = coRef.sPath;
   u8DeviceTag = coRef.u8DeviceTag;
   e8MPlayFileTypeSelection = coRef.e8MPlayFileTypeSelection;
   Tag = coRef.Tag;
}
mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodStart& mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodStart::operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sPath = coRef.sPath;
   u8DeviceTag = coRef.u8DeviceTag;
   e8MPlayFileTypeSelection = coRef.e8MPlayFileTypeSelection;
   Tag = coRef.Tag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodStart::vDestroy()
{
   sPath.vDestroy();
}

mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodStart::mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodStart()
:sPath()
,u8DeviceTag(0)
,e8MPlayFileTypeSelection()
,Tag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERFILELISTMETHODSTART;
}


mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodStart::~mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 10+sPath.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sPath);
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> e8MPlayFileTypeSelection);
   (tVoid) (oIn >> Tag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sPath);
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << e8MPlayFileTypeSelection);
   (tVoid) (oOut << Tag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodStart::operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sPath == roRef.sPath);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (e8MPlayFileTypeSelection == roRef.e8MPlayFileTypeSelection);
   bResult = bResult && (Tag == roRef.Tag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodResult::mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodResult(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   u8DeviceTag = coRef.u8DeviceTag;
   u32TotalNumFiles = coRef.u32TotalNumFiles;
   u32TotalNumFolders = coRef.u32TotalNumFolders;
   u32TotalNumMediaObjects = coRef.u32TotalNumMediaObjects;
   u32TotalNumPlaylists = coRef.u32TotalNumPlaylists;
}
mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodResult& mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodResult::operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   u8DeviceTag = coRef.u8DeviceTag;
   u32TotalNumFiles = coRef.u32TotalNumFiles;
   u32TotalNumFolders = coRef.u32TotalNumFolders;
   u32TotalNumMediaObjects = coRef.u32TotalNumMediaObjects;
   u32TotalNumPlaylists = coRef.u32TotalNumPlaylists;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodResult::mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodResult()
:u32ListHandle(0)
,u32ListSize(0)
,u8DeviceTag(0)
,u32TotalNumFiles(0)
,u32TotalNumFolders(0)
,u32TotalNumMediaObjects(0)
,u32TotalNumPlaylists(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERFILELISTMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodResult::~mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 25;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32ListSize);
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> u32TotalNumFiles);
   (tVoid) (oIn >> u32TotalNumFolders);
   (tVoid) (oIn >> u32TotalNumMediaObjects);
   (tVoid) (oIn >> u32TotalNumPlaylists);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32ListSize);
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << u32TotalNumFiles);
   (tVoid) (oOut << u32TotalNumFolders);
   (tVoid) (oOut << u32TotalNumMediaObjects);
   (tVoid) (oOut << u32TotalNumPlaylists);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodResult::operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32ListSize == roRef.u32ListSize);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (u32TotalNumFiles == roRef.u32TotalNumFiles);
   bResult = bResult && (u32TotalNumFolders == roRef.u32TotalNumFolders);
   bResult = bResult && (u32TotalNumMediaObjects == roRef.u32TotalNumMediaObjects);
   bResult = bResult && (u32TotalNumPlaylists == roRef.u32TotalNumPlaylists);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodStart::mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodStart(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u16WindowSize = coRef.u16WindowSize;
   DeviceTag = coRef.DeviceTag;
}
mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodStart& mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodStart::operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u16WindowSize = coRef.u16WindowSize;
   DeviceTag = coRef.DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodStart::mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodStart()
:u32ListHandle(0)
,u32WindowStart(0)
,u16WindowSize(0)
,DeviceTag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERFILELISTSLICEMETHODSTART;
}


mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodStart::~mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32WindowStart);
   (tVoid) (oIn >> u16WindowSize);
   (tVoid) (oIn >> DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32WindowStart);
   (tVoid) (oOut << u16WindowSize);
   (tVoid) (oOut << DeviceTag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodStart::operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32WindowStart == roRef.u32WindowStart);
   bResult = bResult && (u16WindowSize == roRef.u16WindowSize);
   bResult = bResult && (DeviceTag == roRef.DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodResult::mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodResult(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   oFileList = coRef.oFileList;
}
mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodResult& mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodResult::operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oFileList = coRef.oFileList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodResult::vDestroy()
{
   oFileList.vDestroy(); 
}

mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodResult::mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodResult()
:oFileList()
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERFILELISTSLICEMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodResult::~mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+oFileList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oFileList);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oFileList);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodResult::operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerFileListSliceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oFileList == roRef.oFileList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodStart::mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodStart(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   sFilename = coRef.sFilename;
   Tag = coRef.Tag;
   DeviceTag = coRef.DeviceTag;
}
mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodStart& mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodStart::operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sFilename = coRef.sFilename;
   Tag = coRef.Tag;
   DeviceTag = coRef.DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodStart::vDestroy()
{
   sFilename.vDestroy();
}

mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodStart::mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodStart()
:sFilename()
,Tag(0)
,DeviceTag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERPLAYLISTLISTMETHODSTART;
}


mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodStart::~mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 9+sFilename.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sFilename);
   (tVoid) (oIn >> Tag);
   (tVoid) (oIn >> DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sFilename);
   (tVoid) (oOut << Tag);
   (tVoid) (oOut << DeviceTag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodStart::operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sFilename == roRef.sFilename);
   bResult = bResult && (Tag == roRef.Tag);
   bResult = bResult && (DeviceTag == roRef.DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodResult::mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodResult(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
}
mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodResult& mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodResult::operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodResult::mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodResult()
:u32ListHandle(0)
,u32ListSize(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERPLAYLISTLISTMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodResult::~mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32ListSize);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32ListSize);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodResult::operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerPlaylistListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32ListSize == roRef.u32ListSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart::mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u16WindowSize = coRef.u16WindowSize;
   DeviceTag = coRef.DeviceTag;
}
mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart& mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart::operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u16WindowSize = coRef.u16WindowSize;
   DeviceTag = coRef.DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart::mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart()
:u32ListHandle(0)
,u32WindowStart(0)
,u16WindowSize(0)
,DeviceTag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERPLAYLISTLISTSLICEMETHODSTART;
}


mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart::~mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32WindowStart);
   (tVoid) (oIn >> u16WindowSize);
   (tVoid) (oIn >> DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32WindowStart);
   (tVoid) (oOut << u16WindowSize);
   (tVoid) (oOut << DeviceTag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart::operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32WindowStart == roRef.u32WindowStart);
   bResult = bResult && (u16WindowSize == roRef.u16WindowSize);
   bResult = bResult && (DeviceTag == roRef.DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult::mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   oFileList = coRef.oFileList;
}
mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult& mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult::operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oFileList = coRef.oFileList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult::vDestroy()
{
   oFileList.vDestroy(); 
}

mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult::mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult()
:oFileList()
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERPLAYLISTLISTSLICEMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult::~mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+oFileList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oFileList);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oFileList);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult::operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerPlaylistListSliceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oFileList == roRef.oFileList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart::mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u16WindowSize = coRef.u16WindowSize;
   DeviceTag = coRef.DeviceTag;
}
mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart& mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart::operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u16WindowSize = coRef.u16WindowSize;
   DeviceTag = coRef.DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart::mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart()
:u32ListHandle(0)
,u32WindowStart(0)
,u16WindowSize(0)
,DeviceTag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERQUICKPLAYLISTSLICEMETHODSTART;
}


mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart::~mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32WindowStart);
   (tVoid) (oIn >> u16WindowSize);
   (tVoid) (oIn >> DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32WindowStart);
   (tVoid) (oOut << u16WindowSize);
   (tVoid) (oOut << DeviceTag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart::operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32WindowStart == roRef.u32WindowStart);
   bResult = bResult && (u16WindowSize == roRef.u16WindowSize);
   bResult = bResult && (DeviceTag == roRef.DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult::mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   oMediaObjects = coRef.oMediaObjects;
}
mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult& mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult::operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oMediaObjects = coRef.oMediaObjects;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult::vDestroy()
{
   oMediaObjects.vDestroy(); 
}

mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult::mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult()
:oMediaObjects()
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERQUICKPLAYLISTSLICEMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult::~mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+oMediaObjects.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oMediaObjects);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oMediaObjects);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult::operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oMediaObjects == roRef.oMediaObjects);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart::mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart(const mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   sAlbumArt = coRef.sAlbumArt;
   u32SizeX = coRef.u32SizeX;
   u32SizeY = coRef.u32SizeY;
}
mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart& mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart::operator=(const mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sAlbumArt = coRef.sAlbumArt;
   u32SizeX = coRef.u32SizeX;
   u32SizeY = coRef.u32SizeY;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart::vDestroy()
{
   sAlbumArt.vDestroy();
}

mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart::mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart()
:sAlbumArt()
,u32SizeX(0)
,u32SizeY(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_GETMEDIAOBJECTALBUMARTINFOMETHODSTART;
}


mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart::~mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+sAlbumArt.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sAlbumArt);
   (tVoid) (oIn >> u32SizeX);
   (tVoid) (oIn >> u32SizeY);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sAlbumArt);
   (tVoid) (oOut << u32SizeX);
   (tVoid) (oOut << u32SizeY);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart::operator==(const mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sAlbumArt == roRef.sAlbumArt);
   bResult = bResult && (u32SizeX == roRef.u32SizeX);
   bResult = bResult && (u32SizeY == roRef.u32SizeY);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult::mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult(const mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   sMIMEImageSubtype = coRef.sMIMEImageSubtype;
   u32PhotoSize = coRef.u32PhotoSize;
}
mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult& mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult::operator=(const mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   sMIMEImageSubtype = coRef.sMIMEImageSubtype;
   u32PhotoSize = coRef.u32PhotoSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult::vDestroy()
{
   sMIMEImageSubtype.vDestroy();
}

mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult::mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult()
:sMIMEImageSubtype()
,u32PhotoSize(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_GETMEDIAOBJECTALBUMARTINFOMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult::~mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+sMIMEImageSubtype.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sMIMEImageSubtype);
   (tVoid) (oIn >> u32PhotoSize);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sMIMEImageSubtype);
   (tVoid) (oOut << u32PhotoSize);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult::operator==(const mplay_mediaplayerfi_tclMsgGetMediaObjectAlbumArtInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sMIMEImageSubtype == roRef.sMIMEImageSubtype);
   bResult = bResult && (u32PhotoSize == roRef.u32PhotoSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodStart::mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodStart(const mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32Tag = coRef.u32Tag;
   bAutoPlay = coRef.bAutoPlay;
}
mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodStart& mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodStart::operator=(const mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32Tag = coRef.u32Tag;
   bAutoPlay = coRef.bAutoPlay;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodStart::mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodStart()
:u32Tag(0)
,bAutoPlay(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYMEDIAPLAYEROBJECTMETHODSTART;
}


mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodStart::~mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Tag);
   (tVoid) (oIn >> bAutoPlay);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Tag);
   (tVoid) (oOut << bAutoPlay);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodStart::operator==(const mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Tag == roRef.u32Tag);
   bResult = bResult && (bAutoPlay == roRef.bAutoPlay);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodResult::mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodResult(const mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
}
mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodResult& mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodResult::operator=(const mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodResult::mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodResult()
:u32ListHandle(0)
,u32ListSize(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYMEDIAPLAYEROBJECTMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodResult::~mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32ListSize);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32ListSize);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodResult::operator==(const mplay_mediaplayerfi_tclMsgPlayMediaPlayerObjectMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32ListSize == roRef.u32ListSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgPlayItemFromListMethodStart::mplay_mediaplayerfi_tclMsgPlayItemFromListMethodStart(const mplay_mediaplayerfi_tclMsgPlayItemFromListMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32StartIndex = coRef.u32StartIndex;
   u32StartOffset = coRef.u32StartOffset;
}
mplay_mediaplayerfi_tclMsgPlayItemFromListMethodStart& mplay_mediaplayerfi_tclMsgPlayItemFromListMethodStart::operator=(const mplay_mediaplayerfi_tclMsgPlayItemFromListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32StartIndex = coRef.u32StartIndex;
   u32StartOffset = coRef.u32StartOffset;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgPlayItemFromListMethodStart::mplay_mediaplayerfi_tclMsgPlayItemFromListMethodStart()
:u32ListHandle(0)
,u32StartIndex(0)
,u32StartOffset(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgPlayItemFromListMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYITEMFROMLISTMETHODSTART;
}


mplay_mediaplayerfi_tclMsgPlayItemFromListMethodStart::~mplay_mediaplayerfi_tclMsgPlayItemFromListMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgPlayItemFromListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgPlayItemFromListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32StartIndex);
   (tVoid) (oIn >> u32StartOffset);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgPlayItemFromListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32StartIndex);
   (tVoid) (oOut << u32StartOffset);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgPlayItemFromListMethodStart::operator==(const mplay_mediaplayerfi_tclMsgPlayItemFromListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32StartIndex == roRef.u32StartIndex);
   bResult = bResult && (u32StartOffset == roRef.u32StartOffset);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgPlayItemFromListMethodResult::mplay_mediaplayerfi_tclMsgPlayItemFromListMethodResult(const mplay_mediaplayerfi_tclMsgPlayItemFromListMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
}
mplay_mediaplayerfi_tclMsgPlayItemFromListMethodResult& mplay_mediaplayerfi_tclMsgPlayItemFromListMethodResult::operator=(const mplay_mediaplayerfi_tclMsgPlayItemFromListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgPlayItemFromListMethodResult::mplay_mediaplayerfi_tclMsgPlayItemFromListMethodResult()
:u32ListHandle(0)
,u32ListSize(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgPlayItemFromListMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYITEMFROMLISTMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgPlayItemFromListMethodResult::~mplay_mediaplayerfi_tclMsgPlayItemFromListMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgPlayItemFromListMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgPlayItemFromListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32ListSize);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgPlayItemFromListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32ListSize);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgPlayItemFromListMethodResult::operator==(const mplay_mediaplayerfi_tclMsgPlayItemFromListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32ListSize == roRef.u32ListSize);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgClearMediaPlayerDataMethodStart::mplay_mediaplayerfi_tclMsgClearMediaPlayerDataMethodStart()
 {}

tS32 mplay_mediaplayerfi_tclMsgClearMediaPlayerDataMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CLEARMEDIAPLAYERDATAMETHODSTART;
}


mplay_mediaplayerfi_tclMsgClearMediaPlayerDataMethodStart::~mplay_mediaplayerfi_tclMsgClearMediaPlayerDataMethodStart()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgClearMediaPlayerDataMethodResult::mplay_mediaplayerfi_tclMsgClearMediaPlayerDataMethodResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgClearMediaPlayerDataMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CLEARMEDIAPLAYERDATAMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgClearMediaPlayerDataMethodResult::~mplay_mediaplayerfi_tclMsgClearMediaPlayerDataMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgUmountMethodStart::mplay_mediaplayerfi_tclMsgUmountMethodStart(const mplay_mediaplayerfi_tclMsgUmountMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u8DeviceTag = coRef.u8DeviceTag;
}
mplay_mediaplayerfi_tclMsgUmountMethodStart& mplay_mediaplayerfi_tclMsgUmountMethodStart::operator=(const mplay_mediaplayerfi_tclMsgUmountMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgUmountMethodStart::mplay_mediaplayerfi_tclMsgUmountMethodStart()
:u8DeviceTag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgUmountMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_UMOUNTMETHODSTART;
}


mplay_mediaplayerfi_tclMsgUmountMethodStart::~mplay_mediaplayerfi_tclMsgUmountMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgUmountMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgUmountMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgUmountMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgUmountMethodStart::operator==(const mplay_mediaplayerfi_tclMsgUmountMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgUmountMethodResult::mplay_mediaplayerfi_tclMsgUmountMethodResult(const mplay_mediaplayerfi_tclMsgUmountMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u8DeviceTag = coRef.u8DeviceTag;
   e8UmountResult = coRef.e8UmountResult;
}
mplay_mediaplayerfi_tclMsgUmountMethodResult& mplay_mediaplayerfi_tclMsgUmountMethodResult::operator=(const mplay_mediaplayerfi_tclMsgUmountMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceTag = coRef.u8DeviceTag;
   e8UmountResult = coRef.e8UmountResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgUmountMethodResult::mplay_mediaplayerfi_tclMsgUmountMethodResult()
:u8DeviceTag(0)
,e8UmountResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgUmountMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_UMOUNTMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgUmountMethodResult::~mplay_mediaplayerfi_tclMsgUmountMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgUmountMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgUmountMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> e8UmountResult);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgUmountMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << e8UmountResult);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgUmountMethodResult::operator==(const mplay_mediaplayerfi_tclMsgUmountMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (e8UmountResult == roRef.e8UmountResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgReindexingMethodStart::mplay_mediaplayerfi_tclMsgReindexingMethodStart(const mplay_mediaplayerfi_tclMsgReindexingMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u8DeviceTag = coRef.u8DeviceTag;
}
mplay_mediaplayerfi_tclMsgReindexingMethodStart& mplay_mediaplayerfi_tclMsgReindexingMethodStart::operator=(const mplay_mediaplayerfi_tclMsgReindexingMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgReindexingMethodStart::mplay_mediaplayerfi_tclMsgReindexingMethodStart()
:u8DeviceTag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgReindexingMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REINDEXINGMETHODSTART;
}


mplay_mediaplayerfi_tclMsgReindexingMethodStart::~mplay_mediaplayerfi_tclMsgReindexingMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgReindexingMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgReindexingMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgReindexingMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgReindexingMethodStart::operator==(const mplay_mediaplayerfi_tclMsgReindexingMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgReindexingMethodResult::mplay_mediaplayerfi_tclMsgReindexingMethodResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgReindexingMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REINDEXINGMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgReindexingMethodResult::~mplay_mediaplayerfi_tclMsgReindexingMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodStart::mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodStart(const mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8DeviceType = coRef.e8DeviceType;
   sFilename = coRef.sFilename;
}
mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodStart& mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodStart::operator=(const mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8DeviceType = coRef.e8DeviceType;
   sFilename = coRef.sFilename;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodStart::vDestroy()
{
   sFilename.vDestroy();
}

mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodStart::mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodStart()
:e8DeviceType()
,sFilename()
 {}

tS32 mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DIAGNOSISPLAYSONGMETHODSTART;
}


mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodStart::~mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sFilename.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8DeviceType);
   (tVoid) (oIn >> sFilename);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8DeviceType);
   (tVoid) (oOut << sFilename);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodStart::operator==(const mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8DeviceType == roRef.e8DeviceType);
   bResult = bResult && (sFilename == roRef.sFilename);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodResult::mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DIAGNOSISPLAYSONGMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodResult::~mplay_mediaplayerfi_tclMsgDiagnosisPlaySongMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestListDetailsMethodStart::mplay_mediaplayerfi_tclMsgRequestListDetailsMethodStart(const mplay_mediaplayerfi_tclMsgRequestListDetailsMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
}
mplay_mediaplayerfi_tclMsgRequestListDetailsMethodStart& mplay_mediaplayerfi_tclMsgRequestListDetailsMethodStart::operator=(const mplay_mediaplayerfi_tclMsgRequestListDetailsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgRequestListDetailsMethodStart::mplay_mediaplayerfi_tclMsgRequestListDetailsMethodStart()
:u32ListHandle(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestListDetailsMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTLISTDETAILSMETHODSTART;
}


mplay_mediaplayerfi_tclMsgRequestListDetailsMethodStart::~mplay_mediaplayerfi_tclMsgRequestListDetailsMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgRequestListDetailsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestListDetailsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestListDetailsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestListDetailsMethodStart::operator==(const mplay_mediaplayerfi_tclMsgRequestListDetailsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestListDetailsMethodResult::mplay_mediaplayerfi_tclMsgRequestListDetailsMethodResult(const mplay_mediaplayerfi_tclMsgRequestListDetailsMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8ListType = coRef.e8ListType;
   u32ParentListHandle = coRef.u32ParentListHandle;
   u8DeviceTag = coRef.u8DeviceTag;
   u32Position = coRef.u32Position;
}
mplay_mediaplayerfi_tclMsgRequestListDetailsMethodResult& mplay_mediaplayerfi_tclMsgRequestListDetailsMethodResult::operator=(const mplay_mediaplayerfi_tclMsgRequestListDetailsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8ListType = coRef.e8ListType;
   u32ParentListHandle = coRef.u32ParentListHandle;
   u8DeviceTag = coRef.u8DeviceTag;
   u32Position = coRef.u32Position;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgRequestListDetailsMethodResult::mplay_mediaplayerfi_tclMsgRequestListDetailsMethodResult()
:e8ListType()
,u32ParentListHandle(0)
,u8DeviceTag(0)
,u32Position(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestListDetailsMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTLISTDETAILSMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgRequestListDetailsMethodResult::~mplay_mediaplayerfi_tclMsgRequestListDetailsMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgRequestListDetailsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestListDetailsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ListType);
   (tVoid) (oIn >> u32ParentListHandle);
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> u32Position);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestListDetailsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ListType);
   (tVoid) (oOut << u32ParentListHandle);
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << u32Position);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestListDetailsMethodResult::operator==(const mplay_mediaplayerfi_tclMsgRequestListDetailsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ListType == roRef.e8ListType);
   bResult = bResult && (u32ParentListHandle == roRef.u32ParentListHandle);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (u32Position == roRef.u32Position);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestListInformationMethodStart::mplay_mediaplayerfi_tclMsgRequestListInformationMethodStart(const mplay_mediaplayerfi_tclMsgRequestListInformationMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
}
mplay_mediaplayerfi_tclMsgRequestListInformationMethodStart& mplay_mediaplayerfi_tclMsgRequestListInformationMethodStart::operator=(const mplay_mediaplayerfi_tclMsgRequestListInformationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgRequestListInformationMethodStart::mplay_mediaplayerfi_tclMsgRequestListInformationMethodStart()
:u32ListHandle(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestListInformationMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTLISTINFORMATIONMETHODSTART;
}


mplay_mediaplayerfi_tclMsgRequestListInformationMethodStart::~mplay_mediaplayerfi_tclMsgRequestListInformationMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgRequestListInformationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestListInformationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestListInformationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestListInformationMethodStart::operator==(const mplay_mediaplayerfi_tclMsgRequestListInformationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestListInformationMethodResult::mplay_mediaplayerfi_tclMsgRequestListInformationMethodResult(const mplay_mediaplayerfi_tclMsgRequestListInformationMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8ListType = coRef.e8ListType;
   u32ParentListHandle = coRef.u32ParentListHandle;
   u8DeviceTag = coRef.u8DeviceTag;
   u32Position = coRef.u32Position;
   u32ListSize = coRef.u32ListSize;
   sPath = coRef.sPath;
}
mplay_mediaplayerfi_tclMsgRequestListInformationMethodResult& mplay_mediaplayerfi_tclMsgRequestListInformationMethodResult::operator=(const mplay_mediaplayerfi_tclMsgRequestListInformationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8ListType = coRef.e8ListType;
   u32ParentListHandle = coRef.u32ParentListHandle;
   u8DeviceTag = coRef.u8DeviceTag;
   u32Position = coRef.u32Position;
   u32ListSize = coRef.u32ListSize;
   sPath = coRef.sPath;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgRequestListInformationMethodResult::vDestroy()
{
   sPath.vDestroy();
}

mplay_mediaplayerfi_tclMsgRequestListInformationMethodResult::mplay_mediaplayerfi_tclMsgRequestListInformationMethodResult()
:e8ListType()
,u32ParentListHandle(0)
,u8DeviceTag(0)
,u32Position(0)
,u32ListSize(0)
,sPath()
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestListInformationMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTLISTINFORMATIONMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgRequestListInformationMethodResult::~mplay_mediaplayerfi_tclMsgRequestListInformationMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgRequestListInformationMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 14+sPath.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestListInformationMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ListType);
   (tVoid) (oIn >> u32ParentListHandle);
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> u32Position);
   (tVoid) (oIn >> u32ListSize);
   (tVoid) (oIn >> sPath);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestListInformationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ListType);
   (tVoid) (oOut << u32ParentListHandle);
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << u32Position);
   (tVoid) (oOut << u32ListSize);
   (tVoid) (oOut << sPath);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestListInformationMethodResult::operator==(const mplay_mediaplayerfi_tclMsgRequestListInformationMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ListType == roRef.e8ListType);
   bResult = bResult && (u32ParentListHandle == roRef.u32ParentListHandle);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (u32Position == roRef.u32Position);
   bResult = bResult && (u32ListSize == roRef.u32ListSize);
   bResult = bResult && (sPath == roRef.sPath);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodStart::mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodStart(const mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u8DeviceTag = coRef.u8DeviceTag;
   oTagTransfer = coRef.oTagTransfer;
}
mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodStart& mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodStart::operator=(const mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceTag = coRef.u8DeviceTag;
   oTagTransfer = coRef.oTagTransfer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodStart::vDestroy()
{
   oTagTransfer.vDestroy(); 
}

mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodStart::mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodStart()
:u8DeviceTag(0)
,oTagTransfer()
 {}

tS32 mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_TRANSFERTAGSTODEVICEMETHODSTART;
}


mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodStart::~mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+oTagTransfer.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> oTagTransfer);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << oTagTransfer);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodStart::operator==(const mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (oTagTransfer == roRef.oTagTransfer);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodResult::mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodResult(const mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u8DeviceTag = coRef.u8DeviceTag;
   e8TagTransferStatus = coRef.e8TagTransferStatus;
   oUntransferredTagStream = coRef.oUntransferredTagStream;
}
mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodResult& mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodResult::operator=(const mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceTag = coRef.u8DeviceTag;
   e8TagTransferStatus = coRef.e8TagTransferStatus;
   oUntransferredTagStream = coRef.oUntransferredTagStream;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodResult::vDestroy()
{
   oUntransferredTagStream.vDestroy(); 
}

mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodResult::mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodResult()
:u8DeviceTag(0)
,e8TagTransferStatus()
,oUntransferredTagStream()
 {}

tS32 mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_TRANSFERTAGSTODEVICEMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodResult::~mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+oUntransferredTagStream.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> e8TagTransferStatus);
   (tVoid) (oIn >> oUntransferredTagStream);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << e8TagTransferStatus);
   (tVoid) (oOut << oUntransferredTagStream);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodResult::operator==(const mplay_mediaplayerfi_tclMsgTransferTagsToDeviceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (e8TagTransferStatus == roRef.e8TagTransferStatus);
   bResult = bResult && (oUntransferredTagStream == roRef.oUntransferredTagStream);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodStart::mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodStart(const mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32Tag = coRef.u32Tag;
}
mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodStart& mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodStart::operator=(const mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32Tag = coRef.u32Tag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodStart::mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodStart()
:u32ListHandle(0)
,u32Tag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYITEMFROMLISTBYTAGMETHODSTART;
}


mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodStart::~mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32Tag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32Tag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodStart::operator==(const mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32Tag == roRef.u32Tag);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodResult::mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYITEMFROMLISTBYTAGMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodResult::~mplay_mediaplayerfi_tclMsgPlayItemFromListByTagMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodStart::mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodStart(const mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8PlaybackDirection = coRef.e8PlaybackDirection;
   e8PlaybackSpeed = coRef.e8PlaybackSpeed;
}
mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodStart& mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodStart::operator=(const mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8PlaybackDirection = coRef.e8PlaybackDirection;
   e8PlaybackSpeed = coRef.e8PlaybackSpeed;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodStart::mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodStart()
:e8PlaybackDirection()
,e8PlaybackSpeed()
 {}

tS32 mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKSPEEDSETMETHODSTART;
}


mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodStart::~mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8PlaybackDirection);
   (tVoid) (oIn >> e8PlaybackSpeed);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8PlaybackDirection);
   (tVoid) (oOut << e8PlaybackSpeed);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodStart::operator==(const mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8PlaybackDirection == roRef.e8PlaybackDirection);
   bResult = bResult && (e8PlaybackSpeed == roRef.e8PlaybackSpeed);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodResult::mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodResult(const mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8PlaybackDirection = coRef.e8PlaybackDirection;
   e8PlaybackSpeed = coRef.e8PlaybackSpeed;
}
mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodResult& mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodResult::operator=(const mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8PlaybackDirection = coRef.e8PlaybackDirection;
   e8PlaybackSpeed = coRef.e8PlaybackSpeed;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodResult::mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodResult()
:e8PlaybackDirection()
,e8PlaybackSpeed()
 {}

tS32 mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKSPEEDSETMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodResult::~mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8PlaybackDirection);
   (tVoid) (oIn >> e8PlaybackSpeed);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8PlaybackDirection);
   (tVoid) (oOut << e8PlaybackSpeed);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodResult::operator==(const mplay_mediaplayerfi_tclMsgPlaybackSpeedSetMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8PlaybackDirection == roRef.e8PlaybackDirection);
   bResult = bResult && (e8PlaybackSpeed == roRef.e8PlaybackSpeed);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgClearLastModePauseMethodStart::mplay_mediaplayerfi_tclMsgClearLastModePauseMethodStart(const mplay_mediaplayerfi_tclMsgClearLastModePauseMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u8DeviceTag = coRef.u8DeviceTag;
}
mplay_mediaplayerfi_tclMsgClearLastModePauseMethodStart& mplay_mediaplayerfi_tclMsgClearLastModePauseMethodStart::operator=(const mplay_mediaplayerfi_tclMsgClearLastModePauseMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgClearLastModePauseMethodStart::mplay_mediaplayerfi_tclMsgClearLastModePauseMethodStart()
:u8DeviceTag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgClearLastModePauseMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CLEARLASTMODEPAUSEMETHODSTART;
}


mplay_mediaplayerfi_tclMsgClearLastModePauseMethodStart::~mplay_mediaplayerfi_tclMsgClearLastModePauseMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgClearLastModePauseMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgClearLastModePauseMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgClearLastModePauseMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgClearLastModePauseMethodStart::operator==(const mplay_mediaplayerfi_tclMsgClearLastModePauseMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgClearLastModePauseMethodResult::mplay_mediaplayerfi_tclMsgClearLastModePauseMethodResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgClearLastModePauseMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CLEARLASTMODEPAUSEMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgClearLastModePauseMethodResult::~mplay_mediaplayerfi_tclMsgClearLastModePauseMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodStart::mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodStart(const mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8DiscOperation = coRef.e8DiscOperation;
}
mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodStart& mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodStart::operator=(const mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8DiscOperation = coRef.e8DiscOperation;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodStart::mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodStart()
:e8DiscOperation()
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTDISCOPERATIONMETHODSTART;
}


mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodStart::~mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8DiscOperation);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8DiscOperation);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodStart::operator==(const mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8DiscOperation == roRef.e8DiscOperation);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodResult::mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTDISCOPERATIONMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodResult::~mplay_mediaplayerfi_tclMsgRequestDiscOperationMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodStart::mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodStart(const mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8SelectionType = coRef.e8SelectionType;
   e8AudioMode = coRef.e8AudioMode;
}
mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodStart& mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodStart::operator=(const mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8SelectionType = coRef.e8SelectionType;
   e8AudioMode = coRef.e8AudioMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodStart::mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodStart()
:e8SelectionType()
,e8AudioMode()
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTVCDAUDIOCHANNELMETHODSTART;
}


mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodStart::~mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8SelectionType);
   (tVoid) (oIn >> e8AudioMode);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8SelectionType);
   (tVoid) (oOut << e8AudioMode);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodStart::operator==(const mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8SelectionType == roRef.e8SelectionType);
   bResult = bResult && (e8AudioMode == roRef.e8AudioMode);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodResult::mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTVCDAUDIOCHANNELMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodResult::~mplay_mediaplayerfi_tclMsgRequestVCDAudioChannelMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodStart::mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodStart(const mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8SelectionType = coRef.e8SelectionType;
   e8AudioNumber = coRef.e8AudioNumber;
}
mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodStart& mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodStart::operator=(const mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8SelectionType = coRef.e8SelectionType;
   e8AudioNumber = coRef.e8AudioNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodStart::mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodStart()
:e8SelectionType()
,e8AudioNumber()
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTDVDAUDIOCHANNELMETHODSTART;
}


mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodStart::~mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8SelectionType);
   (tVoid) (oIn >> e8AudioNumber);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8SelectionType);
   (tVoid) (oOut << e8AudioNumber);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodStart::operator==(const mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8SelectionType == roRef.e8SelectionType);
   bResult = bResult && (e8AudioNumber == roRef.e8AudioNumber);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodResult::mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTDVDAUDIOCHANNELMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodResult::~mplay_mediaplayerfi_tclMsgRequestDVDAudioChannelMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodStart::mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodStart(const mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8Action = coRef.e8Action;
}
mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodStart& mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodStart::operator=(const mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8Action = coRef.e8Action;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodStart::mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodStart()
:e8Action()
 {}

tS32 mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SENDNAVIGATIONKEYMETHODSTART;
}


mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodStart::~mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Action);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Action);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodStart::operator==(const mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Action == roRef.e8Action);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodResult::mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SENDNAVIGATIONKEYMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodResult::~mplay_mediaplayerfi_tclMsgSendNavigationKeyMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgSendTouchCommandMethodStart::mplay_mediaplayerfi_tclMsgSendTouchCommandMethodStart(const mplay_mediaplayerfi_tclMsgSendTouchCommandMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8TouchAction = coRef.e8TouchAction;
   u16Xcoordinate = coRef.u16Xcoordinate;
   u16Ycoordinate = coRef.u16Ycoordinate;
   u16MaxXcoordinate = coRef.u16MaxXcoordinate;
   u16MaxYcoordinate = coRef.u16MaxYcoordinate;
}
mplay_mediaplayerfi_tclMsgSendTouchCommandMethodStart& mplay_mediaplayerfi_tclMsgSendTouchCommandMethodStart::operator=(const mplay_mediaplayerfi_tclMsgSendTouchCommandMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8TouchAction = coRef.e8TouchAction;
   u16Xcoordinate = coRef.u16Xcoordinate;
   u16Ycoordinate = coRef.u16Ycoordinate;
   u16MaxXcoordinate = coRef.u16MaxXcoordinate;
   u16MaxYcoordinate = coRef.u16MaxYcoordinate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgSendTouchCommandMethodStart::mplay_mediaplayerfi_tclMsgSendTouchCommandMethodStart()
:e8TouchAction()
,u16Xcoordinate(0)
,u16Ycoordinate(0)
,u16MaxXcoordinate(0)
,u16MaxYcoordinate(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgSendTouchCommandMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SENDTOUCHCOMMANDMETHODSTART;
}


mplay_mediaplayerfi_tclMsgSendTouchCommandMethodStart::~mplay_mediaplayerfi_tclMsgSendTouchCommandMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgSendTouchCommandMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgSendTouchCommandMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8TouchAction);
   (tVoid) (oIn >> u16Xcoordinate);
   (tVoid) (oIn >> u16Ycoordinate);
   (tVoid) (oIn >> u16MaxXcoordinate);
   (tVoid) (oIn >> u16MaxYcoordinate);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgSendTouchCommandMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8TouchAction);
   (tVoid) (oOut << u16Xcoordinate);
   (tVoid) (oOut << u16Ycoordinate);
   (tVoid) (oOut << u16MaxXcoordinate);
   (tVoid) (oOut << u16MaxYcoordinate);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgSendTouchCommandMethodStart::operator==(const mplay_mediaplayerfi_tclMsgSendTouchCommandMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8TouchAction == roRef.e8TouchAction);
   bResult = bResult && (u16Xcoordinate == roRef.u16Xcoordinate);
   bResult = bResult && (u16Ycoordinate == roRef.u16Ycoordinate);
   bResult = bResult && (u16MaxXcoordinate == roRef.u16MaxXcoordinate);
   bResult = bResult && (u16MaxYcoordinate == roRef.u16MaxYcoordinate);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgSendTouchCommandMethodResult::mplay_mediaplayerfi_tclMsgSendTouchCommandMethodResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgSendTouchCommandMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SENDTOUCHCOMMANDMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgSendTouchCommandMethodResult::~mplay_mediaplayerfi_tclMsgSendTouchCommandMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodStart::mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodStart(const mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   TitleNumber = coRef.TitleNumber;
   ChapterNumber = coRef.ChapterNumber;
}
mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodStart& mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodStart::operator=(const mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TitleNumber = coRef.TitleNumber;
   ChapterNumber = coRef.ChapterNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodStart::mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodStart()
:TitleNumber(0)
,ChapterNumber(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTDIRECTSEARCHMETHODSTART;
}


mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodStart::~mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TitleNumber);
   (tVoid) (oIn >> ChapterNumber);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TitleNumber);
   (tVoid) (oOut << ChapterNumber);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodStart::operator==(const mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TitleNumber == roRef.TitleNumber);
   bResult = bResult && (ChapterNumber == roRef.ChapterNumber);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodResult::mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTDIRECTSEARCHMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodResult::~mplay_mediaplayerfi_tclMsgRequestDirectSearchMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodStart::mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodStart(const mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8SelectionType = coRef.e8SelectionType;
   e8Angle = coRef.e8Angle;
}
mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodStart& mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodStart::operator=(const mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8SelectionType = coRef.e8SelectionType;
   e8Angle = coRef.e8Angle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodStart::mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodStart()
:e8SelectionType()
,e8Angle()
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTANGLECHANGEMETHODSTART;
}


mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodStart::~mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8SelectionType);
   (tVoid) (oIn >> e8Angle);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8SelectionType);
   (tVoid) (oOut << e8Angle);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodStart::operator==(const mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8SelectionType == roRef.e8SelectionType);
   bResult = bResult && (e8Angle == roRef.e8Angle);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodResult::mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTANGLECHANGEMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodResult::~mplay_mediaplayerfi_tclMsgRequestAngleChangeMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodStart::mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodStart(const mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8MenuControlData = coRef.e8MenuControlData;
}
mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodStart& mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodStart::operator=(const mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8MenuControlData = coRef.e8MenuControlData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodStart::mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodStart()
:e8MenuControlData()
 {}

tS32 mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SETMENUPLAYBACKCONTROLMETHODSTART;
}


mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodStart::~mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MenuControlData);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MenuControlData);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodStart::operator==(const mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MenuControlData == roRef.e8MenuControlData);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodResult::mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SETMENUPLAYBACKCONTROLMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodResult::~mplay_mediaplayerfi_tclMsgSetMenuPlayBackControlMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodStart::mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodStart(const mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32Number = coRef.u32Number;
}
mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodStart& mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodStart::operator=(const mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32Number = coRef.u32Number;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodStart::mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodStart()
:u32Number(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SELECTDIRECTNUMBERMETHODSTART;
}


mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodStart::~mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Number);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Number);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodStart::operator==(const mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Number == roRef.u32Number);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodResult::mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SELECTDIRECTNUMBERMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodResult::~mplay_mediaplayerfi_tclMsgSelectDirectNumberMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodStart::mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodStart(const mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32SearchNumber = coRef.u32SearchNumber;
}
mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodStart& mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodStart::operator=(const mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32SearchNumber = coRef.u32SearchNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodStart::mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodStart()
:u32SearchNumber(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTTITLESEARCHMETHODSTART;
}


mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodStart::~mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32SearchNumber);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32SearchNumber);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodStart::operator==(const mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32SearchNumber == roRef.u32SearchNumber);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodResult::mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTTITLESEARCHMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodResult::~mplay_mediaplayerfi_tclMsgRequestTitleSearchMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodStart::mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodStart(const mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   subtitleSwitchState = coRef.subtitleSwitchState;
   e8SelectionType = coRef.e8SelectionType;
   u8SubtitleSelection = coRef.u8SubtitleSelection;
}
mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodStart& mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodStart::operator=(const mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   subtitleSwitchState = coRef.subtitleSwitchState;
   e8SelectionType = coRef.e8SelectionType;
   u8SubtitleSelection = coRef.u8SubtitleSelection;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodStart::mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodStart()
:subtitleSwitchState(0)
,e8SelectionType()
,u8SubtitleSelection(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTSUBTITLECHANGEMETHODSTART;
}


mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodStart::~mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> subtitleSwitchState);
   (tVoid) (oIn >> e8SelectionType);
   (tVoid) (oIn >> u8SubtitleSelection);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << subtitleSwitchState);
   (tVoid) (oOut << e8SelectionType);
   (tVoid) (oOut << u8SubtitleSelection);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodStart::operator==(const mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (subtitleSwitchState == roRef.subtitleSwitchState);
   bResult = bResult && (e8SelectionType == roRef.e8SelectionType);
   bResult = bResult && (u8SubtitleSelection == roRef.u8SubtitleSelection);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodResult::mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTSUBTITLECHANGEMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodResult::~mplay_mediaplayerfi_tclMsgRequestSubtitleChangeMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestCMSkipMethodStart::mplay_mediaplayerfi_tclMsgRequestCMSkipMethodStart(const mplay_mediaplayerfi_tclMsgRequestCMSkipMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8CMSkipValue = coRef.e8CMSkipValue;
}
mplay_mediaplayerfi_tclMsgRequestCMSkipMethodStart& mplay_mediaplayerfi_tclMsgRequestCMSkipMethodStart::operator=(const mplay_mediaplayerfi_tclMsgRequestCMSkipMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8CMSkipValue = coRef.e8CMSkipValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgRequestCMSkipMethodStart::mplay_mediaplayerfi_tclMsgRequestCMSkipMethodStart()
:e8CMSkipValue()
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestCMSkipMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTCMSKIPMETHODSTART;
}


mplay_mediaplayerfi_tclMsgRequestCMSkipMethodStart::~mplay_mediaplayerfi_tclMsgRequestCMSkipMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgRequestCMSkipMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestCMSkipMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8CMSkipValue);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestCMSkipMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8CMSkipValue);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestCMSkipMethodStart::operator==(const mplay_mediaplayerfi_tclMsgRequestCMSkipMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8CMSkipValue == roRef.e8CMSkipValue);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgRequestCMSkipMethodResult::mplay_mediaplayerfi_tclMsgRequestCMSkipMethodResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestCMSkipMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTCMSKIPMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgRequestCMSkipMethodResult::~mplay_mediaplayerfi_tclMsgRequestCMSkipMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodResult::mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodResult(const mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u16Temperature = coRef.u16Temperature;
}
mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodResult& mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodResult::operator=(const mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16Temperature = coRef.u16Temperature;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodResult::mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodResult()
:u16Temperature(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTDVDTEMPERATUREMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodResult::~mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16Temperature);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16Temperature);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodResult::operator==(const mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16Temperature == roRef.u16Temperature);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodStart::mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodStart()
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTDVDTEMPERATUREMETHODSTART;
}


mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodStart::~mplay_mediaplayerfi_tclMsgRequestDVDTemperatureMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodStart::mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodStart(const mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   sPlaylistPath = coRef.sPlaylistPath;
   u32OldPosition = coRef.u32OldPosition;
   u32NewPosition = coRef.u32NewPosition;
   u8DeviceTag = coRef.u8DeviceTag;
}
mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodStart& mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodStart::operator=(const mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sPlaylistPath = coRef.sPlaylistPath;
   u32OldPosition = coRef.u32OldPosition;
   u32NewPosition = coRef.u32NewPosition;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodStart::vDestroy()
{
   sPlaylistPath.vDestroy();
}

mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodStart::mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodStart()
:sPlaylistPath()
,u32OldPosition(0)
,u32NewPosition(0)
,u8DeviceTag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REORDERINTERNALPLAYLISTMETHODSTART;
}


mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodStart::~mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 9+sPlaylistPath.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sPlaylistPath);
   (tVoid) (oIn >> u32OldPosition);
   (tVoid) (oIn >> u32NewPosition);
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sPlaylistPath);
   (tVoid) (oOut << u32OldPosition);
   (tVoid) (oOut << u32NewPosition);
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodStart::operator==(const mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sPlaylistPath == roRef.sPlaylistPath);
   bResult = bResult && (u32OldPosition == roRef.u32OldPosition);
   bResult = bResult && (u32NewPosition == roRef.u32NewPosition);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodResult::mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodResult(const mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodResult& mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodResult::operator=(const mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodResult::mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodResult()
:Status()
 {}

tS32 mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REORDERINTERNALPLAYLISTMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodResult::~mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodResult::operator==(const mplay_mediaplayerfi_tclMsgReorderInternalPlaylistMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodStart::mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodStart(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8ListType = coRef.e8ListType;
   u32FilterTag1 = coRef.u32FilterTag1;
   u32FilterTag2 = coRef.u32FilterTag2;
   u32FilterTag3 = coRef.u32FilterTag3;
   u8DeviceTag = coRef.u8DeviceTag;
}
mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodStart& mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodStart::operator=(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8ListType = coRef.e8ListType;
   u32FilterTag1 = coRef.u32FilterTag1;
   u32FilterTag2 = coRef.u32FilterTag2;
   u32FilterTag3 = coRef.u32FilterTag3;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodStart::mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodStart()
:e8ListType()
,u32FilterTag1(0)
,u32FilterTag2(0)
,u32FilterTag3(0)
,u8DeviceTag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DELETEMEDIACONTENTBYFILTERTAGSMETHODSTART;
}


mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodStart::~mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 14;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ListType);
   (tVoid) (oIn >> u32FilterTag1);
   (tVoid) (oIn >> u32FilterTag2);
   (tVoid) (oIn >> u32FilterTag3);
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ListType);
   (tVoid) (oOut << u32FilterTag1);
   (tVoid) (oOut << u32FilterTag2);
   (tVoid) (oOut << u32FilterTag3);
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodStart::operator==(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ListType == roRef.e8ListType);
   bResult = bResult && (u32FilterTag1 == roRef.u32FilterTag1);
   bResult = bResult && (u32FilterTag2 == roRef.u32FilterTag2);
   bResult = bResult && (u32FilterTag3 == roRef.u32FilterTag3);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodResult::mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodResult(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32NumberOfFiles = coRef.u32NumberOfFiles;
   u32Status = coRef.u32Status;
}
mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodResult& mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodResult::operator=(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32NumberOfFiles = coRef.u32NumberOfFiles;
   u32Status = coRef.u32Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodResult::mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodResult()
:u32NumberOfFiles(0)
,u32Status()
 {}

tS32 mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DELETEMEDIACONTENTBYFILTERTAGSMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodResult::~mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32NumberOfFiles);
   (tVoid) (oIn >> u32Status);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32NumberOfFiles);
   (tVoid) (oOut << u32Status);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodResult::operator==(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByFilterTagsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32NumberOfFiles == roRef.u32NumberOfFiles);
   bResult = bResult && (u32Status == roRef.u32Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodStart::mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodStart(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   oMediaObjectTags = coRef.oMediaObjectTags;
   u8DeviceTag = coRef.u8DeviceTag;
}
mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodStart& mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodStart::operator=(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   oMediaObjectTags = coRef.oMediaObjectTags;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodStart::vDestroy()
{
   oMediaObjectTags.vDestroy(); 
}

mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodStart::mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodStart()
:oMediaObjectTags()
,u8DeviceTag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DELETEMEDIACONTENTBYMEDIAOBJECTTAGSMETHODSTART;
}


mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodStart::~mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+oMediaObjectTags.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oMediaObjectTags);
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oMediaObjectTags);
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodStart::operator==(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oMediaObjectTags == roRef.oMediaObjectTags);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodResult::mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodResult(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32NumberOfFiles = coRef.u32NumberOfFiles;
   u32Status = coRef.u32Status;
}
mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodResult& mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodResult::operator=(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32NumberOfFiles = coRef.u32NumberOfFiles;
   u32Status = coRef.u32Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodResult::mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodResult()
:u32NumberOfFiles(0)
,u32Status()
 {}

tS32 mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DELETEMEDIACONTENTBYMEDIAOBJECTTAGSMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodResult::~mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32NumberOfFiles);
   (tVoid) (oIn >> u32Status);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32NumberOfFiles);
   (tVoid) (oOut << u32Status);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodResult::operator==(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByMediaObjectTagsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32NumberOfFiles == roRef.u32NumberOfFiles);
   bResult = bResult && (u32Status == roRef.u32Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodStart::mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodStart(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   oMPlayMediaObjectUrls = coRef.oMPlayMediaObjectUrls;
   u8DeviceTag = coRef.u8DeviceTag;
}
mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodStart& mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodStart::operator=(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   oMPlayMediaObjectUrls = coRef.oMPlayMediaObjectUrls;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodStart::vDestroy()
{
   oMPlayMediaObjectUrls.vDestroy(); 
}

mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodStart::mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodStart()
:oMPlayMediaObjectUrls()
,u8DeviceTag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DELETEMEDIACONTENTBYURLSMETHODSTART;
}


mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodStart::~mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+oMPlayMediaObjectUrls.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oMPlayMediaObjectUrls);
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oMPlayMediaObjectUrls);
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodStart::operator==(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oMPlayMediaObjectUrls == roRef.oMPlayMediaObjectUrls);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodResult::mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodResult(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32NumberOfFiles = coRef.u32NumberOfFiles;
   u32Status = coRef.u32Status;
}
mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodResult& mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodResult::operator=(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32NumberOfFiles = coRef.u32NumberOfFiles;
   u32Status = coRef.u32Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodResult::mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodResult()
:u32NumberOfFiles(0)
,u32Status()
 {}

tS32 mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DELETEMEDIACONTENTBYURLSMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodResult::~mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32NumberOfFiles);
   (tVoid) (oIn >> u32Status);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32NumberOfFiles);
   (tVoid) (oOut << u32Status);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodResult::operator==(const mplay_mediaplayerfi_tclMsgDeleteMediaContentByUrlsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32NumberOfFiles == roRef.u32NumberOfFiles);
   bResult = bResult && (u32Status == roRef.u32Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodStart::mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodStart(const mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32Tag = coRef.u32Tag;
   sTagGenre = coRef.sTagGenre;
   sTagAlbum = coRef.sTagAlbum;
   sTagArtist = coRef.sTagArtist;
   sTagTitle = coRef.sTagTitle;
   sTagComposer = coRef.sTagComposer;
   u16TagYear = coRef.u16TagYear;
   u8DeviceTag = coRef.u8DeviceTag;
   sTagYomiTitle = coRef.sTagYomiTitle;
   sTagYomiArtist = coRef.sTagYomiArtist;
   sTagYomiAlbum = coRef.sTagYomiAlbum;
}
mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodStart& mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodStart::operator=(const mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32Tag = coRef.u32Tag;
   sTagGenre = coRef.sTagGenre;
   sTagAlbum = coRef.sTagAlbum;
   sTagArtist = coRef.sTagArtist;
   sTagTitle = coRef.sTagTitle;
   sTagComposer = coRef.sTagComposer;
   u16TagYear = coRef.u16TagYear;
   u8DeviceTag = coRef.u8DeviceTag;
   sTagYomiTitle = coRef.sTagYomiTitle;
   sTagYomiArtist = coRef.sTagYomiArtist;
   sTagYomiAlbum = coRef.sTagYomiAlbum;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodStart::vDestroy()
{
   sTagGenre.vDestroy();
   sTagAlbum.vDestroy();
   sTagArtist.vDestroy();
   sTagTitle.vDestroy();
   sTagComposer.vDestroy();
   sTagYomiTitle.vDestroy();
   sTagYomiArtist.vDestroy();
   sTagYomiAlbum.vDestroy();
}

mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodStart::mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodStart()
:u32Tag(0)
,sTagGenre()
,sTagAlbum()
,sTagArtist()
,sTagTitle()
,sTagComposer()
,u16TagYear(0)
,u8DeviceTag(0)
,sTagYomiTitle()
,sTagYomiArtist()
,sTagYomiAlbum()
 {}

tS32 mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_EDITMETADATABYMEDIAOBJECTTAGMETHODSTART;
}


mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodStart::~mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 7+sTagGenre.u32GetSize(u16MajorVersion)+sTagAlbum.u32GetSize(u16MajorVersion)+sTagArtist.u32GetSize(u16MajorVersion)+sTagTitle.u32GetSize(u16MajorVersion)+sTagComposer.u32GetSize(u16MajorVersion)+sTagYomiTitle.u32GetSize(u16MajorVersion)+sTagYomiArtist.u32GetSize(u16MajorVersion)+sTagYomiAlbum.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Tag);
   (tVoid) (oIn >> sTagGenre);
   (tVoid) (oIn >> sTagAlbum);
   (tVoid) (oIn >> sTagArtist);
   (tVoid) (oIn >> sTagTitle);
   (tVoid) (oIn >> sTagComposer);
   (tVoid) (oIn >> u16TagYear);
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> sTagYomiTitle);
   (tVoid) (oIn >> sTagYomiArtist);
   (tVoid) (oIn >> sTagYomiAlbum);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Tag);
   (tVoid) (oOut << sTagGenre);
   (tVoid) (oOut << sTagAlbum);
   (tVoid) (oOut << sTagArtist);
   (tVoid) (oOut << sTagTitle);
   (tVoid) (oOut << sTagComposer);
   (tVoid) (oOut << u16TagYear);
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << sTagYomiTitle);
   (tVoid) (oOut << sTagYomiArtist);
   (tVoid) (oOut << sTagYomiAlbum);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodStart::operator==(const mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Tag == roRef.u32Tag);
   bResult = bResult && (sTagGenre == roRef.sTagGenre);
   bResult = bResult && (sTagAlbum == roRef.sTagAlbum);
   bResult = bResult && (sTagArtist == roRef.sTagArtist);
   bResult = bResult && (sTagTitle == roRef.sTagTitle);
   bResult = bResult && (sTagComposer == roRef.sTagComposer);
   bResult = bResult && (u16TagYear == roRef.u16TagYear);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (sTagYomiTitle == roRef.sTagYomiTitle);
   bResult = bResult && (sTagYomiArtist == roRef.sTagYomiArtist);
   bResult = bResult && (sTagYomiAlbum == roRef.sTagYomiAlbum);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodResult::mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodResult(const mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32Status = coRef.u32Status;
}
mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodResult& mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodResult::operator=(const mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32Status = coRef.u32Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodResult::mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodResult()
:u32Status()
 {}

tS32 mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_EDITMETADATABYMEDIAOBJECTTAGMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodResult::~mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Status);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Status);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodResult::operator==(const mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectTagMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Status == roRef.u32Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodStart::mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodStart(const mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   sMediaObjectUrl = coRef.sMediaObjectUrl;
   sTagGenre = coRef.sTagGenre;
   sTagAlbum = coRef.sTagAlbum;
   sTagArtist = coRef.sTagArtist;
   sTagTitle = coRef.sTagTitle;
   sTagComposer = coRef.sTagComposer;
   u16TagYear = coRef.u16TagYear;
   u8DeviceTag = coRef.u8DeviceTag;
   sTagYomiTitle = coRef.sTagYomiTitle;
   sTagYomiArtist = coRef.sTagYomiArtist;
   sTagYomiAlbum = coRef.sTagYomiAlbum;
}
mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodStart& mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodStart::operator=(const mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sMediaObjectUrl = coRef.sMediaObjectUrl;
   sTagGenre = coRef.sTagGenre;
   sTagAlbum = coRef.sTagAlbum;
   sTagArtist = coRef.sTagArtist;
   sTagTitle = coRef.sTagTitle;
   sTagComposer = coRef.sTagComposer;
   u16TagYear = coRef.u16TagYear;
   u8DeviceTag = coRef.u8DeviceTag;
   sTagYomiTitle = coRef.sTagYomiTitle;
   sTagYomiArtist = coRef.sTagYomiArtist;
   sTagYomiAlbum = coRef.sTagYomiAlbum;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodStart::vDestroy()
{
   sMediaObjectUrl.vDestroy();
   sTagGenre.vDestroy();
   sTagAlbum.vDestroy();
   sTagArtist.vDestroy();
   sTagTitle.vDestroy();
   sTagComposer.vDestroy();
   sTagYomiTitle.vDestroy();
   sTagYomiArtist.vDestroy();
   sTagYomiAlbum.vDestroy();
}

mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodStart::mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodStart()
:sMediaObjectUrl()
,sTagGenre()
,sTagAlbum()
,sTagArtist()
,sTagTitle()
,sTagComposer()
,u16TagYear(0)
,u8DeviceTag(0)
,sTagYomiTitle()
,sTagYomiArtist()
,sTagYomiAlbum()
 {}

tS32 mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_EDITMETADATABYMEDIAOBJECTURLMETHODSTART;
}


mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodStart::~mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+sMediaObjectUrl.u32GetSize(u16MajorVersion)+sTagGenre.u32GetSize(u16MajorVersion)+sTagAlbum.u32GetSize(u16MajorVersion)+sTagArtist.u32GetSize(u16MajorVersion)+sTagTitle.u32GetSize(u16MajorVersion)+sTagComposer.u32GetSize(u16MajorVersion)+sTagYomiTitle.u32GetSize(u16MajorVersion)+sTagYomiArtist.u32GetSize(u16MajorVersion)+sTagYomiAlbum.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sMediaObjectUrl);
   (tVoid) (oIn >> sTagGenre);
   (tVoid) (oIn >> sTagAlbum);
   (tVoid) (oIn >> sTagArtist);
   (tVoid) (oIn >> sTagTitle);
   (tVoid) (oIn >> sTagComposer);
   (tVoid) (oIn >> u16TagYear);
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> sTagYomiTitle);
   (tVoid) (oIn >> sTagYomiArtist);
   (tVoid) (oIn >> sTagYomiAlbum);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sMediaObjectUrl);
   (tVoid) (oOut << sTagGenre);
   (tVoid) (oOut << sTagAlbum);
   (tVoid) (oOut << sTagArtist);
   (tVoid) (oOut << sTagTitle);
   (tVoid) (oOut << sTagComposer);
   (tVoid) (oOut << u16TagYear);
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << sTagYomiTitle);
   (tVoid) (oOut << sTagYomiArtist);
   (tVoid) (oOut << sTagYomiAlbum);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodStart::operator==(const mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sMediaObjectUrl == roRef.sMediaObjectUrl);
   bResult = bResult && (sTagGenre == roRef.sTagGenre);
   bResult = bResult && (sTagAlbum == roRef.sTagAlbum);
   bResult = bResult && (sTagArtist == roRef.sTagArtist);
   bResult = bResult && (sTagTitle == roRef.sTagTitle);
   bResult = bResult && (sTagComposer == roRef.sTagComposer);
   bResult = bResult && (u16TagYear == roRef.u16TagYear);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (sTagYomiTitle == roRef.sTagYomiTitle);
   bResult = bResult && (sTagYomiArtist == roRef.sTagYomiArtist);
   bResult = bResult && (sTagYomiAlbum == roRef.sTagYomiAlbum);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodResult::mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodResult(const mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32Status = coRef.u32Status;
}
mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodResult& mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodResult::operator=(const mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32Status = coRef.u32Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodResult::mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodResult()
:u32Status()
 {}

tS32 mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_EDITMETADATABYMEDIAOBJECTURLMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodResult::~mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Status);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Status);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodResult::operator==(const mplay_mediaplayerfi_tclMsgEditMetaDataByMediaObjectUrlMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Status == roRef.u32Status);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgStartRippingMethodStart::mplay_mediaplayerfi_tclMsgStartRippingMethodStart()
 {}

tS32 mplay_mediaplayerfi_tclMsgStartRippingMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_STARTRIPPINGMETHODSTART;
}


mplay_mediaplayerfi_tclMsgStartRippingMethodStart::~mplay_mediaplayerfi_tclMsgStartRippingMethodStart()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgStartRippingMethodResult::mplay_mediaplayerfi_tclMsgStartRippingMethodResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgStartRippingMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_STARTRIPPINGMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgStartRippingMethodResult::~mplay_mediaplayerfi_tclMsgStartRippingMethodResult()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgStopRippingMethodStart::mplay_mediaplayerfi_tclMsgStopRippingMethodStart()
 {}

tS32 mplay_mediaplayerfi_tclMsgStopRippingMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_STOPRIPPINGMETHODSTART;
}


mplay_mediaplayerfi_tclMsgStopRippingMethodStart::~mplay_mediaplayerfi_tclMsgStopRippingMethodStart()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgStopRippingMethodResult::mplay_mediaplayerfi_tclMsgStopRippingMethodResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgStopRippingMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_STOPRIPPINGMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgStopRippingMethodResult::~mplay_mediaplayerfi_tclMsgStopRippingMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodStart::mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodStart(const mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   sAlbumTitle = coRef.sAlbumTitle;
   bMultipleAlbumSelection = coRef.bMultipleAlbumSelection;
}
mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodStart& mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodStart::operator=(const mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sAlbumTitle = coRef.sAlbumTitle;
   bMultipleAlbumSelection = coRef.bMultipleAlbumSelection;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodStart::vDestroy()
{
   sAlbumTitle.vDestroy();
}

mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodStart::mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodStart()
:sAlbumTitle()
,bMultipleAlbumSelection(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_EXTRACTGRACENOTEMETADATAMETHODSTART;
}


mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodStart::~mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sAlbumTitle.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sAlbumTitle);
   (tVoid) (oIn >> bMultipleAlbumSelection);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sAlbumTitle);
   (tVoid) (oOut << bMultipleAlbumSelection);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodStart::operator==(const mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sAlbumTitle == roRef.sAlbumTitle);
   bResult = bResult && (bMultipleAlbumSelection == roRef.bMultipleAlbumSelection);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodResult::mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_EXTRACTGRACENOTEMETADATAMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodResult::~mplay_mediaplayerfi_tclMsgExtractGracenoteMetadataMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodStart::mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodStart(const mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   sName = coRef.sName;
   u8DeviceTag = coRef.u8DeviceTag;
}
mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodStart& mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodStart::operator=(const mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sName = coRef.sName;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodStart::vDestroy()
{
   sName.vDestroy();
}

mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodStart::mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodStart()
:sName()
,u8DeviceTag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CREATEINTERNALFILENAMEPLAYLISTMETHODSTART;
}


mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodStart::~mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sName);
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sName);
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodStart::operator==(const mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sName == roRef.sName);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodResult::mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodResult(const mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   sPlaylistPath = coRef.sPlaylistPath;
   Status = coRef.Status;
}
mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodResult& mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodResult::operator=(const mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodResult& coRef)
{
   if (this == &coRef) return *this;
   sPlaylistPath = coRef.sPlaylistPath;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodResult::vDestroy()
{
   sPlaylistPath.vDestroy();
}

mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodResult::mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodResult()
:sPlaylistPath()
,Status()
 {}

tS32 mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CREATEINTERNALFILENAMEPLAYLISTMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodResult::~mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sPlaylistPath.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sPlaylistPath);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sPlaylistPath);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodResult::operator==(const mplay_mediaplayerfi_tclMsgCreateInternalFileNamePlaylistMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sPlaylistPath == roRef.sPlaylistPath);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodStart::mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodStart(const mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   sPlaylistPath = coRef.sPlaylistPath;
   oMPlayMediaObjectUrls = coRef.oMPlayMediaObjectUrls;
   u8DeviceTag = coRef.u8DeviceTag;
   oMPlayPlayListPosition = coRef.oMPlayPlayListPosition;
}
mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodStart& mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodStart::operator=(const mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sPlaylistPath = coRef.sPlaylistPath;
   oMPlayMediaObjectUrls = coRef.oMPlayMediaObjectUrls;
   u8DeviceTag = coRef.u8DeviceTag;
   oMPlayPlayListPosition = coRef.oMPlayPlayListPosition;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodStart::vDestroy()
{
   sPlaylistPath.vDestroy();
   oMPlayMediaObjectUrls.vDestroy(); 
   oMPlayPlayListPosition.vDestroy(); 
}

mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodStart::mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodStart()
:sPlaylistPath()
,oMPlayMediaObjectUrls()
,u8DeviceTag(0)
,oMPlayPlayListPosition()
 {}

tS32 mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_ADDFILENAMETOINTERNALPLAYLISTMETHODSTART;
}


mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodStart::~mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sPlaylistPath.u32GetSize(u16MajorVersion)+oMPlayMediaObjectUrls.u32GetSize(u16MajorVersion)+oMPlayPlayListPosition.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sPlaylistPath);
   (tVoid) (oIn >> oMPlayMediaObjectUrls);
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> oMPlayPlayListPosition);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sPlaylistPath);
   (tVoid) (oOut << oMPlayMediaObjectUrls);
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << oMPlayPlayListPosition);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodStart::operator==(const mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sPlaylistPath == roRef.sPlaylistPath);
   bResult = bResult && (oMPlayMediaObjectUrls == roRef.oMPlayMediaObjectUrls);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (oMPlayPlayListPosition == roRef.oMPlayPlayListPosition);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodResult::mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodResult(const mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodResult& mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodResult::operator=(const mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodResult::mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodResult()
:Status()
 {}

tS32 mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_ADDFILENAMETOINTERNALPLAYLISTMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodResult::~mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodResult::operator==(const mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodStart::mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodStart(const mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   sPlaylistPath = coRef.sPlaylistPath;
   u8DeviceTag = coRef.u8DeviceTag;
   oMPlayPlayListPosition = coRef.oMPlayPlayListPosition;
}
mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodStart& mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodStart::operator=(const mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sPlaylistPath = coRef.sPlaylistPath;
   u8DeviceTag = coRef.u8DeviceTag;
   oMPlayPlayListPosition = coRef.oMPlayPlayListPosition;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodStart::vDestroy()
{
   sPlaylistPath.vDestroy();
   oMPlayPlayListPosition.vDestroy(); 
}

mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodStart::mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodStart()
:sPlaylistPath()
,u8DeviceTag(0)
,oMPlayPlayListPosition()
 {}

tS32 mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DELETEENTRYFROMPLAYLISTMETHODSTART;
}


mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodStart::~mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sPlaylistPath.u32GetSize(u16MajorVersion)+oMPlayPlayListPosition.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sPlaylistPath);
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> oMPlayPlayListPosition);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sPlaylistPath);
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << oMPlayPlayListPosition);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodStart::operator==(const mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sPlaylistPath == roRef.sPlaylistPath);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (oMPlayPlayListPosition == roRef.oMPlayPlayListPosition);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodResult::mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodResult(const mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodResult& mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodResult::operator=(const mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodResult::mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodResult()
:Status()
 {}

tS32 mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DELETEENTRYFROMPLAYLISTMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodResult::~mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodResult::operator==(const mplay_mediaplayerfi_tclMsgDeleteEntryFromPlaylistMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodStart::mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodStart(const mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   sPlaylistPath = coRef.sPlaylistPath;
   sNewName = coRef.sNewName;
   u8DeviceTag = coRef.u8DeviceTag;
}
mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodStart& mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodStart::operator=(const mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sPlaylistPath = coRef.sPlaylistPath;
   sNewName = coRef.sNewName;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodStart::vDestroy()
{
   sPlaylistPath.vDestroy();
   sNewName.vDestroy();
}

mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodStart::mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodStart()
:sPlaylistPath()
,sNewName()
,u8DeviceTag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_RENAMEINTERNALPLAYLISTMETHODSTART;
}


mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodStart::~mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sPlaylistPath.u32GetSize(u16MajorVersion)+sNewName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sPlaylistPath);
   (tVoid) (oIn >> sNewName);
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sPlaylistPath);
   (tVoid) (oOut << sNewName);
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodStart::operator==(const mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sPlaylistPath == roRef.sPlaylistPath);
   bResult = bResult && (sNewName == roRef.sNewName);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodResult::mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodResult(const mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodResult& mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodResult::operator=(const mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodResult::mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodResult()
:Status()
 {}

tS32 mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_RENAMEINTERNALPLAYLISTMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodResult::~mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodResult::operator==(const mplay_mediaplayerfi_tclMsgRenameInternalPlaylistMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodStart::mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodStart(const mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   sPlaylistPath = coRef.sPlaylistPath;
   u8DeviceTag = coRef.u8DeviceTag;
}
mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodStart& mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodStart::operator=(const mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sPlaylistPath = coRef.sPlaylistPath;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodStart::vDestroy()
{
   sPlaylistPath.vDestroy();
}

mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodStart::mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodStart()
:sPlaylistPath()
,u8DeviceTag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DELETEINTERNALPLAYLISTMETHODSTART;
}


mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodStart::~mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sPlaylistPath.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sPlaylistPath);
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sPlaylistPath);
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodStart::operator==(const mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sPlaylistPath == roRef.sPlaylistPath);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodResult::mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodResult(const mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodResult& mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodResult::operator=(const mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodResult::mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodResult()
:Status()
 {}

tS32 mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DELETEINTERNALPLAYLISTMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodResult::~mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodResult::operator==(const mplay_mediaplayerfi_tclMsgDeleteInternalPlaylistMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodStart::mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodStart(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u8DeviceTag = coRef.u8DeviceTag;
}
mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodStart& mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodStart::operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodStart::mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodStart()
:u8DeviceTag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERINTERNALPLAYLISTLISTMETHODSTART;
}


mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodStart::~mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodStart::operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodResult::mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodResult(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
}
mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodResult& mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodResult::operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodResult::mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodResult()
:u32ListHandle(0)
,u32ListSize(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERINTERNALPLAYLISTLISTMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodResult::~mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32ListSize);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32ListSize);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodResult::operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerInternalPlaylistListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32ListSize == roRef.u32ListSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodStart::mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodStart(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u16WindowSize = coRef.u16WindowSize;
   DeviceTag = coRef.DeviceTag;
}
mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodStart& mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodStart::operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u16WindowSize = coRef.u16WindowSize;
   DeviceTag = coRef.DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodStart::mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodStart()
:u32ListHandle(0)
,u32WindowStart(0)
,u16WindowSize(0)
,DeviceTag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERINTERNALPLAYLISTLISTSLICEMETHODSTART;
}


mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodStart::~mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32WindowStart);
   (tVoid) (oIn >> u16WindowSize);
   (tVoid) (oIn >> DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32WindowStart);
   (tVoid) (oOut << u16WindowSize);
   (tVoid) (oOut << DeviceTag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodStart::operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32WindowStart == roRef.u32WindowStart);
   bResult = bResult && (u16WindowSize == roRef.u16WindowSize);
   bResult = bResult && (DeviceTag == roRef.DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodResult::mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodResult(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   oMediaObjects = coRef.oMediaObjects;
}
mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodResult& mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodResult::operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oMediaObjects = coRef.oMediaObjects;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodResult::vDestroy()
{
   oMediaObjects.vDestroy(); 
}

mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodResult::mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodResult()
:oMediaObjects()
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERINTERNALPLAYLISTLISTSLICEMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodResult::~mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+oMediaObjects.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oMediaObjects);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oMediaObjects);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodResult::operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oMediaObjects == roRef.oMediaObjects);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodStart::mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodStart(const mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32Tag = coRef.u32Tag;
}
mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodStart& mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodStart::operator=(const mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32Tag = coRef.u32Tag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodStart::mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodStart()
:u32ListHandle(0)
,u32Tag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_GETLISTPOSITIONOFOBJECTMETHODSTART;
}


mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodStart::~mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32Tag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32Tag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodStart::operator==(const mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32Tag == roRef.u32Tag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodResult::mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodResult(const mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32Position = coRef.u32Position;
}
mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodResult& mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodResult::operator=(const mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32Position = coRef.u32Position;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodResult::mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodResult()
:u32Position(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_GETLISTPOSITIONOFOBJECTMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodResult::~mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Position);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Position);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodResult::operator==(const mplay_mediaplayerfi_tclMsgGetListPositionOfObjectMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Position == roRef.u32Position);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodStart::mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodStart(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   sFilename = coRef.sFilename;
   u8DeviceTag = coRef.u8DeviceTag;
   e8MPlayFileTypeSelection = coRef.e8MPlayFileTypeSelection;
}
mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodStart& mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodStart::operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sFilename = coRef.sFilename;
   u8DeviceTag = coRef.u8DeviceTag;
   e8MPlayFileTypeSelection = coRef.e8MPlayFileTypeSelection;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodStart::vDestroy()
{
   sFilename.vDestroy();
}

mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodStart::mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodStart()
:sFilename()
,u8DeviceTag(0)
,e8MPlayFileTypeSelection()
 {}

tS32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERFILELISTEXTMETHODSTART;
}


mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodStart::~mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+sFilename.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sFilename);
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> e8MPlayFileTypeSelection);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sFilename);
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << e8MPlayFileTypeSelection);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodStart::operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sFilename == roRef.sFilename);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (e8MPlayFileTypeSelection == roRef.e8MPlayFileTypeSelection);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodResult::mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodResult(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   u8DeviceTag = coRef.u8DeviceTag;
   u32TotalNumFiles = coRef.u32TotalNumFiles;
   u32TotalNumFolders = coRef.u32TotalNumFolders;
   u32Position = coRef.u32Position;
   u32TotalNumMediaObjects = coRef.u32TotalNumMediaObjects;
   u32TotalNumPlaylists = coRef.u32TotalNumPlaylists;
}
mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodResult& mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodResult::operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   u8DeviceTag = coRef.u8DeviceTag;
   u32TotalNumFiles = coRef.u32TotalNumFiles;
   u32TotalNumFolders = coRef.u32TotalNumFolders;
   u32Position = coRef.u32Position;
   u32TotalNumMediaObjects = coRef.u32TotalNumMediaObjects;
   u32TotalNumPlaylists = coRef.u32TotalNumPlaylists;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodResult::mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodResult()
:u32ListHandle(0)
,u32ListSize(0)
,u8DeviceTag(0)
,u32TotalNumFiles(0)
,u32TotalNumFolders(0)
,u32Position(0)
,u32TotalNumMediaObjects(0)
,u32TotalNumPlaylists(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERFILELISTEXTMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodResult::~mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 29;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32ListSize);
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> u32TotalNumFiles);
   (tVoid) (oIn >> u32TotalNumFolders);
   (tVoid) (oIn >> u32Position);
   (tVoid) (oIn >> u32TotalNumMediaObjects);
   (tVoid) (oIn >> u32TotalNumPlaylists);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32ListSize);
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << u32TotalNumFiles);
   (tVoid) (oOut << u32TotalNumFolders);
   (tVoid) (oOut << u32Position);
   (tVoid) (oOut << u32TotalNumMediaObjects);
   (tVoid) (oOut << u32TotalNumPlaylists);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodResult::operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerFileListExtMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32ListSize == roRef.u32ListSize);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (u32TotalNumFiles == roRef.u32TotalNumFiles);
   bResult = bResult && (u32TotalNumFolders == roRef.u32TotalNumFolders);
   bResult = bResult && (u32Position == roRef.u32Position);
   bResult = bResult && (u32TotalNumMediaObjects == roRef.u32TotalNumMediaObjects);
   bResult = bResult && (u32TotalNumPlaylists == roRef.u32TotalNumPlaylists);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgStartSlideshowMethodStart::mplay_mediaplayerfi_tclMsgStartSlideshowMethodStart(const mplay_mediaplayerfi_tclMsgStartSlideshowMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32Tag = coRef.u32Tag;
}
mplay_mediaplayerfi_tclMsgStartSlideshowMethodStart& mplay_mediaplayerfi_tclMsgStartSlideshowMethodStart::operator=(const mplay_mediaplayerfi_tclMsgStartSlideshowMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32Tag = coRef.u32Tag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgStartSlideshowMethodStart::mplay_mediaplayerfi_tclMsgStartSlideshowMethodStart()
:u32ListHandle(0)
,u32Tag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgStartSlideshowMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_STARTSLIDESHOWMETHODSTART;
}


mplay_mediaplayerfi_tclMsgStartSlideshowMethodStart::~mplay_mediaplayerfi_tclMsgStartSlideshowMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgStartSlideshowMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgStartSlideshowMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32Tag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgStartSlideshowMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32Tag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgStartSlideshowMethodStart::operator==(const mplay_mediaplayerfi_tclMsgStartSlideshowMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32Tag == roRef.u32Tag);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgStartSlideshowMethodResult::mplay_mediaplayerfi_tclMsgStartSlideshowMethodResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgStartSlideshowMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_STARTSLIDESHOWMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgStartSlideshowMethodResult::~mplay_mediaplayerfi_tclMsgStartSlideshowMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodStart::mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodStart(const mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8Action = coRef.e8Action;
   u8NextPrevSkipCount = coRef.u8NextPrevSkipCount;
}
mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodStart& mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodStart::operator=(const mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8Action = coRef.e8Action;
   u8NextPrevSkipCount = coRef.u8NextPrevSkipCount;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodStart::mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodStart()
:e8Action()
,u8NextPrevSkipCount(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTSLIDESHOWACTIONMETHODSTART;
}


mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodStart::~mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Action);
   (tVoid) (oIn >> u8NextPrevSkipCount);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Action);
   (tVoid) (oOut << u8NextPrevSkipCount);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodStart::operator==(const mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Action == roRef.e8Action);
   bResult = bResult && (u8NextPrevSkipCount == roRef.u8NextPrevSkipCount);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodResult::mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTSLIDESHOWACTIONMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodResult::~mplay_mediaplayerfi_tclMsgRequestSlideshowActionMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgQuicksearchMethodStart::mplay_mediaplayerfi_tclMsgQuicksearchMethodStart(const mplay_mediaplayerfi_tclMsgQuicksearchMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32Position = coRef.u32Position;
   sSearchChar = coRef.sSearchChar;
}
mplay_mediaplayerfi_tclMsgQuicksearchMethodStart& mplay_mediaplayerfi_tclMsgQuicksearchMethodStart::operator=(const mplay_mediaplayerfi_tclMsgQuicksearchMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32Position = coRef.u32Position;
   sSearchChar = coRef.sSearchChar;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgQuicksearchMethodStart::vDestroy()
{
   sSearchChar.vDestroy(); 
}

mplay_mediaplayerfi_tclMsgQuicksearchMethodStart::mplay_mediaplayerfi_tclMsgQuicksearchMethodStart()
:u32ListHandle(0)
,u32Position(0)
,sSearchChar()
 {}

tS32 mplay_mediaplayerfi_tclMsgQuicksearchMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_QUICKSEARCHMETHODSTART;
}


mplay_mediaplayerfi_tclMsgQuicksearchMethodStart::~mplay_mediaplayerfi_tclMsgQuicksearchMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgQuicksearchMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+sSearchChar.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgQuicksearchMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32Position);
   (tVoid) (oIn >> sSearchChar);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgQuicksearchMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32Position);
   (tVoid) (oOut << sSearchChar);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgQuicksearchMethodStart::operator==(const mplay_mediaplayerfi_tclMsgQuicksearchMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32Position == roRef.u32Position);
   bResult = bResult && (sSearchChar == roRef.sSearchChar);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgQuicksearchMethodResult::mplay_mediaplayerfi_tclMsgQuicksearchMethodResult(const mplay_mediaplayerfi_tclMsgQuicksearchMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32Position = coRef.u32Position;
   oSearchResult = coRef.oSearchResult;
}
mplay_mediaplayerfi_tclMsgQuicksearchMethodResult& mplay_mediaplayerfi_tclMsgQuicksearchMethodResult::operator=(const mplay_mediaplayerfi_tclMsgQuicksearchMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32Position = coRef.u32Position;
   oSearchResult = coRef.oSearchResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgQuicksearchMethodResult::mplay_mediaplayerfi_tclMsgQuicksearchMethodResult()
:u32Position(0)
,oSearchResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgQuicksearchMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_QUICKSEARCHMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgQuicksearchMethodResult::~mplay_mediaplayerfi_tclMsgQuicksearchMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgQuicksearchMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgQuicksearchMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Position);
   (tVoid) (oIn >> oSearchResult);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgQuicksearchMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Position);
   (tVoid) (oOut << oSearchResult);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgQuicksearchMethodResult::operator==(const mplay_mediaplayerfi_tclMsgQuicksearchMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Position == roRef.u32Position);
   bResult = bResult && (oSearchResult == roRef.oSearchResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodStart::mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodStart(const mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   eCmdParam = coRef.eCmdParam;
}
mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodStart& mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodStart::operator=(const mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodStart& coRef)
{
   if (this == &coRef) return *this;
   eCmdParam = coRef.eCmdParam;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodStart::mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodStart()
:eCmdParam()
 {}

tS32 mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_EJECTOPTICALDISCMETHODSTART;
}


mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodStart::~mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eCmdParam);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eCmdParam);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodStart::operator==(const mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eCmdParam == roRef.eCmdParam);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodResult::mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodResult(const mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   ServiceStatus = coRef.ServiceStatus;
}
mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodResult& mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodResult::operator=(const mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ServiceStatus = coRef.ServiceStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodResult::mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodResult()
:ServiceStatus()
 {}

tS32 mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_EJECTOPTICALDISCMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodResult::~mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceStatus);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceStatus);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodResult::operator==(const mplay_mediaplayerfi_tclMsgEjectOpticalDiscMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceStatus == roRef.ServiceStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodStart::mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodStart(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8ListType = coRef.e8ListType;
   u8DeviceTag = coRef.u8DeviceTag;
   sPath = coRef.sPath;
}
mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodStart& mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodStart::operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8ListType = coRef.e8ListType;
   u8DeviceTag = coRef.u8DeviceTag;
   sPath = coRef.sPath;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodStart::vDestroy()
{
   sPath.vDestroy();
}

mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodStart::mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodStart()
:e8ListType()
,u8DeviceTag(0)
,sPath()
 {}

tS32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERINDEXEDIMAGEFOLDERLISTMETHODSTART;
}


mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodStart::~mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+sPath.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ListType);
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> sPath);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ListType);
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << sPath);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodStart::operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ListType == roRef.e8ListType);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (sPath == roRef.sPath);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodResult::mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodResult(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
}
mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodResult& mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodResult::operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodResult::mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodResult()
:u32ListHandle(0)
,u32ListSize(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERINDEXEDIMAGEFOLDERLISTMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodResult::~mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32ListSize);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32ListSize);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodResult::operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerIndexedImageFolderListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32ListSize == roRef.u32ListSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodStart::mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodStart(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u16WindowSize = coRef.u16WindowSize;
   DeviceTag = coRef.DeviceTag;
}
mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodStart& mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodStart::operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u16WindowSize = coRef.u16WindowSize;
   DeviceTag = coRef.DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodStart::mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodStart()
:u32ListHandle(0)
,u32WindowStart(0)
,u16WindowSize(0)
,DeviceTag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERINDEXEDIMAGEFOLDERLISTSLICEMETHODSTART;
}


mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodStart::~mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32WindowStart);
   (tVoid) (oIn >> u16WindowSize);
   (tVoid) (oIn >> DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32WindowStart);
   (tVoid) (oOut << u16WindowSize);
   (tVoid) (oOut << DeviceTag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodStart::operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32WindowStart == roRef.u32WindowStart);
   bResult = bResult && (u16WindowSize == roRef.u16WindowSize);
   bResult = bResult && (DeviceTag == roRef.DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodResult::mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodResult(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   oImageObjects = coRef.oImageObjects;
}
mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodResult& mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodResult::operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oImageObjects = coRef.oImageObjects;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodResult::vDestroy()
{
   oImageObjects.vDestroy(); 
}

mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodResult::mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodResult()
:oImageObjects()
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERINDEXEDIMAGEFOLDERLISTSLICEMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodResult::~mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+oImageObjects.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oImageObjects);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oImageObjects);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodResult::operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerIndexedImageFolderListSliceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oImageObjects == roRef.oImageObjects);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodStart::mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodStart(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   sPath = coRef.sPath;
   u8DeviceTag = coRef.u8DeviceTag;
   e8MPlayFileTypeSelection = coRef.e8MPlayFileTypeSelection;
}
mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodStart& mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodStart::operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sPath = coRef.sPath;
   u8DeviceTag = coRef.u8DeviceTag;
   e8MPlayFileTypeSelection = coRef.e8MPlayFileTypeSelection;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodStart::vDestroy()
{
   sPath.vDestroy();
}

mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodStart::mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodStart()
:sPath()
,u8DeviceTag(0)
,e8MPlayFileTypeSelection()
 {}

tS32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERCDLISTMETHODSTART;
}


mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodStart::~mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+sPath.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sPath);
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> e8MPlayFileTypeSelection);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sPath);
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << e8MPlayFileTypeSelection);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodStart::operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sPath == roRef.sPath);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (e8MPlayFileTypeSelection == roRef.e8MPlayFileTypeSelection);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodResult::mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodResult(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   u8DeviceTag = coRef.u8DeviceTag;
   u32TotalNumFiles = coRef.u32TotalNumFiles;
   u32TotalNumFolders = coRef.u32TotalNumFolders;
   u32TotalNumMediaObjects = coRef.u32TotalNumMediaObjects;
   u32TotalNumPlaylists = coRef.u32TotalNumPlaylists;
}
mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodResult& mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodResult::operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   u8DeviceTag = coRef.u8DeviceTag;
   u32TotalNumFiles = coRef.u32TotalNumFiles;
   u32TotalNumFolders = coRef.u32TotalNumFolders;
   u32TotalNumMediaObjects = coRef.u32TotalNumMediaObjects;
   u32TotalNumPlaylists = coRef.u32TotalNumPlaylists;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodResult::mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodResult()
:u32ListHandle(0)
,u32ListSize(0)
,u8DeviceTag(0)
,u32TotalNumFiles(0)
,u32TotalNumFolders(0)
,u32TotalNumMediaObjects(0)
,u32TotalNumPlaylists(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERCDLISTMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodResult::~mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 25;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32ListSize);
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> u32TotalNumFiles);
   (tVoid) (oIn >> u32TotalNumFolders);
   (tVoid) (oIn >> u32TotalNumMediaObjects);
   (tVoid) (oIn >> u32TotalNumPlaylists);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32ListSize);
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << u32TotalNumFiles);
   (tVoid) (oOut << u32TotalNumFolders);
   (tVoid) (oOut << u32TotalNumMediaObjects);
   (tVoid) (oOut << u32TotalNumPlaylists);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodResult::operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerCDListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32ListSize == roRef.u32ListSize);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (u32TotalNumFiles == roRef.u32TotalNumFiles);
   bResult = bResult && (u32TotalNumFolders == roRef.u32TotalNumFolders);
   bResult = bResult && (u32TotalNumMediaObjects == roRef.u32TotalNumMediaObjects);
   bResult = bResult && (u32TotalNumPlaylists == roRef.u32TotalNumPlaylists);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodStart::mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodStart(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   sPath = coRef.sPath;
   u8DeviceTag = coRef.u8DeviceTag;
   e8MPlayFileTypeSelection = coRef.e8MPlayFileTypeSelection;
}
mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodStart& mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodStart::operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sPath = coRef.sPath;
   u8DeviceTag = coRef.u8DeviceTag;
   e8MPlayFileTypeSelection = coRef.e8MPlayFileTypeSelection;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodStart::vDestroy()
{
   sPath.vDestroy();
}

mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodStart::mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodStart()
:sPath()
,u8DeviceTag(0)
,e8MPlayFileTypeSelection()
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERFOLDERINFOMETHODSTART;
}


mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodStart::~mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+sPath.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sPath);
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> e8MPlayFileTypeSelection);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sPath);
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << e8MPlayFileTypeSelection);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodStart::operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sPath == roRef.sPath);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (e8MPlayFileTypeSelection == roRef.e8MPlayFileTypeSelection);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodResult::mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodResult(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u8DeviceTag = coRef.u8DeviceTag;
   sPath = coRef.sPath;
   u64TotalSize = coRef.u64TotalSize;
   u32TotalNumber = coRef.u32TotalNumber;
   u64ProtectedSize = coRef.u64ProtectedSize;
   u32ProtectedNumber = coRef.u32ProtectedNumber;
}
mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodResult& mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodResult::operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceTag = coRef.u8DeviceTag;
   sPath = coRef.sPath;
   u64TotalSize = coRef.u64TotalSize;
   u32TotalNumber = coRef.u32TotalNumber;
   u64ProtectedSize = coRef.u64ProtectedSize;
   u32ProtectedNumber = coRef.u32ProtectedNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodResult::vDestroy()
{
   sPath.vDestroy();
}

mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodResult::mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodResult()
:u8DeviceTag(0)
,sPath()
,u64TotalSize(0)
,u32TotalNumber(0)
,u64ProtectedSize(0)
,u32ProtectedNumber(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERFOLDERINFOMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodResult::~mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 25+sPath.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> sPath);
   (tVoid) (oIn >> u64TotalSize);
   (tVoid) (oIn >> u32TotalNumber);
   (tVoid) (oIn >> u64ProtectedSize);
   (tVoid) (oIn >> u32ProtectedNumber);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << sPath);
   (tVoid) (oOut << u64TotalSize);
   (tVoid) (oOut << u32TotalNumber);
   (tVoid) (oOut << u64ProtectedSize);
   (tVoid) (oOut << u32ProtectedNumber);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodResult::operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerFolderInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (sPath == roRef.sPath);
   bResult = bResult && (u64TotalSize == roRef.u64TotalSize);
   bResult = bResult && (u32TotalNumber == roRef.u32TotalNumber);
   bResult = bResult && (u64ProtectedSize == roRef.u64ProtectedSize);
   bResult = bResult && (u32ProtectedNumber == roRef.u32ProtectedNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodStart::mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodStart(const mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   oFilePermissionObjectTags = coRef.oFilePermissionObjectTags;
   u8DeviceTag = coRef.u8DeviceTag;
}
mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodStart& mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodStart::operator=(const mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   oFilePermissionObjectTags = coRef.oFilePermissionObjectTags;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodStart::vDestroy()
{
   oFilePermissionObjectTags.vDestroy(); 
}

mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodStart::mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodStart()
:oFilePermissionObjectTags()
,u8DeviceTag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SETFILEPERMISSIONBYMEDIAOBJECTTAGSMETHODSTART;
}


mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodStart::~mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+oFilePermissionObjectTags.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oFilePermissionObjectTags);
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oFilePermissionObjectTags);
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodStart::operator==(const mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oFilePermissionObjectTags == roRef.oFilePermissionObjectTags);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodResult::mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodResult(const mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32NumberOfFiles = coRef.u32NumberOfFiles;
   u32Status = coRef.u32Status;
}
mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodResult& mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodResult::operator=(const mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32NumberOfFiles = coRef.u32NumberOfFiles;
   u32Status = coRef.u32Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodResult::mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodResult()
:u32NumberOfFiles(0)
,u32Status()
 {}

tS32 mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SETFILEPERMISSIONBYMEDIAOBJECTTAGSMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodResult::~mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32NumberOfFiles);
   (tVoid) (oIn >> u32Status);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32NumberOfFiles);
   (tVoid) (oOut << u32Status);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodResult::operator==(const mplay_mediaplayerfi_tclMsgSetFilePermissionByMediaObjectTagsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32NumberOfFiles == roRef.u32NumberOfFiles);
   bResult = bResult && (u32Status == roRef.u32Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodStart::mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodStart(const mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   sPlaylistPath = coRef.sPlaylistPath;
   e8ListType = coRef.e8ListType;
   u32FilterTag1 = coRef.u32FilterTag1;
   u32FilterTag2 = coRef.u32FilterTag2;
   u32FilterTag3 = coRef.u32FilterTag3;
   u8DeviceTag = coRef.u8DeviceTag;
}
mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodStart& mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodStart::operator=(const mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sPlaylistPath = coRef.sPlaylistPath;
   e8ListType = coRef.e8ListType;
   u32FilterTag1 = coRef.u32FilterTag1;
   u32FilterTag2 = coRef.u32FilterTag2;
   u32FilterTag3 = coRef.u32FilterTag3;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodStart::vDestroy()
{
   sPlaylistPath.vDestroy();
}

mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodStart::mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodStart()
:sPlaylistPath()
,e8ListType()
,u32FilterTag1(0)
,u32FilterTag2(0)
,u32FilterTag3(0)
,u8DeviceTag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_ADDFILENAMETOINTERNALPLAYLISTBYTAGSMETHODSTART;
}


mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodStart::~mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 14+sPlaylistPath.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sPlaylistPath);
   (tVoid) (oIn >> e8ListType);
   (tVoid) (oIn >> u32FilterTag1);
   (tVoid) (oIn >> u32FilterTag2);
   (tVoid) (oIn >> u32FilterTag3);
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sPlaylistPath);
   (tVoid) (oOut << e8ListType);
   (tVoid) (oOut << u32FilterTag1);
   (tVoid) (oOut << u32FilterTag2);
   (tVoid) (oOut << u32FilterTag3);
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodStart::operator==(const mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sPlaylistPath == roRef.sPlaylistPath);
   bResult = bResult && (e8ListType == roRef.e8ListType);
   bResult = bResult && (u32FilterTag1 == roRef.u32FilterTag1);
   bResult = bResult && (u32FilterTag2 == roRef.u32FilterTag2);
   bResult = bResult && (u32FilterTag3 == roRef.u32FilterTag3);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodResult::mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodResult(const mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodResult& mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodResult::operator=(const mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodResult::mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodResult()
:Status()
 {}

tS32 mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_ADDFILENAMETOINTERNALPLAYLISTBYTAGSMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodResult::~mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodResult::operator==(const mplay_mediaplayerfi_tclMsgAddFilenameToInternalPlaylistByTagsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodStart::mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodStart(const mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ObjectID = coRef.u32ObjectID;
   u8UserID = coRef.u8UserID;
}
mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodStart& mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodStart::operator=(const mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ObjectID = coRef.u32ObjectID;
   u8UserID = coRef.u8UserID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodStart::mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodStart()
:u32ObjectID(0)
,u8UserID(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_STOREPERSONALIZEDFAVORITEMETHODSTART;
}


mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodStart::~mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ObjectID);
   (tVoid) (oIn >> u8UserID);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ObjectID);
   (tVoid) (oOut << u8UserID);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodStart::operator==(const mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ObjectID == roRef.u32ObjectID);
   bResult = bResult && (u8UserID == roRef.u8UserID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodResult::mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodResult(const mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u64FavoriteID = coRef.u64FavoriteID;
}
mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodResult& mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodResult::operator=(const mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u64FavoriteID = coRef.u64FavoriteID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodResult::mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodResult()
:u64FavoriteID(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_STOREPERSONALIZEDFAVORITEMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodResult::~mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u64FavoriteID);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u64FavoriteID);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodResult::operator==(const mplay_mediaplayerfi_tclMsgStorePersonalizedFavoriteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u64FavoriteID == roRef.u64FavoriteID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodStart::mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodStart(const mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ObjectID = coRef.u32ObjectID;
   u8UserID = coRef.u8UserID;
}
mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodStart& mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodStart::operator=(const mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ObjectID = coRef.u32ObjectID;
   u8UserID = coRef.u8UserID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodStart::mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodStart()
:u32ObjectID(0)
,u8UserID(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DELETEPERSONALIZEDFAVORITEMETHODSTART;
}


mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodStart::~mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ObjectID);
   (tVoid) (oIn >> u8UserID);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ObjectID);
   (tVoid) (oOut << u8UserID);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodStart::operator==(const mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ObjectID == roRef.u32ObjectID);
   bResult = bResult && (u8UserID == roRef.u8UserID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodResult::mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodResult(const mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ObjectID = coRef.u32ObjectID;
}
mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodResult& mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodResult::operator=(const mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ObjectID = coRef.u32ObjectID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodResult::mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodResult()
:u32ObjectID(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DELETEPERSONALIZEDFAVORITEMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodResult::~mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ObjectID);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ObjectID);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodResult::operator==(const mplay_mediaplayerfi_tclMsgDeletePersonalizedFavoriteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ObjectID == roRef.u32ObjectID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodStart::mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodStart(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandleOfParent = coRef.u32ListHandleOfParent;
   u32ListHandleOfReplaceableList = coRef.u32ListHandleOfReplaceableList;
   sSearchString = coRef.sSearchString;
   u8DeviceTag = coRef.u8DeviceTag;
   searchType = coRef.searchType;
}
mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodStart& mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodStart::operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandleOfParent = coRef.u32ListHandleOfParent;
   u32ListHandleOfReplaceableList = coRef.u32ListHandleOfReplaceableList;
   sSearchString = coRef.sSearchString;
   u8DeviceTag = coRef.u8DeviceTag;
   searchType = coRef.searchType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodStart::vDestroy()
{
   sSearchString.vDestroy();
}

mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodStart::mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodStart()
:u32ListHandleOfParent(0)
,u32ListHandleOfReplaceableList(0)
,sSearchString()
,u8DeviceTag(0)
,searchType()
 {}

tS32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERGLOBALSEARCHLISTMETHODSTART;
}


mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodStart::~mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 10+sSearchString.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandleOfParent);
   (tVoid) (oIn >> u32ListHandleOfReplaceableList);
   (tVoid) (oIn >> sSearchString);
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> searchType);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandleOfParent);
   (tVoid) (oOut << u32ListHandleOfReplaceableList);
   (tVoid) (oOut << sSearchString);
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << searchType);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodStart::operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandleOfParent == roRef.u32ListHandleOfParent);
   bResult = bResult && (u32ListHandleOfReplaceableList == roRef.u32ListHandleOfReplaceableList);
   bResult = bResult && (sSearchString == roRef.sSearchString);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (searchType == roRef.searchType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodResult::mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodResult(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   u8DeviceTag = coRef.u8DeviceTag;
}
mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodResult& mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodResult::operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   u32ListSize = coRef.u32ListSize;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodResult::mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodResult()
:u32ListHandle(0)
,u32ListSize(0)
,u8DeviceTag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERGLOBALSEARCHLISTMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodResult::~mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> u32ListSize);
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << u32ListSize);
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodResult::operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerGlobalSearchListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (u32ListSize == roRef.u32ListSize);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodStart::mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodStart(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   listID = coRef.listID;
}
mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodStart& mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodStart::operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   listID = coRef.listID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodStart::mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodStart()
:listID(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERALBUMARTLISTMETHODSTART;
}


mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodStart::~mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> listID);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << listID);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodStart::operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (listID == roRef.listID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodResult::mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodResult(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   albumArtListID = coRef.albumArtListID;
   listSize = coRef.listSize;
}
mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodResult& mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodResult::operator=(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   albumArtListID = coRef.albumArtListID;
   listSize = coRef.listSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodResult::mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodResult()
:albumArtListID(0)
,listSize(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CREATEMEDIAPLAYERALBUMARTLISTMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodResult::~mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> albumArtListID);
   (tVoid) (oIn >> listSize);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << albumArtListID);
   (tVoid) (oOut << listSize);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodResult::operator==(const mplay_mediaplayerfi_tclMsgCreateMediaPlayerAlbumArtListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (albumArtListID == roRef.albumArtListID);
   bResult = bResult && (listSize == roRef.listSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodStart::mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodStart(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   albumArtListID = coRef.albumArtListID;
   indicesType = coRef.indicesType;
   oIndices = coRef.oIndices;
}
mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodStart& mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodStart::operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   albumArtListID = coRef.albumArtListID;
   indicesType = coRef.indicesType;
   oIndices = coRef.oIndices;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodStart::vDestroy()
{
   oIndices.vDestroy(); 
}

mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodStart::mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodStart()
:albumArtListID(0)
,indicesType()
,oIndices()
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERALBUMARTLISTSLICEMETHODSTART;
}


mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodStart::~mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+oIndices.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> albumArtListID);
   (tVoid) (oIn >> indicesType);
   (tVoid) (oIn >> oIndices);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << albumArtListID);
   (tVoid) (oOut << indicesType);
   (tVoid) (oOut << oIndices);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodStart::operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (albumArtListID == roRef.albumArtListID);
   bResult = bResult && (indicesType == roRef.indicesType);
   bResult = bResult && (oIndices == roRef.oIndices);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodResult::mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodResult(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   oAlbumartUrls = coRef.oAlbumartUrls;
}
mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodResult& mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodResult::operator=(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oAlbumartUrls = coRef.oAlbumartUrls;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodResult::vDestroy()
{
   oAlbumartUrls.vDestroy(); 
}

mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodResult::mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodResult()
:oAlbumartUrls()
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTMEDIAPLAYERALBUMARTLISTSLICEMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodResult::~mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+oAlbumartUrls.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oAlbumartUrls);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oAlbumartUrls);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodResult::operator==(const mplay_mediaplayerfi_tclMsgRequestMediaPlayerAlbumArtListSliceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oAlbumartUrls == roRef.oAlbumartUrls);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodStart::mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodStart(const mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   eHIDCommand = coRef.eHIDCommand;
   eKeyEvent = coRef.eKeyEvent;
}
mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodStart& mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodStart::operator=(const mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodStart& coRef)
{
   if (this == &coRef) return *this;
   eHIDCommand = coRef.eHIDCommand;
   eKeyEvent = coRef.eKeyEvent;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodStart::mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodStart()
:eHIDCommand()
,eKeyEvent()
 {}

tS32 mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SENDAPPLEHIDCOMMANDMETHODSTART;
}


mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodStart::~mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eHIDCommand);
   (tVoid) (oIn >> eKeyEvent);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eHIDCommand);
   (tVoid) (oOut << eKeyEvent);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodStart::operator==(const mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eHIDCommand == roRef.eHIDCommand);
   bResult = bResult && (eKeyEvent == roRef.eKeyEvent);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodResult::mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodResult(const mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   result = coRef.result;
}
mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodResult& mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodResult::operator=(const mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodResult& coRef)
{
   if (this == &coRef) return *this;
   result = coRef.result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodResult::mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodResult()
:result(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SENDAPPLEHIDCOMMANDMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodResult::~mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> result);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << result);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodResult::operator==(const mplay_mediaplayerfi_tclMsgSendAppleHIDCommandMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (result == roRef.result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodStart::mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodStart(const mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodStart& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   bRequestAction = coRef.bRequestAction;
}
mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodStart& mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodStart::operator=(const mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bRequestAction = coRef.bRequestAction;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodStart::mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodStart()
:bRequestAction(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTBLUETOOTHAUDIODEVICEMETHODSTART;
}


mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodStart::~mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodStart()
{}

tU32 mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bRequestAction);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bRequestAction);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodStart::operator==(const mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bRequestAction == roRef.bRequestAction);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodResult::mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodResult(const mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodResult& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   bRequestStatus = coRef.bRequestStatus;
}
mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodResult& mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodResult::operator=(const mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bRequestStatus = coRef.bRequestStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodResult::mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodResult()
:bRequestStatus(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REQUESTBLUETOOTHAUDIODEVICEMETHODRESULT;
}


mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodResult::~mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodResult()
{}

tU32 mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bRequestStatus);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bRequestStatus);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodResult::operator==(const mplay_mediaplayerfi_tclMsgRequestBluetoothAudioDeviceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bRequestStatus == roRef.bRequestStatus);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgMediaPlayerListChangeUpReg::mplay_mediaplayerfi_tclMsgMediaPlayerListChangeUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgMediaPlayerListChangeUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYERLISTCHANGEUPREG;
}


mplay_mediaplayerfi_tclMsgMediaPlayerListChangeUpReg::~mplay_mediaplayerfi_tclMsgMediaPlayerListChangeUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgMediaPlayerListChangeRelUpReg::mplay_mediaplayerfi_tclMsgMediaPlayerListChangeRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgMediaPlayerListChangeRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYERLISTCHANGERELUPREG;
}


mplay_mediaplayerfi_tclMsgMediaPlayerListChangeRelUpReg::~mplay_mediaplayerfi_tclMsgMediaPlayerListChangeRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgMediaPlayerListChangeStatus::mplay_mediaplayerfi_tclMsgMediaPlayerListChangeStatus(const mplay_mediaplayerfi_tclMsgMediaPlayerListChangeStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   e8Change = coRef.e8Change;
   u32ListSize = coRef.u32ListSize;
   oItems = coRef.oItems;
}
mplay_mediaplayerfi_tclMsgMediaPlayerListChangeStatus& mplay_mediaplayerfi_tclMsgMediaPlayerListChangeStatus::operator=(const mplay_mediaplayerfi_tclMsgMediaPlayerListChangeStatus& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   e8Change = coRef.e8Change;
   u32ListSize = coRef.u32ListSize;
   oItems = coRef.oItems;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgMediaPlayerListChangeStatus::vDestroy()
{
   oItems.vDestroy(); 
}

mplay_mediaplayerfi_tclMsgMediaPlayerListChangeStatus::mplay_mediaplayerfi_tclMsgMediaPlayerListChangeStatus()
:u32ListHandle(0)
,e8Change()
,u32ListSize(0)
,oItems()
 {}

tS32 mplay_mediaplayerfi_tclMsgMediaPlayerListChangeStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYERLISTCHANGESTATUS;
}


mplay_mediaplayerfi_tclMsgMediaPlayerListChangeStatus::~mplay_mediaplayerfi_tclMsgMediaPlayerListChangeStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgMediaPlayerListChangeStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 9+oItems.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgMediaPlayerListChangeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> e8Change);
   (tVoid) (oIn >> u32ListSize);
   (tVoid) (oIn >> oItems);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgMediaPlayerListChangeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << e8Change);
   (tVoid) (oOut << u32ListSize);
   (tVoid) (oOut << oItems);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgMediaPlayerListChangeStatus::operator==(const mplay_mediaplayerfi_tclMsgMediaPlayerListChangeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (e8Change == roRef.e8Change);
   bResult = bResult && (u32ListSize == roRef.u32ListSize);
   bResult = bResult && (oItems == roRef.oItems);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgNowPlayingUpReg::mplay_mediaplayerfi_tclMsgNowPlayingUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgNowPlayingUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_NOWPLAYINGUPREG;
}


mplay_mediaplayerfi_tclMsgNowPlayingUpReg::~mplay_mediaplayerfi_tclMsgNowPlayingUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgNowPlayingRelUpReg::mplay_mediaplayerfi_tclMsgNowPlayingRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgNowPlayingRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_NOWPLAYINGRELUPREG;
}


mplay_mediaplayerfi_tclMsgNowPlayingRelUpReg::~mplay_mediaplayerfi_tclMsgNowPlayingRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgNowPlayingGet::mplay_mediaplayerfi_tclMsgNowPlayingGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgNowPlayingGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_NOWPLAYINGGET;
}


mplay_mediaplayerfi_tclMsgNowPlayingGet::~mplay_mediaplayerfi_tclMsgNowPlayingGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgNowPlayingStatus::mplay_mediaplayerfi_tclMsgNowPlayingStatus(const mplay_mediaplayerfi_tclMsgNowPlayingStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   e8NowPlayingState = coRef.e8NowPlayingState;
   u32Position = coRef.u32Position;
   u32Tag = coRef.u32Tag;
   oMediaObject = coRef.oMediaObject;
}
mplay_mediaplayerfi_tclMsgNowPlayingStatus& mplay_mediaplayerfi_tclMsgNowPlayingStatus::operator=(const mplay_mediaplayerfi_tclMsgNowPlayingStatus& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   e8NowPlayingState = coRef.e8NowPlayingState;
   u32Position = coRef.u32Position;
   u32Tag = coRef.u32Tag;
   oMediaObject = coRef.oMediaObject;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgNowPlayingStatus::vDestroy()
{
   oMediaObject.vDestroy(); 
}

mplay_mediaplayerfi_tclMsgNowPlayingStatus::mplay_mediaplayerfi_tclMsgNowPlayingStatus()
:u32ListHandle(0)
,e8NowPlayingState()
,u32Position(0)
,u32Tag(0)
,oMediaObject()
 {}

tS32 mplay_mediaplayerfi_tclMsgNowPlayingStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_NOWPLAYINGSTATUS;
}


mplay_mediaplayerfi_tclMsgNowPlayingStatus::~mplay_mediaplayerfi_tclMsgNowPlayingStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgNowPlayingStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 13+oMediaObject.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgNowPlayingStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> e8NowPlayingState);
   (tVoid) (oIn >> u32Position);
   (tVoid) (oIn >> u32Tag);
   (tVoid) (oIn >> oMediaObject);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgNowPlayingStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << e8NowPlayingState);
   (tVoid) (oOut << u32Position);
   (tVoid) (oOut << u32Tag);
   (tVoid) (oOut << oMediaObject);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgNowPlayingStatus::operator==(const mplay_mediaplayerfi_tclMsgNowPlayingStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (e8NowPlayingState == roRef.e8NowPlayingState);
   bResult = bResult && (u32Position == roRef.u32Position);
   bResult = bResult && (u32Tag == roRef.u32Tag);
   bResult = bResult && (oMediaObject == roRef.oMediaObject);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgPlaytimeUpReg::mplay_mediaplayerfi_tclMsgPlaytimeUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgPlaytimeUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYTIMEUPREG;
}


mplay_mediaplayerfi_tclMsgPlaytimeUpReg::~mplay_mediaplayerfi_tclMsgPlaytimeUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgPlaytimeRelUpReg::mplay_mediaplayerfi_tclMsgPlaytimeRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgPlaytimeRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYTIMERELUPREG;
}


mplay_mediaplayerfi_tclMsgPlaytimeRelUpReg::~mplay_mediaplayerfi_tclMsgPlaytimeRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgPlaytimeGet::mplay_mediaplayerfi_tclMsgPlaytimeGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgPlaytimeGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYTIMEGET;
}


mplay_mediaplayerfi_tclMsgPlaytimeGet::~mplay_mediaplayerfi_tclMsgPlaytimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgPlaytimeStatus::mplay_mediaplayerfi_tclMsgPlaytimeStatus(const mplay_mediaplayerfi_tclMsgPlaytimeStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ElapsedPlaytime = coRef.u32ElapsedPlaytime;
   u32TotalPlaytime = coRef.u32TotalPlaytime;
   u32Tag = coRef.u32Tag;
}
mplay_mediaplayerfi_tclMsgPlaytimeStatus& mplay_mediaplayerfi_tclMsgPlaytimeStatus::operator=(const mplay_mediaplayerfi_tclMsgPlaytimeStatus& coRef)
{
   if (this == &coRef) return *this;
   u32ElapsedPlaytime = coRef.u32ElapsedPlaytime;
   u32TotalPlaytime = coRef.u32TotalPlaytime;
   u32Tag = coRef.u32Tag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgPlaytimeStatus::mplay_mediaplayerfi_tclMsgPlaytimeStatus()
:u32ElapsedPlaytime(0)
,u32TotalPlaytime(0)
,u32Tag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgPlaytimeStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYTIMESTATUS;
}


mplay_mediaplayerfi_tclMsgPlaytimeStatus::~mplay_mediaplayerfi_tclMsgPlaytimeStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgPlaytimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgPlaytimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ElapsedPlaytime);
   (tVoid) (oIn >> u32TotalPlaytime);
   (tVoid) (oIn >> u32Tag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgPlaytimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ElapsedPlaytime);
   (tVoid) (oOut << u32TotalPlaytime);
   (tVoid) (oOut << u32Tag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgPlaytimeStatus::operator==(const mplay_mediaplayerfi_tclMsgPlaytimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ElapsedPlaytime == roRef.u32ElapsedPlaytime);
   bResult = bResult && (u32TotalPlaytime == roRef.u32TotalPlaytime);
   bResult = bResult && (u32Tag == roRef.u32Tag);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgPlaybackStateUpReg::mplay_mediaplayerfi_tclMsgPlaybackStateUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgPlaybackStateUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKSTATEUPREG;
}


mplay_mediaplayerfi_tclMsgPlaybackStateUpReg::~mplay_mediaplayerfi_tclMsgPlaybackStateUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgPlaybackStateRelUpReg::mplay_mediaplayerfi_tclMsgPlaybackStateRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgPlaybackStateRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKSTATERELUPREG;
}


mplay_mediaplayerfi_tclMsgPlaybackStateRelUpReg::~mplay_mediaplayerfi_tclMsgPlaybackStateRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgPlaybackStateGet::mplay_mediaplayerfi_tclMsgPlaybackStateGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgPlaybackStateGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKSTATEGET;
}


mplay_mediaplayerfi_tclMsgPlaybackStateGet::~mplay_mediaplayerfi_tclMsgPlaybackStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgPlaybackStateStatus::mplay_mediaplayerfi_tclMsgPlaybackStateStatus(const mplay_mediaplayerfi_tclMsgPlaybackStateStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8State = coRef.e8State;
}
mplay_mediaplayerfi_tclMsgPlaybackStateStatus& mplay_mediaplayerfi_tclMsgPlaybackStateStatus::operator=(const mplay_mediaplayerfi_tclMsgPlaybackStateStatus& coRef)
{
   if (this == &coRef) return *this;
   e8State = coRef.e8State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgPlaybackStateStatus::mplay_mediaplayerfi_tclMsgPlaybackStateStatus()
:e8State()
 {}

tS32 mplay_mediaplayerfi_tclMsgPlaybackStateStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKSTATESTATUS;
}


mplay_mediaplayerfi_tclMsgPlaybackStateStatus::~mplay_mediaplayerfi_tclMsgPlaybackStateStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgPlaybackStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgPlaybackStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8State);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgPlaybackStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8State);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgPlaybackStateStatus::operator==(const mplay_mediaplayerfi_tclMsgPlaybackStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8State == roRef.e8State);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgPlaybackModeUpReg::mplay_mediaplayerfi_tclMsgPlaybackModeUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgPlaybackModeUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKMODEUPREG;
}


mplay_mediaplayerfi_tclMsgPlaybackModeUpReg::~mplay_mediaplayerfi_tclMsgPlaybackModeUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgPlaybackModeRelUpReg::mplay_mediaplayerfi_tclMsgPlaybackModeRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgPlaybackModeRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKMODERELUPREG;
}


mplay_mediaplayerfi_tclMsgPlaybackModeRelUpReg::~mplay_mediaplayerfi_tclMsgPlaybackModeRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgPlaybackModeGet::mplay_mediaplayerfi_tclMsgPlaybackModeGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgPlaybackModeGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKMODEGET;
}


mplay_mediaplayerfi_tclMsgPlaybackModeGet::~mplay_mediaplayerfi_tclMsgPlaybackModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgPlaybackModeSet::mplay_mediaplayerfi_tclMsgPlaybackModeSet(const mplay_mediaplayerfi_tclMsgPlaybackModeSet& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8Mode = coRef.e8Mode;
}
mplay_mediaplayerfi_tclMsgPlaybackModeSet& mplay_mediaplayerfi_tclMsgPlaybackModeSet::operator=(const mplay_mediaplayerfi_tclMsgPlaybackModeSet& coRef)
{
   if (this == &coRef) return *this;
   e8Mode = coRef.e8Mode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgPlaybackModeSet::mplay_mediaplayerfi_tclMsgPlaybackModeSet()
:e8Mode()
 {}

tS32 mplay_mediaplayerfi_tclMsgPlaybackModeSet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKMODESET;
}


mplay_mediaplayerfi_tclMsgPlaybackModeSet::~mplay_mediaplayerfi_tclMsgPlaybackModeSet()
{}

tU32 mplay_mediaplayerfi_tclMsgPlaybackModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgPlaybackModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Mode);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgPlaybackModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Mode);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgPlaybackModeSet::operator==(const mplay_mediaplayerfi_tclMsgPlaybackModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Mode == roRef.e8Mode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgPlaybackModeStatus::mplay_mediaplayerfi_tclMsgPlaybackModeStatus(const mplay_mediaplayerfi_tclMsgPlaybackModeStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8Mode = coRef.e8Mode;
}
mplay_mediaplayerfi_tclMsgPlaybackModeStatus& mplay_mediaplayerfi_tclMsgPlaybackModeStatus::operator=(const mplay_mediaplayerfi_tclMsgPlaybackModeStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Mode = coRef.e8Mode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgPlaybackModeStatus::mplay_mediaplayerfi_tclMsgPlaybackModeStatus()
:e8Mode()
 {}

tS32 mplay_mediaplayerfi_tclMsgPlaybackModeStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKMODESTATUS;
}


mplay_mediaplayerfi_tclMsgPlaybackModeStatus::~mplay_mediaplayerfi_tclMsgPlaybackModeStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgPlaybackModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgPlaybackModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Mode);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgPlaybackModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Mode);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgPlaybackModeStatus::operator==(const mplay_mediaplayerfi_tclMsgPlaybackModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Mode == roRef.e8Mode);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgRepeatModeUpReg::mplay_mediaplayerfi_tclMsgRepeatModeUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgRepeatModeUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REPEATMODEUPREG;
}


mplay_mediaplayerfi_tclMsgRepeatModeUpReg::~mplay_mediaplayerfi_tclMsgRepeatModeUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgRepeatModeRelUpReg::mplay_mediaplayerfi_tclMsgRepeatModeRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgRepeatModeRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REPEATMODERELUPREG;
}


mplay_mediaplayerfi_tclMsgRepeatModeRelUpReg::~mplay_mediaplayerfi_tclMsgRepeatModeRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgRepeatModeGet::mplay_mediaplayerfi_tclMsgRepeatModeGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgRepeatModeGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REPEATMODEGET;
}


mplay_mediaplayerfi_tclMsgRepeatModeGet::~mplay_mediaplayerfi_tclMsgRepeatModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRepeatModeSet::mplay_mediaplayerfi_tclMsgRepeatModeSet(const mplay_mediaplayerfi_tclMsgRepeatModeSet& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8Repeat = coRef.e8Repeat;
}
mplay_mediaplayerfi_tclMsgRepeatModeSet& mplay_mediaplayerfi_tclMsgRepeatModeSet::operator=(const mplay_mediaplayerfi_tclMsgRepeatModeSet& coRef)
{
   if (this == &coRef) return *this;
   e8Repeat = coRef.e8Repeat;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgRepeatModeSet::mplay_mediaplayerfi_tclMsgRepeatModeSet()
:e8Repeat()
 {}

tS32 mplay_mediaplayerfi_tclMsgRepeatModeSet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REPEATMODESET;
}


mplay_mediaplayerfi_tclMsgRepeatModeSet::~mplay_mediaplayerfi_tclMsgRepeatModeSet()
{}

tU32 mplay_mediaplayerfi_tclMsgRepeatModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRepeatModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Repeat);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRepeatModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Repeat);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRepeatModeSet::operator==(const mplay_mediaplayerfi_tclMsgRepeatModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Repeat == roRef.e8Repeat);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRepeatModeStatus::mplay_mediaplayerfi_tclMsgRepeatModeStatus(const mplay_mediaplayerfi_tclMsgRepeatModeStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8Repeat = coRef.e8Repeat;
}
mplay_mediaplayerfi_tclMsgRepeatModeStatus& mplay_mediaplayerfi_tclMsgRepeatModeStatus::operator=(const mplay_mediaplayerfi_tclMsgRepeatModeStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Repeat = coRef.e8Repeat;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgRepeatModeStatus::mplay_mediaplayerfi_tclMsgRepeatModeStatus()
:e8Repeat()
 {}

tS32 mplay_mediaplayerfi_tclMsgRepeatModeStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_REPEATMODESTATUS;
}


mplay_mediaplayerfi_tclMsgRepeatModeStatus::~mplay_mediaplayerfi_tclMsgRepeatModeStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgRepeatModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRepeatModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Repeat);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRepeatModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Repeat);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRepeatModeStatus::operator==(const mplay_mediaplayerfi_tclMsgRepeatModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Repeat == roRef.e8Repeat);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgIndexingStateUpReg::mplay_mediaplayerfi_tclMsgIndexingStateUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgIndexingStateUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_INDEXINGSTATEUPREG;
}


mplay_mediaplayerfi_tclMsgIndexingStateUpReg::~mplay_mediaplayerfi_tclMsgIndexingStateUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgIndexingStateRelUpReg::mplay_mediaplayerfi_tclMsgIndexingStateRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgIndexingStateRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_INDEXINGSTATERELUPREG;
}


mplay_mediaplayerfi_tclMsgIndexingStateRelUpReg::~mplay_mediaplayerfi_tclMsgIndexingStateRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgIndexingStateGet::mplay_mediaplayerfi_tclMsgIndexingStateGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgIndexingStateGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_INDEXINGSTATEGET;
}


mplay_mediaplayerfi_tclMsgIndexingStateGet::~mplay_mediaplayerfi_tclMsgIndexingStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgIndexingStateStatus::mplay_mediaplayerfi_tclMsgIndexingStateStatus(const mplay_mediaplayerfi_tclMsgIndexingStateStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   oIndexingStateResult = coRef.oIndexingStateResult;
}
mplay_mediaplayerfi_tclMsgIndexingStateStatus& mplay_mediaplayerfi_tclMsgIndexingStateStatus::operator=(const mplay_mediaplayerfi_tclMsgIndexingStateStatus& coRef)
{
   if (this == &coRef) return *this;
   oIndexingStateResult = coRef.oIndexingStateResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgIndexingStateStatus::vDestroy()
{
   oIndexingStateResult.vDestroy(); 
}

mplay_mediaplayerfi_tclMsgIndexingStateStatus::mplay_mediaplayerfi_tclMsgIndexingStateStatus()
:oIndexingStateResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgIndexingStateStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_INDEXINGSTATESTATUS;
}


mplay_mediaplayerfi_tclMsgIndexingStateStatus::~mplay_mediaplayerfi_tclMsgIndexingStateStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgIndexingStateStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+oIndexingStateResult.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgIndexingStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oIndexingStateResult);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgIndexingStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oIndexingStateResult);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgIndexingStateStatus::operator==(const mplay_mediaplayerfi_tclMsgIndexingStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oIndexingStateResult == roRef.oIndexingStateResult);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsUpReg::mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYERDEVICECONNECTIONSUPREG;
}


mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsUpReg::~mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsRelUpReg::mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYERDEVICECONNECTIONSRELUPREG;
}


mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsRelUpReg::~mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsGet::mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYERDEVICECONNECTIONSGET;
}


mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsGet::~mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsStatus::mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsStatus(const mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   oDeviceInfo = coRef.oDeviceInfo;
}
mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsStatus& mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsStatus::operator=(const mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsStatus& coRef)
{
   if (this == &coRef) return *this;
   oDeviceInfo = coRef.oDeviceInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsStatus::vDestroy()
{
   oDeviceInfo.vDestroy(); 
}

mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsStatus::mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsStatus()
:oDeviceInfo()
 {}

tS32 mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYERDEVICECONNECTIONSSTATUS;
}


mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsStatus::~mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+oDeviceInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oDeviceInfo);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oDeviceInfo);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsStatus::operator==(const mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oDeviceInfo == roRef.oDeviceInfo);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgActiveMediaDeviceUpReg::mplay_mediaplayerfi_tclMsgActiveMediaDeviceUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgActiveMediaDeviceUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_ACTIVEMEDIADEVICEUPREG;
}


mplay_mediaplayerfi_tclMsgActiveMediaDeviceUpReg::~mplay_mediaplayerfi_tclMsgActiveMediaDeviceUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgActiveMediaDeviceRelUpReg::mplay_mediaplayerfi_tclMsgActiveMediaDeviceRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgActiveMediaDeviceRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_ACTIVEMEDIADEVICERELUPREG;
}


mplay_mediaplayerfi_tclMsgActiveMediaDeviceRelUpReg::~mplay_mediaplayerfi_tclMsgActiveMediaDeviceRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgActiveMediaDeviceGet::mplay_mediaplayerfi_tclMsgActiveMediaDeviceGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgActiveMediaDeviceGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_ACTIVEMEDIADEVICEGET;
}


mplay_mediaplayerfi_tclMsgActiveMediaDeviceGet::~mplay_mediaplayerfi_tclMsgActiveMediaDeviceGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgActiveMediaDeviceSet::mplay_mediaplayerfi_tclMsgActiveMediaDeviceSet(const mplay_mediaplayerfi_tclMsgActiveMediaDeviceSet& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u8DeviceTag = coRef.u8DeviceTag;
   bDeviceActiveSource = coRef.bDeviceActiveSource;
}
mplay_mediaplayerfi_tclMsgActiveMediaDeviceSet& mplay_mediaplayerfi_tclMsgActiveMediaDeviceSet::operator=(const mplay_mediaplayerfi_tclMsgActiveMediaDeviceSet& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceTag = coRef.u8DeviceTag;
   bDeviceActiveSource = coRef.bDeviceActiveSource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgActiveMediaDeviceSet::mplay_mediaplayerfi_tclMsgActiveMediaDeviceSet()
:u8DeviceTag(0)
,bDeviceActiveSource(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgActiveMediaDeviceSet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_ACTIVEMEDIADEVICESET;
}


mplay_mediaplayerfi_tclMsgActiveMediaDeviceSet::~mplay_mediaplayerfi_tclMsgActiveMediaDeviceSet()
{}

tU32 mplay_mediaplayerfi_tclMsgActiveMediaDeviceSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgActiveMediaDeviceSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> bDeviceActiveSource);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgActiveMediaDeviceSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << bDeviceActiveSource);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgActiveMediaDeviceSet::operator==(const mplay_mediaplayerfi_tclMsgActiveMediaDeviceSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (bDeviceActiveSource == roRef.bDeviceActiveSource);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgActiveMediaDeviceStatus::mplay_mediaplayerfi_tclMsgActiveMediaDeviceStatus(const mplay_mediaplayerfi_tclMsgActiveMediaDeviceStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u8DeviceTag = coRef.u8DeviceTag;
   bDeviceActiveSource = coRef.bDeviceActiveSource;
   bScanSupported = coRef.bScanSupported;
}
mplay_mediaplayerfi_tclMsgActiveMediaDeviceStatus& mplay_mediaplayerfi_tclMsgActiveMediaDeviceStatus::operator=(const mplay_mediaplayerfi_tclMsgActiveMediaDeviceStatus& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceTag = coRef.u8DeviceTag;
   bDeviceActiveSource = coRef.bDeviceActiveSource;
   bScanSupported = coRef.bScanSupported;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgActiveMediaDeviceStatus::mplay_mediaplayerfi_tclMsgActiveMediaDeviceStatus()
:u8DeviceTag(0)
,bDeviceActiveSource(0)
,bScanSupported(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgActiveMediaDeviceStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_ACTIVEMEDIADEVICESTATUS;
}


mplay_mediaplayerfi_tclMsgActiveMediaDeviceStatus::~mplay_mediaplayerfi_tclMsgActiveMediaDeviceStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgActiveMediaDeviceStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgActiveMediaDeviceStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> bDeviceActiveSource);
   (tVoid) (oIn >> bScanSupported);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgActiveMediaDeviceStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << bDeviceActiveSource);
   (tVoid) (oOut << bScanSupported);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgActiveMediaDeviceStatus::operator==(const mplay_mediaplayerfi_tclMsgActiveMediaDeviceStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (bDeviceActiveSource == roRef.bDeviceActiveSource);
   bResult = bResult && (bScanSupported == roRef.bScanSupported);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgMyMediaSupportedGet::mplay_mediaplayerfi_tclMsgMyMediaSupportedGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgMyMediaSupportedGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_MYMEDIASUPPORTEDGET;
}


mplay_mediaplayerfi_tclMsgMyMediaSupportedGet::~mplay_mediaplayerfi_tclMsgMyMediaSupportedGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgMyMediaSupportedStatus::mplay_mediaplayerfi_tclMsgMyMediaSupportedStatus(const mplay_mediaplayerfi_tclMsgMyMediaSupportedStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   bMyMediaSupportedFlag = coRef.bMyMediaSupportedFlag;
}
mplay_mediaplayerfi_tclMsgMyMediaSupportedStatus& mplay_mediaplayerfi_tclMsgMyMediaSupportedStatus::operator=(const mplay_mediaplayerfi_tclMsgMyMediaSupportedStatus& coRef)
{
   if (this == &coRef) return *this;
   bMyMediaSupportedFlag = coRef.bMyMediaSupportedFlag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgMyMediaSupportedStatus::mplay_mediaplayerfi_tclMsgMyMediaSupportedStatus()
:bMyMediaSupportedFlag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgMyMediaSupportedStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_MYMEDIASUPPORTEDSTATUS;
}


mplay_mediaplayerfi_tclMsgMyMediaSupportedStatus::~mplay_mediaplayerfi_tclMsgMyMediaSupportedStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgMyMediaSupportedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgMyMediaSupportedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bMyMediaSupportedFlag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgMyMediaSupportedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bMyMediaSupportedFlag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgMyMediaSupportedStatus::operator==(const mplay_mediaplayerfi_tclMsgMyMediaSupportedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bMyMediaSupportedFlag == roRef.bMyMediaSupportedFlag);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgCurrentFolderPathUpReg::mplay_mediaplayerfi_tclMsgCurrentFolderPathUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgCurrentFolderPathUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CURRENTFOLDERPATHUPREG;
}


mplay_mediaplayerfi_tclMsgCurrentFolderPathUpReg::~mplay_mediaplayerfi_tclMsgCurrentFolderPathUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgCurrentFolderPathRelUpReg::mplay_mediaplayerfi_tclMsgCurrentFolderPathRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgCurrentFolderPathRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CURRENTFOLDERPATHRELUPREG;
}


mplay_mediaplayerfi_tclMsgCurrentFolderPathRelUpReg::~mplay_mediaplayerfi_tclMsgCurrentFolderPathRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgCurrentFolderPathGet::mplay_mediaplayerfi_tclMsgCurrentFolderPathGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgCurrentFolderPathGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CURRENTFOLDERPATHGET;
}


mplay_mediaplayerfi_tclMsgCurrentFolderPathGet::~mplay_mediaplayerfi_tclMsgCurrentFolderPathGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgCurrentFolderPathStatus::mplay_mediaplayerfi_tclMsgCurrentFolderPathStatus(const mplay_mediaplayerfi_tclMsgCurrentFolderPathStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   sCurrentFolderPath = coRef.sCurrentFolderPath;
   u32ListHandle = coRef.u32ListHandle;
   Tag = coRef.Tag;
}
mplay_mediaplayerfi_tclMsgCurrentFolderPathStatus& mplay_mediaplayerfi_tclMsgCurrentFolderPathStatus::operator=(const mplay_mediaplayerfi_tclMsgCurrentFolderPathStatus& coRef)
{
   if (this == &coRef) return *this;
   sCurrentFolderPath = coRef.sCurrentFolderPath;
   u32ListHandle = coRef.u32ListHandle;
   Tag = coRef.Tag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgCurrentFolderPathStatus::vDestroy()
{
   sCurrentFolderPath.vDestroy();
}

mplay_mediaplayerfi_tclMsgCurrentFolderPathStatus::mplay_mediaplayerfi_tclMsgCurrentFolderPathStatus()
:sCurrentFolderPath()
,u32ListHandle(0)
,Tag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgCurrentFolderPathStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CURRENTFOLDERPATHSTATUS;
}


mplay_mediaplayerfi_tclMsgCurrentFolderPathStatus::~mplay_mediaplayerfi_tclMsgCurrentFolderPathStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgCurrentFolderPathStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 12+sCurrentFolderPath.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgCurrentFolderPathStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sCurrentFolderPath);
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> Tag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgCurrentFolderPathStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sCurrentFolderPath);
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << Tag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgCurrentFolderPathStatus::operator==(const mplay_mediaplayerfi_tclMsgCurrentFolderPathStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sCurrentFolderPath == roRef.sCurrentFolderPath);
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (Tag == roRef.Tag);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgScanModeUpReg::mplay_mediaplayerfi_tclMsgScanModeUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgScanModeUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SCANMODEUPREG;
}


mplay_mediaplayerfi_tclMsgScanModeUpReg::~mplay_mediaplayerfi_tclMsgScanModeUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgScanModeRelUpReg::mplay_mediaplayerfi_tclMsgScanModeRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgScanModeRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SCANMODERELUPREG;
}


mplay_mediaplayerfi_tclMsgScanModeRelUpReg::~mplay_mediaplayerfi_tclMsgScanModeRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgScanModeGet::mplay_mediaplayerfi_tclMsgScanModeGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgScanModeGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SCANMODEGET;
}


mplay_mediaplayerfi_tclMsgScanModeGet::~mplay_mediaplayerfi_tclMsgScanModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgScanModeSet::mplay_mediaplayerfi_tclMsgScanModeSet(const mplay_mediaplayerfi_tclMsgScanModeSet& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   bScanMode = coRef.bScanMode;
}
mplay_mediaplayerfi_tclMsgScanModeSet& mplay_mediaplayerfi_tclMsgScanModeSet::operator=(const mplay_mediaplayerfi_tclMsgScanModeSet& coRef)
{
   if (this == &coRef) return *this;
   bScanMode = coRef.bScanMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgScanModeSet::mplay_mediaplayerfi_tclMsgScanModeSet()
:bScanMode(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgScanModeSet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SCANMODESET;
}


mplay_mediaplayerfi_tclMsgScanModeSet::~mplay_mediaplayerfi_tclMsgScanModeSet()
{}

tU32 mplay_mediaplayerfi_tclMsgScanModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgScanModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bScanMode);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgScanModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bScanMode);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgScanModeSet::operator==(const mplay_mediaplayerfi_tclMsgScanModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bScanMode == roRef.bScanMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgScanModeStatus::mplay_mediaplayerfi_tclMsgScanModeStatus(const mplay_mediaplayerfi_tclMsgScanModeStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   bScanMode = coRef.bScanMode;
}
mplay_mediaplayerfi_tclMsgScanModeStatus& mplay_mediaplayerfi_tclMsgScanModeStatus::operator=(const mplay_mediaplayerfi_tclMsgScanModeStatus& coRef)
{
   if (this == &coRef) return *this;
   bScanMode = coRef.bScanMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgScanModeStatus::mplay_mediaplayerfi_tclMsgScanModeStatus()
:bScanMode(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgScanModeStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SCANMODESTATUS;
}


mplay_mediaplayerfi_tclMsgScanModeStatus::~mplay_mediaplayerfi_tclMsgScanModeStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgScanModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgScanModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bScanMode);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgScanModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bScanMode);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgScanModeStatus::operator==(const mplay_mediaplayerfi_tclMsgScanModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bScanMode == roRef.bScanMode);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgDiscErrorUpReg::mplay_mediaplayerfi_tclMsgDiscErrorUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgDiscErrorUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DISCERRORUPREG;
}


mplay_mediaplayerfi_tclMsgDiscErrorUpReg::~mplay_mediaplayerfi_tclMsgDiscErrorUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgDiscErrorRelUpReg::mplay_mediaplayerfi_tclMsgDiscErrorRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgDiscErrorRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DISCERRORRELUPREG;
}


mplay_mediaplayerfi_tclMsgDiscErrorRelUpReg::~mplay_mediaplayerfi_tclMsgDiscErrorRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgDiscErrorGet::mplay_mediaplayerfi_tclMsgDiscErrorGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgDiscErrorGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DISCERRORGET;
}


mplay_mediaplayerfi_tclMsgDiscErrorGet::~mplay_mediaplayerfi_tclMsgDiscErrorGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDiscErrorStatus::mplay_mediaplayerfi_tclMsgDiscErrorStatus(const mplay_mediaplayerfi_tclMsgDiscErrorStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   bIsError = coRef.bIsError;
   e8DiscError = coRef.e8DiscError;
}
mplay_mediaplayerfi_tclMsgDiscErrorStatus& mplay_mediaplayerfi_tclMsgDiscErrorStatus::operator=(const mplay_mediaplayerfi_tclMsgDiscErrorStatus& coRef)
{
   if (this == &coRef) return *this;
   bIsError = coRef.bIsError;
   e8DiscError = coRef.e8DiscError;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgDiscErrorStatus::mplay_mediaplayerfi_tclMsgDiscErrorStatus()
:bIsError(0)
,e8DiscError()
 {}

tS32 mplay_mediaplayerfi_tclMsgDiscErrorStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DISCERRORSTATUS;
}


mplay_mediaplayerfi_tclMsgDiscErrorStatus::~mplay_mediaplayerfi_tclMsgDiscErrorStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgDiscErrorStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDiscErrorStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bIsError);
   (tVoid) (oIn >> e8DiscError);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDiscErrorStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bIsError);
   (tVoid) (oOut << e8DiscError);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDiscErrorStatus::operator==(const mplay_mediaplayerfi_tclMsgDiscErrorStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bIsError == roRef.bIsError);
   bResult = bResult && (e8DiscError == roRef.e8DiscError);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgDiscMechanicalInfoUpReg::mplay_mediaplayerfi_tclMsgDiscMechanicalInfoUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgDiscMechanicalInfoUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DISCMECHANICALINFOUPREG;
}


mplay_mediaplayerfi_tclMsgDiscMechanicalInfoUpReg::~mplay_mediaplayerfi_tclMsgDiscMechanicalInfoUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgDiscMechanicalInfoRelUpReg::mplay_mediaplayerfi_tclMsgDiscMechanicalInfoRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgDiscMechanicalInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DISCMECHANICALINFORELUPREG;
}


mplay_mediaplayerfi_tclMsgDiscMechanicalInfoRelUpReg::~mplay_mediaplayerfi_tclMsgDiscMechanicalInfoRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgDiscMechanicalInfoGet::mplay_mediaplayerfi_tclMsgDiscMechanicalInfoGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgDiscMechanicalInfoGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DISCMECHANICALINFOGET;
}


mplay_mediaplayerfi_tclMsgDiscMechanicalInfoGet::~mplay_mediaplayerfi_tclMsgDiscMechanicalInfoGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDiscMechanicalInfoStatus::mplay_mediaplayerfi_tclMsgDiscMechanicalInfoStatus(const mplay_mediaplayerfi_tclMsgDiscMechanicalInfoStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8DiscMechanicalInfo = coRef.e8DiscMechanicalInfo;
}
mplay_mediaplayerfi_tclMsgDiscMechanicalInfoStatus& mplay_mediaplayerfi_tclMsgDiscMechanicalInfoStatus::operator=(const mplay_mediaplayerfi_tclMsgDiscMechanicalInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   e8DiscMechanicalInfo = coRef.e8DiscMechanicalInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgDiscMechanicalInfoStatus::mplay_mediaplayerfi_tclMsgDiscMechanicalInfoStatus()
:e8DiscMechanicalInfo()
 {}

tS32 mplay_mediaplayerfi_tclMsgDiscMechanicalInfoStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DISCMECHANICALINFOSTATUS;
}


mplay_mediaplayerfi_tclMsgDiscMechanicalInfoStatus::~mplay_mediaplayerfi_tclMsgDiscMechanicalInfoStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgDiscMechanicalInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDiscMechanicalInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8DiscMechanicalInfo);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDiscMechanicalInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8DiscMechanicalInfo);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDiscMechanicalInfoStatus::operator==(const mplay_mediaplayerfi_tclMsgDiscMechanicalInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8DiscMechanicalInfo == roRef.e8DiscMechanicalInfo);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgCMSkipAvailableUpReg::mplay_mediaplayerfi_tclMsgCMSkipAvailableUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgCMSkipAvailableUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CMSKIPAVAILABLEUPREG;
}


mplay_mediaplayerfi_tclMsgCMSkipAvailableUpReg::~mplay_mediaplayerfi_tclMsgCMSkipAvailableUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgCMSkipAvailableRelUpReg::mplay_mediaplayerfi_tclMsgCMSkipAvailableRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgCMSkipAvailableRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CMSKIPAVAILABLERELUPREG;
}


mplay_mediaplayerfi_tclMsgCMSkipAvailableRelUpReg::~mplay_mediaplayerfi_tclMsgCMSkipAvailableRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgCMSkipAvailableGet::mplay_mediaplayerfi_tclMsgCMSkipAvailableGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgCMSkipAvailableGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CMSKIPAVAILABLEGET;
}


mplay_mediaplayerfi_tclMsgCMSkipAvailableGet::~mplay_mediaplayerfi_tclMsgCMSkipAvailableGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgCMSkipAvailableStatus::mplay_mediaplayerfi_tclMsgCMSkipAvailableStatus(const mplay_mediaplayerfi_tclMsgCMSkipAvailableStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   bCMSkipAvailable = coRef.bCMSkipAvailable;
}
mplay_mediaplayerfi_tclMsgCMSkipAvailableStatus& mplay_mediaplayerfi_tclMsgCMSkipAvailableStatus::operator=(const mplay_mediaplayerfi_tclMsgCMSkipAvailableStatus& coRef)
{
   if (this == &coRef) return *this;
   bCMSkipAvailable = coRef.bCMSkipAvailable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgCMSkipAvailableStatus::mplay_mediaplayerfi_tclMsgCMSkipAvailableStatus()
:bCMSkipAvailable(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgCMSkipAvailableStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_CMSKIPAVAILABLESTATUS;
}


mplay_mediaplayerfi_tclMsgCMSkipAvailableStatus::~mplay_mediaplayerfi_tclMsgCMSkipAvailableStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgCMSkipAvailableStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgCMSkipAvailableStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bCMSkipAvailable);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgCMSkipAvailableStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bCMSkipAvailable);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgCMSkipAvailableStatus::operator==(const mplay_mediaplayerfi_tclMsgCMSkipAvailableStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bCMSkipAvailable == roRef.bCMSkipAvailable);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgDirectSelectAvailableUpReg::mplay_mediaplayerfi_tclMsgDirectSelectAvailableUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgDirectSelectAvailableUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DIRECTSELECTAVAILABLEUPREG;
}


mplay_mediaplayerfi_tclMsgDirectSelectAvailableUpReg::~mplay_mediaplayerfi_tclMsgDirectSelectAvailableUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgDirectSelectAvailableRelUpReg::mplay_mediaplayerfi_tclMsgDirectSelectAvailableRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgDirectSelectAvailableRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DIRECTSELECTAVAILABLERELUPREG;
}


mplay_mediaplayerfi_tclMsgDirectSelectAvailableRelUpReg::~mplay_mediaplayerfi_tclMsgDirectSelectAvailableRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgDirectSelectAvailableGet::mplay_mediaplayerfi_tclMsgDirectSelectAvailableGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgDirectSelectAvailableGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DIRECTSELECTAVAILABLEGET;
}


mplay_mediaplayerfi_tclMsgDirectSelectAvailableGet::~mplay_mediaplayerfi_tclMsgDirectSelectAvailableGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDirectSelectAvailableStatus::mplay_mediaplayerfi_tclMsgDirectSelectAvailableStatus(const mplay_mediaplayerfi_tclMsgDirectSelectAvailableStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   bDirectSelectAvailable = coRef.bDirectSelectAvailable;
}
mplay_mediaplayerfi_tclMsgDirectSelectAvailableStatus& mplay_mediaplayerfi_tclMsgDirectSelectAvailableStatus::operator=(const mplay_mediaplayerfi_tclMsgDirectSelectAvailableStatus& coRef)
{
   if (this == &coRef) return *this;
   bDirectSelectAvailable = coRef.bDirectSelectAvailable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgDirectSelectAvailableStatus::mplay_mediaplayerfi_tclMsgDirectSelectAvailableStatus()
:bDirectSelectAvailable(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgDirectSelectAvailableStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DIRECTSELECTAVAILABLESTATUS;
}


mplay_mediaplayerfi_tclMsgDirectSelectAvailableStatus::~mplay_mediaplayerfi_tclMsgDirectSelectAvailableStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgDirectSelectAvailableStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDirectSelectAvailableStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bDirectSelectAvailable);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDirectSelectAvailableStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bDirectSelectAvailable);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDirectSelectAvailableStatus::operator==(const mplay_mediaplayerfi_tclMsgDirectSelectAvailableStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bDirectSelectAvailable == roRef.bDirectSelectAvailable);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgDVDAngleInfoUpReg::mplay_mediaplayerfi_tclMsgDVDAngleInfoUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDAngleInfoUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDANGLEINFOUPREG;
}


mplay_mediaplayerfi_tclMsgDVDAngleInfoUpReg::~mplay_mediaplayerfi_tclMsgDVDAngleInfoUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgDVDAngleInfoRelUpReg::mplay_mediaplayerfi_tclMsgDVDAngleInfoRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDAngleInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDANGLEINFORELUPREG;
}


mplay_mediaplayerfi_tclMsgDVDAngleInfoRelUpReg::~mplay_mediaplayerfi_tclMsgDVDAngleInfoRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgDVDAngleInfoGet::mplay_mediaplayerfi_tclMsgDVDAngleInfoGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDAngleInfoGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDANGLEINFOGET;
}


mplay_mediaplayerfi_tclMsgDVDAngleInfoGet::~mplay_mediaplayerfi_tclMsgDVDAngleInfoGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDVDAngleInfoStatus::mplay_mediaplayerfi_tclMsgDVDAngleInfoStatus(const mplay_mediaplayerfi_tclMsgDVDAngleInfoStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8CurrentAngle = coRef.e8CurrentAngle;
   e8TotalAngle = coRef.e8TotalAngle;
}
mplay_mediaplayerfi_tclMsgDVDAngleInfoStatus& mplay_mediaplayerfi_tclMsgDVDAngleInfoStatus::operator=(const mplay_mediaplayerfi_tclMsgDVDAngleInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   e8CurrentAngle = coRef.e8CurrentAngle;
   e8TotalAngle = coRef.e8TotalAngle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgDVDAngleInfoStatus::mplay_mediaplayerfi_tclMsgDVDAngleInfoStatus()
:e8CurrentAngle()
,e8TotalAngle()
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDAngleInfoStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDANGLEINFOSTATUS;
}


mplay_mediaplayerfi_tclMsgDVDAngleInfoStatus::~mplay_mediaplayerfi_tclMsgDVDAngleInfoStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgDVDAngleInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDVDAngleInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8CurrentAngle);
   (tVoid) (oIn >> e8TotalAngle);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDVDAngleInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8CurrentAngle);
   (tVoid) (oOut << e8TotalAngle);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDVDAngleInfoStatus::operator==(const mplay_mediaplayerfi_tclMsgDVDAngleInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8CurrentAngle == roRef.e8CurrentAngle);
   bResult = bResult && (e8TotalAngle == roRef.e8TotalAngle);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgDVDSubtitleInfoUpReg::mplay_mediaplayerfi_tclMsgDVDSubtitleInfoUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDSubtitleInfoUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDSUBTITLEINFOUPREG;
}


mplay_mediaplayerfi_tclMsgDVDSubtitleInfoUpReg::~mplay_mediaplayerfi_tclMsgDVDSubtitleInfoUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgDVDSubtitleInfoRelUpReg::mplay_mediaplayerfi_tclMsgDVDSubtitleInfoRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDSubtitleInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDSUBTITLEINFORELUPREG;
}


mplay_mediaplayerfi_tclMsgDVDSubtitleInfoRelUpReg::~mplay_mediaplayerfi_tclMsgDVDSubtitleInfoRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgDVDSubtitleInfoGet::mplay_mediaplayerfi_tclMsgDVDSubtitleInfoGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDSubtitleInfoGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDSUBTITLEINFOGET;
}


mplay_mediaplayerfi_tclMsgDVDSubtitleInfoGet::~mplay_mediaplayerfi_tclMsgDVDSubtitleInfoGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDVDSubtitleInfoStatus::mplay_mediaplayerfi_tclMsgDVDSubtitleInfoStatus(const mplay_mediaplayerfi_tclMsgDVDSubtitleInfoStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   subtitleState = coRef.subtitleState;
   u8CurrentSubtitle = coRef.u8CurrentSubtitle;
   u8TotalSubtitle = coRef.u8TotalSubtitle;
   u16SubtitleLang = coRef.u16SubtitleLang;
}
mplay_mediaplayerfi_tclMsgDVDSubtitleInfoStatus& mplay_mediaplayerfi_tclMsgDVDSubtitleInfoStatus::operator=(const mplay_mediaplayerfi_tclMsgDVDSubtitleInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   subtitleState = coRef.subtitleState;
   u8CurrentSubtitle = coRef.u8CurrentSubtitle;
   u8TotalSubtitle = coRef.u8TotalSubtitle;
   u16SubtitleLang = coRef.u16SubtitleLang;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgDVDSubtitleInfoStatus::mplay_mediaplayerfi_tclMsgDVDSubtitleInfoStatus()
:subtitleState(0)
,u8CurrentSubtitle(0)
,u8TotalSubtitle(0)
,u16SubtitleLang(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDSubtitleInfoStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDSUBTITLEINFOSTATUS;
}


mplay_mediaplayerfi_tclMsgDVDSubtitleInfoStatus::~mplay_mediaplayerfi_tclMsgDVDSubtitleInfoStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgDVDSubtitleInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDVDSubtitleInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> subtitleState);
   (tVoid) (oIn >> u8CurrentSubtitle);
   (tVoid) (oIn >> u8TotalSubtitle);
   (tVoid) (oIn >> u16SubtitleLang);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDVDSubtitleInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << subtitleState);
   (tVoid) (oOut << u8CurrentSubtitle);
   (tVoid) (oOut << u8TotalSubtitle);
   (tVoid) (oOut << u16SubtitleLang);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDVDSubtitleInfoStatus::operator==(const mplay_mediaplayerfi_tclMsgDVDSubtitleInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (subtitleState == roRef.subtitleState);
   bResult = bResult && (u8CurrentSubtitle == roRef.u8CurrentSubtitle);
   bResult = bResult && (u8TotalSubtitle == roRef.u8TotalSubtitle);
   bResult = bResult && (u16SubtitleLang == roRef.u16SubtitleLang);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoUpReg::mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDAUDIOCHANNELINFOUPREG;
}


mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoUpReg::~mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoRelUpReg::mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDAUDIOCHANNELINFORELUPREG;
}


mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoRelUpReg::~mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoGet::mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDAUDIOCHANNELINFOGET;
}


mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoGet::~mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoStatus::mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoStatus(const mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8totalChannels = coRef.e8totalChannels;
   bSubWooferAvailable = coRef.bSubWooferAvailable;
   e8CurrentAssignment = coRef.e8CurrentAssignment;
}
mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoStatus& mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoStatus::operator=(const mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   e8totalChannels = coRef.e8totalChannels;
   bSubWooferAvailable = coRef.bSubWooferAvailable;
   e8CurrentAssignment = coRef.e8CurrentAssignment;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoStatus::mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoStatus()
:e8totalChannels()
,bSubWooferAvailable(0)
,e8CurrentAssignment()
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDAUDIOCHANNELINFOSTATUS;
}


mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoStatus::~mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8totalChannels);
   (tVoid) (oIn >> bSubWooferAvailable);
   (tVoid) (oIn >> e8CurrentAssignment);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8totalChannels);
   (tVoid) (oOut << bSubWooferAvailable);
   (tVoid) (oOut << e8CurrentAssignment);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoStatus::operator==(const mplay_mediaplayerfi_tclMsgDVDAudioChannelInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8totalChannels == roRef.e8totalChannels);
   bResult = bResult && (bSubWooferAvailable == roRef.bSubWooferAvailable);
   bResult = bResult && (e8CurrentAssignment == roRef.e8CurrentAssignment);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoUpReg::mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDCURRENTAUDIOINFOUPREG;
}


mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoUpReg::~mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoRelUpReg::mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDCURRENTAUDIOINFORELUPREG;
}


mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoRelUpReg::~mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoGet::mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDCURRENTAUDIOINFOGET;
}


mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoGet::~mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoStatus::mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoStatus(const mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8SoundFormat = coRef.e8SoundFormat;
   e8VCDAudioOutput = coRef.e8VCDAudioOutput;
   e8DVDAudioChannel = coRef.e8DVDAudioChannel;
   e8DVDTotalAudio = coRef.e8DVDTotalAudio;
   u16DVDAudioLang = coRef.u16DVDAudioLang;
}
mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoStatus& mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoStatus::operator=(const mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   e8SoundFormat = coRef.e8SoundFormat;
   e8VCDAudioOutput = coRef.e8VCDAudioOutput;
   e8DVDAudioChannel = coRef.e8DVDAudioChannel;
   e8DVDTotalAudio = coRef.e8DVDTotalAudio;
   u16DVDAudioLang = coRef.u16DVDAudioLang;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoStatus::mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoStatus()
:e8SoundFormat()
,e8VCDAudioOutput()
,e8DVDAudioChannel()
,e8DVDTotalAudio()
,u16DVDAudioLang(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDCURRENTAUDIOINFOSTATUS;
}


mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoStatus::~mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8SoundFormat);
   (tVoid) (oIn >> e8VCDAudioOutput);
   (tVoid) (oIn >> e8DVDAudioChannel);
   (tVoid) (oIn >> e8DVDTotalAudio);
   (tVoid) (oIn >> u16DVDAudioLang);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8SoundFormat);
   (tVoid) (oOut << e8VCDAudioOutput);
   (tVoid) (oOut << e8DVDAudioChannel);
   (tVoid) (oOut << e8DVDTotalAudio);
   (tVoid) (oOut << u16DVDAudioLang);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoStatus::operator==(const mplay_mediaplayerfi_tclMsgDVDCurrentAudioInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8SoundFormat == roRef.e8SoundFormat);
   bResult = bResult && (e8VCDAudioOutput == roRef.e8VCDAudioOutput);
   bResult = bResult && (e8DVDAudioChannel == roRef.e8DVDAudioChannel);
   bResult = bResult && (e8DVDTotalAudio == roRef.e8DVDTotalAudio);
   bResult = bResult && (u16DVDAudioLang == roRef.u16DVDAudioLang);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgDisplayModeUpReg::mplay_mediaplayerfi_tclMsgDisplayModeUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgDisplayModeUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DISPLAYMODEUPREG;
}


mplay_mediaplayerfi_tclMsgDisplayModeUpReg::~mplay_mediaplayerfi_tclMsgDisplayModeUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgDisplayModeRelUpReg::mplay_mediaplayerfi_tclMsgDisplayModeRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgDisplayModeRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DISPLAYMODERELUPREG;
}


mplay_mediaplayerfi_tclMsgDisplayModeRelUpReg::~mplay_mediaplayerfi_tclMsgDisplayModeRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDisplayModeSet::mplay_mediaplayerfi_tclMsgDisplayModeSet(const mplay_mediaplayerfi_tclMsgDisplayModeSet& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8DisplayMode = coRef.e8DisplayMode;
}
mplay_mediaplayerfi_tclMsgDisplayModeSet& mplay_mediaplayerfi_tclMsgDisplayModeSet::operator=(const mplay_mediaplayerfi_tclMsgDisplayModeSet& coRef)
{
   if (this == &coRef) return *this;
   e8DisplayMode = coRef.e8DisplayMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgDisplayModeSet::mplay_mediaplayerfi_tclMsgDisplayModeSet()
:e8DisplayMode()
 {}

tS32 mplay_mediaplayerfi_tclMsgDisplayModeSet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DISPLAYMODESET;
}


mplay_mediaplayerfi_tclMsgDisplayModeSet::~mplay_mediaplayerfi_tclMsgDisplayModeSet()
{}

tU32 mplay_mediaplayerfi_tclMsgDisplayModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDisplayModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8DisplayMode);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDisplayModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8DisplayMode);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDisplayModeSet::operator==(const mplay_mediaplayerfi_tclMsgDisplayModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8DisplayMode == roRef.e8DisplayMode);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgDisplayModeGet::mplay_mediaplayerfi_tclMsgDisplayModeGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgDisplayModeGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DISPLAYMODEGET;
}


mplay_mediaplayerfi_tclMsgDisplayModeGet::~mplay_mediaplayerfi_tclMsgDisplayModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDisplayModeStatus::mplay_mediaplayerfi_tclMsgDisplayModeStatus(const mplay_mediaplayerfi_tclMsgDisplayModeStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8DisplayMode = coRef.e8DisplayMode;
}
mplay_mediaplayerfi_tclMsgDisplayModeStatus& mplay_mediaplayerfi_tclMsgDisplayModeStatus::operator=(const mplay_mediaplayerfi_tclMsgDisplayModeStatus& coRef)
{
   if (this == &coRef) return *this;
   e8DisplayMode = coRef.e8DisplayMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgDisplayModeStatus::mplay_mediaplayerfi_tclMsgDisplayModeStatus()
:e8DisplayMode()
 {}

tS32 mplay_mediaplayerfi_tclMsgDisplayModeStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DISPLAYMODESTATUS;
}


mplay_mediaplayerfi_tclMsgDisplayModeStatus::~mplay_mediaplayerfi_tclMsgDisplayModeStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgDisplayModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDisplayModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8DisplayMode);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDisplayModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8DisplayMode);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDisplayModeStatus::operator==(const mplay_mediaplayerfi_tclMsgDisplayModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8DisplayMode == roRef.e8DisplayMode);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingUpReg::mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDPLAYERLANGSETTINGUPREG;
}


mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingUpReg::~mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingRelUpReg::mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDPLAYERLANGSETTINGRELUPREG;
}


mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingRelUpReg::~mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingSet::mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingSet(const mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingSet& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   langSetting = coRef.langSetting;
}
mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingSet& mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingSet::operator=(const mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingSet& coRef)
{
   if (this == &coRef) return *this;
   langSetting = coRef.langSetting;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingSet::mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingSet()
:langSetting()
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingSet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDPLAYERLANGSETTINGSET;
}


mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingSet::~mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingSet()
{}

tU32 mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> langSetting);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << langSetting);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingSet::operator==(const mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (langSetting == roRef.langSetting);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingGet::mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDPLAYERLANGSETTINGGET;
}


mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingGet::~mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingStatus::mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingStatus(const mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   langSetting = coRef.langSetting;
}
mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingStatus& mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingStatus::operator=(const mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingStatus& coRef)
{
   if (this == &coRef) return *this;
   langSetting = coRef.langSetting;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingStatus::mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingStatus()
:langSetting()
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDPLAYERLANGSETTINGSTATUS;
}


mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingStatus::~mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> langSetting);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << langSetting);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingStatus::operator==(const mplay_mediaplayerfi_tclMsgDVDPlayerLangSettingStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (langSetting == roRef.langSetting);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgAngleMarkSettingUpReg::mplay_mediaplayerfi_tclMsgAngleMarkSettingUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgAngleMarkSettingUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_ANGLEMARKSETTINGUPREG;
}


mplay_mediaplayerfi_tclMsgAngleMarkSettingUpReg::~mplay_mediaplayerfi_tclMsgAngleMarkSettingUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgAngleMarkSettingRelUpReg::mplay_mediaplayerfi_tclMsgAngleMarkSettingRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgAngleMarkSettingRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_ANGLEMARKSETTINGRELUPREG;
}


mplay_mediaplayerfi_tclMsgAngleMarkSettingRelUpReg::~mplay_mediaplayerfi_tclMsgAngleMarkSettingRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgAngleMarkSettingSet::mplay_mediaplayerfi_tclMsgAngleMarkSettingSet(const mplay_mediaplayerfi_tclMsgAngleMarkSettingSet& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   bAngleMark = coRef.bAngleMark;
}
mplay_mediaplayerfi_tclMsgAngleMarkSettingSet& mplay_mediaplayerfi_tclMsgAngleMarkSettingSet::operator=(const mplay_mediaplayerfi_tclMsgAngleMarkSettingSet& coRef)
{
   if (this == &coRef) return *this;
   bAngleMark = coRef.bAngleMark;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgAngleMarkSettingSet::mplay_mediaplayerfi_tclMsgAngleMarkSettingSet()
:bAngleMark(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgAngleMarkSettingSet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_ANGLEMARKSETTINGSET;
}


mplay_mediaplayerfi_tclMsgAngleMarkSettingSet::~mplay_mediaplayerfi_tclMsgAngleMarkSettingSet()
{}

tU32 mplay_mediaplayerfi_tclMsgAngleMarkSettingSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgAngleMarkSettingSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bAngleMark);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgAngleMarkSettingSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bAngleMark);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgAngleMarkSettingSet::operator==(const mplay_mediaplayerfi_tclMsgAngleMarkSettingSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bAngleMark == roRef.bAngleMark);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgAngleMarkSettingGet::mplay_mediaplayerfi_tclMsgAngleMarkSettingGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgAngleMarkSettingGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_ANGLEMARKSETTINGGET;
}


mplay_mediaplayerfi_tclMsgAngleMarkSettingGet::~mplay_mediaplayerfi_tclMsgAngleMarkSettingGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgAngleMarkSettingStatus::mplay_mediaplayerfi_tclMsgAngleMarkSettingStatus(const mplay_mediaplayerfi_tclMsgAngleMarkSettingStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   bAngleMark = coRef.bAngleMark;
}
mplay_mediaplayerfi_tclMsgAngleMarkSettingStatus& mplay_mediaplayerfi_tclMsgAngleMarkSettingStatus::operator=(const mplay_mediaplayerfi_tclMsgAngleMarkSettingStatus& coRef)
{
   if (this == &coRef) return *this;
   bAngleMark = coRef.bAngleMark;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgAngleMarkSettingStatus::mplay_mediaplayerfi_tclMsgAngleMarkSettingStatus()
:bAngleMark(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgAngleMarkSettingStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_ANGLEMARKSETTINGSTATUS;
}


mplay_mediaplayerfi_tclMsgAngleMarkSettingStatus::~mplay_mediaplayerfi_tclMsgAngleMarkSettingStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgAngleMarkSettingStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgAngleMarkSettingStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bAngleMark);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgAngleMarkSettingStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bAngleMark);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgAngleMarkSettingStatus::operator==(const mplay_mediaplayerfi_tclMsgAngleMarkSettingStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bAngleMark == roRef.bAngleMark);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgPlayStatusSettingUpReg::mplay_mediaplayerfi_tclMsgPlayStatusSettingUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgPlayStatusSettingUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYSTATUSSETTINGUPREG;
}


mplay_mediaplayerfi_tclMsgPlayStatusSettingUpReg::~mplay_mediaplayerfi_tclMsgPlayStatusSettingUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgPlayStatusSettingRelUpReg::mplay_mediaplayerfi_tclMsgPlayStatusSettingRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgPlayStatusSettingRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYSTATUSSETTINGRELUPREG;
}


mplay_mediaplayerfi_tclMsgPlayStatusSettingRelUpReg::~mplay_mediaplayerfi_tclMsgPlayStatusSettingRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgPlayStatusSettingSet::mplay_mediaplayerfi_tclMsgPlayStatusSettingSet(const mplay_mediaplayerfi_tclMsgPlayStatusSettingSet& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   bPlayStatus = coRef.bPlayStatus;
}
mplay_mediaplayerfi_tclMsgPlayStatusSettingSet& mplay_mediaplayerfi_tclMsgPlayStatusSettingSet::operator=(const mplay_mediaplayerfi_tclMsgPlayStatusSettingSet& coRef)
{
   if (this == &coRef) return *this;
   bPlayStatus = coRef.bPlayStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgPlayStatusSettingSet::mplay_mediaplayerfi_tclMsgPlayStatusSettingSet()
:bPlayStatus(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgPlayStatusSettingSet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYSTATUSSETTINGSET;
}


mplay_mediaplayerfi_tclMsgPlayStatusSettingSet::~mplay_mediaplayerfi_tclMsgPlayStatusSettingSet()
{}

tU32 mplay_mediaplayerfi_tclMsgPlayStatusSettingSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgPlayStatusSettingSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bPlayStatus);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgPlayStatusSettingSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bPlayStatus);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgPlayStatusSettingSet::operator==(const mplay_mediaplayerfi_tclMsgPlayStatusSettingSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bPlayStatus == roRef.bPlayStatus);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgPlayStatusSettingGet::mplay_mediaplayerfi_tclMsgPlayStatusSettingGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgPlayStatusSettingGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYSTATUSSETTINGGET;
}


mplay_mediaplayerfi_tclMsgPlayStatusSettingGet::~mplay_mediaplayerfi_tclMsgPlayStatusSettingGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgPlayStatusSettingStatus::mplay_mediaplayerfi_tclMsgPlayStatusSettingStatus(const mplay_mediaplayerfi_tclMsgPlayStatusSettingStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   bPlayStatus = coRef.bPlayStatus;
}
mplay_mediaplayerfi_tclMsgPlayStatusSettingStatus& mplay_mediaplayerfi_tclMsgPlayStatusSettingStatus::operator=(const mplay_mediaplayerfi_tclMsgPlayStatusSettingStatus& coRef)
{
   if (this == &coRef) return *this;
   bPlayStatus = coRef.bPlayStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgPlayStatusSettingStatus::mplay_mediaplayerfi_tclMsgPlayStatusSettingStatus()
:bPlayStatus(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgPlayStatusSettingStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYSTATUSSETTINGSTATUS;
}


mplay_mediaplayerfi_tclMsgPlayStatusSettingStatus::~mplay_mediaplayerfi_tclMsgPlayStatusSettingStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgPlayStatusSettingStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgPlayStatusSettingStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bPlayStatus);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgPlayStatusSettingStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bPlayStatus);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgPlayStatusSettingStatus::operator==(const mplay_mediaplayerfi_tclMsgPlayStatusSettingStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bPlayStatus == roRef.bPlayStatus);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgDRCSettingUpReg::mplay_mediaplayerfi_tclMsgDRCSettingUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgDRCSettingUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DRCSETTINGUPREG;
}


mplay_mediaplayerfi_tclMsgDRCSettingUpReg::~mplay_mediaplayerfi_tclMsgDRCSettingUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgDRCSettingRelUpReg::mplay_mediaplayerfi_tclMsgDRCSettingRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgDRCSettingRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DRCSETTINGRELUPREG;
}


mplay_mediaplayerfi_tclMsgDRCSettingRelUpReg::~mplay_mediaplayerfi_tclMsgDRCSettingRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDRCSettingSet::mplay_mediaplayerfi_tclMsgDRCSettingSet(const mplay_mediaplayerfi_tclMsgDRCSettingSet& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8DRCSetting = coRef.e8DRCSetting;
}
mplay_mediaplayerfi_tclMsgDRCSettingSet& mplay_mediaplayerfi_tclMsgDRCSettingSet::operator=(const mplay_mediaplayerfi_tclMsgDRCSettingSet& coRef)
{
   if (this == &coRef) return *this;
   e8DRCSetting = coRef.e8DRCSetting;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgDRCSettingSet::mplay_mediaplayerfi_tclMsgDRCSettingSet()
:e8DRCSetting()
 {}

tS32 mplay_mediaplayerfi_tclMsgDRCSettingSet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DRCSETTINGSET;
}


mplay_mediaplayerfi_tclMsgDRCSettingSet::~mplay_mediaplayerfi_tclMsgDRCSettingSet()
{}

tU32 mplay_mediaplayerfi_tclMsgDRCSettingSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDRCSettingSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8DRCSetting);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDRCSettingSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8DRCSetting);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDRCSettingSet::operator==(const mplay_mediaplayerfi_tclMsgDRCSettingSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8DRCSetting == roRef.e8DRCSetting);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgDRCSettingGet::mplay_mediaplayerfi_tclMsgDRCSettingGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgDRCSettingGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DRCSETTINGGET;
}


mplay_mediaplayerfi_tclMsgDRCSettingGet::~mplay_mediaplayerfi_tclMsgDRCSettingGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDRCSettingStatus::mplay_mediaplayerfi_tclMsgDRCSettingStatus(const mplay_mediaplayerfi_tclMsgDRCSettingStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8DRCSetting = coRef.e8DRCSetting;
}
mplay_mediaplayerfi_tclMsgDRCSettingStatus& mplay_mediaplayerfi_tclMsgDRCSettingStatus::operator=(const mplay_mediaplayerfi_tclMsgDRCSettingStatus& coRef)
{
   if (this == &coRef) return *this;
   e8DRCSetting = coRef.e8DRCSetting;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgDRCSettingStatus::mplay_mediaplayerfi_tclMsgDRCSettingStatus()
:e8DRCSetting()
 {}

tS32 mplay_mediaplayerfi_tclMsgDRCSettingStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DRCSETTINGSTATUS;
}


mplay_mediaplayerfi_tclMsgDRCSettingStatus::~mplay_mediaplayerfi_tclMsgDRCSettingStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgDRCSettingStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDRCSettingStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8DRCSetting);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDRCSettingStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8DRCSetting);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDRCSettingStatus::operator==(const mplay_mediaplayerfi_tclMsgDRCSettingStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8DRCSetting == roRef.e8DRCSetting);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgDVDCommandStatusUpReg::mplay_mediaplayerfi_tclMsgDVDCommandStatusUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDCommandStatusUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDCOMMANDSTATUSUPREG;
}


mplay_mediaplayerfi_tclMsgDVDCommandStatusUpReg::~mplay_mediaplayerfi_tclMsgDVDCommandStatusUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgDVDCommandStatusRelUpReg::mplay_mediaplayerfi_tclMsgDVDCommandStatusRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDCommandStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDCOMMANDSTATUSRELUPREG;
}


mplay_mediaplayerfi_tclMsgDVDCommandStatusRelUpReg::~mplay_mediaplayerfi_tclMsgDVDCommandStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDVDCommandStatusStatus::mplay_mediaplayerfi_tclMsgDVDCommandStatusStatus(const mplay_mediaplayerfi_tclMsgDVDCommandStatusStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8CommandStatus = coRef.e8CommandStatus;
}
mplay_mediaplayerfi_tclMsgDVDCommandStatusStatus& mplay_mediaplayerfi_tclMsgDVDCommandStatusStatus::operator=(const mplay_mediaplayerfi_tclMsgDVDCommandStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8CommandStatus = coRef.e8CommandStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgDVDCommandStatusStatus::mplay_mediaplayerfi_tclMsgDVDCommandStatusStatus()
:e8CommandStatus()
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDCommandStatusStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDCOMMANDSTATUSSTATUS;
}


mplay_mediaplayerfi_tclMsgDVDCommandStatusStatus::~mplay_mediaplayerfi_tclMsgDVDCommandStatusStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgDVDCommandStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDVDCommandStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8CommandStatus);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDVDCommandStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8CommandStatus);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDVDCommandStatusStatus::operator==(const mplay_mediaplayerfi_tclMsgDVDCommandStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8CommandStatus == roRef.e8CommandStatus);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgAutoRippingUpReg::mplay_mediaplayerfi_tclMsgAutoRippingUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgAutoRippingUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_AUTORIPPINGUPREG;
}


mplay_mediaplayerfi_tclMsgAutoRippingUpReg::~mplay_mediaplayerfi_tclMsgAutoRippingUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgAutoRippingRelUpReg::mplay_mediaplayerfi_tclMsgAutoRippingRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgAutoRippingRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_AUTORIPPINGRELUPREG;
}


mplay_mediaplayerfi_tclMsgAutoRippingRelUpReg::~mplay_mediaplayerfi_tclMsgAutoRippingRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgAutoRippingGet::mplay_mediaplayerfi_tclMsgAutoRippingGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgAutoRippingGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_AUTORIPPINGGET;
}


mplay_mediaplayerfi_tclMsgAutoRippingGet::~mplay_mediaplayerfi_tclMsgAutoRippingGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgAutoRippingSet::mplay_mediaplayerfi_tclMsgAutoRippingSet(const mplay_mediaplayerfi_tclMsgAutoRippingSet& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   bAutoRipping = coRef.bAutoRipping;
}
mplay_mediaplayerfi_tclMsgAutoRippingSet& mplay_mediaplayerfi_tclMsgAutoRippingSet::operator=(const mplay_mediaplayerfi_tclMsgAutoRippingSet& coRef)
{
   if (this == &coRef) return *this;
   bAutoRipping = coRef.bAutoRipping;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgAutoRippingSet::mplay_mediaplayerfi_tclMsgAutoRippingSet()
:bAutoRipping(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgAutoRippingSet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_AUTORIPPINGSET;
}


mplay_mediaplayerfi_tclMsgAutoRippingSet::~mplay_mediaplayerfi_tclMsgAutoRippingSet()
{}

tU32 mplay_mediaplayerfi_tclMsgAutoRippingSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgAutoRippingSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bAutoRipping);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgAutoRippingSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bAutoRipping);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgAutoRippingSet::operator==(const mplay_mediaplayerfi_tclMsgAutoRippingSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bAutoRipping == roRef.bAutoRipping);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgAutoRippingStatus::mplay_mediaplayerfi_tclMsgAutoRippingStatus(const mplay_mediaplayerfi_tclMsgAutoRippingStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   bAutoRipping = coRef.bAutoRipping;
}
mplay_mediaplayerfi_tclMsgAutoRippingStatus& mplay_mediaplayerfi_tclMsgAutoRippingStatus::operator=(const mplay_mediaplayerfi_tclMsgAutoRippingStatus& coRef)
{
   if (this == &coRef) return *this;
   bAutoRipping = coRef.bAutoRipping;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgAutoRippingStatus::mplay_mediaplayerfi_tclMsgAutoRippingStatus()
:bAutoRipping(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgAutoRippingStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_AUTORIPPINGSTATUS;
}


mplay_mediaplayerfi_tclMsgAutoRippingStatus::~mplay_mediaplayerfi_tclMsgAutoRippingStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgAutoRippingStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgAutoRippingStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bAutoRipping);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgAutoRippingStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bAutoRipping);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgAutoRippingStatus::operator==(const mplay_mediaplayerfi_tclMsgAutoRippingStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bAutoRipping == roRef.bAutoRipping);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgGracenoteLookupModeUpReg::mplay_mediaplayerfi_tclMsgGracenoteLookupModeUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgGracenoteLookupModeUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_GRACENOTELOOKUPMODEUPREG;
}


mplay_mediaplayerfi_tclMsgGracenoteLookupModeUpReg::~mplay_mediaplayerfi_tclMsgGracenoteLookupModeUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgGracenoteLookupModeRelUpReg::mplay_mediaplayerfi_tclMsgGracenoteLookupModeRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgGracenoteLookupModeRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_GRACENOTELOOKUPMODERELUPREG;
}


mplay_mediaplayerfi_tclMsgGracenoteLookupModeRelUpReg::~mplay_mediaplayerfi_tclMsgGracenoteLookupModeRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgGracenoteLookupModeGet::mplay_mediaplayerfi_tclMsgGracenoteLookupModeGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgGracenoteLookupModeGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_GRACENOTELOOKUPMODEGET;
}


mplay_mediaplayerfi_tclMsgGracenoteLookupModeGet::~mplay_mediaplayerfi_tclMsgGracenoteLookupModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgGracenoteLookupModeSet::mplay_mediaplayerfi_tclMsgGracenoteLookupModeSet(const mplay_mediaplayerfi_tclMsgGracenoteLookupModeSet& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   bLookupMode = coRef.bLookupMode;
}
mplay_mediaplayerfi_tclMsgGracenoteLookupModeSet& mplay_mediaplayerfi_tclMsgGracenoteLookupModeSet::operator=(const mplay_mediaplayerfi_tclMsgGracenoteLookupModeSet& coRef)
{
   if (this == &coRef) return *this;
   bLookupMode = coRef.bLookupMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgGracenoteLookupModeSet::mplay_mediaplayerfi_tclMsgGracenoteLookupModeSet()
:bLookupMode(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgGracenoteLookupModeSet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_GRACENOTELOOKUPMODESET;
}


mplay_mediaplayerfi_tclMsgGracenoteLookupModeSet::~mplay_mediaplayerfi_tclMsgGracenoteLookupModeSet()
{}

tU32 mplay_mediaplayerfi_tclMsgGracenoteLookupModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgGracenoteLookupModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bLookupMode);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgGracenoteLookupModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bLookupMode);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgGracenoteLookupModeSet::operator==(const mplay_mediaplayerfi_tclMsgGracenoteLookupModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bLookupMode == roRef.bLookupMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgGracenoteLookupModeStatus::mplay_mediaplayerfi_tclMsgGracenoteLookupModeStatus(const mplay_mediaplayerfi_tclMsgGracenoteLookupModeStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   bLookupMode = coRef.bLookupMode;
}
mplay_mediaplayerfi_tclMsgGracenoteLookupModeStatus& mplay_mediaplayerfi_tclMsgGracenoteLookupModeStatus::operator=(const mplay_mediaplayerfi_tclMsgGracenoteLookupModeStatus& coRef)
{
   if (this == &coRef) return *this;
   bLookupMode = coRef.bLookupMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgGracenoteLookupModeStatus::mplay_mediaplayerfi_tclMsgGracenoteLookupModeStatus()
:bLookupMode(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgGracenoteLookupModeStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_GRACENOTELOOKUPMODESTATUS;
}


mplay_mediaplayerfi_tclMsgGracenoteLookupModeStatus::~mplay_mediaplayerfi_tclMsgGracenoteLookupModeStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgGracenoteLookupModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgGracenoteLookupModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bLookupMode);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgGracenoteLookupModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bLookupMode);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgGracenoteLookupModeStatus::operator==(const mplay_mediaplayerfi_tclMsgGracenoteLookupModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bLookupMode == roRef.bLookupMode);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgGracenoteVersionUpReg::mplay_mediaplayerfi_tclMsgGracenoteVersionUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgGracenoteVersionUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_GRACENOTEVERSIONUPREG;
}


mplay_mediaplayerfi_tclMsgGracenoteVersionUpReg::~mplay_mediaplayerfi_tclMsgGracenoteVersionUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgGracenoteVersionRelUpReg::mplay_mediaplayerfi_tclMsgGracenoteVersionRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgGracenoteVersionRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_GRACENOTEVERSIONRELUPREG;
}


mplay_mediaplayerfi_tclMsgGracenoteVersionRelUpReg::~mplay_mediaplayerfi_tclMsgGracenoteVersionRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgGracenoteVersionGet::mplay_mediaplayerfi_tclMsgGracenoteVersionGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgGracenoteVersionGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_GRACENOTEVERSIONGET;
}


mplay_mediaplayerfi_tclMsgGracenoteVersionGet::~mplay_mediaplayerfi_tclMsgGracenoteVersionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgGracenoteVersionStatus::mplay_mediaplayerfi_tclMsgGracenoteVersionStatus(const mplay_mediaplayerfi_tclMsgGracenoteVersionStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   sVersion = coRef.sVersion;
}
mplay_mediaplayerfi_tclMsgGracenoteVersionStatus& mplay_mediaplayerfi_tclMsgGracenoteVersionStatus::operator=(const mplay_mediaplayerfi_tclMsgGracenoteVersionStatus& coRef)
{
   if (this == &coRef) return *this;
   sVersion = coRef.sVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgGracenoteVersionStatus::vDestroy()
{
   sVersion.vDestroy();
}

mplay_mediaplayerfi_tclMsgGracenoteVersionStatus::mplay_mediaplayerfi_tclMsgGracenoteVersionStatus()
:sVersion()
 {}

tS32 mplay_mediaplayerfi_tclMsgGracenoteVersionStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_GRACENOTEVERSIONSTATUS;
}


mplay_mediaplayerfi_tclMsgGracenoteVersionStatus::~mplay_mediaplayerfi_tclMsgGracenoteVersionStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgGracenoteVersionStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+sVersion.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgGracenoteVersionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sVersion);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgGracenoteVersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sVersion);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgGracenoteVersionStatus::operator==(const mplay_mediaplayerfi_tclMsgGracenoteVersionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sVersion == roRef.sVersion);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgRippingErrorsUpReg::mplay_mediaplayerfi_tclMsgRippingErrorsUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgRippingErrorsUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_RIPPINGERRORSUPREG;
}


mplay_mediaplayerfi_tclMsgRippingErrorsUpReg::~mplay_mediaplayerfi_tclMsgRippingErrorsUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgRippingErrorsRelUpReg::mplay_mediaplayerfi_tclMsgRippingErrorsRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgRippingErrorsRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_RIPPINGERRORSRELUPREG;
}


mplay_mediaplayerfi_tclMsgRippingErrorsRelUpReg::~mplay_mediaplayerfi_tclMsgRippingErrorsRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgRippingErrorsGet::mplay_mediaplayerfi_tclMsgRippingErrorsGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgRippingErrorsGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_RIPPINGERRORSGET;
}


mplay_mediaplayerfi_tclMsgRippingErrorsGet::~mplay_mediaplayerfi_tclMsgRippingErrorsGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRippingErrorsStatus::mplay_mediaplayerfi_tclMsgRippingErrorsStatus(const mplay_mediaplayerfi_tclMsgRippingErrorsStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   oRippingErrors = coRef.oRippingErrors;
}
mplay_mediaplayerfi_tclMsgRippingErrorsStatus& mplay_mediaplayerfi_tclMsgRippingErrorsStatus::operator=(const mplay_mediaplayerfi_tclMsgRippingErrorsStatus& coRef)
{
   if (this == &coRef) return *this;
   oRippingErrors = coRef.oRippingErrors;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgRippingErrorsStatus::mplay_mediaplayerfi_tclMsgRippingErrorsStatus()
:oRippingErrors()
 {}

tS32 mplay_mediaplayerfi_tclMsgRippingErrorsStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_RIPPINGERRORSSTATUS;
}


mplay_mediaplayerfi_tclMsgRippingErrorsStatus::~mplay_mediaplayerfi_tclMsgRippingErrorsStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgRippingErrorsStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRippingErrorsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oRippingErrors);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRippingErrorsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oRippingErrors);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRippingErrorsStatus::operator==(const mplay_mediaplayerfi_tclMsgRippingErrorsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oRippingErrors == roRef.oRippingErrors);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesUpReg::mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_RESOLVEGRACENOTEAMBUIGUITIESUPREG;
}


mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesUpReg::~mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesRelUpReg::mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_RESOLVEGRACENOTEAMBUIGUITIESRELUPREG;
}


mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesRelUpReg::~mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesGet::mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_RESOLVEGRACENOTEAMBUIGUITIESGET;
}


mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesGet::~mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesStatus::mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesStatus(const mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   sTOC = coRef.sTOC;
   oAlbums = coRef.oAlbums;
}
mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesStatus& mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesStatus::operator=(const mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesStatus& coRef)
{
   if (this == &coRef) return *this;
   sTOC = coRef.sTOC;
   oAlbums = coRef.oAlbums;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesStatus::vDestroy()
{
   sTOC.vDestroy();
   oAlbums.vDestroy(); 
}

mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesStatus::mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesStatus()
:sTOC()
,oAlbums()
 {}

tS32 mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_RESOLVEGRACENOTEAMBUIGUITIESSTATUS;
}


mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesStatus::~mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+sTOC.u32GetSize(u16MajorVersion)+oAlbums.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sTOC);
   (tVoid) (oIn >> oAlbums);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sTOC);
   (tVoid) (oOut << oAlbums);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesStatus::operator==(const mplay_mediaplayerfi_tclMsgResolveGracenoteAmbuiguitiesStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sTOC == roRef.sTOC);
   bResult = bResult && (oAlbums == roRef.oAlbums);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingGet::mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDMENUPLAYBACKONGOINGGET;
}


mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingGet::~mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingGet()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingRelUpReg::mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDMENUPLAYBACKONGOINGRELUPREG;
}


mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingRelUpReg::~mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingStatus::mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingStatus(const mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   bDVDMenuPlaybackOngoing = coRef.bDVDMenuPlaybackOngoing;
}
mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingStatus& mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingStatus::operator=(const mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingStatus& coRef)
{
   if (this == &coRef) return *this;
   bDVDMenuPlaybackOngoing = coRef.bDVDMenuPlaybackOngoing;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingStatus::mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingStatus()
:bDVDMenuPlaybackOngoing(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDMENUPLAYBACKONGOINGSTATUS;
}


mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingStatus::~mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bDVDMenuPlaybackOngoing);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bDVDMenuPlaybackOngoing);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingStatus::operator==(const mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bDVDMenuPlaybackOngoing == roRef.bDVDMenuPlaybackOngoing);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingUpReg::mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDMENUPLAYBACKONGOINGUPREG;
}


mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingUpReg::~mplay_mediaplayerfi_tclMsgDVDMenuPlaybackOngoingUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgDVDDriveInfoGet::mplay_mediaplayerfi_tclMsgDVDDriveInfoGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDDriveInfoGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDDRIVEINFOGET;
}


mplay_mediaplayerfi_tclMsgDVDDriveInfoGet::~mplay_mediaplayerfi_tclMsgDVDDriveInfoGet()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgDVDDriveInfoRelUpReg::mplay_mediaplayerfi_tclMsgDVDDriveInfoRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDDriveInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDDRIVEINFORELUPREG;
}


mplay_mediaplayerfi_tclMsgDVDDriveInfoRelUpReg::~mplay_mediaplayerfi_tclMsgDVDDriveInfoRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDVDDriveInfoStatus::mplay_mediaplayerfi_tclMsgDVDDriveInfoStatus(const mplay_mediaplayerfi_tclMsgDVDDriveInfoStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8DVDDiscType = coRef.e8DVDDiscType;
   e8DVDDriveMode = coRef.e8DVDDriveMode;
}
mplay_mediaplayerfi_tclMsgDVDDriveInfoStatus& mplay_mediaplayerfi_tclMsgDVDDriveInfoStatus::operator=(const mplay_mediaplayerfi_tclMsgDVDDriveInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   e8DVDDiscType = coRef.e8DVDDiscType;
   e8DVDDriveMode = coRef.e8DVDDriveMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgDVDDriveInfoStatus::mplay_mediaplayerfi_tclMsgDVDDriveInfoStatus()
:e8DVDDiscType()
,e8DVDDriveMode()
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDDriveInfoStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDDRIVEINFOSTATUS;
}


mplay_mediaplayerfi_tclMsgDVDDriveInfoStatus::~mplay_mediaplayerfi_tclMsgDVDDriveInfoStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgDVDDriveInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDVDDriveInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8DVDDiscType);
   (tVoid) (oIn >> e8DVDDriveMode);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDVDDriveInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8DVDDiscType);
   (tVoid) (oOut << e8DVDDriveMode);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDVDDriveInfoStatus::operator==(const mplay_mediaplayerfi_tclMsgDVDDriveInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8DVDDiscType == roRef.e8DVDDiscType);
   bResult = bResult && (e8DVDDriveMode == roRef.e8DVDDriveMode);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgDVDDriveInfoUpReg::mplay_mediaplayerfi_tclMsgDVDDriveInfoUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgDVDDriveInfoUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DVDDRIVEINFOUPREG;
}


mplay_mediaplayerfi_tclMsgDVDDriveInfoUpReg::~mplay_mediaplayerfi_tclMsgDVDDriveInfoUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgRippingStateUpReg::mplay_mediaplayerfi_tclMsgRippingStateUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgRippingStateUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_RIPPINGSTATEUPREG;
}


mplay_mediaplayerfi_tclMsgRippingStateUpReg::~mplay_mediaplayerfi_tclMsgRippingStateUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgRippingStateRelUpReg::mplay_mediaplayerfi_tclMsgRippingStateRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgRippingStateRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_RIPPINGSTATERELUPREG;
}


mplay_mediaplayerfi_tclMsgRippingStateRelUpReg::~mplay_mediaplayerfi_tclMsgRippingStateRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgRippingStateGet::mplay_mediaplayerfi_tclMsgRippingStateGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgRippingStateGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_RIPPINGSTATEGET;
}


mplay_mediaplayerfi_tclMsgRippingStateGet::~mplay_mediaplayerfi_tclMsgRippingStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRippingStateStatus::mplay_mediaplayerfi_tclMsgRippingStateStatus(const mplay_mediaplayerfi_tclMsgRippingStateStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   oRippingStateResult = coRef.oRippingStateResult;
}
mplay_mediaplayerfi_tclMsgRippingStateStatus& mplay_mediaplayerfi_tclMsgRippingStateStatus::operator=(const mplay_mediaplayerfi_tclMsgRippingStateStatus& coRef)
{
   if (this == &coRef) return *this;
   oRippingStateResult = coRef.oRippingStateResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgRippingStateStatus::mplay_mediaplayerfi_tclMsgRippingStateStatus()
:oRippingStateResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgRippingStateStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_RIPPINGSTATESTATUS;
}


mplay_mediaplayerfi_tclMsgRippingStateStatus::~mplay_mediaplayerfi_tclMsgRippingStateStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgRippingStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRippingStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oRippingStateResult);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRippingStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oRippingStateResult);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRippingStateStatus::operator==(const mplay_mediaplayerfi_tclMsgRippingStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oRippingStateResult == roRef.oRippingStateResult);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgRippingEncodingQualityUpReg::mplay_mediaplayerfi_tclMsgRippingEncodingQualityUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgRippingEncodingQualityUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_RIPPINGENCODINGQUALITYUPREG;
}


mplay_mediaplayerfi_tclMsgRippingEncodingQualityUpReg::~mplay_mediaplayerfi_tclMsgRippingEncodingQualityUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgRippingEncodingQualityRelUpReg::mplay_mediaplayerfi_tclMsgRippingEncodingQualityRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgRippingEncodingQualityRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_RIPPINGENCODINGQUALITYRELUPREG;
}


mplay_mediaplayerfi_tclMsgRippingEncodingQualityRelUpReg::~mplay_mediaplayerfi_tclMsgRippingEncodingQualityRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgRippingEncodingQualityGet::mplay_mediaplayerfi_tclMsgRippingEncodingQualityGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgRippingEncodingQualityGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_RIPPINGENCODINGQUALITYGET;
}


mplay_mediaplayerfi_tclMsgRippingEncodingQualityGet::~mplay_mediaplayerfi_tclMsgRippingEncodingQualityGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRippingEncodingQualityStatus::mplay_mediaplayerfi_tclMsgRippingEncodingQualityStatus(const mplay_mediaplayerfi_tclMsgRippingEncodingQualityStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8EncodingQuality = coRef.e8EncodingQuality;
}
mplay_mediaplayerfi_tclMsgRippingEncodingQualityStatus& mplay_mediaplayerfi_tclMsgRippingEncodingQualityStatus::operator=(const mplay_mediaplayerfi_tclMsgRippingEncodingQualityStatus& coRef)
{
   if (this == &coRef) return *this;
   e8EncodingQuality = coRef.e8EncodingQuality;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgRippingEncodingQualityStatus::mplay_mediaplayerfi_tclMsgRippingEncodingQualityStatus()
:e8EncodingQuality()
 {}

tS32 mplay_mediaplayerfi_tclMsgRippingEncodingQualityStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_RIPPINGENCODINGQUALITYSTATUS;
}


mplay_mediaplayerfi_tclMsgRippingEncodingQualityStatus::~mplay_mediaplayerfi_tclMsgRippingEncodingQualityStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgRippingEncodingQualityStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRippingEncodingQualityStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8EncodingQuality);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRippingEncodingQualityStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8EncodingQuality);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRippingEncodingQualityStatus::operator==(const mplay_mediaplayerfi_tclMsgRippingEncodingQualityStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8EncodingQuality == roRef.e8EncodingQuality);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgRippingEncodingQualitySet::mplay_mediaplayerfi_tclMsgRippingEncodingQualitySet(const mplay_mediaplayerfi_tclMsgRippingEncodingQualitySet& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8EncodingQuality = coRef.e8EncodingQuality;
}
mplay_mediaplayerfi_tclMsgRippingEncodingQualitySet& mplay_mediaplayerfi_tclMsgRippingEncodingQualitySet::operator=(const mplay_mediaplayerfi_tclMsgRippingEncodingQualitySet& coRef)
{
   if (this == &coRef) return *this;
   e8EncodingQuality = coRef.e8EncodingQuality;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgRippingEncodingQualitySet::mplay_mediaplayerfi_tclMsgRippingEncodingQualitySet()
:e8EncodingQuality()
 {}

tS32 mplay_mediaplayerfi_tclMsgRippingEncodingQualitySet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_RIPPINGENCODINGQUALITYSET;
}


mplay_mediaplayerfi_tclMsgRippingEncodingQualitySet::~mplay_mediaplayerfi_tclMsgRippingEncodingQualitySet()
{}

tU32 mplay_mediaplayerfi_tclMsgRippingEncodingQualitySet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgRippingEncodingQualitySet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8EncodingQuality);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgRippingEncodingQualitySet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8EncodingQuality);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgRippingEncodingQualitySet::operator==(const mplay_mediaplayerfi_tclMsgRippingEncodingQualitySet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8EncodingQuality == roRef.e8EncodingQuality);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusGet::mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_GNMETADATAEXTRACTIONSTATUSGET;
}


mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusGet::~mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusGet()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusRelUpReg::mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_GNMETADATAEXTRACTIONSTATUSRELUPREG;
}


mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusRelUpReg::~mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusStatus::mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusStatus(const mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8GNmetadataExtractionResult = coRef.e8GNmetadataExtractionResult;
}
mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusStatus& mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusStatus::operator=(const mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8GNmetadataExtractionResult = coRef.e8GNmetadataExtractionResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusStatus::mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusStatus()
:e8GNmetadataExtractionResult()
 {}

tS32 mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_GNMETADATAEXTRACTIONSTATUSSTATUS;
}


mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusStatus::~mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8GNmetadataExtractionResult);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8GNmetadataExtractionResult);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusStatus::operator==(const mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8GNmetadataExtractionResult == roRef.e8GNmetadataExtractionResult);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusUpReg::mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_GNMETADATAEXTRACTIONSTATUSUPREG;
}


mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusUpReg::~mplay_mediaplayerfi_tclMsgGNMetadataExtractionStatusUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgLanguageUpReg::mplay_mediaplayerfi_tclMsgLanguageUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgLanguageUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_LANGUAGEUPREG;
}


mplay_mediaplayerfi_tclMsgLanguageUpReg::~mplay_mediaplayerfi_tclMsgLanguageUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgLanguageRelUpReg::mplay_mediaplayerfi_tclMsgLanguageRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgLanguageRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_LANGUAGERELUPREG;
}


mplay_mediaplayerfi_tclMsgLanguageRelUpReg::~mplay_mediaplayerfi_tclMsgLanguageRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgLanguageGet::mplay_mediaplayerfi_tclMsgLanguageGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgLanguageGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_LANGUAGEGET;
}


mplay_mediaplayerfi_tclMsgLanguageGet::~mplay_mediaplayerfi_tclMsgLanguageGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgLanguageSet::mplay_mediaplayerfi_tclMsgLanguageSet(const mplay_mediaplayerfi_tclMsgLanguageSet& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8Language = coRef.e8Language;
}
mplay_mediaplayerfi_tclMsgLanguageSet& mplay_mediaplayerfi_tclMsgLanguageSet::operator=(const mplay_mediaplayerfi_tclMsgLanguageSet& coRef)
{
   if (this == &coRef) return *this;
   e8Language = coRef.e8Language;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgLanguageSet::mplay_mediaplayerfi_tclMsgLanguageSet()
:e8Language()
 {}

tS32 mplay_mediaplayerfi_tclMsgLanguageSet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_LANGUAGESET;
}


mplay_mediaplayerfi_tclMsgLanguageSet::~mplay_mediaplayerfi_tclMsgLanguageSet()
{}

tU32 mplay_mediaplayerfi_tclMsgLanguageSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgLanguageSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Language);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgLanguageSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Language);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgLanguageSet::operator==(const mplay_mediaplayerfi_tclMsgLanguageSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Language == roRef.e8Language);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgLanguageStatus::mplay_mediaplayerfi_tclMsgLanguageStatus(const mplay_mediaplayerfi_tclMsgLanguageStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8Language = coRef.e8Language;
}
mplay_mediaplayerfi_tclMsgLanguageStatus& mplay_mediaplayerfi_tclMsgLanguageStatus::operator=(const mplay_mediaplayerfi_tclMsgLanguageStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Language = coRef.e8Language;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgLanguageStatus::mplay_mediaplayerfi_tclMsgLanguageStatus()
:e8Language()
 {}

tS32 mplay_mediaplayerfi_tclMsgLanguageStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_LANGUAGESTATUS;
}


mplay_mediaplayerfi_tclMsgLanguageStatus::~mplay_mediaplayerfi_tclMsgLanguageStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgLanguageStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgLanguageStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Language);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgLanguageStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Language);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgLanguageStatus::operator==(const mplay_mediaplayerfi_tclMsgLanguageStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Language == roRef.e8Language);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgPlaybackRepeatModeUpReg::mplay_mediaplayerfi_tclMsgPlaybackRepeatModeUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgPlaybackRepeatModeUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKREPEATMODEUPREG;
}


mplay_mediaplayerfi_tclMsgPlaybackRepeatModeUpReg::~mplay_mediaplayerfi_tclMsgPlaybackRepeatModeUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgPlaybackRepeatModeRelUpReg::mplay_mediaplayerfi_tclMsgPlaybackRepeatModeRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgPlaybackRepeatModeRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKREPEATMODERELUPREG;
}


mplay_mediaplayerfi_tclMsgPlaybackRepeatModeRelUpReg::~mplay_mediaplayerfi_tclMsgPlaybackRepeatModeRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgPlaybackRepeatModeGet::mplay_mediaplayerfi_tclMsgPlaybackRepeatModeGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgPlaybackRepeatModeGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKREPEATMODEGET;
}


mplay_mediaplayerfi_tclMsgPlaybackRepeatModeGet::~mplay_mediaplayerfi_tclMsgPlaybackRepeatModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgPlaybackRepeatModeSet::mplay_mediaplayerfi_tclMsgPlaybackRepeatModeSet(const mplay_mediaplayerfi_tclMsgPlaybackRepeatModeSet& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8Mode = coRef.e8Mode;
   e8Repeat = coRef.e8Repeat;
}
mplay_mediaplayerfi_tclMsgPlaybackRepeatModeSet& mplay_mediaplayerfi_tclMsgPlaybackRepeatModeSet::operator=(const mplay_mediaplayerfi_tclMsgPlaybackRepeatModeSet& coRef)
{
   if (this == &coRef) return *this;
   e8Mode = coRef.e8Mode;
   e8Repeat = coRef.e8Repeat;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgPlaybackRepeatModeSet::mplay_mediaplayerfi_tclMsgPlaybackRepeatModeSet()
:e8Mode()
,e8Repeat()
 {}

tS32 mplay_mediaplayerfi_tclMsgPlaybackRepeatModeSet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKREPEATMODESET;
}


mplay_mediaplayerfi_tclMsgPlaybackRepeatModeSet::~mplay_mediaplayerfi_tclMsgPlaybackRepeatModeSet()
{}

tU32 mplay_mediaplayerfi_tclMsgPlaybackRepeatModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgPlaybackRepeatModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Mode);
   (tVoid) (oIn >> e8Repeat);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgPlaybackRepeatModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Mode);
   (tVoid) (oOut << e8Repeat);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgPlaybackRepeatModeSet::operator==(const mplay_mediaplayerfi_tclMsgPlaybackRepeatModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Mode == roRef.e8Mode);
   bResult = bResult && (e8Repeat == roRef.e8Repeat);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgPlaybackRepeatModeStatus::mplay_mediaplayerfi_tclMsgPlaybackRepeatModeStatus(const mplay_mediaplayerfi_tclMsgPlaybackRepeatModeStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8Mode = coRef.e8Mode;
   e8Repeat = coRef.e8Repeat;
}
mplay_mediaplayerfi_tclMsgPlaybackRepeatModeStatus& mplay_mediaplayerfi_tclMsgPlaybackRepeatModeStatus::operator=(const mplay_mediaplayerfi_tclMsgPlaybackRepeatModeStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Mode = coRef.e8Mode;
   e8Repeat = coRef.e8Repeat;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgPlaybackRepeatModeStatus::mplay_mediaplayerfi_tclMsgPlaybackRepeatModeStatus()
:e8Mode()
,e8Repeat()
 {}

tS32 mplay_mediaplayerfi_tclMsgPlaybackRepeatModeStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_PLAYBACKREPEATMODESTATUS;
}


mplay_mediaplayerfi_tclMsgPlaybackRepeatModeStatus::~mplay_mediaplayerfi_tclMsgPlaybackRepeatModeStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgPlaybackRepeatModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgPlaybackRepeatModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Mode);
   (tVoid) (oIn >> e8Repeat);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgPlaybackRepeatModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Mode);
   (tVoid) (oOut << e8Repeat);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgPlaybackRepeatModeStatus::operator==(const mplay_mediaplayerfi_tclMsgPlaybackRepeatModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Mode == roRef.e8Mode);
   bResult = bResult && (e8Repeat == roRef.e8Repeat);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgSlideshowTimeUpReg::mplay_mediaplayerfi_tclMsgSlideshowTimeUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgSlideshowTimeUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SLIDESHOWTIMEUPREG;
}


mplay_mediaplayerfi_tclMsgSlideshowTimeUpReg::~mplay_mediaplayerfi_tclMsgSlideshowTimeUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgSlideshowTimeRelUpReg::mplay_mediaplayerfi_tclMsgSlideshowTimeRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgSlideshowTimeRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SLIDESHOWTIMERELUPREG;
}


mplay_mediaplayerfi_tclMsgSlideshowTimeRelUpReg::~mplay_mediaplayerfi_tclMsgSlideshowTimeRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgSlideshowTimeGet::mplay_mediaplayerfi_tclMsgSlideshowTimeGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgSlideshowTimeGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SLIDESHOWTIMEGET;
}


mplay_mediaplayerfi_tclMsgSlideshowTimeGet::~mplay_mediaplayerfi_tclMsgSlideshowTimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgSlideshowTimeSet::mplay_mediaplayerfi_tclMsgSlideshowTimeSet(const mplay_mediaplayerfi_tclMsgSlideshowTimeSet& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32Time = coRef.u32Time;
}
mplay_mediaplayerfi_tclMsgSlideshowTimeSet& mplay_mediaplayerfi_tclMsgSlideshowTimeSet::operator=(const mplay_mediaplayerfi_tclMsgSlideshowTimeSet& coRef)
{
   if (this == &coRef) return *this;
   u32Time = coRef.u32Time;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgSlideshowTimeSet::mplay_mediaplayerfi_tclMsgSlideshowTimeSet()
:u32Time(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgSlideshowTimeSet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SLIDESHOWTIMESET;
}


mplay_mediaplayerfi_tclMsgSlideshowTimeSet::~mplay_mediaplayerfi_tclMsgSlideshowTimeSet()
{}

tU32 mplay_mediaplayerfi_tclMsgSlideshowTimeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgSlideshowTimeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Time);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgSlideshowTimeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Time);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgSlideshowTimeSet::operator==(const mplay_mediaplayerfi_tclMsgSlideshowTimeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Time == roRef.u32Time);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgSlideshowTimeStatus::mplay_mediaplayerfi_tclMsgSlideshowTimeStatus(const mplay_mediaplayerfi_tclMsgSlideshowTimeStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32Time = coRef.u32Time;
}
mplay_mediaplayerfi_tclMsgSlideshowTimeStatus& mplay_mediaplayerfi_tclMsgSlideshowTimeStatus::operator=(const mplay_mediaplayerfi_tclMsgSlideshowTimeStatus& coRef)
{
   if (this == &coRef) return *this;
   u32Time = coRef.u32Time;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgSlideshowTimeStatus::mplay_mediaplayerfi_tclMsgSlideshowTimeStatus()
:u32Time(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgSlideshowTimeStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SLIDESHOWTIMESTATUS;
}


mplay_mediaplayerfi_tclMsgSlideshowTimeStatus::~mplay_mediaplayerfi_tclMsgSlideshowTimeStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgSlideshowTimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgSlideshowTimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Time);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgSlideshowTimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Time);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgSlideshowTimeStatus::operator==(const mplay_mediaplayerfi_tclMsgSlideshowTimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Time == roRef.u32Time);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgNowShowingUpReg::mplay_mediaplayerfi_tclMsgNowShowingUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgNowShowingUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_NOWSHOWINGUPREG;
}


mplay_mediaplayerfi_tclMsgNowShowingUpReg::~mplay_mediaplayerfi_tclMsgNowShowingUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgNowShowingRelUpReg::mplay_mediaplayerfi_tclMsgNowShowingRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgNowShowingRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_NOWSHOWINGRELUPREG;
}


mplay_mediaplayerfi_tclMsgNowShowingRelUpReg::~mplay_mediaplayerfi_tclMsgNowShowingRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgNowShowingGet::mplay_mediaplayerfi_tclMsgNowShowingGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgNowShowingGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_NOWSHOWINGGET;
}


mplay_mediaplayerfi_tclMsgNowShowingGet::~mplay_mediaplayerfi_tclMsgNowShowingGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgNowShowingStatus::mplay_mediaplayerfi_tclMsgNowShowingStatus(const mplay_mediaplayerfi_tclMsgNowShowingStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u32ListHandle = coRef.u32ListHandle;
   e8NowPlayingState = coRef.e8NowPlayingState;
   u32Position = coRef.u32Position;
   u32Tag = coRef.u32Tag;
   oMediaObject = coRef.oMediaObject;
   sNextFile = coRef.sNextFile;
}
mplay_mediaplayerfi_tclMsgNowShowingStatus& mplay_mediaplayerfi_tclMsgNowShowingStatus::operator=(const mplay_mediaplayerfi_tclMsgNowShowingStatus& coRef)
{
   if (this == &coRef) return *this;
   u32ListHandle = coRef.u32ListHandle;
   e8NowPlayingState = coRef.e8NowPlayingState;
   u32Position = coRef.u32Position;
   u32Tag = coRef.u32Tag;
   oMediaObject = coRef.oMediaObject;
   sNextFile = coRef.sNextFile;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgNowShowingStatus::vDestroy()
{
   oMediaObject.vDestroy(); 
   sNextFile.vDestroy();
}

mplay_mediaplayerfi_tclMsgNowShowingStatus::mplay_mediaplayerfi_tclMsgNowShowingStatus()
:u32ListHandle(0)
,e8NowPlayingState()
,u32Position(0)
,u32Tag(0)
,oMediaObject()
,sNextFile()
 {}

tS32 mplay_mediaplayerfi_tclMsgNowShowingStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_NOWSHOWINGSTATUS;
}


mplay_mediaplayerfi_tclMsgNowShowingStatus::~mplay_mediaplayerfi_tclMsgNowShowingStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgNowShowingStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 13+oMediaObject.u32GetSize(u16MajorVersion)+sNextFile.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgNowShowingStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ListHandle);
   (tVoid) (oIn >> e8NowPlayingState);
   (tVoid) (oIn >> u32Position);
   (tVoid) (oIn >> u32Tag);
   (tVoid) (oIn >> oMediaObject);
   (tVoid) (oIn >> sNextFile);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgNowShowingStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ListHandle);
   (tVoid) (oOut << e8NowPlayingState);
   (tVoid) (oOut << u32Position);
   (tVoid) (oOut << u32Tag);
   (tVoid) (oOut << oMediaObject);
   (tVoid) (oOut << sNextFile);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgNowShowingStatus::operator==(const mplay_mediaplayerfi_tclMsgNowShowingStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ListHandle == roRef.u32ListHandle);
   bResult = bResult && (e8NowPlayingState == roRef.e8NowPlayingState);
   bResult = bResult && (u32Position == roRef.u32Position);
   bResult = bResult && (u32Tag == roRef.u32Tag);
   bResult = bResult && (oMediaObject == roRef.oMediaObject);
   bResult = bResult && (sNextFile == roRef.sNextFile);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgSlideshowStateUpReg::mplay_mediaplayerfi_tclMsgSlideshowStateUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgSlideshowStateUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SLIDESHOWSTATEUPREG;
}


mplay_mediaplayerfi_tclMsgSlideshowStateUpReg::~mplay_mediaplayerfi_tclMsgSlideshowStateUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgSlideshowStateRelUpReg::mplay_mediaplayerfi_tclMsgSlideshowStateRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgSlideshowStateRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SLIDESHOWSTATERELUPREG;
}


mplay_mediaplayerfi_tclMsgSlideshowStateRelUpReg::~mplay_mediaplayerfi_tclMsgSlideshowStateRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgSlideshowStateGet::mplay_mediaplayerfi_tclMsgSlideshowStateGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgSlideshowStateGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SLIDESHOWSTATEGET;
}


mplay_mediaplayerfi_tclMsgSlideshowStateGet::~mplay_mediaplayerfi_tclMsgSlideshowStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgSlideshowStateStatus::mplay_mediaplayerfi_tclMsgSlideshowStateStatus(const mplay_mediaplayerfi_tclMsgSlideshowStateStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8State = coRef.e8State;
}
mplay_mediaplayerfi_tclMsgSlideshowStateStatus& mplay_mediaplayerfi_tclMsgSlideshowStateStatus::operator=(const mplay_mediaplayerfi_tclMsgSlideshowStateStatus& coRef)
{
   if (this == &coRef) return *this;
   e8State = coRef.e8State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgSlideshowStateStatus::mplay_mediaplayerfi_tclMsgSlideshowStateStatus()
:e8State()
 {}

tS32 mplay_mediaplayerfi_tclMsgSlideshowStateStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_SLIDESHOWSTATESTATUS;
}


mplay_mediaplayerfi_tclMsgSlideshowStateStatus::~mplay_mediaplayerfi_tclMsgSlideshowStateStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgSlideshowStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgSlideshowStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8State);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgSlideshowStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8State);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgSlideshowStateStatus::operator==(const mplay_mediaplayerfi_tclMsgSlideshowStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8State == roRef.e8State);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateUpReg::mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYEROPTICALDISCSLOTSTATEUPREG;
}


mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateUpReg::~mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateRelUpReg::mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYEROPTICALDISCSLOTSTATERELUPREG;
}


mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateRelUpReg::~mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateGet::mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYEROPTICALDISCSLOTSTATEGET;
}


mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateGet::~mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateStatus::mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateStatus(const mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8State = coRef.e8State;
}
mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateStatus& mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateStatus::operator=(const mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateStatus& coRef)
{
   if (this == &coRef) return *this;
   e8State = coRef.e8State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateStatus::mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateStatus()
:e8State()
 {}

tS32 mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYEROPTICALDISCSLOTSTATESTATUS;
}


mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateStatus::~mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8State);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8State);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateStatus::operator==(const mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscSlotStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8State == roRef.e8State);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoUpReg::mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYEROPTICALDISCCDINFOUPREG;
}


mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoUpReg::~mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoRelUpReg::mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYEROPTICALDISCCDINFORELUPREG;
}


mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoRelUpReg::~mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoGet::mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYEROPTICALDISCCDINFOGET;
}


mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoGet::~mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoStatus::mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoStatus(const mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   CDInfo = coRef.CDInfo;
}
mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoStatus& mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoStatus::operator=(const mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   CDInfo = coRef.CDInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoStatus::vDestroy()
{
   CDInfo.vDestroy(); 
}

mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoStatus::mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoStatus()
:CDInfo()
 {}

tS32 mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_MEDIAPLAYEROPTICALDISCCDINFOSTATUS;
}


mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoStatus::~mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+CDInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CDInfo);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CDInfo);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoStatus::operator==(const mplay_mediaplayerfi_tclMsgMediaPlayerOpticalDiscCDInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CDInfo == roRef.CDInfo);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgiPodCommunicationErrorUpReg::mplay_mediaplayerfi_tclMsgiPodCommunicationErrorUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgiPodCommunicationErrorUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_IPODCOMMUNICATIONERRORUPREG;
}


mplay_mediaplayerfi_tclMsgiPodCommunicationErrorUpReg::~mplay_mediaplayerfi_tclMsgiPodCommunicationErrorUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgiPodCommunicationErrorRelUpReg::mplay_mediaplayerfi_tclMsgiPodCommunicationErrorRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgiPodCommunicationErrorRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_IPODCOMMUNICATIONERRORRELUPREG;
}


mplay_mediaplayerfi_tclMsgiPodCommunicationErrorRelUpReg::~mplay_mediaplayerfi_tclMsgiPodCommunicationErrorRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgiPodCommunicationErrorGet::mplay_mediaplayerfi_tclMsgiPodCommunicationErrorGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgiPodCommunicationErrorGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_IPODCOMMUNICATIONERRORGET;
}


mplay_mediaplayerfi_tclMsgiPodCommunicationErrorGet::~mplay_mediaplayerfi_tclMsgiPodCommunicationErrorGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgiPodCommunicationErrorStatus::mplay_mediaplayerfi_tclMsgiPodCommunicationErrorStatus(const mplay_mediaplayerfi_tclMsgiPodCommunicationErrorStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u8DeviceTag = coRef.u8DeviceTag;
   e8iPodCommunicationError = coRef.e8iPodCommunicationError;
}
mplay_mediaplayerfi_tclMsgiPodCommunicationErrorStatus& mplay_mediaplayerfi_tclMsgiPodCommunicationErrorStatus::operator=(const mplay_mediaplayerfi_tclMsgiPodCommunicationErrorStatus& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceTag = coRef.u8DeviceTag;
   e8iPodCommunicationError = coRef.e8iPodCommunicationError;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgiPodCommunicationErrorStatus::mplay_mediaplayerfi_tclMsgiPodCommunicationErrorStatus()
:u8DeviceTag(0)
,e8iPodCommunicationError()
 {}

tS32 mplay_mediaplayerfi_tclMsgiPodCommunicationErrorStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_IPODCOMMUNICATIONERRORSTATUS;
}


mplay_mediaplayerfi_tclMsgiPodCommunicationErrorStatus::~mplay_mediaplayerfi_tclMsgiPodCommunicationErrorStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgiPodCommunicationErrorStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgiPodCommunicationErrorStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> e8iPodCommunicationError);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgiPodCommunicationErrorStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << e8iPodCommunicationError);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgiPodCommunicationErrorStatus::operator==(const mplay_mediaplayerfi_tclMsgiPodCommunicationErrorStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (e8iPodCommunicationError == roRef.e8iPodCommunicationError);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgDeviceStreamingInfoGet::mplay_mediaplayerfi_tclMsgDeviceStreamingInfoGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgDeviceStreamingInfoGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DEVICESTREAMINGINFOGET;
}


mplay_mediaplayerfi_tclMsgDeviceStreamingInfoGet::~mplay_mediaplayerfi_tclMsgDeviceStreamingInfoGet()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgDeviceStreamingInfoRelUpReg::mplay_mediaplayerfi_tclMsgDeviceStreamingInfoRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgDeviceStreamingInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DEVICESTREAMINGINFORELUPREG;
}


mplay_mediaplayerfi_tclMsgDeviceStreamingInfoRelUpReg::~mplay_mediaplayerfi_tclMsgDeviceStreamingInfoRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgDeviceStreamingInfoStatus::mplay_mediaplayerfi_tclMsgDeviceStreamingInfoStatus(const mplay_mediaplayerfi_tclMsgDeviceStreamingInfoStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8StreamingInfo = coRef.e8StreamingInfo;
   u8DeviceTag = coRef.u8DeviceTag;
   u8DeviceType = coRef.u8DeviceType;
}
mplay_mediaplayerfi_tclMsgDeviceStreamingInfoStatus& mplay_mediaplayerfi_tclMsgDeviceStreamingInfoStatus::operator=(const mplay_mediaplayerfi_tclMsgDeviceStreamingInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   e8StreamingInfo = coRef.e8StreamingInfo;
   u8DeviceTag = coRef.u8DeviceTag;
   u8DeviceType = coRef.u8DeviceType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgDeviceStreamingInfoStatus::mplay_mediaplayerfi_tclMsgDeviceStreamingInfoStatus()
:e8StreamingInfo()
,u8DeviceTag(0)
,u8DeviceType(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgDeviceStreamingInfoStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DEVICESTREAMINGINFOSTATUS;
}


mplay_mediaplayerfi_tclMsgDeviceStreamingInfoStatus::~mplay_mediaplayerfi_tclMsgDeviceStreamingInfoStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgDeviceStreamingInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgDeviceStreamingInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8StreamingInfo);
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> u8DeviceType);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgDeviceStreamingInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8StreamingInfo);
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << u8DeviceType);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgDeviceStreamingInfoStatus::operator==(const mplay_mediaplayerfi_tclMsgDeviceStreamingInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8StreamingInfo == roRef.e8StreamingInfo);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (u8DeviceType == roRef.u8DeviceType);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgDeviceStreamingInfoUpReg::mplay_mediaplayerfi_tclMsgDeviceStreamingInfoUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgDeviceStreamingInfoUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_DEVICESTREAMINGINFOUPREG;
}


mplay_mediaplayerfi_tclMsgDeviceStreamingInfoUpReg::~mplay_mediaplayerfi_tclMsgDeviceStreamingInfoUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgVideoBrightnessUpReg::mplay_mediaplayerfi_tclMsgVideoBrightnessUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoBrightnessUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOBRIGHTNESSUPREG;
}


mplay_mediaplayerfi_tclMsgVideoBrightnessUpReg::~mplay_mediaplayerfi_tclMsgVideoBrightnessUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgVideoBrightnessRelUpReg::mplay_mediaplayerfi_tclMsgVideoBrightnessRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoBrightnessRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOBRIGHTNESSRELUPREG;
}


mplay_mediaplayerfi_tclMsgVideoBrightnessRelUpReg::~mplay_mediaplayerfi_tclMsgVideoBrightnessRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgVideoBrightnessGet::mplay_mediaplayerfi_tclMsgVideoBrightnessGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoBrightnessGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOBRIGHTNESSGET;
}


mplay_mediaplayerfi_tclMsgVideoBrightnessGet::~mplay_mediaplayerfi_tclMsgVideoBrightnessGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgVideoBrightnessSet::mplay_mediaplayerfi_tclMsgVideoBrightnessSet(const mplay_mediaplayerfi_tclMsgVideoBrightnessSet& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u8VideoBrightness = coRef.u8VideoBrightness;
}
mplay_mediaplayerfi_tclMsgVideoBrightnessSet& mplay_mediaplayerfi_tclMsgVideoBrightnessSet::operator=(const mplay_mediaplayerfi_tclMsgVideoBrightnessSet& coRef)
{
   if (this == &coRef) return *this;
   u8VideoBrightness = coRef.u8VideoBrightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgVideoBrightnessSet::mplay_mediaplayerfi_tclMsgVideoBrightnessSet()
:u8VideoBrightness(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoBrightnessSet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOBRIGHTNESSSET;
}


mplay_mediaplayerfi_tclMsgVideoBrightnessSet::~mplay_mediaplayerfi_tclMsgVideoBrightnessSet()
{}

tU32 mplay_mediaplayerfi_tclMsgVideoBrightnessSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgVideoBrightnessSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8VideoBrightness);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgVideoBrightnessSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8VideoBrightness);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgVideoBrightnessSet::operator==(const mplay_mediaplayerfi_tclMsgVideoBrightnessSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8VideoBrightness == roRef.u8VideoBrightness);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgVideoBrightnessStatus::mplay_mediaplayerfi_tclMsgVideoBrightnessStatus(const mplay_mediaplayerfi_tclMsgVideoBrightnessStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u8VideoBrightness = coRef.u8VideoBrightness;
}
mplay_mediaplayerfi_tclMsgVideoBrightnessStatus& mplay_mediaplayerfi_tclMsgVideoBrightnessStatus::operator=(const mplay_mediaplayerfi_tclMsgVideoBrightnessStatus& coRef)
{
   if (this == &coRef) return *this;
   u8VideoBrightness = coRef.u8VideoBrightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgVideoBrightnessStatus::mplay_mediaplayerfi_tclMsgVideoBrightnessStatus()
:u8VideoBrightness(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoBrightnessStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOBRIGHTNESSSTATUS;
}


mplay_mediaplayerfi_tclMsgVideoBrightnessStatus::~mplay_mediaplayerfi_tclMsgVideoBrightnessStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgVideoBrightnessStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgVideoBrightnessStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8VideoBrightness);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgVideoBrightnessStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8VideoBrightness);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgVideoBrightnessStatus::operator==(const mplay_mediaplayerfi_tclMsgVideoBrightnessStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8VideoBrightness == roRef.u8VideoBrightness);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgVideoHueUpReg::mplay_mediaplayerfi_tclMsgVideoHueUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoHueUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOHUEUPREG;
}


mplay_mediaplayerfi_tclMsgVideoHueUpReg::~mplay_mediaplayerfi_tclMsgVideoHueUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgVideoHueRelUpReg::mplay_mediaplayerfi_tclMsgVideoHueRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoHueRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOHUERELUPREG;
}


mplay_mediaplayerfi_tclMsgVideoHueRelUpReg::~mplay_mediaplayerfi_tclMsgVideoHueRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgVideoHueGet::mplay_mediaplayerfi_tclMsgVideoHueGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoHueGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOHUEGET;
}


mplay_mediaplayerfi_tclMsgVideoHueGet::~mplay_mediaplayerfi_tclMsgVideoHueGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgVideoHueSet::mplay_mediaplayerfi_tclMsgVideoHueSet(const mplay_mediaplayerfi_tclMsgVideoHueSet& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   s16VideoHue = coRef.s16VideoHue;
}
mplay_mediaplayerfi_tclMsgVideoHueSet& mplay_mediaplayerfi_tclMsgVideoHueSet::operator=(const mplay_mediaplayerfi_tclMsgVideoHueSet& coRef)
{
   if (this == &coRef) return *this;
   s16VideoHue = coRef.s16VideoHue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgVideoHueSet::mplay_mediaplayerfi_tclMsgVideoHueSet()
:s16VideoHue(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoHueSet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOHUESET;
}


mplay_mediaplayerfi_tclMsgVideoHueSet::~mplay_mediaplayerfi_tclMsgVideoHueSet()
{}

tU32 mplay_mediaplayerfi_tclMsgVideoHueSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgVideoHueSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s16VideoHue);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgVideoHueSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s16VideoHue);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgVideoHueSet::operator==(const mplay_mediaplayerfi_tclMsgVideoHueSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s16VideoHue == roRef.s16VideoHue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgVideoHueStatus::mplay_mediaplayerfi_tclMsgVideoHueStatus(const mplay_mediaplayerfi_tclMsgVideoHueStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   s16VideoHue = coRef.s16VideoHue;
}
mplay_mediaplayerfi_tclMsgVideoHueStatus& mplay_mediaplayerfi_tclMsgVideoHueStatus::operator=(const mplay_mediaplayerfi_tclMsgVideoHueStatus& coRef)
{
   if (this == &coRef) return *this;
   s16VideoHue = coRef.s16VideoHue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgVideoHueStatus::mplay_mediaplayerfi_tclMsgVideoHueStatus()
:s16VideoHue(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoHueStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOHUESTATUS;
}


mplay_mediaplayerfi_tclMsgVideoHueStatus::~mplay_mediaplayerfi_tclMsgVideoHueStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgVideoHueStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgVideoHueStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s16VideoHue);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgVideoHueStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s16VideoHue);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgVideoHueStatus::operator==(const mplay_mediaplayerfi_tclMsgVideoHueStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s16VideoHue == roRef.s16VideoHue);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgVideoSaturationUpReg::mplay_mediaplayerfi_tclMsgVideoSaturationUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoSaturationUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSATURATIONUPREG;
}


mplay_mediaplayerfi_tclMsgVideoSaturationUpReg::~mplay_mediaplayerfi_tclMsgVideoSaturationUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgVideoSaturationRelUpReg::mplay_mediaplayerfi_tclMsgVideoSaturationRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoSaturationRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSATURATIONRELUPREG;
}


mplay_mediaplayerfi_tclMsgVideoSaturationRelUpReg::~mplay_mediaplayerfi_tclMsgVideoSaturationRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgVideoSaturationGet::mplay_mediaplayerfi_tclMsgVideoSaturationGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoSaturationGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSATURATIONGET;
}


mplay_mediaplayerfi_tclMsgVideoSaturationGet::~mplay_mediaplayerfi_tclMsgVideoSaturationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgVideoSaturationSet::mplay_mediaplayerfi_tclMsgVideoSaturationSet(const mplay_mediaplayerfi_tclMsgVideoSaturationSet& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u8VideoSaturation = coRef.u8VideoSaturation;
}
mplay_mediaplayerfi_tclMsgVideoSaturationSet& mplay_mediaplayerfi_tclMsgVideoSaturationSet::operator=(const mplay_mediaplayerfi_tclMsgVideoSaturationSet& coRef)
{
   if (this == &coRef) return *this;
   u8VideoSaturation = coRef.u8VideoSaturation;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgVideoSaturationSet::mplay_mediaplayerfi_tclMsgVideoSaturationSet()
:u8VideoSaturation(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoSaturationSet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSATURATIONSET;
}


mplay_mediaplayerfi_tclMsgVideoSaturationSet::~mplay_mediaplayerfi_tclMsgVideoSaturationSet()
{}

tU32 mplay_mediaplayerfi_tclMsgVideoSaturationSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgVideoSaturationSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8VideoSaturation);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgVideoSaturationSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8VideoSaturation);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgVideoSaturationSet::operator==(const mplay_mediaplayerfi_tclMsgVideoSaturationSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8VideoSaturation == roRef.u8VideoSaturation);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgVideoSaturationStatus::mplay_mediaplayerfi_tclMsgVideoSaturationStatus(const mplay_mediaplayerfi_tclMsgVideoSaturationStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u8VideoSaturation = coRef.u8VideoSaturation;
}
mplay_mediaplayerfi_tclMsgVideoSaturationStatus& mplay_mediaplayerfi_tclMsgVideoSaturationStatus::operator=(const mplay_mediaplayerfi_tclMsgVideoSaturationStatus& coRef)
{
   if (this == &coRef) return *this;
   u8VideoSaturation = coRef.u8VideoSaturation;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgVideoSaturationStatus::mplay_mediaplayerfi_tclMsgVideoSaturationStatus()
:u8VideoSaturation(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoSaturationStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSATURATIONSTATUS;
}


mplay_mediaplayerfi_tclMsgVideoSaturationStatus::~mplay_mediaplayerfi_tclMsgVideoSaturationStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgVideoSaturationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgVideoSaturationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8VideoSaturation);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgVideoSaturationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8VideoSaturation);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgVideoSaturationStatus::operator==(const mplay_mediaplayerfi_tclMsgVideoSaturationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8VideoSaturation == roRef.u8VideoSaturation);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgVideoContrastUpReg::mplay_mediaplayerfi_tclMsgVideoContrastUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoContrastUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOCONTRASTUPREG;
}


mplay_mediaplayerfi_tclMsgVideoContrastUpReg::~mplay_mediaplayerfi_tclMsgVideoContrastUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgVideoContrastRelUpReg::mplay_mediaplayerfi_tclMsgVideoContrastRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoContrastRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOCONTRASTRELUPREG;
}


mplay_mediaplayerfi_tclMsgVideoContrastRelUpReg::~mplay_mediaplayerfi_tclMsgVideoContrastRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgVideoContrastGet::mplay_mediaplayerfi_tclMsgVideoContrastGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoContrastGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOCONTRASTGET;
}


mplay_mediaplayerfi_tclMsgVideoContrastGet::~mplay_mediaplayerfi_tclMsgVideoContrastGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgVideoContrastSet::mplay_mediaplayerfi_tclMsgVideoContrastSet(const mplay_mediaplayerfi_tclMsgVideoContrastSet& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u8VideoContrast = coRef.u8VideoContrast;
}
mplay_mediaplayerfi_tclMsgVideoContrastSet& mplay_mediaplayerfi_tclMsgVideoContrastSet::operator=(const mplay_mediaplayerfi_tclMsgVideoContrastSet& coRef)
{
   if (this == &coRef) return *this;
   u8VideoContrast = coRef.u8VideoContrast;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgVideoContrastSet::mplay_mediaplayerfi_tclMsgVideoContrastSet()
:u8VideoContrast(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoContrastSet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOCONTRASTSET;
}


mplay_mediaplayerfi_tclMsgVideoContrastSet::~mplay_mediaplayerfi_tclMsgVideoContrastSet()
{}

tU32 mplay_mediaplayerfi_tclMsgVideoContrastSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgVideoContrastSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8VideoContrast);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgVideoContrastSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8VideoContrast);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgVideoContrastSet::operator==(const mplay_mediaplayerfi_tclMsgVideoContrastSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8VideoContrast == roRef.u8VideoContrast);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgVideoContrastStatus::mplay_mediaplayerfi_tclMsgVideoContrastStatus(const mplay_mediaplayerfi_tclMsgVideoContrastStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u8VideoContrast = coRef.u8VideoContrast;
}
mplay_mediaplayerfi_tclMsgVideoContrastStatus& mplay_mediaplayerfi_tclMsgVideoContrastStatus::operator=(const mplay_mediaplayerfi_tclMsgVideoContrastStatus& coRef)
{
   if (this == &coRef) return *this;
   u8VideoContrast = coRef.u8VideoContrast;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgVideoContrastStatus::mplay_mediaplayerfi_tclMsgVideoContrastStatus()
:u8VideoContrast(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoContrastStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOCONTRASTSTATUS;
}


mplay_mediaplayerfi_tclMsgVideoContrastStatus::~mplay_mediaplayerfi_tclMsgVideoContrastStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgVideoContrastStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgVideoContrastStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8VideoContrast);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgVideoContrastStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8VideoContrast);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgVideoContrastStatus::operator==(const mplay_mediaplayerfi_tclMsgVideoContrastStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8VideoContrast == roRef.u8VideoContrast);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetUpReg::mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOBRIGHTNESSOFFSETUPREG;
}


mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetUpReg::~mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetRelUpReg::mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOBRIGHTNESSOFFSETRELUPREG;
}


mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetRelUpReg::~mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetGet::mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOBRIGHTNESSOFFSETGET;
}


mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetGet::~mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetSet::mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetSet(const mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetSet& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   s16VideoBrightnessOffset = coRef.s16VideoBrightnessOffset;
}
mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetSet& mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetSet::operator=(const mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetSet& coRef)
{
   if (this == &coRef) return *this;
   s16VideoBrightnessOffset = coRef.s16VideoBrightnessOffset;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetSet::mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetSet()
:s16VideoBrightnessOffset(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetSet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOBRIGHTNESSOFFSETSET;
}


mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetSet::~mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetSet()
{}

tU32 mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s16VideoBrightnessOffset);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s16VideoBrightnessOffset);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetSet::operator==(const mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s16VideoBrightnessOffset == roRef.s16VideoBrightnessOffset);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetStatus::mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetStatus(const mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   s16VideoBrightnessOffset = coRef.s16VideoBrightnessOffset;
}
mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetStatus& mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetStatus::operator=(const mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetStatus& coRef)
{
   if (this == &coRef) return *this;
   s16VideoBrightnessOffset = coRef.s16VideoBrightnessOffset;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetStatus::mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetStatus()
:s16VideoBrightnessOffset(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOBRIGHTNESSOFFSETSTATUS;
}


mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetStatus::~mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s16VideoBrightnessOffset);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s16VideoBrightnessOffset);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetStatus::operator==(const mplay_mediaplayerfi_tclMsgVideoBrightnessOffsetStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s16VideoBrightnessOffset == roRef.s16VideoBrightnessOffset);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgVideoHueOffsetUpReg::mplay_mediaplayerfi_tclMsgVideoHueOffsetUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoHueOffsetUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOHUEOFFSETUPREG;
}


mplay_mediaplayerfi_tclMsgVideoHueOffsetUpReg::~mplay_mediaplayerfi_tclMsgVideoHueOffsetUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgVideoHueOffsetRelUpReg::mplay_mediaplayerfi_tclMsgVideoHueOffsetRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoHueOffsetRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOHUEOFFSETRELUPREG;
}


mplay_mediaplayerfi_tclMsgVideoHueOffsetRelUpReg::~mplay_mediaplayerfi_tclMsgVideoHueOffsetRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgVideoHueOffsetGet::mplay_mediaplayerfi_tclMsgVideoHueOffsetGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoHueOffsetGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOHUEOFFSETGET;
}


mplay_mediaplayerfi_tclMsgVideoHueOffsetGet::~mplay_mediaplayerfi_tclMsgVideoHueOffsetGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgVideoHueOffsetSet::mplay_mediaplayerfi_tclMsgVideoHueOffsetSet(const mplay_mediaplayerfi_tclMsgVideoHueOffsetSet& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   s16VideoHueOffset = coRef.s16VideoHueOffset;
}
mplay_mediaplayerfi_tclMsgVideoHueOffsetSet& mplay_mediaplayerfi_tclMsgVideoHueOffsetSet::operator=(const mplay_mediaplayerfi_tclMsgVideoHueOffsetSet& coRef)
{
   if (this == &coRef) return *this;
   s16VideoHueOffset = coRef.s16VideoHueOffset;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgVideoHueOffsetSet::mplay_mediaplayerfi_tclMsgVideoHueOffsetSet()
:s16VideoHueOffset(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoHueOffsetSet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOHUEOFFSETSET;
}


mplay_mediaplayerfi_tclMsgVideoHueOffsetSet::~mplay_mediaplayerfi_tclMsgVideoHueOffsetSet()
{}

tU32 mplay_mediaplayerfi_tclMsgVideoHueOffsetSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgVideoHueOffsetSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s16VideoHueOffset);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgVideoHueOffsetSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s16VideoHueOffset);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgVideoHueOffsetSet::operator==(const mplay_mediaplayerfi_tclMsgVideoHueOffsetSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s16VideoHueOffset == roRef.s16VideoHueOffset);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgVideoHueOffsetStatus::mplay_mediaplayerfi_tclMsgVideoHueOffsetStatus(const mplay_mediaplayerfi_tclMsgVideoHueOffsetStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   s16VideoHueOffset = coRef.s16VideoHueOffset;
}
mplay_mediaplayerfi_tclMsgVideoHueOffsetStatus& mplay_mediaplayerfi_tclMsgVideoHueOffsetStatus::operator=(const mplay_mediaplayerfi_tclMsgVideoHueOffsetStatus& coRef)
{
   if (this == &coRef) return *this;
   s16VideoHueOffset = coRef.s16VideoHueOffset;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgVideoHueOffsetStatus::mplay_mediaplayerfi_tclMsgVideoHueOffsetStatus()
:s16VideoHueOffset(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoHueOffsetStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOHUEOFFSETSTATUS;
}


mplay_mediaplayerfi_tclMsgVideoHueOffsetStatus::~mplay_mediaplayerfi_tclMsgVideoHueOffsetStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgVideoHueOffsetStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgVideoHueOffsetStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s16VideoHueOffset);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgVideoHueOffsetStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s16VideoHueOffset);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgVideoHueOffsetStatus::operator==(const mplay_mediaplayerfi_tclMsgVideoHueOffsetStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s16VideoHueOffset == roRef.s16VideoHueOffset);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgVideoSaturationOffsetUpReg::mplay_mediaplayerfi_tclMsgVideoSaturationOffsetUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoSaturationOffsetUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSATURATIONOFFSETUPREG;
}


mplay_mediaplayerfi_tclMsgVideoSaturationOffsetUpReg::~mplay_mediaplayerfi_tclMsgVideoSaturationOffsetUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgVideoSaturationOffsetRelUpReg::mplay_mediaplayerfi_tclMsgVideoSaturationOffsetRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoSaturationOffsetRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSATURATIONOFFSETRELUPREG;
}


mplay_mediaplayerfi_tclMsgVideoSaturationOffsetRelUpReg::~mplay_mediaplayerfi_tclMsgVideoSaturationOffsetRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgVideoSaturationOffsetGet::mplay_mediaplayerfi_tclMsgVideoSaturationOffsetGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoSaturationOffsetGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSATURATIONOFFSETGET;
}


mplay_mediaplayerfi_tclMsgVideoSaturationOffsetGet::~mplay_mediaplayerfi_tclMsgVideoSaturationOffsetGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgVideoSaturationOffsetSet::mplay_mediaplayerfi_tclMsgVideoSaturationOffsetSet(const mplay_mediaplayerfi_tclMsgVideoSaturationOffsetSet& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u8VideoSaturationOffset = coRef.u8VideoSaturationOffset;
}
mplay_mediaplayerfi_tclMsgVideoSaturationOffsetSet& mplay_mediaplayerfi_tclMsgVideoSaturationOffsetSet::operator=(const mplay_mediaplayerfi_tclMsgVideoSaturationOffsetSet& coRef)
{
   if (this == &coRef) return *this;
   u8VideoSaturationOffset = coRef.u8VideoSaturationOffset;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgVideoSaturationOffsetSet::mplay_mediaplayerfi_tclMsgVideoSaturationOffsetSet()
:u8VideoSaturationOffset(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoSaturationOffsetSet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSATURATIONOFFSETSET;
}


mplay_mediaplayerfi_tclMsgVideoSaturationOffsetSet::~mplay_mediaplayerfi_tclMsgVideoSaturationOffsetSet()
{}

tU32 mplay_mediaplayerfi_tclMsgVideoSaturationOffsetSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgVideoSaturationOffsetSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8VideoSaturationOffset);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgVideoSaturationOffsetSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8VideoSaturationOffset);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgVideoSaturationOffsetSet::operator==(const mplay_mediaplayerfi_tclMsgVideoSaturationOffsetSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8VideoSaturationOffset == roRef.u8VideoSaturationOffset);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgVideoSaturationOffsetStatus::mplay_mediaplayerfi_tclMsgVideoSaturationOffsetStatus(const mplay_mediaplayerfi_tclMsgVideoSaturationOffsetStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u8VideoSaturationOffset = coRef.u8VideoSaturationOffset;
}
mplay_mediaplayerfi_tclMsgVideoSaturationOffsetStatus& mplay_mediaplayerfi_tclMsgVideoSaturationOffsetStatus::operator=(const mplay_mediaplayerfi_tclMsgVideoSaturationOffsetStatus& coRef)
{
   if (this == &coRef) return *this;
   u8VideoSaturationOffset = coRef.u8VideoSaturationOffset;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgVideoSaturationOffsetStatus::mplay_mediaplayerfi_tclMsgVideoSaturationOffsetStatus()
:u8VideoSaturationOffset(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoSaturationOffsetStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSATURATIONOFFSETSTATUS;
}


mplay_mediaplayerfi_tclMsgVideoSaturationOffsetStatus::~mplay_mediaplayerfi_tclMsgVideoSaturationOffsetStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgVideoSaturationOffsetStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgVideoSaturationOffsetStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8VideoSaturationOffset);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgVideoSaturationOffsetStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8VideoSaturationOffset);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgVideoSaturationOffsetStatus::operator==(const mplay_mediaplayerfi_tclMsgVideoSaturationOffsetStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8VideoSaturationOffset == roRef.u8VideoSaturationOffset);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgVideoScalingUpReg::mplay_mediaplayerfi_tclMsgVideoScalingUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoScalingUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSCALINGUPREG;
}


mplay_mediaplayerfi_tclMsgVideoScalingUpReg::~mplay_mediaplayerfi_tclMsgVideoScalingUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgVideoScalingRelUpReg::mplay_mediaplayerfi_tclMsgVideoScalingRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoScalingRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSCALINGRELUPREG;
}


mplay_mediaplayerfi_tclMsgVideoScalingRelUpReg::~mplay_mediaplayerfi_tclMsgVideoScalingRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgVideoScalingGet::mplay_mediaplayerfi_tclMsgVideoScalingGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoScalingGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSCALINGGET;
}


mplay_mediaplayerfi_tclMsgVideoScalingGet::~mplay_mediaplayerfi_tclMsgVideoScalingGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgVideoScalingSet::mplay_mediaplayerfi_tclMsgVideoScalingSet(const mplay_mediaplayerfi_tclMsgVideoScalingSet& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   eVideoScaling = coRef.eVideoScaling;
}
mplay_mediaplayerfi_tclMsgVideoScalingSet& mplay_mediaplayerfi_tclMsgVideoScalingSet::operator=(const mplay_mediaplayerfi_tclMsgVideoScalingSet& coRef)
{
   if (this == &coRef) return *this;
   eVideoScaling = coRef.eVideoScaling;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgVideoScalingSet::mplay_mediaplayerfi_tclMsgVideoScalingSet()
:eVideoScaling()
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoScalingSet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSCALINGSET;
}


mplay_mediaplayerfi_tclMsgVideoScalingSet::~mplay_mediaplayerfi_tclMsgVideoScalingSet()
{}

tU32 mplay_mediaplayerfi_tclMsgVideoScalingSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgVideoScalingSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eVideoScaling);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgVideoScalingSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eVideoScaling);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgVideoScalingSet::operator==(const mplay_mediaplayerfi_tclMsgVideoScalingSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eVideoScaling == roRef.eVideoScaling);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgVideoScalingStatus::mplay_mediaplayerfi_tclMsgVideoScalingStatus(const mplay_mediaplayerfi_tclMsgVideoScalingStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   eVideoScaling = coRef.eVideoScaling;
}
mplay_mediaplayerfi_tclMsgVideoScalingStatus& mplay_mediaplayerfi_tclMsgVideoScalingStatus::operator=(const mplay_mediaplayerfi_tclMsgVideoScalingStatus& coRef)
{
   if (this == &coRef) return *this;
   eVideoScaling = coRef.eVideoScaling;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgVideoScalingStatus::mplay_mediaplayerfi_tclMsgVideoScalingStatus()
:eVideoScaling()
 {}

tS32 mplay_mediaplayerfi_tclMsgVideoScalingStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_VIDEOSCALINGSTATUS;
}


mplay_mediaplayerfi_tclMsgVideoScalingStatus::~mplay_mediaplayerfi_tclMsgVideoScalingStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgVideoScalingStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgVideoScalingStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eVideoScaling);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgVideoScalingStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eVideoScaling);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgVideoScalingStatus::operator==(const mplay_mediaplayerfi_tclMsgVideoScalingStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eVideoScaling == roRef.eVideoScaling);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedGet::mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_UPDATEPLAYBACKSPEEDGET;
}


mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedGet::~mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedGet()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedRelUpReg::mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_UPDATEPLAYBACKSPEEDRELUPREG;
}


mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedRelUpReg::~mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedSet::mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedSet()
 {}

tS32 mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedSet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_UPDATEPLAYBACKSPEEDSET;
}


mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedSet::~mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedSet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedStatus::mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedStatus(const mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8PlaybackSpeed = coRef.e8PlaybackSpeed;
}
mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedStatus& mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedStatus::operator=(const mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedStatus& coRef)
{
   if (this == &coRef) return *this;
   e8PlaybackSpeed = coRef.e8PlaybackSpeed;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedStatus::mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedStatus()
:e8PlaybackSpeed()
 {}

tS32 mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_UPDATEPLAYBACKSPEEDSTATUS;
}


mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedStatus::~mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8PlaybackSpeed);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8PlaybackSpeed);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedStatus::operator==(const mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8PlaybackSpeed == roRef.e8PlaybackSpeed);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedUpReg::mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_UPDATEPLAYBACKSPEEDUPREG;
}


mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedUpReg::~mplay_mediaplayerfi_tclMsgUpdatePlaybackSpeedUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgUserFavoritesChangedUpReg::mplay_mediaplayerfi_tclMsgUserFavoritesChangedUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgUserFavoritesChangedUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_USERFAVORITESCHANGEDUPREG;
}


mplay_mediaplayerfi_tclMsgUserFavoritesChangedUpReg::~mplay_mediaplayerfi_tclMsgUserFavoritesChangedUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgUserFavoritesChangedRelUpReg::mplay_mediaplayerfi_tclMsgUserFavoritesChangedRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgUserFavoritesChangedRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_USERFAVORITESCHANGEDRELUPREG;
}


mplay_mediaplayerfi_tclMsgUserFavoritesChangedRelUpReg::~mplay_mediaplayerfi_tclMsgUserFavoritesChangedRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgUserFavoritesChangedStatus::mplay_mediaplayerfi_tclMsgUserFavoritesChangedStatus(const mplay_mediaplayerfi_tclMsgUserFavoritesChangedStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   e8ListChangeType = coRef.e8ListChangeType;
   u32ListSize = coRef.u32ListSize;
   u32NumItems = coRef.u32NumItems;
   oChangedFavorites = coRef.oChangedFavorites;
}
mplay_mediaplayerfi_tclMsgUserFavoritesChangedStatus& mplay_mediaplayerfi_tclMsgUserFavoritesChangedStatus::operator=(const mplay_mediaplayerfi_tclMsgUserFavoritesChangedStatus& coRef)
{
   if (this == &coRef) return *this;
   e8ListChangeType = coRef.e8ListChangeType;
   u32ListSize = coRef.u32ListSize;
   u32NumItems = coRef.u32NumItems;
   oChangedFavorites = coRef.oChangedFavorites;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgUserFavoritesChangedStatus::vDestroy()
{
   oChangedFavorites.vDestroy(); 
}

mplay_mediaplayerfi_tclMsgUserFavoritesChangedStatus::mplay_mediaplayerfi_tclMsgUserFavoritesChangedStatus()
:e8ListChangeType()
,u32ListSize(0)
,u32NumItems(0)
,oChangedFavorites()
 {}

tS32 mplay_mediaplayerfi_tclMsgUserFavoritesChangedStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_USERFAVORITESCHANGEDSTATUS;
}


mplay_mediaplayerfi_tclMsgUserFavoritesChangedStatus::~mplay_mediaplayerfi_tclMsgUserFavoritesChangedStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgUserFavoritesChangedStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 9+oChangedFavorites.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgUserFavoritesChangedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ListChangeType);
   (tVoid) (oIn >> u32ListSize);
   (tVoid) (oIn >> u32NumItems);
   (tVoid) (oIn >> oChangedFavorites);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgUserFavoritesChangedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ListChangeType);
   (tVoid) (oOut << u32ListSize);
   (tVoid) (oOut << u32NumItems);
   (tVoid) (oOut << oChangedFavorites);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgUserFavoritesChangedStatus::operator==(const mplay_mediaplayerfi_tclMsgUserFavoritesChangedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ListChangeType == roRef.e8ListChangeType);
   bResult = bResult && (u32ListSize == roRef.u32ListSize);
   bResult = bResult && (u32NumItems == roRef.u32NumItems);
   bResult = bResult && (oChangedFavorites == roRef.oChangedFavorites);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedUpReg::mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_FOLDERBROWSESTRUCTURECLEAREDUPREG;
}


mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedUpReg::~mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedRelUpReg::mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_FOLDERBROWSESTRUCTURECLEAREDRELUPREG;
}


mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedRelUpReg::~mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedStatus::mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedStatus(const mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   u8DeviceTag = coRef.u8DeviceTag;
}
mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedStatus& mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedStatus::operator=(const mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedStatus& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedStatus::mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedStatus()
:u8DeviceTag(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_FOLDERBROWSESTRUCTURECLEAREDSTATUS;
}


mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedStatus::~mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedStatus::operator==(const mplay_mediaplayerfi_tclMsgFolderBrowseStructureClearedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgReadyToPlayUpReg::mplay_mediaplayerfi_tclMsgReadyToPlayUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgReadyToPlayUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_READYTOPLAYUPREG;
}


mplay_mediaplayerfi_tclMsgReadyToPlayUpReg::~mplay_mediaplayerfi_tclMsgReadyToPlayUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgReadyToPlayRelUpReg::mplay_mediaplayerfi_tclMsgReadyToPlayRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgReadyToPlayRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_READYTOPLAYRELUPREG;
}


mplay_mediaplayerfi_tclMsgReadyToPlayRelUpReg::~mplay_mediaplayerfi_tclMsgReadyToPlayRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgReadyToPlayGet::mplay_mediaplayerfi_tclMsgReadyToPlayGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgReadyToPlayGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_READYTOPLAYGET;
}


mplay_mediaplayerfi_tclMsgReadyToPlayGet::~mplay_mediaplayerfi_tclMsgReadyToPlayGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgReadyToPlayStatus::mplay_mediaplayerfi_tclMsgReadyToPlayStatus(const mplay_mediaplayerfi_tclMsgReadyToPlayStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   sDeviceSerialNumber = coRef.sDeviceSerialNumber;
   bPlayingStatus = coRef.bPlayingStatus;
}
mplay_mediaplayerfi_tclMsgReadyToPlayStatus& mplay_mediaplayerfi_tclMsgReadyToPlayStatus::operator=(const mplay_mediaplayerfi_tclMsgReadyToPlayStatus& coRef)
{
   if (this == &coRef) return *this;
   sDeviceSerialNumber = coRef.sDeviceSerialNumber;
   bPlayingStatus = coRef.bPlayingStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mediaplayerfi_tclMsgReadyToPlayStatus::vDestroy()
{
   sDeviceSerialNumber.vDestroy();
}

mplay_mediaplayerfi_tclMsgReadyToPlayStatus::mplay_mediaplayerfi_tclMsgReadyToPlayStatus()
:sDeviceSerialNumber()
,bPlayingStatus(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgReadyToPlayStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_READYTOPLAYSTATUS;
}


mplay_mediaplayerfi_tclMsgReadyToPlayStatus::~mplay_mediaplayerfi_tclMsgReadyToPlayStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mediaplayerfi_tclMsgReadyToPlayStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sDeviceSerialNumber.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgReadyToPlayStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sDeviceSerialNumber);
   (tVoid) (oIn >> bPlayingStatus);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgReadyToPlayStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sDeviceSerialNumber);
   (tVoid) (oOut << bPlayingStatus);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgReadyToPlayStatus::operator==(const mplay_mediaplayerfi_tclMsgReadyToPlayStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sDeviceSerialNumber == roRef.sDeviceSerialNumber);
   bResult = bResult && (bPlayingStatus == roRef.bPlayingStatus);
   return bResult;
}

//=============================================================================

mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusUpReg::mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_BLUETOOTHAUDIODEVICESTATUSUPREG;
}


mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusUpReg::~mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusRelUpReg::mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusRelUpReg()
 {}

tS32 mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_BLUETOOTHAUDIODEVICESTATUSRELUPREG;
}


mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusRelUpReg::~mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusRelUpReg()
{}

//=============================================================================

mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusGet::mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusGet()
 {}

tS32 mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusGet::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_BLUETOOTHAUDIODEVICESTATUSGET;
}


mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusGet::~mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusStatus::mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusStatus(const mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusStatus& coRef)
   : mplay_mediaplayerfi_tclMsgBaseMessage(coRef)
{
   bAudioDeviceStatus = coRef.bAudioDeviceStatus;
}
mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusStatus& mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusStatus::operator=(const mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   bAudioDeviceStatus = coRef.bAudioDeviceStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusStatus::mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusStatus()
:bAudioDeviceStatus(0)
 {}

tS32 mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusStatus::s32GetTypeId() const
{
   return (tS32) mplay_mediaplayerfi_tclToken::EN_MSG_BLUETOOTHAUDIODEVICESTATUSSTATUS;
}


mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusStatus::~mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusStatus()
{}

tU32 mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bAudioDeviceStatus);
   return oIn;
}

fi_tclOutContext& mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bAudioDeviceStatus);
   return oOut;
}

tBool mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusStatus::operator==(const mplay_mediaplayerfi_tclMsgBluetoothAudioDeviceStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bAudioDeviceStatus == roRef.bAudioDeviceStatus);
   return bResult;
}

