#ifndef MPLAY_MEDIAPLAYERFILANGUAGE_HEADER
#define MPLAY_MEDIAPLAYERFILANGUAGE_HEADER

class mplay_mediaplayerfi_tclInContext;
class mplay_mediaplayerfi_tclOutContext;
class mplay_mediaplayerfi_tclVisitorBase;

class MY_DECL mplay_mediaplayerfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  mplay_mediaplayerfi_tclDescription(fi_tclInContext* poIn, mplay_mediaplayerfi_tclVisitorBase* poVisit);
  mplay_mediaplayerfi_tclDescription(fi_tclOutContext* poOut, mplay_mediaplayerfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(mplay_mediaplayerfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(mplay_fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ mplay_mediaplayerfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  mplay_mediaplayerfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<mplay_mediaplayerfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<mplay_mediaplayerfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline mplay_mediaplayerfi_tclDescription::mplay_mediaplayerfi_tclDescription(fi_tclInContext* poIn, mplay_mediaplayerfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline mplay_mediaplayerfi_tclDescription::mplay_mediaplayerfi_tclDescription(fi_tclOutContext* poOut, mplay_mediaplayerfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

