#ifndef __MPLAY_MEDIAPLAYERFIDEBUGVISITOR_H__
#define __MPLAY_MEDIAPLAYERFIDEBUGVISITOR_H__

class MY_DECL mplay_mediaplayerfi_tclPrintVisitor : public mplay_mediaplayerfi_tclVisitorBase {

private:
   /* default constructor */ mplay_mediaplayerfi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   mplay_mediaplayerfi_tclPrintVisitor(mplay_fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(mplay_fi_tclU8& oU8);
   virtual tVoid vVisitS8(mplay_fi_tclS8& oS8);
   virtual tVoid vVisitU16(mplay_fi_tclU16& oU16);
   virtual tVoid vVisitS16(mplay_fi_tclS16& oS16);
   virtual tVoid vVisitU24(mplay_fi_tclU24& oU24);
   virtual tVoid vVisitS24(mplay_fi_tclS24& oS24);
   virtual tVoid vVisitU32(mplay_fi_tclU32& oU32);
   virtual tVoid vVisitS32(mplay_fi_tclS32& oS32);
   virtual tVoid vVisitU64(mplay_fi_tclU64& oU64);
   virtual tVoid vVisitS64(mplay_fi_tclS64& oS64);
   virtual tVoid vVisitBool(mplay_fi_tclBool& oBool);
   virtual tVoid vVisitString(mplay_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(mplay_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(mplay_fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ShortStream(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_EjectOpticalDisc_MethodResult(mplay_fi_tcl_e8_EjectOpticalDisc_MethodResult& o_e8_EjectOpticalDisc_MethodResult);
   virtual tVoid vVisit_e8_SlotStateOpticalDiscType(mplay_fi_tcl_e8_SlotStateOpticalDiscType& o_e8_SlotStateOpticalDiscType);
   virtual tVoid vVisit_e8_EjectParmType(mplay_fi_tcl_e8_EjectParmType& o_e8_EjectParmType);
   virtual tVoid vVisit_e8DeviceState(mplay_fi_tcl_e8DeviceState& o_e8DeviceState);
   virtual tBool bDoExpand_e8_CDInfo(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DVDCommandStatus(mplay_fi_tcl_e8_DVDCommandStatus& o_e8_DVDCommandStatus);
   virtual tVoid vVisit_e8_MDVDDiscType(mplay_fi_tcl_e8_MDVDDiscType& o_e8_MDVDDiscType);
   virtual tVoid vVisit_e8_MDVDDriveMode(mplay_fi_tcl_e8_MDVDDriveMode& o_e8_MDVDDriveMode);
   virtual tVoid vVisit_e8_MAngle(mplay_fi_tcl_e8_MAngle& o_e8_MAngle);
   virtual tVoid vVisit_e8_MAudioOutputNumber(mplay_fi_tcl_e8_MAudioOutputNumber& o_e8_MAudioOutputNumber);
   virtual tVoid vVisit_e8_MChannelAssignment(mplay_fi_tcl_e8_MChannelAssignment& o_e8_MChannelAssignment);
   virtual tVoid vVisit_e8_MCMSkipValue(mplay_fi_tcl_e8_MCMSkipValue& o_e8_MCMSkipValue);
   virtual tVoid vVisit_e8_MDiscError(mplay_fi_tcl_e8_MDiscError& o_e8_MDiscError);
   virtual tVoid vVisit_e8_MDiscMechanicalInfo(mplay_fi_tcl_e8_MDiscMechanicalInfo& o_e8_MDiscMechanicalInfo);
   virtual tVoid vVisit_e8_MDiscOperation(mplay_fi_tcl_e8_MDiscOperation& o_e8_MDiscOperation);
   virtual tVoid vVisit_e8_MDiscType(mplay_fi_tcl_e8_MDiscType& o_e8_MDiscType);
   virtual tVoid vVisit_e8_MDisplayMode(mplay_fi_tcl_e8_MDisplayMode& o_e8_MDisplayMode);
   virtual tVoid vVisit_e8_MDRCSetting(mplay_fi_tcl_e8_MDRCSetting& o_e8_MDRCSetting);
   virtual tVoid vVisit_e8_MGeneralSelectionType(mplay_fi_tcl_e8_MGeneralSelectionType& o_e8_MGeneralSelectionType);
   virtual tVoid vVisit_e8_MMenuControlData(mplay_fi_tcl_e8_MMenuControlData& o_e8_MMenuControlData);
   virtual tVoid vVisit_e8_MNavigationKey(mplay_fi_tcl_e8_MNavigationKey& o_e8_MNavigationKey);
   virtual tVoid vVisit_e8_MPlayAction(mplay_fi_tcl_e8_MPlayAction& o_e8_MPlayAction);
   virtual tVoid vVisit_e8_MPlayAudioChannelFormat(mplay_fi_tcl_e8_MPlayAudioChannelFormat& o_e8_MPlayAudioChannelFormat);
   virtual tVoid vVisit_e8_MPlayAvailabilityReason(mplay_fi_tcl_e8_MPlayAvailabilityReason& o_e8_MPlayAvailabilityReason);
   virtual tVoid vVisit_e8_MPlaybackDirection(mplay_fi_tcl_e8_MPlaybackDirection& o_e8_MPlaybackDirection);
   virtual tVoid vVisit_e8_MPlaybackSpeed(mplay_fi_tcl_e8_MPlaybackSpeed& o_e8_MPlaybackSpeed);
   virtual tVoid vVisit_e8_MPlayCategoryType(mplay_fi_tcl_e8_MPlayCategoryType& o_e8_MPlayCategoryType);
   virtual tVoid vVisit_e8_MPlayChange(mplay_fi_tcl_e8_MPlayChange& o_e8_MPlayChange);
   virtual tVoid vVisit_e8_MPlayConnectionState(mplay_fi_tcl_e8_MPlayConnectionState& o_e8_MPlayConnectionState);
   virtual tVoid vVisit_e8_MPlayConnectionType(mplay_fi_tcl_e8_MPlayConnectionType& o_e8_MPlayConnectionType);
   virtual tVoid vVisit_e8_MPlayDeleteMediaContentTaskResult(mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult& o_e8_MPlayDeleteMediaContentTaskResult);
   virtual tVoid vVisit_e8_MPlayDeviceControlSupport(mplay_fi_tcl_e8_MPlayDeviceControlSupport& o_e8_MPlayDeviceControlSupport);
   virtual tVoid vVisit_e8_MPlayDeviceIndexedState(mplay_fi_tcl_e8_MPlayDeviceIndexedState& o_e8_MPlayDeviceIndexedState);
   virtual tVoid vVisit_e8_MPlayDeviceRippingState(mplay_fi_tcl_e8_MPlayDeviceRippingState& o_e8_MPlayDeviceRippingState);
   virtual tVoid vVisit_e8_MPlayDeviceStatus(mplay_fi_tcl_e8_MPlayDeviceStatus& o_e8_MPlayDeviceStatus);
   virtual tVoid vVisit_e8_MPlayDeviceType(mplay_fi_tcl_e8_MPlayDeviceType& o_e8_MPlayDeviceType);
   virtual tVoid vVisit_e8_MPlayDisconnectReason(mplay_fi_tcl_e8_MPlayDisconnectReason& o_e8_MPlayDisconnectReason);
   virtual tVoid vVisit_e8_MPlayEditMetaDataTaskResult(mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult& o_e8_MPlayEditMetaDataTaskResult);
   virtual tVoid vVisit_e8_MPlayEncodingQuality(mplay_fi_tcl_e8_MPlayEncodingQuality& o_e8_MPlayEncodingQuality);
   virtual tVoid vVisit_e8_MPlayFileFormat(mplay_fi_tcl_e8_MPlayFileFormat& o_e8_MPlayFileFormat);
   virtual tVoid vVisit_e8_MPlayFileSystemType(mplay_fi_tcl_e8_MPlayFileSystemType& o_e8_MPlayFileSystemType);
   virtual tVoid vVisit_e8_MPlayFileType(mplay_fi_tcl_e8_MPlayFileType& o_e8_MPlayFileType);
   virtual tVoid vVisit_e8_MPlayFileTypeSelection(mplay_fi_tcl_e8_MPlayFileTypeSelection& o_e8_MPlayFileTypeSelection);
   virtual tVoid vVisit_e8_MPlayGNmetadataExtractionResult(mplay_fi_tcl_e8_MPlayGNmetadataExtractionResult& o_e8_MPlayGNmetadataExtractionResult);
   virtual tVoid vVisit_e8_MPlayInternalPlaylistTaskResult(mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult& o_e8_MPlayInternalPlaylistTaskResult);
   virtual tVoid vVisit_e8_MPlayiPodCommunicationError(mplay_fi_tcl_e8_MPlayiPodCommunicationError& o_e8_MPlayiPodCommunicationError);
   virtual tVoid vVisit_e8_MPlayLanguage(mplay_fi_tcl_e8_MPlayLanguage& o_e8_MPlayLanguage);
   virtual tVoid vVisit_e8_MPlayListType(mplay_fi_tcl_e8_MPlayListType& o_e8_MPlayListType);
   virtual tVoid vVisit_e8_MPlayMediaType(mplay_fi_tcl_e8_MPlayMediaType& o_e8_MPlayMediaType);
   virtual tVoid vVisit_e8_MPlayMode(mplay_fi_tcl_e8_MPlayMode& o_e8_MPlayMode);
   virtual tVoid vVisit_e8_MPlayNowPlayingState(mplay_fi_tcl_e8_MPlayNowPlayingState& o_e8_MPlayNowPlayingState);
   virtual tVoid vVisit_e8_MPlayPlayableStatus(mplay_fi_tcl_e8_MPlayPlayableStatus& o_e8_MPlayPlayableStatus);
   virtual tVoid vVisit_e8_MPlayPlaypointFormat(mplay_fi_tcl_e8_MPlayPlaypointFormat& o_e8_MPlayPlaypointFormat);
   virtual tVoid vVisit_e8_MPlayRepeat(mplay_fi_tcl_e8_MPlayRepeat& o_e8_MPlayRepeat);
   virtual tVoid vVisit_e8_MPlayState(mplay_fi_tcl_e8_MPlayState& o_e8_MPlayState);
   virtual tVoid vVisit_e8_MPlayStreamingInfo(mplay_fi_tcl_e8_MPlayStreamingInfo& o_e8_MPlayStreamingInfo);
   virtual tVoid vVisit_e8_MPlayTagTransferStatus(mplay_fi_tcl_e8_MPlayTagTransferStatus& o_e8_MPlayTagTransferStatus);
   virtual tVoid vVisit_e8_MPlayUmountResult(mplay_fi_tcl_e8_MPlayUmountResult& o_e8_MPlayUmountResult);
   virtual tVoid vVisit_e8_MSoundFormat(mplay_fi_tcl_e8_MSoundFormat& o_e8_MSoundFormat);
   virtual tVoid vVisit_e8_MSubtitleSelectionType(mplay_fi_tcl_e8_MSubtitleSelectionType& o_e8_MSubtitleSelectionType);
   virtual tVoid vVisit_e8_MTotalChannel(mplay_fi_tcl_e8_MTotalChannel& o_e8_MTotalChannel);
   virtual tVoid vVisit_e8_MTouchAction(mplay_fi_tcl_e8_MTouchAction& o_e8_MTouchAction);
   virtual tVoid vVisit_e8_MVCDAudioMode(mplay_fi_tcl_e8_MVCDAudioMode& o_e8_MVCDAudioMode);
   virtual tVoid vVisit_e8_QuickSearchResult(mplay_fi_tcl_e8_QuickSearchResult& o_e8_QuickSearchResult);
   virtual tBool bDoExpand_MInternalDVDLangSetting(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e_MPlayDeviceDBViewStatus(mplay_fi_tcl_e_MPlayDeviceDBViewStatus& o_e_MPlayDeviceDBViewStatus);
   virtual tBool bDoExpand_MPlayDeviceInfoItem(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MPlayFavoritesList(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MPlayFileListItem(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MPlayFileList(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MPlayImageData(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MPlayImageObjectItem(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MPlayImageObjects(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MPlayIndexingStateResultItem(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MPlayIndexingStateResult(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MPlayItems(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MPlayMediaAlbums(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MPlayMediaObject(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MPlayMediaObjectsItem(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MPlayMediaObjects(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MPlayMediaObjectTag(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MPlayMediaObjectUrl(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PermissionByTag(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MPlayPlayListPosition(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_MPlayRippingErrors(mplay_fi_tcl_MPlayRippingErrors& o_MPlayRippingErrors);
   virtual tBool bDoExpand_MPlayRippingStateResultItem(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MPlaySearchKeyboardListItem(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MPlaySearchKeyboardList(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MPlayTagTransferItem_2(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MPlayTagTransfer_2(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MPlayUntransferredTagStreamItem(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MPlayUntransferredTagStream(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MPlayPermissionByTag(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SearchString(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_MPlaySearchType(mplay_fi_tcl_MPlaySearchType& o_MPlaySearchType);
   virtual tVoid vVisit_VideoScalingType(mplay_fi_tcl_VideoScalingType& o_VideoScalingType);
   virtual tVoid vVisit_IndicesType(mplay_fi_tcl_IndicesType& o_IndicesType);
   virtual tBool bDoExpand_IndicesList(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_AlbumArtUrlList(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e_MPlayHIDCommand(mplay_fi_tcl_e_MPlayHIDCommand& o_e_MPlayHIDCommand);
   virtual tVoid vVisit_e_MPlayKeyEvent(mplay_fi_tcl_e_MPlayKeyEvent& o_e_MPlayKeyEvent);
   virtual tBool bDoExpand_MPlayDeviceInfo(mplay_mediaplayerfi_tclSemanticDomain::tenType enSemantic);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   mplay_fi_tclOutput* poOutput;
};


class MY_DECL mplay_mediaplayerfi_tclRandomInitVisitor : public mplay_mediaplayerfi_tclVisitorBase {
public:

   mplay_mediaplayerfi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(mplay_fi_tclU8& oU8);
   virtual tVoid vVisitS8(mplay_fi_tclS8& oS8);
   virtual tVoid vVisitU16(mplay_fi_tclU16& oU16);
   virtual tVoid vVisitS16(mplay_fi_tclS16& oS16);
   virtual tVoid vVisitU24(mplay_fi_tclU24& oU24);
   virtual tVoid vVisitS24(mplay_fi_tclS24& oS24);
   virtual tVoid vVisitU32(mplay_fi_tclU32& oU32);
   virtual tVoid vVisitS32(mplay_fi_tclS32& oS32);
   virtual tVoid vVisitU64(mplay_fi_tclU64& oU64);
   virtual tVoid vVisitS64(mplay_fi_tclS64& oS64);
   virtual tVoid vVisitBool(mplay_fi_tclBool& oBool);
   virtual tVoid vVisitString(mplay_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(mplay_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(mplay_fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_e8_EjectOpticalDisc_MethodResult(mplay_fi_tcl_e8_EjectOpticalDisc_MethodResult& o_e8_EjectOpticalDisc_MethodResult);
   virtual tVoid vVisit_e8_SlotStateOpticalDiscType(mplay_fi_tcl_e8_SlotStateOpticalDiscType& o_e8_SlotStateOpticalDiscType);
   virtual tVoid vVisit_e8_EjectParmType(mplay_fi_tcl_e8_EjectParmType& o_e8_EjectParmType);
   virtual tVoid vVisit_e8DeviceState(mplay_fi_tcl_e8DeviceState& o_e8DeviceState);
   virtual tVoid vVisit_e8_DVDCommandStatus(mplay_fi_tcl_e8_DVDCommandStatus& o_e8_DVDCommandStatus);
   virtual tVoid vVisit_e8_MDVDDiscType(mplay_fi_tcl_e8_MDVDDiscType& o_e8_MDVDDiscType);
   virtual tVoid vVisit_e8_MDVDDriveMode(mplay_fi_tcl_e8_MDVDDriveMode& o_e8_MDVDDriveMode);
   virtual tVoid vVisit_e8_MAngle(mplay_fi_tcl_e8_MAngle& o_e8_MAngle);
   virtual tVoid vVisit_e8_MAudioOutputNumber(mplay_fi_tcl_e8_MAudioOutputNumber& o_e8_MAudioOutputNumber);
   virtual tVoid vVisit_e8_MChannelAssignment(mplay_fi_tcl_e8_MChannelAssignment& o_e8_MChannelAssignment);
   virtual tVoid vVisit_e8_MCMSkipValue(mplay_fi_tcl_e8_MCMSkipValue& o_e8_MCMSkipValue);
   virtual tVoid vVisit_e8_MDiscError(mplay_fi_tcl_e8_MDiscError& o_e8_MDiscError);
   virtual tVoid vVisit_e8_MDiscMechanicalInfo(mplay_fi_tcl_e8_MDiscMechanicalInfo& o_e8_MDiscMechanicalInfo);
   virtual tVoid vVisit_e8_MDiscOperation(mplay_fi_tcl_e8_MDiscOperation& o_e8_MDiscOperation);
   virtual tVoid vVisit_e8_MDiscType(mplay_fi_tcl_e8_MDiscType& o_e8_MDiscType);
   virtual tVoid vVisit_e8_MDisplayMode(mplay_fi_tcl_e8_MDisplayMode& o_e8_MDisplayMode);
   virtual tVoid vVisit_e8_MDRCSetting(mplay_fi_tcl_e8_MDRCSetting& o_e8_MDRCSetting);
   virtual tVoid vVisit_e8_MGeneralSelectionType(mplay_fi_tcl_e8_MGeneralSelectionType& o_e8_MGeneralSelectionType);
   virtual tVoid vVisit_e8_MMenuControlData(mplay_fi_tcl_e8_MMenuControlData& o_e8_MMenuControlData);
   virtual tVoid vVisit_e8_MNavigationKey(mplay_fi_tcl_e8_MNavigationKey& o_e8_MNavigationKey);
   virtual tVoid vVisit_e8_MPlayAction(mplay_fi_tcl_e8_MPlayAction& o_e8_MPlayAction);
   virtual tVoid vVisit_e8_MPlayAudioChannelFormat(mplay_fi_tcl_e8_MPlayAudioChannelFormat& o_e8_MPlayAudioChannelFormat);
   virtual tVoid vVisit_e8_MPlayAvailabilityReason(mplay_fi_tcl_e8_MPlayAvailabilityReason& o_e8_MPlayAvailabilityReason);
   virtual tVoid vVisit_e8_MPlaybackDirection(mplay_fi_tcl_e8_MPlaybackDirection& o_e8_MPlaybackDirection);
   virtual tVoid vVisit_e8_MPlaybackSpeed(mplay_fi_tcl_e8_MPlaybackSpeed& o_e8_MPlaybackSpeed);
   virtual tVoid vVisit_e8_MPlayCategoryType(mplay_fi_tcl_e8_MPlayCategoryType& o_e8_MPlayCategoryType);
   virtual tVoid vVisit_e8_MPlayChange(mplay_fi_tcl_e8_MPlayChange& o_e8_MPlayChange);
   virtual tVoid vVisit_e8_MPlayConnectionState(mplay_fi_tcl_e8_MPlayConnectionState& o_e8_MPlayConnectionState);
   virtual tVoid vVisit_e8_MPlayConnectionType(mplay_fi_tcl_e8_MPlayConnectionType& o_e8_MPlayConnectionType);
   virtual tVoid vVisit_e8_MPlayDeleteMediaContentTaskResult(mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult& o_e8_MPlayDeleteMediaContentTaskResult);
   virtual tVoid vVisit_e8_MPlayDeviceControlSupport(mplay_fi_tcl_e8_MPlayDeviceControlSupport& o_e8_MPlayDeviceControlSupport);
   virtual tVoid vVisit_e8_MPlayDeviceIndexedState(mplay_fi_tcl_e8_MPlayDeviceIndexedState& o_e8_MPlayDeviceIndexedState);
   virtual tVoid vVisit_e8_MPlayDeviceRippingState(mplay_fi_tcl_e8_MPlayDeviceRippingState& o_e8_MPlayDeviceRippingState);
   virtual tVoid vVisit_e8_MPlayDeviceStatus(mplay_fi_tcl_e8_MPlayDeviceStatus& o_e8_MPlayDeviceStatus);
   virtual tVoid vVisit_e8_MPlayDeviceType(mplay_fi_tcl_e8_MPlayDeviceType& o_e8_MPlayDeviceType);
   virtual tVoid vVisit_e8_MPlayDisconnectReason(mplay_fi_tcl_e8_MPlayDisconnectReason& o_e8_MPlayDisconnectReason);
   virtual tVoid vVisit_e8_MPlayEditMetaDataTaskResult(mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult& o_e8_MPlayEditMetaDataTaskResult);
   virtual tVoid vVisit_e8_MPlayEncodingQuality(mplay_fi_tcl_e8_MPlayEncodingQuality& o_e8_MPlayEncodingQuality);
   virtual tVoid vVisit_e8_MPlayFileFormat(mplay_fi_tcl_e8_MPlayFileFormat& o_e8_MPlayFileFormat);
   virtual tVoid vVisit_e8_MPlayFileSystemType(mplay_fi_tcl_e8_MPlayFileSystemType& o_e8_MPlayFileSystemType);
   virtual tVoid vVisit_e8_MPlayFileType(mplay_fi_tcl_e8_MPlayFileType& o_e8_MPlayFileType);
   virtual tVoid vVisit_e8_MPlayFileTypeSelection(mplay_fi_tcl_e8_MPlayFileTypeSelection& o_e8_MPlayFileTypeSelection);
   virtual tVoid vVisit_e8_MPlayGNmetadataExtractionResult(mplay_fi_tcl_e8_MPlayGNmetadataExtractionResult& o_e8_MPlayGNmetadataExtractionResult);
   virtual tVoid vVisit_e8_MPlayInternalPlaylistTaskResult(mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult& o_e8_MPlayInternalPlaylistTaskResult);
   virtual tVoid vVisit_e8_MPlayiPodCommunicationError(mplay_fi_tcl_e8_MPlayiPodCommunicationError& o_e8_MPlayiPodCommunicationError);
   virtual tVoid vVisit_e8_MPlayLanguage(mplay_fi_tcl_e8_MPlayLanguage& o_e8_MPlayLanguage);
   virtual tVoid vVisit_e8_MPlayListType(mplay_fi_tcl_e8_MPlayListType& o_e8_MPlayListType);
   virtual tVoid vVisit_e8_MPlayMediaType(mplay_fi_tcl_e8_MPlayMediaType& o_e8_MPlayMediaType);
   virtual tVoid vVisit_e8_MPlayMode(mplay_fi_tcl_e8_MPlayMode& o_e8_MPlayMode);
   virtual tVoid vVisit_e8_MPlayNowPlayingState(mplay_fi_tcl_e8_MPlayNowPlayingState& o_e8_MPlayNowPlayingState);
   virtual tVoid vVisit_e8_MPlayPlayableStatus(mplay_fi_tcl_e8_MPlayPlayableStatus& o_e8_MPlayPlayableStatus);
   virtual tVoid vVisit_e8_MPlayPlaypointFormat(mplay_fi_tcl_e8_MPlayPlaypointFormat& o_e8_MPlayPlaypointFormat);
   virtual tVoid vVisit_e8_MPlayRepeat(mplay_fi_tcl_e8_MPlayRepeat& o_e8_MPlayRepeat);
   virtual tVoid vVisit_e8_MPlayState(mplay_fi_tcl_e8_MPlayState& o_e8_MPlayState);
   virtual tVoid vVisit_e8_MPlayStreamingInfo(mplay_fi_tcl_e8_MPlayStreamingInfo& o_e8_MPlayStreamingInfo);
   virtual tVoid vVisit_e8_MPlayTagTransferStatus(mplay_fi_tcl_e8_MPlayTagTransferStatus& o_e8_MPlayTagTransferStatus);
   virtual tVoid vVisit_e8_MPlayUmountResult(mplay_fi_tcl_e8_MPlayUmountResult& o_e8_MPlayUmountResult);
   virtual tVoid vVisit_e8_MSoundFormat(mplay_fi_tcl_e8_MSoundFormat& o_e8_MSoundFormat);
   virtual tVoid vVisit_e8_MSubtitleSelectionType(mplay_fi_tcl_e8_MSubtitleSelectionType& o_e8_MSubtitleSelectionType);
   virtual tVoid vVisit_e8_MTotalChannel(mplay_fi_tcl_e8_MTotalChannel& o_e8_MTotalChannel);
   virtual tVoid vVisit_e8_MTouchAction(mplay_fi_tcl_e8_MTouchAction& o_e8_MTouchAction);
   virtual tVoid vVisit_e8_MVCDAudioMode(mplay_fi_tcl_e8_MVCDAudioMode& o_e8_MVCDAudioMode);
   virtual tVoid vVisit_e8_QuickSearchResult(mplay_fi_tcl_e8_QuickSearchResult& o_e8_QuickSearchResult);
   virtual tVoid vVisit_e_MPlayDeviceDBViewStatus(mplay_fi_tcl_e_MPlayDeviceDBViewStatus& o_e_MPlayDeviceDBViewStatus);
   virtual tVoid vVisit_MPlayRippingErrors(mplay_fi_tcl_MPlayRippingErrors& o_MPlayRippingErrors);
   virtual tVoid vVisit_MPlaySearchType(mplay_fi_tcl_MPlaySearchType& o_MPlaySearchType);
   virtual tVoid vVisit_VideoScalingType(mplay_fi_tcl_VideoScalingType& o_VideoScalingType);
   virtual tVoid vVisit_IndicesType(mplay_fi_tcl_IndicesType& o_IndicesType);
   virtual tVoid vVisit_e_MPlayHIDCommand(mplay_fi_tcl_e_MPlayHIDCommand& o_e_MPlayHIDCommand);
   virtual tVoid vVisit_e_MPlayKeyEvent(mplay_fi_tcl_e_MPlayKeyEvent& o_e_MPlayKeyEvent);
	tU32 u32ListSize;
};

#endif
