/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MPLAY_DEVICEMANAGERFITYPES_HEADER
#define MPLAY_DEVICEMANAGERFITYPES_HEADER


class mplay_devicemanagerfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for mplay_devicemanager_fi message types

fi_tclMessageBase* mplay_devicemanagerfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class mplay_devicemanagerfi_tclMsgBaseMessage : public mplay_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   mplay_devicemanagerfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodStart : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodStart& operator=(const mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodStart& coRef);
   mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodStart(const mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Mount;
   mplay_fi_tclString BlockDevice;
   virtual ~mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodResult : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodResult& operator=(const mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodResult& coRef);
   mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodResult(const mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Success;
   virtual ~mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodStart : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodStart& operator=(const mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodStart& coRef);
   mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodStart(const mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_EjectParmType eCmdParam;
   virtual ~mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodResult : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodResult& operator=(const mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodResult& coRef);
   mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodResult(const mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_EjectOpticalDisc_MethodResult ServiceStatus;
   virtual ~mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodStart : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodStart& operator=(const mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodStart& coRef);
   mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodStart(const mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 VendorID;
   tU32 ProductID;
   tU32 USBPortNo;
   mplay_fi_tcl_e8_DVM_DeviceSpeedUsb SpeedInfo;
   tBool Add;
   virtual ~mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodResult : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodResult& operator=(const mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodResult& coRef);
   mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodResult(const mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Success;
   virtual ~mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodStart : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodStart& operator=(const mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodStart& coRef);
   mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodStart(const mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString ConfigurationParam;
   tU16 Value;
   mplay_fi_tcl_e8_SettingsMode SettingsMode;
   virtual ~mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodResult : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodResult& operator=(const mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodResult& coRef);
   mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodResult(const mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Success;
   virtual ~mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodStart : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodStart& operator=(const mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodStart& coRef);
   mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodStart(const mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString ConfigurationParam;
   virtual ~mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodResult : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodResult& operator=(const mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodResult& coRef);
   mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodResult(const mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 Value;
   virtual ~mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodStart : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodStart& operator=(const mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodStart& coRef);
   mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodStart(const mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 VendorID;
   tU32 ProductID;
   tU32 USBPortNo;
   tBool Add;
   virtual ~mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodResult : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodResult& operator=(const mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodResult& coRef);
   mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodResult(const mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Success;
   virtual ~mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart& operator=(const mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart& coRef);
   mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart(const mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString DeviceSerialNo;
   virtual ~mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult& operator=(const mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult& coRef);
   mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult(const mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_DevManager_DeviceProperty DeviceProperty;
   virtual ~mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodStart : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodStart();

   virtual ~mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodStart();

   inline tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult& operator=(const mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult& coRef);
   mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult(const mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_DevManager_DevInfoStr DevInfoArr;
   virtual ~mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionUpReg : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionUpReg();

   virtual ~mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionUpReg();

   inline tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionRelUpReg : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionRelUpReg();

   virtual ~mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionRelUpReg();

   inline tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet& operator=(const mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet& coRef);
   mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet(const mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mplay_fi_tcl_DevManager_DeviceProperty, std::allocator<mplay_fi_tcl_DevManager_DeviceProperty> > Devicetype;
   virtual ~mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus& operator=(const mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus& coRef);
   mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus(const mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mplay_fi_tcl_DevManager_DeviceProperty, std::allocator<mplay_fi_tcl_DevManager_DeviceProperty> > Devicetype;
   tBool Undervoltage;
   std::vector<mplay_fi_tcl_DevManager_PortStates, std::allocator<mplay_fi_tcl_DevManager_PortStates> > USBPortList;
   virtual ~mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardUpReg : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardUpReg();

   virtual ~mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardUpReg();

   inline tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardRelUpReg : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardRelUpReg();

   virtual ~mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardRelUpReg();

   inline tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardGet : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardGet();

   virtual ~mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardGet();

   inline tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardStatus : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardStatus& operator=(const mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardStatus& coRef);
   mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardStatus(const mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mplay_fi_tcl_DevManager_SDCardInfo, std::allocator<mplay_fi_tcl_DevManager_SDCardInfo> > SDCardList;
   virtual ~mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerOverTempCDUpReg : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerOverTempCDUpReg();

   virtual ~mplay_devicemanagerfi_tclMsgDevManagerOverTempCDUpReg();

   inline tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerOverTempCDUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerOverTempCDRelUpReg : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerOverTempCDRelUpReg();

   virtual ~mplay_devicemanagerfi_tclMsgDevManagerOverTempCDRelUpReg();

   inline tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerOverTempCDRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerOverTempCDSet : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerOverTempCDSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_devicemanagerfi_tclMsgDevManagerOverTempCDSet& operator=(const mplay_devicemanagerfi_tclMsgDevManagerOverTempCDSet& coRef);
   mplay_devicemanagerfi_tclMsgDevManagerOverTempCDSet(const mplay_devicemanagerfi_tclMsgDevManagerOverTempCDSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool OverTemperature;
   virtual ~mplay_devicemanagerfi_tclMsgDevManagerOverTempCDSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerOverTempCDSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerOverTempCDGet : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerOverTempCDGet();

   virtual ~mplay_devicemanagerfi_tclMsgDevManagerOverTempCDGet();

   inline tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerOverTempCDGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerOverTempCDStatus : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerOverTempCDStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_devicemanagerfi_tclMsgDevManagerOverTempCDStatus& operator=(const mplay_devicemanagerfi_tclMsgDevManagerOverTempCDStatus& coRef);
   mplay_devicemanagerfi_tclMsgDevManagerOverTempCDStatus(const mplay_devicemanagerfi_tclMsgDevManagerOverTempCDStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool OverTemperature;
   virtual ~mplay_devicemanagerfi_tclMsgDevManagerOverTempCDStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerOverTempCDStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveUpReg : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveUpReg();

   virtual ~mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveUpReg();

   inline tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveRelUpReg : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveRelUpReg();

   virtual ~mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveRelUpReg();

   inline tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveSet : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveSet& operator=(const mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveSet& coRef);
   mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveSet(const mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool BTAConnectionStatus;
   tU32 TimoutBeforeSendingITC;
   virtual ~mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveGet : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveGet();

   virtual ~mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveGet();

   inline tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveStatus : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveStatus& operator=(const mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveStatus& coRef);
   mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveStatus(const mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool BTAConnectionStatus;
   tU32 TimoutBeforeSendingITC;
   virtual ~mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscUpReg : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscUpReg();

   virtual ~mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscUpReg();

   inline tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscRelUpReg : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscRelUpReg();

   virtual ~mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscRelUpReg();

   inline tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscGet : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscGet();

   virtual ~mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscGet();

   inline tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscStatus : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscStatus& operator=(const mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscStatus& coRef);
   mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscStatus(const mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mplay_fi_tcl_e8_SlotStateOpticalDiscType, std::allocator<mplay_fi_tcl_e8_SlotStateOpticalDiscType> > OpticalDiscSlotState;
   virtual ~mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoUpReg : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoUpReg();

   virtual ~mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoUpReg();

   inline tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoRelUpReg : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoRelUpReg();

   virtual ~mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoRelUpReg();

   inline tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoGet : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoGet();

   virtual ~mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoGet();

   inline tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoStatus : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoStatus& operator=(const mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoStatus& coRef);
   mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoStatus(const mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_CDInfo CDInfo;
   virtual ~mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoSet : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoSet& operator=(const mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoSet& coRef);
   mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoSet(const mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_MDVDDiscType e8DVDDiscType;
   mplay_fi_tcl_e8_MDVDDriveMode e8DVDDriveMode;
   virtual ~mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoRelUpReg : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoRelUpReg();

   virtual ~mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoRelUpReg();

   inline tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoStatus : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoStatus();

   virtual ~mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoStatus();

   inline tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoStatus& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoUpReg : public mplay_devicemanagerfi_tclMsgBaseMessage
{
public:

   mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoUpReg();

   virtual ~mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoUpReg();

   inline tBool operator==(const mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};


#endif
