/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_DEVICEMANAGERFI_TYPES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_DEVICEMANAGERFI_FUNCTIONIDS
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_DEVICEMANAGERFI_SERVICEINFO
#include "mplay_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for mplay_devicemanager_fi message types

fi_tclMessageBase* mplay_devicemanagerfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERMOUNTCDROMINTERNALMETHODSTART:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodStart;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERMOUNTCDROMINTERNALMETHODRESULT:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodResult;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGEREJECTOPTICALDISCMETHODSTART:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodStart;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGEREJECTOPTICALDISCMETHODRESULT:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodResult;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERADDTELEMATICSBOXMETHODSTART:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodStart;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERADDTELEMATICSBOXMETHODRESULT:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodResult;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERSETCONFIGURATIONVALUEMETHODSTART:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodStart;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERSETCONFIGURATIONVALUEMETHODRESULT:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodResult;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETCONFIGURATIONVALUEMETHODSTART:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodStart;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETCONFIGURATIONVALUEMETHODRESULT:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodResult;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERADDEXTERNALHUBMETHODSTART:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodStart;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERADDEXTERNALHUBMETHODRESULT:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodResult;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETDEVPROPERTIESMETHODSTART:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETDEVPROPERTIESMETHODRESULT:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETALLCONNECTEDDEVICESMETHODSTART:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodStart;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETALLCONNECTEDDEVICESMETHODRESULT:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCONNECTIONUPREG:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionUpReg;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCONNECTIONRELUPREG:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionRelUpReg;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCONNECTIONGET:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCONNECTIONSTATUS:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSDCARDUPREG:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardUpReg;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSDCARDRELUPREG:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardRelUpReg;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSDCARDGET:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardGet;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSDCARDSTATUS:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardStatus;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGEROVERTEMPCDUPREG:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerOverTempCDUpReg;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGEROVERTEMPCDRELUPREG:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerOverTempCDRelUpReg;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGEROVERTEMPCDSET:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerOverTempCDSet;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGEROVERTEMPCDGET:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerOverTempCDGet;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGEROVERTEMPCDSTATUS:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerOverTempCDStatus;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERTELEMATICSBOXALIVEUPREG:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveUpReg;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERTELEMATICSBOXALIVERELUPREG:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveRelUpReg;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERTELEMATICSBOXALIVESET:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveSet;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERTELEMATICSBOXALIVEGET:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveGet;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERTELEMATICSBOXALIVESTATUS:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveStatus;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSLOTSTATEOPTICALDISCUPREG:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscUpReg;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSLOTSTATEOPTICALDISCRELUPREG:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscRelUpReg;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSLOTSTATEOPTICALDISCGET:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscGet;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSLOTSTATEOPTICALDISCSTATUS:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscStatus;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCDINFOUPREG:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoUpReg;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCDINFORELUPREG:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoRelUpReg;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCDINFOGET:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoGet;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCDINFOSTATUS:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoStatus;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERDVDDRIVEINFOSET:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoSet;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERDVDDRIVEINFORELUPREG:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoRelUpReg;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERDVDDRIVEINFOSTATUS:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoStatus;

      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERDVDDRIVEINFOUPREG:
         return OSAL_NEW mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoUpReg;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all mplay_devicemanagerfifi messages

// common functions

tU16 mplay_devicemanagerfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MPLAY_DEVICEMANAGERFI_C_U16_SERVICE_ID;
}

tU16 mplay_devicemanagerfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 mplay_devicemanagerfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& mplay_devicemanagerfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& mplay_devicemanagerfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 mplay_devicemanagerfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& mplay_devicemanagerfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& mplay_devicemanagerfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodStart::mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodStart(const mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodStart& coRef)
   : mplay_devicemanagerfi_tclMsgBaseMessage(coRef)
{
   Mount = coRef.Mount;
   BlockDevice = coRef.BlockDevice;
}
mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodStart& mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodStart::operator=(const mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Mount = coRef.Mount;
   BlockDevice = coRef.BlockDevice;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodStart::vDestroy()
{
   BlockDevice.vDestroy();
}

mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodStart::mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodStart()
:Mount(0)
,BlockDevice()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERMOUNTCDROMINTERNALMETHODSTART;
}


mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodStart::~mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+BlockDevice.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Mount);
   (tVoid) (oIn >> BlockDevice);
   return oIn;
}

fi_tclOutContext& mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Mount);
   (tVoid) (oOut << BlockDevice);
   return oOut;
}

tBool mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodStart::operator==(const mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Mount == roRef.Mount);
   bResult = bResult && (BlockDevice == roRef.BlockDevice);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodResult::mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodResult(const mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodResult& coRef)
   : mplay_devicemanagerfi_tclMsgBaseMessage(coRef)
{
   Success = coRef.Success;
}
mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodResult& mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodResult::operator=(const mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Success = coRef.Success;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodResult::mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodResult()
:Success(0)
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERMOUNTCDROMINTERNALMETHODRESULT;
}


mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodResult::~mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodResult()
{}

tU32 mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Success);
   return oIn;
}

fi_tclOutContext& mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Success);
   return oOut;
}

tBool mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodResult::operator==(const mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Success == roRef.Success);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodStart::mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodStart(const mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodStart& coRef)
   : mplay_devicemanagerfi_tclMsgBaseMessage(coRef)
{
   eCmdParam = coRef.eCmdParam;
}
mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodStart& mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodStart::operator=(const mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodStart& coRef)
{
   if (this == &coRef) return *this;
   eCmdParam = coRef.eCmdParam;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodStart::mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodStart()
:eCmdParam()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGEREJECTOPTICALDISCMETHODSTART;
}


mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodStart::~mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodStart()
{}

tU32 mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eCmdParam);
   return oIn;
}

fi_tclOutContext& mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eCmdParam);
   return oOut;
}

tBool mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodStart::operator==(const mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eCmdParam == roRef.eCmdParam);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodResult::mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodResult(const mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodResult& coRef)
   : mplay_devicemanagerfi_tclMsgBaseMessage(coRef)
{
   ServiceStatus = coRef.ServiceStatus;
}
mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodResult& mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodResult::operator=(const mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ServiceStatus = coRef.ServiceStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodResult::mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodResult()
:ServiceStatus()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGEREJECTOPTICALDISCMETHODRESULT;
}


mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodResult::~mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodResult()
{}

tU32 mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceStatus);
   return oIn;
}

fi_tclOutContext& mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceStatus);
   return oOut;
}

tBool mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodResult::operator==(const mplay_devicemanagerfi_tclMsgDevManagerEjectOpticalDiscMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceStatus == roRef.ServiceStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodStart::mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodStart(const mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodStart& coRef)
   : mplay_devicemanagerfi_tclMsgBaseMessage(coRef)
{
   VendorID = coRef.VendorID;
   ProductID = coRef.ProductID;
   USBPortNo = coRef.USBPortNo;
   SpeedInfo = coRef.SpeedInfo;
   Add = coRef.Add;
}
mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodStart& mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodStart::operator=(const mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodStart& coRef)
{
   if (this == &coRef) return *this;
   VendorID = coRef.VendorID;
   ProductID = coRef.ProductID;
   USBPortNo = coRef.USBPortNo;
   SpeedInfo = coRef.SpeedInfo;
   Add = coRef.Add;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodStart::mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodStart()
:VendorID(0)
,ProductID(0)
,USBPortNo(0)
,SpeedInfo()
,Add(0)
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERADDTELEMATICSBOXMETHODSTART;
}


mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodStart::~mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodStart()
{}

tU32 mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 14;
}

fi_tclInContext& mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VendorID);
   (tVoid) (oIn >> ProductID);
   (tVoid) (oIn >> USBPortNo);
   (tVoid) (oIn >> SpeedInfo);
   (tVoid) (oIn >> Add);
   return oIn;
}

fi_tclOutContext& mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VendorID);
   (tVoid) (oOut << ProductID);
   (tVoid) (oOut << USBPortNo);
   (tVoid) (oOut << SpeedInfo);
   (tVoid) (oOut << Add);
   return oOut;
}

tBool mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodStart::operator==(const mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VendorID == roRef.VendorID);
   bResult = bResult && (ProductID == roRef.ProductID);
   bResult = bResult && (USBPortNo == roRef.USBPortNo);
   bResult = bResult && (SpeedInfo == roRef.SpeedInfo);
   bResult = bResult && (Add == roRef.Add);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodResult::mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodResult(const mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodResult& coRef)
   : mplay_devicemanagerfi_tclMsgBaseMessage(coRef)
{
   Success = coRef.Success;
}
mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodResult& mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodResult::operator=(const mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Success = coRef.Success;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodResult::mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodResult()
:Success(0)
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERADDTELEMATICSBOXMETHODRESULT;
}


mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodResult::~mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodResult()
{}

tU32 mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Success);
   return oIn;
}

fi_tclOutContext& mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Success);
   return oOut;
}

tBool mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodResult::operator==(const mplay_devicemanagerfi_tclMsgDevManagerAddTelematicsBoxMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Success == roRef.Success);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodStart::mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodStart(const mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodStart& coRef)
   : mplay_devicemanagerfi_tclMsgBaseMessage(coRef)
{
   ConfigurationParam = coRef.ConfigurationParam;
   Value = coRef.Value;
   SettingsMode = coRef.SettingsMode;
}
mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodStart& mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodStart::operator=(const mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ConfigurationParam = coRef.ConfigurationParam;
   Value = coRef.Value;
   SettingsMode = coRef.SettingsMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodStart::vDestroy()
{
   ConfigurationParam.vDestroy();
}

mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodStart::mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodStart()
:ConfigurationParam()
,Value(0)
,SettingsMode()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERSETCONFIGURATIONVALUEMETHODSTART;
}


mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodStart::~mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+ConfigurationParam.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ConfigurationParam);
   (tVoid) (oIn >> Value);
   (tVoid) (oIn >> SettingsMode);
   return oIn;
}

fi_tclOutContext& mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ConfigurationParam);
   (tVoid) (oOut << Value);
   (tVoid) (oOut << SettingsMode);
   return oOut;
}

tBool mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodStart::operator==(const mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ConfigurationParam == roRef.ConfigurationParam);
   bResult = bResult && (Value == roRef.Value);
   bResult = bResult && (SettingsMode == roRef.SettingsMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodResult::mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodResult(const mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodResult& coRef)
   : mplay_devicemanagerfi_tclMsgBaseMessage(coRef)
{
   Success = coRef.Success;
}
mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodResult& mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodResult::operator=(const mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Success = coRef.Success;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodResult::mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodResult()
:Success(0)
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERSETCONFIGURATIONVALUEMETHODRESULT;
}


mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodResult::~mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodResult()
{}

tU32 mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Success);
   return oIn;
}

fi_tclOutContext& mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Success);
   return oOut;
}

tBool mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodResult::operator==(const mplay_devicemanagerfi_tclMsgDevManagerSetConfigurationValueMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Success == roRef.Success);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodStart::mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodStart(const mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodStart& coRef)
   : mplay_devicemanagerfi_tclMsgBaseMessage(coRef)
{
   ConfigurationParam = coRef.ConfigurationParam;
}
mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodStart& mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodStart::operator=(const mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ConfigurationParam = coRef.ConfigurationParam;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodStart::vDestroy()
{
   ConfigurationParam.vDestroy();
}

mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodStart::mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodStart()
:ConfigurationParam()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETCONFIGURATIONVALUEMETHODSTART;
}


mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodStart::~mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+ConfigurationParam.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ConfigurationParam);
   return oIn;
}

fi_tclOutContext& mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ConfigurationParam);
   return oOut;
}

tBool mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodStart::operator==(const mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ConfigurationParam == roRef.ConfigurationParam);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodResult::mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodResult(const mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodResult& coRef)
   : mplay_devicemanagerfi_tclMsgBaseMessage(coRef)
{
   Value = coRef.Value;
}
mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodResult& mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodResult::operator=(const mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Value = coRef.Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodResult::mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodResult()
:Value(0)
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETCONFIGURATIONVALUEMETHODRESULT;
}


mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodResult::~mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodResult()
{}

tU32 mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Value);
   return oIn;
}

fi_tclOutContext& mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Value);
   return oOut;
}

tBool mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodResult::operator==(const mplay_devicemanagerfi_tclMsgDevManagerGetConfigurationValueMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Value == roRef.Value);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodStart::mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodStart(const mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodStart& coRef)
   : mplay_devicemanagerfi_tclMsgBaseMessage(coRef)
{
   VendorID = coRef.VendorID;
   ProductID = coRef.ProductID;
   USBPortNo = coRef.USBPortNo;
   Add = coRef.Add;
}
mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodStart& mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodStart::operator=(const mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodStart& coRef)
{
   if (this == &coRef) return *this;
   VendorID = coRef.VendorID;
   ProductID = coRef.ProductID;
   USBPortNo = coRef.USBPortNo;
   Add = coRef.Add;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodStart::mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodStart()
:VendorID(0)
,ProductID(0)
,USBPortNo(0)
,Add(0)
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERADDEXTERNALHUBMETHODSTART;
}


mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodStart::~mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodStart()
{}

tU32 mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VendorID);
   (tVoid) (oIn >> ProductID);
   (tVoid) (oIn >> USBPortNo);
   (tVoid) (oIn >> Add);
   return oIn;
}

fi_tclOutContext& mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VendorID);
   (tVoid) (oOut << ProductID);
   (tVoid) (oOut << USBPortNo);
   (tVoid) (oOut << Add);
   return oOut;
}

tBool mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodStart::operator==(const mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VendorID == roRef.VendorID);
   bResult = bResult && (ProductID == roRef.ProductID);
   bResult = bResult && (USBPortNo == roRef.USBPortNo);
   bResult = bResult && (Add == roRef.Add);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodResult::mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodResult(const mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodResult& coRef)
   : mplay_devicemanagerfi_tclMsgBaseMessage(coRef)
{
   Success = coRef.Success;
}
mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodResult& mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodResult::operator=(const mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Success = coRef.Success;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodResult::mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodResult()
:Success(0)
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERADDEXTERNALHUBMETHODRESULT;
}


mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodResult::~mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodResult()
{}

tU32 mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Success);
   return oIn;
}

fi_tclOutContext& mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Success);
   return oOut;
}

tBool mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodResult::operator==(const mplay_devicemanagerfi_tclMsgDevManagerAddExternalHubMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Success == roRef.Success);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart::mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart(const mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart& coRef)
   : mplay_devicemanagerfi_tclMsgBaseMessage(coRef)
{
   DeviceSerialNo = coRef.DeviceSerialNo;
}
mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart& mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart::operator=(const mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceSerialNo = coRef.DeviceSerialNo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart::vDestroy()
{
   DeviceSerialNo.vDestroy();
}

mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart::mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart()
:DeviceSerialNo()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETDEVPROPERTIESMETHODSTART;
}


mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart::~mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+DeviceSerialNo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceSerialNo);
   return oIn;
}

fi_tclOutContext& mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceSerialNo);
   return oOut;
}

tBool mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart::operator==(const mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceSerialNo == roRef.DeviceSerialNo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult::mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult(const mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult& coRef)
   : mplay_devicemanagerfi_tclMsgBaseMessage(coRef)
{
   DeviceProperty = coRef.DeviceProperty;
}
mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult& mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult::operator=(const mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DeviceProperty = coRef.DeviceProperty;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult::vDestroy()
{
   DeviceProperty.vDestroy(); 
}

mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult::mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult()
:DeviceProperty()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETDEVPROPERTIESMETHODRESULT;
}


mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult::~mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+DeviceProperty.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceProperty);
   return oIn;
}

fi_tclOutContext& mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceProperty);
   return oOut;
}

tBool mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult::operator==(const mplay_devicemanagerfi_tclMsgDevManagerGetDevPropertiesMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceProperty == roRef.DeviceProperty);
   return bResult;
}

//=============================================================================

mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodStart::mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodStart()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETALLCONNECTEDDEVICESMETHODSTART;
}


mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodStart::~mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult::mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult(const mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult& coRef)
   : mplay_devicemanagerfi_tclMsgBaseMessage(coRef)
{
   DevInfoArr = coRef.DevInfoArr;
}
mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult& mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult::operator=(const mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DevInfoArr = coRef.DevInfoArr;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult::vDestroy()
{
   DevInfoArr.vDestroy(); 
}

mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult::mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult()
:DevInfoArr()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETALLCONNECTEDDEVICESMETHODRESULT;
}


mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult::~mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+DevInfoArr.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DevInfoArr);
   return oIn;
}

fi_tclOutContext& mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DevInfoArr);
   return oOut;
}

tBool mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult::operator==(const mplay_devicemanagerfi_tclMsgDevManagerGetAllConnectedDevicesMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DevInfoArr == roRef.DevInfoArr);
   return bResult;
}

//=============================================================================

mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionUpReg::mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionUpReg()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionUpReg::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCONNECTIONUPREG;
}


mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionUpReg::~mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionUpReg()
{}

//=============================================================================

mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionRelUpReg::mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionRelUpReg()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCONNECTIONRELUPREG;
}


mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionRelUpReg::~mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet::mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet(const mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet& coRef)
   : mplay_devicemanagerfi_tclMsgBaseMessage(coRef)
{
   Devicetype = coRef.Devicetype;
}
mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet& mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet::operator=(const mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet& coRef)
{
   if (this == &coRef) return *this;
   Devicetype = coRef.Devicetype;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Devicetype.size(); ++u32Idx)
         Devicetype[u32Idx].vDestroy();
   Devicetype.clear();
   }
}

mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet::mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet()

 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCONNECTIONGET;
}


mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet::~mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Devicetype.size(); ++u32ListIdx)
      u32DynamicSize += Devicetype[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Devicetype.size(); ++u32Idx)
      {
         Devicetype[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Devicetype.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Devicetype[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Devicetype.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Devicetype.size(); ++u32Idx)
         (tVoid) (oOut << Devicetype[u32Idx]);
   }
   return oOut;
}

tBool mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet::operator==(const mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionGet& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Devicetype.size() == roRef.Devicetype.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Devicetype.size()); ++u32Idx)
            bResult = bResult && (Devicetype[u32Idx] == roRef.Devicetype[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus::mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus(const mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus& coRef)
   : mplay_devicemanagerfi_tclMsgBaseMessage(coRef)
{
   Devicetype = coRef.Devicetype;
   Undervoltage = coRef.Undervoltage;
   USBPortList = coRef.USBPortList;
}
mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus& mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus::operator=(const mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus& coRef)
{
   if (this == &coRef) return *this;
   Devicetype = coRef.Devicetype;
   Undervoltage = coRef.Undervoltage;
   USBPortList = coRef.USBPortList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Devicetype.size(); ++u32Idx)
         Devicetype[u32Idx].vDestroy();
   Devicetype.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < USBPortList.size(); ++u32Idx)
         USBPortList[u32Idx].vDestroy();
   USBPortList.clear();
   }
}

mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus::mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus()

:Undervoltage(0)

 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCONNECTIONSTATUS;
}


mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus::~mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Devicetype.size(); ++u32ListIdx)
      u32DynamicSize += Devicetype[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+9+ static_cast<tU32>(USBPortList.size()*8);
}

fi_tclInContext& mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Devicetype.size(); ++u32Idx)
      {
         Devicetype[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Devicetype.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Devicetype[u32Idx]);
      }
   }
   (tVoid) (oIn >> Undervoltage);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < USBPortList.size(); ++u32Idx)
      {
         USBPortList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      USBPortList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> USBPortList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Devicetype.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Devicetype.size(); ++u32Idx)
         (tVoid) (oOut << Devicetype[u32Idx]);
   }
   (tVoid) (oOut << Undervoltage);
   (tVoid) (oOut << (tU32)USBPortList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < USBPortList.size(); ++u32Idx)
         (tVoid) (oOut << USBPortList[u32Idx]);
   }
   return oOut;
}

tBool mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus::operator==(const mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Devicetype.size() == roRef.Devicetype.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Devicetype.size()); ++u32Idx)
            bResult = bResult && (Devicetype[u32Idx] == roRef.Devicetype[u32Idx]);
      }
   bResult = bResult && (Undervoltage == roRef.Undervoltage);
      bResult = bResult && (USBPortList.size() == roRef.USBPortList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < USBPortList.size()); ++u32Idx)
            bResult = bResult && (USBPortList[u32Idx] == roRef.USBPortList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardUpReg::mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardUpReg()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardUpReg::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSDCARDUPREG;
}


mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardUpReg::~mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardUpReg()
{}

//=============================================================================

mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardRelUpReg::mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardRelUpReg()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSDCARDRELUPREG;
}


mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardRelUpReg::~mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardRelUpReg()
{}

//=============================================================================

mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardGet::mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardGet()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardGet::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSDCARDGET;
}


mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardGet::~mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardStatus::mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardStatus(const mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardStatus& coRef)
   : mplay_devicemanagerfi_tclMsgBaseMessage(coRef)
{
   SDCardList = coRef.SDCardList;
}
mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardStatus& mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardStatus::operator=(const mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardStatus& coRef)
{
   if (this == &coRef) return *this;
   SDCardList = coRef.SDCardList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SDCardList.size(); ++u32Idx)
         SDCardList[u32Idx].vDestroy();
   SDCardList.clear();
   }
}

mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardStatus::mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardStatus()

 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardStatus::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSDCARDSTATUS;
}


mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardStatus::~mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SDCardList.size(); ++u32ListIdx)
      u32DynamicSize += SDCardList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SDCardList.size(); ++u32Idx)
      {
         SDCardList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SDCardList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SDCardList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)SDCardList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SDCardList.size(); ++u32Idx)
         (tVoid) (oOut << SDCardList[u32Idx]);
   }
   return oOut;
}

tBool mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardStatus::operator==(const mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (SDCardList.size() == roRef.SDCardList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SDCardList.size()); ++u32Idx)
            bResult = bResult && (SDCardList[u32Idx] == roRef.SDCardList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

mplay_devicemanagerfi_tclMsgDevManagerOverTempCDUpReg::mplay_devicemanagerfi_tclMsgDevManagerOverTempCDUpReg()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerOverTempCDUpReg::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGEROVERTEMPCDUPREG;
}


mplay_devicemanagerfi_tclMsgDevManagerOverTempCDUpReg::~mplay_devicemanagerfi_tclMsgDevManagerOverTempCDUpReg()
{}

//=============================================================================

mplay_devicemanagerfi_tclMsgDevManagerOverTempCDRelUpReg::mplay_devicemanagerfi_tclMsgDevManagerOverTempCDRelUpReg()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerOverTempCDRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGEROVERTEMPCDRELUPREG;
}


mplay_devicemanagerfi_tclMsgDevManagerOverTempCDRelUpReg::~mplay_devicemanagerfi_tclMsgDevManagerOverTempCDRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_devicemanagerfi_tclMsgDevManagerOverTempCDSet::mplay_devicemanagerfi_tclMsgDevManagerOverTempCDSet(const mplay_devicemanagerfi_tclMsgDevManagerOverTempCDSet& coRef)
   : mplay_devicemanagerfi_tclMsgBaseMessage(coRef)
{
   OverTemperature = coRef.OverTemperature;
}
mplay_devicemanagerfi_tclMsgDevManagerOverTempCDSet& mplay_devicemanagerfi_tclMsgDevManagerOverTempCDSet::operator=(const mplay_devicemanagerfi_tclMsgDevManagerOverTempCDSet& coRef)
{
   if (this == &coRef) return *this;
   OverTemperature = coRef.OverTemperature;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_devicemanagerfi_tclMsgDevManagerOverTempCDSet::mplay_devicemanagerfi_tclMsgDevManagerOverTempCDSet()
:OverTemperature(0)
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerOverTempCDSet::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGEROVERTEMPCDSET;
}


mplay_devicemanagerfi_tclMsgDevManagerOverTempCDSet::~mplay_devicemanagerfi_tclMsgDevManagerOverTempCDSet()
{}

tU32 mplay_devicemanagerfi_tclMsgDevManagerOverTempCDSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_devicemanagerfi_tclMsgDevManagerOverTempCDSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> OverTemperature);
   return oIn;
}

fi_tclOutContext& mplay_devicemanagerfi_tclMsgDevManagerOverTempCDSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << OverTemperature);
   return oOut;
}

tBool mplay_devicemanagerfi_tclMsgDevManagerOverTempCDSet::operator==(const mplay_devicemanagerfi_tclMsgDevManagerOverTempCDSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (OverTemperature == roRef.OverTemperature);
   return bResult;
}

//=============================================================================

mplay_devicemanagerfi_tclMsgDevManagerOverTempCDGet::mplay_devicemanagerfi_tclMsgDevManagerOverTempCDGet()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerOverTempCDGet::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGEROVERTEMPCDGET;
}


mplay_devicemanagerfi_tclMsgDevManagerOverTempCDGet::~mplay_devicemanagerfi_tclMsgDevManagerOverTempCDGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_devicemanagerfi_tclMsgDevManagerOverTempCDStatus::mplay_devicemanagerfi_tclMsgDevManagerOverTempCDStatus(const mplay_devicemanagerfi_tclMsgDevManagerOverTempCDStatus& coRef)
   : mplay_devicemanagerfi_tclMsgBaseMessage(coRef)
{
   OverTemperature = coRef.OverTemperature;
}
mplay_devicemanagerfi_tclMsgDevManagerOverTempCDStatus& mplay_devicemanagerfi_tclMsgDevManagerOverTempCDStatus::operator=(const mplay_devicemanagerfi_tclMsgDevManagerOverTempCDStatus& coRef)
{
   if (this == &coRef) return *this;
   OverTemperature = coRef.OverTemperature;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_devicemanagerfi_tclMsgDevManagerOverTempCDStatus::mplay_devicemanagerfi_tclMsgDevManagerOverTempCDStatus()
:OverTemperature(0)
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerOverTempCDStatus::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGEROVERTEMPCDSTATUS;
}


mplay_devicemanagerfi_tclMsgDevManagerOverTempCDStatus::~mplay_devicemanagerfi_tclMsgDevManagerOverTempCDStatus()
{}

tU32 mplay_devicemanagerfi_tclMsgDevManagerOverTempCDStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_devicemanagerfi_tclMsgDevManagerOverTempCDStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> OverTemperature);
   return oIn;
}

fi_tclOutContext& mplay_devicemanagerfi_tclMsgDevManagerOverTempCDStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << OverTemperature);
   return oOut;
}

tBool mplay_devicemanagerfi_tclMsgDevManagerOverTempCDStatus::operator==(const mplay_devicemanagerfi_tclMsgDevManagerOverTempCDStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (OverTemperature == roRef.OverTemperature);
   return bResult;
}

//=============================================================================

mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveUpReg::mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveUpReg()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveUpReg::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERTELEMATICSBOXALIVEUPREG;
}


mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveUpReg::~mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveUpReg()
{}

//=============================================================================

mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveRelUpReg::mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveRelUpReg()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERTELEMATICSBOXALIVERELUPREG;
}


mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveRelUpReg::~mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveSet::mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveSet(const mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveSet& coRef)
   : mplay_devicemanagerfi_tclMsgBaseMessage(coRef)
{
   BTAConnectionStatus = coRef.BTAConnectionStatus;
   TimoutBeforeSendingITC = coRef.TimoutBeforeSendingITC;
}
mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveSet& mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveSet::operator=(const mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveSet& coRef)
{
   if (this == &coRef) return *this;
   BTAConnectionStatus = coRef.BTAConnectionStatus;
   TimoutBeforeSendingITC = coRef.TimoutBeforeSendingITC;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveSet::mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveSet()
:BTAConnectionStatus(0)
,TimoutBeforeSendingITC(0)
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveSet::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERTELEMATICSBOXALIVESET;
}


mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveSet::~mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveSet()
{}

tU32 mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BTAConnectionStatus);
   (tVoid) (oIn >> TimoutBeforeSendingITC);
   return oIn;
}

fi_tclOutContext& mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BTAConnectionStatus);
   (tVoid) (oOut << TimoutBeforeSendingITC);
   return oOut;
}

tBool mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveSet::operator==(const mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BTAConnectionStatus == roRef.BTAConnectionStatus);
   bResult = bResult && (TimoutBeforeSendingITC == roRef.TimoutBeforeSendingITC);
   return bResult;
}

//=============================================================================

mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveGet::mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveGet()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveGet::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERTELEMATICSBOXALIVEGET;
}


mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveGet::~mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveStatus::mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveStatus(const mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveStatus& coRef)
   : mplay_devicemanagerfi_tclMsgBaseMessage(coRef)
{
   BTAConnectionStatus = coRef.BTAConnectionStatus;
   TimoutBeforeSendingITC = coRef.TimoutBeforeSendingITC;
}
mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveStatus& mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveStatus::operator=(const mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveStatus& coRef)
{
   if (this == &coRef) return *this;
   BTAConnectionStatus = coRef.BTAConnectionStatus;
   TimoutBeforeSendingITC = coRef.TimoutBeforeSendingITC;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveStatus::mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveStatus()
:BTAConnectionStatus(0)
,TimoutBeforeSendingITC(0)
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveStatus::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERTELEMATICSBOXALIVESTATUS;
}


mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveStatus::~mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveStatus()
{}

tU32 mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BTAConnectionStatus);
   (tVoid) (oIn >> TimoutBeforeSendingITC);
   return oIn;
}

fi_tclOutContext& mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BTAConnectionStatus);
   (tVoid) (oOut << TimoutBeforeSendingITC);
   return oOut;
}

tBool mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveStatus::operator==(const mplay_devicemanagerfi_tclMsgDevManagerTelematicsBoxAliveStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BTAConnectionStatus == roRef.BTAConnectionStatus);
   bResult = bResult && (TimoutBeforeSendingITC == roRef.TimoutBeforeSendingITC);
   return bResult;
}

//=============================================================================

mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscUpReg::mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscUpReg()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscUpReg::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSLOTSTATEOPTICALDISCUPREG;
}


mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscUpReg::~mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscUpReg()
{}

//=============================================================================

mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscRelUpReg::mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscRelUpReg()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSLOTSTATEOPTICALDISCRELUPREG;
}


mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscRelUpReg::~mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscRelUpReg()
{}

//=============================================================================

mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscGet::mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscGet()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscGet::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSLOTSTATEOPTICALDISCGET;
}


mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscGet::~mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscStatus::mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscStatus(const mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscStatus& coRef)
   : mplay_devicemanagerfi_tclMsgBaseMessage(coRef)
{
   OpticalDiscSlotState = coRef.OpticalDiscSlotState;
}
mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscStatus& mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscStatus::operator=(const mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscStatus& coRef)
{
   if (this == &coRef) return *this;
   OpticalDiscSlotState = coRef.OpticalDiscSlotState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscStatus::vDestroy()
{
   {
   OpticalDiscSlotState.clear();
   }
}

mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscStatus::mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscStatus()

 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscStatus::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSLOTSTATEOPTICALDISCSTATUS;
}


mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscStatus::~mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(OpticalDiscSlotState.size()*1);
}

fi_tclInContext& mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      OpticalDiscSlotState.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> OpticalDiscSlotState[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)OpticalDiscSlotState.size());
   {
      for (tU32 u32Idx = 0; u32Idx < OpticalDiscSlotState.size(); ++u32Idx)
         (tVoid) (oOut << OpticalDiscSlotState[u32Idx]);
   }
   return oOut;
}

tBool mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscStatus::operator==(const mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (OpticalDiscSlotState.size() == roRef.OpticalDiscSlotState.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OpticalDiscSlotState.size()); ++u32Idx)
            bResult = bResult && (OpticalDiscSlotState[u32Idx] == roRef.OpticalDiscSlotState[u32Idx]);
      }
   return bResult;
}

//=============================================================================

mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoUpReg::mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoUpReg()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoUpReg::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCDINFOUPREG;
}


mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoUpReg::~mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoUpReg()
{}

//=============================================================================

mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoRelUpReg::mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoRelUpReg()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCDINFORELUPREG;
}


mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoRelUpReg::~mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoRelUpReg()
{}

//=============================================================================

mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoGet::mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoGet()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoGet::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCDINFOGET;
}


mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoGet::~mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoStatus::mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoStatus(const mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoStatus& coRef)
   : mplay_devicemanagerfi_tclMsgBaseMessage(coRef)
{
   CDInfo = coRef.CDInfo;
}
mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoStatus& mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoStatus::operator=(const mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   CDInfo = coRef.CDInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoStatus::vDestroy()
{
   CDInfo.vDestroy(); 
}

mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoStatus::mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoStatus()
:CDInfo()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoStatus::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCDINFOSTATUS;
}


mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoStatus::~mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+CDInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CDInfo);
   return oIn;
}

fi_tclOutContext& mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CDInfo);
   return oOut;
}

tBool mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoStatus::operator==(const mplay_devicemanagerfi_tclMsgDevManagerNotifyCDInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CDInfo == roRef.CDInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoSet::mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoSet(const mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoSet& coRef)
   : mplay_devicemanagerfi_tclMsgBaseMessage(coRef)
{
   e8DVDDiscType = coRef.e8DVDDiscType;
   e8DVDDriveMode = coRef.e8DVDDriveMode;
}
mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoSet& mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoSet::operator=(const mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoSet& coRef)
{
   if (this == &coRef) return *this;
   e8DVDDiscType = coRef.e8DVDDiscType;
   e8DVDDriveMode = coRef.e8DVDDriveMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoSet::mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoSet()
:e8DVDDiscType()
,e8DVDDriveMode()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoSet::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERDVDDRIVEINFOSET;
}


mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoSet::~mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoSet()
{}

tU32 mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8DVDDiscType);
   (tVoid) (oIn >> e8DVDDriveMode);
   return oIn;
}

fi_tclOutContext& mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8DVDDiscType);
   (tVoid) (oOut << e8DVDDriveMode);
   return oOut;
}

tBool mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoSet::operator==(const mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8DVDDiscType == roRef.e8DVDDiscType);
   bResult = bResult && (e8DVDDriveMode == roRef.e8DVDDriveMode);
   return bResult;
}

//=============================================================================

mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoRelUpReg::mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoRelUpReg()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERDVDDRIVEINFORELUPREG;
}


mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoRelUpReg::~mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoRelUpReg()
{}

//=============================================================================

mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoStatus::mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoStatus()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoStatus::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERDVDDRIVEINFOSTATUS;
}


mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoStatus::~mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoStatus()
{}

//=============================================================================

mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoUpReg::mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoUpReg()
 {}

tS32 mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoUpReg::s32GetTypeId() const
{
   return (tS32) mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERDVDDRIVEINFOUPREG;
}


mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoUpReg::~mplay_devicemanagerfi_tclMsgDevManagerDVDDriveInfoUpReg()
{}

