/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_APPCONTROLFI_TYPES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_APPCONTROLFI_FUNCTIONIDS
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_APPCONTROLFI_SERVICEINFO
#include "mplay_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for mplay_appcontrol_fi message types

fi_tclMessageBase* mplay_appcontrolfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case mplay_appcontrolfi_tclToken::EN_MSG_CONNECTMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgConnectMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_CONNECTMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgConnectMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_COMMANDMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgCommandMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_COMMANDMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgCommandMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_CLOSEMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgCloseMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_CLOSEMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgCloseMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_STARTAUDIOMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgStartAudioMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_STARTAUDIOMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgStartAudioMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_STOPAUDIOMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgStopAudioMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_STOPAUDIOMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgStopAudioMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOACTIVEDEVICEMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOACTIVEDEVICEMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOROLESWITCHREQUESTMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOROLESWITCHREQUESTMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOGETMEDIAOBJECTALBUMARTINFOMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOGETMEDIAOBJECTALBUMARTINFOMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOGETMEDIAOBJECTALBUMARTMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOGETMEDIAOBJECTALBUMARTMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOTRANSFERGPSDATAMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOTRANSFERGPSDATAMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOTRANSFERDRDATAMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOTRANSFERDRDATAMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOREQUESTAUDIODEVICEMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOREQUESTAUDIODEVICEMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPORELEASEAUDIODEVICEMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPORELEASEAUDIODEVICEMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOREQUESTPLAYBACKACTIONMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOREQUESTPLAYBACKACTIONMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOSTARTIAP2OVERCARPLAYWIFIMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOSTARTIAP2OVERCARPLAYWIFIMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOSTARTROUTEGUIDANCEMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOSTARTROUTEGUIDANCEMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOSTOPROUTEGUIDANCEMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOSTOPROUTEGUIDANCEMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_SWAPCALLSMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgSwapCallsMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_SWAPCALLSMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgSwapCallsMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOSETROUTEGUIDANCEDISPLAYCOMPONENTINFOMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOSETROUTEGUIDANCEDISPLAYCOMPONENTINFOMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOSTOPROUTEGUIDANCE2METHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOSTOPROUTEGUIDANCE2METHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOSTARTROUTEGUIDANCE2METHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOSTARTROUTEGUIDANCE2METHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOSETCALLCONTROLSCONFIGURATIONMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOSETCALLCONTROLSCONFIGURATIONMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOINITIATECALLMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOINITIATECALLMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOACCEPTCALLMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOACCEPTCALLMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOENDCALLMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOEndCallMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOENDCALLMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOEndCallMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOMERGECALLSMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOMERGECALLSMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOHOLDSTATUSUPDATEMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOHOLDSTATUSUPDATEMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOMUTESTATUSUPDATEMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOMUTESTATUSUPDATEMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOSENDDTMFMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOSENDDTMFMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOSWAPCALLSMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOSWAPCALLSMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOSETAPPLEIDENTIFICATIONINFOMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOSETAPPLEIDENTIFICATIONINFOMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOREQUESTBLUETOOTHAUDIODEVICEMETHODSTART:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodStart;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOREQUESTBLUETOOTHAUDIODEVICEMETHODRESULT:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodResult;

      case mplay_appcontrolfi_tclToken::EN_MSG_DATARESPONSEUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDataResponseUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DATARESPONSERELUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDataResponseRelUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DATARESPONSEGET:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDataResponseGet;

      case mplay_appcontrolfi_tclToken::EN_MSG_DATARESPONSESTATUS:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDataResponseStatus;

      case mplay_appcontrolfi_tclToken::EN_MSG_SESSIONOPENEDUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgSessionOpenedUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_SESSIONOPENEDRELUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgSessionOpenedRelUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_SESSIONOPENEDGET:
         return OSAL_NEW mplay_appcontrolfi_tclMsgSessionOpenedGet;

      case mplay_appcontrolfi_tclToken::EN_MSG_SESSIONOPENEDSTATUS:
         return OSAL_NEW mplay_appcontrolfi_tclMsgSessionOpenedStatus;

      case mplay_appcontrolfi_tclToken::EN_MSG_SESSIONCLOSEDUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgSessionClosedUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_SESSIONCLOSEDRELUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgSessionClosedRelUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_SESSIONCLOSEDGET:
         return OSAL_NEW mplay_appcontrolfi_tclMsgSessionClosedGet;

      case mplay_appcontrolfi_tclToken::EN_MSG_SESSIONCLOSEDSTATUS:
         return OSAL_NEW mplay_appcontrolfi_tclMsgSessionClosedStatus;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPODEVICECONNECTIONSUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPODeviceConnectionsUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPODEVICECONNECTIONSRELUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPODeviceConnectionsRelUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPODEVICECONNECTIONSGET:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPODeviceConnectionsGet;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPODEVICECONNECTIONSSTATUS:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYTIMEUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOPlaytimeUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYTIMERELUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOPlaytimeRelUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYTIMEGET:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOPlaytimeGet;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYTIMESTATUS:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOPlaytimeStatus;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOLOCATIONINFOUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOLocationInfoUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOLOCATIONINFORELUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOLocationInfoRelUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOLOCATIONINFOGET:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOLocationInfoGet;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOLOCATIONINFOSTATUS:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOLocationInfoStatus;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOMETADATAUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOMetaDataUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOMETADATARELUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOMetaDataRelUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOMETADATAGET:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOMetaDataGet;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOMETADATASTATUS:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOMetaDataStatus;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOPHONEDATAUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOPhoneDataUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOPHONEDATARELUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOPhoneDataRelUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOPHONEDATAGET:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOPhoneDataGet;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOPHONEDATASTATUS:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOPhoneDataStatus;

      case mplay_appcontrolfi_tclToken::EN_MSG_NATIVETRANSPORTSTARTUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgNativeTransportStartUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_NATIVETRANSPORTSTARTRELUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgNativeTransportStartRelUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_NATIVETRANSPORTSTARTGET:
         return OSAL_NEW mplay_appcontrolfi_tclMsgNativeTransportStartGet;

      case mplay_appcontrolfi_tclToken::EN_MSG_NATIVETRANSPORTSTARTSTATUS:
         return OSAL_NEW mplay_appcontrolfi_tclMsgNativeTransportStartStatus;

      case mplay_appcontrolfi_tclToken::EN_MSG_NATIVETRANSPORTSTOPUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgNativeTransportStopUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_NATIVETRANSPORTSTOPRELUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgNativeTransportStopRelUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_NATIVETRANSPORTSTOPGET:
         return OSAL_NEW mplay_appcontrolfi_tclMsgNativeTransportStopGet;

      case mplay_appcontrolfi_tclToken::EN_MSG_NATIVETRANSPORTSTOPSTATUS:
         return OSAL_NEW mplay_appcontrolfi_tclMsgNativeTransportStopStatus;

      case mplay_appcontrolfi_tclToken::EN_MSG_CONNECTEDBLUETOOTHPROFILESUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_CONNECTEDBLUETOOTHPROFILESRELUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesRelUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_CONNECTEDBLUETOOTHPROFILESGET:
         return OSAL_NEW mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesGet;

      case mplay_appcontrolfi_tclToken::EN_MSG_CONNECTEDBLUETOOTHPROFILESSTATUS:
         return OSAL_NEW mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesStatus;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPONOWPLAYINGUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPONowPlayingUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPONOWPLAYINGRELUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPONowPlayingRelUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPONOWPLAYINGGET:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPONowPlayingGet;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPONOWPLAYINGSTATUS:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPONowPlayingStatus;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYBACKSTATUSUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOPlaybackStatusUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYBACKSTATUSRELUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOPlaybackStatusRelUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYBACKSTATUSGET:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOPlaybackStatusGet;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYBACKSTATUSSTATUS:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOPlaybackStatusStatus;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYBACKSHUFFLEMODEUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYBACKSHUFFLEMODERELUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeRelUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYBACKSHUFFLEMODEGET:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeGet;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYBACKSHUFFLEMODESTATUS:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeStatus;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYBACKREPEATMODEUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYBACKREPEATMODERELUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeRelUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYBACKREPEATMODEGET:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeGet;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYBACKREPEATMODESTATUS:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeStatus;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOCALLSTATEUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOCallStateUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOCALLSTATERELUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOCallStateRelUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOCALLSTATEGET:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOCallStateGet;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOCALLSTATESTATUS:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOCallStateStatus;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOCOMMUNICATIONSUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOCommunicationsUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOCOMMUNICATIONSRELUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOCommunicationsRelUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOCOMMUNICATIONSGET:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOCommunicationsGet;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOCOMMUNICATIONSSTATUS:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOCommunicationsStatus;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOCOMMUNICATIONERRORUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOCommunicationErrorUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOCOMMUNICATIONERRORRELUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOCommunicationErrorRelUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOCOMMUNICATIONERRORGET:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOCommunicationErrorGet;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOCOMMUNICATIONERRORSTATUS:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOCommunicationErrorStatus;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOCALLDURATIONUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOCallDurationUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOCALLDURATIONRELUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOCallDurationRelUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOCALLDURATIONGET:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOCallDurationGet;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOCALLDURATIONSTATUS:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOCallDurationStatus;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOPOWERUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOPowerUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOPOWERRELUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOPowerRelUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOPOWERGET:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOPowerGet;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOPOWERSTATUS:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOPowerStatus;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCEUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPORouteGuidanceUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCERELUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPORouteGuidanceRelUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCEGET:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPORouteGuidanceGet;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCESTATUS:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPORouteGuidanceStatus;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCEMANEUVERUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCEMANEUVERRELUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverRelUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCEMANEUVERGET:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverGet;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCEMANEUVERSTATUS:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverStatus;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOGPRMCDATASTATUSVALUESUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOGPRMCDATASTATUSVALUESRELUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesRelUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOGPRMCDATASTATUSVALUESGET:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesGet;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOGPRMCDATASTATUSVALUESSTATUS:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesStatus;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCE2UPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPORouteGuidance2UpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCE2RELUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPORouteGuidance2RelUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCE2GET:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPORouteGuidance2Get;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCE2STATUS:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPORouteGuidance2Status;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCEMANEUVER2UPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2UpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCEMANEUVER2RELUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2RelUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCEMANEUVER2GET:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Get;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCEMANEUVER2STATUS:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Status;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOBLUETOOTHAUDIODEVICESTATUSUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOBLUETOOTHAUDIODEVICESTATUSRELUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusRelUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOBLUETOOTHAUDIODEVICESTATUSGET:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusGet;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPOBLUETOOTHAUDIODEVICESTATUSSTATUS:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusStatus;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPODEVICETIMEUPDATEUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPODEVICETIMEUPDATERELUPREG:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateRelUpReg;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPODEVICETIMEUPDATEGET:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateGet;

      case mplay_appcontrolfi_tclToken::EN_MSG_DIPODEVICETIMEUPDATESTATUS:
         return OSAL_NEW mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all mplay_appcontrolfifi messages

// common functions

tU16 mplay_appcontrolfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MPLAY_APPCONTROLFI_C_U16_SERVICE_ID;
}

tU16 mplay_appcontrolfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 mplay_appcontrolfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& mplay_appcontrolfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& mplay_appcontrolfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 mplay_appcontrolfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& mplay_appcontrolfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgConnectMethodStart::mplay_appcontrolfi_tclMsgConnectMethodStart(const mplay_appcontrolfi_tclMsgConnectMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   szDeviceId = coRef.szDeviceId;
   szProtocol = coRef.szProtocol;
   szBundleSeedID = coRef.szBundleSeedID;
   szAppName = coRef.szAppName;
   e8AppLaunchOption = coRef.e8AppLaunchOption;
}
mplay_appcontrolfi_tclMsgConnectMethodStart& mplay_appcontrolfi_tclMsgConnectMethodStart::operator=(const mplay_appcontrolfi_tclMsgConnectMethodStart& coRef)
{
   if (this == &coRef) return *this;
   szDeviceId = coRef.szDeviceId;
   szProtocol = coRef.szProtocol;
   szBundleSeedID = coRef.szBundleSeedID;
   szAppName = coRef.szAppName;
   e8AppLaunchOption = coRef.e8AppLaunchOption;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgConnectMethodStart::vDestroy()
{
   szDeviceId.vDestroy();
   szProtocol.vDestroy();
   szBundleSeedID.vDestroy();
   szAppName.vDestroy();
}

mplay_appcontrolfi_tclMsgConnectMethodStart::mplay_appcontrolfi_tclMsgConnectMethodStart()
:szDeviceId()
,szProtocol()
,szBundleSeedID()
,szAppName()
,e8AppLaunchOption()
 {}

tS32 mplay_appcontrolfi_tclMsgConnectMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_CONNECTMETHODSTART;
}


mplay_appcontrolfi_tclMsgConnectMethodStart::~mplay_appcontrolfi_tclMsgConnectMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgConnectMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+szDeviceId.u32GetSize(u16MajorVersion)+szProtocol.u32GetSize(u16MajorVersion)+szBundleSeedID.u32GetSize(u16MajorVersion)+szAppName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgConnectMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szDeviceId);
   (tVoid) (oIn >> szProtocol);
   (tVoid) (oIn >> szBundleSeedID);
   (tVoid) (oIn >> szAppName);
   (tVoid) (oIn >> e8AppLaunchOption);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgConnectMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szDeviceId);
   (tVoid) (oOut << szProtocol);
   (tVoid) (oOut << szBundleSeedID);
   (tVoid) (oOut << szAppName);
   (tVoid) (oOut << e8AppLaunchOption);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgConnectMethodStart::operator==(const mplay_appcontrolfi_tclMsgConnectMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szDeviceId == roRef.szDeviceId);
   bResult = bResult && (szProtocol == roRef.szProtocol);
   bResult = bResult && (szBundleSeedID == roRef.szBundleSeedID);
   bResult = bResult && (szAppName == roRef.szAppName);
   bResult = bResult && (e8AppLaunchOption == roRef.e8AppLaunchOption);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgConnectMethodResult::mplay_appcontrolfi_tclMsgConnectMethodResult(const mplay_appcontrolfi_tclMsgConnectMethodResult& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   szDeviceId = coRef.szDeviceId;
   u16SessionId = coRef.u16SessionId;
   szAppName = coRef.szAppName;
}
mplay_appcontrolfi_tclMsgConnectMethodResult& mplay_appcontrolfi_tclMsgConnectMethodResult::operator=(const mplay_appcontrolfi_tclMsgConnectMethodResult& coRef)
{
   if (this == &coRef) return *this;
   szDeviceId = coRef.szDeviceId;
   u16SessionId = coRef.u16SessionId;
   szAppName = coRef.szAppName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgConnectMethodResult::vDestroy()
{
   szDeviceId.vDestroy();
   szAppName.vDestroy();
}

mplay_appcontrolfi_tclMsgConnectMethodResult::mplay_appcontrolfi_tclMsgConnectMethodResult()
:szDeviceId()
,u16SessionId(0)
,szAppName()
 {}

tS32 mplay_appcontrolfi_tclMsgConnectMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_CONNECTMETHODRESULT;
}


mplay_appcontrolfi_tclMsgConnectMethodResult::~mplay_appcontrolfi_tclMsgConnectMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgConnectMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+szDeviceId.u32GetSize(u16MajorVersion)+szAppName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgConnectMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szDeviceId);
   (tVoid) (oIn >> u16SessionId);
   (tVoid) (oIn >> szAppName);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgConnectMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szDeviceId);
   (tVoid) (oOut << u16SessionId);
   (tVoid) (oOut << szAppName);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgConnectMethodResult::operator==(const mplay_appcontrolfi_tclMsgConnectMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szDeviceId == roRef.szDeviceId);
   bResult = bResult && (u16SessionId == roRef.u16SessionId);
   bResult = bResult && (szAppName == roRef.szAppName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgCommandMethodStart::mplay_appcontrolfi_tclMsgCommandMethodStart(const mplay_appcontrolfi_tclMsgCommandMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   szDeviceId = coRef.szDeviceId;
   szAppName = coRef.szAppName;
   u16SessionId = coRef.u16SessionId;
   au8CommandBuffer = coRef.au8CommandBuffer;
}
mplay_appcontrolfi_tclMsgCommandMethodStart& mplay_appcontrolfi_tclMsgCommandMethodStart::operator=(const mplay_appcontrolfi_tclMsgCommandMethodStart& coRef)
{
   if (this == &coRef) return *this;
   szDeviceId = coRef.szDeviceId;
   szAppName = coRef.szAppName;
   u16SessionId = coRef.u16SessionId;
   au8CommandBuffer = coRef.au8CommandBuffer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgCommandMethodStart::vDestroy()
{
   szDeviceId.vDestroy();
   szAppName.vDestroy();
   au8CommandBuffer.vDestroy(); 
}

mplay_appcontrolfi_tclMsgCommandMethodStart::mplay_appcontrolfi_tclMsgCommandMethodStart()
:szDeviceId()
,szAppName()
,u16SessionId(0)
,au8CommandBuffer()
 {}

tS32 mplay_appcontrolfi_tclMsgCommandMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_COMMANDMETHODSTART;
}


mplay_appcontrolfi_tclMsgCommandMethodStart::~mplay_appcontrolfi_tclMsgCommandMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgCommandMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+szDeviceId.u32GetSize(u16MajorVersion)+szAppName.u32GetSize(u16MajorVersion)+au8CommandBuffer.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgCommandMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szDeviceId);
   (tVoid) (oIn >> szAppName);
   (tVoid) (oIn >> u16SessionId);
   (tVoid) (oIn >> au8CommandBuffer);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgCommandMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szDeviceId);
   (tVoid) (oOut << szAppName);
   (tVoid) (oOut << u16SessionId);
   (tVoid) (oOut << au8CommandBuffer);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgCommandMethodStart::operator==(const mplay_appcontrolfi_tclMsgCommandMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szDeviceId == roRef.szDeviceId);
   bResult = bResult && (szAppName == roRef.szAppName);
   bResult = bResult && (u16SessionId == roRef.u16SessionId);
   bResult = bResult && (au8CommandBuffer == roRef.au8CommandBuffer);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgCommandMethodResult::mplay_appcontrolfi_tclMsgCommandMethodResult(const mplay_appcontrolfi_tclMsgCommandMethodResult& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   szDeviceId = coRef.szDeviceId;
   szAppName = coRef.szAppName;
   u16SessionId = coRef.u16SessionId;
   au8CommandResponseBuffer = coRef.au8CommandResponseBuffer;
}
mplay_appcontrolfi_tclMsgCommandMethodResult& mplay_appcontrolfi_tclMsgCommandMethodResult::operator=(const mplay_appcontrolfi_tclMsgCommandMethodResult& coRef)
{
   if (this == &coRef) return *this;
   szDeviceId = coRef.szDeviceId;
   szAppName = coRef.szAppName;
   u16SessionId = coRef.u16SessionId;
   au8CommandResponseBuffer = coRef.au8CommandResponseBuffer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgCommandMethodResult::vDestroy()
{
   szDeviceId.vDestroy();
   szAppName.vDestroy();
   au8CommandResponseBuffer.vDestroy(); 
}

mplay_appcontrolfi_tclMsgCommandMethodResult::mplay_appcontrolfi_tclMsgCommandMethodResult()
:szDeviceId()
,szAppName()
,u16SessionId(0)
,au8CommandResponseBuffer()
 {}

tS32 mplay_appcontrolfi_tclMsgCommandMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_COMMANDMETHODRESULT;
}


mplay_appcontrolfi_tclMsgCommandMethodResult::~mplay_appcontrolfi_tclMsgCommandMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgCommandMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+szDeviceId.u32GetSize(u16MajorVersion)+szAppName.u32GetSize(u16MajorVersion)+au8CommandResponseBuffer.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgCommandMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szDeviceId);
   (tVoid) (oIn >> szAppName);
   (tVoid) (oIn >> u16SessionId);
   (tVoid) (oIn >> au8CommandResponseBuffer);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgCommandMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szDeviceId);
   (tVoid) (oOut << szAppName);
   (tVoid) (oOut << u16SessionId);
   (tVoid) (oOut << au8CommandResponseBuffer);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgCommandMethodResult::operator==(const mplay_appcontrolfi_tclMsgCommandMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szDeviceId == roRef.szDeviceId);
   bResult = bResult && (szAppName == roRef.szAppName);
   bResult = bResult && (u16SessionId == roRef.u16SessionId);
   bResult = bResult && (au8CommandResponseBuffer == roRef.au8CommandResponseBuffer);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgCloseMethodStart::mplay_appcontrolfi_tclMsgCloseMethodStart(const mplay_appcontrolfi_tclMsgCloseMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   szDeviceId = coRef.szDeviceId;
   szAppName = coRef.szAppName;
   u16SessionId = coRef.u16SessionId;
}
mplay_appcontrolfi_tclMsgCloseMethodStart& mplay_appcontrolfi_tclMsgCloseMethodStart::operator=(const mplay_appcontrolfi_tclMsgCloseMethodStart& coRef)
{
   if (this == &coRef) return *this;
   szDeviceId = coRef.szDeviceId;
   szAppName = coRef.szAppName;
   u16SessionId = coRef.u16SessionId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgCloseMethodStart::vDestroy()
{
   szDeviceId.vDestroy();
   szAppName.vDestroy();
}

mplay_appcontrolfi_tclMsgCloseMethodStart::mplay_appcontrolfi_tclMsgCloseMethodStart()
:szDeviceId()
,szAppName()
,u16SessionId(0)
 {}

tS32 mplay_appcontrolfi_tclMsgCloseMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_CLOSEMETHODSTART;
}


mplay_appcontrolfi_tclMsgCloseMethodStart::~mplay_appcontrolfi_tclMsgCloseMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgCloseMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+szDeviceId.u32GetSize(u16MajorVersion)+szAppName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgCloseMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szDeviceId);
   (tVoid) (oIn >> szAppName);
   (tVoid) (oIn >> u16SessionId);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgCloseMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szDeviceId);
   (tVoid) (oOut << szAppName);
   (tVoid) (oOut << u16SessionId);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgCloseMethodStart::operator==(const mplay_appcontrolfi_tclMsgCloseMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szDeviceId == roRef.szDeviceId);
   bResult = bResult && (szAppName == roRef.szAppName);
   bResult = bResult && (u16SessionId == roRef.u16SessionId);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgCloseMethodResult::mplay_appcontrolfi_tclMsgCloseMethodResult()
 {}

tS32 mplay_appcontrolfi_tclMsgCloseMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_CLOSEMETHODRESULT;
}


mplay_appcontrolfi_tclMsgCloseMethodResult::~mplay_appcontrolfi_tclMsgCloseMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgStartAudioMethodStart::mplay_appcontrolfi_tclMsgStartAudioMethodStart(const mplay_appcontrolfi_tclMsgStartAudioMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   szDeviceId = coRef.szDeviceId;
}
mplay_appcontrolfi_tclMsgStartAudioMethodStart& mplay_appcontrolfi_tclMsgStartAudioMethodStart::operator=(const mplay_appcontrolfi_tclMsgStartAudioMethodStart& coRef)
{
   if (this == &coRef) return *this;
   szDeviceId = coRef.szDeviceId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgStartAudioMethodStart::vDestroy()
{
   szDeviceId.vDestroy();
}

mplay_appcontrolfi_tclMsgStartAudioMethodStart::mplay_appcontrolfi_tclMsgStartAudioMethodStart()
:szDeviceId()
 {}

tS32 mplay_appcontrolfi_tclMsgStartAudioMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_STARTAUDIOMETHODSTART;
}


mplay_appcontrolfi_tclMsgStartAudioMethodStart::~mplay_appcontrolfi_tclMsgStartAudioMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgStartAudioMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+szDeviceId.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgStartAudioMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szDeviceId);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgStartAudioMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szDeviceId);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgStartAudioMethodStart::operator==(const mplay_appcontrolfi_tclMsgStartAudioMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szDeviceId == roRef.szDeviceId);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgStartAudioMethodResult::mplay_appcontrolfi_tclMsgStartAudioMethodResult()
 {}

tS32 mplay_appcontrolfi_tclMsgStartAudioMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_STARTAUDIOMETHODRESULT;
}


mplay_appcontrolfi_tclMsgStartAudioMethodResult::~mplay_appcontrolfi_tclMsgStartAudioMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgStopAudioMethodStart::mplay_appcontrolfi_tclMsgStopAudioMethodStart(const mplay_appcontrolfi_tclMsgStopAudioMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   szDeviceId = coRef.szDeviceId;
}
mplay_appcontrolfi_tclMsgStopAudioMethodStart& mplay_appcontrolfi_tclMsgStopAudioMethodStart::operator=(const mplay_appcontrolfi_tclMsgStopAudioMethodStart& coRef)
{
   if (this == &coRef) return *this;
   szDeviceId = coRef.szDeviceId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgStopAudioMethodStart::vDestroy()
{
   szDeviceId.vDestroy();
}

mplay_appcontrolfi_tclMsgStopAudioMethodStart::mplay_appcontrolfi_tclMsgStopAudioMethodStart()
:szDeviceId()
 {}

tS32 mplay_appcontrolfi_tclMsgStopAudioMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_STOPAUDIOMETHODSTART;
}


mplay_appcontrolfi_tclMsgStopAudioMethodStart::~mplay_appcontrolfi_tclMsgStopAudioMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgStopAudioMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+szDeviceId.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgStopAudioMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szDeviceId);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgStopAudioMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szDeviceId);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgStopAudioMethodStart::operator==(const mplay_appcontrolfi_tclMsgStopAudioMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szDeviceId == roRef.szDeviceId);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgStopAudioMethodResult::mplay_appcontrolfi_tclMsgStopAudioMethodResult()
 {}

tS32 mplay_appcontrolfi_tclMsgStopAudioMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_STOPAUDIOMETHODRESULT;
}


mplay_appcontrolfi_tclMsgStopAudioMethodResult::~mplay_appcontrolfi_tclMsgStopAudioMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodStart::mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodStart(const mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   u8DeviceTag = coRef.u8DeviceTag;
   bDiPOActive = coRef.bDiPOActive;
}
mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodStart& mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodStart::operator=(const mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceTag = coRef.u8DeviceTag;
   bDiPOActive = coRef.bDiPOActive;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodStart::mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodStart()
:u8DeviceTag(0)
,bDiPOActive(0)
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOACTIVEDEVICEMETHODSTART;
}


mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodStart::~mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodStart()
{}

tU32 mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> bDiPOActive);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << bDiPOActive);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodStart::operator==(const mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (bDiPOActive == roRef.bDiPOActive);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodResult::mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodResult(const mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodResult& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   e8DiPOResponse = coRef.e8DiPOResponse;
}
mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodResult& mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodResult::operator=(const mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8DiPOResponse = coRef.e8DiPOResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodResult::mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodResult()
:e8DiPOResponse()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOACTIVEDEVICEMETHODRESULT;
}


mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodResult::~mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodResult()
{}

tU32 mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8DiPOResponse);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8DiPOResponse);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodResult::operator==(const mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8DiPOResponse == roRef.e8DiPOResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodStart::mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodStart(const mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   u8DeviceTag = coRef.u8DeviceTag;
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
   e8DiPORoleStatus = coRef.e8DiPORoleStatus;
   oAppInfo = coRef.oAppInfo;
}
mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodStart& mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodStart::operator=(const mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceTag = coRef.u8DeviceTag;
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
   e8DiPORoleStatus = coRef.e8DiPORoleStatus;
   oAppInfo = coRef.oAppInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodStart::vDestroy()
{
   sDeviceUSBSerialNumber.vDestroy();
   oAppInfo.vDestroy(); 
}

mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodStart::mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodStart()
:u8DeviceTag(0)
,sDeviceUSBSerialNumber()
,e8DiPORoleStatus()
,oAppInfo()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOROLESWITCHREQUESTMETHODSTART;
}


mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodStart::~mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+sDeviceUSBSerialNumber.u32GetSize(u16MajorVersion)+oAppInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> sDeviceUSBSerialNumber);
   (tVoid) (oIn >> e8DiPORoleStatus);
   (tVoid) (oIn >> oAppInfo);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << sDeviceUSBSerialNumber);
   (tVoid) (oOut << e8DiPORoleStatus);
   (tVoid) (oOut << oAppInfo);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodStart::operator==(const mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (sDeviceUSBSerialNumber == roRef.sDeviceUSBSerialNumber);
   bResult = bResult && (e8DiPORoleStatus == roRef.e8DiPORoleStatus);
   bResult = bResult && (oAppInfo == roRef.oAppInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodResult::mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodResult(const mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodResult& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   e8DiPOResponse = coRef.e8DiPOResponse;
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
}
mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodResult& mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodResult::operator=(const mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8DiPOResponse = coRef.e8DiPOResponse;
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodResult::vDestroy()
{
   sDeviceUSBSerialNumber.vDestroy();
}

mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodResult::mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodResult()
:e8DiPOResponse()
,sDeviceUSBSerialNumber()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOROLESWITCHREQUESTMETHODRESULT;
}


mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodResult::~mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sDeviceUSBSerialNumber.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8DiPOResponse);
   (tVoid) (oIn >> sDeviceUSBSerialNumber);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8DiPOResponse);
   (tVoid) (oOut << sDeviceUSBSerialNumber);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodResult::operator==(const mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8DiPOResponse == roRef.e8DiPOResponse);
   bResult = bResult && (sDeviceUSBSerialNumber == roRef.sDeviceUSBSerialNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodStart::mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodStart(const mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   sAlbumArt = coRef.sAlbumArt;
}
mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodStart& mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodStart::operator=(const mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sAlbumArt = coRef.sAlbumArt;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodStart::vDestroy()
{
   sAlbumArt.vDestroy();
}

mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodStart::mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodStart()
:sAlbumArt()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOGETMEDIAOBJECTALBUMARTINFOMETHODSTART;
}


mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodStart::~mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+sAlbumArt.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sAlbumArt);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sAlbumArt);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodStart::operator==(const mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sAlbumArt == roRef.sAlbumArt);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodResult::mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodResult(const mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodResult& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   sMIMEImageSubtype = coRef.sMIMEImageSubtype;
   u32PhotoSize = coRef.u32PhotoSize;
}
mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodResult& mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodResult::operator=(const mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   sMIMEImageSubtype = coRef.sMIMEImageSubtype;
   u32PhotoSize = coRef.u32PhotoSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodResult::vDestroy()
{
   sMIMEImageSubtype.vDestroy();
}

mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodResult::mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodResult()
:sMIMEImageSubtype()
,u32PhotoSize(0)
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOGETMEDIAOBJECTALBUMARTINFOMETHODRESULT;
}


mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodResult::~mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+sMIMEImageSubtype.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sMIMEImageSubtype);
   (tVoid) (oIn >> u32PhotoSize);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sMIMEImageSubtype);
   (tVoid) (oOut << u32PhotoSize);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodResult::operator==(const mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sMIMEImageSubtype == roRef.sMIMEImageSubtype);
   bResult = bResult && (u32PhotoSize == roRef.u32PhotoSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodStart::mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodStart(const mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   sAlbumArt = coRef.sAlbumArt;
}
mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodStart& mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodStart::operator=(const mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sAlbumArt = coRef.sAlbumArt;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodStart::vDestroy()
{
   sAlbumArt.vDestroy();
}

mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodStart::mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodStart()
:sAlbumArt()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOGETMEDIAOBJECTALBUMARTMETHODSTART;
}


mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodStart::~mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+sAlbumArt.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sAlbumArt);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sAlbumArt);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodStart::operator==(const mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sAlbumArt == roRef.sAlbumArt);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodResult::mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodResult(const mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodResult& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   oImageData = coRef.oImageData;
}
mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodResult& mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodResult::operator=(const mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oImageData = coRef.oImageData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodResult::vDestroy()
{
   oImageData.vDestroy(); 
}

mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodResult::mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodResult()
:oImageData()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOGETMEDIAOBJECTALBUMARTMETHODRESULT;
}


mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodResult::~mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+oImageData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oImageData);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oImageData);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodResult::operator==(const mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oImageData == roRef.oImageData);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodStart::mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodStart(const mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   u8DeviceTag = coRef.u8DeviceTag;
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
   sGPGGAData = coRef.sGPGGAData;
   sGPRMCData = coRef.sGPRMCData;
   sGPGSVData = coRef.sGPGSVData;
   sGPHDTData = coRef.sGPHDTData;
}
mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodStart& mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodStart::operator=(const mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceTag = coRef.u8DeviceTag;
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
   sGPGGAData = coRef.sGPGGAData;
   sGPRMCData = coRef.sGPRMCData;
   sGPGSVData = coRef.sGPGSVData;
   sGPHDTData = coRef.sGPHDTData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodStart::vDestroy()
{
   sDeviceUSBSerialNumber.vDestroy();
   sGPGGAData.vDestroy();
   sGPRMCData.vDestroy();
   sGPGSVData.vDestroy();
   sGPHDTData.vDestroy();
}

mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodStart::mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodStart()
:u8DeviceTag(0)
,sDeviceUSBSerialNumber()
,sGPGGAData()
,sGPRMCData()
,sGPGSVData()
,sGPHDTData()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOTRANSFERGPSDATAMETHODSTART;
}


mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodStart::~mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sDeviceUSBSerialNumber.u32GetSize(u16MajorVersion)+sGPGGAData.u32GetSize(u16MajorVersion)+sGPRMCData.u32GetSize(u16MajorVersion)+sGPGSVData.u32GetSize(u16MajorVersion)+sGPHDTData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> sDeviceUSBSerialNumber);
   (tVoid) (oIn >> sGPGGAData);
   (tVoid) (oIn >> sGPRMCData);
   (tVoid) (oIn >> sGPGSVData);
   (tVoid) (oIn >> sGPHDTData);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << sDeviceUSBSerialNumber);
   (tVoid) (oOut << sGPGGAData);
   (tVoid) (oOut << sGPRMCData);
   (tVoid) (oOut << sGPGSVData);
   (tVoid) (oOut << sGPHDTData);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodStart::operator==(const mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (sDeviceUSBSerialNumber == roRef.sDeviceUSBSerialNumber);
   bResult = bResult && (sGPGGAData == roRef.sGPGGAData);
   bResult = bResult && (sGPRMCData == roRef.sGPRMCData);
   bResult = bResult && (sGPGSVData == roRef.sGPGSVData);
   bResult = bResult && (sGPHDTData == roRef.sGPHDTData);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodResult::mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodResult(const mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodResult& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   e8DiPOResponse = coRef.e8DiPOResponse;
}
mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodResult& mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodResult::operator=(const mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8DiPOResponse = coRef.e8DiPOResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodResult::mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodResult()
:e8DiPOResponse()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOTRANSFERGPSDATAMETHODRESULT;
}


mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodResult::~mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodResult()
{}

tU32 mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8DiPOResponse);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8DiPOResponse);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodResult::operator==(const mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8DiPOResponse == roRef.e8DiPOResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodStart::mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodStart(const mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   u8DeviceTag = coRef.u8DeviceTag;
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
   sPASCDData = coRef.sPASCDData;
   sPAGCDData = coRef.sPAGCDData;
   sPAACDData = coRef.sPAACDData;
}
mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodStart& mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodStart::operator=(const mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceTag = coRef.u8DeviceTag;
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
   sPASCDData = coRef.sPASCDData;
   sPAGCDData = coRef.sPAGCDData;
   sPAACDData = coRef.sPAACDData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodStart::vDestroy()
{
   sDeviceUSBSerialNumber.vDestroy();
   sPASCDData.vDestroy();
   sPAGCDData.vDestroy();
   sPAACDData.vDestroy();
}

mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodStart::mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodStart()
:u8DeviceTag(0)
,sDeviceUSBSerialNumber()
,sPASCDData()
,sPAGCDData()
,sPAACDData()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOTRANSFERDRDATAMETHODSTART;
}


mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodStart::~mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sDeviceUSBSerialNumber.u32GetSize(u16MajorVersion)+sPASCDData.u32GetSize(u16MajorVersion)+sPAGCDData.u32GetSize(u16MajorVersion)+sPAACDData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> sDeviceUSBSerialNumber);
   (tVoid) (oIn >> sPASCDData);
   (tVoid) (oIn >> sPAGCDData);
   (tVoid) (oIn >> sPAACDData);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << sDeviceUSBSerialNumber);
   (tVoid) (oOut << sPASCDData);
   (tVoid) (oOut << sPAGCDData);
   (tVoid) (oOut << sPAACDData);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodStart::operator==(const mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (sDeviceUSBSerialNumber == roRef.sDeviceUSBSerialNumber);
   bResult = bResult && (sPASCDData == roRef.sPASCDData);
   bResult = bResult && (sPAGCDData == roRef.sPAGCDData);
   bResult = bResult && (sPAACDData == roRef.sPAACDData);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodResult::mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodResult(const mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodResult& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   e8DiPOResponse = coRef.e8DiPOResponse;
}
mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodResult& mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodResult::operator=(const mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8DiPOResponse = coRef.e8DiPOResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodResult::mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodResult()
:e8DiPOResponse()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOTRANSFERDRDATAMETHODRESULT;
}


mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodResult::~mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodResult()
{}

tU32 mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8DiPOResponse);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8DiPOResponse);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodResult::operator==(const mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8DiPOResponse == roRef.e8DiPOResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodStart::mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodStart(const mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   u8DeviceTag = coRef.u8DeviceTag;
}
mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodStart& mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodStart::operator=(const mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodStart::mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodStart()
:u8DeviceTag(0)
 {}

tS32 mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOREQUESTAUDIODEVICEMETHODSTART;
}


mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodStart::~mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodStart()
{}

tU32 mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodStart::operator==(const mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodResult::mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodResult(const mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodResult& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   sDeviceName = coRef.sDeviceName;
   e8Error = coRef.e8Error;
}
mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodResult& mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodResult::operator=(const mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   sDeviceName = coRef.sDeviceName;
   e8Error = coRef.e8Error;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodResult::vDestroy()
{
   sDeviceName.vDestroy();
}

mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodResult::mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodResult()
:sDeviceName()
,e8Error()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOREQUESTAUDIODEVICEMETHODRESULT;
}


mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodResult::~mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sDeviceName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sDeviceName);
   (tVoid) (oIn >> e8Error);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sDeviceName);
   (tVoid) (oOut << e8Error);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodResult::operator==(const mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sDeviceName == roRef.sDeviceName);
   bResult = bResult && (e8Error == roRef.e8Error);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodStart::mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodStart(const mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   u8DeviceTag = coRef.u8DeviceTag;
}
mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodStart& mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodStart::operator=(const mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodStart::mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodStart()
:u8DeviceTag(0)
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPORELEASEAUDIODEVICEMETHODSTART;
}


mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodStart::~mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodStart()
{}

tU32 mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodStart::operator==(const mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodResult::mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodResult(const mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodResult& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   e8Error = coRef.e8Error;
}
mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodResult& mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodResult::operator=(const mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8Error = coRef.e8Error;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodResult::mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodResult()
:e8Error()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPORELEASEAUDIODEVICEMETHODRESULT;
}


mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodResult::~mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodResult()
{}

tU32 mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Error);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Error);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodResult::operator==(const mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Error == roRef.e8Error);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodStart::mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodStart(const mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   u8DeviceTag = coRef.u8DeviceTag;
   e8Action = coRef.e8Action;
   u8NextPrevSkipCount = coRef.u8NextPrevSkipCount;
}
mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodStart& mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodStart::operator=(const mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceTag = coRef.u8DeviceTag;
   e8Action = coRef.e8Action;
   u8NextPrevSkipCount = coRef.u8NextPrevSkipCount;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodStart::mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodStart()
:u8DeviceTag(0)
,e8Action()
,u8NextPrevSkipCount(0)
 {}

tS32 mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOREQUESTPLAYBACKACTIONMETHODSTART;
}


mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodStart::~mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodStart()
{}

tU32 mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> e8Action);
   (tVoid) (oIn >> u8NextPrevSkipCount);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << e8Action);
   (tVoid) (oOut << u8NextPrevSkipCount);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodStart::operator==(const mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (e8Action == roRef.e8Action);
   bResult = bResult && (u8NextPrevSkipCount == roRef.u8NextPrevSkipCount);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodResult::mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodResult()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOREQUESTPLAYBACKACTIONMETHODRESULT;
}


mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodResult::~mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodStart::mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodStart(const mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   sDeviceBTMacAddress = coRef.sDeviceBTMacAddress;
}
mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodStart& mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodStart::operator=(const mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sDeviceBTMacAddress = coRef.sDeviceBTMacAddress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodStart::vDestroy()
{
   sDeviceBTMacAddress.vDestroy();
}

mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodStart::mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodStart()
:sDeviceBTMacAddress()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOSTARTIAP2OVERCARPLAYWIFIMETHODSTART;
}


mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodStart::~mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+sDeviceBTMacAddress.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sDeviceBTMacAddress);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sDeviceBTMacAddress);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodStart::operator==(const mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sDeviceBTMacAddress == roRef.sDeviceBTMacAddress);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodResult::mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodResult()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOSTARTIAP2OVERCARPLAYWIFIMETHODRESULT;
}


mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodResult::~mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodResult()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodResult::mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodResult()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOSTARTROUTEGUIDANCEMETHODRESULT;
}


mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodResult::~mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodStart::mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodStart(const mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
   u16RouteGuidanceDisplayComponentID = coRef.u16RouteGuidanceDisplayComponentID;
   SourceName = coRef.SourceName;
   SourceSupportsRouteGuidance = coRef.SourceSupportsRouteGuidance;
}
mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodStart& mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodStart::operator=(const mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
   u16RouteGuidanceDisplayComponentID = coRef.u16RouteGuidanceDisplayComponentID;
   SourceName = coRef.SourceName;
   SourceSupportsRouteGuidance = coRef.SourceSupportsRouteGuidance;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodStart::vDestroy()
{
   sDeviceUSBSerialNumber.vDestroy();
}

mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodStart::mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodStart()
:sDeviceUSBSerialNumber()
,u16RouteGuidanceDisplayComponentID(0)
,SourceName(0)
,SourceSupportsRouteGuidance(0)
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOSTARTROUTEGUIDANCEMETHODSTART;
}


mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodStart::~mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+sDeviceUSBSerialNumber.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sDeviceUSBSerialNumber);
   (tVoid) (oIn >> u16RouteGuidanceDisplayComponentID);
   (tVoid) (oIn >> SourceName);
   (tVoid) (oIn >> SourceSupportsRouteGuidance);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sDeviceUSBSerialNumber);
   (tVoid) (oOut << u16RouteGuidanceDisplayComponentID);
   (tVoid) (oOut << SourceName);
   (tVoid) (oOut << SourceSupportsRouteGuidance);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodStart::operator==(const mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sDeviceUSBSerialNumber == roRef.sDeviceUSBSerialNumber);
   bResult = bResult && (u16RouteGuidanceDisplayComponentID == roRef.u16RouteGuidanceDisplayComponentID);
   bResult = bResult && (SourceName == roRef.SourceName);
   bResult = bResult && (SourceSupportsRouteGuidance == roRef.SourceSupportsRouteGuidance);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodResult::mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodResult()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOSTOPROUTEGUIDANCEMETHODRESULT;
}


mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodResult::~mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodStart::mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodStart(const mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
   u16RouteGuidanceDisplayComponentID = coRef.u16RouteGuidanceDisplayComponentID;
}
mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodStart& mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodStart::operator=(const mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
   u16RouteGuidanceDisplayComponentID = coRef.u16RouteGuidanceDisplayComponentID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodStart::vDestroy()
{
   sDeviceUSBSerialNumber.vDestroy();
}

mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodStart::mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodStart()
:sDeviceUSBSerialNumber()
,u16RouteGuidanceDisplayComponentID(0)
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOSTOPROUTEGUIDANCEMETHODSTART;
}


mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodStart::~mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+sDeviceUSBSerialNumber.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sDeviceUSBSerialNumber);
   (tVoid) (oIn >> u16RouteGuidanceDisplayComponentID);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sDeviceUSBSerialNumber);
   (tVoid) (oOut << u16RouteGuidanceDisplayComponentID);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodStart::operator==(const mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sDeviceUSBSerialNumber == roRef.sDeviceUSBSerialNumber);
   bResult = bResult && (u16RouteGuidanceDisplayComponentID == roRef.u16RouteGuidanceDisplayComponentID);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgSwapCallsMethodResult::mplay_appcontrolfi_tclMsgSwapCallsMethodResult()
 {}

tS32 mplay_appcontrolfi_tclMsgSwapCallsMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_SWAPCALLSMETHODRESULT;
}


mplay_appcontrolfi_tclMsgSwapCallsMethodResult::~mplay_appcontrolfi_tclMsgSwapCallsMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgSwapCallsMethodStart::mplay_appcontrolfi_tclMsgSwapCallsMethodStart(const mplay_appcontrolfi_tclMsgSwapCallsMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   u8DeviceTag = coRef.u8DeviceTag;
}
mplay_appcontrolfi_tclMsgSwapCallsMethodStart& mplay_appcontrolfi_tclMsgSwapCallsMethodStart::operator=(const mplay_appcontrolfi_tclMsgSwapCallsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_appcontrolfi_tclMsgSwapCallsMethodStart::mplay_appcontrolfi_tclMsgSwapCallsMethodStart()
:u8DeviceTag(0)
 {}

tS32 mplay_appcontrolfi_tclMsgSwapCallsMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_SWAPCALLSMETHODSTART;
}


mplay_appcontrolfi_tclMsgSwapCallsMethodStart::~mplay_appcontrolfi_tclMsgSwapCallsMethodStart()
{}

tU32 mplay_appcontrolfi_tclMsgSwapCallsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_appcontrolfi_tclMsgSwapCallsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgSwapCallsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgSwapCallsMethodStart::operator==(const mplay_appcontrolfi_tclMsgSwapCallsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodResult::mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodResult()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOSETROUTEGUIDANCEDISPLAYCOMPONENTINFOMETHODRESULT;
}


mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodResult::~mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodStart::mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodStart(const mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   RouteGuidanceDisplayComponents = coRef.RouteGuidanceDisplayComponents;
}
mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodStart& mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodStart::operator=(const mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RouteGuidanceDisplayComponents = coRef.RouteGuidanceDisplayComponents;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodStart::vDestroy()
{
   RouteGuidanceDisplayComponents.vDestroy(); 
}

mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodStart::mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodStart()
:RouteGuidanceDisplayComponents()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOSETROUTEGUIDANCEDISPLAYCOMPONENTINFOMETHODSTART;
}


mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodStart::~mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+RouteGuidanceDisplayComponents.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RouteGuidanceDisplayComponents);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RouteGuidanceDisplayComponents);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodStart::operator==(const mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RouteGuidanceDisplayComponents == roRef.RouteGuidanceDisplayComponents);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodResult::mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodResult()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOSTOPROUTEGUIDANCE2METHODRESULT;
}


mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodResult::~mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodStart::mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodStart(const mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
   RouteGuidanceDisplayComponentIDs = coRef.RouteGuidanceDisplayComponentIDs;
}
mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodStart& mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodStart::operator=(const mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodStart& coRef)
{
   if (this == &coRef) return *this;
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
   RouteGuidanceDisplayComponentIDs = coRef.RouteGuidanceDisplayComponentIDs;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodStart::vDestroy()
{
   sDeviceUSBSerialNumber.vDestroy();
   RouteGuidanceDisplayComponentIDs.vDestroy(); 
}

mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodStart::mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodStart()
:sDeviceUSBSerialNumber()
,RouteGuidanceDisplayComponentIDs()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOSTOPROUTEGUIDANCE2METHODSTART;
}


mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodStart::~mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+sDeviceUSBSerialNumber.u32GetSize(u16MajorVersion)+RouteGuidanceDisplayComponentIDs.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sDeviceUSBSerialNumber);
   (tVoid) (oIn >> RouteGuidanceDisplayComponentIDs);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sDeviceUSBSerialNumber);
   (tVoid) (oOut << RouteGuidanceDisplayComponentIDs);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodStart::operator==(const mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sDeviceUSBSerialNumber == roRef.sDeviceUSBSerialNumber);
   bResult = bResult && (RouteGuidanceDisplayComponentIDs == roRef.RouteGuidanceDisplayComponentIDs);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodResult::mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodResult()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOSTARTROUTEGUIDANCE2METHODRESULT;
}


mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodResult::~mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodStart::mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodStart(const mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
   RouteGuidanceDisplayComponentIDs = coRef.RouteGuidanceDisplayComponentIDs;
   SourceName = coRef.SourceName;
   SourceSupportsRouteGuidance = coRef.SourceSupportsRouteGuidance;
}
mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodStart& mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodStart::operator=(const mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodStart& coRef)
{
   if (this == &coRef) return *this;
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
   RouteGuidanceDisplayComponentIDs = coRef.RouteGuidanceDisplayComponentIDs;
   SourceName = coRef.SourceName;
   SourceSupportsRouteGuidance = coRef.SourceSupportsRouteGuidance;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodStart::vDestroy()
{
   sDeviceUSBSerialNumber.vDestroy();
   RouteGuidanceDisplayComponentIDs.vDestroy(); 
}

mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodStart::mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodStart()
:sDeviceUSBSerialNumber()
,RouteGuidanceDisplayComponentIDs()
,SourceName(0)
,SourceSupportsRouteGuidance(0)
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOSTARTROUTEGUIDANCE2METHODSTART;
}


mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodStart::~mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+sDeviceUSBSerialNumber.u32GetSize(u16MajorVersion)+RouteGuidanceDisplayComponentIDs.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sDeviceUSBSerialNumber);
   (tVoid) (oIn >> RouteGuidanceDisplayComponentIDs);
   (tVoid) (oIn >> SourceName);
   (tVoid) (oIn >> SourceSupportsRouteGuidance);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sDeviceUSBSerialNumber);
   (tVoid) (oOut << RouteGuidanceDisplayComponentIDs);
   (tVoid) (oOut << SourceName);
   (tVoid) (oOut << SourceSupportsRouteGuidance);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodStart::operator==(const mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sDeviceUSBSerialNumber == roRef.sDeviceUSBSerialNumber);
   bResult = bResult && (RouteGuidanceDisplayComponentIDs == roRef.RouteGuidanceDisplayComponentIDs);
   bResult = bResult && (SourceName == roRef.SourceName);
   bResult = bResult && (SourceSupportsRouteGuidance == roRef.SourceSupportsRouteGuidance);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodResult::mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodResult()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOSETCALLCONTROLSCONFIGURATIONMETHODRESULT;
}


mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodResult::~mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodStart::mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodStart(const mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   callControlsConfiguration = coRef.callControlsConfiguration;
}
mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodStart& mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodStart::operator=(const mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   callControlsConfiguration = coRef.callControlsConfiguration;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodStart::mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodStart()
:callControlsConfiguration()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOSETCALLCONTROLSCONFIGURATIONMETHODSTART;
}


mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodStart::~mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodStart()
{}

tU32 mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> callControlsConfiguration);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << callControlsConfiguration);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodStart::operator==(const mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (callControlsConfiguration == roRef.callControlsConfiguration);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodResult::mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodResult()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOINITIATECALLMETHODRESULT;
}


mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodResult::~mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodStart::mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodStart(const mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   deviceUSBSerialNumber = coRef.deviceUSBSerialNumber;
   type = coRef.type;
   service = coRef.service;
   destinationID = coRef.destinationID;
   addressBookID = coRef.addressBookID;
}
mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodStart& mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodStart::operator=(const mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodStart& coRef)
{
   if (this == &coRef) return *this;
   deviceUSBSerialNumber = coRef.deviceUSBSerialNumber;
   type = coRef.type;
   service = coRef.service;
   destinationID = coRef.destinationID;
   addressBookID = coRef.addressBookID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodStart::vDestroy()
{
   deviceUSBSerialNumber.vDestroy();
   destinationID.vDestroy();
   addressBookID.vDestroy();
}

mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodStart::mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodStart()
:deviceUSBSerialNumber()
,type()
,service()
,destinationID()
,addressBookID()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOINITIATECALLMETHODSTART;
}


mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodStart::~mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+deviceUSBSerialNumber.u32GetSize(u16MajorVersion)+destinationID.u32GetSize(u16MajorVersion)+addressBookID.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> deviceUSBSerialNumber);
   (tVoid) (oIn >> type);
   (tVoid) (oIn >> service);
   (tVoid) (oIn >> destinationID);
   (tVoid) (oIn >> addressBookID);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << deviceUSBSerialNumber);
   (tVoid) (oOut << type);
   (tVoid) (oOut << service);
   (tVoid) (oOut << destinationID);
   (tVoid) (oOut << addressBookID);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodStart::operator==(const mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (deviceUSBSerialNumber == roRef.deviceUSBSerialNumber);
   bResult = bResult && (type == roRef.type);
   bResult = bResult && (service == roRef.service);
   bResult = bResult && (destinationID == roRef.destinationID);
   bResult = bResult && (addressBookID == roRef.addressBookID);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodResult::mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodResult()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOACCEPTCALLMETHODRESULT;
}


mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodResult::~mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodStart::mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodStart(const mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   deviceUSBSerialNumber = coRef.deviceUSBSerialNumber;
   acceptAction = coRef.acceptAction;
   callUUID = coRef.callUUID;
}
mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodStart& mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodStart::operator=(const mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodStart& coRef)
{
   if (this == &coRef) return *this;
   deviceUSBSerialNumber = coRef.deviceUSBSerialNumber;
   acceptAction = coRef.acceptAction;
   callUUID = coRef.callUUID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodStart::vDestroy()
{
   deviceUSBSerialNumber.vDestroy();
   callUUID.vDestroy();
}

mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodStart::mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodStart()
:deviceUSBSerialNumber()
,acceptAction()
,callUUID()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOACCEPTCALLMETHODSTART;
}


mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodStart::~mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+deviceUSBSerialNumber.u32GetSize(u16MajorVersion)+callUUID.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> deviceUSBSerialNumber);
   (tVoid) (oIn >> acceptAction);
   (tVoid) (oIn >> callUUID);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << deviceUSBSerialNumber);
   (tVoid) (oOut << acceptAction);
   (tVoid) (oOut << callUUID);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodStart::operator==(const mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (deviceUSBSerialNumber == roRef.deviceUSBSerialNumber);
   bResult = bResult && (acceptAction == roRef.acceptAction);
   bResult = bResult && (callUUID == roRef.callUUID);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOEndCallMethodResult::mplay_appcontrolfi_tclMsgDiPOEndCallMethodResult()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOEndCallMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOENDCALLMETHODRESULT;
}


mplay_appcontrolfi_tclMsgDiPOEndCallMethodResult::~mplay_appcontrolfi_tclMsgDiPOEndCallMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOEndCallMethodStart::mplay_appcontrolfi_tclMsgDiPOEndCallMethodStart(const mplay_appcontrolfi_tclMsgDiPOEndCallMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   deviceUSBSerialNumber = coRef.deviceUSBSerialNumber;
   endAction = coRef.endAction;
   callUUID = coRef.callUUID;
}
mplay_appcontrolfi_tclMsgDiPOEndCallMethodStart& mplay_appcontrolfi_tclMsgDiPOEndCallMethodStart::operator=(const mplay_appcontrolfi_tclMsgDiPOEndCallMethodStart& coRef)
{
   if (this == &coRef) return *this;
   deviceUSBSerialNumber = coRef.deviceUSBSerialNumber;
   endAction = coRef.endAction;
   callUUID = coRef.callUUID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPOEndCallMethodStart::vDestroy()
{
   deviceUSBSerialNumber.vDestroy();
   callUUID.vDestroy();
}

mplay_appcontrolfi_tclMsgDiPOEndCallMethodStart::mplay_appcontrolfi_tclMsgDiPOEndCallMethodStart()
:deviceUSBSerialNumber()
,endAction()
,callUUID()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOEndCallMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOENDCALLMETHODSTART;
}


mplay_appcontrolfi_tclMsgDiPOEndCallMethodStart::~mplay_appcontrolfi_tclMsgDiPOEndCallMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPOEndCallMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+deviceUSBSerialNumber.u32GetSize(u16MajorVersion)+callUUID.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOEndCallMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> deviceUSBSerialNumber);
   (tVoid) (oIn >> endAction);
   (tVoid) (oIn >> callUUID);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOEndCallMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << deviceUSBSerialNumber);
   (tVoid) (oOut << endAction);
   (tVoid) (oOut << callUUID);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOEndCallMethodStart::operator==(const mplay_appcontrolfi_tclMsgDiPOEndCallMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (deviceUSBSerialNumber == roRef.deviceUSBSerialNumber);
   bResult = bResult && (endAction == roRef.endAction);
   bResult = bResult && (callUUID == roRef.callUUID);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodResult::mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodResult()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOMERGECALLSMETHODRESULT;
}


mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodResult::~mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodStart::mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodStart(const mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   deviceUSBSerialNumber = coRef.deviceUSBSerialNumber;
}
mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodStart& mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodStart::operator=(const mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   deviceUSBSerialNumber = coRef.deviceUSBSerialNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodStart::vDestroy()
{
   deviceUSBSerialNumber.vDestroy();
}

mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodStart::mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodStart()
:deviceUSBSerialNumber()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOMERGECALLSMETHODSTART;
}


mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodStart::~mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+deviceUSBSerialNumber.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> deviceUSBSerialNumber);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << deviceUSBSerialNumber);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodStart::operator==(const mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (deviceUSBSerialNumber == roRef.deviceUSBSerialNumber);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodResult::mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodResult()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOHOLDSTATUSUPDATEMETHODRESULT;
}


mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodResult::~mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodStart::mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodStart(const mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   deviceUSBSerialNumber = coRef.deviceUSBSerialNumber;
   holdStatus = coRef.holdStatus;
   callUUID = coRef.callUUID;
}
mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodStart& mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodStart::operator=(const mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   deviceUSBSerialNumber = coRef.deviceUSBSerialNumber;
   holdStatus = coRef.holdStatus;
   callUUID = coRef.callUUID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodStart::vDestroy()
{
   deviceUSBSerialNumber.vDestroy();
   callUUID.vDestroy();
}

mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodStart::mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodStart()
:deviceUSBSerialNumber()
,holdStatus(0)
,callUUID()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOHOLDSTATUSUPDATEMETHODSTART;
}


mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodStart::~mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+deviceUSBSerialNumber.u32GetSize(u16MajorVersion)+callUUID.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> deviceUSBSerialNumber);
   (tVoid) (oIn >> holdStatus);
   (tVoid) (oIn >> callUUID);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << deviceUSBSerialNumber);
   (tVoid) (oOut << holdStatus);
   (tVoid) (oOut << callUUID);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodStart::operator==(const mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (deviceUSBSerialNumber == roRef.deviceUSBSerialNumber);
   bResult = bResult && (holdStatus == roRef.holdStatus);
   bResult = bResult && (callUUID == roRef.callUUID);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodResult::mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodResult()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOMUTESTATUSUPDATEMETHODRESULT;
}


mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodResult::~mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodStart::mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodStart(const mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   deviceUSBSerialNumber = coRef.deviceUSBSerialNumber;
   muteStatus = coRef.muteStatus;
}
mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodStart& mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodStart::operator=(const mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   deviceUSBSerialNumber = coRef.deviceUSBSerialNumber;
   muteStatus = coRef.muteStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodStart::vDestroy()
{
   deviceUSBSerialNumber.vDestroy();
}

mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodStart::mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodStart()
:deviceUSBSerialNumber()
,muteStatus(0)
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOMUTESTATUSUPDATEMETHODSTART;
}


mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodStart::~mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+deviceUSBSerialNumber.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> deviceUSBSerialNumber);
   (tVoid) (oIn >> muteStatus);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << deviceUSBSerialNumber);
   (tVoid) (oOut << muteStatus);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodStart::operator==(const mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (deviceUSBSerialNumber == roRef.deviceUSBSerialNumber);
   bResult = bResult && (muteStatus == roRef.muteStatus);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodResult::mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodResult()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOSENDDTMFMETHODRESULT;
}


mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodResult::~mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodStart::mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodStart(const mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   deviceUSBSerialNumber = coRef.deviceUSBSerialNumber;
   tone = coRef.tone;
   callUUID = coRef.callUUID;
}
mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodStart& mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodStart::operator=(const mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodStart& coRef)
{
   if (this == &coRef) return *this;
   deviceUSBSerialNumber = coRef.deviceUSBSerialNumber;
   tone = coRef.tone;
   callUUID = coRef.callUUID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodStart::vDestroy()
{
   deviceUSBSerialNumber.vDestroy();
   callUUID.vDestroy();
}

mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodStart::mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodStart()
:deviceUSBSerialNumber()
,tone()
,callUUID()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOSENDDTMFMETHODSTART;
}


mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodStart::~mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+deviceUSBSerialNumber.u32GetSize(u16MajorVersion)+callUUID.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> deviceUSBSerialNumber);
   (tVoid) (oIn >> tone);
   (tVoid) (oIn >> callUUID);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << deviceUSBSerialNumber);
   (tVoid) (oOut << tone);
   (tVoid) (oOut << callUUID);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodStart::operator==(const mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (deviceUSBSerialNumber == roRef.deviceUSBSerialNumber);
   bResult = bResult && (tone == roRef.tone);
   bResult = bResult && (callUUID == roRef.callUUID);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodResult::mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodResult()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOSWAPCALLSMETHODRESULT;
}


mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodResult::~mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodStart::mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodStart(const mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   deviceUSBSerialNumber = coRef.deviceUSBSerialNumber;
}
mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodStart& mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodStart::operator=(const mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   deviceUSBSerialNumber = coRef.deviceUSBSerialNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodStart::vDestroy()
{
   deviceUSBSerialNumber.vDestroy();
}

mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodStart::mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodStart()
:deviceUSBSerialNumber()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOSWAPCALLSMETHODSTART;
}


mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodStart::~mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+deviceUSBSerialNumber.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> deviceUSBSerialNumber);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << deviceUSBSerialNumber);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodStart::operator==(const mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (deviceUSBSerialNumber == roRef.deviceUSBSerialNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodStart::mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodStart(const mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   ProductPlanUUID = coRef.ProductPlanUUID;
}
mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodStart& mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodStart::operator=(const mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ProductPlanUUID = coRef.ProductPlanUUID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodStart::vDestroy()
{
   ProductPlanUUID.vDestroy();
}

mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodStart::mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodStart()
:ProductPlanUUID()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOSETAPPLEIDENTIFICATIONINFOMETHODSTART;
}


mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodStart::~mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+ProductPlanUUID.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ProductPlanUUID);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ProductPlanUUID);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodStart::operator==(const mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ProductPlanUUID == roRef.ProductPlanUUID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodResult::mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodResult(const mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodResult& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   e8DiPOResponse = coRef.e8DiPOResponse;
}
mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodResult& mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodResult::operator=(const mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8DiPOResponse = coRef.e8DiPOResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodResult::mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodResult()
:e8DiPOResponse()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOSETAPPLEIDENTIFICATIONINFOMETHODRESULT;
}


mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodResult::~mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodResult()
{}

tU32 mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8DiPOResponse);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8DiPOResponse);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodResult::operator==(const mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8DiPOResponse == roRef.e8DiPOResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodStart::mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodStart(const mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodStart& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   bRequestAction = coRef.bRequestAction;
}
mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodStart& mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodStart::operator=(const mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bRequestAction = coRef.bRequestAction;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodStart::mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodStart()
:bRequestAction(0)
 {}

tS32 mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOREQUESTBLUETOOTHAUDIODEVICEMETHODSTART;
}


mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodStart::~mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodStart()
{}

tU32 mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bRequestAction);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bRequestAction);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodStart::operator==(const mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bRequestAction == roRef.bRequestAction);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodResult::mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodResult(const mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodResult& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   bRequestStatus = coRef.bRequestStatus;
}
mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodResult& mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodResult::operator=(const mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bRequestStatus = coRef.bRequestStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodResult::mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodResult()
:bRequestStatus(0)
 {}

tS32 mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOREQUESTBLUETOOTHAUDIODEVICEMETHODRESULT;
}


mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodResult::~mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodResult()
{}

tU32 mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bRequestStatus);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bRequestStatus);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodResult::operator==(const mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bRequestStatus == roRef.bRequestStatus);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDataResponseUpReg::mplay_appcontrolfi_tclMsgDataResponseUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDataResponseUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DATARESPONSEUPREG;
}


mplay_appcontrolfi_tclMsgDataResponseUpReg::~mplay_appcontrolfi_tclMsgDataResponseUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDataResponseRelUpReg::mplay_appcontrolfi_tclMsgDataResponseRelUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDataResponseRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DATARESPONSERELUPREG;
}


mplay_appcontrolfi_tclMsgDataResponseRelUpReg::~mplay_appcontrolfi_tclMsgDataResponseRelUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDataResponseGet::mplay_appcontrolfi_tclMsgDataResponseGet()
 {}

tS32 mplay_appcontrolfi_tclMsgDataResponseGet::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DATARESPONSEGET;
}


mplay_appcontrolfi_tclMsgDataResponseGet::~mplay_appcontrolfi_tclMsgDataResponseGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDataResponseStatus::mplay_appcontrolfi_tclMsgDataResponseStatus(const mplay_appcontrolfi_tclMsgDataResponseStatus& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   szDeviceId = coRef.szDeviceId;
   szAppName = coRef.szAppName;
   u16SessionId = coRef.u16SessionId;
   au8CommandResponseBuffer = coRef.au8CommandResponseBuffer;
}
mplay_appcontrolfi_tclMsgDataResponseStatus& mplay_appcontrolfi_tclMsgDataResponseStatus::operator=(const mplay_appcontrolfi_tclMsgDataResponseStatus& coRef)
{
   if (this == &coRef) return *this;
   szDeviceId = coRef.szDeviceId;
   szAppName = coRef.szAppName;
   u16SessionId = coRef.u16SessionId;
   au8CommandResponseBuffer = coRef.au8CommandResponseBuffer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDataResponseStatus::vDestroy()
{
   szDeviceId.vDestroy();
   szAppName.vDestroy();
   au8CommandResponseBuffer.vDestroy(); 
}

mplay_appcontrolfi_tclMsgDataResponseStatus::mplay_appcontrolfi_tclMsgDataResponseStatus()
:szDeviceId()
,szAppName()
,u16SessionId(0)
,au8CommandResponseBuffer()
 {}

tS32 mplay_appcontrolfi_tclMsgDataResponseStatus::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DATARESPONSESTATUS;
}


mplay_appcontrolfi_tclMsgDataResponseStatus::~mplay_appcontrolfi_tclMsgDataResponseStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDataResponseStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+szDeviceId.u32GetSize(u16MajorVersion)+szAppName.u32GetSize(u16MajorVersion)+au8CommandResponseBuffer.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDataResponseStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szDeviceId);
   (tVoid) (oIn >> szAppName);
   (tVoid) (oIn >> u16SessionId);
   (tVoid) (oIn >> au8CommandResponseBuffer);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDataResponseStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szDeviceId);
   (tVoid) (oOut << szAppName);
   (tVoid) (oOut << u16SessionId);
   (tVoid) (oOut << au8CommandResponseBuffer);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDataResponseStatus::operator==(const mplay_appcontrolfi_tclMsgDataResponseStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szDeviceId == roRef.szDeviceId);
   bResult = bResult && (szAppName == roRef.szAppName);
   bResult = bResult && (u16SessionId == roRef.u16SessionId);
   bResult = bResult && (au8CommandResponseBuffer == roRef.au8CommandResponseBuffer);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgSessionOpenedUpReg::mplay_appcontrolfi_tclMsgSessionOpenedUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgSessionOpenedUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_SESSIONOPENEDUPREG;
}


mplay_appcontrolfi_tclMsgSessionOpenedUpReg::~mplay_appcontrolfi_tclMsgSessionOpenedUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgSessionOpenedRelUpReg::mplay_appcontrolfi_tclMsgSessionOpenedRelUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgSessionOpenedRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_SESSIONOPENEDRELUPREG;
}


mplay_appcontrolfi_tclMsgSessionOpenedRelUpReg::~mplay_appcontrolfi_tclMsgSessionOpenedRelUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgSessionOpenedGet::mplay_appcontrolfi_tclMsgSessionOpenedGet()
 {}

tS32 mplay_appcontrolfi_tclMsgSessionOpenedGet::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_SESSIONOPENEDGET;
}


mplay_appcontrolfi_tclMsgSessionOpenedGet::~mplay_appcontrolfi_tclMsgSessionOpenedGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgSessionOpenedStatus::mplay_appcontrolfi_tclMsgSessionOpenedStatus(const mplay_appcontrolfi_tclMsgSessionOpenedStatus& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   szDeviceId = coRef.szDeviceId;
   szAppName = coRef.szAppName;
   u16SessionId = coRef.u16SessionId;
   szProtocolName = coRef.szProtocolName;
}
mplay_appcontrolfi_tclMsgSessionOpenedStatus& mplay_appcontrolfi_tclMsgSessionOpenedStatus::operator=(const mplay_appcontrolfi_tclMsgSessionOpenedStatus& coRef)
{
   if (this == &coRef) return *this;
   szDeviceId = coRef.szDeviceId;
   szAppName = coRef.szAppName;
   u16SessionId = coRef.u16SessionId;
   szProtocolName = coRef.szProtocolName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgSessionOpenedStatus::vDestroy()
{
   szDeviceId.vDestroy();
   szAppName.vDestroy();
   szProtocolName.vDestroy();
}

mplay_appcontrolfi_tclMsgSessionOpenedStatus::mplay_appcontrolfi_tclMsgSessionOpenedStatus()
:szDeviceId()
,szAppName()
,u16SessionId(0)
,szProtocolName()
 {}

tS32 mplay_appcontrolfi_tclMsgSessionOpenedStatus::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_SESSIONOPENEDSTATUS;
}


mplay_appcontrolfi_tclMsgSessionOpenedStatus::~mplay_appcontrolfi_tclMsgSessionOpenedStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgSessionOpenedStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+szDeviceId.u32GetSize(u16MajorVersion)+szAppName.u32GetSize(u16MajorVersion)+szProtocolName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgSessionOpenedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szDeviceId);
   (tVoid) (oIn >> szAppName);
   (tVoid) (oIn >> u16SessionId);
   (tVoid) (oIn >> szProtocolName);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgSessionOpenedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szDeviceId);
   (tVoid) (oOut << szAppName);
   (tVoid) (oOut << u16SessionId);
   (tVoid) (oOut << szProtocolName);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgSessionOpenedStatus::operator==(const mplay_appcontrolfi_tclMsgSessionOpenedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szDeviceId == roRef.szDeviceId);
   bResult = bResult && (szAppName == roRef.szAppName);
   bResult = bResult && (u16SessionId == roRef.u16SessionId);
   bResult = bResult && (szProtocolName == roRef.szProtocolName);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgSessionClosedUpReg::mplay_appcontrolfi_tclMsgSessionClosedUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgSessionClosedUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_SESSIONCLOSEDUPREG;
}


mplay_appcontrolfi_tclMsgSessionClosedUpReg::~mplay_appcontrolfi_tclMsgSessionClosedUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgSessionClosedRelUpReg::mplay_appcontrolfi_tclMsgSessionClosedRelUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgSessionClosedRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_SESSIONCLOSEDRELUPREG;
}


mplay_appcontrolfi_tclMsgSessionClosedRelUpReg::~mplay_appcontrolfi_tclMsgSessionClosedRelUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgSessionClosedGet::mplay_appcontrolfi_tclMsgSessionClosedGet()
 {}

tS32 mplay_appcontrolfi_tclMsgSessionClosedGet::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_SESSIONCLOSEDGET;
}


mplay_appcontrolfi_tclMsgSessionClosedGet::~mplay_appcontrolfi_tclMsgSessionClosedGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgSessionClosedStatus::mplay_appcontrolfi_tclMsgSessionClosedStatus(const mplay_appcontrolfi_tclMsgSessionClosedStatus& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   szDeviceId = coRef.szDeviceId;
   szAppName = coRef.szAppName;
   u16SessionId = coRef.u16SessionId;
}
mplay_appcontrolfi_tclMsgSessionClosedStatus& mplay_appcontrolfi_tclMsgSessionClosedStatus::operator=(const mplay_appcontrolfi_tclMsgSessionClosedStatus& coRef)
{
   if (this == &coRef) return *this;
   szDeviceId = coRef.szDeviceId;
   szAppName = coRef.szAppName;
   u16SessionId = coRef.u16SessionId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgSessionClosedStatus::vDestroy()
{
   szDeviceId.vDestroy();
   szAppName.vDestroy();
}

mplay_appcontrolfi_tclMsgSessionClosedStatus::mplay_appcontrolfi_tclMsgSessionClosedStatus()
:szDeviceId()
,szAppName()
,u16SessionId(0)
 {}

tS32 mplay_appcontrolfi_tclMsgSessionClosedStatus::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_SESSIONCLOSEDSTATUS;
}


mplay_appcontrolfi_tclMsgSessionClosedStatus::~mplay_appcontrolfi_tclMsgSessionClosedStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgSessionClosedStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+szDeviceId.u32GetSize(u16MajorVersion)+szAppName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgSessionClosedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szDeviceId);
   (tVoid) (oIn >> szAppName);
   (tVoid) (oIn >> u16SessionId);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgSessionClosedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szDeviceId);
   (tVoid) (oOut << szAppName);
   (tVoid) (oOut << u16SessionId);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgSessionClosedStatus::operator==(const mplay_appcontrolfi_tclMsgSessionClosedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szDeviceId == roRef.szDeviceId);
   bResult = bResult && (szAppName == roRef.szAppName);
   bResult = bResult && (u16SessionId == roRef.u16SessionId);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPODeviceConnectionsUpReg::mplay_appcontrolfi_tclMsgDiPODeviceConnectionsUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPODeviceConnectionsUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPODEVICECONNECTIONSUPREG;
}


mplay_appcontrolfi_tclMsgDiPODeviceConnectionsUpReg::~mplay_appcontrolfi_tclMsgDiPODeviceConnectionsUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPODeviceConnectionsRelUpReg::mplay_appcontrolfi_tclMsgDiPODeviceConnectionsRelUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPODeviceConnectionsRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPODEVICECONNECTIONSRELUPREG;
}


mplay_appcontrolfi_tclMsgDiPODeviceConnectionsRelUpReg::~mplay_appcontrolfi_tclMsgDiPODeviceConnectionsRelUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPODeviceConnectionsGet::mplay_appcontrolfi_tclMsgDiPODeviceConnectionsGet()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPODeviceConnectionsGet::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPODEVICECONNECTIONSGET;
}


mplay_appcontrolfi_tclMsgDiPODeviceConnectionsGet::~mplay_appcontrolfi_tclMsgDiPODeviceConnectionsGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus::mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus(const mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   oDeviceInfo = coRef.oDeviceInfo;
}
mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus& mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus::operator=(const mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus& coRef)
{
   if (this == &coRef) return *this;
   oDeviceInfo = coRef.oDeviceInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus::vDestroy()
{
   oDeviceInfo.vDestroy(); 
}

mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus::mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus()
:oDeviceInfo()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPODEVICECONNECTIONSSTATUS;
}


mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus::~mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+oDeviceInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oDeviceInfo);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oDeviceInfo);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus::operator==(const mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oDeviceInfo == roRef.oDeviceInfo);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOPlaytimeUpReg::mplay_appcontrolfi_tclMsgDiPOPlaytimeUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOPlaytimeUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYTIMEUPREG;
}


mplay_appcontrolfi_tclMsgDiPOPlaytimeUpReg::~mplay_appcontrolfi_tclMsgDiPOPlaytimeUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOPlaytimeRelUpReg::mplay_appcontrolfi_tclMsgDiPOPlaytimeRelUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOPlaytimeRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYTIMERELUPREG;
}


mplay_appcontrolfi_tclMsgDiPOPlaytimeRelUpReg::~mplay_appcontrolfi_tclMsgDiPOPlaytimeRelUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOPlaytimeGet::mplay_appcontrolfi_tclMsgDiPOPlaytimeGet()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOPlaytimeGet::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYTIMEGET;
}


mplay_appcontrolfi_tclMsgDiPOPlaytimeGet::~mplay_appcontrolfi_tclMsgDiPOPlaytimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOPlaytimeStatus::mplay_appcontrolfi_tclMsgDiPOPlaytimeStatus(const mplay_appcontrolfi_tclMsgDiPOPlaytimeStatus& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   u8DeviceId = coRef.u8DeviceId;
   u32ElapsedPlaytime = coRef.u32ElapsedPlaytime;
   u32TotalPlaytime = coRef.u32TotalPlaytime;
}
mplay_appcontrolfi_tclMsgDiPOPlaytimeStatus& mplay_appcontrolfi_tclMsgDiPOPlaytimeStatus::operator=(const mplay_appcontrolfi_tclMsgDiPOPlaytimeStatus& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceId = coRef.u8DeviceId;
   u32ElapsedPlaytime = coRef.u32ElapsedPlaytime;
   u32TotalPlaytime = coRef.u32TotalPlaytime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_appcontrolfi_tclMsgDiPOPlaytimeStatus::mplay_appcontrolfi_tclMsgDiPOPlaytimeStatus()
:u8DeviceId(0)
,u32ElapsedPlaytime(0)
,u32TotalPlaytime(0)
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOPlaytimeStatus::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYTIMESTATUS;
}


mplay_appcontrolfi_tclMsgDiPOPlaytimeStatus::~mplay_appcontrolfi_tclMsgDiPOPlaytimeStatus()
{}

tU32 mplay_appcontrolfi_tclMsgDiPOPlaytimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOPlaytimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceId);
   (tVoid) (oIn >> u32ElapsedPlaytime);
   (tVoid) (oIn >> u32TotalPlaytime);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOPlaytimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceId);
   (tVoid) (oOut << u32ElapsedPlaytime);
   (tVoid) (oOut << u32TotalPlaytime);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOPlaytimeStatus::operator==(const mplay_appcontrolfi_tclMsgDiPOPlaytimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceId == roRef.u8DeviceId);
   bResult = bResult && (u32ElapsedPlaytime == roRef.u32ElapsedPlaytime);
   bResult = bResult && (u32TotalPlaytime == roRef.u32TotalPlaytime);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOLocationInfoUpReg::mplay_appcontrolfi_tclMsgDiPOLocationInfoUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOLocationInfoUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOLOCATIONINFOUPREG;
}


mplay_appcontrolfi_tclMsgDiPOLocationInfoUpReg::~mplay_appcontrolfi_tclMsgDiPOLocationInfoUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOLocationInfoRelUpReg::mplay_appcontrolfi_tclMsgDiPOLocationInfoRelUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOLocationInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOLOCATIONINFORELUPREG;
}


mplay_appcontrolfi_tclMsgDiPOLocationInfoRelUpReg::~mplay_appcontrolfi_tclMsgDiPOLocationInfoRelUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOLocationInfoGet::mplay_appcontrolfi_tclMsgDiPOLocationInfoGet()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOLocationInfoGet::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOLOCATIONINFOGET;
}


mplay_appcontrolfi_tclMsgDiPOLocationInfoGet::~mplay_appcontrolfi_tclMsgDiPOLocationInfoGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOLocationInfoStatus::mplay_appcontrolfi_tclMsgDiPOLocationInfoStatus(const mplay_appcontrolfi_tclMsgDiPOLocationInfoStatus& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   bStartStopLocationInfo = coRef.bStartStopLocationInfo;
   b8LocationInfoType = coRef.b8LocationInfoType;
}
mplay_appcontrolfi_tclMsgDiPOLocationInfoStatus& mplay_appcontrolfi_tclMsgDiPOLocationInfoStatus::operator=(const mplay_appcontrolfi_tclMsgDiPOLocationInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   bStartStopLocationInfo = coRef.bStartStopLocationInfo;
   b8LocationInfoType = coRef.b8LocationInfoType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_appcontrolfi_tclMsgDiPOLocationInfoStatus::mplay_appcontrolfi_tclMsgDiPOLocationInfoStatus()
:bStartStopLocationInfo(0)
,b8LocationInfoType()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOLocationInfoStatus::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOLOCATIONINFOSTATUS;
}


mplay_appcontrolfi_tclMsgDiPOLocationInfoStatus::~mplay_appcontrolfi_tclMsgDiPOLocationInfoStatus()
{}

tU32 mplay_appcontrolfi_tclMsgDiPOLocationInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOLocationInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bStartStopLocationInfo);
   (tVoid) (oIn >> b8LocationInfoType);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOLocationInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bStartStopLocationInfo);
   (tVoid) (oOut << b8LocationInfoType);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOLocationInfoStatus::operator==(const mplay_appcontrolfi_tclMsgDiPOLocationInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bStartStopLocationInfo == roRef.bStartStopLocationInfo);
   bResult = bResult && (b8LocationInfoType == roRef.b8LocationInfoType);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOMetaDataUpReg::mplay_appcontrolfi_tclMsgDiPOMetaDataUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOMetaDataUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOMETADATAUPREG;
}


mplay_appcontrolfi_tclMsgDiPOMetaDataUpReg::~mplay_appcontrolfi_tclMsgDiPOMetaDataUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOMetaDataRelUpReg::mplay_appcontrolfi_tclMsgDiPOMetaDataRelUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOMetaDataRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOMETADATARELUPREG;
}


mplay_appcontrolfi_tclMsgDiPOMetaDataRelUpReg::~mplay_appcontrolfi_tclMsgDiPOMetaDataRelUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOMetaDataGet::mplay_appcontrolfi_tclMsgDiPOMetaDataGet()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOMetaDataGet::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOMETADATAGET;
}


mplay_appcontrolfi_tclMsgDiPOMetaDataGet::~mplay_appcontrolfi_tclMsgDiPOMetaDataGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOMetaDataStatus::mplay_appcontrolfi_tclMsgDiPOMetaDataStatus(const mplay_appcontrolfi_tclMsgDiPOMetaDataStatus& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   u8DeviceId = coRef.u8DeviceId;
   sArtist = coRef.sArtist;
   sTitle = coRef.sTitle;
   sAlbum = coRef.sAlbum;
   sGenre = coRef.sGenre;
   sAlbumArt = coRef.sAlbumArt;
   sAppName = coRef.sAppName;
}
mplay_appcontrolfi_tclMsgDiPOMetaDataStatus& mplay_appcontrolfi_tclMsgDiPOMetaDataStatus::operator=(const mplay_appcontrolfi_tclMsgDiPOMetaDataStatus& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceId = coRef.u8DeviceId;
   sArtist = coRef.sArtist;
   sTitle = coRef.sTitle;
   sAlbum = coRef.sAlbum;
   sGenre = coRef.sGenre;
   sAlbumArt = coRef.sAlbumArt;
   sAppName = coRef.sAppName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPOMetaDataStatus::vDestroy()
{
   sArtist.vDestroy();
   sTitle.vDestroy();
   sAlbum.vDestroy();
   sGenre.vDestroy();
   sAlbumArt.vDestroy();
   sAppName.vDestroy();
}

mplay_appcontrolfi_tclMsgDiPOMetaDataStatus::mplay_appcontrolfi_tclMsgDiPOMetaDataStatus()
:u8DeviceId(0)
,sArtist()
,sTitle()
,sAlbum()
,sGenre()
,sAlbumArt()
,sAppName()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOMetaDataStatus::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOMETADATASTATUS;
}


mplay_appcontrolfi_tclMsgDiPOMetaDataStatus::~mplay_appcontrolfi_tclMsgDiPOMetaDataStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPOMetaDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sArtist.u32GetSize(u16MajorVersion)+sTitle.u32GetSize(u16MajorVersion)+sAlbum.u32GetSize(u16MajorVersion)+sGenre.u32GetSize(u16MajorVersion)+sAlbumArt.u32GetSize(u16MajorVersion)+sAppName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOMetaDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceId);
   (tVoid) (oIn >> sArtist);
   (tVoid) (oIn >> sTitle);
   (tVoid) (oIn >> sAlbum);
   (tVoid) (oIn >> sGenre);
   (tVoid) (oIn >> sAlbumArt);
   (tVoid) (oIn >> sAppName);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOMetaDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceId);
   (tVoid) (oOut << sArtist);
   (tVoid) (oOut << sTitle);
   (tVoid) (oOut << sAlbum);
   (tVoid) (oOut << sGenre);
   (tVoid) (oOut << sAlbumArt);
   (tVoid) (oOut << sAppName);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOMetaDataStatus::operator==(const mplay_appcontrolfi_tclMsgDiPOMetaDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceId == roRef.u8DeviceId);
   bResult = bResult && (sArtist == roRef.sArtist);
   bResult = bResult && (sTitle == roRef.sTitle);
   bResult = bResult && (sAlbum == roRef.sAlbum);
   bResult = bResult && (sGenre == roRef.sGenre);
   bResult = bResult && (sAlbumArt == roRef.sAlbumArt);
   bResult = bResult && (sAppName == roRef.sAppName);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOPhoneDataUpReg::mplay_appcontrolfi_tclMsgDiPOPhoneDataUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOPhoneDataUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOPHONEDATAUPREG;
}


mplay_appcontrolfi_tclMsgDiPOPhoneDataUpReg::~mplay_appcontrolfi_tclMsgDiPOPhoneDataUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOPhoneDataRelUpReg::mplay_appcontrolfi_tclMsgDiPOPhoneDataRelUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOPhoneDataRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOPHONEDATARELUPREG;
}


mplay_appcontrolfi_tclMsgDiPOPhoneDataRelUpReg::~mplay_appcontrolfi_tclMsgDiPOPhoneDataRelUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOPhoneDataGet::mplay_appcontrolfi_tclMsgDiPOPhoneDataGet()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOPhoneDataGet::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOPHONEDATAGET;
}


mplay_appcontrolfi_tclMsgDiPOPhoneDataGet::~mplay_appcontrolfi_tclMsgDiPOPhoneDataGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOPhoneDataStatus::mplay_appcontrolfi_tclMsgDiPOPhoneDataStatus(const mplay_appcontrolfi_tclMsgDiPOPhoneDataStatus& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   sPhoneCaller = coRef.sPhoneCaller;
   sPhoneCallInfo = coRef.sPhoneCallInfo;
}
mplay_appcontrolfi_tclMsgDiPOPhoneDataStatus& mplay_appcontrolfi_tclMsgDiPOPhoneDataStatus::operator=(const mplay_appcontrolfi_tclMsgDiPOPhoneDataStatus& coRef)
{
   if (this == &coRef) return *this;
   sPhoneCaller = coRef.sPhoneCaller;
   sPhoneCallInfo = coRef.sPhoneCallInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPOPhoneDataStatus::vDestroy()
{
   sPhoneCaller.vDestroy();
   sPhoneCallInfo.vDestroy();
}

mplay_appcontrolfi_tclMsgDiPOPhoneDataStatus::mplay_appcontrolfi_tclMsgDiPOPhoneDataStatus()
:sPhoneCaller()
,sPhoneCallInfo()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOPhoneDataStatus::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOPHONEDATASTATUS;
}


mplay_appcontrolfi_tclMsgDiPOPhoneDataStatus::~mplay_appcontrolfi_tclMsgDiPOPhoneDataStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPOPhoneDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+sPhoneCaller.u32GetSize(u16MajorVersion)+sPhoneCallInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOPhoneDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sPhoneCaller);
   (tVoid) (oIn >> sPhoneCallInfo);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOPhoneDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sPhoneCaller);
   (tVoid) (oOut << sPhoneCallInfo);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOPhoneDataStatus::operator==(const mplay_appcontrolfi_tclMsgDiPOPhoneDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sPhoneCaller == roRef.sPhoneCaller);
   bResult = bResult && (sPhoneCallInfo == roRef.sPhoneCallInfo);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgNativeTransportStartUpReg::mplay_appcontrolfi_tclMsgNativeTransportStartUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgNativeTransportStartUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_NATIVETRANSPORTSTARTUPREG;
}


mplay_appcontrolfi_tclMsgNativeTransportStartUpReg::~mplay_appcontrolfi_tclMsgNativeTransportStartUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgNativeTransportStartRelUpReg::mplay_appcontrolfi_tclMsgNativeTransportStartRelUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgNativeTransportStartRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_NATIVETRANSPORTSTARTRELUPREG;
}


mplay_appcontrolfi_tclMsgNativeTransportStartRelUpReg::~mplay_appcontrolfi_tclMsgNativeTransportStartRelUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgNativeTransportStartGet::mplay_appcontrolfi_tclMsgNativeTransportStartGet()
 {}

tS32 mplay_appcontrolfi_tclMsgNativeTransportStartGet::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_NATIVETRANSPORTSTARTGET;
}


mplay_appcontrolfi_tclMsgNativeTransportStartGet::~mplay_appcontrolfi_tclMsgNativeTransportStartGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgNativeTransportStartStatus::mplay_appcontrolfi_tclMsgNativeTransportStartStatus(const mplay_appcontrolfi_tclMsgNativeTransportStartStatus& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   u32DeviceId = coRef.u32DeviceId;
   u8IAP2iOSAppIdentifier = coRef.u8IAP2iOSAppIdentifier;
   u8SinkEndpoint = coRef.u8SinkEndpoint;
   u8SourceEndpoint = coRef.u8SourceEndpoint;
}
mplay_appcontrolfi_tclMsgNativeTransportStartStatus& mplay_appcontrolfi_tclMsgNativeTransportStartStatus::operator=(const mplay_appcontrolfi_tclMsgNativeTransportStartStatus& coRef)
{
   if (this == &coRef) return *this;
   u32DeviceId = coRef.u32DeviceId;
   u8IAP2iOSAppIdentifier = coRef.u8IAP2iOSAppIdentifier;
   u8SinkEndpoint = coRef.u8SinkEndpoint;
   u8SourceEndpoint = coRef.u8SourceEndpoint;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_appcontrolfi_tclMsgNativeTransportStartStatus::mplay_appcontrolfi_tclMsgNativeTransportStartStatus()
:u32DeviceId(0)
,u8IAP2iOSAppIdentifier(0)
,u8SinkEndpoint(0)
,u8SourceEndpoint(0)
 {}

tS32 mplay_appcontrolfi_tclMsgNativeTransportStartStatus::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_NATIVETRANSPORTSTARTSTATUS;
}


mplay_appcontrolfi_tclMsgNativeTransportStartStatus::~mplay_appcontrolfi_tclMsgNativeTransportStartStatus()
{}

tU32 mplay_appcontrolfi_tclMsgNativeTransportStartStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& mplay_appcontrolfi_tclMsgNativeTransportStartStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32DeviceId);
   (tVoid) (oIn >> u8IAP2iOSAppIdentifier);
   (tVoid) (oIn >> u8SinkEndpoint);
   (tVoid) (oIn >> u8SourceEndpoint);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgNativeTransportStartStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32DeviceId);
   (tVoid) (oOut << u8IAP2iOSAppIdentifier);
   (tVoid) (oOut << u8SinkEndpoint);
   (tVoid) (oOut << u8SourceEndpoint);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgNativeTransportStartStatus::operator==(const mplay_appcontrolfi_tclMsgNativeTransportStartStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32DeviceId == roRef.u32DeviceId);
   bResult = bResult && (u8IAP2iOSAppIdentifier == roRef.u8IAP2iOSAppIdentifier);
   bResult = bResult && (u8SinkEndpoint == roRef.u8SinkEndpoint);
   bResult = bResult && (u8SourceEndpoint == roRef.u8SourceEndpoint);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgNativeTransportStopUpReg::mplay_appcontrolfi_tclMsgNativeTransportStopUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgNativeTransportStopUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_NATIVETRANSPORTSTOPUPREG;
}


mplay_appcontrolfi_tclMsgNativeTransportStopUpReg::~mplay_appcontrolfi_tclMsgNativeTransportStopUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgNativeTransportStopRelUpReg::mplay_appcontrolfi_tclMsgNativeTransportStopRelUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgNativeTransportStopRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_NATIVETRANSPORTSTOPRELUPREG;
}


mplay_appcontrolfi_tclMsgNativeTransportStopRelUpReg::~mplay_appcontrolfi_tclMsgNativeTransportStopRelUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgNativeTransportStopGet::mplay_appcontrolfi_tclMsgNativeTransportStopGet()
 {}

tS32 mplay_appcontrolfi_tclMsgNativeTransportStopGet::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_NATIVETRANSPORTSTOPGET;
}


mplay_appcontrolfi_tclMsgNativeTransportStopGet::~mplay_appcontrolfi_tclMsgNativeTransportStopGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgNativeTransportStopStatus::mplay_appcontrolfi_tclMsgNativeTransportStopStatus(const mplay_appcontrolfi_tclMsgNativeTransportStopStatus& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   u32DeviceId = coRef.u32DeviceId;
   u8IAP2iOSAppIdentifier = coRef.u8IAP2iOSAppIdentifier;
   u8SinkEndpoint = coRef.u8SinkEndpoint;
   u8SourceEndpoint = coRef.u8SourceEndpoint;
}
mplay_appcontrolfi_tclMsgNativeTransportStopStatus& mplay_appcontrolfi_tclMsgNativeTransportStopStatus::operator=(const mplay_appcontrolfi_tclMsgNativeTransportStopStatus& coRef)
{
   if (this == &coRef) return *this;
   u32DeviceId = coRef.u32DeviceId;
   u8IAP2iOSAppIdentifier = coRef.u8IAP2iOSAppIdentifier;
   u8SinkEndpoint = coRef.u8SinkEndpoint;
   u8SourceEndpoint = coRef.u8SourceEndpoint;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_appcontrolfi_tclMsgNativeTransportStopStatus::mplay_appcontrolfi_tclMsgNativeTransportStopStatus()
:u32DeviceId(0)
,u8IAP2iOSAppIdentifier(0)
,u8SinkEndpoint(0)
,u8SourceEndpoint(0)
 {}

tS32 mplay_appcontrolfi_tclMsgNativeTransportStopStatus::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_NATIVETRANSPORTSTOPSTATUS;
}


mplay_appcontrolfi_tclMsgNativeTransportStopStatus::~mplay_appcontrolfi_tclMsgNativeTransportStopStatus()
{}

tU32 mplay_appcontrolfi_tclMsgNativeTransportStopStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& mplay_appcontrolfi_tclMsgNativeTransportStopStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32DeviceId);
   (tVoid) (oIn >> u8IAP2iOSAppIdentifier);
   (tVoid) (oIn >> u8SinkEndpoint);
   (tVoid) (oIn >> u8SourceEndpoint);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgNativeTransportStopStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32DeviceId);
   (tVoid) (oOut << u8IAP2iOSAppIdentifier);
   (tVoid) (oOut << u8SinkEndpoint);
   (tVoid) (oOut << u8SourceEndpoint);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgNativeTransportStopStatus::operator==(const mplay_appcontrolfi_tclMsgNativeTransportStopStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32DeviceId == roRef.u32DeviceId);
   bResult = bResult && (u8IAP2iOSAppIdentifier == roRef.u8IAP2iOSAppIdentifier);
   bResult = bResult && (u8SinkEndpoint == roRef.u8SinkEndpoint);
   bResult = bResult && (u8SourceEndpoint == roRef.u8SourceEndpoint);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesUpReg::mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_CONNECTEDBLUETOOTHPROFILESUPREG;
}


mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesUpReg::~mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesRelUpReg::mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesRelUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_CONNECTEDBLUETOOTHPROFILESRELUPREG;
}


mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesRelUpReg::~mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesRelUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesGet::mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesGet()
 {}

tS32 mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesGet::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_CONNECTEDBLUETOOTHPROFILESGET;
}


mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesGet::~mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesStatus::mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesStatus(const mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesStatus& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   oBTProfileInfo = coRef.oBTProfileInfo;
}
mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesStatus& mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesStatus::operator=(const mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesStatus& coRef)
{
   if (this == &coRef) return *this;
   oBTProfileInfo = coRef.oBTProfileInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesStatus::vDestroy()
{
   oBTProfileInfo.vDestroy(); 
}

mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesStatus::mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesStatus()
:oBTProfileInfo()
 {}

tS32 mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesStatus::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_CONNECTEDBLUETOOTHPROFILESSTATUS;
}


mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesStatus::~mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+oBTProfileInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oBTProfileInfo);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oBTProfileInfo);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesStatus::operator==(const mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oBTProfileInfo == roRef.oBTProfileInfo);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPONowPlayingUpReg::mplay_appcontrolfi_tclMsgDiPONowPlayingUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPONowPlayingUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPONOWPLAYINGUPREG;
}


mplay_appcontrolfi_tclMsgDiPONowPlayingUpReg::~mplay_appcontrolfi_tclMsgDiPONowPlayingUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPONowPlayingRelUpReg::mplay_appcontrolfi_tclMsgDiPONowPlayingRelUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPONowPlayingRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPONOWPLAYINGRELUPREG;
}


mplay_appcontrolfi_tclMsgDiPONowPlayingRelUpReg::~mplay_appcontrolfi_tclMsgDiPONowPlayingRelUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPONowPlayingGet::mplay_appcontrolfi_tclMsgDiPONowPlayingGet()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPONowPlayingGet::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPONOWPLAYINGGET;
}


mplay_appcontrolfi_tclMsgDiPONowPlayingGet::~mplay_appcontrolfi_tclMsgDiPONowPlayingGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPONowPlayingStatus::mplay_appcontrolfi_tclMsgDiPONowPlayingStatus(const mplay_appcontrolfi_tclMsgDiPONowPlayingStatus& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   u8DeviceId = coRef.u8DeviceId;
   sTitle = coRef.sTitle;
   sArtist = coRef.sArtist;
   sAlbum = coRef.sAlbum;
   sGenre = coRef.sGenre;
   sComposer = coRef.sComposer;
   sAlbumArt = coRef.sAlbumArt;
   sAppName = coRef.sAppName;
   u16AlbumTrackNumber = coRef.u16AlbumTrackNumber;
   u16AlbumTrackCount = coRef.u16AlbumTrackCount;
   u16AlbumDiscNumber = coRef.u16AlbumDiscNumber;
   u16AlbumDiscCount = coRef.u16AlbumDiscCount;
   u16ChapterCount = coRef.u16ChapterCount;
   u32QueueIndex = coRef.u32QueueIndex;
   u32QueueCount = coRef.u32QueueCount;
   u32QueueChapterIndex = coRef.u32QueueChapterIndex;
   biTunesRadioAd = coRef.biTunesRadioAd;
   siTunesRadioStationName = coRef.siTunesRadioStationName;
}
mplay_appcontrolfi_tclMsgDiPONowPlayingStatus& mplay_appcontrolfi_tclMsgDiPONowPlayingStatus::operator=(const mplay_appcontrolfi_tclMsgDiPONowPlayingStatus& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceId = coRef.u8DeviceId;
   sTitle = coRef.sTitle;
   sArtist = coRef.sArtist;
   sAlbum = coRef.sAlbum;
   sGenre = coRef.sGenre;
   sComposer = coRef.sComposer;
   sAlbumArt = coRef.sAlbumArt;
   sAppName = coRef.sAppName;
   u16AlbumTrackNumber = coRef.u16AlbumTrackNumber;
   u16AlbumTrackCount = coRef.u16AlbumTrackCount;
   u16AlbumDiscNumber = coRef.u16AlbumDiscNumber;
   u16AlbumDiscCount = coRef.u16AlbumDiscCount;
   u16ChapterCount = coRef.u16ChapterCount;
   u32QueueIndex = coRef.u32QueueIndex;
   u32QueueCount = coRef.u32QueueCount;
   u32QueueChapterIndex = coRef.u32QueueChapterIndex;
   biTunesRadioAd = coRef.biTunesRadioAd;
   siTunesRadioStationName = coRef.siTunesRadioStationName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPONowPlayingStatus::vDestroy()
{
   sTitle.vDestroy();
   sArtist.vDestroy();
   sAlbum.vDestroy();
   sGenre.vDestroy();
   sComposer.vDestroy();
   sAlbumArt.vDestroy();
   sAppName.vDestroy();
   siTunesRadioStationName.vDestroy();
}

mplay_appcontrolfi_tclMsgDiPONowPlayingStatus::mplay_appcontrolfi_tclMsgDiPONowPlayingStatus()
:u8DeviceId(0)
,sTitle()
,sArtist()
,sAlbum()
,sGenre()
,sComposer()
,sAlbumArt()
,sAppName()
,u16AlbumTrackNumber(0)
,u16AlbumTrackCount(0)
,u16AlbumDiscNumber(0)
,u16AlbumDiscCount(0)
,u16ChapterCount(0)
,u32QueueIndex(0)
,u32QueueCount(0)
,u32QueueChapterIndex(0)
,biTunesRadioAd(0)
,siTunesRadioStationName()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPONowPlayingStatus::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPONOWPLAYINGSTATUS;
}


mplay_appcontrolfi_tclMsgDiPONowPlayingStatus::~mplay_appcontrolfi_tclMsgDiPONowPlayingStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPONowPlayingStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 24+sTitle.u32GetSize(u16MajorVersion)+sArtist.u32GetSize(u16MajorVersion)+sAlbum.u32GetSize(u16MajorVersion)+sGenre.u32GetSize(u16MajorVersion)+sComposer.u32GetSize(u16MajorVersion)+sAlbumArt.u32GetSize(u16MajorVersion)+sAppName.u32GetSize(u16MajorVersion)+siTunesRadioStationName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPONowPlayingStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceId);
   (tVoid) (oIn >> sTitle);
   (tVoid) (oIn >> sArtist);
   (tVoid) (oIn >> sAlbum);
   (tVoid) (oIn >> sGenre);
   (tVoid) (oIn >> sComposer);
   (tVoid) (oIn >> sAlbumArt);
   (tVoid) (oIn >> sAppName);
   (tVoid) (oIn >> u16AlbumTrackNumber);
   (tVoid) (oIn >> u16AlbumTrackCount);
   (tVoid) (oIn >> u16AlbumDiscNumber);
   (tVoid) (oIn >> u16AlbumDiscCount);
   (tVoid) (oIn >> u16ChapterCount);
   (tVoid) (oIn >> u32QueueIndex);
   (tVoid) (oIn >> u32QueueCount);
   (tVoid) (oIn >> u32QueueChapterIndex);
   (tVoid) (oIn >> biTunesRadioAd);
   (tVoid) (oIn >> siTunesRadioStationName);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPONowPlayingStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceId);
   (tVoid) (oOut << sTitle);
   (tVoid) (oOut << sArtist);
   (tVoid) (oOut << sAlbum);
   (tVoid) (oOut << sGenre);
   (tVoid) (oOut << sComposer);
   (tVoid) (oOut << sAlbumArt);
   (tVoid) (oOut << sAppName);
   (tVoid) (oOut << u16AlbumTrackNumber);
   (tVoid) (oOut << u16AlbumTrackCount);
   (tVoid) (oOut << u16AlbumDiscNumber);
   (tVoid) (oOut << u16AlbumDiscCount);
   (tVoid) (oOut << u16ChapterCount);
   (tVoid) (oOut << u32QueueIndex);
   (tVoid) (oOut << u32QueueCount);
   (tVoid) (oOut << u32QueueChapterIndex);
   (tVoid) (oOut << biTunesRadioAd);
   (tVoid) (oOut << siTunesRadioStationName);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPONowPlayingStatus::operator==(const mplay_appcontrolfi_tclMsgDiPONowPlayingStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceId == roRef.u8DeviceId);
   bResult = bResult && (sTitle == roRef.sTitle);
   bResult = bResult && (sArtist == roRef.sArtist);
   bResult = bResult && (sAlbum == roRef.sAlbum);
   bResult = bResult && (sGenre == roRef.sGenre);
   bResult = bResult && (sComposer == roRef.sComposer);
   bResult = bResult && (sAlbumArt == roRef.sAlbumArt);
   bResult = bResult && (sAppName == roRef.sAppName);
   bResult = bResult && (u16AlbumTrackNumber == roRef.u16AlbumTrackNumber);
   bResult = bResult && (u16AlbumTrackCount == roRef.u16AlbumTrackCount);
   bResult = bResult && (u16AlbumDiscNumber == roRef.u16AlbumDiscNumber);
   bResult = bResult && (u16AlbumDiscCount == roRef.u16AlbumDiscCount);
   bResult = bResult && (u16ChapterCount == roRef.u16ChapterCount);
   bResult = bResult && (u32QueueIndex == roRef.u32QueueIndex);
   bResult = bResult && (u32QueueCount == roRef.u32QueueCount);
   bResult = bResult && (u32QueueChapterIndex == roRef.u32QueueChapterIndex);
   bResult = bResult && (biTunesRadioAd == roRef.biTunesRadioAd);
   bResult = bResult && (siTunesRadioStationName == roRef.siTunesRadioStationName);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOPlaybackStatusUpReg::mplay_appcontrolfi_tclMsgDiPOPlaybackStatusUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOPlaybackStatusUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYBACKSTATUSUPREG;
}


mplay_appcontrolfi_tclMsgDiPOPlaybackStatusUpReg::~mplay_appcontrolfi_tclMsgDiPOPlaybackStatusUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOPlaybackStatusRelUpReg::mplay_appcontrolfi_tclMsgDiPOPlaybackStatusRelUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOPlaybackStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYBACKSTATUSRELUPREG;
}


mplay_appcontrolfi_tclMsgDiPOPlaybackStatusRelUpReg::~mplay_appcontrolfi_tclMsgDiPOPlaybackStatusRelUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOPlaybackStatusGet::mplay_appcontrolfi_tclMsgDiPOPlaybackStatusGet()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOPlaybackStatusGet::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYBACKSTATUSGET;
}


mplay_appcontrolfi_tclMsgDiPOPlaybackStatusGet::~mplay_appcontrolfi_tclMsgDiPOPlaybackStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOPlaybackStatusStatus::mplay_appcontrolfi_tclMsgDiPOPlaybackStatusStatus(const mplay_appcontrolfi_tclMsgDiPOPlaybackStatusStatus& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   u8DeviceId = coRef.u8DeviceId;
   e8State = coRef.e8State;
}
mplay_appcontrolfi_tclMsgDiPOPlaybackStatusStatus& mplay_appcontrolfi_tclMsgDiPOPlaybackStatusStatus::operator=(const mplay_appcontrolfi_tclMsgDiPOPlaybackStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceId = coRef.u8DeviceId;
   e8State = coRef.e8State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_appcontrolfi_tclMsgDiPOPlaybackStatusStatus::mplay_appcontrolfi_tclMsgDiPOPlaybackStatusStatus()
:u8DeviceId(0)
,e8State()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOPlaybackStatusStatus::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYBACKSTATUSSTATUS;
}


mplay_appcontrolfi_tclMsgDiPOPlaybackStatusStatus::~mplay_appcontrolfi_tclMsgDiPOPlaybackStatusStatus()
{}

tU32 mplay_appcontrolfi_tclMsgDiPOPlaybackStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOPlaybackStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceId);
   (tVoid) (oIn >> e8State);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOPlaybackStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceId);
   (tVoid) (oOut << e8State);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOPlaybackStatusStatus::operator==(const mplay_appcontrolfi_tclMsgDiPOPlaybackStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceId == roRef.u8DeviceId);
   bResult = bResult && (e8State == roRef.e8State);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeUpReg::mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYBACKSHUFFLEMODEUPREG;
}


mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeUpReg::~mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeRelUpReg::mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeRelUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYBACKSHUFFLEMODERELUPREG;
}


mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeRelUpReg::~mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeRelUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeGet::mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeGet()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeGet::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYBACKSHUFFLEMODEGET;
}


mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeGet::~mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeStatus::mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeStatus(const mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeStatus& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   u8DeviceId = coRef.u8DeviceId;
   e8Mode = coRef.e8Mode;
}
mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeStatus& mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeStatus::operator=(const mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeStatus& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceId = coRef.u8DeviceId;
   e8Mode = coRef.e8Mode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeStatus::mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeStatus()
:u8DeviceId(0)
,e8Mode()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeStatus::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYBACKSHUFFLEMODESTATUS;
}


mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeStatus::~mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeStatus()
{}

tU32 mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceId);
   (tVoid) (oIn >> e8Mode);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceId);
   (tVoid) (oOut << e8Mode);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeStatus::operator==(const mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceId == roRef.u8DeviceId);
   bResult = bResult && (e8Mode == roRef.e8Mode);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeUpReg::mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYBACKREPEATMODEUPREG;
}


mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeUpReg::~mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeRelUpReg::mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeRelUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYBACKREPEATMODERELUPREG;
}


mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeRelUpReg::~mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeRelUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeGet::mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeGet()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeGet::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYBACKREPEATMODEGET;
}


mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeGet::~mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeStatus::mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeStatus(const mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeStatus& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   u8DeviceId = coRef.u8DeviceId;
   e8Mode = coRef.e8Mode;
}
mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeStatus& mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeStatus::operator=(const mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeStatus& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceId = coRef.u8DeviceId;
   e8Mode = coRef.e8Mode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeStatus::mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeStatus()
:u8DeviceId(0)
,e8Mode()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeStatus::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOPLAYBACKREPEATMODESTATUS;
}


mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeStatus::~mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeStatus()
{}

tU32 mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceId);
   (tVoid) (oIn >> e8Mode);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceId);
   (tVoid) (oOut << e8Mode);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeStatus::operator==(const mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceId == roRef.u8DeviceId);
   bResult = bResult && (e8Mode == roRef.e8Mode);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOCallStateUpReg::mplay_appcontrolfi_tclMsgDiPOCallStateUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOCallStateUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOCALLSTATEUPREG;
}


mplay_appcontrolfi_tclMsgDiPOCallStateUpReg::~mplay_appcontrolfi_tclMsgDiPOCallStateUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOCallStateRelUpReg::mplay_appcontrolfi_tclMsgDiPOCallStateRelUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOCallStateRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOCALLSTATERELUPREG;
}


mplay_appcontrolfi_tclMsgDiPOCallStateRelUpReg::~mplay_appcontrolfi_tclMsgDiPOCallStateRelUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOCallStateGet::mplay_appcontrolfi_tclMsgDiPOCallStateGet()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOCallStateGet::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOCALLSTATEGET;
}


mplay_appcontrolfi_tclMsgDiPOCallStateGet::~mplay_appcontrolfi_tclMsgDiPOCallStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOCallStateStatus::mplay_appcontrolfi_tclMsgDiPOCallStateStatus(const mplay_appcontrolfi_tclMsgDiPOCallStateStatus& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   u8DeviceId = coRef.u8DeviceId;
   oCallStateUpdate = coRef.oCallStateUpdate;
}
mplay_appcontrolfi_tclMsgDiPOCallStateStatus& mplay_appcontrolfi_tclMsgDiPOCallStateStatus::operator=(const mplay_appcontrolfi_tclMsgDiPOCallStateStatus& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceId = coRef.u8DeviceId;
   oCallStateUpdate = coRef.oCallStateUpdate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPOCallStateStatus::vDestroy()
{
   oCallStateUpdate.vDestroy(); 
}

mplay_appcontrolfi_tclMsgDiPOCallStateStatus::mplay_appcontrolfi_tclMsgDiPOCallStateStatus()
:u8DeviceId(0)
,oCallStateUpdate()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOCallStateStatus::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOCALLSTATESTATUS;
}


mplay_appcontrolfi_tclMsgDiPOCallStateStatus::~mplay_appcontrolfi_tclMsgDiPOCallStateStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPOCallStateStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+oCallStateUpdate.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOCallStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceId);
   (tVoid) (oIn >> oCallStateUpdate);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOCallStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceId);
   (tVoid) (oOut << oCallStateUpdate);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOCallStateStatus::operator==(const mplay_appcontrolfi_tclMsgDiPOCallStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceId == roRef.u8DeviceId);
   bResult = bResult && (oCallStateUpdate == roRef.oCallStateUpdate);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOCommunicationsUpReg::mplay_appcontrolfi_tclMsgDiPOCommunicationsUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOCommunicationsUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOCOMMUNICATIONSUPREG;
}


mplay_appcontrolfi_tclMsgDiPOCommunicationsUpReg::~mplay_appcontrolfi_tclMsgDiPOCommunicationsUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOCommunicationsRelUpReg::mplay_appcontrolfi_tclMsgDiPOCommunicationsRelUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOCommunicationsRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOCOMMUNICATIONSRELUPREG;
}


mplay_appcontrolfi_tclMsgDiPOCommunicationsRelUpReg::~mplay_appcontrolfi_tclMsgDiPOCommunicationsRelUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOCommunicationsGet::mplay_appcontrolfi_tclMsgDiPOCommunicationsGet()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOCommunicationsGet::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOCOMMUNICATIONSGET;
}


mplay_appcontrolfi_tclMsgDiPOCommunicationsGet::~mplay_appcontrolfi_tclMsgDiPOCommunicationsGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOCommunicationsStatus::mplay_appcontrolfi_tclMsgDiPOCommunicationsStatus(const mplay_appcontrolfi_tclMsgDiPOCommunicationsStatus& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   u8DeviceId = coRef.u8DeviceId;
   eSignalStrength = coRef.eSignalStrength;
   eRegistrationStatus = coRef.eRegistrationStatus;
   bAirplaneModeStatus = coRef.bAirplaneModeStatus;
   sCarrierName = coRef.sCarrierName;
   bCellularSupported = coRef.bCellularSupported;
   bTelephonyEnabled = coRef.bTelephonyEnabled;
   bFaceTimeAudioEnabled = coRef.bFaceTimeAudioEnabled;
   bFaceTimeVideoEnabled = coRef.bFaceTimeVideoEnabled;
   bMuteStatus = coRef.bMuteStatus;
   u8CurrentCallCount = coRef.u8CurrentCallCount;
   u8NewVoicemailCount = coRef.u8NewVoicemailCount;
   bInitiateCallAvalable = coRef.bInitiateCallAvalable;
   bEndAndAcceptAvailable = coRef.bEndAndAcceptAvailable;
   bHoldAndAcceptAvailable = coRef.bHoldAndAcceptAvailable;
   bSwapAvailable = coRef.bSwapAvailable;
   bMergeAvailable = coRef.bMergeAvailable;
   bHoldAvailable = coRef.bHoldAvailable;
}
mplay_appcontrolfi_tclMsgDiPOCommunicationsStatus& mplay_appcontrolfi_tclMsgDiPOCommunicationsStatus::operator=(const mplay_appcontrolfi_tclMsgDiPOCommunicationsStatus& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceId = coRef.u8DeviceId;
   eSignalStrength = coRef.eSignalStrength;
   eRegistrationStatus = coRef.eRegistrationStatus;
   bAirplaneModeStatus = coRef.bAirplaneModeStatus;
   sCarrierName = coRef.sCarrierName;
   bCellularSupported = coRef.bCellularSupported;
   bTelephonyEnabled = coRef.bTelephonyEnabled;
   bFaceTimeAudioEnabled = coRef.bFaceTimeAudioEnabled;
   bFaceTimeVideoEnabled = coRef.bFaceTimeVideoEnabled;
   bMuteStatus = coRef.bMuteStatus;
   u8CurrentCallCount = coRef.u8CurrentCallCount;
   u8NewVoicemailCount = coRef.u8NewVoicemailCount;
   bInitiateCallAvalable = coRef.bInitiateCallAvalable;
   bEndAndAcceptAvailable = coRef.bEndAndAcceptAvailable;
   bHoldAndAcceptAvailable = coRef.bHoldAndAcceptAvailable;
   bSwapAvailable = coRef.bSwapAvailable;
   bMergeAvailable = coRef.bMergeAvailable;
   bHoldAvailable = coRef.bHoldAvailable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPOCommunicationsStatus::vDestroy()
{
   sCarrierName.vDestroy();
}

mplay_appcontrolfi_tclMsgDiPOCommunicationsStatus::mplay_appcontrolfi_tclMsgDiPOCommunicationsStatus()
:u8DeviceId(0)
,eSignalStrength()
,eRegistrationStatus()
,bAirplaneModeStatus(0)
,sCarrierName()
,bCellularSupported(0)
,bTelephonyEnabled(0)
,bFaceTimeAudioEnabled(0)
,bFaceTimeVideoEnabled(0)
,bMuteStatus(0)
,u8CurrentCallCount(0)
,u8NewVoicemailCount(0)
,bInitiateCallAvalable(0)
,bEndAndAcceptAvailable(0)
,bHoldAndAcceptAvailable(0)
,bSwapAvailable(0)
,bMergeAvailable(0)
,bHoldAvailable(0)
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOCommunicationsStatus::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOCOMMUNICATIONSSTATUS;
}


mplay_appcontrolfi_tclMsgDiPOCommunicationsStatus::~mplay_appcontrolfi_tclMsgDiPOCommunicationsStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPOCommunicationsStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 17+sCarrierName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOCommunicationsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceId);
   (tVoid) (oIn >> eSignalStrength);
   (tVoid) (oIn >> eRegistrationStatus);
   (tVoid) (oIn >> bAirplaneModeStatus);
   (tVoid) (oIn >> sCarrierName);
   (tVoid) (oIn >> bCellularSupported);
   (tVoid) (oIn >> bTelephonyEnabled);
   (tVoid) (oIn >> bFaceTimeAudioEnabled);
   (tVoid) (oIn >> bFaceTimeVideoEnabled);
   (tVoid) (oIn >> bMuteStatus);
   (tVoid) (oIn >> u8CurrentCallCount);
   (tVoid) (oIn >> u8NewVoicemailCount);
   (tVoid) (oIn >> bInitiateCallAvalable);
   (tVoid) (oIn >> bEndAndAcceptAvailable);
   (tVoid) (oIn >> bHoldAndAcceptAvailable);
   (tVoid) (oIn >> bSwapAvailable);
   (tVoid) (oIn >> bMergeAvailable);
   (tVoid) (oIn >> bHoldAvailable);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOCommunicationsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceId);
   (tVoid) (oOut << eSignalStrength);
   (tVoid) (oOut << eRegistrationStatus);
   (tVoid) (oOut << bAirplaneModeStatus);
   (tVoid) (oOut << sCarrierName);
   (tVoid) (oOut << bCellularSupported);
   (tVoid) (oOut << bTelephonyEnabled);
   (tVoid) (oOut << bFaceTimeAudioEnabled);
   (tVoid) (oOut << bFaceTimeVideoEnabled);
   (tVoid) (oOut << bMuteStatus);
   (tVoid) (oOut << u8CurrentCallCount);
   (tVoid) (oOut << u8NewVoicemailCount);
   (tVoid) (oOut << bInitiateCallAvalable);
   (tVoid) (oOut << bEndAndAcceptAvailable);
   (tVoid) (oOut << bHoldAndAcceptAvailable);
   (tVoid) (oOut << bSwapAvailable);
   (tVoid) (oOut << bMergeAvailable);
   (tVoid) (oOut << bHoldAvailable);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOCommunicationsStatus::operator==(const mplay_appcontrolfi_tclMsgDiPOCommunicationsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceId == roRef.u8DeviceId);
   bResult = bResult && (eSignalStrength == roRef.eSignalStrength);
   bResult = bResult && (eRegistrationStatus == roRef.eRegistrationStatus);
   bResult = bResult && (bAirplaneModeStatus == roRef.bAirplaneModeStatus);
   bResult = bResult && (sCarrierName == roRef.sCarrierName);
   bResult = bResult && (bCellularSupported == roRef.bCellularSupported);
   bResult = bResult && (bTelephonyEnabled == roRef.bTelephonyEnabled);
   bResult = bResult && (bFaceTimeAudioEnabled == roRef.bFaceTimeAudioEnabled);
   bResult = bResult && (bFaceTimeVideoEnabled == roRef.bFaceTimeVideoEnabled);
   bResult = bResult && (bMuteStatus == roRef.bMuteStatus);
   bResult = bResult && (u8CurrentCallCount == roRef.u8CurrentCallCount);
   bResult = bResult && (u8NewVoicemailCount == roRef.u8NewVoicemailCount);
   bResult = bResult && (bInitiateCallAvalable == roRef.bInitiateCallAvalable);
   bResult = bResult && (bEndAndAcceptAvailable == roRef.bEndAndAcceptAvailable);
   bResult = bResult && (bHoldAndAcceptAvailable == roRef.bHoldAndAcceptAvailable);
   bResult = bResult && (bSwapAvailable == roRef.bSwapAvailable);
   bResult = bResult && (bMergeAvailable == roRef.bMergeAvailable);
   bResult = bResult && (bHoldAvailable == roRef.bHoldAvailable);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOCommunicationErrorUpReg::mplay_appcontrolfi_tclMsgDiPOCommunicationErrorUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOCommunicationErrorUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOCOMMUNICATIONERRORUPREG;
}


mplay_appcontrolfi_tclMsgDiPOCommunicationErrorUpReg::~mplay_appcontrolfi_tclMsgDiPOCommunicationErrorUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOCommunicationErrorRelUpReg::mplay_appcontrolfi_tclMsgDiPOCommunicationErrorRelUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOCommunicationErrorRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOCOMMUNICATIONERRORRELUPREG;
}


mplay_appcontrolfi_tclMsgDiPOCommunicationErrorRelUpReg::~mplay_appcontrolfi_tclMsgDiPOCommunicationErrorRelUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOCommunicationErrorGet::mplay_appcontrolfi_tclMsgDiPOCommunicationErrorGet()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOCommunicationErrorGet::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOCOMMUNICATIONERRORGET;
}


mplay_appcontrolfi_tclMsgDiPOCommunicationErrorGet::~mplay_appcontrolfi_tclMsgDiPOCommunicationErrorGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOCommunicationErrorStatus::mplay_appcontrolfi_tclMsgDiPOCommunicationErrorStatus(const mplay_appcontrolfi_tclMsgDiPOCommunicationErrorStatus& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   u8DeviceTag = coRef.u8DeviceTag;
   e8DiPOCommunicationError = coRef.e8DiPOCommunicationError;
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
}
mplay_appcontrolfi_tclMsgDiPOCommunicationErrorStatus& mplay_appcontrolfi_tclMsgDiPOCommunicationErrorStatus::operator=(const mplay_appcontrolfi_tclMsgDiPOCommunicationErrorStatus& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceTag = coRef.u8DeviceTag;
   e8DiPOCommunicationError = coRef.e8DiPOCommunicationError;
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPOCommunicationErrorStatus::vDestroy()
{
   sDeviceUSBSerialNumber.vDestroy();
}

mplay_appcontrolfi_tclMsgDiPOCommunicationErrorStatus::mplay_appcontrolfi_tclMsgDiPOCommunicationErrorStatus()
:u8DeviceTag(0)
,e8DiPOCommunicationError()
,sDeviceUSBSerialNumber()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOCommunicationErrorStatus::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOCOMMUNICATIONERRORSTATUS;
}


mplay_appcontrolfi_tclMsgDiPOCommunicationErrorStatus::~mplay_appcontrolfi_tclMsgDiPOCommunicationErrorStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPOCommunicationErrorStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+sDeviceUSBSerialNumber.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOCommunicationErrorStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> e8DiPOCommunicationError);
   (tVoid) (oIn >> sDeviceUSBSerialNumber);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOCommunicationErrorStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << e8DiPOCommunicationError);
   (tVoid) (oOut << sDeviceUSBSerialNumber);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOCommunicationErrorStatus::operator==(const mplay_appcontrolfi_tclMsgDiPOCommunicationErrorStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (e8DiPOCommunicationError == roRef.e8DiPOCommunicationError);
   bResult = bResult && (sDeviceUSBSerialNumber == roRef.sDeviceUSBSerialNumber);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOCallDurationUpReg::mplay_appcontrolfi_tclMsgDiPOCallDurationUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOCallDurationUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOCALLDURATIONUPREG;
}


mplay_appcontrolfi_tclMsgDiPOCallDurationUpReg::~mplay_appcontrolfi_tclMsgDiPOCallDurationUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOCallDurationRelUpReg::mplay_appcontrolfi_tclMsgDiPOCallDurationRelUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOCallDurationRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOCALLDURATIONRELUPREG;
}


mplay_appcontrolfi_tclMsgDiPOCallDurationRelUpReg::~mplay_appcontrolfi_tclMsgDiPOCallDurationRelUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOCallDurationGet::mplay_appcontrolfi_tclMsgDiPOCallDurationGet()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOCallDurationGet::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOCALLDURATIONGET;
}


mplay_appcontrolfi_tclMsgDiPOCallDurationGet::~mplay_appcontrolfi_tclMsgDiPOCallDurationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOCallDurationStatus::mplay_appcontrolfi_tclMsgDiPOCallDurationStatus(const mplay_appcontrolfi_tclMsgDiPOCallDurationStatus& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   u8DeviceId = coRef.u8DeviceId;
   u32CallDuration = coRef.u32CallDuration;
}
mplay_appcontrolfi_tclMsgDiPOCallDurationStatus& mplay_appcontrolfi_tclMsgDiPOCallDurationStatus::operator=(const mplay_appcontrolfi_tclMsgDiPOCallDurationStatus& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceId = coRef.u8DeviceId;
   u32CallDuration = coRef.u32CallDuration;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_appcontrolfi_tclMsgDiPOCallDurationStatus::mplay_appcontrolfi_tclMsgDiPOCallDurationStatus()
:u8DeviceId(0)
,u32CallDuration(0)
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOCallDurationStatus::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOCALLDURATIONSTATUS;
}


mplay_appcontrolfi_tclMsgDiPOCallDurationStatus::~mplay_appcontrolfi_tclMsgDiPOCallDurationStatus()
{}

tU32 mplay_appcontrolfi_tclMsgDiPOCallDurationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOCallDurationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceId);
   (tVoid) (oIn >> u32CallDuration);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOCallDurationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceId);
   (tVoid) (oOut << u32CallDuration);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOCallDurationStatus::operator==(const mplay_appcontrolfi_tclMsgDiPOCallDurationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceId == roRef.u8DeviceId);
   bResult = bResult && (u32CallDuration == roRef.u32CallDuration);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOPowerUpReg::mplay_appcontrolfi_tclMsgDiPOPowerUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOPowerUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOPOWERUPREG;
}


mplay_appcontrolfi_tclMsgDiPOPowerUpReg::~mplay_appcontrolfi_tclMsgDiPOPowerUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOPowerRelUpReg::mplay_appcontrolfi_tclMsgDiPOPowerRelUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOPowerRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOPOWERRELUPREG;
}


mplay_appcontrolfi_tclMsgDiPOPowerRelUpReg::~mplay_appcontrolfi_tclMsgDiPOPowerRelUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOPowerGet::mplay_appcontrolfi_tclMsgDiPOPowerGet()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOPowerGet::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOPOWERGET;
}


mplay_appcontrolfi_tclMsgDiPOPowerGet::~mplay_appcontrolfi_tclMsgDiPOPowerGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOPowerStatus::mplay_appcontrolfi_tclMsgDiPOPowerStatus(const mplay_appcontrolfi_tclMsgDiPOPowerStatus& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   u8DeviceId = coRef.u8DeviceId;
   u16BatteryChargeLevel = coRef.u16BatteryChargeLevel;
   e8AccessoryPowerMode = coRef.e8AccessoryPowerMode;
   u16MaximumCurrentDrawnFromAccessory = coRef.u16MaximumCurrentDrawnFromAccessory;
   bDeviceBatteryWillChargeIfPowerIsPresent = coRef.bDeviceBatteryWillChargeIfPowerIsPresent;
   e8BatteryChargingState = coRef.e8BatteryChargingState;
   bIsExternalChargerConnected = coRef.bIsExternalChargerConnected;
}
mplay_appcontrolfi_tclMsgDiPOPowerStatus& mplay_appcontrolfi_tclMsgDiPOPowerStatus::operator=(const mplay_appcontrolfi_tclMsgDiPOPowerStatus& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceId = coRef.u8DeviceId;
   u16BatteryChargeLevel = coRef.u16BatteryChargeLevel;
   e8AccessoryPowerMode = coRef.e8AccessoryPowerMode;
   u16MaximumCurrentDrawnFromAccessory = coRef.u16MaximumCurrentDrawnFromAccessory;
   bDeviceBatteryWillChargeIfPowerIsPresent = coRef.bDeviceBatteryWillChargeIfPowerIsPresent;
   e8BatteryChargingState = coRef.e8BatteryChargingState;
   bIsExternalChargerConnected = coRef.bIsExternalChargerConnected;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_appcontrolfi_tclMsgDiPOPowerStatus::mplay_appcontrolfi_tclMsgDiPOPowerStatus()
:u8DeviceId(0)
,u16BatteryChargeLevel(0)
,e8AccessoryPowerMode()
,u16MaximumCurrentDrawnFromAccessory(0)
,bDeviceBatteryWillChargeIfPowerIsPresent(0)
,e8BatteryChargingState()
,bIsExternalChargerConnected(0)
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOPowerStatus::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOPOWERSTATUS;
}


mplay_appcontrolfi_tclMsgDiPOPowerStatus::~mplay_appcontrolfi_tclMsgDiPOPowerStatus()
{}

tU32 mplay_appcontrolfi_tclMsgDiPOPowerStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOPowerStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceId);
   (tVoid) (oIn >> u16BatteryChargeLevel);
   (tVoid) (oIn >> e8AccessoryPowerMode);
   (tVoid) (oIn >> u16MaximumCurrentDrawnFromAccessory);
   (tVoid) (oIn >> bDeviceBatteryWillChargeIfPowerIsPresent);
   (tVoid) (oIn >> e8BatteryChargingState);
   (tVoid) (oIn >> bIsExternalChargerConnected);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOPowerStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceId);
   (tVoid) (oOut << u16BatteryChargeLevel);
   (tVoid) (oOut << e8AccessoryPowerMode);
   (tVoid) (oOut << u16MaximumCurrentDrawnFromAccessory);
   (tVoid) (oOut << bDeviceBatteryWillChargeIfPowerIsPresent);
   (tVoid) (oOut << e8BatteryChargingState);
   (tVoid) (oOut << bIsExternalChargerConnected);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOPowerStatus::operator==(const mplay_appcontrolfi_tclMsgDiPOPowerStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceId == roRef.u8DeviceId);
   bResult = bResult && (u16BatteryChargeLevel == roRef.u16BatteryChargeLevel);
   bResult = bResult && (e8AccessoryPowerMode == roRef.e8AccessoryPowerMode);
   bResult = bResult && (u16MaximumCurrentDrawnFromAccessory == roRef.u16MaximumCurrentDrawnFromAccessory);
   bResult = bResult && (bDeviceBatteryWillChargeIfPowerIsPresent == roRef.bDeviceBatteryWillChargeIfPowerIsPresent);
   bResult = bResult && (e8BatteryChargingState == roRef.e8BatteryChargingState);
   bResult = bResult && (bIsExternalChargerConnected == roRef.bIsExternalChargerConnected);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPORouteGuidanceUpReg::mplay_appcontrolfi_tclMsgDiPORouteGuidanceUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPORouteGuidanceUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCEUPREG;
}


mplay_appcontrolfi_tclMsgDiPORouteGuidanceUpReg::~mplay_appcontrolfi_tclMsgDiPORouteGuidanceUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPORouteGuidanceRelUpReg::mplay_appcontrolfi_tclMsgDiPORouteGuidanceRelUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPORouteGuidanceRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCERELUPREG;
}


mplay_appcontrolfi_tclMsgDiPORouteGuidanceRelUpReg::~mplay_appcontrolfi_tclMsgDiPORouteGuidanceRelUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPORouteGuidanceGet::mplay_appcontrolfi_tclMsgDiPORouteGuidanceGet()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPORouteGuidanceGet::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCEGET;
}


mplay_appcontrolfi_tclMsgDiPORouteGuidanceGet::~mplay_appcontrolfi_tclMsgDiPORouteGuidanceGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPORouteGuidanceStatus::mplay_appcontrolfi_tclMsgDiPORouteGuidanceStatus(const mplay_appcontrolfi_tclMsgDiPORouteGuidanceStatus& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
   u16RouteGuidanceDisplayComponentID = coRef.u16RouteGuidanceDisplayComponentID;
   e8RouteGuidanceState = coRef.e8RouteGuidanceState;
   e8ManeuverState = coRef.e8ManeuverState;
   szCurrentRoadName = coRef.szCurrentRoadName;
   szDestinationName = coRef.szDestinationName;
   u64EstimatedTimeOfArrival = coRef.u64EstimatedTimeOfArrival;
   u64TimeRemainingToDestination = coRef.u64TimeRemainingToDestination;
   u32DistanceRemaining = coRef.u32DistanceRemaining;
   szDistanceRemainingDisplayStr = coRef.szDistanceRemainingDisplayStr;
   e8DistanceRemainingDisplayUnits = coRef.e8DistanceRemainingDisplayUnits;
   u32DistanceToNextManeuver = coRef.u32DistanceToNextManeuver;
   szDistanceToNextManeuverDisplayStr = coRef.szDistanceToNextManeuverDisplayStr;
   e8DistanceToNextManeuverDisplayUnits = coRef.e8DistanceToNextManeuverDisplayUnits;
   u16RouteGuidanceManeuverCurrentList = coRef.u16RouteGuidanceManeuverCurrentList;
   u16RouteGuidanceManeuverCount = coRef.u16RouteGuidanceManeuverCount;
   bIsRouteGuidanceVisibleInApp = coRef.bIsRouteGuidanceVisibleInApp;
   SourceName = coRef.SourceName;
   SourceSupportsRouteGuidance = coRef.SourceSupportsRouteGuidance;
}
mplay_appcontrolfi_tclMsgDiPORouteGuidanceStatus& mplay_appcontrolfi_tclMsgDiPORouteGuidanceStatus::operator=(const mplay_appcontrolfi_tclMsgDiPORouteGuidanceStatus& coRef)
{
   if (this == &coRef) return *this;
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
   u16RouteGuidanceDisplayComponentID = coRef.u16RouteGuidanceDisplayComponentID;
   e8RouteGuidanceState = coRef.e8RouteGuidanceState;
   e8ManeuverState = coRef.e8ManeuverState;
   szCurrentRoadName = coRef.szCurrentRoadName;
   szDestinationName = coRef.szDestinationName;
   u64EstimatedTimeOfArrival = coRef.u64EstimatedTimeOfArrival;
   u64TimeRemainingToDestination = coRef.u64TimeRemainingToDestination;
   u32DistanceRemaining = coRef.u32DistanceRemaining;
   szDistanceRemainingDisplayStr = coRef.szDistanceRemainingDisplayStr;
   e8DistanceRemainingDisplayUnits = coRef.e8DistanceRemainingDisplayUnits;
   u32DistanceToNextManeuver = coRef.u32DistanceToNextManeuver;
   szDistanceToNextManeuverDisplayStr = coRef.szDistanceToNextManeuverDisplayStr;
   e8DistanceToNextManeuverDisplayUnits = coRef.e8DistanceToNextManeuverDisplayUnits;
   u16RouteGuidanceManeuverCurrentList = coRef.u16RouteGuidanceManeuverCurrentList;
   u16RouteGuidanceManeuverCount = coRef.u16RouteGuidanceManeuverCount;
   bIsRouteGuidanceVisibleInApp = coRef.bIsRouteGuidanceVisibleInApp;
   SourceName = coRef.SourceName;
   SourceSupportsRouteGuidance = coRef.SourceSupportsRouteGuidance;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPORouteGuidanceStatus::vDestroy()
{
   sDeviceUSBSerialNumber.vDestroy();
   szCurrentRoadName.vDestroy();
   szDestinationName.vDestroy();
   szDistanceRemainingDisplayStr.vDestroy();
   szDistanceToNextManeuverDisplayStr.vDestroy();
   u16RouteGuidanceManeuverCurrentList.vDestroy(); 
   SourceName.vDestroy();
}

mplay_appcontrolfi_tclMsgDiPORouteGuidanceStatus::mplay_appcontrolfi_tclMsgDiPORouteGuidanceStatus()
:sDeviceUSBSerialNumber()
,u16RouteGuidanceDisplayComponentID(0)
,e8RouteGuidanceState()
,e8ManeuverState()
,szCurrentRoadName()
,szDestinationName()
,u64EstimatedTimeOfArrival(0)
,u64TimeRemainingToDestination(0)
,u32DistanceRemaining(0)
,szDistanceRemainingDisplayStr()
,e8DistanceRemainingDisplayUnits()
,u32DistanceToNextManeuver(0)
,szDistanceToNextManeuverDisplayStr()
,e8DistanceToNextManeuverDisplayUnits()
,u16RouteGuidanceManeuverCurrentList()
,u16RouteGuidanceManeuverCount(0)
,bIsRouteGuidanceVisibleInApp(0)
,SourceName()
,SourceSupportsRouteGuidance(0)
 {}

tS32 mplay_appcontrolfi_tclMsgDiPORouteGuidanceStatus::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCESTATUS;
}


mplay_appcontrolfi_tclMsgDiPORouteGuidanceStatus::~mplay_appcontrolfi_tclMsgDiPORouteGuidanceStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPORouteGuidanceStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 34+sDeviceUSBSerialNumber.u32GetSize(u16MajorVersion)+szCurrentRoadName.u32GetSize(u16MajorVersion)+szDestinationName.u32GetSize(u16MajorVersion)+szDistanceRemainingDisplayStr.u32GetSize(u16MajorVersion)+szDistanceToNextManeuverDisplayStr.u32GetSize(u16MajorVersion)+u16RouteGuidanceManeuverCurrentList.u32GetSize(u16MajorVersion)+SourceName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPORouteGuidanceStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sDeviceUSBSerialNumber);
   (tVoid) (oIn >> u16RouteGuidanceDisplayComponentID);
   (tVoid) (oIn >> e8RouteGuidanceState);
   (tVoid) (oIn >> e8ManeuverState);
   (tVoid) (oIn >> szCurrentRoadName);
   (tVoid) (oIn >> szDestinationName);
   (tVoid) (oIn >> u64EstimatedTimeOfArrival);
   (tVoid) (oIn >> u64TimeRemainingToDestination);
   (tVoid) (oIn >> u32DistanceRemaining);
   (tVoid) (oIn >> szDistanceRemainingDisplayStr);
   (tVoid) (oIn >> e8DistanceRemainingDisplayUnits);
   (tVoid) (oIn >> u32DistanceToNextManeuver);
   (tVoid) (oIn >> szDistanceToNextManeuverDisplayStr);
   (tVoid) (oIn >> e8DistanceToNextManeuverDisplayUnits);
   (tVoid) (oIn >> u16RouteGuidanceManeuverCurrentList);
   (tVoid) (oIn >> u16RouteGuidanceManeuverCount);
   (tVoid) (oIn >> bIsRouteGuidanceVisibleInApp);
   (tVoid) (oIn >> SourceName);
   (tVoid) (oIn >> SourceSupportsRouteGuidance);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPORouteGuidanceStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sDeviceUSBSerialNumber);
   (tVoid) (oOut << u16RouteGuidanceDisplayComponentID);
   (tVoid) (oOut << e8RouteGuidanceState);
   (tVoid) (oOut << e8ManeuverState);
   (tVoid) (oOut << szCurrentRoadName);
   (tVoid) (oOut << szDestinationName);
   (tVoid) (oOut << u64EstimatedTimeOfArrival);
   (tVoid) (oOut << u64TimeRemainingToDestination);
   (tVoid) (oOut << u32DistanceRemaining);
   (tVoid) (oOut << szDistanceRemainingDisplayStr);
   (tVoid) (oOut << e8DistanceRemainingDisplayUnits);
   (tVoid) (oOut << u32DistanceToNextManeuver);
   (tVoid) (oOut << szDistanceToNextManeuverDisplayStr);
   (tVoid) (oOut << e8DistanceToNextManeuverDisplayUnits);
   (tVoid) (oOut << u16RouteGuidanceManeuverCurrentList);
   (tVoid) (oOut << u16RouteGuidanceManeuverCount);
   (tVoid) (oOut << bIsRouteGuidanceVisibleInApp);
   (tVoid) (oOut << SourceName);
   (tVoid) (oOut << SourceSupportsRouteGuidance);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPORouteGuidanceStatus::operator==(const mplay_appcontrolfi_tclMsgDiPORouteGuidanceStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sDeviceUSBSerialNumber == roRef.sDeviceUSBSerialNumber);
   bResult = bResult && (u16RouteGuidanceDisplayComponentID == roRef.u16RouteGuidanceDisplayComponentID);
   bResult = bResult && (e8RouteGuidanceState == roRef.e8RouteGuidanceState);
   bResult = bResult && (e8ManeuverState == roRef.e8ManeuverState);
   bResult = bResult && (szCurrentRoadName == roRef.szCurrentRoadName);
   bResult = bResult && (szDestinationName == roRef.szDestinationName);
   bResult = bResult && (u64EstimatedTimeOfArrival == roRef.u64EstimatedTimeOfArrival);
   bResult = bResult && (u64TimeRemainingToDestination == roRef.u64TimeRemainingToDestination);
   bResult = bResult && (u32DistanceRemaining == roRef.u32DistanceRemaining);
   bResult = bResult && (szDistanceRemainingDisplayStr == roRef.szDistanceRemainingDisplayStr);
   bResult = bResult && (e8DistanceRemainingDisplayUnits == roRef.e8DistanceRemainingDisplayUnits);
   bResult = bResult && (u32DistanceToNextManeuver == roRef.u32DistanceToNextManeuver);
   bResult = bResult && (szDistanceToNextManeuverDisplayStr == roRef.szDistanceToNextManeuverDisplayStr);
   bResult = bResult && (e8DistanceToNextManeuverDisplayUnits == roRef.e8DistanceToNextManeuverDisplayUnits);
   bResult = bResult && (u16RouteGuidanceManeuverCurrentList == roRef.u16RouteGuidanceManeuverCurrentList);
   bResult = bResult && (u16RouteGuidanceManeuverCount == roRef.u16RouteGuidanceManeuverCount);
   bResult = bResult && (bIsRouteGuidanceVisibleInApp == roRef.bIsRouteGuidanceVisibleInApp);
   bResult = bResult && (SourceName == roRef.SourceName);
   bResult = bResult && (SourceSupportsRouteGuidance == roRef.SourceSupportsRouteGuidance);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverUpReg::mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCEMANEUVERUPREG;
}


mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverUpReg::~mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverRelUpReg::mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverRelUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCEMANEUVERRELUPREG;
}


mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverRelUpReg::~mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverRelUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverGet::mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverGet()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverGet::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCEMANEUVERGET;
}


mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverGet::~mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverStatus::mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverStatus(const mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverStatus& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
   u16RouteGuidanceDisplayComponentID = coRef.u16RouteGuidanceDisplayComponentID;
   u16Index = coRef.u16Index;
   szManeuverDescription = coRef.szManeuverDescription;
   e8ManeuverType = coRef.e8ManeuverType;
   szAfterManeuverRoadName = coRef.szAfterManeuverRoadName;
   u32DistanceBetweenManeuver = coRef.u32DistanceBetweenManeuver;
   szDistanceBetweenManeuverDisplayStr = coRef.szDistanceBetweenManeuverDisplayStr;
   e8DistanceBetweenManeuverDisplayUnits = coRef.e8DistanceBetweenManeuverDisplayUnits;
   e8DrivingSide = coRef.e8DrivingSide;
   e8JunctionType = coRef.e8JunctionType;
   s16JunctionElementAngle = coRef.s16JunctionElementAngle;
   s16JunctionElementExitAngle = coRef.s16JunctionElementExitAngle;
}
mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverStatus& mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverStatus::operator=(const mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverStatus& coRef)
{
   if (this == &coRef) return *this;
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
   u16RouteGuidanceDisplayComponentID = coRef.u16RouteGuidanceDisplayComponentID;
   u16Index = coRef.u16Index;
   szManeuverDescription = coRef.szManeuverDescription;
   e8ManeuverType = coRef.e8ManeuverType;
   szAfterManeuverRoadName = coRef.szAfterManeuverRoadName;
   u32DistanceBetweenManeuver = coRef.u32DistanceBetweenManeuver;
   szDistanceBetweenManeuverDisplayStr = coRef.szDistanceBetweenManeuverDisplayStr;
   e8DistanceBetweenManeuverDisplayUnits = coRef.e8DistanceBetweenManeuverDisplayUnits;
   e8DrivingSide = coRef.e8DrivingSide;
   e8JunctionType = coRef.e8JunctionType;
   s16JunctionElementAngle = coRef.s16JunctionElementAngle;
   s16JunctionElementExitAngle = coRef.s16JunctionElementExitAngle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverStatus::vDestroy()
{
   sDeviceUSBSerialNumber.vDestroy();
   szManeuverDescription.vDestroy();
   szAfterManeuverRoadName.vDestroy();
   szDistanceBetweenManeuverDisplayStr.vDestroy();
}

mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverStatus::mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverStatus()
:sDeviceUSBSerialNumber()
,u16RouteGuidanceDisplayComponentID(0)
,u16Index(0)
,szManeuverDescription()
,e8ManeuverType()
,szAfterManeuverRoadName()
,u32DistanceBetweenManeuver(0)
,szDistanceBetweenManeuverDisplayStr()
,e8DistanceBetweenManeuverDisplayUnits()
,e8DrivingSide()
,e8JunctionType()
,s16JunctionElementAngle(0)
,s16JunctionElementExitAngle(0)
 {}

tS32 mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverStatus::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCEMANEUVERSTATUS;
}


mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverStatus::~mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 16+sDeviceUSBSerialNumber.u32GetSize(u16MajorVersion)+szManeuverDescription.u32GetSize(u16MajorVersion)+szAfterManeuverRoadName.u32GetSize(u16MajorVersion)+szDistanceBetweenManeuverDisplayStr.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sDeviceUSBSerialNumber);
   (tVoid) (oIn >> u16RouteGuidanceDisplayComponentID);
   (tVoid) (oIn >> u16Index);
   (tVoid) (oIn >> szManeuverDescription);
   (tVoid) (oIn >> e8ManeuverType);
   (tVoid) (oIn >> szAfterManeuverRoadName);
   (tVoid) (oIn >> u32DistanceBetweenManeuver);
   (tVoid) (oIn >> szDistanceBetweenManeuverDisplayStr);
   (tVoid) (oIn >> e8DistanceBetweenManeuverDisplayUnits);
   (tVoid) (oIn >> e8DrivingSide);
   (tVoid) (oIn >> e8JunctionType);
   (tVoid) (oIn >> s16JunctionElementAngle);
   (tVoid) (oIn >> s16JunctionElementExitAngle);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sDeviceUSBSerialNumber);
   (tVoid) (oOut << u16RouteGuidanceDisplayComponentID);
   (tVoid) (oOut << u16Index);
   (tVoid) (oOut << szManeuverDescription);
   (tVoid) (oOut << e8ManeuverType);
   (tVoid) (oOut << szAfterManeuverRoadName);
   (tVoid) (oOut << u32DistanceBetweenManeuver);
   (tVoid) (oOut << szDistanceBetweenManeuverDisplayStr);
   (tVoid) (oOut << e8DistanceBetweenManeuverDisplayUnits);
   (tVoid) (oOut << e8DrivingSide);
   (tVoid) (oOut << e8JunctionType);
   (tVoid) (oOut << s16JunctionElementAngle);
   (tVoid) (oOut << s16JunctionElementExitAngle);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverStatus::operator==(const mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sDeviceUSBSerialNumber == roRef.sDeviceUSBSerialNumber);
   bResult = bResult && (u16RouteGuidanceDisplayComponentID == roRef.u16RouteGuidanceDisplayComponentID);
   bResult = bResult && (u16Index == roRef.u16Index);
   bResult = bResult && (szManeuverDescription == roRef.szManeuverDescription);
   bResult = bResult && (e8ManeuverType == roRef.e8ManeuverType);
   bResult = bResult && (szAfterManeuverRoadName == roRef.szAfterManeuverRoadName);
   bResult = bResult && (u32DistanceBetweenManeuver == roRef.u32DistanceBetweenManeuver);
   bResult = bResult && (szDistanceBetweenManeuverDisplayStr == roRef.szDistanceBetweenManeuverDisplayStr);
   bResult = bResult && (e8DistanceBetweenManeuverDisplayUnits == roRef.e8DistanceBetweenManeuverDisplayUnits);
   bResult = bResult && (e8DrivingSide == roRef.e8DrivingSide);
   bResult = bResult && (e8JunctionType == roRef.e8JunctionType);
   bResult = bResult && (s16JunctionElementAngle == roRef.s16JunctionElementAngle);
   bResult = bResult && (s16JunctionElementExitAngle == roRef.s16JunctionElementExitAngle);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesUpReg::mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOGPRMCDATASTATUSVALUESUPREG;
}


mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesUpReg::~mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesRelUpReg::mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesRelUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOGPRMCDATASTATUSVALUESRELUPREG;
}


mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesRelUpReg::~mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesRelUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesGet::mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesGet()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesGet::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOGPRMCDATASTATUSVALUESGET;
}


mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesGet::~mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesStatus::mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesStatus(const mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesStatus& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   u8DeviceId = coRef.u8DeviceId;
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
   b8GPRMCDataStatusValues = coRef.b8GPRMCDataStatusValues;
}
mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesStatus& mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesStatus::operator=(const mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesStatus& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceId = coRef.u8DeviceId;
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
   b8GPRMCDataStatusValues = coRef.b8GPRMCDataStatusValues;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesStatus::vDestroy()
{
   sDeviceUSBSerialNumber.vDestroy();
}

mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesStatus::mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesStatus()
:u8DeviceId(0)
,sDeviceUSBSerialNumber()
,b8GPRMCDataStatusValues()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesStatus::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOGPRMCDATASTATUSVALUESSTATUS;
}


mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesStatus::~mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+sDeviceUSBSerialNumber.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceId);
   (tVoid) (oIn >> sDeviceUSBSerialNumber);
   (tVoid) (oIn >> b8GPRMCDataStatusValues);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceId);
   (tVoid) (oOut << sDeviceUSBSerialNumber);
   (tVoid) (oOut << b8GPRMCDataStatusValues);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesStatus::operator==(const mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceId == roRef.u8DeviceId);
   bResult = bResult && (sDeviceUSBSerialNumber == roRef.sDeviceUSBSerialNumber);
   bResult = bResult && (b8GPRMCDataStatusValues == roRef.b8GPRMCDataStatusValues);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPORouteGuidance2UpReg::mplay_appcontrolfi_tclMsgDiPORouteGuidance2UpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPORouteGuidance2UpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCE2UPREG;
}


mplay_appcontrolfi_tclMsgDiPORouteGuidance2UpReg::~mplay_appcontrolfi_tclMsgDiPORouteGuidance2UpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPORouteGuidance2RelUpReg::mplay_appcontrolfi_tclMsgDiPORouteGuidance2RelUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPORouteGuidance2RelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCE2RELUPREG;
}


mplay_appcontrolfi_tclMsgDiPORouteGuidance2RelUpReg::~mplay_appcontrolfi_tclMsgDiPORouteGuidance2RelUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPORouteGuidance2Get::mplay_appcontrolfi_tclMsgDiPORouteGuidance2Get()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPORouteGuidance2Get::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCE2GET;
}


mplay_appcontrolfi_tclMsgDiPORouteGuidance2Get::~mplay_appcontrolfi_tclMsgDiPORouteGuidance2Get()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPORouteGuidance2Status::mplay_appcontrolfi_tclMsgDiPORouteGuidance2Status(const mplay_appcontrolfi_tclMsgDiPORouteGuidance2Status& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
   RouteGuidanceUpdate = coRef.RouteGuidanceUpdate;
}
mplay_appcontrolfi_tclMsgDiPORouteGuidance2Status& mplay_appcontrolfi_tclMsgDiPORouteGuidance2Status::operator=(const mplay_appcontrolfi_tclMsgDiPORouteGuidance2Status& coRef)
{
   if (this == &coRef) return *this;
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
   RouteGuidanceUpdate = coRef.RouteGuidanceUpdate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPORouteGuidance2Status::vDestroy()
{
   sDeviceUSBSerialNumber.vDestroy();
   RouteGuidanceUpdate.vDestroy(); 
}

mplay_appcontrolfi_tclMsgDiPORouteGuidance2Status::mplay_appcontrolfi_tclMsgDiPORouteGuidance2Status()
:sDeviceUSBSerialNumber()
,RouteGuidanceUpdate()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPORouteGuidance2Status::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCE2STATUS;
}


mplay_appcontrolfi_tclMsgDiPORouteGuidance2Status::~mplay_appcontrolfi_tclMsgDiPORouteGuidance2Status()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPORouteGuidance2Status::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+sDeviceUSBSerialNumber.u32GetSize(u16MajorVersion)+RouteGuidanceUpdate.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPORouteGuidance2Status::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sDeviceUSBSerialNumber);
   (tVoid) (oIn >> RouteGuidanceUpdate);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPORouteGuidance2Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sDeviceUSBSerialNumber);
   (tVoid) (oOut << RouteGuidanceUpdate);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPORouteGuidance2Status::operator==(const mplay_appcontrolfi_tclMsgDiPORouteGuidance2Status& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sDeviceUSBSerialNumber == roRef.sDeviceUSBSerialNumber);
   bResult = bResult && (RouteGuidanceUpdate == roRef.RouteGuidanceUpdate);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2UpReg::mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2UpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2UpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCEMANEUVER2UPREG;
}


mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2UpReg::~mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2UpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2RelUpReg::mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2RelUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2RelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCEMANEUVER2RELUPREG;
}


mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2RelUpReg::~mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2RelUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Get::mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Get()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Get::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCEMANEUVER2GET;
}


mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Get::~mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Get()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Status::mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Status(const mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Status& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
   RouteGuidanceManeuverUpdate = coRef.RouteGuidanceManeuverUpdate;
}
mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Status& mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Status::operator=(const mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Status& coRef)
{
   if (this == &coRef) return *this;
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
   RouteGuidanceManeuverUpdate = coRef.RouteGuidanceManeuverUpdate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Status::vDestroy()
{
   sDeviceUSBSerialNumber.vDestroy();
   RouteGuidanceManeuverUpdate.vDestroy(); 
}

mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Status::mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Status()
:sDeviceUSBSerialNumber()
,RouteGuidanceManeuverUpdate()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Status::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOROUTEGUIDANCEMANEUVER2STATUS;
}


mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Status::~mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Status()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Status::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+sDeviceUSBSerialNumber.u32GetSize(u16MajorVersion)+RouteGuidanceManeuverUpdate.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Status::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sDeviceUSBSerialNumber);
   (tVoid) (oIn >> RouteGuidanceManeuverUpdate);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sDeviceUSBSerialNumber);
   (tVoid) (oOut << RouteGuidanceManeuverUpdate);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Status::operator==(const mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Status& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sDeviceUSBSerialNumber == roRef.sDeviceUSBSerialNumber);
   bResult = bResult && (RouteGuidanceManeuverUpdate == roRef.RouteGuidanceManeuverUpdate);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusUpReg::mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOBLUETOOTHAUDIODEVICESTATUSUPREG;
}


mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusUpReg::~mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusRelUpReg::mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusRelUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOBLUETOOTHAUDIODEVICESTATUSRELUPREG;
}


mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusRelUpReg::~mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusRelUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusGet::mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusGet()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusGet::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOBLUETOOTHAUDIODEVICESTATUSGET;
}


mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusGet::~mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusStatus::mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusStatus(const mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusStatus& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   bAudioDeviceStatus = coRef.bAudioDeviceStatus;
}
mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusStatus& mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusStatus::operator=(const mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   bAudioDeviceStatus = coRef.bAudioDeviceStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusStatus::mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusStatus()
:bAudioDeviceStatus(0)
 {}

tS32 mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusStatus::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPOBLUETOOTHAUDIODEVICESTATUSSTATUS;
}


mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusStatus::~mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusStatus()
{}

tU32 mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bAudioDeviceStatus);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bAudioDeviceStatus);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusStatus::operator==(const mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bAudioDeviceStatus == roRef.bAudioDeviceStatus);
   return bResult;
}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateUpReg::mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPODEVICETIMEUPDATEUPREG;
}


mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateUpReg::~mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateRelUpReg::mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateRelUpReg()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPODEVICETIMEUPDATERELUPREG;
}


mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateRelUpReg::~mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateRelUpReg()
{}

//=============================================================================

mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateGet::mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateGet()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateGet::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPODEVICETIMEUPDATEGET;
}


mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateGet::~mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateStatus::mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateStatus(const mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateStatus& coRef)
   : mplay_appcontrolfi_tclMsgBaseMessage(coRef)
{
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
   DeviceTimeUpdate = coRef.DeviceTimeUpdate;
}
mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateStatus& mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateStatus::operator=(const mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateStatus& coRef)
{
   if (this == &coRef) return *this;
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
   DeviceTimeUpdate = coRef.DeviceTimeUpdate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateStatus::vDestroy()
{
   sDeviceUSBSerialNumber.vDestroy();
   DeviceTimeUpdate.vDestroy(); 
}

mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateStatus::mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateStatus()
:sDeviceUSBSerialNumber()
,DeviceTimeUpdate()
 {}

tS32 mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateStatus::s32GetTypeId() const
{
   return (tS32) mplay_appcontrolfi_tclToken::EN_MSG_DIPODEVICETIMEUPDATESTATUS;
}


mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateStatus::~mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 11+sDeviceUSBSerialNumber.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sDeviceUSBSerialNumber);
   (tVoid) (oIn >> DeviceTimeUpdate);
   return oIn;
}

fi_tclOutContext& mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sDeviceUSBSerialNumber);
   (tVoid) (oOut << DeviceTimeUpdate);
   return oOut;
}

tBool mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateStatus::operator==(const mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sDeviceUSBSerialNumber == roRef.sDeviceUSBSerialNumber);
   bResult = bResult && (DeviceTimeUpdate == roRef.DeviceTimeUpdate);
   return bResult;
}

