#ifndef MPLAY_APPCONTROLFILANGUAGE_HEADER
#define MPLAY_APPCONTROLFILANGUAGE_HEADER

class mplay_appcontrolfi_tclInContext;
class mplay_appcontrolfi_tclOutContext;
class mplay_appcontrolfi_tclVisitorBase;

class MY_DECL mplay_appcontrolfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  mplay_appcontrolfi_tclDescription(fi_tclInContext* poIn, mplay_appcontrolfi_tclVisitorBase* poVisit);
  mplay_appcontrolfi_tclDescription(fi_tclOutContext* poOut, mplay_appcontrolfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(mplay_appcontrolfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(mplay_fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ mplay_appcontrolfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  mplay_appcontrolfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<mplay_appcontrolfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<mplay_appcontrolfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline mplay_appcontrolfi_tclDescription::mplay_appcontrolfi_tclDescription(fi_tclInContext* poIn, mplay_appcontrolfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline mplay_appcontrolfi_tclDescription::mplay_appcontrolfi_tclDescription(fi_tclOutContext* poOut, mplay_appcontrolfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

