#ifndef MOST_ALLTYPEFACTORY_HEADER
#define MOST_ALLTYPEFACTORY_HEADER

/**************************************************************************
 * FUNCTION:        figroup_fi_poGetFIObject
 * DESCRIPTION:   Returns an empty FI object of given service, function id and opcode
 * PARAMETER:     
 *    tU16 u16ServiceID
 *       ID of demanded service
 *    tU16 u16FunctionID
 *       ID of demanded function (method or property)
 *    tU8 u8OpCode
 *       demanded opcode (MethodStart, Get, ....)
 * RETURNVALUE:   Pointer to empty FI object of kind figroup_fi_tclMsg<Service><Function><Opcode>.
 * HISTORY:
 * 27.08.2004 CM-DI/ESN1-Bruns
 *            Initial Revision.
 **************************************************************************/

fi_tclTypeBase *most_fi_poGetFIObject(tU16 u16ServiceID, tU16 u16FunctionID, tU8 u8OpCode);
fi_tclMessageBase *most_fi_poGetMessageBaseObject(tU16 u16ServiceID, tU16 u16FunctionID, tU8 u8OpCode);

#endif

